---
aliases:
  - ../../../enterprise/access-control/fine-grained-access-control-references/
  - ../../../enterprise/access-control/rbac-fixed-basic-role-definitions/
description: This topic includes a table that lists permission associated with Grafana
  fixed and basic roles.
labels:
  products:
    - cloud
    - enterprise
menuTitle: RBAC role definitions
title: Grafana RBAC role definitions
weight: 70
---

# RBAC role definitions

{{% admonition type="note" %}}
Available in [Grafana Enterprise]({{< relref "../../../../introduction/grafana-enterprise/" >}}) and [Grafana Cloud](/docs/grafana-cloud).
{{% /admonition %}}

The following tables list permissions associated with basic and fixed roles.

## Basic role assignments

| Basic role    | UID                   | Associated fixed roles                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 | Description                                                                                                |
| ------------- | --------------------- | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ---------------------------------------------------------------------------------------------------------- |
| Grafana Admin | `basic_grafana_admin` | `fixed:roles:reader`<br>`fixed:roles:writer`<br>`fixed:users:reader`<br>`fixed:users:writer`<br>`fixed:org.users:reader`<br>`fixed:org.users:writer`<br>`fixed:ldap:reader`<br>`fixed:ldap:writer`<br>`fixed:stats:reader`<br>`fixed:settings:reader`<br>`fixed:settings:writer`<br>`fixed:provisioning:writer`<br>`fixed:organization:reader`<br>`fixed:organization:maintainer`<br>`fixed:licensing:reader`<br>`fixed:licensing:writer`<br>`fixed:datasources.caching:reader`<br>`fixed:datasources.caching:writer`<br>`fixed:dashboards.insights:reader`<br>`fixed:datasources.insights:reader`<br>`fixed:plugins:maintainer`<br>`fixed:authentication.config:writer`<br>`fixed:library.panels:creator`<br>`fixed:library.panels:reader`<br>`fixed:library.panels:general.reader`<br>`fixed:library.panels:writer`<br>`fixed:library.panels:general.writer`                                                                                                                                                                                                                                                                                                         | Default [Grafana server administrator]({{< relref "../../#grafana-server-administrators" >}}) assignments. |
| Admin         | `basic_admin`         | `fixed:reports:reader`<br>`fixed:reports:writer`<br>`fixed:datasources:reader`<br>`fixed:datasources:writer`<br>`fixed:organization:writer`<br>`fixed:datasources.permissions:reader`<br>`fixed:datasources.permissions:writer`<br>`fixed:teams:writer`<br>`fixed:dashboards:reader`<br>`fixed:dashboards:writer`<br>`fixed:dashboards.permissions:reader`<br>`fixed:dashboards.permissions:writer`<br>`fixed:dashboards.public:writer`<br>`fixed:folders:reader`<br>`fixed:folders:writer`<br>`fixed:folders.permissions:reader`<br>`fixed:folders.permissions:writer`<br>`fixed:alerting:writer`<br>`fixed:apikeys:reader`<br>`fixed:apikeys:writer`<br>`fixed:alerting.provisioning.secrets:reader`<br>`fixed:alerting.provisioning:writer`<br>`fixed:datasources.caching:reader`<br>`fixed:datasources.caching:writer`<br>`fixed:dashboards.insights:reader`<br>`fixed:datasources.insights:reader`<br>`fixed:plugins:writer`<br>`fixed:library.panels:creator`<br>`fixed:library.panels:reader`<br>`fixed:library.panels:general.reader`<br>`fixed:library.panels:writer`<br>`fixed:library.panels:general.writer`<br>`fixed:alerting.provisioning.status:writer` | Default [Grafana organization administrator]({{< relref "../#basic-roles" >}}) assignments.                |
| Editor        | `basic_editor`        | `fixed:datasources:explorer`<br>`fixed:dashboards:creator`<br>`fixed:folders:creator`<br>`fixed:annotations:writer`<br>`fixed:teams:creator` if the `editors_can_admin` configuration flag is enabled<br>`fixed:alerting:writer`<br>`fixed:dashboards.insights:reader`<br>`fixed:datasources.insights:reader`<br>`fixed:library.panels:creator`<br>`fixed:library.panels:general.reader`<br>`fixed:library.panels:general.writer`<br>`fixed:alerting.provisioning.status:writer`                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       | Default [Editor]({{< relref "../#basic-roles" >}}) assignments.                                            |
| Viewer        | `basic_viewer`        | `fixed:datasources.id:reader`<br>`fixed:organization:reader`<br>`fixed:annotations:reader`<br>`fixed:annotations.dashboard:writer`<br>`fixed:alerting:reader`<br>`fixed:plugins.app:reader`<br>`fixed:dashboards.insights:reader`<br>`fixed:datasources.insights:reader`<br>`fixed:library.panels:general.reader`<br>`fixed:datasources:explorer` if the `viewers_can_edit` configuration flag is enabled                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              | Default [Viewer]({{< relref "../#basic-roles" >}}) assignments.                                            |
| No Basic Role | n/a                   |                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        | Default [No Basic Role]({{< relref "../#basic-roles"  >}})                                                 |

## Fixed role definitions

| Fixed role                                   | Permissions                                                                                                                                                                                                                                                                 | Description                                                                                                                                                                                                                                                                           |
| -------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `fixed:alerting.instances:writer`            | All permissions from `fixed:alerting.instances:reader` and<br> `alert.instances:create`<br>`alert.instances:write` for organization scope <br> `alert.instances.external:write` for scope `datasources:*`                                                                   | Create, update and expire all silences in the organization produced by Grafana, Mimir, and Loki.[\*](#alerting-roles)                                                                                                                                                                 |
| `fixed:alerting.instances:reader`            | `alert.instances:read` for organization scope <br> `alert.instances.external:read` for scope `datasources:*`                                                                                                                                                                | Read all alerts and silences in the organization produced by Grafana Alerts and Mimir and Loki alerts and silences.[\*](#alerting-roles)                                                                                                                                              |
| `fixed:alerting.notifications:writer`        | All permissions from `fixed:alerting.notifications:reader` and<br>`alert.notifications:write`for organization scope<br>`alert.notifications.external:read` for scope `datasources:*`                                                                                        | Create, update, and delete contact points, templates, mute timings and notification policies for Grafana and external Alertmanager.[\*](#alerting-roles)                                                                                                                              |
| `fixed:alerting.notifications:reader`        | `alert.notifications:read` for organization scope<br>`alert.notifications.external:read` for scope `datasources:*`                                                                                                                                                          | Read all Grafana and Alertmanager contact points, templates, and notification policies.[\*](#alerting-roles)                                                                                                                                                                          |
| `fixed:alerting.rules:writer`                | All permissions from `fixed:alerting.rules:reader` and <br> `alert.rule:create` <br> `alert.rule:write` <br> `alert.rule:delete` <br> `alert.silences:create` <br> `alert.silences:write` for scope `folders:*` <br> `alert.rules.external:write` for scope `datasources:*` | Create, update, and delete all\* Grafana, Mimir, and Loki alert rules.[\*](#alerting-roles) and manage rule-specific silences                                                                                                                                                         |
| `fixed:alerting.rules:reader`                | `alert.rule:read`, `alert.silences:read` for scope `folders:*` <br> `alert.rules.external:read` for scope `datasources:*` <br> `alert.notifications.time-intervals:read` <br> `alert.notifications.receivers:list`                                                          | Read all\* Grafana, Mimir, and Loki alert rules.[\*](#alerting-roles) and read rule-specific silences                                                                                                                                                                                 |
| `fixed:alerting:writer`                      | All permissions from `fixed:alerting.rules:writer` <br>`fixed:alerting.instances:writer`<br>`fixed:alerting.notifications:writer`                                                                                                                                           | Create, update, and delete Grafana, Mimir, Loki and Alertmanager alert rules\*, silences, contact points, templates, mute timings, and notification policies.[\*](#alerting-roles)                                                                                                    |
| `fixed:alerting:reader`                      | All permissions from `fixed:alerting.rules:reader` <br>`fixed:alerting.instances:reader`<br>`fixed:alerting.notifications:reader`                                                                                                                                           | Read-only permissions for all Grafana, Mimir, Loki and Alertmanager alert rules\*, alerts, contact points, and notification policies.[\*](#alerting-roles)                                                                                                                            |
| `fixed:alerting.provisioning.secrets:reader` | `alert.provisioning:read` and `alert.provisioning.secrets:read`                                                                                                                                                                                                             | Read-only permissions for Provisioning API and let export resources with decrypted secrets [\*](#alerting-roles)                                                                                                                                                                      |
| `fixed:alerting.provisioning:writer`         | `alert.provisioning:read` and `alert.provisioning:write`                                                                                                                                                                                                                    | Create, update and delete Grafana alert rules, notification policies, contact points, templates, etc via provisioning API. [\*](#alerting-roles)                                                                                                                                      |
| `fixed:alerting.provisioning.status:writer`  | `alert.provisioning.provenance:write`                                                                                                                                                                                                                                       | Set provenance status to alert rules, notification policies, contact points, etc. Should be used together with regular writer roles. [\*](#alerting-roles)                                                                                                                            |
| `fixed:annotations.dashboard:writer`         | `annotations:write` <br>`annotations.create`<br> `annotations:delete` for scope `annotations:type:dashboard`                                                                                                                                                                | Create, update and delete dashboard annotations and annotation tags.                                                                                                                                                                                                                  |
| `fixed:annotations:reader`                   | `annotations:read` for scopes `annotations:type:*`                                                                                                                                                                                                                          | Read all annotations and annotation tags.                                                                                                                                                                                                                                             |
| `fixed:annotations:writer`                   | All permissions from `fixed:annotations:reader` <br>`annotations:write` <br>`annotations.create`<br> `annotations:delete` for scope `annotations:type:*`                                                                                                                    | Read, create, update and delete all annotations and annotation tags.                                                                                                                                                                                                                  |
| `fixed:apikeys:reader`                       | `apikeys:read` for scope `apikeys:*`                                                                                                                                                                                                                                        | Read all api keys.                                                                                                                                                                                                                                                                    |
| `fixed:apikeys:writer`                       | All permissions from `fixed:apikeys:reader` and <br> `apikeys:create` <br> `apikeys:delete` for scope `apikeys:*`                                                                                                                                                           | Read, create, delete all api keys.                                                                                                                                                                                                                                                    |
| `fixed:authentication.config:writer`         | `settings:read` for scope `settings:auth.saml:*` <br> `settings:write` for scope `settings:auth.saml:*`                                                                                                                                                                     | Read and update authentication and SAML settings.                                                                                                                                                                                                                                     |
| `fixed:dashboards:creator`                   | `dashboards:create`<br>`folders:read`                                                                                                                                                                                                                                       | Create dashboards.                                                                                                                                                                                                                                                                    |
| `fixed:dashboards.insights:reader`           | `dashboards.insights:read`                                                                                                                                                                                                                                                  | Read dashboard insights data and see presence indicators.                                                                                                                                                                                                                             |
| `fixed:dashboards.permissions:reader`        | `dashboards.permissions:read`                                                                                                                                                                                                                                               | Read all dashboard permissions.                                                                                                                                                                                                                                                       |
| `fixed:dashboards.permissions:writer`        | All permissions from `fixed:dashboards.permissions:reader` and <br>`dashboards.permissions:write`                                                                                                                                                                           | Read and update all dashboard permissions.                                                                                                                                                                                                                                            |
| `fixed:dashboards.public:writer`             | `dashboards.public:write`                                                                                                                                                                                                                                                   | Create, update, delete or pause a public dashboard.                                                                                                                                                                                                                                   |
| `fixed:dashboards:reader`                    | `dashboards:read`                                                                                                                                                                                                                                                           | Read all dashboards.                                                                                                                                                                                                                                                                  |
| `fixed:dashboards:writer`                    | All permissions from `fixed:dashboards:reader` and <br>`dashboards:write`<br>`dashboards:edit`<br>`dashboards:delete`<br>`dashboards:create`<br>`dashboards.permissions:read`<br>`dashboards.permissions:write`                                                             | Read, create, update, and delete all dashboards.                                                                                                                                                                                                                                      |
| `fixed:datasources.caching:reader`           | `datasources.caching:read`                                                                                                                                                                                                                                                  | Read data source query caching settings.                                                                                                                                                                                                                                              |
| `fixed:datasources.caching:writer`           | `datasources.caching:read`<br>`datasources.caching:write`                                                                                                                                                                                                                   | Enable, disable, or update query caching settings.                                                                                                                                                                                                                                    |
| `fixed:datasources:explorer`                 | `datasources:explore`                                                                                                                                                                                                                                                       | Enable the Explore feature. Data source permissions still apply, you can only query data sources for which you have query permissions.                                                                                                                                                |
| `fixed:datasources.id:reader`                | `datasources.id:read`                                                                                                                                                                                                                                                       | Read the ID of a data source based on its name.                                                                                                                                                                                                                                       |
| `fixed:datasources.insights:reader`          | `datasources.insights:read`                                                                                                                                                                                                                                                 | Read data source insights data.                                                                                                                                                                                                                                                       |
| `fixed:datasources.permissions:reader`       | `datasources.permissions:read`                                                                                                                                                                                                                                              | Read data source permissions.                                                                                                                                                                                                                                                         |
| `fixed:datasources.permissions:writer`       | All permissions from `fixed:datasources.permissions:reader` and <br>`datasources.permissions:write`                                                                                                                                                                         | Create, read, or delete permissions of a data source.                                                                                                                                                                                                                                 |
| `fixed:datasources:creator`                  | `datasources:create`                                                                                                                                                                                                                                                        | Create data sources.                                                                                                                                                                                                                                                                  |
| `fixed:datasources:reader`                   | `datasources:read`<br>`datasources:query`                                                                                                                                                                                                                                   | Read and query data sources.                                                                                                                                                                                                                                                          |
| `fixed:datasources:writer`                   | All permissions from `fixed:datasources:reader` and <br>`datasources:create`<br>`datasources:write`<br>`datasources:delete`                                                                                                                                                 | Read, query, create, delete, or update a data source.                                                                                                                                                                                                                                 |
| `fixed:folders.permissions:reader`           | `folders.permissions:read`                                                                                                                                                                                                                                                  | Read all folder permissions.                                                                                                                                                                                                                                                          |
| `fixed:folders.permissions:writer`           | All permissions from `fixed:folders.permissions:reader` and <br>`folders.permissions:write`                                                                                                                                                                                 | Read and update all folder permissions.                                                                                                                                                                                                                                               |
| `fixed:folders:creator`                      | `folders:create`                                                                                                                                                                                                                                                            | Create folders in the root level. If granted together with `folders:write` permission, also allows creating subfolders under all folders.                                                                                                                                             |
| `fixed:folders:reader`                       | `folders:read`<br>`dashboards:read`                                                                                                                                                                                                                                         | Read all folders and dashboards.                                                                                                                                                                                                                                                      |
| `fixed:folders:writer`                       | All permissions from `fixed:dashboards:writer` and <br>`folders:read`<br>`folders:write`<br>`folders:create`<br>`folders:delete`<br>`folders.permissions:read`<br>`folders.permissions:write`                                                                               | Read, create, update, and delete all folders and dashboards. If granted together with `fixed:folders:creator`, allows creating subfolders under all folders.                                                                                                                          |
| `fixed:ldap:reader`                          | `ldap.user:read`<br>`ldap.status:read`                                                                                                                                                                                                                                      | Read the LDAP configuration and LDAP status information.                                                                                                                                                                                                                              |
| `fixed:ldap:writer`                          | All permissions from `fixed:ldap:reader` and <br>`ldap.user:sync`<br>`ldap.config:reload`                                                                                                                                                                                   | Read and update the LDAP configuration, and read LDAP status information.                                                                                                                                                                                                             |
| `fixed:library.panels:creator`               | `library.panels:create`<br>`folders:read`                                                                                                                                                                                                                                   | Create library panel at the root level.                                                                                                                                                                                                                                               |
| `fixed:library.panels:reader`                | `library.panels:read`                                                                                                                                                                                                                                                       | Read all library panels.                                                                                                                                                                                                                                                              |
| `fixed:library.panels:general.reader`        | `library.panels:read`                                                                                                                                                                                                                                                       | Read all library panels at the root level.                                                                                                                                                                                                                                            |
| `fixed:library.panels:writer`                | All permissions from `fixed:library.panels:reader` plus<br>`library.panels:create`<br>`library.panels:delete`<br>`library.panels:write`                                                                                                                                     | Create, read, write or delete all library panels and their permissions.                                                                                                                                                                                                               |
| `fixed:library.panels:general.writer`        | All permissions from `fixed:library.panels:general.reader` plus<br>`library.panels:create`<br>`library.panels:delete`<br>`library.panels:write`                                                                                                                             | Create, read, write or delete all library panels and their permissions at the root level.                                                                                                                                                                                             |
| `fixed:licensing:reader`                     | `licensing:read`<br>`licensing.reports:read`                                                                                                                                                                                                                                | Read licensing information and licensing reports.                                                                                                                                                                                                                                     |
| `fixed:licensing:writer`                     | All permissions from `fixed:licensing:viewer` and <br>`licensing:write`<br>`licensing:delete`                                                                                                                                                                               | Read licensing information and licensing reports, update and delete the license token.                                                                                                                                                                                                |
| `fixed:org.users:reader`                     | `org.users:read`                                                                                                                                                                                                                                                            | Read users within a single organization.                                                                                                                                                                                                                                              |
| `fixed:org.users:writer`                     | All permissions from `fixed:org.users:reader` and <br>`org.users:add`<br>`org.users:remove`<br>`org.users:write`                                                                                                                                                            | Within a single organization, add a user, invite a new user, read information about a user and their role, remove a user from that organization, or change the role of a user.                                                                                                        |
| `fixed:organization:maintainer`              | All permissions from `fixed:organization:reader` and <br> `orgs:write`<br>`orgs:create`<br>`orgs:delete`<br>`orgs.quotas:write`                                                                                                                                             | Create, read, write, or delete an organization. Read or write its quotas. This role needs to be assigned globally.                                                                                                                                                                    |
| `fixed:organization:reader`                  | `orgs:read`<br>`orgs.quotas:read`                                                                                                                                                                                                                                           | Read an organization and its quotas.                                                                                                                                                                                                                                                  |
| `fixed:organization:writer`                  | All permissions from `fixed:organization:reader` and <br> `orgs:write`<br>`orgs.preferences:read`<br>`orgs.preferences:write`                                                                                                                                               | Read an organization, its quotas, or its preferences. Update organization properties, or its preferences.                                                                                                                                                                             |
| `fixed:plugins.app:reader`                   | `plugins.app:access`                                                                                                                                                                                                                                                        | Access application plugins (still enforcing the organization role).                                                                                                                                                                                                                   |
| `fixed:plugins:maintainer`                   | `plugins:install`                                                                                                                                                                                                                                                           | Install and uninstall plugins. Needs to be assigned globally.                                                                                                                                                                                                                         |
| `fixed:plugins:writer`                       | `plugins:write`                                                                                                                                                                                                                                                             | Enable and disable plugins and edit plugins' settings.                                                                                                                                                                                                                                |
| `fixed:provisioning:writer`                  | `provisioning:reload`                                                                                                                                                                                                                                                       | Reload provisioning.                                                                                                                                                                                                                                                                  |
| `fixed:reports:reader`                       | `reports:read`<br>`reports:send`<br>`reports.settings:read`                                                                                                                                                                                                                 | Read all reports and shared report settings.                                                                                                                                                                                                                                          |
| `fixed:reports:writer`                       | All permissions from `fixed:reports:reader` and <br>`reports:create`<br>`reports:write`<br>`reports:delete`<br>`reports.settings:write`                                                                                                                                     | Create, read, update, or delete all reports and shared report settings.                                                                                                                                                                                                               |
| `fixed:roles:reader`                         | `roles:read`<br>`teams.roles:read`<br>`users.roles:read`<br>`users.permissions:read`                                                                                                                                                                                        | Read all access control roles, roles and permissions assigned to users, teams.                                                                                                                                                                                                        |
| `fixed:roles:writer`                         | All permissions from `fixed:roles:reader` and <br>`roles:write`<br>`roles:delete`<br>`teams.roles:add`<br>`teams.roles:remove`<br>`users.roles:add`<br>`users.roles:remove`                                                                                                 | Create, read, update, or delete all roles, assign or unassign roles to users, teams.                                                                                                                                                                                                  |
| `fixed:roles:resetter`                       | `roles:write` with scope `permissions:type:escalate`                                                                                                                                                                                                                        | Reset basic roles to their default.                                                                                                                                                                                                                                                   |
| `fixed:serviceaccounts:reader`               | `serviceaccounts:read`                                                                                                                                                                                                                                                      | Read Grafana service accounts.                                                                                                                                                                                                                                                        |
| `fixed:serviceaccounts:creator`              | `serviceaccounts:create`                                                                                                                                                                                                                                                    | Create Grafana service accounts.                                                                                                                                                                                                                                                      |
| `fixed:serviceaccounts:writer`               | `serviceaccounts:read`<br>`serviceaccounts:create`<br>`serviceaccounts:write`<br>`serviceaccounts:delete`<br>`serviceaccounts.permissions:read`<br>`serviceaccounts.permissions:write`                                                                                      | Create, update, read and delete all Grafana service accounts and manage service account permissions.                                                                                                                                                                                  |
| `fixed:settings:reader`                      | `settings:read`                                                                                                                                                                                                                                                             | Read Grafana instance settings.                                                                                                                                                                                                                                                       |
| `fixed:settings:writer`                      | All permissions from `fixed:settings:reader` and<br>`settings:write`                                                                                                                                                                                                        | Read and update Grafana instance settings.                                                                                                                                                                                                                                            |
| `fixed:stats:reader`                         | `server.stats:read`                                                                                                                                                                                                                                                         | Read Grafana instance statistics.                                                                                                                                                                                                                                                     |
| `fixed:teams:reader`                         | `teams:read`                                                                                                                                                                                                                                                                | List all teams.                                                                                                                                                                                                                                                                       |
| `fixed:teams:creator`                        | `teams:create`<br>`org.users:read`                                                                                                                                                                                                                                          | Create a team and list organization users (required to manage the created team).                                                                                                                                                                                                      |
| `fixed:teams:writer`                         | `teams:create`<br>`teams:delete`<br>`teams:read`<br>`teams:write`<br>`teams.permissions:read`<br>`teams.permissions:write`                                                                                                                                                  | Create, read, update and delete teams and manage team memberships.                                                                                                                                                                                                                    |
| `fixed:users:reader`                         | `users:read`<br>`users.quotas:read`<br>`users.authtoken:read`<br>`                                                                                                                                                                                                          | Read all users and their information, such as team memberships, authentication tokens, and quotas.                                                                                                                                                                                    |
| `fixed:users:writer`                         | All permissions from `fixed:users:reader` and <br>`users:write`<br>`users:create`<br>`users:delete`<br>`users:enable`<br>`users:disable`<br>`users.password:write`<br>`users.permissions:write`<br>`users:logout`<br>`users.authtoken:write`<br>`users.quotas:write`        | Read and update all attributes and settings for all users in Grafana: update user information, read user information, create or enable or disable a user, make a user a Grafana administrator, sign out a user, update a user’s authentication token, or update quotas for all users. |

### Alerting roles

You can use predefined roles to manage user access to alert rules, alert instances, and alert notification settings and create custom roles to limit user access to alert rules in a folder.

Access to Grafana alert rules is an intersection of many permissions:

- Permission to read a folder. For example, the fixed role `fixed:folders:reader` includes the action `folders:read` and a folder scope `folders:id:`.
- Permission to query **all** data sources that a given alert rule uses. If a user cannot query a given data source, they cannot see any alert rules that query that data source.

There is only one exclusion at this moment. Role `fixed:alerting.provisioning:writer` does not require user to have any additional permissions and provides access to all aspects of the alerting configuration via special provisioning API.

For more information about the permissions required to access alert rules, refer to [Create a custom role to access alerts in a folder]({{< relref "./plan-rbac-rollout-strategy/#create-a-custom-role-to-access-alerts-in-a-folder" >}}).

### Grafana OnCall roles (beta)

{{% admonition type="note" %}}
Available from Grafana 9.4 in early access.
{{% /admonition %}}

{{% admonition type="note" %}}
This feature is behind the `accessControlOnCall` feature toggle.
You can enable feature toggles through configuration file or environment variables. See configuration [docs]({{< relref "../../../../setup-grafana/configure-grafana/#feature_toggles" >}}) for details.
{{% /admonition %}}

If you are using [Grafana OnCall](https://grafana.com/docs/oncall/latest/get-started/), you can try out the integration between Grafana OnCall and RBAC.
For a detailed list of the available OnCall RBAC roles, refer to the table in [Available Grafana OnCall RBAC roles and granted actions](https://grafana.com/docs/oncall/latest/user-and-team-management/#available-grafana-oncall-rbac-roles--granted-actions).

The following table lists the default RBAC OnCall role assignments to the basic roles:

| Basic role    | Associated fixed roles              | Description                                                                                             |
| ------------- | ----------------------------------- | ------------------------------------------------------------------------------------------------------- |
| Grafana Admin | `plugins:grafana-oncall-app:admin`  | Default [Grafana server administrator]({{< relref "../#grafana-server-administrators" >}}) assignments. |
| Admin         | `plugins:grafana-oncall-app:admin`  | Default [Grafana organization administrator]({{< relref "../#basic-roles" >}}) assignments.             |
| Editor        | `plugins:grafana-oncall-app:editor` | Default [Editor]({{< relref "../#basic-roles" >}}) assignments.                                         |
| Viewer        | `plugins:grafana-oncall-app:reader` | Default [Viewer]({{< relref "../#basic-roles" >}}) assignments.                                         |
