"use strict";(self.webpackChunk_grafana_ui=self.webpackChunk_grafana_ui||[]).push([[1348],{"./src/components/Select/mockOptions.tsx":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){__webpack_require__.d(__webpack_exports__,{Q:function(){return generateOptions},W:function(){return generateThousandsOfOptions}});var lodash__WEBPACK_IMPORTED_MODULE_0__=__webpack_require__("../../node_modules/lodash/lodash.js"),generateOptions=function(){var desc=arguments.length>0&&void 0!==arguments[0]&&arguments[0];return["Sharilyn Markowitz","Naomi Striplin","Beau Bevel","Garrett Starkes","Hildegarde Pedro","Gudrun Seyler","Eboni Raines","Hye Felix","Chau Brito","Heidy Zook","Karima Husain","Virgil Mckinny","Kaley Dodrill","Sharan Ruf","Edgar Loveland","Judie Sanger","Season Bundrick","Ok Vicente","Garry Spitz","Han Harnish","A very long value that is very long and takes up a lot of space and should be truncated preferrably if it does not fit"].map((function(name){return{value:(0,lodash__WEBPACK_IMPORTED_MODULE_0__.kebabCase)(name),label:name,description:desc?"This is a description of ".concat(name):void 0}}))},generateThousandsOfOptions=function(){return new Array(1e4).fill(null).map((function(_,index){return{value:String(index),label:"Option "+index,description:"This is option number "+index}}))};try{generateOptions.displayName="generateOptions",generateOptions.__docgenInfo={description:"",displayName:"generateOptions",props:{}},"undefined"!=typeof STORYBOOK_REACT_CLASSES&&(STORYBOOK_REACT_CLASSES["src/components/Select/mockOptions.tsx#generateOptions"]={docgenInfo:generateOptions.__docgenInfo,name:"generateOptions",path:"src/components/Select/mockOptions.tsx#generateOptions"})}catch(__react_docgen_typescript_loader_error){}},"./src/components/Select/Select.story.tsx":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){__webpack_require__.r(__webpack_exports__),__webpack_require__.d(__webpack_exports__,{AutoMenuPlacement:function(){return AutoMenuPlacement},Basic:function(){return Basic},BasicSelectAsync:function(){return BasicSelectAsync},BasicSelectPlainValue:function(){return BasicSelectPlainValue},BasicVirtualizedList:function(){return BasicVirtualizedList},CustomValueCreation:function(){return CustomValueCreation},MultiPlainValue:function(){return MultiPlainValue},MultiSelectAsync:function(){return MultiSelectAsync},MultiSelectBasic:function(){return MultiSelectBasic},MultiSelectWithOptionGroups:function(){return MultiSelectWithOptionGroups},MultiSelectWithOptionGroupsVirtualized:function(){return MultiSelectWithOptionGroupsVirtualized},SelectWithOptionDescriptions:function(){return SelectWithOptionDescriptions},WidthAuto:function(){return WidthAuto},default:function(){return Select_story}});var enums=__webpack_require__("../../node_modules/@popperjs/core/lib/enums.js"),dist=__webpack_require__("../../node_modules/@storybook/addon-actions/dist/index.mjs"),chance=__webpack_require__("../../node_modules/chance/chance.js"),chance_default=__webpack_require__.n(chance),react=__webpack_require__("../../node_modules/react/index.js"),icon=__webpack_require__("../grafana-data/src/types/icon.ts"),Select=__webpack_require__("./src/components/Select/Select.tsx"),Icon=__webpack_require__("./src/components/Icon/Icon.tsx"),types_icon=__webpack_require__("./src/types/icon.ts"),jsx_runtime=__webpack_require__("../../node_modules/react/jsx-runtime.js"),lib=__webpack_require__("../../node_modules/@storybook/addon-docs/node_modules/@mdx-js/react/lib/index.js"),blocks_dist=__webpack_require__("../../node_modules/@storybook/blocks/dist/index.mjs");function _createMdxContent(props){const _components={code:"code",h1:"h1",h2:"h2",h3:"h3",li:"li",p:"p",pre:"pre",strong:"strong",ul:"ul",...(0,lib.R)(),...props.components};return(0,jsx_runtime.jsxs)(jsx_runtime.Fragment,{children:[(0,jsx_runtime.jsx)(_components.h1,{id:"select",children:"Select"}),"\n",(0,jsx_runtime.jsxs)(_components.p,{children:["Select is the base for every component on this page. The approaches mentioned here are also applicable to ",(0,jsx_runtime.jsx)(_components.code,{children:"AsyncSelect"}),", ",(0,jsx_runtime.jsx)(_components.code,{children:"MultiSelect"}),", ",(0,jsx_runtime.jsx)(_components.code,{children:"AsyncMultiSelect"}),"."]}),"\n",(0,jsx_runtime.jsx)(_components.h2,{id:"select-variants",children:"Select variants"}),"\n",(0,jsx_runtime.jsxs)(_components.p,{children:["Select is an input with the ability to search and create new values. It should be used when you have a list of options. If the data has a tree structure, consider using ",(0,jsx_runtime.jsx)(_components.code,{children:"Cascader"})," instead.\nSelect has some features:"]}),"\n",(0,jsx_runtime.jsxs)(_components.ul,{children:["\n",(0,jsx_runtime.jsx)(_components.li,{children:"Search a list of values"}),"\n",(0,jsx_runtime.jsx)(_components.li,{children:"Select multiple values"}),"\n",(0,jsx_runtime.jsx)(_components.li,{children:"Select from async data"}),"\n",(0,jsx_runtime.jsx)(_components.li,{children:"Create custom values that aren't in the list"}),"\n"]}),"\n",(0,jsx_runtime.jsx)(_components.h3,{id:"options-format",children:"Options format"}),"\n",(0,jsx_runtime.jsx)(_components.p,{children:"There are four properties for each option:"}),"\n",(0,jsx_runtime.jsxs)(_components.ul,{children:["\n",(0,jsx_runtime.jsxs)(_components.li,{children:[(0,jsx_runtime.jsx)(_components.code,{children:"label"})," - Text that is visible in the menu."]}),"\n",(0,jsx_runtime.jsxs)(_components.li,{children:[(0,jsx_runtime.jsx)(_components.code,{children:"value"})," - Could be anything, but is usually a string. Used to identify what is ",(0,jsx_runtime.jsx)(_components.strong,{children:"actually"})," selected."]}),"\n",(0,jsx_runtime.jsxs)(_components.li,{children:[(0,jsx_runtime.jsx)(_components.code,{children:"description"})," - Longer description that describes the choice. Use this sparingly."]}),"\n",(0,jsx_runtime.jsxs)(_components.li,{children:[(0,jsx_runtime.jsx)(_components.code,{children:"imgUrl"})," - URL to an image. Use this when an image or icon provides more context for the option."]}),"\n"]}),"\n",(0,jsx_runtime.jsx)(_components.pre,{children:(0,jsx_runtime.jsx)(_components.code,{className:"language-jsx",children:"const options = [\n  { label: 'Basic option', value: 0 },\n  { label: 'Option with description', value: 1, description: 'this is a description' },\n  {\n    label: 'Option with description and image',\n    value: 2,\n    description: 'This is a very elaborate description, describing all the wonders in the world.',\n    imgUrl: 'https://placekitten.com/40/40',\n  },\n];\n"})}),"\n",(0,jsx_runtime.jsx)(_components.h3,{id:"creatable-option",children:"Creatable option"}),"\n",(0,jsx_runtime.jsxs)(_components.p,{children:["Creatable option is used when you want to be able to add a custom value to the list of options. ",(0,jsx_runtime.jsx)(_components.code,{children:"allowCustomValue"})," needs to be true and you must handle the value creation with ",(0,jsx_runtime.jsx)(_components.code,{children:"onCreateOption"}),"."]}),"\n",(0,jsx_runtime.jsx)(_components.pre,{children:(0,jsx_runtime.jsx)(_components.code,{className:"language-jsx",children:'import { Select } from "@grafana/ui";\n\nconst SelectComponent = () => {\n  const [value, setValue] = useState<SelectableValue<number>>();\n\n  return (\n    <Select\n      options={option}\n      value={value}\n      allowCustomValue\n      onCreateOption={customValue => {\n        setValue(customValue);\n      }}\n    />\n  );\n};\n'})}),"\n",(0,jsx_runtime.jsx)(_components.h3,{id:"resetting-selected-value-from-outside-the-component",children:"Resetting selected value from outside the component"}),"\n",(0,jsx_runtime.jsxs)(_components.p,{children:["If you want to reset the selected value from outside the component, e.g. if there are two Select components that should be in sync, you can set the dependent Select value to ",(0,jsx_runtime.jsx)(_components.code,{children:"null"})," in the ",(0,jsx_runtime.jsx)(_components.code,{children:"onChange"})," handler of the first Select component."]}),"\n",(0,jsx_runtime.jsx)(_components.pre,{children:(0,jsx_runtime.jsx)(_components.code,{className:"language-tsx",children:"import React, { useState } from 'react';\nimport { Select } from '@grafana/ui';\n\nconst SelectComponent = () => {\n  const [person, setPerson] = useState<string | undefined>('');\n  const [team, setTeam] = useState<string | undefined | null>('');\n\n  return (\n    <form>\n      <Select\n        onChange={({ value }) => {\n          setPerson(value);\n          setTeam(null); // Setting the team to null will reset the selected value in the team Select\n        }}\n        options={[\n          {\n            value: 'option1',\n            label: 'Option 1',\n          },\n          {\n            value: 'option2',\n            label: 'Option 2',\n          },\n        ]}\n        value={person}\n        backspaceRemovesValue\n      />\n      <Select\n        onChange={({ value }) => setTeam(value)}\n        options={[\n          {\n            value: 'team1',\n            label: 'Team 1',\n          },\n          {\n            value: 'team',\n            label: 'Team 2',\n          },\n        ]}\n        value={team}\n      />\n    </form>\n  );\n};\n"})}),"\n",(0,jsx_runtime.jsx)(_components.h2,{id:"asyncselect",children:"AsyncSelect"}),"\n",(0,jsx_runtime.jsxs)(_components.p,{children:["Like regular Select, but handles fetching options asynchronously. Use the ",(0,jsx_runtime.jsx)(_components.code,{children:"loadOptions"})," prop for the async function that loads the options. If ",(0,jsx_runtime.jsx)(_components.code,{children:"defaultOptions"})," is set to ",(0,jsx_runtime.jsx)(_components.code,{children:"true"}),", ",(0,jsx_runtime.jsx)(_components.code,{children:"loadOptions"})," will be called when the component is mounted."]}),"\n",(0,jsx_runtime.jsx)(_components.pre,{children:(0,jsx_runtime.jsx)(_components.code,{className:"language-jsx",children:"\nimport { AsyncSelect } from '@grafana/ui';\n\nconst basicSelectAsync = () => {\n  const [value, setValue] = useState<SelectableValue<string>>();\n\n  return (\n    <AsyncSelect\n      loadOptions={loadAsyncOptions}\n      defaultOptions\n      value={value}\n      onChange={v => {\n        setValue(v);\n      }}\n    />\n  );\n};\n"})}),"\n",(0,jsx_runtime.jsx)(_components.p,{children:"Where the async function could look like this:"}),"\n",(0,jsx_runtime.jsx)(_components.pre,{children:(0,jsx_runtime.jsx)(_components.code,{className:"language-tsx",children:"const loadAsyncOptions = () => {\n  return new Promise<Array<SelectableValue<string>>>((resolve) => {\n    setTimeout(() => {\n      resolve(options);\n    }, 2000);\n  });\n};\n"})}),"\n",(0,jsx_runtime.jsx)(_components.h2,{id:"multiselect",children:"MultiSelect"}),"\n",(0,jsx_runtime.jsx)(_components.p,{children:"Possible to Select multiple values at the same time."}),"\n",(0,jsx_runtime.jsx)(_components.pre,{children:(0,jsx_runtime.jsx)(_components.code,{className:"language-tsx",children:"import { MultiSelect } from '@grafana/ui';\n\nconst multiSelect = () => {\n  const [value, setValue] = useState<Array<SelectableValue<string>>>([]);\n\n  return (\n    <>\n      <MultiSelect\n        options={options}\n        value={value}\n        onChange={(v) => {\n          setValue(v);\n        }}\n      />\n    </>\n  );\n};\n"})}),"\n",(0,jsx_runtime.jsx)(_components.h2,{id:"asyncmultiselect",children:"AsyncMultiSelect"}),"\n",(0,jsx_runtime.jsxs)(_components.p,{children:["Like MultiSelect but handles data asynchronously with the ",(0,jsx_runtime.jsx)(_components.code,{children:"loadOptions"})," prop."]}),"\n",(0,jsx_runtime.jsx)(_components.h2,{id:"testing",children:"Testing"}),"\n",(0,jsx_runtime.jsxs)(_components.p,{children:["Using React Testing Library, you can select the ",(0,jsx_runtime.jsx)(_components.code,{children:"<Select />"})," using its matching label, such as the label assigned with the ",(0,jsx_runtime.jsx)(_components.code,{children:"inputId"})," prop. Use the ",(0,jsx_runtime.jsx)(_components.code,{children:"react-select-event"})," package to select values from the options."]}),"\n",(0,jsx_runtime.jsx)(_components.pre,{children:(0,jsx_runtime.jsx)(_components.code,{className:"language-tsx",children:"import { render, screen } from '@testing-library/react';\nimport selectEvent from 'react-select-event';\nimport { Select } from '@grafana/ui';\n\nit('should call onChange', () => {\n  const onChange = jest.fn();\n\n  render(\n    <>\n      <label htmlFor=\"my-select\">My select</label>\n      <Select onChange={onChange} options={options} inputId=\"my-select\" />\n    </>\n  );\n\n  const selectEl = screen.getByLabelText('My select');\n  expect(selectEl).toBeInTheDocument();\n\n  await selectEvent.select(selectEl, 'Option 2', { container: document.body });\n  expect(onChange).toHaveBeenCalledWith({\n    label: 'Option 2',\n    value: 2,\n  });\n});\n"})}),"\n",(0,jsx_runtime.jsx)(_components.h2,{id:"props",children:"Props"}),"\n",(0,jsx_runtime.jsx)(blocks_dist.ov,{of:Select.l6})]})}var mockOptions=__webpack_require__("./src/components/Select/mockOptions.tsx");function _array_like_to_array(arr,len){(null==len||len>arr.length)&&(len=arr.length);for(var i=0,arr2=new Array(len);i<len;i++)arr2[i]=arr[i];return arr2}function _define_property(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}function _object_spread(target){for(var i=1;i<arguments.length;i++){var source=null!=arguments[i]?arguments[i]:{},ownKeys=Object.keys(source);"function"==typeof Object.getOwnPropertySymbols&&(ownKeys=ownKeys.concat(Object.getOwnPropertySymbols(source).filter((function(sym){return Object.getOwnPropertyDescriptor(source,sym).enumerable})))),ownKeys.forEach((function(key){_define_property(target,key,source[key])}))}return target}function _object_spread_props(target,source){return source=null!=source?source:{},Object.getOwnPropertyDescriptors?Object.defineProperties(target,Object.getOwnPropertyDescriptors(source)):function ownKeys(object,enumerableOnly){var keys=Object.keys(object);if(Object.getOwnPropertySymbols){var symbols=Object.getOwnPropertySymbols(object);enumerableOnly&&(symbols=symbols.filter((function(sym){return Object.getOwnPropertyDescriptor(object,sym).enumerable}))),keys.push.apply(keys,symbols)}return keys}(Object(source)).forEach((function(key){Object.defineProperty(target,key,Object.getOwnPropertyDescriptor(source,key))})),target}function _sliced_to_array(arr,i){return function _array_with_holes(arr){if(Array.isArray(arr))return arr}(arr)||function _iterable_to_array_limit(arr,i){var _i=null==arr?null:"undefined"!=typeof Symbol&&arr[Symbol.iterator]||arr["@@iterator"];if(null!=_i){var _s,_e,_arr=[],_n=!0,_d=!1;try{for(_i=_i.call(arr);!(_n=(_s=_i.next()).done)&&(_arr.push(_s.value),!i||_arr.length!==i);_n=!0);}catch(err){_d=!0,_e=err}finally{try{_n||null==_i.return||_i.return()}finally{if(_d)throw _e}}return _arr}}(arr,i)||_unsupported_iterable_to_array(arr,i)||function _non_iterable_rest(){throw new TypeError("Invalid attempt to destructure non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function _to_consumable_array(arr){return function _array_without_holes(arr){if(Array.isArray(arr))return _array_like_to_array(arr)}(arr)||function _iterable_to_array(iter){if("undefined"!=typeof Symbol&&null!=iter[Symbol.iterator]||null!=iter["@@iterator"])return Array.from(iter)}(arr)||_unsupported_iterable_to_array(arr)||function _non_iterable_spread(){throw new TypeError("Invalid attempt to spread non-iterable instance.\\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.")}()}function _unsupported_iterable_to_array(o,minLen){if(o){if("string"==typeof o)return _array_like_to_array(o,minLen);var n=Object.prototype.toString.call(o).slice(8,-1);return"Object"===n&&o.constructor&&(n=o.constructor.name),"Map"===n||"Set"===n?Array.from(n):"Arguments"===n||/^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)?_array_like_to_array(o,minLen):void 0}}var Select_story_chance=new(chance_default()),manyGroupedOptions=[{label:"Foo",value:"1"},{label:"Animals",options:new Array(100).fill(0).map((function(_,i){var animal=Select_story_chance.animal();return{label:animal,value:animal}}))},{label:"People",options:new Array(100).fill(0).map((function(_,i){var person=Select_story_chance.name();return{label:person,value:person}}))}],meta={title:"Forms/Select",component:Select.l6,subcomponents:{AsyncSelect:Select.DW,MultiSelect:Select.KF,AsyncMultiSelect:Select.Iv},parameters:{docs:{page:function MDXContent(props={}){const{wrapper:MDXLayout}={...(0,lib.R)(),...props.components};return MDXLayout?(0,jsx_runtime.jsx)(MDXLayout,{...props,children:(0,jsx_runtime.jsx)(_createMdxContent,{...props})}):_createMdxContent(props)}},controls:{exclude:["getOptionValue","getOptionLabel","formatCreateLabel","filterOption","className","components","defaultValue","id","inputId","onBlur","onChange","onCloseMenu","onCreateOption","onInputChange","onKeyDown","onOpenMenu","prefix","renderControl","options","isOptionDisabled","aria-label","noOptionsMessage","menuPosition","isValidNewOption","value"]}},args:{width:0,disabled:!1,isLoading:!1,invalid:!1,icon:"arrow-down"},argTypes:{width:{control:{type:"range",min:1,max:100}},icon:{control:{type:"select",options:(0,types_icon.GO)()}}}},loadAsyncOptions=function(){return new Promise((function(resolve){setTimeout((function(){resolve((0,mockOptions.Q)())}),2e3)}))},getPrefix=function(prefix){var _toIconName;return react.createElement(Icon.I,{name:null!==(_toIconName=(0,icon.Uo)(prefix))&&void 0!==_toIconName?_toIconName:"question-circle"})},Basic=function(args){var _useState=_sliced_to_array((0,react.useState)(),2),value=_useState[0],setValue=_useState[1];return react.createElement(react.Fragment,null,react.createElement(Select.l6,_object_spread({options:(0,mockOptions.Q)(),value:value,onChange:function(v){setValue(v),(0,dist.XI)("onChange")(v)}},args)))},BasicVirtualizedList=function(args){var _useState=_sliced_to_array((0,react.useState)(),2),value=_useState[0],setValue=_useState[1];return react.createElement(react.Fragment,null,react.createElement(Select.l6,_object_spread({options:(0,mockOptions.W)(),virtualized:!0,value:value,onChange:function(v){setValue(v),(0,dist.XI)("onChange")(v)}},args)))},BasicSelectPlainValue=function(args){var _useState=_sliced_to_array((0,react.useState)(),2),value=_useState[0],setValue=_useState[1];return react.createElement(react.Fragment,null,react.createElement(Select.l6,_object_spread({options:(0,mockOptions.Q)(),value:value,onChange:function(v){setValue(v.value),(0,dist.XI)("onChange")(v)},prefix:getPrefix(args.icon)},args)))},SelectWithOptionDescriptions=function(args){var _useState=_sliced_to_array((0,react.useState)(),2),value=_useState[0],setValue=_useState[1];return react.createElement(react.Fragment,null,react.createElement(Select.l6,_object_spread({options:[{label:"Basic option",value:0},{label:"Option with description",value:1,description:"this is a description"},{label:"Option with description and image",value:2,description:"This is a very elaborate description, describing all the wonders in the world.",imgUrl:"https://placekitten.com/40/40"}],value:value,onChange:function(v){setValue(v.value),(0,dist.XI)("onChange")(v)},prefix:getPrefix(args.icon)},args)))},MultiPlainValue=function(args){var _useState=_sliced_to_array((0,react.useState)(),2),value=_useState[0],setValue=_useState[1];return react.createElement(react.Fragment,null,react.createElement(Select.KF,_object_spread({options:(0,mockOptions.Q)(),value:value,onChange:function(v){setValue(v.map((function(v){return v.value})))},prefix:getPrefix(args.icon)},args)))},MultiSelectWithOptionGroups=function(args){var _useState=_sliced_to_array((0,react.useState)(),2),value=_useState[0],setValue=_useState[1];return react.createElement(react.Fragment,null,react.createElement(Select.KF,_object_spread({options:[{label:"Foo",value:"1"},{label:"Colours",value:"2",options:[{label:"Blue",value:"5"},{label:"Red",value:"6"},{label:"Black",value:"7"},{label:"Yellow",value:"8"}]},{label:"Animals",value:"9",options:[{label:"Cat",value:"10"},{label:"Cow",value:"11"},{label:"Dog",value:"12"},{label:"Eagle",value:"13"}]}],value:value,onChange:function(v){setValue(v.map((function(v){return v.value}))),(0,dist.XI)("onChange")(v)},prefix:getPrefix(args.icon)},args)))},MultiSelectWithOptionGroupsVirtualized=function(args){var _useState=_sliced_to_array((0,react.useState)(),2),value=_useState[0],setValue=_useState[1];return react.createElement(react.Fragment,null,react.createElement(Select.KF,_object_spread({options:manyGroupedOptions,virtualized:!0,value:value,onChange:function(v){setValue(v.map((function(v){return v.value}))),(0,dist.XI)("onChange")(v)},prefix:getPrefix(args.icon)},args)))},MultiSelectBasic=function(args){var _useState=_sliced_to_array((0,react.useState)([]),2),value=_useState[0],setValue=_useState[1];return react.createElement("div",{style:{maxWidth:"450px"}},react.createElement(Select.KF,_object_spread({options:(0,mockOptions.Q)(),value:value,onChange:function(v){setValue(v),(0,dist.XI)("onChange")(v)},prefix:getPrefix(args.icon)},args)))};MultiSelectBasic.args={isClearable:!1,closeMenuOnSelect:!1,maxVisibleValues:5,noMultiValueWrap:!1};var MultiSelectAsync=function(args){var _useState=_sliced_to_array((0,react.useState)(),2),value=_useState[0],setValue=_useState[1];return react.createElement(Select.Iv,_object_spread({loadOptions:loadAsyncOptions,defaultOptions:!0,value:value,onChange:function(v){setValue(v),(0,dist.XI)("onChange")(v)},prefix:getPrefix(args.icon)},args))};MultiSelectAsync.args={allowCustomValue:!1};var BasicSelectAsync=function(args){var _useState=_sliced_to_array((0,react.useState)(),2),value=_useState[0],setValue=_useState[1];return react.createElement(Select.DW,_object_spread({loadOptions:loadAsyncOptions,defaultOptions:!0,value:value,onChange:function(v){setValue(v),(0,dist.XI)("onChange")(v)},prefix:getPrefix(args.icon)},args))},AutoMenuPlacement=function(args){var _useState=_sliced_to_array((0,react.useState)(),2),value=_useState[0],setValue=_useState[1];return react.createElement(react.Fragment,null,react.createElement("div",{style:{width:"100%",height:"95vh",display:"flex",alignItems:"flex-end"}},react.createElement(Select.l6,_object_spread({options:(0,mockOptions.Q)(),value:value,onChange:function(v){setValue(v),(0,dist.XI)("onChange")(v)},prefix:getPrefix(args.icon)},args))))};AutoMenuPlacement.args={menuPlacement:enums.qZ};var WidthAuto=function(args){var _useState=_sliced_to_array((0,react.useState)(),2),value=_useState[0],setValue=_useState[1];return react.createElement(react.Fragment,null,react.createElement("div",{style:{width:"100%"}},react.createElement(Select.l6,_object_spread_props(_object_spread({options:(0,mockOptions.Q)(),value:value,onChange:function(v){setValue(v),(0,dist.XI)("onChange")(v)},prefix:getPrefix(args.icon)},args),{width:"auto"}))))},CustomValueCreation=function(args){var _useState=_sliced_to_array((0,react.useState)(),2),value=_useState[0],setValue=_useState[1],_useState1=_sliced_to_array((0,react.useState)([]),2),customOptions=_useState1[0],setCustomOptions=_useState1[1],options=(0,mockOptions.Q)();return react.createElement(react.Fragment,null,react.createElement(Select.l6,_object_spread({options:_to_consumable_array(options).concat(_to_consumable_array(customOptions)),value:value,onChange:function(v){setValue(v),(0,dist.XI)("onChange")(v)},allowCustomValue:args.allowCustomValue,onCreateOption:function(v){var customValue={value:v,label:v};setCustomOptions(_to_consumable_array(customOptions).concat([customValue])),setValue(customValue),(0,dist.XI)("onCreateOption")(v)},prefix:getPrefix(args.icon)},args)))};CustomValueCreation.args={allowCustomValue:!0};var Select_story=meta;Basic.parameters={...Basic.parameters,docs:{...Basic.parameters?.docs,source:{originalSource:"args => {\n  const [value, setValue] = useState<SelectableValue<string>>();\n  return <>\n      <Select options={generateOptions()} value={value} onChange={v => {\n      setValue(v);\n      action('onChange')(v);\n    }} {...args} />\n    </>;\n}",...Basic.parameters?.docs?.source}}},BasicVirtualizedList.parameters={...BasicVirtualizedList.parameters,docs:{...BasicVirtualizedList.parameters?.docs,source:{originalSource:"args => {\n  const [value, setValue] = useState<SelectableValue<string>>();\n  return <>\n      <Select options={generateThousandsOfOptions()} virtualized value={value} onChange={v => {\n      setValue(v);\n      action('onChange')(v);\n    }} {...args} />\n    </>;\n}",...BasicVirtualizedList.parameters?.docs?.source}}},BasicSelectPlainValue.parameters={...BasicSelectPlainValue.parameters,docs:{...BasicSelectPlainValue.parameters?.docs,source:{originalSource:"args => {\n  const [value, setValue] = useState<string>();\n  return <>\n      <Select options={generateOptions()} value={value} onChange={v => {\n      setValue(v.value);\n      action('onChange')(v);\n    }} prefix={getPrefix(args.icon)} {...args} />\n    </>;\n}",...BasicSelectPlainValue.parameters?.docs?.source},description:{story:"Uses plain values instead of SelectableValue<T>",...BasicSelectPlainValue.parameters?.docs?.description}}},SelectWithOptionDescriptions.parameters={...SelectWithOptionDescriptions.parameters,docs:{...SelectWithOptionDescriptions.parameters?.docs,source:{originalSource:"args => {\n  // TODO this is not working with new Select\n\n  const [value, setValue] = useState<number>();\n  const options = [{\n    label: 'Basic option',\n    value: 0\n  }, {\n    label: 'Option with description',\n    value: 1,\n    description: 'this is a description'\n  }, {\n    label: 'Option with description and image',\n    value: 2,\n    description: 'This is a very elaborate description, describing all the wonders in the world.',\n    imgUrl: 'https://placekitten.com/40/40'\n  }];\n  return <>\n      <Select options={options} value={value} onChange={v => {\n      setValue(v.value);\n      action('onChange')(v);\n    }} prefix={getPrefix(args.icon)} {...args} />\n    </>;\n}",...SelectWithOptionDescriptions.parameters?.docs?.source},description:{story:"Uses plain values instead of SelectableValue<T>",...SelectWithOptionDescriptions.parameters?.docs?.description}}},MultiPlainValue.parameters={...MultiPlainValue.parameters,docs:{...MultiPlainValue.parameters?.docs,source:{originalSource:"args => {\n  const [value, setValue] = useState<string[]>();\n  return <>\n      <MultiSelect options={generateOptions()} value={value} onChange={v => {\n      setValue(v.map(v => v.value!));\n    }} prefix={getPrefix(args.icon)} {...args} />\n    </>;\n}",...MultiPlainValue.parameters?.docs?.source},description:{story:"Uses plain values instead of SelectableValue<T>",...MultiPlainValue.parameters?.docs?.description}}},MultiSelectWithOptionGroups.parameters={...MultiSelectWithOptionGroups.parameters,docs:{...MultiSelectWithOptionGroups.parameters?.docs,source:{originalSource:"args => {\n  const [value, setValue] = useState<string[]>();\n  return <>\n      <MultiSelect options={[{\n      label: 'Foo',\n      value: '1'\n    }, {\n      label: 'Colours',\n      value: '2',\n      options: [{\n        label: 'Blue',\n        value: '5'\n      }, {\n        label: 'Red',\n        value: '6'\n      }, {\n        label: 'Black',\n        value: '7'\n      }, {\n        label: 'Yellow',\n        value: '8'\n      }]\n    }, {\n      label: 'Animals',\n      value: '9',\n      options: [{\n        label: 'Cat',\n        value: '10'\n      }, {\n        label: 'Cow',\n        value: '11'\n      }, {\n        label: 'Dog',\n        value: '12'\n      }, {\n        label: 'Eagle',\n        value: '13'\n      }]\n    }]} value={value} onChange={v => {\n      setValue(v.map(v => v.value!));\n      action('onChange')(v);\n    }} prefix={getPrefix(args.icon)} {...args} />\n    </>;\n}",...MultiSelectWithOptionGroups.parameters?.docs?.source}}},MultiSelectWithOptionGroupsVirtualized.parameters={...MultiSelectWithOptionGroupsVirtualized.parameters,docs:{...MultiSelectWithOptionGroupsVirtualized.parameters?.docs,source:{originalSource:"args => {\n  const [value, setValue] = useState<string[]>();\n  return <>\n      <MultiSelect options={manyGroupedOptions} virtualized value={value} onChange={v => {\n      setValue(v.map(v => v.value!));\n      action('onChange')(v);\n    }} prefix={getPrefix(args.icon)} {...args} />\n    </>;\n}",...MultiSelectWithOptionGroupsVirtualized.parameters?.docs?.source}}},MultiSelectBasic.parameters={...MultiSelectBasic.parameters,docs:{...MultiSelectBasic.parameters?.docs,source:{originalSource:"args => {\n  const [value, setValue] = useState<Array<SelectableValue<string>>>([]);\n  return <div style={{\n    maxWidth: '450px'\n  }}>\n      <MultiSelect options={generateOptions()} value={value} onChange={v => {\n      setValue(v);\n      action('onChange')(v);\n    }} prefix={getPrefix(args.icon)} {...args} />\n    </div>;\n}",...MultiSelectBasic.parameters?.docs?.source}}},MultiSelectAsync.parameters={...MultiSelectAsync.parameters,docs:{...MultiSelectAsync.parameters?.docs,source:{originalSource:"args => {\n  const [value, setValue] = useState<Array<SelectableValue<string>>>();\n  return <AsyncMultiSelect loadOptions={loadAsyncOptions} defaultOptions value={value} onChange={v => {\n    setValue(v);\n    action('onChange')(v);\n  }} prefix={getPrefix(args.icon)} {...args} />;\n}",...MultiSelectAsync.parameters?.docs?.source}}},BasicSelectAsync.parameters={...BasicSelectAsync.parameters,docs:{...BasicSelectAsync.parameters?.docs,source:{originalSource:"args => {\n  const [value, setValue] = useState<SelectableValue<string>>();\n  return <AsyncSelect loadOptions={loadAsyncOptions} defaultOptions value={value} onChange={v => {\n    setValue(v);\n    action('onChange')(v);\n  }} prefix={getPrefix(args.icon)} {...args} />;\n}",...BasicSelectAsync.parameters?.docs?.source}}},AutoMenuPlacement.parameters={...AutoMenuPlacement.parameters,docs:{...AutoMenuPlacement.parameters?.docs,source:{originalSource:"args => {\n  const [value, setValue] = useState<SelectableValue<string>>();\n  return <>\n      <div style={{\n      width: '100%',\n      height: '95vh',\n      display: 'flex',\n      alignItems: 'flex-end'\n    }}>\n        <Select options={generateOptions()} value={value} onChange={v => {\n        setValue(v);\n        action('onChange')(v);\n      }} prefix={getPrefix(args.icon)} {...args} />\n      </div>\n    </>;\n}",...AutoMenuPlacement.parameters?.docs?.source}}},WidthAuto.parameters={...WidthAuto.parameters,docs:{...WidthAuto.parameters?.docs,source:{originalSource:"args => {\n  const [value, setValue] = useState<SelectableValue<string>>();\n  return <>\n      <div style={{\n      width: '100%'\n    }}>\n        <Select options={generateOptions()} value={value} onChange={v => {\n        setValue(v);\n        action('onChange')(v);\n      }} prefix={getPrefix(args.icon)} {...args} width=\"auto\" />\n      </div>\n    </>;\n}",...WidthAuto.parameters?.docs?.source}}},CustomValueCreation.parameters={...CustomValueCreation.parameters,docs:{...CustomValueCreation.parameters?.docs,source:{originalSource:"args => {\n  const [value, setValue] = useState<SelectableValue<string>>();\n  const [customOptions, setCustomOptions] = useState<Array<SelectableValue<string>>>([]);\n  const options = generateOptions();\n  return <>\n      <Select options={[...options, ...customOptions]} value={value} onChange={v => {\n      setValue(v);\n      action('onChange')(v);\n    }} allowCustomValue={args.allowCustomValue} onCreateOption={v => {\n      const customValue: SelectableValue<string> = {\n        value: v,\n        label: v\n      };\n      setCustomOptions([...customOptions, customValue]);\n      setValue(customValue);\n      action('onCreateOption')(v);\n    }} prefix={getPrefix(args.icon)} {...args} />\n    </>;\n}",...CustomValueCreation.parameters?.docs?.source}}};try{BasicSelectPlainValue.displayName="BasicSelectPlainValue",BasicSelectPlainValue.__docgenInfo={description:"Uses plain values instead of SelectableValue<T>",displayName:"BasicSelectPlainValue",props:{}},"undefined"!=typeof STORYBOOK_REACT_CLASSES&&(STORYBOOK_REACT_CLASSES["src/components/Select/Select.story.tsx#BasicSelectPlainValue"]={docgenInfo:BasicSelectPlainValue.__docgenInfo,name:"BasicSelectPlainValue",path:"src/components/Select/Select.story.tsx#BasicSelectPlainValue"})}catch(__react_docgen_typescript_loader_error){}try{SelectWithOptionDescriptions.displayName="SelectWithOptionDescriptions",SelectWithOptionDescriptions.__docgenInfo={description:"Uses plain values instead of SelectableValue<T>",displayName:"SelectWithOptionDescriptions",props:{}},"undefined"!=typeof STORYBOOK_REACT_CLASSES&&(STORYBOOK_REACT_CLASSES["src/components/Select/Select.story.tsx#SelectWithOptionDescriptions"]={docgenInfo:SelectWithOptionDescriptions.__docgenInfo,name:"SelectWithOptionDescriptions",path:"src/components/Select/Select.story.tsx#SelectWithOptionDescriptions"})}catch(__react_docgen_typescript_loader_error){}try{MultiPlainValue.displayName="MultiPlainValue",MultiPlainValue.__docgenInfo={description:"Uses plain values instead of SelectableValue<T>",displayName:"MultiPlainValue",props:{}},"undefined"!=typeof STORYBOOK_REACT_CLASSES&&(STORYBOOK_REACT_CLASSES["src/components/Select/Select.story.tsx#MultiPlainValue"]={docgenInfo:MultiPlainValue.__docgenInfo,name:"MultiPlainValue",path:"src/components/Select/Select.story.tsx#MultiPlainValue"})}catch(__react_docgen_typescript_loader_error){}}}]);