"use strict";(self.webpackChunk_grafana_ui=self.webpackChunk_grafana_ui||[]).push([[6418],{"./src/components/UsersIndicator/UsersIndicator.story.tsx":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){__webpack_require__.r(__webpack_exports__),__webpack_require__.d(__webpack_exports__,{Basic:function(){return Basic},WithManyUsers:function(){return WithManyUsers},default:function(){return UsersIndicator_story}});var react=__webpack_require__("../../node_modules/react/index.js"),emotion_css_esm=__webpack_require__("../../node_modules/@emotion/css/dist/emotion-css.esm.js"),ThemeContext=__webpack_require__("./src/themes/ThemeContext.tsx"),UserIcon=__webpack_require__("./src/components/UsersIndicator/UserIcon.tsx"),UsersIndicator=function(param){var users=param.users,onClick=param.onClick,_param_limit=param.limit,limit=void 0===_param_limit?4:_param_limit,styles=(0,ThemeContext.of)(getStyles);if(!users.length)return null;limit=limit>0?limit:4;var limitReached=users.length>limit,extraUsers=users.length-limit,tooManyUsers=extraUsers>99;return react.createElement("div",{className:styles.container,"aria-label":"Users indicator container"},limitReached&&react.createElement(UserIcon.n,{onClick:onClick,userView:{user:{name:"Extra users"},lastActiveAt:""},showTooltip:!1},tooManyUsers?"...":"+".concat(extraUsers)),users.slice(0,limitReached?limit:limit+1).reverse().map((function(userView){return react.createElement(UserIcon.n,{key:userView.user.name,userView:userView})})))},getStyles=function(theme){return{container:(0,emotion_css_esm.AH)({display:"flex",justifyContent:"center",flexDirection:"row-reverse",marginLeft:theme.spacing(1),"& > button":{marginLeft:theme.spacing(-1)}}),dots:(0,emotion_css_esm.AH)({marginBottom:"3px"})}};try{UsersIndicator.displayName="UsersIndicator",UsersIndicator.__docgenInfo={description:"",displayName:"UsersIndicator",props:{users:{defaultValue:null,description:"An object that contains the user's details and 'lastActiveAt' status",name:"users",required:!0,type:{name:"UserView[]"}},limit:{defaultValue:{value:"4"},description:"A limit of how many user icons to show before collapsing them and showing a number of users instead",name:"limit",required:!1,type:{name:"number"}},onClick:{defaultValue:null,description:"onClick handler for the user number indicator",name:"onClick",required:!1,type:{name:"(() => void)"}}}},"undefined"!=typeof STORYBOOK_REACT_CLASSES&&(STORYBOOK_REACT_CLASSES["src/components/UsersIndicator/UsersIndicator.tsx#UsersIndicator"]={docgenInfo:UsersIndicator.__docgenInfo,name:"UsersIndicator",path:"src/components/UsersIndicator/UsersIndicator.tsx#UsersIndicator"})}catch(__react_docgen_typescript_loader_error){}var jsx_runtime=__webpack_require__("../../node_modules/react/jsx-runtime.js"),lib=__webpack_require__("../../node_modules/@storybook/addon-docs/node_modules/@mdx-js/react/lib/index.js"),dist=__webpack_require__("../../node_modules/@storybook/blocks/dist/index.mjs");function _createMdxContent(props){const _components={code:"code",h1:"h1",h2:"h2",p:"p",pre:"pre",...(0,lib.R)(),...props.components};return(0,jsx_runtime.jsxs)(jsx_runtime.Fragment,{children:[(0,jsx_runtime.jsx)(dist.W8,{title:"MDX|UsersIndicator",component:UsersIndicator}),"\n",(0,jsx_runtime.jsx)(_components.h1,{id:"usersindicator",children:"UsersIndicator"}),"\n",(0,jsx_runtime.jsx)(_components.p,{children:"A component that displays a set of user icons indicating which users are currently active. If there are too many users to display all the icons, it will collapse the icons into a single icon with a number indicating the number of additional users."}),"\n",(0,jsx_runtime.jsx)(_components.h2,{id:"usage",children:"Usage"}),"\n",(0,jsx_runtime.jsx)(_components.pre,{children:(0,jsx_runtime.jsx)(_components.code,{className:"language-tsx",children:"import { UsersIndicator } from '@grafana/ui';\n\nconst users = [\n  {\n    user: {\n      name: 'John Smith',\n      avatarUrl: 'https://example.com/avatar.png',\n    },\n    lastActiveAt: '2023-04-18T15:00:00.000Z',\n  },\n  {\n    user: {\n      name: 'Jane Doe',\n      avatarUrl: 'https://example.com/avatar.png',\n    },\n    lastActiveAt: '2023-04-17T10:00:00.000Z',\n  },\n  {\n    user: {\n      name: 'Bob Johnson',\n      avatarUrl: 'https://example.com/avatar.png',\n    },\n    lastActiveAt: '2023-04-16T08:00:00.000Z',\n  },\n];\n\nconst ExampleComponent = () => {\n  return (\n    <div>\n      <UsersIndicator users={users} limit={2} />\n    </div>\n  );\n};\n"})}),"\n",(0,jsx_runtime.jsx)(dist.ov,{of:UsersIndicator}),"\n",(0,jsx_runtime.jsx)(_components.h2,{id:"userview-type",children:"UserView type"}),"\n",(0,jsx_runtime.jsx)(_components.pre,{children:(0,jsx_runtime.jsx)(_components.code,{className:"language-tsx",children:"import { DateTimeInput } from '@grafana/data';\n\nexport interface UserView {\n  user: {\n    /** User's name, containing first + last name */\n    name: string;\n    /** URL to the user's avatar */\n    avatarUrl?: string;\n  };\n  /** Datetime string when the user was last active */\n  lastActiveAt: DateTimeInput;\n}\n"})})]})}function _define_property(obj,key,value){return key in obj?Object.defineProperty(obj,key,{value:value,enumerable:!0,configurable:!0,writable:!0}):obj[key]=value,obj}function _object_spread(target){for(var i=1;i<arguments.length;i++){var source=null!=arguments[i]?arguments[i]:{},ownKeys=Object.keys(source);"function"==typeof Object.getOwnPropertySymbols&&(ownKeys=ownKeys.concat(Object.getOwnPropertySymbols(source).filter((function(sym){return Object.getOwnPropertyDescriptor(source,sym).enumerable})))),ownKeys.forEach((function(key){_define_property(target,key,source[key])}))}return target}function _object_spread_props(target,source){return source=null!=source?source:{},Object.getOwnPropertyDescriptors?Object.defineProperties(target,Object.getOwnPropertyDescriptors(source)):function ownKeys(object,enumerableOnly){var keys=Object.keys(object);if(Object.getOwnPropertySymbols){var symbols=Object.getOwnPropertySymbols(object);enumerableOnly&&(symbols=symbols.filter((function(sym){return Object.getOwnPropertyDescriptor(object,sym).enumerable}))),keys.push.apply(keys,symbols)}return keys}(Object(source)).forEach((function(key){Object.defineProperty(target,key,Object.getOwnPropertyDescriptor(source,key))})),target}var meta={title:"General/UsersIndicator",component:UsersIndicator,argTypes:{limit:{control:{type:"number",min:1}}},parameters:{docs:{page:function MDXContent(props={}){const{wrapper:MDXLayout}={...(0,lib.R)(),...props.components};return MDXLayout?(0,jsx_runtime.jsx)(MDXLayout,{...props,children:(0,jsx_runtime.jsx)(_createMdxContent,{...props})}):_createMdxContent(props)}},knobs:{disabled:!0},controls:{exclude:["className","onClick"]},actions:{disabled:!0}},args:{onClick:void 0}},Basic=function(args){return react.createElement(UsersIndicator,_object_spread_props(_object_spread({},args),{users:[{name:"John Doe",avatarUrl:"https://picsum.photos/id/1/200/200"},{name:"Jane Smith",avatarUrl:""},{name:"Bob Johnson",avatarUrl:"https://picsum.photos/id/3/200/200"}].map((function(user){return{user:user,lastActiveAt:(new Date).toDateString()}}))}))};Basic.args={limit:4};var WithManyUsers=function(args){return react.createElement(UsersIndicator,_object_spread_props(_object_spread({},args),{users:[{name:"John Doe",avatarUrl:"https://picsum.photos/id/1/200/200"},{name:"Jane Smith",avatarUrl:""},{name:"Bob Johnson",avatarUrl:"https://picsum.photos/id/3/200/200"},{name:"John Smith",avatarUrl:"https://picsum.photos/id/1/200/200"},{name:"Jane Johnson",avatarUrl:""}].map((function(user){return{user:user,lastActiveAt:(new Date).toDateString()}}))}))};WithManyUsers.args={limit:4};var UsersIndicator_story=meta;Basic.parameters={...Basic.parameters,docs:{...Basic.parameters?.docs,source:{originalSource:"args => {\n  const users = [{\n    name: 'John Doe',\n    avatarUrl: 'https://picsum.photos/id/1/200/200'\n  }, {\n    name: 'Jane Smith',\n    avatarUrl: ''\n  }, {\n    name: 'Bob Johnson',\n    avatarUrl: 'https://picsum.photos/id/3/200/200'\n  }];\n  return <UsersIndicator {...args} users={users.map(user => ({\n    user,\n    lastActiveAt: new Date().toDateString()\n  }))} />;\n}",...Basic.parameters?.docs?.source}}},WithManyUsers.parameters={...WithManyUsers.parameters,docs:{...WithManyUsers.parameters?.docs,source:{originalSource:"args => {\n  const users = [{\n    name: 'John Doe',\n    avatarUrl: 'https://picsum.photos/id/1/200/200'\n  }, {\n    name: 'Jane Smith',\n    avatarUrl: ''\n  }, {\n    name: 'Bob Johnson',\n    avatarUrl: 'https://picsum.photos/id/3/200/200'\n  }, {\n    name: 'John Smith',\n    avatarUrl: 'https://picsum.photos/id/1/200/200'\n  }, {\n    name: 'Jane Johnson',\n    avatarUrl: ''\n  }];\n  return <UsersIndicator {...args} users={users.map(user => ({\n    user,\n    lastActiveAt: new Date().toDateString()\n  }))} />;\n}",...WithManyUsers.parameters?.docs?.source}}}}}]);