'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var css = require('@emotion/css');
var React = require('react');
var classNames = require('classnames');
var SVG = require('react-inlinesvg');
var data = require('@grafana/data');
var hoistNonReactStatics = require('hoist-non-react-statics');
var memoize = require('micro-memoize');
var react$1 = require('@floating-ui/react');
var e2eSelectors = require('@grafana/e2e-selectors');
var ReactDOM = require('react-dom');
var react = require('@emotion/react');
var tinycolor = require('tinycolor2');
var lodash = require('lodash');
var slate = require('slate');
var ansicolor = require('ansicolor');
var ReactSelect = require('react-select');
var ReactAsyncSelect = require('react-select/async');
var Creatable = require('react-select/creatable');
var Scrollbars = require('react-custom-scrollbars-2');
var reactTransitionGroup = require('react-transition-group');
var i18next = require('i18next');
var reactI18next = require('react-i18next');
var RCCascader = require('rc-cascader');
var useMeasure = require('react-use/lib/useMeasure');
var AsyncCreatable = require('react-select/async-creatable');
var reactWindow = require('react-window');
var focus = require('@react-aria/focus');
var reactColorful = require('react-colorful');
var reactUse = require('react-use');
var ReactDOMServer = require('react-dom/server');
var dateFns = require('date-fns');
var dialog = require('@react-aria/dialog');
var overlays = require('@react-aria/overlays');
var Calendar = require('react-calendar');
var uuid = require('uuid');
var RcTimePicker = require('rc-time-picker');
var reactTable = require('react-table');
var Skeleton = require('react-loading-skeleton');
var reactHookForm = require('react-hook-form');
var Plain = require('slate-plain-serializer');
var slateReact = require('slate-react');
var isHotkey = require('is-hotkey');
var Prism = require('prismjs');
var immutable = require('immutable');
var calculateSize = require('calculate-size');
var Highlighter = require('react-highlight-words');
var reactRouterDom = require('react-router-dom');
var rxjs = require('rxjs');
var operators = require('rxjs/operators');
var schema = require('@grafana/schema');
var uPlot = require('uplot');
var $ = require('jquery');
var usePrevious = require('react-use/lib/usePrevious');
var useClickAway = require('react-use/lib/useClickAway');
var faroWebSdk = require('@grafana/faro-web-sdk');
var RcDrawer = require('rc-drawer');
var SliderComponent = require('rc-slider');
var Tooltip$1 = require('rc-tooltip');
var reactDropzone = require('react-dropzone');
var WKT = require('ol/format/WKT');
var geom = require('ol/geom');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n["default"] = e;
  return Object.freeze(n);
}

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);
var React__namespace = /*#__PURE__*/_interopNamespace(React);
var classNames__default = /*#__PURE__*/_interopDefaultLegacy(classNames);
var SVG__default = /*#__PURE__*/_interopDefaultLegacy(SVG);
var hoistNonReactStatics__default = /*#__PURE__*/_interopDefaultLegacy(hoistNonReactStatics);
var memoize__default = /*#__PURE__*/_interopDefaultLegacy(memoize);
var ReactDOM__default = /*#__PURE__*/_interopDefaultLegacy(ReactDOM);
var tinycolor__default = /*#__PURE__*/_interopDefaultLegacy(tinycolor);
var ReactSelect__default = /*#__PURE__*/_interopDefaultLegacy(ReactSelect);
var ReactAsyncSelect__default = /*#__PURE__*/_interopDefaultLegacy(ReactAsyncSelect);
var Creatable__default = /*#__PURE__*/_interopDefaultLegacy(Creatable);
var Scrollbars__default = /*#__PURE__*/_interopDefaultLegacy(Scrollbars);
var i18next__default = /*#__PURE__*/_interopDefaultLegacy(i18next);
var RCCascader__default = /*#__PURE__*/_interopDefaultLegacy(RCCascader);
var useMeasure__default = /*#__PURE__*/_interopDefaultLegacy(useMeasure);
var AsyncCreatable__default = /*#__PURE__*/_interopDefaultLegacy(AsyncCreatable);
var ReactDOMServer__default = /*#__PURE__*/_interopDefaultLegacy(ReactDOMServer);
var Calendar__default = /*#__PURE__*/_interopDefaultLegacy(Calendar);
var RcTimePicker__default = /*#__PURE__*/_interopDefaultLegacy(RcTimePicker);
var Skeleton__default = /*#__PURE__*/_interopDefaultLegacy(Skeleton);
var Plain__default = /*#__PURE__*/_interopDefaultLegacy(Plain);
var Prism__default = /*#__PURE__*/_interopDefaultLegacy(Prism);
var calculateSize__default = /*#__PURE__*/_interopDefaultLegacy(calculateSize);
var Highlighter__default = /*#__PURE__*/_interopDefaultLegacy(Highlighter);
var uPlot__default = /*#__PURE__*/_interopDefaultLegacy(uPlot);
var $__default = /*#__PURE__*/_interopDefaultLegacy($);
var usePrevious__default = /*#__PURE__*/_interopDefaultLegacy(usePrevious);
var useClickAway__default = /*#__PURE__*/_interopDefaultLegacy(useClickAway);
var RcDrawer__default = /*#__PURE__*/_interopDefaultLegacy(RcDrawer);
var SliderComponent__default = /*#__PURE__*/_interopDefaultLegacy(SliderComponent);
var Tooltip__default = /*#__PURE__*/_interopDefaultLegacy(Tooltip$1);
var WKT__default = /*#__PURE__*/_interopDefaultLegacy(WKT);

function stylesFactory(stylesCreator) {
  return memoize__default["default"](stylesCreator);
}

var __defProp$33 = Object.defineProperty;
var __defProps$1Q = Object.defineProperties;
var __getOwnPropDescs$1Q = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2O = Object.getOwnPropertySymbols;
var __hasOwnProp$2O = Object.prototype.hasOwnProperty;
var __propIsEnum$2O = Object.prototype.propertyIsEnumerable;
var __defNormalProp$33 = (obj, key, value) => key in obj ? __defProp$33(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2M = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2O.call(b, prop))
      __defNormalProp$33(a, prop, b[prop]);
  if (__getOwnPropSymbols$2O)
    for (var prop of __getOwnPropSymbols$2O(b)) {
      if (__propIsEnum$2O.call(b, prop))
        __defNormalProp$33(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1Q = (a, b) => __defProps$1Q(a, __getOwnPropDescs$1Q(b));
let ThemeContextMock = null;
const memoizedStyleCreators = /* @__PURE__ */ new WeakMap();
const withTheme = (Component) => {
  const WithTheme = (props) => {
    const ContextComponent = ThemeContextMock || data.ThemeContext;
    return (
      // @ts-ignore
      /* @__PURE__ */ React__default["default"].createElement(ContextComponent.Consumer, null, (theme) => /* @__PURE__ */ React__default["default"].createElement(Component, __spreadProps$1Q(__spreadValues$2M({}, props), { theme: theme.v1 })))
    );
  };
  WithTheme.displayName = `WithTheme(${Component.displayName})`;
  hoistNonReactStatics__default["default"](WithTheme, Component);
  return WithTheme;
};
const withTheme2 = (Component) => {
  const WithTheme = (props) => {
    const ContextComponent = ThemeContextMock || data.ThemeContext;
    return (
      // @ts-ignore
      /* @__PURE__ */ React__default["default"].createElement(ContextComponent.Consumer, null, (theme) => /* @__PURE__ */ React__default["default"].createElement(Component, __spreadProps$1Q(__spreadValues$2M({}, props), { theme })))
    );
  };
  WithTheme.displayName = `WithTheme(${Component.displayName})`;
  hoistNonReactStatics__default["default"](WithTheme, Component);
  return WithTheme;
};
function useTheme() {
  return React.useContext(ThemeContextMock || data.ThemeContext).v1;
}
function useTheme2() {
  return React.useContext(ThemeContextMock || data.ThemeContext);
}
function useStyles(getStyles) {
  const theme = useTheme();
  let memoizedStyleCreator = memoizedStyleCreators.get(getStyles);
  if (!memoizedStyleCreator) {
    memoizedStyleCreator = stylesFactory(getStyles);
    memoizedStyleCreators.set(getStyles, memoizedStyleCreator);
  }
  return memoizedStyleCreator(theme);
}
function useStyles2(getStyles, ...additionalArguments) {
  const theme = useTheme2();
  let memoizedStyleCreator = memoizedStyleCreators.get(getStyles);
  if (!memoizedStyleCreator) {
    memoizedStyleCreator = memoize__default["default"](getStyles, { maxSize: 10 });
    memoizedStyleCreators.set(getStyles, memoizedStyleCreator);
  }
  return memoizedStyleCreator(theme, ...additionalArguments);
}
const mockThemeContext = (theme) => {
  ThemeContextMock = React__default["default"].createContext(theme);
  return () => {
    ThemeContextMock = null;
  };
};

const alwaysMonoIcons = [
  "grafana",
  "favorite",
  "heart-break",
  "heart",
  "panel-add",
  "library-panel",
  "circle-mono"
];
function getIconSubDir(name, type) {
  if (name == null ? void 0 : name.startsWith("gf-")) {
    return "custom";
  } else if (alwaysMonoIcons.includes(name)) {
    return "mono";
  } else if (type === "default") {
    return "unicons";
  } else if (type === "solid") {
    return "solid";
  } else {
    return "mono";
  }
}
function getSvgSize(size) {
  switch (size) {
    case "xs":
      return 12;
    case "sm":
      return 14;
    case "md":
      return 16;
    case "lg":
      return 18;
    case "xl":
      return 24;
    case "xxl":
      return 36;
    case "xxxl":
      return 48;
  }
}
let iconRoot;
function getIconRoot() {
  if (iconRoot) {
    return iconRoot;
  }
  const grafanaPublicPath = typeof window !== "undefined" && window.__grafana_public_path__;
  if (grafanaPublicPath) {
    iconRoot = grafanaPublicPath + "img/icons/";
  } else {
    iconRoot = "public/img/icons/";
  }
  return iconRoot;
}

var __defProp$32 = Object.defineProperty;
var __getOwnPropSymbols$2N = Object.getOwnPropertySymbols;
var __hasOwnProp$2N = Object.prototype.hasOwnProperty;
var __propIsEnum$2N = Object.prototype.propertyIsEnumerable;
var __defNormalProp$32 = (obj, key, value) => key in obj ? __defProp$32(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2L = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2N.call(b, prop))
      __defNormalProp$32(a, prop, b[prop]);
  if (__getOwnPropSymbols$2N)
    for (var prop of __getOwnPropSymbols$2N(b)) {
      if (__propIsEnum$2N.call(b, prop))
        __defNormalProp$32(a, prop, b[prop]);
    }
  return a;
};
var __objRest$1k = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2N.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2N)
    for (var prop of __getOwnPropSymbols$2N(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2N.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const getIconStyles = (theme) => {
  return {
    icon: css.css({
      display: "inline-block",
      fill: "currentColor",
      flexShrink: 0,
      label: "Icon",
      // line-height: 0; is needed for correct icon alignment in Safari
      lineHeight: 0,
      verticalAlign: "middle"
    }),
    orange: css.css({
      fill: theme.v1.palette.orange
    })
  };
};
const Icon = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, { size = "md", type = "default", name, className, style, title = "" } = _b, rest = __objRest$1k(_b, ["size", "type", "name", "className", "style", "title"]);
    const styles = useStyles2(getIconStyles);
    if (!data.isIconName(name)) {
      console.warn("Icon component passed an invalid icon name", name);
    }
    const iconName = name === "fa fa-spinner" ? "spinner" : name;
    const iconRoot = getIconRoot();
    const svgSize = getSvgSize(size);
    const svgHgt = svgSize;
    const svgWid = name.startsWith("gf-bar-align") ? 16 : name.startsWith("gf-interp") ? 30 : svgSize;
    const subDir = getIconSubDir(iconName, type);
    const svgPath = `${iconRoot}${subDir}/${iconName}.svg`;
    const composedClassName = css.cx(
      styles.icon,
      className,
      type === "mono" ? { [styles.orange]: name === "favorite" } : "",
      iconName === "spinner" && "fa-spin"
    );
    return /* @__PURE__ */ React__default["default"].createElement(
      SVG__default["default"],
      __spreadValues$2L({
        innerRef: ref,
        src: svgPath,
        width: svgWid,
        height: svgHgt,
        title,
        className: composedClassName,
        style
      }, rest)
    );
  }
);
Icon.displayName = "Icon";

function getPlacement(placement) {
  switch (placement) {
    case "auto":
      return "bottom";
    case "auto-start":
      return "bottom-start";
    case "auto-end":
      return "bottom-end";
    default:
      return placement != null ? placement : "bottom";
  }
}
function buildTooltipTheme(theme, tooltipBg, toggletipBorder, tooltipText, tooltipPadding) {
  return {
    arrow: css.css({
      fill: tooltipBg
    }),
    container: css.css({
      backgroundColor: tooltipBg,
      borderRadius: theme.shape.radius.default,
      border: `1px solid ${toggletipBorder}`,
      boxShadow: theme.shadows.z2,
      color: tooltipText,
      fontSize: theme.typography.bodySmall.fontSize,
      padding: theme.spacing(tooltipPadding.topBottom, tooltipPadding.rightLeft),
      transition: "opacity 0.3s",
      zIndex: theme.zIndex.tooltip,
      maxWidth: "400px",
      overflowWrap: "break-word",
      "&[data-popper-interactive='false']": {
        pointerEvents: "none"
      }
    }),
    headerClose: css.css({
      color: theme.colors.text.secondary,
      position: "absolute",
      right: theme.spacing(1),
      top: theme.spacing(1.5),
      backgroundColor: "transparent",
      border: 0
    }),
    header: css.css({
      paddingTop: theme.spacing(1),
      paddingBottom: theme.spacing(2)
    }),
    body: css.css({
      paddingTop: theme.spacing(1),
      paddingBottom: theme.spacing(1)
    }),
    footer: css.css({
      paddingTop: theme.spacing(2),
      paddingBottom: theme.spacing(1)
    })
  };
}

let themeMock;
const getTheme = (mode = "dark") => {
  if (themeMock) {
    return themeMock(mode);
  }
  return data.createTheme({ colors: { mode } }).v1;
};
const mockTheme = (mock) => {
  themeMock = mock;
  return () => {
    themeMock = null;
  };
};

function getAgularPanelStyles(theme) {
  return react.css({
    ".panel-options-group": {
      borderBottom: `1px solid ${theme.colors.border.weak}`
    },
    ".panel-options-group__header": {
      padding: theme.spacing(1, 2, 1, 1),
      position: "relative",
      display: "flex",
      alignItems: "center",
      cursor: "pointer",
      fontWeight: 500,
      color: theme.colors.text.primary,
      "&:hover": {
        background: theme.colors.emphasize(theme.colors.background.primary, 0.03)
      }
    },
    ".panel-options-group__icon": {
      color: theme.colors.text.secondary,
      marginRight: theme.spacing(1),
      padding: theme.spacing(0, 0.9, 0, 0.6)
    },
    ".panel-options-group__title": {
      position: "relative"
    },
    ".panel-options-group__body": {
      padding: theme.spacing(1, 2, 1, 4)
    }
  });
}

function getCardStyles$1(theme) {
  return react.css({
    ".card-section": {
      marginBottom: theme.spacing(4)
    },
    ".card-list": {
      display: "flex",
      flexDirection: "row",
      flexWrap: "wrap",
      listStyleType: "none"
    },
    ".card-item": {
      display: "block",
      height: "100%",
      background: theme.colors.background.secondary,
      boxShadow: "none",
      padding: theme.spacing(2),
      borderRadius: "4px",
      "&:hover": {
        background: theme.colors.emphasize(theme.colors.background.secondary, 0.03)
      },
      ".label-tag": {
        marginLeft: theme.spacing(1),
        fontSize: "11px",
        padding: "2px 6px"
      }
    },
    ".card-item-body": {
      display: "flex",
      overflow: "hidden"
    },
    ".card-item-details": {
      overflow: "hidden"
    },
    ".card-item-header": {
      marginBottom: theme.spacing(2)
    },
    ".card-item-type": {
      color: theme.colors.text.secondary,
      textTransform: "uppercase",
      fontSize: theme.typography.size.sm,
      fontWeight: theme.typography.fontWeightMedium
    },
    ".card-item-badge": {
      margin: "6px 0"
    },
    ".card-item-notice": {
      fontSize: theme.typography.size.sm
    },
    ".card-item-name": {
      color: theme.colors.text.primary,
      overflow: "hidden",
      textOverflow: "ellipsis",
      width: "100%"
    },
    ".card-item-label": {
      marginLeft: theme.spacing(1)
    },
    ".card-item-sub-name": {
      color: theme.colors.text.secondary,
      overflow: "hidden",
      textOverflow: "ellipsis",
      width: "100%"
    },
    ".card-item-sub-name--header": {
      color: theme.colors.text.secondary,
      textTransform: "uppercase",
      marginBottom: theme.spacing(2),
      fontSize: theme.typography.size.sm,
      fontWeight: "bold"
    },
    ".card-list-layout-grid": {
      ".card-item-type": {
        display: "inline-block"
      },
      ".card-item-notice": {
        fontSize: theme.typography.size.sm,
        display: "inline-block",
        marginLeft: theme.spacing(2)
      },
      ".card-item-header-action": {
        float: "right"
      },
      ".card-item-wrapper": {
        width: "100%",
        padding: theme.spacing(0, 2, 2, 0)
      },
      ".card-item-wrapper--clickable": {
        cursor: "pointer"
      },
      ".card-item-figure": {
        margin: theme.spacing(0, 2, 2, 0),
        height: "80px",
        img: {
          width: "80px"
        }
      },
      ".card-item-name": {
        fontSize: theme.typography.h3.fontSize
      },
      [theme.breakpoints.up("md")]: {
        ".card-item-wrapper": {
          width: "50%"
        }
      },
      [theme.breakpoints.up("lg")]: {
        ".card-item-wrapper": {
          width: "33.333333%"
        }
      },
      "&.card-list-layout-grid--max-2-col": {
        [theme.breakpoints.up("lg")]: {
          ".card-item-wrapper": {
            width: "50%"
          }
        }
      }
    },
    ".card-list-layout-list": {
      ".card-item-wrapper": {
        padding: 0,
        width: "100%",
        marginBottom: theme.spacing(1)
      },
      ".card-item-wrapper--clickable": {
        cursor: "pointer"
      },
      ".card-item": {
        borderRadius: "2px"
      },
      ".card-item-header": {
        float: "right",
        textAlign: "right"
      },
      ".card-item-figure": {
        margin: theme.spacing(0, 2, 0, 0),
        img: {
          width: "48px"
        }
      },
      ".card-item-name": {
        fontSize: theme.typography.h4.fontSize
      },
      ".card-item-sub-name": {
        fontSize: theme.typography.size.sm
      },
      ".layout-selector": {
        marginRight: 0
      }
    }
  });
}

function cardChrome(theme) {
  return `
    background: ${theme.colors.background.secondary};
    &:hover {
      background: ${hoverColor(theme.colors.background.secondary, theme)};
    }
    box-shadow: ${theme.components.panel.boxShadow};
    border-radius: ${theme.shape.radius.default};
`;
}
function hoverColor(color, theme) {
  return theme.isDark ? tinycolor__default["default"](color).brighten(2).toString() : tinycolor__default["default"](color).darken(2).toString();
}
function listItem(theme) {
  return `
  background: ${theme.colors.background.secondary};
  &:hover {
    background: ${hoverColor(theme.colors.background.secondary, theme)};
  }
  box-shadow: ${theme.components.panel.boxShadow};
  border-radius: ${theme.shape.radius.default};
`;
}
function listItemSelected(theme) {
  return `
    background: ${hoverColor(theme.colors.background.secondary, theme)};
    color: ${theme.colors.text.maxContrast};
`;
}
function mediaUp(breakpoint) {
  return `only screen and (min-width: ${breakpoint})`;
}
const isGrafanaTheme2 = (theme) => theme.hasOwnProperty("v1");
const focusCss = (theme) => {
  const isTheme2 = isGrafanaTheme2(theme);
  const firstColor = isTheme2 ? theme.colors.background.canvas : theme.colors.bodyBg;
  const secondColor = isTheme2 ? theme.colors.primary.main : theme.colors.formFocusOutline;
  return `
  outline: 2px dotted transparent;
  outline-offset: 2px;
  box-shadow: 0 0 0 2px ${firstColor}, 0 0 0px 4px ${secondColor};
  transition-property: outline, outline-offset, box-shadow;
  transition-duration: 0.2s;
  transition-timing-function: cubic-bezier(0.19, 1, 0.22, 1);`;
};
function getMouseFocusStyles(theme) {
  return {
    outline: "none",
    boxShadow: `none`
  };
}
function getFocusStyles(theme) {
  return {
    outline: "2px dotted transparent",
    outlineOffset: "2px",
    boxShadow: `0 0 0 2px ${theme.colors.background.canvas}, 0 0 0px 4px ${theme.colors.primary.main}`,
    transitionTimingFunction: `cubic-bezier(0.19, 1, 0.22, 1)`,
    transitionDuration: "0.2s",
    transitionProperty: "outline, outline-offset, box-shadow"
  };
}
const getTooltipContainerStyles = (theme) => ({
  overflow: "hidden",
  background: theme.colors.background.secondary,
  boxShadow: theme.shadows.z2,
  maxWidth: "800px",
  padding: theme.spacing(1),
  borderRadius: theme.shape.radius.default,
  zIndex: theme.zIndex.tooltip
});

var mixins = /*#__PURE__*/Object.freeze({
  __proto__: null,
  cardChrome: cardChrome,
  hoverColor: hoverColor,
  listItem: listItem,
  listItemSelected: listItemSelected,
  mediaUp: mediaUp,
  focusCss: focusCss,
  getMouseFocusStyles: getMouseFocusStyles,
  getFocusStyles: getFocusStyles,
  getTooltipContainerStyles: getTooltipContainerStyles
});

var __defProp$31 = Object.defineProperty;
var __getOwnPropSymbols$2M = Object.getOwnPropertySymbols;
var __hasOwnProp$2M = Object.prototype.hasOwnProperty;
var __propIsEnum$2M = Object.prototype.propertyIsEnumerable;
var __defNormalProp$31 = (obj, key, value) => key in obj ? __defProp$31(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2K = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2M.call(b, prop))
      __defNormalProp$31(a, prop, b[prop]);
  if (__getOwnPropSymbols$2M)
    for (var prop of __getOwnPropSymbols$2M(b)) {
      if (__propIsEnum$2M.call(b, prop))
        __defNormalProp$31(a, prop, b[prop]);
    }
  return a;
};
function getElementStyles(theme) {
  return react.css({
    html: {
      MsOverflowStyle: "scrollbar",
      WebkitTapHighlightColor: "rgba(0, 0, 0, 0)",
      height: "100%",
      fontSize: `${theme.typography.htmlFontSize}px`,
      fontFamily: theme.typography.fontFamily,
      lineHeight: theme.typography.body.lineHeight,
      fontKerning: "normal"
    },
    ":root": {
      colorScheme: theme.colors.mode
    },
    body: __spreadValues$2K({
      height: "100%",
      width: "100%",
      position: "absolute",
      color: theme.colors.text.primary,
      backgroundColor: theme.colors.background.canvas
    }, getVariantStyles(theme.typography.body)),
    "h1, .h1": getVariantStyles(theme.typography.h1),
    "h2, .h2": getVariantStyles(theme.typography.h2),
    "h3, .h3": getVariantStyles(theme.typography.h3),
    "h4, .h4": getVariantStyles(theme.typography.h4),
    "h5, .h5": getVariantStyles(theme.typography.h5),
    "h6, .h6": getVariantStyles(theme.typography.h6),
    p: {
      margin: theme.spacing(0, 0, 2)
    },
    button: {
      letterSpacing: theme.typography.body.letterSpacing,
      "&:focus-visible": getFocusStyles(theme),
      "&:focus": {
        outline: "none"
      }
    },
    // Ex: 14px base font * 85% = about 12px
    small: {
      fontSize: theme.typography.bodySmall.fontSize
    },
    "b, strong": {
      fontWeight: theme.typography.fontWeightMedium
    },
    em: {
      fontStyle: "italic",
      color: theme.colors.text.primary
    },
    cite: {
      fontStyle: "normal"
    },
    // Utility classes
    ".muted": {
      color: theme.colors.text.secondary
    },
    "a.muted:hover, a.muted:focus": {
      color: theme.colors.text.primary
    },
    ".text-warning": {
      color: theme.colors.warning.text,
      "&:hover, &:focus": {
        color: theme.colors.emphasize(theme.colors.warning.text, 0.15)
      }
    },
    ".text-error": {
      color: theme.colors.error.text,
      "&:hover, &:focus": {
        color: theme.colors.emphasize(theme.colors.error.text, 0.15)
      }
    },
    ".text-success": {
      color: "$success-text-color",
      "&:hover, &:focus": {
        color: theme.colors.emphasize(theme.colors.success.text, 0.15)
      }
    },
    a: {
      cursor: "pointer",
      color: theme.colors.text.primary,
      textDecoration: "none",
      "&:focus": {
        outline: "none"
      },
      "&:focus-visible": getFocusStyles(theme),
      "&:[disabled]": {
        cursor: "default",
        // Need type assertion here due to the use of !important
        // see https://github.com/frenic/csstype/issues/114#issuecomment-697201978
        // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
        pointerEvents: "none !important"
      }
    },
    ".text-link": {
      textDecoration: "underline"
    },
    ".text-left": {
      textAlign: "left"
    },
    ".text-right": {
      textAlign: "right"
    },
    ".text-center": {
      textAlign: "center"
    },
    ".highlight-search-match": {
      background: theme.components.textHighlight.background,
      color: theme.components.textHighlight.text,
      padding: 0
    }
  });
}
function getVariantStyles(variant) {
  return {
    margin: 0,
    fontSize: variant.fontSize,
    lineHeight: variant.lineHeight,
    fontWeight: variant.fontWeight,
    letterSpacing: variant.letterSpacing,
    fontFamily: variant.fontFamily,
    marginBottom: "0.45em"
  };
}

function getExtraStyles(theme) {
  return react.css({
    // fix white background on intercom in dark mode
    "iframe.intercom-borderless-frame": {
      colorScheme: theme.colors.mode
    }
  });
}

function getFormElementStyles(theme) {
  return react.css({
    "input, button, select, textarea": {
      fontFamily: theme.typography.body.fontFamily,
      fontSize: theme.typography.body.fontSize,
      fontWeight: theme.typography.body.fontWeight,
      lineHeight: theme.typography.body.lineHeight
    },
    "input, select": {
      backgroundColor: theme.components.input.background,
      color: theme.components.input.text,
      border: "none",
      boxShadow: "none"
    },
    textarea: {
      height: "auto"
    },
    // Reset width of input images, buttons, radios, checkboxes
    "input[type='file'], input[type='image'], input[type='submit'], input[type='reset'], input[type='button'], input[type='radio'], input[type='checkbox']": {
      width: "auto"
      // Override of generic input selector
    }
  });
}

function getMarkdownStyles(theme) {
  return react.css({
    // TODO copy from _utils.scss
  });
}

function getPageStyles(theme) {
  const maxWidthBreakpoint = theme.breakpoints.values.xxl + theme.spacing.gridSize * 2 + theme.components.sidemenu.width;
  return react.css({
    ".grafana-app": {
      display: "flex",
      alignItems: "stretch",
      position: "absolute",
      width: "100%",
      height: "100%",
      top: 0,
      left: 0
    },
    ".main-view": {
      position: "relative",
      display: "flex",
      flexDirection: "column",
      flexGrow: 1,
      height: "100%",
      flex: "1 1 0",
      minWidth: 0
    },
    ".page-scrollbar-content": {
      display: "flex",
      minHeight: "100%",
      flexDirection: "column",
      width: "100%",
      height: "100%"
    },
    ".page-container": {
      flexGrow: 1,
      flexBasis: "100%",
      paddingLeft: theme.spacing(2),
      paddingRight: theme.spacing(2),
      [theme.breakpoints.up("sm")]: {
        margin: theme.spacing(0, 1)
      },
      [theme.breakpoints.up("md")]: {
        margin: theme.spacing(0, 2)
      },
      [`@media (min-width: ${maxWidthBreakpoint}px)`]: {
        maxWidth: `${theme.breakpoints.values.xxl}px`,
        marginLeft: "auto",
        marginRight: "auto",
        width: "100%"
      }
    },
    ".page-full": {
      marginLeft: theme.spacing(2),
      paddingLeft: theme.spacing(2),
      paddingRight: theme.spacing(2)
    },
    ".page-body": {
      padding: theme.spacing(1),
      background: theme.components.panel.background,
      border: `1px solid ${theme.components.panel.borderColor}`,
      marginBottom: "32px",
      [theme.breakpoints.up("md")]: {
        padding: theme.spacing(2)
      },
      [theme.breakpoints.up("lg")]: {
        padding: theme.spacing(3)
      }
    },
    ".page-heading": {
      fontSize: theme.typography.h4.fontSize,
      marginTop: 0,
      marginBottom: theme.spacing(2)
    },
    ".page-action-bar": {
      marginBottom: theme.spacing(2),
      display: "flex",
      alignItems: "flex-start",
      gap: theme.spacing(2)
    },
    ".page-action-bar--narrow": {
      marginBottom: 0
    },
    ".page-action-bar__spacer": {
      width: theme.spacing(2),
      flexGrow: 1
    },
    ".page-sub-heading": {
      marginBottom: theme.spacing(2)
    },
    ".page-sub-heading-icon": {
      marginLeft: theme.spacing(1),
      marginTop: theme.spacing(0.5)
    },
    ".page-hidden": {
      display: "none"
    }
  });
}

var __defProp$30 = Object.defineProperty;
var __defProps$1P = Object.defineProperties;
var __getOwnPropDescs$1P = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2L = Object.getOwnPropertySymbols;
var __hasOwnProp$2L = Object.prototype.hasOwnProperty;
var __propIsEnum$2L = Object.prototype.propertyIsEnumerable;
var __defNormalProp$30 = (obj, key, value) => key in obj ? __defProp$30(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2J = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2L.call(b, prop))
      __defNormalProp$30(a, prop, b[prop]);
  if (__getOwnPropSymbols$2L)
    for (var prop of __getOwnPropSymbols$2L(b)) {
      if (__propIsEnum$2L.call(b, prop))
        __defNormalProp$30(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1P = (a, b) => __defProps$1P(a, __getOwnPropDescs$1P(b));
const fadeIn = css.keyframes({
  "0%": {
    opacity: 0
  },
  "100%": {
    opacity: 1
  }
});
const skeletonAnimation = {
  animationName: fadeIn,
  animationDelay: "100ms",
  animationTimingFunction: "ease-in",
  animationDuration: "100ms",
  animationFillMode: "backwards"
};
const attachSkeleton = (Component, Skeleton) => {
  const skeletonWrapper = (props) => {
    return /* @__PURE__ */ React__default["default"].createElement(
      Skeleton,
      __spreadProps$1P(__spreadValues$2J({}, props), {
        rootProps: {
          style: skeletonAnimation
        }
      })
    );
  };
  return Object.assign(Component, { Skeleton: skeletonWrapper });
};

const getSkeletonStyles$3 = (theme) => {
  return react.css({
    ".react-loading-skeleton": skeletonAnimation
  });
};

function GlobalStyles() {
  const theme = useTheme2();
  return /* @__PURE__ */ React__default["default"].createElement(
    react.Global,
    {
      styles: [
        getElementStyles(theme),
        getExtraStyles(theme),
        getFormElementStyles(theme),
        getPageStyles(theme),
        getCardStyles$1(theme),
        getAgularPanelStyles(theme),
        getMarkdownStyles(),
        getSkeletonStyles$3()
      ]
    }
  );
}

var __defProp$2$ = Object.defineProperty;
var __defProps$1O = Object.defineProperties;
var __getOwnPropDescs$1O = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2K = Object.getOwnPropertySymbols;
var __hasOwnProp$2K = Object.prototype.hasOwnProperty;
var __propIsEnum$2K = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2$ = (obj, key, value) => key in obj ? __defProp$2$(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2I = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2K.call(b, prop))
      __defNormalProp$2$(a, prop, b[prop]);
  if (__getOwnPropSymbols$2K)
    for (var prop of __getOwnPropSymbols$2K(b)) {
      if (__propIsEnum$2K.call(b, prop))
        __defNormalProp$2$(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1O = (a, b) => __defProps$1O(a, __getOwnPropDescs$1O(b));
function Portal$1(props) {
  const { children, className, root, forwardedRef } = props;
  const theme = useTheme2();
  const node = React.useRef(null);
  const portalRoot = root != null ? root : getPortalContainer();
  if (!node.current) {
    node.current = document.createElement("div");
    if (className) {
      node.current.className = className;
    }
    node.current.style.position = "relative";
    node.current.style.zIndex = `${theme.zIndex.portal}`;
  }
  React.useLayoutEffect(() => {
    if (node.current) {
      portalRoot.appendChild(node.current);
    }
    return () => {
      if (node.current) {
        portalRoot.removeChild(node.current);
      }
    };
  }, [portalRoot]);
  return ReactDOM__default["default"].createPortal(/* @__PURE__ */ React__default["default"].createElement("div", { ref: forwardedRef }, children), node.current);
}
function getPortalContainer() {
  var _a;
  return (_a = window.document.getElementById("grafana-portal-container")) != null ? _a : document.body;
}
function PortalContainer() {
  return /* @__PURE__ */ React__default["default"].createElement("div", { id: "grafana-portal-container" });
}
const RefForwardingPortal = React__default["default"].forwardRef((props, ref) => {
  return /* @__PURE__ */ React__default["default"].createElement(Portal$1, __spreadProps$1O(__spreadValues$2I({}, props), { forwardedRef: ref }));
});
RefForwardingPortal.displayName = "RefForwardingPortal";

var __defProp$2_ = Object.defineProperty;
var __getOwnPropSymbols$2J = Object.getOwnPropertySymbols;
var __hasOwnProp$2J = Object.prototype.hasOwnProperty;
var __propIsEnum$2J = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2_ = (obj, key, value) => key in obj ? __defProp$2_(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2H = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2J.call(b, prop))
      __defNormalProp$2_(a, prop, b[prop]);
  if (__getOwnPropSymbols$2J)
    for (var prop of __getOwnPropSymbols$2J(b)) {
      if (__propIsEnum$2J.call(b, prop))
        __defNormalProp$2_(a, prop, b[prop]);
    }
  return a;
};
const Tooltip = React__default["default"].forwardRef(
  ({ children, theme, interactive, show, placement, content }, forwardedRef) => {
    const arrowRef = React.useRef(null);
    const [controlledVisible, setControlledVisible] = React.useState(show);
    const isOpen = show != null ? show : controlledVisible;
    const middleware = [
      react$1.offset(8),
      react$1.flip({
        fallbackAxisSideDirection: "end",
        // see https://floating-ui.com/docs/flip#combining-with-shift
        crossAxis: false,
        boundary: document.body
      }),
      react$1.shift(),
      react$1.arrow({
        element: arrowRef
      })
    ];
    const { context, refs, floatingStyles } = react$1.useFloating({
      open: isOpen,
      placement: getPlacement(placement),
      onOpenChange: setControlledVisible,
      middleware,
      whileElementsMounted: react$1.autoUpdate
    });
    const tooltipId = React.useId();
    const hover = react$1.useHover(context, {
      delay: {
        close: interactive ? 100 : 0
      },
      move: false
    });
    const focus = react$1.useFocus(context);
    const dismiss = react$1.useDismiss(context);
    const { getReferenceProps, getFloatingProps } = react$1.useInteractions([dismiss, hover, focus]);
    const contentIsFunction = typeof content === "function";
    const styles = useStyles2(getStyles$23);
    const style = styles[theme != null ? theme : "info"];
    const handleRef = React.useCallback(
      (ref) => {
        refs.setReference(ref);
        if (typeof forwardedRef === "function") {
          forwardedRef(ref);
        } else if (forwardedRef) {
          forwardedRef.current = ref;
        }
      },
      [forwardedRef, refs]
    );
    const childHasMatchingAriaLabel = "aria-label" in children.props && children.props["aria-label"] === content;
    return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, React__default["default"].cloneElement(children, __spreadValues$2H({
      ref: handleRef,
      tabIndex: 0,
      // tooltip trigger should be keyboard focusable
      "aria-describedby": !childHasMatchingAriaLabel && isOpen ? tooltipId : void 0
    }, getReferenceProps())), isOpen && /* @__PURE__ */ React__default["default"].createElement(Portal$1, null, /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$2H({ ref: refs.setFloating, style: floatingStyles }, getFloatingProps()), /* @__PURE__ */ React__default["default"].createElement(react$1.FloatingArrow, { className: style.arrow, ref: arrowRef, context }), /* @__PURE__ */ React__default["default"].createElement(
      "div",
      {
        "data-testid": e2eSelectors.selectors.components.Tooltip.container,
        id: tooltipId,
        role: "tooltip",
        className: style.container
      },
      typeof content === "string" && content,
      React__default["default"].isValidElement(content) && React__default["default"].cloneElement(content),
      contentIsFunction && content({})
    ))));
  }
);
Tooltip.displayName = "Tooltip";
const getStyles$23 = (theme) => {
  const info = buildTooltipTheme(
    theme,
    theme.components.tooltip.background,
    theme.components.tooltip.background,
    theme.components.tooltip.text,
    { topBottom: 0.5, rightLeft: 1 }
  );
  const error = buildTooltipTheme(
    theme,
    theme.colors.error.main,
    theme.colors.error.main,
    theme.colors.error.contrastText,
    { topBottom: 0.5, rightLeft: 1 }
  );
  return {
    info,
    ["info-alt"]: info,
    error
  };
};

var __defProp$2Z = Object.defineProperty;
var __defNormalProp$2Z = (obj, key, value) => key in obj ? __defProp$2Z(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$v = (obj, key, value) => {
  __defNormalProp$2Z(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
class PopoverController extends React.Component {
  constructor() {
    super(...arguments);
    __publicField$v(this, "hideTimeout", null);
    __publicField$v(this, "state", { show: false });
    __publicField$v(this, "showPopper", () => {
      if (this.hideTimeout) {
        clearTimeout(this.hideTimeout);
      }
      this.setState({ show: true });
    });
    __publicField$v(this, "hidePopper", () => {
      this.hideTimeout = setTimeout(() => {
        this.setState({ show: false });
      }, this.props.hideAfter);
    });
  }
  render() {
    const { children, content, placement = "auto" } = this.props;
    const { show } = this.state;
    return children(this.showPopper, this.hidePopper, {
      show,
      placement,
      content
    });
  }
}

var __defProp$2Y = Object.defineProperty;
var __defProps$1N = Object.defineProperties;
var __getOwnPropDescs$1N = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2I = Object.getOwnPropertySymbols;
var __hasOwnProp$2I = Object.prototype.hasOwnProperty;
var __propIsEnum$2I = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2Y = (obj, key, value) => key in obj ? __defProp$2Y(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2G = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2I.call(b, prop))
      __defNormalProp$2Y(a, prop, b[prop]);
  if (__getOwnPropSymbols$2I)
    for (var prop of __getOwnPropSymbols$2I(b)) {
      if (__propIsEnum$2I.call(b, prop))
        __defNormalProp$2Y(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1N = (a, b) => __defProps$1N(a, __getOwnPropDescs$1N(b));
var __objRest$1j = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2I.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2I)
    for (var prop of __getOwnPropSymbols$2I(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2I.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const FormLabel = (_a) => {
  var _b = _a, {
    children,
    isFocused,
    isInvalid,
    className,
    htmlFor,
    tooltip,
    width,
    interactive
  } = _b, rest = __objRest$1j(_b, [
    "children",
    "isFocused",
    "isInvalid",
    "className",
    "htmlFor",
    "tooltip",
    "width",
    "interactive"
  ]);
  const classes = classNames__default["default"](className, `gf-form-label width-${width ? width : "10"}`, {
    "gf-form-label--is-focused": isFocused,
    "gf-form-label--is-invalid": isInvalid
  });
  return /* @__PURE__ */ React__default["default"].createElement("label", __spreadProps$1N(__spreadValues$2G({ className: classes }, rest), { htmlFor }), children, tooltip && /* @__PURE__ */ React__default["default"].createElement(Tooltip, { placement: "top", content: tooltip, theme: "info", interactive }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "info-circle", size: "sm", style: { marginLeft: "10px" } })));
};
const InlineFormLabel = FormLabel;

var __defProp$2X = Object.defineProperty;
var __defProps$1M = Object.defineProperties;
var __getOwnPropDescs$1M = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2H = Object.getOwnPropertySymbols;
var __hasOwnProp$2H = Object.prototype.hasOwnProperty;
var __propIsEnum$2H = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2X = (obj, key, value) => key in obj ? __defProp$2X(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2F = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2H.call(b, prop))
      __defNormalProp$2X(a, prop, b[prop]);
  if (__getOwnPropSymbols$2H)
    for (var prop of __getOwnPropSymbols$2H(b)) {
      if (__propIsEnum$2H.call(b, prop))
        __defNormalProp$2X(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1M = (a, b) => __defProps$1M(a, __getOwnPropDescs$1M(b));
var __objRest$1i = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2H.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2H)
    for (var prop of __getOwnPropSymbols$2H(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2H.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  labelWidth: 6,
  inputWidth: 12
};
const FormField = (_a) => {
  var _b = _a, {
    label,
    tooltip,
    labelWidth,
    inputWidth,
    inputEl,
    className,
    interactive
  } = _b, inputProps = __objRest$1i(_b, [
    "label",
    "tooltip",
    "labelWidth",
    "inputWidth",
    "inputEl",
    "className",
    "interactive"
  ]);
  const styles = getStyles$22();
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.formField, className) }, /* @__PURE__ */ React__default["default"].createElement(InlineFormLabel, { width: labelWidth, tooltip, interactive }, label), inputEl || /* @__PURE__ */ React__default["default"].createElement(
    "input",
    __spreadProps$1M(__spreadValues$2F({
      type: "text",
      className: `gf-form-input ${inputWidth ? `width-${inputWidth}` : ""}`
    }, inputProps), {
      disabled: inputProps.disabled
    })
  ));
};
FormField.displayName = "FormField";
FormField.defaultProps = defaultProps;
const getStyles$22 = () => {
  return {
    formField: css.css({
      display: "flex",
      flexDirection: "row",
      alignItems: "flex-start",
      textAlign: "left",
      position: "relative"
    })
  };
};

if (typeof window !== "undefined" && "Element" in window && !Element.prototype.closest) {
  Element.prototype.closest = function(s) {
    const matches = (this.document || this.ownerDocument).querySelectorAll(s);
    let el = this;
    let i;
    do {
      i = matches.length;
      while (--i >= 0 && matches.item(i) !== el) {
      }
      el = el.parentElement;
    } while (i < 0 && el);
    return el;
  };
}
function getPreviousCousin(node, selector) {
  let sibling = node.parentElement.previousSibling;
  let el;
  while (sibling) {
    el = sibling.querySelector(selector);
    if (el) {
      return el;
    }
    sibling = sibling.previousSibling;
  }
  return void 0;
}
function getNextCharacter(global) {
  const selection = (global || window).getSelection();
  if (!selection || !selection.anchorNode) {
    return null;
  }
  const range = selection.getRangeAt(0);
  const text = selection.anchorNode.textContent;
  const offset = range.startOffset;
  return text.slice(offset, offset + 1);
}

var dom = /*#__PURE__*/Object.freeze({
  __proto__: null,
  getPreviousCousin: getPreviousCousin,
  getNextCharacter: getNextCharacter
});

function getChildId(children) {
  let inputId;
  const child = React__default["default"].Children.only(children);
  if ("id" in (child == null ? void 0 : child.props)) {
    inputId = child.props.id;
  } else if ("inputId" in child.props) {
    inputId = child == null ? void 0 : child.props.inputId;
  }
  return typeof inputId === "string" ? inputId : void 0;
}
function renderOrCallToRender(itemToRender, props) {
  if (React__default["default"].isValidElement(itemToRender) || typeof itemToRender === "string" || typeof itemToRender === "number") {
    return itemToRender;
  }
  if (typeof itemToRender === "function" && props) {
    return itemToRender(props);
  }
  throw new Error(`${itemToRender} is not a React element nor a function that returns React element`);
}

var reactUtils = /*#__PURE__*/Object.freeze({
  __proto__: null,
  getChildId: getChildId,
  renderOrCallToRender: renderOrCallToRender
});

const PALETTE_ROWS = 4;
const DEFAULT_ANNOTATION_COLOR = "rgba(0, 211, 255, 1)";
const OK_COLOR = "rgba(11, 237, 50, 1)";
const ALERTING_COLOR = "rgba(237, 46, 24, 1)";
const NO_DATA_COLOR = "rgba(150, 150, 150, 1)";
const PENDING_COLOR = "rgba(247, 149, 32, 1)";
const REGION_FILL_ALPHA = 0.09;
const colors = [
  "#7EB26D",
  // 0: pale green
  "#EAB839",
  // 1: mustard
  "#6ED0E0",
  // 2: light blue
  "#EF843C",
  // 3: orange
  "#E24D42",
  // 4: red
  "#1F78C1",
  // 5: ocean
  "#BA43A9",
  // 6: purple
  "#705DA0",
  // 7: violet
  "#508642",
  // 8: dark green
  "#CCA300",
  // 9: dark sand
  "#447EBC",
  "#C15C17",
  "#890F02",
  "#0A437C",
  "#6D1F62",
  "#584477",
  "#B7DBAB",
  "#F4D598",
  "#70DBED",
  "#F9BA8F",
  "#F29191",
  "#82B5D8",
  "#E5A8E2",
  "#AEA2E0",
  "#629E51",
  "#E5AC0E",
  "#64B0C8",
  "#E0752D",
  "#BF1B00",
  "#0A50A1",
  "#962D82",
  "#614D93",
  "#9AC48A",
  "#F2C96D",
  "#65C5DB",
  "#F9934E",
  "#EA6460",
  "#5195CE",
  "#D683CE",
  "#806EB7",
  "#3F6833",
  "#967302",
  "#2F575E",
  "#99440A",
  "#58140C",
  "#052B51",
  "#511749",
  "#3F2B5B",
  "#E0F9D7",
  "#FCEACA",
  "#CFFAFF",
  "#F9E2D2",
  "#FCE2DE",
  "#BADFF4",
  "#F9D9F9",
  "#DEDAF7"
];
function sortColorsByHue(hexColors) {
  const hslColors = lodash.map(hexColors, hexToHsl);
  const sortedHSLColors = lodash.sortBy(hslColors, ["h"]);
  const chunkedHSLColors = lodash.chunk(sortedHSLColors, PALETTE_ROWS);
  const sortedChunkedHSLColors = lodash.map(chunkedHSLColors, (chunk2) => {
    return lodash.sortBy(chunk2, "l");
  });
  const flattenedZippedSortedChunkedHSLColors = lodash.flattenDeep(lodash.zip(...sortedChunkedHSLColors));
  return lodash.map(flattenedZippedSortedChunkedHSLColors, hslToHex);
}
function hexToHsl(color) {
  return tinycolor__default["default"](color).toHsl();
}
function hslToHex(color) {
  return tinycolor__default["default"](color).toHexString();
}
function getTextColorForBackground(color) {
  const b = tinycolor__default["default"](color).getBrightness();
  return b > 180 ? "rgb(32, 34, 38)" : "rgb(247, 248, 250)";
}
function getTextColorForAlphaBackground(color, themeIsDark) {
  const tcolor = tinycolor__default["default"](color);
  const b = tcolor.getBrightness();
  const a = tcolor.getAlpha();
  if (a < 0.3) {
    return themeIsDark ? "rgb(247, 248, 250)" : "rgb(32, 34, 38)";
  }
  return b > 180 ? "rgb(32, 34, 38)" : "rgb(247, 248, 250)";
}
let sortedColors = sortColorsByHue(colors);

var EventsWithValidation = /* @__PURE__ */ ((EventsWithValidation2) => {
  EventsWithValidation2["onBlur"] = "onBlur";
  EventsWithValidation2["onFocus"] = "onFocus";
  EventsWithValidation2["onChange"] = "onChange";
  return EventsWithValidation2;
})(EventsWithValidation || {});
const validate = (value, validationRules) => {
  const errors = validationRules.reduce((acc, currRule) => {
    if (!currRule.rule(value)) {
      return acc.concat(currRule.errorMessage);
    }
    return acc;
  }, []);
  return errors.length > 0 ? errors : null;
};
const hasValidationEvent = (event, validationEvents) => {
  return validationEvents && validationEvents[event];
};
const regexValidation = (pattern, errorMessage) => {
  return {
    rule: (valueToValidate) => {
      return !!valueToValidate.match(pattern);
    },
    errorMessage: errorMessage || "Value is not valid"
  };
};

const SCHEMA = {
  document: {
    nodes: [
      {
        match: [{ type: "paragraph" }, { type: "code_block" }, { type: "code_line" }]
      }
    ]
  },
  inlines: {}
};
const makeFragment = (text, syntax) => {
  const lines = text.split("\n").map(
    (line) => slate.Block.create({
      type: "code_line",
      nodes: [slate.Text.create(line)]
    })
  );
  const block = slate.Block.create({
    data: {
      syntax
    },
    type: "code_block",
    nodes: lines
  });
  return slate.Document.create({
    nodes: [block]
  });
};
const makeValue = (text, syntax) => {
  const fragment = makeFragment(text, syntax);
  return slate.Value.create({
    document: fragment
  });
};

const linkModelToContextMenuItems = (links) => {
  return links().map((link) => {
    return {
      label: link.title,
      ariaLabel: link.title,
      // TODO: rename to href
      url: link.href,
      target: link.target,
      icon: `${link.target === "_blank" ? "external-link-alt" : "link"}`,
      onClick: link.onClick
    };
  });
};
const isCompactUrl = (url) => {
  const compactExploreUrlRegex = /\/explore\?.*&(left|right)=\[(.*\,){2,}(.*){1}\]/;
  return compactExploreUrlRegex.test(url);
};

const TAG_COLORS = [
  "#D32D20",
  "#1E72B8",
  "#B240A2",
  "#705DA0",
  "#466803",
  "#497A3C",
  "#3D71AA",
  "#B15415",
  "#890F02",
  "#6E6E6E",
  "#0A437C",
  "#6D1F62",
  "#584477",
  "#4C7A3F",
  "#2F4F4F",
  "#BF1B00",
  "#7662B1",
  "#8A2EB8",
  "#517A00",
  "#000000",
  "#3F6833",
  "#2F575E",
  "#99440A",
  "#AE561A",
  "#0E4AB4",
  "#58140C",
  "#052B51",
  "#511749",
  "#3F2B5B"
];
const TAG_BORDER_COLORS = [
  "#FF7368",
  "#459EE7",
  "#E069CF",
  "#9683C6",
  "#6C8E29",
  "#76AC68",
  "#6AA4E2",
  "#E7823D",
  "#AF3528",
  "#9B9B9B",
  "#3069A2",
  "#934588",
  "#7E6A9D",
  "#88C477",
  "#557575",
  "#E54126",
  "#A694DD",
  "#B054DE",
  "#8FC426",
  "#262626",
  "#658E59",
  "#557D84",
  "#BF6A30",
  "#FF9B53",
  "#3470DA",
  "#7E3A32",
  "#2B5177",
  "#773D6F",
  "#655181"
];
function getTagColorIndexFromName(name = "") {
  const hash = djb2(name.toLowerCase());
  return Math.abs(hash % TAG_COLORS.length);
}
function getTagColorsFromName(name = "") {
  const index = getTagColorIndexFromName(name);
  return getTagColor(index);
}
function getTagColor(index) {
  return { color: TAG_COLORS[index], borderColor: TAG_BORDER_COLORS[index] };
}
function djb2(str) {
  let hash = 5381;
  for (let i = 0; i < str.length; i++) {
    hash = (hash << 5) + hash + str.charCodeAt(i);
  }
  return hash;
}

let scrollbarWidth = null;
function getScrollbarWidth() {
  if (scrollbarWidth !== null) {
    return scrollbarWidth;
  }
  if (typeof document !== "undefined") {
    const div = document.createElement("div");
    const newStyles = {
      width: "100px",
      height: "100px",
      position: "absolute",
      top: "-9999px",
      overflow: "scroll",
      MsOverflowStyle: "scrollbar"
    };
    Object.keys(newStyles).map((style) => {
      div.style[style] = newStyles[style];
    });
    document.body.appendChild(div);
    scrollbarWidth = div.offsetWidth - div.clientWidth;
    document.body.removeChild(div);
  } else {
    scrollbarWidth = 0;
  }
  return scrollbarWidth || 0;
}

const getCellLinks = (field, row) => {
  let links;
  if (field.getLinks) {
    links = field.getLinks({
      valueRowIndex: row.index
    });
  }
  if (!links) {
    return;
  }
  for (let i = 0; i < (links == null ? void 0 : links.length); i++) {
    if (links[i].onClick) {
      const origOnClick = links[i].onClick;
      links[i].onClick = (event) => {
        if (!(event.ctrlKey || event.metaKey || event.shiftKey)) {
          event.preventDefault();
          origOnClick(event, {
            field,
            rowIndex: row.index
          });
        }
      };
    }
  }
  return links;
};

let _context;
const cache = /* @__PURE__ */ new Map();
const cacheLimit = 500;
let ctxFontStyle = "";
function getCanvasContext() {
  if (!_context) {
    _context = document.createElement("canvas").getContext("2d");
  }
  return _context;
}
function measureText(text, fontSize, fontWeight = 400) {
  const fontStyle = `${fontWeight} ${fontSize}px 'Inter'`;
  const cacheKey = text + fontStyle;
  const fromCache = cache.get(cacheKey);
  if (fromCache) {
    return fromCache;
  }
  const context = getCanvasContext();
  if (ctxFontStyle !== fontStyle) {
    context.font = ctxFontStyle = fontStyle;
  }
  const metrics = context.measureText(text);
  if (cache.size === cacheLimit) {
    cache.clear();
  }
  cache.set(cacheKey, metrics);
  return metrics;
}
function calculateFontSize(text, width, height, lineHeight, maxSize, fontWeight) {
  const textSize = measureText(text, 14, fontWeight);
  const fontSizeBasedOnWidth = width / (textSize.width + 2) * 14;
  const fontSizeBasedOnHeight = height / lineHeight;
  const optimalSize = Math.min(fontSizeBasedOnHeight, fontSizeBasedOnWidth);
  return Math.min(optimalSize, maxSize != null ? maxSize : optimalSize);
}

function useForceUpdate() {
  const [_, setValue] = React.useState(0);
  return () => setValue((prevState) => prevState + 1);
}

function fuzzyMatch(stack, needle) {
  let distance = 0, searchIndex = stack.indexOf(needle);
  needle = needle.replace(/\s/g, "");
  const ranges = [];
  if (searchIndex !== -1) {
    return {
      distance: 0,
      found: true,
      ranges: [{ start: searchIndex, end: searchIndex + needle.length - 1 }]
    };
  }
  for (const letter of needle) {
    const letterIndex = stack.indexOf(letter, searchIndex);
    if (letterIndex === -1) {
      return { distance: Infinity, ranges: [], found: false };
    }
    if (searchIndex !== -1) {
      distance += letterIndex - searchIndex;
    }
    searchIndex = letterIndex + 1;
    if (ranges.length === 0) {
      ranges.push({ start: letterIndex, end: letterIndex });
    } else {
      const lastRange = lodash.last(ranges);
      if (letterIndex === lastRange.end + 1) {
        lastRange.end++;
      } else {
        ranges.push({ start: letterIndex, end: letterIndex });
      }
    }
  }
  return {
    distance,
    ranges,
    found: true
  };
}

var SearchFunctionType = /* @__PURE__ */ ((SearchFunctionType2) => {
  SearchFunctionType2["Word"] = "Word";
  SearchFunctionType2["Prefix"] = "Prefix";
  SearchFunctionType2["Fuzzy"] = "Fuzzy";
  return SearchFunctionType2;
})(SearchFunctionType || {});
const wordSearch = (items, text) => {
  return items.filter((c) => (c.filterText || c.label).includes(text));
};
const prefixSearch = (items, text) => {
  return items.filter((c) => (c.filterText || c.label).startsWith(text));
};
const fuzzySearch = (items, text) => {
  text = text.toLowerCase();
  return items.filter((item) => {
    const { distance, ranges, found } = fuzzyMatch(item.label.toLowerCase(), text);
    if (!found) {
      return false;
    }
    item.sortValue = distance;
    item.highlightParts = ranges;
    return true;
  });
};
const SearchFunctionMap = {
  ["Word" /* Word */]: wordSearch,
  ["Prefix" /* Prefix */]: prefixSearch,
  ["Fuzzy" /* Fuzzy */]: fuzzySearch
};

const throttledLog = lodash.throttle((...t) => {
  console.log(...t);
}, 500);
const createLogger = (name) => {
  let loggingEnabled = false;
  if (typeof window !== "undefined") {
    loggingEnabled = window.localStorage.getItem("grafana.debug") === "true";
  }
  return {
    logger: (id, throttle2 = false, ...t) => {
      if (process.env.NODE_ENV === "production" || process.env.NODE_ENV === "test" || !loggingEnabled) {
        return;
      }
      const fn = throttle2 ? throttledLog : console.log;
      fn(`[${name}: ${id}]:`, ...t);
    },
    enable: () => loggingEnabled = true,
    disable: () => loggingEnabled = false,
    isEnabled: () => loggingEnabled
  };
};

var __defProp$2W = Object.defineProperty;
var __defProps$1L = Object.defineProperties;
var __getOwnPropDescs$1L = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2G = Object.getOwnPropertySymbols;
var __hasOwnProp$2G = Object.prototype.hasOwnProperty;
var __propIsEnum$2G = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2W = (obj, key, value) => key in obj ? __defProp$2W(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2E = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2G.call(b, prop))
      __defNormalProp$2W(a, prop, b[prop]);
  if (__getOwnPropSymbols$2G)
    for (var prop of __getOwnPropSymbols$2G(b)) {
      if (__propIsEnum$2G.call(b, prop))
        __defNormalProp$2W(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1L = (a, b) => __defProps$1L(a, __getOwnPropDescs$1L(b));
function attachDebugger(key, thebugger, logger) {
  var _a;
  if (process.env.NODE_ENV === "production") {
    return;
  }
  let completeDebugger = thebugger || {};
  if (logger !== void 0) {
    completeDebugger = __spreadProps$1L(__spreadValues$2E({}, completeDebugger), { enable: () => logger.enable(), disable: () => logger.disable() });
  }
  let debugGlobal = (_a = typeof window !== "undefined" && window["_debug"]) != null ? _a : {};
  debugGlobal[key] = completeDebugger;
  if (typeof window !== "undefined") {
    window["_debug"] = debugGlobal;
  }
}

var NodeGraphDataFrameFieldNames = /* @__PURE__ */ ((NodeGraphDataFrameFieldNames2) => {
  NodeGraphDataFrameFieldNames2["id"] = "id";
  NodeGraphDataFrameFieldNames2["title"] = "title";
  NodeGraphDataFrameFieldNames2["subTitle"] = "subTitle";
  NodeGraphDataFrameFieldNames2["mainStat"] = "mainStat";
  NodeGraphDataFrameFieldNames2["secondaryStat"] = "secondaryStat";
  NodeGraphDataFrameFieldNames2["source"] = "source";
  NodeGraphDataFrameFieldNames2["target"] = "target";
  NodeGraphDataFrameFieldNames2["detail"] = "detail__";
  NodeGraphDataFrameFieldNames2["arc"] = "arc__";
  NodeGraphDataFrameFieldNames2["color"] = "color";
  return NodeGraphDataFrameFieldNames2;
})(NodeGraphDataFrameFieldNames || {});

var __defProp$2V = Object.defineProperty;
var __defProps$1K = Object.defineProperties;
var __getOwnPropDescs$1K = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2F = Object.getOwnPropertySymbols;
var __hasOwnProp$2F = Object.prototype.hasOwnProperty;
var __propIsEnum$2F = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2V = (obj, key, value) => key in obj ? __defProp$2V(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2D = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2F.call(b, prop))
      __defNormalProp$2V(a, prop, b[prop]);
  if (__getOwnPropSymbols$2F)
    for (var prop of __getOwnPropSymbols$2F(b)) {
      if (__propIsEnum$2F.call(b, prop))
        __defNormalProp$2V(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1K = (a, b) => __defProps$1K(a, __getOwnPropDescs$1K(b));
var __objRest$1h = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2F.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2F)
    for (var prop of __getOwnPropSymbols$2F(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2F.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var __publicField$u = (obj, key, value) => {
  __defNormalProp$2V(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var LegacyInputStatus = /* @__PURE__ */ ((LegacyInputStatus2) => {
  LegacyInputStatus2["Invalid"] = "invalid";
  LegacyInputStatus2["Valid"] = "valid";
  return LegacyInputStatus2;
})(LegacyInputStatus || {});
class Input$1 extends React.PureComponent {
  constructor() {
    super(...arguments);
    __publicField$u(this, "state", {
      error: null
    });
    __publicField$u(this, "validatorAsync", (validationRules) => {
      return (evt) => {
        const errors = validate(evt.target.value, validationRules);
        this.setState((prevState) => {
          return __spreadProps$1K(__spreadValues$2D({}, prevState), { error: errors ? errors[0] : null });
        });
      };
    });
    __publicField$u(this, "populateEventPropsWithStatus", (restProps, validationEvents) => {
      const inputElementProps = __spreadValues$2D({}, restProps);
      if (!validationEvents) {
        return inputElementProps;
      }
      Object.keys(EventsWithValidation).forEach((eventName) => {
        if (hasValidationEvent(eventName, validationEvents) || restProps[eventName]) {
          inputElementProps[eventName] = async (evt) => {
            evt.persist();
            if (hasValidationEvent(eventName, validationEvents)) {
              await this.validatorAsync(validationEvents[eventName]).apply(this, [evt]);
            }
            if (restProps[eventName]) {
              restProps[eventName].apply(null, [evt, this.status]);
            }
          };
        }
      });
      return inputElementProps;
    });
  }
  get status() {
    return this.state.error ? "invalid" /* Invalid */ : "valid" /* Valid */;
  }
  get isInvalid() {
    return this.status === "invalid" /* Invalid */;
  }
  render() {
    const _a = this.props, { validationEvents, className, hideErrorMessage, inputRef } = _a, restProps = __objRest$1h(_a, ["validationEvents", "className", "hideErrorMessage", "inputRef"]);
    const { error } = this.state;
    const inputClassName = classNames__default["default"]("gf-form-input", { invalid: this.isInvalid }, className);
    const inputElementProps = this.populateEventPropsWithStatus(restProps, validationEvents);
    return /* @__PURE__ */ React__default["default"].createElement("div", { style: { flexGrow: 1 } }, /* @__PURE__ */ React__default["default"].createElement("input", __spreadProps$1K(__spreadValues$2D({}, inputElementProps), { ref: inputRef, className: inputClassName })), error && !hideErrorMessage && /* @__PURE__ */ React__default["default"].createElement("span", null, error));
  }
}
__publicField$u(Input$1, "defaultProps", {
  className: ""
});

var __defProp$2U = Object.defineProperty;
var __getOwnPropSymbols$2E = Object.getOwnPropertySymbols;
var __hasOwnProp$2E = Object.prototype.hasOwnProperty;
var __propIsEnum$2E = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2U = (obj, key, value) => key in obj ? __defProp$2U(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2C = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2E.call(b, prop))
      __defNormalProp$2U(a, prop, b[prop]);
  if (__getOwnPropSymbols$2E)
    for (var prop of __getOwnPropSymbols$2E(b)) {
      if (__propIsEnum$2E.call(b, prop))
        __defNormalProp$2U(a, prop, b[prop]);
    }
  return a;
};
const IndicatorsContainer$1 = (props) => {
  const isOpen = props.selectProps.menuIsOpen;
  return /* @__PURE__ */ React__default["default"].createElement(ReactSelect.components.IndicatorsContainer, __spreadValues$2C({}, props), /* @__PURE__ */ React__default["default"].createElement(Icon, { name: isOpen ? "angle-up" : "angle-down", style: { marginTop: "7px" } }));
};

var __defProp$2T = Object.defineProperty;
var __getOwnPropSymbols$2D = Object.getOwnPropertySymbols;
var __hasOwnProp$2D = Object.prototype.hasOwnProperty;
var __propIsEnum$2D = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2T = (obj, key, value) => key in obj ? __defProp$2T(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2B = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2D.call(b, prop))
      __defNormalProp$2T(a, prop, b[prop]);
  if (__getOwnPropSymbols$2D)
    for (var prop of __getOwnPropSymbols$2D(b)) {
      if (__propIsEnum$2D.call(b, prop))
        __defNormalProp$2T(a, prop, b[prop]);
    }
  return a;
};
const NoOptionsMessage = (props) => {
  const { children } = props;
  return /* @__PURE__ */ React__default["default"].createElement(ReactSelect.components.NoOptionsMessage, __spreadValues$2B({}, props), /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-select-box__desc-option" }, /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-select-box__desc-option__body" }, children)));
};

const ScrollIndicators = ({ children }) => {
  const [showScrollTopIndicator, setShowTopScrollIndicator] = React.useState(false);
  const [showScrollBottomIndicator, setShowBottomScrollIndicator] = React.useState(false);
  const scrollTopMarker = React.useRef(null);
  const scrollBottomMarker = React.useRef(null);
  const styles = useStyles2(getStyles$21);
  React.useEffect(() => {
    const intersectionObserver = new IntersectionObserver((entries) => {
      entries.forEach((entry) => {
        if (entry.target === scrollTopMarker.current) {
          setShowTopScrollIndicator(!entry.isIntersecting);
        } else if (entry.target === scrollBottomMarker.current) {
          setShowBottomScrollIndicator(!entry.isIntersecting);
        }
      });
    });
    [scrollTopMarker, scrollBottomMarker].forEach((ref) => {
      if (ref.current) {
        intersectionObserver.observe(ref.current);
      }
    });
    return () => intersectionObserver.disconnect();
  }, []);
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      className: css.cx(styles.scrollIndicator, styles.scrollTopIndicator, {
        [styles.scrollIndicatorVisible]: showScrollTopIndicator
      })
    }
  ), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.scrollContent }, /* @__PURE__ */ React__default["default"].createElement("div", { ref: scrollTopMarker }), children, /* @__PURE__ */ React__default["default"].createElement("div", { ref: scrollBottomMarker })), /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      className: css.cx(styles.scrollIndicator, styles.scrollBottomIndicator, {
        [styles.scrollIndicatorVisible]: showScrollBottomIndicator
      })
    }
  ));
};
const getStyles$21 = (theme) => {
  return {
    scrollContent: css.css({
      flex: 1,
      position: "relative"
    }),
    scrollIndicator: css.css({
      height: theme.spacing(6),
      left: 0,
      opacity: 0,
      pointerEvents: "none",
      position: "absolute",
      right: 0,
      transition: theme.transitions.create("opacity"),
      zIndex: 1
    }),
    scrollTopIndicator: css.css({
      background: `linear-gradient(0deg, transparent, ${theme.colors.background.canvas})`,
      top: 0
    }),
    scrollBottomIndicator: css.css({
      background: `linear-gradient(180deg, transparent, ${theme.colors.background.canvas})`,
      bottom: 0
    }),
    scrollIndicatorVisible: css.css({
      opacity: 1
    })
  };
};

var __defProp$2S = Object.defineProperty;
var __defProps$1J = Object.defineProperties;
var __getOwnPropDescs$1J = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2C = Object.getOwnPropertySymbols;
var __hasOwnProp$2C = Object.prototype.hasOwnProperty;
var __propIsEnum$2C = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2S = (obj, key, value) => key in obj ? __defProp$2S(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2A = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2C.call(b, prop))
      __defNormalProp$2S(a, prop, b[prop]);
  if (__getOwnPropSymbols$2C)
    for (var prop of __getOwnPropSymbols$2C(b)) {
      if (__propIsEnum$2C.call(b, prop))
        __defNormalProp$2S(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1J = (a, b) => __defProps$1J(a, __getOwnPropDescs$1J(b));
const CustomScrollbar = ({
  autoHide = false,
  autoHideTimeout = 200,
  setScrollTop,
  className,
  testId,
  autoHeightMin = "0",
  autoHeightMax = "100%",
  hideTracksWhenNotNeeded = false,
  hideHorizontalTrack,
  hideVerticalTrack,
  scrollRefCallback,
  showScrollIndicators = false,
  updateAfterMountMs,
  scrollTop,
  onScroll,
  children
}) => {
  const ref = React.useRef(null);
  const styles = useStyles2(getStyles$20);
  React.useEffect(() => {
    if (ref.current && scrollRefCallback) {
      scrollRefCallback(ref.current.view);
    }
  }, [ref, scrollRefCallback]);
  React.useEffect(() => {
    if (ref.current && scrollTop != null) {
      ref.current.scrollTop(scrollTop);
    }
  }, [scrollTop]);
  React.useEffect(() => {
    if (!updateAfterMountMs) {
      return;
    }
    setTimeout(() => {
      const scrollbar = ref.current;
      if (scrollbar == null ? void 0 : scrollbar.update) {
        scrollbar.update();
      }
    }, updateAfterMountMs);
  }, [updateAfterMountMs]);
  function renderTrack(className2, hideTrack, passedProps) {
    if (passedProps.style && hideTrack) {
      passedProps.style.display = "none";
    }
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1J(__spreadValues$2A({}, passedProps), { className: className2 }));
  }
  const renderTrackHorizontal = React.useCallback(
    (passedProps) => {
      return renderTrack("track-horizontal", hideHorizontalTrack, passedProps);
    },
    [hideHorizontalTrack]
  );
  const renderTrackVertical = React.useCallback(
    (passedProps) => {
      return renderTrack("track-vertical", hideVerticalTrack, passedProps);
    },
    [hideVerticalTrack]
  );
  const renderThumbHorizontal = React.useCallback((passedProps) => {
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1J(__spreadValues$2A({}, passedProps), { className: "thumb-horizontal" }));
  }, []);
  const renderThumbVertical = React.useCallback((passedProps) => {
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1J(__spreadValues$2A({}, passedProps), { className: "thumb-vertical" }));
  }, []);
  const renderView = React.useCallback((passedProps) => {
    if (passedProps.style && passedProps.style["WebkitOverflowScrolling"] === "touch") {
      passedProps.style["WebkitOverflowScrolling"] = "auto";
    }
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1J(__spreadValues$2A({}, passedProps), { className: "scrollbar-view" }));
  }, []);
  const onScrollStop = React.useCallback(() => {
    ref.current && setScrollTop && setScrollTop(ref.current.getValues());
  }, [setScrollTop]);
  return /* @__PURE__ */ React__default["default"].createElement(
    Scrollbars__default["default"],
    {
      "data-testid": testId,
      ref,
      className: css.cx(styles.customScrollbar, className, {
        [styles.scrollbarWithScrollIndicators]: showScrollIndicators
      }),
      onScrollStop,
      autoHeight: true,
      autoHide,
      autoHideTimeout,
      hideTracksWhenNotNeeded,
      autoHeightMax,
      autoHeightMin,
      renderTrackHorizontal,
      renderTrackVertical,
      renderThumbHorizontal,
      renderThumbVertical,
      renderView,
      onScroll
    },
    showScrollIndicators ? /* @__PURE__ */ React__default["default"].createElement(ScrollIndicators, null, children) : children
  );
};
const getStyles$20 = (theme) => {
  return {
    customScrollbar: css.css({
      // Fix for Firefox. For some reason sometimes .view container gets a height of its content, but in order to
      // make scroll working it should fit outer container size (scroll appears only when inner container size is
      // greater than outer one).
      display: "flex",
      flexGrow: 1,
      ".scrollbar-view": {
        display: "flex",
        flexGrow: 1,
        flexDirection: "column"
      },
      ".track-vertical": {
        borderRadius: theme.shape.borderRadius(2),
        width: `${theme.spacing(1)} !important`,
        right: 0,
        bottom: theme.spacing(0.25),
        top: theme.spacing(0.25)
      },
      ".track-horizontal": {
        borderRadius: theme.shape.borderRadius(2),
        height: `${theme.spacing(1)} !important`,
        right: theme.spacing(0.25),
        bottom: theme.spacing(0.25),
        left: theme.spacing(0.25)
      },
      ".thumb-vertical": {
        background: theme.colors.action.focus,
        borderRadius: theme.shape.borderRadius(2),
        opacity: 0
      },
      ".thumb-horizontal": {
        background: theme.colors.action.focus,
        borderRadius: theme.shape.borderRadius(2),
        opacity: 0
      },
      "&:hover": {
        ".thumb-vertical, .thumb-horizontal": {
          opacity: 1,
          transition: "opacity 0.3s ease-in-out"
        }
      }
    }),
    // override the scroll container position so that the scroll indicators
    // are positioned at the top and bottom correctly.
    // react-custom-scrollbars doesn't provide any way for us to hook in nicely,
    // so we have to override with !important. feelsbad.
    scrollbarWithScrollIndicators: css.css({
      ".scrollbar-view": {
        // Need type assertion here due to the use of !important
        // see https://github.com/frenic/csstype/issues/114#issuecomment-697201978
        // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
        position: "static !important"
      }
    })
  };
};

var __defProp$2R = Object.defineProperty;
var __defNormalProp$2R = (obj, key, value) => key in obj ? __defProp$2R(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$t = (obj, key, value) => {
  __defNormalProp$2R(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
const getSelectOptionGroupStyles = stylesFactory((theme) => {
  return {
    header: css.css({
      display: "flex",
      alignItems: "center",
      justifyContent: "flex-start",
      justifyItems: "center",
      cursor: "pointer",
      padding: "7px 10px",
      width: "100%",
      borderBottom: `1px solid ${theme.colors.background.secondary}`,
      "&:hover": {
        color: theme.colors.text.maxContrast
      }
    }),
    label: css.css({
      flexGrow: 1
    }),
    icon: css.css({
      paddingRight: "2px"
    })
  };
});
class UnthemedSelectOptionGroup extends React.PureComponent {
  constructor() {
    super(...arguments);
    __publicField$t(this, "state", {
      expanded: false
    });
    __publicField$t(this, "onToggleChildren", () => {
      this.setState((prevState) => ({
        expanded: !prevState.expanded
      }));
    });
  }
  componentDidMount() {
    if (this.props.data.expanded) {
      this.setState({ expanded: true });
    } else if (this.props.selectProps && this.props.selectProps.value) {
      const { value } = this.props.selectProps.value;
      if (value && this.props.options.some((option) => option.value === value)) {
        this.setState({ expanded: true });
      }
    }
  }
  componentDidUpdate(nextProps) {
    if (nextProps.selectProps.inputValue !== "") {
      this.setState({ expanded: true });
    }
  }
  render() {
    const { children, label, theme } = this.props;
    const { expanded } = this.state;
    const styles = getSelectOptionGroupStyles(theme);
    return /* @__PURE__ */ React__default["default"].createElement("div", null, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.header, onClick: this.onToggleChildren, role: "presentation" }, /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.label }, label), /* @__PURE__ */ React__default["default"].createElement(Icon, { className: styles.icon, name: expanded ? "angle-up" : "angle-down" })), expanded && children);
  }
}
const SelectOptionGroup = withTheme2(UnthemedSelectOptionGroup);

function useDelayedSwitch(value, options = {}) {
  const { duration = 250, delay = 250 } = options;
  const [delayedValue, setDelayedValue] = React.useState(value);
  const onStartTime = React.useRef();
  React.useEffect(() => {
    let timeout;
    if (value) {
      timeout = setTimeout(() => {
        onStartTime.current = /* @__PURE__ */ new Date();
        setDelayedValue(value);
      }, delay);
    } else {
      const timeSpent = onStartTime.current ? Date.now() - onStartTime.current.valueOf() : 0;
      const turnOff = () => {
        onStartTime.current = void 0;
        setDelayedValue(value);
      };
      if (timeSpent >= duration) {
        turnOff();
      } else {
        timeout = setTimeout(turnOff, duration - timeSpent);
      }
    }
    return () => {
      if (timeout) {
        clearTimeout(timeout);
        timeout = void 0;
      }
    };
  }, [value, duration, delay]);
  return delayedValue;
}

var CompletionItemKind = /* @__PURE__ */ ((CompletionItemKind2) => {
  CompletionItemKind2["GroupTitle"] = "GroupTitle";
  return CompletionItemKind2;
})(CompletionItemKind || {});

const isIconSize = (value) => {
  return ["xs", "sm", "md", "lg", "xl", "xxl", "xxxl"].includes(value);
};
const getAvailableIcons = () => Object.keys(data.availableIconsIndex);
function getFieldTypeIcon(field) {
  return getFieldTypeIconName(field == null ? void 0 : field.type);
}
function getFieldTypeIconName(type) {
  if (type) {
    switch (type) {
      case data.FieldType.time:
        return "clock-nine";
      case data.FieldType.string:
        return "font";
      case data.FieldType.number:
        return "calculator-alt";
      case data.FieldType.boolean:
        return "toggle-on";
      case data.FieldType.trace:
        return "info-circle";
      case data.FieldType.enum:
        return "list-ol";
      case data.FieldType.geo:
        return "map-marker";
      case data.FieldType.other:
        return "brackets-curly";
    }
  }
  return "question-circle";
}

const Spinner = ({
  className,
  inline = false,
  iconClassName,
  style,
  size = "md"
}) => {
  const styles = useStyles2(getStyles$1$);
  const deprecatedStyles = useStyles2(getDeprecatedStyles, size);
  if (typeof size !== "string" || !isIconSize(size)) {
    const iconRoot = getIconRoot();
    const iconName = "spinner";
    const subDir = getIconSubDir(iconName, "default");
    const svgPath = `${iconRoot}${subDir}/${iconName}.svg`;
    return /* @__PURE__ */ React__default["default"].createElement(
      "div",
      {
        "data-testid": "Spinner",
        style,
        className: css.cx(
          {
            [styles.inline]: inline
          },
          deprecatedStyles.wrapper,
          className
        )
      },
      /* @__PURE__ */ React__default["default"].createElement(
        SVG__default["default"],
        {
          src: svgPath,
          width: size,
          height: size,
          className: css.cx("fa-spin", deprecatedStyles.icon, className),
          style
        }
      )
    );
  }
  return /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      "data-testid": "Spinner",
      style,
      className: css.cx(
        {
          [styles.inline]: inline
        },
        className
      )
    },
    /* @__PURE__ */ React__default["default"].createElement(Icon, { className: css.cx("fa-spin", iconClassName), name: "spinner", size, "aria-label": "loading spinner" })
  );
};
const getStyles$1$ = (theme) => ({
  inline: css.css({
    display: "inline-block"
  })
});
const getDeprecatedStyles = (theme, size) => ({
  wrapper: css.css({
    fontSize: typeof size === "string" ? size : `${size}px`
  }),
  icon: css.css({
    display: "inline-block",
    fill: "currentColor",
    flexShrink: 0,
    label: "Icon",
    // line-height: 0; is needed for correct icon alignment in Safari
    lineHeight: 0,
    verticalAlign: "middle"
  })
});

function FadeTransition(props) {
  const { visible, children, duration = 250 } = props;
  const styles = useStyles2(getStyles$1_, duration);
  return /* @__PURE__ */ React__default["default"].createElement(reactTransitionGroup.CSSTransition, { in: visible, mountOnEnter: true, unmountOnExit: true, timeout: duration, classNames: styles }, children);
}
const getStyles$1_ = (_theme, duration) => ({
  enter: css.css({
    label: "enter",
    opacity: 0
  }),
  enterActive: css.css({
    label: "enterActive",
    opacity: 1,
    transition: `opacity ${duration}ms ease-out`
  }),
  exit: css.css({
    label: "exit",
    opacity: 1
  }),
  exitActive: css.css({
    label: "exitActive",
    opacity: 0,
    transition: `opacity ${duration}ms ease-out`
  })
});

function SlideOutTransition(props) {
  const { visible, children, duration = 250, horizontal, size } = props;
  const styles = useStyles2(getStyles$1Z, duration, horizontal ? "width" : "height", size);
  return /* @__PURE__ */ React__default["default"].createElement(reactTransitionGroup.CSSTransition, { in: visible, mountOnEnter: true, unmountOnExit: true, timeout: duration, classNames: styles }, children);
}
const getStyles$1Z = (_theme, duration, measurement, size) => ({
  enter: css.css({
    label: "enter",
    [`${measurement}`]: 0,
    opacity: 0
  }),
  enterActive: css.css({
    label: "enterActive",
    [`${measurement}`]: `${size}px`,
    opacity: 1,
    transition: `opacity ${duration}ms ease-out, ${measurement} ${duration}ms ease-out`
  }),
  exit: css.css({
    label: "exit",
    [`${measurement}`]: `${size}px`,
    opacity: 1
  }),
  exitActive: css.css({
    label: "exitActive",
    opacity: 0,
    [`${measurement}`]: 0,
    transition: `opacity ${duration}ms ease-out, ${measurement} ${duration}ms ease-out`
  })
});

var __defProp$2Q = Object.defineProperty;
var __defProps$1I = Object.defineProperties;
var __getOwnPropDescs$1I = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2B = Object.getOwnPropertySymbols;
var __hasOwnProp$2B = Object.prototype.hasOwnProperty;
var __propIsEnum$2B = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2Q = (obj, key, value) => key in obj ? __defProp$2Q(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2z = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2B.call(b, prop))
      __defNormalProp$2Q(a, prop, b[prop]);
  if (__getOwnPropSymbols$2B)
    for (var prop of __getOwnPropSymbols$2B(b)) {
      if (__propIsEnum$2B.call(b, prop))
        __defNormalProp$2Q(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1I = (a, b) => __defProps$1I(a, __getOwnPropDescs$1I(b));
const getStyles$1Y = (theme) => {
  return {
    singleValue: css.css({
      label: "singleValue",
      whiteSpace: "nowrap",
      overflow: "hidden",
      textOverflow: "ellipsis",
      boxSizing: "border-box",
      maxWidth: "100%",
      gridArea: "1 / 1 / 2 / 3"
    }),
    spinnerWrapper: css.css({
      width: "16px",
      height: "16px",
      display: "inline-block",
      marginRight: "10px",
      position: "relative",
      verticalAlign: "middle",
      overflow: "hidden"
    }),
    spinnerIcon: css.css({
      width: "100%",
      height: "100%",
      position: "absolute"
    }),
    optionIcon: css.css({
      marginRight: theme.spacing(1),
      color: theme.colors.text.secondary
    }),
    disabled: css.css({
      color: theme.colors.text.disabled
    }),
    isOpen: css.css({
      color: theme.colors.text.disabled
    })
  };
};
const SingleValue = (props) => {
  var _a;
  const { children, data: data$1, isDisabled } = props;
  const styles = useStyles2(getStyles$1Y);
  const loading = useDelayedSwitch(data$1.loading || false, { delay: 250, duration: 750 });
  const icon = data$1.icon ? data.toIconName(data$1.icon) : void 0;
  return /* @__PURE__ */ React__default["default"].createElement(
    ReactSelect.components.SingleValue,
    __spreadProps$1I(__spreadValues$2z({}, props), {
      className: css.cx(styles.singleValue, isDisabled && styles.disabled, props.selectProps.menuIsOpen && styles.isOpen)
    }),
    data$1.imgUrl ? /* @__PURE__ */ React__default["default"].createElement(FadeWithImage, { loading, imgUrl: data$1.imgUrl, styles, alt: String((_a = data$1.label) != null ? _a : data$1.value) }) : /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(SlideOutTransition, { horizontal: true, size: 16, visible: loading, duration: 150 }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.spinnerWrapper }, /* @__PURE__ */ React__default["default"].createElement(Spinner, { className: styles.spinnerIcon, inline: true }))), icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, role: "img", className: styles.optionIcon })),
    !data$1.hideText && children
  );
};
const FadeWithImage = (props) => {
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: props.styles.spinnerWrapper }, /* @__PURE__ */ React__default["default"].createElement(FadeTransition, { duration: 150, visible: props.loading }, /* @__PURE__ */ React__default["default"].createElement(Spinner, { className: props.styles.spinnerIcon, inline: true })), /* @__PURE__ */ React__default["default"].createElement(FadeTransition, { duration: 150, visible: !props.loading }, /* @__PURE__ */ React__default["default"].createElement("img", { className: props.styles.spinnerIcon, src: props.imgUrl, alt: props.alt })));
};

var __defProp$2P = Object.defineProperty;
var __defProps$1H = Object.defineProperties;
var __getOwnPropDescs$1H = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2A = Object.getOwnPropertySymbols;
var __hasOwnProp$2A = Object.prototype.hasOwnProperty;
var __propIsEnum$2A = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2P = (obj, key, value) => key in obj ? __defProp$2P(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2y = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2A.call(b, prop))
      __defNormalProp$2P(a, prop, b[prop]);
  if (__getOwnPropSymbols$2A)
    for (var prop of __getOwnPropSymbols$2A(b)) {
      if (__propIsEnum$2A.call(b, prop))
        __defNormalProp$2P(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1H = (a, b) => __defProps$1H(a, __getOwnPropDescs$1H(b));
function resetSelectStyles(theme) {
  return {
    clearIndicator: () => ({}),
    container: () => ({}),
    control: () => ({}),
    dropdownIndicator: () => ({}),
    group: () => ({}),
    groupHeading: () => ({}),
    indicatorsContainer: () => ({}),
    indicatorSeparator: () => ({}),
    input: function(originalStyles) {
      return __spreadProps$1H(__spreadValues$2y({}, originalStyles), {
        color: "inherit",
        margin: 0,
        padding: 0,
        // Set an explicit z-index here to ensure this element always overlays the singleValue
        zIndex: 1
      });
    },
    loadingIndicator: () => ({}),
    loadingMessage: () => ({}),
    menu: () => ({}),
    menuList: ({ maxHeight }) => ({
      maxHeight
    }),
    multiValue: () => ({}),
    multiValueLabel: () => ({
      overflow: "hidden",
      textOverflow: "ellipsis"
    }),
    multiValueRemove: () => ({}),
    noOptionsMessage: () => ({}),
    option: () => ({}),
    placeholder: (originalStyles) => __spreadProps$1H(__spreadValues$2y({}, originalStyles), {
      color: theme.colors.text.secondary
    }),
    singleValue: () => ({}),
    valueContainer: () => ({})
  };
}
function useCustomSelectStyles(theme, width) {
  return React.useMemo(() => {
    return __spreadProps$1H(__spreadValues$2y({}, resetSelectStyles(theme)), {
      menuPortal: (base) => {
        return __spreadProps$1H(__spreadValues$2y({}, base), {
          zIndex: theme.zIndex.portal
        });
      },
      //These are required for the menu positioning to function
      menu: ({ top, bottom, position }) => {
        return {
          top,
          bottom,
          position,
          minWidth: "100%",
          zIndex: theme.zIndex.dropdown
        };
      },
      container: () => ({
        width: width ? theme.spacing(width) : "100%",
        display: width === "auto" ? "inline-flex" : "flex"
      }),
      option: (provided, state) => __spreadProps$1H(__spreadValues$2y({}, provided), {
        opacity: state.isDisabled ? 0.5 : 1
      })
    });
  }, [theme, width]);
}

var __defProp$2O = Object.defineProperty;
var __getOwnPropSymbols$2z = Object.getOwnPropertySymbols;
var __hasOwnProp$2z = Object.prototype.hasOwnProperty;
var __propIsEnum$2z = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2O = (obj, key, value) => key in obj ? __defProp$2O(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2x = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2z.call(b, prop))
      __defNormalProp$2O(a, prop, b[prop]);
  if (__getOwnPropSymbols$2z)
    for (var prop of __getOwnPropSymbols$2z(b)) {
      if (__propIsEnum$2z.call(b, prop))
        __defNormalProp$2O(a, prop, b[prop]);
    }
  return a;
};
const SelectOption = (props) => {
  const { children, isSelected, data } = props;
  return /* @__PURE__ */ React__default["default"].createElement(ReactSelect.components.Option, __spreadValues$2x({}, props), /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-select-box__desc-option" }, data.imgUrl && /* @__PURE__ */ React__default["default"].createElement("img", { className: "gf-form-select-box__desc-option__img", src: data.imgUrl, alt: "" }), /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-select-box__desc-option__body" }, /* @__PURE__ */ React__default["default"].createElement("div", null, children), data.description && /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-select-box__desc-option__desc" }, data.description)), isSelected && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "check", "aria-hidden": "true" })));
};

var __defProp$2N = Object.defineProperty;
var __getOwnPropSymbols$2y = Object.getOwnPropertySymbols;
var __hasOwnProp$2y = Object.prototype.hasOwnProperty;
var __propIsEnum$2y = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2N = (obj, key, value) => key in obj ? __defProp$2N(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2w = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2y.call(b, prop))
      __defNormalProp$2N(a, prop, b[prop]);
  if (__getOwnPropSymbols$2y)
    for (var prop of __getOwnPropSymbols$2y(b)) {
      if (__propIsEnum$2y.call(b, prop))
        __defNormalProp$2N(a, prop, b[prop]);
    }
  return a;
};
var __publicField$s = (obj, key, value) => {
  __defNormalProp$2N(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
const MenuList = (props) => {
  return /* @__PURE__ */ React__default["default"].createElement(ReactSelect.components.MenuList, __spreadValues$2w({}, props), /* @__PURE__ */ React__default["default"].createElement(CustomScrollbar, { autoHide: false, autoHeightMax: "inherit" }, props.children));
};
const _Select = class _Select extends React.PureComponent {
  render() {
    const {
      defaultValue,
      getOptionLabel,
      getOptionValue,
      onChange,
      options,
      placeholder,
      width,
      value,
      className,
      isDisabled,
      isLoading,
      isSearchable,
      isClearable,
      backspaceRemovesValue,
      isMulti,
      autoFocus,
      openMenuOnFocus,
      onBlur,
      maxMenuHeight,
      noOptionsMessage,
      isOpen,
      components: components2,
      tooltipContent,
      tabSelectsValue,
      onCloseMenu,
      onOpenMenu,
      allowCustomValue,
      formatCreateLabel,
      "aria-label": ariaLabel
    } = this.props;
    let widthClass = "";
    if (width) {
      widthClass = "width-" + width;
    }
    let SelectComponent = ReactSelect__default["default"];
    const creatableOptions = {};
    if (allowCustomValue) {
      SelectComponent = Creatable__default["default"];
      creatableOptions.formatCreateLabel = formatCreateLabel != null ? formatCreateLabel : (input) => input;
    }
    const selectClassNames = classNames__default["default"]("gf-form-input", "gf-form-input--form-dropdown", widthClass, className);
    const selectComponents = __spreadValues$2w(__spreadValues$2w({}, _Select.defaultProps.components), components2);
    return /* @__PURE__ */ React__default["default"].createElement(WrapInTooltip, { onCloseMenu, onOpenMenu, tooltipContent, isOpen }, (onOpenMenuInternal, onCloseMenuInternal) => {
      return /* @__PURE__ */ React__default["default"].createElement(
        SelectComponent,
        __spreadValues$2w({
          captureMenuScroll: false,
          classNamePrefix: "gf-form-select-box",
          className: selectClassNames,
          components: selectComponents,
          defaultValue,
          value,
          getOptionLabel,
          getOptionValue,
          menuShouldScrollIntoView: false,
          isSearchable,
          onChange,
          options,
          placeholder: placeholder || "Choose",
          styles: resetSelectStyles(this.context),
          isDisabled,
          isLoading,
          isClearable,
          autoFocus,
          onBlur,
          openMenuOnFocus,
          maxMenuHeight,
          noOptionsMessage,
          isMulti,
          backspaceRemovesValue,
          menuIsOpen: isOpen,
          onMenuOpen: onOpenMenuInternal,
          onMenuClose: onCloseMenuInternal,
          tabSelectsValue,
          "aria-label": ariaLabel
        }, creatableOptions)
      );
    });
  }
};
__publicField$s(_Select, "contextType", data.ThemeContext);
__publicField$s(_Select, "defaultProps", {
  className: "",
  isDisabled: false,
  isSearchable: true,
  isClearable: false,
  isMulti: false,
  openMenuOnFocus: false,
  autoFocus: false,
  isLoading: false,
  backspaceRemovesValue: true,
  maxMenuHeight: 300,
  tabSelectsValue: true,
  allowCustomValue: false,
  components: {
    Option: SelectOption,
    SingleValue,
    IndicatorsContainer: IndicatorsContainer$1,
    MenuList,
    Group: SelectOptionGroup
  }
});
let Select$1 = _Select;
class AsyncSelect$1 extends React.PureComponent {
  render() {
    const {
      defaultValue,
      getOptionLabel,
      getOptionValue,
      onChange,
      placeholder,
      width,
      value,
      className,
      loadOptions,
      defaultOptions,
      isLoading,
      loadingMessage,
      noOptionsMessage,
      isDisabled,
      isSearchable,
      isClearable,
      backspaceRemovesValue,
      autoFocus,
      onBlur,
      openMenuOnFocus,
      maxMenuHeight,
      isMulti,
      tooltipContent,
      onCloseMenu,
      onOpenMenu,
      isOpen
    } = this.props;
    let widthClass = "";
    if (width) {
      widthClass = "width-" + width;
    }
    const selectClassNames = classNames__default["default"]("gf-form-input", "gf-form-input--form-dropdown", widthClass, className);
    return /* @__PURE__ */ React__default["default"].createElement(WrapInTooltip, { onCloseMenu, onOpenMenu, tooltipContent, isOpen }, (onOpenMenuInternal, onCloseMenuInternal) => {
      return /* @__PURE__ */ React__default["default"].createElement(
        ReactAsyncSelect__default["default"],
        {
          captureMenuScroll: false,
          classNamePrefix: "gf-form-select-box",
          className: selectClassNames,
          components: {
            Option: SelectOption,
            SingleValue,
            IndicatorsContainer: IndicatorsContainer$1,
            NoOptionsMessage
          },
          defaultValue,
          value,
          getOptionLabel,
          getOptionValue,
          menuShouldScrollIntoView: false,
          onChange,
          loadOptions,
          isLoading,
          defaultOptions,
          placeholder: placeholder || "Choose",
          styles: resetSelectStyles(this.context),
          loadingMessage,
          noOptionsMessage,
          isDisabled,
          isSearchable,
          isClearable,
          autoFocus,
          onBlur,
          openMenuOnFocus,
          maxMenuHeight,
          isMulti,
          backspaceRemovesValue
        }
      );
    });
  }
}
__publicField$s(AsyncSelect$1, "contextType", data.ThemeContext);
__publicField$s(AsyncSelect$1, "defaultProps", {
  className: "",
  components: {},
  loadingMessage: () => "Loading...",
  isDisabled: false,
  isClearable: false,
  isMulti: false,
  isSearchable: true,
  backspaceRemovesValue: true,
  autoFocus: false,
  openMenuOnFocus: false,
  maxMenuHeight: 300
});
class WrapInTooltip extends React.PureComponent {
  constructor() {
    super(...arguments);
    __publicField$s(this, "state", {
      isOpenInternal: false
    });
    __publicField$s(this, "onOpenMenu", () => {
      const { onOpenMenu } = this.props;
      if (onOpenMenu) {
        onOpenMenu();
      }
      this.setState({ isOpenInternal: true });
    });
    __publicField$s(this, "onCloseMenu", () => {
      const { onCloseMenu } = this.props;
      if (onCloseMenu) {
        onCloseMenu();
      }
      this.setState({ isOpenInternal: false });
    });
  }
  render() {
    const { children, isOpen, tooltipContent } = this.props;
    const { isOpenInternal } = this.state;
    let showTooltip = void 0;
    if (isOpenInternal || isOpen) {
      showTooltip = false;
    }
    if (tooltipContent) {
      return /* @__PURE__ */ React__default["default"].createElement(Tooltip, { show: showTooltip, content: tooltipContent, placement: "bottom" }, /* @__PURE__ */ React__default["default"].createElement("div", null, children(this.onOpenMenu, this.onCloseMenu)));
    } else {
      return /* @__PURE__ */ React__default["default"].createElement("div", null, children(this.onOpenMenu, this.onCloseMenu));
    }
  }
}

var __defProp$2M = Object.defineProperty;
var __defNormalProp$2M = (obj, key, value) => key in obj ? __defProp$2M(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$r = (obj, key, value) => {
  __defNormalProp$2M(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
class Switch$1 extends React.PureComponent {
  constructor() {
    super(...arguments);
    __publicField$r(this, "state", {
      id: lodash.uniqueId()
    });
    __publicField$r(this, "internalOnChange", (event) => {
      event.stopPropagation();
      this.props.onChange(event);
    });
  }
  render() {
    const {
      labelClass = "",
      switchClass = "",
      label,
      checked,
      disabled,
      transparent,
      className,
      tooltip,
      tooltipPlacement
    } = this.props;
    const labelId = this.state.id;
    const labelClassName = `gf-form-label ${labelClass} ${transparent ? "gf-form-label--transparent" : ""} pointer`;
    const switchClassName = `gf-form-switch ${switchClass} ${transparent ? "gf-form-switch--transparent" : ""}`;
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-switch-container-react" }, /* @__PURE__ */ React__default["default"].createElement("label", { htmlFor: labelId, className: `gf-form gf-form-switch-container ${className || ""}` }, label && /* @__PURE__ */ React__default["default"].createElement("div", { className: labelClassName }, label, tooltip && /* @__PURE__ */ React__default["default"].createElement(Tooltip, { placement: tooltipPlacement ? tooltipPlacement : "auto", content: tooltip, theme: "info" }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "info-circle", size: "sm", style: { marginLeft: "10px" } }))), /* @__PURE__ */ React__default["default"].createElement("div", { className: switchClassName }, /* @__PURE__ */ React__default["default"].createElement(
      "input",
      {
        disabled,
        id: labelId,
        type: "checkbox",
        checked,
        onChange: this.internalOnChange
      }
    ), /* @__PURE__ */ React__default["default"].createElement("span", { className: "gf-form-switch__slider" }))));
  }
}

const getFocusStyle = (theme) => css.css({
  "&:focus": getFocusStyles(theme)
});
const sharedInputStyle = (theme, invalid = false) => {
  const borderColor = invalid ? theme.colors.error.border : theme.components.input.borderColor;
  const borderColorHover = invalid ? theme.colors.error.shade : theme.components.input.borderHover;
  const background = theme.components.input.background;
  const textColor = theme.components.input.text;
  const autoFillBorder = theme.isDark ? "#2e2f35" : "#bab4ca";
  return css.cx(
    inputPadding(theme),
    css.css({
      background,
      lineHeight: theme.typography.body.lineHeight,
      fontSize: theme.typography.size.md,
      color: textColor,
      border: `1px solid ${borderColor}`,
      "&:-webkit-autofill, &:-webkit-autofill:hover": {
        /* Welcome to 2005. This is a HACK to get rid od Chromes default autofill styling */
        boxShadow: `inset 0 0 0 1px rgba(255, 255, 255, 0), inset 0 0 0 100px ${background}!important`,
        WebkitTextFillColor: `${textColor} !important`,
        borderColor: autoFillBorder
      },
      "&:-webkit-autofill:focus": {
        /* Welcome to 2005. This is a HACK to get rid od Chromes default autofill styling */
        boxShadow: `0 0 0 2px ${theme.colors.background.primary}, 0 0 0px 4px ${theme.colors.primary.main}, inset 0 0 0 1px rgba(255, 255, 255, 0), inset 0 0 0 100px ${background}!important`,
        WebkitTextFillColor: `${textColor} !important`
      },
      "&:hover": {
        borderColor: borderColorHover
      },
      "&:focus": {
        outline: "none"
      },
      "&:disabled": {
        backgroundColor: theme.colors.action.disabledBackground,
        color: theme.colors.action.disabledText,
        border: `1px solid ${theme.colors.action.disabledBackground}`,
        "&:hover": {
          borderColor
        }
      },
      "&::placeholder": {
        color: theme.colors.text.disabled,
        opacity: 1
      }
    })
  );
};
const inputPadding = (theme) => {
  return css.css({
    padding: theme.spacing(0, 1, 0, 1)
  });
};
const inputSizes = () => {
  return {
    sm: css.css({
      width: inputSizesPixels("sm")
    }),
    md: css.css({
      width: inputSizesPixels("md")
    }),
    lg: css.css({
      width: inputSizesPixels("lg")
    }),
    auto: css.css({
      width: inputSizesPixels("auto")
    })
  };
};
const inputSizesPixels = (size) => {
  switch (size) {
    case "sm":
      return "200px";
    case "md":
      return "320px";
    case "lg":
      return "580px";
    case "auto":
    default:
      return "auto";
  }
};
function getPropertiesForButtonSize(size, theme) {
  switch (size) {
    case "sm":
      return {
        padding: 1,
        fontSize: theme.typography.size.sm,
        height: theme.components.height.sm
      };
    case "lg":
      return {
        padding: 3,
        fontSize: theme.typography.size.lg,
        height: theme.components.height.lg
      };
    case "md":
    default:
      return {
        padding: 2,
        fontSize: theme.typography.size.md,
        height: theme.components.height.md
      };
  }
}

var __defProp$2L = Object.defineProperty;
var __defProps$1G = Object.defineProperties;
var __getOwnPropDescs$1G = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2x = Object.getOwnPropertySymbols;
var __hasOwnProp$2x = Object.prototype.hasOwnProperty;
var __propIsEnum$2x = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2L = (obj, key, value) => key in obj ? __defProp$2L(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2v = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2x.call(b, prop))
      __defNormalProp$2L(a, prop, b[prop]);
  if (__getOwnPropSymbols$2x)
    for (var prop of __getOwnPropSymbols$2x(b)) {
      if (__propIsEnum$2x.call(b, prop))
        __defNormalProp$2L(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1G = (a, b) => __defProps$1G(a, __getOwnPropDescs$1G(b));
var __objRest$1g = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2x.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2x)
    for (var prop of __getOwnPropSymbols$2x(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2x.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Button = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, {
      variant = "primary",
      size = "md",
      fill = "solid",
      icon,
      fullWidth,
      children,
      className,
      type = "button",
      tooltip,
      tooltipPlacement
    } = _b, otherProps = __objRest$1g(_b, [
      "variant",
      "size",
      "fill",
      "icon",
      "fullWidth",
      "children",
      "className",
      "type",
      "tooltip",
      "tooltipPlacement"
    ]);
    const theme = useTheme2();
    const styles = getButtonStyles({
      theme,
      size,
      variant,
      fill,
      fullWidth,
      iconOnly: !children
    });
    const button = /* @__PURE__ */ React__default["default"].createElement("button", __spreadProps$1G(__spreadValues$2v({ className: css.cx(styles.button, className), type }, otherProps), { ref: tooltip ? void 0 : ref }), icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, size, className: styles.icon }), children && /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.content }, children));
    if (tooltip) {
      return /* @__PURE__ */ React__default["default"].createElement(Tooltip, { ref, content: tooltip, placement: tooltipPlacement }, button);
    }
    return button;
  }
);
Button.displayName = "Button";
const LinkButton = React__default["default"].forwardRef(
  (_c, ref) => {
    var _d = _c, {
      variant = "primary",
      size = "md",
      fill = "solid",
      icon,
      fullWidth,
      children,
      className,
      onBlur,
      onFocus,
      disabled,
      tooltip,
      tooltipPlacement
    } = _d, otherProps = __objRest$1g(_d, [
      "variant",
      "size",
      "fill",
      "icon",
      "fullWidth",
      "children",
      "className",
      "onBlur",
      "onFocus",
      "disabled",
      "tooltip",
      "tooltipPlacement"
    ]);
    const theme = useTheme2();
    const styles = getButtonStyles({
      theme,
      fullWidth,
      size,
      variant,
      fill,
      iconOnly: !children
    });
    const linkButtonStyles = css.cx(
      styles.button,
      {
        [css.css(styles.disabled, {
          pointerEvents: "none"
        })]: disabled
      },
      className
    );
    const button = /* @__PURE__ */ React__default["default"].createElement(
      "a",
      __spreadProps$1G(__spreadValues$2v({
        className: linkButtonStyles
      }, otherProps), {
        tabIndex: disabled ? -1 : 0,
        "aria-disabled": disabled,
        ref: tooltip ? void 0 : ref
      }),
      icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, size, className: styles.icon }),
      children && /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.content }, children)
    );
    if (tooltip) {
      return /* @__PURE__ */ React__default["default"].createElement(Tooltip, { ref, content: tooltip, placement: tooltipPlacement }, button);
    }
    return button;
  }
);
LinkButton.displayName = "LinkButton";
const getButtonStyles = (props) => {
  const { theme, variant, fill = "solid", size, iconOnly, fullWidth } = props;
  const { height, padding, fontSize } = getPropertiesForButtonSize(size, theme);
  const variantStyles = getPropertiesForVariant(theme, variant, fill);
  const disabledStyles = getPropertiesForDisabled(theme, variant, fill);
  const focusStyle = getFocusStyles(theme);
  const paddingMinusBorder = theme.spacing.gridSize * padding - 1;
  return {
    button: css.css(__spreadProps$1G(__spreadValues$2v(__spreadValues$2v({
      label: "button",
      display: "inline-flex",
      alignItems: "center",
      fontSize,
      fontWeight: theme.typography.fontWeightMedium,
      fontFamily: theme.typography.fontFamily,
      padding: `0 ${paddingMinusBorder}px`,
      height: theme.spacing(height),
      // Deduct border from line-height for perfect vertical centering on windows and linux
      lineHeight: `${theme.spacing.gridSize * height - 2}px`,
      verticalAlign: "middle",
      cursor: "pointer",
      borderRadius: theme.shape.radius.default,
      "&:focus": focusStyle,
      "&:focus-visible": focusStyle,
      "&:focus:not(:focus-visible)": getMouseFocusStyles()
    }, fullWidth && {
      flexGrow: 1,
      justifyContent: "center"
    }), variantStyles), {
      ":disabled": disabledStyles,
      "&[disabled]": disabledStyles
    })),
    disabled: css.css(disabledStyles),
    img: css.css({
      width: "16px",
      height: "16px",
      margin: theme.spacing(0, 1, 0, 0.5)
    }),
    icon: iconOnly ? css.css({
      // Important not to set margin bottom here as it would override internal icon bottom margin
      marginRight: theme.spacing(-padding / 2),
      marginLeft: theme.spacing(-padding / 2)
    }) : css.css({
      marginRight: theme.spacing(padding / 2)
    }),
    content: css.css({
      display: "flex",
      flexDirection: "row",
      alignItems: "center",
      whiteSpace: "nowrap",
      overflow: "hidden",
      height: "100%"
    })
  };
};
function getButtonVariantStyles(theme, color, fill) {
  let outlineBorderColor = color.border;
  let borderColor = "transparent";
  let hoverBorderColor = "transparent";
  if (color.name === "secondary") {
    borderColor = color.border;
    hoverBorderColor = theme.colors.emphasize(color.border, 0.25);
    outlineBorderColor = theme.colors.border.strong;
  }
  if (fill === "outline") {
    return {
      background: "transparent",
      color: color.text,
      border: `1px solid ${outlineBorderColor}`,
      transition: theme.transitions.create(["background-color", "border-color", "color"], {
        duration: theme.transitions.duration.short
      }),
      "&:hover": {
        background: color.transparent,
        borderColor: theme.colors.emphasize(outlineBorderColor, 0.25),
        color: color.text
      }
    };
  }
  if (fill === "text") {
    return {
      background: "transparent",
      color: color.text,
      border: "1px solid transparent",
      transition: theme.transitions.create(["background-color", "color"], {
        duration: theme.transitions.duration.short
      }),
      "&:focus": {
        outline: "none",
        textDecoration: "none"
      },
      "&:hover": {
        background: color.transparent,
        textDecoration: "none"
      }
    };
  }
  return {
    background: color.main,
    color: color.contrastText,
    border: `1px solid ${borderColor}`,
    transition: theme.transitions.create(["background-color", "box-shadow", "border-color", "color"], {
      duration: theme.transitions.duration.short
    }),
    "&:hover": {
      background: color.shade,
      color: color.contrastText,
      boxShadow: theme.shadows.z1,
      borderColor: hoverBorderColor
    }
  };
}
function getPropertiesForDisabled(theme, variant, fill) {
  const disabledStyles = {
    cursor: "not-allowed",
    boxShadow: "none",
    color: theme.colors.text.disabled,
    transition: "none"
  };
  if (fill === "text") {
    return __spreadProps$1G(__spreadValues$2v({}, disabledStyles), {
      background: "transparent",
      border: `1px solid transparent`
    });
  }
  if (fill === "outline") {
    return __spreadProps$1G(__spreadValues$2v({}, disabledStyles), {
      background: "transparent",
      border: `1px solid ${theme.colors.border.weak}`
    });
  }
  return __spreadProps$1G(__spreadValues$2v({}, disabledStyles), {
    background: theme.colors.action.disabledBackground,
    border: `1px solid transparent`
  });
}
function getPropertiesForVariant(theme, variant, fill) {
  switch (variant) {
    case "secondary":
      return getButtonVariantStyles(theme, theme.colors.secondary, fill);
    case "destructive":
      return getButtonVariantStyles(theme, theme.colors.error, fill);
    case "success":
      return getButtonVariantStyles(theme, theme.colors.success, fill);
    case "primary":
    default:
      return getButtonVariantStyles(theme, theme.colors.primary, fill);
  }
}
const clearButtonStyles = (theme) => {
  return css.css({
    background: "transparent",
    color: theme.colors.text.primary,
    border: "none",
    padding: 0
  });
};
const clearLinkButtonStyles = (theme) => {
  return css.css({
    background: "transparent",
    border: "none",
    padding: 0,
    fontFamily: "inherit",
    color: "inherit",
    height: "100%",
    "&:hover": {
      background: "transparent",
      color: "inherit"
    }
  });
};

var __defProp$2K = Object.defineProperty;
var __getOwnPropSymbols$2w = Object.getOwnPropertySymbols;
var __hasOwnProp$2w = Object.prototype.hasOwnProperty;
var __propIsEnum$2w = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2K = (obj, key, value) => key in obj ? __defProp$2K(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2u = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2w.call(b, prop))
      __defNormalProp$2K(a, prop, b[prop]);
  if (__getOwnPropSymbols$2w)
    for (var prop of __getOwnPropSymbols$2w(b)) {
      if (__propIsEnum$2w.call(b, prop))
        __defNormalProp$2K(a, prop, b[prop]);
    }
  return a;
};
var __objRest$1f = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2w.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2w)
    for (var prop of __getOwnPropSymbols$2w(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2w.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const getSecretFormFieldStyles = () => {
  return {
    noRadiusInput: css.css({
      borderBottomRightRadius: "0 !important",
      borderTopRightRadius: "0 !important"
    }),
    noRadiusButton: css.css({
      borderBottomLeftRadius: "0 !important",
      borderTopLeftRadius: "0 !important"
    })
  };
};
const SecretFormField = (_a) => {
  var _b = _a, {
    label = "Password",
    labelWidth,
    inputWidth = 12,
    onReset,
    isConfigured,
    tooltip,
    placeholder = "Password",
    interactive
  } = _b, inputProps = __objRest$1f(_b, [
    "label",
    "labelWidth",
    "inputWidth",
    "onReset",
    "isConfigured",
    "tooltip",
    "placeholder",
    "interactive"
  ]);
  const styles = getSecretFormFieldStyles();
  return /* @__PURE__ */ React__default["default"].createElement(
    FormField,
    {
      label,
      tooltip,
      interactive,
      labelWidth,
      inputEl: isConfigured ? /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(
        "input",
        __spreadValues$2u({
          type: "text",
          className: css.cx(`gf-form-input width-${inputWidth}`, styles.noRadiusInput),
          disabled: true,
          value: "configured"
        }, lodash.omit(inputProps, "value"))
      ), /* @__PURE__ */ React__default["default"].createElement(Button, { onClick: onReset, variant: "secondary", type: "button" }, "Reset")) : /* @__PURE__ */ React__default["default"].createElement(
        "input",
        __spreadValues$2u({
          type: "password",
          className: `gf-form-input width-${inputWidth}`,
          placeholder
        }, inputProps)
      )
    }
  );
};
SecretFormField.displayName = "SecretFormField";

var __defProp$2J = Object.defineProperty;
var __defProps$1F = Object.defineProperties;
var __getOwnPropDescs$1F = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2v = Object.getOwnPropertySymbols;
var __hasOwnProp$2v = Object.prototype.hasOwnProperty;
var __propIsEnum$2v = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2J = (obj, key, value) => key in obj ? __defProp$2J(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2t = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2v.call(b, prop))
      __defNormalProp$2J(a, prop, b[prop]);
  if (__getOwnPropSymbols$2v)
    for (var prop of __getOwnPropSymbols$2v(b)) {
      if (__propIsEnum$2v.call(b, prop))
        __defNormalProp$2J(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1F = (a, b) => __defProps$1F(a, __getOwnPropDescs$1F(b));
var __objRest$1e = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2v.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2v)
    for (var prop of __getOwnPropSymbols$2v(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2v.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const IconButton = React__default["default"].forwardRef((props, ref) => {
  const { size = "md", variant = "secondary" } = props;
  let limitedIconSize;
  if (size === "xxl" || size === "xxxl") {
    data.deprecationWarning("IconButton", 'size="xxl" and size="xxxl"', 'size="xl"');
    limitedIconSize = "xl";
  } else {
    limitedIconSize = size;
  }
  const styles = useStyles2(getStyles$1X, limitedIconSize, variant);
  let ariaLabel;
  let buttonRef;
  if ("tooltip" in props) {
    const { tooltip } = props;
    ariaLabel = typeof tooltip === "string" ? tooltip : void 0;
  } else if ("ariaLabel" in props || "aria-label" in props) {
    const { ariaLabel: deprecatedAriaLabel, ["aria-label"]: ariaLabelProp } = props;
    ariaLabel = ariaLabelProp || deprecatedAriaLabel;
    buttonRef = ref;
  }
  if ("tooltip" in props) {
    const _a = props, { name, iconType, className, tooltip, tooltipPlacement } = _a, restProps = __objRest$1e(_a, ["name", "iconType", "className", "tooltip", "tooltipPlacement"]);
    return /* @__PURE__ */ React__default["default"].createElement(Tooltip, { ref, content: tooltip, placement: tooltipPlacement }, /* @__PURE__ */ React__default["default"].createElement(
      "button",
      __spreadProps$1F(__spreadValues$2t({}, restProps), {
        ref: buttonRef,
        "aria-label": ariaLabel,
        className: css.cx(styles.button, className),
        type: "button"
      }),
      /* @__PURE__ */ React__default["default"].createElement(Icon, { name, size: limitedIconSize, className: styles.icon, type: iconType })
    ));
  } else {
    const _b = props, { name, iconType, className } = _b, restProps = __objRest$1e(_b, ["name", "iconType", "className"]);
    return /* @__PURE__ */ React__default["default"].createElement(
      "button",
      __spreadProps$1F(__spreadValues$2t({}, restProps), {
        ref: buttonRef,
        "aria-label": ariaLabel,
        className: css.cx(styles.button, className),
        type: "button"
      }),
      /* @__PURE__ */ React__default["default"].createElement(Icon, { name, size: limitedIconSize, className: styles.icon, type: iconType })
    );
  }
});
IconButton.displayName = "IconButton";
const getStyles$1X = (theme, size, variant) => {
  const hoverSize = getSvgSize(size) + theme.spacing.gridSize;
  let iconColor = theme.colors.text.primary;
  if (variant === "primary") {
    iconColor = theme.colors.primary.text;
  } else if (variant === "destructive") {
    iconColor = theme.colors.error.text;
  }
  return {
    button: css.css({
      zIndex: 0,
      position: "relative",
      margin: `0 ${theme.spacing.x0_5} 0 0`,
      boxShadow: "none",
      border: "none",
      display: "inline-flex",
      background: "transparent",
      justifyContent: "center",
      alignItems: "center",
      padding: 0,
      color: iconColor,
      "&[disabled], &:disabled": {
        cursor: "not-allowed",
        color: theme.colors.action.disabledText,
        opacity: 0.65
      },
      "&:before": {
        zIndex: -1,
        position: "absolute",
        opacity: 0,
        width: `${hoverSize}px`,
        height: `${hoverSize}px`,
        borderRadius: theme.shape.radius.default,
        content: '""',
        transitionDuration: "0.2s",
        transitionTimingFunction: "cubic-bezier(0.4, 0, 0.2, 1)",
        transitionProperty: "opacity"
      },
      "&:focus, &:focus-visible": getFocusStyles(theme),
      "&:focus:not(:focus-visible)": getMouseFocusStyles(),
      "&:hover": {
        "&:before": {
          backgroundColor: variant === "secondary" ? theme.colors.action.hover : data.colorManipulator.alpha(iconColor, 0.12),
          opacity: 1
        }
      }
    }),
    icon: css.css({
      verticalAlign: "baseline"
    })
  };
};

var __defProp$2I = Object.defineProperty;
var __getOwnPropSymbols$2u = Object.getOwnPropertySymbols;
var __hasOwnProp$2u = Object.prototype.hasOwnProperty;
var __propIsEnum$2u = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2I = (obj, key, value) => key in obj ? __defProp$2I(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2s = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2u.call(b, prop))
      __defNormalProp$2I(a, prop, b[prop]);
  if (__getOwnPropSymbols$2u)
    for (var prop of __getOwnPropSymbols$2u(b)) {
      if (__propIsEnum$2u.call(b, prop))
        __defNormalProp$2I(a, prop, b[prop]);
    }
  return a;
};
var __objRest$1d = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2u.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2u)
    for (var prop of __getOwnPropSymbols$2u(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2u.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const ButtonGroup = React.forwardRef((_a, ref) => {
  var _b = _a, { className, children } = _b, rest = __objRest$1d(_b, ["className", "children"]);
  const styles = useStyles2(getStyles$1W);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$2s({ ref, className: css.cx("button-group", styles.wrapper, className) }, rest), children);
});
ButtonGroup.displayName = "ButtonGroup";
const getStyles$1W = (theme) => ({
  wrapper: css.css({
    display: "flex",
    "> .button-group:not(:first-child) > button, > button:not(:first-child)": {
      borderTopLeftRadius: 0,
      borderBottomLeftRadius: 0
    },
    "> .button-group:not(:last-child) > button, > button:not(:last-child)": {
      borderTopRightRadius: 0,
      borderBottomRightRadius: 0,
      borderRightWidth: 0
    }
  })
});

const ConfirmButton = ({
  children,
  className,
  closeOnConfirm,
  confirmText = "Save",
  confirmVariant = "primary",
  disabled = false,
  onCancel,
  onClick,
  onConfirm,
  size = "md"
}) => {
  const mainButtonRef = React.useRef(null);
  const confirmButtonRef = React.useRef(null);
  const [showConfirm, setShowConfirm] = React.useState(false);
  const [shouldRestoreFocus, setShouldRestoreFocus] = React.useState(false);
  const styles = useStyles2(getStyles$1V);
  React.useEffect(() => {
    var _a, _b;
    if (showConfirm) {
      (_a = confirmButtonRef.current) == null ? void 0 : _a.focus();
      setShouldRestoreFocus(true);
    } else {
      if (shouldRestoreFocus) {
        (_b = mainButtonRef.current) == null ? void 0 : _b.focus();
        setShouldRestoreFocus(false);
      }
    }
  }, [shouldRestoreFocus, showConfirm]);
  const onClickButton = (event) => {
    if (event) {
      event.preventDefault();
    }
    setShowConfirm(true);
    onClick == null ? void 0 : onClick();
  };
  const onClickCancel = (event) => {
    var _a;
    if (event) {
      event.preventDefault();
    }
    setShowConfirm(false);
    (_a = mainButtonRef.current) == null ? void 0 : _a.focus();
    onCancel == null ? void 0 : onCancel();
  };
  const onClickConfirm = (event) => {
    if (event) {
      event.preventDefault();
    }
    onConfirm == null ? void 0 : onConfirm();
    if (closeOnConfirm) {
      setShowConfirm(false);
    }
  };
  const buttonClass = css.cx(className, styles.mainButton, {
    [styles.mainButtonHide]: showConfirm
  });
  const confirmButtonClass = css.cx(styles.confirmButton, {
    [styles.confirmButtonHide]: !showConfirm
  });
  const confirmButtonContainerClass = css.cx(styles.confirmButtonContainer, {
    [styles.confirmButtonContainerHide]: !showConfirm
  });
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.container }, /* @__PURE__ */ React__default["default"].createElement("span", { className: buttonClass }, typeof children === "string" ? /* @__PURE__ */ React__default["default"].createElement(Button, { disabled, size, fill: "text", onClick: onClickButton, ref: mainButtonRef }, children) : React__default["default"].cloneElement(children, { disabled, onClick: onClickButton, ref: mainButtonRef })), /* @__PURE__ */ React__default["default"].createElement("div", { className: confirmButtonContainerClass }, /* @__PURE__ */ React__default["default"].createElement("span", { className: confirmButtonClass }, /* @__PURE__ */ React__default["default"].createElement(Button, { size, variant: confirmVariant, onClick: onClickConfirm, ref: confirmButtonRef }, confirmText), /* @__PURE__ */ React__default["default"].createElement(Button, { size, fill: "text", onClick: onClickCancel }, "Cancel"))));
};
ConfirmButton.displayName = "ConfirmButton";
const getStyles$1V = (theme) => {
  return {
    container: css.css({
      alignItems: "center",
      display: "flex",
      justifyContent: "flex-end",
      position: "relative"
    }),
    mainButton: css.css({
      opacity: 1,
      transition: theme.transitions.create(["opacity"], {
        duration: theme.transitions.duration.shortest,
        easing: theme.transitions.easing.easeOut
      }),
      zIndex: 2
    }),
    mainButtonHide: css.css({
      opacity: 0,
      transition: theme.transitions.create(["opacity", "visibility"], {
        duration: theme.transitions.duration.shortest,
        easing: theme.transitions.easing.easeIn
      }),
      visibility: "hidden",
      zIndex: 0
    }),
    confirmButtonContainer: css.css({
      overflow: "visible",
      position: "absolute",
      pointerEvents: "all",
      right: 0
    }),
    confirmButtonContainerHide: css.css({
      overflow: "hidden",
      pointerEvents: "none"
    }),
    confirmButton: css.css({
      alignItems: "flex-start",
      background: theme.colors.background.primary,
      display: "flex",
      opacity: 1,
      transform: "translateX(0)",
      transition: theme.transitions.create(["opacity", "transform"], {
        duration: theme.transitions.duration.shortest,
        easing: theme.transitions.easing.easeOut
      }),
      zIndex: 1
    }),
    confirmButtonHide: css.css({
      opacity: 0,
      transform: "translateX(100%)",
      transition: theme.transitions.create(["opacity", "transform", "visibility"], {
        duration: theme.transitions.duration.shortest,
        easing: theme.transitions.easing.easeIn
      }),
      visibility: "hidden"
    })
  };
};

const DeleteButton = ({ size, disabled, onConfirm, "aria-label": ariaLabel, closeOnConfirm }) => {
  return /* @__PURE__ */ React__default["default"].createElement(
    ConfirmButton,
    {
      confirmText: "Delete",
      confirmVariant: "destructive",
      size: size || "md",
      disabled,
      onConfirm,
      closeOnConfirm
    },
    /* @__PURE__ */ React__default["default"].createElement(Button, { "aria-label": ariaLabel, variant: "destructive", icon: "times", size: size || "sm" })
  );
};

var __defProp$2H = Object.defineProperty;
var __getOwnPropSymbols$2t = Object.getOwnPropertySymbols;
var __hasOwnProp$2t = Object.prototype.hasOwnProperty;
var __propIsEnum$2t = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2H = (obj, key, value) => key in obj ? __defProp$2H(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2r = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2t.call(b, prop))
      __defNormalProp$2H(a, prop, b[prop]);
  if (__getOwnPropSymbols$2t)
    for (var prop of __getOwnPropSymbols$2t(b)) {
      if (__propIsEnum$2t.call(b, prop))
        __defNormalProp$2H(a, prop, b[prop]);
    }
  return a;
};
var __objRest$1c = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2t.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2t)
    for (var prop of __getOwnPropSymbols$2t(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2t.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function Popover(_a) {
  var _b = _a, {
    content,
    show,
    placement,
    className,
    wrapperClassName,
    referenceElement,
    renderArrow
  } = _b, rest = __objRest$1c(_b, [
    "content",
    "show",
    "placement",
    "className",
    "wrapperClassName",
    "referenceElement",
    "renderArrow"
  ]);
  const theme = useTheme2();
  const arrowRef = React.useRef(null);
  const middleware = [
    react$1.offset(8),
    react$1.flip({
      fallbackAxisSideDirection: "end",
      // see https://floating-ui.com/docs/flip#combining-with-shift
      crossAxis: false,
      boundary: document.body
    }),
    react$1.shift()
  ];
  if (renderArrow) {
    middleware.push(
      react$1.arrow({
        element: arrowRef
      })
    );
  }
  const { context, refs, floatingStyles } = react$1.useFloating({
    open: show,
    placement: getPlacement(placement),
    middleware,
    whileElementsMounted: react$1.autoUpdate,
    strategy: "fixed"
  });
  React.useLayoutEffect(() => {
    refs.setReference(referenceElement);
  }, [referenceElement, refs]);
  const { styles: placementStyles } = react$1.useTransitionStyles(context, {
    initial: () => ({
      opacity: 0
    }),
    duration: theme.transitions.duration.enteringScreen
  });
  return show ? /* @__PURE__ */ React__default["default"].createElement(Portal$1, null, /* @__PURE__ */ React__default["default"].createElement(
    "div",
    __spreadValues$2r({
      ref: refs.setFloating,
      style: __spreadValues$2r(__spreadValues$2r({}, floatingStyles), placementStyles),
      className: wrapperClassName
    }, rest),
    /* @__PURE__ */ React__default["default"].createElement("div", { className }, renderArrow && /* @__PURE__ */ React__default["default"].createElement(react$1.FloatingArrow, { fill: theme.colors.border.weak, ref: arrowRef, context }), typeof content === "string" && content, React__default["default"].isValidElement(content) && React__default["default"].cloneElement(content), typeof content === "function" && content({}))
  )) : void 0;
}

var __defProp$2G = Object.defineProperty;
var __getOwnPropSymbols$2s = Object.getOwnPropertySymbols;
var __hasOwnProp$2s = Object.prototype.hasOwnProperty;
var __propIsEnum$2s = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2G = (obj, key, value) => key in obj ? __defProp$2G(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2q = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2s.call(b, prop))
      __defNormalProp$2G(a, prop, b[prop]);
  if (__getOwnPropSymbols$2s)
    for (var prop of __getOwnPropSymbols$2s(b)) {
      if (__propIsEnum$2s.call(b, prop))
        __defNormalProp$2G(a, prop, b[prop]);
    }
  return a;
};
const Toggletip = React__default["default"].memo(
  ({
    children,
    theme = "info",
    placement = "auto",
    content,
    title,
    closeButton = true,
    onClose,
    footer,
    fitContent = false,
    onOpen,
    show
  }) => {
    const arrowRef = React.useRef(null);
    const grafanaTheme = useTheme2();
    const styles = useStyles2(getStyles$1U);
    const style = styles[theme];
    const [controlledVisible, setControlledVisible] = React.useState(show);
    const isOpen = show != null ? show : controlledVisible;
    const middleware = [
      react$1.offset(8),
      react$1.flip({
        fallbackAxisSideDirection: "end",
        // see https://floating-ui.com/docs/flip#combining-with-shift
        crossAxis: false,
        boundary: document.body
      }),
      react$1.shift(),
      react$1.arrow({
        element: arrowRef
      })
    ];
    const { context, refs, floatingStyles } = react$1.useFloating({
      open: isOpen,
      placement: getPlacement(placement),
      onOpenChange: (open) => {
        if (show === void 0) {
          setControlledVisible(open);
        }
        if (!open) {
          onClose == null ? void 0 : onClose();
        } else {
          onOpen == null ? void 0 : onOpen();
        }
      },
      middleware,
      whileElementsMounted: react$1.autoUpdate,
      strategy: "fixed"
    });
    const click = react$1.useClick(context);
    const dismiss = react$1.useDismiss(context);
    const { getReferenceProps, getFloatingProps } = react$1.useInteractions([dismiss, click]);
    return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, React__default["default"].cloneElement(children, __spreadValues$2q({
      ref: refs.setReference,
      tabIndex: 0,
      "aria-expanded": isOpen
    }, getReferenceProps())), isOpen && /* @__PURE__ */ React__default["default"].createElement(react$1.FloatingFocusManager, { context, modal: false, closeOnFocusOut: false }, /* @__PURE__ */ React__default["default"].createElement(
      "div",
      __spreadValues$2q({
        "data-testid": "toggletip-content",
        className: css.cx(style.container, {
          [styles.fitContent]: fitContent
        }),
        ref: refs.setFloating,
        style: floatingStyles
      }, getFloatingProps()),
      /* @__PURE__ */ React__default["default"].createElement(
        react$1.FloatingArrow,
        {
          strokeWidth: 0.3,
          stroke: grafanaTheme.colors.border.weak,
          className: style.arrow,
          ref: arrowRef,
          context
        }
      ),
      Boolean(title) && /* @__PURE__ */ React__default["default"].createElement("div", { className: style.header }, title),
      closeButton && /* @__PURE__ */ React__default["default"].createElement("div", { className: style.headerClose }, /* @__PURE__ */ React__default["default"].createElement(
        IconButton,
        {
          "aria-label": "Close",
          name: "times",
          "data-testid": "toggletip-header-close",
          onClick: () => {
            setControlledVisible(false);
            onClose == null ? void 0 : onClose();
          }
        }
      )),
      /* @__PURE__ */ React__default["default"].createElement("div", { className: style.body }, (typeof content === "string" || React__default["default"].isValidElement(content)) && content, typeof content === "function" && content({})),
      Boolean(footer) && /* @__PURE__ */ React__default["default"].createElement("div", { className: style.footer }, footer)
    )));
  }
);
Toggletip.displayName = "Toggletip";
const getStyles$1U = (theme) => {
  const info = buildTooltipTheme(
    theme,
    theme.colors.background.primary,
    theme.colors.border.weak,
    theme.components.tooltip.text,
    { topBottom: 2, rightLeft: 2 }
  );
  const error = buildTooltipTheme(
    theme,
    theme.colors.error.main,
    theme.colors.error.main,
    theme.colors.error.contrastText,
    { topBottom: 2, rightLeft: 2 }
  );
  return {
    info,
    error,
    fitContent: css.css({
      maxWidth: "fit-content"
    })
  };
};

const Counter = ({ value }) => {
  const styles = useStyles2(getStyles$1T);
  return /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.counter }, data.locale(value, 0).text);
};
const getStyles$1T = (theme) => ({
  counter: css.css({
    label: "counter",
    marginLeft: theme.spacing(1),
    borderRadius: theme.spacing(3),
    backgroundColor: theme.colors.action.hover,
    padding: theme.spacing(0.25, 1),
    color: theme.colors.text.secondary,
    fontWeight: theme.typography.fontWeightMedium,
    fontSize: theme.typography.size.sm
  })
});

var __defProp$2F = Object.defineProperty;
var __defProps$1E = Object.defineProperties;
var __getOwnPropDescs$1E = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2r = Object.getOwnPropertySymbols;
var __hasOwnProp$2r = Object.prototype.hasOwnProperty;
var __propIsEnum$2r = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2F = (obj, key, value) => key in obj ? __defProp$2F(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2p = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2r.call(b, prop))
      __defNormalProp$2F(a, prop, b[prop]);
  if (__getOwnPropSymbols$2r)
    for (var prop of __getOwnPropSymbols$2r(b)) {
      if (__propIsEnum$2r.call(b, prop))
        __defNormalProp$2F(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1E = (a, b) => __defProps$1E(a, __getOwnPropDescs$1E(b));
var __objRest$1b = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2r.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2r)
    for (var prop of __getOwnPropSymbols$2r(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2r.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Tab = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, { label, active, icon, onChangeTab, counter, suffix: Suffix, className, href } = _b, otherProps = __objRest$1b(_b, ["label", "active", "icon", "onChangeTab", "counter", "suffix", "className", "href"]);
    const tabsStyles = useStyles2(getStyles$1S);
    const clearStyles = useStyles2(clearButtonStyles);
    const content = () => /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon }), label, typeof counter === "number" && /* @__PURE__ */ React__default["default"].createElement(Counter, { value: counter }), Suffix && /* @__PURE__ */ React__default["default"].createElement(Suffix, { className: tabsStyles.suffix }));
    const linkClass = css.cx(clearStyles, tabsStyles.link, active ? tabsStyles.activeStyle : tabsStyles.notActive);
    const commonProps = __spreadProps$1E(__spreadValues$2p({
      className: linkClass
    }, otherProps), {
      onClick: onChangeTab,
      "aria-label": otherProps["aria-label"] || e2eSelectors.selectors.components.Tab.title(label),
      role: "tab",
      "aria-selected": active
    });
    if (href) {
      return /* @__PURE__ */ React__default["default"].createElement("div", { className: tabsStyles.item }, /* @__PURE__ */ React__default["default"].createElement(
        "a",
        __spreadProps$1E(__spreadValues$2p({}, commonProps), {
          href,
          ref
        }),
        content()
      ));
    }
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: tabsStyles.item }, /* @__PURE__ */ React__default["default"].createElement(
      "button",
      __spreadProps$1E(__spreadValues$2p({}, commonProps), {
        type: "button",
        ref
      }),
      content()
    ));
  }
);
Tab.displayName = "Tab";
const getStyles$1S = (theme) => {
  return {
    item: css.css({
      listStyle: "none",
      position: "relative",
      display: "flex",
      whiteSpace: "nowrap",
      padding: theme.spacing(0.5)
    }),
    link: css.css({
      color: theme.colors.text.secondary,
      padding: theme.spacing(1, 1.5, 0.5),
      borderRadius: theme.shape.radius.default,
      display: "block",
      height: "100%",
      svg: {
        marginRight: theme.spacing(1)
      },
      "&:focus-visible": getFocusStyles(theme),
      "&::before": {
        display: "block",
        content: '" "',
        position: "absolute",
        left: 0,
        right: 0,
        height: "4px",
        borderRadius: theme.shape.radius.default,
        bottom: 0
      }
    }),
    notActive: css.css({
      "a:hover, &:hover, &:focus": {
        color: theme.colors.text.primary,
        "&::before": {
          backgroundColor: theme.colors.action.hover
        }
      }
    }),
    activeStyle: css.css({
      label: "activeTabStyle",
      color: theme.colors.text.primary,
      overflow: "hidden",
      "&::before": {
        backgroundImage: theme.colors.gradients.brandHorizontal
      }
    }),
    suffix: css.css({
      marginLeft: theme.spacing(1)
    })
  };
};

const TabsBar = React__default["default"].forwardRef(({ children, className, hideBorder = false }, ref) => {
  const styles = useStyles2(getStyles$1R);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.tabsWrapper, hideBorder && styles.noBorder, className), ref }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.tabs, role: "tablist" }, children));
});
const getStyles$1R = (theme) => ({
  tabsWrapper: css.css({
    borderBottom: `1px solid ${theme.colors.border.weak}`,
    overflowX: "auto"
  }),
  noBorder: css.css({
    borderBottom: 0
  }),
  tabs: css.css({
    position: "relative",
    display: "flex",
    height: `${theme.components.menuTabs.height}px`,
    alignItems: "center"
  })
});
TabsBar.displayName = "TabsBar";

var __defProp$2E = Object.defineProperty;
var __defProps$1D = Object.defineProperties;
var __getOwnPropDescs$1D = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2q = Object.getOwnPropertySymbols;
var __hasOwnProp$2q = Object.prototype.hasOwnProperty;
var __propIsEnum$2q = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2E = (obj, key, value) => key in obj ? __defProp$2E(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2o = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2q.call(b, prop))
      __defNormalProp$2E(a, prop, b[prop]);
  if (__getOwnPropSymbols$2q)
    for (var prop of __getOwnPropSymbols$2q(b)) {
      if (__propIsEnum$2q.call(b, prop))
        __defNormalProp$2E(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1D = (a, b) => __defProps$1D(a, __getOwnPropDescs$1D(b));
var __objRest$1a = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2q.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2q)
    for (var prop of __getOwnPropSymbols$2q(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2q.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const TabContent = (_a) => {
  var _b = _a, { children, className } = _b, restProps = __objRest$1a(_b, ["children", "className"]);
  const styles = useStyles2(getTabContentStyle);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1D(__spreadValues$2o({}, restProps), { className: css.cx(styles.tabContent, className) }), children);
};
const getTabContentStyle = (theme) => ({
  tabContent: css.css({
    background: theme.colors.background.primary
  })
});

function TabbedContainer({ tabs, defaultTab, closeIconTooltip, onClose }) {
  var _a;
  const [activeTab, setActiveTab] = React.useState(tabs.some((tab) => tab.value === defaultTab) ? defaultTab : tabs[0].value);
  const styles = useStyles2(getStyles$1Q);
  const theme = useTheme2();
  const onSelectTab = (item) => {
    setActiveTab(item.value);
  };
  const autoHeight = `calc(100% - (${theme.components.menuTabs.height}px + ${theme.spacing(1)}))`;
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.container }, /* @__PURE__ */ React__default["default"].createElement(TabsBar, { className: styles.tabs }, tabs.map((t) => /* @__PURE__ */ React__default["default"].createElement(
    Tab,
    {
      key: t.value,
      label: t.label,
      active: t.value === activeTab,
      onChangeTab: () => onSelectTab(t),
      icon: t.icon
    }
  )), /* @__PURE__ */ React__default["default"].createElement(IconButton, { className: styles.close, onClick: onClose, name: "times", tooltip: closeIconTooltip != null ? closeIconTooltip : "Close" })), /* @__PURE__ */ React__default["default"].createElement(CustomScrollbar, { autoHeightMin: autoHeight, autoHeightMax: autoHeight }, /* @__PURE__ */ React__default["default"].createElement(TabContent, { className: styles.tabContent }, (_a = tabs.find((t) => t.value === activeTab)) == null ? void 0 : _a.content)));
}
const getStyles$1Q = (theme) => ({
  container: css.css({
    height: "100%"
  }),
  tabContent: css.css({
    padding: theme.spacing(2),
    backgroundColor: theme.colors.background.primary,
    height: `100%`
  }),
  close: css.css({
    position: "absolute",
    right: "16px",
    top: "5px",
    cursor: "pointer",
    fontSize: theme.typography.size.lg
  }),
  tabs: css.css({
    paddingTop: theme.spacing(1),
    borderColor: theme.colors.border.weak,
    ul: {
      marginLeft: theme.spacing(2)
    }
  })
});

var __defProp$2D = Object.defineProperty;
var __getOwnPropSymbols$2p = Object.getOwnPropertySymbols;
var __hasOwnProp$2p = Object.prototype.hasOwnProperty;
var __propIsEnum$2p = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2D = (obj, key, value) => key in obj ? __defProp$2D(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2n = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2p.call(b, prop))
      __defNormalProp$2D(a, prop, b[prop]);
  if (__getOwnPropSymbols$2p)
    for (var prop of __getOwnPropSymbols$2p(b)) {
      if (__propIsEnum$2p.call(b, prop))
        __defNormalProp$2D(a, prop, b[prop]);
    }
  return a;
};
function initI18n() {
  if (typeof i18next__default["default"].options.resources !== "object") {
    i18next__default["default"].use(reactI18next.initReactI18next).init({
      resources: {},
      returnEmptyString: false,
      lng: "en-US"
      // this should be the locale of the phrases in our source JSX
    });
  }
}
const Trans = (props) => {
  initI18n();
  return /* @__PURE__ */ React__default["default"].createElement(reactI18next.Trans, __spreadValues$2n({}, props));
};
const tFunc = i18next__default["default"].t;
const t = (id, defaultMessage, values) => {
  initI18n();
  return tFunc(id, defaultMessage, values);
};

var __defProp$2C = Object.defineProperty;
var __defProps$1C = Object.defineProperties;
var __getOwnPropDescs$1C = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2o = Object.getOwnPropertySymbols;
var __hasOwnProp$2o = Object.prototype.hasOwnProperty;
var __propIsEnum$2o = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2C = (obj, key, value) => key in obj ? __defProp$2C(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2m = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2o.call(b, prop))
      __defNormalProp$2C(a, prop, b[prop]);
  if (__getOwnPropSymbols$2o)
    for (var prop of __getOwnPropSymbols$2o(b)) {
      if (__propIsEnum$2o.call(b, prop))
        __defNormalProp$2C(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1C = (a, b) => __defProps$1C(a, __getOwnPropDescs$1C(b));
function InlineToast({ referenceElement, children, suffixIcon, placement }) {
  const styles = useStyles2(getStyles$1P);
  const theme = useTheme2();
  const middleware = [
    react$1.offset(8),
    react$1.flip({
      fallbackAxisSideDirection: "end",
      // see https://floating-ui.com/docs/flip#combining-with-shift
      crossAxis: false,
      boundary: document.body
    }),
    react$1.shift()
  ];
  const { context, refs, floatingStyles } = react$1.useFloating({
    open: true,
    placement,
    middleware,
    whileElementsMounted: react$1.autoUpdate,
    strategy: "fixed"
  });
  React.useLayoutEffect(() => {
    refs.setReference(referenceElement);
  }, [referenceElement, refs]);
  const { styles: placementStyles } = react$1.useTransitionStyles(context, {
    initial: ({ side }) => {
      return {
        opacity: 0,
        transform: getInitialTransform(side, theme)
      };
    },
    duration: theme.transitions.duration.shortest
  });
  return /* @__PURE__ */ React__default["default"].createElement(Portal$1, null, /* @__PURE__ */ React__default["default"].createElement("div", { style: __spreadValues$2m({ display: "inline-block" }, floatingStyles), ref: refs.setFloating, "aria-live": "polite" }, /* @__PURE__ */ React__default["default"].createElement("span", { className: css.cx(styles.root), style: placementStyles }, children && /* @__PURE__ */ React__default["default"].createElement("span", null, children), suffixIcon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: suffixIcon }))));
}
const getStyles$1P = (theme) => {
  return {
    root: css.css(__spreadProps$1C(__spreadValues$2m({}, theme.typography.bodySmall), {
      willChange: "transform",
      background: theme.components.tooltip.background,
      color: theme.components.tooltip.text,
      padding: theme.spacing(0.5, 1.5),
      // get's an extra .5 of vertical padding to account for the rounded corners
      borderRadius: theme.shape.radius.pill,
      display: "inline-flex",
      gap: theme.spacing(0.5),
      alignItems: "center"
    }))
  };
};
const getInitialTransform = (placement, theme) => {
  const gap = 1;
  switch (placement) {
    case "top":
      return `translateY(${theme.spacing(gap)})`;
    case "bottom":
      return `translateY(-${theme.spacing(gap)})`;
    case "left":
      return `translateX(${theme.spacing(gap)})`;
    case "right":
      return `translateX(-${theme.spacing(gap)})`;
  }
};

var __defProp$2B = Object.defineProperty;
var __defProps$1B = Object.defineProperties;
var __getOwnPropDescs$1B = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2n = Object.getOwnPropertySymbols;
var __hasOwnProp$2n = Object.prototype.hasOwnProperty;
var __propIsEnum$2n = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2B = (obj, key, value) => key in obj ? __defProp$2B(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2l = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2n.call(b, prop))
      __defNormalProp$2B(a, prop, b[prop]);
  if (__getOwnPropSymbols$2n)
    for (var prop of __getOwnPropSymbols$2n(b)) {
      if (__propIsEnum$2n.call(b, prop))
        __defNormalProp$2B(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1B = (a, b) => __defProps$1B(a, __getOwnPropDescs$1B(b));
var __objRest$19 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2n.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2n)
    for (var prop of __getOwnPropSymbols$2n(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2n.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const SHOW_SUCCESS_DURATION$1 = 2 * 1e3;
function ClipboardButton(_a) {
  var _b = _a, {
    onClipboardCopy,
    onClipboardError,
    children,
    getText,
    icon,
    variant
  } = _b, buttonProps = __objRest$19(_b, [
    "onClipboardCopy",
    "onClipboardError",
    "children",
    "getText",
    "icon",
    "variant"
  ]);
  const styles = useStyles2(getStyles$1O);
  const [showCopySuccess, setShowCopySuccess] = React.useState(false);
  React.useEffect(() => {
    let timeoutId;
    if (showCopySuccess) {
      timeoutId = setTimeout(() => {
        setShowCopySuccess(false);
      }, SHOW_SUCCESS_DURATION$1);
    }
    return () => {
      window.clearTimeout(timeoutId);
    };
  }, [showCopySuccess]);
  const buttonRef = React.useRef(null);
  const copyTextCallback = React.useCallback(async () => {
    const textToCopy = getText();
    try {
      await copyText(textToCopy, buttonRef);
      setShowCopySuccess(true);
      onClipboardCopy == null ? void 0 : onClipboardCopy(textToCopy);
    } catch (e) {
      onClipboardError == null ? void 0 : onClipboardError(textToCopy, e);
    }
  }, [getText, onClipboardCopy, onClipboardError]);
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, showCopySuccess && /* @__PURE__ */ React__default["default"].createElement(InlineToast, { placement: "top", referenceElement: buttonRef.current }, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "clipboard-button.inline-toast.success" }, "Copied")), /* @__PURE__ */ React__default["default"].createElement(
    Button,
    __spreadProps$1B(__spreadValues$2l({
      onClick: copyTextCallback,
      icon,
      variant: showCopySuccess ? "success" : variant,
      "aria-label": showCopySuccess ? "Copied" : void 0
    }, buttonProps), {
      className: css.cx(styles.button, showCopySuccess && styles.successButton, buttonProps.className),
      ref: buttonRef
    }),
    children,
    showCopySuccess && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.successOverlay }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "check" }))
  ));
}
const copyText = async (text, buttonRef) => {
  var _a;
  if (navigator.clipboard && window.isSecureContext) {
    return navigator.clipboard.writeText(text);
  } else {
    const textarea = document.createElement("textarea");
    (_a = buttonRef.current) == null ? void 0 : _a.appendChild(textarea);
    textarea.value = text;
    textarea.focus();
    textarea.select();
    document.execCommand("copy");
    textarea.remove();
  }
};
const getStyles$1O = (theme) => {
  return {
    button: css.css({
      position: "relative"
    }),
    successButton: css.css({
      "> *": css.css({
        visibility: "hidden"
      })
    }),
    successOverlay: css.css({
      position: "absolute",
      top: 0,
      bottom: 0,
      right: 0,
      left: 0,
      visibility: "visible"
      // re-visible the overlay
    })
  };
};

var __defProp$2A = Object.defineProperty;
var __defProps$1A = Object.defineProperties;
var __getOwnPropDescs$1A = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2m = Object.getOwnPropertySymbols;
var __hasOwnProp$2m = Object.prototype.hasOwnProperty;
var __propIsEnum$2m = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2A = (obj, key, value) => key in obj ? __defProp$2A(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2k = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2m.call(b, prop))
      __defNormalProp$2A(a, prop, b[prop]);
  if (__getOwnPropSymbols$2m)
    for (var prop of __getOwnPropSymbols$2m(b)) {
      if (__propIsEnum$2m.call(b, prop))
        __defNormalProp$2A(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1A = (a, b) => __defProps$1A(a, __getOwnPropDescs$1A(b));
var __objRest$18 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2m.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2m)
    for (var prop of __getOwnPropSymbols$2m(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2m.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Input = React__default["default"].forwardRef((props, ref) => {
  const _a = props, { className, addonAfter, addonBefore, prefix, suffix, invalid, loading, width = 0 } = _a, restProps = __objRest$18(_a, ["className", "addonAfter", "addonBefore", "prefix", "suffix", "invalid", "loading", "width"]);
  const [prefixRef, prefixRect] = useMeasure__default["default"]();
  const [suffixRef, suffixRect] = useMeasure__default["default"]();
  const theme = useTheme2();
  const styles = getInputStyles({ theme, invalid: !!invalid, width });
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.wrapper, className), "data-testid": "input-wrapper" }, !!addonBefore && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.addon }, addonBefore), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.inputWrapper }, prefix && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.prefix, ref: prefixRef }, prefix), /* @__PURE__ */ React__default["default"].createElement(
    "input",
    __spreadProps$1A(__spreadValues$2k({
      ref,
      className: styles.input
    }, restProps), {
      style: {
        paddingLeft: prefix ? prefixRect.width + 12 : void 0,
        paddingRight: suffix || loading ? suffixRect.width + 12 : void 0
      }
    })
  ), (suffix || loading) && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.suffix, ref: suffixRef }, loading && /* @__PURE__ */ React__default["default"].createElement(Spinner, { className: styles.loadingIndicator, inline: true }), suffix)), !!addonAfter && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.addon }, addonAfter));
});
Input.displayName = "Input";
const getInputStyles = stylesFactory(({ theme, invalid = false, width }) => {
  const prefixSuffixStaticWidth = "28px";
  const prefixSuffix = css.css({
    position: "absolute",
    top: 0,
    zIndex: 1,
    display: "flex",
    alignItems: "center",
    justifyContent: "center",
    flexGrow: 0,
    flexShrink: 0,
    fontSize: theme.typography.size.md,
    height: "100%",
    /* Min width specified for prefix/suffix classes used outside React component*/
    minWidth: prefixSuffixStaticWidth,
    color: theme.colors.text.secondary
  });
  return {
    // Wraps inputWrapper and addons
    wrapper: css.cx(
      css.css({
        label: "input-wrapper",
        display: "flex",
        width: width ? theme.spacing(width) : "100%",
        height: theme.spacing(theme.components.height.md),
        borderRadius: theme.shape.radius.default,
        "&:hover": {
          "> .prefix, .suffix, .input": {
            borderColor: invalid ? theme.colors.error.border : theme.colors.primary.border
          },
          // only show number buttons on hover
          "input[type='number']": {
            appearance: "textfield"
          },
          "input[type='number']::-webkit-inner-spin-button, input[type='number']::-webkit-outer-spin-button": {
            // Need type assertion here due to the use of !important
            // see https://github.com/frenic/csstype/issues/114#issuecomment-697201978
            // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
            WebkitAppearance: "inner-spin-button !important",
            opacity: 1
          }
        }
      })
    ),
    // Wraps input and prefix/suffix
    inputWrapper: css.css({
      label: "input-inputWrapper",
      position: "relative",
      flexGrow: 1,
      /* we want input to be above addons, especially for focused state */
      zIndex: 1,
      /* when input rendered with addon before only*/
      "&:not(:first-child):last-child": {
        "> input": {
          borderLeft: "none",
          borderTopLeftRadius: 0,
          borderBottomLeftRadius: 0
        }
      },
      /* when input rendered with addon after only*/
      "&:first-child:not(:last-child)": {
        "> input": {
          borderRight: "none",
          borderTopRightRadius: 0,
          borderBottomRightRadius: 0
        }
      },
      /* when rendered with addon before and after */
      "&:not(:first-child):not(:last-child)": {
        "> input": {
          borderRight: "none",
          borderTopRightRadius: 0,
          borderBottomRightRadius: 0,
          borderTopLeftRadius: 0,
          borderBottomLeftRadius: 0
        }
      },
      input: {
        /* paddings specified for classes used outside React component */
        "&:not(:first-child)": {
          paddingLeft: prefixSuffixStaticWidth
        },
        "&:not(:last-child)": {
          paddingRight: prefixSuffixStaticWidth
        },
        "&[readonly]": {
          cursor: "default"
        }
      }
    }),
    input: css.cx(
      getFocusStyle(theme),
      sharedInputStyle(theme, invalid),
      css.css({
        label: "input-input",
        position: "relative",
        zIndex: 0,
        flexGrow: 1,
        borderRadius: theme.shape.radius.default,
        height: "100%",
        width: "100%"
      })
    ),
    inputDisabled: css.css({
      backgroundColor: theme.colors.action.disabledBackground,
      color: theme.colors.action.disabledText,
      border: `1px solid ${theme.colors.action.disabledBackground}`,
      "&:focus": {
        boxShadow: "none"
      }
    }),
    addon: css.css({
      label: "input-addon",
      display: "flex",
      justifyContent: "center",
      alignItems: "center",
      flexGrow: 0,
      flexShrink: 0,
      position: "relative",
      "&:first-child": {
        borderTopRightRadius: 0,
        borderBottomRightRadius: 0,
        "> :last-child": {
          borderTopRightRadius: 0,
          borderBottomRightRadius: 0
        }
      },
      "&:last-child": {
        borderTopLeftRadius: 0,
        borderBottomLeftRadius: 0,
        "> :first-child": {
          borderTopLeftRadius: 0,
          borderBottomLeftRadius: 0
        }
      },
      "> *:focus": {
        /* we want anything that has focus and is an addon to be above input */
        zIndex: 2
      }
    }),
    prefix: css.cx(
      prefixSuffix,
      css.css({
        label: "input-prefix",
        paddingLeft: theme.spacing(1),
        paddingRight: theme.spacing(0.5),
        borderRight: "none",
        borderTopRightRadius: 0,
        borderBottomRightRadius: 0
      })
    ),
    suffix: css.cx(
      prefixSuffix,
      css.css({
        label: "input-suffix",
        paddingLeft: theme.spacing(1),
        paddingRight: theme.spacing(1),
        marginBottom: "-2px",
        borderLeft: "none",
        borderTopLeftRadius: 0,
        borderBottomLeftRadius: 0,
        right: 0
      })
    ),
    loadingIndicator: css.css({
      "& + *": {
        marginLeft: theme.spacing(0.5)
      }
    })
  };
});

function breakpointCSS(theme, prop, getCSS, key) {
  const value = prop[key];
  if (value !== void 0 && value !== null) {
    return {
      [theme.breakpoints.up(key)]: getCSS(value)
    };
  }
  return;
}
function getResponsiveStyle(theme, prop, getCSS) {
  if (prop === void 0 || prop === null) {
    return null;
  }
  if (typeof prop !== "object" || !("xs" in prop)) {
    return getCSS(prop);
  }
  return [
    breakpointCSS(theme, prop, getCSS, "xs"),
    breakpointCSS(theme, prop, getCSS, "sm"),
    breakpointCSS(theme, prop, getCSS, "md"),
    breakpointCSS(theme, prop, getCSS, "lg"),
    breakpointCSS(theme, prop, getCSS, "xl"),
    breakpointCSS(theme, prop, getCSS, "xxl")
  ];
}

var __defProp$2z = Object.defineProperty;
var __getOwnPropSymbols$2l = Object.getOwnPropertySymbols;
var __hasOwnProp$2l = Object.prototype.hasOwnProperty;
var __propIsEnum$2l = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2z = (obj, key, value) => key in obj ? __defProp$2z(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2j = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2l.call(b, prop))
      __defNormalProp$2z(a, prop, b[prop]);
  if (__getOwnPropSymbols$2l)
    for (var prop of __getOwnPropSymbols$2l(b)) {
      if (__propIsEnum$2l.call(b, prop))
        __defNormalProp$2z(a, prop, b[prop]);
    }
  return a;
};
var __objRest$17 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2l.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2l)
    for (var prop of __getOwnPropSymbols$2l(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2l.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Stack = React__default["default"].forwardRef((props, ref) => {
  const _a = props, { gap = 1, alignItems, justifyContent, direction, wrap, children, grow, shrink, basis, flex } = _a, rest = __objRest$17(_a, ["gap", "alignItems", "justifyContent", "direction", "wrap", "children", "grow", "shrink", "basis", "flex"]);
  const styles = useStyles2(getStyles$1N, gap, alignItems, justifyContent, direction, wrap, grow, shrink, basis, flex);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$2j({ ref, className: styles.flex }, rest), children);
});
Stack.displayName = "Stack";
const getStyles$1N = (theme, gap, alignItems, justifyContent, direction, wrap, grow, shrink, basis, flex) => {
  return {
    flex: css.css([
      {
        display: "flex"
      },
      getResponsiveStyle(theme, direction, (val) => ({
        flexDirection: val
      })),
      getResponsiveStyle(theme, wrap, (val) => ({
        flexWrap: val
      })),
      getResponsiveStyle(theme, alignItems, (val) => ({
        alignItems: val
      })),
      getResponsiveStyle(theme, justifyContent, (val) => ({
        justifyContent: val
      })),
      getResponsiveStyle(theme, gap, (val) => ({
        gap: theme.spacing(val)
      })),
      getResponsiveStyle(theme, grow, (val) => ({
        flexGrow: val
      })),
      getResponsiveStyle(theme, shrink, (val) => ({
        flexShrink: val
      })),
      getResponsiveStyle(theme, basis, (val) => ({
        flexBasis: val
      })),
      getResponsiveStyle(theme, flex, (val) => ({
        flex: val
      }))
    ])
  };
};

function DropdownIndicator({ selectProps }) {
  const isOpen = selectProps.menuIsOpen;
  const icon = isOpen ? "search" : "angle-down";
  const size = isOpen ? "sm" : "md";
  return /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, size });
}

const IndicatorsContainer = React__default["default"].forwardRef((props, ref) => {
  const { children } = props;
  const theme = useTheme2();
  const styles = getInputStyles({ theme, invalid: false });
  return /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      className: css.cx(
        styles.suffix,
        css.css({
          position: "relative"
        })
      ),
      ref
    },
    children
  );
});
IndicatorsContainer.displayName = "IndicatorsContainer";

var __defProp$2y = Object.defineProperty;
var __defProps$1z = Object.defineProperties;
var __getOwnPropDescs$1z = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2k = Object.getOwnPropertySymbols;
var __hasOwnProp$2k = Object.prototype.hasOwnProperty;
var __propIsEnum$2k = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2y = (obj, key, value) => key in obj ? __defProp$2y(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2i = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2k.call(b, prop))
      __defNormalProp$2y(a, prop, b[prop]);
  if (__getOwnPropSymbols$2k)
    for (var prop of __getOwnPropSymbols$2k(b)) {
      if (__propIsEnum$2k.call(b, prop))
        __defNormalProp$2y(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1z = (a, b) => __defProps$1z(a, __getOwnPropDescs$1z(b));
var __objRest$16 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2k.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2k)
    for (var prop of __getOwnPropSymbols$2k(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2k.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const InputControl$1 = React__default["default"].forwardRef(
  function InputControl2(_a, ref) {
    var _b = _a, { focused, invalid, disabled, children, innerProps, prefix } = _b; __objRest$16(_b, ["focused", "invalid", "disabled", "children", "innerProps", "prefix"]);
    const styles = useStyles2(getInputControlStyles, invalid, !!prefix);
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1z(__spreadValues$2i({ className: styles.input }, innerProps), { ref }), prefix && /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.prefix) }, prefix), children);
  }
);
const getInputControlStyles = (theme, invalid, withPrefix) => {
  const styles = getInputStyles({ theme, invalid });
  return {
    input: css.cx(
      inputPadding(theme),
      css.css({
        width: "100%",
        maxWidth: "100%",
        display: "flex",
        flexDirection: "row",
        alignItems: "center",
        flexWrap: "wrap",
        justifyContent: "space-between",
        paddingRight: 0,
        position: "relative",
        boxSizing: "border-box"
      }),
      withPrefix && css.css({
        paddingLeft: 0
      })
    ),
    prefix: css.cx(
      styles.prefix,
      css.css({
        position: "relative"
      })
    )
  };
};

const getSelectStyles = stylesFactory((theme) => {
  return {
    menu: css.css({
      label: "grafana-select-menu",
      background: theme.components.dropdown.background,
      boxShadow: theme.shadows.z3,
      position: "relative",
      minWidth: "100%",
      zIndex: 1
    }),
    option: css.css({
      label: "grafana-select-option",
      padding: "8px",
      display: "flex",
      alignItems: "center",
      flexDirection: "row",
      flexShrink: 0,
      whiteSpace: "nowrap",
      cursor: "pointer",
      borderLeft: "2px solid transparent",
      "&:hover": {
        background: theme.colors.action.hover,
        "@media (forced-colors: active), (prefers-contrast: more)": {
          border: `1px solid ${theme.colors.primary.border}`
        }
      }
    }),
    optionIcon: css.css({
      marginRight: theme.spacing(1)
    }),
    optionImage: css.css({
      label: "grafana-select-option-image",
      width: "16px",
      marginRight: "10px"
    }),
    optionDescription: css.css({
      label: "grafana-select-option-description",
      fontWeight: "normal",
      fontSize: theme.typography.size.sm,
      color: theme.colors.text.secondary,
      whiteSpace: "normal",
      lineHeight: theme.typography.body.lineHeight
    }),
    optionBody: css.css({
      label: "grafana-select-option-body",
      display: "flex",
      fontWeight: theme.typography.fontWeightMedium,
      flexDirection: "column",
      flexGrow: 1
    }),
    optionFocused: css.css({
      label: "grafana-select-option-focused",
      background: theme.colors.action.focus,
      "@media (forced-colors: active), (prefers-contrast: more)": {
        border: `1px solid ${theme.colors.primary.border}`
      }
    }),
    optionSelected: css.css({
      background: theme.colors.action.selected
    }),
    optionDisabled: css.css({
      label: "grafana-select-option-disabled",
      backgroundColor: theme.colors.action.disabledBackground,
      color: theme.colors.action.disabledText,
      cursor: "not-allowed"
    }),
    singleValue: css.css({
      label: "grafana-select-single-value",
      color: theme.components.input.text,
      gridArea: "1 / 1 / 2 / 3",
      whiteSpace: "nowrap",
      overflow: "hidden",
      textOverflow: "ellipsis",
      boxSizing: "border-box",
      maxWidth: "100%"
    }),
    valueContainer: css.css({
      label: "grafana-select-value-container",
      alignItems: "center",
      display: "grid",
      position: "relative",
      boxSizing: "border-box",
      flex: "1 1 0%",
      outline: "none",
      overflow: "hidden"
    }),
    valueContainerMulti: css.css({
      label: "grafana-select-value-container-multi",
      flexWrap: "wrap",
      display: "flex"
    }),
    valueContainerMultiNoWrap: css.css({
      display: "grid",
      gridAutoFlow: "column"
    }),
    loadingMessage: css.css({
      label: "grafana-select-loading-message",
      padding: theme.spacing(1),
      textAlign: "center",
      width: "100%"
    }),
    multiValueContainer: css.css({
      label: "grafana-select-multi-value-container",
      display: "flex",
      alignItems: "center",
      lineHeight: 1,
      background: theme.colors.background.secondary,
      borderRadius: theme.shape.radius.default,
      margin: theme.spacing(0.25, 1, 0.25, 0),
      padding: theme.spacing(0.25, 0, 0.25, 1),
      color: theme.colors.text.primary,
      fontSize: theme.typography.size.sm,
      overflow: "hidden",
      whiteSpace: "nowrap",
      "&:hover": {
        background: theme.colors.emphasize(theme.colors.background.secondary)
      }
    }),
    multiValueRemove: css.css({
      label: "grafana-select-multi-value-remove",
      margin: theme.spacing(0, 0.5),
      cursor: "pointer",
      svg: {
        marginBottom: 0
      }
    }),
    singleValueRemove: css.css({
      cursor: "pointer",
      "&:hover": {
        color: theme.colors.text.primary
      }
    })
  };
});

var __defProp$2x = Object.defineProperty;
var __defProps$1y = Object.defineProperties;
var __getOwnPropDescs$1y = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2j = Object.getOwnPropertySymbols;
var __hasOwnProp$2j = Object.prototype.hasOwnProperty;
var __propIsEnum$2j = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2x = (obj, key, value) => key in obj ? __defProp$2x(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2h = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2j.call(b, prop))
      __defNormalProp$2x(a, prop, b[prop]);
  if (__getOwnPropSymbols$2j)
    for (var prop of __getOwnPropSymbols$2j(b)) {
      if (__propIsEnum$2j.call(b, prop))
        __defNormalProp$2x(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1y = (a, b) => __defProps$1y(a, __getOwnPropDescs$1y(b));
const MultiValueContainer = ({ innerProps, children }) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1y(__spreadValues$2h({}, innerProps), { className: styles.multiValueContainer }), children);
};
const MultiValueRemove = ({ children, innerProps }) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  return /* @__PURE__ */ React__default["default"].createElement(IconButton, __spreadProps$1y(__spreadValues$2h({}, innerProps), { name: "times", size: "sm", className: styles.multiValueRemove, tooltip: "Remove" }));
};

var __defProp$2w = Object.defineProperty;
var __defProps$1x = Object.defineProperties;
var __getOwnPropDescs$1x = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2i = Object.getOwnPropertySymbols;
var __hasOwnProp$2i = Object.prototype.hasOwnProperty;
var __propIsEnum$2i = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2w = (obj, key, value) => key in obj ? __defProp$2w(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2g = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2i.call(b, prop))
      __defNormalProp$2w(a, prop, b[prop]);
  if (__getOwnPropSymbols$2i)
    for (var prop of __getOwnPropSymbols$2i(b)) {
      if (__propIsEnum$2i.call(b, prop))
        __defNormalProp$2w(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1x = (a, b) => __defProps$1x(a, __getOwnPropDescs$1x(b));
const SelectContainer = (props) => {
  const {
    isDisabled,
    isFocused,
    children,
    selectProps: { invalid = false }
  } = props;
  const styles = useStyles2(getSelectContainerStyles, isFocused, isDisabled, invalid);
  return /* @__PURE__ */ React__default["default"].createElement(ReactSelect.components.SelectContainer, __spreadProps$1x(__spreadValues$2g({}, props), { className: css.cx(styles.wrapper, props.className) }), children);
};
const getSelectContainerStyles = (theme, focused, disabled, invalid) => {
  const styles = getInputStyles({ theme, invalid });
  return {
    wrapper: css.cx(
      styles.wrapper,
      sharedInputStyle(theme, invalid),
      focused && css.css(getFocusStyles(theme)),
      disabled && styles.inputDisabled,
      css.css({
        position: "relative",
        boxSizing: "border-box",
        /* The display property is set by the styles prop in SelectBase because it's dependant on the width prop  */
        flexDirection: "row",
        flexWrap: "wrap",
        alignItems: "stretch",
        justifyContent: "space-between",
        minHeight: "32px",
        height: "auto",
        maxWidth: "100%",
        /* Input padding is applied to the InputControl so the menu is aligned correctly */
        padding: 0,
        cursor: disabled ? "not-allowed" : "pointer"
      })
    )
  };
};

var __defProp$2v = Object.defineProperty;
var __defProps$1w = Object.defineProperties;
var __getOwnPropDescs$1w = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2h = Object.getOwnPropertySymbols;
var __hasOwnProp$2h = Object.prototype.hasOwnProperty;
var __propIsEnum$2h = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2v = (obj, key, value) => key in obj ? __defProp$2v(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2f = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2h.call(b, prop))
      __defNormalProp$2v(a, prop, b[prop]);
  if (__getOwnPropSymbols$2h)
    for (var prop of __getOwnPropSymbols$2h(b)) {
      if (__propIsEnum$2h.call(b, prop))
        __defNormalProp$2v(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1w = (a, b) => __defProps$1w(a, __getOwnPropDescs$1w(b));
var __objRest$15 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2h.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2h)
    for (var prop of __getOwnPropSymbols$2h(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2h.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const SelectMenu = ({ children, maxHeight, innerRef, innerProps }) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1w(__spreadValues$2f({}, innerProps), { className: styles.menu, style: { maxHeight }, "aria-label": "Select options menu" }), /* @__PURE__ */ React__default["default"].createElement(CustomScrollbar, { scrollRefCallback: innerRef, autoHide: false, autoHeightMax: "inherit", hideHorizontalTrack: true }, children));
};
SelectMenu.displayName = "SelectMenu";
const VIRTUAL_LIST_ITEM_HEIGHT = 37;
const VIRTUAL_LIST_WIDTH_ESTIMATE_MULTIPLIER = 8;
const VIRTUAL_LIST_PADDING = 8;
const VIRTUAL_LIST_WIDTH_EXTRA = 36;
const VirtualizedSelectMenu = ({ children, maxHeight, options, getValue }) => {
  var _a;
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  const [value] = getValue();
  const valueIndex = value ? options.findIndex((option) => option.value === value.value) : 0;
  const valueYOffset = valueIndex * VIRTUAL_LIST_ITEM_HEIGHT;
  if (!Array.isArray(children)) {
    return null;
  }
  const longestOption = (_a = lodash.max(options.map((option) => {
    var _a2;
    return (_a2 = option.label) == null ? void 0 : _a2.length;
  }))) != null ? _a : 0;
  const widthEstimate = longestOption * VIRTUAL_LIST_WIDTH_ESTIMATE_MULTIPLIER + VIRTUAL_LIST_PADDING * 2 + VIRTUAL_LIST_WIDTH_EXTRA;
  const heightEstimate = Math.min(options.length * VIRTUAL_LIST_ITEM_HEIGHT, maxHeight);
  const scrollOffset = Math.max(0, valueYOffset - heightEstimate / 2);
  return /* @__PURE__ */ React__default["default"].createElement(
    reactWindow.FixedSizeList,
    {
      className: styles.menu,
      height: heightEstimate,
      width: widthEstimate,
      "aria-label": "Select options menu",
      itemCount: children.length,
      itemSize: VIRTUAL_LIST_ITEM_HEIGHT,
      initialScrollOffset: scrollOffset
    },
    ({ index, style }) => /* @__PURE__ */ React__default["default"].createElement("div", { style: __spreadProps$1w(__spreadValues$2f({}, style), { overflow: "hidden" }) }, children[index])
  );
};
VirtualizedSelectMenu.displayName = "VirtualizedSelectMenu";
const SelectMenuOptions = ({
  children,
  data: data$1,
  innerProps,
  innerRef,
  isFocused,
  isSelected,
  renderOptionLabel
}) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  const icon = data$1.icon ? data.toIconName(data$1.icon) : void 0;
  const _a = innerProps, rest = __objRest$15(_a, ["onMouseMove", "onMouseOver"]);
  return /* @__PURE__ */ React__default["default"].createElement(
    "div",
    __spreadProps$1w(__spreadValues$2f({
      ref: innerRef,
      className: css.cx(
        styles.option,
        isFocused && styles.optionFocused,
        isSelected && styles.optionSelected,
        data$1.isDisabled && styles.optionDisabled
      )
    }, rest), {
      "aria-label": "Select option",
      title: data$1.title
    }),
    icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, className: styles.optionIcon }),
    data$1.imgUrl && /* @__PURE__ */ React__default["default"].createElement("img", { className: styles.optionImage, src: data$1.imgUrl, alt: data$1.label || String(data$1.value) }),
    /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.optionBody }, /* @__PURE__ */ React__default["default"].createElement("span", null, renderOptionLabel ? renderOptionLabel(data$1) : children), data$1.description && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.optionDescription }, data$1.description), data$1.component && /* @__PURE__ */ React__default["default"].createElement(data$1.component, null))
  );
};
SelectMenuOptions.displayName = "SelectMenuOptions";

class UnthemedValueContainer extends React.Component {
  render() {
    const { children } = this.props;
    const { selectProps } = this.props;
    if (selectProps && Array.isArray(children) && Array.isArray(children[0]) && selectProps.maxVisibleValues !== void 0 && !(selectProps.showAllSelectedWhenOpen && selectProps.menuIsOpen)) {
      const [valueChildren, ...otherChildren] = children;
      const truncatedValues = valueChildren.slice(0, selectProps.maxVisibleValues);
      return this.renderContainer([truncatedValues, ...otherChildren]);
    }
    return this.renderContainer(children);
  }
  renderContainer(children) {
    var _a, _b;
    const { isMulti, theme, selectProps } = this.props;
    const noWrap = ((_a = this.props.selectProps) == null ? void 0 : _a.noMultiValueWrap) && !((_b = this.props.selectProps) == null ? void 0 : _b.menuIsOpen);
    const styles = getSelectStyles(theme);
    const dataTestid = selectProps["data-testid"];
    const className = css.cx(styles.valueContainer, {
      [styles.valueContainerMulti]: isMulti && !noWrap,
      [styles.valueContainerMultiNoWrap]: isMulti && noWrap
    });
    return /* @__PURE__ */ React__default["default"].createElement("div", { "data-testid": dataTestid, className }, children);
  }
}
const ValueContainer = withTheme2(UnthemedValueContainer);

var __getOwnPropSymbols$2g = Object.getOwnPropertySymbols;
var __hasOwnProp$2g = Object.prototype.hasOwnProperty;
var __propIsEnum$2g = Object.prototype.propertyIsEnumerable;
var __objRest$14 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2g.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2g)
    for (var prop of __getOwnPropSymbols$2g(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2g.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const cleanValue = (value, options) => {
  if (Array.isArray(value)) {
    const filtered = value.filter(Boolean);
    return (filtered == null ? void 0 : filtered.length) ? filtered : void 0;
  }
  if (typeof value === "object") {
    return [value];
  }
  if (typeof value === "string" || typeof value === "number") {
    const selectedValue = findSelectedValue(value, options);
    if (selectedValue) {
      return [selectedValue];
    }
  }
  return void 0;
};
const findSelectedValue = (value, options) => {
  for (const option of options) {
    if ("options" in option) {
      let found = findSelectedValue(value, option.options);
      if (found) {
        return found;
      }
    } else if ("value" in option && option.value === value) {
      return option;
    }
  }
  return null;
};
const omitDescriptions = (options) => {
  return options.map((_a) => {
    var _b = _a, rest = __objRest$14(_b, ["description"]);
    return rest;
  });
};

var __defProp$2u = Object.defineProperty;
var __defProps$1v = Object.defineProperties;
var __getOwnPropDescs$1v = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2f = Object.getOwnPropertySymbols;
var __hasOwnProp$2f = Object.prototype.hasOwnProperty;
var __propIsEnum$2f = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2u = (obj, key, value) => key in obj ? __defProp$2u(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2e = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2f.call(b, prop))
      __defNormalProp$2u(a, prop, b[prop]);
  if (__getOwnPropSymbols$2f)
    for (var prop of __getOwnPropSymbols$2f(b)) {
      if (__propIsEnum$2f.call(b, prop))
        __defNormalProp$2u(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1v = (a, b) => __defProps$1v(a, __getOwnPropDescs$1v(b));
var __objRest$13 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2f.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2f)
    for (var prop of __getOwnPropSymbols$2f(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2f.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const CustomControl = (props) => {
  const {
    children,
    innerProps,
    selectProps: { menuIsOpen, onMenuClose, onMenuOpen },
    isFocused,
    isMulti,
    getValue,
    innerRef
  } = props;
  const selectProps = props.selectProps;
  if (selectProps.renderControl) {
    return React__default["default"].createElement(selectProps.renderControl, {
      isOpen: menuIsOpen,
      value: isMulti ? getValue() : getValue()[0],
      ref: innerRef,
      onClick: menuIsOpen ? onMenuClose : onMenuOpen,
      onBlur: onMenuClose,
      disabled: !!selectProps.disabled,
      invalid: !!selectProps.invalid
    });
  }
  return /* @__PURE__ */ React__default["default"].createElement(
    InputControl$1,
    {
      ref: innerRef,
      innerProps,
      prefix: selectProps.prefix,
      focused: isFocused,
      invalid: !!selectProps.invalid,
      disabled: !!selectProps.disabled
    },
    children
  );
};
function SelectBase(_a) {
  var _b = _a, {
    allowCustomValue = false,
    allowCreateWhileLoading = false,
    "aria-label": ariaLabel,
    "data-testid": dataTestid,
    autoFocus = false,
    backspaceRemovesValue = true,
    blurInputOnSelect,
    cacheOptions,
    className,
    closeMenuOnSelect = true,
    components,
    createOptionPosition = "last",
    defaultOptions,
    defaultValue,
    disabled = false,
    filterOption,
    formatCreateLabel,
    getOptionLabel,
    getOptionValue,
    inputValue,
    invalid,
    isClearable = false,
    id,
    isLoading = false,
    isMulti = false,
    inputId,
    isOpen,
    isOptionDisabled,
    isSearchable = true,
    loadOptions,
    loadingMessage = "Loading options...",
    maxMenuHeight = 300,
    minMenuHeight,
    maxVisibleValues,
    menuPlacement = "auto",
    menuPosition,
    menuShouldPortal = true,
    noOptionsMessage = i18next.t("grafana-ui.select.no-options-label", "No options found"),
    onBlur,
    onChange,
    onCloseMenu,
    onCreateOption,
    onInputChange,
    onKeyDown,
    onMenuScrollToBottom,
    onMenuScrollToTop,
    onOpenMenu,
    onFocus,
    openMenuOnFocus = false,
    options = [],
    placeholder = i18next.t("grafana-ui.select.placeholder", "Choose"),
    prefix,
    renderControl,
    showAllSelectedWhenOpen = true,
    tabSelectsValue = true,
    value,
    virtualized = false,
    noMultiValueWrap,
    width,
    isValidNewOption,
    formatOptionLabel,
    hideSelectedOptions
  } = _b, rest = __objRest$13(_b, [
    "allowCustomValue",
    "allowCreateWhileLoading",
    "aria-label",
    "data-testid",
    "autoFocus",
    "backspaceRemovesValue",
    "blurInputOnSelect",
    "cacheOptions",
    "className",
    "closeMenuOnSelect",
    "components",
    "createOptionPosition",
    "defaultOptions",
    "defaultValue",
    "disabled",
    "filterOption",
    "formatCreateLabel",
    "getOptionLabel",
    "getOptionValue",
    "inputValue",
    "invalid",
    "isClearable",
    "id",
    "isLoading",
    "isMulti",
    "inputId",
    "isOpen",
    "isOptionDisabled",
    "isSearchable",
    "loadOptions",
    "loadingMessage",
    "maxMenuHeight",
    "minMenuHeight",
    "maxVisibleValues",
    "menuPlacement",
    "menuPosition",
    "menuShouldPortal",
    "noOptionsMessage",
    "onBlur",
    "onChange",
    "onCloseMenu",
    "onCreateOption",
    "onInputChange",
    "onKeyDown",
    "onMenuScrollToBottom",
    "onMenuScrollToTop",
    "onOpenMenu",
    "onFocus",
    "openMenuOnFocus",
    "options",
    "placeholder",
    "prefix",
    "renderControl",
    "showAllSelectedWhenOpen",
    "tabSelectsValue",
    "value",
    "virtualized",
    "noMultiValueWrap",
    "width",
    "isValidNewOption",
    "formatOptionLabel",
    "hideSelectedOptions"
  ]);
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  const reactSelectRef = React.useRef(null);
  const [closeToBottom, setCloseToBottom] = React.useState(false);
  const selectStyles = useCustomSelectStyles(theme, width);
  const [hasInputValue, setHasInputValue] = React.useState(!!inputValue);
  React.useEffect(() => {
    if (loadOptions && isOpen && reactSelectRef.current && reactSelectRef.current.controlRef && menuPlacement === "auto") {
      const distance = window.innerHeight - reactSelectRef.current.controlRef.getBoundingClientRect().bottom;
      setCloseToBottom(distance < maxMenuHeight);
    }
  }, [maxMenuHeight, menuPlacement, loadOptions, isOpen]);
  const onChangeWithEmpty = React.useCallback(
    (value2, action) => {
      if (isMulti && (value2 === void 0 || value2 === null)) {
        return onChange([], action);
      }
      onChange(value2, action);
    },
    [isMulti, onChange]
  );
  let ReactSelectComponent = ReactSelect__default["default"];
  const creatableProps = {};
  let asyncSelectProps = {};
  let selectedValue;
  if (isMulti && loadOptions) {
    selectedValue = value;
  } else {
    if (isMulti && value && Array.isArray(value) && !loadOptions) {
      selectedValue = value.map((v) => {
        var _a2;
        const selectableValue = findSelectedValue((_a2 = v.value) != null ? _a2 : v, options);
        if (!allowCustomValue || selectableValue) {
          return selectableValue;
        }
        return typeof v === "string" ? data.toOption(v) : v;
      });
    } else if (loadOptions) {
      const hasValue = defaultValue || value;
      selectedValue = hasValue ? [hasValue] : [];
    } else {
      selectedValue = cleanValue(value, options);
    }
  }
  const commonSelectProps = {
    "aria-label": ariaLabel,
    "data-testid": dataTestid,
    autoFocus,
    backspaceRemovesValue,
    blurInputOnSelect,
    captureMenuScroll: onMenuScrollToBottom || onMenuScrollToTop,
    closeMenuOnSelect,
    // We don't want to close if we're actually scrolling the menu
    // So only close if none of the parents are the select menu itself
    defaultValue,
    // Also passing disabled, as this is the new Select API, and I want to use this prop instead of react-select's one
    disabled,
    // react-select always tries to filter the options even at first menu open, which is a problem for performance
    // in large lists. So we set it to not try to filter the options if there is no input value.
    filterOption: hasInputValue ? filterOption : null,
    getOptionLabel,
    getOptionValue,
    hideSelectedOptions,
    inputValue,
    invalid,
    isClearable,
    id,
    // Passing isDisabled as react-select accepts this prop
    isDisabled: disabled,
    isLoading,
    isMulti,
    inputId,
    isOptionDisabled,
    isSearchable,
    maxMenuHeight,
    minMenuHeight,
    maxVisibleValues,
    menuIsOpen: isOpen,
    menuPlacement: menuPlacement === "auto" && closeToBottom ? "top" : menuPlacement,
    menuPosition,
    menuShouldBlockScroll: true,
    menuPortalTarget: menuShouldPortal && typeof document !== "undefined" ? document.body : void 0,
    menuShouldScrollIntoView: false,
    onBlur,
    onChange: onChangeWithEmpty,
    onInputChange: (val, actionMeta) => {
      var _a2;
      const newValue = (_a2 = onInputChange == null ? void 0 : onInputChange(val, actionMeta)) != null ? _a2 : val;
      const newHasValue = !!newValue;
      if (newHasValue !== hasInputValue) {
        setHasInputValue(newHasValue);
      }
      return newValue;
    },
    onKeyDown,
    onMenuClose: onCloseMenu,
    onMenuOpen: onOpenMenu,
    onMenuScrollToBottom,
    onMenuScrollToTop,
    onFocus,
    formatOptionLabel,
    openMenuOnFocus,
    options: virtualized ? omitDescriptions(options) : options,
    placeholder,
    prefix,
    renderControl,
    showAllSelectedWhenOpen,
    tabSelectsValue,
    value: isMulti ? selectedValue : selectedValue == null ? void 0 : selectedValue[0],
    noMultiValueWrap
  };
  if (allowCustomValue) {
    ReactSelectComponent = Creatable__default["default"];
    creatableProps.allowCreateWhileLoading = allowCreateWhileLoading;
    creatableProps.formatCreateLabel = formatCreateLabel != null ? formatCreateLabel : defaultFormatCreateLabel;
    creatableProps.onCreateOption = onCreateOption;
    creatableProps.createOptionPosition = createOptionPosition;
    creatableProps.isValidNewOption = isValidNewOption;
  }
  if (loadOptions) {
    ReactSelectComponent = allowCustomValue ? AsyncCreatable__default["default"] : ReactAsyncSelect__default["default"];
    asyncSelectProps = {
      loadOptions,
      cacheOptions,
      defaultOptions
    };
  }
  const SelectMenuComponent = virtualized ? VirtualizedSelectMenu : SelectMenu;
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(
    ReactSelectComponent,
    __spreadValues$2e(__spreadValues$2e(__spreadValues$2e(__spreadValues$2e({
      ref: reactSelectRef,
      components: __spreadValues$2e({
        MenuList: SelectMenuComponent,
        Group: SelectOptionGroup,
        ValueContainer,
        IndicatorsContainer: CustomIndicatorsContainer,
        IndicatorSeparator,
        Control: CustomControl,
        Option: SelectMenuOptions,
        ClearIndicator(props) {
          const { clearValue } = props;
          return /* @__PURE__ */ React__default["default"].createElement(
            Icon,
            {
              name: "times",
              role: "button",
              "aria-label": "select-clear-value",
              className: styles.singleValueRemove,
              onMouseDown: (e) => {
                e.preventDefault();
                e.stopPropagation();
                clearValue();
              }
            }
          );
        },
        LoadingIndicator() {
          return /* @__PURE__ */ React__default["default"].createElement(Spinner, { inline: true });
        },
        LoadingMessage() {
          return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.loadingMessage }, loadingMessage);
        },
        NoOptionsMessage() {
          return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.loadingMessage, "aria-label": "No options provided" }, noOptionsMessage);
        },
        DropdownIndicator,
        SingleValue(props) {
          return /* @__PURE__ */ React__default["default"].createElement(SingleValue, __spreadProps$1v(__spreadValues$2e({}, props), { isDisabled: disabled }));
        },
        SelectContainer,
        MultiValueContainer,
        MultiValueRemove: !disabled ? MultiValueRemove : () => null
      }, components),
      styles: selectStyles,
      className
    }, commonSelectProps), creatableProps), asyncSelectProps), rest)
  ));
}
function defaultFormatCreateLabel(input) {
  return /* @__PURE__ */ React__default["default"].createElement("div", { style: { display: "flex", gap: "8px", alignItems: "center" } }, /* @__PURE__ */ React__default["default"].createElement("div", null, input), /* @__PURE__ */ React__default["default"].createElement("div", { style: { flexGrow: 1 } }), /* @__PURE__ */ React__default["default"].createElement("div", { className: "muted small", style: { display: "flex", gap: "8px", alignItems: "center" } }, "Hit enter to add"));
}
function CustomIndicatorsContainer(props) {
  const { showAllSelectedWhenOpen, maxVisibleValues, menuIsOpen } = props.selectProps;
  const value = props.getValue();
  if (maxVisibleValues !== void 0 && Array.isArray(props.children)) {
    const selectedValuesCount = value.length;
    if (selectedValuesCount > maxVisibleValues && !(showAllSelectedWhenOpen && menuIsOpen)) {
      const indicatorChildren = [...props.children];
      indicatorChildren.splice(
        -1,
        0,
        /* @__PURE__ */ React__default["default"].createElement("span", { key: "excess-values", id: "excess-values" }, "(+", selectedValuesCount - maxVisibleValues, ")")
      );
      return /* @__PURE__ */ React__default["default"].createElement(IndicatorsContainer, __spreadValues$2e({}, props), indicatorChildren);
    }
  }
  return /* @__PURE__ */ React__default["default"].createElement(IndicatorsContainer, __spreadValues$2e({}, props));
}
function IndicatorSeparator() {
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null);
}

var __defProp$2t = Object.defineProperty;
var __defProps$1u = Object.defineProperties;
var __getOwnPropDescs$1u = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2e = Object.getOwnPropertySymbols;
var __hasOwnProp$2e = Object.prototype.hasOwnProperty;
var __propIsEnum$2e = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2t = (obj, key, value) => key in obj ? __defProp$2t(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2d = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2e.call(b, prop))
      __defNormalProp$2t(a, prop, b[prop]);
  if (__getOwnPropSymbols$2e)
    for (var prop of __getOwnPropSymbols$2e(b)) {
      if (__propIsEnum$2e.call(b, prop))
        __defNormalProp$2t(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1u = (a, b) => __defProps$1u(a, __getOwnPropDescs$1u(b));
function Select(props) {
  return /* @__PURE__ */ React__default["default"].createElement(SelectBase, __spreadValues$2d({}, props));
}
function MultiSelect(props) {
  return /* @__PURE__ */ React__default["default"].createElement(SelectBase, __spreadProps$1u(__spreadValues$2d({}, props), { isMulti: true }));
}
function AsyncSelect(props) {
  return /* @__PURE__ */ React__default["default"].createElement(SelectBase, __spreadValues$2d({}, props));
}
function VirtualizedSelect(props) {
  return /* @__PURE__ */ React__default["default"].createElement(SelectBase, __spreadValues$2d({ virtualized: true }, props));
}
function AsyncVirtualizedSelect(props) {
  return /* @__PURE__ */ React__default["default"].createElement(SelectBase, __spreadValues$2d({ virtualized: true }, props));
}
function AsyncMultiSelect(props) {
  return /* @__PURE__ */ React__default["default"].createElement(SelectBase, __spreadProps$1u(__spreadValues$2d({}, props), { isMulti: true }));
}

const onChangeCascader = (onChanged) => (values, options) => {
  if (onChanged) {
    onChanged(
      values.map((value) => String(value)),
      fromRCOptions(options)
    );
  }
};
const onLoadDataCascader = (onLoadData) => (options) => {
  if (onLoadData) {
    onLoadData(fromRCOptions(options));
  }
};
const fromRCOptions = (options) => {
  return options.map(fromRCOption);
};
const fromRCOption = (option) => {
  var _a;
  return {
    value: (_a = option.value) != null ? _a : "",
    label: option.label
  };
};

var __defProp$2s = Object.defineProperty;
var __defNormalProp$2s = (obj, key, value) => key in obj ? __defProp$2s(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$q = (obj, key, value) => {
  __defNormalProp$2s(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
const disableDivFocus = css.css({
  "&:focus": {
    outline: "none"
  }
});
const DEFAULT_SEPARATOR = " / ";
class Cascader extends React.PureComponent {
  constructor(props) {
    super(props);
    __publicField$q(this, "flattenOptions", (options, optionPath = []) => {
      let selectOptions = [];
      for (const option of options) {
        const cpy = [...optionPath];
        cpy.push(option);
        if (!option.items || option.items.length === 0) {
          selectOptions.push({
            singleLabel: cpy[cpy.length - 1].label,
            label: cpy.map((o) => o.label).join(this.props.separator || DEFAULT_SEPARATOR),
            value: cpy.map((o) => o.value)
          });
        } else {
          selectOptions = [...selectOptions, ...this.flattenOptions(option.items, cpy)];
        }
      }
      return selectOptions;
    });
    __publicField$q(this, "getSearchableOptions", memoize__default["default"]((options) => this.flattenOptions(options)));
    //For rc-cascader
    __publicField$q(this, "onChange", (value, selectedOptions) => {
      const activeLabel = this.props.hideActiveLevelLabel ? "" : this.props.displayAllSelectedLevels ? selectedOptions.map((option) => option.label).join(this.props.separator || DEFAULT_SEPARATOR) : selectedOptions[selectedOptions.length - 1].label;
      const state = {
        rcValue: { value, label: activeLabel },
        focusCascade: true,
        activeLabel,
        isSearching: false,
        inputValue: activeLabel
      };
      this.setState(state);
      this.props.onSelect(selectedOptions[selectedOptions.length - 1].value);
    });
    //For select
    __publicField$q(this, "onSelect", (obj) => {
      const valueArray = obj.value || [];
      const activeLabel = this.props.displayAllSelectedLevels ? obj.label : obj.singleLabel || "";
      const state = {
        activeLabel,
        inputValue: activeLabel,
        rcValue: { value: valueArray, label: activeLabel },
        isSearching: false,
        focusCascade: false
      };
      this.setState(state);
      this.props.onSelect(valueArray[valueArray.length - 1]);
    });
    __publicField$q(this, "onCreateOption", (value) => {
      this.setState({
        activeLabel: value,
        inputValue: value,
        rcValue: [],
        isSearching: false
      });
      this.props.onSelect(value);
    });
    __publicField$q(this, "onBlur", () => {
      var _a, _b;
      this.setState({
        isSearching: false,
        focusCascade: false
      });
      if (this.state.activeLabel === "") {
        this.setState({
          rcValue: []
        });
      }
      (_b = (_a = this.props).onBlur) == null ? void 0 : _b.call(_a);
    });
    __publicField$q(this, "onBlurCascade", () => {
      var _a, _b;
      this.setState({
        focusCascade: false
      });
      (_b = (_a = this.props).onBlur) == null ? void 0 : _b.call(_a);
    });
    __publicField$q(this, "onInputKeyDown", (e) => {
      if (["ArrowDown", "ArrowUp", "Enter", "ArrowLeft", "ArrowRight"].includes(e.key)) {
        return;
      }
      const { activeLabel } = this.state;
      this.setState({
        focusCascade: false,
        isSearching: true,
        inputValue: activeLabel
      });
    });
    __publicField$q(this, "onSelectInputChange", (value) => {
      this.setState({
        inputValue: value
      });
    });
    const searchableOptions = this.getSearchableOptions(props.options);
    const { rcValue, activeLabel } = this.setInitialValue(searchableOptions, props.initialValue);
    this.state = {
      isSearching: false,
      focusCascade: false,
      rcValue,
      activeLabel,
      inputValue: ""
    };
  }
  setInitialValue(searchableOptions, initValue) {
    if (!initValue) {
      return { rcValue: [], activeLabel: "" };
    }
    for (const option of searchableOptions) {
      const optionPath = option.value || [];
      if (optionPath[optionPath.length - 1] === initValue) {
        return {
          rcValue: optionPath,
          activeLabel: this.props.displayAllSelectedLevels ? option.label : option.singleLabel || ""
        };
      }
    }
    if (this.props.allowCustomValue) {
      return { rcValue: [], activeLabel: initValue };
    }
    return { rcValue: [], activeLabel: "" };
  }
  render() {
    const {
      allowCustomValue,
      formatCreateLabel,
      placeholder,
      width,
      changeOnSelect,
      options,
      disabled,
      id,
      isClearable
    } = this.props;
    const { focusCascade, isSearching, rcValue, activeLabel, inputValue } = this.state;
    const searchableOptions = this.getSearchableOptions(options);
    return /* @__PURE__ */ React__default["default"].createElement("div", null, isSearching ? /* @__PURE__ */ React__default["default"].createElement(
      Select,
      {
        allowCustomValue,
        placeholder,
        autoFocus: !focusCascade,
        onChange: this.onSelect,
        onBlur: this.onBlur,
        options: searchableOptions,
        onCreateOption: this.onCreateOption,
        formatCreateLabel,
        width,
        onInputChange: this.onSelectInputChange,
        disabled,
        inputValue,
        inputId: id
      }
    ) : /* @__PURE__ */ React__default["default"].createElement(
      RCCascader__default["default"],
      {
        onChange: onChangeCascader(this.onChange),
        options,
        changeOnSelect,
        value: rcValue.value,
        fieldNames: { label: "label", value: "value", children: "items" },
        expandIcon: null,
        open: this.props.alwaysOpen,
        disabled
      },
      /* @__PURE__ */ React__default["default"].createElement("div", { className: disableDivFocus }, /* @__PURE__ */ React__default["default"].createElement(
        Input,
        {
          autoFocus: this.props.autoFocus,
          width,
          placeholder,
          onBlur: this.onBlurCascade,
          value: activeLabel,
          onKeyDown: this.onInputKeyDown,
          onChange: () => {
          },
          suffix: /* @__PURE__ */ React__default["default"].createElement(Stack, { gap: 0.5 }, isClearable && activeLabel !== "" && /* @__PURE__ */ React__default["default"].createElement(
            IconButton,
            {
              name: "times",
              "aria-label": "Clear selection",
              onClick: (e) => {
                e.preventDefault();
                e.stopPropagation();
                this.setState({ rcValue: [], activeLabel: "", inputValue: "" });
                this.props.onSelect("");
              }
            }
          ), /* @__PURE__ */ React__default["default"].createElement(Icon, { name: focusCascade ? "angle-up" : "angle-down" })),
          disabled,
          id
        }
      ))
    ));
  }
}
__publicField$q(Cascader, "defaultProps", { changeOnSelect: true });

var __defProp$2r = Object.defineProperty;
var __defProps$1t = Object.defineProperties;
var __getOwnPropDescs$1t = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2d = Object.getOwnPropertySymbols;
var __hasOwnProp$2d = Object.prototype.hasOwnProperty;
var __propIsEnum$2d = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2r = (obj, key, value) => key in obj ? __defProp$2r(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2c = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2d.call(b, prop))
      __defNormalProp$2r(a, prop, b[prop]);
  if (__getOwnPropSymbols$2d)
    for (var prop of __getOwnPropSymbols$2d(b)) {
      if (__propIsEnum$2d.call(b, prop))
        __defNormalProp$2r(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1t = (a, b) => __defProps$1t(a, __getOwnPropDescs$1t(b));
var __objRest$12 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2d.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2d)
    for (var prop of __getOwnPropSymbols$2d(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2d.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const ButtonCascader = (props) => {
  const _a = props, { onChange, className, loadData, icon, buttonProps, hideDownIcon, variant, disabled } = _a, rest = __objRest$12(_a, ["onChange", "className", "loadData", "icon", "buttonProps", "hideDownIcon", "variant", "disabled"]);
  const styles = useStyles2(getStyles$1M);
  let content = props.children;
  if (!hideDownIcon) {
    content = [props.children, /* @__PURE__ */ React__default["default"].createElement(Icon, { key: "down-icon", name: "angle-down", className: styles.icons.right })];
  }
  return /* @__PURE__ */ React__default["default"].createElement(
    RCCascader__default["default"],
    __spreadProps$1t(__spreadValues$2c({
      onChange: onChangeCascader(onChange),
      loadData: onLoadDataCascader(loadData),
      dropdownClassName: styles.popup
    }, rest), {
      expandIcon: null
    }),
    /* @__PURE__ */ React__default["default"].createElement(Button, __spreadValues$2c({ icon, disabled, variant }, buttonProps != null ? buttonProps : {}), content)
  );
};
ButtonCascader.displayName = "ButtonCascader";
const getStyles$1M = (theme) => {
  return {
    popup: css.css({
      label: "popup",
      zIndex: theme.zIndex.dropdown
    }),
    icons: {
      right: css.css({
        margin: "1px 0 0 4px"
      }),
      left: css.css({
        margin: "-1px 4px 0 0"
      })
    }
  };
};

var __defProp$2q = Object.defineProperty;
var __getOwnPropSymbols$2c = Object.getOwnPropertySymbols;
var __hasOwnProp$2c = Object.prototype.hasOwnProperty;
var __propIsEnum$2c = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2q = (obj, key, value) => key in obj ? __defProp$2q(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2b = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2c.call(b, prop))
      __defNormalProp$2q(a, prop, b[prop]);
  if (__getOwnPropSymbols$2c)
    for (var prop of __getOwnPropSymbols$2c(b)) {
      if (__propIsEnum$2c.call(b, prop))
        __defNormalProp$2q(a, prop, b[prop]);
    }
  return a;
};
var __objRest$11 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2c.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2c)
    for (var prop of __getOwnPropSymbols$2c(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2c.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const LoadingPlaceholder = (_a) => {
  var _b = _a, { text, className } = _b, rest = __objRest$11(_b, ["text", "className"]);
  const styles = useStyles2(getStyles$1L);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$2b({ className: css.cx(styles.container, className) }, rest), text, " ", /* @__PURE__ */ React__default["default"].createElement(Spinner, { inline: true }));
};
const getStyles$1L = (theme) => {
  return {
    container: css.css({
      marginBottom: theme.spacing(4)
    })
  };
};

const BAR_WIDTH = 28;
const MILLISECONDS_PER_PIXEL = 2.4;
const MIN_DURATION_MS = 500;
const MAX_DURATION_MS = 4e3;
const DEFAULT_ANIMATION_DELAY = 300;
const MAX_TRANSLATE_X = 100 / BAR_WIDTH * 100;
function LoadingBar({ width, delay = DEFAULT_ANIMATION_DELAY, ariaLabel = "Loading bar" }) {
  const durationMs = Math.min(Math.max(Math.round(width * MILLISECONDS_PER_PIXEL), MIN_DURATION_MS), MAX_DURATION_MS);
  const styles = useStyles2(getStyles$1K, delay, durationMs);
  const containerStyles = {
    overflow: "hidden"
  };
  return /* @__PURE__ */ React__default["default"].createElement("div", { style: containerStyles }, /* @__PURE__ */ React__default["default"].createElement("div", { "aria-label": ariaLabel, className: styles.bar }));
}
const getStyles$1K = (_theme, delay, duration) => {
  const animation = css.keyframes({
    "0%": {
      transform: "translateX(-100%)"
    },
    // this gives us a delay between iterations
    "85%, 100%": {
      transform: `translateX(${MAX_TRANSLATE_X}%)`
    }
  });
  return {
    bar: css.css({
      width: BAR_WIDTH + "%",
      height: 1,
      background: "linear-gradient(90deg, rgba(110, 159, 255, 0) 0%, #6E9FFF 80.75%, rgba(110, 159, 255, 0) 100%)",
      transform: "translateX(-100%)",
      animationName: animation,
      // an initial delay to prevent the loader from showing if the response is faster than the delay
      animationDelay: `${delay}ms`,
      animationDuration: `${duration}ms`,
      animationTimingFunction: "linear",
      animationIterationCount: "infinite",
      willChange: "transform"
    })
  };
};

const closePopover = (event, hidePopper) => {
  if (event.key === "Tab" || event.altKey || event.ctrlKey || event.metaKey) {
    return;
  }
  event.stopPropagation();
  if (event.key === "Escape") {
    hidePopper();
  }
  return;
};

var __defProp$2p = Object.defineProperty;
var __defProps$1s = Object.defineProperties;
var __getOwnPropDescs$1s = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2b = Object.getOwnPropertySymbols;
var __hasOwnProp$2b = Object.prototype.hasOwnProperty;
var __propIsEnum$2b = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2p = (obj, key, value) => key in obj ? __defProp$2p(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2a = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2b.call(b, prop))
      __defNormalProp$2p(a, prop, b[prop]);
  if (__getOwnPropSymbols$2b)
    for (var prop of __getOwnPropSymbols$2b(b)) {
      if (__propIsEnum$2b.call(b, prop))
        __defNormalProp$2p(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1s = (a, b) => __defProps$1s(a, __getOwnPropDescs$1s(b));
var __objRest$10 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2b.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2b)
    for (var prop of __getOwnPropSymbols$2b(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2b.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var ColorSwatchVariant = /* @__PURE__ */ ((ColorSwatchVariant2) => {
  ColorSwatchVariant2["Small"] = "small";
  ColorSwatchVariant2["Large"] = "large";
  return ColorSwatchVariant2;
})(ColorSwatchVariant || {});
const ColorSwatch = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, { color, label, variant = "small" /* Small */, isSelected, "aria-label": ariaLabel } = _b, otherProps = __objRest$10(_b, ["color", "label", "variant", "isSelected", "aria-label"]);
    const theme = useTheme2();
    const { isFocusVisible, focusProps } = focus.useFocusRing();
    const styles = getStyles$1J(theme, variant, color, isFocusVisible, isSelected);
    const hasLabel = !!label;
    const colorLabel = ariaLabel || label;
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$2a({ ref, className: styles.wrapper, "data-testid": e2eSelectors.selectors.components.ColorSwatch.name }, otherProps), hasLabel && /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.label }, label), /* @__PURE__ */ React__default["default"].createElement(
      "button",
      __spreadProps$1s(__spreadValues$2a({
        className: styles.swatch
      }, focusProps), {
        "aria-label": colorLabel ? `${colorLabel} color` : "Pick a color",
        type: "button"
      })
    ));
  }
);
const getStyles$1J = (theme, variant, color, isFocusVisible, isSelected) => {
  const tc = tinycolor__default["default"](color);
  const isSmall = variant === "small" /* Small */;
  const swatchSize = isSmall ? "16px" : "32px";
  let border = "none";
  if (tc.getAlpha() < 0.1) {
    border = `2px solid ${theme.colors.border.medium}`;
  }
  return {
    wrapper: css.css({
      display: "flex",
      alignItems: "center",
      cursor: "pointer"
    }),
    label: css.css({
      marginRight: theme.spacing(1)
    }),
    swatch: css.css({
      width: swatchSize,
      height: swatchSize,
      background: `${color}`,
      border,
      borderRadius: theme.shape.radius.circle,
      outlineOffset: "1px",
      outline: isFocusVisible ? `2px solid  ${theme.colors.primary.main}` : "none",
      boxShadow: isSelected ? `inset 0 0 0 2px ${color}, inset 0 0 0 4px ${theme.colors.getContrastText(color)}` : "none",
      transition: theme.transitions.create(["transform"], {
        duration: theme.transitions.duration.short
      }),
      "&:hover": {
        transform: "scale(1.1)"
      },
      "@media (forced-colors: active)": {
        forcedColorAdjust: "none"
      }
    })
  };
};
ColorSwatch.displayName = "ColorSwatch";

function reverseMap(arr, callbackfn) {
  const reversedAndMapped = new Array(arr.length);
  for (let i = 0; i < arr.length; i++) {
    const reverseIndex = arr.length - 1 - i;
    reversedAndMapped[i] = callbackfn(arr[reverseIndex], reverseIndex, arr);
  }
  return reversedAndMapped;
}

var __defProp$2o = Object.defineProperty;
var __defProps$1r = Object.defineProperties;
var __getOwnPropDescs$1r = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2a = Object.getOwnPropertySymbols;
var __hasOwnProp$2a = Object.prototype.hasOwnProperty;
var __propIsEnum$2a = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2o = (obj, key, value) => key in obj ? __defProp$2o(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$29 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2a.call(b, prop))
      __defNormalProp$2o(a, prop, b[prop]);
  if (__getOwnPropSymbols$2a)
    for (var prop of __getOwnPropSymbols$2a(b)) {
      if (__propIsEnum$2a.call(b, prop))
        __defNormalProp$2o(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1r = (a, b) => __defProps$1r(a, __getOwnPropDescs$1r(b));
var __objRest$$ = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2a.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2a)
    for (var prop of __getOwnPropSymbols$2a(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2a.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const NamedColorsGroup = (_a) => {
  var _b = _a, { hue, selectedColor, onColorSelect } = _b, otherProps = __objRest$$(_b, ["hue", "selectedColor", "onColorSelect"]);
  const label = lodash.upperFirst(hue.name);
  const styles = useStyles2(getStyles$1I);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.colorRow }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.colorLabel }, label), /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1r(__spreadValues$29({}, otherProps), { className: styles.swatchRow }), reverseMap(hue.shades, (shade) => /* @__PURE__ */ React__default["default"].createElement(
    ColorSwatch,
    {
      key: shade.name,
      "aria-label": shade.name,
      variant: shade.primary ? ColorSwatchVariant.Large : ColorSwatchVariant.Small,
      isSelected: shade.name === selectedColor,
      color: shade.color,
      onClick: () => onColorSelect(shade.name)
    }
  ))));
};
const getStyles$1I = (theme) => {
  return {
    colorRow: css.css({
      display: "grid",
      gridTemplateColumns: "25% 1fr",
      gridColumnGap: theme.spacing(2),
      padding: theme.spacing(0.5, 0),
      "&:hover": {
        background: theme.colors.background.secondary
      }
    }),
    colorLabel: css.css({
      paddingLeft: theme.spacing(2),
      display: "flex",
      alignItems: "center"
    }),
    swatchRow: css.css({
      display: "flex",
      gap: theme.spacing(1),
      alignItems: "center",
      justifyContent: "space-around",
      flexDirection: "row"
    })
  };
};

const NamedColorsPalette = ({ color, onChange }) => {
  const theme = useTheme2();
  const styles = useStyles2(getStyles$1H);
  const swatches = [];
  for (const hue of theme.visualization.hues) {
    swatches.push(/* @__PURE__ */ React__default["default"].createElement(NamedColorsGroup, { key: hue.name, selectedColor: color, hue, onColorSelect: onChange }));
  }
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.swatches }, swatches), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.extraColors }, /* @__PURE__ */ React__default["default"].createElement(
    ColorSwatch,
    {
      isSelected: color === "transparent",
      color: "rgba(0,0,0,0)",
      label: "Transparent",
      onClick: () => onChange("transparent")
    }
  ), /* @__PURE__ */ React__default["default"].createElement(
    ColorSwatch,
    {
      isSelected: color === "text",
      color: theme.colors.text.primary,
      label: "Text color",
      onClick: () => onChange("text")
    }
  )));
};
const getStyles$1H = (theme) => {
  return {
    container: css.css({
      display: "flex",
      flexDirection: "column"
    }),
    extraColors: css.css({
      display: "flex",
      alignItems: "center",
      justifyContent: "space-around",
      gap: theme.spacing(1),
      padding: theme.spacing(1, 0)
    }),
    swatches: css.css({
      display: "grid",
      flexGrow: 1
    })
  };
};

var __defProp$2n = Object.defineProperty;
var __defProps$1q = Object.defineProperties;
var __getOwnPropDescs$1q = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$29 = Object.getOwnPropertySymbols;
var __hasOwnProp$29 = Object.prototype.hasOwnProperty;
var __propIsEnum$29 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2n = (obj, key, value) => key in obj ? __defProp$2n(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$28 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$29.call(b, prop))
      __defNormalProp$2n(a, prop, b[prop]);
  if (__getOwnPropSymbols$29)
    for (var prop of __getOwnPropSymbols$29(b)) {
      if (__propIsEnum$29.call(b, prop))
        __defNormalProp$2n(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1q = (a, b) => __defProps$1q(a, __getOwnPropDescs$1q(b));
var __objRest$_ = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$29.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$29)
    for (var prop of __getOwnPropSymbols$29(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$29.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const ColorInput = React.forwardRef(
  (_a, ref) => {
    var _b = _a, { color, onChange, isClearable = false, onClick, onBlur, disabled, buttonAriaLabel } = _b, inputProps = __objRest$_(_b, ["color", "onChange", "isClearable", "onClick", "onBlur", "disabled", "buttonAriaLabel"]);
    const [value, setValue] = React.useState(color);
    const [previousColor, setPreviousColor] = React.useState(color);
    const updateColor = React.useMemo(() => lodash.debounce(onChange, 100), []);
    React.useEffect(() => {
      const newColor = tinycolor__default["default"](color);
      if (newColor.isValid() && color !== previousColor) {
        setValue(newColor.toString());
        setPreviousColor(color);
      }
    }, [color, previousColor]);
    const onChangeColor = (event) => {
      const { value: colorValue } = event.currentTarget;
      setValue(colorValue);
      if (colorValue === "" && isClearable) {
        updateColor(colorValue);
        return;
      }
      const newColor = tinycolor__default["default"](colorValue);
      if (newColor.isValid()) {
        updateColor(newColor.toString());
      }
    };
    const onBlurInput = (event) => {
      const newColor = tinycolor__default["default"](value);
      if (!newColor.isValid()) {
        setValue(color);
      }
      onBlur == null ? void 0 : onBlur(event);
    };
    return /* @__PURE__ */ React__default["default"].createElement(
      Input,
      __spreadProps$1q(__spreadValues$28({}, inputProps), {
        value,
        onChange: onChangeColor,
        disabled,
        onClick,
        onBlur: onBlurInput,
        addonBefore: /* @__PURE__ */ React__default["default"].createElement(ColorPreview, { onClick, ariaLabel: buttonAriaLabel, disabled, color }),
        ref
      })
    );
  }
);
ColorInput.displayName = "ColorInput";
const ColorPreview = ({ color, onClick, disabled, ariaLabel }) => {
  const styles = useStyles2(getColorPreviewStyles);
  return /* @__PURE__ */ React__default["default"].createElement(
    "button",
    {
      type: "button",
      onClick,
      "aria-label": ariaLabel,
      disabled: disabled || !onClick,
      className: css.cx(
        styles,
        css.css({
          backgroundColor: color
        })
      )
    }
  );
};
const getColorPreviewStyles = (theme) => css.css({
  height: "100%",
  width: `${theme.spacing.gridSize * 4}px`,
  borderRadius: `${theme.shape.radius.default} 0 0 ${theme.shape.radius.default}`,
  border: `1px solid ${theme.colors.border.medium}`
});

const SpectrumPalette = ({ color, onChange }) => {
  const [currentColor, setColor] = React.useState(color);
  reactUse.useThrottleFn(
    (c) => {
      onChange(data.colorManipulator.asHexString(theme.visualization.getColorByName(c)));
    },
    500,
    [currentColor]
  );
  const theme = useTheme2();
  const styles = useStyles2(getStyles$1G);
  const rgbaString = React.useMemo(() => {
    return currentColor.startsWith("rgba") ? currentColor : tinycolor__default["default"](theme.visualization.getColorByName(color)).toRgbString();
  }, [currentColor, theme, color]);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.wrapper }, /* @__PURE__ */ React__default["default"].createElement(reactColorful.RgbaStringColorPicker, { className: styles.root, color: rgbaString, onChange: setColor }), /* @__PURE__ */ React__default["default"].createElement(ColorInput, { theme, color: rgbaString, onChange: setColor, className: styles.colorInput }));
};
const getStyles$1G = (theme) => ({
  wrapper: css.css({
    flexGrow: 1
  }),
  root: css.css({
    "&.react-colorful": {
      width: "auto"
    },
    ".react-colorful": {
      "&__saturation": {
        borderRadius: `${theme.shape.radius.default} ${theme.shape.radius.default} 0 0`
      },
      "&__alpha": {
        borderRadius: `0 0 ${theme.shape.radius.default} ${theme.shape.radius.default}`
      },
      "&__alpha, &__hue": {
        height: theme.spacing(2),
        position: "relative"
      },
      "&__pointer": {
        height: theme.spacing(2),
        width: theme.spacing(2)
      }
    }
  }),
  colorInput: css.css({
    marginTop: theme.spacing(2)
  })
});

var __defProp$2m = Object.defineProperty;
var __defNormalProp$2m = (obj, key, value) => key in obj ? __defProp$2m(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$p = (obj, key, value) => {
  __defNormalProp$2m(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
class UnThemedColorPickerPopover extends React.Component {
  constructor(props) {
    super(props);
    __publicField$p(this, "getTabClassName", (tabName) => {
      const { activePicker } = this.state;
      return `ColorPickerPopover__tab ${activePicker === tabName && "ColorPickerPopover__tab--active"}`;
    });
    __publicField$p(this, "handleChange", (color) => {
      const { onChange, enableNamedColors, theme } = this.props;
      if (enableNamedColors) {
        return onChange(color);
      }
      onChange(data.colorManipulator.asHexString(theme.visualization.getColorByName(color)));
    });
    __publicField$p(this, "onTabChange", (tab) => {
      return () => this.setState({ activePicker: tab });
    });
    __publicField$p(this, "renderPicker", () => {
      const { activePicker } = this.state;
      const { color } = this.props;
      switch (activePicker) {
        case "spectrum":
          return /* @__PURE__ */ React__default["default"].createElement(SpectrumPalette, { color, onChange: this.handleChange });
        case "palette":
          return /* @__PURE__ */ React__default["default"].createElement(NamedColorsPalette, { color, onChange: this.handleChange });
        default:
          return this.renderCustomPicker(activePicker);
      }
    });
    __publicField$p(this, "renderCustomPicker", (tabKey) => {
      const { customPickers, color, theme } = this.props;
      if (!customPickers) {
        return null;
      }
      return React__default["default"].createElement(customPickers[tabKey].tabComponent, {
        color,
        theme,
        onChange: this.handleChange
      });
    });
    __publicField$p(this, "renderCustomPickerTabs", () => {
      const { customPickers } = this.props;
      if (!customPickers) {
        return null;
      }
      return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, Object.keys(customPickers).map((key) => {
        return /* @__PURE__ */ React__default["default"].createElement("button", { className: this.getTabClassName(key), onClick: this.onTabChange(key), key, type: "button" }, customPickers[key].name);
      }));
    });
    this.state = {
      activePicker: "palette"
    };
  }
  render() {
    const { theme } = this.props;
    const styles = getStyles$1F(theme);
    return /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { contain: true, restoreFocus: true, autoFocus: true }, /* @__PURE__ */ React__default["default"].createElement("div", { tabIndex: -1, className: styles.colorPickerPopover }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.colorPickerPopoverTabs }, /* @__PURE__ */ React__default["default"].createElement("button", { className: this.getTabClassName("palette"), onClick: this.onTabChange("palette"), type: "button" }, "Colors"), /* @__PURE__ */ React__default["default"].createElement("button", { className: this.getTabClassName("spectrum"), onClick: this.onTabChange("spectrum"), type: "button" }, "Custom"), this.renderCustomPickerTabs()), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.colorPickerPopoverContent }, this.renderPicker())));
  }
}
const ColorPickerPopover = withTheme2(UnThemedColorPickerPopover);
ColorPickerPopover.displayName = "ColorPickerPopover";
const getStyles$1F = stylesFactory((theme) => {
  return {
    colorPickerPopover: css.css({
      borderRadius: theme.shape.radius.default,
      boxShadow: theme.shadows.z3,
      background: theme.colors.background.primary,
      border: `1px solid ${theme.colors.border.weak}`,
      ".ColorPickerPopover__tab": {
        width: "50%",
        textAlign: "center",
        padding: theme.spacing(1, 0),
        background: theme.colors.background.secondary,
        color: theme.colors.text.secondary,
        fontSize: theme.typography.bodySmall.fontSize,
        cursor: "pointer",
        border: "none",
        "&:focus:not(:focus-visible)": {
          outline: "none",
          boxShadow: "none"
        },
        ":focus-visible": {
          position: "relative"
        }
      },
      ".ColorPickerPopover__tab--active": {
        color: theme.colors.text.primary,
        fontWeight: theme.typography.fontWeightMedium,
        background: theme.colors.background.primary
      }
    }),
    colorPickerPopoverContent: css.css({
      width: "246px",
      fontSize: theme.typography.bodySmall.fontSize,
      minHeight: "184px",
      padding: theme.spacing(1),
      display: "flex",
      flexDirection: "column"
    }),
    colorPickerPopoverTabs: css.css({
      display: "flex",
      width: "100%",
      borderRadius: `${theme.shape.radius.default} ${theme.shape.radius.default} 0 0`
    })
  };
});

var __defProp$2l = Object.defineProperty;
var __defProps$1p = Object.defineProperties;
var __getOwnPropDescs$1p = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$28 = Object.getOwnPropertySymbols;
var __hasOwnProp$28 = Object.prototype.hasOwnProperty;
var __propIsEnum$28 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2l = (obj, key, value) => key in obj ? __defProp$2l(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$27 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$28.call(b, prop))
      __defNormalProp$2l(a, prop, b[prop]);
  if (__getOwnPropSymbols$28)
    for (var prop of __getOwnPropSymbols$28(b)) {
      if (__propIsEnum$28.call(b, prop))
        __defNormalProp$2l(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1p = (a, b) => __defProps$1p(a, __getOwnPropDescs$1p(b));
var __objRest$Z = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$28.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$28)
    for (var prop of __getOwnPropSymbols$28(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$28.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const SeriesColorPickerPopover = (props) => {
  const styles = useStyles2(getStyles$1E);
  const _a = props, { yaxis, onToggleAxis, color } = _a, colorPickerProps = __objRest$Z(_a, ["yaxis", "onToggleAxis", "color"]);
  const customPickers = onToggleAxis ? {
    yaxis: {
      name: "Y-Axis",
      tabComponent() {
        return /* @__PURE__ */ React__default["default"].createElement(
          Switch$1,
          {
            key: "yaxisSwitch",
            label: "Use right y-axis",
            className: styles.colorPickerAxisSwitch,
            labelClass: styles.colorPickerAxisSwitchLabel,
            checked: yaxis === 2,
            onChange: () => {
              if (onToggleAxis) {
                onToggleAxis();
              }
            }
          }
        );
      }
    }
  } : void 0;
  return /* @__PURE__ */ React__default["default"].createElement(ColorPickerPopover, __spreadProps$1p(__spreadValues$27({}, colorPickerProps), { color: color || "#000000", customPickers }));
};
const SeriesColorPickerPopoverWithTheme = withTheme2(SeriesColorPickerPopover);
const getStyles$1E = () => {
  return {
    colorPickerAxisSwitch: css.css({
      width: "100%"
    }),
    colorPickerAxisSwitchLabel: css.css({
      display: "flex",
      flexGrow: 1
    })
  };
};

var __defProp$2k = Object.defineProperty;
var __defProps$1o = Object.defineProperties;
var __getOwnPropDescs$1o = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$27 = Object.getOwnPropertySymbols;
var __hasOwnProp$27 = Object.prototype.hasOwnProperty;
var __propIsEnum$27 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2k = (obj, key, value) => key in obj ? __defProp$2k(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$26 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$27.call(b, prop))
      __defNormalProp$2k(a, prop, b[prop]);
  if (__getOwnPropSymbols$27)
    for (var prop of __getOwnPropSymbols$27(b)) {
      if (__propIsEnum$27.call(b, prop))
        __defNormalProp$2k(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1o = (a, b) => __defProps$1o(a, __getOwnPropDescs$1o(b));
var __publicField$o = (obj, key, value) => {
  __defNormalProp$2k(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
const colorPickerFactory = (popover, displayName = "ColorPicker") => {
  var _a;
  return _a = class extends React.Component {
    constructor() {
      super(...arguments);
      __publicField$o(this, "pickerTriggerRef", React.createRef());
    }
    render() {
      const { theme, children, onChange, color } = this.props;
      const styles = getStyles$1D(theme);
      const popoverElement = React__default["default"].createElement(popover, __spreadProps$1o(__spreadValues$26({}, __spreadProps$1o(__spreadValues$26({}, this.props), { children: null })), {
        onChange
      }));
      return /* @__PURE__ */ React__default["default"].createElement(PopoverController, { content: popoverElement, hideAfter: 300 }, (showPopper, hidePopper, popperProps) => {
        return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, this.pickerTriggerRef.current && /* @__PURE__ */ React__default["default"].createElement(
          Popover,
          __spreadProps$1o(__spreadValues$26({}, popperProps), {
            referenceElement: this.pickerTriggerRef.current,
            wrapperClassName: styles.colorPicker,
            onMouseLeave: hidePopper,
            onMouseEnter: showPopper,
            onKeyDown: (event) => closePopover(event, hidePopper)
          })
        ), children ? children({
          ref: this.pickerTriggerRef,
          showColorPicker: showPopper,
          hideColorPicker: hidePopper
        }) : /* @__PURE__ */ React__default["default"].createElement(
          ColorSwatch,
          {
            ref: this.pickerTriggerRef,
            onClick: showPopper,
            onMouseLeave: hidePopper,
            color: theme.visualization.getColorByName(color || "#000000"),
            "aria-label": color
          }
        ));
      });
    }
  }, __publicField$o(_a, "displayName", displayName), _a;
};
const ColorPicker = withTheme2(colorPickerFactory(ColorPickerPopover, "ColorPicker"));
const SeriesColorPicker = withTheme2(colorPickerFactory(SeriesColorPickerPopover, "SeriesColorPicker"));
const getStyles$1D = stylesFactory((theme) => {
  return {
    colorPicker: css.css({
      position: "absolute",
      zIndex: theme.zIndex.tooltip,
      color: theme.colors.text.primary,
      maxWidth: "400px",
      fontSize: theme.typography.size.sm
    })
  };
});

var __defProp$2j = Object.defineProperty;
var __defNormalProp$2j = (obj, key, value) => key in obj ? __defProp$2j(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$n = (obj, key, value) => {
  __defNormalProp$2j(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
class ClickOutsideWrapper extends React.PureComponent {
  constructor() {
    super(...arguments);
    __publicField$n(this, "myRef", React.createRef());
    __publicField$n(this, "state", {
      hasEventListener: false
    });
    __publicField$n(this, "onOutsideClick", (event) => {
      const domNode = this.myRef.current;
      if (!domNode || event.target instanceof Node && !domNode.contains(event.target)) {
        this.props.onClick();
      }
    });
  }
  componentDidMount() {
    this.props.parent.addEventListener("click", this.onOutsideClick, this.props.useCapture);
    if (this.props.includeButtonPress) {
      this.props.parent.addEventListener("keyup", this.onOutsideClick, this.props.useCapture);
    }
  }
  componentWillUnmount() {
    this.props.parent.removeEventListener("click", this.onOutsideClick, this.props.useCapture);
    if (this.props.includeButtonPress) {
      this.props.parent.removeEventListener("keyup", this.onOutsideClick, this.props.useCapture);
    }
  }
  render() {
    return /* @__PURE__ */ React__default["default"].createElement("div", { ref: this.myRef }, this.props.children);
  }
}
__publicField$n(ClickOutsideWrapper, "defaultProps", {
  includeButtonPress: true,
  parent: typeof window !== "undefined" ? window : void 0,
  useCapture: false
});

var __defProp$2i = Object.defineProperty;
var __defProps$1n = Object.defineProperties;
var __getOwnPropDescs$1n = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$26 = Object.getOwnPropertySymbols;
var __hasOwnProp$26 = Object.prototype.hasOwnProperty;
var __propIsEnum$26 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2i = (obj, key, value) => key in obj ? __defProp$2i(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$25 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$26.call(b, prop))
      __defNormalProp$2i(a, prop, b[prop]);
  if (__getOwnPropSymbols$26)
    for (var prop of __getOwnPropSymbols$26(b)) {
      if (__propIsEnum$26.call(b, prop))
        __defNormalProp$2i(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1n = (a, b) => __defProps$1n(a, __getOwnPropDescs$1n(b));
var __objRest$Y = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$26.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$26)
    for (var prop of __getOwnPropSymbols$26(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$26.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const ColorPickerInput = React.forwardRef(
  (_a, ref) => {
    var _b = _a, { value = "", onChange, returnColorAs = "rgb" } = _b, inputProps = __objRest$Y(_b, ["value", "onChange", "returnColorAs"]);
    const [currentColor, setColor] = React.useState(value);
    const [isOpen, setIsOpen] = React.useState(false);
    const theme = useTheme2();
    const styles = useStyles2(getStyles$1C);
    const paletteStyles = useStyles2(getStyles$1G);
    reactUse.useThrottleFn(
      (c) => {
        if (c === value) {
          return;
        }
        if (!c) {
          onChange("");
          return;
        }
        const color = theme.visualization.getColorByName(c);
        if (returnColorAs === "rgb") {
          onChange(data.colorManipulator.asRgbString(color));
        } else {
          onChange(data.colorManipulator.asHexString(color));
        }
      },
      500,
      [currentColor]
    );
    return /* @__PURE__ */ React__default["default"].createElement(ClickOutsideWrapper, { onClick: () => setIsOpen(false) }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.wrapper }, isOpen && !inputProps.disabled && /* @__PURE__ */ React__default["default"].createElement(
      reactColorful.RgbaStringColorPicker,
      {
        "data-testid": "color-popover",
        color: currentColor,
        onChange: setColor,
        className: css.cx(paletteStyles.root, styles.picker)
      }
    ), /* @__PURE__ */ React__default["default"].createElement(
      ColorInput,
      __spreadProps$1n(__spreadValues$25({}, inputProps), {
        theme,
        color: currentColor,
        onChange: setColor,
        buttonAriaLabel: "Open color picker",
        onClick: () => setIsOpen(true),
        onBlur: () => setIsOpen(false),
        ref,
        isClearable: true
      })
    )));
  }
);
ColorPickerInput.displayName = "ColorPickerInput";
const getStyles$1C = (theme) => {
  return {
    wrapper: css.css({
      position: "relative"
    }),
    picker: css.css({
      "&.react-colorful": {
        position: "absolute",
        width: "100%",
        zIndex: 11,
        bottom: "36px"
      }
    }),
    inner: css.css({
      position: "absolute"
    })
  };
};

const EmptySearchResult = ({ children }) => {
  const styles = useStyles2(getStyles$1B);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.container }, children);
};
const getStyles$1B = (theme) => {
  return {
    container: css.css({
      borderLeft: `3px solid ${theme.colors.info.main}`,
      backgroundColor: `${theme.colors.background.secondary}`,
      padding: theme.spacing(2),
      minWidth: "350px",
      borderRadius: theme.shape.radius.default,
      marginBottom: theme.spacing(4)
    })
  };
};

var __defProp$2h = Object.defineProperty;
var __getOwnPropSymbols$25 = Object.getOwnPropertySymbols;
var __hasOwnProp$25 = Object.prototype.hasOwnProperty;
var __propIsEnum$25 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2h = (obj, key, value) => key in obj ? __defProp$2h(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$24 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$25.call(b, prop))
      __defNormalProp$2h(a, prop, b[prop]);
  if (__getOwnPropSymbols$25)
    for (var prop of __getOwnPropSymbols$25(b)) {
      if (__propIsEnum$25.call(b, prop))
        __defNormalProp$2h(a, prop, b[prop]);
    }
  return a;
};
var __objRest$X = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$25.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$25)
    for (var prop of __getOwnPropSymbols$25(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$25.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Box = React.forwardRef((props, ref) => {
  const _a = props, {
    children,
    margin,
    marginX,
    marginY,
    marginTop,
    marginBottom,
    marginLeft,
    marginRight,
    padding,
    paddingX,
    paddingY,
    paddingTop,
    paddingBottom,
    paddingLeft,
    paddingRight,
    display,
    backgroundColor,
    grow,
    shrink,
    basis,
    flex,
    borderColor,
    borderStyle,
    borderRadius,
    direction,
    justifyContent,
    alignItems,
    boxShadow,
    element,
    gap
  } = _a, rest = __objRest$X(_a, [
    "children",
    "margin",
    "marginX",
    "marginY",
    "marginTop",
    "marginBottom",
    "marginLeft",
    "marginRight",
    "padding",
    "paddingX",
    "paddingY",
    "paddingTop",
    "paddingBottom",
    "paddingLeft",
    "paddingRight",
    "display",
    "backgroundColor",
    "grow",
    "shrink",
    "basis",
    "flex",
    "borderColor",
    "borderStyle",
    "borderRadius",
    "direction",
    "justifyContent",
    "alignItems",
    "boxShadow",
    "element",
    "gap"
  ]);
  const styles = useStyles2(
    getStyles$1A,
    margin,
    marginX,
    marginY,
    marginTop,
    marginBottom,
    marginLeft,
    marginRight,
    padding,
    paddingX,
    paddingY,
    paddingTop,
    paddingBottom,
    paddingLeft,
    paddingRight,
    display,
    backgroundColor,
    grow,
    shrink,
    basis,
    flex,
    borderColor,
    borderStyle,
    borderRadius,
    direction,
    justifyContent,
    alignItems,
    boxShadow,
    gap
  );
  const Element = element != null ? element : "div";
  return /* @__PURE__ */ React__default["default"].createElement(Element, __spreadValues$24({ ref, className: styles.root }, rest), children);
});
Box.displayName = "Box";
const customBorderColor = (color, theme) => {
  switch (color) {
    case "error":
    case "success":
    case "info":
    case "warning":
      return theme.colors[color].borderTransparent;
    default:
      return color ? theme.colors.border[color] : void 0;
  }
};
const customBackgroundColor = (color, theme) => {
  switch (color) {
    case "error":
    case "success":
    case "info":
    case "warning":
      return theme.colors[color].transparent;
    default:
      return color ? theme.colors.background[color] : void 0;
  }
};
const getStyles$1A = (theme, margin, marginX, marginY, marginTop, marginBottom, marginLeft, marginRight, padding, paddingX, paddingY, paddingTop, paddingBottom, paddingLeft, paddingRight, display, backgroundColor, grow, shrink, basis, flex, borderColor, borderStyle, borderRadius, direction, justifyContent, alignItems, boxShadow, gap) => {
  return {
    root: css.css([
      getResponsiveStyle(theme, margin, (val) => ({
        margin: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginX, (val) => ({
        marginLeft: theme.spacing(val),
        marginRight: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginY, (val) => ({
        marginTop: theme.spacing(val),
        marginBottom: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginTop, (val) => ({
        marginTop: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginBottom, (val) => ({
        marginBottom: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginLeft, (val) => ({
        marginLeft: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginRight, (val) => ({
        marginRight: theme.spacing(val)
      })),
      getResponsiveStyle(theme, padding, (val) => ({
        padding: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingX, (val) => ({
        paddingLeft: theme.spacing(val),
        paddingRight: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingY, (val) => ({
        paddingTop: theme.spacing(val),
        paddingBottom: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingTop, (val) => ({
        paddingTop: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingBottom, (val) => ({
        paddingBottom: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingLeft, (val) => ({
        paddingLeft: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingRight, (val) => ({
        paddingRight: theme.spacing(val)
      })),
      getResponsiveStyle(theme, display, (val) => ({
        display: val
      })),
      getResponsiveStyle(theme, backgroundColor, (val) => ({
        backgroundColor: customBackgroundColor(val, theme)
      })),
      getResponsiveStyle(theme, direction, (val) => ({
        flexDirection: val
      })),
      getResponsiveStyle(theme, grow, (val) => ({
        flexGrow: val
      })),
      getResponsiveStyle(theme, shrink, (val) => ({
        flexShrink: val
      })),
      getResponsiveStyle(theme, basis, (val) => ({
        flexBasis: val
      })),
      getResponsiveStyle(theme, flex, (val) => ({
        flex: val
      })),
      getResponsiveStyle(theme, borderStyle, (val) => ({
        borderStyle: val
      })),
      getResponsiveStyle(theme, borderColor, (val) => ({
        borderColor: customBorderColor(val, theme)
      })),
      (borderStyle || borderColor) && {
        borderWidth: "1px"
      },
      getResponsiveStyle(theme, justifyContent, (val) => ({
        justifyContent: val
      })),
      getResponsiveStyle(theme, alignItems, (val) => ({
        alignItems: val
      })),
      getResponsiveStyle(theme, borderRadius, (val) => ({
        borderRadius: theme.shape.radius[val]
      })),
      getResponsiveStyle(theme, boxShadow, (val) => ({
        boxShadow: theme.shadows[val]
      })),
      getResponsiveStyle(theme, gap, (val) => ({
        gap: theme.spacing(val)
      }))
    ])
  };
};

const TruncatedText = React__default["default"].forwardRef(({ childElement, children }, ref) => {
  const [isOverflowing, setIsOverflowing] = React.useState(false);
  const internalRef = React.useRef(null);
  React.useImperativeHandle(ref, () => internalRef.current);
  const resizeObserver = React.useMemo(
    () => new ResizeObserver((entries) => {
      for (const entry of entries) {
        if (entry.target.clientWidth && entry.target.scrollWidth) {
          if (entry.target.scrollWidth > entry.target.clientWidth) {
            setIsOverflowing(true);
          }
          if (entry.target.scrollWidth <= entry.target.clientWidth) {
            setIsOverflowing(false);
          }
        }
      }
    }),
    []
  );
  React.useEffect(() => {
    const { current } = internalRef;
    if (current) {
      resizeObserver.observe(current);
    }
    return () => {
      resizeObserver.disconnect();
    };
  }, [setIsOverflowing, resizeObserver]);
  const getTooltipText = (children2) => {
    if (typeof children2 === "string") {
      return children2;
    }
    const html = ReactDOMServer__default["default"].renderToStaticMarkup(/* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, children2));
    return html.replace(/(<([^>]+)>)/gi, "");
  };
  if (isOverflowing) {
    return /* @__PURE__ */ React__default["default"].createElement(Tooltip, { ref: internalRef, content: getTooltipText(children) }, childElement(void 0));
  } else {
    return childElement(internalRef);
  }
});
TruncatedText.displayName = "TruncatedText";

const customWeight = (weight, theme) => {
  switch (weight) {
    case "bold":
      return theme.typography.fontWeightBold;
    case "medium":
      return theme.typography.fontWeightMedium;
    case "light":
      return theme.typography.fontWeightLight;
    case "regular":
    case void 0:
      return theme.typography.fontWeightRegular;
  }
};
const customColor = (color, theme) => {
  switch (color) {
    case "error":
      return theme.colors.error.text;
    case "success":
      return theme.colors.success.text;
    case "info":
      return theme.colors.info.text;
    case "warning":
      return theme.colors.warning.text;
    default:
      return color ? theme.colors.text[color] : void 0;
  }
};
const customVariant = (theme, element, variant) => {
  if (variant) {
    return theme.typography[variant];
  }
  switch (element) {
    case "span":
      return;
    case "h1":
      return theme.typography.h1;
    case "h2":
      return theme.typography.h2;
    case "h3":
      return theme.typography.h3;
    case "h4":
      return theme.typography.h4;
    case "h5":
      return theme.typography.h5;
    case "h6":
      return theme.typography.h6;
    default:
      return theme.typography.body;
  }
};

var __defProp$2g = Object.defineProperty;
var __defProps$1m = Object.defineProperties;
var __getOwnPropDescs$1m = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$24 = Object.getOwnPropertySymbols;
var __hasOwnProp$24 = Object.prototype.hasOwnProperty;
var __propIsEnum$24 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2g = (obj, key, value) => key in obj ? __defProp$2g(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$23 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$24.call(b, prop))
      __defNormalProp$2g(a, prop, b[prop]);
  if (__getOwnPropSymbols$24)
    for (var prop of __getOwnPropSymbols$24(b)) {
      if (__propIsEnum$24.call(b, prop))
        __defNormalProp$2g(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1m = (a, b) => __defProps$1m(a, __getOwnPropDescs$1m(b));
var __objRest$W = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$24.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$24)
    for (var prop of __getOwnPropSymbols$24(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$24.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Text = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, { element = "span", variant, weight, color, truncate, italic, textAlignment, children } = _b, restProps = __objRest$W(_b, ["element", "variant", "weight", "color", "truncate", "italic", "textAlignment", "children"]);
    const styles = useStyles2(getTextStyles, element, variant, color, weight, truncate, italic, textAlignment);
    const childElement = (ref2) => {
      return React.createElement(
        element,
        __spreadProps$1m(__spreadValues$23({}, restProps), {
          style: void 0,
          // Remove the style prop to avoid overriding the styles
          className: styles,
          // When overflowing, the internalRef is passed to the tooltip, which forwards it to the child element
          ref: ref2
        }),
        children
      );
    };
    if (!truncate || element === "span") {
      return childElement(void 0);
    }
    return /* @__PURE__ */ React__default["default"].createElement(
      TruncatedText,
      {
        childElement,
        children,
        ref
      }
    );
  }
);
Text.displayName = "Text";
const getTextStyles = (theme, element, variant, color, weight, truncate, italic, textAlignment) => {
  return css.css([
    __spreadValues$23({
      margin: 0,
      padding: 0
    }, customVariant(theme, element, variant)),
    variant && __spreadValues$23({}, theme.typography[variant]),
    color && {
      color: customColor(color, theme)
    },
    weight && {
      fontWeight: customWeight(weight, theme)
    },
    truncate && {
      overflow: "hidden",
      textOverflow: "ellipsis",
      whiteSpace: "nowrap"
    },
    italic && {
      fontStyle: "italic"
    },
    textAlignment && {
      textAlign: textAlignment
    }
  ]);
};

var grotCTASvg = "<svg viewBox=\"0 0 321 171\" fill=\"none\" xmlns=\"http://www.w3.org/2000/svg\">\n  <ellipse cx=\"160.5\" cy=\"153.5\" rx=\"160.5\" ry=\"17.5\" fill=\"#9087e9\" fill-opacity=\"0.3\" />\n  <g id=\"grot-cta-cactus-1\" fill=\"#9087e9\">\n    <path d=\"M12.496 76.3187C12.4507 76.4394 12.4205 76.5149 12.3752 76.5753C12.2998 76.681 12.2394 76.7112 12.179 76.7263C12.1488 76.7263 12.1186 76.7263 12.0884 76.7112C11.9827 76.6659 11.9374 76.6055 11.8771 76.53C11.8167 76.4394 11.7412 76.3338 11.6808 76.2281C11.5449 76.0016 11.4242 75.7299 11.3185 75.428C11.2128 75.1411 11.1373 74.8392 11.1071 74.5373C10.8656 76.5904 11.0769 78.7945 11.3034 80.8627L11.4242 81.9799C12.496 93.1664 18.7913 101.62 30.0835 107.146C30.0835 102.813 30.0835 98.2539 30.1137 93.7401C29.223 93.3928 28.3172 92.955 27.5171 92.0493C25.2828 89.5281 24.6487 85.7842 24.075 82.4932C23.9996 82.0252 23.9241 81.5723 23.8335 81.1345L23.592 79.7607C23.0183 76.4545 22.4144 73.0427 20.6783 70.4008C19.7423 68.9818 18.3082 68.1816 16.723 68.1816C15.2285 68.1816 13.7792 68.9063 12.7677 70.1593C11.9676 71.1406 11.5147 72.303 11.2581 73.556C11.2883 73.4956 11.3185 73.4201 11.3638 73.3748C11.394 73.3296 11.4543 73.2994 11.4996 73.2994C11.5449 73.2994 11.5751 73.2994 11.6053 73.3296C11.7261 73.4352 11.7865 73.5409 11.8469 73.6617C11.9072 73.7825 11.9374 73.9183 11.9827 74.0542C12.1488 74.6279 12.345 75.1713 12.5262 75.745C12.5413 75.8054 12.5564 75.896 12.5413 76.0016C12.5413 76.1677 12.5111 76.2583 12.4809 76.3489L12.496 76.3187ZM25.4941 97.2576C25.5243 97.3632 25.4941 97.4689 25.4639 97.5444C25.4035 97.6803 25.3583 97.7407 25.2979 97.7708C25.2375 97.801 25.2073 97.8161 25.1771 97.8161C24.9959 97.7105 24.9506 97.6501 24.9205 97.5142C24.8752 97.3028 24.845 97.0915 24.8299 96.8952C24.8299 96.699 24.8299 96.4876 24.8299 96.2612C24.8299 96.231 24.845 96.1857 24.8601 96.1555C24.9054 96.0951 24.9205 96.08 24.9506 96.0649C24.9808 96.0649 25.011 96.0649 25.0261 96.1253C25.1318 96.3065 25.2224 96.4876 25.2979 96.6688C25.3734 96.85 25.4337 97.0462 25.479 97.2576H25.4941ZM23.8486 87.792C23.8788 87.6713 23.8939 87.5958 23.9392 87.5505C23.9845 87.4901 24.0298 87.4599 24.0901 87.4599C24.1656 87.4599 24.2109 87.4599 24.2713 87.5203C24.6789 87.8071 24.9808 88.0638 25.2224 88.5167C25.2526 88.562 25.2677 88.6223 25.2677 88.7129C25.2677 88.8488 25.2677 88.9092 25.2677 88.9696C25.2677 88.9998 25.2677 89.03 25.2375 89.0601C25.2375 89.1054 25.2073 89.1507 25.1771 89.1809C25.0261 89.2564 24.9808 89.2564 24.9506 89.2413C24.7091 89.1356 24.5279 88.9998 24.3619 88.8337C24.1958 88.6676 24.06 88.4865 23.8939 88.2751C23.8637 88.2298 23.8335 88.1544 23.8184 88.0789C23.8184 87.9732 23.8184 87.8826 23.8184 87.8071L23.8486 87.792ZM24.1807 101.605C24.2562 101.696 24.2864 101.802 24.3015 101.922C24.3166 102.104 24.3015 102.224 24.2864 102.345C24.2411 102.496 24.1958 102.587 24.1354 102.647C24.0449 102.768 23.9694 102.798 23.8788 102.813C23.8335 102.813 23.8033 102.813 23.7731 102.813C23.6523 102.768 23.6071 102.723 23.5467 102.647C23.1844 102.164 22.8371 101.681 22.505 101.183C22.4748 101.122 22.4446 101.047 22.4446 100.956C22.4446 100.82 22.4446 100.715 22.4446 100.624C22.4748 100.473 22.505 100.383 22.5503 100.307C22.5956 100.232 22.656 100.201 22.7164 100.201C22.8069 100.201 22.8673 100.232 22.9277 100.292C23.3504 100.73 23.758 101.183 24.1656 101.651L24.1807 101.605ZM21.9313 80.3796C21.9615 80.2589 22.0219 80.1532 22.0823 80.0928C22.1125 80.0626 22.1276 80.0626 22.1578 80.0475C22.2031 80.0173 22.2635 79.9871 22.3088 79.972C22.3691 79.972 22.4144 80.0022 22.4446 80.0173C22.4748 80.0173 22.505 80.0173 22.5201 80.0475C22.5805 80.1079 22.6258 80.2136 22.6409 80.3494C22.7164 80.9835 22.8824 81.5572 23.1844 82.1157C23.2447 82.2214 23.2598 82.3422 23.2598 82.4781C23.2598 82.5082 23.2598 82.5384 23.2598 82.5686C23.2598 82.6743 23.2296 82.78 23.1994 82.8706C23.1391 83.0215 23.0787 83.1121 23.0032 83.1876C22.8824 83.2782 22.822 83.3084 22.7466 83.3235C22.6409 83.3235 22.5956 83.3084 22.5503 83.2782C22.5201 83.2782 22.505 83.2631 22.4748 83.248C22.3993 83.1876 22.3389 83.097 22.2786 82.9762C22.1729 82.7649 22.0823 82.5535 22.0219 82.3573C21.9464 82.1459 21.9011 81.9346 21.871 81.7232C21.8408 81.5119 21.8257 81.2854 21.8257 81.0741C21.8257 80.8627 21.8559 80.6363 21.9011 80.3947L21.9313 80.3796ZM20.0292 72.8163C20.0443 72.5596 20.0745 72.3181 20.1349 72.0614C20.165 71.9256 20.2254 71.8199 20.2858 71.7595C20.316 71.7293 20.3462 71.7293 20.3613 71.7142C20.4066 71.684 20.467 71.6538 20.5123 71.6387C20.5727 71.6387 20.6179 71.6689 20.6632 71.6991C20.6934 71.6991 20.7236 71.6991 20.7387 71.7293C20.7991 71.7897 20.8595 71.8954 20.8897 72.0313C20.9954 72.5294 21.0105 73.0276 21.0255 73.5409C21.0255 73.6617 21.0255 73.7674 20.9803 73.8579C20.9803 73.8881 20.9501 73.9183 20.935 73.9334C20.9048 73.9787 20.8897 74.0391 20.8595 74.0844C20.8444 74.1146 20.8142 74.1146 20.784 74.1448C20.7538 74.175 20.7236 74.2052 20.6934 74.2203C20.6632 74.2203 20.633 74.2203 20.6179 74.2354C20.5878 74.2354 20.5425 74.2655 20.5123 74.2655C20.467 74.2655 20.4368 74.2655 20.4066 74.2504C20.3764 74.2504 20.3462 74.2504 20.3311 74.2354C20.3009 74.2203 20.2707 74.1901 20.2405 74.1599C20.2254 74.1448 20.1952 74.1297 20.1801 74.0995C20.15 74.0542 20.1349 74.0089 20.1047 73.9636C20.1047 73.9334 20.0745 73.9183 20.0594 73.8881C20.0292 73.7976 20.0141 73.6919 20.0141 73.5711C20.0141 73.3145 20.0141 73.0578 20.0292 72.8163ZM19.3347 90.0716C19.4102 89.9659 19.4706 89.9206 19.5763 89.9056C19.6216 89.9056 19.6669 89.9056 19.6971 89.9056C20.0896 90.0112 20.4519 90.132 20.8293 90.2679C20.8897 90.283 20.935 90.3283 20.9803 90.3735C21.0406 90.4641 21.0708 90.5094 21.0859 90.5547C21.0859 90.5849 21.0859 90.6151 21.101 90.6453C21.101 90.6906 21.1161 90.7359 21.1312 90.7811C21.1312 90.8113 21.1312 90.8415 21.1312 90.8717C21.1312 90.917 21.1312 90.9623 21.1312 91.0076C21.1312 91.0378 21.1312 91.068 21.1161 91.0982C21.1161 91.1435 21.101 91.1737 21.0859 91.2189C21.0859 91.2491 21.0708 91.2793 21.0557 91.2944C21.0406 91.3246 21.0255 91.3548 20.9954 91.385C20.9199 91.4605 20.8897 91.4756 20.8595 91.4907C20.7236 91.5209 20.6783 91.5058 20.633 91.4907C20.2556 91.3246 19.8782 91.1737 19.5159 90.9774C19.4253 90.9321 19.3649 90.8415 19.3196 90.7359C19.2744 90.6151 19.2442 90.4943 19.2442 90.3886C19.2442 90.2377 19.2744 90.1471 19.3196 90.0565L19.3347 90.0716ZM16.7834 79.5191C16.7834 79.5191 16.8136 79.3682 16.8438 79.3078C16.874 79.2323 16.9193 79.187 16.9646 79.1417C17.0401 79.0662 17.1005 79.0511 17.1608 79.0511C17.3269 79.1115 17.3722 79.1417 17.4175 79.2021C17.5533 79.3531 17.6439 79.504 17.7496 79.6701C17.8402 79.8211 17.9308 79.9871 18.0213 80.1683C18.0666 80.2589 18.0817 80.3796 18.0968 80.4853C18.0968 80.5155 18.0968 80.5457 18.0968 80.5759C18.0968 80.6665 18.0666 80.7571 18.0364 80.8325C17.9761 80.9684 17.9308 81.0439 17.8704 81.1043C17.7647 81.1798 17.7043 81.2099 17.6439 81.225C17.5533 81.225 17.5081 81.2099 17.4779 81.1798C17.3571 81.0892 17.2967 81.0137 17.2363 80.908C17.0552 80.5457 16.9193 80.1985 16.8136 79.806C16.7985 79.7456 16.7985 79.6701 16.8136 79.5946V79.5493L16.7834 79.5191ZM16.7834 93.5438C16.7834 93.5438 16.7834 93.6193 16.7985 93.6646C16.8136 93.7401 16.8287 93.8156 16.8287 93.9061C16.8287 93.9514 16.8136 93.9816 16.7985 94.0269C16.7985 94.1024 16.7834 94.1779 16.7532 94.2232C16.7381 94.2534 16.6928 94.2534 16.6627 94.2835C16.6174 94.3137 16.5872 94.359 16.5268 94.359C16.0437 94.3288 15.7569 94.1779 15.3945 93.891C15.3191 93.8306 15.2587 93.7401 15.2285 93.6193C15.1832 93.4834 15.1832 93.3627 15.1832 93.2419C15.1983 93.0758 15.2285 92.9852 15.2889 92.8947C15.3794 92.7739 15.4549 92.7286 15.5455 92.7286C15.6059 92.7286 15.6361 92.7286 15.6814 92.7286C15.8927 92.789 16.0588 92.8494 16.2098 92.94C16.3607 93.0305 16.4966 93.1513 16.6476 93.3023C16.6928 93.3476 16.7381 93.4381 16.7834 93.5589V93.5438ZM15.1681 69.1478C15.1681 69.1478 15.1983 69.012 15.2285 68.9516C15.2889 68.8308 15.3342 68.7704 15.3945 68.7251C15.47 68.6647 15.5153 68.6496 15.5606 68.6496C15.6512 68.6496 15.6965 68.6647 15.7267 68.6949C15.8323 68.7855 15.8927 68.8459 15.9531 68.9516C16.0739 69.1478 16.1645 69.3592 16.2399 69.5705C16.2852 69.6913 16.3003 69.8272 16.3003 69.9479C16.3003 69.9781 16.3003 70.0234 16.3003 70.0536C16.3003 70.1442 16.2701 70.2197 16.2399 70.2952C16.2399 70.3253 16.2249 70.3555 16.2098 70.3857C16.1645 70.4763 16.1041 70.5518 16.0437 70.6122C15.9682 70.6726 15.8927 70.7028 15.8172 70.7028C15.6965 70.6877 15.6361 70.6575 15.5908 70.6122C15.5757 70.5971 15.5455 70.582 15.5304 70.5518C15.4549 70.4763 15.3945 70.3555 15.3493 70.1895C15.2738 69.963 15.2285 69.7215 15.1832 69.4799C15.1681 69.3894 15.1832 69.2988 15.1832 69.2082C15.1832 69.178 15.1832 69.1629 15.1832 69.1327L15.1681 69.1478ZM14.0057 82.8404C14.0359 82.7196 14.0811 82.6139 14.1566 82.5384C14.1717 82.5082 14.2019 82.5082 14.2321 82.4932C14.2774 82.4479 14.3378 82.4177 14.3982 82.4177C14.4737 82.4026 14.5038 82.4177 14.534 82.4177C14.6699 82.4932 14.7303 82.5535 14.7756 82.6743C14.8511 82.8555 14.9115 83.0517 14.9567 83.2329C15.0926 83.8066 15.1228 84.4104 15.1832 85.0143C15.1832 85.135 15.1832 85.2256 15.153 85.3313C15.153 85.3615 15.1228 85.3917 15.1228 85.4219C15.0926 85.4823 15.0775 85.5276 15.0322 85.5879C15.0171 85.6181 14.9869 85.6332 14.9718 85.6634C14.9416 85.6936 14.8964 85.7389 14.8511 85.754C14.8209 85.7691 14.8058 85.7842 14.7756 85.7993C14.7303 85.8144 14.685 85.8295 14.6397 85.8295C14.4737 85.8295 14.3831 85.7993 14.3076 85.7238C14.2019 85.5879 14.1264 85.4672 14.1113 85.286C14.066 84.8784 14.0057 84.4859 13.9755 84.0783C13.9453 83.6707 13.9453 83.2782 14.0208 82.8706L14.0057 82.8404Z\" />\n    <path d=\"M60.248 62.0524C60.248 41.7325 53.1375 39 46.178 39C39.2185 39 32.1081 41.7325 32.1081 62.0524C32.1081 63.3205 32.0628 66.2794 32.0175 70.28C31.791 87.641 31.3231 123.752 32.5157 130.274C35.1274 144.449 40.1545 144.449 44.1853 144.449H48.0349C52.1261 144.449 57.2287 144.449 59.8555 130.138C61.0481 123.661 60.565 87.6259 60.3386 70.3102C60.2782 66.2794 60.248 63.3054 60.248 62.0373V62.0524ZM33.4517 58.6104C33.5422 58.4745 33.6479 58.3387 33.7687 58.2179C33.8291 58.1575 33.9046 58.1273 33.9649 58.1273C34.0857 58.1424 34.1461 58.1877 34.2065 58.2481C34.282 58.3387 34.3122 58.4443 34.3424 58.55C34.3726 58.7161 34.3877 58.8368 34.3726 58.9425C34.3273 59.1086 34.2971 59.1992 34.2065 59.2595L34.0404 59.5615L33.8744 59.8634C33.8744 59.9842 33.8291 60.0899 33.7687 60.1804C33.663 60.271 33.6177 60.3012 33.5724 60.3163C33.5121 60.3314 33.4819 60.3163 33.4517 60.3012C33.3309 60.2257 33.2856 60.1502 33.2554 60.0144C33.1346 59.5011 33.2101 59.0331 33.4668 58.6255L33.4517 58.6104ZM33.0893 98.5105C33.0592 98.586 33.0139 98.6464 32.9686 98.6766C32.8931 98.7219 32.8629 98.737 32.8327 98.737C32.7572 98.737 32.7119 98.7219 32.6817 98.6917C32.6214 98.6464 32.5761 98.6011 32.5459 98.5558C32.5006 98.4652 32.4855 98.42 32.4704 98.3747C32.4553 98.2539 32.4402 98.1935 32.4553 98.118C32.5308 97.6953 32.6063 97.2877 32.7119 96.8801C32.8176 96.4725 32.9384 96.08 33.1044 95.6875C33.1497 95.5818 33.195 95.5214 33.2554 95.461C33.346 95.4006 33.3762 95.3855 33.4215 95.3855C33.5271 95.3855 33.5724 95.4006 33.6177 95.4459C33.7083 95.5063 33.7536 95.5667 33.7838 95.6271C33.8442 95.7328 33.8593 95.7932 33.8744 95.8535C33.9046 96.0045 33.9046 96.0951 33.8895 96.1706C33.7989 96.5782 33.6932 96.9707 33.5573 97.3632C33.4215 97.7406 33.2554 98.118 33.0893 98.5105ZM33.0893 77.6924C33.029 77.783 32.9686 77.8283 32.9082 77.8283C32.8478 77.8283 32.8025 77.8132 32.7723 77.7679C32.7119 77.6924 32.6968 77.6471 32.6666 77.6018C32.6365 77.5263 32.6214 77.466 32.6214 77.3905C32.6214 77.2848 32.6214 77.2244 32.6214 77.1791C32.8025 76.6508 33.0139 76.1677 33.2705 75.6695C33.3007 75.6091 33.3309 75.5638 33.3762 75.5336C33.5422 75.5034 33.5875 75.5336 33.6328 75.5789C33.7083 75.6695 33.7536 75.7148 33.7838 75.7903C33.8291 75.8808 33.8442 75.9563 33.8593 76.0318C33.8593 76.1677 33.8593 76.2431 33.8442 76.3035C33.7385 76.5451 33.6177 76.7866 33.497 77.0131C33.3762 77.2546 33.2403 77.4811 33.0893 77.7075V77.6924ZM33.6026 117.728C33.6479 117.638 33.6932 117.577 33.7536 117.532C33.8442 117.472 33.8744 117.457 33.9197 117.457C34.0253 117.457 34.0706 117.472 34.1159 117.502C34.1914 117.547 34.2367 117.608 34.2669 117.668C34.3122 117.774 34.3424 117.819 34.3424 117.879C34.3726 118.03 34.3726 118.106 34.3424 118.181C34.2518 118.559 34.131 118.921 34.0102 119.268C33.8895 119.615 33.7385 119.978 33.6026 120.325C33.5573 120.431 33.5121 120.491 33.4668 120.536C33.3913 120.582 33.3611 120.612 33.3309 120.612C33.2403 120.612 33.195 120.582 33.1497 120.551C33.0592 120.476 33.0139 120.4 32.9837 120.325C32.9384 120.219 32.9233 120.144 32.9082 120.068C32.8931 119.902 32.8931 119.827 32.9082 119.736C33.0139 119.389 33.1044 119.042 33.2101 118.71C33.3158 118.378 33.4366 118.03 33.5875 117.713L33.6026 117.728ZM32.3647 66.4304C32.3949 66.2945 32.4251 66.204 32.4704 66.1436C32.5157 66.0832 32.561 66.053 32.6214 66.0379C32.7119 66.0379 32.7572 66.053 32.8176 66.1134C33.2554 66.5512 33.7234 66.9437 34.0706 67.457C34.1159 67.5173 34.131 67.6079 34.1461 67.7136C34.1461 67.8646 34.1461 67.9853 34.1461 68.091C34.1159 68.2571 34.0857 68.3628 34.0253 68.4382C33.98 68.5137 33.9197 68.5439 33.8442 68.559C33.7385 68.559 33.6781 68.5288 33.6026 68.4684C33.1346 68.0306 32.8025 67.4721 32.4402 66.9437C32.41 66.8984 32.3949 66.8078 32.3798 66.7323C32.3798 66.5965 32.3798 66.5059 32.3798 66.4153L32.3647 66.4304ZM32.0024 85.452C32.0024 85.3765 32.0326 85.286 32.0628 85.2256C32.1081 85.1048 32.1534 85.0293 32.2138 84.984C32.3043 84.9086 32.3496 84.8935 32.3949 84.8784C32.4704 84.8784 32.5006 84.8784 32.5459 84.9086C32.6516 84.984 32.6968 85.0595 32.7421 85.1501C32.9837 85.6634 33.2252 86.1767 33.4366 86.705C33.4819 86.7956 33.4819 86.9013 33.4819 87.007C33.4668 87.173 33.4517 87.2636 33.4215 87.3391C33.3762 87.475 33.3158 87.5504 33.2554 87.5957C33.1648 87.6712 33.1044 87.7014 33.0592 87.7014C32.9686 87.7014 32.9384 87.6863 32.9082 87.6561C32.8025 87.5806 32.7421 87.5052 32.6968 87.3995C32.4704 86.8711 32.259 86.3276 32.0477 85.7992C32.0175 85.7087 32.0024 85.6181 32.0024 85.5275C32.0024 85.4973 32.0024 85.4822 32.0024 85.452ZM31.9118 107.644C31.942 107.523 31.9571 107.493 31.9722 107.433C32.0326 107.327 32.0628 107.312 32.093 107.282C32.2138 107.236 32.259 107.267 32.3194 107.312C32.7421 107.75 33.0743 108.218 33.4064 108.731C33.4819 108.837 33.5121 108.972 33.5271 109.108C33.5271 109.138 33.5271 109.169 33.5271 109.199C33.5271 109.32 33.5271 109.44 33.4819 109.546C33.4366 109.682 33.3762 109.788 33.3158 109.863C33.195 109.969 33.1346 110.014 33.0592 110.014C32.9837 110.014 32.9384 109.999 32.8931 109.969C32.7572 109.878 32.6968 109.803 32.6365 109.667C32.3496 109.048 32.093 108.459 31.9118 107.81C31.9118 107.765 31.9118 107.704 31.9118 107.629V107.644ZM34.3575 129.489C34.3122 129.624 34.2669 129.715 34.2216 129.775C34.131 129.881 34.0706 129.926 33.98 129.926C33.7687 129.881 33.7083 129.836 33.6479 129.76C33.1799 129.232 32.8025 128.613 32.3949 128.024C32.3647 127.979 32.3496 127.919 32.3496 127.858C32.3496 127.753 32.3496 127.677 32.3496 127.617C32.3798 127.511 32.3949 127.435 32.4251 127.39C32.4553 127.345 32.5006 127.315 32.5459 127.315C32.6214 127.315 32.6515 127.33 32.7119 127.375C32.9686 127.617 33.2403 127.843 33.497 128.085C33.7536 128.326 34.0102 128.568 34.2367 128.839C34.2971 128.915 34.3424 129.021 34.3575 129.126C34.3726 129.292 34.3575 129.413 34.3575 129.519V129.489ZM34.6594 51.7717C34.6594 51.7717 34.6141 51.9075 34.5839 51.9679C34.5688 51.9981 34.5537 52.0283 34.5386 52.0434C34.4933 52.1038 34.448 52.134 34.4027 52.1793C34.2669 52.2699 34.1914 52.3 34.1159 52.3C34.0253 52.3 33.9499 52.2548 33.8744 52.1944C33.7536 52.0585 33.7083 51.9528 33.6781 51.7717C33.6177 51.3339 33.5724 50.881 33.5422 50.4432C33.5422 50.3677 33.5422 50.3073 33.5724 50.2469C33.6177 50.1412 33.6328 50.111 33.663 50.0658C33.7385 49.9752 33.7687 49.9299 33.814 49.8997C33.8744 49.8695 33.9197 49.8544 33.9649 49.8393C34.0404 49.8393 34.0857 49.8695 34.1159 49.8846C34.2065 49.9601 34.2367 50.0205 34.282 50.111C34.4178 50.5187 34.5537 50.9112 34.6745 51.3188C34.7047 51.4395 34.7047 51.5603 34.6896 51.666C34.6896 51.6962 34.6745 51.7264 34.6594 51.7566V51.7717ZM36.2143 137.988C36.2143 138.154 36.1539 138.245 36.1087 138.335C36.0181 138.441 35.9577 138.471 35.8822 138.471C35.7916 138.471 35.7463 138.456 35.7161 138.441C35.6105 138.38 35.5803 138.365 35.5501 138.32C35.4595 138.23 35.4293 138.184 35.4142 138.139C35.3538 138.003 35.3236 137.912 35.3236 137.822C35.2934 137.444 35.2934 137.082 35.2934 136.705C35.2934 136.478 35.3538 136.312 35.4444 136.191C35.535 136.071 35.6558 136.01 35.7765 136.01C35.8671 136.01 35.9426 136.071 36.0181 136.116C36.0483 136.146 36.0936 136.131 36.1238 136.176C36.2143 136.297 36.2747 136.463 36.2747 136.69C36.2747 137.127 36.2747 137.565 36.2294 138.003L36.2143 137.988ZM43.6267 107.508C43.7475 106.995 43.9136 106.497 44.0947 105.983C44.14 105.847 44.2004 105.772 44.2608 105.696C44.3665 105.621 44.4117 105.606 44.457 105.606C44.5778 105.621 44.6382 105.651 44.6986 105.696C44.8194 105.802 44.8797 105.878 44.9401 105.983C45.0005 106.134 45.0307 106.225 45.0458 106.315C45.0458 106.346 45.0458 106.376 45.0458 106.406C45.0458 106.527 45.0458 106.648 45.0005 106.753C44.7439 107.372 44.5174 108.006 44.1551 108.565C44.1098 108.625 44.0645 108.67 44.0343 108.701C43.974 108.731 43.9438 108.746 43.9136 108.746C43.8532 108.746 43.8079 108.716 43.7626 108.67C43.6871 108.595 43.6418 108.535 43.6116 108.474C43.5814 108.414 43.5512 108.338 43.5362 108.263C43.5211 108.142 43.506 108.067 43.5211 108.006C43.5512 107.825 43.6116 107.659 43.6418 107.493L43.6267 107.508ZM42.9625 81.1646C43.0531 81.1646 43.1285 81.2099 43.1889 81.2854C43.2644 81.3911 43.3097 81.4967 43.3248 81.6024C43.355 81.7685 43.355 81.8742 43.3399 81.9798C43.3248 82.1308 43.2946 82.2214 43.2493 82.2969C42.9776 82.7196 42.6455 83.0668 42.4492 83.5348C42.3888 83.6555 42.3284 83.731 42.2529 83.7763C42.0718 83.8216 42.0416 83.8065 41.9963 83.7914C41.8906 83.7461 41.8302 83.6857 41.785 83.6103C41.7095 83.4744 41.6793 83.3687 41.6944 83.2479C41.7246 82.8554 41.785 82.4176 41.951 82.0402C42.1171 81.6628 42.3888 81.3458 42.7964 81.1948C42.8568 81.1797 42.9021 81.1646 42.9474 81.1646H42.9625ZM41.4679 70.0234C41.3773 70.0083 41.317 69.963 41.2717 69.9026C41.2113 69.812 41.166 69.7365 41.1358 69.646C41.0905 69.495 41.0754 69.4044 41.0603 69.3138C41.0603 69.1629 41.0603 69.0874 41.0905 69.027C41.2264 68.7251 41.3622 68.4382 41.5283 68.1514C41.6944 67.8646 41.8755 67.6079 42.0869 67.3513C42.1624 67.2607 42.2378 67.2305 42.3133 67.2154C42.4341 67.2154 42.5096 67.2607 42.57 67.3362C42.6455 67.4419 42.6907 67.5324 42.7209 67.6381C42.7813 67.8042 42.7964 67.9099 42.8115 68.0155C42.8115 68.1816 42.8115 68.2722 42.7813 68.3477C42.5096 68.9213 42.1473 69.4346 41.7246 69.9177C41.6491 69.9932 41.5887 70.0234 41.5283 70.0234H41.5132H41.4679ZM41.4981 50.262C41.5887 50.0507 41.7246 49.8393 41.8906 49.5978C41.9661 49.4921 42.0416 49.4317 42.1171 49.3864C42.2228 49.3562 42.268 49.326 42.2982 49.326C42.4492 49.3713 42.4794 49.3864 42.5247 49.4166C42.6304 49.5072 42.6606 49.5525 42.7058 49.6129C42.7813 49.7336 42.8115 49.8242 42.8417 49.9148C42.8719 50.0658 42.887 50.1261 42.887 50.2016C42.887 50.2318 42.887 50.262 42.887 50.2922C42.887 50.3677 42.887 50.4281 42.8719 50.4885C42.8719 50.5187 42.8719 50.5488 42.8719 50.579C42.8417 50.6696 42.8115 50.7451 42.7662 50.8206C42.5398 51.1376 42.3586 51.4244 42.0567 51.5754C41.951 51.6207 41.8453 51.6509 41.7095 51.666C41.634 51.666 41.6189 51.6358 41.5736 51.6207C41.5434 51.6207 41.5132 51.6207 41.4981 51.5905C41.4679 51.5603 41.4528 51.515 41.4226 51.4697C41.3622 51.349 41.3622 51.2886 41.3472 51.2282C41.3321 51.0923 41.3321 51.0168 41.3321 50.9715C41.3622 50.6847 41.4226 50.4583 41.5132 50.2318L41.4981 50.262ZM39.9885 42.0495C40.0187 41.9438 40.0338 41.8985 40.0489 41.8381C40.0941 41.7476 40.1394 41.7023 40.1696 41.657C40.23 41.6117 40.2602 41.5966 40.3055 41.5966C40.381 41.5966 40.4112 41.5966 40.4263 41.6268C40.5168 41.6872 40.547 41.7476 40.5923 41.8231C40.7886 42.2307 40.9999 42.6081 41.1811 43.0308C41.2415 43.1666 41.2566 43.3025 41.2415 43.4233C41.2415 43.4686 41.2415 43.4988 41.2415 43.529C41.2415 43.6195 41.2113 43.695 41.1811 43.7705C41.1811 43.8007 41.1509 43.8309 41.1358 43.8611C41.0905 43.9517 41.0301 44.0271 40.9546 44.0875C40.8641 44.163 40.7886 44.1781 40.7131 44.1932C40.5923 44.1781 40.5319 44.1479 40.4716 44.1026C40.4565 44.0875 40.4263 44.0724 40.4112 44.0422C40.3357 43.9517 40.2753 43.846 40.2451 43.6648C40.1847 43.4233 40.1545 43.1817 40.1243 42.9402C40.0941 42.6987 40.0489 42.4722 40.0036 42.2156C40.0036 42.1552 40.0036 42.0797 40.0036 42.0193L39.9885 42.0495ZM39.6412 57.4631C39.6412 57.3272 39.7016 57.2366 39.7771 57.1611C39.7922 57.1309 39.8224 57.1309 39.8526 57.1158C39.8979 57.0705 39.9583 57.0555 40.0187 57.0404C40.0941 57.0253 40.1243 57.0404 40.1545 57.0555C40.2904 57.1158 40.3659 57.1913 40.4112 57.297C40.547 57.614 40.6829 57.8707 40.9094 58.1424C40.9999 58.2481 41.0301 58.3689 41.0452 58.5047C41.0452 58.5349 41.0452 58.5651 41.0452 58.5953C41.0452 58.7312 41.0452 58.867 40.9999 59.0029C40.9395 59.169 40.8943 59.2746 40.8188 59.3652C40.698 59.5011 40.6225 59.5464 40.5319 59.5615C40.4716 59.5615 40.4414 59.5615 40.4112 59.5464C40.2753 59.486 40.2149 59.4256 40.1545 59.335C39.8375 58.8972 39.6714 58.4594 39.6412 57.9763C39.6412 57.8103 39.6412 57.6442 39.6412 57.4631ZM41.3622 109.516C41.317 109.652 41.2717 109.742 41.2113 109.818C41.1207 109.939 41.0452 109.969 40.9697 109.984C40.7735 109.924 40.7131 109.878 40.6527 109.788C40.4263 109.471 40.23 109.138 40.0338 108.806C40.0036 108.761 39.9885 108.67 39.9734 108.58C39.9734 108.444 39.9734 108.338 39.9734 108.248C40.0036 108.097 40.0338 108.006 40.079 107.931C40.1243 107.855 40.1696 107.825 40.23 107.81C40.3206 107.81 40.381 107.84 40.4414 107.901C40.7131 108.187 40.9848 108.489 41.2415 108.791C41.317 108.882 41.3472 108.988 41.3622 109.093C41.3622 109.274 41.3622 109.395 41.3321 109.501L41.3622 109.516ZM38.5845 74.7788C38.5845 74.6429 38.5996 74.5523 38.6298 74.4618C38.66 74.3561 38.6902 74.2957 38.7355 74.2353C38.8109 74.1447 38.8562 74.1145 38.9166 74.1145C39.0827 74.1749 39.1431 74.2202 39.1883 74.2806C39.5809 74.7939 39.9885 75.2468 40.4867 75.6695C40.5319 75.7148 40.5772 75.7752 40.6074 75.8355C40.6527 75.9563 40.6678 76.0016 40.6829 76.062C40.6829 76.0922 40.6829 76.1224 40.6829 76.1526C40.6829 76.1979 40.6829 76.2582 40.6829 76.3035C40.6829 76.3337 40.6829 76.3639 40.6829 76.3941C40.6829 76.4545 40.6829 76.4998 40.6678 76.5451C40.6678 76.5753 40.6678 76.6055 40.6527 76.6357C40.6376 76.6809 40.6225 76.7413 40.5923 76.7715C40.5319 76.8923 40.4866 76.9376 40.4414 76.9678C40.381 76.998 40.3357 77.0131 40.2904 77.0131C40.1998 77.0131 40.1243 76.9829 40.0338 76.9074C39.3544 76.4092 38.8864 75.7601 38.6147 74.9599C38.5996 74.8996 38.5845 74.8241 38.5845 74.7335V74.7788ZM39.7318 90.9623C39.4299 90.5698 39.1582 90.1772 38.8713 89.7696C38.826 89.7093 38.8109 89.6187 38.8109 89.513C38.8109 89.362 38.8109 89.2564 38.8109 89.1507C38.8411 88.9846 38.8713 88.894 38.9317 88.8186C38.977 88.7431 39.0374 88.7129 39.0978 88.6978C39.2034 88.6978 39.2638 88.728 39.3242 88.7884C39.6865 89.1507 40.0338 89.5281 40.3508 89.9206C40.4263 90.0112 40.4565 90.1169 40.4716 90.2376C40.4867 90.4339 40.4716 90.5547 40.4565 90.6603C40.4112 90.8113 40.3659 90.9019 40.3055 90.9774C40.2149 91.0981 40.1394 91.1434 40.0489 91.1434C40.0036 91.1434 39.9734 91.1434 39.9432 91.1434C39.8224 91.0981 39.762 91.0528 39.7016 90.9623H39.7318ZM39.7771 115.856C39.7771 115.856 39.7469 115.721 39.7469 115.645C39.7469 115.524 39.7469 115.449 39.7771 115.373C39.8073 115.283 39.8375 115.237 39.8677 115.192C39.9281 115.117 39.9734 115.087 40.0338 115.087C40.1243 115.087 40.1998 115.132 40.2753 115.222C40.7282 115.736 41.1358 116.249 41.5132 116.838C41.5736 116.928 41.6038 117.064 41.6038 117.185C41.6038 117.215 41.6038 117.245 41.6038 117.276C41.6038 117.411 41.6038 117.532 41.5585 117.653C41.4981 117.804 41.4528 117.91 41.4075 117.985C41.3019 118.121 41.2264 118.166 41.1509 118.166C41.1056 118.166 41.0754 118.166 41.0452 118.151C40.9395 118.091 40.8792 118.03 40.8188 117.94C40.6074 117.608 40.4263 117.26 40.2602 116.913C40.079 116.566 39.9281 116.219 39.762 115.856H39.7771ZM41.8151 128.824C41.7699 128.96 41.7246 129.051 41.6642 129.126C41.5736 129.247 41.4981 129.277 41.4226 129.292C41.2264 129.232 41.166 129.187 41.1207 129.111C41.015 128.945 40.9094 128.779 40.8037 128.613C40.698 128.447 40.5923 128.281 40.4867 128.115C40.4565 128.07 40.4414 127.979 40.4263 127.888C40.4263 127.753 40.4263 127.647 40.4414 127.556C40.4716 127.405 40.5017 127.315 40.547 127.239C40.5923 127.164 40.6376 127.134 40.698 127.118C40.7886 127.118 40.849 127.149 40.9094 127.209C41.1811 127.511 41.4528 127.798 41.7095 128.115C41.785 128.205 41.8151 128.311 41.8302 128.417C41.8302 128.598 41.8302 128.719 41.8 128.824H41.8151ZM42.6455 99.2352C42.4341 99.8692 42.0869 100.352 41.634 100.835C41.5585 100.926 41.483 100.941 41.4226 100.956C41.317 100.956 41.2566 100.911 41.2113 100.835C41.166 100.745 41.1358 100.639 41.1056 100.533C41.0754 100.367 41.0603 100.262 41.0603 100.156C41.0603 100.005 41.0754 99.9145 41.1056 99.8541C41.2264 99.5824 41.3623 99.3257 41.5132 99.0842C41.6642 98.8427 41.8604 98.6162 42.102 98.4501C42.1775 98.4049 42.2378 98.3747 42.2982 98.3747C42.4039 98.3747 42.4643 98.4049 42.5096 98.4652C42.5549 98.5256 42.5851 98.6011 42.6153 98.6766C42.6455 98.7974 42.6605 98.8879 42.6605 98.9634C42.6605 99.0842 42.6606 99.1748 42.6304 99.2352H42.6455ZM43.8381 138.335C43.6871 138.637 43.5362 138.939 43.4003 139.241C43.3701 139.301 43.3399 139.347 43.3097 139.362C43.1587 139.392 43.1134 139.362 43.0833 139.316C43.0229 139.226 42.9927 139.181 42.9625 139.105C42.9323 138.999 42.9172 138.924 42.9021 138.848C42.9021 138.713 42.9021 138.637 42.9474 138.577C43.0983 138.29 43.2644 137.988 43.4154 137.701C43.4456 137.641 43.4758 137.611 43.506 137.58C43.6418 137.55 43.6871 137.58 43.7324 137.626C43.7928 137.701 43.823 137.762 43.8381 137.837C43.8683 137.928 43.8834 138.003 43.8834 138.079C43.8834 138.199 43.8834 138.275 43.8532 138.335H43.8381ZM44.5325 130.108C44.3816 130.847 44.2155 131.602 44.0645 132.342C44.0343 132.478 43.989 132.553 43.9287 132.629C43.8381 132.719 43.7777 132.749 43.7173 132.749C43.6569 132.749 43.5965 132.734 43.5512 132.704C43.4758 132.644 43.4456 132.614 43.4154 132.568C43.355 132.463 43.3399 132.417 43.3248 132.372C43.2946 132.221 43.2946 132.131 43.3097 132.04C43.4456 131.285 43.5814 130.53 43.7324 129.775C43.7626 129.64 43.8079 129.534 43.8683 129.474C43.9739 129.368 44.0343 129.338 44.1098 129.338C44.1853 129.338 44.2306 129.368 44.291 129.398C44.3816 129.458 44.4117 129.504 44.4419 129.534C44.5174 129.64 44.5325 129.7 44.5476 129.745C44.5778 129.911 44.5929 130.002 44.5627 130.092L44.5325 130.108ZM45.1666 119.706C45.0156 120.25 44.8043 120.778 44.7439 121.336C44.7439 121.487 44.6835 121.578 44.6382 121.654C44.5627 121.759 44.5023 121.789 44.4268 121.789C44.3363 121.789 44.3061 121.774 44.2759 121.759C44.1853 121.699 44.1551 121.684 44.1249 121.654C44.0494 121.563 44.0192 121.518 43.989 121.472C43.9287 121.336 43.8985 121.261 43.8985 121.186C43.8683 120.974 43.8683 120.748 43.8683 120.536C43.8683 120.37 43.8834 120.219 43.9136 120.068C44.0041 119.6 44.2004 119.178 44.5627 118.83C44.6382 118.755 44.7137 118.725 44.7741 118.725C44.8948 118.725 44.9552 118.77 45.0005 118.83C45.0609 118.906 45.0911 118.997 45.1213 119.087C45.1666 119.223 45.1817 119.329 45.1817 119.419C45.1817 119.555 45.1817 119.646 45.1817 119.706H45.1666ZM52.3978 78.7643C52.428 78.6133 52.4733 78.5076 52.5337 78.4321C52.6394 78.3265 52.7148 78.2812 52.7903 78.2812C52.8658 78.2812 52.9262 78.3114 52.9866 78.3416C53.0772 78.417 53.1224 78.4472 53.1526 78.4925C53.1677 78.5227 53.1828 78.5378 53.1979 78.568C53.2281 78.6133 53.2432 78.6737 53.2734 78.7341C53.2734 78.7643 53.2885 78.7945 53.3036 78.8247C53.3187 78.9152 53.3338 79.0209 53.3036 79.1266C53.2281 79.5795 53.1224 80.0173 53.0168 80.4551C52.9866 80.5909 52.9413 80.6815 52.8809 80.757C52.7903 80.8627 52.7148 80.8929 52.6545 80.8929C52.5941 80.8929 52.5337 80.8627 52.4884 80.8325C52.4129 80.7721 52.3676 80.7268 52.3525 80.6966C52.2921 80.5909 52.2619 80.5306 52.2468 80.4853C52.2016 80.3343 52.2016 80.2437 52.2167 80.138C52.277 79.6852 52.3223 79.2323 52.3978 78.7794V78.7643ZM52.1714 94.6005C52.1714 94.6005 52.0506 94.5703 52.0053 94.5401C51.9147 94.4647 51.8845 94.4345 51.8543 94.3892C51.7789 94.2684 51.7638 94.2231 51.7487 94.1627C51.7034 93.9967 51.7034 93.9061 51.7185 93.8004C51.7789 93.3626 51.8543 92.9248 51.9449 92.487C52.0355 92.0492 52.1261 91.6265 52.2468 91.1887C52.277 91.083 52.3223 91.0076 52.3676 90.9472C52.4431 90.8868 52.4733 90.8717 52.5186 90.8566C52.6243 90.8566 52.6696 90.8868 52.7148 90.917C52.8054 90.9774 52.8507 91.0377 52.896 91.1132C52.9564 91.2189 52.9866 91.2793 53.0017 91.3548C53.047 91.5057 53.0621 91.5963 53.047 91.6718C52.9413 92.5172 52.7752 93.3173 52.579 94.1325C52.5488 94.2835 52.4884 94.3741 52.428 94.4496C52.3223 94.5552 52.2619 94.5854 52.1865 94.5854L52.1714 94.6005ZM51.6883 66.219C51.6883 66.219 51.7638 66.2794 51.794 66.3096C51.8241 66.3398 51.8392 66.3549 51.8694 66.3851C51.8996 66.4304 51.9298 66.4908 51.9449 66.5512C51.9449 66.5814 51.9751 66.6116 51.9902 66.6417C52.0204 66.7474 52.0204 66.8682 52.0204 66.989C51.9902 67.3211 51.9147 67.623 51.8241 67.9401C51.794 68.0306 51.7487 68.091 51.7034 68.1212C51.5071 68.1363 51.4769 68.1212 51.4316 68.091C51.326 67.9853 51.2656 67.925 51.2505 67.8344C51.1448 67.4872 51.0995 67.1701 51.0693 66.8078C51.0693 66.687 51.0693 66.5814 51.0844 66.4908C51.0844 66.4606 51.0995 66.4455 51.1146 66.4153C51.1297 66.37 51.1448 66.3096 51.175 66.2794C51.2656 66.204 51.2958 66.1738 51.326 66.1587C51.5373 66.1436 51.5826 66.1587 51.6128 66.1587C51.643 66.1587 51.6732 66.1738 51.7034 66.1889L51.6883 66.219ZM50.9335 49.9903C51.024 49.9601 51.0542 49.945 51.0844 49.945C51.1901 49.9601 51.2656 50.0054 51.326 50.0809C51.4165 50.2016 51.4618 50.2922 51.492 50.3828C51.5373 50.5338 51.5524 50.6545 51.5524 50.7753C51.5373 50.9716 51.5071 51.0772 51.4316 51.1678C51.0693 51.6509 50.8429 52.134 50.6919 52.7227C50.6617 52.8133 50.6315 52.8737 50.5862 52.919C50.5258 52.9794 50.4806 52.9945 50.4504 52.9945C50.3749 52.9945 50.3296 52.9945 50.2843 52.9492C50.2239 52.9039 50.1937 52.8737 50.1635 52.8284C50.1031 52.7529 50.088 52.7077 50.0579 52.6624C50.0126 52.5567 49.9975 52.4963 49.9975 52.4359C49.9673 51.5754 50.1937 50.8055 50.7372 50.1412C50.7976 50.0658 50.8731 50.0054 50.9335 49.9752V49.9903ZM49.0011 59.0029C49.0313 58.8972 49.0615 58.8368 49.0917 58.7765C49.1521 58.6859 49.2124 58.6557 49.2577 58.6557C49.3634 58.6557 49.4238 58.701 49.4993 58.7916C49.7257 59.0784 49.9673 59.3652 50.1937 59.6521C50.2541 59.7124 50.2692 59.803 50.2843 59.9087C50.2843 60.0597 50.2843 60.1502 50.2692 60.2408C50.2239 60.3616 50.1937 60.422 50.1484 60.4824C50.0729 60.5729 50.0126 60.6031 49.9522 60.6182C49.7861 60.5729 49.7408 60.5277 49.6955 60.4673C49.4842 60.1502 49.2577 59.8483 49.0464 59.5313C49.0011 59.4709 48.986 59.3954 48.9709 59.3048C48.9709 59.169 48.9709 59.0784 48.9709 59.0029H49.0011ZM49.0766 73.3446C49.1219 73.1936 49.1521 73.1031 49.1974 73.0276C49.2426 72.9672 49.3181 72.9219 49.3936 72.9219C49.4993 72.9219 49.5748 72.937 49.6502 73.0125C49.9069 73.2087 50.0729 73.4352 50.2541 73.6918C50.3296 73.7975 50.3598 73.9183 50.3749 74.0541C50.3749 74.0843 50.3749 74.1145 50.3749 74.1447C50.3749 74.2806 50.3749 74.4014 50.3296 74.5372C50.2692 74.7033 50.2239 74.7939 50.1635 74.8694C50.0579 75.0052 49.9673 75.0505 49.8918 75.0505C49.8465 75.0505 49.8163 75.0505 49.7861 75.0354C49.6653 74.975 49.605 74.9146 49.5446 74.8241C49.3634 74.5221 49.1974 74.2655 49.0615 73.9334C49.0313 73.873 49.0313 73.7824 49.0313 73.6918C49.0313 73.5409 49.0313 73.4503 49.0615 73.3446H49.0766ZM49.6351 40.6153C49.6653 40.4342 49.7408 40.2681 49.8465 40.1322C49.9522 39.9964 50.1031 39.8907 50.2994 39.8303C50.3447 39.8303 50.3749 39.8152 50.4051 39.8152C50.5107 39.8303 50.5711 39.8756 50.6164 39.936C50.6768 40.0417 50.707 40.1322 50.7221 40.2228C50.7221 40.3738 50.7221 40.4644 50.6768 40.5549C50.6315 40.6757 50.5711 40.7512 50.4957 40.7965L50.3749 40.9475L50.2541 41.0984C50.239 41.2343 50.1937 41.3249 50.1182 41.3853C50.0126 41.4305 49.9824 41.4607 49.9522 41.4607C49.8616 41.4305 49.8163 41.4003 49.7559 41.3702C49.7257 41.3551 49.7106 41.34 49.6804 41.3098C49.6201 41.2192 49.5748 41.1135 49.5748 40.9776C49.5748 40.8418 49.5899 40.721 49.6201 40.6002L49.6351 40.6153ZM48.6539 44.3744C48.6539 44.2838 48.6841 44.1932 48.7143 44.1026C48.7595 43.997 48.8048 43.9215 48.8501 43.8762C48.9407 43.7856 49.0011 43.7403 49.0464 43.7403C49.2124 43.8158 49.2577 43.8611 49.303 43.9366C49.5748 44.4197 49.8314 44.8876 50.088 45.3707C50.1333 45.4613 50.1484 45.567 50.1484 45.6727C50.1484 45.8387 50.1182 45.9293 50.088 46.0048C50.0428 46.1407 49.9824 46.2161 49.922 46.2765C49.8163 46.352 49.771 46.3822 49.7106 46.3822C49.6201 46.3822 49.5899 46.3822 49.5446 46.352C49.4238 46.2765 49.3634 46.201 49.3181 46.0954C49.0917 45.6425 48.8954 45.1745 48.6841 44.7065C48.6539 44.631 48.6539 44.5404 48.6539 44.4498C48.6539 44.4348 48.6539 44.4046 48.6539 44.3895V44.3744ZM48.4576 85.2256C48.4878 85.0444 48.518 84.9237 48.5482 84.8029C48.6086 84.6368 48.669 84.5311 48.7294 84.4557C48.8199 84.35 48.8954 84.3047 48.986 84.2896C49.1823 84.3349 49.2577 84.3651 49.3181 84.4406C49.9069 85.0746 50.2088 85.7238 50.2541 86.5843C50.2541 86.6899 50.2541 86.8107 50.2088 86.9164C50.2088 86.9466 50.1786 86.9768 50.1786 87.007C50.1484 87.0825 50.1182 87.1428 50.0729 87.2032C50.0579 87.2334 50.0277 87.2636 49.9975 87.2787C49.9522 87.324 49.8918 87.3542 49.8314 87.3844C49.8012 87.3844 49.771 87.4146 49.7408 87.4146C49.6201 87.4146 49.5144 87.4146 49.4087 87.3391C49.2577 87.2485 49.1219 87.1126 49.0162 86.9768C48.6992 86.5541 48.5482 85.9804 48.4425 85.4822C48.4425 85.4067 48.4425 85.3162 48.4425 85.1954L48.4576 85.2256ZM48.8803 99.0842C48.8803 98.9785 48.8803 98.8728 48.8803 98.7823C48.9105 98.6162 48.9407 98.5256 48.986 98.4501C49.0464 98.3747 49.1219 98.3294 49.1974 98.3294C49.303 98.3294 49.3634 98.3294 49.454 98.3898C49.9673 98.7068 50.4051 99.1597 50.858 99.5673C50.9184 99.6277 50.9636 99.7032 51.0089 99.7786C51.0089 99.8088 51.024 99.839 51.0391 99.8692C51.0542 99.9296 51.0693 99.99 51.0844 100.05C51.0844 100.081 51.0844 100.126 51.0844 100.156C51.0844 100.216 51.0844 100.277 51.0844 100.337C51.0844 100.367 51.0844 100.413 51.0844 100.443C51.0844 100.503 51.0542 100.564 51.0391 100.624C51.0391 100.654 51.024 100.684 51.0089 100.715C50.9787 100.79 50.9485 100.85 50.9184 100.896C50.858 101.001 50.7976 101.047 50.7523 101.092C50.6768 101.122 50.6466 101.137 50.6013 101.137C50.5107 101.122 50.4353 101.092 50.3598 101.001C49.8918 100.473 49.3785 99.9749 48.986 99.3861C48.9407 99.3257 48.9105 99.2201 48.8954 99.1144C48.8954 99.0993 48.8954 99.0842 48.8954 99.0691L48.8803 99.0842ZM49.0162 113.486C49.0162 113.486 48.9709 113.366 48.9558 113.275C48.9407 113.154 48.9407 113.064 48.9558 112.973C48.9558 112.837 48.986 112.747 49.0162 112.671C49.0766 112.58 49.137 112.535 49.2124 112.535C49.2577 112.535 49.303 112.535 49.3634 112.565C49.771 112.747 50.088 113.003 50.4202 113.305C50.4957 113.366 50.5409 113.441 50.5711 113.516C50.5711 113.547 50.5862 113.577 50.6013 113.592C50.6164 113.652 50.6466 113.713 50.6466 113.773C50.6466 113.803 50.6466 113.834 50.6466 113.864C50.6466 113.924 50.6466 113.984 50.6466 114.06C50.6466 114.09 50.6466 114.12 50.6466 114.151C50.6466 114.226 50.6164 114.317 50.5862 114.392C50.5409 114.498 50.5107 114.573 50.4504 114.619C50.3749 114.694 50.3296 114.724 50.2843 114.739C50.1333 114.769 50.1031 114.754 50.088 114.739C49.9522 114.694 49.8767 114.634 49.8012 114.558C49.6502 114.377 49.5144 114.211 49.3785 114.045C49.2426 113.864 49.1219 113.683 49.0162 113.486ZM49.5144 127.677C49.5295 127.556 49.5446 127.466 49.5748 127.39C49.6201 127.269 49.6502 127.209 49.6955 127.149C49.7559 127.073 49.8163 127.043 49.8767 127.043C49.9824 127.043 50.0428 127.073 50.1031 127.134C50.5258 127.571 50.8127 128.024 51.0844 128.568C51.1448 128.689 51.175 128.824 51.175 128.96C51.175 128.99 51.175 129.021 51.175 129.066C51.175 129.187 51.1448 129.292 51.1146 129.398C51.0542 129.564 50.9787 129.655 50.9033 129.73C50.7825 129.836 50.707 129.866 50.6315 129.866C50.5107 129.866 50.4655 129.851 50.4202 129.821C50.39 129.821 50.3598 129.806 50.3447 129.775C50.2692 129.715 50.1937 129.624 50.1182 129.489C49.9824 129.217 49.8616 128.96 49.771 128.688C49.6804 128.417 49.5899 128.145 49.5295 127.858C49.5295 127.813 49.5295 127.737 49.5295 127.662L49.5144 127.677ZM51.1146 141.053C51.1146 141.053 51.1146 141.173 51.0844 141.219C51.0844 141.249 51.0844 141.279 51.0542 141.324C51.0391 141.385 51.0089 141.43 50.9938 141.475C50.9184 141.611 50.8731 141.656 50.8127 141.702C50.7523 141.747 50.6919 141.762 50.6315 141.762C50.5409 141.762 50.4504 141.732 50.3447 141.656C49.7861 141.264 49.5899 140.705 49.5446 140.041C49.5446 139.966 49.5597 139.875 49.5899 139.8C49.6502 139.679 49.6804 139.618 49.7257 139.588C49.8163 139.498 49.8767 139.467 49.9371 139.467C50.0428 139.483 50.1182 139.528 50.1937 139.618C50.39 139.86 50.6013 140.056 50.8429 140.237C50.9033 140.283 50.9485 140.343 50.9938 140.419C50.9938 140.449 51.0089 140.479 51.024 140.494C51.0391 140.554 51.0693 140.6 51.0844 140.66C51.0844 140.69 51.0844 140.736 51.0844 140.766C51.0844 140.826 51.0844 140.886 51.0844 140.947C51.0844 140.977 51.0844 141.022 51.0844 141.053H51.1146ZM51.9147 135.029C51.8241 135.497 51.7185 135.905 51.492 136.312C51.4467 136.403 51.3863 136.448 51.326 136.448C51.2505 136.448 51.2052 136.433 51.1599 136.388C51.0844 136.312 51.0542 136.267 51.0391 136.222C50.9787 136.101 50.9636 136.041 50.9636 135.98C50.9636 135.754 50.9636 135.542 50.9636 135.331C50.9787 135.12 51.024 134.908 51.0693 134.682C51.0995 134.531 51.1599 134.44 51.2052 134.365C51.3109 134.259 51.3713 134.229 51.4467 134.229C51.5222 134.229 51.5675 134.259 51.6279 134.289C51.7185 134.365 51.7487 134.395 51.7789 134.44C51.8543 134.561 51.8694 134.606 51.8845 134.667C51.9147 134.833 51.9298 134.923 51.8996 135.029H51.9147ZM53.2734 119.54C53.2734 119.646 53.2281 119.751 53.1677 119.842C52.8205 120.295 52.579 120.733 52.5035 121.306C52.4884 121.442 52.428 121.533 52.3676 121.593C52.2619 121.638 52.2318 121.669 52.1865 121.669C52.0959 121.638 52.0506 121.608 51.9902 121.563C51.96 121.548 51.9449 121.533 51.9147 121.503C51.8543 121.412 51.809 121.306 51.809 121.17C51.809 120.959 51.8392 120.748 51.8694 120.551C51.96 119.963 52.1563 119.419 52.5186 118.891C52.579 118.815 52.6243 118.77 52.6846 118.725C52.7601 118.695 52.7903 118.679 52.8205 118.679C52.9111 118.679 52.9866 118.74 53.047 118.8C53.1375 118.921 53.1828 118.997 53.213 119.087C53.2583 119.238 53.2734 119.344 53.2734 119.449C53.2734 119.48 53.2734 119.495 53.2734 119.525V119.54ZM53.4546 105.742C53.0772 106.527 52.7601 107.342 52.4431 108.157C52.4129 108.248 52.3676 108.308 52.3223 108.353C52.2468 108.399 52.2167 108.414 52.2016 108.429C52.1261 108.429 52.0808 108.414 52.0506 108.384C51.9751 108.323 51.9449 108.278 51.9147 108.218C51.8694 108.127 51.8543 108.082 51.8392 108.021C51.8091 107.901 51.794 107.825 51.809 107.765C51.8845 106.949 52.0959 106.18 52.4129 105.44C52.5186 105.198 52.6394 104.957 52.7601 104.7C52.8054 104.625 52.8507 104.564 52.9111 104.534C53.0017 104.504 53.047 104.489 53.0772 104.489C53.1375 104.489 53.1677 104.504 53.213 104.534C53.3338 104.594 53.3942 104.64 53.4546 104.7C53.515 104.776 53.5602 104.851 53.5753 104.942C53.6508 105.213 53.5753 105.53 53.4697 105.757L53.4546 105.742ZM59.0403 57.0102C59.0403 57.0102 59.1611 56.9649 59.2064 56.9649C59.2969 56.9649 59.3724 57.0253 59.4177 57.1007C59.4781 57.2215 59.5083 57.3272 59.5083 57.448C59.5083 57.6291 59.5083 57.7499 59.4932 57.8556C59.463 58.0065 59.4328 58.1122 59.3875 58.1575L59.2214 58.4141C59.2516 58.4896 59.2516 58.5802 59.2516 58.6708C59.2516 58.8217 59.2214 58.8972 59.2064 58.9576C59.1611 59.0784 59.1309 59.1388 59.0856 59.1841C59.0101 59.2595 58.9648 59.2746 58.9195 59.2746C58.844 59.2746 58.8138 59.2746 58.7836 59.2444C58.678 59.169 58.6327 59.1086 58.5874 59.018C58.4968 58.8368 58.4364 58.6557 58.4062 58.4594C58.376 58.3085 58.376 58.1726 58.4062 58.0216C58.4515 57.5989 58.6629 57.1913 59.0856 56.98L59.0403 57.0102ZM57.5004 78.2661C57.7269 77.783 57.9382 77.3301 58.3006 76.9376C58.3609 76.8772 58.4213 76.847 58.4666 76.847C58.5874 76.9074 58.6327 76.9376 58.6629 76.9829C58.7384 77.1036 58.7535 77.1489 58.7685 77.2093C58.8138 77.3603 58.8138 77.4358 58.7987 77.4962C58.7233 77.7981 58.6327 78.0849 58.5119 78.3567C58.3911 78.6284 58.2553 78.885 58.1194 79.1719C58.0741 79.2474 58.0288 79.3077 57.9835 79.3379C57.7873 79.3681 57.7269 79.3379 57.6816 79.2775C57.6061 79.1568 57.5608 79.0813 57.5306 78.9907C57.4853 78.8548 57.4702 78.7492 57.4552 78.6435C57.4552 78.4623 57.4552 78.3567 57.5004 78.2812V78.2661ZM57.4702 87.5504C57.5004 87.3995 57.5306 87.3089 57.5759 87.2334C57.6212 87.173 57.6665 87.1277 57.742 87.1277C57.8326 87.1277 57.893 87.1579 57.9533 87.2183C58.1496 87.4146 58.3157 87.5957 58.4817 87.8071C58.6478 88.0033 58.7836 88.2147 58.9195 88.4562C58.9497 88.5015 58.9648 88.577 58.9799 88.6676C58.9799 88.8035 58.9799 88.894 58.9799 88.9846C58.9497 89.1205 58.9346 89.2111 58.8893 89.2866C58.844 89.3469 58.7987 89.3771 58.7384 89.3922C58.6478 89.3922 58.5874 89.3771 58.527 89.3167C58.3157 89.1356 58.1496 88.9544 57.9835 88.7582C57.8175 88.5619 57.6816 88.3657 57.5306 88.1392C57.5004 88.0939 57.4702 88.0033 57.4702 87.9128C57.4702 87.7769 57.4702 87.6712 57.4702 87.5806V87.5504ZM58.3458 96.1555C58.3911 96.0498 58.4515 95.9743 58.4968 95.929C58.5874 95.8686 58.6327 95.8535 58.6629 95.8535C58.7685 95.8535 58.8138 95.8837 58.8591 95.929C58.9648 96.0196 59.0101 96.08 59.0403 96.1555C59.0856 96.2762 59.1007 96.3517 59.1158 96.4272C59.1158 96.5933 59.1158 96.6989 59.0705 96.7895C58.8289 97.3481 58.5723 97.9067 58.2855 98.435C58.2402 98.5105 58.21 98.5558 58.1647 98.586C57.9835 98.6313 57.9382 98.586 57.8779 98.5407C57.8024 98.4501 57.7571 98.3898 57.7269 98.3143C57.6816 98.2086 57.6665 98.1331 57.6514 98.0425C57.6514 97.8916 57.6514 97.8161 57.6514 97.7557C57.8477 97.2122 58.0741 96.6839 58.3157 96.1555H58.3458ZM57.5155 106.557C57.5155 106.557 57.5306 106.406 57.5608 106.346C57.591 106.255 57.6212 106.21 57.6665 106.164C57.742 106.089 57.7873 106.059 57.8326 106.059C57.9231 106.059 57.9835 106.104 58.059 106.195C58.376 106.617 58.678 107.04 58.9648 107.478C59.0252 107.553 59.0403 107.659 59.0554 107.765C59.0554 107.946 59.0554 108.052 59.0101 108.142C58.9648 108.263 58.9195 108.338 58.8742 108.414C58.7836 108.52 58.7233 108.55 58.6629 108.565C58.4968 108.504 58.4515 108.459 58.4062 108.384C58.1194 107.87 57.8326 107.342 57.5608 106.814C57.5306 106.753 57.5155 106.693 57.5155 106.617C57.5155 106.602 57.5155 106.587 57.5155 106.572V106.557ZM58.995 113.245C58.9648 113.381 58.9346 113.471 58.8742 113.532L58.1949 114.181C58.1949 114.181 58.0892 114.256 58.0288 114.256C57.9382 114.256 57.8779 114.211 57.8477 114.151C57.8024 114.09 57.7722 114 57.7571 113.909C57.7269 113.773 57.7269 113.683 57.7571 113.592C57.7873 113.456 57.8175 113.381 57.8628 113.32C58.0892 113.094 58.3006 112.852 58.527 112.626C58.5874 112.565 58.6327 112.55 58.6931 112.535C58.7836 112.535 58.844 112.58 58.8893 112.641C58.9346 112.716 58.9799 112.807 58.995 112.898C59.0252 113.048 59.0252 113.139 59.0252 113.23L58.995 113.245ZM57.4099 66.8984C57.4099 66.8984 57.4401 66.7776 57.4702 66.7172C57.5306 66.5965 57.5759 66.5512 57.6212 66.5059C57.6967 66.4606 57.742 66.4304 57.7873 66.4304C57.8779 66.4304 57.908 66.4455 57.9382 66.4757C58.0439 66.5512 58.0892 66.6116 58.1345 66.7172C58.2402 66.9588 58.376 67.2003 58.5421 67.4117C58.6931 67.6381 58.8591 67.8344 59.0403 68.0457C59.1158 68.1363 59.1611 68.2571 59.1913 68.3929C59.2214 68.6043 59.1913 68.7402 59.1762 68.8609C59.1158 69.027 59.0705 69.1327 59.0101 69.2082C58.9044 69.344 58.8138 69.3893 58.7233 69.3893C58.6629 69.3893 58.6327 69.3893 58.6025 69.3893C58.4666 69.3289 58.3911 69.2836 58.3308 69.1931C58.0892 68.8911 57.893 68.5892 57.742 68.2571C57.591 67.925 57.4853 67.5777 57.4099 67.2154C57.3948 67.1399 57.4099 67.0494 57.4099 66.9739C57.4099 66.9437 57.4099 66.9286 57.4099 66.9135V66.8984ZM55.8247 47.7258C55.704 47.4239 55.6134 47.1219 55.5228 46.8049C55.5077 46.7294 55.5077 46.6388 55.5228 46.5332C55.553 46.3671 55.5832 46.2765 55.6134 46.1859C55.6587 46.0954 55.704 46.0199 55.7643 45.9595C55.87 45.8689 55.9304 45.8236 56.0059 45.8236C56.0361 45.8236 56.0814 45.8387 56.1116 45.8538C56.2172 45.9142 56.2776 45.9595 56.3229 46.035C56.6852 46.5634 56.9268 47.1219 57.1834 47.6956C57.2287 47.8164 57.2438 47.9522 57.2438 48.0881C57.2438 48.1183 57.2438 48.1636 57.2438 48.1938C57.2438 48.3146 57.2136 48.4202 57.1683 48.5108C57.1079 48.6769 57.0324 48.7675 56.957 48.858C56.8362 48.9637 56.7607 48.9939 56.7003 48.9939C56.5947 48.9939 56.5343 48.9788 56.489 48.9486C56.4588 48.9486 56.4437 48.9335 56.4135 48.9033C56.338 48.8429 56.2776 48.7373 56.2021 48.6014C56.0663 48.2995 55.9455 48.0126 55.8247 47.7107V47.7258ZM57.6665 135.588C57.6665 135.588 57.6514 135.723 57.6212 135.784C57.5759 135.89 57.5457 135.935 57.5004 135.98C57.425 136.041 57.3797 136.056 57.3495 136.056C57.2891 136.056 57.2589 136.056 57.2287 136.025C57.1381 135.965 57.1079 135.905 57.0777 135.829L56.7607 135.029C56.655 134.757 56.5494 134.501 56.4437 134.229C56.4135 134.169 56.4135 134.093 56.4135 134.018C56.4135 133.897 56.4437 133.836 56.4588 133.791C56.489 133.701 56.5343 133.655 56.5645 133.61C56.6248 133.55 56.6701 133.534 56.7003 133.534C56.7607 133.534 56.7909 133.534 56.806 133.565C56.8815 133.625 56.9268 133.67 56.957 133.746C57.1834 134.259 57.425 134.772 57.6514 135.301C57.6816 135.376 57.6967 135.452 57.6967 135.527C57.6967 135.542 57.6967 135.573 57.6967 135.588H57.6665ZM59.146 127.088C59.0705 127.39 58.9648 127.692 58.844 128.009C58.7987 128.115 58.7535 128.175 58.7082 128.221C58.6176 128.281 58.5874 128.296 58.5572 128.296C58.4515 128.296 58.4062 128.281 58.3609 128.251C58.2704 128.19 58.2251 128.13 58.1949 128.07C58.1345 127.964 58.1194 127.903 58.1043 127.843C58.0741 127.692 58.0741 127.617 58.0892 127.541C58.1496 127.239 58.21 126.922 58.3006 126.62C58.3458 126.469 58.3911 126.318 58.4666 126.182C58.527 126.047 58.6176 125.911 58.7082 125.79C58.7836 125.699 58.8591 125.669 58.9195 125.669C59.0252 125.699 59.0856 125.73 59.1309 125.79C59.2214 125.926 59.2516 126.032 59.2667 126.122C59.2667 126.454 59.2365 126.771 59.1611 127.088H59.146ZM59.5687 121.201C59.5234 121.352 59.4781 121.457 59.4177 121.533C59.3271 121.654 59.2365 121.699 59.1611 121.714C59.1158 121.714 59.0856 121.714 59.0554 121.714C58.9346 121.669 58.8591 121.608 58.7987 121.533C58.527 121.201 58.2855 120.823 58.0288 120.476C57.7722 120.129 57.5004 119.782 57.2589 119.419C57.2136 119.359 57.1985 119.268 57.1985 119.163C57.1985 119.012 57.1985 118.906 57.2136 118.8C57.2438 118.634 57.2891 118.529 57.3344 118.453C57.3797 118.378 57.4401 118.332 57.5004 118.332C57.6061 118.332 57.6665 118.362 57.7269 118.438C58.3458 119.087 58.9195 119.736 59.463 120.446C59.5234 120.536 59.5687 120.657 59.5838 120.778C59.5989 120.974 59.5838 121.11 59.5687 121.216V121.201Z\" />\n    <path d=\"M63.1768 78.145C63.0711 78.3262 63.0107 78.5073 62.9654 78.7036C62.6786 78.7791 62.3918 78.8395 62.0898 78.8999C62.1351 83.0967 62.1955 87.7313 62.2257 92.4565C63.1919 92.4565 64.2788 92.2301 65.4262 91.8074C65.4262 91.7923 65.396 91.7319 65.3658 91.6715C65.3658 91.6413 65.3356 91.6111 65.3356 91.5809C65.3054 91.4904 65.3054 91.3696 65.3054 91.2488C65.3356 90.9167 65.3507 90.7959 65.4866 90.494C65.5168 90.4185 65.562 90.3732 65.6073 90.3279C65.6828 90.2826 65.7281 90.2675 65.7583 90.2675C65.7885 90.2675 65.8187 90.2826 65.8489 90.2977C65.9395 90.343 65.9847 90.4034 66.0149 90.4789C66.1508 90.811 66.181 91.0526 66.2112 91.3998C66.2112 91.43 66.2112 91.4602 66.2112 91.4904C69.7287 90.026 72.899 87.7011 75.6012 84.6365C75.5559 84.6063 75.5107 84.5762 75.4654 84.5158C75.1785 84.1836 75.1031 83.7609 75.2087 83.3684C75.2389 83.2326 75.2993 83.1118 75.3597 82.9759C75.405 82.9004 75.4654 82.8552 75.5107 82.8401C75.6918 82.8401 75.7371 82.8702 75.7824 82.9155C75.8881 83.0363 75.9334 83.1118 75.9636 83.2024C76.0088 83.4288 76.0843 83.6553 76.1447 83.8666C76.1598 83.9421 76.1598 84.0176 76.1447 84.1082C76.1447 84.0478 76.1447 83.9874 76.1447 83.927C78.5602 81.0134 80.5831 77.511 82.0776 73.4953C82.0776 73.4651 82.1078 73.4198 82.1078 73.4047C82.1078 73.4047 82.0475 73.4349 81.9871 73.45C81.8814 73.45 81.821 73.4047 81.7757 73.3745C81.6549 73.2538 81.5946 73.1481 81.5493 72.9971C81.4436 72.6499 81.4134 72.3329 81.4134 71.9705C81.4134 71.88 81.4436 71.7894 81.4889 71.6988C81.5644 71.578 81.6248 71.5478 81.6851 71.5327C81.7757 71.5327 81.8361 71.5478 81.9116 71.6384C82.0173 71.7743 82.1078 71.8951 82.1833 72.0158C82.2588 72.1366 82.3192 72.2725 82.3796 72.4385C82.4249 72.5593 82.44 72.665 82.4249 72.7707C82.4249 72.7103 82.4249 72.6348 82.3947 72.5744C82.8476 71.2761 83.3609 69.6457 83.8288 67.8039C83.8288 67.8039 83.7534 67.7737 83.7081 67.7284C83.6326 67.6378 83.5873 67.5775 83.5571 67.502C83.5118 67.4114 83.4967 67.3208 83.4816 67.2453C83.4816 67.1095 83.4816 67.0189 83.5118 66.9585C83.6779 66.6113 83.8288 66.2792 84.0251 65.9621C84.0704 65.9017 84.1157 65.8565 84.1459 65.8263C84.3119 65.7961 84.3723 65.8263 84.4176 65.8715C84.3723 65.8263 84.3421 65.8112 84.2968 65.7961C84.5837 64.377 85.2328 60.6934 85.0064 57.1759C84.946 57.1458 84.8856 57.0854 84.8403 57.0099C84.6139 56.708 84.3874 56.406 84.1761 56.089C84.1157 55.9984 84.0855 55.8927 84.0704 55.772C84.0553 55.5757 84.0704 55.4549 84.0855 55.3493C84.1308 55.1983 84.161 55.1077 84.2214 55.0322C84.3119 54.9115 84.3874 54.8662 84.4629 54.8662C84.5082 54.8662 84.5384 54.8662 84.5686 54.8662C84.6592 54.8964 84.7044 54.9417 84.7497 54.9719C84.478 53.5528 83.9949 52.2545 83.2099 51.2883C82.2286 50.0806 80.885 49.5371 79.0432 49.6428C73.6689 49.9598 72.3706 57.9761 71.5101 63.2749C71.344 64.2864 71.193 65.2073 71.027 65.9923C69.94 71.2459 68.2039 76.5901 63.7505 78.4017C63.7203 78.2356 63.675 78.1601 63.6146 78.0997C63.675 78.1601 63.7203 78.2507 63.7203 78.3262C63.7354 78.4922 63.7807 78.6432 63.8259 78.7791C63.8712 78.9301 63.9316 79.0659 63.992 79.2169C64.0222 79.2924 64.0373 79.398 64.0373 79.5037C64.0373 79.6849 64.0071 79.7906 63.9769 79.8962C63.9316 80.017 63.8863 80.0925 63.841 80.168C63.7505 80.2736 63.6901 80.3189 63.6146 80.3189C63.5693 80.3189 63.5391 80.3189 63.5089 80.3038C63.3881 80.2585 63.3278 80.1982 63.2674 80.1227C63.1466 79.9717 63.056 79.8056 62.9956 79.6396C62.9352 79.4735 62.9051 79.3075 62.89 79.1263C62.89 78.9753 62.89 78.8093 62.9352 78.6583C62.9805 78.4621 63.0409 78.2809 63.1466 78.0997L63.1768 78.145ZM79.8283 77.9488C79.8283 77.9488 79.8283 78.0545 79.7981 78.1148C79.7981 78.145 79.7679 78.1752 79.7679 78.2054C79.7528 78.2507 79.7377 78.296 79.7075 78.3413C79.6924 78.3715 79.6622 78.3866 79.6471 78.4168C79.6169 78.447 79.5867 78.4772 79.5414 78.4923C79.5112 78.4923 79.481 78.5073 79.4509 78.5224C79.4207 78.5224 79.4056 78.5375 79.3754 78.5375C79.3452 78.5375 79.2999 78.5375 79.2546 78.5375C79.1791 78.613 79.1489 78.6583 79.1187 78.6734C79.0432 78.7036 79.0131 78.7187 78.9829 78.7187C78.9225 78.7187 78.8772 78.6885 78.8319 78.6583C78.7564 78.5828 78.7111 78.5224 78.6809 78.4621C78.6507 78.4017 78.6205 78.3262 78.6054 78.2507C78.5904 78.1299 78.5753 78.0545 78.5903 77.9941C78.6054 77.8733 78.6356 77.7676 78.6658 77.6619C78.7413 77.4657 78.8621 77.3298 79.0432 77.2392C79.1338 77.1939 79.2395 77.1638 79.3603 77.1487C79.4358 77.1487 79.481 77.1638 79.5112 77.1789C79.632 77.2392 79.6622 77.2845 79.7075 77.3298C79.7679 77.4204 79.7981 77.511 79.8132 77.5865C79.8283 77.7223 79.8434 77.7978 79.8434 77.8582C79.8434 77.8884 79.8434 77.9186 79.8434 77.9639L79.8283 77.9488ZM81.353 61.4634C81.353 61.5841 81.3681 61.7049 81.353 61.8257C81.3379 61.9766 81.3077 62.0823 81.2775 62.1578C81.0058 62.656 80.6586 63.0636 80.6888 63.6675C80.6888 63.8486 80.6435 63.9845 80.5831 64.0902C80.5529 64.1204 80.5227 64.1354 80.5076 64.1505C80.4472 64.1958 80.4019 64.2411 80.3265 64.2562C80.251 64.2713 80.2057 64.2562 80.1604 64.226C80.1302 64.226 80.1 64.226 80.0698 64.1958C79.9943 64.1354 79.9188 64.0298 79.8736 63.8637C79.8132 63.6071 79.7679 63.3353 79.7679 63.0636C79.7679 62.505 79.8736 61.9314 80.1755 61.4936C80.3265 61.2822 80.5378 61.101 80.7944 60.9652C80.8699 60.935 80.9303 60.9199 80.9756 60.9199C81.0813 60.9199 81.1568 60.9803 81.2171 61.0709C81.2926 61.1916 81.3228 61.2973 81.353 61.4181V61.4785V61.4634ZM80.1151 51.9073C80.251 51.5298 80.3868 51.1373 80.5378 50.7599C80.5831 50.6542 80.6284 50.5939 80.6737 50.5335C80.7643 50.4731 80.7944 50.458 80.8246 50.458C80.9303 50.458 80.9756 50.4882 81.0209 50.5335C81.1115 50.609 81.1568 50.6844 81.2021 50.7599C81.2473 50.8807 81.2624 50.9411 81.2775 51.0166C81.2775 51.1826 81.2775 51.2732 81.2473 51.3638C81.0964 51.7412 80.9303 52.1035 80.7793 52.4658C80.7341 52.5564 80.6888 52.6168 80.6435 52.6621C80.568 52.7074 80.5227 52.7225 80.4925 52.7376C80.4019 52.7376 80.3566 52.7074 80.3114 52.6772C80.2208 52.6017 80.1906 52.5413 80.1453 52.4658C80.1 52.3602 80.0849 52.2998 80.0849 52.2243C80.0849 52.0733 80.0849 51.9827 80.1 51.9073H80.1151ZM78.3035 54.0812C78.3035 54.0812 78.3337 53.9604 78.3639 53.9C78.4243 53.7792 78.4696 53.7188 78.53 53.6736C78.6054 53.6283 78.6658 53.5981 78.7111 53.5981C78.8017 53.5981 78.847 53.6132 78.8772 53.6434C78.9829 53.7188 79.0432 53.7943 79.0885 53.8849C79.1489 54.0359 79.2395 54.1566 79.315 54.2774C79.5716 54.6397 79.9188 54.9115 80.2359 55.2587C80.2963 55.3342 80.3415 55.4398 80.3868 55.5606C80.4321 55.7116 80.4472 55.8324 80.4472 55.9682C80.4472 56.1343 80.417 56.24 80.3566 56.3305C80.2812 56.4513 80.1906 56.4966 80.0849 56.5117C80.0245 56.5117 79.9792 56.5117 79.9339 56.5117C79.6924 56.4513 79.4961 56.3456 79.315 56.2098C78.9678 55.9229 78.7111 55.5153 78.53 55.0775C78.4394 54.8662 78.3639 54.6397 78.3035 54.4284C78.2733 54.3378 78.2733 54.2623 78.3035 54.1717C78.3035 54.1415 78.3035 54.1264 78.3035 54.0963V54.0812ZM76.5221 69.3136C76.5221 69.2381 76.5221 69.1626 76.5221 69.072C76.5221 69.0267 76.5523 68.9965 76.5674 68.9663C76.5976 68.906 76.6127 68.8456 76.658 68.8003C76.6882 68.7701 76.7335 68.7701 76.7637 68.755C76.809 68.7399 76.8392 68.6946 76.8844 68.6946C76.9146 68.6946 76.9448 68.6946 76.975 68.6946C77.1411 68.7248 77.2619 68.7852 77.3977 68.8607C77.5336 68.9361 77.6544 69.0116 77.7751 69.1022C77.8355 69.1475 77.8808 69.1928 77.911 69.2683C77.9563 69.389 77.9714 69.4343 77.9865 69.4796C77.9865 69.5098 77.9865 69.54 77.9865 69.5702C77.9865 69.6155 77.9865 69.6759 77.9865 69.7212C77.9865 69.7514 77.9865 69.7816 77.9865 69.8117C77.9865 69.857 77.9865 69.9174 77.9714 69.9627C77.9714 69.9929 77.9714 70.0231 77.9563 70.0533C77.9563 70.0986 77.9261 70.1439 77.8959 70.1892C77.8355 70.3099 77.7902 70.3401 77.76 70.3703C77.6695 70.4307 77.6242 70.4458 77.5638 70.4458C77.4883 70.4458 77.4128 70.4156 77.3222 70.3703C77.0203 70.1741 76.8241 69.9929 76.5976 69.7212C76.5372 69.6457 76.507 69.54 76.4919 69.4343C76.4919 69.4041 76.4919 69.3588 76.4919 69.3136H76.5221ZM74.5143 75.7296C74.5596 75.639 74.62 75.5937 74.6653 75.5484C74.7407 75.5182 74.7709 75.5031 74.8011 75.5031C74.8917 75.5031 74.9521 75.5635 75.0125 75.6239C75.1031 75.7447 75.1483 75.8353 75.1785 75.9258C75.2238 76.0768 75.2389 76.1825 75.254 76.3033C75.254 76.4995 75.2238 76.6052 75.1785 76.6958C75.0729 76.8769 74.937 77.0581 74.8162 77.2241C74.6954 77.4053 74.5898 77.5865 74.4539 77.7525C74.3935 77.828 74.3482 77.8733 74.3029 77.9035C74.1067 77.9337 74.0463 77.9035 74.001 77.8431C73.9255 77.7374 73.8953 77.6619 73.8802 77.5714C73.85 77.4506 73.8349 77.3449 73.8349 77.2392C73.8349 77.0732 73.85 76.9826 73.8802 76.9071C74.0765 76.4995 74.2576 76.0919 74.4992 75.6994L74.5143 75.7296ZM73.3368 56.2551C73.3368 56.1494 73.367 56.0588 73.3971 55.9682C73.4726 55.8324 73.5179 55.7569 73.5934 55.7267C73.6538 55.6965 73.6991 55.6814 73.7444 55.6814C73.9255 55.7569 73.9859 55.8173 74.0463 55.9531C74.1822 56.2551 74.2576 56.557 74.3331 56.8589C74.3633 56.9646 74.3784 57.0552 74.4086 57.1759C74.4237 57.2816 74.4237 57.3873 74.4086 57.4779C74.4086 57.5081 74.4086 57.5383 74.3935 57.5685C74.3784 57.6288 74.3482 57.6892 74.3331 57.7496C74.3331 57.7798 74.3029 57.7949 74.2878 57.8251C74.2576 57.8704 74.2124 57.9157 74.1671 57.9459C74.0614 58.0214 74.001 58.0515 73.9255 58.0515C73.8349 58.0515 73.7746 58.0063 73.7142 57.961C73.6085 57.8402 73.5481 57.7345 73.5179 57.5836C73.4122 57.1458 73.3519 56.723 73.3519 56.2702L73.3368 56.2551ZM72.4612 62.6258C72.4612 62.6258 72.4612 62.5654 72.4612 62.5352C72.4612 62.4748 72.4763 62.4295 72.4914 62.3842C72.5366 62.2484 72.5668 62.188 72.6121 62.1427L73.0499 61.6596C73.1254 61.5841 73.2009 61.5539 73.2613 61.5388C73.3066 61.5388 73.3368 61.5388 73.3669 61.5539C73.4726 61.5992 73.5179 61.6445 73.5632 61.7049C73.6085 61.7804 73.6538 61.8408 73.684 61.9163C73.684 61.9465 73.6991 61.9615 73.7142 61.9917C73.7293 62.0521 73.7444 62.0974 73.7595 62.1578C73.7595 62.188 73.7595 62.2182 73.7595 62.2484C73.7595 62.3088 73.7595 62.3541 73.7595 62.4144C73.7595 62.4446 73.7595 62.4748 73.7595 62.505C73.7595 62.5654 73.7444 62.6107 73.7293 62.6711C73.6689 62.822 73.6387 62.8824 73.5783 62.9428C73.4273 63.0787 73.2613 63.2146 73.1103 63.3504C73.0197 63.4259 72.9442 63.4561 72.8688 63.4561C72.8235 63.4561 72.7933 63.4561 72.7631 63.441C72.6725 63.3957 72.6272 63.3504 72.597 63.3051C72.5517 63.2297 72.5366 63.1693 72.5064 63.1089C72.4763 62.973 72.4612 62.9277 72.4612 62.8824C72.4612 62.8522 72.4612 62.822 72.4612 62.7919C72.4612 62.7315 72.4612 62.6862 72.4612 62.6409V62.6258ZM71.6761 68.1058C71.7214 67.9851 71.7667 67.9247 71.8271 67.8945C72.0385 67.8945 72.0837 67.9247 72.1441 67.9851C72.1592 68.0002 72.1894 68.0153 72.2045 68.0454C72.2649 68.136 72.3102 68.2417 72.3102 68.3474C72.3102 68.5738 72.3857 68.7701 72.5064 68.9512C72.5366 68.9965 72.5366 69.0871 72.5366 69.1626C72.5366 69.2985 72.5215 69.389 72.4914 69.4645C72.4461 69.6004 72.4159 69.6759 72.3706 69.7363C72.3102 69.8117 72.2649 69.8419 72.2045 69.8419C72.1139 69.8419 72.0536 69.8117 71.9932 69.7514C71.5403 69.2532 71.4648 68.7248 71.6761 68.0907V68.1058ZM71.4044 87.4747C71.6158 87.5502 71.6308 87.5955 71.6459 87.6257C71.6761 87.7464 71.6761 87.7917 71.661 87.837C71.6459 87.9729 71.6158 88.0333 71.5856 88.0635C71.4799 88.1842 71.3893 88.2295 71.2836 88.2597C71.0723 88.2899 70.9817 88.2597 70.8609 88.2144C70.8005 88.1993 70.7553 88.1389 70.7402 88.0785C70.71 87.9578 70.6949 87.9125 70.6949 87.8521C70.7251 87.7313 70.7251 87.686 70.7402 87.6408C70.8307 87.5804 70.8458 87.5502 70.8911 87.5502C71.0723 87.5502 71.2383 87.52 71.4044 87.4445V87.4747ZM70.2873 78.0846C70.2873 78.0846 70.3325 78.0394 70.3627 78.0243C70.4231 77.979 70.4684 77.9337 70.5288 77.9337C70.6043 77.9186 70.6345 77.9337 70.6798 77.9639C70.71 77.9639 70.7251 77.9639 70.7552 77.9941C70.8307 78.0545 70.8911 78.145 70.9364 78.296C71.027 78.6281 71.1025 78.915 71.1478 79.232C71.178 79.3829 71.1931 79.5339 71.1931 79.7C71.1931 79.8509 71.1931 80.017 71.1629 80.1831C71.1478 80.3038 71.1025 80.3944 71.0421 80.4548C70.9364 80.5303 70.8911 80.5605 70.8458 80.5605C70.7854 80.5605 70.7552 80.5605 70.7251 80.5454C70.6043 80.485 70.5439 80.4246 70.4986 80.334C70.1967 79.7453 70.2118 79.1263 70.1967 78.4772C70.1967 78.3111 70.2269 78.1903 70.3024 78.0846H70.2873ZM68.053 74.9597C68.053 74.8691 68.0832 74.7936 68.1285 74.7483C68.3398 74.4766 68.37 74.4162 68.6417 74.2199C68.7021 74.1746 68.7625 74.1595 68.8078 74.1595C68.8984 74.1595 68.9588 74.2048 69.0041 74.2501C69.0644 74.3105 69.0946 74.386 69.1097 74.4766C69.1399 74.5973 69.1399 74.6879 69.1399 74.7634C69.1248 74.8842 69.1097 74.9597 69.0644 75.02C69.0192 75.0955 68.989 75.1257 68.9437 75.171C68.8682 75.2616 68.7776 75.3673 68.687 75.4428C68.6417 75.488 68.6115 75.5182 68.5512 75.5635C68.4908 75.6088 68.4304 75.6239 68.3851 75.639C68.2794 75.639 68.2341 75.5937 68.1888 75.5484C68.1285 75.488 68.0983 75.4126 68.0832 75.322C68.053 75.1861 68.053 75.1106 68.053 75.02V74.9748V74.9597ZM64.7166 84.8026C64.8978 84.5309 65.079 84.3346 65.2903 84.2138C65.5168 84.0931 65.7734 84.0327 66.1055 84.0327C66.1508 84.0327 66.181 84.0478 66.2263 84.0629C66.2565 84.0629 66.3018 84.0629 66.3169 84.0931C66.3471 84.1082 66.3773 84.1535 66.4074 84.1836C66.4376 84.2138 66.4527 84.2289 66.4829 84.2591C66.498 84.2893 66.5131 84.3346 66.5282 84.3799C66.5282 84.4101 66.5584 84.4403 66.5735 84.4856C66.5735 84.5309 66.5735 84.5762 66.5886 84.6214C66.5886 84.6667 66.5886 84.6969 66.6037 84.7422C66.6037 84.7875 66.6037 84.8479 66.6037 84.8932C66.6037 84.9385 66.6037 84.9687 66.6037 85.014C66.6037 85.0743 66.5735 85.1196 66.5433 85.1649C66.5433 85.1951 66.5282 85.2253 66.5131 85.2404C66.4829 85.2857 66.4527 85.3159 66.4074 85.3612C66.3018 85.4518 66.2414 85.4819 66.1508 85.497C65.7734 85.5272 65.4715 85.648 65.1092 85.7537C65.0639 85.7537 65.0337 85.7688 65.0035 85.7688C64.9582 85.7688 64.928 85.7386 64.8978 85.7235C64.8676 85.7235 64.8223 85.7084 64.8072 85.6782C64.7619 85.6329 64.7468 85.5876 64.7166 85.5272C64.7166 85.497 64.6864 85.4668 64.6713 85.4216C64.6563 85.3461 64.6562 85.2706 64.6562 85.1951C64.6562 85.1649 64.6562 85.1196 64.6562 85.0894C64.6562 84.9838 64.7015 84.8781 64.7468 84.8177L64.7166 84.8026Z\" />\n  </g>\n  <g id=\"grot-cta-cactus-2\" fill=\"#9087e9\">\n    <path d=\"M185.199 118.399C185.239 118.849 185.289 119.299 185.349 119.759C185.479 119.789 185.539 119.819 185.609 119.829C185.659 119.849 185.689 119.879 185.699 119.929C185.699 120.009 185.699 120.039 185.699 120.069C185.669 120.139 185.659 120.159 185.639 120.179C185.559 120.219 185.539 120.209 185.529 120.189C185.479 120.129 185.419 120.069 185.359 120.029C185.379 120.039 185.389 120.059 185.399 120.069C185.679 122.009 186.169 123.919 187.209 125.639C187.059 125.669 187.039 125.979 187.189 126.029C187.289 126.069 187.389 126.099 187.489 126.129C187.979 126.779 188.499 127.409 189.139 127.979C189.579 128.369 190.669 129.269 191.989 129.949C191.959 129.969 191.929 129.989 191.889 130.019C191.829 130.069 191.809 130.169 191.819 130.249C191.799 130.159 191.819 130.059 191.889 130.019C191.939 129.989 191.969 129.959 191.999 129.939C192.029 129.919 192.069 129.899 192.119 129.879C192.139 129.879 192.159 129.869 192.179 129.869C192.229 129.869 192.269 129.909 192.299 129.949C192.339 130.019 192.349 130.069 192.359 130.129C192.739 130.319 193.129 130.459 193.529 130.569C193.559 129.869 193.589 129.219 193.579 128.669V127.419C193.559 126.839 193.559 126.249 193.549 125.669C193.139 125.549 192.759 125.379 192.419 125.159C192.409 125.119 192.389 125.079 192.369 125.059C192.389 125.089 192.419 125.129 192.429 125.179L192.449 125.249C192.449 125.249 192.449 125.329 192.449 125.369C192.429 125.429 192.419 125.459 192.409 125.479C192.369 125.529 192.349 125.539 192.319 125.549C192.269 125.549 192.239 125.539 192.199 125.489L192.159 125.439C192.159 125.439 192.109 125.359 192.099 125.309C192.099 125.239 192.099 125.209 192.109 125.169C192.129 125.109 192.159 125.069 192.179 125.049C192.219 125.019 192.239 125.009 192.269 125.009C192.249 125.009 192.229 125.009 192.219 125.029C191.039 124.149 190.309 122.599 190.059 120.419C190.009 120.399 189.979 120.379 189.949 120.349C189.899 120.269 189.879 120.219 189.879 120.169C189.879 120.029 189.889 119.929 189.939 119.799C189.959 119.749 189.979 119.719 189.999 119.689C189.989 119.429 189.959 119.199 189.949 118.929C189.919 117.759 190.009 116.169 190.099 114.629C190.179 113.299 190.249 112.039 190.249 111.059C190.249 109.549 189.719 107.149 188.319 107.149C188.049 107.149 187.739 107.239 187.409 107.399C187.369 107.369 187.349 107.359 187.329 107.339L187.399 107.379C187.459 107.419 187.489 107.459 187.509 107.509C187.529 107.599 187.539 107.639 187.529 107.689C187.519 107.759 187.489 107.799 187.459 107.829C187.409 107.879 187.379 107.889 187.349 107.899C187.309 107.899 187.289 107.899 187.269 107.879C187.209 107.829 187.189 107.789 187.169 107.729L187.139 107.619C187.139 107.619 187.139 107.569 187.139 107.539C186.979 107.619 186.819 107.719 186.649 107.849C186.169 108.199 185.859 108.679 185.659 109.139C185.629 109.099 185.589 109.079 185.559 109.079C185.599 109.079 185.639 109.099 185.669 109.159C185.719 109.219 185.759 109.289 185.799 109.359C185.849 109.439 185.869 109.509 185.869 109.579C185.869 109.599 185.869 109.619 185.869 109.639C185.869 109.689 185.869 109.729 185.849 109.769C185.849 109.789 185.839 109.809 185.829 109.819C185.809 109.859 185.789 109.879 185.759 109.909C185.689 109.969 185.649 109.979 185.609 109.989C185.549 109.989 185.509 109.959 185.479 109.919C185.419 109.829 185.389 109.759 185.379 109.649C185.379 109.719 185.399 109.779 185.419 109.829C185.369 110.009 185.329 110.179 185.309 110.319C185.149 111.249 185.059 112.269 185.019 113.359C185.029 113.319 185.049 113.289 185.099 113.279C185.129 113.279 185.159 113.279 185.179 113.279C185.219 113.279 185.239 113.289 185.299 113.319C185.349 113.339 185.379 113.379 185.399 113.429C185.429 113.499 185.429 113.549 185.419 113.599C185.399 113.669 185.389 113.709 185.359 113.749C185.329 113.789 185.299 113.809 185.259 113.819C185.199 113.819 185.169 113.799 185.139 113.759C185.099 113.709 185.079 113.679 185.069 113.649C185.049 113.619 185.039 113.579 185.019 113.529C185.019 113.509 185.019 113.489 185.019 113.479C184.969 114.969 185.019 116.609 185.179 118.439L185.199 118.399ZM192.869 128.049C192.869 128.049 192.899 127.979 192.919 127.949C192.949 127.919 192.979 127.899 192.999 127.899C193.089 127.939 193.109 127.969 193.129 128.009C193.169 128.099 193.209 128.179 193.239 128.269C193.249 128.299 193.249 128.339 193.239 128.379C193.229 128.449 193.219 128.469 193.209 128.499C193.179 128.559 193.159 128.569 193.139 128.579C193.089 128.589 193.059 128.579 193.029 128.529C192.979 128.459 192.929 128.379 192.889 128.309C192.869 128.269 192.859 128.229 192.859 128.189C192.859 128.119 192.859 128.079 192.879 128.049H192.869ZM190.119 122.739C190.259 122.699 190.339 122.709 190.419 122.709C190.479 122.709 190.509 122.739 190.529 122.779C190.559 122.829 190.559 122.869 190.559 122.919C190.549 122.989 190.529 123.029 190.509 123.059C190.479 123.099 190.449 123.129 190.419 123.129C190.399 123.129 190.379 123.129 190.359 123.099C190.289 123.019 190.219 122.949 190.139 122.889C190.109 122.759 190.109 122.759 190.109 122.749L190.119 122.739ZM189.959 128.139C189.959 128.209 189.959 128.249 189.939 128.279C189.919 128.329 189.899 128.359 189.869 128.389C189.829 128.419 189.809 128.429 189.789 128.439C189.699 128.399 189.679 128.369 189.669 128.329C189.639 128.229 189.609 128.129 189.579 128.019C189.579 127.989 189.579 127.959 189.579 127.919C189.589 127.859 189.599 127.829 189.609 127.799C189.639 127.739 189.659 127.729 189.679 127.719C189.729 127.709 189.759 127.719 189.789 127.769C189.839 127.849 189.889 127.929 189.939 128.009C189.969 128.049 189.979 128.099 189.979 128.139H189.959ZM189.929 114.669L189.859 114.759C189.859 114.759 189.809 114.809 189.779 114.809C189.709 114.769 189.679 114.739 189.669 114.689C189.669 114.649 189.649 114.599 189.649 114.559C189.629 114.459 189.649 114.399 189.669 114.349C189.709 114.279 189.739 114.259 189.779 114.259C189.829 114.259 189.849 114.269 189.879 114.289C189.929 114.329 189.949 114.349 189.959 114.369C189.989 114.429 189.999 114.459 189.999 114.489C189.999 114.579 189.979 114.619 189.939 114.669H189.929ZM189.479 110.539C189.509 110.459 189.539 110.429 189.579 110.429C189.609 110.429 189.639 110.449 189.669 110.479C189.799 110.629 189.889 110.789 189.969 110.959C189.989 110.999 189.999 111.049 189.999 111.099C189.999 111.179 189.989 111.209 189.969 111.249C189.949 111.309 189.919 111.339 189.889 111.369C189.849 111.399 189.819 111.419 189.799 111.419C189.759 111.419 189.739 111.419 189.729 111.399C189.679 111.359 189.659 111.329 189.639 111.279C189.559 111.079 189.499 110.899 189.459 110.689C189.459 110.639 189.459 110.589 189.479 110.539ZM189.369 116.849C189.369 116.849 189.379 116.789 189.399 116.759C189.429 116.699 189.449 116.689 189.479 116.679C189.539 116.669 189.569 116.679 189.609 116.729L189.659 116.789L189.819 116.999C189.819 116.999 189.859 117.089 189.869 117.129C189.869 117.209 189.869 117.249 189.859 117.289C189.839 117.339 189.819 117.379 189.789 117.409C189.739 117.449 189.719 117.469 189.689 117.469C189.579 117.419 189.559 117.389 189.539 117.359C189.489 117.269 189.449 117.179 189.419 117.089L189.379 117.009C189.379 117.009 189.359 116.929 189.369 116.889C189.369 116.879 189.369 116.869 189.369 116.849ZM189.049 124.559C189.049 124.559 189.049 124.509 189.069 124.489C189.109 124.459 189.129 124.439 189.149 124.439C189.219 124.449 189.279 124.459 189.349 124.459C189.379 124.459 189.409 124.459 189.439 124.459C189.499 124.459 189.539 124.489 189.569 124.539C189.599 124.629 189.609 124.669 189.609 124.709C189.609 124.729 189.599 124.749 189.599 124.769C189.599 124.809 189.589 124.839 189.569 124.869C189.559 124.889 189.539 124.889 189.519 124.899C189.499 124.909 189.479 124.939 189.459 124.939C189.259 124.899 189.269 124.889 189.119 124.799C189.099 124.789 189.079 124.749 189.069 124.719C189.069 124.649 189.059 124.629 189.059 124.599C189.059 124.589 189.059 124.569 189.069 124.559H189.049ZM188.529 108.119C188.549 108.049 188.579 108.029 188.619 108.029C188.649 108.029 188.679 108.039 188.699 108.069C188.729 108.119 188.749 108.149 188.759 108.179C188.769 108.259 188.759 108.309 188.739 108.349C188.709 108.399 188.679 108.449 188.649 108.499C188.629 108.529 188.609 108.559 188.589 108.589C188.569 108.619 188.549 108.639 188.529 108.639C188.499 108.639 188.479 108.599 188.459 108.559C188.439 108.489 188.429 108.449 188.439 108.419C188.469 108.319 188.509 108.219 188.529 108.119ZM188.259 121.949C188.279 121.879 188.319 121.849 188.349 121.839C188.399 121.829 188.429 121.839 188.459 121.879C188.499 121.929 188.519 121.969 188.529 122.009C188.549 122.099 188.559 122.149 188.539 122.199C188.509 122.299 188.469 122.399 188.439 122.509C188.419 122.559 188.389 122.579 188.349 122.589C188.249 122.539 188.229 122.509 188.219 122.479C188.199 122.389 188.189 122.299 188.199 122.219C188.199 122.139 188.219 122.059 188.249 121.969L188.259 121.949ZM187.789 113.769C187.789 113.769 187.789 113.719 187.789 113.699C187.869 113.599 187.889 113.609 187.909 113.629C187.959 113.679 187.989 113.699 188.009 113.729C188.029 113.759 188.049 113.789 188.089 113.849C188.099 113.869 188.109 113.899 188.109 113.939C188.109 113.999 188.109 114.019 188.099 114.049C188.009 114.149 187.989 114.139 187.969 114.119C187.949 114.089 187.939 114.079 187.919 114.059C187.869 114.009 187.849 113.969 187.789 113.869C187.789 113.849 187.779 113.819 187.769 113.789C187.769 113.779 187.769 113.769 187.769 113.759L187.789 113.769ZM187.819 118.149C187.839 118.099 187.859 118.069 187.879 118.039C187.919 118.009 187.939 117.999 187.949 117.999C187.999 117.999 188.019 118.019 188.049 118.029C188.099 118.069 188.119 118.099 188.139 118.139C188.159 118.199 188.169 118.229 188.179 118.269C188.179 118.349 188.179 118.399 188.169 118.439C188.119 118.559 188.079 118.679 188.029 118.789C187.999 118.849 187.969 118.869 187.929 118.879C187.889 118.879 187.879 118.879 187.859 118.859C187.809 118.819 187.799 118.789 187.789 118.749C187.759 118.639 187.759 118.539 187.759 118.439C187.759 118.339 187.789 118.239 187.829 118.139L187.819 118.149ZM187.279 110.359C187.279 110.359 187.349 110.309 187.369 110.309C187.429 110.309 187.459 110.319 187.479 110.339C187.519 110.379 187.549 110.409 187.569 110.449C187.589 110.519 187.599 110.549 187.599 110.589C187.599 110.679 187.579 110.739 187.549 110.789C187.499 110.869 187.469 110.909 187.399 110.979C187.369 111.009 187.339 111.019 187.319 111.019C187.269 110.989 187.249 110.979 187.239 110.959C187.209 110.899 187.199 110.879 187.189 110.849C187.169 110.779 187.169 110.749 187.169 110.729C187.169 110.649 187.179 110.579 187.209 110.509C187.229 110.439 187.249 110.399 187.279 110.359ZM187.049 116.129C187.049 116.129 187.049 116.089 187.059 116.079C187.139 115.999 187.159 116.009 187.169 116.029C187.289 116.149 187.379 116.229 187.459 116.379C187.479 116.409 187.479 116.449 187.479 116.489C187.479 116.559 187.469 116.579 187.459 116.609C187.429 116.669 187.419 116.679 187.399 116.689C187.339 116.709 187.309 116.689 187.279 116.649C187.249 116.609 187.219 116.569 187.199 116.519C187.159 116.459 187.119 116.389 187.089 116.329C187.069 116.289 187.049 116.259 187.039 116.219C187.039 116.209 187.039 116.179 187.039 116.149V116.129H187.049ZM186.339 122.499C186.349 122.419 186.369 122.329 186.399 122.249C186.419 122.199 186.449 122.179 186.489 122.179C186.529 122.179 186.559 122.199 186.569 122.249C186.619 122.409 186.639 122.559 186.649 122.729C186.649 122.809 186.629 122.869 186.599 122.899C186.529 122.939 186.509 122.959 186.479 122.959C186.449 122.959 186.429 122.939 186.409 122.929C186.339 122.869 186.319 122.819 186.319 122.739C186.319 122.659 186.319 122.589 186.339 122.509V122.499ZM185.319 115.879C185.339 115.829 185.369 115.789 185.389 115.769C185.429 115.749 185.449 115.739 185.469 115.739C185.509 115.739 185.539 115.759 185.569 115.789C185.619 115.849 185.639 115.889 185.659 115.939C185.679 115.999 185.679 116.049 185.669 116.099C185.649 116.199 185.639 116.249 185.599 116.299C185.579 116.319 185.569 116.329 185.549 116.349C185.509 116.399 185.469 116.429 185.389 116.439C185.359 116.439 185.329 116.419 185.319 116.399C185.259 116.309 185.239 116.229 185.239 116.149C185.239 116.069 185.269 115.989 185.309 115.889L185.319 115.879Z\" />\n    <path d=\"M204.809 110.7C204.809 110.64 204.839 110.62 204.869 110.62C204.839 110.62 204.819 110.64 204.809 110.7C204.809 110.75 204.809 110.78 204.799 110.82C204.779 110.85 204.759 110.87 204.739 110.9C204.739 111.76 204.739 112.61 204.719 113.46C204.719 114.1 204.709 114.72 204.699 115.34C204.699 115.4 204.699 115.47 204.699 115.53C204.759 115.48 204.829 115.44 204.889 115.39C204.909 115.36 204.939 115.34 204.989 115.33C205.339 115.06 205.689 114.78 205.999 114.52C205.999 114.5 205.989 114.49 205.999 114.46C205.999 114.42 206.009 114.38 206.019 114.34C206.019 114.3 206.029 114.26 206.039 114.22C206.059 114.15 206.099 114.12 206.139 114.12C206.179 114.12 206.219 114.15 206.229 114.22C206.229 114.25 206.239 114.28 206.249 114.32C206.279 114.3 206.319 114.27 206.339 114.24C207.249 113.45 207.979 112.44 208.509 111.33C208.459 111.22 208.449 111.19 208.449 111.16C208.449 111.07 208.459 111.02 208.489 110.99L208.639 110.82C208.639 110.82 208.679 110.78 208.699 110.78C208.999 110.18 209.189 109.52 209.329 108.84L209.249 108.76C209.249 108.76 209.209 108.69 209.199 108.65C209.199 108.58 209.199 108.55 209.199 108.52C209.219 108.46 209.229 108.44 209.249 108.42C209.309 108.39 209.339 108.4 209.359 108.42C209.509 107.8 209.599 107.13 209.649 106.46C209.599 106.36 209.599 106.34 209.599 106.32C209.599 106.25 209.599 106.22 209.619 106.2L209.689 106.04C209.739 105.29 209.749 104.53 209.739 103.78C209.729 103.76 209.719 103.75 209.709 103.72C209.709 103.69 209.699 103.65 209.699 103.61C209.699 103.54 209.709 103.51 209.719 103.49C209.739 103.31 209.739 103.18 209.739 103.05V102.66C209.739 101.79 209.739 100.97 209.189 100.47C208.859 100.17 208.359 100 207.819 100C207.439 100 207.059 100.09 206.749 100.25C206.179 100.55 205.879 101.05 205.709 101.55C205.729 101.58 205.749 101.6 205.779 101.64C205.809 101.67 205.809 101.72 205.809 101.76C205.799 101.83 205.789 101.86 205.779 101.88C205.749 101.94 205.729 101.95 205.709 101.96C205.659 101.98 205.629 101.96 205.609 101.92C205.559 102.18 205.529 102.43 205.529 102.63C205.529 103 205.529 103.36 205.529 103.73C205.519 103.75 205.499 103.76 205.489 103.79C205.509 103.74 205.529 103.71 205.559 103.69C205.669 103.66 205.699 103.68 205.719 103.7C205.759 103.75 205.789 103.79 205.799 103.83C205.809 103.88 205.819 103.93 205.809 103.97C205.799 104.06 205.779 104.11 205.739 104.15C205.679 104.22 205.649 104.24 205.579 104.29C205.539 105.02 205.539 105.71 205.509 106.4C205.529 106.41 205.539 106.45 205.549 106.49C205.549 106.56 205.549 106.59 205.549 106.63C205.539 106.67 205.519 106.7 205.499 106.72C205.499 107.02 205.489 107.32 205.449 107.63L205.399 108.11C205.319 108.92 205.219 109.93 204.899 110.61C204.939 110.65 204.959 110.68 204.959 110.71C204.979 110.8 204.979 110.9 204.969 111C204.969 111.05 204.959 111.08 204.939 111.1C204.789 111.08 204.779 111.05 204.779 111C204.779 110.97 204.779 110.95 204.779 110.92C204.779 110.84 204.779 110.78 204.799 110.68L204.809 110.7ZM208.439 106.07C208.439 106.07 208.399 106.15 208.369 106.18C208.319 106.23 208.289 106.24 208.259 106.25C208.169 106.21 208.159 106.18 208.149 106.16C208.069 105.97 208.049 105.9 208.049 105.74C208.049 105.71 208.059 105.67 208.079 105.64C208.109 105.59 208.139 105.57 208.159 105.56C208.189 105.56 208.219 105.57 208.239 105.61C208.259 105.63 208.279 105.66 208.299 105.68L208.359 105.75C208.359 105.75 208.419 105.84 208.439 105.89C208.449 105.98 208.449 106.02 208.439 106.07ZM208.549 102.55C208.549 102.55 208.609 102.57 208.629 102.59C208.669 102.63 208.689 102.66 208.699 102.7C208.719 102.75 208.729 102.8 208.729 102.84C208.729 102.91 208.719 102.95 208.699 102.99C208.619 103.12 208.589 103.15 208.459 103.22C208.379 103.22 208.349 103.19 208.339 103.15C208.319 103.09 208.309 103.04 208.319 103.01C208.349 102.85 208.369 102.77 208.449 102.62C208.479 102.57 208.509 102.55 208.549 102.54V102.55ZM207.979 100.36C207.979 100.36 207.979 100.31 207.989 100.28C208.009 100.22 208.019 100.21 208.029 100.19C208.189 100.21 208.229 100.24 208.269 100.26C208.309 100.29 208.339 100.32 208.399 100.37C208.439 100.41 208.459 100.45 208.469 100.5C208.479 100.58 208.479 100.63 208.469 100.68C208.449 100.75 208.429 100.78 208.409 100.81C208.369 100.86 208.339 100.87 208.309 100.88C208.249 100.88 208.219 100.86 208.179 100.81C208.129 100.75 208.099 100.7 208.069 100.64C208.039 100.59 208.009 100.54 207.969 100.46C207.969 100.44 207.959 100.41 207.959 100.38C207.959 100.37 207.959 100.36 207.959 100.35L207.979 100.36ZM207.459 109.07C207.479 109 207.519 108.94 207.569 108.88C207.609 108.83 207.649 108.81 207.689 108.81C207.749 108.81 207.779 108.83 207.809 108.86C207.839 108.91 207.859 108.95 207.879 108.99C207.899 109.06 207.899 109.11 207.889 109.16C207.869 109.24 207.849 109.28 207.809 109.31C207.729 109.37 207.699 109.39 207.609 109.42C207.479 109.38 207.469 109.35 207.459 109.33C207.439 109.26 207.439 109.24 207.439 109.21C207.439 109.13 207.449 109.09 207.459 109.07ZM206.929 101.24C206.959 101.16 206.999 101.09 207.049 101.01C207.079 100.96 207.119 100.94 207.149 100.93C207.189 100.93 207.219 100.94 207.239 100.97C207.279 101.01 207.289 101.05 207.309 101.08C207.329 101.14 207.339 101.18 207.339 101.22C207.339 101.29 207.319 101.33 207.299 101.37C207.219 101.49 207.129 101.6 207.059 101.72C207.029 101.77 206.999 101.79 206.969 101.79C206.929 101.77 206.909 101.76 206.899 101.73C206.869 101.67 206.859 101.65 206.849 101.62C206.839 101.55 206.829 101.51 206.849 101.48C206.879 101.39 206.899 101.31 206.929 101.23V101.24ZM206.719 103.95C206.739 103.89 206.749 103.87 206.769 103.86C206.839 103.83 206.859 103.84 206.879 103.86L207.029 103.96C207.029 103.96 207.099 104.03 207.109 104.08C207.109 104.16 207.109 104.2 207.109 104.23C207.079 104.3 207.069 104.32 207.049 104.34C206.969 104.38 206.949 104.37 206.929 104.34C206.879 104.28 206.819 104.22 206.759 104.17C206.729 104.15 206.719 104.11 206.709 104.07C206.709 104 206.709 103.98 206.709 103.95H206.719ZM206.559 106.74C206.609 106.65 206.649 106.57 206.689 106.5C206.739 106.43 206.789 106.36 206.859 106.3C206.889 106.27 206.919 106.26 206.939 106.26C206.999 106.3 207.009 106.32 207.019 106.35C207.039 106.42 207.039 106.45 207.049 106.48C207.049 106.56 207.049 106.6 207.029 106.63C206.939 106.81 206.849 106.89 206.699 107.03C206.669 107.05 206.649 107.07 206.629 107.07C206.579 107.03 206.569 107.02 206.559 106.99C206.539 106.93 206.539 106.9 206.529 106.88C206.529 106.81 206.529 106.77 206.539 106.75L206.559 106.74ZM206.539 110.62C206.539 110.62 206.559 110.53 206.579 110.49C206.619 110.44 206.639 110.43 206.659 110.42C206.719 110.42 206.759 110.44 206.789 110.5C206.849 110.61 206.889 110.72 206.919 110.84C206.939 110.9 206.939 110.96 206.939 111.01C206.929 111.09 206.919 111.12 206.909 111.14C206.879 111.2 206.859 111.22 206.839 111.23C206.789 111.27 206.769 111.27 206.749 111.28C206.689 111.28 206.649 111.26 206.619 111.23C206.569 111.16 206.549 111.1 206.539 111.01C206.539 110.94 206.539 110.88 206.539 110.82C206.539 110.75 206.539 110.69 206.539 110.62ZM205.699 109.39C205.729 109.32 205.749 109.27 205.779 109.21C205.789 109.19 205.809 109.16 205.819 109.13C205.849 109.08 205.879 109.06 205.909 109.06C205.969 109.09 205.989 109.11 206.009 109.14C206.039 109.21 206.049 109.25 206.049 109.28C206.049 109.38 206.039 109.43 205.999 109.47C205.919 109.54 205.899 109.56 205.809 109.61C205.689 109.51 205.679 109.49 205.679 109.47C205.679 109.41 205.679 109.39 205.679 109.38L205.699 109.39ZM205.049 112.86C205.139 112.79 205.179 112.76 205.279 112.71C205.299 112.71 205.319 112.7 205.329 112.7C205.379 112.7 205.409 112.73 205.439 112.77C205.479 112.83 205.489 112.88 205.499 112.94C205.499 113.02 205.499 113.08 205.469 113.12C205.439 113.18 205.399 113.21 205.339 113.22C205.299 113.22 205.259 113.23 205.219 113.23C205.189 113.23 205.159 113.23 205.119 113.23C205.079 113.23 205.049 113.21 205.029 113.18C205.009 113.15 204.989 113.11 204.989 113.07C204.979 112.99 204.989 112.9 205.049 112.86Z\" />\n    <path d=\"M194.11 109.23C194.11 109.23 194.08 109.28 194.09 109.3C194.09 109.27 194.09 109.25 194.11 109.23C194.2 109.2 194.22 109.21 194.24 109.25C194.3 109.42 194.39 109.59 194.51 109.73C194.53 109.75 194.54 109.78 194.54 109.81C194.54 109.86 194.54 109.88 194.54 109.9C194.45 109.99 194.44 109.98 194.42 109.97C194.32 109.88 194.24 109.78 194.19 109.67C194.14 109.56 194.11 109.44 194.1 109.3C194.1 109.36 194.13 109.41 194.14 109.47C194.18 110.02 194.23 110.57 194.27 111.11C194.36 112.15 194.45 113.13 194.47 114.07C194.52 116 194.56 117.95 194.59 119.9C194.73 119.93 194.83 120.01 194.89 120.12C194.94 120.2 194.98 120.3 194.99 120.4C194.99 120.49 194.99 120.57 194.97 120.65C194.96 120.72 194.92 120.74 194.88 120.74C194.78 120.68 194.77 120.64 194.77 120.6C194.77 120.57 194.77 120.54 194.75 120.5C194.72 120.42 194.66 120.35 194.59 120.29C194.62 122.67 194.65 125.04 194.67 127.37V128.62C194.69 129.22 194.66 129.94 194.62 130.71C194.5 133.61 194.32 137.59 196.07 139.41C196.74 140.11 197.65 140.45 198.84 140.45C201.7 140.45 203.15 137.9 203.15 132.86V132.8C203.07 132.96 203 133.11 202.91 133.26C202.89 133.29 202.86 133.31 202.84 133.31C202.81 133.31 202.77 133.29 202.75 133.26C202.72 133.22 202.72 133.18 202.72 133.14C202.72 133.1 202.74 133.05 202.76 133.02C202.82 132.91 202.9 132.8 202.97 132.69C203 132.65 203.02 132.6 203.05 132.56C203.07 132.53 203.09 132.52 203.11 132.52C203.14 132.52 203.17 132.56 203.18 132.6C203.17 131.59 203.18 130.61 203.21 129.63C203.09 129.62 203.08 129.59 203.07 129.55C203.05 129.4 202.98 129.25 202.93 129.11C202.91 129.05 202.91 128.96 202.95 128.91C202.97 128.89 203 128.87 203.02 128.87C203.05 128.87 203.07 128.87 203.08 128.89C203.16 128.98 203.21 129.08 203.24 129.18C203.24 127.89 203.29 126.65 203.33 125.42C203.31 125.53 203.29 125.65 203.25 125.75C203.23 125.8 203.2 125.82 203.17 125.82C203.12 125.82 203.11 125.8 203.09 125.78C203.05 125.73 203.04 125.69 203.04 125.65C203.04 125.53 203.07 125.42 203.1 125.32C203.13 125.21 203.17 125.11 203.2 125C203.22 124.94 203.24 124.92 203.27 124.92C203.35 124.63 203.36 124.29 203.38 123.96C203.4 123.5 203.41 123.02 203.43 122.56C203.41 122.61 203.38 122.65 203.36 122.7C203.34 122.74 203.32 122.79 203.29 122.83C203.27 122.86 203.24 122.87 203.22 122.87C203.19 122.87 203.16 122.83 203.15 122.79C203.13 122.72 203.13 122.67 203.14 122.64C203.18 122.54 203.24 122.46 203.3 122.38C203.32 122.35 203.34 122.31 203.36 122.28C203.38 122.25 203.4 122.24 203.42 122.24C203.45 122.24 203.47 122.27 203.48 122.31C203.47 122.28 203.45 122.26 203.44 122.25C203.53 119.95 203.6 117.62 203.61 115.3C203.58 115.33 203.53 115.35 203.5 115.38C203.46 115.41 203.43 115.44 203.39 115.46C203.27 115.34 203.27 115.32 203.28 115.29C203.28 115.23 203.29 115.2 203.3 115.19C203.35 115.1 203.42 115.02 203.49 114.95C203.56 114.88 203.65 114.82 203.73 114.75C203.69 114.78 203.66 114.81 203.62 114.84C203.62 114.37 203.62 113.89 203.63 113.41C203.65 111.7 203.66 109.96 203.58 108.27C203.55 108.34 203.53 108.35 203.5 108.36C203.48 108.36 203.46 108.36 203.44 108.34C203.39 108.29 203.41 108.21 203.44 108.16C203.48 108.09 203.52 108.02 203.56 107.95C203.5 106.79 203.38 105.67 203.19 104.58C203.18 104.64 203.17 104.7 203.16 104.76C203.13 104.88 203.09 104.99 203.04 105.1C203.02 105.14 203 105.15 202.98 105.15C202.89 105.08 202.88 105.06 202.88 105.03C202.88 104.78 202.91 104.53 202.98 104.29C202.99 104.26 203.01 104.22 203.03 104.2C203.07 104.17 203.08 104.16 203.1 104.16C203.1 104.08 203.1 103.99 203.08 103.91C202.78 102.47 201.82 100.06 198.84 100.06C196.99 100.06 195.35 101.23 194.65 103.03C194.52 103.37 194.42 103.73 194.33 104.09C194.4 104.25 194.46 104.4 194.51 104.57C194.51 104.6 194.51 104.64 194.51 104.67C194.49 104.72 194.47 104.73 194.45 104.74C194.42 104.74 194.4 104.74 194.38 104.69C194.34 104.6 194.31 104.5 194.27 104.41C193.98 105.89 194 107.54 194.11 109.22V109.23ZM202.88 118.65C202.88 118.65 202.93 118.61 202.96 118.61C202.99 118.61 203.01 118.62 203.03 118.65C203.11 118.8 203.17 118.96 203.23 119.12C203.24 119.15 203.23 119.19 203.23 119.22C203.21 119.27 203.19 119.3 203.16 119.3C203.14 119.3 203.12 119.3 203.1 119.26C203.02 119.13 202.94 119.01 202.88 118.87C202.86 118.84 202.85 118.79 202.85 118.76C202.85 118.72 202.85 118.68 202.88 118.65ZM202.69 111.58C202.69 111.58 202.72 111.54 202.74 111.54C202.79 111.58 202.81 111.6 202.81 111.63C202.81 111.66 202.81 111.69 202.8 111.71C202.82 111.93 202.77 112.1 202.72 112.26C202.63 112.24 202.62 112.22 202.63 112.2C202.64 112.15 202.66 112.1 202.67 112.06C202.64 112.05 202.62 112 202.62 111.95C202.63 111.83 202.65 111.7 202.7 111.59L202.69 111.58ZM200.42 125.38C200.42 125.38 200.42 125.45 200.4 125.48C200.29 125.52 200.26 125.5 200.25 125.44L200.17 125.1C200.17 125.1 200.17 125.02 200.19 124.99C200.22 124.95 200.24 124.94 200.26 124.94C200.33 124.96 200.35 124.99 200.36 125.03C200.37 125.09 200.38 125.16 200.39 125.22C200.39 125.27 200.41 125.33 200.42 125.38ZM200.86 112.2C200.82 112.29 200.75 112.37 200.69 112.45C200.67 112.47 200.66 112.5 200.64 112.53C200.55 112.62 200.45 112.71 200.34 112.78C200.27 112.78 200.25 112.76 200.24 112.73C200.23 112.68 200.23 112.64 200.24 112.62C200.3 112.5 200.37 112.37 200.45 112.25C200.53 112.13 200.63 112.03 200.75 111.96C200.87 112.07 200.87 112.08 200.87 112.11C200.87 112.17 200.87 112.19 200.87 112.2H200.86ZM200.49 116.32C200.49 116.32 200.46 116.37 200.44 116.37C200.41 116.37 200.4 116.35 200.38 116.33C200.36 116.29 200.35 116.26 200.35 116.23C200.37 116.13 200.38 116.03 200.39 115.92C200.41 115.8 200.43 115.69 200.44 115.57C200.44 115.53 200.47 115.51 200.49 115.51C200.51 115.51 200.53 115.51 200.54 115.56C200.59 115.81 200.57 116.08 200.49 116.32ZM200.56 119.58C200.53 119.48 200.53 119.46 200.54 119.44C200.54 119.39 200.55 119.36 200.56 119.35C200.62 119.27 200.67 119.19 200.72 119.11C200.77 119.03 200.8 118.94 200.82 118.84C200.82 118.8 200.85 118.76 200.87 118.72C200.92 118.69 200.94 118.67 200.97 118.67C201.09 118.69 201.13 118.82 201.12 118.91C201.1 119.21 200.96 119.57 200.62 119.61C200.57 119.59 200.56 119.59 200.55 119.58H200.56ZM200.93 133.57C200.9 133.63 200.87 133.65 200.85 133.66C200.8 133.66 200.77 133.65 200.75 133.59C200.7 133.46 200.64 133.34 200.62 133.2C200.62 133.17 200.62 133.13 200.64 133.1C200.67 133.05 200.69 133.02 200.72 133.02C200.74 133.02 200.76 133.03 200.79 133.06C200.87 133.17 200.91 133.3 200.96 133.42C200.98 133.47 200.96 133.52 200.96 133.56L200.93 133.57ZM201.17 130.76C201.12 130.86 201.04 130.95 200.95 131.03C200.83 130.94 200.83 130.92 200.83 130.9C200.83 130.84 200.85 130.81 200.87 130.79C200.99 130.69 201.07 130.55 201.1 130.39C201.11 130.33 201.14 130.31 201.18 130.31C201.27 130.36 201.28 130.39 201.28 130.43C201.27 130.55 201.24 130.66 201.19 130.76H201.17ZM201.4 127.02C201.4 127.02 201.43 127.08 201.42 127.13C201.38 127.46 201.27 127.77 201.02 128C200.94 128 200.93 127.98 200.92 127.95C200.91 127.89 200.91 127.85 200.92 127.83C200.98 127.71 201.02 127.58 201.07 127.46C201.12 127.34 201.18 127.22 201.22 127.09C201.23 127.05 201.25 127.02 201.27 127C201.36 126.98 201.37 127 201.39 127C201.39 127 201.41 127 201.41 127.02H201.4ZM201.26 122.65C201.26 122.65 201.32 122.67 201.33 122.7C201.37 122.76 201.36 122.84 201.34 122.91C201.29 123.04 201.24 123.16 201.16 123.28C201.1 123.37 201.02 123.5 200.93 123.56C200.84 123.56 200.82 123.55 200.81 123.51C200.79 123.46 200.79 123.42 200.79 123.39C200.84 123.13 201 122.86 201.19 122.67C201.21 122.65 201.22 122.65 201.24 122.65C201.24 122.65 201.24 122.65 201.25 122.65H201.26ZM200.97 101.51C200.99 101.45 201 101.39 201.03 101.34C201.05 101.31 201.07 101.29 201.1 101.28C201.18 101.3 201.18 101.32 201.18 101.34C201.19 101.37 201.2 101.41 201.19 101.45C201.16 101.55 201.17 101.61 201.17 101.66C201.17 101.72 201.14 101.79 201.15 101.86C201.16 101.93 201.15 102.05 201.06 102.08C201.01 102.08 201 102.07 200.98 102.06C200.93 102.02 200.92 101.98 200.92 101.95C200.9 101.8 200.92 101.66 200.96 101.52L200.97 101.51ZM200.74 105.28C200.76 105.22 200.79 105.19 200.83 105.19C200.93 105.25 200.94 105.29 200.94 105.33C200.93 105.53 200.92 105.73 200.88 105.93C200.88 105.97 200.85 106.01 200.83 106.04C200.78 106.07 200.77 106.09 200.75 106.09C200.62 106.05 200.61 105.9 200.62 105.82C200.65 105.64 200.69 105.47 200.74 105.29V105.28ZM200.15 108.85C200.15 108.85 200.19 108.83 200.21 108.83C200.29 108.87 200.31 108.9 200.32 108.93C200.35 109 200.38 109.07 200.4 109.15C200.42 109.22 200.44 109.3 200.44 109.38C200.44 109.41 200.44 109.44 200.42 109.46C200.39 109.5 200.37 109.52 200.35 109.52C200.33 109.52 200.31 109.52 200.3 109.5C200.25 109.45 200.21 109.39 200.18 109.32C200.15 109.25 200.12 109.18 200.1 109.12C200.08 109.08 200.08 109.03 200.09 108.98C200.09 108.93 200.12 108.88 200.16 108.86L200.15 108.85ZM200.02 120.87C200.02 120.87 200.06 120.94 200.06 120.97C200.07 121.03 200.09 121.09 200.1 121.15C200.14 121.33 200.18 121.52 200.18 121.7C200.18 121.73 200.17 121.76 200.15 121.78C200.12 121.82 200.1 121.83 200.08 121.84C200.05 121.84 200.03 121.84 200.01 121.8C199.9 121.58 199.86 121.31 199.81 121.06C199.8 121 199.81 120.93 199.86 120.87C199.87 120.85 199.88 120.82 199.91 120.81C199.97 120.81 199.98 120.82 200 120.84C200 120.84 200.02 120.84 200.03 120.86L200.02 120.87ZM199.74 113.99C199.74 113.99 199.77 113.94 199.79 113.94C199.82 113.94 199.83 113.94 199.85 113.98L199.98 114.33C199.98 114.33 199.98 114.38 199.98 114.41C199.91 114.46 199.89 114.45 199.88 114.42L199.74 114.08C199.74 114.08 199.74 114.02 199.74 114V113.99ZM199.71 128.43C199.71 128.43 199.71 128.37 199.73 128.34C199.76 128.27 199.78 128.26 199.8 128.24C199.89 128.21 199.91 128.22 199.94 128.24C200.06 128.33 200.16 128.43 200.24 128.56C200.33 128.71 200.37 128.84 200.38 129.01C200.38 129.04 200.38 129.08 200.36 129.11C200.34 129.17 200.32 129.19 200.29 129.19C200.27 129.19 200.25 129.19 200.23 129.17C200.16 129.13 200.14 129.11 200.13 129.1C200.07 129.02 200.03 128.98 200 128.94C199.94 128.86 199.87 128.77 199.81 128.69L199.75 128.61C199.75 128.61 199.72 128.54 199.71 128.49C199.71 128.48 199.71 128.46 199.71 128.45V128.43ZM196.68 117.28C196.68 117.28 196.72 117.24 196.75 117.24C196.78 117.24 196.8 117.24 196.81 117.26C196.91 117.37 196.97 117.49 197.04 117.62C197.08 117.69 197.09 117.79 197.04 117.87C197.02 117.9 196.99 117.92 196.96 117.92C196.93 117.92 196.9 117.9 196.88 117.87C196.79 117.75 196.72 117.63 196.66 117.49C196.65 117.46 196.66 117.43 196.67 117.39C196.67 117.35 196.67 117.32 196.68 117.29V117.28ZM196.78 121.89C196.78 121.89 196.82 121.87 196.84 121.87C196.92 121.91 196.94 121.94 196.95 121.97C196.99 122.06 197.01 122.15 197.04 122.24C197.04 122.27 197.06 122.3 197.07 122.33C197.07 122.36 197.08 122.4 197.08 122.44C197.08 122.48 197.06 122.51 197.04 122.54C197.02 122.56 197 122.57 196.97 122.57C196.94 122.57 196.92 122.55 196.9 122.52C196.83 122.4 196.78 122.29 196.73 122.16C196.72 122.12 196.71 122.07 196.72 122.02C196.72 121.97 196.75 121.93 196.78 121.9V121.89ZM197.29 129.42C197.29 129.42 197.29 129.49 197.27 129.53C197.24 129.59 197.21 129.61 197.18 129.61C197.16 129.61 197.13 129.6 197.11 129.56C197.04 129.44 197 129.32 196.94 129.2C196.92 129.16 196.92 129.11 196.93 129.07C196.94 129.03 196.96 128.98 196.99 128.95C197.01 128.93 197.03 128.93 197.05 128.93C197.12 128.97 197.14 128.99 197.16 129.02C197.21 129.15 197.25 129.28 197.29 129.42ZM196.78 131.95C196.93 131.79 196.98 131.83 197.03 131.88C197.08 131.93 197.12 131.99 197.17 132.05C197.18 132.07 197.19 132.1 197.19 132.12C197.19 132.17 197.19 132.19 197.18 132.21C197.09 132.29 197.07 132.29 197.05 132.27C196.94 132.17 196.85 132.08 196.78 131.94V131.95ZM197.62 135.75C197.62 135.75 197.6 135.8 197.59 135.82C197.56 135.87 197.54 135.88 197.52 135.88C197.48 135.88 197.46 135.88 197.43 135.83C197.3 135.59 197.16 135.36 197.09 135.1C197.07 135.04 197.07 134.97 197.11 134.91C197.13 134.89 197.15 134.88 197.18 134.87C197.32 134.99 197.39 135.11 197.45 135.24C197.51 135.36 197.56 135.49 197.62 135.62C197.63 135.65 197.63 135.68 197.62 135.72C197.62 135.73 197.62 135.74 197.62 135.75ZM197.74 127.97C197.74 127.97 197.69 127.94 197.67 127.9C197.65 127.83 197.64 127.79 197.66 127.76C197.7 127.68 197.75 127.61 197.79 127.53C197.86 127.39 197.93 127.25 198.02 127.12C198.04 127.09 198.06 127.08 198.08 127.08C198.11 127.08 198.13 127.11 198.15 127.15C198.17 127.21 198.17 127.26 198.16 127.29C198.08 127.46 197.99 127.61 197.9 127.77C197.87 127.83 197.84 127.88 197.81 127.94C197.79 127.97 197.77 127.98 197.75 127.98L197.74 127.97ZM198.3 132.39C198.3 132.39 198.35 132.42 198.36 132.44C198.38 132.49 198.39 132.51 198.39 132.53C198.39 132.59 198.39 132.63 198.39 132.65C198.3 132.88 198.12 133.02 197.9 133.1C197.79 132.98 197.79 132.96 197.79 132.94C197.79 132.88 197.81 132.86 197.83 132.84C197.91 132.78 197.97 132.72 198.03 132.65C198.09 132.58 198.15 132.51 198.21 132.43C198.24 132.4 198.27 132.38 198.29 132.38L198.3 132.39ZM198.22 120.55C198.22 120.62 198.18 120.67 198.15 120.73C198.09 120.88 198 121.01 197.84 121.07C197.73 121.03 197.72 121.01 197.72 120.99C197.71 120.93 197.72 120.9 197.72 120.88C197.73 120.81 197.75 120.78 197.76 120.76C197.82 120.69 197.88 120.61 197.91 120.52C197.92 120.49 197.94 120.46 197.94 120.43C197.94 120.39 197.97 120.35 198 120.32C198.05 120.29 198.06 120.27 198.09 120.27C198.16 120.29 198.17 120.32 198.19 120.35C198.21 120.39 198.22 120.43 198.23 120.47C198.23 120.5 198.23 120.53 198.23 120.55H198.22ZM198.07 114.91C198.07 114.91 198.14 114.94 198.15 114.96C198.17 114.98 198.17 115.01 198.17 115.04C198.17 115.1 198.17 115.13 198.16 115.16C198.14 115.21 198.12 115.26 198.09 115.31C198.06 115.38 198.02 115.46 197.98 115.53C197.95 115.58 197.92 115.64 197.88 115.69C197.86 115.72 197.83 115.74 197.8 115.74C197.77 115.74 197.74 115.73 197.72 115.7C197.7 115.67 197.68 115.63 197.68 115.59C197.68 115.55 197.68 115.5 197.7 115.47C197.79 115.28 197.87 115.1 198.02 114.94C198.03 114.93 198.05 114.92 198.07 114.92V114.91ZM197.72 106.97C197.72 106.97 197.78 106.91 197.81 106.91C197.85 106.91 197.89 106.93 197.92 106.97C197.95 107.01 197.96 107.07 197.96 107.12C197.96 107.17 197.94 107.23 197.91 107.27C197.84 107.39 197.75 107.49 197.66 107.6C197.58 107.6 197.55 107.6 197.53 107.57C197.49 107.52 197.5 107.44 197.52 107.38C197.58 107.23 197.63 107.1 197.72 106.96V106.97ZM197.33 124.92C197.33 124.92 197.39 125.01 197.43 125.05C197.53 125.18 197.58 125.33 197.57 125.5C197.57 125.53 197.57 125.56 197.55 125.58C197.54 125.61 197.52 125.63 197.49 125.63C197.4 125.58 197.39 125.55 197.39 125.53C197.38 125.43 197.32 125.34 197.23 125.28C197.19 125.26 197.17 125.21 197.16 125.17C197.16 125.09 197.16 125.06 197.16 125.03C197.19 124.96 197.2 124.94 197.21 124.92C197.29 124.88 197.31 124.89 197.34 124.92H197.33ZM196.93 101.97C196.93 101.97 196.97 101.95 196.99 101.95C197.03 101.95 197.05 101.97 197.07 102C197.12 102.09 197.16 102.18 197.18 102.27C197.21 102.36 197.23 102.46 197.24 102.56C197.25 102.62 197.24 102.71 197.19 102.75C197.17 102.76 197.15 102.77 197.14 102.77C197.1 102.77 197.08 102.75 197.06 102.72C197.04 102.67 197.02 102.62 196.99 102.57C196.93 102.44 196.89 102.31 196.87 102.17C196.87 102.11 196.87 102.02 196.93 101.98V101.97ZM196.72 110.05C196.72 110.05 196.77 110.01 196.79 110.01C196.83 110.01 196.86 110.03 196.88 110.07C196.99 110.22 197.06 110.39 197.1 110.57C197.1 110.6 197.1 110.65 197.08 110.69C197.05 110.75 197.03 110.78 196.99 110.79C196.97 110.79 196.95 110.79 196.93 110.77C196.9 110.74 196.88 110.7 196.85 110.66C196.77 110.55 196.71 110.43 196.67 110.3C196.67 110.28 196.67 110.25 196.67 110.23C196.67 110.16 196.67 110.1 196.72 110.05ZM195.35 116.85C195.35 116.85 195.41 116.88 195.42 116.9C195.45 116.97 195.44 117.04 195.41 117.1C195.29 117.32 195.14 117.52 194.93 117.66C194.9 117.68 194.88 117.69 194.86 117.69C194.78 117.64 194.77 117.62 194.76 117.59C194.74 117.52 194.74 117.49 194.74 117.45C194.75 117.36 194.77 117.32 194.8 117.29C194.97 117.15 195.14 117.01 195.29 116.85C195.34 116.83 195.34 116.84 195.35 116.84V116.85ZM194.7 107.18C194.87 106.98 195.04 106.76 195.14 106.51C195.16 106.46 195.18 106.45 195.2 106.45C195.24 106.46 195.25 106.48 195.27 106.51C195.29 106.57 195.3 106.62 195.29 106.66C195.19 106.96 195.07 107.24 194.89 107.49C194.86 107.53 194.83 107.55 194.8 107.55C194.74 107.52 194.72 107.5 194.71 107.48C194.68 107.41 194.67 107.38 194.67 107.35C194.67 107.26 194.67 107.21 194.7 107.18ZM194.63 112.67C194.67 112.73 194.7 112.8 194.74 112.87C194.78 112.94 194.82 113 194.84 113.07C194.86 113.13 194.86 113.23 194.82 113.28C194.8 113.31 194.77 113.32 194.74 113.32C194.71 113.32 194.69 113.32 194.67 113.3C194.57 113.2 194.5 113.07 194.43 112.95C194.41 112.91 194.39 112.85 194.39 112.8C194.39 112.75 194.4 112.7 194.43 112.65C194.46 112.61 194.49 112.59 194.53 112.59C194.56 112.59 194.6 112.61 194.62 112.65L194.63 112.67Z\" />\n  </g>\n  <path opacity=\"0.3\" d=\"M125.654 159.24C155.834 159.24 180.3 156.368 180.3 152.825C180.3 149.282 155.834 146.409 125.654 146.409C95.4736 146.409 71.0078 149.282 71.0078 152.825C71.0078 156.368 95.4736 159.24 125.654 159.24Z\" fill=\"#080821\"/>\n  <path d=\"M189.979 110.609C194.593 111.964 202.76 118.5 200.546 124.948C198.332 131.397 190.512 130.335 181.539 123.907\" fill=\"#F99F10\"/>\n  <path d=\"M189.979 110.609C194.593 111.964 202.76 118.5 200.546 124.948C198.332 131.397 190.512 130.335 181.539 123.907\" stroke=\"#3A1103\" stroke-width=\"2.06554\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n  <path d=\"M115.554 36.1128C102.429 26.9625 85.6365 24.9093 82.6828 28.1935C80.2867 30.8539 89.3379 45.4284 87.8714 49.6875C86.409 53.9466 73.5696 51.1912 72.1651 56.607C71.5 59.1807 81.3484 65.3897 81.084 68.9837C80.8196 72.5778 73.2143 71.5615 72.6566 76.2131C72.2807 79.3403 79.2209 80.0302 78.9565 83.7565C78.6921 87.4827 73.6811 86.8011 73.9001 90.4116C74.0777 93.3405 79.5555 91.4113 81.0221 96.3356C82.4845 101.26 115.558 36.1128 115.558 36.1128H115.554Z\" fill=\"#EF6122\"/>\n  <path d=\"M57.0086 123.507C57.4093 111.461 65.816 108.788 71.9217 110.845C78.0233 112.902 77.6845 119.995 76.1437 122.664C73.6815 126.923 70.0669 125.085 71.4177 122.102C72.4175 119.239 72.6034 115.265 67.8733 116.529C61.9948 118.103 63.8248 133.909 76.2015 130.802C84.6785 128.675 84.0134 119.698 83.34 106.607C81.5347 93.9407 83.4887 77.3338 88.8757 61.5696C99.7899 29.6282 165.536 19.2468 187.36 48.7922C215.712 87.1699 184.448 124.655 179.639 129.443C164.66 141.068 167.089 151.586 156.357 152.284C146.157 152.949 146.996 142.584 140.25 142.006C139.853 142.006 139.457 142.006 139.06 141.997C131.141 142.58 129.612 152.457 117.669 152.284C107.936 152.143 112.27 143.642 105.768 139.564C104.404 138.92 103.223 138.465 102.132 138.168C101.273 137.986 100.319 137.854 99.2406 137.788C98.9927 137.771 97.4931 137.78 97.0552 137.78C93.1926 137.85 90.8751 138.763 82.1461 140.539C66.4191 143.737 56.6698 133.698 57.0086 123.507Z\" fill=\"#FAC20C\" stroke=\"#3A1103\" stroke-width=\"2.06554\" stroke-miterlimit=\"10\"/>\n  <path d=\"M99.9346 44.2687C122.292 28.4302 148.314 37.0807 151.639 39.2784C154.965 41.4761 159.678 38.8653 157.03 32.268C148.157 10.175 125.262 -1.06152 119.099 2.7432C112.208 6.99821 120.875 25.9764 116.372 30.4255C112.757 33.9948 110.295 31.2683 104.148 29.2069C98.5961 27.3437 99.9346 44.2687 99.9346 44.2687Z\" fill=\"#EF6122\"/>\n  <path d=\"M139.09 19.7477C139.075 19.4295 139.023 19.0921 138.93 18.6947C138.837 18.2973 138.687 17.8773 138.477 17.4183C138.265 16.9789 137.977 16.4983 137.607 16.0548C137.472 15.8734 137.317 15.6929 137.141 15.5311C137.416 14.5044 136.856 13.603 136.856 13.603C135.867 13.5262 135.246 13.8727 135.005 14.0466C134.966 14.0269 134.926 14.0048 134.886 14.0047C134.729 13.943 134.551 13.8603 134.375 13.8177C134.197 13.7551 134.019 13.7121 133.842 13.6494C133.664 13.6064 133.468 13.5648 133.27 13.5208C133.23 13.5207 133.21 13.5197 133.172 13.4999C132.759 12.1245 131.541 11.5302 131.541 11.5302C130.158 12.3787 129.859 13.6023 129.859 13.6023C129.859 13.6023 129.858 13.6219 129.839 13.6808C129.759 13.6984 129.681 13.7183 129.601 13.7359C129.501 13.7745 129.381 13.8116 129.282 13.8306C129.183 13.8691 129.062 13.9063 128.963 13.9449C128.764 14.0398 128.543 14.1352 128.343 14.232C128.143 14.3485 127.943 14.4631 127.762 14.5786C127.744 14.558 127.724 14.5589 127.724 14.5589C125.833 13.8128 124.133 14.6764 124.133 14.6764C123.939 16.6946 124.829 17.9997 125.023 18.2397C124.981 18.3584 124.939 18.4949 124.899 18.6141C124.752 19.0685 124.645 19.5407 124.558 20.0359C124.556 20.115 124.535 20.1734 124.535 20.2529C122.737 21.0541 122.191 22.8301 122.191 22.8301C123.629 24.5402 125.35 24.6885 125.35 24.6885C125.561 25.088 125.812 25.4498 126.085 25.8112C126.201 25.9518 126.318 26.0929 126.454 26.2345C125.893 27.7522 126.485 29.0495 126.485 29.0495C128.128 29.1363 129.212 28.3815 129.433 28.2066C129.59 28.2683 129.769 28.3113 129.927 28.3533C130.421 28.5 130.935 28.5682 131.45 28.6167C131.569 28.6189 131.708 28.6201 131.827 28.6223L131.886 28.6234L131.926 28.6235L132.005 28.6255L132.084 28.6276C132.839 29.7513 134.183 29.9117 134.183 29.9117C135.172 28.9182 135.228 27.9078 135.232 27.6898L135.232 27.6702L135.233 27.6304L135.233 27.5906C135.434 27.4545 135.634 27.3002 135.815 27.1448C136.198 26.7939 136.561 26.4042 136.846 25.9927C136.866 25.954 136.907 25.9148 136.927 25.876C138.016 25.954 138.802 25.2336 138.802 25.2336C138.643 24.101 137.998 23.5344 137.861 23.4143L137.843 23.3936L137.823 23.3926C137.823 23.3926 137.803 23.3917 137.804 23.372C137.805 23.3126 137.827 23.2345 137.828 23.1751C137.83 23.0563 137.852 22.9385 137.853 22.7995L137.855 22.7003L137.855 22.6606L137.856 22.6409L137.856 22.6012L137.858 22.5221L137.859 22.4229L137.86 22.3238L137.861 22.2246L137.863 22.1254L137.844 22.0252C137.827 21.9054 137.808 21.7674 137.771 21.6466C137.66 21.149 137.489 20.6902 137.239 20.269C136.99 19.8478 136.678 19.4667 136.326 19.143C135.974 18.8194 135.582 18.5751 135.171 18.3697C134.758 18.1839 134.323 18.0383 133.888 17.99C133.671 17.967 133.452 17.9435 133.234 17.9383L133.155 17.9363L133.136 17.9353C133.136 17.9353 133.096 17.9352 133.116 17.9343L133.076 17.9342L132.997 17.9321L132.918 17.9301C132.798 17.9476 132.699 17.9464 132.581 17.9643C132.143 18.0367 131.745 18.1887 131.365 18.3992C131.005 18.6108 130.683 18.8635 130.421 19.1773C130.157 19.4709 129.954 19.8035 129.809 20.1587C129.663 20.5139 129.578 20.8683 129.553 21.2242L129.55 21.482L129.549 21.5414L129.547 21.6204L129.545 21.7393C129.561 21.9185 129.598 22.0968 129.635 22.2555C129.729 22.5935 129.862 22.8937 130.055 23.1356C130.23 23.3966 130.464 23.5988 130.698 23.7813C130.933 23.9442 131.189 24.0665 131.444 24.1508C131.699 24.2352 131.938 24.2578 132.176 24.2621L132.255 24.2642L132.295 24.2643L132.335 24.2644L132.414 24.2664L132.433 24.2674L132.453 24.2684L132.493 24.2685C132.533 24.2686 132.552 24.2696 132.573 24.2509C132.592 24.2519 132.633 24.2323 132.653 24.2333C132.713 24.2148 132.753 24.2149 132.812 24.1958C132.911 24.1572 133.012 24.121 133.111 24.0824C133.21 24.0438 133.29 23.9865 133.371 23.9273C133.391 23.9086 133.411 23.8876 133.43 23.8886C133.51 23.8312 133.533 23.7115 133.453 23.6318C133.396 23.5517 133.296 23.5304 133.216 23.5877C133.195 23.6064 133.175 23.6073 133.156 23.6264C133.097 23.6651 133.017 23.6827 132.936 23.7021C132.856 23.7197 132.778 23.7396 132.698 23.7572C132.658 23.7571 132.618 23.7748 132.578 23.7747L132.518 23.7736L132.459 23.7725L132.4 23.7714L132.32 23.7694L132.301 23.7684L132.261 23.7683L132.202 23.7672C132.024 23.7443 131.827 23.6826 131.649 23.5998C131.473 23.5175 131.295 23.3949 131.14 23.2542C130.984 23.1135 130.847 22.9316 130.751 22.7522C130.656 22.5532 130.579 22.3528 130.544 22.115C130.526 21.9952 130.528 21.896 130.53 21.7772L130.531 21.678L130.532 21.6584L130.533 21.6388L130.533 21.599C130.534 21.5396 130.555 21.4812 130.556 21.4217C130.644 20.9467 130.908 20.4762 131.291 20.1253C131.392 20.0273 131.493 19.9495 131.593 19.8931C131.694 19.8152 131.814 19.758 131.934 19.7007C132.054 19.6435 132.173 19.6059 132.313 19.5678C132.432 19.5302 132.572 19.5119 132.711 19.515L132.909 19.5192L132.948 19.5193L133.008 19.5204L133.048 19.5205L133.067 19.5215L133.127 19.5226C133.264 19.5454 133.424 19.5677 133.561 19.5887C133.838 19.6525 134.114 19.7561 134.369 19.92C134.88 20.2061 135.308 20.6703 135.577 21.2099C135.711 21.4905 135.806 21.7691 135.84 22.0662C135.858 22.1462 135.858 22.2258 135.857 22.2852L135.856 22.3446L135.854 22.404L135.853 22.4634L135.852 22.5228L135.852 22.5626L135.851 22.622L135.848 22.7605C135.846 22.8395 135.826 22.9181 135.824 22.9971C135.822 23.0762 135.802 23.1547 135.78 23.2347C135.758 23.3146 135.738 23.3932 135.716 23.4712C135.674 23.6297 135.612 23.7872 135.549 23.9443C135.425 24.2392 135.261 24.534 135.058 24.809C134.652 25.3371 134.13 25.7644 133.51 26.0314C133.21 26.1644 132.891 26.2591 132.553 26.313C132.394 26.3304 132.216 26.3473 132.057 26.3647L132.017 26.3646L131.997 26.3636L131.938 26.3625L131.859 26.3604L131.819 26.3604L131.8 26.3594C131.72 26.3573 131.621 26.3561 131.543 26.3363C131.187 26.3102 130.831 26.2241 130.495 26.1195C130.16 26.0148 129.826 25.8708 129.531 25.7068C128.923 25.3601 128.356 24.8946 127.929 24.3313C127.715 24.0505 127.523 23.7492 127.37 23.4499C127.216 23.1305 127.103 22.8116 127.01 22.4718C126.916 22.1338 126.883 21.795 126.848 21.4581L126.849 21.3987L126.85 21.379L126.851 21.3594L126.852 21.3397L126.853 21.2803L126.854 21.2607L126.855 21.241L126.856 21.2013L126.858 21.1222L126.859 21.1026L126.859 21.0628L126.861 20.944C126.864 20.7657 126.886 20.6081 126.909 20.429C126.932 20.2518 126.975 20.0736 126.998 19.9142C127.041 19.736 127.082 19.5794 127.127 19.4017C127.232 19.0661 127.356 18.7314 127.5 18.4375C127.787 17.8277 128.175 17.279 128.637 16.8506C128.758 16.734 128.878 16.637 129 16.5404C129.122 16.4439 129.241 16.3665 129.381 16.2686C129.502 16.1917 129.641 16.1135 129.781 16.0376C129.841 15.9989 129.921 15.9813 129.98 15.9426C130.021 15.9231 130.059 15.9049 130.08 15.904C130.12 15.8845 130.159 15.8663 130.179 15.8654C130.318 15.8092 130.478 15.752 130.617 15.7135C130.658 15.694 130.697 15.6959 130.736 15.6759C130.777 15.6564 130.816 15.6583 130.855 15.6383C130.935 15.6207 131.014 15.6008 131.074 15.5822C131.115 15.5627 131.154 15.5647 131.194 15.5648C131.234 15.5649 131.274 15.5472 131.314 15.5473C131.353 15.5474 131.394 15.5297 131.433 15.5298L131.494 15.5112L131.553 15.5123C131.593 15.5124 131.633 15.4947 131.673 15.4948C131.713 15.4949 131.753 15.4772 131.813 15.4783C131.852 15.4784 131.913 15.4599 131.952 15.4618L132.031 15.4639L132.09 15.465L132.11 15.466L132.15 15.466L132.288 15.4692L132.348 15.4703L132.367 15.4713L132.387 15.4722L132.506 15.4744L132.942 15.4811C133.238 15.5061 133.516 15.5307 133.793 15.5945C134.346 15.7025 134.878 15.8905 135.349 16.1368C135.82 16.383 136.251 16.6671 136.603 16.9908C136.622 17.0114 136.643 17.0307 136.661 17.0513C136.68 17.0719 136.701 17.0911 136.72 17.1118C136.759 17.1516 136.797 17.1929 136.856 17.2337C136.896 17.2736 136.933 17.3149 136.973 17.3547C137.012 17.3946 137.05 17.4358 137.089 17.4757C137.246 17.6365 137.381 17.8179 137.517 17.9974C137.768 18.3396 137.981 18.6797 138.134 19.0188C138.153 19.0394 138.154 19.0595 138.173 19.0783C138.192 19.0971 138.192 19.119 138.191 19.1387C138.211 19.1794 138.229 19.2178 138.248 19.2586C138.268 19.2993 138.286 19.3378 138.306 19.3785C138.325 19.4192 138.343 19.4577 138.363 19.4984C138.42 19.6581 138.476 19.7976 138.515 19.9367C138.591 20.1567 138.646 20.3557 138.682 20.534C138.701 20.5944 138.759 20.6549 138.84 20.6354C138.919 20.6375 138.979 20.5792 138.981 20.5001C139.106 20.2052 139.111 19.9877 139.094 19.7486L139.09 19.7477Z\" fill=\"#FAC20C\" fill-opacity=\"0.5\"/>\n  <path d=\"M127.975 119.854C122.213 125.093 115.652 127.03 111.984 122.548C107.932 117.595 111.575 111.857 116.888 107.007\" fill=\"#F99F10\"/>\n  <path d=\"M127.975 119.854C122.213 125.093 115.652 127.03 111.984 122.548C107.932 117.595 111.575 111.857 116.888 107.007\" stroke=\"#3A1103\" stroke-width=\"2.06554\" stroke-miterlimit=\"10\" stroke-linecap=\"round\"/>\n  <path d=\"M107.857 31.6853C96.5872 26.381 85.5944 23.5678 82.682 28.1946C79.5341 33.1973 90.2666 43.8224 87.8706 49.6886C85.6316 55.1746 72.9864 50.4652 72.1643 56.6081C71.5075 61.5241 81.3477 65.3908 81.0833 68.9848C80.8189 72.5788 73.1186 71.1123 72.5567 75.768C72.1808 78.8952 79.2201 80.0313 78.9516 83.7575C78.6872 87.4837 73.9654 86.798 73.8952 90.4127C73.8291 93.7878 82.5209 93.7423 82.7646 99.8604\" stroke=\"#3A1103\" stroke-width=\"2.06554\" stroke-miterlimit=\"10\"/>\n  <path d=\"M151.639 39.2779C154.965 41.4756 159.678 38.8648 157.03 32.2674C148.157 10.1745 125.94 -1.10338 119.099 2.74265C111.919 6.77871 120.875 25.9758 116.372 30.425C113.856 32.9119 110.552 32.8045 107.523 31.5321\" stroke=\"#3A1103\" stroke-width=\"2.06554\" stroke-miterlimit=\"10\"/>\n  <path d=\"M151.772 39.3768C139.812 32.2879 118.992 31.8665 100.232 45.8956\" stroke=\"#3A1103\" stroke-width=\"2.06554\" stroke-miterlimit=\"10\"/>\n  <path d=\"M133.284 88.646L194.34 93.5863C201.676 94.1799 208.104 88.7139 208.698 81.3777L208.698 81.3736C209.292 74.0374 203.826 67.6089 196.49 67.0153L135.434 62.0751C128.097 61.4814 121.669 66.9474 121.075 74.2837L121.075 74.2878C120.481 81.624 125.947 88.0524 133.284 88.646Z\" fill=\"#5545EF\" stroke=\"#231735\" stroke-width=\"2.06554\" stroke-miterlimit=\"10\"/>\n  <path d=\"M147.72 85.3174L194.052 89.0663C198.918 89.4601 203.182 85.8342 203.576 80.9676C203.97 76.101 200.344 71.8367 195.478 71.4429L149.146 67.6941C144.28 67.3003 140.015 70.9262 139.622 75.7928C139.228 80.6593 142.854 84.9237 147.72 85.3174Z\" fill=\"#19052D\"/>\n  <path d=\"M157.095 82.5854C157.145 81.9596 156.519 81.395 155.704 81.329L148.111 80.7147C147.296 80.6487 146.588 81.1053 146.537 81.7312C146.486 82.3571 147.112 82.9216 147.927 82.9876L155.52 83.602C156.336 83.6679 157.044 83.2113 157.095 82.5854Z\" fill=\"white\"/>\n  <path d=\"M157.46 78.0845C157.51 77.4586 156.885 76.894 156.069 76.8281L148.477 76.2137C147.661 76.1477 146.953 76.6043 146.902 77.2302C146.852 77.8561 147.477 78.4207 148.293 78.4866L155.885 79.101C156.701 79.167 157.409 78.7104 157.46 78.0845Z\" fill=\"white\"/>\n  <path d=\"M170.198 83.645C170.249 83.0191 169.623 82.4546 168.808 82.3886L161.215 81.7742C160.399 81.7083 159.691 82.1649 159.64 82.7908C159.59 83.4166 160.216 83.9812 161.031 84.0472L168.624 84.6615C169.439 84.7275 170.147 84.2709 170.198 83.645Z\" fill=\"white\"/>\n  <path d=\"M170.561 79.145C170.612 78.5191 169.986 77.9546 169.171 77.8886L161.578 77.2742C160.763 77.2083 160.054 77.6649 160.004 78.2908C159.953 78.9166 160.579 79.4812 161.394 79.5472L168.987 80.1615C169.802 80.2275 170.511 79.7709 170.561 79.145Z\" fill=\"white\"/>\n  <path d=\"M170.927 74.6489C170.977 74.023 170.351 73.4585 169.536 73.3925L161.943 72.7781C161.128 72.7122 160.42 73.1688 160.369 73.7947C160.318 74.4205 160.944 74.9851 161.759 75.0511L169.352 75.6654C170.168 75.7314 170.876 75.2748 170.927 74.6489Z\" fill=\"white\"/>\n  <path d=\"M183.3 84.7056C183.35 84.0797 182.724 83.5151 181.909 83.4492L174.316 82.8348C173.501 82.7688 172.793 83.2254 172.742 83.8513C172.691 84.4772 173.317 85.0417 174.132 85.1077L181.725 85.7221C182.541 85.788 183.249 85.3314 183.3 84.7056Z\" fill=\"white\"/>\n  <path d=\"M196.401 85.7651C196.452 85.1393 195.826 84.5747 195.011 84.5087L187.418 83.8944C186.603 83.8284 185.894 84.285 185.844 84.9109C185.793 85.5368 186.419 86.1013 187.234 86.1673L194.827 86.7816C195.642 86.8476 196.351 86.391 196.401 85.7651Z\" fill=\"white\"/>\n  <path d=\"M196.766 81.2651C196.817 80.6393 196.191 80.0747 195.376 80.0087L187.783 79.3944C186.968 79.3284 186.259 79.785 186.209 80.4109C186.158 81.0368 186.784 81.6013 187.599 81.6673L195.192 82.2817C196.007 82.3476 196.716 81.891 196.766 81.2651Z\" fill=\"white\"/>\n  <path d=\"M171.748 104.198L159.416 102.806C157.532 102.593 156.172 100.887 156.385 99.0029C156.447 98.4491 156.947 98.0507 157.501 98.1132C158.055 98.1757 158.453 98.6755 158.391 99.2293C158.303 100.009 158.866 100.712 159.643 100.8L171.975 102.192C172.529 102.254 172.927 102.754 172.864 103.308C172.802 103.862 172.302 104.26 171.748 104.198Z\" fill=\"#231F20\"/>\n  <path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M242 64.8081C243.527 65.5394 245.147 66.1493 246.865 66.5965C247.578 66.782 248.306 66.9366 249.047 67.0611C251.266 67.4329 253.59 67.5604 255.96 67.5349C259.346 67.4986 262.831 67.0989 266.275 66.4191C270.358 65.6132 274.377 64.3926 278.112 62.903C282.213 61.2684 285.971 59.3022 289.067 57.1158C289.342 56.9179 289.405 56.5333 289.208 56.2569C289.011 55.981 288.628 55.9172 288.353 56.1151C285.362 58.3081 281.727 60.3172 277.735 61.9653C274.072 63.4773 270.11 64.6817 266.093 65.5046C262.707 66.198 259.279 66.6069 255.946 66.6827C253.621 66.7356 251.345 66.6027 249.154 66.3282C248.422 66.2366 247.701 66.1342 246.988 66.0163C245.253 65.7295 243.585 65.3542 242 64.8085V64.8081Z\" fill=\"#3B3B5A\"/>\n  <path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M242.827 68.5993C245.17 69.3267 247.614 69.9091 250.115 70.3215C252.571 70.7262 255.077 70.979 257.588 71.0501C259.6 71.1073 261.614 71.0451 263.603 70.875C266.656 70.6137 269.65 70.0823 272.499 69.2957C277.676 67.8599 282.939 65.2459 288.327 63.8297C291.878 62.8963 295.484 62.4866 299.158 63.3226C306.092 64.8984 308.96 69.1466 308.614 73.111C308.243 77.3738 304.17 81.1864 297.694 80.7859C294.532 80.5857 292.718 77.9559 292.465 75.226C292.213 72.5057 293.519 69.6521 296.677 69.0124C299.42 68.4574 301.072 69.7051 301.506 71.2612C301.762 72.1768 301.593 73.1806 300.971 73.8968C300.437 74.5109 299.573 74.8951 298.39 74.8723C298.052 74.8669 297.773 75.1386 297.768 75.4784C297.763 75.8181 298.033 76.0979 298.371 76.1034C299.993 76.1219 301.152 75.5329 301.877 74.6853C302.753 73.6606 303.006 72.2375 302.633 70.9396C302.056 68.9336 299.99 67.1676 296.452 67.9128C292.687 68.7044 291.096 72.0821 291.418 75.328C291.735 78.5334 293.918 81.5767 297.634 81.7913C304.772 82.2137 309.173 77.8941 309.571 73.1949C309.936 68.8702 306.926 64.12 299.36 62.4205C295.537 61.5632 291.788 61.9857 288.1 62.9686C282.711 64.4041 277.453 67.0412 272.277 68.4976C269.478 69.2892 266.533 69.8117 263.532 70.1051C261.57 70.2968 259.584 70.3845 257.596 70.3857C255.106 70.3869 252.615 70.25 250.166 69.9575C247.657 69.6575 245.194 69.2096 242.826 68.6004L242.827 68.5993Z\" fill=\"#3B3B5A\"/>\n  <path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M291.436 59.5939C292.226 59.4088 293.019 59.2773 293.833 59.1382C294.098 59.093 294.361 59.047 294.625 58.9967C294.887 58.9469 295.148 58.8912 295.411 58.8402C298.474 58.2438 301.661 58.1151 304.617 58.8193C305.752 59.0899 306.856 59.4718 307.895 60.0048C309.392 60.772 310.752 61.8438 311.93 63.2368C312.154 63.4911 312.542 63.5154 312.795 63.2905C313.049 63.0655 313.073 62.6763 312.849 62.4216C311.457 60.9011 309.857 59.7871 308.131 58.994C306.375 58.1862 304.49 57.7042 302.546 57.5249C300.958 57.3784 299.335 57.4182 297.726 57.6281C296.667 57.7665 295.608 57.9532 294.584 58.2492C294.253 58.3451 293.929 58.4545 293.609 58.5789C292.852 58.8731 292.144 59.2267 291.436 59.5939H291.436Z\" fill=\"#3B3B5A\"/>\n  <path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M10 9.80809C11.5269 10.5394 13.147 11.1493 14.8652 11.5965C15.5783 11.782 16.3059 11.9366 17.0475 12.0611C19.2659 12.4329 21.5902 12.5604 23.9599 12.5349C27.3459 12.4986 30.8311 12.0989 34.2748 11.4191C38.3577 10.6132 42.3771 9.39259 46.1125 7.90298C50.2127 6.26842 53.9708 4.30224 57.067 2.11575C57.3417 1.91786 57.4052 1.53328 57.2082 1.25693C57.0112 0.980957 56.6283 0.917183 56.3532 1.11508C53.362 3.30814 49.7274 5.31722 45.7354 6.9653C42.0723 8.47733 38.1103 9.6817 34.0928 10.5046C30.7072 11.198 27.2789 11.6069 23.946 11.6827C21.6206 11.7356 19.3448 11.6027 17.1541 11.3282C16.4222 11.2366 15.7006 11.1342 14.9876 11.0163C13.2532 10.7295 11.5847 10.3542 10 9.80848L10 9.80809Z\" fill=\"#3B3B5A\"/>\n  <path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M10.8269 13.5993C13.1701 14.3267 15.614 14.9091 18.1153 15.3215C20.5708 15.7262 23.0771 15.979 25.5876 16.0501C27.5998 16.1073 29.6139 16.0451 31.603 15.875C34.6558 15.6137 37.6496 15.0823 40.4992 14.2957C45.6757 12.8599 50.9388 10.2459 56.3266 8.82971C59.878 7.89629 63.4841 7.48659 67.1579 8.32261C74.0915 9.89841 76.9595 14.1466 76.614 18.111C76.2426 22.3738 72.1701 26.1864 65.6945 25.7859C62.5325 25.5857 60.7177 22.9559 60.4649 20.226C60.2128 17.5057 61.5189 14.6521 64.6767 14.0124C67.4204 13.4574 69.072 14.7051 69.5065 16.2612C69.762 17.1768 69.5934 18.1806 68.9712 18.8968C68.4371 19.5109 67.5731 19.8951 66.3898 19.8723C66.0516 19.8669 65.773 20.1386 65.7676 20.4784C65.7626 20.8181 66.0327 21.0979 66.371 21.1034C67.993 21.1219 69.152 20.5329 69.877 19.6853C70.7533 18.6606 71.0065 17.2375 70.6332 15.9396C70.056 13.9336 67.9903 12.1676 64.4515 12.9128C60.6869 13.7044 59.0961 17.0821 59.4178 20.328C59.7353 23.5334 61.9179 26.5767 65.6341 26.7913C72.7716 27.2137 77.1735 22.8941 77.5706 18.1949C77.9362 13.8702 74.9262 9.11998 67.3596 7.42049C63.5372 6.56321 59.7884 6.98567 56.0995 7.96857C50.7114 9.40407 45.4533 12.0412 40.2771 13.4976C37.4776 14.2892 34.5326 14.8117 31.5322 15.1051C29.5701 15.2968 27.5841 15.3845 25.5961 15.3857C23.1064 15.3869 20.6155 15.25 18.1657 14.9575C15.6567 14.6575 13.1943 14.2096 10.8262 13.6004L10.8269 13.5993Z\" fill=\"#3B3B5A\"/>\n  <path fill-rule=\"evenodd\" clip-rule=\"evenodd\" d=\"M59.4359 4.59389C60.2263 4.40875 61.0187 4.27734 61.8333 4.1382C62.0981 4.09297 62.3605 4.04698 62.6253 3.99673C62.8873 3.94687 63.1482 3.89122 63.4107 3.8402C66.4738 3.24381 69.6612 3.1151 72.617 3.81933C73.7522 4.08988 74.8558 4.47176 75.8948 5.00475C77.3917 5.77198 78.7524 6.84377 79.9304 8.23676C80.1543 8.49108 80.5418 8.51543 80.7954 8.29048C81.049 8.06553 81.0729 7.67632 80.8489 7.42161C79.4574 5.90107 77.8566 4.78715 76.1315 3.99403C74.3748 3.18622 72.4896 2.70424 70.5459 2.5249C68.9582 2.37841 67.3346 2.41822 65.7257 2.6281C64.6667 2.76647 63.6081 2.95315 62.5841 3.24922C62.2532 3.34508 61.9288 3.45446 61.609 3.57892C60.852 3.87305 60.1444 4.22671 59.4355 4.59389H59.4359Z\" fill=\"#3B3B5A\"/>\n  <g id=\"grot-cta-tumbleweed\" fill-opacity=\"0.8\" fill=\"#9087e9\">\n    <path d=\"M255.834 142.553C255.855 141.865 255.927 141.184 256.06 140.504C256.238 139.668 256.382 138.823 256.622 138.003C256.66 137.862 256.697 137.72 256.734 137.576C256.738 137.552 256.74 137.53 256.744 137.506C256.811 136.99 256.912 136.479 257.005 135.969C257.1 135.536 257.189 135.104 257.3 134.675C257.295 134.677 257.292 134.68 257.287 134.683C257.279 134.688 257.271 134.692 257.263 134.697C257.076 134.816 256.892 134.94 256.711 135.067C256.607 135.136 256.506 135.208 256.406 135.281L256.404 135.284C256.013 136.389 255.675 137.515 255.392 138.653C255.399 138.67 255.407 138.688 255.416 138.705C255.408 138.785 255.397 138.863 255.389 138.942C255.339 139.481 255.292 140.021 255.274 140.562C255.235 141.391 255.233 142.222 255.265 143.053C255.267 143.096 255.269 143.138 255.273 143.182C255.354 143.105 255.437 143.03 255.521 142.959C255.561 142.922 255.603 142.886 255.647 142.85C255.689 142.814 255.731 142.778 255.775 142.743C255.793 142.728 255.811 142.713 255.83 142.699C255.832 142.651 255.832 142.603 255.835 142.553L255.834 142.553ZM254.489 129.99C254.494 129.981 254.498 129.974 254.505 129.966C254.503 129.949 254.503 129.932 254.504 129.915C254.5 129.745 254.499 129.579 254.498 129.41C254.48 129.437 254.46 129.464 254.44 129.491C254.421 129.518 254.403 129.545 254.383 129.57C254.344 129.624 254.307 129.676 254.268 129.728C254.211 129.808 254.152 129.886 254.093 129.965C254.012 130.076 253.932 130.185 253.85 130.293L253.85 130.295C253.857 130.451 253.868 130.607 253.881 130.763C253.881 130.799 253.885 130.836 253.888 130.871C253.967 130.776 254.045 130.679 254.121 130.581C254.137 130.561 254.152 130.541 254.167 130.523C254.25 130.417 254.332 130.309 254.414 130.2C254.418 130.193 254.423 130.186 254.429 130.18C254.434 130.171 254.439 130.165 254.446 130.156C254.45 130.151 254.453 130.148 254.455 130.143L254.455 130.141C254.464 130.091 254.476 130.04 254.489 129.99ZM256.404 135.284L256.405 135.28C256.428 135.216 256.45 135.15 256.475 135.085C256.568 134.824 256.666 134.565 256.767 134.306C256.534 134.495 256.31 134.693 256.095 134.9L256.094 134.902C256.048 135.089 256.005 135.276 255.961 135.463C255.947 135.521 255.935 135.58 255.921 135.639C255.912 135.671 255.904 135.705 255.897 135.738C255.793 136.269 255.681 136.798 255.603 137.333C255.55 137.637 255.509 137.945 255.472 138.252C255.347 137.817 255.259 137.372 255.192 136.921C255.171 136.781 255.15 136.642 255.131 136.502C255.13 136.493 255.13 136.487 255.128 136.48L255.129 136.478C255.072 136.063 255.025 135.648 254.971 135.232C254.938 134.955 254.902 134.677 254.868 134.4C254.907 134.188 254.95 133.975 254.993 133.765C255.033 133.583 255.074 133.399 255.119 133.219C255.255 132.644 255.414 132.078 255.597 131.52C255.648 131.367 255.7 131.217 255.756 131.066L255.759 131.058C255.801 130.936 255.844 130.818 255.892 130.698C256.253 129.749 256.686 128.836 257.182 127.944C257.343 127.644 257.511 127.348 257.685 127.053L257.686 127.051C257.699 127.026 257.713 127.003 257.728 126.979C257.873 126.73 258.022 126.483 258.173 126.236C258.224 126.148 258.275 126.063 258.328 125.976C258.44 125.789 258.555 125.602 258.67 125.416C258.757 125.276 258.844 125.133 258.933 124.993C259.023 124.841 259.116 124.69 259.206 124.539C259.301 124.382 259.396 124.223 259.49 124.066C260.08 123.081 260.651 122.084 261.177 121.06C260.738 121.586 260.316 122.124 259.902 122.667C259.901 122.669 259.899 122.671 259.898 122.672C259.87 122.711 259.839 122.751 259.811 122.79C259.45 123.267 259.097 123.749 258.748 124.234C258.535 124.525 258.328 124.819 258.124 125.118C258.122 125.121 258.119 125.124 258.117 125.13L258.116 125.132C257.946 125.38 257.777 125.63 257.608 125.88C257.387 126.221 257.173 126.565 256.963 126.916C256.828 127.143 256.695 127.373 256.566 127.606C256.541 127.652 256.517 127.699 256.49 127.744C256.2 128.295 255.929 128.858 255.692 129.437C255.445 130.067 255.227 130.712 255.071 131.37C254.915 132 254.804 132.642 254.741 133.286C254.692 132.824 254.646 132.364 254.606 131.901C254.556 131.322 254.52 130.74 254.509 130.16C254.508 130.13 254.508 130.102 254.507 130.073L254.508 130.071C254.505 130.036 254.505 130 254.506 129.967C254.499 129.975 254.495 129.982 254.489 129.991C254.476 130.041 254.465 130.092 254.456 130.141L254.455 130.143C254.453 130.149 254.45 130.152 254.446 130.157C254.439 130.165 254.435 130.172 254.43 130.181C254.423 130.187 254.419 130.194 254.414 130.201C254.332 130.309 254.251 130.418 254.167 130.524C254.153 130.542 254.137 130.562 254.122 130.582C254.046 130.68 253.968 130.777 253.889 130.871L253.888 130.873C253.932 131.421 253.989 131.966 254.061 132.507C254.107 132.877 254.163 133.245 254.223 133.612C254.256 133.82 254.291 134.03 254.329 134.236C254.334 134.282 254.343 134.33 254.35 134.375C254.367 134.471 254.383 134.567 254.402 134.662L254.402 134.664C254.537 135.44 254.687 136.21 254.854 136.986C254.874 137.073 254.895 137.158 254.918 137.244C254.918 137.244 254.918 137.246 254.919 137.246C254.919 137.255 254.921 137.26 254.923 137.267C255.043 137.734 255.186 138.196 255.384 138.635L255.392 138.653C255.675 137.515 256.013 136.389 256.404 135.284L256.404 135.284ZM263.087 115.103C263.079 115.107 263.074 115.111 263.07 115.116C263.058 115.175 263.042 115.233 263.028 115.291L263.027 115.293C263.025 115.301 263.025 115.307 263.022 115.314C263.01 115.369 262.994 115.425 262.98 115.477C262.975 115.498 262.969 115.522 262.962 115.542C262.901 115.555 262.84 115.567 262.778 115.575C262.742 115.641 262.706 115.709 262.671 115.774C262.639 115.837 262.607 115.898 262.573 115.958C262.702 115.83 262.828 115.703 262.954 115.571L262.954 115.57C262.957 115.566 262.96 115.565 262.964 115.56C262.973 115.553 262.98 115.545 262.987 115.535C263.111 115.411 263.232 115.285 263.352 115.158C263.595 114.901 263.834 114.642 264.071 114.379C263.738 114.615 263.41 114.857 263.086 115.103L263.087 115.103ZM265.693 138.295C265.693 138.289 265.696 138.281 265.698 138.275C265.706 138.228 265.713 138.182 265.722 138.132C265.71 138.143 265.698 138.153 265.686 138.164C265.414 138.402 265.138 138.638 264.862 138.87C264.795 139.232 264.734 139.596 264.679 139.961C264.946 139.746 265.209 139.526 265.47 139.302C265.491 139.286 265.512 139.268 265.528 139.251C265.58 138.932 265.636 138.612 265.693 138.295ZM270.127 134.619L270.114 134.628C270.019 134.681 269.925 134.735 269.832 134.789C269.737 134.844 269.646 134.899 269.553 134.957L269.013 135.316L268.493 135.706L268.076 136.05L267.99 136.122C267.827 136.265 267.668 136.412 267.514 136.565C267.504 136.577 267.494 136.588 267.482 136.598C267.414 136.667 267.345 136.737 267.279 136.808C267.203 136.887 267.128 136.968 267.055 137.05C266.916 137.209 266.779 137.372 266.65 137.54C266.584 137.626 266.518 137.713 266.454 137.8C266.454 137.8 266.452 137.801 266.451 137.803C266.389 137.89 266.327 137.978 266.267 138.066L265.916 138.612L265.593 139.176C265.587 139.187 265.582 139.198 265.576 139.208C265.777 139.04 265.973 138.87 266.166 138.697C266.713 138.219 267.244 137.725 267.764 137.218C267.957 137.025 268.149 136.83 268.338 136.632C268.597 136.364 268.852 136.09 269.101 135.814C269.125 135.869 269.151 135.922 269.172 135.976C269.188 136.009 269.204 136.041 269.217 136.076L269.298 136.002C269.277 135.976 269.255 135.948 269.232 135.923C269.198 135.877 269.16 135.834 269.123 135.79C269.438 135.44 269.747 135.088 270.044 134.724C270.073 134.689 270.1 134.654 270.127 134.619L270.127 134.619ZM280.076 143.082C279.866 143.195 279.654 143.305 279.437 143.411C279.347 143.458 279.256 143.504 279.163 143.547L279.16 143.548C278.987 143.72 278.809 143.892 278.631 144.06L278.457 144.21C278.445 144.219 278.435 144.23 278.423 144.24L278.235 144.401L277.879 144.709L277.873 144.714L277.549 144.993C277.368 145.145 277.197 145.311 277.006 145.455L276.438 145.888L275.871 146.322C275.679 146.464 275.497 146.617 275.295 146.745C275.114 146.866 274.933 146.986 274.752 147.109C274.796 147.004 274.839 146.899 274.884 146.795C274.975 146.574 275.069 146.353 275.159 146.134C275.231 145.965 275.302 145.794 275.376 145.626C275.405 145.558 275.433 145.492 275.462 145.426C275.486 145.367 275.513 145.309 275.54 145.25C275.587 145.138 275.635 145.029 275.684 144.919C275.54 144.977 275.399 145.036 275.255 145.095C275.247 145.098 275.24 145.1 275.232 145.104C275.174 145.248 275.119 145.393 275.069 145.54L275.06 145.564C275.036 145.628 275.014 145.69 274.993 145.756L274.993 145.758C274.96 145.852 274.929 145.947 274.901 146.04C274.809 146.337 274.726 146.637 274.66 146.938C274.638 147.03 274.62 147.12 274.601 147.21C274.043 147.587 273.482 147.964 272.893 148.292L272.276 148.655L271.969 148.837L271.65 148.998L270.374 149.647C270.163 149.761 269.944 149.854 269.724 149.946L269.066 150.228C268.627 150.414 268.193 150.615 267.739 150.763L266.708 151.137C267.429 150.696 268.117 150.202 268.754 149.645C268.841 149.57 268.929 149.495 269.013 149.417C269.931 148.611 270.81 147.764 271.65 146.877C271.719 146.804 271.79 146.73 271.858 146.655L271.86 146.653C271.925 146.581 271.992 146.511 272.055 146.439C272.11 146.384 272.161 146.328 272.21 146.271C272.283 146.193 272.354 146.112 272.423 146.034C272.591 145.848 272.756 145.658 272.918 145.468C272.893 145.479 272.869 145.487 272.844 145.493C272.741 145.529 272.639 145.563 272.536 145.597C272.535 145.597 272.534 145.599 272.534 145.599C272.278 145.681 272.02 145.763 271.76 145.844C271.5 145.919 271.238 145.987 270.972 146.045L270.97 146.044C270.926 146.094 270.878 146.141 270.831 146.19C270.847 146.149 270.863 146.106 270.877 146.065C270.913 145.967 270.944 145.871 270.975 145.774C270.852 145.814 270.73 145.85 270.608 145.879C270.597 145.96 270.585 146.039 270.571 146.121C270.551 146.251 270.53 146.38 270.508 146.51C270.356 146.655 270.202 146.802 270.054 146.95C270.007 147 269.96 147.046 269.912 147.093C269.497 147.505 269.056 147.885 268.614 148.267C268.44 148.415 268.268 148.566 268.097 148.718C268.097 148.718 268.095 148.719 268.094 148.721C268.071 148.74 268.048 148.762 268.025 148.781C267.469 149.254 266.88 149.671 266.261 150.046C266.119 150.134 265.977 150.217 265.832 150.3C265.427 150.528 265.014 150.74 264.59 150.937C264.649 150.81 264.704 150.68 264.756 150.55C264.787 150.47 264.818 150.388 264.847 150.306L264.86 150.268C264.878 150.215 264.895 150.165 264.911 150.113C265.034 149.741 265.129 149.357 265.198 148.97C265.22 148.859 265.237 148.748 265.252 148.637C265.258 148.603 265.263 148.571 265.266 148.537L265.267 148.535C265.268 148.525 265.27 148.515 265.271 148.504C265.274 148.491 265.274 148.478 265.275 148.464C265.279 148.438 265.281 148.413 265.284 148.387C265.288 148.371 265.29 148.353 265.289 148.336C265.299 148.259 265.308 148.18 265.312 148.102C265.326 147.957 265.334 147.811 265.337 147.664C265.343 147.483 265.342 147.301 265.336 147.12C265.329 146.878 265.312 146.636 265.283 146.396C265.278 146.346 265.27 146.295 265.263 146.244C265.256 146.195 265.248 146.146 265.24 146.097C265.223 145.981 265.202 145.866 265.177 145.751C265.144 145.583 265.103 145.416 265.056 145.249L265.056 145.248C265.045 145.201 265.03 145.158 265.016 145.114C265 145.057 264.983 145.003 264.96 144.947C264.911 144.786 264.849 144.628 264.78 144.471C264.773 144.45 264.763 144.429 264.753 144.409C264.749 144.397 264.742 144.386 264.738 144.374C264.738 144.421 264.737 144.467 264.738 144.512C264.739 144.516 264.738 144.518 264.739 144.522C264.739 144.613 264.741 144.704 264.742 144.793C264.742 144.885 264.742 144.976 264.744 145.067C264.744 145.133 264.745 145.198 264.745 145.264C264.745 145.314 264.745 145.367 264.746 145.42C264.746 145.603 264.744 145.784 264.742 145.966C264.742 146.021 264.74 146.075 264.738 146.129C264.736 146.228 264.734 146.324 264.73 146.421L264.729 146.423C264.727 146.477 264.726 146.529 264.722 146.583C264.724 146.596 264.722 146.608 264.722 146.621C264.716 146.752 264.709 146.882 264.702 147.012L264.701 147.014C264.701 147.045 264.698 147.078 264.696 147.109C264.687 147.237 264.678 147.366 264.668 147.493C264.657 147.641 264.643 147.79 264.628 147.936C264.627 147.953 264.623 147.968 264.622 147.983C264.617 148.048 264.61 148.111 264.6 148.175L264.599 148.177C264.593 148.257 264.584 148.338 264.573 148.416C264.557 148.542 264.541 148.668 264.52 148.794C264.513 148.852 264.505 148.911 264.496 148.969C264.479 149.077 264.461 149.184 264.443 149.292C264.383 149.646 264.313 149.999 264.235 150.351C264.233 150.363 264.229 150.376 264.227 150.388L264.225 150.394C264.212 150.455 264.199 150.516 264.183 150.575L264.182 150.577C264.14 150.779 264.089 150.979 264.038 151.182C263.828 151.27 263.619 151.353 263.408 151.431C263.261 151.486 263.114 151.538 262.966 151.588C263.709 151.553 264.455 151.493 265.198 151.42C265.395 151.4 265.59 151.377 265.787 151.351C266.854 151.183 267.907 150.976 268.949 150.718L269.864 150.482L270.768 150.209C271.04 150.135 271.3 150.036 271.563 149.944C271.633 149.917 271.704 149.889 271.773 149.861C271.452 149.92 271.13 149.978 270.809 150.048C270.442 150.122 270.072 150.204 269.706 150.294L269.85 150.236C270.075 150.148 270.299 150.059 270.514 149.951L271.821 149.329L272.147 149.173L272.462 148.996L273.096 148.645C275.35 147.407 277.427 145.867 279.308 144.112C279.422 144.01 279.531 143.907 279.639 143.801C280.001 143.457 280.355 143.106 280.698 142.747C280.494 142.862 280.287 142.975 280.077 143.086L280.076 143.082ZM268.256 136.687L267.823 137.011L267.406 137.358C266.947 137.759 266.53 138.208 266.167 138.697C266.714 138.219 267.245 137.725 267.764 137.218C267.958 137.024 268.15 136.829 268.338 136.632L268.256 136.688L268.256 136.687ZM271.149 145.153C271.144 145.158 271.135 145.163 271.13 145.168C271.003 145.261 270.878 145.352 270.75 145.444C270.72 145.468 270.688 145.488 270.657 145.511L270.656 145.513C270.646 145.604 270.633 145.695 270.62 145.787C270.774 145.672 270.926 145.556 271.076 145.433C271.101 145.341 271.125 145.248 271.149 145.153ZM269.324 136.034C269.289 136.052 269.255 136.069 269.224 136.088C269.286 136.23 269.347 136.371 269.405 136.513C269.41 136.509 269.414 136.505 269.419 136.501C269.473 136.461 269.527 136.421 269.583 136.381C269.5 136.262 269.414 136.147 269.324 136.034ZM270.127 134.619L270.113 134.627L270.112 134.627C270.017 134.68 269.924 134.735 269.832 134.789C269.737 134.844 269.646 134.899 269.552 134.957L269.011 135.315L268.492 135.706L268.076 136.05L267.99 136.121C267.826 136.265 267.668 136.412 267.514 136.565C267.504 136.576 267.494 136.588 267.482 136.598C267.413 136.667 267.345 136.736 267.278 136.808C267.202 136.887 267.128 136.968 267.055 137.05C266.916 137.209 266.779 137.372 266.65 137.54C266.584 137.626 266.518 137.713 266.454 137.8C266.454 137.8 266.451 137.801 266.451 137.803C266.387 137.889 266.325 137.977 266.265 138.065L265.915 138.612L265.593 139.176C265.587 139.187 265.581 139.198 265.575 139.208C265.777 139.04 265.973 138.87 266.166 138.697C266.713 138.219 267.244 137.725 267.763 137.218C267.957 137.024 268.148 136.829 268.337 136.632C268.597 136.364 268.851 136.09 269.101 135.814C269.124 135.868 269.15 135.922 269.172 135.975C269.188 136.008 269.204 136.041 269.217 136.076L269.297 136.002C269.277 135.976 269.255 135.947 269.232 135.923C269.197 135.877 269.159 135.834 269.122 135.79C269.437 135.44 269.747 135.088 270.044 134.723C270.073 134.689 270.099 134.654 270.126 134.619L270.127 134.619ZM265.693 138.295C265.693 138.288 265.696 138.281 265.697 138.275C265.706 138.227 265.713 138.182 265.722 138.132C265.71 138.142 265.698 138.153 265.686 138.164C265.413 138.402 265.138 138.637 264.861 138.87C264.795 139.232 264.734 139.596 264.679 139.961C264.945 139.746 265.209 139.526 265.47 139.302C265.49 139.286 265.511 139.268 265.528 139.251C265.579 138.932 265.636 138.612 265.693 138.295ZM280.076 143.082C279.866 143.195 279.653 143.304 279.437 143.411C279.347 143.458 279.255 143.504 279.162 143.547L279.16 143.548C278.986 143.72 278.809 143.892 278.631 144.06L278.456 144.21C278.445 144.219 278.435 144.23 278.423 144.24L278.234 144.401L277.879 144.709L277.873 144.713L277.549 144.993C277.368 145.145 277.197 145.311 277.005 145.455L276.438 145.888L275.871 146.322C275.678 146.463 275.497 146.617 275.294 146.745C275.113 146.866 274.933 146.986 274.751 147.109C274.796 147.004 274.839 146.899 274.883 146.795C274.975 146.574 275.068 146.353 275.159 146.134C275.23 145.965 275.302 145.794 275.375 145.626C275.405 145.558 275.432 145.491 275.461 145.426C275.486 145.367 275.513 145.309 275.539 145.25C275.586 145.138 275.635 145.029 275.683 144.919C275.539 144.977 275.399 145.036 275.254 145.095C275.247 145.098 275.24 145.1 275.232 145.104C275.174 145.248 275.119 145.393 275.068 145.54L275.06 145.564C275.036 145.628 275.014 145.69 274.993 145.756L274.992 145.758C274.96 145.852 274.929 145.947 274.901 146.04C274.809 146.336 274.726 146.637 274.659 146.938C274.638 147.029 274.619 147.12 274.601 147.21C274.042 147.587 273.482 147.964 272.892 148.292L272.275 148.655L271.968 148.837L271.649 148.998L270.373 149.647C270.163 149.761 269.944 149.853 269.724 149.946L269.066 150.227C268.626 150.414 268.192 150.615 267.738 150.763L266.707 151.137C267.429 150.696 268.117 150.201 268.754 149.645C268.841 149.57 268.928 149.495 269.012 149.417C269.93 148.61 270.809 147.763 271.65 146.877C271.719 146.804 271.789 146.73 271.857 146.655L271.86 146.653C271.925 146.581 271.991 146.511 272.055 146.439C272.109 146.384 272.16 146.328 272.21 146.271C272.122 146.298 272.035 146.325 271.948 146.347C271.945 146.348 271.945 146.35 271.943 146.349C271.842 146.378 271.742 146.404 271.642 146.428C271.763 146.34 271.882 146.251 272.002 146.16C272.162 146.04 272.319 145.916 272.474 145.788C272.474 145.788 272.475 145.786 272.477 145.787C272.538 145.739 272.601 145.691 272.66 145.642C272.722 145.592 272.785 145.542 272.844 145.493C272.741 145.529 272.639 145.563 272.537 145.597C272.535 145.596 272.534 145.598 272.534 145.598C272.278 145.68 272.02 145.763 271.76 145.844C271.501 145.918 271.238 145.987 270.972 146.044L270.97 146.044C270.926 146.094 270.878 146.14 270.831 146.19C270.848 146.149 270.863 146.106 270.877 146.064C270.775 146.086 270.674 146.103 270.571 146.12C270.551 146.251 270.53 146.38 270.508 146.509C270.356 146.655 270.202 146.801 270.054 146.95C270.008 146.999 269.96 147.046 269.912 147.093C269.497 147.505 269.056 147.885 268.614 148.267C268.44 148.415 268.268 148.566 268.097 148.717C268.097 148.717 268.095 148.719 268.094 148.72C268.071 148.74 268.048 148.761 268.025 148.781C267.469 149.254 266.88 149.671 266.261 150.046C266.119 150.134 265.977 150.217 265.832 150.299C265.427 150.527 265.014 150.74 264.59 150.936C264.649 150.809 264.704 150.679 264.756 150.549C264.787 150.47 264.818 150.388 264.847 150.305L264.86 150.268C264.878 150.215 264.896 150.164 264.911 150.113C265.034 149.74 265.129 149.356 265.198 148.97C265.22 148.859 265.237 148.747 265.252 148.637C265.258 148.603 265.263 148.571 265.266 148.536L265.267 148.534C265.268 148.524 265.27 148.514 265.271 148.504C265.274 148.49 265.274 148.478 265.275 148.463C265.279 148.437 265.282 148.413 265.284 148.386C265.288 148.371 265.29 148.353 265.289 148.336C265.299 148.259 265.308 148.18 265.312 148.101C265.326 147.957 265.335 147.81 265.337 147.663C265.343 147.482 265.343 147.301 265.336 147.12C265.329 146.877 265.312 146.635 265.284 146.396C265.278 146.346 265.27 146.295 265.263 146.243C265.256 146.195 265.248 146.146 265.24 146.096C265.223 145.981 265.202 145.866 265.177 145.75C265.144 145.583 265.103 145.415 265.056 145.249L265.056 145.247C265.045 145.201 265.03 145.158 265.016 145.113C265 145.057 264.983 145.003 264.96 144.946C264.911 144.786 264.85 144.628 264.78 144.471C264.773 144.449 264.763 144.429 264.753 144.409C264.749 144.397 264.742 144.386 264.738 144.374C264.738 144.421 264.737 144.467 264.739 144.511C264.739 144.516 264.739 144.518 264.739 144.522C264.739 144.613 264.741 144.704 264.742 144.793C264.742 144.885 264.742 144.976 264.744 145.067C264.745 145.132 264.745 145.198 264.746 145.263C264.745 145.314 264.746 145.367 264.746 145.42C264.746 145.603 264.744 145.783 264.742 145.966C264.742 146.021 264.74 146.075 264.738 146.129C264.736 146.227 264.734 146.324 264.73 146.421L264.729 146.423C264.727 146.477 264.726 146.529 264.722 146.583C264.724 146.596 264.722 146.608 264.722 146.62C264.716 146.751 264.709 146.881 264.702 147.012L264.701 147.013C264.701 147.045 264.698 147.078 264.696 147.108C264.687 147.236 264.678 147.366 264.668 147.493C264.657 147.641 264.643 147.789 264.628 147.936C264.627 147.952 264.623 147.968 264.623 147.982C264.617 148.048 264.61 148.111 264.6 148.175L264.599 148.177C264.593 148.257 264.584 148.338 264.573 148.416C264.557 148.541 264.541 148.668 264.52 148.794C264.513 148.852 264.505 148.911 264.496 148.968C264.479 149.077 264.461 149.184 264.443 149.291C264.383 149.645 264.314 149.998 264.236 150.351C264.234 150.363 264.229 150.376 264.227 150.388L264.225 150.393C264.212 150.454 264.2 150.515 264.183 150.575L264.182 150.577C264.14 150.779 264.09 150.978 264.038 151.182C263.828 151.269 263.619 151.352 263.408 151.431C263.261 151.485 263.114 151.538 262.966 151.587C263.709 151.552 264.455 151.492 265.198 151.42C265.395 151.399 265.59 151.376 265.787 151.35C266.854 151.183 267.907 150.975 268.949 150.718L269.865 150.481L270.768 150.209C271.04 150.134 271.3 150.035 271.563 149.943C271.633 149.917 271.704 149.889 271.773 149.86C271.452 149.919 271.13 149.978 270.809 150.048C270.442 150.121 270.072 150.203 269.706 150.294L269.851 150.236C270.075 150.147 270.299 150.059 270.514 149.95L271.821 149.329L272.147 149.173L272.463 148.996L273.096 148.645C275.35 147.406 277.428 145.867 279.308 144.112C279.422 144.01 279.531 143.907 279.64 143.801C280.001 143.457 280.355 143.105 280.698 142.746C280.494 142.861 280.287 142.974 280.077 143.085L280.076 143.082ZM268.255 136.687L267.823 137.011L267.406 137.357C266.947 137.759 266.53 138.208 266.166 138.697C266.713 138.219 267.245 137.725 267.764 137.218C267.958 137.024 268.149 136.829 268.338 136.632L268.256 136.687L268.255 136.687ZM255.833 142.552C255.854 141.865 255.926 141.184 256.059 140.504C256.237 139.668 256.381 138.823 256.621 138.003C256.659 137.862 256.696 137.719 256.733 137.576C256.737 137.552 256.739 137.53 256.743 137.506C256.81 136.99 256.911 136.479 257.004 135.968C257.1 135.536 257.189 135.103 257.299 134.674C257.294 134.677 257.291 134.68 257.286 134.682C257.278 134.688 257.27 134.692 257.262 134.697C257.075 134.816 256.892 134.939 256.711 135.066C256.611 135.135 256.513 135.204 256.415 135.275C256.412 135.278 256.406 135.281 256.403 135.284C256.012 136.389 255.674 137.514 255.391 138.653C255.398 138.67 255.406 138.687 255.415 138.705C255.406 138.784 255.396 138.863 255.388 138.942C255.338 139.481 255.291 140.021 255.272 140.561C255.233 141.39 255.232 142.222 255.264 143.052C255.266 143.095 255.268 143.138 255.272 143.182C255.353 143.104 255.436 143.03 255.52 142.958C255.56 142.921 255.602 142.885 255.646 142.85C255.688 142.814 255.73 142.778 255.774 142.743C255.792 142.728 255.809 142.713 255.829 142.699C255.831 142.651 255.831 142.602 255.833 142.553L255.833 142.552ZM254.488 129.99C254.49 129.965 254.497 129.94 254.503 129.915C254.499 129.745 254.498 129.578 254.497 129.41C254.479 129.437 254.46 129.464 254.44 129.491C254.42 129.518 254.402 129.545 254.383 129.57C254.343 129.624 254.306 129.676 254.267 129.728C254.21 129.807 254.151 129.886 254.092 129.964C254.011 130.075 253.931 130.184 253.85 130.293L253.849 130.295C253.856 130.451 253.867 130.606 253.881 130.763C253.881 130.799 253.885 130.836 253.887 130.871C253.967 130.776 254.045 130.679 254.121 130.581C254.136 130.561 254.151 130.541 254.166 130.523C254.249 130.417 254.331 130.309 254.413 130.2C254.418 130.193 254.422 130.186 254.428 130.18C254.434 130.171 254.438 130.164 254.445 130.156C254.449 130.151 254.452 130.148 254.454 130.142L254.455 130.141C254.463 130.091 254.475 130.04 254.488 129.99ZM256.403 135.284L256.405 135.28C256.427 135.216 256.45 135.15 256.474 135.085C256.567 134.824 256.665 134.565 256.766 134.305C256.534 134.494 256.309 134.693 256.094 134.9L256.093 134.902C256.048 135.089 256.004 135.275 255.96 135.463C255.946 135.521 255.934 135.58 255.92 135.638C255.911 135.671 255.904 135.704 255.896 135.738C255.792 136.268 255.68 136.798 255.602 137.333C255.549 137.637 255.508 137.945 255.471 138.252C255.346 137.817 255.258 137.372 255.191 136.921C255.17 136.781 255.149 136.641 255.13 136.502C255.129 136.493 255.129 136.487 255.127 136.48L255.128 136.478C255.072 136.063 255.024 135.648 254.97 135.231C254.938 134.955 254.902 134.677 254.867 134.4C254.907 134.188 254.949 133.975 254.992 133.765C255.032 133.582 255.073 133.399 255.118 133.218C255.254 132.644 255.413 132.078 255.596 131.52C255.647 131.367 255.699 131.217 255.755 131.066L255.758 131.058C255.801 130.936 255.843 130.818 255.891 130.698C256.252 129.749 256.685 128.835 257.181 127.944C257.342 127.644 257.51 127.348 257.684 127.052L257.685 127.05C257.698 127.025 257.712 127.003 257.727 126.979C257.872 126.73 258.021 126.482 258.172 126.236C258.224 126.148 258.274 126.062 258.328 125.976C258.439 125.789 258.554 125.602 258.669 125.416C258.756 125.275 258.843 125.133 258.932 124.993C259.023 124.841 259.115 124.69 259.206 124.538C259.3 124.381 259.395 124.223 259.49 124.066C260.08 123.081 260.651 122.084 261.177 121.06C260.738 121.586 260.315 122.124 259.901 122.667C259.901 122.669 259.898 122.67 259.897 122.672C259.869 122.711 259.839 122.751 259.81 122.79C259.449 123.267 259.097 123.749 258.747 124.234C258.534 124.525 258.327 124.819 258.123 125.117C258.121 125.121 258.118 125.124 258.116 125.13L258.116 125.132C257.945 125.38 257.777 125.629 257.608 125.88C257.386 126.22 257.172 126.565 256.962 126.916C256.827 127.142 256.694 127.373 256.565 127.606C256.54 127.652 256.516 127.698 256.49 127.744C256.2 128.294 255.929 128.857 255.692 129.437C255.444 130.067 255.226 130.712 255.07 131.369C254.914 132 254.804 132.642 254.74 133.285C254.692 132.824 254.645 132.364 254.605 131.901C254.556 131.322 254.519 130.74 254.508 130.159C254.508 130.13 254.507 130.102 254.507 130.073L254.507 130.071C254.504 130.036 254.504 130 254.505 129.967C254.503 129.949 254.503 129.932 254.504 129.916C254.497 129.941 254.491 129.966 254.489 129.99C254.475 130.041 254.464 130.092 254.455 130.141L254.455 130.143C254.453 130.149 254.45 130.152 254.446 130.157C254.439 130.165 254.434 130.172 254.429 130.181C254.423 130.187 254.418 130.194 254.414 130.201C254.332 130.309 254.25 130.417 254.167 130.523C254.152 130.542 254.137 130.562 254.121 130.582C254.045 130.679 253.967 130.776 253.888 130.871L253.887 130.873C253.931 131.421 253.989 131.966 254.06 132.507C254.107 132.876 254.162 133.245 254.222 133.612C254.256 133.819 254.29 134.029 254.328 134.236C254.333 134.282 254.342 134.33 254.35 134.374C254.367 134.471 254.382 134.567 254.402 134.662L254.401 134.664C254.536 135.439 254.686 136.21 254.853 136.986C254.873 137.073 254.894 137.158 254.917 137.244C254.917 137.244 254.917 137.246 254.919 137.246C254.918 137.254 254.92 137.259 254.922 137.266C255.042 137.733 255.186 138.196 255.383 138.635L255.391 138.653C255.674 137.515 256.012 136.389 256.404 135.284L256.403 135.284ZM263.086 115.103C263.079 115.106 263.073 115.111 263.069 115.116C263.057 115.175 263.041 115.232 263.027 115.291L263.027 115.293C263.024 115.3 263.024 115.307 263.021 115.314C263.009 115.369 262.994 115.425 262.98 115.477C262.974 115.498 262.968 115.521 262.961 115.542C262.9 115.554 262.839 115.567 262.777 115.575C262.742 115.641 262.705 115.708 262.67 115.774C262.638 115.837 262.606 115.897 262.573 115.957C262.701 115.829 262.828 115.703 262.953 115.571L262.954 115.569C262.957 115.566 262.959 115.565 262.963 115.56C262.972 115.552 262.979 115.544 262.987 115.534C263.11 115.411 263.232 115.284 263.351 115.157C263.594 114.9 263.833 114.642 264.07 114.379C263.737 114.615 263.409 114.857 263.086 115.103L263.086 115.103ZM254.5 129.301C254.498 129.025 254.505 128.751 254.52 128.476C254.545 127.918 254.594 127.36 254.681 126.81C254.794 125.985 254.976 125.17 255.214 124.37C255.25 124.302 255.288 124.235 255.328 124.169C255.27 124.219 255.211 124.268 255.152 124.317C255.09 124.368 255.029 124.418 254.967 124.468C254.89 124.532 254.812 124.593 254.732 124.654C254.652 124.715 254.571 124.775 254.492 124.834C254.158 125.08 253.812 125.312 253.456 125.526C253.439 125.587 253.424 125.648 253.407 125.709C253.364 125.871 253.321 126.031 253.279 126.193C253.219 126.417 253.163 126.639 253.107 126.862L252.786 128.442C252.769 128.541 252.747 128.639 252.726 128.737C252.722 128.757 252.719 128.777 252.714 128.796C252.702 128.855 252.688 128.914 252.678 128.973C252.666 129.032 252.656 129.092 252.647 129.152C252.658 129.133 252.673 129.115 252.685 129.098C252.828 128.912 252.985 128.739 253.156 128.583C252.937 128.907 252.758 129.247 252.614 129.6C252.599 129.637 252.584 129.676 252.568 129.714L252.567 129.718L252.523 130.032L252.411 130.829C252.403 130.896 252.392 130.963 252.382 131.029C252.352 131.23 252.324 131.428 252.313 131.629C252.295 131.875 252.275 132.122 252.256 132.365C252.359 132.232 252.462 132.1 252.567 131.968C252.579 131.951 252.592 131.936 252.604 131.92C252.611 131.871 252.619 131.823 252.626 131.777C252.764 130.871 252.949 129.973 253.177 129.085C253.432 128.038 253.746 127.007 254.107 125.989C254.062 126.23 254.02 126.471 253.983 126.71C253.897 127.287 253.854 127.868 253.832 128.448C253.812 129.027 253.811 129.607 253.843 130.183C253.843 130.187 253.843 130.189 253.843 130.194C253.844 130.228 253.848 130.259 253.851 130.293C253.933 130.185 254.013 130.076 254.094 129.965C254.153 129.886 254.211 129.807 254.268 129.729C254.307 129.677 254.345 129.624 254.384 129.571C254.403 129.546 254.421 129.518 254.441 129.491C254.461 129.464 254.481 129.438 254.499 129.41L254.5 129.408C254.499 129.372 254.499 129.336 254.501 129.301L254.5 129.301ZM280.075 143.082C279.865 143.195 279.653 143.304 279.437 143.411C279.347 143.457 279.255 143.504 279.162 143.547L279.159 143.548C278.986 143.719 278.809 143.892 278.63 144.059L278.456 144.21C278.444 144.218 278.434 144.23 278.422 144.24L278.234 144.4L277.878 144.709L277.873 144.713L277.549 144.993C277.367 145.145 277.196 145.311 277.005 145.455L276.438 145.888L275.871 146.321C275.678 146.463 275.496 146.617 275.294 146.745C275.113 146.866 274.933 146.986 274.751 147.109C274.796 147.004 274.838 146.899 274.883 146.794C274.974 146.574 275.068 146.353 275.158 146.134C275.23 145.965 275.302 145.794 275.375 145.625C275.405 145.558 275.432 145.491 275.461 145.426C275.486 145.367 275.512 145.308 275.539 145.25C275.586 145.138 275.635 145.029 275.683 144.919C275.539 144.976 275.399 145.035 275.254 145.094C275.246 145.098 275.239 145.1 275.232 145.104C275.173 145.248 275.119 145.393 275.068 145.54L275.059 145.564C275.035 145.627 275.014 145.69 274.993 145.756L274.992 145.758C274.959 145.852 274.929 145.947 274.901 146.04C274.808 146.336 274.725 146.636 274.659 146.938C274.638 147.029 274.619 147.12 274.6 147.21C274.042 147.587 273.482 147.964 272.892 148.292L272.275 148.655L271.968 148.837L271.649 148.998L270.373 149.646C270.162 149.761 269.943 149.853 269.724 149.946L269.066 150.227C268.626 150.414 268.192 150.615 267.738 150.763L266.707 151.136C267.429 150.696 268.116 150.201 268.753 149.645C268.841 149.57 268.928 149.495 269.012 149.417C269.93 148.61 270.809 147.763 271.649 146.877C271.719 146.804 271.789 146.729 271.857 146.654L271.86 146.653C271.925 146.581 271.991 146.511 272.054 146.439C272.109 146.384 272.16 146.328 272.209 146.271C272.122 146.298 272.035 146.324 271.947 146.347C271.945 146.348 271.944 146.35 271.942 146.349C271.842 146.378 271.742 146.404 271.641 146.428C271.763 146.34 271.882 146.251 272.002 146.159C272.161 146.04 272.318 145.915 272.474 145.788C272.474 145.788 272.474 145.786 272.476 145.787C272.537 145.738 272.6 145.691 272.659 145.642C272.721 145.591 272.785 145.542 272.844 145.493C272.741 145.529 272.638 145.563 272.536 145.597C272.534 145.596 272.534 145.598 272.534 145.598C272.278 145.68 272.019 145.763 271.76 145.844C271.5 145.918 271.238 145.987 270.972 146.044L270.97 146.044C270.925 146.094 270.878 146.14 270.831 146.189C270.847 146.149 270.862 146.105 270.877 146.064C270.774 146.085 270.673 146.103 270.571 146.12C270.551 146.25 270.529 146.38 270.508 146.509C270.356 146.655 270.202 146.801 270.054 146.95C270.007 146.999 269.959 147.046 269.912 147.092C269.497 147.505 269.055 147.885 268.614 148.266C268.44 148.415 268.268 148.566 268.097 148.717C268.097 148.717 268.095 148.718 268.094 148.72C268.07 148.74 268.048 148.761 268.025 148.781C267.469 149.254 266.88 149.67 266.261 150.046C266.119 150.133 265.976 150.216 265.832 150.299C265.427 150.527 265.014 150.74 264.589 150.936C264.648 150.809 264.704 150.679 264.755 150.549C264.787 150.47 264.818 150.388 264.846 150.305L264.859 150.268C264.878 150.215 264.895 150.164 264.911 150.113C265.034 149.74 265.129 149.356 265.198 148.969C265.219 148.859 265.237 148.747 265.252 148.637C265.257 148.603 265.262 148.571 265.266 148.536L265.267 148.534C265.268 148.524 265.269 148.514 265.271 148.504C265.273 148.49 265.273 148.478 265.274 148.463C265.279 148.437 265.281 148.413 265.284 148.386C265.287 148.371 265.289 148.352 265.289 148.335C265.299 148.259 265.307 148.179 265.311 148.101C265.326 147.956 265.334 147.81 265.337 147.663C265.343 147.482 265.342 147.301 265.335 147.119C265.329 146.877 265.312 146.635 265.283 146.396C265.278 146.346 265.27 146.294 265.262 146.243C265.256 146.195 265.248 146.145 265.24 146.096C265.223 145.981 265.201 145.866 265.176 145.75C265.144 145.583 265.103 145.415 265.055 145.249L265.056 145.247C265.045 145.201 265.03 145.158 265.016 145.113C265 145.057 264.983 145.002 264.96 144.946C264.91 144.785 264.849 144.628 264.78 144.471C264.772 144.449 264.763 144.429 264.753 144.409C264.748 144.397 264.742 144.386 264.737 144.374C264.738 144.42 264.737 144.466 264.738 144.511C264.739 144.516 264.738 144.517 264.739 144.522C264.739 144.613 264.741 144.704 264.742 144.792C264.741 144.885 264.742 144.976 264.744 145.067C264.744 145.132 264.745 145.198 264.745 145.263C264.745 145.314 264.745 145.367 264.746 145.419C264.745 145.603 264.744 145.783 264.742 145.966C264.742 146.021 264.74 146.075 264.738 146.129C264.736 146.227 264.734 146.323 264.73 146.421L264.729 146.423C264.727 146.477 264.726 146.529 264.722 146.582C264.724 146.596 264.722 146.608 264.721 146.62C264.716 146.751 264.709 146.881 264.702 147.011L264.701 147.013C264.701 147.045 264.698 147.078 264.696 147.108C264.687 147.236 264.678 147.365 264.668 147.493C264.656 147.64 264.643 147.789 264.628 147.936C264.626 147.952 264.623 147.968 264.622 147.982C264.616 148.048 264.609 148.111 264.6 148.175L264.599 148.177C264.592 148.257 264.583 148.338 264.573 148.416C264.557 148.541 264.541 148.668 264.52 148.793C264.512 148.852 264.505 148.91 264.495 148.968C264.479 149.076 264.461 149.184 264.442 149.291C264.383 149.645 264.313 149.998 264.235 150.35C264.233 150.362 264.229 150.376 264.227 150.387L264.225 150.393C264.212 150.454 264.199 150.515 264.183 150.575L264.182 150.577C264.139 150.779 264.089 150.978 264.038 151.182C263.828 151.269 263.618 151.352 263.408 151.431C263.26 151.485 263.114 151.538 262.966 151.587C263.709 151.552 264.454 151.492 265.198 151.42C265.394 151.399 265.59 151.376 265.786 151.35C266.853 151.183 267.907 150.975 268.948 150.717L269.864 150.481L270.767 150.209C271.039 150.134 271.299 150.035 271.563 149.943C271.633 149.917 271.704 149.889 271.773 149.86C271.451 149.919 271.129 149.978 270.808 150.048C270.442 150.121 270.072 150.203 269.706 150.293L269.85 150.236C270.075 150.147 270.299 150.059 270.514 149.95L271.82 149.329L272.146 149.172L272.462 148.996L273.096 148.645C275.349 147.406 277.427 145.867 279.308 144.111C279.421 144.009 279.531 143.907 279.639 143.801C280.001 143.456 280.354 143.105 280.698 142.746C280.494 142.861 280.286 142.974 280.077 143.085L280.075 143.082ZM255.833 142.552C255.854 141.865 255.926 141.184 256.059 140.504C256.237 139.668 256.381 138.823 256.621 138.003C256.659 137.862 256.696 137.719 256.733 137.576C256.737 137.552 256.739 137.53 256.743 137.506C256.81 136.99 256.911 136.479 257.004 135.968C257.1 135.536 257.189 135.103 257.299 134.674C257.294 134.677 257.291 134.68 257.286 134.682C257.278 134.688 257.27 134.692 257.262 134.697C257.075 134.816 256.892 134.939 256.711 135.066C256.611 135.135 256.513 135.204 256.415 135.275C256.412 135.278 256.406 135.281 256.403 135.284C256.012 136.389 255.674 137.514 255.391 138.653C255.398 138.67 255.406 138.687 255.415 138.705C255.406 138.784 255.396 138.863 255.388 138.942C255.338 139.481 255.291 140.021 255.272 140.561C255.233 141.39 255.232 142.222 255.264 143.052C255.266 143.095 255.268 143.138 255.272 143.182C255.353 143.104 255.436 143.03 255.52 142.958C255.56 142.921 255.602 142.885 255.646 142.85C255.688 142.814 255.73 142.778 255.774 142.743C255.792 142.728 255.809 142.713 255.829 142.699C255.831 142.651 255.831 142.602 255.833 142.553L255.833 142.552ZM254.488 129.99C254.49 129.965 254.497 129.94 254.503 129.915C254.499 129.745 254.498 129.578 254.497 129.41C254.479 129.437 254.46 129.464 254.44 129.491C254.42 129.518 254.402 129.545 254.383 129.57C254.343 129.624 254.306 129.676 254.267 129.728C254.21 129.807 254.151 129.886 254.092 129.964C254.011 130.075 253.931 130.184 253.85 130.293L253.849 130.295C253.856 130.451 253.867 130.606 253.881 130.763C253.881 130.799 253.885 130.836 253.887 130.871C253.967 130.776 254.045 130.679 254.121 130.581C254.136 130.561 254.151 130.541 254.166 130.523C254.249 130.417 254.331 130.309 254.413 130.2C254.418 130.193 254.422 130.186 254.428 130.18C254.434 130.171 254.438 130.164 254.445 130.156C254.449 130.151 254.452 130.148 254.454 130.142L254.455 130.141C254.463 130.091 254.475 130.04 254.488 129.99ZM256.403 135.284L256.405 135.28C256.427 135.216 256.45 135.15 256.474 135.085C256.567 134.824 256.665 134.565 256.766 134.305C256.534 134.494 256.309 134.693 256.094 134.9L256.093 134.902C256.048 135.089 256.004 135.275 255.96 135.463C255.946 135.521 255.934 135.58 255.92 135.638C255.911 135.671 255.904 135.704 255.896 135.738C255.792 136.268 255.68 136.798 255.602 137.333C255.549 137.637 255.508 137.945 255.471 138.252C255.346 137.817 255.258 137.372 255.191 136.921C255.17 136.781 255.149 136.641 255.13 136.502C255.129 136.493 255.129 136.487 255.127 136.48L255.128 136.478C255.072 136.063 255.024 135.648 254.97 135.231C254.938 134.955 254.902 134.677 254.867 134.4C254.907 134.188 254.949 133.975 254.992 133.765C255.032 133.582 255.073 133.399 255.118 133.218C255.254 132.644 255.413 132.078 255.596 131.52C255.647 131.367 255.699 131.217 255.755 131.066L255.758 131.058C255.801 130.936 255.843 130.818 255.891 130.698C256.252 129.749 256.685 128.835 257.181 127.944C257.342 127.644 257.51 127.348 257.684 127.052L257.685 127.05C257.698 127.025 257.712 127.003 257.727 126.979C257.872 126.73 258.021 126.482 258.172 126.236C258.224 126.148 258.274 126.062 258.328 125.976C258.439 125.789 258.554 125.602 258.669 125.416C258.756 125.275 258.843 125.133 258.932 124.993C259.023 124.841 259.115 124.69 259.206 124.538C259.3 124.381 259.395 124.223 259.49 124.066C260.08 123.081 260.651 122.084 261.177 121.06C260.738 121.586 260.315 122.124 259.901 122.667C259.901 122.669 259.898 122.67 259.897 122.672C259.869 122.711 259.839 122.751 259.81 122.79C259.449 123.267 259.097 123.749 258.747 124.234C258.534 124.525 258.327 124.819 258.123 125.117C258.121 125.121 258.118 125.124 258.116 125.13L258.116 125.132C257.945 125.38 257.777 125.629 257.608 125.88C257.386 126.22 257.172 126.565 256.962 126.916C256.827 127.142 256.694 127.373 256.565 127.606C256.54 127.652 256.516 127.698 256.49 127.744C256.2 128.294 255.929 128.857 255.692 129.437C255.444 130.067 255.226 130.712 255.07 131.369C254.914 132 254.804 132.642 254.74 133.285C254.692 132.824 254.645 132.364 254.605 131.901C254.556 131.322 254.519 130.74 254.508 130.159C254.508 130.13 254.507 130.102 254.507 130.073L254.507 130.071C254.504 130.036 254.504 130 254.505 129.967C254.503 129.949 254.503 129.932 254.504 129.916C254.497 129.941 254.491 129.966 254.489 129.99C254.475 130.041 254.464 130.092 254.455 130.141L254.455 130.143C254.453 130.149 254.45 130.152 254.446 130.157C254.439 130.165 254.434 130.172 254.429 130.181C254.423 130.187 254.418 130.194 254.414 130.201C254.332 130.309 254.25 130.417 254.167 130.523C254.152 130.542 254.137 130.562 254.121 130.582C254.045 130.679 253.967 130.776 253.888 130.871L253.887 130.873C253.931 131.421 253.989 131.966 254.06 132.507C254.107 132.876 254.162 133.245 254.222 133.612C254.256 133.819 254.29 134.029 254.328 134.236C254.333 134.282 254.342 134.33 254.35 134.374C254.367 134.471 254.382 134.567 254.402 134.662L254.401 134.664C254.536 135.439 254.686 136.21 254.853 136.986C254.873 137.073 254.894 137.158 254.917 137.244C254.917 137.244 254.917 137.246 254.919 137.246C254.918 137.254 254.92 137.259 254.922 137.266C255.042 137.733 255.186 138.196 255.383 138.635L255.391 138.653C255.674 137.515 256.012 136.389 256.404 135.284L256.403 135.284ZM263.086 115.103C263.079 115.106 263.073 115.111 263.069 115.116C263.057 115.175 263.041 115.232 263.027 115.291L263.027 115.293C263.024 115.3 263.024 115.307 263.021 115.314C263.009 115.369 262.994 115.425 262.98 115.477C262.974 115.498 262.968 115.521 262.961 115.542C262.9 115.554 262.839 115.567 262.777 115.575C262.742 115.641 262.705 115.708 262.67 115.774C262.638 115.837 262.606 115.897 262.573 115.957C262.701 115.829 262.828 115.703 262.953 115.571L262.954 115.569C262.957 115.566 262.959 115.565 262.963 115.56C262.972 115.552 262.979 115.544 262.987 115.534C263.11 115.411 263.232 115.284 263.351 115.157C263.594 114.9 263.833 114.642 264.07 114.379C263.737 114.615 263.409 114.857 263.086 115.103L263.086 115.103ZM254.5 129.301C254.498 129.025 254.505 128.751 254.52 128.476C254.545 127.918 254.594 127.36 254.681 126.81C254.794 125.985 254.976 125.17 255.214 124.37C255.25 124.302 255.288 124.235 255.328 124.169C255.27 124.219 255.211 124.268 255.152 124.317C255.09 124.368 255.029 124.418 254.967 124.468C254.89 124.532 254.812 124.593 254.732 124.654C254.652 124.715 254.571 124.775 254.492 124.834C254.158 125.08 253.812 125.312 253.456 125.526C253.439 125.587 253.424 125.648 253.407 125.709C253.364 125.871 253.321 126.031 253.279 126.193C253.219 126.417 253.163 126.639 253.107 126.862L252.786 128.442C252.769 128.541 252.747 128.639 252.726 128.737C252.722 128.757 252.719 128.777 252.714 128.796C252.702 128.855 252.688 128.914 252.678 128.973C252.666 129.032 252.656 129.092 252.647 129.152C252.658 129.133 252.673 129.115 252.685 129.098C252.828 128.912 252.985 128.739 253.156 128.583C252.937 128.907 252.758 129.247 252.614 129.6C252.599 129.637 252.584 129.676 252.568 129.714L252.567 129.718L252.523 130.032L252.411 130.829C252.403 130.896 252.392 130.963 252.382 131.029C252.352 131.23 252.324 131.428 252.313 131.629C252.295 131.875 252.275 132.122 252.256 132.365C252.359 132.232 252.462 132.1 252.567 131.968C252.579 131.951 252.592 131.936 252.604 131.92C252.611 131.871 252.619 131.823 252.626 131.777C252.764 130.871 252.949 129.973 253.177 129.085C253.432 128.038 253.746 127.007 254.107 125.989C254.062 126.23 254.02 126.471 253.983 126.71C253.897 127.287 253.854 127.868 253.832 128.448C253.812 129.027 253.811 129.607 253.843 130.183C253.843 130.187 253.843 130.189 253.843 130.194C253.844 130.228 253.848 130.259 253.851 130.293C253.933 130.185 254.013 130.076 254.094 129.965C254.153 129.886 254.211 129.807 254.268 129.729C254.307 129.677 254.345 129.624 254.384 129.571C254.403 129.546 254.421 129.518 254.441 129.491C254.461 129.464 254.481 129.438 254.499 129.41L254.5 129.408C254.499 129.372 254.499 129.336 254.501 129.301L254.5 129.301ZM280.075 143.082C279.865 143.195 279.653 143.304 279.437 143.411C279.347 143.457 279.255 143.504 279.162 143.547L279.159 143.548C278.986 143.719 278.809 143.892 278.63 144.059L278.456 144.21C278.444 144.218 278.434 144.23 278.422 144.24L278.234 144.4L277.878 144.709L277.873 144.713L277.549 144.993C277.367 145.145 277.196 145.311 277.005 145.455L276.438 145.888L275.871 146.321C275.678 146.463 275.496 146.617 275.294 146.745C275.113 146.866 274.933 146.986 274.751 147.109C274.796 147.004 274.838 146.899 274.883 146.794C274.974 146.574 275.068 146.353 275.158 146.134C275.23 145.965 275.302 145.794 275.375 145.625C275.405 145.558 275.432 145.491 275.461 145.426C275.486 145.367 275.512 145.308 275.539 145.25C275.586 145.138 275.635 145.029 275.683 144.919C275.539 144.976 275.399 145.035 275.254 145.094C275.246 145.098 275.239 145.1 275.232 145.104C275.173 145.248 275.119 145.393 275.068 145.54L275.059 145.564C275.035 145.627 275.014 145.69 274.993 145.756L274.992 145.758C274.959 145.852 274.929 145.947 274.901 146.04C274.808 146.336 274.725 146.636 274.659 146.938C274.638 147.029 274.619 147.12 274.6 147.21C274.042 147.587 273.482 147.964 272.892 148.292L272.275 148.655L271.968 148.837L271.649 148.998L270.373 149.646C270.162 149.761 269.943 149.853 269.724 149.946L269.066 150.227C268.626 150.414 268.192 150.615 267.738 150.763L266.707 151.136C267.429 150.696 268.116 150.201 268.753 149.645C268.841 149.57 268.928 149.495 269.012 149.417C269.93 148.61 270.809 147.763 271.649 146.877C271.719 146.804 271.789 146.729 271.857 146.654L271.86 146.653C271.925 146.581 271.991 146.511 272.054 146.439C272.109 146.384 272.16 146.328 272.209 146.271C272.122 146.298 272.035 146.324 271.947 146.347C271.945 146.348 271.944 146.35 271.942 146.349C271.842 146.378 271.742 146.404 271.641 146.428C271.763 146.34 271.882 146.251 272.002 146.159C272.161 146.04 272.318 145.915 272.474 145.788C272.474 145.788 272.474 145.786 272.476 145.787C272.537 145.738 272.6 145.691 272.659 145.642C272.721 145.591 272.785 145.542 272.844 145.493C272.741 145.529 272.638 145.563 272.536 145.597C272.534 145.596 272.534 145.598 272.534 145.598C272.278 145.68 272.019 145.763 271.76 145.844C271.5 145.918 271.238 145.987 270.972 146.044L270.97 146.044C270.925 146.094 270.878 146.14 270.831 146.189C270.847 146.149 270.862 146.105 270.877 146.064C270.774 146.085 270.673 146.103 270.571 146.12C270.551 146.25 270.529 146.38 270.508 146.509C270.356 146.655 270.202 146.801 270.054 146.95C270.007 146.999 269.959 147.046 269.912 147.092C269.497 147.505 269.055 147.885 268.614 148.266C268.44 148.415 268.268 148.566 268.097 148.717C268.097 148.717 268.095 148.718 268.094 148.72C268.07 148.74 268.048 148.761 268.025 148.781C267.469 149.254 266.88 149.67 266.261 150.046C266.119 150.133 265.976 150.216 265.832 150.299C265.427 150.527 265.014 150.74 264.589 150.936C264.648 150.809 264.704 150.679 264.755 150.549C264.787 150.47 264.818 150.388 264.846 150.305L264.859 150.268C264.878 150.215 264.895 150.164 264.911 150.113C265.034 149.74 265.129 149.356 265.198 148.969C265.219 148.859 265.237 148.747 265.252 148.637C265.257 148.603 265.262 148.571 265.266 148.536L265.267 148.534C265.268 148.524 265.269 148.514 265.271 148.504C265.273 148.49 265.273 148.478 265.274 148.463C265.279 148.437 265.281 148.413 265.284 148.386C265.287 148.371 265.289 148.352 265.289 148.335C265.299 148.259 265.307 148.179 265.311 148.101C265.326 147.956 265.334 147.81 265.337 147.663C265.343 147.482 265.342 147.301 265.335 147.119C265.329 146.877 265.312 146.635 265.283 146.396C265.278 146.346 265.27 146.294 265.262 146.243C265.256 146.195 265.248 146.145 265.24 146.096C265.223 145.981 265.201 145.866 265.176 145.75C265.144 145.583 265.103 145.415 265.055 145.249L265.056 145.247C265.045 145.201 265.03 145.158 265.016 145.113C265 145.057 264.983 145.002 264.96 144.946C264.91 144.785 264.849 144.628 264.78 144.471C264.772 144.449 264.763 144.429 264.753 144.409C264.748 144.397 264.742 144.386 264.737 144.374C264.738 144.42 264.737 144.466 264.738 144.511C264.739 144.516 264.738 144.517 264.739 144.522C264.739 144.613 264.741 144.704 264.742 144.792C264.741 144.885 264.742 144.976 264.744 145.067C264.744 145.132 264.745 145.198 264.745 145.263C264.745 145.314 264.745 145.367 264.746 145.419C264.745 145.603 264.744 145.783 264.742 145.966C264.742 146.021 264.74 146.075 264.738 146.129C264.736 146.227 264.734 146.323 264.73 146.421L264.729 146.423C264.727 146.477 264.726 146.529 264.722 146.582C264.724 146.596 264.722 146.608 264.721 146.62C264.716 146.751 264.709 146.881 264.702 147.011L264.701 147.013C264.701 147.045 264.698 147.078 264.696 147.108C264.687 147.236 264.678 147.365 264.668 147.493C264.656 147.64 264.643 147.789 264.628 147.936C264.626 147.952 264.623 147.968 264.622 147.982C264.616 148.048 264.609 148.111 264.6 148.175L264.599 148.177C264.592 148.257 264.583 148.338 264.573 148.416C264.557 148.541 264.541 148.668 264.52 148.793C264.512 148.852 264.505 148.91 264.495 148.968C264.479 149.076 264.461 149.184 264.442 149.291C264.383 149.645 264.313 149.998 264.235 150.35C264.233 150.362 264.229 150.376 264.227 150.387L264.225 150.393C264.212 150.454 264.199 150.515 264.183 150.575L264.182 150.577C264.139 150.779 264.089 150.978 264.038 151.182C263.828 151.269 263.618 151.352 263.408 151.431C263.26 151.485 263.114 151.538 262.966 151.587C263.709 151.552 264.454 151.492 265.198 151.42C265.394 151.399 265.59 151.376 265.786 151.35C266.853 151.183 267.907 150.975 268.948 150.717L269.864 150.481L270.767 150.209C271.039 150.134 271.299 150.035 271.563 149.943C271.633 149.917 271.704 149.889 271.773 149.86C271.451 149.919 271.129 149.978 270.808 150.048C270.442 150.121 270.072 150.203 269.706 150.293L269.85 150.236C270.075 150.147 270.299 150.059 270.514 149.95L271.82 149.329L272.146 149.172L272.462 148.996L273.096 148.645C275.349 147.406 277.427 145.867 279.308 144.111C279.421 144.009 279.531 143.907 279.639 143.801C280.001 143.456 280.354 143.105 280.698 142.746C280.494 142.861 280.286 142.974 280.077 143.085L280.075 143.082ZM255.833 142.552C255.854 141.865 255.926 141.184 256.059 140.504C256.237 139.668 256.381 138.823 256.621 138.003C256.659 137.862 256.696 137.719 256.733 137.576C256.737 137.552 256.739 137.53 256.743 137.506C256.81 136.99 256.911 136.479 257.004 135.968C257.1 135.536 257.189 135.103 257.299 134.674C257.294 134.677 257.291 134.68 257.286 134.682C257.278 134.688 257.27 134.692 257.262 134.697C257.075 134.816 256.892 134.939 256.711 135.066C256.611 135.135 256.513 135.204 256.415 135.275C256.412 135.278 256.406 135.281 256.403 135.284C256.012 136.389 255.674 137.514 255.391 138.653C255.398 138.67 255.406 138.687 255.415 138.705C255.406 138.784 255.396 138.863 255.388 138.942C255.338 139.481 255.291 140.021 255.272 140.561C255.233 141.39 255.232 142.222 255.264 143.052C255.266 143.095 255.268 143.138 255.272 143.182C255.353 143.104 255.436 143.03 255.52 142.958C255.56 142.921 255.602 142.885 255.646 142.85C255.688 142.814 255.73 142.778 255.774 142.743C255.792 142.728 255.809 142.713 255.829 142.699C255.831 142.651 255.831 142.602 255.833 142.553L255.833 142.552ZM254.488 129.99C254.49 129.965 254.497 129.94 254.503 129.915C254.499 129.745 254.498 129.578 254.497 129.41C254.479 129.437 254.46 129.464 254.44 129.491C254.42 129.518 254.402 129.545 254.383 129.57C254.343 129.624 254.306 129.676 254.267 129.728C254.21 129.807 254.151 129.886 254.092 129.964C254.011 130.075 253.931 130.184 253.85 130.293L253.849 130.295C253.856 130.451 253.867 130.606 253.881 130.763C253.881 130.799 253.885 130.836 253.887 130.871C253.967 130.776 254.045 130.679 254.121 130.581C254.136 130.561 254.151 130.541 254.166 130.523C254.249 130.417 254.331 130.309 254.413 130.2C254.418 130.193 254.422 130.186 254.428 130.18C254.434 130.171 254.438 130.164 254.445 130.156C254.449 130.151 254.452 130.148 254.454 130.142L254.455 130.141C254.463 130.091 254.475 130.04 254.488 129.99ZM256.403 135.284L256.405 135.28C256.427 135.216 256.45 135.15 256.474 135.085C256.567 134.824 256.665 134.565 256.766 134.305C256.534 134.494 256.309 134.693 256.094 134.9L256.093 134.902C256.048 135.089 256.004 135.275 255.96 135.463C255.946 135.521 255.934 135.58 255.92 135.638C255.911 135.671 255.904 135.704 255.896 135.738C255.792 136.268 255.68 136.798 255.602 137.333C255.549 137.637 255.508 137.945 255.471 138.252C255.346 137.817 255.258 137.372 255.191 136.921C255.17 136.781 255.149 136.641 255.13 136.502C255.129 136.493 255.129 136.487 255.127 136.48L255.128 136.478C255.072 136.063 255.024 135.648 254.97 135.231C254.938 134.955 254.902 134.677 254.867 134.4C254.907 134.188 254.949 133.975 254.992 133.765C255.032 133.582 255.073 133.399 255.118 133.218C255.254 132.644 255.413 132.078 255.596 131.52C255.647 131.367 255.699 131.217 255.755 131.066L255.758 131.058C255.801 130.936 255.843 130.818 255.891 130.698C256.252 129.749 256.685 128.835 257.181 127.944C257.342 127.644 257.51 127.348 257.684 127.052L257.685 127.05C257.698 127.025 257.712 127.003 257.727 126.979C257.872 126.73 258.021 126.482 258.172 126.236C258.224 126.148 258.274 126.062 258.328 125.976C258.439 125.789 258.554 125.602 258.669 125.416C258.756 125.275 258.843 125.133 258.932 124.993C259.023 124.841 259.115 124.69 259.206 124.538C259.3 124.381 259.395 124.223 259.49 124.066C260.08 123.081 260.651 122.084 261.177 121.06C260.738 121.586 260.315 122.124 259.901 122.667C259.901 122.669 259.898 122.67 259.897 122.672C259.869 122.711 259.839 122.751 259.81 122.79C259.449 123.267 259.097 123.749 258.747 124.234C258.534 124.525 258.327 124.819 258.123 125.117C258.121 125.121 258.118 125.124 258.116 125.13L258.116 125.132C257.945 125.38 257.777 125.629 257.608 125.88C257.386 126.22 257.172 126.565 256.962 126.916C256.827 127.142 256.694 127.373 256.565 127.606C256.54 127.652 256.516 127.698 256.49 127.744C256.2 128.294 255.929 128.857 255.692 129.437C255.444 130.067 255.226 130.712 255.07 131.369C254.914 132 254.804 132.642 254.74 133.285C254.692 132.824 254.645 132.364 254.605 131.901C254.556 131.322 254.519 130.74 254.508 130.159C254.508 130.13 254.507 130.102 254.507 130.073L254.507 130.071C254.504 130.036 254.504 130 254.505 129.967C254.503 129.949 254.503 129.932 254.504 129.916C254.497 129.941 254.491 129.966 254.489 129.99C254.475 130.041 254.464 130.092 254.455 130.141L254.455 130.143C254.453 130.149 254.45 130.152 254.446 130.157C254.439 130.165 254.434 130.172 254.429 130.181C254.423 130.187 254.418 130.194 254.414 130.201C254.332 130.309 254.25 130.417 254.167 130.523C254.152 130.542 254.137 130.562 254.121 130.582C254.045 130.679 253.967 130.776 253.888 130.871L253.887 130.873C253.931 131.421 253.989 131.966 254.06 132.507C254.107 132.876 254.162 133.245 254.222 133.612C254.256 133.819 254.29 134.029 254.328 134.236C254.333 134.282 254.342 134.33 254.35 134.374C254.367 134.471 254.382 134.567 254.402 134.662L254.401 134.664C254.536 135.439 254.686 136.21 254.853 136.986C254.873 137.073 254.894 137.158 254.917 137.244C254.917 137.244 254.917 137.246 254.919 137.246C254.918 137.254 254.92 137.259 254.922 137.266C255.042 137.733 255.186 138.196 255.383 138.635L255.391 138.653C255.674 137.515 256.012 136.389 256.404 135.284L256.403 135.284ZM263.086 115.103C263.079 115.106 263.073 115.111 263.069 115.116C263.057 115.175 263.041 115.232 263.027 115.291L263.027 115.293C263.024 115.3 263.024 115.307 263.021 115.314C263.009 115.369 262.994 115.425 262.98 115.477C262.974 115.498 262.968 115.521 262.961 115.542C262.9 115.554 262.839 115.567 262.777 115.575C262.742 115.641 262.705 115.708 262.67 115.774C262.638 115.837 262.606 115.897 262.573 115.957C262.701 115.829 262.828 115.703 262.953 115.571L262.954 115.569C262.957 115.566 262.959 115.565 262.963 115.56C262.972 115.552 262.979 115.544 262.987 115.534C263.11 115.411 263.232 115.284 263.351 115.157C263.594 114.9 263.833 114.642 264.07 114.379C263.737 114.615 263.409 114.857 263.086 115.103L263.086 115.103ZM254.5 129.301C254.498 129.025 254.505 128.751 254.52 128.476C254.545 127.918 254.594 127.36 254.681 126.81C254.794 125.985 254.976 125.17 255.214 124.37C255.25 124.302 255.288 124.235 255.328 124.169C255.27 124.219 255.211 124.268 255.152 124.317C255.09 124.368 255.029 124.418 254.967 124.468C254.89 124.532 254.812 124.593 254.732 124.654C254.652 124.715 254.571 124.775 254.492 124.834C254.158 125.08 253.812 125.312 253.456 125.526C253.439 125.587 253.424 125.648 253.407 125.709C253.364 125.871 253.321 126.031 253.279 126.193C253.219 126.417 253.163 126.639 253.107 126.862L252.786 128.442C252.769 128.541 252.747 128.639 252.726 128.737C252.722 128.757 252.719 128.777 252.714 128.796C252.702 128.855 252.688 128.914 252.678 128.973C252.666 129.032 252.656 129.092 252.647 129.152C252.658 129.133 252.673 129.115 252.685 129.098C252.828 128.912 252.985 128.739 253.156 128.583C252.937 128.907 252.758 129.247 252.614 129.6C252.599 129.637 252.584 129.676 252.568 129.714L252.567 129.718L252.523 130.032L252.411 130.829C252.403 130.896 252.392 130.963 252.382 131.029C252.352 131.23 252.324 131.428 252.313 131.629C252.295 131.875 252.275 132.122 252.256 132.365C252.359 132.232 252.462 132.1 252.567 131.968C252.579 131.951 252.592 131.936 252.604 131.92C252.611 131.871 252.619 131.823 252.626 131.777C252.764 130.871 252.949 129.973 253.177 129.085C253.432 128.038 253.746 127.007 254.107 125.989C254.062 126.23 254.02 126.471 253.983 126.71C253.897 127.287 253.854 127.868 253.832 128.448C253.812 129.027 253.811 129.607 253.843 130.183C253.843 130.187 253.843 130.189 253.843 130.194C253.844 130.228 253.848 130.259 253.851 130.293C253.933 130.185 254.013 130.076 254.094 129.965C254.153 129.886 254.211 129.807 254.268 129.729C254.307 129.677 254.345 129.624 254.384 129.571C254.403 129.546 254.421 129.518 254.441 129.491C254.461 129.464 254.481 129.438 254.499 129.41L254.5 129.408C254.499 129.372 254.499 129.336 254.501 129.301L254.5 129.301ZM280.075 143.082C279.865 143.195 279.653 143.304 279.437 143.411C279.347 143.457 279.255 143.504 279.162 143.547L279.159 143.548C278.986 143.719 278.809 143.892 278.63 144.059L278.456 144.21C278.444 144.218 278.434 144.23 278.422 144.24L278.234 144.4L277.878 144.709L277.873 144.713L277.549 144.993C277.367 145.145 277.196 145.311 277.005 145.455L276.438 145.888L275.871 146.321C275.678 146.463 275.496 146.617 275.294 146.745C275.113 146.866 274.933 146.986 274.751 147.109C274.796 147.004 274.838 146.899 274.883 146.794C274.974 146.574 275.068 146.353 275.158 146.134C275.23 145.965 275.302 145.794 275.375 145.625C275.405 145.558 275.432 145.491 275.461 145.426C275.486 145.367 275.512 145.308 275.539 145.25C275.586 145.138 275.635 145.029 275.683 144.919C275.539 144.976 275.399 145.035 275.254 145.094C275.246 145.098 275.239 145.1 275.232 145.104C275.173 145.248 275.119 145.393 275.068 145.54L275.059 145.564C275.035 145.627 275.014 145.69 274.993 145.756L274.992 145.758C274.959 145.852 274.929 145.947 274.901 146.04C274.808 146.336 274.725 146.636 274.659 146.938C274.638 147.029 274.619 147.12 274.6 147.21C274.042 147.587 273.482 147.964 272.892 148.292L272.275 148.655L271.968 148.837L271.649 148.998L270.373 149.646C270.162 149.761 269.943 149.853 269.724 149.946L269.066 150.227C268.626 150.414 268.192 150.615 267.738 150.763L266.707 151.136C267.429 150.696 268.116 150.201 268.753 149.645C268.841 149.57 268.928 149.495 269.012 149.417C269.93 148.61 270.809 147.763 271.649 146.877C271.719 146.804 271.789 146.729 271.857 146.654L271.86 146.653C271.925 146.581 271.991 146.511 272.054 146.439C272.109 146.384 272.16 146.328 272.209 146.271C272.122 146.298 272.035 146.324 271.947 146.347C271.945 146.348 271.944 146.35 271.942 146.349C271.842 146.378 271.742 146.404 271.641 146.428C271.763 146.34 271.882 146.251 272.002 146.159C272.161 146.04 272.318 145.915 272.474 145.788C272.474 145.788 272.474 145.786 272.476 145.787C272.537 145.738 272.6 145.691 272.659 145.642C272.721 145.591 272.785 145.542 272.844 145.493C272.741 145.529 272.638 145.563 272.536 145.597C272.534 145.596 272.534 145.598 272.534 145.598C272.278 145.68 272.019 145.763 271.76 145.844C271.5 145.918 271.238 145.987 270.972 146.044L270.97 146.044C270.925 146.094 270.878 146.14 270.831 146.189C270.847 146.149 270.862 146.105 270.877 146.064C270.774 146.085 270.673 146.103 270.571 146.12C270.551 146.25 270.529 146.38 270.508 146.509C270.356 146.655 270.202 146.801 270.054 146.95C270.007 146.999 269.959 147.046 269.912 147.092C269.497 147.505 269.055 147.885 268.614 148.266C268.44 148.415 268.268 148.566 268.097 148.717C268.097 148.717 268.095 148.718 268.094 148.72C268.07 148.74 268.048 148.761 268.025 148.781C267.469 149.254 266.88 149.67 266.261 150.046C266.119 150.133 265.976 150.216 265.832 150.299C265.427 150.527 265.014 150.74 264.589 150.936C264.648 150.809 264.704 150.679 264.755 150.549C264.787 150.47 264.818 150.388 264.846 150.305L264.859 150.268C264.878 150.215 264.895 150.164 264.911 150.113C265.034 149.74 265.129 149.356 265.198 148.969C265.219 148.859 265.237 148.747 265.252 148.637C265.257 148.603 265.262 148.571 265.266 148.536L265.267 148.534C265.268 148.524 265.269 148.514 265.271 148.504C265.273 148.49 265.273 148.478 265.274 148.463C265.279 148.437 265.281 148.413 265.284 148.386C265.287 148.371 265.289 148.352 265.289 148.335C265.299 148.259 265.307 148.179 265.311 148.101C265.326 147.956 265.334 147.81 265.337 147.663C265.343 147.482 265.342 147.301 265.335 147.119C265.329 146.877 265.312 146.635 265.283 146.396C265.278 146.346 265.27 146.294 265.262 146.243C265.256 146.195 265.248 146.145 265.24 146.096C265.223 145.981 265.201 145.866 265.176 145.75C265.144 145.583 265.103 145.415 265.055 145.249L265.056 145.247C265.045 145.201 265.03 145.158 265.016 145.113C265 145.057 264.983 145.002 264.96 144.946C264.91 144.785 264.849 144.628 264.78 144.471C264.772 144.449 264.763 144.429 264.753 144.409C264.748 144.397 264.742 144.386 264.737 144.374C264.738 144.42 264.737 144.466 264.738 144.511C264.739 144.516 264.738 144.517 264.739 144.522C264.739 144.613 264.741 144.704 264.742 144.792C264.741 144.885 264.742 144.976 264.744 145.067C264.744 145.132 264.745 145.198 264.745 145.263C264.745 145.314 264.745 145.367 264.746 145.419C264.745 145.603 264.744 145.783 264.742 145.966C264.742 146.021 264.74 146.075 264.738 146.129C264.736 146.227 264.734 146.323 264.73 146.421L264.729 146.423C264.727 146.477 264.726 146.529 264.722 146.582C264.724 146.596 264.722 146.608 264.721 146.62C264.716 146.751 264.709 146.881 264.702 147.011L264.701 147.013C264.701 147.045 264.698 147.078 264.696 147.108C264.687 147.236 264.678 147.365 264.668 147.493C264.656 147.64 264.643 147.789 264.628 147.936C264.626 147.952 264.623 147.968 264.622 147.982C264.616 148.048 264.609 148.111 264.6 148.175L264.599 148.177C264.592 148.257 264.583 148.338 264.573 148.416C264.557 148.541 264.541 148.668 264.52 148.793C264.512 148.852 264.505 148.91 264.495 148.968C264.479 149.076 264.461 149.184 264.442 149.291C264.383 149.645 264.313 149.998 264.235 150.35C264.233 150.362 264.229 150.376 264.227 150.387L264.225 150.393C264.212 150.454 264.199 150.515 264.183 150.575L264.182 150.577C264.139 150.779 264.089 150.978 264.038 151.182C263.828 151.269 263.618 151.352 263.408 151.431C263.26 151.485 263.114 151.538 262.966 151.587C263.709 151.552 264.454 151.492 265.198 151.42C265.394 151.399 265.59 151.376 265.786 151.35C266.853 151.183 267.907 150.975 268.948 150.717L269.864 150.481L270.767 150.209C271.039 150.134 271.299 150.035 271.563 149.943C271.633 149.917 271.704 149.889 271.773 149.86C271.451 149.919 271.129 149.978 270.808 150.048C270.442 150.121 270.072 150.203 269.706 150.293L269.85 150.236C270.075 150.147 270.299 150.059 270.514 149.95L271.82 149.329L272.146 149.172L272.462 148.996L273.096 148.645C275.349 147.406 277.427 145.867 279.308 144.111C279.421 144.009 279.531 143.907 279.639 143.801C280.001 143.456 280.354 143.105 280.698 142.746C280.494 142.861 280.286 142.974 280.077 143.085L280.075 143.082ZM255.833 142.552C255.854 141.865 255.926 141.184 256.059 140.504C256.237 139.668 256.381 138.823 256.621 138.003C256.659 137.862 256.696 137.719 256.733 137.576C256.737 137.552 256.739 137.53 256.743 137.506C256.81 136.99 256.911 136.479 257.004 135.968C257.1 135.536 257.189 135.103 257.299 134.674C257.294 134.677 257.291 134.68 257.286 134.682C257.278 134.688 257.27 134.692 257.262 134.697C257.075 134.816 256.892 134.939 256.711 135.066C256.611 135.135 256.513 135.204 256.415 135.275C256.412 135.278 256.406 135.281 256.403 135.284C256.012 136.389 255.674 137.514 255.391 138.653C255.398 138.67 255.406 138.687 255.415 138.705C255.406 138.784 255.396 138.863 255.388 138.942C255.338 139.481 255.291 140.021 255.272 140.561C255.233 141.39 255.232 142.222 255.264 143.052C255.266 143.095 255.268 143.138 255.272 143.182C255.353 143.104 255.436 143.03 255.52 142.958C255.56 142.921 255.602 142.885 255.646 142.85C255.688 142.814 255.73 142.778 255.774 142.743C255.792 142.728 255.809 142.713 255.829 142.699C255.831 142.651 255.831 142.602 255.833 142.553L255.833 142.552ZM254.503 129.915C254.499 129.745 254.498 129.578 254.497 129.41C254.479 129.437 254.46 129.464 254.44 129.491C254.42 129.518 254.402 129.545 254.383 129.57C254.343 129.624 254.306 129.676 254.267 129.728C254.21 129.807 254.151 129.886 254.092 129.964C254.011 130.075 253.931 130.184 253.85 130.293L253.849 130.295C253.856 130.451 253.867 130.606 253.881 130.763C253.881 130.799 253.885 130.836 253.887 130.871C253.967 130.776 254.045 130.679 254.121 130.581C254.136 130.561 254.151 130.541 254.166 130.523C254.249 130.417 254.331 130.309 254.413 130.2C254.418 130.193 254.422 130.186 254.428 130.18C254.434 130.171 254.438 130.164 254.445 130.156C254.449 130.151 254.452 130.148 254.454 130.142L254.455 130.141C254.463 130.091 254.475 130.04 254.488 129.99C254.49 129.965 254.497 129.94 254.503 129.915ZM256.405 135.28C256.427 135.216 256.45 135.15 256.474 135.085C256.567 134.824 256.665 134.565 256.766 134.305C256.534 134.494 256.309 134.693 256.094 134.9L256.093 134.902C256.048 135.089 256.004 135.275 255.96 135.463C255.946 135.521 255.934 135.58 255.92 135.638C255.911 135.671 255.904 135.704 255.896 135.738C255.792 136.268 255.68 136.798 255.602 137.333C255.549 137.637 255.508 137.945 255.471 138.252C255.346 137.817 255.258 137.372 255.191 136.921C255.17 136.781 255.149 136.641 255.13 136.502C255.129 136.493 255.129 136.487 255.127 136.48L255.128 136.478C255.072 136.063 255.024 135.648 254.97 135.231C254.938 134.955 254.902 134.677 254.867 134.4C254.907 134.188 254.949 133.975 254.992 133.765C255.032 133.582 255.073 133.399 255.118 133.218C255.254 132.644 255.413 132.078 255.596 131.52C255.647 131.367 255.699 131.217 255.755 131.066L255.758 131.058C255.801 130.936 255.843 130.818 255.891 130.698C256.252 129.749 256.685 128.835 257.181 127.944C257.342 127.644 257.51 127.348 257.684 127.052L257.685 127.05C257.698 127.025 257.712 127.003 257.727 126.979C257.872 126.73 258.021 126.482 258.172 126.236C258.224 126.148 258.274 126.062 258.328 125.976C258.439 125.789 258.554 125.602 258.669 125.416C258.756 125.275 258.843 125.133 258.932 124.993C259.023 124.841 259.115 124.69 259.206 124.538C259.3 124.381 259.395 124.223 259.49 124.066C260.08 123.081 260.651 122.084 261.177 121.06C260.738 121.586 260.315 122.124 259.901 122.667C259.901 122.669 259.898 122.67 259.897 122.672C259.869 122.711 259.839 122.751 259.81 122.79C259.449 123.267 259.097 123.749 258.747 124.234C258.534 124.525 258.327 124.819 258.123 125.117C258.121 125.121 258.118 125.124 258.116 125.13L258.116 125.132C257.945 125.38 257.777 125.629 257.608 125.88C257.386 126.22 257.172 126.565 256.962 126.916C256.827 127.142 256.694 127.373 256.565 127.606C256.54 127.652 256.516 127.698 256.49 127.744C256.2 128.294 255.929 128.857 255.692 129.437C255.444 130.067 255.226 130.712 255.07 131.369C254.914 132 254.804 132.642 254.74 133.285C254.692 132.824 254.645 132.364 254.605 131.901C254.556 131.322 254.519 130.74 254.508 130.159C254.508 130.13 254.507 130.102 254.507 130.073L254.507 130.071C254.504 130.036 254.504 130 254.505 129.967C254.503 129.949 254.503 129.932 254.504 129.916C254.497 129.941 254.491 129.966 254.489 129.99C254.475 130.041 254.464 130.092 254.455 130.141L254.455 130.143C254.453 130.149 254.45 130.152 254.446 130.157C254.439 130.165 254.434 130.172 254.429 130.181C254.423 130.187 254.418 130.194 254.414 130.201C254.332 130.309 254.25 130.417 254.167 130.523C254.152 130.542 254.137 130.562 254.121 130.582C254.045 130.679 253.967 130.776 253.888 130.871L253.887 130.873C253.931 131.421 253.989 131.966 254.06 132.507C254.107 132.876 254.162 133.245 254.222 133.612C254.256 133.819 254.29 134.029 254.328 134.236C254.333 134.282 254.342 134.33 254.35 134.374C254.367 134.471 254.382 134.567 254.402 134.662L254.401 134.664C254.536 135.439 254.686 136.21 254.853 136.986C254.873 137.073 254.894 137.158 254.917 137.244C254.917 137.244 254.917 137.246 254.919 137.246C254.918 137.254 254.92 137.259 254.922 137.266C255.042 137.733 255.186 138.196 255.383 138.635L255.391 138.653C255.674 137.515 256.012 136.389 256.404 135.284L256.405 135.28L256.405 135.28ZM262.954 115.568C262.958 115.565 262.96 115.564 262.964 115.559C262.973 115.551 262.98 115.543 262.988 115.533C263.111 115.41 263.232 115.283 263.352 115.156C263.595 114.899 263.834 114.641 264.071 114.378C263.738 114.614 263.41 114.856 263.086 115.102C263.079 115.106 263.073 115.11 263.069 115.115C263.057 115.174 263.041 115.232 263.027 115.29L263.027 115.292C263.024 115.3 263.024 115.306 263.022 115.314C263.009 115.368 262.994 115.424 262.98 115.476C262.975 115.498 262.969 115.521 262.961 115.542C262.9 115.554 262.839 115.567 262.777 115.575C262.742 115.64 262.706 115.708 262.67 115.774C262.638 115.836 262.606 115.897 262.573 115.957C262.702 115.829 262.828 115.702 262.953 115.571L262.954 115.569L262.954 115.568ZM254.44 129.491C254.46 129.464 254.48 129.437 254.498 129.41L254.498 129.408C254.498 129.372 254.498 129.336 254.5 129.301C254.499 129.025 254.505 128.751 254.521 128.476C254.545 127.918 254.594 127.36 254.682 126.809C254.795 125.985 254.977 125.17 255.214 124.37C255.25 124.302 255.288 124.235 255.328 124.169C255.27 124.219 255.211 124.268 255.152 124.317C255.09 124.367 255.029 124.417 254.967 124.468C254.89 124.532 254.812 124.593 254.732 124.653C254.652 124.714 254.572 124.775 254.492 124.833C254.158 125.08 253.813 125.312 253.456 125.525C253.439 125.587 253.425 125.647 253.407 125.709C253.364 125.871 253.321 126.03 253.28 126.193C253.219 126.416 253.163 126.639 253.107 126.862L252.786 128.442C252.769 128.541 252.748 128.639 252.726 128.737C252.722 128.756 252.719 128.776 252.714 128.796C252.702 128.855 252.688 128.913 252.678 128.973C252.666 129.032 252.656 129.092 252.648 129.152C252.659 129.133 252.673 129.115 252.685 129.098C252.828 128.912 252.985 128.738 253.157 128.583C252.937 128.907 252.758 129.247 252.614 129.599C252.599 129.636 252.584 129.675 252.568 129.714L252.567 129.718L252.524 130.031L252.412 130.828C252.403 130.895 252.392 130.963 252.382 131.029C252.353 131.23 252.324 131.428 252.313 131.629C252.295 131.875 252.275 132.121 252.256 132.365C252.359 132.232 252.462 132.099 252.567 131.967C252.579 131.95 252.592 131.936 252.605 131.919C252.611 131.871 252.619 131.823 252.626 131.777C252.764 130.871 252.949 129.972 253.177 129.084C253.433 128.038 253.746 127.007 254.107 125.988C254.062 126.229 254.02 126.47 253.984 126.71C253.897 127.287 253.854 127.867 253.832 128.448C253.812 129.026 253.811 129.607 253.843 130.183C253.844 130.187 253.843 130.189 253.844 130.193C253.844 130.227 253.848 130.258 253.851 130.293C253.933 130.184 254.013 130.076 254.094 129.964C254.153 129.886 254.212 129.807 254.268 129.728C254.307 129.676 254.345 129.624 254.384 129.57C254.404 129.545 254.422 129.518 254.441 129.491L254.44 129.491ZM300.436 137.18C300.808 136.009 301.042 134.795 301.16 133.574L301.161 133.572C301.161 133.572 301.161 133.57 301.161 133.566C301.182 133.352 301.2 133.137 301.213 132.922C301.265 132.039 301.264 131.158 301.218 130.279C301.219 130.258 301.217 130.238 301.216 130.217C301.217 130.215 301.215 130.213 301.216 130.211C301.164 129.19 301.051 128.173 300.898 127.168C300.755 126.221 300.58 125.28 300.388 124.344C300.378 124.29 300.364 124.237 300.354 124.182C300.305 123.963 300.258 123.747 300.21 123.528C300.208 123.521 300.207 123.512 300.205 123.505C300.062 122.851 299.913 122.199 299.755 121.548C299.894 122.494 300.052 123.435 300.186 124.379C300.237 124.719 300.287 125.059 300.332 125.398C300.334 125.405 300.334 125.412 300.336 125.419C300.353 125.545 300.37 125.671 300.387 125.794C300.387 125.794 300.388 125.797 300.387 125.799C300.449 126.271 300.505 126.741 300.554 127.213C300.72 128.829 300.813 130.451 300.739 132.067C300.74 132.071 300.738 132.075 300.739 132.079L300.738 132.081C300.726 132.349 300.708 132.617 300.685 132.884C300.587 134.12 300.373 135.345 300.031 136.533C300.016 136.587 300.001 136.638 299.984 136.692L299.982 136.697C299.869 137.086 299.74 137.469 299.595 137.844C299.571 137.913 299.545 137.982 299.516 138.048C299.485 138.13 299.453 138.211 299.419 138.292C299.412 138.311 299.406 138.328 299.398 138.346C299.377 138.395 299.358 138.444 299.334 138.492C299.049 139.158 298.711 139.799 298.322 140.41C298.487 139.982 298.638 139.553 298.778 139.119L298.781 139.111C298.801 139.047 298.823 138.983 298.844 138.918C299.267 137.569 299.575 136.189 299.761 134.796L299.763 134.791C299.765 134.766 299.769 134.744 299.772 134.722C299.984 133.096 300.031 131.455 299.901 129.832C299.898 129.804 299.895 129.775 299.892 129.749C299.892 129.747 299.893 129.745 299.891 129.744C299.88 129.589 299.866 129.433 299.849 129.277C299.853 129.508 299.854 129.742 299.849 129.974C299.848 129.976 299.85 129.976 299.85 129.978C299.85 130.019 299.851 130.061 299.849 130.102C299.815 132.288 299.502 134.456 298.93 136.542C298.918 136.595 298.904 136.647 298.886 136.698C298.886 136.704 298.885 136.708 298.883 136.714C298.277 138.882 297.389 140.96 296.248 142.883C296.247 142.887 296.244 142.89 296.242 142.894C296.236 142.9 296.23 142.907 296.224 142.911L296.228 142.917C296.106 143.125 295.979 143.331 295.848 143.534C295.668 143.82 295.481 144.1 295.288 144.377C295.284 144.383 295.28 144.388 295.275 144.395C294.257 145.856 293.077 147.199 291.768 148.398C291.759 148.408 291.749 148.417 291.74 148.426C291.412 148.726 291.078 149.016 290.736 149.298C289.301 150.479 287.732 151.498 286.072 152.327C285.023 152.848 283.944 153.301 282.839 153.68C281.732 154.055 280.595 154.337 279.45 154.55C278.716 154.69 277.974 154.786 277.226 154.858L277.317 154.767L277.951 154.142L277.951 154.14L278.177 153.92L278.229 153.868L279.285 152.821L279.758 152.351C279.804 152.365 279.846 152.369 279.887 152.356C280.317 152.252 280.748 152.144 281.176 152.026C281.837 151.84 282.494 151.632 283.143 151.396C283.34 151.363 283.536 151.33 283.735 151.293C283.833 151.277 283.93 151.258 284.027 151.239C284.453 151.151 284.878 151.051 285.298 150.932C285.354 150.918 285.409 150.903 285.465 150.887C285.613 150.845 285.759 150.799 285.904 150.753C286.099 150.689 286.292 150.622 286.486 150.55C286.562 150.524 286.638 150.495 286.714 150.465C287.036 150.341 287.356 150.205 287.67 150.057C287.836 149.98 288.001 149.898 288.165 149.814C288.168 149.811 288.171 149.81 288.173 149.808C288.6 149.586 289.015 149.344 289.414 149.074C290.495 148.343 291.452 147.435 292.215 146.389C292.499 145.997 292.76 145.59 292.993 145.168C292.994 145.167 292.995 145.165 292.994 145.164C293.049 145.065 293.103 144.964 293.155 144.862C293.178 144.821 293.199 144.778 293.22 144.737C293.501 144.158 293.74 143.56 293.909 142.945C293.664 143.534 293.384 144.107 293.052 144.645C292.778 145.108 292.472 145.547 292.136 145.963C292.076 146.037 292.015 146.111 291.954 146.184C291.546 146.662 291.113 147.119 290.639 147.527C290.491 147.657 290.338 147.781 290.183 147.9C289.846 148.164 289.492 148.406 289.128 148.629C288.734 148.874 288.323 149.091 287.903 149.289C287.821 149.33 287.739 149.367 287.655 149.403C287.367 149.534 287.073 149.654 286.777 149.765C286.658 149.812 286.54 149.855 286.421 149.896C286.389 149.908 286.357 149.92 286.326 149.931C286.373 149.905 286.421 149.877 286.466 149.849L286.469 149.847C287.134 149.467 287.772 149.048 288.38 148.583C288.424 148.547 288.469 148.514 288.513 148.479C288.622 148.395 288.728 148.308 288.834 148.22C289.255 147.873 289.659 147.506 290.04 147.117C290.047 147.109 290.056 147.102 290.063 147.094C290.066 147.091 290.067 147.089 290.07 147.086C290.798 146.348 291.449 145.538 292.009 144.672C292.492 143.924 292.911 143.138 293.263 142.323C293.342 142.14 293.415 141.954 293.485 141.768C293.635 141.38 293.769 140.986 293.884 140.588C293.959 140.33 294.026 140.068 294.086 139.805C293.972 140.159 293.849 140.508 293.712 140.853C293.527 141.327 293.321 141.791 293.091 142.244C292.728 142.967 292.314 143.664 291.849 144.324C291.846 144.327 291.844 144.331 291.841 144.334C291.835 144.345 291.828 144.355 291.82 144.365C291.791 144.406 291.763 144.444 291.734 144.485C291.22 145.189 290.665 145.862 290.051 146.477C289.586 146.944 289.09 147.378 288.572 147.779C288.521 147.817 288.472 147.854 288.423 147.892C288.42 147.895 288.417 147.897 288.412 147.899C288.298 147.986 288.181 148.072 288.064 148.155C288.014 148.191 287.966 148.227 287.914 148.261C287.55 148.521 287.172 148.76 286.788 148.987C286.984 148.685 287.175 148.382 287.37 148.081C287.666 147.628 287.959 147.175 288.267 146.731C288.568 146.283 288.883 145.842 289.198 145.402C289.351 145.19 289.508 144.977 289.662 144.763C289.825 144.535 289.988 144.307 290.15 144.077C289.727 144.428 289.343 144.819 288.981 145.232C288.619 145.644 288.286 146.081 287.976 146.533C287.851 146.715 287.732 146.901 287.616 147.091C287.444 147.368 287.281 147.653 287.132 147.945C286.94 148.316 286.763 148.697 286.614 149.09C285.812 149.551 284.977 149.956 284.123 150.315C283.905 150.408 283.687 150.497 283.468 150.583C282.66 150.903 281.836 151.194 281.003 151.459C280.832 151.516 280.658 151.569 280.485 151.623C281.544 150.56 282.599 149.493 283.649 148.421L286.719 145.267L287.222 144.75L289.009 142.914C289.274 142.642 289.537 142.369 289.798 142.09C290.036 141.842 290.269 141.59 290.5 141.335C290.534 141.322 290.569 141.308 290.604 141.291C290.819 141.206 291.03 141.108 291.24 141.002C291.666 140.786 292.079 140.537 292.477 140.269C292.638 140.158 292.797 140.045 292.95 139.925C292.983 139.903 293.015 139.88 293.044 139.854C293.084 139.826 293.121 139.797 293.158 139.765C293.158 139.765 293.159 139.764 293.161 139.762C293.203 139.732 293.242 139.697 293.282 139.667C293.312 139.642 293.341 139.618 293.371 139.593L293.372 139.591C293.572 139.427 293.766 139.256 293.956 139.079C294.135 138.91 294.311 138.735 294.481 138.556C295.085 137.917 295.624 137.215 296.078 136.463C296.366 135.985 296.623 135.489 296.832 134.974L296.833 134.972C296.855 134.921 296.875 134.869 296.895 134.817C296.986 134.585 297.067 134.347 297.135 134.108L297.136 134.104C297.14 134.093 297.142 134.081 297.146 134.07C297.142 134.076 297.138 134.081 297.133 134.088L297.132 134.092C297.042 134.217 296.954 134.344 296.865 134.467C296.843 134.499 296.819 134.531 296.796 134.563C296.779 134.587 296.762 134.611 296.746 134.634C296.379 135.152 296.012 135.658 295.622 136.149C295.098 136.816 294.547 137.459 293.968 138.071C293.917 138.125 293.865 138.179 293.813 138.23C293.279 138.787 292.722 139.32 292.138 139.831C292.031 139.927 291.922 140.022 291.812 140.114C291.53 140.357 291.239 140.594 290.947 140.83C291.508 140.182 292.04 139.501 292.511 138.777C292.596 138.649 292.679 138.52 292.759 138.387C292.901 138.159 293.036 137.923 293.162 137.685C293.309 137.407 293.446 137.123 293.571 136.834C293.584 136.82 293.6 136.806 293.613 136.792C293.774 136.619 293.908 136.427 294.049 136.24C294.328 135.861 294.596 135.475 294.848 135.076C294.964 134.895 295.075 134.713 295.182 134.526C295.547 133.893 295.864 133.229 296.117 132.54C296.204 132.32 296.275 132.091 296.349 131.867C296.411 131.638 296.483 131.412 296.534 131.179C296.55 131.115 296.566 131.051 296.58 130.986C296.676 130.59 296.744 130.186 296.807 129.785C296.936 128.848 296.985 127.9 296.962 126.959C296.957 126.778 296.946 126.598 296.936 126.419C297.006 126.18 297.07 125.937 297.125 125.693C297.125 125.693 297.127 125.691 297.126 125.689C297.135 125.658 297.141 125.627 297.148 125.595C297.175 125.48 297.199 125.363 297.221 125.246C297.306 124.816 297.369 124.379 297.412 123.941L297.413 123.937C297.418 123.905 297.422 123.871 297.425 123.838C297.489 123.197 297.499 122.549 297.484 121.904C297.462 121.258 297.399 120.615 297.306 119.976C297.267 119.732 297.224 119.491 297.176 119.248C297.098 118.857 297.007 118.47 296.905 118.084C296.731 117.463 296.538 116.849 296.295 116.253C296.001 115.504 295.655 114.778 295.258 114.082C295.248 114.064 295.236 114.047 295.226 114.029L295.225 114.026C295.089 113.792 294.947 113.559 294.797 113.333C294.788 113.317 294.778 113.303 294.769 113.287L294.768 113.284C294.674 113.147 294.581 113.009 294.485 112.873C294.571 113.086 294.657 113.299 294.74 113.511C294.749 113.533 294.757 113.553 294.766 113.575C294.899 113.915 295.029 114.256 295.153 114.596C295.153 114.596 295.155 114.596 295.155 114.598C295.163 114.618 295.169 114.635 295.175 114.654C295.393 115.246 295.595 115.838 295.775 116.435C295.949 117.037 296.124 117.637 296.258 118.248C296.4 118.853 296.521 119.466 296.61 120.082C296.685 120.529 296.737 120.981 296.778 121.433C296.793 121.601 296.807 121.77 296.82 121.939C296.854 122.247 296.85 122.56 296.867 122.871C296.87 122.91 296.872 122.949 296.872 122.989C296.877 123.104 296.872 123.221 296.873 123.339L296.877 123.808C296.873 124.192 296.853 124.576 296.829 124.962C296.827 124.991 296.826 125.018 296.825 125.047L296.824 125.049C296.822 125.065 296.822 125.08 296.82 125.096C296.82 125.085 296.817 125.076 296.814 125.064L296.815 125.062C296.813 125.043 296.812 125.023 296.808 125.003C296.713 124.214 296.575 123.433 296.405 122.662C296.311 122.24 296.209 121.824 296.098 121.408C295.858 120.505 295.583 119.614 295.294 118.73C295.118 118.216 294.941 117.702 294.759 117.192C294.706 117.041 294.654 116.895 294.599 116.743L294.598 116.741C294.596 116.736 294.595 116.731 294.592 116.726C294.516 116.516 294.439 116.306 294.362 116.098C294.419 116.314 294.479 116.531 294.539 116.747C294.543 116.77 294.551 116.792 294.556 116.813C294.558 116.819 294.56 116.826 294.563 116.834L294.563 116.836C294.741 117.488 294.925 118.135 295.094 118.789C295.098 118.803 295.103 118.82 295.106 118.834C295.342 119.715 295.57 120.601 295.758 121.49C295.895 122.128 296.018 122.766 296.117 123.407C296.248 124.209 296.343 125.01 296.392 125.815C296.395 125.837 296.396 125.859 296.397 125.88L296.397 125.882C296.419 126.244 296.43 126.605 296.433 126.967C296.434 127.079 296.433 127.192 296.432 127.305C296.432 127.322 296.433 127.34 296.43 127.358C296.43 127.359 296.43 127.36 296.431 127.362C296.413 128.757 296.239 130.152 295.864 131.486C295.785 131.776 295.693 132.065 295.592 132.35C295.298 133.21 294.891 134.032 294.437 134.826C294.372 134.939 294.306 135.05 294.236 135.161C294.195 135.231 294.152 135.3 294.109 135.369C294.478 134.173 294.701 132.934 294.782 131.691C294.806 131.329 294.821 130.966 294.829 130.604C294.83 130.575 294.831 130.543 294.831 130.512C294.838 130.006 294.83 129.5 294.811 128.997C294.811 128.995 294.811 128.994 294.81 128.992C294.809 128.971 294.809 128.947 294.806 128.925C294.774 128.133 294.707 127.341 294.615 126.555C294.602 126.451 294.59 126.346 294.576 126.242C294.385 124.723 294.118 123.213 293.835 121.71C293.828 121.663 293.818 121.619 293.809 121.572L293.808 121.57C293.809 121.568 293.809 121.566 293.808 121.563C293.803 121.541 293.8 121.518 293.796 121.496C293.799 121.522 293.803 121.547 293.807 121.573C293.807 121.575 293.808 121.576 293.807 121.578C293.816 121.631 293.823 121.684 293.832 121.738C294.071 123.308 294.294 124.881 294.43 126.463C294.434 126.5 294.438 126.536 294.44 126.572C294.522 127.502 294.57 128.433 294.57 129.364C294.571 129.391 294.571 129.415 294.572 129.442L294.571 129.444C294.57 129.971 294.554 130.496 294.521 131.022C294.518 131.056 294.517 131.09 294.515 131.127L294.514 131.129C294.5 131.307 294.487 131.486 294.469 131.665C294.349 132.933 294.095 134.189 293.685 135.389C293.596 135.088 293.508 134.788 293.424 134.489C293.337 134.183 293.256 133.877 293.181 133.569C293.163 133.499 293.147 133.431 293.131 133.36C293.111 133.285 293.093 133.209 293.079 133.135L293.079 133.133C293.069 133.102 293.062 133.074 293.056 133.043C292.992 132.766 292.932 132.488 292.879 132.211C292.872 132.183 292.866 132.156 292.863 132.127C292.793 131.778 292.733 131.429 292.679 131.08C292.616 130.67 292.563 130.26 292.522 129.85C292.479 129.464 292.447 129.077 292.423 128.689C292.421 128.688 292.422 128.686 292.423 128.684L292.422 128.682C292.419 128.641 292.416 128.6 292.414 128.557C292.377 127.973 292.363 127.387 292.353 126.794C292.352 126.684 292.351 126.576 292.349 126.466C292.349 126.462 292.35 126.458 292.349 126.456L292.349 126.454C292.35 126.42 292.348 126.39 292.349 126.357C292.347 126.23 292.346 126.105 292.344 125.978C292.257 126.234 292.181 126.495 292.121 126.758C292.041 127.088 291.98 127.421 291.939 127.759C291.938 127.762 291.936 127.766 291.937 127.771C291.937 127.775 291.936 127.779 291.935 127.782C291.934 127.786 291.934 127.793 291.932 127.796C291.924 127.85 291.918 127.903 291.913 127.956C291.89 128.155 291.871 128.355 291.859 128.555C291.824 129.143 291.831 129.735 291.881 130.325C291.881 130.332 291.882 130.336 291.882 130.342C291.883 130.343 291.883 130.345 291.883 130.345C291.905 130.626 291.94 130.908 291.982 131.188C292.006 131.35 292.034 131.511 292.067 131.672C292.141 132.06 292.235 132.444 292.346 132.824C292.353 132.85 292.361 132.878 292.37 132.905C292.436 133.128 292.511 133.349 292.593 133.569C292.601 133.6 292.612 133.629 292.625 133.659C292.633 133.684 292.643 133.709 292.653 133.736C292.74 133.958 292.832 134.179 292.93 134.394C293.043 134.64 293.162 134.879 293.292 135.112C293.39 135.287 293.49 135.458 293.598 135.627C293.486 135.939 293.366 136.248 293.232 136.549C293.133 136.775 293.024 136.997 292.908 137.215C292.77 137.481 292.621 137.739 292.465 137.995C292.062 138.64 291.607 139.254 291.116 139.839C290.877 140.125 290.629 140.406 290.375 140.682C290.321 140.741 290.267 140.799 290.211 140.855C289.688 141.417 289.143 141.961 288.593 142.503L287.387 143.692L286.769 144.301L286.753 144.317L285.937 145.121L285.873 145.185L283.119 147.897C283.087 147.928 283.056 147.962 283.024 147.993C283.251 147.656 283.469 147.313 283.677 146.966L283.678 146.964C283.733 146.878 283.786 146.793 283.836 146.703C283.931 146.544 284.024 146.385 284.116 146.225C284.723 145.166 285.258 144.067 285.731 142.939C285.76 142.875 285.787 142.809 285.812 142.744C285.868 142.612 285.923 142.477 285.974 142.343C286.003 142.277 286.028 142.21 286.054 142.143C286.071 142.098 286.088 142.056 286.106 142.011C286.484 141.637 286.831 141.231 287.152 140.805C287.383 140.496 287.6 140.175 287.8 139.842C288.058 139.424 288.29 138.988 288.494 138.538C288.801 137.87 289.049 137.172 289.232 136.459L289.232 136.457C289.249 136.395 289.263 136.337 289.276 136.276C289.283 136.255 289.289 136.234 289.292 136.212L289.293 136.21C289.306 136.16 289.317 136.111 289.328 136.06L289.329 136.056C289.331 136.05 289.331 136.044 289.332 136.04L289.333 136.038C289.341 136.003 289.348 135.966 289.354 135.93C289.525 135.109 289.614 134.27 289.57 133.431C289.321 134.269 289.081 135.088 288.799 135.891C288.518 136.693 288.204 137.477 287.853 138.246C287.754 138.465 287.652 138.682 287.544 138.895C287.482 139.023 287.42 139.149 287.354 139.273L287.352 139.279C287.224 139.532 287.091 139.783 286.954 140.032C286.867 140.19 286.779 140.346 286.69 140.501C286.651 140.57 286.611 140.638 286.57 140.706C286.637 140.507 286.702 140.309 286.763 140.109L286.764 140.103C286.767 140.095 286.77 140.088 286.77 140.08L286.776 140.063C286.793 140.014 286.808 139.966 286.82 139.918C286.852 139.821 286.881 139.726 286.909 139.631C287.019 139.248 287.125 138.863 287.221 138.477C287.229 138.447 287.239 138.414 287.245 138.383C287.338 138.029 287.414 137.67 287.491 137.316C287.565 136.981 287.637 136.646 287.71 136.313C287.721 136.262 287.732 136.213 287.743 136.162C287.749 136.133 287.754 136.107 287.76 136.078L287.761 136.076L287.776 136.012C287.779 135.993 287.783 135.976 287.787 135.958C287.843 135.711 287.9 135.462 287.962 135.217C288.095 134.673 288.244 134.133 288.428 133.603C288.526 133.323 288.63 133.045 288.749 132.77C288.413 133.269 288.138 133.81 287.903 134.366C287.826 134.546 287.755 134.726 287.685 134.908C287.572 135.216 287.466 135.528 287.367 135.838C287.347 135.901 287.328 135.964 287.308 136.027L287.307 136.029C287.256 136.19 287.206 136.349 287.159 136.51C287.092 136.733 287.027 136.959 286.964 137.182C286.817 137.697 286.664 138.211 286.506 138.722C286.454 138.89 286.403 139.055 286.35 139.22C286.281 139.438 286.21 139.656 286.136 139.873C286.114 139.938 286.093 140.005 286.07 140.071L286.033 140.176C285.911 140.534 285.785 140.892 285.652 141.246C285.609 141.364 285.564 141.481 285.519 141.598C285.512 141.617 285.505 141.633 285.498 141.652C285.477 141.706 285.458 141.761 285.438 141.815L285.437 141.817C285.346 142.061 285.251 142.304 285.154 142.546C285.129 142.613 285.102 142.678 285.075 142.744L285.075 142.746C285.049 142.807 285.026 142.868 284.999 142.929C284.973 142.996 284.947 143.058 284.919 143.122L284.918 143.124C284.819 143.361 284.719 143.596 284.616 143.832C284.314 144.555 283.972 145.262 283.636 145.972C283.423 146.41 283.205 146.844 282.979 147.275C282.941 147.35 282.901 147.423 282.864 147.498C282.862 147.5 282.86 147.503 282.86 147.505C282.679 147.851 282.494 148.194 282.306 148.537C282.266 148.609 282.228 148.683 282.185 148.756C282.16 148.806 282.131 148.857 282.104 148.907C281.325 149.684 280.547 150.462 279.772 151.245C279.681 151.338 279.59 151.428 279.499 151.521L278.372 152.67C278.431 152.488 278.49 152.306 278.551 152.125C278.611 151.946 278.67 151.768 278.73 151.589C278.844 151.256 278.959 150.923 279.08 150.592C279.196 150.263 279.318 149.937 279.441 149.611C279.468 149.546 279.492 149.483 279.517 149.418C279.561 149.303 279.604 149.189 279.649 149.074C279.684 148.983 279.72 148.892 279.756 148.802C279.781 148.737 279.805 148.671 279.832 148.607C279.968 148.256 280.106 147.906 280.24 147.55C279.978 147.912 279.749 148.292 279.54 148.685C279.504 148.75 279.47 148.819 279.437 148.885L279.435 148.888C279.422 148.913 279.41 148.937 279.397 148.962C279.311 149.13 279.231 149.3 279.155 149.472C279.126 149.537 279.097 149.601 279.069 149.665C278.956 149.931 278.849 150.202 278.749 150.473C278.607 150.874 278.479 151.282 278.372 151.694C278.341 151.814 278.312 151.932 278.286 152.052C278.221 152.341 278.164 152.633 278.122 152.926L277.789 153.263L277.705 153.348L276.932 154.144L276.812 154.266L276.723 154.358L276.364 154.724C276.305 154.786 276.256 154.855 276.217 154.938C276.13 154.944 276.044 154.95 275.958 154.956C274.781 155.028 273.593 155.046 272.4 155.053C270.587 155.065 268.778 155.09 266.985 155.012C267.19 154.938 267.388 154.859 267.587 154.776L267.589 154.777C267.722 154.722 267.855 154.667 267.985 154.611C268.032 154.592 268.082 154.571 268.128 154.551C268.267 154.492 268.406 154.43 268.543 154.371C268.897 154.216 269.25 154.058 269.6 153.897C270.088 153.675 270.573 153.449 271.059 153.213C271.29 153.099 271.523 152.985 271.755 152.863C272.008 152.731 272.261 152.594 272.513 152.441C271.948 152.452 271.4 152.552 270.866 152.693C270.593 152.765 270.325 152.851 270.06 152.948C269.805 153.039 269.554 153.144 269.306 153.256C268.805 153.486 268.32 153.756 267.862 154.067C267.743 154.148 267.628 154.23 267.514 154.317C267.416 154.393 267.318 154.47 267.225 154.55C267.154 154.607 267.089 154.663 267.023 154.724L267.023 154.726C266.925 154.812 266.831 154.903 266.739 154.998C266.246 154.974 265.754 154.945 265.266 154.902C264.092 154.8 262.925 154.629 261.787 154.353C261.219 154.219 260.66 154.046 260.108 153.85C259.854 153.764 259.609 153.656 259.361 153.558C259.839 153.521 260.314 153.463 260.783 153.381C260.917 153.358 261.05 153.332 261.181 153.306C261.224 153.298 261.267 153.29 261.308 153.281L261.31 153.281C261.472 153.247 261.629 153.211 261.788 153.171C261.922 153.14 262.053 153.105 262.185 153.071C262.187 153.072 262.188 153.071 262.19 153.071C262.743 152.921 263.287 152.744 263.822 152.543C263.914 152.51 264.004 152.474 264.094 152.437C264.728 152.188 265.347 151.897 265.949 151.571C266.116 151.529 266.281 151.488 266.445 151.441L266.613 151.388C266.618 151.386 266.623 151.385 266.627 151.384L267.276 151.178C267.954 151.015 268.632 150.892 269.313 150.793L269.322 150.792C269.844 150.714 270.366 150.648 270.892 150.584C271.529 150.515 272.167 150.429 272.808 150.343C273.45 150.248 274.09 150.131 274.729 149.984C275.368 149.824 276 149.622 276.609 149.361C276.758 149.295 276.906 149.225 277.053 149.154C277.501 148.932 277.936 148.685 278.339 148.386C278.488 148.28 278.633 148.166 278.772 148.048C278.927 147.918 279.075 147.782 279.215 147.639C279.413 147.44 279.597 147.228 279.768 147.005C279.848 146.896 279.926 146.784 279.998 146.67C280.281 146.225 280.498 145.744 280.611 145.24C280.229 146.013 279.687 146.661 279.055 147.196C278.735 147.469 278.392 147.712 278.035 147.927C277.608 148.182 277.164 148.411 276.704 148.601C276.586 148.653 276.471 148.7 276.353 148.743C275.773 148.971 275.173 149.157 274.564 149.299C273.952 149.454 273.328 149.57 272.698 149.687C272.694 149.687 272.691 149.689 272.687 149.689C272.684 149.69 272.682 149.692 272.68 149.691C272.4 149.746 272.117 149.797 271.832 149.846C271.811 149.851 271.791 149.855 271.769 149.857C271.448 149.917 271.126 149.975 270.805 150.045C270.438 150.119 270.068 150.201 269.702 150.291L269.846 150.233C270.071 150.145 270.295 150.056 270.51 149.947L271.817 149.326L272.143 149.17L272.458 148.993L273.092 148.642C275.346 147.403 277.423 145.864 279.304 144.109C279.418 144.007 279.527 143.904 279.635 143.798C279.997 143.454 280.351 143.103 280.694 142.744C280.803 142.632 280.908 142.521 281.015 142.408C281.015 142.408 281.016 142.407 281.018 142.405C281.122 142.296 281.224 142.184 281.323 142.073C281.555 141.825 281.779 141.572 282 141.318L282.347 140.884L282.904 140.182C283.05 139.991 283.21 139.81 283.346 139.609L283.76 139.013L284.173 138.417C284.309 138.219 284.457 138.025 284.574 137.815L285.319 136.57C285.581 136.161 285.777 135.718 286.001 135.29L286.33 134.644L286.493 134.321L286.634 133.987L287.2 132.652C287.285 132.458 287.358 132.258 287.43 132.057L287.458 131.974C287.543 131.749 287.62 131.521 287.694 131.289C288.3 129.456 288.728 127.556 288.859 125.628C288.873 125.401 288.884 125.173 288.889 124.945C288.892 124.839 288.894 124.732 288.895 124.625L288.896 124.623C288.897 124.577 288.895 124.533 288.895 124.486C288.898 123.965 288.878 123.442 288.832 122.922C288.828 122.868 288.825 122.816 288.818 122.763C288.784 122.404 288.737 122.049 288.68 121.696C288.612 121.298 288.53 120.903 288.426 120.51C288.407 120.43 288.386 120.351 288.364 120.27C288.364 120.27 288.364 120.268 288.363 120.267C288.332 120.149 288.295 120.031 288.259 119.911C288.295 120.067 288.331 120.22 288.364 120.377C288.364 120.379 288.364 120.384 288.366 120.386C288.387 120.495 288.41 120.606 288.428 120.715C288.5 121.092 288.556 121.471 288.599 121.853C288.642 122.232 288.672 122.613 288.689 122.996L288.688 122.998C288.707 123.441 288.707 123.883 288.691 124.324C288.688 124.443 288.683 124.561 288.674 124.678C288.673 124.729 288.672 124.775 288.668 124.824L288.667 124.826C288.651 125.085 288.628 125.345 288.601 125.605C288.476 126.914 288.212 128.204 287.852 129.467C287.822 129.28 287.793 129.091 287.77 128.902L287.768 128.888C287.717 128.441 287.683 127.993 287.68 127.546C287.669 127.097 287.692 126.648 287.732 126.199C287.753 125.976 287.779 125.754 287.81 125.531L287.811 125.529C287.817 125.474 287.824 125.424 287.832 125.37C287.857 125.195 287.884 125.02 287.911 124.844C287.797 125.063 287.706 125.29 287.629 125.525C287.607 125.587 287.587 125.651 287.569 125.715C287.526 125.862 287.49 126.01 287.459 126.159C287.363 126.614 287.324 127.083 287.327 127.55C287.338 128.017 287.388 128.485 287.498 128.938C287.535 129.092 287.579 129.246 287.628 129.396C287.669 129.522 287.716 129.648 287.766 129.77C287.627 130.236 287.475 130.699 287.309 131.158C287.232 131.381 287.148 131.605 287.059 131.825C286.973 132.048 286.889 132.272 286.787 132.487L286.212 133.793L286.069 134.121L285.905 134.436L285.574 135.069C285.346 135.487 285.148 135.92 284.885 136.319L284.144 137.539C284.129 137.565 284.112 137.591 284.096 137.617C284.139 137.337 284.184 137.056 284.23 136.777C284.267 136.541 284.308 136.309 284.347 136.074C284.582 134.721 284.846 133.376 285.104 132.025L285.107 132.018C285.111 131.994 285.116 131.966 285.12 131.942C285.141 131.833 285.16 131.724 285.181 131.616L285.181 131.614C285.191 131.569 285.199 131.521 285.208 131.476C285.224 131.393 285.239 131.309 285.255 131.227C285.398 130.486 285.528 129.741 285.646 128.993C285.709 128.617 285.766 128.238 285.822 127.86C285.871 127.512 285.914 127.163 285.955 126.815L285.956 126.813C285.962 126.758 285.966 126.704 285.972 126.65C285.974 126.644 285.973 126.64 285.975 126.634C286.012 126.287 286.046 125.938 286.074 125.59L286.075 125.588C286.081 125.535 286.084 125.484 286.088 125.43C286.089 125.407 286.091 125.385 286.094 125.363C286.116 125.057 286.136 124.749 286.152 124.443C286.191 123.45 286.178 122.454 286.095 121.46C286.083 121.306 286.068 121.15 286.052 120.994C286.044 120.922 286.035 120.849 286.025 120.776C285.998 120.533 285.964 120.288 285.927 120.045C285.935 120.04 285.946 120.033 285.952 120.027C285.981 119.999 285.991 119.964 286.004 119.931L286.044 119.829L286.201 119.424C286.294 119.151 286.381 118.874 286.469 118.597C286.545 118.318 286.613 118.036 286.681 117.754C286.737 117.47 286.786 117.184 286.838 116.901C286.927 116.285 286.98 115.665 287.005 115.048C287.189 114.868 287.374 114.692 287.563 114.524C287.902 114.226 288.251 113.943 288.618 113.687C288.862 113.513 289.108 113.349 289.366 113.194L289.368 113.193C289.372 113.19 289.374 113.189 289.379 113.186C289.503 113.109 289.63 113.035 289.756 112.963C289.92 112.871 290.088 112.782 290.257 112.695L290.26 112.694C290.267 112.692 290.272 112.689 290.279 112.686C290.506 112.568 290.738 112.455 290.973 112.343C290.755 112.37 290.538 112.415 290.325 112.476C290.318 112.476 290.313 112.478 290.307 112.478L290.304 112.479C290.076 112.543 289.854 112.624 289.634 112.717C289.583 112.737 289.533 112.76 289.483 112.782C289.481 112.784 289.478 112.785 289.473 112.787C289.103 112.956 288.748 113.164 288.414 113.399C288.035 113.672 287.681 113.981 287.371 114.329C287.242 114.472 287.123 114.62 287.008 114.774C287.013 114.548 287.015 114.323 287.013 114.097C287.011 113.879 287.007 113.661 286.996 113.442C286.994 113.4 286.992 113.357 286.988 113.315C286.945 112.565 286.858 111.817 286.72 111.08C286.715 111.051 286.711 111.022 286.704 110.993L286.705 110.991C286.699 110.953 286.691 110.916 286.683 110.878C286.719 110.7 286.759 110.523 286.803 110.348L286.806 110.341C286.829 110.244 286.853 110.149 286.88 110.055C286.915 109.922 286.954 109.79 286.996 109.659C287.126 109.229 287.286 108.81 287.462 108.395C287.641 107.981 287.841 107.574 288.052 107.161C287.724 107.487 287.447 107.867 287.216 108.272C286.983 108.676 286.799 109.109 286.66 109.553C286.603 109.742 286.553 109.933 286.512 110.126C286.505 110.096 286.501 110.067 286.493 110.039L286.26 109.213L285.986 108.4L285.667 107.606L285.594 107.45L285.587 107.435L285.305 106.832L285.512 107.443L285.525 107.481L285.579 107.639L285.815 108.454L286.018 109.276L286.182 110.104C286.208 110.249 286.227 110.395 286.25 110.542C286.09 109.964 285.856 109.407 285.553 108.887C285.355 108.553 285.131 108.235 284.882 107.938C284.85 107.898 284.817 107.859 284.782 107.819C284.751 107.786 284.722 107.75 284.691 107.718C284.642 107.663 284.594 107.613 284.544 107.562C284.423 107.438 284.298 107.319 284.169 107.204C283.624 106.725 282.997 106.332 282.322 106.088C282.932 106.466 283.488 106.905 283.98 107.404C284.051 107.477 284.122 107.552 284.19 107.629C284.236 107.678 284.282 107.73 284.325 107.781C284.377 107.839 284.427 107.896 284.475 107.957C284.508 107.996 284.54 108.037 284.572 108.077C284.822 108.389 285.048 108.72 285.249 109.066C285.606 109.665 285.882 110.313 286.081 110.984C286.203 111.399 286.29 111.823 286.348 112.254L286.35 112.257C286.35 112.274 286.353 112.29 286.355 112.307C286.381 112.495 286.397 112.684 286.409 112.876C286.408 112.877 286.407 112.879 286.409 112.882C286.412 112.925 286.414 112.968 286.416 113.011C286.417 113.033 286.419 113.052 286.42 113.073C286.434 112.984 286.447 112.893 286.457 112.802C286.462 113.019 286.469 113.238 286.465 113.454C286.461 113.823 286.446 114.193 286.42 114.561C286.408 114.728 286.393 114.893 286.378 115.058C286.364 114.965 286.35 114.873 286.329 114.78C286.322 114.729 286.311 114.679 286.299 114.629C286.299 114.629 286.3 114.627 286.299 114.624C286.274 114.506 286.246 114.389 286.214 114.275C286.208 114.254 286.203 114.233 286.197 114.214C286.197 114.212 286.195 114.212 286.196 114.21C286.152 114.051 286.101 113.895 286.045 113.74C286.04 113.73 286.038 113.719 286.033 113.709C285.891 113.323 285.715 112.949 285.508 112.593C285.38 112.378 285.242 112.171 285.091 111.971C284.807 111.584 284.484 111.227 284.124 110.911C283.578 110.431 282.952 110.039 282.276 109.794C282.887 110.172 283.442 110.611 283.934 111.111C284.424 111.613 284.852 112.168 285.203 112.772C285.295 112.926 285.381 113.084 285.461 113.243C285.634 113.583 285.781 113.935 285.905 114.294C285.91 114.306 285.915 114.316 285.917 114.327C285.96 114.448 285.998 114.568 286.033 114.69C286.053 114.756 286.072 114.821 286.085 114.887C286.085 114.887 286.087 114.888 286.086 114.89C286.094 114.911 286.099 114.932 286.104 114.953C286.179 115.244 286.236 115.54 286.282 115.838C286.236 116.152 286.186 116.466 286.125 116.778C286.068 117.05 286.007 117.322 285.955 117.595C285.889 117.865 285.821 118.134 285.761 118.404C285.731 118.509 285.704 118.616 285.674 118.721C285.639 118.567 285.603 118.416 285.563 118.263C285.559 118.241 285.553 118.22 285.547 118.197L285.547 118.195C285.495 117.997 285.44 117.801 285.379 117.605C285.375 117.593 285.372 117.582 285.368 117.57C285.342 117.481 285.314 117.391 285.282 117.302C285.281 117.292 285.278 117.278 285.271 117.265L285.27 117.262C284.952 116.278 284.531 115.33 284.005 114.442C283.412 113.457 282.686 112.55 281.823 111.806C283.338 113.511 284.306 115.591 284.85 117.752C284.909 117.994 284.965 118.235 285.013 118.477C285.018 118.493 285.022 118.507 285.023 118.523C285.038 118.589 285.052 118.657 285.065 118.725C285.143 119.118 285.21 119.514 285.262 119.912L285.263 119.914C285.269 119.946 285.272 119.978 285.274 120.009C285.322 120.358 285.359 120.706 285.387 121.057C285.391 121.107 285.395 121.154 285.397 121.204C285.406 121.282 285.412 121.363 285.417 121.44C285.427 121.578 285.436 121.718 285.441 121.857C285.471 122.4 285.481 122.943 285.474 123.486C285.41 123.342 285.346 123.198 285.283 123.053C285.206 122.879 285.13 122.705 285.054 122.529C285.006 122.418 284.959 122.305 284.913 122.194C284.906 122.179 284.9 122.165 284.893 122.149L284.892 122.147C284.782 121.881 284.672 121.616 284.565 121.347C284.535 121.275 284.505 121.202 284.476 121.128C284.473 121.119 284.468 121.109 284.464 121.097L284.464 121.095C284.377 120.879 284.294 120.663 284.212 120.445C283.94 119.746 283.692 119.041 283.45 118.329C283.268 117.792 283.095 117.252 282.92 116.709C282.905 116.662 282.889 116.612 282.874 116.564C282.832 116.436 282.791 116.31 282.749 116.182C282.773 116.376 282.801 116.568 282.831 116.76C282.846 116.845 282.859 116.928 282.874 117.013C282.96 117.481 283.064 117.947 283.186 118.408C283.376 119.142 283.613 119.862 283.881 120.57C284.024 120.942 284.175 121.308 284.341 121.673L284.343 121.676C284.344 121.684 284.349 121.695 284.355 121.705C284.395 121.797 284.437 121.89 284.483 121.982C284.585 122.205 284.693 122.427 284.807 122.646L284.808 122.648L284.81 122.649C284.817 122.664 284.822 122.676 284.83 122.689C284.97 122.964 285.118 123.232 285.273 123.499C285.337 123.607 285.401 123.716 285.466 123.822C285.461 124.019 285.457 124.215 285.446 124.411C285.428 124.906 285.394 125.402 285.355 125.899C285.349 125.951 285.346 126.005 285.341 126.06C285.336 126.101 285.332 126.141 285.33 126.183C285.304 126.479 285.272 126.776 285.241 127.073C285.234 127.129 285.227 127.186 285.221 127.24C285.216 127.298 285.209 127.354 285.202 127.411C285.189 127.533 285.175 127.652 285.16 127.774C285.035 128.894 284.863 130.015 284.714 131.138C284.648 131.614 284.581 132.092 284.517 132.572C284.509 132.613 284.505 132.652 284.501 132.693L284.5 132.694C284.455 133.03 284.412 133.367 284.371 133.705C284.369 133.717 284.368 133.727 284.368 133.74C284.366 133.751 284.364 133.768 284.364 133.78L284.363 133.784C284.244 134.765 284.148 135.747 284.094 136.732C284.088 136.823 284.084 136.914 284.08 137.005C284.069 137.231 284.062 137.456 284.056 137.682C283.958 137.835 283.849 137.98 283.746 138.13L283.335 138.714L282.926 139.299C282.792 139.496 282.633 139.673 282.489 139.861L281.595 140.975C281.486 141.1 281.376 141.223 281.266 141.345C281.059 141.577 280.85 141.806 280.641 142.036L280.163 142.566L279.835 142.886L279.663 143.054C279.669 143.024 279.675 142.993 279.683 142.964C279.689 142.936 279.694 142.909 279.7 142.884C279.739 142.705 279.778 142.531 279.816 142.355C279.83 142.29 279.844 142.227 279.858 142.163L279.86 142.155C279.907 141.954 279.951 141.753 280 141.553L280.001 141.549C280.011 141.495 280.023 141.443 280.035 141.39L280.036 141.388C280.1 141.118 280.165 140.845 280.233 140.576C280.315 140.236 280.405 139.899 280.497 139.559C280.51 139.503 280.526 139.445 280.543 139.39C280.577 139.263 280.611 139.134 280.647 139.007C280.789 138.485 280.941 137.963 281.081 137.432C280.804 137.907 280.58 138.409 280.383 138.922C280.214 139.36 280.073 139.808 279.951 140.263C279.936 140.319 279.921 140.375 279.908 140.43L279.907 140.433C279.901 140.452 279.896 140.472 279.891 140.491C279.796 140.881 279.714 141.276 279.653 141.672C279.641 141.736 279.632 141.8 279.624 141.863C279.616 141.912 279.609 141.961 279.603 142.009L279.603 142.011C279.598 142.043 279.595 142.076 279.59 142.108C279.58 142.191 279.57 142.276 279.562 142.359C279.557 142.416 279.551 142.475 279.546 142.533C279.531 142.705 279.519 142.877 279.512 143.05C279.511 143.058 279.511 143.064 279.511 143.072C279.508 143.118 279.507 143.162 279.506 143.208C279.503 143.211 279.5 143.212 279.499 143.216C279.496 143.217 279.494 143.218 279.493 143.22C279.382 143.329 279.27 143.438 279.159 143.546L279.156 143.548C278.983 143.719 278.805 143.892 278.627 144.059L278.453 144.209C278.441 144.218 278.431 144.229 278.419 144.24L278.231 144.4L277.875 144.709L277.869 144.713L277.545 144.992C277.364 145.144 277.193 145.31 277.002 145.455L276.434 145.888L275.867 146.321C275.675 146.463 275.493 146.617 275.291 146.745C275.11 146.865 274.929 146.986 274.748 147.108C274.792 147.004 274.835 146.899 274.88 146.794C274.971 146.573 275.064 146.353 275.155 146.134C275.227 145.964 275.298 145.794 275.372 145.625C275.401 145.557 275.429 145.491 275.458 145.425C275.482 145.366 275.509 145.308 275.535 145.25C275.583 145.138 275.631 145.028 275.68 144.919C275.71 144.851 275.739 144.783 275.771 144.717C275.781 144.693 275.791 144.671 275.801 144.647C275.842 144.556 275.884 144.465 275.924 144.374C276.045 144.109 276.169 143.844 276.295 143.582C276.357 143.446 276.422 143.313 276.486 143.177C276.59 142.962 276.695 142.746 276.799 142.531C276.934 142.258 277.065 141.983 277.195 141.706C276.839 142.124 276.528 142.577 276.245 143.047C276.23 143.073 276.214 143.099 276.199 143.126C276.065 143.346 275.941 143.571 275.822 143.799C275.703 144.032 275.588 144.266 275.481 144.502C275.473 144.521 275.464 144.541 275.457 144.559C275.405 144.674 275.357 144.788 275.31 144.904C275.281 144.97 275.254 145.037 275.228 145.103C275.17 145.247 275.115 145.393 275.064 145.539L275.056 145.564C275.032 145.627 275.01 145.689 274.989 145.756L274.989 145.758C274.956 145.852 274.925 145.946 274.897 146.04C274.805 146.336 274.722 146.636 274.656 146.937C274.634 147.029 274.616 147.119 274.597 147.21C274.039 147.587 273.478 147.963 272.889 148.291L272.272 148.655L271.965 148.837L271.646 148.998L270.37 149.646C270.159 149.761 269.94 149.853 269.72 149.945L269.062 150.227C268.623 150.414 268.189 150.615 267.735 150.763L266.704 151.136C267.425 150.695 268.113 150.201 268.75 149.645C268.837 149.57 268.925 149.495 269.009 149.417C269.927 148.61 270.806 147.763 271.646 146.877C271.715 146.804 271.786 146.729 271.854 146.654L271.856 146.653C271.921 146.581 271.988 146.511 272.051 146.438C272.106 146.384 272.157 146.328 272.206 146.271C272.279 146.193 272.35 146.112 272.419 146.033C272.587 145.847 272.752 145.658 272.914 145.468C272.949 145.427 272.985 145.385 273.021 145.342C273.155 145.187 273.288 145.029 273.418 144.867C273.437 144.846 273.456 144.823 273.473 144.8C274.419 143.645 275.294 142.432 276.085 141.167C276.185 141.005 276.286 140.847 276.388 140.686C276.882 140.314 277.347 139.896 277.776 139.453C278.359 138.853 278.89 138.205 279.383 137.536C279.558 137.297 279.73 137.058 279.896 136.814C280.441 136.026 280.943 135.216 281.442 134.408C281.527 134.268 281.613 134.128 281.699 133.989C281.796 133.831 281.893 133.673 281.992 133.516L281.993 133.512C282.021 133.469 282.047 133.425 282.074 133.382L282.075 133.38C282.535 132.638 282.998 131.897 283.481 131.159C283.185 131.425 282.904 131.702 282.634 131.994L282.633 131.996C282.627 132.002 282.62 132.011 282.613 132.017C282.127 132.545 281.674 133.109 281.245 133.68C280.571 134.577 279.941 135.5 279.315 136.414C279.106 136.717 278.896 137.019 278.685 137.319C278.679 137.331 278.671 137.341 278.663 137.351C278.243 137.943 277.818 138.526 277.365 139.089C277.324 139.142 277.279 139.192 277.236 139.245L277.384 138.98L277.512 138.751C277.624 138.546 277.746 138.346 277.848 138.137L278.153 137.506C278.356 137.085 278.566 136.667 278.762 136.242L279.306 134.953C279.395 134.737 279.492 134.524 279.574 134.306L279.811 133.647C279.97 133.209 280.134 132.771 280.285 132.331L280.684 130.991C280.739 130.801 280.801 130.612 280.854 130.422C280.864 130.387 280.871 130.354 280.881 130.319L281.045 129.641L281.098 129.416L281.368 128.284L281.4 128.118C281.426 128.074 281.452 128.028 281.482 127.984C281.729 127.606 281.986 127.24 282.273 126.893C282.553 126.544 282.857 126.213 283.175 125.892C283.29 125.778 283.407 125.667 283.523 125.556C283.525 125.556 283.526 125.554 283.526 125.554C283.532 125.548 283.539 125.542 283.545 125.536C283.751 125.344 283.963 125.154 284.179 124.966C283.981 125.049 283.791 125.147 283.608 125.256C283.602 125.261 283.595 125.264 283.587 125.268C283.381 125.395 283.181 125.534 282.991 125.687C282.623 125.977 282.294 126.311 281.999 126.672C281.837 126.875 281.686 127.086 281.549 127.306L281.623 126.912C281.662 126.682 281.705 126.454 281.743 126.225L281.829 125.533L281.885 125.079L281.886 125.077L281.903 124.931L281.952 124.535L281.972 124.367L281.998 124.151L282.093 122.762L282.135 122.067L282.139 121.6L282.141 121.371L282.149 119.982L282.053 121.368L282.005 122.059L281.919 122.745L281.836 123.434L281.753 124.119L281.677 124.544L281.647 124.715L281.647 124.717L281.548 125.281L281.52 125.442L281.512 125.481L281.392 126.162L281.354 126.326L281.237 126.835L280.928 128.181L280.637 129.209C280.624 128.583 280.605 127.958 280.58 127.334C280.568 126.995 280.553 126.657 280.538 126.319C280.537 126.296 280.535 126.272 280.535 126.248C280.534 126.227 280.533 126.205 280.532 126.184C280.521 125.942 280.509 125.702 280.496 125.462L280.497 125.46C280.494 125.413 280.492 125.364 280.489 125.316C280.43 124.164 280.358 123.017 280.27 121.862C280.257 121.718 280.245 121.575 280.231 121.433C280.19 121.004 280.143 120.575 280.085 120.147C280.085 120.134 280.083 120.123 280.079 120.109C280.062 119.959 280.04 119.809 280.016 119.659C280.01 119.617 280.001 119.574 279.993 119.531C279.989 119.506 279.985 119.482 279.979 119.457C279.979 119.444 279.975 119.43 279.972 119.416C279.939 119.224 279.901 119.03 279.861 118.836C280.003 118.393 280.11 117.937 280.192 117.477C280.232 117.244 280.265 117.009 280.292 116.774C280.294 116.762 280.295 116.752 280.297 116.742C280.356 116.213 280.38 115.682 280.37 115.152C280.368 115.023 280.363 114.893 280.357 114.764L280.357 114.762C280.356 114.736 280.356 114.713 280.352 114.687C280.35 114.637 280.347 114.592 280.343 114.542L280.344 114.54C280.342 114.508 280.341 114.476 280.337 114.445C280.337 114.443 280.338 114.441 280.337 114.439C280.325 114.279 280.31 114.122 280.291 113.964C280.249 113.585 280.188 113.21 280.109 112.837C280.018 112.414 279.905 111.996 279.765 111.586L279.764 111.584C279.746 111.531 279.727 111.476 279.706 111.423C279.669 111.321 279.633 111.22 279.588 111.119L279.587 111.116C279.566 111.06 279.542 111.003 279.516 110.948C279.483 110.869 279.448 110.792 279.41 110.715C279.398 110.688 279.384 110.66 279.371 110.632C279.374 110.667 279.377 110.7 279.38 110.732L279.38 110.734C279.384 110.812 279.391 110.89 279.398 110.966C279.403 111.027 279.408 111.085 279.413 111.144C279.421 111.259 279.432 111.374 279.443 111.487C279.447 111.543 279.453 111.6 279.458 111.657L279.458 111.659C279.467 111.795 279.48 111.927 279.493 112.062C279.494 112.082 279.497 112.104 279.499 112.124C279.521 112.388 279.542 112.65 279.56 112.913C279.59 113.33 279.614 113.745 279.632 114.162C279.641 114.361 279.65 114.562 279.653 114.763C279.658 114.896 279.662 115.03 279.664 115.163C279.668 115.299 279.669 115.436 279.668 115.571C279.67 115.597 279.672 115.623 279.671 115.648L279.671 115.65C279.672 115.829 279.672 116.01 279.671 116.191C279.67 116.204 279.67 116.216 279.67 116.229C279.669 116.349 279.667 116.468 279.665 116.589C279.665 116.634 279.665 116.676 279.662 116.719C279.66 116.952 279.653 117.184 279.644 117.416C279.638 117.562 279.633 117.705 279.626 117.85C279.593 117.729 279.559 117.606 279.519 117.485C279.474 117.334 279.426 117.187 279.372 117.04L279.373 117.038C279.374 117.036 279.371 117.033 279.371 117.033C279.334 116.925 279.295 116.819 279.252 116.712C279.239 116.676 279.223 116.637 279.207 116.599C279.206 116.59 279.203 116.581 279.197 116.573C279.191 116.554 279.182 116.536 279.174 116.518C279.022 116.143 278.847 115.779 278.646 115.429C278.622 115.387 278.596 115.347 278.572 115.309C278.459 115.116 278.34 114.934 278.211 114.756C278.115 114.622 278.017 114.493 277.91 114.368L277.908 114.367C277.9 114.354 277.893 114.345 277.883 114.335C277.861 114.304 277.834 114.276 277.81 114.249C277.794 114.228 277.776 114.207 277.759 114.191C277.605 114.015 277.443 113.85 277.271 113.695C277.406 113.866 277.531 114.04 277.647 114.22C277.666 114.245 277.682 114.272 277.698 114.298C277.715 114.321 277.73 114.345 277.745 114.369C277.757 114.388 277.768 114.407 277.78 114.426C277.867 114.566 277.949 114.706 278.028 114.849C278.133 115.043 278.23 115.241 278.321 115.441C278.475 115.781 278.609 116.129 278.725 116.481C278.754 116.562 278.78 116.645 278.802 116.727C278.853 116.883 278.896 117.041 278.937 117.199C278.939 117.208 278.941 117.213 278.944 117.222L278.945 117.225C278.976 117.354 279.01 117.483 279.038 117.613C279.059 117.7 279.078 117.789 279.097 117.875C279.279 118.743 279.391 119.626 279.466 120.516C279.468 120.534 279.471 120.551 279.47 120.57C279.493 120.816 279.511 121.061 279.527 121.306C279.528 121.325 279.529 121.347 279.531 121.366C279.544 121.548 279.555 121.73 279.566 121.911L279.696 124.098C279.736 124.662 279.771 125.224 279.812 125.785C279.815 125.833 279.819 125.881 279.822 125.926C279.831 126.047 279.84 126.168 279.851 126.288C279.862 126.426 279.873 126.563 279.884 126.701C279.889 126.748 279.893 126.791 279.897 126.836L279.896 126.838C279.897 126.864 279.9 126.893 279.902 126.918C279.893 126.896 279.885 126.875 279.876 126.853C279.862 126.814 279.848 126.777 279.833 126.739C279.75 126.524 279.669 126.309 279.588 126.093C279.572 126.054 279.556 126.015 279.544 125.975C279.514 125.899 279.487 125.824 279.458 125.749C279.201 125.045 278.95 124.341 278.722 123.625C278.673 123.476 278.624 123.324 278.578 123.173L278.577 123.171C278.571 123.152 278.566 123.135 278.559 123.118C278.514 122.974 278.471 122.833 278.428 122.689L278.429 122.687C278.422 122.67 278.418 122.658 278.413 122.642C278.35 122.435 278.289 122.228 278.228 122.022L278.139 121.713C278.116 121.633 278.093 121.554 278.07 121.474C278.061 121.444 278.053 121.413 278.045 121.383C278.043 121.38 278.044 121.379 278.045 121.377C278.045 121.377 278.045 121.375 278.043 121.374C277.952 121.048 277.863 120.724 277.774 120.394C277.773 120.392 277.773 120.387 277.77 120.382C277.714 120.173 277.659 119.962 277.602 119.751C277.588 119.698 277.574 119.642 277.56 119.586C277.532 119.488 277.507 119.391 277.48 119.294C277.488 119.416 277.498 119.54 277.51 119.662C277.517 119.734 277.525 119.808 277.533 119.881C277.564 120.163 277.603 120.444 277.649 120.725C277.651 120.731 277.653 120.733 277.653 120.737L277.653 120.739C277.697 121.007 277.747 121.274 277.803 121.539C277.829 121.664 277.855 121.789 277.886 121.913C277.885 121.915 277.887 121.918 277.888 121.92C277.904 122.006 277.926 122.089 277.947 122.175C277.978 122.305 278.011 122.435 278.046 122.565C278.09 122.736 278.136 122.906 278.187 123.075C278.192 123.091 278.195 123.107 278.201 123.124C278.239 123.258 278.278 123.389 278.321 123.52C278.326 123.54 278.333 123.557 278.339 123.576L278.34 123.579C278.354 123.63 278.372 123.683 278.388 123.734C278.624 124.455 278.892 125.165 279.206 125.853C279.247 125.945 279.289 126.038 279.333 126.129C279.348 126.166 279.367 126.202 279.384 126.239C279.481 126.444 279.583 126.647 279.688 126.848C279.706 126.884 279.725 126.918 279.743 126.953C279.806 127.068 279.87 127.183 279.933 127.297C279.99 127.993 280.055 128.688 280.13 129.382C280.169 129.751 280.21 130.119 280.255 130.486C280.216 130.597 280.178 130.708 280.141 130.822L279.691 132.123C279.528 132.551 279.353 132.977 279.184 133.403L278.929 134.041C278.841 134.252 278.739 134.457 278.645 134.667L278.516 134.942C278.493 134.795 278.469 134.65 278.448 134.506C278.43 134.388 278.412 134.27 278.393 134.152C278.314 133.615 278.236 133.082 278.171 132.546C278.102 132.01 278.046 131.472 277.991 130.935C277.936 130.396 277.889 129.855 277.828 129.309C277.744 129.851 277.713 130.4 277.715 130.948C277.716 131.497 277.758 132.044 277.822 132.589C277.894 133.134 277.991 133.675 278.125 134.206C278.178 134.416 278.237 134.624 278.3 134.829C278.336 134.945 278.373 135.057 278.412 135.169L278.068 135.913C277.862 136.324 277.642 136.726 277.43 137.131L277.11 137.738C277.002 137.94 276.88 138.134 276.765 138.332L276.152 139.37L276.077 139.496L276.076 139.5L276.067 139.514C275.925 139.74 275.778 139.963 275.63 140.183C275.601 140.226 275.574 140.267 275.544 140.31L275.543 140.312C275.467 140.428 275.39 140.542 275.313 140.659L274.934 141.231C274.811 141.422 274.665 141.599 274.531 141.784L273.712 142.884C273.688 142.915 273.662 142.947 273.637 142.978C273.502 143.148 273.363 143.319 273.223 143.485C273.221 143.486 273.22 143.487 273.22 143.488C273.13 143.594 273.042 143.703 272.953 143.809C272.916 143.853 272.88 143.897 272.843 143.941C272.551 144.293 272.265 144.649 271.949 144.979L271.327 145.654L271.023 145.985C271.005 146.004 270.986 146.023 270.969 146.042L270.967 146.041C270.922 146.091 270.875 146.138 270.828 146.187C270.844 146.146 270.859 146.103 270.874 146.062C270.909 145.964 270.941 145.868 270.972 145.772C271.007 145.659 271.042 145.545 271.073 145.432C271.099 145.34 271.123 145.247 271.147 145.152C271.161 145.094 271.175 145.035 271.187 144.976C271.239 144.759 271.282 144.537 271.317 144.316C271.346 144.141 271.371 143.964 271.391 143.786C271.46 143.192 271.475 142.591 271.446 141.993C271.463 141.97 271.478 141.943 271.495 141.92L271.785 141.466L272.062 141.006L272.327 140.535C272.52 140.184 272.693 139.82 272.848 139.451C272.99 139.333 273.13 139.209 273.261 139.08C273.497 138.854 273.719 138.611 273.921 138.355C274.043 138.205 274.158 138.049 274.267 137.891C274.523 137.525 274.748 137.137 274.941 136.732L274.942 136.729C274.964 136.69 274.983 136.646 275.003 136.607C275.212 136.152 275.384 135.681 275.517 135.199C275.779 134.238 275.886 133.235 275.813 132.245C275.78 131.762 275.705 131.285 275.583 130.818C275.536 130.626 275.479 130.438 275.412 130.25C275.376 130.141 275.333 130.033 275.29 129.926C275.283 129.907 275.275 129.887 275.267 129.867L275.265 129.865C275.199 129.711 275.131 129.561 275.053 129.414C275.113 129.747 275.159 130.079 275.195 130.409C275.195 130.414 275.196 130.418 275.196 130.422L275.194 130.424C275.193 130.425 275.194 130.426 275.195 130.426C275.203 130.484 275.21 130.541 275.214 130.597C275.229 130.737 275.239 130.877 275.247 131.017C275.274 131.433 275.278 131.845 275.265 132.255C275.234 132.938 275.152 133.613 275.014 134.277C274.995 134.367 274.974 134.459 274.954 134.548L274.952 134.552C274.918 134.707 274.879 134.861 274.837 135.013C274.616 135.826 274.309 136.614 273.923 137.369C273.883 137.448 273.843 137.527 273.801 137.605C273.621 137.934 273.426 138.256 273.216 138.57C273.189 138.61 273.164 138.647 273.137 138.687C273.152 138.643 273.169 138.603 273.182 138.559C273.192 138.53 273.201 138.502 273.209 138.473C273.422 137.818 273.587 137.147 273.706 136.47C273.829 135.763 273.903 135.047 273.886 134.327C273.652 135.008 273.44 135.681 273.218 136.347L273.184 136.445C272.972 137.079 272.748 137.703 272.517 138.326L271.913 139.94L271.837 140.146L271.836 140.149L271.784 140.287L271.598 140.781L271.591 140.8L271.498 141.033L271.403 141.269L271.391 141.297C271.39 141.284 271.39 141.271 271.388 141.258C271.386 141.234 271.384 141.21 271.379 141.187L271.38 141.185C271.376 141.152 271.372 141.121 271.364 141.089C271.348 140.947 271.327 140.807 271.301 140.665C271.297 140.626 271.292 140.588 271.282 140.549C271.259 140.414 271.233 140.282 271.204 140.147C271.201 140.131 271.198 140.117 271.193 140.101C271.057 139.483 270.869 138.879 270.627 138.295C270.349 137.62 270.002 136.97 269.582 136.378C269.499 136.259 269.412 136.145 269.323 136.032C269.314 136.02 269.305 136.009 269.296 135.999C269.276 135.973 269.254 135.945 269.231 135.92C269.196 135.874 269.158 135.831 269.121 135.787C269.436 135.437 269.746 135.085 270.043 134.721C270.071 134.686 270.098 134.651 270.125 134.616L270.126 134.614C270.202 134.523 270.275 134.433 270.348 134.34C270.944 133.58 271.502 132.79 272.005 131.966C272.595 131.006 273.116 130 273.538 128.959C273.834 128.209 274.095 127.444 274.295 126.667C274.374 126.361 274.443 126.052 274.501 125.74C274.419 126 274.333 126.261 274.244 126.518C273.964 127.312 273.641 128.087 273.265 128.835C272.779 129.831 272.207 130.782 271.586 131.696C270.57 133.189 269.4 134.569 268.134 135.857C267.851 136.144 267.563 136.428 267.27 136.708C267.219 136.759 267.166 136.808 267.113 136.857C266.671 137.283 266.214 137.695 265.751 138.101C265.741 138.111 265.73 138.118 265.721 138.127L265.72 138.129C265.708 138.139 265.696 138.15 265.684 138.16C265.411 138.399 265.136 138.634 264.859 138.867C264.85 138.876 264.839 138.883 264.83 138.892C264.817 138.903 264.805 138.913 264.794 138.922C264.791 138.923 264.791 138.925 264.788 138.926C264.777 138.935 264.767 138.944 264.756 138.953C264.755 138.955 264.753 138.954 264.753 138.956C264.377 139.274 263.992 139.588 263.609 139.897C263.637 139.854 263.664 139.811 263.695 139.766L263.989 139.275L264.259 138.765C264.603 138.078 264.854 137.342 265.011 136.589L265.114 136.02L265.189 135.45L265.231 134.875C265.238 134.683 265.241 134.493 265.242 134.302C265.24 134.119 265.234 133.936 265.223 133.754C265.217 133.667 265.211 133.581 265.203 133.496C265.159 133.003 265.076 132.515 264.944 132.039C264.921 132.524 264.889 133.004 264.843 133.477C264.832 133.589 264.82 133.7 264.807 133.812C264.791 133.967 264.773 134.118 264.751 134.271C264.721 134.454 264.692 134.635 264.667 134.817L264.568 135.357L264.457 135.896L264.324 136.427C264.14 137.134 263.926 137.831 263.686 138.522L263.498 139.041L263.29 139.554C263.215 139.722 263.132 139.887 263.063 140.061C263.014 140.175 262.975 140.292 262.951 140.423C262.701 140.62 262.452 140.816 262.2 141.013L260.88 142.034C260.436 142.373 259.997 142.722 259.554 143.034C259.453 143.106 259.348 143.177 259.244 143.246C259.239 142.92 259.239 142.594 259.245 142.267C259.247 142.059 259.251 141.852 259.258 141.646C259.262 141.555 259.265 141.467 259.269 141.376L259.27 141.374C259.271 141.322 259.275 141.268 259.279 141.215C259.282 141.113 259.286 141.011 259.294 140.909L259.295 140.907C259.298 140.849 259.301 140.791 259.305 140.731C259.311 140.641 259.317 140.55 259.324 140.458C259.352 140.091 259.389 139.722 259.437 139.355L259.438 139.353C259.451 139.211 259.471 139.07 259.491 138.927C259.511 138.772 259.533 138.618 259.559 138.462C259.566 138.412 259.573 138.36 259.582 138.31C259.64 137.943 259.707 137.579 259.782 137.213L259.782 137.211C259.795 137.154 259.807 137.097 259.821 137.039C259.952 136.416 260.106 135.798 260.281 135.178C260.357 134.904 260.437 134.63 260.521 134.356C260.339 134.668 260.17 134.986 260.011 135.31C259.641 136.073 259.336 136.869 259.091 137.685C259.072 137.746 259.054 137.809 259.035 137.87L259.034 137.872C258.946 138.18 258.867 138.488 258.795 138.8C258.76 138.948 258.73 139.097 258.699 139.247C258.689 139.3 258.677 139.353 258.667 139.406L258.666 139.408C258.591 139.8 258.531 140.193 258.485 140.588C258.485 140.588 258.482 140.589 258.483 140.592C258.466 140.733 258.45 140.875 258.439 141.019C258.433 141.078 258.428 141.135 258.423 141.192C258.413 141.305 258.405 141.42 258.397 141.533L258.397 141.535C258.393 141.605 258.389 141.673 258.387 141.744C258.384 141.796 258.381 141.848 258.381 141.901C258.377 141.962 258.375 142.023 258.373 142.083C258.367 142.338 258.366 142.59 258.374 142.844C258.379 143.092 258.392 143.341 258.411 143.587L258.687 143.574C258.514 143.665 258.34 143.75 258.158 143.818C257.746 143.976 257.308 144.047 256.879 144.002C256.8 143.993 256.723 143.979 256.645 143.963L256.557 144.284L256.553 144.299C256.553 144.295 256.551 144.292 256.553 144.289C256.53 144.045 256.511 143.802 256.495 143.557C256.486 143.438 256.479 143.318 256.474 143.198C256.469 143.15 256.468 143.105 256.467 143.059C256.452 142.786 256.444 142.513 256.44 142.24L256.44 142.238C256.438 142.189 256.436 142.14 256.436 142.092C256.435 142.066 256.435 142.041 256.433 142.015L256.434 142.013C256.435 141.973 256.434 141.935 256.435 141.895C256.433 141.766 256.432 141.643 256.432 141.513L256.434 141.507C256.435 141.489 256.435 141.47 256.435 141.451C256.438 141.17 256.445 140.888 256.456 140.607C256.492 139.592 256.589 138.578 256.731 137.573C256.735 137.549 256.737 137.526 256.741 137.502C256.808 136.987 256.909 136.476 257.003 135.965C257.098 135.533 257.187 135.1 257.298 134.671C257.31 134.61 257.327 134.551 257.344 134.489C257.347 134.473 257.352 134.46 257.355 134.444C257.403 134.257 257.453 134.072 257.505 133.885C257.522 133.822 257.54 133.76 257.559 133.7C257.573 133.639 257.59 133.578 257.609 133.517L257.61 133.515C257.699 133.209 257.794 132.905 257.895 132.601C257.934 132.606 257.971 132.608 258.006 132.61C258.152 132.62 258.294 132.598 258.436 132.584C258.458 132.581 258.482 132.579 258.504 132.576C258.624 132.56 258.742 132.536 258.862 132.516C258.996 132.489 259.128 132.459 259.258 132.424C259.274 132.421 259.289 132.416 259.305 132.411L259.307 132.411C259.516 132.355 259.717 132.291 259.918 132.215C259.963 132.201 260.007 132.185 260.051 132.168L260.053 132.167C260.194 132.113 260.331 132.057 260.468 131.997C260.884 131.817 261.286 131.613 261.676 131.399C261.765 131.349 261.854 131.3 261.942 131.251C262.055 131.187 262.167 131.125 262.278 131.06C262.495 130.937 262.711 130.812 262.926 130.686C262.926 130.686 262.928 130.687 262.928 130.685C263.068 130.603 263.208 130.521 263.348 130.439C263.777 130.186 264.205 129.925 264.626 129.657C265.124 129.345 265.614 129.02 266.098 128.682C266.987 128.043 267.839 127.354 268.646 126.623C268.65 126.62 268.653 126.617 268.656 126.614C268.689 126.585 268.72 126.556 268.752 126.525L268.753 126.523C269.159 126.154 269.555 125.776 269.942 125.389C269.98 125.352 270.017 125.314 270.055 125.277C270.057 125.276 270.058 125.274 270.059 125.272C270.243 125.087 270.425 124.902 270.606 124.714C270.91 124.674 271.21 124.625 271.506 124.567C272.008 124.467 272.503 124.35 272.994 124.217C273.193 124.164 273.394 124.108 273.594 124.047C273.777 123.994 273.961 123.938 274.144 123.877C274.248 123.844 274.353 123.81 274.455 123.774C274.939 123.605 275.421 123.425 275.895 123.182C275.363 123.137 274.844 123.17 274.329 123.233C274.187 123.252 274.048 123.273 273.906 123.298C273.761 123.321 273.617 123.349 273.472 123.378C273.25 123.424 273.029 123.477 272.81 123.537C272.311 123.671 271.821 123.838 271.344 124.037L271.178 124.112C271.848 123.395 272.498 122.662 273.14 121.924C273.831 121.121 274.538 120.327 275.181 119.475C275.193 119.46 275.204 119.445 275.216 119.43C275.239 119.398 275.264 119.364 275.287 119.332C275.289 119.328 275.291 119.327 275.293 119.323C275.317 119.29 275.342 119.254 275.366 119.22C275.459 119.092 275.548 118.963 275.636 118.832C275.664 118.787 275.694 118.742 275.723 118.697C276.042 118.201 276.324 117.68 276.533 117.131C276.597 116.966 276.655 116.799 276.702 116.627C276.709 116.605 276.717 116.584 276.723 116.561C276.713 116.583 276.704 116.607 276.695 116.629C276.623 116.806 276.543 116.981 276.459 117.152C276.315 117.439 276.155 117.718 275.981 117.989C275.867 118.164 275.747 118.333 275.624 118.501C275.592 118.543 275.562 118.583 275.53 118.625L275.53 118.627C275.459 118.716 275.388 118.805 275.317 118.894C275.292 118.923 275.269 118.953 275.244 118.982C275.242 118.983 275.241 118.984 275.241 118.985C275.164 119.079 275.086 119.17 275.008 119.263C274.955 119.322 274.902 119.384 274.848 119.443C274.777 119.526 274.704 119.608 274.63 119.689C274.039 120.344 273.411 120.97 272.8 121.614C272.483 121.942 272.166 122.268 271.849 122.594L271.848 122.596C271.731 122.715 271.613 122.836 271.496 122.956C271.08 123.378 270.661 123.796 270.239 124.207L270.236 124.208C270.156 124.288 270.074 124.367 269.992 124.443C269.79 124.638 269.585 124.833 269.378 125.024C269.661 124.554 269.947 124.086 270.241 123.624C270.706 122.888 271.184 122.161 271.684 121.45C271.942 121.076 272.207 120.706 272.477 120.341C272.573 120.21 272.669 120.079 272.767 119.948C272.917 119.746 273.07 119.542 273.224 119.34C273.579 118.874 273.945 118.414 274.312 117.951C274.489 117.728 274.667 117.505 274.845 117.283C274.555 117.54 274.277 117.81 274.004 118.086C273.662 118.435 273.33 118.796 273.01 119.168C272.757 119.457 272.516 119.754 272.278 120.056C272.173 120.188 272.072 120.321 271.971 120.457C271.773 120.717 271.582 120.981 271.395 121.249C270.896 121.971 270.425 122.716 270.004 123.486C269.684 124.061 269.389 124.652 269.124 125.253C268.901 125.456 268.681 125.656 268.455 125.851C268.415 125.888 268.375 125.923 268.334 125.957C268.282 126.002 268.231 126.047 268.177 126.092C267.835 126.386 267.486 126.672 267.131 126.949C267.171 126.773 267.208 126.598 267.241 126.424C267.267 126.294 267.292 126.166 267.314 126.037C267.327 125.982 267.335 125.928 267.346 125.873C267.462 125.222 267.557 124.573 267.638 123.918C267.675 123.611 267.71 123.303 267.742 122.994C267.746 122.938 267.753 122.882 267.758 122.825C267.767 122.726 267.776 122.628 267.785 122.529C267.791 122.469 267.795 122.41 267.8 122.351C267.811 122.217 267.82 122.086 267.831 121.953C267.853 121.634 267.871 121.313 267.882 120.991C267.89 120.768 267.891 120.545 267.889 120.321C267.887 120.198 267.885 120.078 267.879 119.954C267.815 120.108 267.755 120.262 267.701 120.418C267.61 120.669 267.53 120.924 267.461 121.179L267.46 121.181C267.396 121.41 267.337 121.638 267.282 121.869C267.231 122.098 267.183 122.328 267.138 122.559C267.126 122.62 267.115 122.679 267.105 122.741C267.076 122.897 267.049 123.054 267.025 123.213C267.014 123.27 267.007 123.326 266.999 123.385C266.98 123.502 266.963 123.623 266.949 123.742C266.945 123.772 266.942 123.801 266.937 123.831C266.935 123.856 266.93 123.881 266.928 123.906C266.853 124.541 266.808 125.181 266.796 125.819C266.794 125.945 266.793 126.068 266.794 126.193C266.797 126.344 266.8 126.494 266.807 126.644C266.813 126.821 266.823 126.999 266.837 127.177C266.448 127.474 266.051 127.759 265.648 128.037C264.91 128.543 264.143 129.012 263.367 129.476C263.223 129.563 263.077 129.651 262.931 129.737C262.68 129.884 262.432 130.034 262.185 130.182C261.871 130.37 261.558 130.557 261.247 130.737L261.244 130.738C261.179 130.775 261.118 130.81 261.053 130.845C260.757 131.014 260.458 131.171 260.157 131.317C260.051 131.367 259.946 131.415 259.839 131.462C259.817 131.473 259.792 131.483 259.767 131.494C259.463 131.624 259.154 131.738 258.84 131.823C258.798 131.836 258.756 131.847 258.714 131.858C258.514 131.906 258.313 131.94 258.113 131.969C258.524 130.821 259.007 129.697 259.555 128.606C259.613 128.496 259.67 128.383 259.73 128.273C260.156 127.463 260.617 126.668 261.13 125.907C261.71 125.04 262.335 124.204 263.015 123.41C263.682 122.622 264.403 121.879 265.154 121.16C265.154 121.16 265.155 121.16 265.156 121.159C265.268 121.055 265.378 120.952 265.49 120.847C265.658 120.689 265.828 120.533 266.002 120.376L266.003 120.374C266.115 120.27 266.228 120.168 266.344 120.065C266.344 120.065 266.347 120.064 266.347 120.062C266.61 119.827 266.874 119.594 267.14 119.362L267.141 119.358C267.272 119.243 267.403 119.131 267.533 119.016C267.593 118.965 267.652 118.911 267.71 118.86C268.611 118.071 269.509 117.285 270.409 116.495C270.752 116.526 271.091 116.527 271.429 116.516C271.514 116.514 271.6 116.51 271.684 116.504C271.753 116.5 271.821 116.496 271.889 116.49C272.202 116.468 272.513 116.433 272.822 116.386C273.284 116.319 273.741 116.227 274.195 116.109C274.648 115.986 275.096 115.842 275.536 115.628C275.179 115.572 274.828 115.553 274.478 115.554C274.473 115.554 274.471 115.553 274.467 115.554C274.349 115.553 274.23 115.556 274.113 115.56C273.925 115.566 273.737 115.577 273.549 115.594C273.272 115.616 272.996 115.648 272.72 115.69C272.288 115.752 271.858 115.839 271.432 115.948C271.404 115.955 271.375 115.962 271.347 115.969C271.175 116.015 271.003 116.067 270.833 116.122C270.881 116.081 270.927 116.038 270.975 115.998C271.045 115.936 271.114 115.875 271.184 115.814C271.185 115.812 271.187 115.812 271.187 115.812C271.269 115.738 271.353 115.666 271.437 115.59C271.856 115.223 272.275 114.857 272.691 114.487C272.736 114.45 272.778 114.412 272.819 114.373C272.915 114.293 273.006 114.211 273.099 114.127C273.155 114.079 273.211 114.029 273.267 113.981C273.787 113.521 274.306 113.061 274.827 112.599L274.83 112.598C274.949 112.49 275.068 112.384 275.19 112.276C275.256 112.217 275.321 112.157 275.387 112.101C275.559 111.947 275.73 111.794 275.898 111.641C276.294 111.29 276.688 110.938 277.08 110.583C276.626 110.94 276.172 111.296 275.717 111.653C275.508 111.818 275.299 111.984 275.092 112.15C274.933 112.275 274.774 112.399 274.616 112.526C274.46 112.649 274.304 112.771 274.149 112.897C273.652 113.291 273.154 113.687 272.656 114.085C272.484 114.223 272.312 114.361 272.138 114.499C272.038 114.579 271.939 114.658 271.84 114.737C271.676 114.87 271.513 115.001 271.347 115.133C271.346 115.135 271.343 115.138 271.341 115.139C271.093 115.335 270.851 115.532 270.603 115.728C270.512 115.804 270.419 115.877 270.326 115.952C270.281 115.989 270.235 116.025 270.188 116.062C270.105 116.13 270.022 116.194 269.94 116.262L269.937 116.263C269.295 116.78 268.653 117.299 268.011 117.815C267.882 117.92 267.753 118.023 267.623 118.127C267.458 118.262 267.292 118.396 267.125 118.53C266.491 119.047 265.857 119.569 265.235 120.106C265.212 119.42 265.223 118.731 265.281 118.046C265.284 118 265.288 117.955 265.292 117.91C265.293 117.902 265.294 117.894 265.295 117.886C265.319 117.596 265.351 117.303 265.391 117.014C265.396 116.963 265.403 116.912 265.411 116.863C265.415 116.828 265.421 116.792 265.426 116.758C265.47 116.457 265.521 116.157 265.581 115.858C265.62 115.658 265.662 115.46 265.707 115.263C265.748 115.254 265.786 115.242 265.821 115.227L266.365 114.998C266.719 114.833 267.077 114.666 267.428 114.491C267.518 114.444 267.606 114.397 267.697 114.348C267.709 114.342 267.723 114.334 267.733 114.327C267.912 114.233 268.086 114.136 268.263 114.039C268.274 114.032 268.285 114.026 268.295 114.019L268.298 114.018C268.355 113.987 268.407 113.958 268.462 113.927C268.798 113.723 269.13 113.514 269.463 113.305C270.19 112.818 270.893 112.299 271.568 111.748C271.647 111.687 271.724 111.623 271.8 111.559C272.259 111.179 272.707 110.786 273.14 110.381C273.836 109.729 274.501 109.048 275.131 108.338C275.138 108.331 275.145 108.323 275.151 108.317C275.161 108.306 275.172 108.293 275.182 108.281C275.289 108.228 275.396 108.176 275.501 108.127C275.587 108.085 275.675 108.044 275.762 108.007C275.87 107.957 275.977 107.908 276.085 107.864C276.185 107.82 276.283 107.779 276.382 107.741C276.382 107.741 276.384 107.742 276.385 107.74C276.75 107.591 277.116 107.459 277.488 107.341C277.685 107.277 277.884 107.218 278.085 107.163C278.522 107.043 278.966 106.942 279.415 106.862C279.58 106.831 279.745 106.804 279.911 106.779C279.994 106.766 280.076 106.754 280.16 106.743C280.865 106.647 281.581 106.604 282.322 106.575C281.683 106.334 281.001 106.222 280.316 106.195C280.253 106.194 280.191 106.192 280.128 106.191C280.082 106.19 280.035 106.19 279.989 106.191C279.284 106.195 278.579 106.296 277.897 106.483C277.247 106.662 276.621 106.925 276.036 107.257C276.122 107.148 276.21 107.04 276.295 106.928L276.986 105.986L277.103 105.814L277.241 105.609L277.496 105.232L277.63 105.037L277.639 105.021L278.241 104.025C278.403 103.736 278.562 103.447 278.718 103.156C278.746 103.107 278.772 103.055 278.8 103.005C278.763 103.058 278.725 103.11 278.691 103.162C278.504 103.427 278.321 103.693 278.139 103.958L277.445 104.884L277.297 105.067L277.136 105.27L276.795 105.695L276.723 105.786L276.615 105.911L275.97 106.658C275.856 106.787 275.74 106.913 275.623 107.039C275.507 107.166 275.39 107.291 275.271 107.414C275.132 107.562 274.991 107.707 274.849 107.849C274.779 107.924 274.705 107.996 274.632 108.067C274.55 108.152 274.465 108.234 274.379 108.318L274.378 108.32C274.302 108.394 274.224 108.466 274.147 108.541C274.147 108.541 274.146 108.54 274.145 108.542C273.669 108.996 273.177 109.432 272.672 109.851C272.532 109.967 272.389 110.081 272.245 110.196C272.059 110.348 271.87 110.493 271.676 110.639L271.675 110.641C271.245 110.972 270.801 111.29 270.35 111.595C270.417 111.415 270.477 111.236 270.537 111.057C270.68 110.62 270.809 110.18 270.93 109.742C271.007 109.465 271.079 109.185 271.147 108.903C271.162 108.841 271.177 108.779 271.191 108.714C271.205 108.662 271.217 108.609 271.227 108.556C271.24 108.507 271.251 108.456 271.262 108.407C271.264 108.393 271.266 108.382 271.269 108.368C271.314 108.164 271.356 107.958 271.396 107.748L271.397 107.744C271.406 107.686 271.417 107.627 271.426 107.569C271.455 107.387 271.479 107.204 271.496 107.016C271.285 107.263 271.108 107.53 270.956 107.806C270.914 107.88 270.874 107.952 270.835 108.027C270.802 108.092 270.769 108.158 270.737 108.225C270.704 108.295 270.671 108.366 270.64 108.437C270.614 108.502 270.586 108.564 270.561 108.629C270.546 108.666 270.532 108.701 270.517 108.738C270.493 108.801 270.469 108.865 270.445 108.928C270.371 109.134 270.307 109.344 270.249 109.553C270.143 109.944 270.065 110.34 270.02 110.743C270.017 110.751 270.015 110.758 270.016 110.765C270.008 110.826 270.002 110.885 269.996 110.946C269.971 111.242 269.962 111.543 269.977 111.843C269.637 112.066 269.294 112.284 268.947 112.495C268.878 112.536 268.809 112.575 268.74 112.617C268.733 112.621 268.724 112.626 268.717 112.63C268.573 112.715 268.43 112.8 268.286 112.887C268.285 112.886 268.284 112.888 268.281 112.889C268.175 112.952 268.071 113.015 267.967 113.079C267.635 113.261 267.304 113.45 266.976 113.641C266.646 113.811 266.319 113.988 265.991 114.168C266.041 113.995 266.092 113.821 266.145 113.65C266.17 113.572 266.195 113.496 266.219 113.419C266.341 113.044 266.471 112.67 266.612 112.3C266.646 112.208 266.681 112.117 266.719 112.028C266.997 111.317 267.312 110.622 267.66 109.944C267.671 109.925 267.681 109.903 267.692 109.884L267.693 109.882C267.733 109.803 267.774 109.727 267.815 109.651C268.058 109.204 268.326 108.773 268.618 108.362L268.618 108.36C268.673 108.282 268.729 108.206 268.784 108.131C268.904 108.059 269.022 107.986 269.141 107.916C269.069 107.952 268.998 107.987 268.929 108.024C268.896 108.04 268.862 108.057 268.829 108.073C268.939 107.926 269.055 107.781 269.173 107.641C269.758 106.932 270.475 106.353 271.241 105.815C271.477 105.651 271.718 105.49 271.962 105.333C272.055 105.27 272.151 105.208 272.248 105.148C272.52 104.97 272.793 104.795 273.066 104.616C273.079 104.608 273.093 104.598 273.107 104.589C273.265 104.485 273.422 104.38 273.577 104.273C273.577 104.272 273.578 104.271 273.58 104.27L273.582 104.269C273.591 104.263 273.596 104.259 273.605 104.253C273.991 103.977 274.372 103.688 274.729 103.373C275.083 103.056 275.412 102.709 275.702 102.335C275.375 102.677 275.021 102.988 274.647 103.271C274.341 103.502 274.02 103.711 273.695 103.91C273.694 103.912 273.691 103.913 273.69 103.912C273.617 103.957 273.545 104.001 273.471 104.045C273.362 104.11 273.25 104.175 273.143 104.239C273.129 104.247 273.117 104.253 273.101 104.26C272.788 104.442 272.467 104.619 272.148 104.797C272.086 104.831 272.029 104.863 271.969 104.895C271.647 105.076 271.325 105.26 271.005 105.452C270.187 105.941 269.395 106.53 268.735 107.251C268.308 107.71 267.926 108.209 267.582 108.728C266.087 109.564 264.661 110.531 263.312 111.597C261.83 112.778 260.448 114.091 259.185 115.515C259.04 115.68 258.892 115.849 258.75 116.017C258.747 116.02 258.746 116.022 258.743 116.025C258.619 116.17 258.497 116.315 258.376 116.463C258.325 116.527 258.271 116.591 258.221 116.655C258.132 116.761 258.045 116.87 257.959 116.979C257.958 116.981 257.956 116.982 257.955 116.984C257.265 117.857 256.621 118.767 256.019 119.706C255.898 119.898 255.777 120.089 255.658 120.285C255.681 120.183 255.703 120.083 255.727 119.982C255.821 119.579 255.924 119.178 256.038 118.782C256.065 118.686 256.093 118.588 256.123 118.494L256.126 118.486C256.142 118.428 256.159 118.373 256.177 118.316L256.179 118.31C256.275 117.995 256.382 117.68 256.496 117.37C256.521 117.298 256.547 117.229 256.574 117.159C256.928 116.228 257.35 115.332 257.836 114.465L257.846 114.449C257.994 114.18 258.153 113.917 258.313 113.655C258.328 113.632 258.34 113.609 258.354 113.587C258.459 113.412 258.565 113.239 258.676 113.066C258.865 112.763 259.06 112.462 259.26 112.165C259.297 112.106 259.335 112.05 259.375 111.992C259.733 111.438 260.116 110.897 260.481 110.339C260.775 109.899 261.065 109.456 261.352 109.011C261.412 108.918 261.47 108.824 261.53 108.729C261.899 108.145 262.258 107.553 262.602 106.95C261.978 107.636 261.382 108.341 260.801 109.058C260.698 109.184 260.597 109.311 260.494 109.438C260.341 109.629 260.188 109.822 260.036 110.016C259.619 110.535 259.222 111.071 258.826 111.612C258.605 111.919 258.392 112.23 258.183 112.548C258.023 112.791 257.863 113.039 257.709 113.289C257.703 113.299 257.698 113.308 257.692 113.319C257.354 113.888 257.035 114.475 256.759 115.081C256.483 115.701 256.238 116.334 256.054 116.986C255.998 117.18 255.945 117.374 255.898 117.571C255.884 117.616 255.873 117.665 255.863 117.713C255.832 117.839 255.804 117.968 255.779 118.096C255.69 118.522 255.623 118.954 255.58 119.386C255.57 119.456 255.564 119.53 255.56 119.602C255.555 119.628 255.552 119.654 255.553 119.682C255.539 119.845 255.528 120.01 255.523 120.177C255.518 120.293 255.514 120.409 255.514 120.525C255.244 120.973 254.982 121.428 254.733 121.889C254.665 122.015 254.598 122.139 254.531 122.265C254.479 122.367 254.424 122.47 254.374 122.573L254.373 122.577C254.367 122.586 254.362 122.596 254.358 122.607C253.652 123.999 253.046 125.443 252.542 126.925C252.542 126.915 252.54 126.903 252.539 126.892C252.537 126.875 252.533 126.861 252.533 126.844L252.533 126.842C252.452 126.154 252.384 125.476 252.356 124.796C252.354 124.743 252.35 124.691 252.35 124.638C252.342 124.349 252.34 124.058 252.35 123.77C252.364 123.128 252.421 122.491 252.534 121.865C252.696 120.961 252.979 120.077 253.384 119.245C253.792 118.415 254.327 117.642 255.002 116.947C254.145 117.408 253.431 118.138 252.903 118.974C252.369 119.811 252.016 120.762 251.84 121.74C251.674 122.67 251.663 123.625 251.785 124.547C251.79 124.593 251.797 124.64 251.804 124.687C251.836 124.917 251.877 125.146 251.924 125.373C252.05 125.981 252.232 126.573 252.466 127.143L252.466 127.145C252.466 127.145 252.468 127.146 252.467 127.147L252.459 127.17C252.284 127.699 252.123 128.231 251.977 128.768L251.756 129.616L251.647 130.041L251.553 130.47C251.433 131.041 251.326 131.617 251.234 132.196C251.066 133.284 250.959 134.386 250.932 135.491C250.75 135.044 250.58 134.598 250.43 134.146C250.417 134.11 250.405 134.072 250.396 134.035C250.206 133.449 250.051 132.856 249.941 132.258C249.929 132.194 249.917 132.131 249.907 132.069C249.893 131.992 249.882 131.915 249.871 131.839C249.85 131.703 249.832 131.569 249.818 131.433C249.715 130.52 249.738 129.592 249.888 128.68C249.914 128.531 249.942 128.383 249.976 128.236C250.115 127.61 250.322 126.996 250.602 126.395C250.661 126.268 250.722 126.142 250.788 126.017C250.585 126.219 250.402 126.44 250.236 126.673C250.233 126.676 250.233 126.678 250.231 126.682C250.217 126.7 250.204 126.718 250.191 126.737C250.14 126.812 250.09 126.888 250.043 126.964C249.74 127.455 249.51 127.996 249.351 128.556C249.173 129.181 249.081 129.829 249.07 130.479C249.063 130.822 249.08 131.167 249.117 131.51C249.156 131.848 249.213 132.184 249.291 132.512C249.318 132.637 249.35 132.764 249.387 132.889C249.523 133.389 249.703 133.877 249.92 134.345C250.199 134.956 250.534 135.538 250.924 136.078C250.921 136.645 250.939 137.212 250.981 137.778C250.992 137.917 251.004 138.053 251.017 138.193L251.016 138.194C251.03 138.343 251.045 138.489 251.061 138.636C251.209 139.936 251.467 141.224 251.833 142.471C251.855 142.546 251.876 142.621 251.899 142.694C252.079 143.294 252.278 143.885 252.498 144.471C252.612 144.786 252.734 145.101 252.862 145.412C252.902 145.511 252.942 145.609 252.985 145.708C253.022 145.801 253.062 145.894 253.103 145.988C253.33 146.505 253.564 147.02 253.807 147.528C254.067 148.067 254.337 148.6 254.623 149.125C254.765 149.383 254.92 149.634 255.08 149.882C254.565 149.434 254.062 148.973 253.585 148.483C253.53 148.428 253.478 148.374 253.425 148.318L253.423 148.317C253.261 148.147 253.102 147.974 252.946 147.798C251.535 146.207 250.321 144.442 249.298 142.565C249.281 142.54 249.266 142.512 249.253 142.482L249.25 142.477C249.112 142.224 248.978 141.969 248.846 141.711C248.723 141.47 248.601 141.226 248.485 140.979C248.478 140.966 248.471 140.951 248.465 140.938C248.442 140.888 248.417 140.839 248.394 140.789C247.83 139.597 247.329 138.37 246.904 137.118C246.665 136.47 246.485 135.806 246.28 135.147C246.094 134.482 245.923 133.814 245.786 133.147C245.734 132.902 245.688 132.658 245.648 132.413C245.596 132.119 245.554 131.824 245.523 131.531C245.515 131.491 245.51 131.451 245.508 131.41C245.5 131.348 245.493 131.287 245.487 131.226L245.549 131.024L245.549 131.022L245.609 130.832L245.62 130.793C245.828 130.139 246.025 129.48 246.221 128.824C246.314 128.519 246.403 128.215 246.488 127.908C246.59 127.554 246.689 127.2 246.791 126.846L247.254 125.147L247.332 124.86C247.361 124.746 247.393 124.631 247.423 124.519L247.424 124.515C247.44 124.458 247.456 124.4 247.474 124.343C247.61 123.864 247.766 123.397 247.985 122.966C248.279 122.38 248.707 121.862 249.159 121.355C249.186 121.324 249.216 121.292 249.244 121.262C249.349 121.147 249.456 121.032 249.566 120.917C249.898 120.562 250.232 120.204 250.542 119.821C250.975 119.282 251.355 118.679 251.545 118.016C251.267 118.646 250.859 119.198 250.382 119.681C250.161 119.912 249.931 120.132 249.697 120.351C249.68 120.369 249.661 120.386 249.64 120.404C249.419 120.611 249.193 120.819 248.973 121.035C248.97 121.037 248.97 121.039 248.967 121.04C248.945 121.062 248.922 121.083 248.9 121.105C248.856 121.147 248.813 121.191 248.771 121.235C248.323 121.682 247.899 122.175 247.576 122.748C247.536 122.821 247.496 122.893 247.46 122.967C247.224 123.441 247.059 123.936 246.91 124.425C246.892 124.484 246.873 124.545 246.856 124.605L246.853 124.614C246.843 124.649 246.831 124.682 246.822 124.717L246.72 125.069L246.6 125.489L246.476 125.92L246.426 126.094L246.425 126.098L246.37 126.286L246.253 126.696C246.241 126.736 246.231 126.777 246.22 126.817C246.187 126.943 246.152 127.067 246.117 127.192C246.104 127.241 246.093 127.287 246.079 127.333C245.954 127.783 245.829 128.23 245.714 128.683C245.614 129.069 245.515 129.458 245.414 129.847C245.414 129.79 245.414 129.735 245.415 129.678C245.415 129.672 245.416 129.664 245.416 129.658C245.416 129.481 245.421 129.303 245.429 129.127C245.491 127.862 245.704 126.592 245.996 125.33C246.015 125.246 246.033 125.162 246.054 125.079C246.18 124.556 246.313 124.033 246.458 123.513C246.837 122.134 247.282 120.772 247.797 119.439L248.06 119.159C248.18 119.034 248.296 118.911 248.414 118.785L248.414 118.783C248.418 118.778 248.423 118.776 248.425 118.77C248.488 118.703 248.552 118.635 248.613 118.568C248.801 118.366 248.988 118.163 249.174 117.96C249.261 117.868 249.345 117.775 249.429 117.68C249.712 117.369 249.986 117.052 250.265 116.74L251.331 115.498C251.581 115.204 251.829 114.915 252.098 114.66C252.206 114.556 252.318 114.459 252.435 114.369C252.605 114.236 252.789 114.119 252.982 114.011C253.022 113.989 253.061 113.966 253.102 113.945C253.146 113.922 253.187 113.9 253.233 113.878C253.233 113.876 253.235 113.877 253.235 113.877C253.424 113.782 253.62 113.697 253.816 113.611C253.994 113.538 254.174 113.466 254.355 113.393C254.436 113.36 254.517 113.327 254.598 113.294C254.647 113.275 254.693 113.258 254.741 113.236L254.743 113.235C254.94 113.154 255.136 113.066 255.329 112.973C255.492 112.892 255.652 112.805 255.808 112.709C255.808 112.709 255.811 112.708 255.811 112.706C256.127 112.51 256.42 112.281 256.66 112.002C256.524 112.113 256.383 112.216 256.236 112.308C255.926 112.503 255.592 112.658 255.246 112.775C255.239 112.777 255.234 112.78 255.227 112.781C255.19 112.796 255.152 112.81 255.115 112.82C255.099 112.828 255.087 112.832 255.074 112.834L255.072 112.835C255.025 112.855 254.977 112.87 254.932 112.884C254.801 112.929 254.668 112.971 254.534 113.013C254.266 113.095 253.998 113.174 253.727 113.262C253.727 113.262 253.726 113.261 253.725 113.263C253.713 113.267 253.703 113.27 253.691 113.275C253.658 113.286 253.622 113.297 253.588 113.311C253.447 113.359 253.305 113.411 253.165 113.467C252.882 113.582 252.6 113.718 252.332 113.883C252.274 113.918 252.217 113.955 252.161 113.995C251.687 114.328 251.304 114.747 250.935 115.149L249.845 116.372C249.49 116.787 249.126 117.193 248.78 117.615C248.759 117.639 248.74 117.662 248.719 117.686L248.708 117.701C248.575 117.858 248.443 118.016 248.312 118.175C248.452 117.851 248.595 117.53 248.743 117.21C248.818 117.049 248.895 116.888 248.972 116.729L248.973 116.725C248.979 116.715 248.985 116.702 248.99 116.693C249.431 115.787 249.917 114.902 250.443 114.046C251.145 113.814 251.733 113.369 252.329 112.958C252.51 112.83 252.688 112.698 252.866 112.563C253.184 112.324 253.495 112.078 253.803 111.829C253.959 111.702 254.112 111.576 254.266 111.448C255.523 110.405 256.717 109.305 258.008 108.346C258.948 107.646 259.961 107.032 261.035 106.565C261.427 106.393 261.828 106.241 262.237 106.112C262.898 105.901 263.581 105.758 264.276 105.706C264.381 105.699 264.489 105.692 264.595 105.689C265.227 105.659 265.865 105.72 266.488 105.869C266.55 105.882 266.613 105.897 266.674 105.914L266.678 105.916C266.722 105.927 266.769 105.939 266.814 105.955C266.873 105.968 266.93 105.986 266.987 106.004C266.937 105.982 266.886 105.96 266.836 105.941C266.797 105.923 266.757 105.907 266.717 105.894L266.713 105.892C266.66 105.871 266.606 105.851 266.551 105.832C266.019 105.647 265.455 105.542 264.889 105.497C264.791 105.489 264.694 105.482 264.597 105.478C264.267 105.469 263.937 105.481 263.607 105.514C263.355 105.536 263.105 105.571 262.855 105.618C262.616 105.659 262.376 105.712 262.14 105.772C262.015 105.804 261.891 105.839 261.767 105.876C260.304 106.306 258.94 107.039 257.697 107.919C256.501 108.776 255.398 109.74 254.31 110.702C254.179 110.817 254.051 110.932 253.921 111.045C253.785 111.166 253.646 111.286 253.51 111.406C253.035 111.816 252.557 112.221 252.069 112.61C251.62 112.975 251.144 113.285 250.692 113.651C251.454 112.456 252.305 111.316 253.244 110.252C254.27 109.093 255.42 108.037 256.669 107.118C256.672 107.117 256.673 107.115 256.675 107.113C256.802 107.022 256.925 106.933 257.053 106.844C257.927 106.229 258.846 105.68 259.807 105.207C260.612 104.805 261.446 104.457 262.302 104.174C262.386 104.145 262.469 104.118 262.553 104.095C262.553 104.095 262.554 104.093 262.556 104.094C262.942 103.969 263.332 103.859 263.727 103.765C264.451 103.591 265.187 103.462 265.93 103.383C266.583 103.312 267.24 103.281 267.898 103.291C267.355 103.248 266.809 103.237 266.266 103.255C265.161 103.287 264.058 103.438 262.977 103.69C262.917 103.703 262.858 103.717 262.797 103.733C262.676 103.761 262.551 103.793 262.43 103.827L262.425 103.83C262.214 103.883 262.005 103.941 261.797 104.006C261.055 104.231 260.33 104.502 259.622 104.812C258.914 105.127 258.227 105.483 257.562 105.876C257.342 106 257.13 106.13 256.92 106.264L256.917 106.265C256.48 106.543 256.054 106.834 255.64 107.143C255.551 107.205 255.462 107.271 255.377 107.336C255.423 107.276 255.468 107.218 255.514 107.16C255.684 106.947 255.86 106.738 256.044 106.539C256.045 106.537 256.047 106.538 256.047 106.538C256.053 106.527 256.062 106.518 256.072 106.509C256.136 106.438 256.201 106.368 256.269 106.299C256.405 106.157 256.544 106.018 256.687 105.882C256.736 105.833 256.785 105.787 256.835 105.741C257.254 105.352 257.702 104.991 258.17 104.656C258.938 104.105 259.756 103.622 260.606 103.207C261.43 102.804 262.286 102.463 263.161 102.185C263.175 102.181 263.188 102.175 263.202 102.172C264.998 101.596 266.872 101.258 268.758 101.024C269.701 100.904 270.649 100.818 271.601 100.746C272.196 100.693 272.792 100.651 273.39 100.608C273.406 100.605 273.423 100.605 273.44 100.605C273.686 100.587 273.935 100.568 274.181 100.55C274.199 100.548 274.219 100.546 274.236 100.544C274.309 100.54 274.383 100.534 274.457 100.527C274.383 100.527 274.31 100.525 274.236 100.527C274.218 100.525 274.199 100.524 274.182 100.525L274.181 100.527C273.936 100.524 273.69 100.523 273.445 100.524C273.429 100.523 273.412 100.523 273.395 100.523C272.792 100.523 272.192 100.53 271.59 100.54C270.635 100.562 269.678 100.606 268.722 100.677C266.812 100.823 264.9 101.118 263.047 101.666C261.485 102.135 259.972 102.794 258.593 103.679L258.591 103.68C258.334 103.843 258.081 104.015 257.835 104.195C257.633 104.344 257.434 104.496 257.239 104.656C256.679 105.111 256.153 105.608 255.672 106.15C255.577 106.258 255.485 106.367 255.395 106.479C255.368 106.51 255.342 106.543 255.318 106.574C255.259 106.647 255.202 106.72 255.145 106.794C255.11 106.841 255.074 106.89 255.038 106.937C254.966 107.036 254.893 107.137 254.824 107.239C254.778 107.305 254.733 107.368 254.691 107.435L254.69 107.437C254.5 107.723 254.326 108.018 254.166 108.321C253.652 108.771 253.157 109.243 252.685 109.737C251.73 110.728 250.87 111.801 250.09 112.933L250.089 112.935C250.086 112.938 250.082 112.943 250.081 112.947C249.984 113.086 249.889 113.226 249.796 113.367C249.827 112.92 249.889 112.478 249.986 112.047C250.031 111.851 250.079 111.658 250.133 111.466C250.192 111.258 250.259 111.054 250.338 110.856C250.36 110.8 250.382 110.743 250.405 110.687C250.404 110.685 250.406 110.684 250.406 110.684C250.472 110.513 250.543 110.346 250.621 110.181C250.658 110.105 250.695 110.029 250.732 109.956C250.772 109.879 250.812 109.805 250.855 109.732C250.915 109.618 250.981 109.506 251.049 109.397C251.051 109.391 251.055 109.384 251.06 109.377C251.204 109.143 251.361 108.917 251.527 108.699C251.593 108.61 251.662 108.522 251.734 108.436C251.737 108.433 251.738 108.429 251.741 108.426C251.905 108.228 252.077 108.035 252.251 107.838C252.281 107.804 252.31 107.77 252.341 107.736C252.705 107.324 253.065 106.909 253.415 106.479C253.416 106.475 253.419 106.474 253.419 106.472C253.528 106.341 253.634 106.207 253.739 106.073C253.781 106.018 253.823 105.965 253.865 105.91C253.904 105.86 253.943 105.809 253.981 105.759C253.792 105.908 253.604 106.062 253.422 106.218C253.422 106.218 253.421 106.22 253.419 106.219C253.386 106.248 253.354 106.274 253.32 106.303C253.21 106.395 253.102 106.488 252.995 106.584C252.995 106.584 252.993 106.583 252.993 106.585C252.775 106.777 252.56 106.97 252.346 107.168L252.344 107.169C252.33 107.185 252.315 107.199 252.297 107.214C252.213 107.292 252.129 107.37 252.045 107.448C251.727 107.738 251.425 108.051 251.136 108.384C250.858 108.726 250.609 109.092 250.391 109.478C250.274 109.694 250.167 109.916 250.073 110.145C250.05 110.2 250.026 110.255 250.004 110.313C249.99 110.348 249.976 110.383 249.965 110.421L249.963 110.427C249.902 110.583 249.849 110.743 249.803 110.906C249.698 111.256 249.622 111.615 249.581 111.978C249.57 112.05 249.562 112.123 249.558 112.195C249.546 112.303 249.539 112.41 249.535 112.516C249.534 112.519 249.535 112.522 249.534 112.526C249.529 112.589 249.528 112.654 249.529 112.718C249.526 112.725 249.528 112.732 249.527 112.74C249.528 112.751 249.527 112.759 249.527 112.77C249.527 112.772 249.528 112.774 249.527 112.776C249.525 113.081 249.546 113.385 249.587 113.686C249.311 114.115 249.047 114.55 248.791 114.99L248.788 114.999C248.452 115.579 248.135 116.171 247.835 116.77C246.568 119.305 245.609 121.98 244.874 124.712C244.866 124.735 244.861 124.756 244.855 124.779C244.651 125.561 244.47 126.358 244.33 127.167C244.315 127.258 244.3 127.35 244.287 127.442L244.287 127.444C244.202 127.975 244.139 128.507 244.101 129.048C244.096 129.111 244.093 129.175 244.091 129.24C244.083 129.356 244.078 129.473 244.074 129.588C244.073 129.59 244.075 129.591 244.074 129.593C244.071 129.676 244.069 129.759 244.068 129.843C244.029 129.621 243.994 129.398 243.965 129.175C243.964 129.171 243.963 129.166 243.963 129.162C243.924 128.896 243.895 128.628 243.869 128.363C243.868 128.36 243.869 128.358 243.869 128.356C243.854 128.193 243.842 128.029 243.831 127.865C243.792 127.371 243.795 126.875 243.786 126.379L243.812 125.638C243.817 125.392 243.848 125.145 243.866 124.899C243.872 124.832 243.879 124.764 243.885 124.697C243.886 124.695 243.886 124.693 243.885 124.691C243.898 124.569 243.911 124.447 243.928 124.324C244.018 123.534 244.155 122.748 244.357 121.977C244.528 121.295 244.743 120.624 244.993 119.965L244.994 119.963C245.026 119.876 245.06 119.79 245.094 119.705C245.164 119.527 245.235 119.352 245.311 119.176C245.578 118.557 245.882 117.955 246.2 117.353L246.201 117.351C246.21 117.337 246.214 117.324 246.224 117.309C246.225 117.305 246.229 117.3 246.23 117.296C246.369 117.035 246.509 116.771 246.651 116.509C247.496 114.953 248.329 113.39 249.127 111.805L249.127 111.803C249.148 111.768 249.165 111.732 249.184 111.694C249.219 111.624 249.256 111.553 249.289 111.482C249.341 111.38 249.394 111.279 249.444 111.176C249.357 111.31 249.271 111.444 249.186 111.579C249.168 111.607 249.15 111.634 249.134 111.662L249.133 111.664C249.133 111.664 249.131 111.666 249.13 111.667C249.128 111.669 249.127 111.671 249.126 111.672C248.303 112.965 247.505 114.272 246.72 115.587C246.71 115.603 246.7 115.621 246.689 115.638C246.689 115.64 246.685 115.643 246.685 115.645C246.637 115.723 246.593 115.801 246.545 115.879C246.542 115.882 246.54 115.887 246.538 115.891C246.493 115.966 246.451 116.04 246.406 116.115C246.367 116.179 246.33 116.242 246.291 116.306C245.931 116.906 245.583 117.516 245.263 118.142C245.12 118.415 244.983 118.692 244.853 118.971C244.624 119.486 244.416 120.011 244.237 120.546C244.211 120.615 244.189 120.685 244.167 120.755L244.166 120.758C244.098 120.96 244.036 121.164 243.977 121.369C243.959 121.428 243.941 121.49 243.925 121.55C243.897 121.649 243.871 121.748 243.845 121.848C243.827 121.918 243.812 121.986 243.796 122.056C243.775 122.142 243.755 122.228 243.738 122.314L243.737 122.316C243.478 123.507 243.334 124.725 243.323 125.94C243.321 126.06 243.322 126.18 243.325 126.299C243.331 126.834 243.362 127.369 243.423 127.9C243.533 129.008 243.763 130.101 244.097 131.16L244.098 131.163C244.098 131.169 244.097 131.177 244.099 131.184C244.13 131.662 244.183 132.14 244.253 132.613C244.286 132.839 244.324 133.063 244.367 133.286C244.365 133.29 244.366 133.293 244.368 133.295C244.374 133.338 244.382 133.381 244.391 133.423C244.4 133.471 244.408 133.518 244.418 133.564C244.653 134.774 244.97 135.95 245.335 137.115C245.384 137.275 245.435 137.434 245.487 137.593C245.602 137.934 245.702 138.278 245.832 138.614L246.213 139.622C246.213 139.627 246.215 139.629 246.216 139.63C246.343 139.964 246.494 140.288 246.632 140.616L246.748 140.886C246.748 140.886 246.751 140.889 246.751 140.894L246.846 141.112C246.917 141.278 247.001 141.437 247.077 141.601C247.237 141.923 247.389 142.25 247.554 142.571L248.074 143.517C248.241 143.836 248.436 144.142 248.625 144.45L248.907 144.91L249.051 145.141L249.205 145.363L249.823 146.254C250.035 146.547 250.264 146.828 250.485 147.115L250.819 147.543L251.175 147.95C251.415 148.221 251.647 148.502 251.9 148.76L252.667 149.532C252.792 149.664 252.927 149.784 253.063 149.903L253.471 150.263C253.554 150.339 253.64 150.415 253.725 150.489L253.727 150.489C253.772 150.53 253.816 150.568 253.861 150.607C253.873 150.618 253.884 150.628 253.896 150.636C253.967 150.697 254.04 150.756 254.112 150.812C254.14 150.835 254.169 150.855 254.197 150.878C254.234 150.905 254.268 150.934 254.305 150.962L254.424 151.051L254.426 151.052L254.739 151.291C254.885 151.399 255.026 151.513 255.18 151.609C255.35 151.716 255.522 151.82 255.696 151.92C255.835 152.006 255.975 152.087 256.116 152.167L256.354 152.3C256.435 152.341 256.519 152.377 256.601 152.413C256.704 152.462 256.807 152.504 256.912 152.549C256.888 152.562 256.867 152.575 256.847 152.589C256.643 152.734 256.435 152.885 256.263 153.061C256.021 153.308 255.844 153.604 255.833 154.007C255.827 154.189 255.873 154.398 255.955 154.614C255.971 154.655 255.988 154.695 256.006 154.735L256.007 154.738C256.019 154.729 256.03 154.722 256.039 154.713C256.05 154.706 256.058 154.7 256.067 154.693C256.098 154.67 256.128 154.645 256.156 154.619C256.159 154.617 256.161 154.618 256.161 154.616C256.194 154.587 256.224 154.556 256.254 154.524C256.314 154.46 256.367 154.392 256.411 154.322C256.433 154.287 256.454 154.252 256.473 154.216L256.475 154.211C256.488 154.184 256.502 154.157 256.513 154.129C256.527 154.102 256.538 154.077 256.548 154.049C256.556 154.03 256.565 154.012 256.571 153.993L256.575 153.982C256.596 153.928 256.613 153.873 256.628 153.817C256.631 153.81 256.633 153.802 256.635 153.792L256.643 153.767C256.726 153.54 256.766 153.296 256.799 153.051C256.839 153.046 256.879 153.039 256.918 153.031C256.969 153.07 257.021 153.109 257.073 153.148C257.08 153.152 257.085 153.156 257.092 153.161C257.157 153.209 257.224 153.259 257.29 153.305C257.3 153.313 257.312 153.321 257.322 153.329L257.585 153.488C257.801 153.617 258.021 153.747 258.243 153.872C258.283 153.818 258.326 153.768 258.37 153.72C258.371 153.716 258.375 153.711 258.378 153.708C258.382 153.716 258.384 153.723 258.387 153.73C258.436 153.846 258.5 153.929 258.571 153.996C258.629 154.052 258.698 154.087 258.767 154.121C258.835 154.157 258.902 154.193 258.974 154.224C259.255 154.347 259.532 154.486 259.818 154.595C260.39 154.823 260.969 155.028 261.561 155.193C262.509 155.465 263.473 155.663 264.442 155.807C264.679 155.845 264.919 155.878 265.157 155.908C266.366 156.066 267.579 156.132 268.784 156.182C269.994 156.226 271.191 156.25 272.394 156.273C272.864 156.278 273.336 156.282 273.809 156.28C274.438 156.276 275.067 156.265 275.697 156.239L275.706 156.24C277.029 156.183 278.356 156.06 279.677 155.81C279.687 155.807 279.696 155.806 279.703 155.804C280.224 155.916 280.755 156.007 281.305 156.031C282.177 156.079 283.025 155.891 283.843 155.728C284.663 155.56 285.485 155.377 286.303 155.162C287.117 154.934 287.929 154.67 288.708 154.324C289.486 153.97 290.228 153.537 290.908 153.028C292.277 152.014 293.429 150.767 294.462 149.448C293.263 150.621 292.044 151.769 290.671 152.691C289.306 153.625 287.768 154.229 286.164 154.652C285.365 154.872 284.552 155.053 283.736 155.24C282.922 155.432 282.12 155.617 281.312 155.621C281.104 155.62 280.896 155.612 280.687 155.594C281.55 155.396 282.406 155.158 283.242 154.866C284.401 154.457 285.533 153.976 286.627 153.418C286.924 153.26 287.219 153.099 287.509 152.93C287.509 152.93 287.51 152.93 287.511 152.929C287.79 152.769 288.064 152.604 288.338 152.434C288.822 152.132 289.294 151.816 289.758 151.486C290.083 151.253 290.405 151.011 290.717 150.761C290.719 150.76 290.72 150.758 290.722 150.757C291.071 150.479 291.413 150.192 291.748 149.895C292.03 149.645 292.306 149.391 292.576 149.129C293.462 148.282 294.263 147.349 295.006 146.379C295.187 146.132 295.379 145.893 295.549 145.638L296.061 144.878C296.379 144.356 296.705 143.84 296.986 143.299C297.156 142.985 297.316 142.67 297.471 142.349C297.84 141.961 298.184 141.545 298.499 141.111C299.064 140.314 299.533 139.453 299.916 138.561C299.984 138.401 300.05 138.243 300.112 138.081C300.137 138.014 300.162 137.949 300.188 137.882C300.251 137.712 300.31 137.541 300.369 137.365L300.369 137.363C300.391 137.301 300.411 137.237 300.432 137.172L300.436 137.18ZM263.397 112.133C263.465 112.07 263.534 112.005 263.603 111.945C264.792 110.875 266.068 109.898 267.406 109.01C267.359 109.084 267.315 109.157 267.27 109.232C267.192 109.359 267.116 109.486 267.045 109.613C266.881 109.908 266.723 110.207 266.572 110.508C266.533 110.584 266.497 110.657 266.462 110.734L266.461 110.735C266.152 111.365 265.875 112.008 265.629 112.667C265.581 112.793 265.535 112.92 265.491 113.048C265.353 113.434 265.227 113.827 265.115 114.222C265.07 114.371 265.028 114.522 264.99 114.673C264.963 114.769 264.939 114.864 264.916 114.961C264.784 115.512 264.672 116.066 264.585 116.626C264.541 116.906 264.504 117.186 264.474 117.468C264.461 117.584 264.45 117.702 264.439 117.818C264.438 117.839 264.436 117.857 264.435 117.878C264.432 117.923 264.428 117.97 264.425 118.016C264.403 118.324 264.39 118.635 264.381 118.944C264.381 118.986 264.382 119.027 264.38 119.068L264.38 119.07C264.373 119.619 264.392 120.17 264.446 120.719L264.561 120.71C264.487 120.777 264.413 120.845 264.338 120.911C264.232 121.009 264.128 121.103 264.024 121.202L264.021 121.203C263.896 121.322 263.768 121.44 263.644 121.561C263.559 121.643 263.474 121.725 263.39 121.81C263.389 121.812 263.387 121.811 263.386 121.813C263.042 122.148 262.709 122.498 262.382 122.857C262.303 122.943 262.226 123.032 262.15 123.119C261.519 123.844 260.927 124.604 260.372 125.39C260.323 125.46 260.273 125.531 260.225 125.601C259.659 126.42 259.15 127.275 258.674 128.148C258.154 129.095 257.709 130.082 257.31 131.085C256.907 132.089 256.571 133.118 256.285 134.161C256.231 134.349 256.183 134.536 256.136 134.727C256.122 134.785 256.107 134.841 256.095 134.9L256.094 134.902C256.048 135.088 256.004 135.275 255.961 135.462C255.947 135.521 255.935 135.58 255.921 135.638C255.912 135.671 255.904 135.704 255.897 135.737C255.793 136.268 255.681 136.798 255.602 137.333C255.55 137.637 255.508 137.945 255.471 138.252C255.346 137.817 255.258 137.372 255.192 136.921C255.171 136.781 255.15 136.641 255.131 136.502C255.129 136.493 255.129 136.487 255.128 136.48L255.128 136.478C255.072 136.062 255.024 135.648 254.971 135.231C254.938 134.955 254.902 134.676 254.868 134.399C254.907 134.187 254.949 133.975 254.993 133.764C255.033 133.582 255.073 133.398 255.119 133.218C255.255 132.644 255.413 132.078 255.596 131.52C255.647 131.367 255.699 131.216 255.756 131.065L255.759 131.058C255.801 130.936 255.844 130.818 255.892 130.698C256.253 129.748 256.685 128.835 257.182 127.944C257.343 127.643 257.511 127.348 257.685 127.052L257.686 127.05C257.698 127.025 257.713 127.003 257.727 126.978C257.873 126.73 258.022 126.482 258.173 126.235C258.224 126.148 258.275 126.062 258.328 125.976C258.439 125.789 258.555 125.601 258.67 125.416C258.757 125.275 258.844 125.133 258.932 124.993C259.023 124.841 259.115 124.69 259.206 124.538C259.301 124.381 259.396 124.223 259.49 124.066C260.08 123.08 260.651 122.084 261.177 121.06C260.738 121.586 260.315 122.124 259.902 122.667C259.901 122.669 259.899 122.67 259.898 122.672C259.87 122.711 259.839 122.751 259.811 122.789C259.449 123.266 259.097 123.748 258.747 124.234C258.535 124.524 258.327 124.819 258.123 125.117C258.122 125.121 258.119 125.124 258.117 125.13L258.116 125.131C257.946 125.38 257.777 125.629 257.608 125.88C257.387 126.22 257.173 126.565 256.963 126.916C256.827 127.142 256.695 127.372 256.565 127.605C256.541 127.652 256.516 127.698 256.49 127.744C256.2 128.294 255.929 128.857 255.692 129.436C255.444 130.066 255.227 130.712 255.071 131.369C254.915 132 254.804 132.641 254.741 133.285C254.692 132.824 254.646 132.363 254.606 131.901C254.556 131.321 254.52 130.74 254.509 130.159C254.508 130.13 254.507 130.102 254.507 130.072L254.508 130.07C254.505 130.036 254.505 130 254.506 129.966C254.503 129.949 254.503 129.932 254.505 129.915C254.5 129.745 254.499 129.579 254.499 129.41L254.499 129.408C254.499 129.372 254.499 129.336 254.5 129.301C254.499 129.025 254.506 128.751 254.521 128.476C254.546 127.918 254.595 127.36 254.682 126.809C254.795 125.985 254.977 125.17 255.215 124.37C255.251 124.302 255.289 124.235 255.328 124.169C255.33 124.166 255.332 124.164 255.334 124.161C255.384 124.07 255.435 123.978 255.486 123.891C255.651 123.61 255.821 123.333 255.999 123.062C256.026 123.019 256.056 122.975 256.086 122.932C256.087 122.93 256.087 122.929 256.09 122.927C256.175 122.797 256.262 122.667 256.354 122.541C256.982 121.642 257.682 120.802 258.447 120.01C258.551 119.901 258.654 119.792 258.759 119.683C259.11 119.32 259.475 118.966 259.842 118.613C260.067 118.39 260.296 118.172 260.527 117.954C260.776 117.716 261.027 117.478 261.276 117.236C261.68 116.847 262.081 116.456 262.476 116.058C262.508 116.026 262.541 115.992 262.571 115.96C262.572 115.958 262.574 115.959 262.574 115.957C262.703 115.829 262.829 115.702 262.954 115.57L262.955 115.569C262.958 115.565 262.961 115.564 262.965 115.559C262.974 115.552 262.981 115.544 262.988 115.534C263.111 115.41 263.233 115.284 263.353 115.157C263.596 114.9 263.835 114.641 264.071 114.378C263.739 114.614 263.41 114.856 263.087 115.102C263.08 115.106 263.074 115.11 263.07 115.115C263.043 115.133 263.017 115.154 262.991 115.172C262.991 115.174 262.989 115.174 262.988 115.176C262.965 115.193 262.942 115.21 262.919 115.228C262.894 115.246 262.868 115.267 262.842 115.287C262.186 115.786 261.544 116.303 260.908 116.826C260.901 116.832 260.893 116.838 260.887 116.844C260.376 117.254 259.882 117.689 259.385 118.124C258.888 118.573 258.404 119.039 257.935 119.525C257.476 120.017 257.031 120.528 256.623 121.071C256.531 121.197 256.438 121.325 256.349 121.454C256.506 121.13 256.67 120.81 256.842 120.49C257.922 118.516 259.304 116.701 260.868 115.039C260.435 115.394 260.016 115.769 259.611 116.16C259.827 115.891 260.044 115.627 260.268 115.366C260.271 115.363 260.272 115.361 260.275 115.358C260.388 115.222 260.506 115.086 260.624 114.954C261.49 113.963 262.412 113.022 263.393 112.136C263.394 112.135 263.395 112.134 263.397 112.133L263.397 112.133ZM256.593 151.14C256.588 151.13 256.585 151.118 256.58 151.108C256.559 151.05 256.538 150.992 256.516 150.934C256.489 150.861 256.462 150.788 256.438 150.717C256.428 150.697 256.422 150.678 256.416 150.659C256.362 150.516 256.309 150.371 256.258 150.229C256.194 150.059 256.129 149.89 256.063 149.721C255.923 149.355 255.777 148.992 255.617 148.638C255.162 147.661 254.731 146.673 254.342 145.677C254.295 145.563 254.251 145.449 254.208 145.335C254.206 145.33 254.205 145.326 254.203 145.321C253.824 144.335 253.49 143.336 253.209 142.325L252.995 141.515L252.897 141.075L252.872 140.963L252.812 140.698C252.744 140.428 252.707 140.152 252.654 139.879L252.582 139.468C252.557 139.331 252.544 139.194 252.525 139.055C252.397 138.234 252.329 137.403 252.308 136.57L252.307 136.568C252.297 136.291 252.295 136.012 252.297 135.732C252.303 135.248 252.323 134.762 252.354 134.276C252.396 133.614 252.461 132.952 252.55 132.294C252.558 132.242 252.565 132.192 252.572 132.139C252.583 132.065 252.593 131.99 252.605 131.919C252.611 131.871 252.619 131.823 252.626 131.777C252.764 130.871 252.949 129.972 253.177 129.084C253.433 128.038 253.746 127.007 254.107 125.988C254.062 126.229 254.02 126.47 253.984 126.71C253.897 127.287 253.854 127.867 253.832 128.448C253.812 129.026 253.811 129.607 253.843 130.183C253.844 130.187 253.843 130.189 253.844 130.193C253.844 130.227 253.848 130.258 253.851 130.293L253.851 130.295C253.857 130.451 253.869 130.607 253.882 130.763C253.882 130.799 253.886 130.836 253.889 130.871L253.888 130.873C253.932 131.421 253.99 131.965 254.061 132.506C254.108 132.876 254.163 133.245 254.223 133.611C254.257 133.819 254.291 134.029 254.329 134.236C254.334 134.282 254.343 134.329 254.351 134.374C254.368 134.47 254.383 134.566 254.403 134.661L254.402 134.663C254.537 135.439 254.687 136.209 254.854 136.985C254.874 137.072 254.895 137.158 254.918 137.243C254.918 137.243 254.918 137.245 254.92 137.246C254.919 137.254 254.921 137.259 254.923 137.266C255.043 137.733 255.187 138.195 255.384 138.634L255.392 138.652C255.399 138.669 255.408 138.687 255.416 138.705C255.408 138.784 255.397 138.863 255.389 138.941C255.339 139.48 255.293 140.02 255.274 140.561C255.235 141.39 255.233 142.221 255.265 143.052C255.267 143.095 255.269 143.138 255.273 143.181L255.272 143.183C255.284 143.452 255.301 143.722 255.319 143.989C255.322 144.034 255.327 144.076 255.331 144.12L255.33 144.121C255.373 144.688 255.434 145.255 255.513 145.817C255.568 146.224 255.632 146.629 255.704 147.033C255.904 148.099 256.153 149.158 256.473 150.196C256.549 150.433 256.629 150.671 256.713 150.907C256.734 150.965 256.752 151.022 256.774 151.08L256.775 151.082C256.806 151.175 256.841 151.268 256.874 151.361C256.782 151.287 256.688 151.214 256.593 151.139L256.593 151.14ZM258.903 152.368C258.9 152.37 258.898 152.369 258.894 152.369C258.794 152.373 258.691 152.375 258.592 152.377C258.574 152.332 258.555 152.29 258.538 152.246C258.532 152.234 258.526 152.221 258.524 152.209C258.497 152.152 258.474 152.097 258.455 152.042C258.367 151.835 258.284 151.625 258.207 151.417C258.137 151.241 258.073 151.067 258.012 150.892C257.989 150.836 257.968 150.78 257.952 150.724C257.846 150.433 257.748 150.139 257.657 149.844C257.654 149.839 257.652 149.834 257.651 149.83C257.341 148.84 257.098 147.831 256.903 146.813C256.864 146.608 256.828 146.402 256.796 146.197C256.696 145.581 256.618 144.962 256.56 144.342C256.844 144.427 257.145 144.463 257.443 144.454C257.745 144.441 258.041 144.382 258.324 144.29C258.889 144.111 259.401 143.83 259.884 143.525C260.367 143.212 260.813 142.88 261.269 142.556C261.723 142.231 262.172 141.896 262.622 141.564C263.287 141.068 263.944 140.558 264.592 140.033C264.603 140.025 264.615 140.014 264.627 140.003C264.633 139.999 264.639 139.995 264.645 139.988C264.656 139.98 264.668 139.971 264.68 139.961C264.946 139.746 265.21 139.525 265.471 139.302C265.491 139.286 265.512 139.268 265.529 139.25C265.548 139.238 265.563 139.224 265.577 139.21L265.577 139.208C265.779 139.04 265.975 138.87 266.167 138.697C266.714 138.218 267.246 137.725 267.765 137.218C267.959 137.024 268.15 136.829 268.339 136.632C268.598 136.364 268.853 136.09 269.103 135.814C269.126 135.868 269.152 135.921 269.173 135.975C269.189 136.008 269.205 136.041 269.219 136.075C269.222 136.078 269.222 136.083 269.225 136.088C269.287 136.23 269.348 136.371 269.406 136.513C269.678 137.163 269.916 137.817 270.112 138.48C270.322 139.215 270.489 139.955 270.604 140.705C270.62 140.805 270.634 140.903 270.648 141.004C270.653 141.044 270.658 141.084 270.661 141.125C270.668 141.165 270.673 141.205 270.677 141.247C270.681 141.277 270.685 141.31 270.689 141.341C270.708 141.506 270.725 141.669 270.739 141.835C270.743 141.872 270.748 141.907 270.749 141.946L270.748 141.947C270.81 142.712 270.817 143.486 270.777 144.257C270.776 144.272 270.776 144.284 270.773 144.298C270.753 144.649 270.722 145 270.68 145.351C270.672 145.405 270.666 145.458 270.658 145.512L270.657 145.514C270.647 145.605 270.634 145.695 270.621 145.787C270.617 145.818 270.613 145.848 270.609 145.878C270.598 145.958 270.585 146.038 270.571 146.12C270.552 146.25 270.53 146.379 270.508 146.508C270.357 146.654 270.203 146.8 270.054 146.949C270.008 146.998 269.96 147.045 269.912 147.092C269.498 147.504 269.056 147.884 268.614 148.266C268.44 148.414 268.268 148.565 268.098 148.717C268.098 148.717 268.095 148.718 268.095 148.72C268.071 148.739 268.049 148.761 268.025 148.78C267.469 149.253 266.88 149.67 266.262 150.045C266.12 150.133 265.977 150.216 265.833 150.299C265.427 150.526 265.014 150.739 264.59 150.936C264.649 150.808 264.705 150.678 264.756 150.549C264.788 150.469 264.818 150.387 264.847 150.305L264.86 150.267C264.878 150.214 264.896 150.163 264.912 150.112C265.034 149.74 265.13 149.356 265.198 148.969C265.22 148.858 265.237 148.747 265.253 148.636C265.258 148.602 265.263 148.57 265.267 148.535L265.267 148.534C265.269 148.523 265.27 148.513 265.271 148.503C265.274 148.49 265.274 148.477 265.275 148.462C265.28 148.437 265.282 148.412 265.285 148.386C265.288 148.37 265.29 148.352 265.29 148.335C265.299 148.258 265.308 148.179 265.312 148.1C265.326 147.956 265.335 147.809 265.337 147.663C265.343 147.481 265.343 147.3 265.336 147.119C265.329 146.877 265.312 146.635 265.284 146.395C265.278 146.345 265.271 146.294 265.263 146.243C265.257 146.194 265.248 146.145 265.24 146.096C265.223 145.98 265.202 145.865 265.177 145.749C265.144 145.582 265.103 145.414 265.056 145.248L265.057 145.246C265.045 145.2 265.031 145.157 265.017 145.112C265 145.056 264.983 145.002 264.961 144.945C264.911 144.785 264.85 144.627 264.78 144.47C264.773 144.449 264.763 144.428 264.753 144.408C264.749 144.396 264.742 144.385 264.738 144.373C264.739 144.42 264.737 144.466 264.739 144.511C264.739 144.515 264.739 144.517 264.739 144.521C264.74 144.612 264.742 144.703 264.743 144.792C264.742 144.884 264.742 144.975 264.744 145.066C264.745 145.132 264.745 145.197 264.746 145.263C264.745 145.313 264.746 145.366 264.746 145.419C264.746 145.602 264.745 145.782 264.742 145.965C264.742 146.02 264.741 146.074 264.739 146.128C264.736 146.226 264.734 146.323 264.73 146.42L264.73 146.422C264.728 146.476 264.726 146.528 264.723 146.582C264.724 146.595 264.722 146.607 264.722 146.62C264.717 146.751 264.71 146.88 264.702 147.011L264.702 147.013C264.701 147.044 264.698 147.077 264.696 147.108C264.688 147.235 264.679 147.365 264.668 147.492C264.657 147.64 264.643 147.789 264.628 147.935C264.627 147.951 264.624 147.967 264.623 147.982C264.617 148.047 264.61 148.11 264.6 148.174L264.6 148.176C264.593 148.256 264.584 148.337 264.574 148.415C264.558 148.54 264.541 148.667 264.521 148.793C264.513 148.851 264.505 148.91 264.496 148.968C264.48 149.076 264.461 149.183 264.443 149.29C264.383 149.645 264.314 149.997 264.236 150.35C264.234 150.362 264.229 150.375 264.227 150.387L264.225 150.393C264.213 150.453 264.2 150.514 264.183 150.574L264.183 150.576C264.14 150.778 264.09 150.978 264.038 151.181C263.829 151.269 263.619 151.351 263.408 151.43C263.261 151.484 263.115 151.537 262.967 151.586C262.788 151.647 262.61 151.705 262.429 151.758C262.278 151.805 262.127 151.847 261.975 151.889C261.787 151.938 261.603 151.985 261.415 152.027L261.413 152.029C260.836 152.161 260.252 152.258 259.668 152.317C259.413 152.342 259.158 152.361 258.904 152.37L258.903 152.368ZM254.501 129.301C254.5 129.025 254.506 128.751 254.522 128.477C254.546 127.919 254.595 127.361 254.683 126.81C254.796 125.986 254.978 125.17 255.215 124.37C255.251 124.303 255.289 124.236 255.329 124.17C255.271 124.22 255.212 124.269 255.153 124.318C255.091 124.368 255.03 124.418 254.968 124.468C254.891 124.532 254.813 124.594 254.733 124.654C254.653 124.715 254.573 124.776 254.493 124.834C254.159 125.081 253.814 125.312 253.457 125.526C253.44 125.588 253.426 125.648 253.408 125.709C253.365 125.871 253.322 126.031 253.281 126.194C253.22 126.417 253.164 126.64 253.108 126.862L252.787 128.443C252.77 128.542 252.749 128.64 252.727 128.737C252.723 128.757 252.72 128.777 252.715 128.797C252.703 128.856 252.689 128.914 252.679 128.974C252.667 129.033 252.657 129.093 252.649 129.153C252.66 129.133 252.674 129.115 252.686 129.099C252.829 128.912 252.986 128.739 253.158 128.584C252.938 128.907 252.759 129.248 252.615 129.6C252.6 129.637 252.585 129.676 252.569 129.715L252.568 129.719L252.525 130.032L252.413 130.829C252.404 130.896 252.393 130.964 252.383 131.03C252.354 131.23 252.325 131.429 252.314 131.63C252.296 131.876 252.276 132.122 252.257 132.366C252.36 132.233 252.463 132.1 252.568 131.968C252.58 131.951 252.593 131.937 252.606 131.92C252.612 131.871 252.62 131.824 252.627 131.778C252.765 130.871 252.95 129.973 253.178 129.085C253.434 128.038 253.747 127.008 254.108 125.989C254.063 126.23 254.021 126.471 253.985 126.711C253.898 127.288 253.855 127.868 253.833 128.448C253.813 129.027 253.812 129.608 253.844 130.183C253.845 130.188 253.844 130.19 253.845 130.194C253.845 130.228 253.849 130.259 253.852 130.294C253.934 130.185 254.014 130.076 254.095 129.965C254.154 129.886 254.213 129.808 254.269 129.729C254.308 129.677 254.346 129.625 254.385 129.571C254.405 129.546 254.423 129.518 254.442 129.492C254.462 129.465 254.482 129.438 254.5 129.41L254.501 129.409C254.5 129.373 254.5 129.337 254.502 129.301L254.501 129.301ZM263.087 115.103C263.08 115.107 263.074 115.111 263.07 115.116C263.058 115.175 263.042 115.233 263.028 115.291L263.028 115.293C263.025 115.301 263.025 115.307 263.023 115.314C263.01 115.369 262.995 115.425 262.981 115.477C262.976 115.498 262.97 115.522 262.962 115.542C262.901 115.555 262.84 115.567 262.778 115.575C262.743 115.641 262.707 115.709 262.671 115.774C262.639 115.837 262.607 115.898 262.574 115.958C262.703 115.83 262.829 115.703 262.954 115.572L262.955 115.57C262.958 115.567 262.96 115.565 262.964 115.56C262.973 115.553 262.98 115.545 262.988 115.535C263.111 115.411 263.233 115.285 263.352 115.158C263.595 114.901 263.834 114.642 264.071 114.379C263.738 114.615 263.41 114.857 263.087 115.104L263.087 115.103ZM256.405 135.284L256.406 135.28C256.428 135.216 256.451 135.15 256.476 135.085C256.568 134.825 256.666 134.566 256.767 134.306C256.535 134.495 256.31 134.693 256.095 134.901L256.095 134.902C256.049 135.089 256.005 135.276 255.961 135.463C255.947 135.521 255.935 135.58 255.921 135.639C255.912 135.671 255.905 135.705 255.897 135.738C255.794 136.269 255.681 136.799 255.603 137.333C255.55 137.637 255.509 137.945 255.472 138.253C255.347 137.818 255.259 137.372 255.192 136.922C255.171 136.781 255.15 136.642 255.131 136.502C255.13 136.493 255.13 136.487 255.128 136.48L255.129 136.478C255.073 136.063 255.025 135.648 254.971 135.232C254.939 134.955 254.903 134.677 254.868 134.4C254.908 134.188 254.95 133.975 254.993 133.765C255.033 133.583 255.074 133.399 255.12 133.219C255.256 132.645 255.414 132.078 255.597 131.52C255.648 131.367 255.7 131.217 255.757 131.066L255.759 131.058C255.802 130.936 255.844 130.819 255.893 130.698C256.253 129.749 256.686 128.836 257.182 127.944C257.343 127.644 257.511 127.349 257.686 127.053L257.686 127.051C257.699 127.026 257.713 127.003 257.728 126.979C257.873 126.73 258.022 126.483 258.173 126.236C258.225 126.149 258.275 126.063 258.329 125.976C258.44 125.789 258.555 125.602 258.67 125.416C258.757 125.276 258.844 125.134 258.933 124.994C259.024 124.842 259.116 124.691 259.207 124.539C259.301 124.382 259.396 124.223 259.491 124.066C260.081 123.081 260.652 122.085 261.178 121.06C260.739 121.586 260.316 122.124 259.902 122.668C259.902 122.669 259.899 122.671 259.899 122.673C259.87 122.711 259.84 122.751 259.812 122.79C259.45 123.267 259.098 123.749 258.748 124.235C258.536 124.525 258.328 124.82 258.124 125.118C258.123 125.121 258.119 125.125 258.117 125.13L258.117 125.132C257.946 125.38 257.778 125.63 257.609 125.881C257.388 126.221 257.173 126.566 256.963 126.916C256.828 127.143 256.695 127.373 256.566 127.606C256.542 127.652 256.517 127.699 256.491 127.744C256.201 128.295 255.93 128.858 255.693 129.437C255.445 130.067 255.227 130.712 255.071 131.37C254.916 132 254.805 132.642 254.741 133.286C254.693 132.825 254.646 132.364 254.606 131.902C254.557 131.322 254.52 130.741 254.509 130.16C254.509 130.13 254.508 130.103 254.508 130.073L254.508 130.071C254.506 130.036 254.505 130 254.506 129.967C254.504 129.949 254.504 129.932 254.505 129.916C254.499 129.941 254.492 129.966 254.49 129.991C254.477 130.041 254.465 130.092 254.456 130.142L254.456 130.143C254.454 130.149 254.451 130.152 254.447 130.157C254.44 130.165 254.435 130.172 254.43 130.181C254.424 130.187 254.419 130.194 254.415 130.201C254.333 130.31 254.251 130.418 254.168 130.524C254.153 130.542 254.138 130.562 254.122 130.582C254.046 130.68 253.968 130.777 253.889 130.872L253.889 130.873C253.932 131.422 253.99 131.966 254.061 132.507C254.108 132.877 254.163 133.245 254.223 133.612C254.257 133.82 254.292 134.03 254.329 134.237C254.334 134.283 254.343 134.33 254.351 134.375C254.368 134.471 254.383 134.567 254.403 134.662L254.402 134.664C254.537 135.44 254.687 136.21 254.854 136.986C254.875 137.073 254.896 137.158 254.919 137.244C254.919 137.244 254.918 137.246 254.92 137.247C254.919 137.255 254.922 137.26 254.923 137.267C255.043 137.734 255.187 138.196 255.384 138.635L255.393 138.653C255.675 137.515 256.013 136.389 256.405 135.284L256.405 135.284ZM254.489 129.99C254.491 129.966 254.498 129.941 254.505 129.915C254.5 129.745 254.499 129.579 254.499 129.41C254.481 129.437 254.461 129.464 254.441 129.491C254.421 129.518 254.403 129.545 254.384 129.57C254.344 129.624 254.307 129.677 254.268 129.728C254.211 129.808 254.152 129.886 254.093 129.965C254.013 130.076 253.933 130.185 253.851 130.293L253.85 130.295C253.857 130.451 253.868 130.607 253.882 130.763C253.882 130.799 253.886 130.836 253.889 130.871C253.968 130.776 254.046 130.679 254.122 130.581C254.137 130.561 254.153 130.541 254.167 130.523C254.25 130.417 254.332 130.309 254.414 130.2C254.419 130.193 254.423 130.187 254.43 130.18C254.435 130.172 254.439 130.165 254.446 130.157C254.45 130.152 254.453 130.148 254.455 130.143L254.456 130.141C254.465 130.091 254.476 130.04 254.489 129.99ZM255.834 142.553C255.856 141.865 255.928 141.185 256.06 140.504C256.238 139.669 256.382 138.823 256.622 138.003C256.66 137.862 256.697 137.72 256.734 137.576C256.738 137.553 256.74 137.53 256.744 137.506C256.811 136.99 256.912 136.48 257.006 135.969C257.101 135.536 257.19 135.104 257.301 134.675C257.295 134.677 257.292 134.68 257.287 134.683C257.279 134.688 257.271 134.692 257.263 134.698C257.076 134.816 256.893 134.94 256.712 135.067C256.612 135.135 256.514 135.205 256.416 135.276C256.413 135.279 256.408 135.281 256.404 135.284C256.013 136.389 255.675 137.515 255.392 138.653C255.399 138.67 255.407 138.688 255.416 138.705C255.408 138.785 255.397 138.863 255.389 138.942C255.339 139.481 255.292 140.021 255.274 140.562C255.235 141.391 255.233 142.222 255.265 143.053C255.267 143.096 255.269 143.138 255.273 143.182C255.354 143.105 255.437 143.03 255.521 142.959C255.561 142.922 255.603 142.886 255.647 142.85C255.689 142.814 255.731 142.778 255.775 142.743C255.793 142.728 255.811 142.713 255.83 142.699C255.832 142.651 255.832 142.603 255.835 142.553L255.834 142.553ZM280.076 143.083C279.866 143.195 279.654 143.305 279.438 143.411C279.348 143.458 279.256 143.504 279.163 143.547L279.16 143.548C278.987 143.72 278.81 143.892 278.631 144.06L278.457 144.21C278.446 144.219 278.435 144.23 278.423 144.241L278.235 144.401L277.88 144.709L277.874 144.714L277.55 144.993C277.368 145.145 277.197 145.311 277.006 145.455L276.439 145.889L275.872 146.322C275.679 146.464 275.498 146.618 275.295 146.745C275.114 146.866 274.934 146.987 274.752 147.109C274.797 147.004 274.839 146.899 274.884 146.795C274.976 146.574 275.069 146.353 275.16 146.134C275.231 145.965 275.303 145.794 275.376 145.626C275.406 145.558 275.433 145.492 275.462 145.426C275.487 145.367 275.513 145.309 275.54 145.251C275.587 145.138 275.636 145.029 275.684 144.919C275.54 144.977 275.4 145.036 275.255 145.095C275.247 145.098 275.24 145.1 275.233 145.104C275.174 145.248 275.12 145.393 275.069 145.54L275.06 145.564C275.036 145.628 275.015 145.69 274.994 145.756L274.993 145.758C274.961 145.852 274.93 145.947 274.902 146.04C274.809 146.337 274.726 146.637 274.66 146.938C274.639 147.03 274.62 147.12 274.601 147.21C274.043 147.588 273.483 147.964 272.893 148.292L272.276 148.655L271.969 148.837L271.65 148.998L270.374 149.647C270.164 149.761 269.944 149.854 269.725 149.946L269.067 150.228C268.627 150.414 268.193 150.615 267.739 150.764L266.708 151.137C267.43 150.696 268.117 150.202 268.755 149.646C268.842 149.57 268.929 149.495 269.013 149.417C269.931 148.611 270.81 147.764 271.65 146.877C271.72 146.805 271.79 146.73 271.858 146.655L271.861 146.654C271.926 146.581 271.992 146.512 272.055 146.439C272.11 146.384 272.161 146.328 272.21 146.271C272.123 146.298 272.036 146.325 271.948 146.347C271.946 146.348 271.945 146.35 271.943 146.35C271.843 146.378 271.743 146.405 271.642 146.429C271.764 146.34 271.883 146.251 272.003 146.16C272.162 146.04 272.319 145.916 272.475 145.788C272.475 145.788 272.476 145.787 272.477 145.787C272.538 145.739 272.601 145.691 272.661 145.642C272.722 145.592 272.786 145.542 272.845 145.493C272.742 145.529 272.639 145.563 272.537 145.597C272.535 145.597 272.535 145.598 272.535 145.598C272.279 145.68 272.021 145.763 271.761 145.844C271.501 145.918 271.239 145.987 270.973 146.045L270.971 146.044C270.927 146.094 270.879 146.141 270.832 146.19C270.848 146.149 270.863 146.106 270.878 146.064C270.775 146.086 270.674 146.104 270.572 146.121C270.552 146.251 270.531 146.38 270.509 146.509C270.357 146.655 270.203 146.801 270.055 146.95C270.008 147 269.96 147.046 269.913 147.093C269.498 147.505 269.057 147.885 268.615 148.267C268.441 148.415 268.269 148.566 268.098 148.718C268.098 148.718 268.096 148.719 268.095 148.721C268.071 148.74 268.049 148.762 268.026 148.781C267.47 149.254 266.881 149.671 266.262 150.046C266.12 150.134 265.977 150.217 265.833 150.3C265.428 150.527 265.015 150.74 264.591 150.937C264.649 150.809 264.705 150.679 264.756 150.55C264.788 150.47 264.819 150.388 264.847 150.306L264.86 150.268C264.879 150.215 264.896 150.164 264.912 150.113C265.035 149.741 265.13 149.357 265.199 148.97C265.22 148.859 265.238 148.748 265.253 148.637C265.259 148.603 265.263 148.571 265.267 148.536L265.268 148.535C265.269 148.524 265.27 148.514 265.272 148.504C265.274 148.491 265.275 148.478 265.275 148.463C265.28 148.438 265.282 148.413 265.285 148.387C265.289 148.371 265.291 148.353 265.29 148.336C265.3 148.259 265.308 148.18 265.312 148.101C265.327 147.957 265.335 147.81 265.338 147.664C265.344 147.482 265.343 147.301 265.337 147.12C265.33 146.878 265.313 146.636 265.284 146.396C265.279 146.346 265.271 146.295 265.264 146.244C265.257 146.195 265.249 146.146 265.241 146.097C265.224 145.981 265.203 145.866 265.177 145.75C265.145 145.583 265.104 145.415 265.056 145.249L265.057 145.247C265.046 145.201 265.031 145.158 265.017 145.113C265.001 145.057 264.984 145.003 264.961 144.946C264.912 144.786 264.85 144.628 264.781 144.471C264.773 144.45 264.764 144.429 264.754 144.409C264.75 144.397 264.743 144.386 264.738 144.374C264.739 144.421 264.738 144.467 264.739 144.512C264.74 144.516 264.739 144.518 264.74 144.522C264.74 144.613 264.742 144.704 264.743 144.793C264.743 144.885 264.743 144.976 264.745 145.067C264.745 145.133 264.746 145.198 264.746 145.264C264.746 145.314 264.746 145.367 264.747 145.42C264.747 145.603 264.745 145.784 264.743 145.966C264.743 146.021 264.741 146.075 264.739 146.129C264.737 146.227 264.735 146.324 264.731 146.421L264.73 146.423C264.728 146.477 264.727 146.529 264.723 146.583C264.725 146.596 264.723 146.608 264.723 146.621C264.717 146.752 264.71 146.882 264.703 147.012L264.702 147.014C264.702 147.045 264.699 147.078 264.697 147.109C264.688 147.237 264.679 147.366 264.669 147.493C264.658 147.641 264.644 147.79 264.629 147.936C264.628 147.952 264.624 147.968 264.623 147.983C264.618 148.048 264.61 148.111 264.601 148.175L264.6 148.177C264.594 148.257 264.584 148.338 264.574 148.416C264.558 148.541 264.542 148.668 264.521 148.794C264.514 148.852 264.506 148.911 264.496 148.969C264.48 149.077 264.462 149.184 264.444 149.291C264.384 149.646 264.314 149.998 264.236 150.351C264.234 150.363 264.23 150.376 264.228 150.388L264.226 150.394C264.213 150.454 264.2 150.515 264.184 150.575L264.183 150.577C264.14 150.779 264.09 150.979 264.039 151.182C263.829 151.27 263.62 151.352 263.409 151.431C263.261 151.485 263.115 151.538 262.967 151.588C263.71 151.552 264.456 151.493 265.199 151.42C265.396 151.4 265.591 151.377 265.787 151.35C266.854 151.183 267.908 150.976 268.949 150.718L269.865 150.482L270.769 150.209C271.041 150.135 271.3 150.036 271.564 149.944C271.634 149.917 271.705 149.889 271.774 149.86C271.452 149.92 271.131 149.978 270.81 150.048C270.443 150.122 270.073 150.204 269.707 150.294L269.851 150.236C270.076 150.148 270.3 150.059 270.515 149.95L271.822 149.329L272.147 149.173L272.463 148.996L273.097 148.645C275.35 147.406 277.428 145.867 279.309 144.112C279.422 144.01 279.532 143.907 279.64 143.801C280.002 143.457 280.355 143.106 280.699 142.747C280.495 142.861 280.287 142.975 280.078 143.085L280.076 143.083ZM254.501 129.301C254.5 129.025 254.506 128.751 254.522 128.477C254.546 127.919 254.595 127.361 254.683 126.81C254.796 125.986 254.978 125.17 255.215 124.37C255.251 124.303 255.289 124.236 255.329 124.17C255.271 124.22 255.212 124.269 255.153 124.318C255.091 124.368 255.03 124.418 254.968 124.468C254.891 124.532 254.813 124.594 254.733 124.654C254.653 124.715 254.573 124.776 254.493 124.834C254.159 125.081 253.814 125.312 253.457 125.526C253.44 125.588 253.426 125.648 253.408 125.709C253.365 125.871 253.322 126.031 253.281 126.194C253.22 126.417 253.164 126.64 253.108 126.862L252.787 128.443C252.77 128.542 252.749 128.64 252.727 128.737C252.723 128.757 252.72 128.777 252.715 128.797C252.703 128.856 252.689 128.914 252.679 128.974C252.667 129.033 252.657 129.093 252.649 129.153C252.66 129.133 252.674 129.115 252.686 129.099C252.829 128.912 252.986 128.739 253.158 128.584C252.938 128.907 252.759 129.248 252.615 129.6C252.6 129.637 252.585 129.676 252.569 129.715L252.568 129.719L252.525 130.032L252.413 130.829C252.404 130.896 252.393 130.964 252.383 131.03C252.354 131.23 252.325 131.429 252.314 131.63C252.296 131.876 252.276 132.122 252.257 132.366C252.36 132.233 252.463 132.1 252.568 131.968C252.58 131.951 252.593 131.937 252.606 131.92C252.612 131.871 252.62 131.824 252.627 131.778C252.765 130.871 252.95 129.973 253.178 129.085C253.434 128.038 253.747 127.008 254.108 125.989C254.063 126.23 254.021 126.471 253.985 126.711C253.898 127.288 253.855 127.868 253.833 128.448C253.813 129.027 253.812 129.608 253.844 130.183C253.845 130.188 253.844 130.19 253.845 130.194C253.845 130.228 253.849 130.259 253.852 130.294C253.934 130.185 254.014 130.076 254.095 129.965C254.154 129.886 254.213 129.808 254.269 129.729C254.308 129.677 254.346 129.625 254.385 129.571C254.405 129.546 254.423 129.518 254.442 129.492C254.462 129.465 254.482 129.438 254.5 129.41L254.501 129.409C254.5 129.373 254.5 129.337 254.502 129.301L254.501 129.301ZM263.087 115.103C263.08 115.107 263.074 115.111 263.07 115.116C263.058 115.175 263.042 115.233 263.028 115.291L263.028 115.293C263.025 115.301 263.025 115.307 263.023 115.314C263.01 115.369 262.995 115.425 262.981 115.477C262.976 115.498 262.97 115.522 262.962 115.542C262.901 115.555 262.84 115.567 262.778 115.575C262.743 115.641 262.707 115.709 262.671 115.774C262.639 115.837 262.607 115.898 262.574 115.958C262.703 115.83 262.829 115.703 262.954 115.572L262.955 115.57C262.958 115.567 262.96 115.565 262.964 115.56C262.973 115.553 262.98 115.545 262.988 115.535C263.111 115.411 263.233 115.285 263.352 115.158C263.595 114.901 263.834 114.642 264.071 114.379C263.738 114.615 263.41 114.857 263.087 115.104L263.087 115.103ZM256.405 135.284L256.406 135.28C256.428 135.216 256.451 135.15 256.476 135.085C256.568 134.825 256.666 134.566 256.767 134.306C256.535 134.495 256.31 134.693 256.095 134.901L256.095 134.902C256.049 135.089 256.005 135.276 255.961 135.463C255.947 135.521 255.935 135.58 255.921 135.639C255.912 135.671 255.905 135.705 255.897 135.738C255.794 136.269 255.681 136.799 255.603 137.333C255.55 137.637 255.509 137.945 255.472 138.253C255.347 137.818 255.259 137.372 255.192 136.922C255.171 136.781 255.15 136.642 255.131 136.502C255.13 136.493 255.13 136.487 255.128 136.48L255.129 136.478C255.073 136.063 255.025 135.648 254.971 135.232C254.939 134.955 254.903 134.677 254.868 134.4C254.908 134.188 254.95 133.975 254.993 133.765C255.033 133.583 255.074 133.399 255.12 133.219C255.256 132.645 255.414 132.078 255.597 131.52C255.648 131.367 255.7 131.217 255.757 131.066L255.759 131.058C255.802 130.936 255.844 130.819 255.893 130.698C256.253 129.749 256.686 128.836 257.182 127.944C257.343 127.644 257.511 127.349 257.686 127.053L257.686 127.051C257.699 127.026 257.713 127.003 257.728 126.979C257.873 126.73 258.022 126.483 258.173 126.236C258.225 126.149 258.275 126.063 258.329 125.976C258.44 125.789 258.555 125.602 258.67 125.416C258.757 125.276 258.844 125.134 258.933 124.994C259.024 124.842 259.116 124.691 259.207 124.539C259.301 124.382 259.396 124.223 259.491 124.066C260.081 123.081 260.652 122.085 261.178 121.06C260.739 121.586 260.316 122.124 259.902 122.668C259.902 122.669 259.899 122.671 259.899 122.673C259.87 122.711 259.84 122.751 259.812 122.79C259.45 123.267 259.098 123.749 258.748 124.235C258.536 124.525 258.328 124.82 258.124 125.118C258.123 125.121 258.119 125.125 258.117 125.13L258.117 125.132C257.946 125.38 257.778 125.63 257.609 125.881C257.388 126.221 257.173 126.566 256.963 126.916C256.828 127.143 256.695 127.373 256.566 127.606C256.542 127.652 256.517 127.699 256.491 127.744C256.201 128.295 255.93 128.858 255.693 129.437C255.445 130.067 255.227 130.712 255.071 131.37C254.916 132 254.805 132.642 254.741 133.286C254.693 132.825 254.646 132.364 254.606 131.902C254.557 131.322 254.52 130.741 254.509 130.16C254.509 130.13 254.508 130.103 254.508 130.073L254.508 130.071C254.506 130.036 254.505 130 254.506 129.967C254.504 129.949 254.504 129.932 254.505 129.916C254.499 129.941 254.492 129.966 254.49 129.991C254.477 130.041 254.465 130.092 254.456 130.142L254.456 130.143C254.454 130.149 254.451 130.152 254.447 130.157C254.44 130.165 254.435 130.172 254.43 130.181C254.424 130.187 254.419 130.194 254.415 130.201C254.333 130.31 254.251 130.418 254.168 130.524C254.153 130.542 254.138 130.562 254.122 130.582C254.046 130.68 253.968 130.777 253.889 130.872L253.889 130.873C253.932 131.422 253.99 131.966 254.061 132.507C254.108 132.877 254.163 133.245 254.223 133.612C254.257 133.82 254.292 134.03 254.329 134.237C254.334 134.283 254.343 134.33 254.351 134.375C254.368 134.471 254.383 134.567 254.403 134.662L254.402 134.664C254.537 135.44 254.687 136.21 254.854 136.986C254.875 137.073 254.896 137.158 254.919 137.244C254.919 137.244 254.918 137.246 254.92 137.247C254.919 137.255 254.922 137.26 254.923 137.267C255.043 137.734 255.187 138.196 255.384 138.635L255.393 138.653C255.675 137.515 256.013 136.389 256.405 135.284L256.405 135.284ZM254.489 129.99C254.491 129.966 254.498 129.941 254.505 129.915C254.5 129.745 254.499 129.579 254.499 129.41C254.481 129.437 254.461 129.464 254.441 129.491C254.421 129.518 254.403 129.545 254.384 129.57C254.344 129.624 254.307 129.677 254.268 129.728C254.211 129.808 254.152 129.886 254.093 129.965C254.013 130.076 253.933 130.185 253.851 130.293L253.85 130.295C253.857 130.451 253.868 130.607 253.882 130.763C253.882 130.799 253.886 130.836 253.889 130.871C253.968 130.776 254.046 130.679 254.122 130.581C254.137 130.561 254.153 130.541 254.167 130.523C254.25 130.417 254.332 130.309 254.414 130.2C254.419 130.193 254.423 130.187 254.43 130.18C254.435 130.172 254.439 130.165 254.446 130.157C254.45 130.152 254.453 130.148 254.455 130.143L254.456 130.141C254.465 130.091 254.476 130.04 254.489 129.99ZM255.834 142.553C255.856 141.865 255.928 141.185 256.06 140.504C256.238 139.669 256.382 138.823 256.622 138.003C256.66 137.862 256.697 137.72 256.734 137.576C256.738 137.553 256.74 137.53 256.744 137.506C256.811 136.99 256.912 136.48 257.006 135.969C257.101 135.536 257.19 135.104 257.301 134.675C257.295 134.677 257.292 134.68 257.287 134.683C257.279 134.688 257.271 134.692 257.263 134.698C257.076 134.816 256.893 134.94 256.712 135.067C256.612 135.135 256.514 135.205 256.416 135.276C256.413 135.279 256.408 135.281 256.404 135.284C256.013 136.389 255.675 137.515 255.392 138.653C255.399 138.67 255.407 138.688 255.416 138.705C255.408 138.785 255.397 138.863 255.389 138.942C255.339 139.481 255.292 140.021 255.274 140.562C255.235 141.391 255.233 142.222 255.265 143.053C255.267 143.096 255.269 143.138 255.273 143.182C255.354 143.105 255.437 143.03 255.521 142.959C255.561 142.922 255.603 142.886 255.647 142.85C255.689 142.814 255.731 142.778 255.775 142.743C255.793 142.728 255.811 142.713 255.83 142.699C255.832 142.651 255.832 142.603 255.835 142.553L255.834 142.553ZM280.076 143.083C279.866 143.195 279.654 143.305 279.438 143.411C279.348 143.458 279.256 143.504 279.163 143.547L279.16 143.548C278.987 143.72 278.81 143.892 278.631 144.06L278.457 144.21C278.446 144.219 278.435 144.23 278.423 144.241L278.235 144.401L277.88 144.709L277.874 144.714L277.55 144.993C277.368 145.145 277.197 145.311 277.006 145.455L276.439 145.889L275.872 146.322C275.679 146.464 275.498 146.618 275.295 146.745C275.114 146.866 274.934 146.987 274.752 147.109C274.797 147.004 274.839 146.899 274.884 146.795C274.976 146.574 275.069 146.353 275.16 146.134C275.231 145.965 275.303 145.794 275.376 145.626C275.406 145.558 275.433 145.492 275.462 145.426C275.487 145.367 275.513 145.309 275.54 145.251C275.587 145.138 275.636 145.029 275.684 144.919C275.54 144.977 275.4 145.036 275.255 145.095C275.247 145.098 275.24 145.1 275.233 145.104C275.174 145.248 275.12 145.393 275.069 145.54L275.06 145.564C275.036 145.628 275.015 145.69 274.994 145.756L274.993 145.758C274.961 145.852 274.93 145.947 274.902 146.04C274.809 146.337 274.726 146.637 274.66 146.938C274.639 147.03 274.62 147.12 274.601 147.21C274.043 147.588 273.483 147.964 272.893 148.292L272.276 148.655L271.969 148.837L271.65 148.998L270.374 149.647C270.164 149.761 269.944 149.854 269.725 149.946L269.067 150.228C268.627 150.414 268.193 150.615 267.739 150.764L266.708 151.137C267.43 150.696 268.117 150.202 268.755 149.646C268.842 149.57 268.929 149.495 269.013 149.417C269.931 148.611 270.81 147.764 271.65 146.877C271.72 146.805 271.79 146.73 271.858 146.655L271.861 146.654C271.926 146.581 271.992 146.512 272.055 146.439C272.11 146.384 272.161 146.328 272.21 146.271C272.123 146.298 272.036 146.325 271.948 146.347C271.946 146.348 271.945 146.35 271.943 146.35C271.843 146.378 271.743 146.405 271.642 146.429C271.764 146.34 271.883 146.251 272.003 146.16C272.162 146.04 272.319 145.916 272.475 145.788C272.475 145.788 272.476 145.787 272.477 145.787C272.538 145.739 272.601 145.691 272.661 145.642C272.722 145.592 272.786 145.542 272.845 145.493C272.742 145.529 272.639 145.563 272.537 145.597C272.535 145.597 272.535 145.598 272.535 145.598C272.279 145.68 272.021 145.763 271.761 145.844C271.501 145.918 271.239 145.987 270.973 146.045L270.971 146.044C270.927 146.094 270.879 146.141 270.832 146.19C270.848 146.149 270.863 146.106 270.878 146.064C270.775 146.086 270.674 146.104 270.572 146.121C270.552 146.251 270.531 146.38 270.509 146.509C270.357 146.655 270.203 146.801 270.055 146.95C270.008 147 269.96 147.046 269.913 147.093C269.498 147.505 269.057 147.885 268.615 148.267C268.441 148.415 268.269 148.566 268.098 148.718C268.098 148.718 268.096 148.719 268.095 148.721C268.071 148.74 268.049 148.762 268.026 148.781C267.47 149.254 266.881 149.671 266.262 150.046C266.12 150.134 265.977 150.217 265.833 150.3C265.428 150.527 265.015 150.74 264.591 150.937C264.649 150.809 264.705 150.679 264.756 150.55C264.788 150.47 264.819 150.388 264.847 150.306L264.86 150.268C264.879 150.215 264.896 150.164 264.912 150.113C265.035 149.741 265.13 149.357 265.199 148.97C265.22 148.859 265.238 148.748 265.253 148.637C265.259 148.603 265.263 148.571 265.267 148.536L265.268 148.535C265.269 148.524 265.27 148.514 265.272 148.504C265.274 148.491 265.275 148.478 265.275 148.463C265.28 148.438 265.282 148.413 265.285 148.387C265.289 148.371 265.291 148.353 265.29 148.336C265.3 148.259 265.308 148.18 265.312 148.101C265.327 147.957 265.335 147.81 265.338 147.664C265.344 147.482 265.343 147.301 265.337 147.12C265.33 146.878 265.313 146.636 265.284 146.396C265.279 146.346 265.271 146.295 265.264 146.244C265.257 146.195 265.249 146.146 265.241 146.097C265.224 145.981 265.203 145.866 265.177 145.75C265.145 145.583 265.104 145.415 265.056 145.249L265.057 145.247C265.046 145.201 265.031 145.158 265.017 145.113C265.001 145.057 264.984 145.003 264.961 144.946C264.912 144.786 264.85 144.628 264.781 144.471C264.773 144.45 264.764 144.429 264.754 144.409C264.75 144.397 264.743 144.386 264.738 144.374C264.739 144.421 264.738 144.467 264.739 144.512C264.74 144.516 264.739 144.518 264.74 144.522C264.74 144.613 264.742 144.704 264.743 144.793C264.743 144.885 264.743 144.976 264.745 145.067C264.745 145.133 264.746 145.198 264.746 145.264C264.746 145.314 264.746 145.367 264.747 145.42C264.747 145.603 264.745 145.784 264.743 145.966C264.743 146.021 264.741 146.075 264.739 146.129C264.737 146.227 264.735 146.324 264.731 146.421L264.73 146.423C264.728 146.477 264.727 146.529 264.723 146.583C264.725 146.596 264.723 146.608 264.723 146.621C264.717 146.752 264.71 146.882 264.703 147.012L264.702 147.014C264.702 147.045 264.699 147.078 264.697 147.109C264.688 147.237 264.679 147.366 264.669 147.493C264.658 147.641 264.644 147.79 264.629 147.936C264.628 147.952 264.624 147.968 264.623 147.983C264.618 148.048 264.61 148.111 264.601 148.175L264.6 148.177C264.594 148.257 264.584 148.338 264.574 148.416C264.558 148.541 264.542 148.668 264.521 148.794C264.514 148.852 264.506 148.911 264.496 148.969C264.48 149.077 264.462 149.184 264.444 149.291C264.384 149.646 264.314 149.998 264.236 150.351C264.234 150.363 264.23 150.376 264.228 150.388L264.226 150.394C264.213 150.454 264.2 150.515 264.184 150.575L264.183 150.577C264.14 150.779 264.09 150.979 264.039 151.182C263.829 151.27 263.62 151.352 263.409 151.431C263.261 151.485 263.115 151.538 262.967 151.588C263.71 151.552 264.456 151.493 265.199 151.42C265.396 151.4 265.591 151.377 265.787 151.35C266.854 151.183 267.908 150.976 268.949 150.718L269.865 150.482L270.769 150.209C271.041 150.135 271.3 150.036 271.564 149.944C271.634 149.917 271.705 149.889 271.774 149.86C271.452 149.92 271.131 149.978 270.81 150.048C270.443 150.122 270.073 150.204 269.707 150.294L269.851 150.236C270.076 150.148 270.3 150.059 270.515 149.95L271.822 149.329L272.147 149.173L272.463 148.996L273.097 148.645C275.35 147.406 277.428 145.867 279.309 144.112C279.422 144.01 279.532 143.907 279.64 143.801C280.002 143.457 280.355 143.106 280.699 142.747C280.495 142.861 280.287 142.975 280.078 143.085L280.076 143.083ZM254.501 129.301C254.5 129.025 254.506 128.751 254.522 128.477C254.546 127.919 254.595 127.361 254.683 126.81C254.796 125.986 254.978 125.17 255.215 124.37C255.251 124.303 255.289 124.236 255.329 124.17C255.271 124.22 255.212 124.269 255.153 124.318C255.091 124.368 255.03 124.418 254.968 124.468C254.891 124.532 254.813 124.594 254.733 124.654C254.653 124.715 254.573 124.776 254.493 124.834C254.159 125.081 253.814 125.312 253.457 125.526C253.44 125.588 253.426 125.648 253.408 125.709C253.365 125.871 253.322 126.031 253.281 126.194C253.22 126.417 253.164 126.64 253.108 126.862L252.787 128.443C252.77 128.542 252.749 128.64 252.727 128.737C252.723 128.757 252.72 128.777 252.715 128.797C252.703 128.856 252.689 128.914 252.679 128.974C252.667 129.033 252.657 129.093 252.649 129.153C252.66 129.133 252.674 129.115 252.686 129.099C252.829 128.912 252.986 128.739 253.158 128.584C252.938 128.907 252.759 129.248 252.615 129.6C252.6 129.637 252.585 129.676 252.569 129.715L252.568 129.719L252.525 130.032L252.413 130.829C252.404 130.896 252.393 130.964 252.383 131.03C252.354 131.23 252.325 131.429 252.314 131.63C252.296 131.876 252.276 132.122 252.257 132.366C252.36 132.233 252.463 132.1 252.568 131.968C252.58 131.951 252.593 131.937 252.606 131.92C252.612 131.871 252.62 131.824 252.627 131.778C252.765 130.871 252.95 129.973 253.178 129.085C253.434 128.038 253.747 127.008 254.108 125.989C254.063 126.23 254.021 126.471 253.985 126.711C253.898 127.288 253.855 127.868 253.833 128.448C253.813 129.027 253.812 129.608 253.844 130.183C253.845 130.188 253.844 130.19 253.845 130.194C253.845 130.228 253.849 130.259 253.852 130.294C253.934 130.185 254.014 130.076 254.095 129.965C254.154 129.886 254.213 129.808 254.269 129.729C254.308 129.677 254.346 129.625 254.385 129.571C254.405 129.546 254.423 129.518 254.442 129.492C254.462 129.465 254.482 129.438 254.5 129.41L254.501 129.409C254.5 129.373 254.5 129.337 254.502 129.301L254.501 129.301ZM263.087 115.103C263.08 115.107 263.074 115.111 263.07 115.116C263.058 115.175 263.042 115.233 263.028 115.291L263.028 115.293C263.025 115.301 263.025 115.307 263.023 115.314C263.01 115.369 262.995 115.425 262.981 115.477C262.976 115.498 262.97 115.522 262.962 115.542C262.901 115.555 262.84 115.567 262.778 115.575C262.743 115.641 262.707 115.709 262.671 115.774C262.639 115.837 262.607 115.898 262.574 115.958C262.703 115.83 262.829 115.703 262.954 115.572L262.955 115.57C262.958 115.567 262.96 115.565 262.964 115.56C262.973 115.553 262.98 115.545 262.988 115.535C263.111 115.411 263.233 115.285 263.352 115.158C263.595 114.901 263.834 114.642 264.071 114.379C263.738 114.615 263.41 114.857 263.087 115.104L263.087 115.103ZM256.405 135.284L256.406 135.28C256.428 135.216 256.451 135.15 256.476 135.085C256.568 134.825 256.666 134.566 256.767 134.306C256.535 134.495 256.31 134.693 256.095 134.901L256.095 134.902C256.049 135.089 256.005 135.276 255.961 135.463C255.947 135.521 255.935 135.58 255.921 135.639C255.912 135.671 255.905 135.705 255.897 135.738C255.794 136.269 255.681 136.799 255.603 137.333C255.55 137.637 255.509 137.945 255.472 138.253C255.347 137.818 255.259 137.372 255.192 136.922C255.171 136.781 255.15 136.642 255.131 136.502C255.13 136.493 255.13 136.487 255.128 136.48L255.129 136.478C255.073 136.063 255.025 135.648 254.971 135.232C254.939 134.955 254.903 134.677 254.868 134.4C254.908 134.188 254.95 133.975 254.993 133.765C255.033 133.583 255.074 133.399 255.12 133.219C255.256 132.645 255.414 132.078 255.597 131.52C255.648 131.367 255.7 131.217 255.757 131.066L255.759 131.058C255.802 130.936 255.844 130.819 255.893 130.698C256.253 129.749 256.686 128.836 257.182 127.944C257.343 127.644 257.511 127.349 257.686 127.053L257.686 127.051C257.699 127.026 257.713 127.003 257.728 126.979C257.873 126.73 258.022 126.483 258.173 126.236C258.225 126.149 258.275 126.063 258.329 125.976C258.44 125.789 258.555 125.602 258.67 125.416C258.757 125.276 258.844 125.134 258.933 124.994C259.024 124.842 259.116 124.691 259.207 124.539C259.301 124.382 259.396 124.223 259.491 124.066C260.081 123.081 260.652 122.085 261.178 121.06C260.739 121.586 260.316 122.124 259.902 122.668C259.902 122.669 259.899 122.671 259.899 122.673C259.87 122.711 259.84 122.751 259.812 122.79C259.45 123.267 259.098 123.749 258.748 124.235C258.536 124.525 258.328 124.82 258.124 125.118C258.123 125.121 258.119 125.125 258.117 125.13L258.117 125.132C257.946 125.38 257.778 125.63 257.609 125.881C257.388 126.221 257.173 126.566 256.963 126.916C256.828 127.143 256.695 127.373 256.566 127.606C256.542 127.652 256.517 127.699 256.491 127.744C256.201 128.295 255.93 128.858 255.693 129.437C255.445 130.067 255.227 130.712 255.071 131.37C254.916 132 254.805 132.642 254.741 133.286C254.693 132.825 254.646 132.364 254.606 131.902C254.557 131.322 254.52 130.741 254.509 130.16C254.509 130.13 254.508 130.103 254.508 130.073L254.508 130.071C254.506 130.036 254.505 130 254.506 129.967C254.504 129.949 254.504 129.932 254.505 129.916C254.499 129.941 254.492 129.966 254.49 129.991C254.477 130.041 254.465 130.092 254.456 130.142L254.456 130.143C254.454 130.149 254.451 130.152 254.447 130.157C254.44 130.165 254.435 130.172 254.43 130.181C254.424 130.187 254.419 130.194 254.415 130.201C254.333 130.31 254.251 130.418 254.168 130.524C254.153 130.542 254.138 130.562 254.122 130.582C254.046 130.68 253.968 130.777 253.889 130.872L253.889 130.873C253.932 131.422 253.99 131.966 254.061 132.507C254.108 132.877 254.163 133.245 254.223 133.612C254.257 133.82 254.292 134.03 254.329 134.237C254.334 134.283 254.343 134.33 254.351 134.375C254.368 134.471 254.383 134.567 254.403 134.662L254.402 134.664C254.537 135.44 254.687 136.21 254.854 136.986C254.875 137.073 254.896 137.158 254.919 137.244C254.919 137.244 254.918 137.246 254.92 137.247C254.919 137.255 254.922 137.26 254.923 137.267C255.043 137.734 255.187 138.196 255.384 138.635L255.393 138.653C255.675 137.515 256.013 136.389 256.405 135.284L256.405 135.284ZM254.489 129.99C254.491 129.966 254.498 129.941 254.505 129.915C254.5 129.745 254.499 129.579 254.499 129.41C254.481 129.437 254.461 129.464 254.441 129.491C254.421 129.518 254.403 129.545 254.384 129.57C254.344 129.624 254.307 129.677 254.268 129.728C254.211 129.808 254.152 129.886 254.093 129.965C254.013 130.076 253.933 130.185 253.851 130.293L253.85 130.295C253.857 130.451 253.868 130.607 253.882 130.763C253.882 130.799 253.886 130.836 253.889 130.871C253.968 130.776 254.046 130.679 254.122 130.581C254.137 130.561 254.153 130.541 254.167 130.523C254.25 130.417 254.332 130.309 254.414 130.2C254.419 130.193 254.423 130.187 254.43 130.18C254.435 130.172 254.439 130.165 254.446 130.157C254.45 130.152 254.453 130.148 254.455 130.143L254.456 130.141C254.465 130.091 254.476 130.04 254.489 129.99ZM255.834 142.553C255.856 141.865 255.928 141.185 256.06 140.504C256.238 139.669 256.382 138.823 256.622 138.003C256.66 137.862 256.697 137.72 256.734 137.576C256.738 137.553 256.74 137.53 256.744 137.506C256.811 136.99 256.912 136.48 257.006 135.969C257.101 135.536 257.19 135.104 257.301 134.675C257.295 134.677 257.292 134.68 257.287 134.683C257.279 134.688 257.271 134.692 257.263 134.698C257.076 134.816 256.893 134.94 256.712 135.067C256.612 135.135 256.514 135.205 256.416 135.276C256.413 135.279 256.408 135.281 256.404 135.284C256.013 136.389 255.675 137.515 255.392 138.653C255.399 138.67 255.407 138.688 255.416 138.705C255.408 138.785 255.397 138.863 255.389 138.942C255.339 139.481 255.292 140.021 255.274 140.562C255.235 141.391 255.233 142.222 255.265 143.053C255.267 143.096 255.269 143.138 255.273 143.182C255.354 143.105 255.437 143.03 255.521 142.959C255.561 142.922 255.603 142.886 255.647 142.85C255.689 142.814 255.731 142.778 255.775 142.743C255.793 142.728 255.811 142.713 255.83 142.699C255.832 142.651 255.832 142.603 255.835 142.553L255.834 142.553ZM280.076 143.083C279.866 143.195 279.654 143.305 279.438 143.411C279.348 143.458 279.256 143.504 279.163 143.547L279.16 143.548C278.987 143.72 278.81 143.892 278.631 144.06L278.457 144.21C278.446 144.219 278.435 144.23 278.423 144.241L278.235 144.401L277.88 144.709L277.874 144.714L277.55 144.993C277.368 145.145 277.197 145.311 277.006 145.455L276.439 145.889L275.872 146.322C275.679 146.464 275.498 146.618 275.295 146.745C275.114 146.866 274.934 146.987 274.752 147.109C274.797 147.004 274.839 146.899 274.884 146.795C274.976 146.574 275.069 146.353 275.16 146.134C275.231 145.965 275.303 145.794 275.376 145.626C275.406 145.558 275.433 145.492 275.462 145.426C275.487 145.367 275.513 145.309 275.54 145.251C275.587 145.138 275.636 145.029 275.684 144.919C275.54 144.977 275.4 145.036 275.255 145.095C275.247 145.098 275.24 145.1 275.233 145.104C275.174 145.248 275.12 145.393 275.069 145.54L275.06 145.564C275.036 145.628 275.015 145.69 274.994 145.756L274.993 145.758C274.961 145.852 274.93 145.947 274.902 146.04C274.809 146.337 274.726 146.637 274.66 146.938C274.639 147.03 274.62 147.12 274.601 147.21C274.043 147.588 273.483 147.964 272.893 148.292L272.276 148.655L271.969 148.837L271.65 148.998L270.374 149.647C270.164 149.761 269.944 149.854 269.725 149.946L269.067 150.228C268.627 150.414 268.193 150.615 267.739 150.764L266.708 151.137C267.43 150.696 268.117 150.202 268.755 149.646C268.842 149.57 268.929 149.495 269.013 149.417C269.931 148.611 270.81 147.764 271.65 146.877C271.72 146.805 271.79 146.73 271.858 146.655L271.861 146.654C271.926 146.581 271.992 146.512 272.055 146.439C272.11 146.384 272.161 146.328 272.21 146.271C272.123 146.298 272.036 146.325 271.948 146.347C271.946 146.348 271.945 146.35 271.943 146.35C271.843 146.378 271.743 146.405 271.642 146.429C271.764 146.34 271.883 146.251 272.003 146.16C272.162 146.04 272.319 145.916 272.475 145.788C272.475 145.788 272.476 145.787 272.477 145.787C272.538 145.739 272.601 145.691 272.661 145.642C272.722 145.592 272.786 145.542 272.845 145.493C272.742 145.529 272.639 145.563 272.537 145.597C272.535 145.597 272.535 145.598 272.535 145.598C272.279 145.68 272.021 145.763 271.761 145.844C271.501 145.918 271.239 145.987 270.973 146.045L270.971 146.044C270.927 146.094 270.879 146.141 270.832 146.19C270.848 146.149 270.863 146.106 270.878 146.064C270.775 146.086 270.674 146.104 270.572 146.121C270.552 146.251 270.531 146.38 270.509 146.509C270.357 146.655 270.203 146.801 270.055 146.95C270.008 147 269.96 147.046 269.913 147.093C269.498 147.505 269.057 147.885 268.615 148.267C268.441 148.415 268.269 148.566 268.098 148.718C268.098 148.718 268.096 148.719 268.095 148.721C268.071 148.74 268.049 148.762 268.026 148.781C267.47 149.254 266.881 149.671 266.262 150.046C266.12 150.134 265.977 150.217 265.833 150.3C265.428 150.527 265.015 150.74 264.591 150.937C264.649 150.809 264.705 150.679 264.756 150.55C264.788 150.47 264.819 150.388 264.847 150.306L264.86 150.268C264.879 150.215 264.896 150.164 264.912 150.113C265.035 149.741 265.13 149.357 265.199 148.97C265.22 148.859 265.238 148.748 265.253 148.637C265.259 148.603 265.263 148.571 265.267 148.536L265.268 148.535C265.269 148.524 265.27 148.514 265.272 148.504C265.274 148.491 265.275 148.478 265.275 148.463C265.28 148.438 265.282 148.413 265.285 148.387C265.289 148.371 265.291 148.353 265.29 148.336C265.3 148.259 265.308 148.18 265.312 148.101C265.327 147.957 265.335 147.81 265.338 147.664C265.344 147.482 265.343 147.301 265.337 147.12C265.33 146.878 265.313 146.636 265.284 146.396C265.279 146.346 265.271 146.295 265.264 146.244C265.257 146.195 265.249 146.146 265.241 146.097C265.224 145.981 265.203 145.866 265.177 145.75C265.145 145.583 265.104 145.415 265.056 145.249L265.057 145.247C265.046 145.201 265.031 145.158 265.017 145.113C265.001 145.057 264.984 145.003 264.961 144.946C264.912 144.786 264.85 144.628 264.781 144.471C264.773 144.45 264.764 144.429 264.754 144.409C264.75 144.397 264.743 144.386 264.738 144.374C264.739 144.421 264.738 144.467 264.739 144.512C264.74 144.516 264.739 144.518 264.74 144.522C264.74 144.613 264.742 144.704 264.743 144.793C264.743 144.885 264.743 144.976 264.745 145.067C264.745 145.133 264.746 145.198 264.746 145.264C264.746 145.314 264.746 145.367 264.747 145.42C264.747 145.603 264.745 145.784 264.743 145.966C264.743 146.021 264.741 146.075 264.739 146.129C264.737 146.227 264.735 146.324 264.731 146.421L264.73 146.423C264.728 146.477 264.727 146.529 264.723 146.583C264.725 146.596 264.723 146.608 264.723 146.621C264.717 146.752 264.71 146.882 264.703 147.012L264.702 147.014C264.702 147.045 264.699 147.078 264.697 147.109C264.688 147.237 264.679 147.366 264.669 147.493C264.658 147.641 264.644 147.79 264.629 147.936C264.628 147.952 264.624 147.968 264.623 147.983C264.618 148.048 264.61 148.111 264.601 148.175L264.6 148.177C264.594 148.257 264.584 148.338 264.574 148.416C264.558 148.541 264.542 148.668 264.521 148.794C264.514 148.852 264.506 148.911 264.496 148.969C264.48 149.077 264.462 149.184 264.444 149.291C264.384 149.646 264.314 149.998 264.236 150.351C264.234 150.363 264.23 150.376 264.228 150.388L264.226 150.394C264.213 150.454 264.2 150.515 264.184 150.575L264.183 150.577C264.14 150.779 264.09 150.979 264.039 151.182C263.829 151.27 263.62 151.352 263.409 151.431C263.261 151.485 263.115 151.538 262.967 151.588C263.71 151.552 264.456 151.493 265.199 151.42C265.396 151.4 265.591 151.377 265.787 151.35C266.854 151.183 267.908 150.976 268.949 150.718L269.865 150.482L270.769 150.209C271.041 150.135 271.3 150.036 271.564 149.944C271.634 149.917 271.705 149.889 271.774 149.86C271.452 149.92 271.131 149.978 270.81 150.048C270.443 150.122 270.073 150.204 269.707 150.294L269.851 150.236C270.076 150.148 270.3 150.059 270.515 149.95L271.822 149.329L272.147 149.173L272.463 148.996L273.097 148.645C275.35 147.406 277.428 145.867 279.309 144.112C279.422 144.01 279.532 143.907 279.64 143.801C280.002 143.457 280.355 143.106 280.699 142.747C280.495 142.861 280.287 142.975 280.078 143.085L280.076 143.083ZM254.501 129.301C254.5 129.025 254.506 128.751 254.522 128.477C254.546 127.919 254.595 127.361 254.683 126.81C254.796 125.986 254.978 125.17 255.215 124.37C255.251 124.303 255.289 124.236 255.329 124.17C255.271 124.22 255.212 124.269 255.153 124.318C255.091 124.368 255.03 124.418 254.968 124.468C254.891 124.532 254.813 124.594 254.733 124.654C254.653 124.715 254.573 124.776 254.493 124.834C254.159 125.081 253.814 125.312 253.457 125.526C253.44 125.588 253.426 125.648 253.408 125.709C253.365 125.871 253.322 126.031 253.281 126.194C253.22 126.417 253.164 126.64 253.108 126.862L252.787 128.443C252.77 128.542 252.749 128.64 252.727 128.737C252.723 128.757 252.72 128.777 252.715 128.797C252.703 128.856 252.689 128.914 252.679 128.974C252.667 129.033 252.657 129.093 252.649 129.153C252.66 129.133 252.674 129.115 252.686 129.099C252.829 128.912 252.986 128.739 253.158 128.584C252.938 128.907 252.759 129.248 252.615 129.6C252.6 129.637 252.585 129.676 252.569 129.715L252.568 129.719L252.525 130.032L252.413 130.829C252.404 130.896 252.393 130.964 252.383 131.03C252.354 131.23 252.325 131.429 252.314 131.63C252.296 131.876 252.276 132.122 252.257 132.366C252.36 132.233 252.463 132.1 252.568 131.968C252.58 131.951 252.593 131.937 252.606 131.92C252.612 131.871 252.62 131.824 252.627 131.778C252.765 130.871 252.95 129.973 253.178 129.085C253.434 128.038 253.747 127.008 254.108 125.989C254.063 126.23 254.021 126.471 253.985 126.711C253.898 127.288 253.855 127.868 253.833 128.448C253.813 129.027 253.812 129.608 253.844 130.183C253.845 130.188 253.844 130.19 253.845 130.194C253.845 130.228 253.849 130.259 253.852 130.294C253.934 130.185 254.014 130.076 254.095 129.965C254.154 129.886 254.213 129.808 254.269 129.729C254.308 129.677 254.346 129.625 254.385 129.571C254.405 129.546 254.423 129.518 254.442 129.492C254.462 129.465 254.482 129.438 254.5 129.41L254.501 129.409C254.5 129.373 254.5 129.337 254.502 129.301L254.501 129.301ZM263.087 115.103C263.08 115.107 263.074 115.111 263.07 115.116C263.058 115.175 263.042 115.233 263.028 115.291L263.028 115.293C263.025 115.301 263.025 115.307 263.023 115.314C263.01 115.369 262.995 115.425 262.981 115.477C262.976 115.498 262.97 115.522 262.962 115.542C262.901 115.555 262.84 115.567 262.778 115.575C262.743 115.641 262.707 115.709 262.671 115.774C262.639 115.837 262.607 115.898 262.574 115.958C262.703 115.83 262.829 115.703 262.954 115.572L262.955 115.57C262.958 115.567 262.96 115.565 262.964 115.56C262.973 115.553 262.98 115.545 262.988 115.535C263.111 115.411 263.233 115.285 263.352 115.158C263.595 114.901 263.834 114.642 264.071 114.379C263.738 114.615 263.41 114.857 263.087 115.104L263.087 115.103ZM256.405 135.284L256.406 135.28C256.428 135.216 256.451 135.15 256.476 135.085C256.568 134.825 256.666 134.566 256.767 134.306C256.535 134.495 256.31 134.693 256.095 134.901L256.095 134.902C256.049 135.089 256.005 135.276 255.961 135.463C255.947 135.521 255.935 135.58 255.921 135.639C255.912 135.671 255.905 135.705 255.897 135.738C255.794 136.269 255.681 136.799 255.603 137.333C255.55 137.637 255.509 137.945 255.472 138.253C255.347 137.818 255.259 137.372 255.192 136.922C255.171 136.781 255.15 136.642 255.131 136.502C255.13 136.493 255.13 136.487 255.128 136.48L255.129 136.478C255.073 136.063 255.025 135.648 254.971 135.232C254.939 134.955 254.903 134.677 254.868 134.4C254.908 134.188 254.95 133.975 254.993 133.765C255.033 133.583 255.074 133.399 255.12 133.219C255.256 132.645 255.414 132.078 255.597 131.52C255.648 131.367 255.7 131.217 255.757 131.066L255.759 131.058C255.802 130.936 255.844 130.819 255.893 130.698C256.253 129.749 256.686 128.836 257.182 127.944C257.343 127.644 257.511 127.349 257.686 127.053L257.686 127.051C257.699 127.026 257.713 127.003 257.728 126.979C257.873 126.73 258.022 126.483 258.173 126.236C258.225 126.149 258.275 126.063 258.329 125.976C258.44 125.789 258.555 125.602 258.67 125.416C258.757 125.276 258.844 125.134 258.933 124.994C259.024 124.842 259.116 124.691 259.207 124.539C259.301 124.382 259.396 124.223 259.491 124.066C260.081 123.081 260.652 122.085 261.178 121.06C260.739 121.586 260.316 122.124 259.902 122.668C259.902 122.669 259.899 122.671 259.899 122.673C259.87 122.711 259.84 122.751 259.812 122.79C259.45 123.267 259.098 123.749 258.748 124.235C258.536 124.525 258.328 124.82 258.124 125.118C258.123 125.121 258.119 125.125 258.117 125.13L258.117 125.132C257.946 125.38 257.778 125.63 257.609 125.881C257.388 126.221 257.173 126.566 256.963 126.916C256.828 127.143 256.695 127.373 256.566 127.606C256.542 127.652 256.517 127.699 256.491 127.744C256.201 128.295 255.93 128.858 255.693 129.437C255.445 130.067 255.227 130.712 255.071 131.37C254.916 132 254.805 132.642 254.741 133.286C254.693 132.825 254.646 132.364 254.606 131.902C254.557 131.322 254.52 130.741 254.509 130.16C254.509 130.13 254.508 130.103 254.508 130.073L254.508 130.071C254.506 130.036 254.505 130 254.506 129.967C254.504 129.949 254.504 129.932 254.505 129.916C254.499 129.941 254.492 129.966 254.49 129.991C254.477 130.041 254.465 130.092 254.456 130.142L254.456 130.143C254.454 130.149 254.451 130.152 254.447 130.157C254.44 130.165 254.435 130.172 254.43 130.181C254.424 130.187 254.419 130.194 254.415 130.201C254.333 130.31 254.251 130.418 254.168 130.524C254.153 130.542 254.138 130.562 254.122 130.582C254.046 130.68 253.968 130.777 253.889 130.872L253.889 130.873C253.932 131.422 253.99 131.966 254.061 132.507C254.108 132.877 254.163 133.245 254.223 133.612C254.257 133.82 254.292 134.03 254.329 134.237C254.334 134.283 254.343 134.33 254.351 134.375C254.368 134.471 254.383 134.567 254.403 134.662L254.402 134.664C254.537 135.44 254.687 136.21 254.854 136.986C254.875 137.073 254.896 137.158 254.919 137.244C254.919 137.244 254.918 137.246 254.92 137.247C254.919 137.255 254.922 137.26 254.923 137.267C255.043 137.734 255.187 138.196 255.384 138.635L255.393 138.653C255.675 137.515 256.013 136.389 256.405 135.284L256.405 135.284ZM254.489 129.99C254.491 129.966 254.498 129.941 254.505 129.915C254.5 129.745 254.499 129.579 254.499 129.41C254.481 129.437 254.461 129.464 254.441 129.491C254.421 129.518 254.403 129.545 254.384 129.57C254.344 129.624 254.307 129.677 254.268 129.728C254.211 129.808 254.152 129.886 254.093 129.965C254.013 130.076 253.933 130.185 253.851 130.293L253.85 130.295C253.857 130.451 253.868 130.607 253.882 130.763C253.882 130.799 253.886 130.836 253.889 130.871C253.968 130.776 254.046 130.679 254.122 130.581C254.137 130.561 254.153 130.541 254.167 130.523C254.25 130.417 254.332 130.309 254.414 130.2C254.419 130.193 254.423 130.187 254.43 130.18C254.435 130.172 254.439 130.165 254.446 130.157C254.45 130.152 254.453 130.148 254.455 130.143L254.456 130.141C254.465 130.091 254.476 130.04 254.489 129.99ZM255.834 142.553C255.856 141.865 255.928 141.185 256.06 140.504C256.238 139.669 256.382 138.823 256.622 138.003C256.66 137.862 256.697 137.72 256.734 137.576C256.738 137.553 256.74 137.53 256.744 137.506C256.811 136.99 256.912 136.48 257.006 135.969C257.101 135.536 257.19 135.104 257.301 134.675C257.295 134.677 257.292 134.68 257.287 134.683C257.279 134.688 257.271 134.692 257.263 134.698C257.076 134.816 256.893 134.94 256.712 135.067C256.612 135.135 256.514 135.205 256.416 135.276C256.413 135.279 256.408 135.281 256.404 135.284C256.013 136.389 255.675 137.515 255.392 138.653C255.399 138.67 255.407 138.688 255.416 138.705C255.408 138.785 255.397 138.863 255.389 138.942C255.339 139.481 255.292 140.021 255.274 140.562C255.235 141.391 255.233 142.222 255.265 143.053C255.267 143.096 255.269 143.138 255.273 143.182C255.354 143.105 255.437 143.03 255.521 142.959C255.561 142.922 255.603 142.886 255.647 142.85C255.689 142.814 255.731 142.778 255.775 142.743C255.793 142.728 255.811 142.713 255.83 142.699C255.832 142.651 255.832 142.603 255.835 142.553L255.834 142.553ZM265.694 138.295C265.694 138.289 265.696 138.281 265.698 138.276C265.706 138.228 265.714 138.182 265.723 138.132C265.711 138.143 265.698 138.153 265.686 138.164C265.414 138.402 265.139 138.638 264.862 138.87C264.795 139.232 264.735 139.597 264.68 139.961C264.946 139.746 265.21 139.526 265.471 139.303C265.491 139.286 265.512 139.268 265.529 139.251C265.58 138.932 265.636 138.612 265.694 138.295ZM270.127 134.62L270.114 134.628C270.02 134.681 269.925 134.735 269.833 134.789C269.737 134.844 269.647 134.899 269.553 134.957L269.014 135.316L268.493 135.706L268.077 136.05L267.991 136.122C267.827 136.265 267.669 136.412 267.515 136.565C267.505 136.577 267.494 136.588 267.482 136.598C267.414 136.668 267.346 136.737 267.279 136.808C267.203 136.887 267.128 136.969 267.056 137.05C266.916 137.209 266.78 137.372 266.65 137.54C266.584 137.627 266.518 137.713 266.455 137.8C266.455 137.8 266.452 137.802 266.451 137.803C266.39 137.89 266.328 137.978 266.268 138.066L265.916 138.612L265.594 139.177C265.588 139.187 265.582 139.198 265.576 139.208C265.778 139.041 265.974 138.87 266.166 138.697C266.713 138.219 267.245 137.725 267.764 137.219C267.958 137.025 268.149 136.83 268.338 136.632C268.597 136.364 268.852 136.09 269.102 135.814C269.125 135.869 269.151 135.922 269.172 135.976C269.188 136.009 269.204 136.042 269.218 136.076L269.298 136.002C269.277 135.976 269.256 135.948 269.233 135.923C269.198 135.877 269.16 135.834 269.123 135.79C269.438 135.44 269.747 135.088 270.045 134.724C270.073 134.689 270.1 134.654 270.127 134.619L270.127 134.62ZM280.076 143.083C279.866 143.195 279.654 143.305 279.438 143.411C279.348 143.458 279.256 143.504 279.163 143.547L279.16 143.548C278.987 143.72 278.81 143.892 278.631 144.06L278.457 144.21C278.446 144.219 278.435 144.23 278.423 144.241L278.235 144.401L277.88 144.709L277.874 144.714L277.55 144.993C277.368 145.145 277.197 145.311 277.006 145.455L276.439 145.889L275.872 146.322C275.679 146.464 275.498 146.618 275.295 146.745C275.114 146.866 274.934 146.987 274.752 147.109C274.797 147.004 274.839 146.899 274.884 146.795C274.976 146.574 275.069 146.353 275.16 146.134C275.231 145.965 275.303 145.794 275.376 145.626C275.406 145.558 275.433 145.492 275.462 145.426C275.487 145.367 275.513 145.309 275.54 145.251C275.587 145.138 275.636 145.029 275.684 144.919C275.54 144.977 275.4 145.036 275.255 145.095C275.247 145.098 275.24 145.1 275.233 145.104C275.174 145.248 275.12 145.393 275.069 145.54L275.06 145.564C275.036 145.628 275.015 145.69 274.994 145.756L274.993 145.758C274.961 145.852 274.93 145.947 274.902 146.04C274.809 146.337 274.726 146.637 274.66 146.938C274.639 147.03 274.62 147.12 274.601 147.21C274.043 147.588 273.483 147.964 272.893 148.292L272.276 148.655L271.969 148.837L271.65 148.998L270.374 149.647C270.164 149.761 269.944 149.854 269.725 149.946L269.067 150.228C268.627 150.414 268.193 150.615 267.739 150.764L266.708 151.137C267.43 150.696 268.117 150.202 268.755 149.646C268.842 149.57 268.929 149.495 269.013 149.417C269.931 148.611 270.81 147.764 271.65 146.877C271.72 146.805 271.79 146.73 271.858 146.655L271.861 146.654C271.926 146.581 271.992 146.512 272.055 146.439C272.11 146.384 272.161 146.328 272.21 146.271C272.123 146.298 272.036 146.325 271.948 146.347C271.946 146.348 271.945 146.35 271.943 146.35C271.843 146.378 271.743 146.405 271.642 146.429C271.764 146.34 271.883 146.251 272.003 146.16C272.162 146.04 272.319 145.916 272.475 145.788C272.475 145.788 272.476 145.787 272.477 145.787C272.538 145.739 272.601 145.691 272.661 145.642C272.722 145.592 272.786 145.542 272.845 145.493C272.742 145.529 272.639 145.563 272.537 145.597C272.535 145.597 272.535 145.598 272.535 145.598C272.279 145.68 272.021 145.763 271.761 145.844C271.501 145.918 271.239 145.987 270.973 146.045L270.971 146.044C270.927 146.094 270.879 146.141 270.832 146.19C270.848 146.149 270.863 146.106 270.878 146.064C270.775 146.086 270.674 146.104 270.572 146.121C270.552 146.251 270.531 146.38 270.509 146.509C270.357 146.655 270.203 146.801 270.055 146.95C270.008 147 269.96 147.046 269.913 147.093C269.498 147.505 269.057 147.885 268.615 148.267C268.441 148.415 268.269 148.566 268.098 148.718C268.098 148.718 268.096 148.719 268.095 148.721C268.071 148.74 268.049 148.762 268.026 148.781C267.47 149.254 266.881 149.671 266.262 150.046C266.12 150.134 265.977 150.217 265.833 150.3C265.428 150.527 265.015 150.74 264.591 150.937C264.649 150.809 264.705 150.679 264.756 150.55C264.788 150.47 264.819 150.388 264.847 150.306L264.86 150.268C264.879 150.215 264.896 150.164 264.912 150.113C265.035 149.741 265.13 149.357 265.199 148.97C265.22 148.859 265.238 148.748 265.253 148.637C265.259 148.603 265.263 148.571 265.267 148.536L265.268 148.535C265.269 148.524 265.27 148.514 265.272 148.504C265.274 148.491 265.275 148.478 265.275 148.463C265.28 148.438 265.282 148.413 265.285 148.387C265.289 148.371 265.291 148.353 265.29 148.336C265.3 148.259 265.308 148.18 265.312 148.101C265.327 147.957 265.335 147.81 265.338 147.664C265.344 147.482 265.343 147.301 265.337 147.12C265.33 146.878 265.313 146.636 265.284 146.396C265.279 146.346 265.271 146.295 265.264 146.244C265.257 146.195 265.249 146.146 265.241 146.097C265.224 145.981 265.203 145.866 265.177 145.75C265.145 145.583 265.104 145.415 265.056 145.249L265.057 145.247C265.046 145.201 265.031 145.158 265.017 145.113C265.001 145.057 264.984 145.003 264.961 144.946C264.912 144.786 264.85 144.628 264.781 144.471C264.773 144.45 264.764 144.429 264.754 144.409C264.75 144.397 264.743 144.386 264.738 144.374C264.739 144.421 264.738 144.467 264.739 144.512C264.74 144.516 264.739 144.518 264.74 144.522C264.74 144.613 264.742 144.704 264.743 144.793C264.743 144.885 264.743 144.976 264.745 145.067C264.745 145.133 264.746 145.198 264.746 145.264C264.746 145.314 264.746 145.367 264.747 145.42C264.747 145.603 264.745 145.784 264.743 145.966C264.743 146.021 264.741 146.075 264.739 146.129C264.737 146.227 264.735 146.324 264.731 146.421L264.73 146.423C264.728 146.477 264.727 146.529 264.723 146.583C264.725 146.596 264.723 146.608 264.723 146.621C264.717 146.752 264.71 146.882 264.703 147.012L264.702 147.014C264.702 147.045 264.699 147.078 264.697 147.109C264.688 147.237 264.679 147.366 264.669 147.493C264.658 147.641 264.644 147.79 264.629 147.936C264.628 147.952 264.624 147.968 264.623 147.983C264.618 148.048 264.61 148.111 264.601 148.175L264.6 148.177C264.594 148.257 264.584 148.338 264.574 148.416C264.558 148.541 264.542 148.668 264.521 148.794C264.514 148.852 264.506 148.911 264.496 148.969C264.48 149.077 264.462 149.184 264.444 149.291C264.384 149.646 264.314 149.998 264.236 150.351C264.234 150.363 264.23 150.376 264.228 150.388L264.226 150.394C264.213 150.454 264.2 150.515 264.184 150.575L264.183 150.577C264.14 150.779 264.09 150.979 264.039 151.182C263.829 151.27 263.62 151.352 263.409 151.431C263.261 151.485 263.115 151.538 262.967 151.588C263.71 151.552 264.456 151.493 265.199 151.42C265.396 151.4 265.591 151.377 265.787 151.35C266.854 151.183 267.908 150.976 268.949 150.718L269.865 150.482L270.769 150.209C271.041 150.135 271.3 150.036 271.564 149.944C271.634 149.917 271.705 149.889 271.774 149.86C271.452 149.92 271.131 149.978 270.81 150.048C270.443 150.122 270.073 150.204 269.707 150.294L269.851 150.236C270.076 150.148 270.3 150.059 270.515 149.95L271.822 149.329L272.147 149.173L272.463 148.996L273.097 148.645C275.35 147.406 277.428 145.867 279.309 144.112C279.422 144.01 279.532 143.907 279.64 143.801C280.002 143.457 280.355 143.106 280.699 142.747C280.495 142.861 280.287 142.975 280.078 143.085L280.076 143.083ZM268.256 136.688L267.824 137.012L267.407 137.358C266.948 137.759 266.53 138.208 266.167 138.697C266.714 138.219 267.245 137.725 267.765 137.218C267.959 137.025 268.15 136.83 268.339 136.632L268.256 136.688L268.256 136.688ZM255.131 136.502C255.13 136.493 255.13 136.487 255.128 136.48L255.129 136.478C255.072 136.063 255.025 135.648 254.971 135.232C254.938 134.955 254.902 134.677 254.868 134.4C254.907 134.188 254.95 133.975 254.993 133.765C255.033 133.583 255.074 133.399 255.119 133.219C255.255 132.644 255.414 132.078 255.597 131.52C255.648 131.367 255.7 131.217 255.756 131.066L255.759 131.058C255.801 130.936 255.844 130.818 255.892 130.698C256.253 129.749 256.686 128.836 257.182 127.944C257.343 127.644 257.511 127.348 257.685 127.053L257.686 127.051C257.699 127.026 257.713 127.003 257.728 126.979C257.873 126.73 258.022 126.483 258.173 126.236C258.224 126.148 258.275 126.063 258.328 125.976C258.44 125.789 258.555 125.602 258.67 125.416C258.757 125.276 258.844 125.133 258.933 124.993C259.023 124.841 259.116 124.69 259.206 124.539C259.301 124.382 259.396 124.223 259.49 124.066C260.08 123.081 260.651 122.084 261.177 121.06C260.738 121.586 260.316 122.124 259.902 122.667C259.901 122.669 259.899 122.671 259.898 122.672C259.87 122.711 259.839 122.751 259.811 122.79C259.45 123.267 259.097 123.749 258.748 124.234C258.535 124.525 258.328 124.819 258.124 125.118C258.122 125.121 258.119 125.124 258.117 125.13L258.116 125.132C257.946 125.38 257.777 125.63 257.608 125.88C257.387 126.221 257.173 126.565 256.963 126.916C256.828 127.143 256.695 127.373 256.566 127.606C256.541 127.652 256.517 127.699 256.49 127.744C256.2 128.295 255.929 128.858 255.692 129.437C255.445 130.067 255.227 130.712 255.071 131.37C254.915 132 254.804 132.642 254.741 133.286C254.692 132.824 254.646 132.364 254.606 131.901C254.556 131.322 254.52 130.74 254.509 130.16C254.508 130.13 254.508 130.102 254.507 130.073L254.508 130.071C254.505 130.036 254.505 130 254.506 129.967C254.499 129.975 254.495 129.982 254.489 129.991C254.476 130.041 254.465 130.092 254.456 130.141L254.455 130.143C254.453 130.149 254.45 130.152 254.446 130.157C254.439 130.165 254.435 130.172 254.43 130.181C254.423 130.187 254.419 130.194 254.414 130.201C254.332 130.309 254.251 130.418 254.167 130.524C254.153 130.542 254.137 130.562 254.122 130.582C254.046 130.68 253.968 130.777 253.889 130.871L253.888 130.873C253.932 131.421 253.989 131.966 254.061 132.507C254.107 132.877 254.163 133.245 254.223 133.612C254.256 133.82 254.291 134.03 254.329 134.236C254.334 134.282 254.343 134.33 254.35 134.375C254.367 134.471 254.383 134.567 254.402 134.662L254.402 134.664C254.537 135.44 254.687 136.21 254.854 136.986C254.874 137.073 254.895 137.158 254.918 137.244C254.918 137.244 254.918 137.246 254.919 137.246C254.919 137.255 254.921 137.26 254.923 137.267C254.971 137.079 255.021 136.894 255.074 136.708C255.094 136.639 255.113 136.572 255.131 136.502L255.131 136.502ZM263.087 115.103C263.079 115.107 263.074 115.111 263.07 115.116C263.058 115.175 263.042 115.233 263.028 115.291L263.027 115.293C263.025 115.301 263.025 115.307 263.022 115.314C263.01 115.369 262.994 115.425 262.98 115.477C262.975 115.498 262.969 115.522 262.962 115.542C262.901 115.555 262.84 115.567 262.778 115.575C262.742 115.641 262.706 115.709 262.671 115.774C262.639 115.837 262.607 115.898 262.573 115.958C262.702 115.83 262.828 115.703 262.954 115.571L262.954 115.57C262.957 115.566 262.96 115.565 262.964 115.56C262.973 115.553 262.98 115.545 262.987 115.535C263.111 115.411 263.232 115.285 263.352 115.158C263.595 114.901 263.834 114.642 264.071 114.379C263.738 114.615 263.41 114.857 263.086 115.103L263.087 115.103ZM256.095 134.901L256.094 134.903C256.048 135.089 256.005 135.276 255.961 135.463C255.947 135.522 255.935 135.581 255.921 135.639C256.001 135.578 256.081 135.518 256.163 135.458C256.211 135.424 256.256 135.389 256.304 135.355C256.338 135.331 256.371 135.308 256.404 135.284L256.406 135.281C256.428 135.217 256.451 135.151 256.475 135.085C256.568 134.825 256.666 134.566 256.767 134.306C256.535 134.495 256.31 134.693 256.095 134.901L256.095 134.901ZM254.489 129.99C254.494 129.981 254.498 129.974 254.505 129.966C254.503 129.949 254.503 129.932 254.504 129.915C254.5 129.745 254.499 129.579 254.498 129.41C254.48 129.437 254.46 129.464 254.44 129.491C254.421 129.518 254.403 129.545 254.383 129.57C254.344 129.624 254.307 129.676 254.268 129.728C254.211 129.808 254.152 129.886 254.093 129.965C254.012 130.076 253.932 130.185 253.85 130.293L253.85 130.295C253.857 130.451 253.868 130.607 253.881 130.763C253.881 130.799 253.885 130.836 253.888 130.871C253.967 130.776 254.045 130.679 254.121 130.581C254.137 130.561 254.152 130.541 254.167 130.523C254.25 130.417 254.332 130.309 254.414 130.2C254.418 130.193 254.423 130.186 254.429 130.18C254.434 130.171 254.439 130.165 254.446 130.156C254.45 130.151 254.453 130.148 254.455 130.143L254.455 130.141C254.464 130.091 254.476 130.04 254.489 129.99ZM271.5 122.961C271.084 123.384 270.665 123.801 270.242 124.212L270.24 124.214C270.231 124.225 270.222 124.239 270.214 124.251C270.158 124.327 270.103 124.402 270.051 124.477C270.012 124.53 269.974 124.585 269.936 124.639C269.924 124.656 269.914 124.672 269.902 124.688C269.8 124.836 269.7 124.987 269.601 125.138C269.503 125.287 269.406 125.439 269.311 125.589C269.279 125.639 269.247 125.691 269.216 125.742C269.159 125.836 269.101 125.929 269.047 126.024C269.004 126.092 268.965 126.163 268.925 126.23C268.867 126.329 268.81 126.428 268.754 126.527C269.16 126.158 269.557 125.78 269.944 125.393C269.982 125.356 270.018 125.318 270.056 125.281C270.059 125.28 270.06 125.278 270.06 125.276C270.094 125.214 270.131 125.151 270.169 125.09C270.236 124.974 270.305 124.857 270.378 124.743C270.424 124.664 270.473 124.584 270.523 124.507C270.537 124.485 270.551 124.462 270.568 124.439C270.636 124.327 270.708 124.218 270.782 124.106C270.868 123.974 270.958 123.841 271.048 123.71C271.161 123.543 271.276 123.376 271.395 123.213C271.409 123.193 271.425 123.171 271.44 123.151C271.521 123.04 271.602 122.927 271.687 122.817C271.741 122.745 271.796 122.672 271.852 122.601C271.735 122.72 271.617 122.841 271.5 122.961L271.5 122.961ZM274.4 142.274C274.154 142.515 273.898 142.749 273.639 142.979C273.504 143.15 273.365 143.32 273.225 143.487C273.224 143.488 273.223 143.489 273.222 143.49C273.133 143.596 273.045 143.704 272.955 143.81C273.108 143.667 273.26 143.522 273.408 143.373C273.555 143.228 273.698 143.082 273.842 142.934C273.849 142.928 273.852 142.923 273.859 142.916C274.21 142.554 274.552 142.182 274.884 141.8C274.726 141.96 274.563 142.118 274.4 142.274ZM280.704 142.584C280.61 142.636 280.514 142.687 280.421 142.738C280.327 142.79 280.231 142.841 280.136 142.892C280.019 142.955 279.9 143.017 279.779 143.076C279.756 143.089 279.73 143.103 279.704 143.115C279.679 143.127 279.653 143.142 279.628 143.154C279.588 143.176 279.548 143.196 279.503 143.216C279.5 143.217 279.498 143.218 279.497 143.22C279.386 143.329 279.274 143.438 279.163 143.547L279.16 143.548C278.987 143.719 278.809 143.892 278.631 144.059L278.457 144.21C278.445 144.218 278.435 144.229 278.423 144.24L278.235 144.4L277.879 144.709L277.874 144.713L277.549 144.992C277.368 145.145 277.197 145.31 277.006 145.455L276.439 145.888L275.871 146.321C275.679 146.463 275.497 146.617 275.295 146.745C275.114 146.866 274.933 146.986 274.752 147.109C274.796 147.004 274.839 146.899 274.884 146.794C274.975 146.573 275.069 146.353 275.159 146.134C275.231 145.965 275.303 145.794 275.376 145.625C275.406 145.558 275.433 145.491 275.462 145.425C275.487 145.367 275.513 145.308 275.54 145.25C275.587 145.138 275.635 145.029 275.684 144.919C275.714 144.851 275.744 144.784 275.775 144.717C275.785 144.693 275.795 144.671 275.806 144.647C275.846 144.556 275.888 144.465 275.928 144.374C275.773 144.438 275.617 144.5 275.461 144.56C275.409 144.674 275.361 144.788 275.314 144.904C275.285 144.97 275.258 145.037 275.233 145.103C275.174 145.248 275.12 145.393 275.069 145.539L275.06 145.564C275.036 145.627 275.015 145.689 274.994 145.756L274.993 145.758C274.96 145.852 274.93 145.947 274.901 146.04C274.809 146.336 274.726 146.636 274.66 146.937C274.638 147.029 274.62 147.12 274.601 147.21C274.043 147.587 273.483 147.964 272.893 148.292L272.276 148.655L271.969 148.837L271.65 148.998L270.374 149.646C270.163 149.761 269.944 149.853 269.724 149.946L269.066 150.227C268.627 150.414 268.193 150.615 267.739 150.763L266.708 151.136C267.43 150.696 268.117 150.201 268.754 149.645C268.842 149.57 268.929 149.495 269.013 149.417C269.931 148.61 270.81 147.763 271.65 146.877C271.72 146.804 271.79 146.729 271.858 146.654L271.86 146.653C271.926 146.581 271.992 146.511 272.055 146.439C272.11 146.384 272.161 146.328 272.21 146.271C272.284 146.193 272.354 146.112 272.423 146.033C272.591 145.847 272.756 145.658 272.918 145.468C272.953 145.427 272.989 145.385 273.025 145.343C273.159 145.187 273.292 145.029 273.422 144.867C273.442 144.847 273.46 144.824 273.477 144.8C273.366 144.846 273.253 144.893 273.14 144.938C272.647 145.141 272.153 145.349 271.659 145.536C271.549 145.578 271.44 145.619 271.331 145.657L271.026 145.987C271.009 146.006 270.99 146.025 270.973 146.044L270.971 146.044C270.926 146.093 270.878 146.14 270.832 146.189C270.848 146.149 270.863 146.105 270.878 146.064C270.913 145.967 270.945 145.87 270.976 145.774C271.011 145.661 271.046 145.548 271.077 145.434C271.103 145.342 271.126 145.249 271.151 145.154C271.165 145.096 271.179 145.038 271.191 144.978C271.243 144.761 271.286 144.54 271.321 144.318C271.35 144.143 271.375 143.966 271.395 143.788C271.464 143.194 271.479 142.593 271.45 141.995C271.466 141.972 271.482 141.945 271.499 141.922L271.789 141.468L272.066 141.008L272.331 140.538C272.524 140.186 272.697 139.822 272.852 139.453C272.994 139.336 273.134 139.212 273.265 139.082C273.501 138.857 273.722 138.613 273.925 138.357C274.047 138.207 274.162 138.051 274.271 137.893C274.527 137.527 274.752 137.14 274.945 136.735C274.944 136.694 274.943 136.656 274.944 136.616C274.941 136.472 274.94 136.329 274.939 136.185C274.938 135.637 274.946 135.096 274.955 134.554C274.92 134.709 274.882 134.863 274.839 135.015C274.619 135.828 274.312 136.616 273.925 137.371C273.885 137.45 273.845 137.529 273.804 137.607C273.624 137.936 273.428 138.258 273.218 138.573C273.192 138.612 273.166 138.649 273.14 138.689C273.155 138.645 273.171 138.605 273.184 138.561C273.194 138.533 273.204 138.504 273.212 138.475C273.424 137.821 273.59 137.149 273.709 136.472C273.831 135.765 273.905 135.049 273.889 134.33C273.655 135.011 273.443 135.683 273.22 136.349L273.186 136.447C272.975 137.081 272.75 137.705 272.519 138.328L271.915 139.942L271.84 140.148L271.838 140.152L271.786 140.289L271.6 140.783L271.594 140.802L271.5 141.035L271.406 141.271L271.394 141.299C271.392 141.286 271.393 141.273 271.391 141.26C271.389 141.236 271.386 141.212 271.382 141.189L271.382 141.187C271.379 141.155 271.375 141.124 271.367 141.091C271.351 140.949 271.33 140.809 271.303 140.667C271.3 140.628 271.294 140.59 271.285 140.551C271.262 140.417 271.236 140.284 271.207 140.149C271.204 140.133 271.2 140.12 271.195 140.103C271.06 139.485 270.872 138.881 270.63 138.297C270.352 137.622 270.004 136.973 269.584 136.38C269.501 136.261 269.415 136.147 269.325 136.034C269.317 136.022 269.308 136.011 269.299 136.001C269.278 135.975 269.257 135.947 269.234 135.922C269.199 135.876 269.161 135.833 269.124 135.789C269.439 135.439 269.748 135.087 270.045 134.723C270.074 134.688 270.101 134.653 270.128 134.618L270.129 134.617C270.205 134.525 270.278 134.435 270.35 134.342C270.947 133.582 271.505 132.792 272.008 131.968C272.597 131.008 273.119 130.003 273.541 128.961C273.837 128.211 274.098 127.446 274.298 126.669C274.377 126.364 274.446 126.055 274.504 125.742C274.422 126.002 274.336 126.263 274.246 126.52C273.967 127.314 273.643 128.089 273.268 128.837C272.781 129.833 272.209 130.785 271.589 131.699C270.572 133.191 269.403 134.572 268.137 135.859C267.854 136.147 267.566 136.43 267.273 136.71C267.221 136.761 267.168 136.81 267.116 136.86C266.673 137.285 266.216 137.697 265.753 138.104C265.744 138.113 265.733 138.12 265.723 138.129L265.723 138.131C265.711 138.141 265.698 138.152 265.686 138.163C265.414 138.401 265.139 138.636 264.862 138.869C264.796 139.231 264.735 139.595 264.68 139.96C264.946 139.745 265.21 139.525 265.471 139.301C265.491 139.285 265.512 139.267 265.529 139.25C265.548 139.237 265.563 139.224 265.576 139.209L265.577 139.207C265.779 139.04 265.974 138.869 266.167 138.696C266.714 138.218 267.245 137.724 267.765 137.218C267.958 137.024 268.15 136.829 268.339 136.631C268.598 136.363 268.853 136.089 269.103 135.813C269.126 135.868 269.152 135.921 269.173 135.975C269.189 136.008 269.205 136.041 269.218 136.075C269.222 136.078 269.222 136.082 269.225 136.087C269.287 136.229 269.348 136.37 269.406 136.512C269.677 137.163 269.916 137.816 270.111 138.48C270.322 139.215 270.489 139.955 270.604 140.704C270.619 140.805 270.634 140.903 270.647 141.004C270.652 141.044 270.658 141.083 270.66 141.124C270.667 141.165 270.673 141.204 270.677 141.246C270.681 141.277 270.685 141.31 270.689 141.341C270.707 141.505 270.724 141.669 270.739 141.834C270.743 141.871 270.747 141.907 270.749 141.945L270.748 141.947C270.809 142.711 270.817 143.485 270.777 144.257C270.776 144.271 270.776 144.284 270.773 144.298C270.753 144.649 270.722 145 270.68 145.35C270.672 145.404 270.666 145.457 270.658 145.511L270.657 145.513C270.646 145.604 270.634 145.695 270.621 145.787C270.617 145.817 270.613 145.847 270.609 145.877C270.598 145.958 270.585 146.038 270.571 146.119C270.551 146.249 270.53 146.378 270.508 146.508C270.356 146.653 270.202 146.8 270.054 146.949C270.008 146.998 269.96 147.045 269.912 147.091C269.497 147.504 269.056 147.883 268.614 148.265C268.44 148.414 268.268 148.564 268.097 148.716C268.097 148.716 268.095 148.717 268.094 148.719C268.071 148.738 268.048 148.76 268.025 148.779C267.469 149.252 266.88 149.669 266.261 150.045C266.119 150.132 265.977 150.215 265.832 150.298C265.427 150.526 265.014 150.739 264.59 150.935C264.649 150.808 264.704 150.678 264.756 150.548C264.787 150.469 264.818 150.386 264.847 150.304L264.86 150.266C264.878 150.214 264.896 150.163 264.911 150.111C265.034 149.739 265.129 149.355 265.198 148.968C265.22 148.858 265.237 148.746 265.252 148.636C265.258 148.602 265.263 148.57 265.266 148.535L265.267 148.533C265.268 148.523 265.27 148.513 265.271 148.503C265.274 148.489 265.274 148.476 265.275 148.462C265.279 148.436 265.282 148.412 265.284 148.385C265.288 148.37 265.29 148.351 265.289 148.334C265.299 148.258 265.308 148.178 265.312 148.1C265.326 147.955 265.335 147.809 265.337 147.662C265.343 147.481 265.343 147.3 265.336 147.118C265.329 146.876 265.312 146.634 265.284 146.395C265.278 146.344 265.27 146.293 265.263 146.242C265.256 146.194 265.248 146.144 265.24 146.095C265.223 145.98 265.202 145.865 265.177 145.749C265.144 145.582 265.103 145.414 265.056 145.248L265.056 145.246C265.045 145.2 265.03 145.157 265.016 145.112C265 145.056 264.983 145.001 264.96 144.945C264.911 144.784 264.85 144.627 264.78 144.47C264.773 144.448 264.763 144.428 264.753 144.408C264.749 144.396 264.742 144.385 264.738 144.373C264.738 144.419 264.737 144.465 264.739 144.51C264.739 144.514 264.739 144.516 264.739 144.521C264.739 144.611 264.741 144.703 264.742 144.791C264.742 144.884 264.742 144.975 264.744 145.066C264.745 145.131 264.745 145.197 264.746 145.262C264.745 145.312 264.746 145.365 264.746 145.418C264.746 145.602 264.744 145.782 264.742 145.965C264.742 146.019 264.74 146.074 264.738 146.128C264.736 146.226 264.734 146.322 264.73 146.42L264.729 146.421C264.727 146.476 264.726 146.528 264.722 146.581C264.724 146.595 264.722 146.607 264.722 146.619C264.716 146.75 264.709 146.88 264.702 147.01L264.701 147.012C264.701 147.044 264.698 147.076 264.696 147.107C264.687 147.235 264.678 147.364 264.668 147.491C264.657 147.639 264.643 147.788 264.628 147.935C264.627 147.951 264.623 147.967 264.623 147.981C264.617 148.047 264.61 148.109 264.6 148.174L264.599 148.176C264.593 148.255 264.584 148.337 264.573 148.415C264.557 148.54 264.541 148.667 264.52 148.792C264.513 148.851 264.505 148.909 264.496 148.967C264.479 149.075 264.461 149.183 264.443 149.29C264.383 149.644 264.314 149.997 264.236 150.349C264.234 150.361 264.229 150.374 264.227 150.386L264.225 150.392C264.212 150.453 264.2 150.514 264.183 150.574L264.183 150.575C264.14 150.778 264.09 150.977 264.038 151.181C263.828 151.268 263.619 151.351 263.408 151.43C263.261 151.484 263.114 151.536 262.966 151.586C263.709 151.551 264.455 151.491 265.198 151.418C265.395 151.398 265.59 151.375 265.787 151.349C266.854 151.182 267.907 150.974 268.949 150.716L269.865 150.48L270.768 150.208C271.04 150.133 271.3 150.034 271.563 149.942C271.633 149.916 271.704 149.888 271.773 149.859C271.452 149.918 271.13 149.977 270.809 150.047C270.442 150.12 270.072 150.202 269.706 150.292L269.851 150.235C270.075 150.146 270.299 150.058 270.514 149.949L271.821 149.328L272.147 149.171L272.463 148.995L273.096 148.643C275.35 147.405 277.428 145.866 279.308 144.11C279.422 144.008 279.531 143.905 279.64 143.8C280.001 143.455 280.355 143.104 280.698 142.745C280.807 142.633 280.913 142.523 281.019 142.41C280.915 142.468 280.81 142.527 280.706 142.585L280.704 142.584Z\" />\n    <path d=\"M264.626 147.981C264.627 147.966 264.63 147.95 264.632 147.934C264.589 147.869 264.552 147.799 264.515 147.729C264.411 147.524 264.328 147.31 264.266 147.093C264.233 146.987 264.209 146.881 264.186 146.775C264.05 146.119 264.043 145.457 264.077 144.814C264.116 144.166 264.197 143.545 264.261 142.917C264.329 142.289 264.41 141.662 264.489 141.037C264.527 140.747 264.567 140.455 264.609 140.164C264.614 140.111 264.623 140.057 264.631 140.003C264.636 139.999 264.642 139.995 264.649 139.988C264.66 139.98 264.671 139.971 264.684 139.961C264.738 139.596 264.799 139.232 264.866 138.869C265.074 137.703 265.325 136.543 265.633 135.395C265.713 135.102 265.799 134.812 265.887 134.522C265.914 134.439 265.939 134.353 265.966 134.27C266.011 134.127 266.056 133.987 266.102 133.847C266.122 133.783 266.142 133.72 266.164 133.656C266.071 133.664 265.979 133.672 265.888 133.682C265.897 133.65 265.907 133.615 265.914 133.582C265.913 133.579 265.911 133.579 265.908 133.58C265.899 133.614 265.889 133.649 265.881 133.684C265.872 133.71 265.865 133.735 265.858 133.762L265.855 133.772C265.847 133.805 265.837 133.84 265.828 133.872C265.813 133.928 265.798 133.982 265.785 134.039C265.742 134.199 265.701 134.361 265.662 134.523C265.617 134.699 265.573 134.875 265.533 135.053C265.504 135.172 265.476 135.29 265.449 135.409C265.416 135.546 265.386 135.682 265.357 135.82C265.317 135.996 265.279 136.172 265.243 136.349C265.202 136.541 265.163 136.734 265.125 136.927C265.101 137.045 265.079 137.162 265.056 137.278C265.023 137.452 264.99 137.626 264.96 137.799C264.889 138.185 264.822 138.572 264.76 138.959C264.751 139.013 264.742 139.065 264.736 139.12C264.708 139.285 264.682 139.451 264.657 139.619C264.635 139.757 264.614 139.895 264.596 140.034C264.588 140.088 264.58 140.14 264.572 140.194C264.522 140.539 264.474 140.883 264.43 141.228C264.351 141.853 264.27 142.48 264.202 143.107C264.138 143.736 264.057 144.357 264.018 145.005C263.984 145.648 263.991 146.309 264.127 146.966C264.136 147.007 264.145 147.05 264.156 147.091C264.222 147.375 264.322 147.657 264.456 147.92C264.475 147.956 264.494 147.992 264.515 148.029C264.534 148.061 264.551 148.094 264.573 148.125C264.579 148.137 264.587 148.149 264.594 148.16C264.597 148.165 264.601 148.171 264.603 148.176L264.604 148.174C264.614 148.11 264.621 148.047 264.627 147.981L264.626 147.981ZM266.436 131.859C266.398 131.969 266.364 132.079 266.328 132.188C266.308 132.253 266.286 132.315 266.269 132.379C266.322 132.205 266.378 132.033 266.436 131.859ZM260.261 140.725C260.219 140.73 260.178 140.734 260.137 140.741C260.063 140.749 259.991 140.762 259.917 140.775C259.863 140.785 259.809 140.796 259.754 140.807C259.672 140.82 259.589 140.84 259.509 140.858C259.468 140.867 259.428 140.877 259.389 140.888C259.359 140.895 259.33 140.904 259.301 140.911C259.284 140.916 259.268 140.92 259.251 140.925C259.152 140.952 259.051 140.98 258.954 141.012C258.905 141.026 258.857 141.043 258.809 141.059L258.807 141.06C258.678 141.102 258.553 141.147 258.429 141.196C258.414 141.202 258.4 141.207 258.385 141.213C258.325 141.236 258.264 141.259 258.204 141.285C258.168 141.299 258.133 141.315 258.098 141.33C258.08 141.339 258.061 141.347 258.043 141.355L258.041 141.355C257.482 141.599 256.948 141.896 256.446 142.242L256.446 142.244C256.394 142.279 256.341 142.315 256.29 142.352L256.137 142.464C256.115 142.479 256.095 142.496 256.072 142.513C255.992 142.574 255.913 142.637 255.832 142.699C255.813 142.714 255.795 142.728 255.777 142.743C255.733 142.779 255.691 142.815 255.649 142.851C255.605 142.886 255.563 142.922 255.523 142.959C255.439 143.031 255.356 143.106 255.275 143.182L255.274 143.184C255.286 143.454 255.303 143.723 255.321 143.99C255.324 144.035 255.329 144.077 255.333 144.121C255.48 143.995 255.628 143.871 255.779 143.751C255.8 143.733 255.823 143.715 255.844 143.697C255.87 143.677 255.894 143.656 255.92 143.635C255.996 143.575 256.071 143.515 256.147 143.455C256.236 143.387 256.325 143.319 256.413 143.253C256.434 143.235 256.457 143.219 256.479 143.202C256.523 143.168 256.566 143.135 256.611 143.102C256.928 142.867 257.252 142.64 257.578 142.42L257.579 142.418C257.583 142.418 257.586 142.416 257.589 142.413C257.625 142.39 257.663 142.365 257.698 142.342C257.723 142.325 257.748 142.308 257.776 142.293C257.779 142.29 257.78 142.288 257.783 142.287C257.832 142.253 257.884 142.22 257.937 142.188C257.956 142.176 257.975 142.164 257.994 142.151C258.104 142.078 258.217 142.007 258.333 141.938C258.35 141.925 258.369 141.915 258.387 141.904C258.42 141.882 258.454 141.862 258.487 141.842C258.616 141.762 258.746 141.683 258.878 141.607C258.992 141.539 259.105 141.473 259.224 141.409C259.24 141.4 259.258 141.389 259.274 141.38L259.275 141.378C259.387 141.316 259.494 141.256 259.604 141.193C259.761 141.106 259.917 141.02 260.076 140.932C260.214 140.855 260.355 140.778 260.495 140.7C260.417 140.707 260.338 140.715 260.259 140.726L260.261 140.725ZM262.864 131.592C262.767 131.604 262.668 131.621 262.572 131.638C262.458 131.658 262.345 131.679 262.232 131.703C262.182 131.714 262.132 131.724 262.081 131.736C262.054 131.741 262.029 131.747 262.001 131.754C261.993 131.76 261.988 131.768 261.981 131.775C261.954 131.805 261.928 131.838 261.898 131.868C261.915 131.832 261.932 131.8 261.951 131.764C261.931 131.768 261.913 131.772 261.892 131.777C261.779 131.804 261.666 131.832 261.555 131.861C261.522 131.995 261.492 132.129 261.468 132.267C261.383 132.376 261.298 132.488 261.219 132.599C261.164 132.675 261.11 132.751 261.059 132.826C261.092 132.814 261.126 132.801 261.16 132.789C261.316 132.734 261.474 132.679 261.63 132.628C261.704 132.605 261.775 132.582 261.846 132.56C261.953 132.525 262.059 132.492 262.166 132.462C262.188 132.455 262.211 132.448 262.235 132.441C262.212 132.446 262.19 132.453 262.167 132.46L262.36 132.23L262.539 132.021C262.663 131.874 262.786 131.732 262.913 131.586C262.896 131.586 262.88 131.589 262.864 131.592L262.864 131.592ZM255.263 144.18C255.209 144.228 255.152 144.276 255.098 144.327C255.176 144.257 255.254 144.189 255.334 144.122C255.31 144.142 255.287 144.161 255.263 144.18L255.263 144.18ZM284.388 141.041C284.409 141.022 284.432 141.005 284.454 140.985C284.457 140.982 284.458 140.98 284.461 140.977C284.437 140.998 284.412 141.019 284.388 141.041ZM281.133 143.065C280.939 143.17 280.741 143.272 280.543 143.37C280.332 143.474 280.12 143.577 279.906 143.675C279.818 143.717 279.73 143.758 279.642 143.799C280.004 143.455 280.357 143.103 280.701 142.744C280.497 142.859 280.289 142.972 280.08 143.083C279.87 143.196 279.658 143.305 279.442 143.411C279.352 143.458 279.26 143.504 279.167 143.548L279.164 143.549C279.07 143.594 278.977 143.64 278.885 143.682C278.586 143.966 278.28 144.241 277.968 144.51C277.847 144.615 277.725 144.718 277.603 144.821C277.695 144.786 277.785 144.752 277.878 144.714C277.917 144.698 277.955 144.684 277.993 144.668C278.054 144.643 278.118 144.618 278.18 144.591C278.211 144.579 278.244 144.565 278.275 144.553C278.41 144.498 278.545 144.442 278.679 144.385C278.891 144.296 279.102 144.203 279.311 144.11C279.404 144.068 279.496 144.026 279.589 143.983C279.629 143.965 279.671 143.948 279.712 143.928C279.753 143.911 279.794 143.891 279.834 143.872C280.053 143.77 280.268 143.666 280.484 143.56C280.573 143.515 280.665 143.47 280.755 143.424L280.755 143.422C280.77 143.414 280.786 143.407 280.799 143.399C280.892 143.351 280.984 143.303 281.075 143.255C281.085 143.25 281.093 143.244 281.103 143.239C281.189 143.193 281.274 143.147 281.358 143.1C281.453 143.046 281.547 142.993 281.64 142.941C281.828 142.833 282.014 142.721 282.198 142.61C282.219 142.598 282.238 142.584 282.257 142.572C281.89 142.745 281.514 142.906 281.134 143.065L281.133 143.065ZM275.259 145.094C275.251 145.098 275.244 145.1 275.236 145.104C275.122 145.148 275.008 145.197 274.893 145.243C274.299 145.488 273.706 145.739 273.11 145.962C272.984 146.011 272.856 146.058 272.729 146.104C272.608 146.146 272.487 146.187 272.367 146.223C272.316 146.238 272.265 146.257 272.214 146.271C272.127 146.297 272.039 146.324 271.952 146.346C271.949 146.347 271.949 146.349 271.947 146.349C271.846 146.377 271.746 146.404 271.646 146.428C271.767 146.339 271.887 146.25 272.006 146.159C272.166 146.039 272.323 145.915 272.478 145.788C272.478 145.788 272.479 145.786 272.481 145.786C272.542 145.738 272.605 145.69 272.664 145.641C272.726 145.591 272.789 145.541 272.848 145.492C272.745 145.528 272.643 145.562 272.541 145.596C272.539 145.596 272.538 145.598 272.538 145.598C272.282 145.679 272.024 145.762 271.764 145.843C271.505 145.918 271.243 145.986 270.977 146.044L270.975 146.043C270.93 146.093 270.882 146.14 270.836 146.189C270.852 146.148 270.867 146.105 270.881 146.063C270.779 146.085 270.678 146.103 270.575 146.12C270.556 146.25 270.534 146.379 270.512 146.508C270.361 146.654 270.206 146.8 270.058 146.949C270.012 146.999 269.964 147.045 269.916 147.092C269.502 147.504 269.06 147.884 268.618 148.266C268.444 148.414 268.272 148.565 268.102 148.717C268.104 148.715 268.107 148.714 268.109 148.713C268.259 148.628 268.408 148.543 268.558 148.456C268.635 148.411 268.714 148.367 268.791 148.32C268.871 148.273 268.947 148.228 269.025 148.181C269.181 148.09 269.333 147.996 269.487 147.899C269.618 147.82 269.747 147.739 269.874 147.657C270.202 147.444 270.527 147.226 270.848 147.004C270.85 147.005 270.85 147.003 270.85 147.003C270.906 146.965 270.961 146.928 271.016 146.89C271.087 146.837 271.16 146.784 271.234 146.731C271.264 146.729 271.29 146.728 271.318 146.725C271.396 146.718 271.475 146.71 271.553 146.699C271.658 146.687 271.76 146.671 271.863 146.654L271.865 146.653C271.91 146.645 271.956 146.636 272 146.628C272.099 146.61 272.199 146.592 272.296 146.571C272.612 146.503 272.925 146.42 273.234 146.331C273.548 146.234 273.86 146.136 274.169 146.034C274.169 146.034 274.171 146.035 274.172 146.033C274.45 145.942 274.724 145.85 274.998 145.757C275.001 145.756 275.003 145.755 275.006 145.753C275.13 145.712 275.256 145.669 275.381 145.625C275.411 145.557 275.438 145.49 275.467 145.425C275.492 145.366 275.518 145.307 275.545 145.249C275.592 145.137 275.64 145.028 275.689 144.918C275.545 144.976 275.405 145.034 275.26 145.093L275.259 145.094ZM291.867 128.086C291.87 128.049 291.875 128.01 291.881 127.973C291.902 127.914 291.92 127.855 291.938 127.796C291.94 127.793 291.94 127.786 291.941 127.782C291.922 127.837 291.904 127.894 291.885 127.949C291.808 128.179 291.728 128.408 291.647 128.637C291.721 128.452 291.795 128.269 291.867 128.085L291.867 128.086ZM291.49 128.264C291.454 128.379 291.417 128.492 291.38 128.605C291.218 129.107 291.046 129.606 290.86 130.099C290.527 130.991 290.157 131.865 289.745 132.716C289.769 132.68 289.79 132.641 289.812 132.604C290.119 132.052 290.405 131.49 290.669 130.92C290.837 130.553 291.003 130.183 291.161 129.814L291.162 129.81C291.289 129.298 291.398 128.782 291.489 128.264L291.49 128.264ZM288.523 134.171C288.564 134.053 288.604 133.932 288.643 133.813L288.648 133.8C288.668 133.735 288.687 133.674 288.707 133.609C288.787 133.342 288.863 133.076 288.935 132.808C288.966 132.692 288.997 132.579 289.026 132.465C289.082 132.249 289.136 132.033 289.185 131.819C289.217 131.691 289.246 131.562 289.274 131.433C289.432 130.693 289.587 129.955 289.711 129.215C289.973 127.736 290.208 126.251 290.365 124.749C290.245 125.107 290.128 125.467 290.018 125.827C289.979 125.952 289.943 126.074 289.906 126.199C289.835 126.433 289.766 126.668 289.698 126.903C289.631 127.139 289.562 127.374 289.496 127.611C289.438 127.822 289.382 128.032 289.325 128.244C289.25 128.523 289.176 128.803 289.104 129.081C288.908 129.807 288.74 130.535 288.543 131.254C288.358 131.976 288.165 132.695 287.942 133.399C287.923 133.461 287.904 133.527 287.883 133.589C287.847 133.709 287.811 133.827 287.772 133.946L287.764 133.969C287.714 134.124 287.662 134.279 287.61 134.431C287.537 134.64 287.461 134.847 287.383 135.054L287.382 135.056C287.302 135.268 287.219 135.48 287.134 135.688C287.101 135.771 287.066 135.852 287.031 135.935C286.998 136.014 286.963 136.094 286.928 136.172C286.907 136.22 286.887 136.266 286.866 136.313L286.866 136.315C286.831 136.392 286.796 136.466 286.762 136.542C286.688 136.704 286.612 136.863 286.534 137.022C286.457 137.183 286.377 137.34 286.296 137.497C286.096 137.877 285.888 138.253 285.667 138.623C285.595 138.747 285.521 138.869 285.444 138.992C285.281 139.16 285.113 139.328 284.943 139.49C284.604 139.817 284.253 140.131 283.891 140.429C283.864 140.452 283.838 140.474 283.81 140.494C284.47 140.371 285.149 140.294 285.82 140.205C285.931 140.098 286.039 139.986 286.144 139.873C286.217 139.656 286.288 139.439 286.358 139.221C286.411 139.056 286.462 138.89 286.513 138.723C286.65 138.275 286.783 137.824 286.912 137.372C286.995 137.085 287.078 136.797 287.167 136.51C287.214 136.35 287.263 136.19 287.315 136.029L287.316 136.027C287.335 135.964 287.355 135.901 287.375 135.839C287.435 135.779 287.496 135.72 287.555 135.659C287.697 135.517 287.835 135.369 287.969 135.217C287.907 135.463 287.851 135.711 287.794 135.959C287.79 135.976 287.786 135.994 287.784 136.012L287.768 136.076C287.773 136.069 287.777 136.062 287.78 136.053C287.794 136.026 287.806 135.999 287.819 135.972C287.848 135.908 287.879 135.843 287.907 135.779C287.942 135.702 287.975 135.625 288.006 135.548C288.036 135.48 288.064 135.412 288.092 135.344C288.107 135.307 288.122 135.27 288.136 135.234C288.183 135.116 288.229 134.995 288.273 134.876C288.279 134.865 288.282 134.856 288.286 134.844C288.287 134.842 288.29 134.839 288.291 134.837C288.292 134.834 288.291 134.829 288.292 134.827C288.374 134.609 288.45 134.391 288.524 134.171L288.523 134.171ZM282.285 141.627C282.269 141.638 282.255 141.648 282.239 141.657C282.09 141.758 281.939 141.852 281.788 141.948C281.618 142.055 281.445 142.161 281.271 142.263C281.189 142.311 281.107 142.358 281.025 142.406C281.025 142.406 281.024 142.407 281.022 142.409C280.917 142.467 280.813 142.526 280.708 142.584C280.615 142.636 280.519 142.687 280.426 142.739C280.332 142.79 280.236 142.842 280.14 142.892C280.024 142.955 279.905 143.017 279.784 143.076C279.761 143.089 279.735 143.103 279.709 143.115C279.684 143.128 279.658 143.142 279.632 143.154C279.593 143.176 279.553 143.196 279.508 143.216C279.505 143.218 279.503 143.219 279.502 143.221C279.489 143.227 279.476 143.235 279.461 143.24C279.385 143.279 279.308 143.318 279.23 143.354C279.228 143.355 279.227 143.357 279.224 143.358C279.156 143.392 279.085 143.426 279.015 143.459C278.658 143.63 278.297 143.795 277.936 143.957C277.764 144.034 277.591 144.108 277.419 144.184L277.414 144.186C277.255 144.255 277.094 144.326 276.936 144.395C277.284 144.149 277.623 143.89 277.951 143.616C278.075 143.514 278.196 143.408 278.317 143.301C278.353 143.271 278.387 143.24 278.42 143.21C278.44 143.191 278.461 143.173 278.48 143.153C278.519 143.12 278.554 143.086 278.589 143.051L278.594 143.049C278.61 143.035 278.623 143.021 278.638 143.007C278.727 142.926 278.815 142.843 278.9 142.757C279.036 142.625 279.167 142.492 279.297 142.353C279.313 142.336 279.33 142.318 279.347 142.299C279.413 142.231 279.478 142.159 279.541 142.088C279.553 142.078 279.563 142.064 279.574 142.053C279.587 142.039 279.598 142.026 279.611 142.011L279.612 142.01C279.739 141.868 279.862 141.726 279.984 141.58L279.985 141.579C279.994 141.571 280.002 141.561 280.009 141.553C280.071 141.478 280.133 141.402 280.195 141.325C280.229 141.282 280.263 141.239 280.297 141.196C280.298 141.194 280.3 141.193 280.301 141.191C280.354 141.123 280.407 141.055 280.459 140.985C280.834 140.491 281.183 139.977 281.514 139.455C281.91 138.805 282.282 138.144 282.632 137.475C282.972 136.799 283.311 136.127 283.619 135.442C283.744 135.174 283.867 134.904 283.99 134.635C284.106 134.379 284.222 134.124 284.334 133.866C284.341 133.853 284.346 133.838 284.353 133.826L284.354 133.82C284.36 133.81 284.366 133.794 284.371 133.784L284.373 133.78C284.492 133.508 284.611 133.233 284.727 132.959C284.843 132.684 284.956 132.409 285.069 132.132C285.083 132.097 285.098 132.06 285.112 132.025L285.115 132.017C285.178 131.858 285.242 131.697 285.302 131.537C285.335 131.455 285.367 131.376 285.397 131.294C285.327 131.4 285.258 131.507 285.189 131.614L285.189 131.616C285.171 131.643 285.153 131.669 285.137 131.697C285.017 131.879 284.901 132.061 284.786 132.247C284.773 132.268 284.759 132.29 284.745 132.311L284.744 132.313C284.739 132.323 284.731 132.333 284.725 132.344C284.651 132.46 284.58 132.576 284.509 132.693L284.509 132.694C284.495 132.717 284.481 132.739 284.466 132.762C284.373 132.915 284.281 133.066 284.19 133.22C283.805 133.861 283.431 134.507 283.067 135.158C282.691 135.809 282.344 136.472 281.969 137.115C281.787 137.439 281.603 137.763 281.415 138.086C281.229 138.404 281.037 138.721 280.838 139.034C280.781 139.125 280.724 139.217 280.667 139.309C280.614 139.394 280.56 139.476 280.506 139.56C280.501 139.567 280.497 139.574 280.492 139.581C280.488 139.586 280.486 139.592 280.483 139.597C280.299 139.878 280.111 140.157 279.918 140.431L279.916 140.434C279.91 140.441 279.905 140.448 279.901 140.454C279.822 140.566 279.741 140.677 279.659 140.788C279.562 140.921 279.464 141.051 279.365 141.179C279.343 141.205 279.324 141.232 279.301 141.26C279.232 141.35 279.16 141.441 279.088 141.529C278.803 141.887 278.506 142.235 278.197 142.574C278.179 142.593 278.159 142.614 278.142 142.633L278.14 142.634C278.038 142.745 277.935 142.854 277.832 142.964C277.788 143.01 277.742 143.057 277.697 143.102C277.619 143.183 277.54 143.263 277.46 143.342C277.228 143.573 276.991 143.801 276.749 144.025C276.632 144.132 276.515 144.238 276.397 144.343C276.382 144.356 276.364 144.371 276.349 144.385C276.293 144.437 276.233 144.488 276.173 144.539C276.04 144.655 275.905 144.77 275.769 144.885C275.752 144.892 275.736 144.9 275.719 144.906C275.709 144.911 275.698 144.914 275.688 144.918C275.639 145.028 275.591 145.137 275.543 145.25C275.517 145.308 275.49 145.366 275.466 145.425C275.436 145.491 275.409 145.557 275.379 145.625C275.389 145.622 275.397 145.618 275.406 145.615C275.903 145.444 276.401 145.267 276.9 145.084C277.113 145.006 277.325 144.927 277.537 144.844C277.558 144.839 277.579 144.829 277.6 144.822C277.6 144.822 277.601 144.82 277.603 144.82C277.725 144.717 277.847 144.614 277.967 144.509C278.28 144.24 278.586 143.965 278.884 143.681C278.977 143.639 279.071 143.594 279.164 143.548L279.167 143.547C279.26 143.503 279.352 143.457 279.442 143.411C279.658 143.304 279.87 143.195 280.08 143.082C280.289 142.971 280.497 142.858 280.701 142.743C280.357 143.102 280.004 143.454 279.642 143.798C279.73 143.757 279.818 143.716 279.906 143.675C280.12 143.576 280.332 143.473 280.543 143.369C280.741 143.271 280.939 143.169 281.133 143.064C281.103 143.077 281.072 143.089 281.042 143.102C281.471 142.623 281.886 142.131 282.284 141.626L282.285 141.627ZM284.388 141.04C284.409 141.022 284.432 141.005 284.454 140.985C284.457 140.982 284.458 140.98 284.461 140.977C284.437 140.998 284.413 141.019 284.388 141.04ZM281.133 143.064C280.939 143.17 280.742 143.272 280.543 143.369C280.332 143.473 280.12 143.576 279.906 143.675C279.818 143.716 279.73 143.757 279.642 143.799C280.004 143.454 280.357 143.103 280.701 142.744C280.497 142.859 280.289 142.972 280.08 143.083C279.87 143.195 279.658 143.305 279.442 143.411C279.352 143.458 279.26 143.504 279.167 143.547L279.164 143.548C279.071 143.594 278.977 143.639 278.885 143.681C278.586 143.965 278.28 144.24 277.968 144.509C277.847 144.615 277.725 144.718 277.603 144.821C277.695 144.785 277.785 144.751 277.878 144.714C277.917 144.698 277.956 144.684 277.993 144.667C278.054 144.642 278.118 144.618 278.18 144.591C278.211 144.579 278.244 144.564 278.275 144.552C278.41 144.498 278.546 144.441 278.679 144.385C278.891 144.296 279.102 144.203 279.311 144.109C279.404 144.067 279.496 144.026 279.589 143.982C279.629 143.964 279.671 143.947 279.712 143.928C279.753 143.91 279.794 143.891 279.835 143.871C280.053 143.77 280.268 143.666 280.484 143.559C280.573 143.514 280.665 143.47 280.755 143.423L280.755 143.421C280.771 143.414 280.786 143.407 280.799 143.399C280.892 143.351 280.984 143.303 281.075 143.254C281.085 143.249 281.093 143.244 281.103 143.239C281.189 143.193 281.274 143.146 281.358 143.1C281.453 143.046 281.547 142.992 281.641 142.941C281.828 142.833 282.014 142.721 282.198 142.609C282.219 142.598 282.238 142.584 282.257 142.571C281.89 142.745 281.514 142.905 281.134 143.064L281.133 143.064ZM275.259 145.094C275.251 145.098 275.244 145.099 275.237 145.103C275.122 145.148 275.008 145.197 274.893 145.243C274.299 145.488 273.706 145.739 273.11 145.962C272.984 146.011 272.856 146.057 272.729 146.103C272.609 146.146 272.487 146.186 272.368 146.222C272.316 146.238 272.265 146.256 272.214 146.27C272.127 146.297 272.039 146.323 271.952 146.346C271.949 146.347 271.949 146.349 271.947 146.348C271.846 146.377 271.747 146.403 271.646 146.427C271.767 146.339 271.887 146.25 272.006 146.159C272.166 146.039 272.323 145.915 272.478 145.787C272.478 145.787 272.479 145.785 272.481 145.786C272.542 145.738 272.605 145.69 272.664 145.641C272.726 145.59 272.789 145.541 272.849 145.492C272.745 145.528 272.643 145.562 272.541 145.596C272.539 145.595 272.538 145.597 272.538 145.597C272.282 145.679 272.024 145.762 271.764 145.843C271.505 145.917 271.243 145.986 270.977 146.043L270.975 146.043C270.93 146.093 270.882 146.139 270.836 146.189C270.852 146.148 270.867 146.104 270.881 146.063C270.779 146.085 270.678 146.102 270.576 146.119C270.556 146.25 270.534 146.379 270.512 146.508C270.361 146.654 270.207 146.8 270.058 146.949C270.012 146.998 269.964 147.045 269.916 147.092C269.502 147.504 269.06 147.884 268.618 148.265C268.444 148.414 268.272 148.565 268.102 148.716C268.104 148.715 268.107 148.714 268.109 148.713C268.259 148.627 268.408 148.543 268.559 148.456C268.635 148.411 268.714 148.366 268.791 148.319C268.871 148.273 268.947 148.228 269.025 148.181C269.181 148.09 269.333 147.995 269.487 147.899C269.618 147.82 269.747 147.739 269.874 147.656C270.203 147.444 270.527 147.225 270.848 147.004C270.85 147.005 270.851 147.003 270.851 147.003C270.906 146.965 270.961 146.927 271.016 146.889C271.088 146.836 271.161 146.784 271.234 146.731C271.264 146.729 271.29 146.727 271.318 146.724C271.396 146.718 271.475 146.709 271.553 146.698C271.658 146.686 271.76 146.671 271.863 146.654L271.865 146.653C271.91 146.645 271.956 146.636 272.001 146.628C272.1 146.61 272.199 146.591 272.296 146.57C272.612 146.503 272.926 146.42 273.234 146.331C273.548 146.233 273.86 146.135 274.169 146.034C274.169 146.034 274.171 146.034 274.172 146.032C274.45 145.941 274.724 145.849 274.998 145.757C275.001 145.755 275.003 145.754 275.006 145.753C275.13 145.712 275.256 145.669 275.381 145.624C275.411 145.557 275.438 145.49 275.467 145.424C275.492 145.365 275.518 145.307 275.545 145.249C275.592 145.137 275.641 145.027 275.689 144.918C275.545 144.975 275.405 145.034 275.26 145.093L275.259 145.094ZM264.626 147.98C264.627 147.966 264.63 147.95 264.632 147.934C264.589 147.868 264.552 147.799 264.515 147.729C264.411 147.524 264.328 147.31 264.266 147.093C264.233 146.986 264.209 146.881 264.187 146.775C264.05 146.118 264.043 145.457 264.077 144.813C264.116 144.166 264.197 143.545 264.261 142.916C264.329 142.289 264.41 141.662 264.49 141.037C264.527 140.746 264.567 140.455 264.609 140.164C264.614 140.111 264.623 140.057 264.631 140.003C264.637 139.999 264.642 139.994 264.649 139.988C264.66 139.979 264.672 139.971 264.684 139.96C264.738 139.596 264.799 139.232 264.866 138.869C265.074 137.703 265.325 136.543 265.633 135.394C265.713 135.102 265.799 134.811 265.887 134.522C265.914 134.438 265.939 134.352 265.966 134.269C266.011 134.127 266.056 133.987 266.102 133.847C266.122 133.782 266.142 133.719 266.164 133.655C266.071 133.663 265.98 133.671 265.888 133.682C265.897 133.649 265.907 133.615 265.914 133.581C265.913 133.579 265.911 133.578 265.909 133.579C265.899 133.614 265.889 133.648 265.881 133.684C265.872 133.71 265.865 133.735 265.858 133.762L265.855 133.772C265.847 133.805 265.837 133.839 265.828 133.872C265.813 133.928 265.799 133.982 265.785 134.038C265.742 134.198 265.701 134.361 265.662 134.522C265.617 134.699 265.573 134.875 265.533 135.052C265.504 135.171 265.476 135.29 265.449 135.409C265.417 135.545 265.386 135.682 265.357 135.819C265.317 135.995 265.28 136.171 265.243 136.349C265.202 136.541 265.163 136.733 265.125 136.927C265.101 137.045 265.08 137.162 265.056 137.278C265.023 137.452 264.99 137.626 264.96 137.798C264.889 138.185 264.822 138.572 264.76 138.959C264.752 139.013 264.742 139.065 264.736 139.119C264.708 139.285 264.682 139.45 264.657 139.619C264.635 139.756 264.615 139.894 264.596 140.033C264.588 140.087 264.58 140.14 264.572 140.194C264.522 140.539 264.474 140.882 264.431 141.227C264.351 141.853 264.27 142.48 264.202 143.107C264.138 143.736 264.057 144.356 264.018 145.004C263.985 145.648 263.991 146.309 264.128 146.965C264.137 147.006 264.145 147.049 264.156 147.091C264.222 147.375 264.322 147.656 264.456 147.92C264.475 147.956 264.494 147.992 264.515 148.029C264.534 148.06 264.552 148.094 264.573 148.124C264.579 148.137 264.587 148.149 264.594 148.159C264.597 148.164 264.601 148.17 264.604 148.175L264.604 148.173C264.614 148.109 264.621 148.046 264.627 147.981L264.626 147.98ZM266.436 131.859C266.398 131.968 266.364 132.078 266.328 132.188C266.308 132.253 266.286 132.315 266.269 132.378C266.322 132.205 266.378 132.033 266.436 131.859ZM260.261 140.725C260.22 140.729 260.178 140.734 260.138 140.741C260.063 140.749 259.991 140.762 259.917 140.774C259.863 140.785 259.809 140.795 259.754 140.806C259.672 140.82 259.589 140.839 259.509 140.858C259.468 140.867 259.429 140.877 259.389 140.888C259.359 140.895 259.331 140.904 259.301 140.91C259.284 140.915 259.268 140.92 259.252 140.925C259.152 140.951 259.051 140.98 258.954 141.011C258.905 141.026 258.857 141.043 258.809 141.058L258.807 141.059C258.679 141.101 258.553 141.146 258.429 141.196C258.415 141.201 258.4 141.207 258.385 141.212C258.325 141.235 258.264 141.259 258.204 141.284C258.168 141.299 258.133 141.314 258.098 141.33C258.08 141.338 258.061 141.346 258.043 141.355L258.041 141.354C257.482 141.599 256.948 141.895 256.446 142.242L256.446 142.244C256.394 142.278 256.341 142.315 256.29 142.352L256.138 142.464C256.115 142.479 256.095 142.495 256.072 142.513C255.992 142.573 255.913 142.637 255.833 142.699C255.813 142.713 255.795 142.728 255.777 142.743C255.733 142.778 255.691 142.814 255.649 142.85C255.605 142.886 255.563 142.922 255.523 142.958C255.439 143.031 255.356 143.105 255.275 143.182L255.274 143.184C255.286 143.453 255.303 143.722 255.321 143.99C255.324 144.035 255.329 144.077 255.333 144.12C255.48 143.994 255.628 143.871 255.779 143.75C255.8 143.732 255.823 143.715 255.844 143.697C255.87 143.677 255.894 143.655 255.92 143.635C255.996 143.575 256.072 143.515 256.147 143.455C256.236 143.387 256.325 143.318 256.413 143.252C256.434 143.234 256.457 143.219 256.48 143.202C256.523 143.168 256.566 143.135 256.611 143.102C256.928 142.866 257.252 142.639 257.578 142.42L257.579 142.418C257.583 142.417 257.586 142.416 257.589 142.413C257.625 142.389 257.663 142.365 257.698 142.341C257.723 142.325 257.748 142.308 257.776 142.292C257.78 142.289 257.78 142.287 257.783 142.286C257.832 142.253 257.884 142.22 257.937 142.188C257.956 142.176 257.975 142.163 257.994 142.151C258.104 142.077 258.217 142.007 258.333 141.938C258.35 141.925 258.369 141.914 258.387 141.904C258.42 141.882 258.454 141.862 258.487 141.841C258.616 141.762 258.746 141.683 258.878 141.606C258.992 141.538 259.106 141.472 259.224 141.409C259.24 141.399 259.258 141.389 259.274 141.38L259.275 141.378C259.387 141.315 259.494 141.256 259.604 141.193C259.761 141.106 259.917 141.019 260.076 140.931C260.214 140.855 260.355 140.778 260.495 140.7C260.417 140.706 260.338 140.715 260.259 140.725L260.261 140.725ZM262.864 131.591C262.767 131.604 262.668 131.62 262.572 131.638C262.458 131.657 262.345 131.679 262.232 131.703C262.182 131.713 262.132 131.723 262.081 131.735C262.054 131.741 262.029 131.747 262.001 131.754C261.993 131.759 261.988 131.768 261.981 131.774C261.954 131.805 261.928 131.838 261.898 131.868C261.915 131.831 261.933 131.8 261.951 131.764C261.931 131.767 261.913 131.772 261.892 131.777C261.78 131.803 261.666 131.832 261.556 131.861C261.522 131.994 261.492 132.129 261.468 132.266C261.383 132.376 261.298 132.487 261.219 132.599C261.164 132.675 261.11 132.751 261.059 132.825C261.092 132.814 261.126 132.8 261.16 132.789C261.316 132.733 261.474 132.679 261.631 132.628C261.704 132.605 261.775 132.581 261.846 132.559C261.953 132.525 262.059 132.492 262.166 132.462C262.188 132.454 262.211 132.448 262.235 132.441C262.212 132.446 262.19 132.453 262.167 132.46L262.361 132.23L262.539 132.02C262.663 131.874 262.786 131.731 262.913 131.586C262.896 131.586 262.88 131.589 262.864 131.592L262.864 131.591ZM255.263 144.179C255.209 144.228 255.152 144.276 255.099 144.327C255.176 144.256 255.254 144.189 255.334 144.122C255.31 144.141 255.287 144.16 255.263 144.18L255.263 144.179ZM291.867 128.085C291.87 128.048 291.875 128.01 291.881 127.972C291.902 127.914 291.92 127.855 291.938 127.796C291.94 127.792 291.94 127.786 291.941 127.782C291.922 127.837 291.904 127.894 291.886 127.948C291.808 128.178 291.728 128.408 291.647 128.636C291.722 128.451 291.795 128.269 291.868 128.085L291.867 128.085ZM291.49 128.264C291.454 128.378 291.417 128.491 291.38 128.605C291.218 129.107 291.046 129.605 290.86 130.099C290.527 130.99 290.157 131.864 289.746 132.716C289.769 132.68 289.791 132.641 289.812 132.604C290.119 132.051 290.405 131.489 290.67 130.92C290.837 130.552 291.003 130.182 291.161 129.814L291.162 129.81C291.289 129.298 291.398 128.782 291.489 128.264L291.49 128.264ZM288.523 134.171C288.564 134.052 288.604 133.932 288.643 133.812L288.648 133.799C288.668 133.735 288.687 133.674 288.707 133.609C288.787 133.342 288.863 133.075 288.935 132.808C288.966 132.692 288.997 132.579 289.026 132.464C289.082 132.248 289.136 132.033 289.185 131.818C289.217 131.69 289.246 131.562 289.274 131.432C289.432 130.693 289.587 129.955 289.711 129.214C289.973 127.736 290.208 126.251 290.365 124.748C290.245 125.107 290.128 125.466 290.018 125.826C289.979 125.952 289.943 126.074 289.906 126.198C289.835 126.432 289.767 126.668 289.698 126.903C289.631 127.139 289.562 127.374 289.497 127.61C289.438 127.821 289.382 128.032 289.325 128.244C289.25 128.523 289.176 128.803 289.105 129.081C288.908 129.807 288.74 130.534 288.543 131.254C288.358 131.975 288.166 132.694 287.943 133.398C287.923 133.461 287.905 133.526 287.883 133.588C287.848 133.709 287.811 133.827 287.772 133.946L287.764 133.968C287.714 134.124 287.663 134.278 287.61 134.431C287.537 134.639 287.461 134.847 287.383 135.054L287.383 135.056C287.303 135.268 287.219 135.479 287.134 135.688C287.101 135.771 287.066 135.852 287.032 135.934C286.998 136.013 286.963 136.094 286.928 136.172C286.907 136.22 286.887 136.265 286.866 136.313L286.866 136.315C286.831 136.391 286.797 136.466 286.762 136.542C286.689 136.704 286.613 136.863 286.534 137.021C286.457 137.182 286.378 137.34 286.296 137.497C286.097 137.876 285.888 138.253 285.667 138.623C285.595 138.747 285.521 138.869 285.445 138.992C285.281 139.16 285.113 139.327 284.943 139.49C284.604 139.817 284.253 140.131 283.891 140.429C283.865 140.451 283.838 140.474 283.81 140.493C284.47 140.371 285.149 140.294 285.82 140.205C285.931 140.098 286.04 139.986 286.144 139.873C286.217 139.656 286.289 139.438 286.358 139.22C286.411 139.055 286.462 138.89 286.514 138.722C286.65 138.275 286.783 137.824 286.912 137.372C286.995 137.084 287.078 136.797 287.167 136.51C287.214 136.349 287.263 136.19 287.315 136.028L287.316 136.026C287.335 135.964 287.355 135.901 287.375 135.838C287.435 135.779 287.496 135.72 287.555 135.659C287.697 135.516 287.835 135.368 287.969 135.217C287.907 135.463 287.851 135.711 287.794 135.958C287.79 135.976 287.786 135.994 287.784 136.012L287.768 136.076C287.773 136.069 287.777 136.062 287.781 136.053C287.794 136.026 287.806 135.998 287.819 135.971C287.848 135.907 287.879 135.842 287.907 135.778C287.942 135.702 287.975 135.625 288.006 135.547C288.036 135.48 288.064 135.411 288.092 135.343C288.107 135.306 288.122 135.269 288.136 135.234C288.184 135.116 288.23 134.995 288.273 134.875C288.279 134.865 288.282 134.855 288.286 134.844C288.287 134.842 288.29 134.839 288.291 134.837C288.292 134.833 288.291 134.829 288.292 134.827C288.374 134.609 288.45 134.391 288.524 134.17L288.523 134.171ZM282.285 141.627C282.269 141.638 282.255 141.648 282.239 141.657C282.09 141.757 281.939 141.852 281.789 141.947C281.618 142.055 281.445 142.161 281.271 142.263C281.189 142.31 281.107 142.358 281.025 142.405C281.025 142.405 281.024 142.406 281.022 142.408C280.917 142.467 280.813 142.525 280.709 142.584C280.615 142.636 280.519 142.687 280.426 142.738C280.332 142.79 280.236 142.841 280.14 142.892C280.024 142.955 279.905 143.017 279.784 143.076C279.761 143.089 279.735 143.103 279.709 143.115C279.684 143.127 279.658 143.142 279.633 143.154C279.593 143.176 279.553 143.196 279.508 143.216C279.505 143.217 279.503 143.218 279.502 143.22C279.489 143.226 279.476 143.235 279.461 143.24C279.385 143.279 279.308 143.318 279.23 143.354C279.228 143.355 279.227 143.357 279.224 143.358C279.156 143.391 279.085 143.426 279.015 143.458C278.659 143.629 278.298 143.795 277.936 143.956C277.764 144.033 277.591 144.108 277.42 144.183L277.414 144.186C277.256 144.255 277.095 144.325 276.936 144.395C277.284 144.149 277.623 143.89 277.951 143.616C278.075 143.513 278.196 143.408 278.317 143.3C278.353 143.27 278.387 143.24 278.421 143.21C278.44 143.191 278.461 143.173 278.48 143.152C278.519 143.119 278.554 143.085 278.589 143.051L278.594 143.048C278.61 143.035 278.623 143.02 278.638 143.007C278.728 142.926 278.815 142.843 278.9 142.757C279.037 142.625 279.167 142.491 279.297 142.353C279.314 142.335 279.33 142.318 279.347 142.299C279.413 142.231 279.478 142.158 279.541 142.088C279.553 142.077 279.564 142.064 279.574 142.053C279.587 142.039 279.598 142.025 279.612 142.011L279.612 142.009C279.739 141.868 279.862 141.725 279.984 141.58L279.985 141.578C279.994 141.571 280.002 141.561 280.009 141.553C280.071 141.477 280.133 141.402 280.195 141.325C280.229 141.282 280.263 141.239 280.297 141.196C280.298 141.194 280.3 141.192 280.301 141.191C280.354 141.123 280.407 141.055 280.459 140.984C280.834 140.491 281.183 139.976 281.514 139.455C281.91 138.804 282.282 138.143 282.632 137.475C282.972 136.799 283.311 136.126 283.619 135.441C283.744 135.173 283.867 134.904 283.99 134.635C284.106 134.378 284.222 134.123 284.335 133.866C284.341 133.853 284.346 133.838 284.353 133.825L284.355 133.82C284.36 133.809 284.366 133.794 284.371 133.783L284.373 133.78C284.492 133.508 284.611 133.232 284.727 132.959C284.844 132.684 284.956 132.408 285.069 132.132C285.083 132.097 285.098 132.06 285.112 132.025L285.115 132.017C285.178 131.858 285.243 131.697 285.302 131.537C285.335 131.455 285.367 131.375 285.397 131.294C285.327 131.4 285.258 131.506 285.189 131.613L285.189 131.615C285.171 131.643 285.153 131.668 285.137 131.696C285.017 131.878 284.901 132.061 284.786 132.247C284.773 132.267 284.759 132.29 284.745 132.31L284.745 132.312C284.739 132.323 284.731 132.333 284.725 132.344C284.651 132.459 284.58 132.575 284.51 132.692L284.509 132.694C284.495 132.717 284.481 132.739 284.467 132.762C284.373 132.915 284.281 133.066 284.19 133.22C283.805 133.861 283.432 134.507 283.067 135.158C282.691 135.809 282.344 136.472 281.969 137.115C281.787 137.439 281.603 137.763 281.415 138.085C281.229 138.404 281.037 138.72 280.838 139.033C280.781 139.125 280.724 139.217 280.667 139.308C280.614 139.393 280.56 139.476 280.506 139.56C280.501 139.567 280.497 139.574 280.492 139.581C280.488 139.586 280.487 139.591 280.483 139.596C280.299 139.878 280.111 140.156 279.918 140.43L279.916 140.434C279.91 140.44 279.906 140.447 279.901 140.454C279.822 140.566 279.742 140.677 279.659 140.787C279.562 140.92 279.464 141.05 279.365 141.178C279.344 141.204 279.324 141.231 279.301 141.259C279.232 141.349 279.161 141.44 279.088 141.528C278.803 141.887 278.506 142.234 278.197 142.574C278.179 142.593 278.16 142.614 278.142 142.633L278.14 142.634C278.038 142.744 277.935 142.854 277.832 142.963C277.788 143.009 277.742 143.057 277.697 143.102C277.619 143.182 277.54 143.263 277.46 143.342C277.228 143.573 276.991 143.801 276.75 144.024C276.632 144.131 276.515 144.238 276.397 144.342C276.382 144.356 276.364 144.371 276.349 144.385C276.293 144.437 276.233 144.488 276.173 144.539C276.04 144.655 275.905 144.77 275.769 144.885C275.752 144.892 275.737 144.899 275.719 144.906C275.709 144.911 275.698 144.913 275.688 144.918C275.639 145.028 275.591 145.137 275.543 145.249C275.517 145.307 275.49 145.366 275.466 145.425C275.437 145.49 275.409 145.557 275.38 145.625C275.389 145.622 275.397 145.618 275.406 145.615C275.903 145.444 276.401 145.267 276.9 145.084C277.113 145.006 277.326 144.926 277.538 144.844C277.558 144.838 277.579 144.828 277.6 144.821C277.6 144.821 277.601 144.819 277.603 144.82C277.725 144.717 277.847 144.614 277.968 144.508C278.28 144.24 278.586 143.965 278.885 143.68C278.977 143.639 279.071 143.593 279.164 143.548L279.167 143.546C279.26 143.503 279.352 143.457 279.442 143.41C279.658 143.304 279.87 143.195 280.08 143.082C280.289 142.971 280.497 142.858 280.701 142.743C280.357 143.102 280.004 143.453 279.642 143.798C279.73 143.756 279.818 143.715 279.906 143.674C280.12 143.575 280.332 143.472 280.543 143.368C280.741 143.271 280.939 143.169 281.133 143.063C281.104 143.076 281.072 143.088 281.042 143.101C281.471 142.622 281.887 142.131 282.285 141.626L282.285 141.627ZM284.389 141.04C284.41 141.022 284.432 141.004 284.454 140.984C284.457 140.981 284.458 140.979 284.461 140.976C284.437 140.998 284.413 141.019 284.389 141.04ZM281.134 143.064C280.939 143.169 280.742 143.271 280.543 143.369C280.332 143.473 280.12 143.576 279.907 143.675C279.818 143.716 279.73 143.757 279.642 143.798C280.004 143.454 280.357 143.103 280.701 142.744C280.497 142.858 280.29 142.971 280.08 143.082C279.87 143.195 279.658 143.304 279.442 143.411C279.352 143.457 279.26 143.504 279.167 143.547L279.164 143.548C279.071 143.594 278.977 143.639 278.885 143.681C278.586 143.965 278.28 144.24 277.968 144.509C277.847 144.614 277.725 144.717 277.603 144.82C277.695 144.785 277.785 144.751 277.878 144.713C277.917 144.697 277.956 144.683 277.993 144.667C278.055 144.642 278.118 144.617 278.18 144.59C278.211 144.578 278.244 144.564 278.275 144.552C278.41 144.497 278.546 144.441 278.679 144.384C278.891 144.296 279.102 144.203 279.312 144.109C279.404 144.067 279.496 144.025 279.59 143.982C279.63 143.964 279.671 143.947 279.712 143.927C279.754 143.91 279.794 143.89 279.835 143.871C280.053 143.769 280.268 143.665 280.484 143.559C280.574 143.514 280.665 143.47 280.755 143.423L280.756 143.421C280.771 143.414 280.786 143.406 280.799 143.398C280.892 143.35 280.984 143.302 281.075 143.254C281.085 143.249 281.093 143.243 281.103 143.239C281.189 143.192 281.275 143.146 281.358 143.099C281.453 143.046 281.547 142.992 281.641 142.94C281.828 142.832 282.014 142.72 282.198 142.609C282.219 142.597 282.238 142.583 282.258 142.571C281.89 142.744 281.514 142.905 281.134 143.064L281.134 143.064ZM275.259 145.094C275.251 145.097 275.244 145.099 275.237 145.103C275.122 145.147 275.008 145.196 274.893 145.243C274.299 145.487 273.706 145.739 273.111 145.962C272.984 146.011 272.856 146.057 272.729 146.103C272.609 146.146 272.487 146.186 272.368 146.222C272.316 146.238 272.265 146.256 272.214 146.27C272.127 146.296 272.04 146.323 271.952 146.345C271.95 146.347 271.949 146.349 271.947 146.348C271.847 146.376 271.747 146.403 271.646 146.427C271.767 146.338 271.887 146.249 272.007 146.158C272.166 146.039 272.323 145.914 272.479 145.787C272.479 145.787 272.479 145.785 272.481 145.786C272.542 145.737 272.605 145.689 272.664 145.64C272.726 145.59 272.79 145.54 272.849 145.491C272.746 145.527 272.643 145.561 272.541 145.596C272.539 145.595 272.539 145.597 272.539 145.597C272.282 145.679 272.024 145.762 271.764 145.842C271.505 145.917 271.243 145.986 270.977 146.043L270.975 146.042C270.93 146.092 270.882 146.139 270.836 146.188C270.852 146.147 270.867 146.104 270.881 146.063C270.779 146.084 270.678 146.102 270.576 146.119C270.556 146.249 270.534 146.378 270.512 146.508C270.361 146.653 270.207 146.8 270.059 146.949C270.012 146.998 269.964 147.044 269.916 147.091C269.502 147.504 269.06 147.883 268.618 148.265C268.445 148.414 268.273 148.564 268.102 148.716C268.104 148.715 268.107 148.713 268.11 148.712C268.259 148.627 268.408 148.542 268.559 148.455C268.635 148.41 268.714 148.366 268.792 148.319C268.871 148.273 268.948 148.228 269.025 148.181C269.181 148.089 269.334 147.995 269.487 147.899C269.618 147.819 269.747 147.738 269.874 147.656C270.203 147.443 270.527 147.225 270.848 147.004C270.85 147.004 270.851 147.002 270.851 147.002C270.906 146.965 270.961 146.927 271.016 146.889C271.088 146.836 271.161 146.783 271.234 146.73C271.264 146.728 271.29 146.727 271.318 146.724C271.396 146.717 271.475 146.709 271.553 146.698C271.658 146.686 271.76 146.671 271.863 146.654L271.866 146.652C271.91 146.645 271.956 146.635 272.001 146.627C272.1 146.609 272.199 146.591 272.296 146.57C272.612 146.502 272.926 146.42 273.234 146.331C273.548 146.233 273.86 146.135 274.169 146.033C274.169 146.033 274.171 146.034 274.172 146.032C274.45 145.941 274.724 145.849 274.998 145.756C275.001 145.755 275.003 145.754 275.006 145.753C275.13 145.711 275.256 145.669 275.381 145.624C275.411 145.556 275.438 145.49 275.467 145.424C275.492 145.365 275.518 145.307 275.545 145.248C275.592 145.136 275.641 145.027 275.689 144.917C275.545 144.975 275.405 145.034 275.26 145.093L275.259 145.094ZM264.626 147.98C264.627 147.965 264.63 147.95 264.632 147.933C264.589 147.868 264.552 147.798 264.515 147.728C264.411 147.524 264.328 147.31 264.266 147.092C264.233 146.986 264.209 146.881 264.187 146.774C264.05 146.118 264.043 145.457 264.077 144.813C264.116 144.165 264.197 143.545 264.261 142.916C264.329 142.288 264.41 141.662 264.49 141.036C264.527 140.746 264.567 140.454 264.609 140.164C264.615 140.111 264.623 140.057 264.631 140.003C264.637 139.998 264.642 139.994 264.649 139.988C264.66 139.979 264.672 139.97 264.684 139.96C264.738 139.595 264.799 139.231 264.866 138.869C265.075 137.702 265.325 136.542 265.633 135.394C265.713 135.102 265.799 134.811 265.887 134.521C265.914 134.438 265.94 134.352 265.966 134.269C266.011 134.127 266.056 133.986 266.102 133.846C266.123 133.782 266.142 133.719 266.164 133.655C266.071 133.663 265.98 133.671 265.888 133.681C265.897 133.649 265.907 133.614 265.914 133.581C265.913 133.578 265.911 133.578 265.909 133.579C265.899 133.614 265.889 133.648 265.881 133.683C265.872 133.71 265.865 133.735 265.858 133.762L265.855 133.771C265.847 133.804 265.838 133.839 265.828 133.872C265.813 133.927 265.799 133.981 265.785 134.038C265.743 134.198 265.701 134.36 265.662 134.522C265.618 134.698 265.573 134.874 265.533 135.052C265.504 135.171 265.476 135.289 265.449 135.409C265.417 135.545 265.386 135.681 265.358 135.819C265.318 135.995 265.28 136.171 265.244 136.348C265.202 136.54 265.163 136.733 265.125 136.927C265.101 137.045 265.08 137.161 265.056 137.277C265.023 137.452 264.99 137.625 264.96 137.798C264.889 138.184 264.822 138.572 264.76 138.959C264.752 139.013 264.742 139.064 264.736 139.119C264.708 139.284 264.682 139.45 264.658 139.618C264.635 139.756 264.615 139.894 264.596 140.033C264.588 140.087 264.58 140.139 264.572 140.193C264.522 140.538 264.475 140.882 264.431 141.227C264.351 141.852 264.27 142.479 264.202 143.107C264.138 143.735 264.057 144.356 264.018 145.004C263.985 145.648 263.991 146.309 264.128 146.965C264.137 147.006 264.145 147.049 264.156 147.091C264.222 147.375 264.322 147.656 264.456 147.919C264.475 147.955 264.494 147.991 264.515 148.028C264.534 148.06 264.552 148.094 264.573 148.124C264.579 148.137 264.588 148.148 264.594 148.159C264.597 148.164 264.601 148.17 264.604 148.175L264.604 148.173C264.614 148.109 264.621 148.046 264.627 147.98L264.626 147.98ZM266.436 131.859C266.398 131.968 266.364 132.078 266.328 132.188C266.308 132.252 266.287 132.314 266.269 132.378C266.323 132.205 266.378 132.032 266.436 131.859ZM260.261 140.724C260.22 140.729 260.178 140.733 260.138 140.741C260.063 140.748 259.991 140.761 259.917 140.774C259.863 140.784 259.809 140.795 259.755 140.806C259.672 140.819 259.589 140.839 259.509 140.858C259.468 140.867 259.429 140.876 259.389 140.888C259.359 140.894 259.331 140.903 259.301 140.91C259.285 140.915 259.268 140.92 259.252 140.924C259.152 140.951 259.051 140.979 258.954 141.011C258.905 141.026 258.857 141.043 258.81 141.058L258.807 141.059C258.679 141.101 258.553 141.146 258.429 141.195C258.415 141.201 258.4 141.206 258.386 141.212C258.325 141.235 258.264 141.258 258.205 141.284C258.168 141.299 258.133 141.314 258.098 141.329C258.08 141.338 258.061 141.346 258.043 141.354L258.041 141.354C257.483 141.598 256.948 141.895 256.447 142.241L256.446 142.243C256.394 142.278 256.341 142.315 256.29 142.352L256.138 142.463C256.115 142.479 256.095 142.495 256.072 142.512C255.992 142.573 255.913 142.636 255.833 142.699C255.813 142.713 255.795 142.728 255.777 142.743C255.733 142.778 255.691 142.814 255.649 142.85C255.606 142.885 255.564 142.921 255.523 142.958C255.439 143.03 255.357 143.105 255.275 143.182L255.275 143.183C255.286 143.453 255.303 143.722 255.321 143.989C255.325 144.035 255.329 144.076 255.333 144.12C255.48 143.994 255.628 143.871 255.779 143.75C255.8 143.732 255.823 143.715 255.844 143.697C255.87 143.676 255.894 143.655 255.92 143.635C255.996 143.574 256.072 143.514 256.147 143.454C256.236 143.386 256.325 143.318 256.414 143.252C256.435 143.234 256.457 143.219 256.48 143.201C256.523 143.168 256.566 143.134 256.611 143.101C256.929 142.866 257.252 142.639 257.578 142.419L257.579 142.418C257.584 142.417 257.586 142.416 257.589 142.413C257.625 142.389 257.663 142.364 257.698 142.341C257.723 142.324 257.748 142.307 257.777 142.292C257.78 142.289 257.78 142.287 257.783 142.286C257.832 142.252 257.884 142.22 257.937 142.188C257.956 142.175 257.975 142.163 257.994 142.15C258.104 142.077 258.217 142.006 258.333 141.937C258.351 141.924 258.369 141.914 258.387 141.903C258.42 141.881 258.455 141.861 258.487 141.841C258.616 141.761 258.746 141.683 258.878 141.606C258.992 141.538 259.106 141.472 259.224 141.408C259.24 141.399 259.259 141.389 259.274 141.379L259.275 141.377C259.387 141.315 259.495 141.255 259.604 141.193C259.761 141.106 259.917 141.019 260.076 140.931C260.215 140.854 260.355 140.777 260.496 140.699C260.417 140.706 260.339 140.714 260.259 140.725L260.261 140.724ZM262.864 131.591C262.767 131.604 262.669 131.62 262.572 131.637C262.458 131.657 262.345 131.679 262.232 131.703C262.182 131.713 262.132 131.723 262.082 131.735C262.054 131.74 262.029 131.746 262.001 131.753C261.993 131.759 261.988 131.768 261.982 131.774C261.954 131.804 261.928 131.838 261.899 131.867C261.915 131.831 261.933 131.799 261.951 131.764C261.931 131.767 261.913 131.771 261.892 131.777C261.78 131.803 261.667 131.831 261.556 131.86C261.522 131.994 261.492 132.129 261.468 132.266C261.383 132.376 261.298 132.487 261.22 132.599C261.164 132.674 261.11 132.75 261.059 132.825C261.092 132.814 261.127 132.8 261.16 132.789C261.316 132.733 261.474 132.678 261.631 132.628C261.704 132.604 261.776 132.581 261.846 132.559C261.953 132.524 262.059 132.492 262.167 132.461C262.188 132.454 262.211 132.447 262.235 132.441C262.212 132.445 262.191 132.453 262.167 132.459L262.361 132.23L262.539 132.02C262.663 131.873 262.787 131.731 262.913 131.585C262.896 131.586 262.88 131.589 262.864 131.591L262.864 131.591ZM255.264 144.179C255.209 144.227 255.152 144.275 255.099 144.326C255.176 144.256 255.254 144.188 255.334 144.122C255.311 144.141 255.287 144.16 255.263 144.179L255.264 144.179ZM291.868 128.085C291.87 128.048 291.875 128.01 291.882 127.972C291.902 127.913 291.92 127.855 291.939 127.796C291.94 127.792 291.94 127.785 291.941 127.782C291.922 127.836 291.905 127.893 291.886 127.948C291.808 128.178 291.728 128.407 291.647 128.636C291.722 128.451 291.796 128.268 291.868 128.085L291.868 128.085ZM291.49 128.264C291.455 128.378 291.417 128.491 291.38 128.604C291.219 129.107 291.046 129.605 290.86 130.098C290.528 130.99 290.157 131.864 289.746 132.716C289.769 132.679 289.791 132.641 289.812 132.604C290.12 132.051 290.405 131.489 290.67 130.919C290.837 130.552 291.003 130.182 291.161 129.813L291.162 129.809C291.289 129.297 291.399 128.781 291.49 128.263L291.49 128.264ZM288.523 134.17C288.564 134.052 288.604 133.931 288.643 133.812L288.648 133.799C288.668 133.734 288.687 133.673 288.707 133.609C288.787 133.342 288.863 133.075 288.935 132.807C288.966 132.692 288.997 132.578 289.026 132.464C289.082 132.248 289.136 132.032 289.185 131.818C289.217 131.69 289.247 131.561 289.275 131.432C289.432 130.693 289.587 129.954 289.711 129.214C289.973 127.736 290.208 126.25 290.365 124.748C290.245 125.106 290.128 125.466 290.018 125.826C289.979 125.951 289.943 126.073 289.906 126.198C289.836 126.432 289.767 126.667 289.698 126.902C289.631 127.138 289.562 127.374 289.497 127.61C289.438 127.821 289.382 128.031 289.326 128.243C289.25 128.522 289.176 128.802 289.105 129.081C288.908 129.806 288.74 130.534 288.543 131.253C288.358 131.975 288.166 132.694 287.943 133.398C287.923 133.461 287.905 133.526 287.883 133.588C287.848 133.709 287.811 133.826 287.772 133.945L287.764 133.968C287.714 134.124 287.663 134.278 287.61 134.431C287.538 134.639 287.461 134.847 287.383 135.054L287.383 135.055C287.303 135.268 287.219 135.479 287.134 135.687C287.101 135.771 287.067 135.851 287.032 135.934C286.998 136.013 286.964 136.094 286.928 136.172C286.907 136.219 286.887 136.265 286.867 136.313L286.866 136.314C286.831 136.391 286.797 136.465 286.762 136.541C286.689 136.704 286.613 136.862 286.535 137.021C286.458 137.182 286.378 137.339 286.296 137.496C286.097 137.876 285.888 138.252 285.668 138.622C285.595 138.747 285.521 138.868 285.445 138.991C285.281 139.16 285.113 139.327 284.943 139.49C284.605 139.816 284.254 140.131 283.891 140.428C283.865 140.451 283.838 140.473 283.81 140.493C284.47 140.37 285.149 140.294 285.82 140.204C285.931 140.097 286.04 139.986 286.144 139.872C286.217 139.656 286.289 139.438 286.358 139.22C286.411 139.055 286.462 138.89 286.514 138.722C286.65 138.274 286.783 137.823 286.913 137.371C286.995 137.084 287.078 136.797 287.167 136.51C287.214 136.349 287.264 136.189 287.315 136.028L287.316 136.026C287.336 135.963 287.355 135.901 287.375 135.838C287.435 135.779 287.496 135.72 287.555 135.658C287.697 135.516 287.835 135.368 287.969 135.216C287.907 135.462 287.851 135.71 287.794 135.958C287.79 135.976 287.786 135.993 287.784 136.011L287.768 136.075C287.773 136.069 287.777 136.062 287.781 136.052C287.794 136.025 287.806 135.998 287.819 135.971C287.848 135.907 287.879 135.842 287.907 135.778C287.942 135.702 287.975 135.624 288.006 135.547C288.036 135.479 288.064 135.411 288.092 135.343C288.107 135.306 288.122 135.269 288.136 135.234C288.184 135.115 288.23 134.995 288.273 134.875C288.279 134.864 288.282 134.855 288.286 134.843C288.287 134.842 288.29 134.838 288.291 134.837C288.292 134.833 288.292 134.828 288.292 134.827C288.374 134.609 288.45 134.39 288.524 134.17L288.523 134.17ZM282.285 141.626C282.269 141.637 282.255 141.647 282.239 141.657C282.09 141.757 281.939 141.852 281.789 141.947C281.619 142.054 281.445 142.16 281.271 142.262C281.189 142.31 281.107 142.357 281.025 142.405C281.025 142.405 281.024 142.406 281.022 142.408C280.917 142.467 280.813 142.525 280.709 142.583C280.615 142.635 280.519 142.686 280.426 142.738C280.332 142.79 280.236 142.841 280.141 142.892C280.024 142.954 279.905 143.017 279.784 143.075C279.761 143.088 279.735 143.102 279.709 143.115C279.684 143.127 279.658 143.141 279.633 143.153C279.593 143.176 279.553 143.195 279.508 143.216C279.505 143.217 279.503 143.218 279.502 143.22C279.49 143.226 279.476 143.234 279.462 143.24C279.385 143.278 279.308 143.317 279.23 143.353C279.228 143.355 279.227 143.356 279.225 143.358C279.156 143.391 279.085 143.425 279.015 143.458C278.659 143.629 278.298 143.795 277.937 143.956C277.764 144.033 277.591 144.108 277.42 144.183L277.415 144.185C277.256 144.255 277.095 144.325 276.936 144.394C277.284 144.149 277.623 143.889 277.951 143.615C278.075 143.513 278.196 143.408 278.318 143.3C278.353 143.27 278.387 143.24 278.421 143.209C278.44 143.19 278.461 143.172 278.481 143.152C278.519 143.119 278.554 143.085 278.589 143.051L278.595 143.048C278.61 143.034 278.623 143.02 278.639 143.006C278.728 142.926 278.816 142.842 278.9 142.756C279.037 142.624 279.167 142.491 279.297 142.352C279.314 142.335 279.33 142.317 279.348 142.298C279.413 142.23 279.478 142.158 279.541 142.087C279.553 142.077 279.564 142.064 279.574 142.052C279.587 142.038 279.598 142.025 279.612 142.011L279.612 142.009C279.739 141.867 279.863 141.725 279.985 141.58L279.985 141.578C279.994 141.57 280.002 141.56 280.009 141.552C280.071 141.477 280.133 141.401 280.195 141.324C280.229 141.281 280.263 141.238 280.297 141.195C280.298 141.193 280.3 141.192 280.301 141.19C280.354 141.122 280.407 141.054 280.459 140.984C280.834 140.491 281.183 139.976 281.514 139.454C281.91 138.804 282.282 138.143 282.632 137.475C282.972 136.799 283.311 136.126 283.619 135.441C283.744 135.173 283.867 134.903 283.99 134.634C284.106 134.378 284.222 134.123 284.335 133.865C284.341 133.853 284.346 133.838 284.353 133.825L284.355 133.819C284.361 133.809 284.366 133.794 284.372 133.783L284.373 133.779C284.493 133.507 284.611 133.232 284.727 132.959C284.844 132.683 284.956 132.408 285.069 132.131C285.083 132.096 285.098 132.059 285.112 132.024L285.115 132.017C285.179 131.857 285.243 131.697 285.303 131.536C285.335 131.455 285.367 131.375 285.397 131.293C285.327 131.399 285.258 131.506 285.19 131.613L285.189 131.615C285.171 131.642 285.154 131.668 285.138 131.696C285.018 131.878 284.901 132.061 284.786 132.246C284.773 132.267 284.759 132.289 284.745 132.31L284.745 132.312C284.739 132.323 284.731 132.333 284.725 132.343C284.652 132.459 284.58 132.575 284.51 132.692L284.509 132.694C284.495 132.716 284.481 132.739 284.467 132.761C284.373 132.914 284.281 133.065 284.19 133.219C283.805 133.861 283.432 134.507 283.067 135.157C282.691 135.808 282.344 136.471 281.969 137.114C281.787 137.439 281.603 137.762 281.415 138.085C281.229 138.403 281.037 138.72 280.838 139.033C280.781 139.125 280.724 139.217 280.667 139.308C280.614 139.393 280.56 139.476 280.506 139.56C280.501 139.566 280.497 139.573 280.492 139.58C280.489 139.585 280.487 139.591 280.483 139.596C280.299 139.877 280.111 140.156 279.918 140.43L279.917 140.434C279.91 140.44 279.906 140.447 279.901 140.454C279.822 140.566 279.742 140.676 279.659 140.787C279.562 140.92 279.465 141.05 279.365 141.178C279.344 141.204 279.324 141.231 279.301 141.259C279.232 141.349 279.161 141.44 279.088 141.528C278.803 141.886 278.506 142.234 278.197 142.573C278.18 142.593 278.16 142.613 278.143 142.632L278.14 142.634C278.038 142.744 277.935 142.853 277.832 142.963C277.788 143.009 277.743 143.056 277.697 143.102C277.619 143.182 277.54 143.262 277.46 143.342C277.228 143.573 276.992 143.801 276.75 144.024C276.632 144.131 276.515 144.237 276.397 144.342C276.382 144.356 276.364 144.371 276.349 144.384C276.293 144.436 276.233 144.487 276.173 144.538C276.04 144.655 275.905 144.77 275.769 144.885C275.752 144.891 275.737 144.899 275.72 144.906C275.709 144.91 275.698 144.913 275.688 144.918C275.639 145.027 275.591 145.137 275.544 145.249C275.517 145.307 275.491 145.365 275.466 145.424C275.437 145.49 275.409 145.556 275.38 145.624C275.389 145.621 275.397 145.617 275.406 145.614C275.904 145.444 276.401 145.267 276.9 145.084C277.113 145.005 277.326 144.926 277.538 144.843C277.559 144.838 277.579 144.828 277.6 144.821C277.6 144.821 277.601 144.819 277.603 144.82C277.725 144.716 277.847 144.614 277.968 144.508C278.28 144.239 278.586 143.964 278.885 143.68C278.977 143.638 279.071 143.593 279.164 143.547L279.167 143.546C279.26 143.502 279.352 143.456 279.442 143.41C279.658 143.303 279.87 143.194 280.08 143.081C280.289 142.971 280.497 142.857 280.701 142.743C280.357 143.102 280.004 143.453 279.642 143.797C279.73 143.756 279.818 143.715 279.906 143.674C280.12 143.575 280.332 143.472 280.543 143.368C280.742 143.27 280.939 143.168 281.133 143.063C281.104 143.076 281.072 143.088 281.042 143.101C281.472 142.622 281.887 142.13 282.285 141.626L282.285 141.626ZM284.389 141.039C284.41 141.021 284.433 141.004 284.454 140.984C284.457 140.981 284.458 140.979 284.461 140.976C284.437 140.997 284.413 141.018 284.389 141.039ZM281.134 143.064C280.939 143.169 280.742 143.271 280.543 143.369C280.332 143.472 280.12 143.575 279.907 143.674C279.819 143.715 279.731 143.757 279.642 143.798C280.004 143.453 280.358 143.102 280.701 142.743C280.497 142.858 280.29 142.971 280.08 143.082C279.871 143.195 279.658 143.304 279.442 143.41C279.352 143.457 279.26 143.503 279.167 143.546L279.165 143.548C279.071 143.593 278.977 143.639 278.885 143.681C278.586 143.964 278.28 144.24 277.968 144.508C277.847 144.614 277.725 144.717 277.603 144.82C277.696 144.785 277.785 144.75 277.878 144.713C277.917 144.697 277.956 144.683 277.993 144.667C278.055 144.641 278.118 144.617 278.18 144.59C278.212 144.578 278.244 144.564 278.276 144.551C278.41 144.497 278.546 144.441 278.679 144.384C278.891 144.295 279.102 144.202 279.312 144.108C279.404 144.067 279.497 144.025 279.59 143.981C279.63 143.964 279.671 143.947 279.712 143.927C279.754 143.91 279.794 143.89 279.835 143.87C280.053 143.769 280.268 143.665 280.484 143.558C280.574 143.514 280.665 143.469 280.755 143.423L280.756 143.421C280.771 143.413 280.786 143.406 280.799 143.398C280.892 143.35 280.984 143.302 281.075 143.254C281.085 143.249 281.093 143.243 281.104 143.238C281.189 143.192 281.275 143.146 281.358 143.099C281.453 143.045 281.547 142.992 281.641 142.94C281.828 142.832 282.014 142.72 282.198 142.609C282.219 142.597 282.239 142.583 282.258 142.57C281.89 142.744 281.514 142.904 281.135 143.063L281.134 143.064ZM275.259 145.093C275.251 145.097 275.244 145.099 275.237 145.102C275.122 145.147 275.008 145.196 274.894 145.242C274.299 145.487 273.706 145.738 273.111 145.961C272.984 146.01 272.856 146.057 272.729 146.103C272.609 146.145 272.487 146.185 272.368 146.221C272.316 146.237 272.265 146.256 272.214 146.269C272.127 146.296 272.04 146.323 271.952 146.345C271.95 146.346 271.949 146.348 271.947 146.348C271.847 146.376 271.747 146.402 271.646 146.427C271.768 146.338 271.887 146.249 272.007 146.158C272.166 146.038 272.323 145.914 272.479 145.786C272.479 145.786 272.479 145.785 272.481 145.785C272.542 145.737 272.605 145.689 272.664 145.64C272.726 145.59 272.79 145.54 272.849 145.491C272.746 145.527 272.643 145.561 272.541 145.595C272.539 145.595 272.539 145.596 272.539 145.596C272.283 145.678 272.024 145.761 271.765 145.842C271.505 145.916 271.243 145.985 270.977 146.043L270.975 146.042C270.93 146.092 270.883 146.139 270.836 146.188C270.852 146.147 270.867 146.104 270.882 146.062C270.779 146.084 270.678 146.101 270.576 146.119C270.556 146.249 270.534 146.378 270.513 146.507C270.361 146.653 270.207 146.799 270.059 146.948C270.012 146.997 269.964 147.044 269.916 147.091C269.502 147.503 269.06 147.883 268.618 148.265C268.445 148.413 268.273 148.564 268.102 148.716C268.105 148.714 268.107 148.713 268.11 148.712C268.259 148.627 268.409 148.542 268.559 148.455C268.636 148.41 268.714 148.365 268.792 148.318C268.871 148.272 268.948 148.227 269.025 148.18C269.181 148.089 269.334 147.995 269.487 147.898C269.618 147.819 269.747 147.738 269.875 147.656C270.203 147.443 270.527 147.225 270.848 147.003C270.85 147.004 270.851 147.002 270.851 147.002C270.906 146.964 270.961 146.927 271.017 146.889C271.088 146.835 271.161 146.783 271.234 146.73C271.264 146.728 271.29 146.726 271.318 146.724C271.397 146.717 271.475 146.708 271.553 146.697C271.658 146.685 271.761 146.67 271.863 146.653L271.866 146.652C271.91 146.644 271.956 146.635 272.001 146.627C272.1 146.609 272.199 146.59 272.297 146.569C272.613 146.502 272.926 146.419 273.235 146.33C273.548 146.232 273.861 146.135 274.17 146.033C274.17 146.033 274.171 146.034 274.172 146.032C274.45 145.94 274.724 145.848 274.998 145.756C275.001 145.755 275.003 145.753 275.006 145.752C275.13 145.711 275.256 145.668 275.381 145.623C275.411 145.556 275.438 145.489 275.467 145.424C275.492 145.365 275.519 145.306 275.545 145.248C275.592 145.136 275.641 145.027 275.689 144.917C275.545 144.974 275.405 145.033 275.26 145.092L275.259 145.093ZM264.626 147.979C264.627 147.965 264.63 147.949 264.632 147.933C264.589 147.868 264.552 147.798 264.515 147.728C264.411 147.523 264.328 147.309 264.266 147.092C264.234 146.986 264.209 146.88 264.187 146.774C264.05 146.118 264.043 145.456 264.077 144.813C264.116 144.165 264.197 143.544 264.261 142.916C264.329 142.288 264.41 141.661 264.49 141.036C264.527 140.746 264.567 140.454 264.609 140.163C264.615 140.11 264.623 140.056 264.631 140.002C264.637 139.998 264.643 139.994 264.649 139.987C264.66 139.979 264.672 139.97 264.684 139.959C264.739 139.595 264.8 139.231 264.866 138.868C265.075 137.702 265.326 136.542 265.633 135.393C265.714 135.101 265.8 134.811 265.887 134.521C265.914 134.438 265.94 134.352 265.966 134.269C266.012 134.126 266.056 133.986 266.102 133.846C266.123 133.781 266.142 133.719 266.165 133.655C266.071 133.662 265.98 133.671 265.888 133.681C265.897 133.648 265.907 133.614 265.915 133.581C265.913 133.578 265.911 133.577 265.909 133.579C265.899 133.613 265.889 133.648 265.881 133.683C265.872 133.709 265.865 133.734 265.858 133.761L265.855 133.771C265.848 133.804 265.838 133.839 265.829 133.871C265.813 133.927 265.799 133.981 265.786 134.038C265.743 134.198 265.701 134.36 265.662 134.521C265.618 134.698 265.574 134.874 265.533 135.052C265.504 135.17 265.476 135.289 265.449 135.408C265.417 135.544 265.386 135.681 265.358 135.819C265.318 135.994 265.28 136.171 265.244 136.348C265.202 136.54 265.163 136.733 265.125 136.926C265.101 137.044 265.08 137.161 265.056 137.277C265.023 137.451 264.991 137.625 264.96 137.798C264.889 138.184 264.823 138.571 264.76 138.958C264.752 139.012 264.742 139.064 264.736 139.119C264.708 139.284 264.682 139.45 264.658 139.618C264.635 139.756 264.615 139.894 264.596 140.033C264.588 140.087 264.58 140.139 264.572 140.193C264.522 140.538 264.475 140.881 264.431 141.227C264.351 141.852 264.27 142.479 264.202 143.106C264.138 143.735 264.057 144.356 264.018 145.004C263.985 145.647 263.991 146.308 264.128 146.965C264.137 147.006 264.145 147.049 264.156 147.09C264.222 147.374 264.322 147.656 264.456 147.919C264.475 147.955 264.495 147.991 264.516 148.028C264.534 148.06 264.552 148.093 264.573 148.124C264.579 148.136 264.588 148.148 264.595 148.159C264.597 148.164 264.601 148.169 264.604 148.174L264.604 148.173C264.614 148.108 264.621 148.046 264.627 147.98L264.626 147.979ZM266.436 131.858C266.398 131.967 266.365 132.078 266.329 132.187C266.308 132.252 266.287 132.314 266.269 132.377C266.323 132.204 266.378 132.032 266.436 131.858ZM260.262 140.724C260.22 140.729 260.178 140.733 260.138 140.74C260.063 140.748 259.991 140.761 259.918 140.773C259.863 140.784 259.809 140.795 259.755 140.805C259.672 140.819 259.589 140.839 259.509 140.857C259.468 140.866 259.429 140.876 259.389 140.887C259.359 140.894 259.331 140.903 259.301 140.91C259.285 140.914 259.268 140.919 259.252 140.924C259.152 140.951 259.052 140.979 258.955 141.011C258.905 141.025 258.857 141.042 258.81 141.057L258.807 141.059C258.679 141.101 258.554 141.146 258.429 141.195C258.415 141.2 258.4 141.206 258.386 141.211C258.325 141.235 258.264 141.258 258.205 141.284C258.168 141.298 258.133 141.314 258.098 141.329C258.081 141.338 258.061 141.345 258.043 141.354L258.041 141.353C257.483 141.598 256.948 141.895 256.447 142.241L256.446 142.243C256.394 142.278 256.341 142.314 256.29 142.351L256.138 142.463C256.116 142.478 256.095 142.494 256.072 142.512C255.992 142.573 255.913 142.636 255.833 142.698C255.813 142.712 255.795 142.727 255.777 142.742C255.734 142.778 255.692 142.814 255.65 142.85C255.606 142.885 255.564 142.921 255.524 142.958C255.44 143.03 255.357 143.104 255.275 143.181L255.275 143.183C255.287 143.452 255.303 143.722 255.321 143.989C255.325 144.034 255.329 144.076 255.333 144.12C255.48 143.993 255.628 143.87 255.779 143.75C255.8 143.732 255.823 143.714 255.844 143.696C255.87 143.676 255.894 143.655 255.921 143.634C255.996 143.574 256.072 143.514 256.147 143.454C256.236 143.386 256.325 143.318 256.414 143.252C256.435 143.234 256.457 143.218 256.48 143.201C256.523 143.167 256.566 143.134 256.611 143.101C256.929 142.866 257.252 142.638 257.579 142.419L257.579 142.417C257.584 142.417 257.586 142.415 257.589 142.412C257.625 142.389 257.663 142.364 257.699 142.34C257.723 142.324 257.748 142.307 257.777 142.292C257.78 142.289 257.78 142.287 257.783 142.285C257.833 142.252 257.884 142.219 257.937 142.187C257.956 142.175 257.975 142.162 257.994 142.15C258.104 142.076 258.217 142.006 258.333 141.937C258.351 141.924 258.369 141.914 258.387 141.903C258.42 141.881 258.455 141.861 258.487 141.841C258.616 141.761 258.746 141.682 258.878 141.606C258.992 141.538 259.106 141.472 259.224 141.408C259.24 141.399 259.259 141.388 259.275 141.379L259.275 141.377C259.388 141.315 259.495 141.255 259.605 141.192C259.761 141.105 259.917 141.019 260.076 140.93C260.215 140.854 260.355 140.777 260.496 140.699C260.418 140.706 260.339 140.714 260.26 140.725L260.262 140.724ZM262.864 131.591C262.767 131.603 262.669 131.62 262.573 131.637C262.458 131.656 262.345 131.678 262.232 131.702C262.182 131.712 262.132 131.722 262.082 131.734C262.055 131.74 262.029 131.746 262.001 131.753C261.993 131.759 261.988 131.767 261.982 131.774C261.954 131.804 261.928 131.837 261.899 131.867C261.915 131.831 261.933 131.799 261.952 131.763C261.931 131.767 261.913 131.771 261.892 131.776C261.78 131.803 261.667 131.831 261.556 131.86C261.522 131.994 261.492 132.128 261.468 132.265C261.383 132.375 261.298 132.487 261.22 132.598C261.164 132.674 261.11 132.75 261.059 132.825C261.092 132.813 261.127 132.8 261.16 132.788C261.316 132.733 261.474 132.678 261.631 132.627C261.704 132.604 261.776 132.58 261.846 132.559C261.953 132.524 262.06 132.491 262.167 132.461C262.188 132.454 262.212 132.447 262.235 132.44C262.212 132.445 262.191 132.452 262.167 132.459L262.361 132.229L262.539 132.02C262.664 131.873 262.787 131.731 262.913 131.585C262.896 131.585 262.88 131.588 262.865 131.591L262.864 131.591ZM255.264 144.179C255.209 144.227 255.152 144.275 255.099 144.326C255.176 144.256 255.254 144.188 255.334 144.121C255.311 144.14 255.287 144.16 255.264 144.179L255.264 144.179ZM291.868 128.085C291.87 128.048 291.875 128.009 291.882 127.971C291.902 127.913 291.92 127.854 291.939 127.795C291.94 127.791 291.94 127.785 291.941 127.781C291.922 127.836 291.905 127.893 291.886 127.948C291.808 128.177 291.729 128.407 291.647 128.636C291.722 128.451 291.796 128.268 291.868 128.084L291.868 128.085ZM291.49 128.263C291.455 128.377 291.418 128.491 291.38 128.604C291.219 129.106 291.046 129.605 290.86 130.098C290.528 130.99 290.157 131.864 289.746 132.715C289.769 132.679 289.791 132.64 289.812 132.603C290.12 132.051 290.405 131.489 290.67 130.919C290.837 130.551 291.004 130.182 291.161 129.813L291.162 129.809C291.289 129.297 291.399 128.781 291.49 128.263L291.49 128.263ZM288.523 134.17C288.564 134.052 288.604 133.931 288.643 133.812L288.648 133.798C288.668 133.734 288.687 133.673 288.708 133.608C288.787 133.341 288.863 133.075 288.935 132.807C288.967 132.691 288.997 132.578 289.026 132.464C289.082 132.247 289.136 132.032 289.185 131.818C289.217 131.689 289.247 131.561 289.275 131.432C289.432 130.692 289.587 129.954 289.711 129.214C289.974 127.735 290.208 126.25 290.365 124.747C290.245 125.106 290.129 125.466 290.019 125.826C289.979 125.951 289.943 126.073 289.906 126.197C289.836 126.432 289.767 126.667 289.698 126.902C289.631 127.138 289.562 127.373 289.497 127.609C289.438 127.821 289.382 128.031 289.326 128.243C289.25 128.522 289.176 128.802 289.105 129.08C288.908 129.806 288.74 130.534 288.543 131.253C288.358 131.974 288.166 132.694 287.943 133.397C287.923 133.46 287.905 133.526 287.883 133.588C287.848 133.708 287.811 133.826 287.772 133.945L287.764 133.968C287.714 134.123 287.663 134.278 287.61 134.43C287.538 134.639 287.462 134.846 287.383 135.053L287.383 135.055C287.303 135.267 287.219 135.479 287.134 135.687C287.101 135.77 287.067 135.851 287.032 135.933C286.998 136.012 286.964 136.093 286.928 136.171C286.908 136.219 286.887 136.265 286.867 136.312L286.866 136.314C286.831 136.39 286.797 136.465 286.762 136.541C286.689 136.703 286.613 136.862 286.535 137.02C286.458 137.181 286.378 137.339 286.296 137.496C286.097 137.875 285.888 138.252 285.668 138.622C285.595 138.746 285.521 138.868 285.445 138.991C285.281 139.159 285.113 139.327 284.944 139.489C284.605 139.816 284.254 140.13 283.892 140.428C283.865 140.45 283.838 140.473 283.81 140.493C284.47 140.37 285.149 140.293 285.821 140.204C285.931 140.097 286.04 139.985 286.144 139.872C286.217 139.655 286.289 139.438 286.358 139.22C286.411 139.055 286.462 138.889 286.514 138.722C286.65 138.274 286.783 137.823 286.913 137.371C286.995 137.084 287.078 136.796 287.167 136.509C287.215 136.348 287.264 136.189 287.315 136.028L287.316 136.026C287.336 135.963 287.355 135.9 287.375 135.837C287.436 135.778 287.496 135.719 287.555 135.658C287.697 135.515 287.835 135.368 287.97 135.216C287.907 135.462 287.851 135.71 287.795 135.958C287.791 135.975 287.787 135.993 287.784 136.011L287.769 136.075C287.773 136.068 287.778 136.061 287.781 136.052C287.794 136.025 287.806 135.997 287.82 135.971C287.848 135.907 287.879 135.841 287.908 135.778C287.943 135.701 287.976 135.624 288.007 135.547C288.036 135.479 288.064 135.411 288.092 135.342C288.107 135.305 288.122 135.268 288.136 135.233C288.184 135.115 288.23 134.994 288.273 134.874C288.279 134.864 288.283 134.854 288.286 134.843C288.287 134.841 288.29 134.838 288.291 134.836C288.292 134.832 288.292 134.828 288.292 134.826C288.374 134.608 288.45 134.39 288.524 134.17L288.523 134.17ZM282.285 141.626C282.269 141.637 282.255 141.647 282.239 141.656C282.09 141.756 281.94 141.851 281.789 141.947C281.619 142.054 281.445 142.16 281.271 142.262C281.189 142.309 281.107 142.357 281.025 142.404C281.025 142.404 281.024 142.406 281.022 142.408C280.918 142.466 280.813 142.525 280.709 142.583C280.615 142.635 280.519 142.686 280.426 142.738C280.332 142.789 280.236 142.84 280.141 142.891C280.024 142.954 279.906 143.016 279.784 143.075C279.761 143.088 279.735 143.102 279.71 143.114C279.684 143.127 279.658 143.141 279.633 143.153C279.594 143.175 279.553 143.195 279.508 143.215C279.505 143.216 279.503 143.218 279.502 143.22C279.49 143.226 279.476 143.234 279.462 143.239C279.385 143.278 279.308 143.317 279.23 143.353C279.228 143.354 279.227 143.356 279.225 143.357C279.156 143.391 279.085 143.425 279.015 143.457C278.659 143.629 278.298 143.794 277.937 143.955C277.764 144.033 277.591 144.107 277.42 144.183L277.415 144.185C277.256 144.254 277.095 144.325 276.936 144.394C277.284 144.148 277.623 143.889 277.952 143.615C278.076 143.512 278.196 143.407 278.318 143.3C278.353 143.27 278.387 143.239 278.421 143.209C278.44 143.19 278.461 143.172 278.481 143.152C278.519 143.119 278.555 143.084 278.59 143.05L278.595 143.048C278.61 143.034 278.623 143.02 278.639 143.006C278.728 142.925 278.816 142.842 278.9 142.756C279.037 142.624 279.167 142.49 279.297 142.352C279.314 142.335 279.33 142.317 279.348 142.298C279.413 142.23 279.478 142.158 279.541 142.087C279.553 142.076 279.564 142.063 279.574 142.052C279.587 142.038 279.598 142.025 279.612 142.01L279.612 142.008C279.739 141.867 279.863 141.725 279.985 141.579L279.985 141.577C279.994 141.57 280.002 141.56 280.009 141.552C280.071 141.476 280.133 141.401 280.196 141.324C280.229 141.281 280.263 141.238 280.297 141.195C280.298 141.193 280.3 141.192 280.301 141.19C280.354 141.122 280.407 141.054 280.459 140.984C280.835 140.49 281.183 139.975 281.514 139.454C281.91 138.804 282.282 138.143 282.632 137.474C282.972 136.798 283.311 136.125 283.62 135.441C283.744 135.172 283.867 134.903 283.99 134.634C284.106 134.378 284.222 134.123 284.335 133.865C284.341 133.852 284.346 133.837 284.353 133.825L284.355 133.819C284.361 133.808 284.366 133.793 284.372 133.783L284.373 133.779C284.493 133.507 284.611 133.232 284.727 132.958C284.844 132.683 284.956 132.408 285.069 132.131C285.083 132.096 285.098 132.059 285.112 132.024L285.115 132.016C285.179 131.857 285.243 131.696 285.303 131.536C285.335 131.454 285.367 131.375 285.398 131.293C285.327 131.399 285.258 131.506 285.19 131.613L285.189 131.614C285.171 131.642 285.154 131.668 285.138 131.696C285.018 131.878 284.902 132.06 284.787 132.246C284.773 132.267 284.759 132.289 284.745 132.31L284.745 132.312C284.739 132.322 284.731 132.332 284.726 132.343C284.652 132.459 284.58 132.574 284.51 132.691L284.509 132.693C284.495 132.716 284.481 132.738 284.467 132.761C284.374 132.914 284.281 133.065 284.19 133.219C283.805 133.86 283.432 134.506 283.067 135.157C282.692 135.808 282.344 136.471 281.969 137.114C281.787 137.438 281.603 137.762 281.416 138.084C281.229 138.403 281.037 138.72 280.838 139.032C280.781 139.124 280.724 139.216 280.667 139.308C280.614 139.393 280.561 139.475 280.506 139.559C280.502 139.566 280.497 139.573 280.493 139.58C280.489 139.585 280.487 139.591 280.483 139.596C280.299 139.877 280.112 140.156 279.918 140.43L279.917 140.433C279.91 140.44 279.906 140.446 279.901 140.453C279.822 140.565 279.742 140.676 279.659 140.786C279.563 140.919 279.465 141.049 279.366 141.177C279.344 141.204 279.324 141.23 279.302 141.259C279.232 141.348 279.161 141.44 279.088 141.528C278.804 141.886 278.506 142.234 278.197 142.573C278.18 142.592 278.16 142.613 278.143 142.632L278.14 142.633C278.039 142.744 277.935 142.853 277.832 142.962C277.789 143.009 277.743 143.056 277.697 143.101C277.619 143.182 277.541 143.262 277.46 143.341C277.228 143.572 276.992 143.8 276.75 144.024C276.633 144.131 276.516 144.237 276.397 144.342C276.382 144.355 276.364 144.37 276.349 144.384C276.293 144.436 276.233 144.487 276.173 144.538C276.04 144.654 275.906 144.769 275.769 144.884C275.752 144.891 275.737 144.898 275.72 144.905C275.71 144.91 275.698 144.912 275.688 144.917C275.639 145.027 275.591 145.136 275.544 145.248C275.517 145.307 275.491 145.365 275.466 145.424C275.437 145.49 275.41 145.556 275.38 145.624C275.389 145.621 275.397 145.617 275.406 145.614C275.904 145.443 276.401 145.266 276.9 145.083C277.113 145.005 277.326 144.925 277.538 144.843C277.559 144.838 277.579 144.828 277.6 144.82C277.6 144.82 277.601 144.818 277.603 144.819C277.725 144.716 277.847 144.613 277.968 144.508C278.28 144.239 278.586 143.964 278.885 143.68C278.977 143.638 279.071 143.592 279.165 143.547L279.167 143.546C279.26 143.502 279.352 143.456 279.442 143.409C279.658 143.303 279.87 143.194 280.08 143.081C280.29 142.97 280.497 142.857 280.701 142.742C280.358 143.101 280.004 143.453 279.642 143.797C279.73 143.756 279.818 143.715 279.907 143.673C280.12 143.575 280.332 143.472 280.543 143.368C280.742 143.27 280.939 143.168 281.134 143.063C281.104 143.076 281.072 143.088 281.042 143.101C281.472 142.622 281.887 142.13 282.285 141.625L282.285 141.626ZM284.389 141.039C284.41 141.021 284.433 141.004 284.454 140.984C284.458 140.981 284.458 140.979 284.461 140.976C284.437 140.997 284.413 141.018 284.389 141.039ZM280.544 143.368C280.333 143.472 280.121 143.575 279.907 143.674C279.819 143.715 279.731 143.756 279.643 143.798C280.004 143.453 280.358 143.102 280.702 142.743C280.498 142.858 280.29 142.971 280.081 143.082C279.871 143.194 279.659 143.304 279.443 143.41C279.353 143.457 279.261 143.503 279.168 143.546L279.165 143.547C279.071 143.593 278.978 143.638 278.885 143.68C278.587 143.964 278.281 144.239 277.968 144.508C277.847 144.614 277.725 144.717 277.604 144.82C277.696 144.784 277.786 144.75 277.879 144.713C277.918 144.697 277.956 144.683 277.994 144.666C278.055 144.641 278.118 144.617 278.18 144.59C278.212 144.578 278.244 144.563 278.276 144.551C278.411 144.497 278.546 144.44 278.679 144.384C278.892 144.295 279.103 144.202 279.312 144.108C279.405 144.066 279.497 144.025 279.59 143.981C279.63 143.963 279.672 143.946 279.712 143.927C279.754 143.909 279.795 143.89 279.835 143.87C280.054 143.769 280.269 143.665 280.485 143.558C280.574 143.513 280.665 143.469 280.756 143.422L280.756 143.42C280.771 143.413 280.787 143.406 280.8 143.398C280.892 143.35 280.985 143.302 281.076 143.253C281.086 143.248 281.094 143.243 281.104 143.238C281.19 143.192 281.275 143.145 281.359 143.099C281.453 143.045 281.548 142.991 281.641 142.94C281.828 142.832 282.014 142.72 282.198 142.608C282.219 142.597 282.239 142.583 282.258 142.57C281.891 142.744 281.514 142.904 281.135 143.063C280.94 143.169 280.743 143.27 280.545 143.368L280.544 143.368ZM275.237 145.102C275.123 145.147 275.009 145.196 274.894 145.242C274.3 145.487 273.707 145.738 273.111 145.961C272.985 146.01 272.857 146.056 272.73 146.102C272.609 146.145 272.488 146.185 272.368 146.221C272.317 146.237 272.266 146.255 272.215 146.269C272.127 146.296 272.04 146.322 271.953 146.345C271.95 146.346 271.95 146.348 271.948 146.347C271.847 146.376 271.747 146.402 271.647 146.426C271.768 146.338 271.887 146.249 272.007 146.158C272.167 146.038 272.324 145.914 272.479 145.786C272.479 145.786 272.48 145.784 272.482 145.785C272.543 145.737 272.606 145.689 272.665 145.64C272.727 145.589 272.79 145.54 272.849 145.491C272.746 145.527 272.644 145.561 272.542 145.595C272.54 145.594 272.539 145.596 272.539 145.596C272.283 145.678 272.025 145.761 271.765 145.842C271.506 145.916 271.244 145.985 270.977 146.042L270.976 146.042C270.931 146.092 270.883 146.138 270.836 146.188C270.853 146.147 270.868 146.103 270.882 146.062C270.78 146.084 270.679 146.101 270.576 146.118C270.556 146.249 270.535 146.378 270.513 146.507C270.361 146.653 270.207 146.799 270.059 146.948C270.013 146.997 269.965 147.044 269.917 147.091C269.502 147.503 269.061 147.883 268.619 148.264C268.445 148.413 268.273 148.564 268.103 148.715C268.105 148.714 268.108 148.713 268.11 148.712C268.26 148.627 268.409 148.542 268.559 148.455C268.636 148.41 268.715 148.365 268.792 148.318C268.871 148.272 268.948 148.227 269.026 148.18C269.182 148.089 269.334 147.994 269.488 147.898C269.618 147.819 269.748 147.738 269.875 147.655C270.203 147.443 270.528 147.224 270.849 147.003C270.851 147.004 270.851 147.002 270.851 147.002C270.907 146.964 270.962 146.926 271.017 146.889C271.088 146.835 271.161 146.783 271.234 146.73C271.265 146.728 271.291 146.726 271.319 146.723C271.397 146.717 271.476 146.708 271.554 146.697C271.659 146.685 271.761 146.67 271.864 146.653L271.866 146.652C271.911 146.644 271.956 146.635 272.001 146.627C272.1 146.609 272.2 146.59 272.297 146.569C272.613 146.502 272.926 146.419 273.235 146.33C273.549 146.232 273.861 146.134 274.17 146.033C274.17 146.033 274.172 146.033 274.173 146.031C274.45 145.94 274.725 145.848 274.999 145.756C275.001 145.754 275.004 145.753 275.007 145.752C275.13 145.711 275.257 145.668 275.382 145.623C275.412 145.556 275.439 145.489 275.468 145.423C275.493 145.364 275.519 145.306 275.546 145.248C275.593 145.136 275.641 145.026 275.69 144.917C275.546 144.974 275.405 145.033 275.261 145.092C275.253 145.096 275.246 145.098 275.238 145.101L275.237 145.102ZM264.627 147.979C264.628 147.965 264.631 147.949 264.632 147.933C264.59 147.867 264.553 147.798 264.516 147.728C264.412 147.523 264.328 147.309 264.267 147.092C264.234 146.985 264.209 146.88 264.187 146.774C264.051 146.117 264.044 145.456 264.078 144.812C264.117 144.165 264.198 143.544 264.262 142.915C264.33 142.288 264.41 141.661 264.49 141.036C264.528 140.745 264.568 140.454 264.61 140.163C264.615 140.11 264.623 140.056 264.632 140.002C264.637 139.998 264.643 139.993 264.649 139.987C264.661 139.978 264.672 139.97 264.684 139.959C264.739 139.595 264.8 139.231 264.867 138.868C265.075 137.702 265.326 136.542 265.634 135.393C265.714 135.101 265.8 134.81 265.888 134.521C265.915 134.437 265.94 134.351 265.967 134.268C266.012 134.126 266.057 133.986 266.103 133.846C266.123 133.781 266.143 133.718 266.165 133.654C266.072 133.662 265.98 133.67 265.889 133.681C265.898 133.648 265.908 133.614 265.915 133.58C265.914 133.578 265.912 133.577 265.909 133.578C265.9 133.613 265.89 133.647 265.882 133.683C265.873 133.709 265.866 133.734 265.859 133.761L265.855 133.771C265.848 133.804 265.838 133.838 265.829 133.871C265.814 133.927 265.799 133.981 265.786 134.037C265.743 134.197 265.702 134.36 265.663 134.521C265.618 134.698 265.574 134.874 265.533 135.051C265.505 135.17 265.477 135.289 265.45 135.408C265.417 135.544 265.387 135.681 265.358 135.818C265.318 135.994 265.28 136.17 265.244 136.348C265.203 136.54 265.163 136.732 265.126 136.926C265.102 137.044 265.08 137.161 265.057 137.277C265.024 137.451 264.991 137.625 264.961 137.797C264.89 138.184 264.823 138.571 264.761 138.958C264.752 139.012 264.743 139.064 264.737 139.118C264.709 139.284 264.683 139.449 264.658 139.618C264.636 139.755 264.615 139.893 264.597 140.032C264.588 140.086 264.581 140.139 264.573 140.193C264.523 140.538 264.475 140.881 264.431 141.226C264.351 141.852 264.271 142.479 264.203 143.106C264.139 143.735 264.058 144.355 264.019 145.003C263.985 145.647 263.992 146.308 264.128 146.964C264.137 147.005 264.146 147.048 264.156 147.09C264.222 147.374 264.323 147.655 264.457 147.919C264.476 147.955 264.495 147.991 264.516 148.028C264.535 148.059 264.552 148.093 264.573 148.123C264.58 148.136 264.588 148.148 264.595 148.158C264.598 148.163 264.602 148.169 264.604 148.174L264.605 148.172C264.615 148.108 264.622 148.045 264.627 147.98L264.627 147.979ZM266.329 132.187C266.309 132.252 266.287 132.314 266.269 132.377C266.323 132.204 266.379 132.032 266.437 131.858C266.399 131.967 266.365 132.077 266.329 132.187ZM260.138 140.74C260.064 140.748 259.992 140.761 259.918 140.773C259.864 140.784 259.81 140.794 259.755 140.805C259.673 140.819 259.59 140.838 259.51 140.857C259.469 140.866 259.429 140.876 259.39 140.887C259.36 140.894 259.331 140.903 259.302 140.909C259.285 140.914 259.269 140.919 259.252 140.924C259.153 140.95 259.052 140.979 258.955 141.01C258.906 141.025 258.858 141.042 258.81 141.057L258.808 141.058C258.679 141.1 258.554 141.145 258.43 141.195C258.415 141.2 258.401 141.206 258.386 141.211C258.325 141.234 258.265 141.258 258.205 141.283C258.168 141.298 258.134 141.313 258.099 141.329C258.081 141.337 258.061 141.345 258.044 141.354L258.042 141.353C257.483 141.598 256.948 141.894 256.447 142.241L256.447 142.243C256.394 142.277 256.342 142.314 256.291 142.351L256.138 142.463C256.116 142.478 256.096 142.494 256.073 142.512C255.993 142.572 255.914 142.636 255.833 142.698C255.814 142.712 255.796 142.727 255.778 142.742C255.734 142.777 255.692 142.813 255.65 142.849C255.606 142.885 255.564 142.921 255.524 142.957C255.44 143.03 255.357 143.104 255.276 143.181L255.275 143.183C255.287 143.452 255.303 143.721 255.322 143.989C255.325 144.034 255.33 144.076 255.334 144.119C255.481 143.993 255.629 143.87 255.78 143.749C255.801 143.731 255.824 143.714 255.845 143.696C255.871 143.676 255.895 143.654 255.921 143.634C255.997 143.574 256.072 143.514 256.148 143.454C256.237 143.386 256.326 143.317 256.414 143.251C256.435 143.233 256.457 143.218 256.48 143.201C256.524 143.167 256.567 143.134 256.612 143.101C256.929 142.865 257.253 142.638 257.579 142.419L257.58 142.417C257.584 142.416 257.587 142.415 257.59 142.412C257.625 142.388 257.664 142.364 257.699 142.34C257.724 142.324 257.749 142.307 257.777 142.291C257.78 142.288 257.781 142.286 257.784 142.285C257.833 142.252 257.884 142.219 257.938 142.187C257.957 142.175 257.976 142.162 257.995 142.15C258.105 142.076 258.218 142.006 258.334 141.937C258.351 141.924 258.37 141.913 258.388 141.903C258.421 141.881 258.455 141.861 258.488 141.84C258.616 141.761 258.747 141.682 258.879 141.605C258.993 141.537 259.106 141.471 259.225 141.408C259.241 141.398 259.259 141.388 259.275 141.379L259.276 141.377C259.388 141.314 259.495 141.255 259.605 141.192C259.762 141.105 259.918 141.018 260.077 140.93C260.215 140.854 260.356 140.777 260.496 140.699C260.418 140.705 260.339 140.714 260.26 140.724C260.218 140.729 260.177 140.733 260.136 140.74L260.138 140.74ZM261.632 132.627C261.705 132.603 261.776 132.58 261.847 132.558C261.954 132.523 262.06 132.491 262.167 132.46C262.189 132.453 262.212 132.446 262.236 132.44C262.213 132.444 262.191 132.452 262.168 132.458L262.361 132.229L262.54 132.019C262.664 131.872 262.787 131.73 262.914 131.584C262.897 131.585 262.881 131.588 262.865 131.59C262.768 131.603 262.67 131.62 262.573 131.637C262.459 131.656 262.346 131.678 262.233 131.702C262.183 131.712 262.133 131.722 262.083 131.734C262.055 131.74 262.03 131.746 262.002 131.753C261.994 131.758 261.989 131.767 261.983 131.773C261.955 131.804 261.929 131.837 261.9 131.867C261.916 131.831 261.934 131.799 261.952 131.763C261.932 131.767 261.914 131.771 261.893 131.776C261.781 131.803 261.668 131.831 261.557 131.86C261.523 131.994 261.493 132.128 261.469 132.265C261.384 132.375 261.299 132.486 261.221 132.598C261.165 132.674 261.111 132.75 261.06 132.825C261.093 132.813 261.128 132.8 261.161 132.788C261.317 132.733 261.475 132.678 261.632 132.627L261.632 132.627ZM255.099 144.326C255.176 144.255 255.255 144.188 255.335 144.121C255.311 144.14 255.288 144.159 255.264 144.179C255.209 144.227 255.153 144.275 255.099 144.326L255.099 144.326ZM291.868 128.085C291.87 128.048 291.875 128.009 291.882 127.972C291.902 127.913 291.921 127.854 291.939 127.795C291.94 127.792 291.94 127.785 291.942 127.781C291.923 127.836 291.905 127.893 291.886 127.948C291.809 128.178 291.729 128.407 291.648 128.636C291.722 128.451 291.796 128.268 291.868 128.084L291.868 128.085ZM291.38 128.605C291.219 129.107 291.046 129.605 290.86 130.099C290.528 130.99 290.157 131.864 289.746 132.716C289.769 132.68 289.791 132.641 289.812 132.604C290.12 132.051 290.405 131.489 290.67 130.919C290.838 130.552 291.004 130.182 291.161 129.813L291.162 129.81C291.289 129.297 291.399 128.781 291.49 128.264C291.455 128.378 291.417 128.491 291.38 128.604L291.38 128.605ZM288.644 133.812L288.648 133.799C288.668 133.734 288.687 133.673 288.708 133.609C288.788 133.342 288.863 133.075 288.935 132.807C288.967 132.692 288.998 132.579 289.027 132.464C289.083 132.248 289.136 132.033 289.185 131.818C289.217 131.69 289.247 131.562 289.275 131.432C289.432 130.693 289.587 129.954 289.712 129.214C289.974 127.736 290.209 126.25 290.365 124.748C290.245 125.106 290.129 125.466 290.019 125.826C289.979 125.952 289.943 126.074 289.907 126.198C289.836 126.432 289.767 126.668 289.698 126.903C289.631 127.138 289.562 127.374 289.497 127.61C289.439 127.821 289.383 128.031 289.326 128.243C289.25 128.522 289.176 128.802 289.105 129.081C288.908 129.806 288.74 130.534 288.543 131.254C288.359 131.975 288.166 132.694 287.943 133.398C287.923 133.461 287.905 133.526 287.883 133.588C287.848 133.709 287.811 133.826 287.772 133.945L287.764 133.968C287.715 134.124 287.663 134.278 287.61 134.431C287.538 134.639 287.462 134.847 287.384 135.054L287.383 135.056C287.303 135.268 287.219 135.479 287.134 135.687C287.101 135.771 287.067 135.852 287.032 135.934C286.998 136.013 286.964 136.094 286.928 136.172C286.908 136.219 286.888 136.265 286.867 136.313L286.866 136.315C286.831 136.391 286.797 136.466 286.762 136.542C286.689 136.704 286.613 136.863 286.535 137.021C286.458 137.182 286.378 137.339 286.296 137.496C286.097 137.876 285.889 138.252 285.668 138.622C285.595 138.747 285.521 138.868 285.445 138.991C285.281 139.16 285.114 139.327 284.944 139.49C284.605 139.817 284.254 140.131 283.892 140.429C283.865 140.451 283.838 140.473 283.81 140.493C284.47 140.37 285.149 140.294 285.821 140.205C285.932 140.098 286.04 139.986 286.145 139.872C286.218 139.656 286.289 139.438 286.358 139.22C286.411 139.055 286.462 138.89 286.514 138.722C286.65 138.274 286.784 137.824 286.913 137.371C286.996 137.084 287.079 136.797 287.168 136.51C287.215 136.349 287.264 136.189 287.316 136.028L287.316 136.026C287.336 135.963 287.356 135.901 287.375 135.838C287.436 135.779 287.496 135.72 287.556 135.658C287.698 135.516 287.835 135.368 287.97 135.216C287.908 135.462 287.851 135.71 287.795 135.958C287.791 135.976 287.787 135.993 287.785 136.012L287.769 136.076C287.773 136.069 287.778 136.062 287.781 136.052C287.795 136.026 287.806 135.998 287.82 135.971C287.848 135.907 287.879 135.842 287.908 135.778C287.943 135.702 287.976 135.625 288.007 135.547C288.037 135.48 288.065 135.411 288.092 135.343C288.107 135.306 288.122 135.269 288.137 135.234C288.184 135.115 288.23 134.995 288.274 134.875C288.28 134.864 288.283 134.855 288.287 134.844C288.287 134.842 288.291 134.839 288.291 134.837C288.293 134.833 288.292 134.829 288.293 134.827C288.374 134.609 288.45 134.391 288.524 134.17C288.566 134.052 288.605 133.931 288.645 133.812L288.644 133.812ZM282.239 141.657C282.091 141.757 281.94 141.852 281.789 141.947C281.619 142.055 281.446 142.161 281.271 142.262C281.189 142.31 281.107 142.357 281.026 142.405C281.026 142.405 281.025 142.406 281.022 142.408C280.918 142.467 280.813 142.525 280.709 142.584C280.615 142.635 280.519 142.686 280.426 142.738C280.332 142.79 280.237 142.841 280.141 142.892C280.024 142.955 279.906 143.017 279.785 143.075C279.761 143.088 279.735 143.103 279.71 143.115C279.684 143.127 279.658 143.141 279.633 143.154C279.594 143.176 279.553 143.195 279.508 143.216C279.506 143.217 279.503 143.218 279.503 143.22C279.49 143.226 279.477 143.234 279.462 143.24C279.385 143.279 279.309 143.317 279.231 143.353C279.228 143.355 279.228 143.357 279.225 143.358C279.157 143.391 279.086 143.425 279.015 143.458C278.659 143.629 278.298 143.795 277.937 143.956C277.765 144.033 277.592 144.108 277.42 144.183L277.415 144.186C277.256 144.255 277.095 144.325 276.936 144.394C277.284 144.149 277.623 143.889 277.952 143.615C278.076 143.513 278.197 143.408 278.318 143.3C278.354 143.27 278.387 143.24 278.421 143.209C278.44 143.191 278.461 143.173 278.481 143.152C278.52 143.119 278.555 143.085 278.59 143.051L278.595 143.048C278.61 143.035 278.624 143.02 278.639 143.007C278.728 142.926 278.816 142.842 278.901 142.756C279.037 142.624 279.168 142.491 279.297 142.352C279.314 142.335 279.331 142.318 279.348 142.298C279.414 142.23 279.479 142.158 279.541 142.087C279.553 142.077 279.564 142.064 279.574 142.053C279.588 142.038 279.599 142.025 279.612 142.011L279.613 142.009C279.74 141.868 279.863 141.725 279.985 141.58L279.986 141.578C279.995 141.571 280.002 141.561 280.009 141.552C280.071 141.477 280.133 141.401 280.196 141.325C280.23 141.281 280.264 141.238 280.297 141.195C280.298 141.193 280.301 141.192 280.301 141.19C280.354 141.122 280.408 141.054 280.459 140.984C280.835 140.491 281.184 139.976 281.514 139.454C281.911 138.804 282.283 138.143 282.633 137.475C282.972 136.799 283.311 136.126 283.62 135.441C283.745 135.173 283.867 134.904 283.99 134.635C284.107 134.378 284.222 134.123 284.335 133.865C284.342 133.853 284.347 133.838 284.353 133.825L284.355 133.82C284.361 133.809 284.366 133.794 284.372 133.783L284.373 133.779C284.493 133.507 284.612 133.232 284.727 132.959C284.844 132.683 284.956 132.408 285.069 132.131C285.083 132.096 285.098 132.059 285.113 132.024L285.115 132.017C285.179 131.858 285.243 131.697 285.303 131.536C285.335 131.455 285.367 131.375 285.398 131.293C285.327 131.4 285.259 131.506 285.19 131.613L285.189 131.615C285.171 131.642 285.154 131.668 285.138 131.696C285.018 131.878 284.902 132.061 284.787 132.246C284.773 132.267 284.759 132.29 284.746 132.31L284.745 132.312C284.739 132.323 284.732 132.333 284.726 132.343C284.652 132.459 284.58 132.575 284.51 132.692L284.509 132.694C284.495 132.716 284.481 132.739 284.467 132.761C284.374 132.914 284.281 133.065 284.19 133.219C283.805 133.861 283.432 134.507 283.067 135.157C282.692 135.808 282.344 136.472 281.969 137.115C281.787 137.439 281.604 137.763 281.416 138.085C281.229 138.404 281.037 138.72 280.839 139.033C280.782 139.125 280.724 139.217 280.667 139.308C280.615 139.393 280.561 139.476 280.506 139.56C280.502 139.567 280.497 139.574 280.493 139.58C280.489 139.585 280.487 139.591 280.483 139.596C280.299 139.877 280.112 140.156 279.918 140.43L279.917 140.434C279.911 140.44 279.906 140.447 279.902 140.454C279.823 140.566 279.742 140.676 279.66 140.787C279.563 140.92 279.465 141.05 279.366 141.178C279.344 141.204 279.324 141.231 279.302 141.259C279.233 141.349 279.161 141.44 279.088 141.528C278.804 141.887 278.507 142.234 278.197 142.573C278.18 142.593 278.16 142.613 278.143 142.633L278.14 142.634C278.039 142.744 277.936 142.853 277.832 142.963C277.789 143.009 277.743 143.056 277.698 143.102C277.619 143.182 277.541 143.262 277.461 143.342C277.229 143.573 276.992 143.801 276.75 144.024C276.633 144.131 276.516 144.238 276.398 144.342C276.382 144.356 276.365 144.371 276.349 144.384C276.293 144.437 276.233 144.488 276.174 144.538C276.041 144.655 275.906 144.77 275.769 144.885C275.752 144.892 275.737 144.899 275.72 144.906C275.71 144.911 275.698 144.913 275.688 144.918C275.64 145.028 275.591 145.137 275.544 145.249C275.517 145.307 275.491 145.365 275.466 145.424C275.437 145.49 275.41 145.557 275.38 145.624C275.39 145.621 275.397 145.618 275.407 145.615C275.904 145.444 276.401 145.267 276.901 145.084C277.113 145.006 277.326 144.926 277.538 144.843C277.559 144.838 277.579 144.828 277.601 144.821C277.601 144.821 277.601 144.819 277.603 144.82C277.725 144.717 277.847 144.614 277.968 144.508C278.28 144.24 278.586 143.964 278.885 143.68C278.978 143.638 279.071 143.593 279.165 143.547L279.167 143.546C279.26 143.503 279.352 143.456 279.442 143.41C279.658 143.304 279.871 143.194 280.081 143.082C280.29 142.971 280.497 142.858 280.701 142.743C280.358 143.102 280.004 143.453 279.643 143.797C279.731 143.756 279.819 143.715 279.907 143.674C280.12 143.575 280.333 143.472 280.544 143.368C280.742 143.27 280.939 143.169 281.134 143.063C281.104 143.076 281.072 143.088 281.043 143.101C281.472 142.622 281.887 142.13 282.285 141.626C282.269 141.637 282.255 141.647 282.239 141.656L282.239 141.657ZM303.613 133.556C303.645 133.452 303.675 133.348 303.704 133.245C303.706 133.233 303.711 133.22 303.715 133.208C303.73 133.151 303.744 133.092 303.759 133.036C303.785 132.938 303.809 132.839 303.832 132.742C304.061 131.803 304.269 130.862 304.421 129.902C304.374 130.008 304.328 130.114 304.285 130.222C304.173 130.488 304.064 130.756 303.961 131.023C303.857 131.292 303.757 131.561 303.659 131.831C303.566 132.089 303.473 132.35 303.385 132.61C303.304 132.836 303.226 133.062 303.147 133.285C303.106 133.395 303.065 133.507 303.023 133.617C302.981 133.727 302.937 133.834 302.889 133.941C302.88 133.961 302.871 133.981 302.862 134.001C302.853 134.022 302.845 134.04 302.836 134.06C302.8 134.14 302.763 134.22 302.726 134.297C302.668 134.416 302.61 134.533 302.549 134.649C302.508 134.725 302.467 134.802 302.424 134.877C302.366 134.977 302.306 135.076 302.245 135.175C302.007 135.575 301.724 135.946 301.425 136.304C301.131 136.667 300.796 136.996 300.448 137.311C300.427 137.331 300.405 137.351 300.382 137.368C300.382 137.368 300.382 137.37 300.38 137.369L300.379 137.371C300.114 137.606 299.834 137.827 299.541 138.033C299.535 138.037 299.527 138.043 299.521 138.047C299.451 138.097 299.382 138.144 299.311 138.191C299.294 138.204 299.275 138.217 299.256 138.229C299.294 138.154 299.334 138.077 299.37 138.001C299.42 137.901 299.471 137.802 299.519 137.701C299.526 137.687 299.532 137.674 299.539 137.66C299.642 137.449 299.743 137.236 299.841 137.021C299.886 136.921 299.931 136.823 299.976 136.723C299.979 136.713 299.984 136.706 299.987 136.697L299.989 136.691C300.231 136.152 300.455 135.604 300.662 135.048C300.722 134.89 300.781 134.731 300.834 134.571C300.888 134.421 300.939 134.27 300.989 134.119C301.031 133.998 301.068 133.877 301.106 133.755C301.127 133.695 301.146 133.634 301.165 133.573L301.166 133.571C301.188 133.507 301.207 133.442 301.227 133.377C301.234 133.35 301.243 133.326 301.25 133.299C301.284 133.189 301.315 133.08 301.346 132.968C301.383 132.837 301.419 132.707 301.454 132.578C301.483 132.474 301.509 132.37 301.537 132.264C301.579 132.095 301.621 131.924 301.661 131.755C301.693 131.614 301.725 131.474 301.755 131.332C301.758 131.317 301.762 131.299 301.766 131.283C301.776 131.234 301.787 131.185 301.798 131.136C301.866 131.031 301.932 130.926 301.996 130.82C302.035 130.755 302.072 130.69 302.11 130.625C302.258 130.367 302.398 130.104 302.527 129.835C302.581 129.721 302.633 129.609 302.685 129.496C302.735 129.381 302.785 129.268 302.833 129.154C302.93 128.924 303.019 128.689 303.103 128.455C303.129 128.38 303.15 128.305 303.174 128.23L303.175 128.228C303.189 128.188 303.202 128.151 303.214 128.111C303.222 128.086 303.228 128.063 303.237 128.038C303.248 127.998 303.262 127.961 303.273 127.92C303.284 127.884 303.294 127.849 303.304 127.813C303.315 127.775 303.327 127.736 303.338 127.698C303.361 127.62 303.383 127.543 303.402 127.464C303.413 127.427 303.424 127.389 303.433 127.35C303.45 127.29 303.465 127.228 303.478 127.167C303.497 127.098 303.513 127.028 303.528 126.955C303.551 126.864 303.571 126.77 303.59 126.68C303.609 126.594 303.627 126.507 303.641 126.422C303.718 126.031 303.778 125.637 303.826 125.243C304.084 123.06 303.908 120.849 303.429 118.72C302.941 116.593 302.173 114.548 301.258 112.59C300.8 111.609 300.31 110.645 299.806 109.693C299.291 108.744 298.769 107.8 298.229 106.868C298.497 107.445 298.769 108.02 299.04 108.594C299.23 108.994 299.416 109.394 299.598 109.796C300.052 110.771 300.493 111.753 300.898 112.747C301.202 113.491 301.492 114.242 301.757 115C302.068 115.885 302.345 116.777 302.576 117.681C302.642 117.939 302.704 118.197 302.761 118.457C302.79 118.587 302.819 118.717 302.845 118.848C303.279 120.926 303.416 123.069 303.188 125.172C303.175 125.288 303.161 125.401 303.147 125.516C303.132 125.631 303.116 125.745 303.097 125.859C303.063 126.085 303.023 126.309 302.979 126.534L302.976 126.543C302.96 126.626 302.944 126.709 302.924 126.79C302.905 126.889 302.881 126.986 302.858 127.083C302.84 127.161 302.821 127.239 302.8 127.318C302.792 127.353 302.782 127.389 302.771 127.426C302.746 127.522 302.72 127.621 302.691 127.718C302.659 127.835 302.622 127.953 302.585 128.071L302.585 128.073C302.567 128.136 302.547 128.199 302.526 128.261L302.525 128.263C302.401 128.65 302.26 129.028 302.098 129.402C302.147 129.056 302.185 128.708 302.22 128.359C302.286 127.664 302.325 126.965 302.33 126.268C302.33 126.152 302.331 126.035 302.331 125.919C302.329 125.687 302.326 125.454 302.318 125.222C302.31 124.99 302.298 124.758 302.284 124.525C302.276 124.408 302.268 124.292 302.259 124.177C302.251 124.061 302.241 123.945 302.23 123.83C302.211 123.636 302.188 123.441 302.163 123.245C302.16 123.229 302.159 123.214 302.158 123.199C302.136 123.044 302.115 122.887 302.091 122.731C302.055 122.489 302.016 122.248 301.971 122.007C301.941 121.834 301.905 121.662 301.87 121.492C301.837 121.333 301.801 121.173 301.765 121.017C301.747 120.935 301.727 120.852 301.706 120.769C301.67 120.622 301.633 120.474 301.592 120.327C301.543 120.139 301.491 119.951 301.433 119.764C301.414 119.697 301.394 119.629 301.371 119.562C301.335 119.446 301.299 119.33 301.259 119.216C301.226 119.109 301.19 119.002 301.151 118.896C301.103 118.759 301.054 118.622 301.003 118.485C300.942 118.324 300.881 118.168 300.817 118.012C300.764 117.881 300.711 117.753 300.656 117.627C300.652 117.62 300.649 117.612 300.645 117.604C300.592 117.478 300.536 117.354 300.48 117.231C300.472 117.216 300.466 117.199 300.456 117.183C300.395 117.05 300.331 116.918 300.265 116.786C300.264 116.779 300.26 116.772 300.256 116.766C300.175 116.603 300.091 116.44 300.003 116.279C299.917 116.116 299.826 115.954 299.734 115.793C299.66 115.664 299.585 115.537 299.506 115.411C299.494 115.39 299.482 115.371 299.468 115.35C299.446 115.312 299.421 115.274 299.396 115.236C299.315 115.105 299.231 114.977 299.145 114.848C299.344 115.191 299.532 115.538 299.707 115.889C299.741 115.956 299.772 116.022 299.804 116.09C299.836 116.155 299.867 116.223 299.898 116.291C299.942 116.378 299.981 116.467 300.02 116.554C300.084 116.691 300.143 116.827 300.2 116.964C300.203 116.968 300.204 116.972 300.206 116.977C300.359 117.342 300.501 117.711 300.631 118.085C300.761 118.456 300.881 118.833 300.989 119.214C301.418 120.734 301.661 122.299 301.74 123.868C301.755 124.134 301.766 124.401 301.77 124.668C301.774 124.935 301.775 125.201 301.771 125.467C301.77 125.572 301.766 125.674 301.765 125.776C301.761 125.939 301.755 126.103 301.746 126.267C301.734 126.532 301.716 126.798 301.693 127.063C301.688 127.135 301.682 127.207 301.674 127.276C301.666 127.387 301.655 127.495 301.643 127.604C301.63 127.739 301.613 127.872 301.599 128.006C301.597 128.016 301.596 128.026 301.594 128.036C301.58 128.155 301.564 128.276 301.548 128.395C301.533 128.486 301.52 128.579 301.508 128.669C301.497 128.75 301.484 128.829 301.47 128.911C301.43 129.154 301.389 129.394 301.342 129.633C301.312 129.785 301.282 129.938 301.251 130.09C301.242 130.133 301.232 130.174 301.224 130.217C301.144 130.592 301.055 130.965 300.954 131.335C300.919 131.479 300.88 131.623 300.837 131.764C300.816 131.843 300.793 131.922 300.77 132C300.765 132.027 300.755 132.054 300.746 132.08L300.746 132.082C300.719 132.176 300.689 132.269 300.659 132.363C300.64 132.429 300.618 132.493 300.597 132.559C300.539 132.745 300.477 132.93 300.413 133.115C300.296 133.451 300.175 133.784 300.045 134.114C300 134.233 299.952 134.351 299.904 134.467C299.86 134.576 299.816 134.685 299.77 134.791L299.768 134.797C299.753 134.836 299.735 134.874 299.72 134.913C299.71 134.935 299.7 134.957 299.69 134.979C299.57 135.266 299.444 135.549 299.315 135.83C299.243 135.982 299.172 136.132 299.101 136.285C299.031 136.429 298.961 136.571 298.89 136.715C298.823 136.848 298.756 136.98 298.689 137.113C298.686 137.116 298.684 137.12 298.683 137.123C298.617 137.252 298.55 137.38 298.482 137.509C298.483 137.507 298.483 137.505 298.482 137.502C298.508 137.343 298.532 137.183 298.553 137.024C298.615 136.542 298.66 136.06 298.743 135.577C298.887 134.677 299.069 133.784 299.257 132.887C299.397 132.228 299.54 131.567 299.676 130.903C299.71 130.733 299.744 130.566 299.775 130.398C299.783 130.363 299.791 130.329 299.797 130.293C299.813 130.204 299.832 130.114 299.848 130.023C299.851 130.009 299.854 129.993 299.857 129.98C299.87 129.904 299.885 129.827 299.899 129.75C299.902 129.734 299.905 129.72 299.906 129.704C299.965 129.383 300.019 129.063 300.068 128.739C300.084 128.639 300.1 128.537 300.114 128.437C300.117 128.416 300.119 128.398 300.121 128.378C300.147 128.214 300.168 128.049 300.19 127.884C300.209 127.736 300.226 127.589 300.241 127.442C300.254 127.322 300.264 127.202 300.275 127.079C300.285 126.958 300.293 126.837 300.301 126.718C300.309 126.596 300.316 126.474 300.322 126.354C300.335 126.098 300.342 125.839 300.341 125.582C300.343 125.528 300.342 125.475 300.342 125.42C300.342 125.384 300.343 125.346 300.339 125.307C300.34 125.276 300.34 125.246 300.338 125.214C300.339 125.187 300.339 125.157 300.336 125.129C300.335 125.04 300.332 124.952 300.327 124.863C300.326 124.78 300.321 124.696 300.315 124.612C300.313 124.54 300.308 124.468 300.303 124.397C300.302 124.388 300.302 124.382 300.301 124.373C300.294 124.265 300.284 124.159 300.273 124.052C300.265 123.954 300.255 123.856 300.244 123.76C300.242 123.751 300.241 123.744 300.239 123.735C300.233 123.668 300.226 123.598 300.216 123.529C300.213 123.496 300.207 123.463 300.202 123.431C300.174 123.223 300.139 123.016 300.1 122.808C300.087 122.736 300.072 122.663 300.057 122.591C300.044 122.519 300.029 122.446 300.012 122.375C299.974 122.21 299.934 122.045 299.892 121.883C299.648 120.983 299.301 120.106 298.82 119.306C298.77 119.225 298.718 119.144 298.666 119.067C298.638 119.023 298.612 118.983 298.583 118.945C298.533 118.871 298.482 118.799 298.429 118.727C298.362 118.635 298.293 118.543 298.221 118.455C298.219 118.454 298.22 118.452 298.218 118.452C298.154 118.373 298.089 118.293 298.023 118.218C297.799 117.961 297.557 117.721 297.299 117.501C297.273 117.477 297.245 117.455 297.217 117.432C297.184 117.404 297.153 117.379 297.118 117.352C297.072 117.315 297.025 117.28 296.978 117.244C297.045 117.308 297.113 117.373 297.177 117.438C297.208 117.469 297.238 117.499 297.267 117.53C297.276 117.54 297.287 117.55 297.296 117.561C297.321 117.587 297.344 117.612 297.367 117.636C297.437 117.709 297.505 117.785 297.569 117.862C297.59 117.886 297.611 117.911 297.632 117.935C297.665 117.974 297.697 118.014 297.728 118.053C297.832 118.184 297.933 118.318 298.029 118.454C298.074 118.514 298.117 118.577 298.158 118.642C298.161 118.641 298.161 118.645 298.161 118.645C298.209 118.719 298.258 118.792 298.303 118.869C298.355 118.95 298.403 119.035 298.451 119.121C298.453 119.121 298.454 119.124 298.455 119.126C298.51 119.224 298.564 119.324 298.613 119.423C299.032 120.226 299.321 121.093 299.506 121.976C299.871 123.747 299.878 125.58 299.648 127.373C299.419 129.174 299.001 130.958 298.671 132.771C298.502 133.678 298.354 134.591 298.257 135.513C298.24 135.708 298.219 135.903 298.202 136.099C298.2 136.111 298.2 136.122 298.199 136.132C298.189 136.232 298.181 136.33 298.175 136.431C298.162 136.584 298.155 136.738 298.152 136.892C298.151 136.945 298.15 136.995 298.149 137.045C298.149 137.083 298.149 137.119 298.151 137.156C298.151 137.192 298.152 137.228 298.154 137.264C298.157 137.381 298.166 137.496 298.177 137.611C298.183 137.66 298.189 137.708 298.196 137.755C298.202 137.805 298.212 137.855 298.22 137.905C298.223 137.927 298.227 137.947 298.232 137.97C298.208 138.012 298.186 138.053 298.161 138.095C297.904 138.555 297.635 139.008 297.356 139.456C297.29 139.562 297.224 139.667 297.156 139.772C297.07 139.911 296.981 140.046 296.891 140.182C296.713 140.454 296.529 140.724 296.343 140.992C296.25 141.126 296.155 141.26 296.061 141.391C295.948 141.548 295.835 141.703 295.721 141.857C295.608 142.012 295.492 142.163 295.376 142.317C295.367 142.328 295.357 142.34 295.349 142.351C295.377 142.277 295.407 142.201 295.435 142.127C295.505 141.944 295.574 141.764 295.643 141.582C295.754 141.294 295.859 141.003 295.961 140.714C296.066 140.424 296.166 140.135 296.273 139.845L296.872 138.099C296.896 138.024 296.921 137.951 296.945 137.877C296.955 137.849 296.962 137.82 296.972 137.792C297.017 137.65 297.063 137.506 297.104 137.358C297.116 137.315 297.129 137.273 297.139 137.231C297.168 137.131 297.193 137.028 297.215 136.927C297.226 136.884 297.235 136.84 297.245 136.798C297.255 136.746 297.265 136.693 297.274 136.641C297.286 136.578 297.297 136.514 297.305 136.449C297.315 136.383 297.324 136.317 297.33 136.249C297.365 135.864 297.351 135.48 297.309 135.107C297.287 134.892 297.253 134.679 297.215 134.469C297.208 134.429 297.199 134.388 297.192 134.348C297.176 134.266 297.16 134.185 297.143 134.103C297.142 134.101 297.141 134.098 297.14 134.094C297.139 134.093 297.139 134.091 297.139 134.091L297.141 134.087C297.136 134.058 297.129 134.031 297.121 134.003C297.114 133.975 297.109 133.948 297.103 133.921C297.091 133.87 297.081 133.82 297.069 133.77C297.068 133.763 297.067 133.758 297.065 133.751C296.978 133.346 296.885 132.946 296.821 132.542C296.709 131.943 296.689 131.331 296.799 130.721C296.776 130.782 296.756 130.845 296.74 130.911L296.733 130.932C296.726 130.951 296.72 130.967 296.716 130.987C296.714 130.993 296.711 131 296.711 131.006C296.71 131.01 296.708 131.016 296.708 131.02C296.691 131.088 296.673 131.158 296.66 131.227C296.646 131.296 296.634 131.368 296.623 131.437C296.622 131.446 296.619 131.453 296.62 131.462C296.61 131.53 296.602 131.601 296.595 131.67C296.587 131.746 296.581 131.819 296.578 131.894C296.57 132.045 296.569 132.194 296.571 132.345C296.573 132.419 296.577 132.494 296.58 132.569C296.616 133.193 296.718 133.807 296.788 134.41C296.792 134.443 296.795 134.476 296.798 134.509C296.799 134.513 296.799 134.52 296.799 134.524C296.801 134.537 296.803 134.55 296.803 134.563C296.807 134.594 296.811 134.625 296.812 134.657C296.822 134.749 296.831 134.841 296.837 134.933C296.839 134.946 296.84 134.959 296.84 134.972L296.839 134.974C296.842 134.985 296.842 134.996 296.843 135.007C296.858 135.241 296.865 135.471 296.855 135.7L296.854 135.702C296.855 135.706 296.854 135.71 296.854 135.714C296.853 135.792 296.847 135.868 296.84 135.945C296.84 135.949 296.84 135.956 296.838 135.961C296.831 136.037 296.822 136.112 296.81 136.187C296.799 136.268 296.785 136.345 296.769 136.423C296.756 136.49 296.742 136.555 296.725 136.621C296.719 136.644 296.713 136.669 296.707 136.693C296.692 136.759 296.673 136.826 296.651 136.895C296.648 136.911 296.645 136.926 296.639 136.941C296.639 136.95 296.636 136.957 296.632 136.962C296.617 137.018 296.598 137.074 296.58 137.131C296.58 137.138 296.578 137.143 296.574 137.148L296.573 137.152C296.545 137.239 296.514 137.326 296.484 137.414L296.445 137.525C296.402 137.649 296.355 137.774 296.309 137.899L295.68 139.635C295.528 140.086 295.366 140.534 295.215 140.982C295.17 141.117 295.127 141.249 295.084 141.384C295.032 141.54 294.98 141.697 294.93 141.852C294.923 141.873 294.915 141.896 294.91 141.917C294.872 142.033 294.834 142.148 294.797 142.261C294.775 142.323 294.755 142.388 294.737 142.451C294.687 142.601 294.64 142.75 294.594 142.899C294.57 142.981 294.545 143.061 294.52 143.143L294.449 143.366L294.39 143.556C293.971 144.065 293.544 144.563 293.102 145.052C293.068 145.089 293.036 145.128 293 145.164C293.001 145.166 293.001 145.167 292.999 145.168C292.872 145.309 292.746 145.449 292.616 145.587C292.574 145.634 292.531 145.678 292.488 145.724C292.198 146.036 291.905 146.343 291.605 146.648C291.485 146.769 291.366 146.889 291.246 147.01C291.176 147.078 291.107 147.149 291.037 147.217C290.879 147.375 290.718 147.53 290.557 147.685C290.424 147.814 290.286 147.943 290.151 148.071C290.145 148.077 290.136 148.085 290.13 148.091C290.023 148.193 289.916 148.294 289.807 148.394C289.674 148.516 289.541 148.638 289.405 148.76C289.003 149.122 288.596 149.471 288.179 149.809C288.177 149.81 288.174 149.812 288.171 149.815C287.987 149.962 287.803 150.106 287.617 150.248C287.5 150.336 287.38 150.425 287.262 150.511C287.16 150.587 287.054 150.662 286.949 150.735C286.921 150.755 286.891 150.776 286.861 150.795C286.765 150.863 286.669 150.929 286.569 150.992C286.527 151.022 286.484 151.049 286.438 151.078C286.396 151.107 286.35 151.136 286.306 151.165C286.263 151.194 286.217 151.222 286.173 151.252C286.133 151.278 286.093 151.302 286.05 151.327C286.016 151.347 285.981 151.368 285.949 151.389C285.907 151.412 285.866 151.438 285.824 151.462C285.824 151.463 285.819 151.464 285.819 151.464C285.782 151.487 285.747 151.508 285.71 151.529C285.663 151.555 285.618 151.582 285.573 151.608C285.539 151.626 285.507 151.647 285.473 151.665C285.476 151.663 285.477 151.661 285.477 151.66C285.61 151.531 285.745 151.403 285.878 151.274C285.878 151.274 285.879 151.272 285.881 151.273C285.971 151.184 286.062 151.096 286.153 151.009C286.246 150.919 286.34 150.83 286.432 150.742C286.438 150.735 286.444 150.731 286.45 150.725C286.541 150.64 286.63 150.554 286.719 150.467C286.725 150.46 286.734 150.453 286.741 150.445C286.934 150.259 287.124 150.07 287.314 149.879C287.411 149.784 287.506 149.691 287.601 149.595C287.703 149.494 287.806 149.393 287.908 149.291C287.975 149.226 288.04 149.16 288.107 149.095L288.78 148.412L288.951 148.24L289.738 147.441C289.84 147.335 289.942 147.229 290.046 147.12C290.053 147.112 290.062 147.104 290.069 147.096C290.072 147.093 290.072 147.091 290.076 147.088C290.185 146.974 290.292 146.858 290.399 146.739C290.483 146.643 290.567 146.547 290.647 146.448C290.869 146.186 291.074 145.91 291.258 145.611C291.288 145.56 291.319 145.508 291.347 145.456C291.35 145.453 291.352 145.449 291.353 145.446C291.372 145.41 291.392 145.375 291.41 145.341C291.43 145.304 291.449 145.266 291.468 145.228C291.503 145.16 291.536 145.094 291.568 145.027C291.569 145.023 291.572 145.022 291.573 145.018C291.572 145.014 291.574 145.01 291.577 145.007C291.611 144.933 291.644 144.857 291.676 144.783C291.708 144.707 291.738 144.633 291.767 144.557C291.776 144.529 291.787 144.503 291.797 144.475C291.817 144.425 291.837 144.377 291.855 144.326C291.866 144.295 291.875 144.262 291.886 144.23L291.894 144.209C291.9 144.184 291.909 144.158 291.918 144.133L291.952 144.035C291.957 144.02 291.962 144.007 291.964 143.993C291.993 143.904 292.022 143.813 292.047 143.725C292.074 143.635 292.099 143.545 292.123 143.457C292.129 143.438 292.135 143.417 292.139 143.397C292.149 143.363 292.158 143.326 292.168 143.291L292.168 143.289C292.239 143.019 292.305 142.749 292.371 142.481C292.391 142.391 292.414 142.302 292.436 142.213C292.479 142.034 292.524 141.856 292.57 141.68C292.617 141.503 292.667 141.329 292.721 141.154C292.726 141.134 292.733 141.113 292.74 141.095C292.75 141.058 292.761 141.022 292.773 140.986C292.782 140.955 292.792 140.927 292.802 140.897C292.849 140.749 292.9 140.602 292.958 140.458C292.96 140.446 292.965 140.438 292.971 140.429C292.993 140.369 293.017 140.312 293.044 140.254C293.079 140.171 293.116 140.087 293.158 140.005C293.178 139.957 293.202 139.913 293.227 139.867C293.251 139.82 293.276 139.774 293.301 139.73C293.319 139.696 293.338 139.663 293.357 139.629C293.364 139.617 293.372 139.607 293.378 139.594L293.379 139.593C293.383 139.586 293.388 139.577 293.393 139.57L293.394 139.566C293.403 139.546 293.417 139.526 293.429 139.507C293.434 139.5 293.439 139.491 293.444 139.484C293.483 139.42 293.524 139.356 293.567 139.293C293.571 139.288 293.572 139.285 293.576 139.28L293.576 139.278C293.622 139.214 293.667 139.149 293.715 139.086C293.673 139.128 293.63 139.172 293.591 139.218C293.564 139.247 293.538 139.278 293.514 139.307C293.492 139.331 293.471 139.356 293.452 139.381C293.413 139.426 293.376 139.472 293.343 139.52C293.332 139.533 293.323 139.547 293.312 139.56C293.285 139.597 293.258 139.632 293.234 139.67C293.21 139.701 293.189 139.732 293.167 139.765C293.167 139.766 293.166 139.767 293.164 139.768C293.158 139.778 293.151 139.788 293.145 139.799C293.104 139.861 293.064 139.923 293.027 139.988C293.014 140.007 293.002 140.028 292.991 140.047C292.938 140.139 292.884 140.234 292.835 140.328C292.785 140.422 292.739 140.52 292.693 140.615C292.663 140.679 292.633 140.744 292.604 140.81C292.565 140.898 292.529 140.986 292.494 141.073C292.381 141.358 292.278 141.647 292.182 141.936C292.102 142.18 292.026 142.423 291.949 142.664C291.926 142.736 291.903 142.808 291.881 142.878C291.838 143.013 291.794 143.147 291.75 143.281C291.701 143.422 291.652 143.561 291.602 143.701L291.522 143.914C291.49 144 291.457 144.083 291.421 144.167C291.361 144.315 291.297 144.459 291.229 144.6C291.208 144.641 291.188 144.682 291.168 144.722C291.138 144.783 291.106 144.844 291.074 144.902C291.05 144.947 291.024 144.99 290.998 145.034C290.976 145.075 290.951 145.115 290.928 145.153C290.927 145.155 290.924 145.156 290.924 145.158C290.922 145.164 290.918 145.169 290.915 145.172C290.912 145.175 290.911 145.177 290.91 145.18C290.906 145.184 290.906 145.185 290.904 145.189C290.877 145.237 290.847 145.283 290.816 145.329C290.764 145.406 290.712 145.483 290.657 145.556C290.549 145.702 290.436 145.842 290.318 145.98C290.312 145.986 290.305 145.994 290.3 146.001C290.244 146.066 290.187 146.128 290.129 146.192C290.046 146.284 289.96 146.374 289.872 146.463L289.872 146.465C289.8 146.539 289.728 146.612 289.654 146.685C289.61 146.728 289.565 146.772 289.52 146.815C289.455 146.883 289.385 146.952 289.315 147.018L288.428 147.894L288.24 148.077C288.24 148.077 288.238 148.078 288.237 148.08L287.859 148.452L287.661 148.649C287.592 148.72 287.524 148.789 287.453 148.859C287.125 149.189 286.797 149.516 286.474 149.848L286.471 149.849C286.457 149.865 286.441 149.881 286.425 149.897C286.356 149.969 286.284 150.042 286.215 150.114C286.153 150.177 286.09 150.242 286.03 150.305C285.978 150.358 285.928 150.411 285.878 150.465C285.741 150.605 285.605 150.747 285.47 150.888C285.394 150.967 285.319 151.044 285.243 151.123C285.207 151.161 285.171 151.199 285.134 151.237C284.896 151.485 284.661 151.734 284.426 151.986L284.073 152.358C283.408 152.65 282.724 152.903 282.019 153.127C281.286 153.361 280.536 153.562 279.78 153.746C279.627 153.778 279.474 153.813 279.323 153.847C279.063 153.906 278.8 153.967 278.538 154.023C278.437 154.045 278.335 154.067 278.236 154.087C278.197 154.095 278.161 154.103 278.122 154.111C278.088 154.118 278.056 154.124 278.023 154.129C278 154.134 277.978 154.139 277.955 154.144C277.801 154.173 277.646 154.201 277.493 154.225C277.287 154.264 277.083 154.301 276.88 154.335C276.83 154.343 276.779 154.351 276.73 154.359C276.582 154.385 276.435 154.408 276.286 154.431C275.153 154.606 274.014 154.727 272.872 154.805C272.644 154.821 272.413 154.836 272.185 154.845C271.974 154.856 271.763 154.865 271.552 154.872C271.147 154.885 270.744 154.893 270.34 154.892C270.199 154.891 270.056 154.89 269.916 154.888C269.853 154.887 269.79 154.886 269.725 154.885C269.551 154.883 269.378 154.878 269.204 154.871C269.187 154.871 269.17 154.869 269.151 154.869C268.949 154.862 268.749 154.852 268.548 154.841C268.342 154.833 268.137 154.819 267.931 154.802C267.818 154.795 267.707 154.788 267.594 154.778L267.593 154.778C267.451 154.767 267.312 154.754 267.171 154.741C267.151 154.739 267.132 154.738 267.112 154.736C267.098 154.733 267.084 154.732 267.069 154.731C267.055 154.73 267.042 154.73 267.029 154.728C266.949 154.719 266.872 154.711 266.793 154.703C266.57 154.678 266.349 154.652 266.128 154.624C266.003 154.608 265.877 154.589 265.752 154.572C265.635 154.556 265.517 154.539 265.4 154.519C265.253 154.498 265.106 154.474 264.959 154.448C264.813 154.425 264.667 154.398 264.52 154.372C264.227 154.317 263.935 154.26 263.643 154.197C263.402 154.145 263.161 154.088 262.92 154.028C262.751 153.986 262.582 153.94 262.415 153.895C262.383 153.884 262.35 153.875 262.317 153.865C262.233 153.842 262.147 153.817 262.063 153.792C261.749 153.7 261.438 153.602 261.128 153.499L261.049 153.472C260.962 153.444 260.875 153.414 260.789 153.384C260.663 153.34 260.539 153.297 260.414 153.252C260.712 153.271 261.014 153.283 261.314 153.284L261.316 153.285C261.348 153.285 261.38 153.283 261.411 153.284C261.439 153.283 261.469 153.283 261.496 153.282C261.577 153.28 261.655 153.28 261.736 153.276C261.834 153.274 261.932 153.27 262.029 153.268C262.04 153.268 262.051 153.267 262.062 153.267C262.085 153.267 262.109 153.264 262.132 153.264C262.133 153.264 262.135 153.264 262.137 153.263C263.202 153.228 264.268 153.147 265.337 153.042C265.577 153.016 265.817 152.987 266.057 152.957C266.328 152.923 266.598 152.886 266.867 152.844L266.869 152.845C266.891 152.842 266.913 152.839 266.933 152.836C267.079 152.812 267.223 152.79 267.368 152.767C267.757 152.702 268.143 152.632 268.531 152.553C268.638 152.531 268.744 152.511 268.849 152.486C268.981 152.458 269.113 152.43 269.245 152.4C271.695 151.858 274.098 150.949 276.291 149.696C277.038 149.778 277.797 149.789 278.552 149.724C278.639 149.716 278.726 149.709 278.813 149.699C278.896 149.69 278.98 149.681 279.061 149.669C279.066 149.668 279.07 149.668 279.075 149.667C279.083 149.666 279.092 149.665 279.101 149.664C279.217 149.651 279.331 149.634 279.447 149.613C279.452 149.612 279.459 149.611 279.463 149.61C279.561 149.594 279.661 149.575 279.759 149.557C279.954 149.519 280.147 149.476 280.339 149.429C280.83 149.305 281.314 149.144 281.783 148.944C281.921 148.887 282.058 148.825 282.191 148.757C282.211 148.748 282.232 148.738 282.252 148.728C282.296 148.705 282.341 148.685 282.382 148.662C282.552 148.575 282.717 148.485 282.88 148.387C282.962 148.338 283.043 148.288 283.124 148.236C283.145 148.225 283.164 148.212 283.184 148.198C283.268 148.143 283.353 148.086 283.437 148.027C283.509 147.976 283.58 147.925 283.651 147.872C283.662 147.865 283.671 147.856 283.68 147.848C283.744 147.803 283.805 147.755 283.865 147.704C283.885 147.69 283.903 147.675 283.921 147.66C283.976 147.616 284.032 147.568 284.087 147.521C284.148 147.467 284.211 147.413 284.27 147.357C284.283 147.345 284.297 147.333 284.31 147.321C284.396 147.243 284.479 147.162 284.56 147.079C284.618 147.021 284.675 146.961 284.732 146.901C284.736 146.896 284.74 146.891 284.743 146.887C284.803 146.822 284.864 146.757 284.921 146.688C284.978 146.624 285.035 146.557 285.087 146.491C285.098 146.476 285.112 146.462 285.121 146.446C285.141 146.421 285.162 146.397 285.181 146.372C285.192 146.359 285.203 146.346 285.212 146.332C285.227 146.312 285.242 146.294 285.255 146.273C285.302 146.21 285.351 146.144 285.394 146.08C285.436 146.018 285.479 145.957 285.517 145.895C285.547 145.85 285.576 145.805 285.602 145.76C285.636 145.704 285.67 145.648 285.702 145.592C285.74 145.525 285.777 145.455 285.813 145.388C285.814 145.385 285.818 145.38 285.819 145.376C285.838 145.34 285.857 145.303 285.874 145.266C285.898 145.217 285.92 145.17 285.943 145.122C285.983 145.036 286.02 144.95 286.055 144.866C286.057 144.86 286.061 144.855 286.062 144.847C286.099 144.758 286.131 144.671 286.162 144.583C286.185 144.517 286.205 144.452 286.225 144.387C286.238 144.345 286.252 144.304 286.263 144.261C286.114 144.49 285.958 144.709 285.796 144.923C285.631 145.135 285.461 145.34 285.284 145.535C285.196 145.633 285.105 145.73 285.013 145.824C284.828 146.011 284.64 146.192 284.442 146.365C284.345 146.452 284.244 146.535 284.144 146.618C284.094 146.659 284.042 146.699 283.991 146.738C283.922 146.79 283.853 146.842 283.783 146.893C283.751 146.918 283.717 146.942 283.684 146.964L283.684 146.966C283.577 147.043 283.471 147.118 283.362 147.19C283.28 147.243 283.198 147.297 283.117 147.351C283.033 147.404 282.952 147.456 282.867 147.506C282.771 147.563 282.674 147.618 282.575 147.672C282.456 147.738 282.336 147.802 282.214 147.865C281.972 147.99 281.725 148.104 281.475 148.211C280.925 148.446 280.359 148.639 279.78 148.798C279.774 148.801 279.768 148.801 279.763 148.803C279.721 148.816 279.676 148.828 279.633 148.838C279.57 148.856 279.506 148.874 279.442 148.89C279.389 148.903 279.333 148.918 279.281 148.929C279.012 148.996 278.74 149.055 278.466 149.11C278.335 149.136 278.203 149.16 278.07 149.183C277.938 149.207 277.804 149.228 277.671 149.249C277.537 149.27 277.404 149.289 277.27 149.31C277.242 149.313 277.215 149.317 277.186 149.321C277.125 149.33 277.063 149.338 277.001 149.346C276.955 149.351 276.91 149.358 276.864 149.364C277.133 149.202 277.398 149.039 277.659 148.87C277.743 148.815 277.827 148.76 277.91 148.705C277.983 148.659 278.054 148.612 278.123 148.564C278.23 148.493 278.335 148.422 278.437 148.351C278.468 148.33 278.498 148.309 278.527 148.287C278.554 148.269 278.582 148.249 278.607 148.231C278.715 148.156 278.821 148.081 278.926 148.004C278.943 147.991 278.959 147.98 278.977 147.967L278.979 147.966C279.041 147.922 279.103 147.876 279.163 147.831C279.188 147.813 279.211 147.795 279.235 147.776C279.344 147.698 279.449 147.619 279.553 147.539C279.684 147.441 279.811 147.342 279.938 147.241C280.457 146.831 280.964 146.407 281.461 145.972L281.83 145.641L281.931 145.546L281.931 145.544L282.07 145.411L282.187 145.299L282.901 144.614C283.354 144.164 283.794 143.704 284.222 143.233C284.264 143.229 284.305 143.224 284.346 143.215C284.354 143.216 284.361 143.216 284.368 143.214C284.445 143.205 284.52 143.193 284.596 143.182C284.659 143.172 284.721 143.162 284.782 143.149C284.831 143.143 284.878 143.134 284.926 143.125C284.93 143.124 284.933 143.123 284.935 143.122C284.94 143.121 284.942 143.12 284.946 143.12C285.212 143.07 285.475 143.01 285.738 142.939C285.745 142.937 285.752 142.935 285.759 142.934C285.877 142.903 285.996 142.868 286.113 142.833C286.205 142.806 286.297 142.777 286.39 142.746C286.597 142.676 286.804 142.603 287.011 142.523C287.087 142.492 287.164 142.464 287.24 142.432C287.316 142.401 287.39 142.37 287.465 142.337C287.565 142.292 287.667 142.247 287.766 142.197L287.778 142.193L287.779 142.191C287.872 142.147 287.964 142.101 288.058 142.054C288.217 141.972 288.374 141.888 288.528 141.796C289.005 141.521 289.461 141.208 289.889 140.857C289.984 140.776 290.079 140.695 290.172 140.612C290.238 140.555 290.302 140.497 290.364 140.439C290.444 140.363 290.523 140.285 290.599 140.206C290.83 139.971 291.05 139.72 291.252 139.46C291.256 139.455 291.259 139.451 291.263 139.446C291.4 139.269 291.531 139.087 291.653 138.899C291.783 138.698 291.906 138.492 292.019 138.281C292.113 138.107 292.2 137.929 292.28 137.746C292.355 137.58 292.422 137.411 292.481 137.24C292.501 137.188 292.519 137.137 292.535 137.084L292.541 137.067C292.56 137.006 292.578 136.947 292.597 136.886C292.615 136.823 292.633 136.759 292.651 136.696C292.655 136.685 292.656 136.675 292.66 136.663C292.671 136.614 292.683 136.566 292.694 136.517C292.706 136.471 292.716 136.422 292.726 136.374C292.74 136.31 292.754 136.247 292.763 136.185C292.772 136.135 292.78 136.085 292.788 136.033C292.794 136.004 292.798 135.973 292.8 135.944C292.807 135.899 292.813 135.852 292.818 135.805C292.827 135.733 292.833 135.659 292.838 135.585C292.843 135.54 292.844 135.494 292.845 135.448C292.85 135.405 292.851 135.364 292.851 135.321C292.854 135.247 292.853 135.17 292.852 135.094C292.834 135.16 292.815 135.221 292.792 135.285C292.788 135.304 292.781 135.325 292.773 135.346L292.762 135.379C292.745 135.433 292.727 135.485 292.709 135.538L292.708 135.54C292.671 135.645 292.633 135.75 292.594 135.852C292.565 135.928 292.535 136.002 292.505 136.076C292.472 136.153 292.441 136.231 292.407 136.305C292.37 136.387 292.333 136.469 292.294 136.55C292.261 136.621 292.226 136.693 292.191 136.763C292.102 136.942 292.006 137.12 291.907 137.292C291.869 137.359 291.828 137.427 291.786 137.492C291.692 137.649 291.592 137.804 291.489 137.956C291.419 138.054 291.349 138.151 291.277 138.249C291.206 138.346 291.133 138.441 291.056 138.534C291.052 138.539 291.049 138.542 291.045 138.547L291.044 138.551C290.981 138.628 290.919 138.704 290.857 138.781C290.732 138.929 290.603 139.074 290.47 139.216C290.13 139.582 289.768 139.924 289.382 140.241C289.173 140.412 288.96 140.579 288.74 140.736C288.526 140.892 288.306 141.041 288.081 141.186C288.078 141.189 288.073 141.192 288.068 141.194L288.066 141.198C288.035 141.216 288.007 141.236 287.975 141.255C287.934 141.281 287.894 141.307 287.851 141.332C287.84 141.339 287.83 141.346 287.819 141.352C287.473 141.567 287.118 141.769 286.756 141.959C286.506 142.088 286.255 142.211 286.001 142.331C285.993 142.335 285.988 142.337 285.98 142.341C285.693 142.477 285.399 142.609 285.102 142.736C285.095 142.739 285.089 142.744 285.082 142.745C284.914 142.818 284.741 142.89 284.569 142.961C284.512 142.986 284.455 143.01 284.399 143.033C284.44 142.986 284.483 142.938 284.526 142.892C284.605 142.803 284.682 142.714 284.758 142.625C284.82 142.555 284.88 142.486 284.94 142.416C284.943 142.413 284.946 142.41 284.95 142.405C285.013 142.332 285.074 142.258 285.138 142.184C285.242 142.062 285.343 141.939 285.445 141.816L285.445 141.814C285.453 141.806 285.46 141.796 285.467 141.788C285.588 141.64 285.709 141.491 285.828 141.343C285.948 141.192 286.066 141.042 286.183 140.891C286.222 140.839 286.263 140.788 286.3 140.735C286.361 140.657 286.419 140.58 286.478 140.502C286.576 140.372 286.675 140.24 286.771 140.109C286.783 140.092 286.794 140.077 286.807 140.06C286.843 140.009 286.88 139.959 286.917 139.906C286.954 139.854 286.99 139.803 287.028 139.751C287.101 139.648 287.172 139.546 287.245 139.441C287.272 139.406 287.297 139.368 287.323 139.331C287.336 139.312 287.349 139.291 287.362 139.273C287.408 139.208 287.45 139.147 287.493 139.084C287.515 139.05 287.539 139.018 287.561 138.983C287.604 138.92 287.648 138.855 287.69 138.79C287.755 138.693 287.82 138.595 287.884 138.497C287.985 138.339 288.087 138.18 288.186 138.021C288.387 137.703 288.581 137.381 288.771 137.057C288.867 136.894 288.961 136.733 289.054 136.569C289.083 136.552 289.112 136.535 289.14 136.517C289.169 136.5 289.198 136.482 289.225 136.464L289.233 136.461C289.235 136.459 289.236 136.458 289.24 136.457L289.241 136.455C289.321 136.407 289.398 136.36 289.479 136.31C289.562 136.259 289.646 136.205 289.728 136.152C289.894 136.043 290.057 135.931 290.217 135.816C290.287 135.767 290.355 135.715 290.425 135.665C290.673 135.479 290.916 135.288 291.152 135.087C291.178 135.067 291.203 135.044 291.227 135.023C291.276 134.98 291.324 134.94 291.37 134.897C291.397 134.873 291.425 134.849 291.452 134.825C291.5 134.784 291.546 134.741 291.593 134.698C291.633 134.662 291.673 134.625 291.713 134.588C291.745 134.559 291.776 134.53 291.808 134.499C291.954 134.362 292.096 134.22 292.236 134.076C292.331 133.981 292.422 133.886 292.513 133.787C292.523 133.778 292.533 133.767 292.543 133.757C292.573 133.724 292.604 133.69 292.635 133.656C292.761 133.517 292.884 133.376 293.006 133.231C293.034 133.199 293.06 133.166 293.088 133.133L293.089 133.131C293.121 133.092 293.154 133.053 293.187 133.012C293.198 132.998 293.208 132.987 293.217 132.973C293.389 132.764 293.556 132.545 293.719 132.328C293.78 132.244 293.841 132.16 293.9 132.075C293.911 132.06 293.921 132.043 293.933 132.028L293.934 132.026C294.121 131.76 294.298 131.484 294.471 131.21C294.476 131.201 294.481 131.194 294.486 131.185C294.499 131.165 294.51 131.147 294.523 131.126L294.524 131.125C294.566 131.057 294.607 130.989 294.648 130.919C294.71 130.818 294.77 130.718 294.828 130.617C294.832 130.612 294.834 130.607 294.838 130.602C294.876 130.535 294.916 130.469 294.954 130.402C295.028 130.267 295.102 130.131 295.175 129.994C295.25 129.858 295.321 129.721 295.391 129.585C295.409 129.551 295.427 129.517 295.445 129.483C295.496 129.385 295.546 129.285 295.595 129.186C295.617 129.139 295.642 129.092 295.664 129.045C295.735 128.901 295.805 128.755 295.874 128.611C295.876 128.605 295.881 128.598 295.883 128.592C295.903 128.551 295.925 128.508 295.943 128.466L295.944 128.464C295.96 128.436 295.973 128.405 295.987 128.376C296.089 128.15 296.189 127.928 296.288 127.703C296.339 127.588 296.39 127.471 296.44 127.356C296.467 127.295 296.493 127.233 296.521 127.173C296.548 127.113 296.574 127.05 296.599 126.989C296.651 126.868 296.702 126.747 296.753 126.623L296.754 126.622C296.799 126.515 296.843 126.408 296.886 126.301C296.928 126.198 296.97 126.096 297.012 125.993C297.053 125.893 297.094 125.792 297.136 125.691C297.136 125.691 297.138 125.689 297.137 125.687C297.154 125.651 297.167 125.613 297.182 125.574C297.203 125.522 297.224 125.472 297.244 125.42C297.321 125.23 297.397 125.042 297.471 124.85C297.545 124.663 297.618 124.476 297.69 124.288C297.944 123.628 298.185 122.962 298.412 122.289C298.436 122.219 298.459 122.149 298.483 122.08C298.194 122.561 297.915 123.048 297.645 123.535C297.57 123.667 297.496 123.802 297.425 123.935L297.423 123.939C297.407 123.967 297.392 123.997 297.376 124.026C297.37 124.036 297.365 124.045 297.359 124.056C297.287 124.191 297.215 124.326 297.143 124.461C297.04 124.655 296.937 124.848 296.835 125.045L296.834 125.047C296.831 125.05 296.829 125.056 296.825 125.061L296.825 125.063C296.811 125.091 296.794 125.121 296.78 125.15C296.773 125.163 296.766 125.177 296.759 125.191C296.74 125.227 296.722 125.263 296.703 125.299C296.68 125.339 296.659 125.382 296.638 125.424C296.56 125.576 296.483 125.726 296.407 125.878L296.406 125.88C296.384 125.921 296.363 125.962 296.342 126.004C296.336 126.016 296.329 126.031 296.322 126.043C296.23 126.22 296.14 126.399 296.049 126.576C295.982 126.713 295.915 126.848 295.849 126.983C295.767 127.146 295.685 127.309 295.601 127.472C295.561 127.553 295.52 127.634 295.479 127.714C295.47 127.734 295.46 127.751 295.449 127.771C295.405 127.863 295.356 127.956 295.309 128.047C295.269 128.127 295.229 128.206 295.187 128.284C295.149 128.364 295.109 128.443 295.067 128.52C295.055 128.542 295.046 128.562 295.035 128.581C294.999 128.649 294.964 128.719 294.928 128.786C294.894 128.856 294.857 128.926 294.82 128.995C294.8 129.034 294.778 129.075 294.756 129.114C294.699 129.223 294.641 129.33 294.581 129.441L294.581 129.442C294.559 129.479 294.539 129.514 294.519 129.552C294.434 129.706 294.35 129.858 294.261 130.01C294.246 130.036 294.233 130.062 294.218 130.088L294.217 130.09C294.216 130.092 294.216 130.093 294.213 130.095C294.197 130.123 294.183 130.152 294.166 130.177C294.128 130.242 294.092 130.31 294.055 130.375C293.894 130.658 293.725 130.936 293.55 131.211L293.549 131.214C293.535 131.235 293.522 131.256 293.508 131.276C293.452 131.364 293.397 131.452 293.341 131.54C293.227 131.716 293.111 131.888 292.992 132.06C292.958 132.109 292.923 132.16 292.888 132.209C292.863 132.245 292.838 132.28 292.813 132.316C292.672 132.513 292.528 132.71 292.379 132.903C292.352 132.939 292.322 132.976 292.295 133.012C292.145 133.209 291.99 133.404 291.832 133.595C291.813 133.618 291.795 133.639 291.777 133.662C291.705 133.747 291.633 133.834 291.558 133.917C291.486 134.002 291.412 134.088 291.335 134.17C291.313 134.198 291.286 134.227 291.262 134.255C291.231 134.288 291.2 134.324 291.169 134.357L291.168 134.359C291.148 134.382 291.125 134.405 291.104 134.428C290.832 134.727 290.55 135.019 290.261 135.306C290.243 135.321 290.227 135.336 290.213 135.353C290.066 135.496 289.917 135.64 289.765 135.781C289.614 135.925 289.46 136.067 289.302 136.208L289.301 136.21C289.295 136.214 289.289 136.22 289.283 136.225L289.282 136.227C289.258 136.248 289.233 136.271 289.209 136.292C289.242 136.234 289.272 136.177 289.303 136.118C289.314 136.098 289.326 136.077 289.337 136.058L289.338 136.054C289.355 136.022 289.372 135.992 289.39 135.96C289.477 135.799 289.565 135.636 289.652 135.472C289.737 135.311 289.822 135.152 289.903 134.99C289.969 134.859 290.036 134.727 290.102 134.594C290.42 133.956 290.717 133.311 290.996 132.659C291.158 132.277 291.315 131.891 291.464 131.504C291.591 131.176 291.715 130.846 291.831 130.513C291.852 130.457 291.873 130.399 291.892 130.343L291.954 130.164C292.006 130.015 292.058 129.865 292.106 129.713C292.136 129.627 292.166 129.54 292.194 129.453C292.213 129.388 292.232 129.327 292.254 129.263L292.26 129.244C292.267 129.225 292.272 129.206 292.278 129.187C292.286 129.164 292.291 129.143 292.299 129.121C292.323 129.04 292.349 128.959 292.373 128.877C292.393 128.812 292.412 128.747 292.432 128.682C292.443 128.644 292.454 128.606 292.466 128.567C292.502 128.443 292.538 128.321 292.573 128.196C292.621 128.034 292.665 127.872 292.709 127.708C292.745 127.573 292.781 127.438 292.815 127.305C292.846 127.185 292.877 127.065 292.906 126.945C292.941 126.809 292.972 126.675 293.004 126.541C293.017 126.492 293.027 126.443 293.037 126.396C293.065 126.279 293.092 126.165 293.118 126.049C293.167 125.822 293.216 125.596 293.261 125.368C293.28 125.271 293.301 125.175 293.317 125.078C293.323 125.049 293.329 125.019 293.335 124.99C293.35 124.91 293.365 124.831 293.38 124.752L293.38 124.75C293.397 124.666 293.412 124.58 293.427 124.495C293.427 124.487 293.43 124.479 293.431 124.471C293.445 124.394 293.459 124.317 293.471 124.239C293.488 124.143 293.503 124.05 293.519 123.955C293.546 123.787 293.571 123.617 293.594 123.448C293.618 123.281 293.64 123.114 293.661 122.944L293.663 122.939C293.683 122.789 293.702 122.638 293.719 122.486C293.722 122.458 293.726 122.428 293.729 122.397C293.744 122.267 293.758 122.135 293.772 122.005C293.774 121.979 293.777 121.952 293.78 121.926C293.782 121.916 293.782 121.908 293.784 121.898C293.796 121.79 293.805 121.684 293.815 121.576C293.816 121.575 293.815 121.573 293.815 121.571L293.817 121.57L293.816 121.568C293.816 121.566 293.817 121.564 293.816 121.561C293.828 121.448 293.837 121.335 293.846 121.22C293.851 121.163 293.855 121.107 293.86 121.05C293.865 121.001 293.869 120.952 293.871 120.904C293.875 120.861 293.879 120.82 293.881 120.777C293.886 120.732 293.889 120.687 293.891 120.641C293.895 120.579 293.9 120.516 293.901 120.453C293.911 120.34 293.918 120.227 293.923 120.115C293.933 119.954 293.94 119.795 293.945 119.632C293.947 119.608 293.948 119.582 293.949 119.555C293.955 119.387 293.96 119.218 293.964 119.051C293.971 118.78 293.974 118.509 293.974 118.237C293.974 118.214 293.974 118.189 293.974 118.165C294.042 118.029 294.111 117.891 294.176 117.751C294.234 117.632 294.289 117.512 294.342 117.39C294.373 117.318 294.404 117.247 294.434 117.173L294.436 117.167C294.459 117.112 294.481 117.055 294.505 117C294.528 116.944 294.549 116.889 294.571 116.833L294.579 116.81C294.589 116.786 294.597 116.762 294.606 116.737C294.672 116.564 294.733 116.39 294.79 116.213L294.795 116.198C294.8 116.183 294.806 116.166 294.809 116.151C294.822 116.109 294.837 116.065 294.849 116.023C294.857 115.994 294.867 115.966 294.875 115.937C294.895 115.866 294.916 115.795 294.932 115.724C294.943 115.685 294.955 115.647 294.963 115.61C294.98 115.544 294.996 115.478 295.009 115.411C295.023 115.359 295.035 115.306 295.045 115.253C295.068 115.151 295.086 115.05 295.104 114.949C295.112 114.914 295.119 114.876 295.125 114.84C295.128 114.82 295.132 114.8 295.135 114.78C295.136 114.772 295.136 114.764 295.137 114.756C295.143 114.726 295.147 114.696 295.152 114.666C295.156 114.64 295.158 114.616 295.162 114.592C295.177 114.508 295.187 114.425 295.197 114.34C295.201 114.317 295.205 114.293 295.207 114.268C295.216 114.187 295.226 114.104 295.233 114.023C295.243 113.935 295.251 113.85 295.258 113.762C295.265 113.676 295.272 113.589 295.277 113.503C295.288 113.33 295.295 113.158 295.3 112.985C295.333 111.907 295.292 110.842 295.32 109.781C295.326 109.516 295.337 109.252 295.354 108.987C295.36 108.896 295.365 108.803 295.375 108.712C295.379 108.64 295.385 108.568 295.395 108.497C295.402 108.397 295.414 108.295 295.428 108.195C295.5 107.67 295.609 107.15 295.763 106.639C295.713 106.759 295.666 106.881 295.622 107.003L295.518 107.302C295.506 107.344 295.493 107.386 295.478 107.429C295.476 107.441 295.471 107.452 295.468 107.464C295.463 107.481 295.458 107.5 295.452 107.517C295.448 107.53 295.444 107.542 295.441 107.556C295.414 107.645 295.389 107.736 295.365 107.828L295.364 107.832C295.334 107.944 295.307 108.056 295.283 108.17C295.17 108.696 295.096 109.23 295.039 109.764C294.94 110.834 294.913 111.902 294.811 112.954C294.8 113.064 294.79 113.174 294.777 113.283C294.768 113.358 294.759 113.433 294.748 113.507C294.747 113.511 294.747 113.515 294.746 113.519C294.737 113.6 294.726 113.68 294.715 113.761C294.701 113.855 294.687 113.951 294.671 114.044C294.652 114.168 294.629 114.293 294.606 114.415L294.605 114.419C294.578 114.564 294.546 114.709 294.511 114.852C294.476 114.996 294.439 115.139 294.399 115.281C294.398 115.289 294.396 115.295 294.393 115.302C294.381 115.344 294.368 115.386 294.354 115.428C294.323 115.529 294.293 115.628 294.259 115.725C294.228 115.814 294.198 115.902 294.163 115.989L294.161 115.997C294.139 116.052 294.12 116.109 294.096 116.164C294.091 116.179 294.084 116.193 294.079 116.209C294.074 116.222 294.068 116.234 294.064 116.245C294.059 116.259 294.054 116.274 294.048 116.286C294.009 116.385 293.968 116.48 293.927 116.575C293.921 116.487 293.919 116.397 293.913 116.309C293.911 116.266 293.909 116.223 293.907 116.182C293.905 116.218 293.906 116.252 293.904 116.287C293.903 116.289 293.904 116.293 293.903 116.295C293.902 116.347 293.901 116.4 293.899 116.454C293.898 116.498 293.897 116.544 293.897 116.588L293.895 116.613C293.894 116.625 293.894 116.64 293.893 116.652C293.884 116.674 293.875 116.694 293.865 116.716C293.856 116.736 293.846 116.758 293.837 116.778C293.828 116.798 293.818 116.82 293.807 116.84C293.783 116.897 293.756 116.952 293.73 117.007C293.678 117.115 293.626 117.223 293.57 117.33C293.534 117.402 293.498 117.47 293.46 117.538C293.237 117.956 292.992 118.364 292.733 118.76C291.791 120.188 290.702 121.525 289.501 122.741C289.497 122.321 289.489 121.901 289.474 121.481C289.475 121.456 289.475 121.43 289.475 121.405C289.475 121.395 289.476 121.386 289.475 121.376L289.476 121.374C289.484 120.981 289.483 120.589 289.478 120.195C289.485 120.01 289.491 119.825 289.495 119.641C289.497 119.574 289.499 119.507 289.501 119.441C289.503 119.395 289.504 119.349 289.503 119.302C289.507 119.171 289.507 119.041 289.511 118.909C289.518 118.707 289.525 118.505 289.536 118.302C289.543 118.141 289.552 117.977 289.564 117.815C289.565 117.775 289.568 117.736 289.571 117.697C289.573 117.641 289.577 117.588 289.581 117.532C289.622 117.513 289.663 117.491 289.703 117.469C289.718 117.46 289.735 117.453 289.751 117.444L289.752 117.442C289.796 117.419 289.839 117.398 289.879 117.374C289.938 117.342 289.995 117.307 290.053 117.272C290.072 117.26 290.093 117.248 290.114 117.236L290.115 117.235C290.23 117.165 290.343 117.092 290.453 117.017C290.55 116.952 290.643 116.883 290.735 116.814C290.757 116.798 290.777 116.782 290.797 116.768C290.886 116.7 290.976 116.629 291.062 116.557C291.085 116.539 291.108 116.52 291.129 116.502C291.171 116.466 291.213 116.43 291.254 116.393C291.301 116.355 291.344 116.315 291.389 116.276C291.424 116.243 291.457 116.213 291.49 116.18C291.518 116.154 291.548 116.128 291.574 116.102C291.584 116.092 291.592 116.085 291.602 116.076C291.611 116.068 291.62 116.059 291.63 116.049L291.631 116.048C291.649 116.031 291.665 116.015 291.684 115.998C291.767 115.916 291.849 115.832 291.926 115.748C292.003 115.667 292.076 115.585 292.148 115.503C292.154 115.498 292.158 115.493 292.162 115.488C292.226 115.414 292.29 115.339 292.352 115.264L292.354 115.262C292.385 115.221 292.417 115.183 292.449 115.141C292.542 115.024 292.632 114.906 292.719 114.782C292.773 114.704 292.826 114.625 292.879 114.545C292.907 114.502 292.934 114.459 292.962 114.414C292.977 114.391 292.991 114.369 293.005 114.346C293.03 114.305 293.055 114.263 293.08 114.221C293.084 114.216 293.087 114.213 293.089 114.207C293.109 114.174 293.127 114.14 293.147 114.107C293.208 113.997 293.265 113.887 293.318 113.772C293.349 113.707 293.379 113.64 293.408 113.572C293.42 113.545 293.432 113.517 293.441 113.489C293.46 113.449 293.474 113.407 293.49 113.367C293.482 113.372 293.476 113.377 293.468 113.382C293.379 113.444 293.292 113.507 293.206 113.571C293.19 113.582 293.173 113.595 293.158 113.607C293.091 113.66 293.022 113.712 292.956 113.764C292.936 113.779 292.918 113.795 292.9 113.81C292.88 113.826 292.862 113.841 292.841 113.858C292.824 113.871 292.809 113.884 292.794 113.898C292.702 113.974 292.61 114.051 292.519 114.131C292.428 114.209 292.34 114.288 292.252 114.367C292.154 114.453 292.058 114.542 291.963 114.629C291.677 114.892 291.398 115.157 291.124 115.431C291.047 115.506 290.973 115.581 290.898 115.658C290.823 115.733 290.75 115.803 290.682 115.88L290.681 115.882L290.673 115.885C290.576 115.984 290.48 116.084 290.384 116.185C290.292 116.28 290.202 116.375 290.113 116.474C290.093 116.495 290.073 116.516 290.053 116.538C290.05 116.541 290.049 116.543 290.046 116.546C289.96 116.641 289.875 116.735 289.79 116.832C289.773 116.852 289.756 116.871 289.739 116.89C289.698 116.935 289.659 116.981 289.62 117.026C289.632 116.876 289.645 116.728 289.659 116.579C289.666 116.524 289.67 116.468 289.676 116.414C289.681 116.371 289.685 116.328 289.69 116.284C289.708 116.115 289.727 115.947 289.748 115.777C289.799 115.342 289.859 114.908 289.93 114.475C289.966 114.242 290.007 114.009 290.049 113.778C290.076 113.627 290.106 113.475 290.135 113.323C290.164 113.173 290.195 113.022 290.229 112.871C290.235 112.835 290.242 112.802 290.25 112.767C290.255 112.741 290.261 112.716 290.266 112.69C290.281 112.617 290.297 112.547 290.313 112.475C290.337 112.369 290.362 112.262 290.388 112.157C290.409 112.059 290.432 111.962 290.458 111.864C290.471 111.807 290.485 111.749 290.5 111.693C290.541 111.526 290.583 111.362 290.628 111.196C290.645 111.124 290.666 111.051 290.687 110.979C290.73 110.817 290.776 110.656 290.823 110.495C290.826 110.473 290.833 110.454 290.84 110.433C290.868 110.329 290.899 110.226 290.931 110.124C290.963 110.019 290.994 109.916 291.026 109.813C291.05 109.729 291.077 109.648 291.103 109.567C291.126 109.493 291.148 109.418 291.173 109.347C291.201 109.253 291.23 109.162 291.261 109.072C291.295 108.97 291.328 108.868 291.363 108.766L291.804 107.544L292.293 106.336L292.819 105.141C292.886 105.008 292.95 104.873 293.015 104.739C293.142 104.482 293.266 104.222 293.389 103.963C293.343 104.038 293.295 104.114 293.248 104.188C293.062 104.482 292.877 104.778 292.695 105.075L292.049 106.22L291.46 107.395L290.919 108.598C290.897 108.647 290.876 108.697 290.857 108.747C290.815 108.842 290.777 108.939 290.738 109.034C290.74 108.277 290.652 107.515 290.468 106.775C290.417 106.57 290.358 106.364 290.293 106.163C290.228 105.961 290.156 105.762 290.078 105.564C289.998 105.367 289.912 105.173 289.818 104.981C289.725 104.788 289.627 104.605 289.522 104.421C289.465 104.323 289.406 104.227 289.345 104.13C289.295 104.049 289.242 103.97 289.189 103.892C289.185 103.887 289.183 103.882 289.178 103.876C289.128 103.802 289.075 103.728 289.022 103.657C288.777 103.32 288.505 103.004 288.205 102.721C288.171 102.69 288.14 102.66 288.106 102.63C288.049 102.576 287.989 102.524 287.929 102.473C288.006 102.622 288.08 102.772 288.155 102.92C288.285 103.178 288.409 103.434 288.528 103.692C288.555 103.748 288.58 103.803 288.604 103.86C288.648 103.953 288.688 104.045 288.728 104.136C288.767 104.224 288.805 104.31 288.84 104.396C288.882 104.495 288.921 104.593 288.961 104.693C289.035 104.879 289.107 105.066 289.174 105.256C289.242 105.444 289.307 105.632 289.367 105.822C289.43 106.012 289.488 106.201 289.542 106.392C289.596 106.584 289.647 106.776 289.696 106.968C289.841 107.547 289.956 108.133 290.041 108.726C290.055 108.826 290.067 108.923 290.081 109.024C290.095 109.124 290.107 109.223 290.116 109.323C290.137 109.488 290.151 109.655 290.165 109.822C290.176 109.942 290.182 110.062 290.191 110.183C290.195 110.262 290.199 110.342 290.205 110.421C290.207 110.428 290.207 110.434 290.207 110.441C290.155 110.585 290.107 110.73 290.058 110.876C289.989 111.082 289.922 111.288 289.859 111.493C289.854 111.508 289.849 111.522 289.846 111.537C289.796 111.699 289.747 111.859 289.699 112.021C289.679 112.086 289.66 112.151 289.642 112.217C289.6 112.36 289.559 112.504 289.521 112.649C289.506 112.692 289.495 112.737 289.483 112.783C289.466 112.845 289.449 112.906 289.434 112.968C289.432 112.974 289.43 112.98 289.43 112.986C289.421 113.019 289.411 113.053 289.403 113.086C289.395 113.122 289.387 113.157 289.378 113.189C289.34 113.33 289.304 113.471 289.269 113.613C289.222 113.81 289.178 114.005 289.133 114.202C289.108 114.309 289.085 114.417 289.063 114.525C288.957 115.019 288.862 115.517 288.778 116.019C288.759 116.128 288.742 116.24 288.724 116.352C288.721 116.365 288.72 116.38 288.718 116.394C288.695 116.538 288.674 116.684 288.653 116.828C288.647 116.879 288.639 116.931 288.632 116.981C288.625 117.032 288.618 117.082 288.611 117.134C288.603 117.186 288.597 117.241 288.591 117.294C288.579 117.389 288.566 117.483 288.556 117.578C288.538 117.728 288.522 117.876 288.506 118.025C288.503 118.053 288.498 118.079 288.497 118.106C288.491 118.159 288.486 118.211 288.482 118.265C288.473 118.359 288.464 118.451 288.457 118.545C288.453 118.598 288.448 118.649 288.444 118.703C288.439 118.743 288.437 118.784 288.433 118.825L288.433 118.827C288.432 118.835 288.432 118.842 288.431 118.85C288.43 118.866 288.43 118.883 288.429 118.9C288.407 119.326 288.385 119.752 288.373 120.178C288.373 120.207 288.374 120.235 288.372 120.264C288.374 120.264 288.374 120.266 288.374 120.266C288.374 120.302 288.374 120.338 288.374 120.374C288.374 120.376 288.374 120.38 288.375 120.383C288.373 120.487 288.373 120.591 288.376 120.697C288.375 120.766 288.377 120.834 288.379 120.902C288.38 121.105 288.384 121.306 288.39 121.509C288.402 121.73 288.416 121.949 288.432 122.17L288.431 122.172C288.433 122.198 288.435 122.222 288.437 122.248C288.449 122.444 288.465 122.641 288.479 122.835L288.532 123.279L288.531 123.281L288.54 123.353L288.556 123.496C288.559 123.539 288.569 123.585 288.584 123.628C288.556 123.654 288.528 123.678 288.498 123.704C288.368 123.823 288.235 123.939 288.101 124.053C288.05 124.098 287.996 124.145 287.942 124.189C287.904 124.222 287.865 124.253 287.827 124.284C287.768 124.333 287.709 124.382 287.648 124.431C287.524 124.533 287.396 124.634 287.267 124.733C287.232 124.763 287.195 124.79 287.155 124.818C287.011 124.931 286.863 125.041 286.715 125.148C286.555 125.263 286.396 125.376 286.233 125.486C286.186 125.52 286.136 125.554 286.085 125.587L286.084 125.588C286.068 125.598 286.053 125.61 286.038 125.619C285.993 125.65 285.949 125.679 285.903 125.709C285.807 125.773 285.712 125.835 285.615 125.896C285.528 125.952 285.44 126.006 285.352 126.059C285.338 126.069 285.322 126.078 285.306 126.087C285.298 126.091 285.292 126.097 285.282 126.1C285.263 126.114 285.242 126.126 285.221 126.138C285.181 126.162 285.142 126.184 285.102 126.208C285.005 126.268 284.906 126.324 284.806 126.38C284.693 126.446 284.578 126.509 284.464 126.572C284.438 126.587 284.414 126.599 284.388 126.614C284.285 126.668 284.184 126.722 284.082 126.775C284.132 126.527 284.181 126.278 284.226 126.031C284.274 125.784 284.32 125.535 284.364 125.287C284.403 125.079 284.441 124.871 284.477 124.664C284.513 124.456 284.549 124.249 284.585 124.042C284.65 123.654 284.715 123.266 284.78 122.878C284.792 122.8 284.806 122.725 284.818 122.647C284.846 122.48 284.875 122.313 284.901 122.145C284.97 121.741 285.037 121.335 285.104 120.929C285.144 120.686 285.185 120.441 285.225 120.198C285.241 120.102 285.257 120.008 285.273 119.913C285.289 119.811 285.307 119.712 285.323 119.611C285.387 119.224 285.452 118.838 285.513 118.453C285.528 118.368 285.541 118.282 285.556 118.196L285.557 118.195C285.724 117.176 285.89 116.16 286.055 115.143C286.07 115.057 286.082 114.973 286.096 114.89C286.132 114.664 286.17 114.439 286.206 114.214C286.222 114.108 286.239 114.002 286.257 113.897C286.311 113.56 286.363 113.222 286.417 112.882C286.416 112.88 286.416 112.878 286.417 112.876C286.502 112.341 286.586 111.805 286.669 111.27C286.684 111.178 286.698 111.084 286.712 110.992L286.713 110.991C286.745 110.776 286.779 110.563 286.811 110.348C286.818 110.317 286.823 110.285 286.828 110.253C286.826 110.25 286.828 110.247 286.828 110.245C286.848 110.115 286.869 109.983 286.888 109.853C286.855 110.003 286.821 110.156 286.788 110.307C286.643 110.955 286.498 111.605 286.356 112.255C286.339 112.335 286.321 112.417 286.304 112.497C286.249 112.739 286.196 112.984 286.145 113.23C286.128 113.308 286.112 113.385 286.095 113.463C286.078 113.543 286.058 113.625 286.042 113.708C286.025 113.782 286.01 113.855 285.995 113.929C285.968 114.05 285.941 114.171 285.915 114.293C285.898 114.367 285.882 114.442 285.867 114.516C285.837 114.658 285.807 114.799 285.777 114.94C285.61 115.714 285.445 116.489 285.281 117.264C285.265 117.341 285.247 117.415 285.231 117.491C285.162 117.821 285.092 118.148 285.023 118.476C285.006 118.555 284.989 118.633 284.973 118.711C284.949 118.829 284.923 118.945 284.899 119.063C284.896 119.047 284.893 119.033 284.89 119.017C284.852 118.834 284.81 118.651 284.766 118.471C284.632 117.959 284.468 117.458 284.281 116.965C284.093 116.475 283.881 115.995 283.637 115.523C283.51 115.281 283.378 115.039 283.229 114.804C283.2 114.754 283.171 114.706 283.138 114.659C283.053 114.528 282.963 114.4 282.867 114.274C282.84 114.237 282.811 114.2 282.782 114.162C282.789 114.264 282.796 114.365 282.808 114.464C282.807 114.466 282.809 114.466 282.808 114.468C282.82 114.576 282.834 114.682 282.851 114.789C282.862 114.862 282.875 114.938 282.89 115.013C282.897 115.064 282.909 115.114 282.919 115.166C282.958 115.357 283.002 115.545 283.049 115.731C283.051 115.732 283.05 115.734 283.05 115.734C283.051 115.738 283.053 115.743 283.054 115.748C283.055 115.755 283.058 115.76 283.06 115.767L283.059 115.769C283.061 115.78 283.066 115.792 283.07 115.804L283.069 115.806C283.103 115.929 283.136 116.051 283.172 116.17C283.208 116.292 283.244 116.414 283.284 116.533C283.323 116.654 283.363 116.774 283.406 116.893C283.446 117.013 283.492 117.132 283.537 117.25C283.726 117.741 283.939 118.222 284.182 118.693C284.358 119.03 284.548 119.364 284.767 119.684C284.668 120.153 284.569 120.622 284.473 121.092L284.472 121.094C284.455 121.168 284.44 121.241 284.425 121.316C284.4 121.436 284.376 121.555 284.352 121.673C284.335 121.746 284.32 121.82 284.305 121.893C284.163 122.564 284.023 123.236 283.882 123.907C283.797 124.324 283.709 124.74 283.618 125.155C283.612 125.191 283.603 125.228 283.595 125.263C283.583 125.322 283.569 125.382 283.557 125.441C283.552 125.461 283.548 125.479 283.544 125.496C283.543 125.504 283.542 125.514 283.539 125.524C283.538 125.532 283.537 125.542 283.534 125.55C283.477 125.812 283.418 126.072 283.355 126.332C283.306 126.534 283.259 126.737 283.209 126.941C283.207 126.948 283.206 126.957 283.204 126.962C283.15 127.186 283.094 127.408 283.036 127.63C282.989 127.812 282.941 127.995 282.891 128.176C282.879 128.223 282.866 128.271 282.852 128.317L282.852 128.319C282.835 128.38 282.818 128.44 282.801 128.501C282.796 128.521 282.789 128.542 282.785 128.561C282.752 128.672 282.72 128.783 282.686 128.893C282.666 128.964 282.646 129.033 282.624 129.103C282.599 129.194 282.57 129.285 282.54 129.375C282.537 129.391 282.531 129.408 282.525 129.425L282.495 129.524L282.481 129.565C282.466 129.615 282.45 129.665 282.433 129.715C282.376 129.892 282.317 130.067 282.257 130.242C282.196 130.417 282.129 130.604 282.062 130.785C281.657 131.892 281.179 132.971 280.651 134.022C280.518 134.283 280.381 134.546 280.239 134.802C279.813 135.576 279.35 136.328 278.864 137.065C278.808 137.149 278.752 137.233 278.693 137.315C278.687 137.328 278.679 137.338 278.672 137.348C278.589 137.469 278.506 137.589 278.42 137.707C278.322 137.85 278.221 137.99 278.118 138.129C277.996 138.298 277.874 138.461 277.749 138.627C277.612 138.809 277.472 138.988 277.333 139.167C277.314 139.192 277.294 139.217 277.273 139.241C277.175 139.367 277.075 139.49 276.973 139.613C276.906 139.698 276.838 139.779 276.77 139.859C276.716 139.924 276.662 139.99 276.606 140.054C276.523 140.152 276.441 140.25 276.357 140.345C276.331 140.279 276.308 140.214 276.286 140.149C276.277 140.125 276.267 140.101 276.258 140.077L276.259 140.075C276.212 139.949 276.17 139.82 276.133 139.692C276.121 139.648 276.109 139.602 276.099 139.558C276.096 139.549 276.093 139.539 276.091 139.528C276.088 139.518 276.085 139.507 276.082 139.497C276.073 139.456 276.062 139.415 276.054 139.372C276.046 139.329 276.037 139.288 276.029 139.245C276.011 139.156 275.993 139.068 275.979 138.979C275.977 138.962 275.973 138.943 275.971 138.926C275.966 138.897 275.962 138.87 275.958 138.841L275.958 138.839C275.95 138.79 275.943 138.739 275.937 138.688C275.927 138.609 275.916 138.531 275.909 138.453C275.891 138.293 275.877 138.133 275.865 137.972C275.791 136.801 275.864 135.583 275.883 134.369C275.913 133.158 275.944 131.951 276.053 130.755C276.057 130.726 276.058 130.699 276.061 130.671C276.065 130.617 276.071 130.563 276.075 130.509C276.082 130.421 276.092 130.334 276.103 130.247C276.118 130.105 276.133 129.965 276.151 129.824C276.156 129.771 276.163 129.716 276.168 129.663C276.183 129.535 276.2 129.409 276.218 129.282C276.224 129.223 276.233 129.167 276.24 129.109C276.356 129.054 276.472 129 276.586 128.943C276.759 128.859 276.928 128.771 277.097 128.679C277.18 128.633 277.264 128.586 277.348 128.539C277.433 128.493 277.515 128.445 277.597 128.398C277.921 128.209 278.239 128.009 278.551 127.802C278.863 127.596 279.169 127.38 279.471 127.158C279.565 127.089 279.658 127.021 279.748 126.949C279.759 126.942 279.769 126.933 279.78 126.924C279.799 126.914 279.816 126.901 279.831 126.887C279.848 126.874 279.865 126.861 279.883 126.848C279.889 126.842 279.894 126.839 279.902 126.834L279.903 126.832C280.099 126.681 280.291 126.526 280.479 126.368C280.502 126.351 280.523 126.331 280.544 126.313C280.643 126.233 280.737 126.152 280.831 126.071C280.839 126.063 280.846 126.057 280.855 126.05L280.855 126.048C280.976 125.944 281.095 125.838 281.211 125.731C281.299 125.65 281.386 125.568 281.473 125.487C281.48 125.479 281.489 125.472 281.495 125.465C281.499 125.462 281.502 125.459 281.505 125.456C281.511 125.45 281.518 125.442 281.527 125.436C281.536 125.427 281.543 125.419 281.553 125.409C281.653 125.314 281.753 125.214 281.851 125.115C281.864 125.1 281.88 125.087 281.893 125.072L281.894 125.071C282.117 124.845 282.334 124.608 282.54 124.361C282.615 124.272 282.692 124.179 282.765 124.084C282.708 124.113 282.654 124.142 282.599 124.172C282.514 124.216 282.431 124.261 282.35 124.307C282.218 124.379 282.086 124.453 281.959 124.529C281.946 124.537 281.933 124.543 281.92 124.551C281.83 124.602 281.744 124.657 281.654 124.71L281.654 124.711C281.643 124.716 281.635 124.722 281.627 124.728L281.624 124.729C281.614 124.734 281.605 124.741 281.595 124.746C281.568 124.764 281.539 124.781 281.511 124.799C281.374 124.884 281.239 124.97 281.106 125.059C281.088 125.067 281.071 125.078 281.057 125.088C281.049 125.094 281.042 125.098 281.033 125.103C280.965 125.147 280.895 125.192 280.826 125.238C280.717 125.31 280.61 125.382 280.503 125.454L280.502 125.456C280.48 125.472 280.459 125.485 280.436 125.501C280.433 125.504 280.428 125.506 280.423 125.509C280.224 125.644 280.027 125.782 279.829 125.922C279.804 125.939 279.782 125.954 279.759 125.972C279.703 126.011 279.648 126.049 279.594 126.089C279.525 126.137 279.457 126.187 279.389 126.235C279.35 126.262 279.314 126.287 279.279 126.315C279.185 126.382 279.094 126.449 279 126.518C278.403 126.959 277.815 127.415 277.239 127.887C276.922 128.15 276.609 128.416 276.3 128.692C276.377 128.19 276.462 127.689 276.563 127.189C276.644 126.777 276.733 126.363 276.827 125.952C276.839 125.899 276.85 125.848 276.862 125.795C277.311 125.201 277.725 124.584 278.117 123.951C278.167 123.869 278.218 123.788 278.267 123.707C278.276 123.693 278.283 123.678 278.292 123.665C278.311 123.635 278.328 123.605 278.346 123.576C278.386 123.512 278.423 123.446 278.46 123.382C278.475 123.355 278.49 123.331 278.506 123.305C278.512 123.292 278.52 123.28 278.527 123.268C278.546 123.237 278.564 123.203 278.584 123.17C278.612 123.118 278.643 123.068 278.672 123.015C278.719 122.932 278.765 122.849 278.811 122.766C278.88 122.64 278.948 122.515 279.015 122.388C279.076 122.274 279.136 122.161 279.194 122.044C279.291 121.862 279.382 121.677 279.474 121.492C279.495 121.449 279.516 121.406 279.538 121.362C279.54 121.357 279.544 121.35 279.546 121.344C279.614 121.203 279.68 121.062 279.746 120.919C279.789 120.826 279.831 120.735 279.872 120.642C279.896 120.591 279.918 120.538 279.942 120.487C279.966 120.432 279.992 120.376 280.015 120.321C280.018 120.311 280.023 120.303 280.027 120.293C280.048 120.244 280.07 120.192 280.092 120.141C280.108 120.106 280.122 120.073 280.136 120.038C280.16 119.981 280.184 119.924 280.208 119.867C280.235 119.802 280.261 119.738 280.289 119.671C280.337 119.557 280.383 119.441 280.428 119.324C280.476 119.204 280.522 119.085 280.565 118.965C280.611 118.844 280.656 118.723 280.699 118.603C280.787 118.362 280.869 118.118 280.95 117.875C280.974 117.803 280.997 117.731 281.02 117.659C281.034 117.618 281.048 117.574 281.061 117.53C281.068 117.509 281.073 117.49 281.08 117.469C281.094 117.428 281.107 117.384 281.12 117.34C281.138 117.283 281.154 117.223 281.172 117.166C281.207 117.047 281.241 116.931 281.272 116.811C281.296 116.731 281.317 116.65 281.339 116.569C281.371 116.447 281.402 116.326 281.432 116.203C281.469 116.054 281.504 115.904 281.537 115.755C281.351 116.213 281.165 116.671 280.978 117.129C280.793 117.585 280.602 118.039 280.409 118.49C280.33 118.678 280.249 118.862 280.166 119.046C280.106 119.182 280.047 119.317 279.985 119.451C279.982 119.462 279.976 119.473 279.972 119.484C279.954 119.523 279.936 119.563 279.919 119.601C279.913 119.618 279.905 119.634 279.897 119.65C279.864 119.723 279.833 119.795 279.799 119.867L279.799 119.869C279.775 119.918 279.754 119.967 279.731 120.016C279.683 120.122 279.634 120.229 279.585 120.334C279.549 120.412 279.514 120.489 279.477 120.566C279.457 120.612 279.435 120.657 279.413 120.702C279.339 120.86 279.264 121.014 279.189 121.172C279.067 121.426 278.943 121.679 278.817 121.932C278.692 122.183 278.563 122.433 278.434 122.684L278.434 122.685C278.409 122.734 278.384 122.78 278.359 122.828C278.31 122.927 278.26 123.023 278.207 123.121C278.182 123.167 278.157 123.215 278.133 123.262C278.039 123.44 277.943 123.619 277.848 123.797C277.556 124.34 277.253 124.88 276.949 125.419C276.975 125.314 276.999 125.208 277.026 125.104C277.035 125.059 277.046 125.016 277.057 124.972C277.091 124.838 277.124 124.707 277.158 124.573C277.193 124.442 277.226 124.308 277.262 124.175C277.328 123.918 277.398 123.662 277.469 123.407C277.481 123.354 277.498 123.301 277.512 123.248C277.525 123.198 277.539 123.151 277.552 123.1L277.554 123.097C277.592 122.956 277.632 122.816 277.672 122.676C277.715 122.523 277.76 122.368 277.803 122.214C277.813 122.178 277.823 122.143 277.834 122.107C277.852 122.041 277.871 121.974 277.892 121.91C277.944 121.729 277.997 121.552 278.05 121.373C278.096 121.218 278.141 121.063 278.186 120.908C278.26 120.66 278.333 120.413 278.408 120.166C278.469 119.965 278.53 119.766 278.589 119.565C278.666 119.307 278.742 119.049 278.819 118.792C278.847 118.7 278.874 118.608 278.902 118.517C278.945 118.38 278.986 118.243 279.029 118.108C279.032 118.093 279.038 118.076 279.043 118.061C279.05 118.035 279.057 118.013 279.066 117.988C279.078 117.948 279.091 117.911 279.103 117.87C279.111 117.842 279.12 117.815 279.129 117.787C279.167 117.665 279.208 117.543 279.248 117.42C279.27 117.351 279.293 117.285 279.316 117.218C279.335 117.157 279.356 117.097 279.378 117.034L279.425 116.897C279.442 116.848 279.459 116.799 279.478 116.751L279.499 116.691C279.514 116.647 279.531 116.605 279.546 116.562C279.561 116.518 279.577 116.478 279.594 116.435C279.601 116.414 279.61 116.396 279.617 116.375C279.636 116.325 279.657 116.273 279.676 116.223L279.683 116.204C279.717 116.117 279.751 116.032 279.786 115.948C279.823 115.861 279.858 115.776 279.896 115.693C279.946 115.579 279.997 115.469 280.05 115.359C280.103 115.247 280.158 115.137 280.215 115.029C280.244 114.975 280.271 114.922 280.299 114.87C280.32 114.833 280.342 114.794 280.363 114.758L280.364 114.756C280.408 114.678 280.454 114.601 280.499 114.525L280.5 114.523C280.545 114.446 280.592 114.371 280.639 114.297C280.649 114.282 280.661 114.265 280.67 114.249C280.707 114.192 280.746 114.134 280.785 114.078C280.799 114.054 280.819 114.029 280.835 114.005C280.883 113.935 280.932 113.866 280.983 113.797C281.003 113.771 281.024 113.742 281.045 113.716C281.097 113.645 281.153 113.576 281.208 113.507C281.109 113.603 281.015 113.705 280.924 113.809C280.9 113.836 280.874 113.863 280.851 113.893C280.834 113.91 280.817 113.93 280.802 113.948C280.789 113.962 280.778 113.977 280.765 113.994C280.755 114.005 280.746 114.014 280.737 114.026C280.701 114.071 280.664 114.115 280.63 114.16C280.574 114.229 280.52 114.301 280.467 114.373C280.465 114.374 280.464 114.376 280.464 114.378C280.425 114.43 280.387 114.482 280.35 114.535L280.35 114.536C280.342 114.546 280.334 114.556 280.328 114.567C280.283 114.631 280.239 114.696 280.195 114.763C280.181 114.785 280.166 114.805 280.153 114.829C280.099 114.911 280.047 114.994 279.997 115.079C279.948 115.159 279.898 115.241 279.853 115.324C279.839 115.345 279.828 115.366 279.816 115.389C279.767 115.474 279.722 115.557 279.677 115.642L279.677 115.644C279.6 115.786 279.526 115.933 279.454 116.079C279.395 116.202 279.335 116.326 279.278 116.452C279.267 116.473 279.256 116.497 279.247 116.519C279.238 116.539 279.229 116.557 279.22 116.577C279.218 116.583 279.214 116.588 279.212 116.593C279.197 116.63 279.18 116.669 279.165 116.706C279.157 116.722 279.149 116.74 279.143 116.757C279.123 116.803 279.102 116.85 279.084 116.897C279.066 116.937 279.049 116.98 279.031 117.02C279.004 117.086 278.978 117.153 278.951 117.22C278.908 117.327 278.863 117.435 278.822 117.543C278.767 117.678 278.715 117.814 278.664 117.95C278.58 118.169 278.5 118.388 278.419 118.608C278.249 119.074 278.085 119.539 277.916 120.003C277.87 120.13 277.825 120.26 277.78 120.39C277.757 120.449 277.737 120.508 277.716 120.568C277.697 120.622 277.676 120.678 277.659 120.733L277.658 120.735C277.495 121.199 277.335 121.666 277.179 122.134C277.068 122.468 276.959 122.806 276.85 123.143C276.844 123.076 276.839 123.006 276.831 122.938C276.795 122.633 276.749 122.33 276.693 122.031C276.693 122.031 276.693 122.029 276.691 122.028L276.692 122.027C276.659 121.859 276.625 121.69 276.584 121.524C276.582 121.512 276.58 121.501 276.577 121.492C276.557 121.401 276.536 121.311 276.512 121.221C276.368 120.655 276.187 120.099 275.968 119.558C275.876 119.332 275.777 119.108 275.668 118.887C275.659 118.869 275.651 118.852 275.641 118.831C275.617 118.785 275.594 118.737 275.57 118.691C275.559 118.668 275.547 118.647 275.536 118.624C275.518 118.59 275.498 118.556 275.48 118.524C275.475 118.514 275.471 118.507 275.465 118.498C275.436 118.444 275.404 118.389 275.372 118.335C275.36 118.316 275.35 118.296 275.338 118.277C275.304 118.221 275.267 118.164 275.231 118.109C275.205 118.069 275.179 118.028 275.153 117.989C275.157 118.092 275.164 118.196 275.171 118.297C275.171 118.301 275.171 118.307 275.172 118.312C275.179 118.407 275.188 118.503 275.199 118.597C275.204 118.645 275.209 118.691 275.215 118.74C275.216 118.75 275.217 118.764 275.22 118.775C275.224 118.812 275.229 118.852 275.235 118.89C275.238 118.923 275.242 118.954 275.246 118.984C275.258 119.066 275.27 119.148 275.284 119.229C275.288 119.26 275.294 119.292 275.298 119.323C275.299 119.325 275.298 119.327 275.299 119.33C275.303 119.356 275.308 119.383 275.312 119.41C275.312 119.414 275.314 119.417 275.314 119.421C275.318 119.446 275.322 119.472 275.328 119.498C275.332 119.522 275.335 119.549 275.341 119.574C275.35 119.628 275.359 119.679 275.368 119.733C275.473 120.3 275.598 120.862 275.741 121.417C275.85 121.848 275.973 122.278 276.106 122.708L276.105 122.71C276.108 122.715 276.11 122.72 276.111 122.724C276.146 122.84 276.184 122.956 276.221 123.072C276.248 123.149 276.274 123.225 276.298 123.301L276.3 123.306L276.3 123.308C276.388 123.554 276.476 123.797 276.575 124.04C276.45 124.455 276.33 124.873 276.216 125.293C276.187 125.401 276.159 125.506 276.131 125.613C276.093 125.751 276.057 125.89 276.022 126.03C275.977 126.206 275.934 126.38 275.891 126.558L275.891 126.559C275.879 126.606 275.869 126.653 275.857 126.7C275.832 126.809 275.807 126.916 275.782 127.025C275.749 127.168 275.719 127.309 275.689 127.452C275.687 127.456 275.686 127.46 275.687 127.464C275.649 127.64 275.613 127.817 275.579 127.993C275.574 128.015 275.57 128.038 275.566 128.062C275.527 128.26 275.49 128.455 275.458 128.653C275.423 128.851 275.389 129.05 275.359 129.248C275.357 129.254 275.355 129.258 275.357 129.265C275.326 129.465 275.299 129.664 275.271 129.865C275.245 130.05 275.221 130.235 275.201 130.42L275.199 130.421C275.198 130.422 275.199 130.423 275.2 130.424C275.19 130.507 275.18 130.59 275.171 130.672C275.166 130.709 275.163 130.748 275.159 130.784C275.156 130.811 275.153 130.839 275.152 130.866C275.145 130.94 275.139 131.013 275.131 131.084C275.127 131.14 275.122 131.195 275.118 131.249C275.096 131.506 275.076 131.767 275.06 132.025C275.045 132.255 275.031 132.486 275.02 132.718C275.005 132.991 274.993 133.263 274.985 133.534C274.975 133.806 274.968 134.077 274.961 134.349C274.961 134.387 274.96 134.426 274.959 134.464C274.958 134.491 274.959 134.519 274.958 134.546L274.957 134.55C274.948 135.092 274.94 135.633 274.941 136.181C274.942 136.324 274.943 136.468 274.946 136.612C274.945 136.652 274.946 136.69 274.947 136.73C274.947 136.741 274.948 136.752 274.948 136.762C274.949 136.773 274.949 136.784 274.95 136.795C274.954 136.99 274.961 137.188 274.972 137.386C274.985 137.605 275.003 137.826 275.026 138.045C275.041 138.196 275.06 138.347 275.083 138.501C275.101 138.636 275.125 138.77 275.149 138.905C275.199 139.164 275.258 139.423 275.332 139.678C275.339 139.706 275.349 139.732 275.356 139.76C275.372 139.812 275.388 139.864 275.404 139.914C275.433 139.989 275.459 140.065 275.485 140.142C275.506 140.198 275.527 140.253 275.55 140.308L275.549 140.31C275.557 140.329 275.566 140.347 275.574 140.367L275.576 140.372C275.617 140.466 275.654 140.561 275.7 140.653C275.717 140.684 275.733 140.715 275.751 140.744C275.762 140.767 275.774 140.786 275.787 140.805C275.787 140.806 275.788 140.808 275.79 140.808C275.809 140.842 275.834 140.876 275.856 140.909C275.821 140.948 275.784 140.987 275.748 141.025C275.599 141.189 275.448 141.351 275.295 141.511L275.29 141.513C275.154 141.658 275.013 141.803 274.871 141.945C274.858 141.96 274.842 141.973 274.829 141.988C274.67 142.148 274.508 142.306 274.345 142.462C274.223 142.582 274.097 142.703 273.968 142.818C273.928 142.857 273.888 142.894 273.847 142.932C273.823 142.953 273.8 142.975 273.777 142.994C273.712 143.052 273.648 143.11 273.584 143.167C273.465 143.274 273.347 143.378 273.23 143.485C273.228 143.485 273.227 143.486 273.227 143.488C273.165 143.542 273.105 143.595 273.044 143.65C272.705 143.93 272.369 144.216 272.024 144.49C271.94 144.556 271.856 144.622 271.77 144.687C271.738 144.711 271.707 144.736 271.675 144.759C271.638 144.788 271.601 144.815 271.562 144.844C271.525 144.871 271.49 144.899 271.45 144.928C271.353 145.003 271.253 145.076 271.154 145.151C271.148 145.155 271.14 145.161 271.134 145.165C271.007 145.258 270.882 145.35 270.754 145.442C270.725 145.466 270.692 145.486 270.661 145.509L270.66 145.511C270.649 145.52 270.635 145.529 270.624 145.538C270.352 145.73 270.079 145.918 269.802 146.102C269.466 146.326 269.124 146.545 268.779 146.758C268.637 146.846 268.495 146.931 268.352 147.017C268.281 147.059 268.209 147.102 268.137 147.145L268.135 147.144C267.382 147.586 266.605 147.997 265.816 148.372C265.669 148.442 265.526 148.509 265.379 148.574C265.353 148.589 265.33 148.6 265.306 148.608C265.302 148.613 265.298 148.614 265.296 148.613C265.283 148.621 265.27 148.627 265.256 148.633C265.243 148.639 265.23 148.645 265.218 148.649C265.178 148.669 265.135 148.688 265.093 148.707L265.228 148.573L265.254 148.546L265.269 148.532L265.27 148.53L265.337 148.471L265.34 148.468L265.343 148.459L265.375 148.43L265.373 148.429C265.37 148.426 265.368 148.423 265.366 148.418C265.362 148.417 265.361 148.414 265.36 148.412C265.343 148.393 265.328 148.375 265.314 148.356C265.306 148.349 265.3 148.34 265.293 148.332C265.259 148.288 265.226 148.245 265.195 148.201C265.188 148.194 265.183 148.186 265.177 148.178C265.149 148.138 265.123 148.098 265.099 148.056C265.079 148.023 265.061 147.992 265.043 147.958C265.036 147.947 265.029 147.937 265.024 147.922C265.022 147.919 265.021 147.917 265.019 147.916C265.003 147.883 264.987 147.85 264.971 147.819L264.949 147.774C264.933 147.741 264.917 147.706 264.904 147.672C264.826 147.489 264.767 147.3 264.724 147.104L264.724 147.102C264.717 147.07 264.71 147.04 264.704 147.008L264.705 147.007C264.695 146.957 264.687 146.907 264.678 146.858C264.677 146.856 264.678 146.854 264.678 146.852C264.673 146.825 264.668 146.796 264.666 146.767C264.655 146.694 264.649 146.62 264.643 146.547C264.634 146.434 264.627 146.318 264.625 146.203L264.648 146.252L264.682 146.314L264.733 146.416L264.732 146.418L264.766 146.484C264.894 146.425 265.018 146.365 265.142 146.303C265.157 146.296 265.171 146.288 265.183 146.282C265.211 146.268 265.239 146.255 265.266 146.239C265.459 146.143 265.648 146.041 265.837 145.935C265.931 145.882 266.026 145.828 266.118 145.774C266.211 145.72 266.303 145.665 266.395 145.609L266.4 145.606C266.717 145.413 267.031 145.208 267.336 144.996C267.336 144.994 267.338 144.995 267.339 144.993C267.759 144.698 268.169 144.385 268.564 144.059C268.801 143.863 269.035 143.662 269.262 143.457C269.438 143.294 269.614 143.128 269.784 142.959C269.868 142.881 269.948 142.801 270.027 142.719C270.252 142.492 270.469 142.259 270.682 142.022C270.692 142.011 270.702 141.999 270.711 141.987C270.726 141.974 270.737 141.959 270.751 141.944L270.752 141.943C270.845 141.836 270.94 141.728 271.03 141.62C271.094 141.543 271.159 141.467 271.22 141.389C271.251 141.353 271.281 141.315 271.31 141.279C271.319 141.267 271.328 141.258 271.337 141.246C271.354 141.227 271.369 141.207 271.385 141.187L271.385 141.185C271.426 141.134 271.465 141.084 271.504 141.032C271.515 141.017 271.526 141.004 271.538 140.989C271.594 140.916 271.65 140.842 271.703 140.768C271.742 140.717 271.781 140.665 271.818 140.612C271.87 140.542 271.92 140.471 271.97 140.4C272.008 140.344 272.049 140.286 272.088 140.23C272.147 140.143 272.206 140.054 272.263 139.967C272.331 139.863 272.396 139.76 272.46 139.656C272.464 139.649 272.468 139.644 272.472 139.637C272.542 139.526 272.609 139.413 272.676 139.299C272.514 139.468 272.352 139.637 272.188 139.802C272.073 139.92 271.957 140.035 271.842 140.149C271.745 140.246 271.646 140.342 271.546 140.436C271.467 140.514 271.388 140.59 271.307 140.665C271.281 140.69 271.254 140.714 271.228 140.739C271.228 140.741 271.226 140.74 271.225 140.742C271.128 140.833 271.032 140.923 270.935 141.014C270.851 141.092 270.765 141.168 270.68 141.244C270.655 141.267 270.629 141.289 270.604 141.312C270.521 141.387 270.44 141.462 270.356 141.534C270.338 141.548 270.323 141.562 270.305 141.577C270.303 141.578 270.302 141.58 270.302 141.58C270.208 141.663 270.112 141.746 270.015 141.826C270.014 141.828 270.011 141.829 270.011 141.831C269.888 141.936 269.766 142.038 269.64 142.14C269.557 142.21 269.472 142.278 269.388 142.345C269.285 142.43 269.178 142.513 269.071 142.596C268.966 142.679 268.86 142.762 268.752 142.843C268.408 143.105 268.058 143.36 267.701 143.603C267.692 143.611 267.682 143.616 267.673 143.623C267.544 143.713 267.412 143.802 267.281 143.89C267.139 143.984 266.998 144.075 266.855 144.167L266.854 144.169C266.853 144.171 266.851 144.172 266.848 144.173C266.704 144.267 266.559 144.357 266.412 144.447C265.969 144.723 265.517 144.988 265.06 145.242L265.059 145.244C265.026 145.262 264.992 145.28 264.96 145.298C264.892 145.338 264.821 145.378 264.749 145.415C264.73 145.427 264.71 145.437 264.689 145.449C264.673 145.458 264.655 145.466 264.64 145.476C264.644 145.408 264.651 145.34 264.656 145.271C264.66 145.217 264.665 145.16 264.671 145.105C264.673 145.087 264.675 145.071 264.677 145.052C264.679 145.028 264.681 145.003 264.686 144.977C264.695 144.871 264.709 144.764 264.724 144.656C264.729 144.605 264.735 144.556 264.742 144.506C264.745 144.471 264.751 144.438 264.756 144.404C264.808 144.005 264.871 143.599 264.926 143.197L265.199 141.33C265.221 141.186 265.244 141.041 265.268 140.895C265.275 140.843 265.285 140.791 265.292 140.739C265.309 140.635 265.324 140.531 265.34 140.425C265.35 140.372 265.358 140.319 265.366 140.265C265.378 140.255 265.389 140.246 265.4 140.235C265.424 140.212 265.449 140.191 265.472 140.167C265.541 140.101 265.602 140.029 265.659 139.956C265.756 139.832 265.849 139.704 265.94 139.578C265.971 139.536 266 139.493 266.032 139.452L266.422 138.965L266.826 138.492C267.1 138.181 267.38 137.878 267.664 137.581C267.807 137.432 267.951 137.284 268.094 137.138C268.166 137.064 268.239 136.992 268.313 136.919C268.387 136.845 268.46 136.774 268.535 136.703L268.705 136.541L268.984 136.28L269.117 136.162L269.175 136.112C269.175 136.112 269.177 136.111 269.178 136.109L269.222 136.071L269.303 135.998L269.45 135.87L269.929 135.474C270.011 135.412 270.093 135.347 270.175 135.286C270.257 135.221 270.339 135.155 270.42 135.09C270.486 135.04 270.554 134.991 270.62 134.94C271.073 134.605 271.542 134.285 272.026 133.972C272.185 133.87 272.345 133.767 272.507 133.665C272.366 133.701 272.225 133.738 272.085 133.782C272 133.808 271.915 133.835 271.832 133.863C271.665 133.919 271.499 133.979 271.335 134.045C271.13 134.125 270.926 134.214 270.725 134.313C270.671 134.337 270.615 134.364 270.559 134.393C270.47 134.436 270.383 134.481 270.295 134.529C270.239 134.556 270.185 134.583 270.132 134.614L270.132 134.616L270.118 134.624C270.024 134.677 269.929 134.731 269.837 134.785C269.742 134.84 269.651 134.895 269.557 134.953L269.018 135.312L268.497 135.702L268.081 136.046L267.995 136.118C267.831 136.261 267.673 136.408 267.519 136.561C267.509 136.573 267.499 136.584 267.486 136.594C267.418 136.663 267.35 136.733 267.283 136.804C267.207 136.883 267.132 136.965 267.06 137.046C266.921 137.205 266.784 137.368 266.654 137.536C266.588 137.622 266.523 137.709 266.459 137.796C266.459 137.796 266.456 137.798 266.455 137.799C266.394 137.886 266.332 137.974 266.272 138.062L265.92 138.608L265.598 139.172C265.592 139.183 265.586 139.194 265.58 139.204L265.58 139.206C265.559 139.248 265.539 139.287 265.518 139.328C265.524 139.301 265.527 139.274 265.532 139.247C265.584 138.928 265.64 138.608 265.697 138.291C265.697 138.284 265.7 138.277 265.702 138.271C265.71 138.223 265.717 138.178 265.726 138.128L265.727 138.126C265.757 137.959 265.789 137.789 265.821 137.622C265.872 137.359 265.922 137.094 265.976 136.831C266 136.704 266.025 136.578 266.052 136.451C266.055 136.443 266.056 136.435 266.058 136.428C266.082 136.299 266.109 136.172 266.137 136.044C266.143 136.015 266.149 135.983 266.157 135.954C266.185 135.812 266.217 135.674 266.248 135.533C266.249 135.525 266.249 135.519 266.252 135.511C266.283 135.372 266.315 135.232 266.346 135.093C266.383 134.937 266.421 134.78 266.459 134.622C266.463 134.605 266.467 134.587 266.473 134.57C266.522 134.366 266.574 134.163 266.627 133.96C266.748 133.492 266.874 133.024 267.007 132.561C267.051 132.418 267.094 132.275 267.137 132.132C267.155 132.073 267.172 132.013 267.19 131.954C267.215 131.87 267.243 131.785 267.269 131.702L267.27 131.7C267.288 131.636 267.309 131.574 267.329 131.511C267.351 131.441 267.374 131.371 267.397 131.304C267.469 131.082 267.545 130.86 267.621 130.64C267.685 130.462 267.749 130.282 267.815 130.105C267.832 130.056 267.848 130.009 267.866 129.962C267.931 129.789 267.997 129.616 268.063 129.443C268.069 129.428 268.076 129.412 268.081 129.397C268.096 129.36 268.112 129.321 268.127 129.284C268.141 129.25 268.152 129.218 268.165 129.185C268.175 129.163 268.185 129.141 268.193 129.119C268.198 129.102 268.206 129.086 268.214 129.069C268.227 129.032 268.244 128.993 268.259 128.956C268.294 128.869 268.33 128.783 268.367 128.695C268.431 128.54 268.497 128.388 268.565 128.235C268.579 128.2 268.595 128.165 268.609 128.13C268.678 127.975 268.748 127.82 268.821 127.666C268.933 127.423 269.048 127.18 269.167 126.94C269.304 126.663 269.446 126.387 269.592 126.116C269.637 126.03 269.683 125.947 269.728 125.864C269.78 125.769 269.834 125.674 269.888 125.579C269.944 125.478 270.003 125.376 270.061 125.276C270.063 125.275 270.064 125.273 270.064 125.271C270.099 125.209 270.135 125.146 270.173 125.086C270.241 124.97 270.309 124.853 270.382 124.739C270.428 124.66 270.477 124.58 270.527 124.503C270.541 124.48 270.555 124.458 270.572 124.434C270.64 124.323 270.712 124.213 270.786 124.102C270.872 123.969 270.962 123.837 271.052 123.706C271.165 123.538 271.28 123.372 271.4 123.209C271.413 123.188 271.429 123.166 271.444 123.146C271.525 123.035 271.606 122.922 271.691 122.813C271.745 122.741 271.8 122.667 271.856 122.596L271.857 122.595C271.972 122.447 272.088 122.3 272.207 122.156C272.22 122.137 272.235 122.119 272.25 122.101C272.362 121.965 272.475 121.829 272.591 121.695C272.613 121.668 272.634 121.644 272.655 121.62C272.695 121.571 272.736 121.524 272.778 121.477L272.779 121.475C272.832 121.413 272.887 121.352 272.941 121.292C273.096 121.118 273.255 120.946 273.413 120.775C273.306 120.864 273.201 120.954 273.098 121.047C273.011 121.126 272.924 121.206 272.838 121.285L272.837 121.287C272.744 121.373 272.653 121.459 272.562 121.545C272.472 121.634 272.383 121.721 272.293 121.81C272.115 121.99 271.942 122.172 271.771 122.357C271.684 122.449 271.601 122.542 271.517 122.638C271.436 122.728 271.357 122.82 271.277 122.912C271.108 123.106 270.943 123.304 270.781 123.505C270.69 123.621 270.599 123.737 270.51 123.853C270.426 123.961 270.347 124.068 270.267 124.177C270.259 124.187 270.252 124.196 270.247 124.206L270.244 124.207C270.236 124.219 270.227 124.233 270.218 124.245C270.163 124.32 270.107 124.396 270.056 124.471C270.016 124.524 269.978 124.579 269.941 124.633C269.928 124.65 269.919 124.665 269.907 124.682C269.805 124.83 269.704 124.981 269.605 125.132C269.507 125.281 269.41 125.433 269.316 125.583C269.284 125.633 269.251 125.685 269.221 125.736C269.163 125.83 269.105 125.923 269.051 126.018C269.009 126.086 268.969 126.156 268.929 126.224C268.872 126.322 268.814 126.422 268.759 126.521L268.758 126.523C268.728 126.574 268.699 126.627 268.671 126.678C268.648 126.719 268.625 126.761 268.602 126.802C268.542 126.91 268.483 127.017 268.424 127.128C268.356 127.258 268.287 127.388 268.221 127.518C268.148 127.662 268.078 127.804 268.007 127.946C267.936 128.09 267.868 128.232 267.801 128.377C267.754 128.475 267.71 128.573 267.664 128.673C267.512 129.01 267.366 129.347 267.226 129.688C267.164 129.835 267.105 129.983 267.047 130.131C266.855 130.625 266.677 131.126 266.509 131.628L266.505 131.626C266.485 131.624 266.464 131.618 266.444 131.616C266.377 131.601 266.311 131.591 266.246 131.579C266.228 131.576 266.209 131.574 266.19 131.57C266.106 131.557 266.021 131.545 265.939 131.533C265.831 131.519 265.721 131.506 265.611 131.496C265.57 131.492 265.528 131.488 265.487 131.484C265.411 131.477 265.335 131.471 265.261 131.467C265.154 131.461 265.048 131.456 264.942 131.453C264.806 131.448 264.673 131.446 264.537 131.45C264.478 131.448 264.419 131.449 264.361 131.452C264.278 131.453 264.195 131.455 264.112 131.46C264.061 131.462 264.007 131.464 263.955 131.469C263.706 131.482 263.456 131.505 263.207 131.536C263.176 131.54 263.148 131.543 263.119 131.548C263.09 131.552 263.061 131.555 263.03 131.561C262.99 131.566 262.95 131.571 262.912 131.577C262.897 131.58 262.879 131.583 262.863 131.586C262.766 131.598 262.668 131.615 262.571 131.632C262.457 131.651 262.344 131.673 262.231 131.697C262.181 131.707 262.131 131.717 262.08 131.729C262.053 131.735 262.028 131.741 262 131.748C261.991 131.749 261.983 131.75 261.976 131.752C261.972 131.751 261.967 131.753 261.964 131.754C261.96 131.755 261.955 131.756 261.95 131.758C261.93 131.762 261.912 131.766 261.891 131.771C261.779 131.798 261.665 131.826 261.555 131.855C261.55 131.855 261.548 131.857 261.543 131.857C261.404 131.895 261.266 131.934 261.127 131.976C260.977 132.021 260.825 132.07 260.676 132.123C260.545 132.166 260.415 132.213 260.286 132.263C260.182 132.303 260.077 132.345 259.974 132.387C259.94 132.4 259.906 132.413 259.874 132.428C259.861 132.434 259.846 132.441 259.833 132.447L259.853 132.42L259.865 132.404L260.057 132.167L260.059 132.166L260.229 131.957L260.608 131.501L261.002 131.035L261.252 130.738L261.255 130.737L262.134 129.694C262.644 129.094 263.16 128.498 263.692 127.911C264.13 127.425 264.58 126.943 265.026 126.447C265.121 126.343 265.214 126.238 265.307 126.134C265.152 126.217 264.998 126.304 264.845 126.397C264.77 126.442 264.695 126.49 264.619 126.538C264.557 126.577 264.495 126.617 264.435 126.657C264.041 126.916 263.665 127.201 263.301 127.498C262.753 127.948 262.231 128.433 261.743 128.946C261.673 129.021 261.605 129.094 261.537 129.169C261.52 129.189 261.502 129.208 261.485 129.227C261.468 129.247 261.453 129.266 261.436 129.284C261.573 129.003 261.721 128.73 261.877 128.462C261.913 128.396 261.952 128.33 261.992 128.266C262.038 128.187 262.085 128.111 262.133 128.033C262.7 127.14 263.361 126.317 264.107 125.579C264.165 125.523 264.222 125.467 264.28 125.414C264.288 125.406 264.294 125.399 264.303 125.392C264.335 125.361 264.366 125.332 264.4 125.301C264.469 125.234 264.54 125.17 264.613 125.106C264.65 125.072 264.686 125.04 264.723 125.007C264.765 124.971 264.81 124.933 264.852 124.897C264.914 124.845 264.977 124.791 265.041 124.74C265.095 124.695 265.15 124.651 265.203 124.606C265.27 124.554 265.336 124.503 265.402 124.452C265.43 124.428 265.458 124.406 265.489 124.385L265.494 124.382C265.687 124.232 265.886 124.089 266.092 123.951C266.142 123.916 266.197 123.88 266.249 123.846C266.359 123.772 266.472 123.702 266.584 123.631C266.712 123.554 266.842 123.477 266.975 123.403C266.986 123.396 266.996 123.391 267.009 123.385C267.237 123.255 267.47 123.13 267.708 123.014C267.723 123.007 267.736 123.001 267.751 122.993C267.891 122.926 268.031 122.859 268.174 122.795C268.317 122.728 268.46 122.666 268.605 122.607C268.696 122.569 268.787 122.533 268.877 122.497C268.943 122.471 269.009 122.444 269.076 122.421C269.215 122.368 269.353 122.316 269.494 122.267C269.402 122.271 269.31 122.275 269.217 122.282C269.148 122.286 269.08 122.294 269.011 122.299C268.962 122.306 268.913 122.31 268.863 122.318C268.503 122.361 268.146 122.431 267.794 122.528C267.78 122.532 267.764 122.537 267.75 122.54C267.536 122.597 267.324 122.664 267.114 122.741C267.079 122.754 267.043 122.767 267.009 122.781C266.976 122.792 266.94 122.805 266.905 122.82C266.696 122.9 266.491 122.988 266.289 123.085C265.275 123.561 264.346 124.222 263.547 125.013C263.463 125.096 263.382 125.18 263.302 125.265C263.301 125.267 263.299 125.266 263.298 125.268C263.219 125.352 263.143 125.438 263.066 125.525C263.038 125.557 263.011 125.588 262.982 125.62C262.982 125.622 262.98 125.621 262.98 125.621C262.919 125.693 262.858 125.766 262.798 125.84C262.758 125.891 262.717 125.943 262.676 125.994C262.653 126.022 262.631 126.05 262.61 126.079C262.564 126.139 262.52 126.199 262.476 126.259C262.465 126.272 262.456 126.286 262.447 126.3C262.409 126.35 262.375 126.399 262.34 126.45C262.311 126.491 262.283 126.53 262.258 126.572C262.229 126.612 262.202 126.655 262.175 126.697C262.148 126.736 262.121 126.777 262.099 126.818C262.066 126.864 262.037 126.912 262.009 126.962C261.991 126.989 261.975 127.017 261.959 127.046C261.924 127.105 261.888 127.164 261.855 127.224C261.812 127.298 261.772 127.373 261.732 127.449C261.683 127.544 261.636 127.637 261.59 127.733C261.512 127.889 261.441 128.047 261.374 128.21C261.351 128.265 261.328 128.318 261.306 128.374C261.261 128.487 261.219 128.602 261.178 128.719C261.155 128.785 261.135 128.849 261.114 128.916C261.093 128.978 261.072 129.043 261.055 129.106C261.049 129.123 261.045 129.141 261.039 129.158C261.02 129.225 261 129.294 260.983 129.362C260.926 129.569 260.88 129.779 260.842 129.991C260.832 130.004 260.823 130.016 260.812 130.029C260.547 130.375 260.292 130.734 260.063 131.105L259.845 131.463L259.747 131.625L259.714 131.685L259.448 132.153L259.31 132.411L259.204 132.614L259.163 132.69C259.147 132.718 259.132 132.747 259.118 132.778C258.984 132.846 258.851 132.913 258.719 132.985C258.688 133.004 258.654 133.022 258.622 133.04C258.5 133.107 258.376 133.178 258.257 133.25C258.247 133.255 258.238 133.263 258.228 133.267C258.219 133.273 258.209 133.278 258.201 133.284C257.983 133.414 257.77 133.553 257.564 133.699C257.561 133.7 257.558 133.703 257.556 133.704L257.555 133.706C257.331 133.86 257.115 134.021 256.905 134.19C256.867 134.221 256.829 134.251 256.793 134.282C256.787 134.289 256.778 134.294 256.77 134.3L256.769 134.302C256.537 134.491 256.313 134.689 256.098 134.896L256.097 134.898C256.094 134.901 256.091 134.903 256.088 134.906C256.085 134.909 256.082 134.91 256.079 134.913C256.019 134.972 255.958 135.031 255.899 135.093C255.832 135.158 255.769 135.225 255.705 135.293C255.641 135.361 255.58 135.428 255.518 135.497C255.456 135.566 255.396 135.638 255.336 135.708C255.359 135.629 255.379 135.552 255.404 135.474C255.41 135.451 255.416 135.426 255.424 135.404L255.463 135.284L255.904 133.935C255.911 133.908 255.921 133.88 255.93 133.854C255.96 133.755 255.992 133.656 256.026 133.559L256.07 133.432C256.086 133.385 256.102 133.34 256.119 133.296C256.181 133.123 256.246 132.954 256.311 132.785C256.351 132.683 256.39 132.583 256.427 132.482C256.49 132.318 256.552 132.157 256.613 131.993C256.645 131.907 256.677 131.823 256.71 131.738C256.742 131.652 256.776 131.567 256.81 131.482C256.841 131.396 256.875 131.311 256.91 131.228L256.912 131.223C256.937 131.162 256.962 131.103 256.987 131.042L257.338 130.25L257.464 129.967L257.614 129.629C257.723 129.396 257.817 129.154 257.936 128.926L258.289 128.236C258.526 127.778 258.751 127.313 258.999 126.86L259.775 125.519C259.807 125.463 259.841 125.408 259.873 125.351C259.948 125.221 260.021 125.091 260.101 124.963C260.122 124.926 260.146 124.888 260.169 124.851L260.589 124.201C260.633 124.134 260.675 124.066 260.717 123.999C260.816 123.848 260.911 123.698 261.007 123.548C261.147 123.331 261.288 123.114 261.434 122.9L261.974 122.15C262.004 122.143 262.035 122.139 262.067 122.131C262.084 122.129 262.1 122.126 262.119 122.122C262.206 122.106 262.295 122.086 262.383 122.068C262.466 122.05 262.546 122.03 262.629 122.01C262.668 122.001 262.705 121.992 262.742 121.984C262.778 121.975 262.817 121.966 262.855 121.956C262.93 121.938 263.007 121.918 263.082 121.897C263.147 121.88 263.21 121.862 263.276 121.842C263.315 121.831 263.353 121.819 263.394 121.805C263.46 121.786 263.525 121.766 263.589 121.746C263.606 121.742 263.625 121.736 263.642 121.729C263.717 121.706 263.793 121.682 263.869 121.656C264.195 121.548 264.519 121.428 264.84 121.299C264.948 121.255 265.055 121.207 265.161 121.16C265.161 121.16 265.162 121.16 265.164 121.159C265.256 121.119 265.348 121.08 265.438 121.037C265.493 121.012 265.545 120.988 265.601 120.961C265.744 120.895 265.886 120.824 266.029 120.753L266.032 120.75C266.083 120.726 266.132 120.699 266.181 120.673C266.293 120.617 266.403 120.556 266.512 120.496C266.599 120.448 266.683 120.399 266.767 120.35C266.852 120.3 266.936 120.251 267.02 120.198C267.103 120.149 267.184 120.097 267.267 120.046C267.267 120.045 267.268 120.044 267.27 120.043C267.352 119.989 267.434 119.935 267.514 119.879C267.608 119.817 267.701 119.75 267.793 119.683C267.796 119.68 267.802 119.676 267.81 119.672C267.842 119.646 267.876 119.621 267.91 119.595C267.937 119.577 267.963 119.559 267.986 119.54C268.012 119.521 268.036 119.5 268.06 119.481C268.055 119.481 268.051 119.482 268.045 119.486L268.042 119.487C267.887 119.553 267.731 119.621 267.574 119.689C267.319 119.801 267.067 119.913 266.815 120.026C266.669 120.089 266.522 120.155 266.375 120.219C266.348 120.231 266.323 120.241 266.296 120.253C266.296 120.255 266.293 120.256 266.293 120.256C266.199 120.295 266.105 120.336 266.012 120.376C265.972 120.393 265.933 120.409 265.893 120.427C265.712 120.505 265.532 120.582 265.351 120.658C265.131 120.753 264.91 120.842 264.689 120.932C264.554 120.989 264.419 121.043 264.283 121.097C264.198 121.13 264.113 121.166 264.029 121.198L264.026 121.199C263.682 121.337 263.334 121.469 262.987 121.603C262.914 121.631 262.844 121.657 262.771 121.684C262.766 121.687 262.761 121.687 262.756 121.69C262.589 121.752 262.42 121.815 262.253 121.878C262.25 121.881 262.248 121.88 262.245 121.881C262.228 121.888 262.214 121.893 262.197 121.9C262.178 121.906 262.158 121.914 262.141 121.921L262.305 121.692L262.329 121.658L262.341 121.643C262.401 121.56 262.459 121.479 262.519 121.397C262.61 121.269 262.703 121.141 262.8 121.017L263.124 120.613L263.13 120.607L263.131 120.605L263.287 120.41C263.613 120.01 263.932 119.602 264.264 119.203L264.327 119.13L264.385 119.066L264.386 119.064L265.241 118.104L265.29 118.049L265.297 118.041C265.386 117.943 265.473 117.843 265.562 117.743C266.381 117.403 267.194 117.052 268.003 116.689C268.01 116.686 268.015 116.683 268.023 116.68C268.032 116.677 268.042 116.672 268.05 116.668C268.073 116.657 268.098 116.647 268.12 116.637C268.374 116.523 268.624 116.41 268.877 116.295C268.997 116.295 269.117 116.294 269.236 116.291C269.247 116.291 269.259 116.291 269.27 116.29C269.281 116.29 269.293 116.29 269.304 116.29C269.378 116.288 269.455 116.287 269.53 116.282C269.632 116.281 269.736 116.277 269.839 116.271C269.876 116.269 269.911 116.266 269.947 116.266L269.949 116.264C270.011 116.261 270.076 116.258 270.138 116.254C270.325 116.243 270.513 116.228 270.701 116.211C270.777 116.204 270.851 116.198 270.925 116.19C271.078 116.176 271.231 116.159 271.383 116.14C271.431 116.134 271.48 116.127 271.528 116.121C271.621 116.111 271.714 116.097 271.806 116.085C271.846 116.079 271.888 116.073 271.929 116.066C272.046 116.05 272.162 116.033 272.28 116.013C272.409 115.992 272.541 115.97 272.671 115.946L272.745 115.934L272.748 115.933C272.79 115.926 272.833 115.918 272.876 115.91C272.997 115.888 273.117 115.865 273.237 115.841L273.239 115.841C273.327 115.824 273.413 115.805 273.5 115.785C273.687 115.744 273.874 115.703 274.06 115.659C274.204 115.626 274.345 115.591 274.488 115.555C274.531 115.544 274.574 115.532 274.618 115.52C274.803 115.472 274.987 115.42 275.17 115.368C275.355 115.314 275.536 115.259 275.719 115.2C275.771 115.183 275.825 115.167 275.878 115.148C275.986 115.116 276.094 115.079 276.202 115.041C276.228 115.033 276.253 115.025 276.28 115.015C276.405 114.972 276.529 114.929 276.653 114.881C276.734 114.853 276.815 114.822 276.895 114.791C276.972 114.763 277.048 114.732 277.124 114.701C277.168 114.685 277.212 114.667 277.255 114.648C277.271 114.643 277.286 114.637 277.301 114.63C277.419 114.582 277.534 114.534 277.649 114.483C277.686 114.467 277.723 114.45 277.761 114.433C277.771 114.428 277.78 114.425 277.79 114.421C277.833 114.402 277.875 114.382 277.918 114.362L277.92 114.362C277.983 114.333 278.043 114.306 278.106 114.275C278.037 114.293 277.965 114.312 277.894 114.33C277.847 114.341 277.801 114.353 277.755 114.364C277.739 114.367 277.725 114.372 277.709 114.375C277.672 114.386 277.634 114.396 277.598 114.404C276.943 114.573 276.291 114.743 275.635 114.901C274.813 115.098 273.989 115.288 273.159 115.451C272.867 115.512 272.571 115.569 272.276 115.623C271.979 115.678 271.683 115.731 271.388 115.781C271.325 115.792 271.26 115.802 271.197 115.814C271.197 115.814 271.195 115.813 271.194 115.815C271.016 115.843 270.841 115.874 270.663 115.902C270.627 115.908 270.589 115.914 270.554 115.919C270.48 115.931 270.409 115.942 270.335 115.953C270.152 115.982 269.969 116.009 269.786 116.036C269.613 116.062 269.44 116.089 269.267 116.113C269.483 116.013 269.7 115.915 269.916 115.813C270.229 115.669 270.543 115.523 270.854 115.374C271.02 115.297 271.184 115.219 271.35 115.14C271.497 115.068 271.643 114.999 271.79 114.928C271.912 114.869 272.035 114.813 272.156 114.754L272.396 114.637L272.701 114.488L272.723 114.479L273.012 114.337L273.048 114.318L273.433 114.131L274.029 113.841C274.029 113.841 274.03 113.841 274.031 113.839L274.378 113.671C275.195 113.272 276.017 112.886 276.852 112.543C277.018 112.472 277.186 112.406 277.354 112.342C277.691 112.213 278.029 112.09 278.371 111.977C278.491 111.936 278.61 111.897 278.729 111.861C278.784 111.843 278.841 111.826 278.897 111.81C279.061 111.761 279.226 111.715 279.393 111.672C279.417 111.664 279.442 111.658 279.468 111.652C279.53 111.636 279.592 111.621 279.656 111.608C279.696 111.596 279.734 111.588 279.773 111.579C279.849 111.561 279.924 111.545 279.999 111.53C280.113 111.505 280.229 111.482 280.343 111.462C280.458 111.439 280.574 111.42 280.689 111.403C280.79 111.387 280.892 111.372 280.991 111.36C281.125 111.343 281.26 111.329 281.395 111.317C281.48 111.31 281.563 111.301 281.646 111.297C281.733 111.291 281.817 111.286 281.899 111.285C281.914 111.284 281.931 111.284 281.946 111.283C282.03 111.278 282.111 111.276 282.193 111.275C282.201 111.276 282.208 111.276 282.214 111.274C282.39 111.272 282.564 111.275 282.74 111.284C282.84 111.287 282.939 111.294 283.039 111.301C283.07 111.303 283.099 111.305 283.129 111.309C283.222 111.316 283.315 111.325 283.408 111.336C283.516 111.348 283.623 111.362 283.73 111.378C283.613 111.34 283.494 111.303 283.374 111.27C283.291 111.247 283.207 111.224 283.123 111.206C283.02 111.18 282.916 111.159 282.81 111.137C282.707 111.118 282.605 111.102 282.501 111.087C282.399 111.071 282.296 111.058 282.193 111.045C281.886 111.009 281.574 110.991 281.264 110.986C281.236 110.987 281.207 110.986 281.179 110.987C281.156 110.987 281.133 110.987 281.109 110.988C281.008 110.988 280.908 110.99 280.808 110.995C280.751 110.996 280.693 110.999 280.636 111.003C280.382 111.016 280.126 111.041 279.874 111.071C279.805 111.081 279.738 111.091 279.672 111.1C279.648 111.102 279.621 111.106 279.597 111.11C279.554 111.116 279.51 111.124 279.467 111.132C279.452 111.133 279.436 111.136 279.423 111.138C279.398 111.142 279.373 111.146 279.349 111.15C279.149 111.184 278.953 111.222 278.757 111.265C278.753 111.266 278.75 111.267 278.746 111.267C278.609 111.298 278.476 111.33 278.339 111.364C278.479 111.278 278.616 111.191 278.757 111.107C278.888 111.026 279.021 110.946 279.156 110.866C279.234 110.819 279.31 110.774 279.39 110.728L279.39 110.726C279.391 110.725 279.392 110.724 279.395 110.724C279.402 110.718 279.409 110.714 279.42 110.709C279.56 110.625 279.703 110.542 279.845 110.459C279.924 110.414 280.003 110.368 280.081 110.325C280.084 110.322 280.089 110.322 280.092 110.319C280.162 110.28 280.233 110.239 280.302 110.2C280.328 110.185 280.351 110.172 280.375 110.159C280.401 110.145 280.424 110.132 280.45 110.118C280.62 110.023 280.789 109.93 280.96 109.838C281.333 109.637 281.708 109.442 282.086 109.251C282.402 109.093 282.72 108.938 283.04 108.786L283.052 108.78C283.111 108.751 283.171 108.722 283.232 108.694C283.252 108.684 283.27 108.676 283.289 108.668C283.294 108.665 283.297 108.662 283.303 108.66L283.304 108.66C283.373 108.627 283.443 108.595 283.511 108.563C283.813 108.42 284.119 108.281 284.426 108.142C284.478 108.119 284.53 108.096 284.583 108.072L284.733 108.003C284.786 107.98 284.84 107.956 284.893 107.932C284.958 107.902 285.022 107.874 285.088 107.844C285.217 107.786 285.346 107.725 285.476 107.665C285.498 107.656 285.523 107.645 285.546 107.634C285.558 107.628 285.569 107.623 285.581 107.617C285.566 107.618 285.553 107.62 285.538 107.619C285.53 107.62 285.521 107.62 285.514 107.621C285.497 107.622 285.48 107.624 285.464 107.627C285.427 107.631 285.388 107.632 285.349 107.636C285.311 107.637 285.274 107.641 285.236 107.645C285.146 107.652 285.057 107.663 284.967 107.674C284.914 107.681 284.861 107.688 284.808 107.697C284.772 107.701 284.737 107.706 284.701 107.712C284.632 107.722 284.563 107.734 284.495 107.747C284.442 107.755 284.39 107.765 284.336 107.775C284.33 107.774 284.325 107.776 284.318 107.778C284.223 107.797 284.13 107.816 284.036 107.838C283.905 107.864 283.772 107.896 283.642 107.931C283.54 107.957 283.436 107.984 283.335 108.014C283.224 108.043 283.115 108.077 283.005 108.111C282.91 108.141 282.815 108.171 282.72 108.204C282.619 108.239 282.518 108.275 282.417 108.312C282.379 108.326 282.343 108.339 282.303 108.355L282.301 108.354C282.19 108.395 282.08 108.439 281.97 108.485C281.947 108.494 281.923 108.503 281.901 108.514C281.869 108.526 281.839 108.539 281.809 108.552C281.701 108.596 281.592 108.643 281.484 108.694C281.37 108.743 281.258 108.794 281.145 108.852C281.083 108.881 281.019 108.911 280.955 108.944C280.83 109.006 280.705 109.07 280.583 109.137C280.464 109.201 280.346 109.268 280.228 109.336C280.128 109.394 280.027 109.454 279.926 109.515C279.84 109.568 279.754 109.622 279.667 109.678C279.591 109.728 279.515 109.777 279.44 109.827C279.43 109.832 279.422 109.837 279.413 109.845C279.342 109.892 279.27 109.941 279.2 109.99C279.17 110.011 279.139 110.032 279.11 110.056C279.048 110.1 278.987 110.142 278.928 110.187C278.914 110.195 278.9 110.205 278.889 110.213C278.881 110.219 278.872 110.226 278.863 110.234C278.852 110.241 278.845 110.249 278.837 110.254C278.806 110.275 278.778 110.297 278.748 110.321C278.628 110.412 278.512 110.504 278.395 110.598C278.297 110.68 278.199 110.764 278.101 110.85C278.002 110.936 277.907 111.022 277.813 111.11C277.808 111.113 277.804 111.118 277.801 111.121C277.615 111.292 277.435 111.472 277.262 111.656C277.253 111.663 277.246 111.67 277.239 111.678C277.092 111.726 276.945 111.774 276.797 111.823C276.647 111.874 276.496 111.928 276.347 111.981C276.342 111.983 276.337 111.984 276.332 111.986C276.114 112.067 275.899 112.154 275.683 112.241C275.627 112.264 275.573 112.285 275.516 112.31C275.29 112.402 275.065 112.499 274.839 112.598L274.837 112.599C274.746 112.635 274.656 112.675 274.567 112.716C274.43 112.774 274.294 112.834 274.159 112.897C274.119 112.914 274.079 112.932 274.039 112.95C273.325 113.284 272.619 113.62 271.914 113.963C271.68 114.078 271.445 114.192 271.211 114.307C270.939 114.441 270.67 114.575 270.4 114.709C270.125 114.845 269.852 114.982 269.579 115.119C269.33 115.243 269.082 115.37 268.833 115.497C268.179 115.828 267.529 116.167 266.882 116.513C266.789 116.561 266.699 116.61 266.608 116.658L267.459 115.802L268.401 114.945L268.605 114.759L268.611 114.752L268.796 114.585L268.915 114.477L269.187 114.228L269.79 113.733L270.55 113.11L270.953 112.78L270.997 112.743L271.484 112.385L271.484 112.383L271.764 112.179L272.255 111.818L272.885 111.352L273.038 111.251L273.537 110.923L274.847 110.061L273.486 110.84L272.803 111.229L272.485 111.436L272.482 111.438L272.146 111.656L272.11 111.679L271.647 111.982L271.598 112.013L271.552 112.044L271.506 112.074L270.83 112.516L269.769 113.298L269.565 113.449L269.089 113.8L268.933 113.917C268.904 113.94 268.875 113.962 268.848 113.986C268.773 114.044 268.701 114.106 268.627 114.166C268.527 114.25 268.426 114.332 268.323 114.417L268.044 114.65L267.976 114.707C268.012 114.639 268.048 114.572 268.083 114.502C268.089 114.49 268.096 114.475 268.103 114.461C268.131 114.407 268.156 114.35 268.182 114.294C268.193 114.275 268.203 114.253 268.213 114.231C268.236 114.182 268.257 114.132 268.279 114.083C268.288 114.061 268.297 114.041 268.305 114.02C268.321 113.986 268.336 113.949 268.35 113.914C268.408 113.765 268.461 113.618 268.51 113.466C268.517 113.443 268.525 113.422 268.531 113.399C268.544 113.36 268.557 113.318 268.569 113.276C268.615 113.121 268.656 112.965 268.691 112.808C268.705 112.75 268.717 112.691 268.727 112.631C268.744 112.552 268.758 112.471 268.771 112.391C268.781 112.325 268.791 112.259 268.799 112.193C268.805 112.159 268.808 112.126 268.811 112.091C268.813 112.087 268.813 112.081 268.813 112.075C268.821 112.008 268.828 111.941 268.832 111.873C268.841 111.787 268.846 111.699 268.848 111.613C268.851 111.526 268.852 111.438 268.853 111.352C268.852 111.324 268.852 111.294 268.851 111.265C268.85 111.252 268.85 111.239 268.85 111.226C268.85 111.214 268.851 111.199 268.849 111.186C268.848 111.158 268.846 111.128 268.844 111.098C268.84 111.006 268.832 110.914 268.821 110.823C268.803 110.907 268.786 110.99 268.768 111.074C268.764 111.091 268.759 111.111 268.755 111.128C268.754 111.138 268.753 111.148 268.749 111.158C268.745 111.184 268.74 111.207 268.734 111.233C268.729 111.258 268.722 111.285 268.715 111.31C268.707 111.346 268.7 111.379 268.692 111.414C268.625 111.723 268.549 112.026 268.466 112.326C268.445 112.399 268.424 112.471 268.403 112.546C268.384 112.611 268.365 112.674 268.343 112.736C268.327 112.787 268.312 112.839 268.297 112.888C268.286 112.919 268.278 112.949 268.267 112.979C268.255 113.013 268.246 113.048 268.232 113.081C268.154 113.313 268.07 113.541 267.98 113.766C267.944 113.855 267.909 113.944 267.871 114.032C267.866 114.045 267.862 114.056 267.856 114.069C267.823 114.15 267.787 114.23 267.751 114.31C267.749 114.316 267.746 114.323 267.742 114.328C267.74 114.336 267.738 114.342 267.733 114.348C267.724 114.375 267.713 114.402 267.7 114.427C267.682 114.466 267.665 114.504 267.646 114.539C267.592 114.66 267.534 114.778 267.474 114.895C267.432 114.979 267.389 115.063 267.347 115.147C267.318 115.201 267.287 115.251 267.259 115.303L267.113 115.425L266.465 116.026C266.465 116.026 266.464 116.027 266.462 116.027L265.956 116.496L265.8 116.642L265.4 117.015L265.38 117.034C265.374 117.04 265.367 117.048 265.361 117.054C265.177 117.23 265.006 117.415 264.829 117.596L264.431 118.01L264.381 118.063L263.734 118.733C263.383 119.125 263.045 119.529 262.699 119.927L262.184 120.525C262.014 120.727 261.859 120.939 261.697 121.146L260.73 122.397C260.69 122.45 260.651 122.504 260.613 122.558C260.573 122.612 260.536 122.665 260.498 122.719C260.27 123.042 260.049 123.37 259.823 123.694L259.436 124.251L259.372 124.344C259.296 124.453 259.226 124.565 259.157 124.678C259.123 124.734 259.088 124.791 259.054 124.847C259.043 124.867 259.032 124.888 259.019 124.907C258.998 124.943 258.975 124.98 258.952 125.016L258.815 125.238L258.654 125.504L258.62 125.56C258.639 125.51 258.656 125.461 258.676 125.411C258.681 125.394 258.688 125.375 258.696 125.359L258.7 125.345C258.729 125.275 258.757 125.207 258.785 125.137L258.786 125.135C258.839 125.006 258.893 124.875 258.948 124.747C259.026 124.565 259.105 124.385 259.187 124.204C259.37 123.792 259.56 123.382 259.757 122.974C259.805 122.87 259.855 122.77 259.903 122.667C259.953 122.566 260 122.467 260.05 122.366C260.117 122.227 260.187 122.087 260.254 121.948C260.4 121.649 260.547 121.35 260.694 121.049C260.795 120.842 260.895 120.635 260.996 120.428C261.041 120.334 261.087 120.238 261.132 120.144C261.139 120.132 261.145 120.119 261.15 120.106C261.179 120.045 261.21 119.981 261.24 119.918C261.292 119.81 261.343 119.701 261.393 119.592C261.444 119.483 261.495 119.373 261.546 119.262C261.582 119.188 261.617 119.112 261.652 119.036C261.726 118.87 261.801 118.702 261.874 118.535C262.199 117.797 262.5 117.045 262.749 116.272C262.807 116.098 262.86 115.923 262.911 115.744C262.913 115.739 262.916 115.731 262.916 115.723C262.932 115.671 262.946 115.619 262.961 115.565L262.961 115.563C262.964 115.556 262.967 115.547 262.968 115.536C262.976 115.516 262.982 115.493 262.987 115.471C263.001 115.419 263.016 115.363 263.029 115.309C263.031 115.301 263.031 115.295 263.034 115.287L263.034 115.285C263.048 115.227 263.064 115.169 263.076 115.11C263.082 115.087 263.088 115.065 263.092 115.042C263.101 115.009 263.109 114.974 263.116 114.94C263.089 114.994 263.061 115.046 263.034 115.098C263.021 115.123 263.008 115.148 262.994 115.17C262.987 115.185 262.979 115.201 262.972 115.215C262.95 115.254 262.93 115.293 262.909 115.332C262.901 115.347 262.892 115.36 262.885 115.375C262.881 115.388 262.874 115.401 262.866 115.412C262.844 115.457 262.821 115.5 262.797 115.544C262.792 115.553 262.789 115.561 262.784 115.57C262.749 115.635 262.713 115.703 262.677 115.769C262.645 115.831 262.613 115.892 262.58 115.952C262.537 116.032 262.493 116.111 262.45 116.191C262.44 116.209 262.432 116.225 262.422 116.243C262.057 116.918 261.688 117.589 261.316 118.26C261.137 118.588 260.957 118.913 260.776 119.24C260.685 119.404 260.597 119.567 260.508 119.733C260.418 119.895 260.332 120.059 260.243 120.224L260.242 120.226C260.196 120.309 260.153 120.393 260.109 120.477C260.095 120.504 260.079 120.532 260.066 120.559C260.029 120.628 259.993 120.696 259.958 120.765C259.937 120.809 259.914 120.849 259.893 120.893C259.862 120.951 259.834 121.009 259.803 121.068C259.772 121.127 259.743 121.186 259.714 121.246C259.654 121.362 259.596 121.481 259.538 121.6C259.504 121.668 259.471 121.737 259.437 121.805C259.368 121.949 259.299 122.094 259.231 122.241C258.912 122.93 258.619 123.636 258.369 124.358C258.33 124.469 258.294 124.58 258.257 124.692C258.233 124.766 258.211 124.838 258.187 124.912C258.164 124.984 258.143 125.052 258.122 125.125L258.115 125.143C258.099 125.197 258.085 125.249 258.069 125.302C258.055 125.354 258.04 125.404 258.028 125.457C258.008 125.526 257.988 125.595 257.972 125.665C257.95 125.746 257.93 125.83 257.911 125.913C257.906 125.935 257.901 125.956 257.896 125.976C257.891 125.997 257.886 126.016 257.881 126.038C257.872 126.075 257.863 126.114 257.856 126.151C257.852 126.169 257.848 126.188 257.844 126.206C257.834 126.253 257.824 126.3 257.814 126.347C257.798 126.416 257.785 126.483 257.775 126.551C257.772 126.565 257.769 126.579 257.766 126.593L257.766 126.594C257.756 126.646 257.746 126.699 257.739 126.752C257.731 126.799 257.722 126.847 257.714 126.895C257.706 126.945 257.698 126.997 257.691 127.047L257.69 127.049C257.683 127.089 257.678 127.127 257.673 127.165C257.672 127.175 257.671 127.183 257.67 127.194C257.656 127.22 257.64 127.249 257.627 127.276C257.617 127.291 257.609 127.309 257.599 127.325C257.522 127.469 257.446 127.615 257.366 127.758C257.133 128.187 256.906 128.623 256.687 129.06C256.615 129.206 256.544 129.352 256.473 129.5C256.364 129.725 256.258 129.952 256.154 130.179C256.081 130.333 256.013 130.488 255.945 130.642C255.909 130.722 255.872 130.804 255.837 130.884C255.813 130.941 255.788 130.998 255.764 131.055L255.761 131.062C255.681 131.25 255.602 131.435 255.524 131.623C255.511 131.656 255.495 131.689 255.483 131.724C255.391 131.945 255.304 132.168 255.216 132.392C255.13 132.615 255.044 132.838 254.962 133.062C254.886 133.263 254.814 133.464 254.744 133.665C254.735 133.687 254.726 133.712 254.718 133.736L254.646 133.943C254.618 134.024 254.591 134.103 254.565 134.184C254.542 134.25 254.521 134.317 254.498 134.382C254.466 134.475 254.436 134.566 254.406 134.658L254.406 134.66C254.393 134.702 254.379 134.743 254.367 134.785C254.357 134.805 254.352 134.827 254.347 134.848L254.346 134.85C254.319 134.934 254.291 135.016 254.265 135.102L254.257 135.125C254.253 135.136 254.25 135.147 254.247 135.159C254.244 135.168 254.241 135.178 254.24 135.188C254.228 135.222 254.215 135.258 254.206 135.292L254.204 135.296C254.198 135.313 254.192 135.332 254.188 135.349C254.137 135.513 254.086 135.678 254.04 135.843C253.979 136.042 253.922 136.243 253.867 136.445C253.857 136.473 253.85 136.5 253.842 136.529L253.841 136.531C253.835 136.554 253.829 136.577 253.823 136.601C253.796 136.697 253.769 136.793 253.744 136.889C253.712 137.008 253.679 137.127 253.65 137.248C253.619 137.362 253.59 137.474 253.562 137.586L253.544 137.656C253.518 137.761 253.494 137.866 253.469 137.971C253.428 138.129 253.389 138.291 253.353 138.451C253.321 138.585 253.292 138.718 253.262 138.853C253.255 138.878 253.25 138.906 253.243 138.931C253.226 139.003 253.211 139.078 253.196 139.15C253.158 139.323 253.122 139.493 253.087 139.666C253.059 139.802 253.033 139.938 253.008 140.075C252.985 140.204 252.964 140.331 252.944 140.461C252.927 140.565 252.914 140.67 252.901 140.775C252.892 140.837 252.884 140.897 252.876 140.96C252.863 141.061 252.851 141.162 252.841 141.262C252.805 141.605 252.777 141.951 252.763 142.296C252.76 142.365 252.757 142.434 252.754 142.504L252.753 142.495L252.549 141.285C252.444 140.756 252.401 140.218 252.341 139.681L252.255 138.879C252.223 138.611 252.194 138.344 252.188 138.074L252.12 136.46L252.115 136.349L252.102 136.056L252.105 135.945L252.111 135.653L252.128 134.846C252.126 134.609 252.131 134.375 252.141 134.141C252.142 134.071 252.147 134.003 252.149 133.937L252.166 133.633C252.174 133.48 252.185 133.328 252.197 133.178C252.197 133.176 252.196 133.174 252.197 133.172C252.208 133.018 252.221 132.867 252.233 132.715C252.236 132.665 252.24 132.616 252.244 132.567C252.26 132.553 252.277 132.54 252.293 132.525C252.338 132.486 252.382 132.448 252.426 132.409C252.456 132.381 252.487 132.354 252.517 132.327C252.53 132.314 252.542 132.304 252.555 132.291C252.614 132.238 252.672 132.184 252.73 132.128C252.786 132.074 252.843 132.02 252.899 131.963C253.011 131.851 253.122 131.738 253.229 131.623C253.326 131.522 253.421 131.418 253.515 131.311C253.534 131.293 253.552 131.271 253.569 131.252C253.642 131.168 253.716 131.084 253.788 130.998C253.802 130.981 253.813 130.966 253.827 130.95C253.849 130.924 253.872 130.896 253.893 130.87L253.894 130.868C253.973 130.773 254.051 130.676 254.127 130.578C254.143 130.558 254.158 130.538 254.173 130.52C254.256 130.414 254.338 130.306 254.42 130.197C254.424 130.19 254.429 130.183 254.435 130.177C254.44 130.168 254.445 130.162 254.452 130.153C254.455 130.148 254.459 130.145 254.461 130.14L254.461 130.138C254.48 130.115 254.496 130.093 254.513 130.069L254.513 130.067C254.623 129.915 254.728 129.763 254.832 129.609C254.867 129.558 254.902 129.507 254.935 129.453C254.97 129.4 255.006 129.345 255.04 129.289C255.091 129.21 255.142 129.13 255.19 129.051L255.206 129.024C255.282 128.897 255.357 128.77 255.429 128.641L255.43 128.639C255.474 128.561 255.518 128.484 255.559 128.408C255.584 128.36 255.609 128.311 255.634 128.265C255.644 128.247 255.653 128.227 255.663 128.21C255.699 128.144 255.732 128.078 255.766 128.01L255.769 128.002C255.853 127.833 255.933 127.663 256.009 127.492C256.051 127.395 256.094 127.296 256.132 127.198C256.164 127.12 256.193 127.041 256.222 126.963C256.21 126.978 256.201 126.992 256.192 127.008C256.069 127.178 255.948 127.351 255.828 127.522C255.708 127.693 255.589 127.865 255.47 128.036L255.469 128.04C255.463 128.046 255.458 128.053 255.454 128.06C255.359 128.2 255.263 128.337 255.167 128.475C255.005 128.705 254.842 128.937 254.679 129.165L254.678 129.167C254.671 129.175 254.666 129.185 254.658 129.193C254.609 129.265 254.559 129.336 254.505 129.405L254.504 129.407C254.486 129.435 254.466 129.462 254.447 129.488C254.427 129.515 254.409 129.543 254.39 129.568C254.35 129.621 254.313 129.674 254.274 129.726C254.217 129.805 254.158 129.884 254.099 129.962C254.018 130.073 253.938 130.182 253.856 130.291L253.856 130.292C253.833 130.322 253.812 130.351 253.789 130.381C253.596 130.64 253.399 130.897 253.203 131.153C253.134 131.243 253.065 131.333 252.996 131.422C252.925 131.512 252.856 131.603 252.785 131.692C252.727 131.767 252.668 131.841 252.61 131.916C252.598 131.933 252.585 131.947 252.572 131.964C252.467 132.096 252.365 132.229 252.262 132.362C252.281 132.118 252.301 131.872 252.319 131.626C252.329 131.425 252.358 131.226 252.388 131.026C252.398 130.96 252.409 130.892 252.417 130.825L252.529 130.028L252.572 129.715L252.574 129.711L252.631 129.284L252.64 129.228C252.643 129.202 252.647 129.176 252.652 129.15L252.653 129.148C252.661 129.088 252.671 129.028 252.683 128.969C252.693 128.91 252.707 128.851 252.719 128.792C252.724 128.773 252.727 128.752 252.732 128.733C252.753 128.635 252.774 128.537 252.792 128.438L253.112 126.858C253.168 126.635 253.224 126.412 253.285 126.189C253.326 126.027 253.369 125.867 253.413 125.705C253.43 125.643 253.444 125.583 253.462 125.522C253.818 125.308 254.164 125.076 254.498 124.83C254.577 124.771 254.657 124.71 254.737 124.65C254.817 124.589 254.895 124.528 254.972 124.464C255.034 124.414 255.096 124.363 255.157 124.313C255.216 124.264 255.276 124.215 255.333 124.165C255.366 124.137 255.399 124.108 255.431 124.077C255.514 124.007 255.597 123.934 255.679 123.86C255.761 123.787 255.842 123.712 255.922 123.639C256.035 123.533 256.144 123.425 256.254 123.316C256.583 122.988 256.897 122.644 257.192 122.287C257.214 122.261 257.236 122.233 257.258 122.205C257.305 122.149 257.35 122.093 257.395 122.037C257.514 121.887 257.631 121.733 257.743 121.579C257.932 121.32 258.109 121.054 258.271 120.778C258.271 120.78 258.268 120.781 258.266 120.782C258.215 120.83 258.164 120.88 258.116 120.929C258.049 120.994 257.983 121.057 257.918 121.121C257.88 121.16 257.841 121.199 257.802 121.237L257.802 121.239C257.519 121.52 257.243 121.799 256.963 122.077C256.742 122.295 256.522 122.512 256.3 122.727C256.232 122.794 256.163 122.859 256.095 122.923C256.092 122.925 256.091 122.927 256.091 122.928C255.943 123.069 255.795 123.209 255.648 123.35C255.207 123.772 254.755 124.18 254.302 124.589C254.045 124.82 253.786 125.051 253.526 125.283L253.712 124.583L253.729 124.521L253.986 123.757C254.094 123.439 254.199 123.117 254.307 122.801C254.332 122.727 254.356 122.653 254.381 122.58L254.383 122.576C254.412 122.492 254.439 122.406 254.471 122.323L254.502 122.232L254.552 122.106L254.553 122.105L255.103 120.737L255.107 120.723C255.139 120.652 255.166 120.579 255.195 120.508L255.196 120.506C255.213 120.461 255.23 120.419 255.247 120.376C255.264 120.331 255.281 120.289 255.3 120.247C255.317 120.204 255.336 120.162 255.355 120.12C255.373 120.078 255.393 120.034 255.413 119.993L255.51 119.795L255.563 119.685L255.762 119.267L255.763 119.265L255.912 118.957L256.111 118.542C256.117 118.531 256.122 118.52 256.126 118.509L256.128 118.503C256.128 118.503 256.13 118.498 256.133 118.496L256.135 118.489C256.171 118.417 256.204 118.346 256.237 118.274C256.283 118.178 256.331 118.083 256.38 117.989C256.405 117.974 256.429 117.959 256.453 117.944C256.54 117.894 256.625 117.842 256.711 117.79C256.821 117.722 256.933 117.654 257.04 117.586L257.043 117.585C257.07 117.569 257.094 117.552 257.119 117.535C257.179 117.497 257.238 117.461 257.298 117.422C257.443 117.329 257.59 117.233 257.735 117.138C257.813 117.089 257.887 117.039 257.964 116.988C258.033 116.942 258.101 116.896 258.171 116.849C258.374 116.713 258.578 116.573 258.778 116.434C258.98 116.293 259.181 116.152 259.382 116.009C259.581 115.867 259.78 115.724 259.978 115.578C260.079 115.507 260.176 115.433 260.274 115.362C260.373 115.289 260.473 115.214 260.57 115.141C261.044 114.789 261.515 114.432 261.985 114.075C262.142 113.956 262.297 113.837 262.454 113.719C262.708 113.527 262.962 113.333 263.217 113.139C263.979 112.557 264.739 111.976 265.514 111.417C265.829 111.187 266.148 110.956 266.467 110.732L266.468 110.73C266.485 110.719 266.502 110.706 266.518 110.695C266.705 110.564 266.891 110.432 267.081 110.304C267.286 110.163 267.492 110.024 267.702 109.888L267.702 109.886C267.724 109.872 267.744 109.858 267.765 109.844C267.902 109.755 268.04 109.666 268.18 109.577C268.338 109.474 268.499 109.372 268.663 109.273C268.851 109.155 269.041 109.042 269.231 108.927C269.335 108.931 269.438 108.933 269.54 108.935C269.845 108.941 270.149 108.939 270.455 108.932C270.459 108.931 270.463 108.933 270.468 108.932C270.563 108.931 270.657 108.928 270.753 108.923C270.883 108.918 271.013 108.913 271.142 108.907C271.146 108.906 271.153 108.906 271.157 108.906C271.372 108.894 271.581 108.878 271.796 108.86C271.811 108.859 271.827 108.858 271.842 108.857C271.935 108.849 272.031 108.84 272.125 108.829C272.236 108.819 272.346 108.806 272.455 108.795L272.457 108.794C272.47 108.792 272.486 108.791 272.499 108.789C272.768 108.76 273.037 108.726 273.305 108.686C273.477 108.659 273.648 108.632 273.819 108.603C273.932 108.585 274.043 108.563 274.155 108.545C274.155 108.543 274.157 108.543 274.157 108.543L274.239 108.527C274.27 108.523 274.299 108.517 274.329 108.51C274.597 108.46 274.863 108.403 275.128 108.343C275.133 108.342 275.135 108.341 275.14 108.34C275.145 108.338 275.151 108.338 275.155 108.338C275.196 108.329 275.236 108.319 275.275 108.307C275.337 108.293 275.399 108.279 275.462 108.262C275.468 108.263 275.475 108.261 275.482 108.259C275.517 108.25 275.551 108.241 275.586 108.232L275.711 108.199C275.748 108.191 275.783 108.182 275.817 108.173C276.052 108.111 276.282 108.048 276.513 107.978C276.628 107.944 276.744 107.908 276.859 107.873C276.973 107.836 277.087 107.798 277.201 107.76C277.352 107.709 277.503 107.656 277.652 107.602C277.7 107.583 277.751 107.565 277.8 107.546C277.863 107.522 277.926 107.497 277.99 107.473C278.077 107.44 278.163 107.404 278.249 107.369C277.977 107.424 277.708 107.478 277.438 107.534C277.089 107.605 276.742 107.676 276.394 107.743C276.394 107.745 276.392 107.744 276.392 107.744C276.177 107.786 275.962 107.829 275.748 107.869C275.683 107.882 275.618 107.893 275.552 107.906C275.496 107.916 275.44 107.926 275.384 107.936C275.327 107.946 275.271 107.958 275.215 107.966L275.181 107.973C275.053 107.996 274.927 108.02 274.799 108.041C274.748 108.051 274.694 108.059 274.642 108.069C274.604 108.075 274.568 108.083 274.53 108.087C274.102 108.162 273.674 108.23 273.246 108.293C273.037 108.325 272.824 108.355 272.614 108.385C272.587 108.388 272.558 108.393 272.532 108.397C272.516 108.4 272.499 108.4 272.483 108.403C272.381 108.418 272.277 108.431 272.174 108.443C272.123 108.451 272.072 108.459 272.02 108.464C271.969 108.471 271.918 108.477 271.865 108.484C271.849 108.487 271.832 108.487 271.817 108.488C271.623 108.514 271.43 108.535 271.237 108.558C271.231 108.558 271.225 108.561 271.219 108.561C271.056 108.58 270.892 108.599 270.73 108.617C270.684 108.622 270.636 108.626 270.59 108.631C270.584 108.631 270.577 108.633 270.571 108.633C270.547 108.635 270.52 108.639 270.496 108.641C270.293 108.661 270.092 108.682 269.89 108.7C269.778 108.712 269.667 108.722 269.556 108.734C269.98 108.489 270.41 108.253 270.845 108.031C270.865 108.021 270.886 108.009 270.906 107.999C270.984 107.959 271.063 107.919 271.139 107.88C271.228 107.837 271.317 107.794 271.406 107.751C271.477 107.717 271.548 107.682 271.621 107.646C271.701 107.609 271.783 107.57 271.865 107.533C271.883 107.524 271.9 107.518 271.917 107.509C271.943 107.497 271.968 107.484 271.993 107.474C272.156 107.398 272.32 107.324 272.486 107.253C272.508 107.244 272.531 107.235 272.553 107.226C272.892 107.078 273.237 106.941 273.584 106.81C273.697 106.768 273.816 106.724 273.93 106.684C274.046 106.642 274.163 106.603 274.28 106.564C274.493 106.49 274.706 106.421 274.922 106.357C275.04 106.32 275.159 106.283 275.277 106.25C275.298 106.245 275.317 106.239 275.338 106.232C275.392 106.217 275.448 106.2 275.505 106.184C275.517 106.18 275.53 106.178 275.542 106.174C275.558 106.169 275.572 106.165 275.588 106.162C275.93 106.068 276.275 105.986 276.624 105.913C276.664 105.903 276.704 105.896 276.745 105.887C276.755 105.884 276.765 105.884 276.775 105.881C276.888 105.857 277.001 105.837 277.113 105.817C277.117 105.816 277.122 105.814 277.126 105.815C277.147 105.809 277.17 105.805 277.192 105.802C277.304 105.782 277.414 105.763 277.526 105.747C277.526 105.747 277.527 105.745 277.529 105.746C277.634 105.728 277.74 105.714 277.846 105.7C277.938 105.685 278.03 105.673 278.124 105.663C278.23 105.65 278.336 105.636 278.442 105.626C278.582 105.611 278.721 105.599 278.862 105.588C279 105.577 279.141 105.567 279.282 105.561C279.419 105.554 279.557 105.549 279.693 105.546C279.715 105.545 279.734 105.545 279.753 105.543C279.876 105.542 279.999 105.54 280.12 105.542C280.129 105.541 280.139 105.542 280.148 105.541C280.258 105.541 280.368 105.544 280.479 105.546C280.502 105.546 280.525 105.547 280.547 105.549C280.585 105.549 280.623 105.55 280.66 105.552C280.76 105.555 280.862 105.561 280.962 105.568C281.039 105.572 281.115 105.577 281.19 105.584C281.23 105.585 281.271 105.589 281.312 105.593C281.374 105.597 281.436 105.604 281.499 105.611C281.549 105.614 281.599 105.621 281.648 105.627C281.721 105.633 281.793 105.641 281.865 105.652C281.986 105.666 282.107 105.683 282.227 105.701C282.333 105.717 282.44 105.735 282.548 105.753C282.599 105.763 282.653 105.773 282.704 105.782C282.825 105.805 282.945 105.828 283.066 105.855C283.019 105.839 282.971 105.82 282.924 105.804C282.811 105.765 282.698 105.728 282.583 105.694C282.558 105.686 282.536 105.678 282.511 105.671C282.448 105.651 282.383 105.633 282.319 105.617C282.258 105.598 282.196 105.581 282.136 105.566C281.999 105.53 281.863 105.497 281.726 105.468C281.646 105.449 281.567 105.432 281.487 105.417C281.461 105.411 281.436 105.406 281.409 105.403C281.324 105.386 281.24 105.369 281.154 105.355C281.027 105.334 280.898 105.312 280.769 105.295L280.763 105.293C280.755 105.292 280.747 105.291 280.739 105.291C280.733 105.289 280.729 105.289 280.723 105.287C280.703 105.284 280.681 105.281 280.66 105.28C280.543 105.265 280.428 105.25 280.312 105.24C280.196 105.227 280.08 105.216 279.963 105.207C279.73 105.187 279.498 105.176 279.265 105.169C278.983 105.162 278.704 105.165 278.423 105.174C278.141 105.184 277.861 105.203 277.581 105.227C277.557 105.23 277.531 105.231 277.507 105.234C277.431 105.239 277.357 105.247 277.28 105.254C277.27 105.255 277.258 105.257 277.248 105.257C277.215 105.261 277.18 105.265 277.146 105.271C276.725 105.319 276.307 105.384 275.89 105.467C275.775 105.489 275.66 105.512 275.545 105.539C275.521 105.542 275.498 105.548 275.475 105.553C275.448 105.558 275.42 105.566 275.393 105.571C275.386 105.573 275.379 105.575 275.372 105.576C275.356 105.579 275.341 105.582 275.324 105.587C275.302 105.59 275.279 105.597 275.256 105.601C274.939 105.671 274.626 105.754 274.317 105.843C274.254 105.861 274.193 105.878 274.132 105.896C274.219 105.809 274.308 105.724 274.395 105.636C274.628 105.426 274.856 105.21 275.084 104.997C275.325 104.796 275.558 104.586 275.794 104.379C275.901 104.288 276.008 104.199 276.119 104.111C276.181 104.059 276.245 104.007 276.309 103.958C276.416 103.873 276.524 103.788 276.633 103.703C277.046 103.544 277.469 103.412 277.897 103.312C277.993 103.291 278.091 103.27 278.186 103.25C278.256 103.236 278.328 103.223 278.398 103.212C278.432 103.205 278.465 103.199 278.499 103.194C278.566 103.182 278.633 103.171 278.701 103.163C278.711 103.16 278.72 103.159 278.728 103.158C278.879 103.136 279.03 103.119 279.182 103.106C279.268 103.096 279.352 103.09 279.436 103.085C279.478 103.08 279.52 103.078 279.563 103.078C279.623 103.074 279.683 103.071 279.742 103.071C279.805 103.067 279.868 103.066 279.93 103.064C280.036 103.063 280.141 103.064 280.245 103.066C281.031 103.078 281.817 103.192 282.581 103.394C282.793 103.45 283.005 103.515 283.211 103.589C283.291 103.617 283.374 103.648 283.453 103.677C283.539 103.709 283.625 103.743 283.711 103.779C283.804 103.816 283.894 103.853 283.984 103.895C284.258 104.016 284.526 104.149 284.791 104.295C284.715 104.229 284.636 104.165 284.556 104.104C284.231 103.852 283.877 103.633 283.505 103.449C283.415 103.405 283.325 103.361 283.232 103.321C283.05 103.238 282.863 103.165 282.672 103.099C281.898 102.824 281.076 102.687 280.252 102.668C279.428 102.658 278.6 102.768 277.816 103.013C277.812 103.014 277.809 103.015 277.804 103.018C277.65 103.066 277.498 103.118 277.346 103.177C277.453 103.102 277.56 103.03 277.667 102.957C277.731 102.912 277.796 102.869 277.864 102.827C277.994 102.742 278.125 102.657 278.257 102.574C278.308 102.541 278.359 102.509 278.41 102.478C278.565 102.384 278.721 102.293 278.877 102.201C279.088 102.079 279.304 101.964 279.521 101.85C279.436 101.911 279.354 101.973 279.274 102.038C279.996 101.671 280.745 101.392 281.517 101.213C282.288 101.038 283.076 100.951 283.864 100.969C284.652 100.979 285.437 101.093 286.202 101.298C286.312 101.327 286.419 101.358 286.527 101.391C286.663 101.432 286.796 101.478 286.931 101.527C287.064 101.575 287.198 101.626 287.329 101.68C287.421 101.716 287.513 101.756 287.604 101.796C287.681 101.83 287.758 101.864 287.833 101.901C287.943 101.954 288.055 102.008 288.165 102.067C288.25 102.109 288.331 102.154 288.414 102.2C288.274 102.079 288.128 101.966 287.977 101.861C287.93 101.825 287.882 101.794 287.834 101.762C287.768 101.716 287.699 101.671 287.628 101.63C287.571 101.593 287.513 101.56 287.453 101.527C287.432 101.513 287.411 101.502 287.388 101.489C287.301 101.441 287.212 101.395 287.123 101.349C287.038 101.307 286.951 101.266 286.865 101.228C286.678 101.142 286.487 101.068 286.293 101C285.516 100.727 284.694 100.589 283.871 100.571C283.676 100.569 283.483 100.573 283.288 100.586C283.145 100.593 283 100.604 282.857 100.622C282.857 100.622 282.855 100.621 282.853 100.623C282.686 100.641 282.519 100.667 282.353 100.696C282.189 100.725 282.023 100.76 281.86 100.8C282.015 100.742 282.169 100.68 282.327 100.625L283.233 100.327L284.153 100.073L284.366 100.022L285.087 99.853L286.03 99.6768L285.07 99.7482L284.113 99.8732L283.163 100.056L282.331 100.256L282.221 100.283C282.188 100.293 282.157 100.303 282.124 100.313C282.2 100.246 282.274 100.179 282.346 100.11C282.362 100.094 282.377 100.08 282.391 100.066C282.466 99.9952 282.537 99.9248 282.606 99.8524C282.965 99.4672 283.29 99.0468 283.558 98.5944C283.772 98.2389 283.953 97.8635 284.088 97.4744C284.117 97.3897 284.144 97.3062 284.169 97.2225C284.174 97.2011 284.182 97.1786 284.188 97.1572C283.898 97.5917 283.61 98.0163 283.301 98.421C283.146 98.6223 282.987 98.82 282.824 99.0137C282.659 99.2072 282.49 99.3973 282.316 99.5789C281.994 99.9242 281.648 100.249 281.29 100.563C280.368 100.864 279.467 101.24 278.594 101.673C278.156 101.892 277.728 102.133 277.306 102.383C277.296 102.388 277.285 102.393 277.277 102.398C277.307 102.33 277.336 102.265 277.365 102.194C277.375 102.171 277.385 102.147 277.394 102.122L277.448 101.983C277.472 101.92 277.494 101.858 277.516 101.796C277.522 101.777 277.529 101.756 277.534 101.737C277.555 101.675 277.576 101.61 277.594 101.547C277.611 101.489 277.627 101.432 277.643 101.374C277.677 101.251 277.705 101.128 277.731 101.004C277.745 100.946 277.756 100.889 277.766 100.829C277.772 100.801 277.778 100.772 277.781 100.744C277.791 100.69 277.8 100.634 277.809 100.58C277.817 100.526 277.825 100.472 277.831 100.417C277.839 100.363 277.846 100.308 277.852 100.254C277.904 99.7281 277.909 99.197 277.848 98.6745C277.825 98.4726 277.792 98.2698 277.75 98.0697C277.742 98.0268 277.732 97.9832 277.722 97.9396C277.704 97.8575 277.683 97.7766 277.658 97.6963C277.628 97.5889 277.595 97.4827 277.558 97.3793C277.553 97.3566 277.544 97.3325 277.534 97.3078C277.516 97.2553 277.497 97.2022 277.475 97.1503C277.478 97.219 277.483 97.2902 277.488 97.3614C277.497 97.5228 277.507 97.6819 277.513 97.842C277.519 97.9409 277.521 98.0367 277.526 98.1328C277.533 98.3206 277.537 98.5073 277.536 98.6925C277.535 99.2017 277.513 99.708 277.456 100.211C277.408 100.714 277.321 101.215 277.218 101.712C277.194 101.822 277.169 101.931 277.141 102.042C277.116 102.151 277.089 102.261 277.059 102.371C277.044 102.431 277.029 102.493 277.013 102.553C277.008 102.555 277.004 102.559 276.999 102.561C276.975 102.576 276.951 102.591 276.929 102.606C276.804 102.681 276.681 102.76 276.559 102.84C276.122 103.123 275.696 103.423 275.281 103.743C275.03 103.951 274.776 104.157 274.529 104.371C274.289 104.593 274.05 104.816 273.816 105.046C273.593 105.284 273.369 105.523 273.152 105.766L272.841 106.145L272.762 106.239C272.737 106.27 272.709 106.301 272.696 106.345C272.695 106.355 272.694 106.368 272.692 106.38C272.627 106.405 272.561 106.429 272.497 106.455C272.471 106.465 272.444 106.477 272.417 106.486C272.266 106.544 272.119 106.605 271.971 106.667C271.963 106.668 271.955 106.671 271.947 106.675C271.93 106.684 271.911 106.69 271.893 106.698C271.824 106.725 271.756 106.752 271.689 106.782C270.812 107.162 269.96 107.593 269.133 108.067C269.049 108.114 268.967 108.163 268.883 108.21C268.883 108.211 268.882 108.212 268.88 108.213C268.796 108.262 268.711 108.31 268.629 108.359L268.628 108.361C268.498 108.438 268.37 108.516 268.242 108.594C268.081 108.696 267.919 108.799 267.757 108.906C267.595 109.01 267.436 109.117 267.276 109.224C267.271 109.226 267.268 109.229 267.265 109.232C267.106 109.337 266.952 109.444 266.794 109.551C266.395 109.83 265.999 110.112 265.608 110.402C265.427 110.537 265.247 110.672 265.067 110.81C264.811 111.006 264.557 111.204 264.305 111.403C264.261 111.438 264.215 111.473 264.174 111.507C263.915 111.712 263.659 111.918 263.404 112.125C263.402 112.125 263.401 112.126 263.401 112.128C263.175 112.31 262.952 112.492 262.73 112.676C262.508 112.86 262.288 113.046 262.068 113.232C261.577 113.644 261.088 114.057 260.6 114.469C260.114 114.882 259.625 115.294 259.136 115.703C259.127 115.711 259.117 115.72 259.107 115.727C258.989 115.827 258.871 115.925 258.753 116.023C258.538 116.201 258.324 116.38 258.107 116.557C257.974 116.665 257.842 116.773 257.71 116.881C257.666 116.916 257.622 116.954 257.578 116.989C257.226 117.276 256.871 117.559 256.511 117.838C256.481 117.862 256.453 117.884 256.424 117.907C256.44 117.877 256.457 117.847 256.476 117.818L256.514 117.749L256.57 117.648L256.943 116.986L257.264 116.412C257.279 116.384 257.295 116.355 257.311 116.327C257.335 116.283 257.359 116.236 257.383 116.192L257.46 116.061C257.666 115.715 257.899 115.385 258.114 115.045L258.552 114.369L258.771 114.03L259.013 113.71L259.617 112.904L259.796 112.665L259.981 112.42C260.12 112.224 260.274 112.037 260.428 111.852C260.444 111.831 260.462 111.809 260.48 111.788C260.521 111.737 260.561 111.686 260.604 111.635C260.615 111.622 260.626 111.609 260.637 111.596L260.639 111.595C260.694 111.527 260.75 111.458 260.809 111.392C260.87 111.319 260.936 111.245 260.999 111.172C261.358 110.755 261.731 110.35 262.112 109.955C262.438 109.914 262.762 109.848 263.078 109.757C263.459 109.649 263.829 109.506 264.184 109.336C264.243 109.306 264.303 109.279 264.362 109.248C264.423 109.219 264.482 109.189 264.539 109.158C264.684 109.08 264.826 108.994 264.964 108.905C265.104 108.817 265.239 108.725 265.372 108.627C265.531 108.51 265.685 108.387 265.833 108.257C265.89 108.207 265.948 108.155 266.002 108.102C266.039 108.069 266.076 108.035 266.11 107.999C266.163 107.949 266.212 107.899 266.261 107.849C266.327 107.779 266.393 107.707 266.455 107.636C266.519 107.561 266.581 107.486 266.641 107.41C266.683 107.357 266.722 107.303 266.763 107.248C266.8 107.193 266.84 107.139 266.877 107.083C266.763 107.174 266.65 107.263 266.536 107.35C266.445 107.422 266.354 107.491 266.262 107.56C266.059 107.715 265.851 107.866 265.643 108.011C265.223 108.297 264.794 108.568 264.349 108.807C263.906 109.053 263.447 109.267 262.975 109.464C262.843 109.519 262.71 109.572 262.575 109.622C262.505 109.648 262.432 109.676 262.362 109.702C262.453 109.611 262.543 109.521 262.635 109.432C262.805 109.264 262.976 109.098 263.152 108.936C263.24 108.854 263.327 108.773 263.416 108.692C263.727 108.408 264.048 108.134 264.375 107.866C264.434 107.815 264.496 107.767 264.558 107.719C264.633 107.656 264.709 107.594 264.787 107.535C264.792 107.531 264.799 107.524 264.808 107.521C264.814 107.517 264.82 107.513 264.823 107.51C264.832 107.502 264.841 107.495 264.849 107.489C264.883 107.463 264.916 107.436 264.95 107.41L264.953 107.409C265.212 107.209 265.477 107.016 265.746 106.827C265.912 106.708 266.081 106.592 266.251 106.478C266.393 106.384 266.535 106.29 266.68 106.199C266.681 106.197 266.685 106.197 266.685 106.197C266.755 106.153 266.823 106.109 266.893 106.066C266.926 106.044 266.963 106.023 266.997 106.003C266.997 106.001 266.999 106.002 266.999 106.002C267 106 267.001 105.998 267.004 105.999C267.128 105.924 267.252 105.852 267.378 105.779C267.498 105.707 267.621 105.638 267.744 105.572C267.89 105.492 268.035 105.416 268.182 105.34C268.24 105.31 268.298 105.281 268.354 105.252C268.48 105.188 268.606 105.127 268.731 105.07C268.737 105.065 268.745 105.062 268.75 105.059C268.861 105.005 268.974 104.953 269.088 104.903C269.426 104.753 269.771 104.609 270.12 104.477C270.208 104.444 270.294 104.413 270.381 104.382C270.468 104.349 270.556 104.319 270.644 104.29C270.731 104.259 270.817 104.23 270.904 104.203C271.114 104.133 271.323 104.069 271.536 104.009C271.353 104.049 271.172 104.092 270.991 104.14C270.624 104.233 270.26 104.342 269.902 104.462C269.794 104.499 269.687 104.535 269.581 104.574C269.473 104.613 269.367 104.652 269.262 104.694C269.156 104.733 269.05 104.776 268.945 104.817C268.904 104.835 268.864 104.852 268.823 104.866C268.812 104.872 268.801 104.875 268.791 104.88C268.76 104.895 268.729 104.907 268.697 104.921C268.571 104.974 268.445 105.027 268.32 105.085C268.258 105.112 268.195 105.141 268.134 105.17C268.047 105.208 267.961 105.249 267.874 105.293C267.817 105.319 267.76 105.348 267.704 105.375C267.59 105.431 267.478 105.489 267.367 105.547C267.277 105.594 267.187 105.64 267.099 105.687C266.998 105.741 266.899 105.797 266.8 105.851C266.775 105.863 266.749 105.878 266.726 105.891C266.714 105.899 266.701 105.905 266.686 105.913C266.625 105.949 266.563 105.984 266.504 106.02C266.481 106.031 266.459 106.045 266.44 106.057C266.298 106.139 266.159 106.223 266.021 106.308C265.873 106.398 265.728 106.49 265.581 106.585C265.426 106.687 265.274 106.79 265.124 106.896C265.05 106.946 264.975 106.998 264.906 107.05C264.823 107.107 264.741 107.166 264.662 107.226C264.587 107.278 264.515 107.331 264.444 107.386C264.333 107.468 264.224 107.552 264.114 107.638C264.057 107.682 264.002 107.726 263.946 107.772L263.941 107.774C263.857 107.84 263.774 107.908 263.691 107.976L263.689 107.977C263.675 107.987 263.66 107.999 263.647 108.011C263.527 108.111 263.406 108.21 263.287 108.31C263.153 108.423 263.023 108.538 262.892 108.655C262.761 108.772 262.63 108.888 262.503 109.007C262.373 109.126 262.247 109.244 262.121 109.365C262.011 109.47 261.903 109.576 261.795 109.681C261.766 109.709 261.737 109.739 261.708 109.767C261.596 109.878 261.485 109.989 261.376 110.103C261.253 110.229 261.133 110.354 261.014 110.481C260.894 110.608 260.776 110.735 260.657 110.865C260.471 111.066 260.29 111.268 260.114 111.477C260.037 111.564 259.963 111.651 259.888 111.739C259.85 111.783 259.813 111.827 259.777 111.872C259.742 111.912 259.709 111.953 259.677 111.995C259.674 111.998 259.67 112.003 259.667 112.006C259.641 112.039 259.614 112.072 259.59 112.106L259.483 112.246L258.905 112.994L258.903 112.995L258.727 113.222L258.591 113.401L258.34 113.724L258.306 113.774L258.112 114.064L257.858 114.446L257.848 114.462L257.659 114.745C257.585 114.861 257.508 114.973 257.432 115.086C257.355 115.198 257.279 115.313 257.202 115.425C257.051 115.653 256.906 115.885 256.776 116.124L255.966 117.545C255.932 117.598 255.903 117.654 255.875 117.709C255.865 117.725 255.857 117.741 255.85 117.757C255.827 117.8 255.805 117.843 255.784 117.886C255.72 118.016 255.66 118.147 255.594 118.276L255.549 118.37L255.548 118.371L255.411 118.652L255.238 119.011L254.881 119.749C254.864 119.779 254.849 119.81 254.836 119.841C254.821 119.872 254.808 119.903 254.794 119.934C254.712 120.12 254.641 120.313 254.561 120.502L253.945 122.017C253.896 122.152 253.849 122.285 253.802 122.421C253.738 122.607 253.675 122.795 253.612 122.982C253.571 123.107 253.529 123.234 253.49 123.359C253.467 123.423 253.447 123.49 253.426 123.554C253.409 123.616 253.39 123.677 253.372 123.736C253.332 123.861 253.294 123.989 253.257 124.115C253.226 124.218 253.193 124.323 253.163 124.428C253.131 124.533 253.102 124.636 253.073 124.742C253.065 124.766 253.058 124.792 253.051 124.819C252.991 125.035 252.932 125.253 252.875 125.471C252.816 125.697 252.758 125.926 252.704 126.153C252.655 126.355 252.607 126.56 252.562 126.763C252.554 126.788 252.549 126.814 252.544 126.839L252.543 126.841C252.524 126.921 252.508 127 252.49 127.08C252.486 127.099 252.482 127.121 252.478 127.141L252.477 127.142C252.476 127.146 252.474 127.152 252.474 127.156L252.47 127.168C252.464 127.197 252.459 127.225 252.454 127.252C252.447 127.284 252.44 127.315 252.434 127.347C252.421 127.408 252.409 127.467 252.397 127.526C252.384 127.58 252.374 127.634 252.364 127.687C252.34 127.803 252.317 127.919 252.296 128.034C252.267 128.178 252.243 128.323 252.216 128.468C252.166 128.751 252.117 129.036 252.074 129.32C252.007 129.762 251.948 130.207 251.896 130.653L251.895 130.656C251.895 130.663 251.893 130.668 251.892 130.675L251.891 130.678C251.875 130.81 251.862 130.94 251.849 131.072C251.836 131.213 251.822 131.351 251.809 131.492C251.797 131.631 251.786 131.773 251.773 131.912C251.762 132.053 251.754 132.193 251.743 132.333C251.735 132.473 251.725 132.615 251.719 132.754C251.703 133.039 251.691 133.324 251.684 133.61C251.678 133.747 251.676 133.883 251.674 134.021C251.674 134.046 251.673 134.073 251.674 134.099C251.672 134.263 251.673 134.425 251.673 134.59C251.672 134.671 251.673 134.754 251.674 134.836L251.677 135.652L251.679 136.059L251.706 136.467L251.818 138.096C251.821 138.19 251.829 138.281 251.838 138.372C251.838 138.379 251.84 138.386 251.84 138.392C251.848 138.477 251.859 138.561 251.87 138.644C251.88 138.732 251.894 138.819 251.905 138.907L251.927 139.071C251.909 139.012 251.893 138.954 251.875 138.897C251.844 138.787 251.812 138.679 251.78 138.571C251.764 138.517 251.747 138.463 251.732 138.409C251.676 138.225 251.62 138.042 251.56 137.861C251.343 137.164 251.09 136.485 250.864 135.8C250.767 135.515 250.67 135.231 250.576 134.948C250.55 134.865 250.524 134.782 250.496 134.699C250.457 134.578 250.42 134.455 250.383 134.333C250.37 134.297 250.358 134.259 250.349 134.222C250.341 134.197 250.333 134.171 250.326 134.145C250.285 134.013 250.248 133.882 250.212 133.751C250.144 133.519 250.082 133.287 250.026 133.053C250.004 132.959 249.984 132.865 249.963 132.772C249.94 132.669 249.92 132.568 249.9 132.464C249.898 132.457 249.898 132.451 249.896 132.444C249.89 132.412 249.882 132.38 249.877 132.346C249.876 132.344 249.875 132.339 249.875 132.335C249.869 132.31 249.865 132.283 249.86 132.256C249.843 132.16 249.828 132.064 249.811 131.966C249.809 131.954 249.806 131.943 249.804 131.93L249.805 131.928C249.792 131.845 249.78 131.763 249.768 131.681C249.754 131.594 249.742 131.508 249.73 131.42C249.685 131.071 249.657 130.72 249.644 130.368C249.636 130.107 249.635 129.843 249.64 129.579C249.642 129.513 249.645 129.448 249.648 129.382C249.647 129.371 249.647 129.358 249.65 129.349C249.653 129.274 249.659 129.198 249.665 129.125C249.67 129.048 249.677 128.975 249.686 128.9C249.687 128.898 249.685 128.896 249.688 128.894C249.688 128.875 249.69 128.859 249.693 128.843C249.695 128.825 249.697 128.807 249.699 128.791C249.701 128.77 249.703 128.752 249.706 128.732C249.707 128.711 249.709 128.693 249.714 128.674L249.715 128.672C249.735 128.504 249.761 128.338 249.793 128.172C249.808 128.099 249.822 128.028 249.838 127.956C249.847 127.913 249.857 127.87 249.868 127.828C249.879 127.777 249.892 127.728 249.905 127.678C249.938 127.553 249.972 127.43 250.013 127.307C250.055 127.166 250.103 127.029 250.158 126.89C250.161 126.88 250.165 126.869 250.17 126.86C250.194 126.797 250.221 126.732 250.248 126.67C250.269 126.623 250.291 126.573 250.311 126.525C250.334 126.479 250.355 126.431 250.378 126.382C250.404 126.324 250.432 126.268 250.462 126.213C250.48 126.177 250.499 126.142 250.517 126.108C250.519 126.104 250.519 126.102 250.522 126.101C250.552 126.044 250.585 125.986 250.619 125.93C250.625 125.92 250.63 125.911 250.636 125.9C250.651 125.874 250.666 125.849 250.683 125.824C250.71 125.776 250.738 125.731 250.769 125.687C250.797 125.642 250.827 125.598 250.857 125.553C250.855 125.554 250.853 125.558 250.851 125.559C250.798 125.609 250.745 125.658 250.695 125.71C250.657 125.747 250.62 125.787 250.581 125.826C250.544 125.866 250.509 125.907 250.474 125.947C250.466 125.953 250.461 125.96 250.457 125.967C250.425 126.004 250.392 126.043 250.362 126.081C250.326 126.124 250.292 126.167 250.26 126.212L250.259 126.214C250.225 126.257 250.192 126.303 250.16 126.349C250.131 126.389 250.104 126.43 250.075 126.471C250.009 126.57 249.946 126.673 249.884 126.778C249.846 126.845 249.807 126.915 249.771 126.984C249.736 127.046 249.706 127.11 249.675 127.175C249.645 127.236 249.615 127.299 249.586 127.363C249.546 127.457 249.507 127.549 249.472 127.644C249.444 127.714 249.419 127.785 249.394 127.856C249.37 127.928 249.348 127.996 249.326 128.066C249.324 128.078 249.32 128.09 249.316 128.101L249.315 128.105C249.279 128.219 249.247 128.336 249.215 128.453C249.184 128.571 249.158 128.69 249.134 128.808C249.122 128.867 249.11 128.927 249.1 128.984C249.098 128.985 249.098 128.986 249.099 128.988C249.085 129.065 249.071 129.141 249.061 129.219C249.044 129.323 249.031 129.426 249.02 129.531C248.971 129.915 248.956 130.301 248.961 130.686C248.96 130.749 248.962 130.811 248.964 130.872C248.964 130.879 248.963 130.885 248.965 130.892C248.967 130.96 248.97 131.03 248.972 131.099C248.982 131.324 248.998 131.55 249.019 131.774C249.051 132.059 249.092 132.341 249.142 132.622C249.144 132.641 249.148 132.661 249.152 132.68L249.151 132.682C249.158 132.716 249.164 132.749 249.171 132.783C249.188 132.878 249.208 132.973 249.228 133.066C249.236 133.101 249.243 133.135 249.25 133.169C249.251 133.171 249.252 133.176 249.251 133.178C249.274 133.276 249.296 133.37 249.32 133.466C249.358 133.634 249.402 133.8 249.447 133.968C249.656 134.676 249.895 135.372 250.157 136.055C250.413 136.697 250.665 137.335 250.934 137.965C250.948 138.001 250.965 138.037 250.98 138.074C250.996 138.113 251.013 138.15 251.029 138.189L251.028 138.191C251.175 138.545 251.321 138.9 251.459 139.255C251.503 139.365 251.547 139.475 251.589 139.584C251.643 139.721 251.695 139.857 251.745 139.992C251.797 140.128 251.847 140.263 251.894 140.399C252.079 140.91 252.249 141.428 252.399 141.956L252.599 142.921C252.644 143.107 252.696 143.293 252.745 143.479C252.748 143.64 252.753 143.802 252.76 143.963C252.766 144.123 252.776 144.284 252.787 144.446C252.791 144.506 252.795 144.569 252.801 144.63C252.804 144.677 252.806 144.724 252.811 144.772C252.813 144.82 252.818 144.867 252.822 144.915C252.824 144.941 252.828 144.966 252.829 144.992C252.842 145.131 252.857 145.271 252.874 145.409C252.894 145.572 252.914 145.733 252.938 145.895C252.946 145.967 252.957 146.039 252.968 146.112C252.991 146.259 253.015 146.408 253.042 146.555C253.048 146.592 253.056 146.631 253.061 146.669C253.076 146.748 253.093 146.827 253.108 146.906C253.131 147.022 253.154 147.137 253.179 147.253C253.216 147.433 253.257 147.613 253.302 147.793C253.33 147.91 253.359 148.028 253.391 148.144C253.404 148.201 253.421 148.257 253.436 148.316C253.441 148.328 253.442 148.341 253.447 148.353C253.449 148.364 253.453 148.376 253.456 148.388C253.482 148.483 253.51 148.577 253.539 148.671C253.545 148.694 253.551 148.72 253.56 148.744C253.641 149.014 253.73 149.285 253.825 149.552C253.854 149.633 253.883 149.715 253.914 149.795C253.929 149.836 253.944 149.878 253.96 149.917C253.996 150.014 254.034 150.111 254.073 150.206C254.111 150.302 254.15 150.397 254.191 150.491C254.252 150.637 254.317 150.783 254.383 150.928C254.4 150.968 254.42 151.009 254.44 151.049C254.44 151.054 254.441 151.056 254.444 151.061C254.367 150.999 254.289 150.938 254.212 150.876C254.184 150.853 254.155 150.833 254.127 150.81C254.054 150.753 253.981 150.694 253.91 150.634C253.898 150.626 253.887 150.615 253.876 150.605C253.83 150.566 253.787 150.528 253.742 150.487L253.74 150.486C253.654 150.412 253.568 150.336 253.485 150.261C253.48 150.257 253.477 150.254 253.473 150.248C253.378 150.165 253.284 150.077 253.19 149.99C253.069 149.876 252.95 149.764 252.833 149.647C252.752 149.568 252.675 149.489 252.599 149.41C252.503 149.311 252.41 149.214 252.317 149.112C251.415 148.148 250.603 147.095 249.851 145.996C249.54 145.539 249.238 145.074 248.942 144.603C248.982 144.469 249.016 144.336 249.047 144.201C249.094 144 249.131 143.796 249.163 143.595C249.175 143.51 249.188 143.426 249.196 143.341C249.207 143.256 249.215 143.17 249.223 143.087C249.226 143.078 249.226 143.067 249.227 143.057C249.229 143.032 249.234 143.007 249.236 142.982C249.24 142.947 249.243 142.913 249.243 142.877C249.245 142.835 249.249 142.794 249.253 142.752C249.256 142.706 249.258 142.663 249.259 142.617C249.263 142.572 249.264 142.526 249.267 142.478C249.268 142.445 249.27 142.41 249.269 142.376C249.271 142.347 249.271 142.317 249.27 142.288C249.273 142.251 249.273 142.213 249.274 142.175C249.274 142.15 249.274 142.125 249.275 142.099C249.275 142.074 249.274 142.046 249.272 142.021C249.273 141.995 249.274 141.968 249.272 141.942L249.272 141.924C249.271 141.788 249.265 141.654 249.259 141.519C249.253 141.382 249.246 141.247 249.234 141.11C249.227 141.015 249.217 140.921 249.206 140.827C249.196 140.733 249.184 140.635 249.171 140.543C249.156 140.435 249.14 140.328 249.123 140.221C249.122 140.206 249.119 140.19 249.115 140.176C249.113 140.163 249.11 140.147 249.109 140.134C249.078 139.95 249.042 139.766 248.999 139.582C248.975 139.475 248.95 139.371 248.923 139.265C248.831 138.911 248.722 138.557 248.586 138.215C248.559 138.147 248.533 138.079 248.503 138.011C248.474 137.944 248.442 137.877 248.411 137.809C248.379 137.743 248.347 137.677 248.313 137.61C248.297 137.573 248.279 137.539 248.261 137.506C248.259 137.604 248.256 137.702 248.254 137.8C248.254 137.885 248.252 137.968 248.255 138.053C248.255 138.234 248.262 138.416 248.269 138.595C248.273 138.706 248.277 138.815 248.283 138.924C248.29 139.07 248.298 139.216 248.307 139.362C248.335 139.84 248.369 140.312 248.409 140.786C248.418 140.911 248.429 141.039 248.44 141.165C248.441 141.169 248.44 141.171 248.441 141.176C248.442 141.201 248.444 141.225 248.448 141.252C248.449 141.267 248.45 141.282 248.451 141.297C248.459 141.395 248.467 141.495 248.477 141.593C248.498 141.825 248.518 142.058 248.541 142.289C248.563 142.522 248.588 142.754 248.612 142.988C248.621 143.071 248.631 143.152 248.64 143.235C248.65 143.317 248.658 143.396 248.668 143.477C248.688 143.646 248.71 143.813 248.734 143.984C248.752 144.11 248.771 144.237 248.792 144.364C248.753 144.3 248.714 144.238 248.675 144.174C248.566 143.997 248.457 143.818 248.35 143.64C248.238 143.453 248.126 143.265 248.015 143.077C247.914 142.905 247.814 142.734 247.714 142.56C247.608 142.378 247.505 142.197 247.401 142.016C247.298 141.834 247.195 141.651 247.092 141.468C246.982 141.274 246.874 141.081 246.766 140.89C246.765 140.885 246.764 140.883 246.762 140.882C246.565 140.527 246.369 140.17 246.172 139.816C246.17 139.815 246.168 139.812 246.168 139.808C246.028 139.559 245.891 139.312 245.753 139.062C245.099 137.885 244.459 136.707 243.878 135.509C243.842 135.435 243.809 135.363 243.776 135.292L243.753 135.244C243.778 135.209 243.8 135.174 243.817 135.138C243.83 135.113 243.842 135.09 243.851 135.063C243.863 135.036 243.872 135.009 243.88 134.98L244.047 134.415L244.085 134.287L244.279 133.623L244.335 133.43L244.376 133.294L244.381 133.281L244.414 133.166L244.467 132.982L244.471 132.973L244.492 132.898L244.525 132.785L244.679 132.257C244.679 132.257 244.68 132.255 244.682 132.254C244.781 132.177 244.88 132.097 244.975 132.017C245.11 131.908 245.239 131.797 245.367 131.681C245.394 131.659 245.42 131.634 245.447 131.61C245.45 131.608 245.453 131.605 245.453 131.603C245.457 131.6 245.46 131.597 245.463 131.594C245.488 131.571 245.513 131.548 245.537 131.525C245.738 131.342 245.933 131.15 246.12 130.956C246.228 130.846 246.332 130.735 246.436 130.623C246.54 130.51 246.643 130.396 246.744 130.282C246.795 130.221 246.844 130.163 246.893 130.102C246.927 130.063 246.961 130.022 246.993 129.983C247.019 129.952 247.045 129.919 247.071 129.887C247.137 129.805 247.204 129.723 247.269 129.638C247.322 129.57 247.375 129.502 247.427 129.432C247.45 129.402 247.473 129.37 247.497 129.338C247.513 129.316 247.529 129.295 247.545 129.273C247.553 129.263 247.561 129.251 247.569 129.239C247.584 129.221 247.597 129.202 247.608 129.183C247.647 129.131 247.687 129.077 247.723 129.022C247.774 128.952 247.823 128.878 247.871 128.807C247.937 128.709 247.999 128.613 248.063 128.515C248.152 128.375 248.239 128.233 248.322 128.089C248.439 127.892 248.55 127.688 248.653 127.481C248.667 127.453 248.684 127.424 248.698 127.396C248.729 127.329 248.76 127.264 248.792 127.197C248.692 127.316 248.594 127.433 248.496 127.553C248.397 127.673 248.299 127.79 248.203 127.911C248.189 127.925 248.177 127.942 248.163 127.958C247.983 128.18 247.803 128.402 247.622 128.621C247.582 128.669 247.542 128.718 247.502 128.767L247.501 128.769C247.476 128.798 247.45 128.83 247.425 128.859C247.364 128.933 247.303 129.006 247.242 129.079C247.157 129.183 247.07 129.287 246.982 129.39C246.956 129.423 246.928 129.455 246.9 129.487C246.896 129.492 246.89 129.499 246.886 129.504C246.741 129.679 246.593 129.851 246.443 130.022C246.155 130.358 245.863 130.687 245.565 131.017L245.564 131.019L245.369 131.235C245.341 131.266 245.315 131.295 245.287 131.325C245.269 131.348 245.249 131.369 245.228 131.391C245.083 131.549 244.937 131.709 244.792 131.868L245.209 130.428L245.209 130.426L245.298 130.122C245.324 130.036 245.347 129.95 245.371 129.863C245.391 129.792 245.411 129.723 245.431 129.653C245.54 129.273 245.648 128.894 245.754 128.514C245.848 128.182 245.942 127.85 246.035 127.518C246.048 127.472 246.06 127.425 246.073 127.377C246.109 127.255 246.144 127.13 246.178 127.007C246.197 126.94 246.216 126.873 246.233 126.805C246.266 126.694 246.296 126.582 246.326 126.471C246.345 126.41 246.363 126.346 246.378 126.284C246.396 126.227 246.411 126.171 246.427 126.114C246.428 126.11 246.431 126.109 246.432 126.105C246.435 126.102 246.437 126.096 246.44 126.093L246.442 126.089C246.486 126.014 246.536 125.938 246.583 125.864C246.605 125.826 246.631 125.786 246.655 125.748C246.673 125.719 246.693 125.688 246.711 125.658L246.712 125.656C246.883 125.383 247.055 125.11 247.229 124.839C247.247 124.812 247.265 124.784 247.283 124.755C247.331 124.679 247.38 124.603 247.43 124.528C247.433 124.523 247.435 124.519 247.438 124.514L247.44 124.51C247.606 124.256 247.774 124.002 247.942 123.749C248.081 123.541 248.223 123.333 248.366 123.126C248.399 123.076 248.432 123.028 248.465 122.981C248.474 122.969 248.483 122.955 248.491 122.943C248.62 122.76 248.748 122.578 248.878 122.397C248.937 122.312 248.996 122.229 249.056 122.147C249.135 122.035 249.213 121.924 249.293 121.815C249.533 121.483 249.777 121.155 250.028 120.833C250.559 120.126 251.109 119.433 251.682 118.759C251.697 118.739 251.715 118.72 251.732 118.701C251.754 118.673 251.779 118.643 251.803 118.616C251.971 118.411 252.145 118.208 252.32 118.007C252.39 117.926 252.46 117.845 252.528 117.764C252.599 117.683 252.671 117.602 252.743 117.522C252.752 117.513 252.762 117.504 252.77 117.494C253.573 116.587 254.41 115.71 255.267 114.843C255.6 114.507 255.93 114.169 256.257 113.821C256.296 113.778 256.335 113.737 256.375 113.694C256.437 113.626 256.498 113.559 256.559 113.492C256.675 113.366 256.789 113.237 256.903 113.108C256.97 113.032 257.035 112.953 257.101 112.878C257.102 112.876 257.104 112.876 257.104 112.875C257.166 112.801 257.227 112.727 257.287 112.652C257.348 112.578 257.408 112.504 257.466 112.427C257.514 112.368 257.56 112.308 257.604 112.248C257.627 112.218 257.649 112.19 257.67 112.161C257.718 112.096 257.765 112.032 257.811 111.966C257.852 111.911 257.893 111.853 257.931 111.797C257.978 111.729 258.025 111.661 258.068 111.592C258.145 111.477 258.216 111.363 258.287 111.246C258.336 111.164 258.386 111.081 258.432 110.998C258.454 110.959 258.476 110.92 258.495 110.883C258.533 110.816 258.566 110.749 258.6 110.683L258.619 110.646C258.607 110.663 258.592 110.681 258.578 110.697C258.525 110.765 258.472 110.833 258.418 110.898C258.362 110.969 258.305 111.04 258.247 111.11C258.065 111.327 257.877 111.538 257.684 111.745C257.582 111.857 257.474 111.967 257.367 112.075C257.269 112.176 257.166 112.277 257.064 112.377C256.939 112.5 256.813 112.622 256.685 112.742C256.584 112.838 256.483 112.931 256.381 113.024C256.356 113.047 256.334 113.069 256.309 113.09C256.269 113.129 256.227 113.165 256.186 113.203C256.143 113.241 256.102 113.28 256.06 113.318C256.054 113.322 256.048 113.328 256.042 113.332C255.967 113.403 255.888 113.473 255.811 113.543C255.738 113.606 255.665 113.671 255.593 113.734C255.343 113.955 255.094 114.177 254.844 114.399C254.51 114.694 254.175 114.993 253.852 115.309C253.834 115.325 253.818 115.341 253.801 115.358C253.762 115.393 253.723 115.431 253.686 115.466C253.569 115.577 253.455 115.689 253.342 115.802C253.189 115.951 253.037 116.102 252.888 116.253C252.839 116.304 252.79 116.354 252.742 116.407C252.722 116.429 252.699 116.451 252.679 116.474C252.527 116.634 252.376 116.794 252.227 116.957L252.226 116.959C252.217 116.969 252.208 116.976 252.2 116.986C252.188 116.998 252.177 117.012 252.166 117.025C252.116 117.077 252.068 117.13 252.02 117.183C252.066 117.106 252.11 117.028 252.155 116.952C252.182 116.906 252.209 116.863 252.236 116.817C252.245 116.802 252.256 116.784 252.265 116.769L252.266 116.767C252.489 116.396 252.722 116.03 252.96 115.67C253.208 115.295 253.465 114.925 253.73 114.56C253.848 114.398 253.965 114.241 254.087 114.083L254.088 114.081C254.092 114.076 254.096 114.071 254.1 114.066C254.205 113.928 254.309 113.79 254.417 113.654C254.53 113.512 254.642 113.372 254.756 113.232L254.758 113.231C254.844 113.124 254.931 113.019 255.018 112.914C255.04 112.886 255.064 112.859 255.087 112.831L255.089 112.83C255.121 112.792 255.153 112.755 255.185 112.717L255.186 112.716C255.24 112.65 255.296 112.585 255.352 112.523C255.409 112.456 255.465 112.389 255.523 112.325C255.657 112.171 255.793 112.021 255.931 111.871C256.036 111.753 256.143 111.639 256.25 111.524C256.562 111.19 256.881 110.858 257.205 110.526C257.307 110.419 257.412 110.312 257.517 110.205C257.227 110.348 256.943 110.509 256.67 110.682C256.598 110.727 256.527 110.774 256.458 110.821C256.357 110.886 256.26 110.953 256.164 111.023C256.13 111.044 256.098 111.067 256.069 111.091C256.017 111.126 255.966 111.163 255.919 111.201C255.835 111.263 255.754 111.325 255.673 111.389C255.647 111.408 255.621 111.428 255.597 111.45C255.519 111.511 255.442 111.575 255.366 111.641C255.346 111.655 255.326 111.671 255.308 111.688C255.269 111.719 255.231 111.752 255.194 111.786L255.193 111.788C255.155 111.819 255.116 111.851 255.079 111.885C254.96 111.991 254.842 112.1 254.728 112.212C254.641 112.293 254.557 112.376 254.473 112.46C254.432 112.501 254.392 112.542 254.353 112.583C254.27 112.668 254.19 112.754 254.109 112.842C254.075 112.879 254.041 112.915 254.007 112.954C253.931 113.037 253.855 113.123 253.783 113.209C253.769 113.225 253.755 113.242 253.741 113.258C253.741 113.258 253.739 113.257 253.739 113.259C253.723 113.279 253.706 113.298 253.69 113.32C253.64 113.379 253.59 113.437 253.542 113.497C253.527 113.517 253.51 113.536 253.494 113.556C253.491 113.561 253.487 113.566 253.482 113.573C253.404 113.672 253.324 113.773 253.25 113.873C253.193 113.944 253.139 114.016 253.086 114.09C253.077 114.104 253.066 114.117 253.057 114.131C252.995 114.217 252.934 114.303 252.874 114.389C252.575 114.823 252.301 115.273 252.053 115.737C252.024 115.792 251.993 115.849 251.966 115.905C251.938 115.954 251.912 116.004 251.888 116.055C251.862 116.105 251.837 116.155 251.813 116.206L251.811 116.209C251.797 116.24 251.781 116.273 251.766 116.303C251.708 116.422 251.653 116.544 251.598 116.666C251.499 116.897 251.403 117.132 251.315 117.368C251.278 117.469 251.242 117.571 251.207 117.672C251.17 117.779 251.135 117.887 251.101 117.995C251.082 118.052 251.067 118.108 251.05 118.163L251.042 118.186C251.025 118.245 251.01 118.303 250.993 118.363C250.989 118.368 250.986 118.371 250.982 118.376C250.808 118.585 250.638 118.798 250.469 119.013C250.382 119.122 250.297 119.233 250.211 119.342C250.127 119.452 250.043 119.564 249.959 119.674C249.791 119.898 249.627 120.121 249.465 120.347C249.383 120.46 249.302 120.573 249.224 120.689C249.144 120.803 249.064 120.918 248.987 121.032C248.899 121.162 248.812 121.292 248.725 121.422C248.722 121.425 248.721 121.429 248.719 121.432C248.633 121.561 248.55 121.69 248.465 121.82C248.455 121.836 248.445 121.851 248.436 121.867C248.357 121.991 248.278 122.115 248.2 122.242C248.115 122.377 248.032 122.515 247.95 122.653C247.851 122.817 247.754 122.981 247.658 123.148C247.611 123.23 247.563 123.315 247.516 123.4C247.469 123.482 247.421 123.565 247.376 123.648L247.374 123.651C247.358 123.679 247.345 123.706 247.328 123.735C247.249 123.88 247.171 124.025 247.093 124.171C247.017 124.317 246.941 124.464 246.867 124.611C246.849 124.643 246.832 124.673 246.817 124.705L246.82 124.696C246.832 124.649 246.844 124.603 246.858 124.557L248.304 119.233L248.346 119.077L248.347 119.073L248.373 118.979L248.379 118.955L248.427 118.78L248.428 118.778L248.673 117.871L248.721 117.696L248.944 116.878L248.984 116.724L248.986 116.72L249.131 116.187C249.22 115.857 249.31 115.529 249.403 115.201C249.421 115.135 249.441 115.068 249.459 115.003C249.505 114.84 249.553 114.677 249.601 114.515C249.649 114.352 249.698 114.191 249.748 114.029C249.771 113.952 249.794 113.874 249.818 113.798C249.837 113.737 249.858 113.677 249.877 113.616C249.894 113.553 249.917 113.489 249.936 113.426C249.968 113.328 250 113.229 250.034 113.132C250.058 113.064 250.079 112.997 250.102 112.93L250.103 112.928C250.215 112.603 250.334 112.279 250.46 111.958C250.499 111.858 250.538 111.758 250.581 111.659C250.614 111.574 250.65 111.489 250.685 111.407C250.701 111.372 250.715 111.339 250.728 111.306C250.765 111.226 250.798 111.147 250.834 111.067L250.836 111.063C250.88 110.967 250.924 110.868 250.97 110.773C251.015 110.675 251.063 110.578 251.111 110.483C251.155 110.391 251.201 110.301 251.248 110.21C251.248 110.208 251.251 110.207 251.251 110.205C251.284 110.141 251.317 110.076 251.353 110.015C251.394 109.933 251.439 109.851 251.486 109.771C251.537 109.679 251.59 109.588 251.644 109.497C251.657 109.472 251.672 109.448 251.687 109.424C251.756 109.31 251.824 109.198 251.898 109.088C251.902 109.077 251.91 109.065 251.918 109.055C251.958 108.993 251.996 108.933 252.036 108.873C252.041 108.866 252.045 108.859 252.05 108.852C252.087 108.798 252.123 108.744 252.16 108.69C252.245 108.568 252.331 108.446 252.421 108.328C252.532 108.178 252.646 108.031 252.764 107.886C252.882 107.742 253.003 107.598 253.124 107.457C253.229 107.462 253.335 107.467 253.439 107.469C253.556 107.472 253.673 107.475 253.792 107.474C253.868 107.473 253.946 107.472 254.023 107.469C254.122 107.468 254.225 107.464 254.324 107.458C254.397 107.454 254.468 107.449 254.539 107.444C254.563 107.442 254.587 107.441 254.609 107.439C254.641 107.437 254.673 107.436 254.704 107.432C254.728 107.429 254.754 107.428 254.778 107.424C254.893 107.415 255.009 107.402 255.123 107.389C255.237 107.376 255.352 107.361 255.467 107.344C255.48 107.342 255.495 107.341 255.509 107.34C255.538 107.335 255.564 107.331 255.593 107.327C255.609 107.324 255.624 107.323 255.64 107.318C255.724 107.307 255.81 107.292 255.893 107.277C255.962 107.265 256.031 107.253 256.1 107.237C256.198 107.218 256.297 107.198 256.395 107.177C256.493 107.154 256.59 107.131 256.688 107.108C256.833 107.074 256.976 107.037 257.118 106.998C257.227 106.968 257.337 106.939 257.445 106.905C257.529 106.881 257.614 106.854 257.697 106.828C257.929 106.754 258.157 106.674 258.385 106.588C258.85 106.413 259.307 106.213 259.751 105.99C259.861 105.933 259.971 105.876 260.082 105.818C260.164 105.775 260.245 105.729 260.327 105.684C260.57 105.547 260.809 105.403 261.043 105.252C261.147 105.182 261.251 105.113 261.354 105.042C261.459 104.969 261.56 104.896 261.661 104.822C261.746 104.761 261.829 104.699 261.909 104.636C261.946 104.609 261.982 104.579 262.018 104.552C262.097 104.489 262.179 104.424 262.256 104.359C262.334 104.293 262.412 104.227 262.49 104.16C262.515 104.137 262.539 104.114 262.567 104.089C262.567 104.089 262.567 104.088 262.569 104.088C262.613 104.047 262.659 104.006 262.704 103.962C262.719 103.948 262.735 103.933 262.751 103.917C262.782 103.888 262.813 103.861 262.842 103.831C262.892 103.783 262.941 103.734 262.99 103.684C262.992 103.683 262.994 103.679 262.996 103.678C262.999 103.675 263.003 103.671 263.006 103.668C263.112 103.564 263.209 103.459 263.309 103.348L263.304 103.35C263.221 103.395 263.137 103.442 263.056 103.488C262.879 103.585 262.705 103.68 262.527 103.774C262.498 103.79 262.47 103.805 262.443 103.821L262.438 103.823C262.323 103.887 262.207 103.948 262.094 104.007C261.982 104.07 261.868 104.131 261.751 104.189C261.715 104.209 261.676 104.229 261.64 104.248C261.511 104.317 261.377 104.386 261.245 104.452C261.078 104.54 260.907 104.625 260.736 104.707L260.734 104.706C259.872 105.128 258.997 105.507 258.105 105.844C257.908 105.917 257.713 105.988 257.516 106.059C257.322 106.127 257.128 106.194 256.933 106.257L256.931 106.258C256.866 106.28 256.802 106.3 256.739 106.32C256.567 106.379 256.394 106.433 256.223 106.483C256.169 106.5 256.115 106.515 256.061 106.532C256.061 106.532 256.059 106.531 256.058 106.533C256.007 106.547 255.958 106.561 255.906 106.577C255.731 106.63 255.557 106.68 255.382 106.728C255.361 106.733 255.342 106.74 255.321 106.745C255.305 106.748 255.289 106.753 255.272 106.758C255.235 106.768 255.197 106.78 255.159 106.788C255.14 106.794 255.119 106.799 255.1 106.803C254.947 106.845 254.794 106.885 254.64 106.924C254.64 106.924 254.637 106.925 254.635 106.924C254.418 106.979 254.199 107.034 253.979 107.084C253.805 107.125 253.632 107.164 253.457 107.204C253.409 107.215 253.359 107.227 253.311 107.238C253.377 107.162 253.446 107.086 253.517 107.014C253.592 106.933 253.668 106.852 253.747 106.772C253.765 106.749 253.787 106.729 253.807 106.708C253.885 106.628 253.963 106.55 254.042 106.472C254.042 106.472 254.043 106.471 254.045 106.469C254.12 106.394 254.196 106.321 254.274 106.247C254.353 106.172 254.434 106.096 254.517 106.022C254.589 105.952 254.666 105.884 254.741 105.818C254.823 105.747 254.902 105.678 254.983 105.609C255.064 105.538 255.145 105.469 255.227 105.403C255.28 105.358 255.333 105.316 255.388 105.272C255.48 105.196 255.575 105.121 255.671 105.047C255.72 105.009 255.769 104.97 255.82 104.933C255.872 104.894 255.924 104.853 255.975 104.814L255.98 104.811C256.163 104.672 256.35 104.539 256.54 104.407C258.112 103.316 259.813 102.408 261.564 101.615C261.939 101.444 262.316 101.277 262.695 101.118C263.029 100.973 263.365 100.832 263.701 100.694C263.742 100.679 263.782 100.661 263.824 100.644C264.101 100.531 264.378 100.419 264.656 100.311C265.406 100.011 266.161 99.7228 266.917 99.4396C265.695 99.8521 264.477 100.274 263.269 100.732C263.097 100.796 262.925 100.861 262.755 100.928C262.543 101.01 262.329 101.092 262.118 101.177C261.908 101.26 261.697 101.347 261.486 101.434C259.705 102.183 257.968 103.051 256.342 104.115C256.23 104.188 256.12 104.261 256.01 104.336C255.899 104.412 255.788 104.489 255.681 104.568C255.587 104.634 255.493 104.703 255.4 104.771C255.119 104.981 254.842 105.201 254.572 105.428C254.494 105.494 254.417 105.559 254.341 105.626C254.251 105.704 254.162 105.783 254.073 105.863C253.988 105.939 253.904 106.017 253.82 106.093C253.817 106.098 253.811 106.101 253.808 106.106C253.722 106.184 253.638 106.266 253.555 106.349C253.514 106.387 253.475 106.427 253.434 106.465C253.425 106.474 253.415 106.484 253.406 106.493C253.338 106.56 253.271 106.632 253.205 106.701C253.167 106.737 253.133 106.775 253.097 106.811C253.153 106.711 253.206 106.612 253.264 106.512C253.299 106.448 253.336 106.385 253.372 106.321C253.394 106.284 253.415 106.248 253.436 106.211C253.439 106.203 253.443 106.196 253.448 106.189C253.581 105.968 253.717 105.748 253.857 105.531C253.927 105.422 253.998 105.315 254.071 105.207C254.214 104.994 254.363 104.784 254.517 104.576C254.746 104.268 254.989 103.967 255.244 103.681C256.596 102.133 258.265 100.876 260.073 99.8748C261.885 98.8667 263.838 98.1224 265.832 97.5055C266.829 97.192 267.841 96.9219 268.858 96.6634C269.088 96.6019 269.318 96.5432 269.55 96.4843C269.586 96.4759 269.622 96.465 269.658 96.4566C270.407 96.2656 271.161 96.0846 271.91 95.8917C271.553 95.9493 271.198 96.007 270.842 96.0689C270.162 96.1827 269.483 96.3072 268.805 96.4327C267.776 96.6381 266.746 96.8624 265.726 97.1255C265.582 97.1622 265.439 97.199 265.297 97.2379C265.174 97.271 265.053 97.3048 264.932 97.3388C264.82 97.3695 264.707 97.4022 264.597 97.4356C264.482 97.4695 264.367 97.5034 264.253 97.54C263.608 97.7354 262.969 97.9561 262.337 98.2003C262.237 98.2394 262.137 98.2785 262.038 98.3177C261.925 98.363 261.812 98.4082 261.7 98.4551C262.105 98.1894 262.516 97.9296 262.935 97.6873L263.398 97.4311C263.475 97.388 263.551 97.3448 263.627 97.2997C263.705 97.2591 263.783 97.2166 263.861 97.1785C263.941 97.1385 264.019 97.1004 264.097 97.0597C264.254 96.9772 264.41 96.8968 264.567 96.8206C264.646 96.7806 264.726 96.7451 264.806 96.7095C265.443 96.4082 266.088 96.1283 266.748 95.8876C267.403 95.6325 268.071 95.4133 268.748 95.2163C269.42 95.0093 270.107 94.8495 270.797 94.6886C270.991 94.6463 271.185 94.6037 271.379 94.5662C271.515 94.5376 271.653 94.5114 271.788 94.4847C272.546 94.339 273.313 94.2175 274.088 94.1092C274.395 94.0661 274.702 94.0255 275.013 93.9857C274.714 93.9557 274.413 93.9313 274.112 93.9173C274.003 93.911 273.894 93.9072 273.786 93.9053C273.655 93.9 273.525 93.8973 273.393 93.8976C273.306 93.8972 273.218 93.8961 273.132 93.8977C273.12 93.8957 273.109 93.8962 273.098 93.8967C272.929 93.899 272.761 93.9022 272.593 93.909C272.586 93.9089 272.582 93.9095 272.577 93.91C272.488 93.9127 272.4 93.918 272.31 93.9227C271.768 93.9496 271.227 94.0021 270.688 94.0759C269.968 94.1697 269.255 94.3184 268.549 94.4904C267.844 94.6694 267.15 94.8921 266.465 95.143C265.788 95.4074 265.119 95.7022 264.473 96.0361C264.392 96.0799 264.312 96.1218 264.232 96.1655C264.072 96.2537 263.913 96.3435 263.755 96.4341C263.597 96.5248 263.441 96.6178 263.287 96.7142C263.134 96.8106 262.98 96.9087 262.829 97.0102C262.754 97.0622 262.679 97.1142 262.604 97.1658C262.399 97.3076 262.199 97.4529 262.002 97.6017C261.805 97.7524 261.612 97.9086 261.422 98.0663C261.327 98.147 261.231 98.2277 261.14 98.3094C260.954 98.4728 260.774 98.6417 260.596 98.8141C260.508 98.8993 260.42 98.9867 260.335 99.0751C260.152 99.1636 259.97 99.2537 259.789 99.3492C259.554 99.4742 259.322 99.6022 259.092 99.7374C258.862 99.8707 258.636 100.009 258.409 100.152C257.96 100.438 257.521 100.743 257.094 101.065C256.675 101.397 256.261 101.734 255.874 102.105C255.675 102.285 255.492 102.483 255.301 102.669C255.164 102.817 255.026 102.963 254.896 103.116C254.853 103.167 254.81 103.219 254.767 103.27C254.245 103.882 253.78 104.541 253.369 105.228C253.233 105.457 253.102 105.69 252.976 105.924C252.928 106.015 252.88 106.104 252.832 106.194C252.792 106.273 252.752 106.354 252.712 106.432C252.679 106.495 252.647 106.557 252.617 106.62C252.579 106.7 252.539 106.779 252.503 106.859C252.476 106.911 252.452 106.963 252.429 107.017C252.404 107.065 252.383 107.112 252.362 107.162C252.331 107.225 252.303 107.289 252.274 107.353C252.233 107.446 252.191 107.539 252.148 107.631C252.124 107.688 252.098 107.745 252.076 107.802C252.055 107.852 252.035 107.904 252.017 107.955C252 107.997 251.984 108.043 251.971 108.087C251.97 108.09 251.968 108.096 251.969 108.1C251.963 108.115 251.961 108.129 251.957 108.145L251.955 108.152C251.955 108.152 251.954 108.154 251.952 108.156C251.886 108.242 251.821 108.332 251.756 108.421C251.753 108.424 251.752 108.427 251.749 108.431C251.744 108.439 251.737 108.446 251.732 108.454C251.639 108.584 251.548 108.717 251.46 108.851C251.413 108.919 251.369 108.986 251.326 109.053C251.28 109.127 251.232 109.203 251.185 109.279C251.127 109.373 251.071 109.468 251.015 109.562C251.011 109.568 251.006 109.575 251.004 109.581C250.968 109.642 250.932 109.704 250.897 109.767C250.881 109.796 250.865 109.824 250.849 109.852C250.839 109.869 250.828 109.889 250.819 109.907C250.754 110.028 250.689 110.15 250.625 110.273C250.561 110.397 250.499 110.52 250.437 110.644C250.431 110.655 250.426 110.665 250.421 110.679C250.421 110.679 250.418 110.68 250.42 110.682C250.398 110.721 250.379 110.763 250.36 110.805C250.312 110.902 250.265 111.002 250.22 111.1C250.17 111.209 250.121 111.32 250.074 111.43C250.036 111.516 250 111.601 249.965 111.685L249.963 111.689C249.93 111.768 249.895 111.848 249.863 111.928C249.784 112.128 249.704 112.325 249.631 112.525C249.6 112.608 249.57 112.688 249.542 112.77C249.52 112.828 249.498 112.886 249.477 112.944C249.479 112.94 249.478 112.936 249.479 112.932C249.481 112.922 249.482 112.912 249.483 112.902C249.505 112.774 249.525 112.647 249.548 112.52C249.55 112.516 249.548 112.514 249.55 112.51C249.565 112.431 249.579 112.353 249.593 112.275C249.602 112.225 249.61 112.177 249.619 112.128L249.62 112.126C249.674 111.822 249.733 111.52 249.797 111.22C249.812 111.145 249.828 111.069 249.845 110.995C249.848 110.988 249.849 110.979 249.851 110.972C249.861 110.925 249.871 110.878 249.881 110.83C249.9 110.753 249.916 110.676 249.936 110.599C249.944 110.566 249.952 110.531 249.959 110.497C249.966 110.472 249.97 110.446 249.977 110.421L249.979 110.416C249.98 110.406 249.983 110.396 249.986 110.384C249.99 110.367 249.994 110.347 250 110.33C250.003 110.31 250.009 110.293 250.013 110.276C250.017 110.258 250.021 110.24 250.025 110.223C250.038 110.171 250.05 110.118 250.064 110.066C250.078 110.014 250.092 109.962 250.107 109.908C250.122 109.839 250.14 109.769 250.159 109.702C250.181 109.609 250.207 109.515 250.233 109.423C250.271 109.28 250.31 109.138 250.351 108.996C250.356 108.983 250.358 108.971 250.362 108.96L250.362 108.958C250.404 108.812 250.447 108.669 250.493 108.525C250.5 108.498 250.507 108.473 250.516 108.447C250.527 108.408 250.54 108.373 250.553 108.335C250.599 108.191 250.645 108.045 250.693 107.899C250.932 107.175 251.199 106.461 251.492 105.754C251.575 105.553 251.659 105.353 251.747 105.153C251.779 105.08 251.81 105.007 251.842 104.934C251.898 104.808 251.955 104.682 252.013 104.555C252.103 104.357 252.196 104.157 252.29 103.958C252.382 103.759 252.477 103.557 252.572 103.356C252.612 103.273 252.652 103.188 252.692 103.103C252.672 103.124 252.65 103.145 252.632 103.167C252.55 103.25 252.473 103.333 252.395 103.419C252.379 103.435 252.365 103.451 252.351 103.467C252.284 103.543 252.217 103.621 252.151 103.697C252.15 103.699 252.147 103.702 252.146 103.706C252.07 103.795 251.996 103.887 251.925 103.978C251.702 104.261 251.496 104.558 251.302 104.862C251.173 105.064 251.049 105.269 250.93 105.479C250.728 105.838 250.541 106.207 250.37 106.584C250.165 107.041 249.984 107.507 249.828 107.984C249.818 108.01 249.811 108.037 249.802 108.064C249.785 108.113 249.77 108.162 249.755 108.212C249.75 108.225 249.747 108.241 249.742 108.254C249.715 108.345 249.687 108.437 249.662 108.529C249.626 108.651 249.593 108.775 249.561 108.898C249.546 108.961 249.531 109.023 249.516 109.083C249.499 109.149 249.485 109.216 249.47 109.282C249.454 109.348 249.439 109.415 249.427 109.48C249.413 109.537 249.403 109.592 249.392 109.647C249.369 109.763 249.347 109.88 249.328 109.996C249.315 110.069 249.303 110.141 249.293 110.213C249.283 110.264 249.275 110.318 249.268 110.371C249.263 110.401 249.259 110.431 249.257 110.462C249.255 110.474 249.253 110.486 249.251 110.498C249.239 110.582 249.229 110.665 249.22 110.75C249.206 110.876 249.194 111.002 249.182 111.128C249.17 111.266 249.16 111.403 249.153 111.54L249.152 111.542C249.151 111.581 249.149 111.618 249.149 111.656L249.148 111.658C249.145 111.701 249.143 111.745 249.141 111.786C249.14 111.79 249.141 111.793 249.142 111.797L249.141 111.799C249.138 111.825 249.139 111.853 249.139 111.878C249.131 112.095 249.131 112.309 249.138 112.527C249.139 112.589 249.141 112.65 249.145 112.713C249.144 112.732 249.147 112.749 249.147 112.768L249.146 112.77C249.149 112.803 249.151 112.835 249.152 112.867C249.157 112.934 249.159 113 249.165 113.068C249.178 113.268 249.199 113.467 249.225 113.666C249.203 113.728 249.184 113.789 249.165 113.851L249.155 113.88C249.114 114.002 249.073 114.127 249.035 114.251C249.015 114.313 248.995 114.378 248.975 114.441C248.944 114.535 248.914 114.63 248.884 114.727C248.859 114.813 248.831 114.898 248.806 114.984L248.802 114.993C248.76 115.128 248.719 115.265 248.678 115.401C248.616 115.603 248.557 115.805 248.497 116.006L247.984 117.747L247.984 117.749L247.931 117.931L247.806 118.353L247.681 118.781L246.502 122.787L246.443 122.988L246.05 124.328C246.021 124.43 245.99 124.533 245.961 124.634C245.94 124.699 245.921 124.766 245.903 124.831C245.717 125.47 245.534 126.106 245.353 126.745C245.211 127.247 245.068 127.75 244.925 128.254C244.852 128.506 244.782 128.758 244.711 129.011C244.691 129.078 244.672 129.145 244.653 129.213C244.653 129.208 244.652 129.206 244.651 129.201C244.607 129.005 244.566 128.808 244.527 128.611C244.447 128.221 244.371 127.83 244.302 127.439L244.302 127.437C244.296 127.408 244.29 127.38 244.286 127.351C244.278 127.307 244.269 127.259 244.263 127.215C244.233 127.048 244.205 126.883 244.179 126.718C244.171 126.669 244.161 126.617 244.155 126.569C244.143 126.499 244.133 126.432 244.123 126.363C244.088 126.143 244.055 125.921 244.024 125.7C244.001 125.531 243.979 125.364 243.959 125.197C243.943 125.067 243.927 124.937 243.913 124.808C243.909 124.769 243.905 124.731 243.9 124.692C243.901 124.69 243.901 124.688 243.9 124.685C243.881 124.527 243.867 124.369 243.852 124.21C243.847 124.157 243.844 124.106 243.84 124.051L243.84 124.049C243.833 123.986 243.829 123.923 243.824 123.858C243.825 123.857 243.824 123.854 243.824 123.852C243.813 123.72 243.805 123.586 243.796 123.455C243.788 123.319 243.78 123.184 243.774 123.049C243.768 122.914 243.764 122.78 243.76 122.646C243.757 122.533 243.753 122.423 243.752 122.311L243.752 122.309C243.752 122.286 243.751 122.264 243.751 122.241C243.75 122.226 243.751 122.209 243.75 122.194C243.749 122.093 243.749 121.996 243.75 121.895C243.749 121.857 243.75 121.817 243.751 121.779C243.812 121.706 243.874 121.63 243.932 121.554C243.935 121.551 243.937 121.547 243.94 121.544C244.09 121.354 244.235 121.16 244.372 120.961C244.377 120.952 244.384 120.944 244.389 120.935C244.423 120.886 244.457 120.837 244.491 120.787C244.525 120.738 244.559 120.689 244.592 120.637C244.672 120.515 244.75 120.393 244.825 120.267C244.888 120.165 244.949 120.064 245.008 119.96L245.008 119.958C245.023 119.935 245.037 119.913 245.049 119.89C245.212 119.607 245.366 119.317 245.513 119.025C245.58 118.886 245.647 118.747 245.712 118.605C245.761 118.5 245.808 118.394 245.853 118.288C245.906 118.165 245.96 118.041 246.01 117.915C246.06 117.789 246.109 117.665 246.156 117.538L246.156 117.536C246.172 117.495 246.187 117.454 246.201 117.412C246.212 117.38 246.225 117.349 246.236 117.317L246.245 117.29C246.292 117.157 246.336 117.023 246.379 116.888C246.414 116.78 246.445 116.671 246.476 116.564C246.499 116.487 246.521 116.411 246.541 116.334C246.567 116.242 246.588 116.15 246.612 116.057C246.613 116.055 246.611 116.053 246.615 116.05C246.636 115.958 246.656 115.864 246.675 115.772C246.687 115.725 246.695 115.68 246.705 115.632C246.711 115.597 246.718 115.563 246.724 115.527L246.721 115.535C246.667 115.649 246.614 115.761 246.56 115.873C246.557 115.876 246.555 115.882 246.554 115.885C246.489 116.023 246.424 116.161 246.362 116.299C246.291 116.449 246.221 116.6 246.155 116.75C246.086 116.901 246.017 117.049 245.949 117.198C245.819 117.476 245.689 117.753 245.558 118.028C245.427 118.302 245.294 118.576 245.157 118.849C245.088 118.994 245.016 119.135 244.945 119.279C244.873 119.418 244.802 119.556 244.73 119.697C244.595 119.958 244.46 120.219 244.324 120.479C244.28 120.563 244.236 120.647 244.192 120.73C244.188 120.737 244.186 120.743 244.181 120.75L244.18 120.753C244.039 121.02 243.897 121.285 243.755 121.554C243.763 121.125 243.786 120.695 243.823 120.265C243.835 120.122 243.85 119.98 243.866 119.838C243.971 118.865 244.152 117.9 244.417 116.954C244.453 116.825 244.491 116.7 244.531 116.572C244.55 116.509 244.571 116.445 244.59 116.382C244.632 116.249 244.675 116.119 244.72 115.989C244.826 115.683 244.942 115.379 245.063 115.08C245.185 114.783 245.312 114.488 245.446 114.195C245.857 113.302 246.345 112.439 246.898 111.622C246.966 111.519 247.037 111.417 247.108 111.316C247.178 111.216 247.249 111.116 247.32 111.019C247.322 111.015 247.325 111.012 247.328 111.009C247.381 110.934 247.434 110.862 247.49 110.791C247.542 110.721 247.596 110.651 247.651 110.582C247.675 110.548 247.699 110.516 247.725 110.485C247.812 110.374 247.9 110.264 247.991 110.156C248.078 110.05 248.167 109.946 248.258 109.842C248.33 109.756 248.404 109.67 248.482 109.585C248.496 109.567 248.514 109.548 248.53 109.53C248.602 109.45 248.674 109.37 248.748 109.292C248.742 109.297 248.738 109.302 248.732 109.306C248.675 109.356 248.62 109.406 248.568 109.458C248.509 109.513 248.451 109.569 248.392 109.624C248.333 109.679 248.276 109.735 248.22 109.794C248.162 109.852 248.106 109.908 248.05 109.966C247.695 110.328 247.36 110.706 247.04 111.099C246.931 111.23 246.827 111.362 246.724 111.495C246.119 112.292 245.577 113.143 245.109 114.031C244.62 114.961 244.219 115.936 243.908 116.942L243.9 116.965C243.875 117.049 243.848 117.132 243.826 117.215C243.792 117.325 243.76 117.434 243.73 117.546C243.702 117.652 243.673 117.758 243.646 117.866C243.624 117.949 243.603 118.033 243.585 118.117C243.566 118.19 243.55 118.265 243.533 118.339C243.427 118.809 243.34 119.285 243.273 119.763C243.257 119.877 243.242 119.992 243.228 120.107C243.194 120.374 243.169 120.641 243.148 120.909C243.14 120.999 243.134 121.088 243.129 121.176C243.121 121.29 243.113 121.403 243.11 121.515C243.103 121.622 243.099 121.729 243.096 121.837C243.087 122.067 243.083 122.298 243.083 122.529C243.064 122.426 243.047 122.323 243.031 122.218C243.029 122.201 243.025 122.181 243.023 122.163C243.004 122.051 242.987 121.938 242.971 121.825C242.952 121.692 242.935 121.56 242.919 121.428C242.904 121.307 242.89 121.184 242.879 121.062L242.88 121.061C242.878 121.043 242.875 121.027 242.874 121.01C242.858 120.857 242.846 120.703 242.836 120.548C242.836 120.542 242.835 120.535 242.835 120.529L242.835 120.527C242.818 120.302 242.809 120.075 242.805 119.849L242.806 119.847C242.801 119.582 242.802 119.317 242.814 119.053C242.838 118.35 242.918 117.649 243.061 116.957C243.079 116.868 243.097 116.778 243.118 116.689C243.134 116.618 243.15 116.548 243.17 116.477C243.182 116.424 243.194 116.371 243.211 116.318C243.234 116.225 243.258 116.132 243.286 116.041C243.29 116.023 243.296 116.005 243.3 115.987C243.309 115.956 243.319 115.926 243.328 115.895C243.331 115.88 243.337 115.863 243.342 115.848C243.356 115.8 243.371 115.752 243.387 115.705C243.392 115.686 243.397 115.664 243.406 115.646C243.482 115.401 243.566 115.16 243.653 114.919C243.684 114.837 243.715 114.753 243.748 114.67C243.781 114.589 243.813 114.507 243.848 114.425C243.881 114.341 243.918 114.261 243.954 114.179C244.027 114.017 244.102 113.856 244.18 113.698C244.259 113.537 244.342 113.379 244.427 113.223C244.472 113.143 244.515 113.066 244.559 112.989L244.69 112.756C244.705 112.732 244.721 112.706 244.735 112.681C244.766 112.629 244.799 112.577 244.829 112.526C244.877 112.45 244.924 112.374 244.973 112.298C245.021 112.222 245.072 112.149 245.121 112.074C245.186 111.978 245.252 111.885 245.318 111.79C245.319 111.789 245.32 111.787 245.322 111.785C245.392 111.687 245.464 111.59 245.535 111.493C245.607 111.396 245.68 111.299 245.756 111.203C245.521 111.437 245.296 111.686 245.082 111.943C245.005 112.034 244.93 112.126 244.858 112.219C244.855 112.222 244.854 112.226 244.85 112.229L244.85 112.23C244.778 112.323 244.705 112.416 244.637 112.51C244.621 112.53 244.606 112.55 244.591 112.57C244.518 112.671 244.447 112.773 244.376 112.875C244.337 112.931 244.299 112.987 244.262 113.044C244.225 113.101 244.188 113.16 244.152 113.217C244.078 113.332 244.008 113.449 243.938 113.566C243.707 113.957 243.497 114.363 243.307 114.777C243.149 115.123 243.007 115.478 242.882 115.837C242.85 115.929 242.819 116.025 242.789 116.118C242.758 116.215 242.728 116.312 242.701 116.409C242.688 116.447 242.677 116.483 242.668 116.522C242.639 116.624 242.612 116.726 242.585 116.828C242.555 116.945 242.527 117.061 242.5 117.176C242.498 117.183 242.497 117.192 242.496 117.2C242.474 117.295 242.454 117.39 242.435 117.486C242.427 117.515 242.422 117.547 242.416 117.576C242.394 117.689 242.374 117.802 242.355 117.915C242.318 118.134 242.288 118.353 242.263 118.572C242.244 118.722 242.229 118.87 242.217 119.02C242.151 119.829 242.16 120.643 242.229 121.45C242.24 121.583 242.252 121.713 242.267 121.845C242.281 121.982 242.299 122.119 242.317 122.256C242.318 122.269 242.321 122.28 242.323 122.294C242.333 122.378 242.344 122.461 242.361 122.547L242.361 122.549C242.391 122.764 242.429 122.979 242.468 123.193C242.475 123.233 242.483 123.272 242.49 123.31C242.495 123.339 242.501 123.371 242.507 123.4C242.581 123.761 242.664 124.114 242.761 124.468C242.807 124.644 242.858 124.819 242.909 124.993C242.962 125.17 243.015 125.344 243.071 125.517C243.098 125.598 243.124 125.679 243.152 125.758C243.177 125.836 243.206 125.918 243.235 125.998C243.242 126.019 243.248 126.04 243.257 126.062C243.264 126.084 243.272 126.105 243.279 126.127C243.3 126.182 243.32 126.24 243.341 126.295C243.362 126.356 243.384 126.414 243.405 126.474C243.455 126.775 243.509 127.074 243.569 127.373C243.598 127.522 243.629 127.67 243.661 127.818C243.661 127.82 243.663 127.82 243.662 127.822C243.693 127.97 243.726 128.116 243.76 128.263C243.761 128.265 243.76 128.269 243.761 128.271C243.766 128.294 243.771 128.315 243.776 128.336C243.792 128.407 243.807 128.477 243.825 128.549C243.84 128.62 243.858 128.689 243.875 128.758C243.909 128.896 243.943 129.034 243.98 129.171C244.001 129.257 244.024 129.341 244.047 129.427C244.06 129.48 244.075 129.533 244.089 129.585C244.089 129.586 244.09 129.587 244.09 129.589C244.109 129.655 244.126 129.722 244.144 129.785C244.183 129.927 244.225 130.068 244.264 130.21C244.271 130.256 244.301 130.296 244.341 130.333L244.13 131.094L244.112 131.158L244.114 131.16L244.055 131.371L243.931 131.821L243.874 132.023L243.747 132.478L243.694 132.675L243.693 132.676L243.569 133.137L243.315 134.07L243.277 134.211C243.275 134.206 243.273 134.203 243.273 134.199C243.189 134.01 243.105 133.821 243.024 133.628C243.023 133.626 243.022 133.623 243.021 133.619C242.947 133.443 242.875 133.269 242.803 133.093C242.788 133.053 242.772 133.014 242.758 132.976C242.689 132.802 242.622 132.627 242.556 132.451C242.506 132.311 242.455 132.172 242.409 132.031C242.388 131.971 242.368 131.914 242.348 131.854C242.188 131.388 242.039 130.917 241.901 130.442C241.81 130.126 241.725 129.808 241.644 129.487C241.524 129.007 241.418 128.524 241.328 128.038C241.297 127.876 241.269 127.714 241.242 127.551C241.188 127.227 241.139 126.9 241.094 126.573C241.071 126.409 241.052 126.247 241.033 126.082C240.994 125.755 240.961 125.427 240.934 125.098C240.905 124.768 240.884 124.44 240.866 124.11C240.836 123.492 240.827 122.874 240.837 122.256C240.844 121.865 240.858 121.472 240.882 121.082C240.889 120.956 240.898 120.829 240.907 120.704C240.934 120.33 240.968 119.956 241.012 119.583C241.026 119.451 241.04 119.32 241.058 119.189C241.062 119.154 241.067 119.12 241.072 119.088C241.094 118.915 241.117 118.744 241.143 118.572C241.146 118.551 241.149 118.531 241.154 118.512C241.18 118.333 241.208 118.156 241.239 117.979C241.27 117.794 241.304 117.61 241.34 117.426C241.359 117.317 241.383 117.207 241.405 117.099C241.425 116.999 241.445 116.898 241.467 116.799C241.487 116.706 241.509 116.613 241.53 116.521C241.552 116.413 241.578 116.309 241.605 116.202C241.625 116.106 241.649 116.013 241.675 115.921C241.697 115.826 241.72 115.73 241.746 115.636C241.776 115.52 241.805 115.406 241.838 115.291C241.865 115.191 241.892 115.093 241.922 114.994C241.937 114.94 241.951 114.888 241.969 114.836C241.988 114.762 242.01 114.687 242.033 114.616C242.041 114.587 242.05 114.558 242.058 114.53C242.074 114.484 242.087 114.44 242.1 114.397C242.107 114.378 242.111 114.358 242.118 114.339C242.156 114.222 242.194 114.103 242.232 113.985C242.277 113.851 242.322 113.715 242.368 113.582C242.719 112.57 243.128 111.579 243.595 110.614C243.784 110.229 243.979 109.848 244.183 109.472C244.286 109.284 244.392 109.096 244.499 108.909L244.506 108.912C244.509 108.903 244.511 108.892 244.514 108.883C244.515 108.879 244.517 108.876 244.52 108.872C244.694 108.571 244.874 108.271 245.058 107.976C245.137 107.852 245.215 107.73 245.294 107.607C245.299 107.597 245.307 107.587 245.314 107.579C245.391 107.455 245.47 107.336 245.551 107.217C245.584 107.167 245.618 107.117 245.653 107.068C245.687 107.015 245.724 106.962 245.761 106.91C245.816 106.83 245.871 106.75 245.928 106.671C246.043 106.504 246.161 106.339 246.283 106.177C246.415 105.997 246.548 105.82 246.684 105.646C246.984 105.255 247.297 104.87 247.618 104.497C247.689 104.414 247.761 104.332 247.832 104.249C247.961 104.102 248.092 103.956 248.223 103.814C248.303 103.724 248.386 103.637 248.467 103.549C248.504 103.509 248.541 103.469 248.58 103.43C248.657 103.347 248.737 103.263 248.818 103.182C249.454 102.525 250.121 101.895 250.819 101.298C250.921 101.211 251.022 101.127 251.125 101.04C251.209 100.97 251.294 100.901 251.379 100.832C251.456 100.768 251.535 100.704 251.613 100.643C251.782 100.508 251.955 100.374 252.127 100.242C252.248 100.149 252.37 100.059 252.494 99.9671C252.557 99.9194 252.621 99.8742 252.686 99.8271C252.836 99.7168 252.988 99.6119 253.141 99.5047C253.563 99.2089 253.994 98.9266 254.434 98.6538C254.587 98.5593 254.742 98.4656 254.896 98.3736C254.983 98.3218 255.071 98.2699 255.158 98.2203C255.408 98.0757 255.659 97.935 255.911 97.7988C255.432 98.0057 254.96 98.2271 254.494 98.4642C254.287 98.5694 254.081 98.6769 253.876 98.789C253.707 98.8802 253.541 98.9718 253.375 99.0681C253.299 99.1094 253.226 99.1513 253.154 99.1958C253.141 99.2019 253.13 99.2087 253.119 99.2155C252.966 99.3038 252.815 99.3943 252.665 99.4876C252.481 99.5987 252.298 99.7141 252.118 99.831C252.099 99.8433 252.083 99.8545 252.066 99.8656C251.871 99.9899 251.679 100.119 251.491 100.25C251.145 100.488 250.803 100.733 250.467 100.99C250.394 101.043 250.324 101.099 250.253 101.153C249.917 101.412 249.587 101.681 249.263 101.956C249.068 102.122 248.877 102.29 248.688 102.46C248.59 102.548 248.492 102.636 248.396 102.725C248.299 102.816 248.203 102.904 248.108 102.996C248.013 103.087 247.918 103.178 247.823 103.27C247.73 103.362 247.636 103.455 247.543 103.548C247.358 103.734 247.174 103.925 246.995 104.115C246.988 104.124 246.981 104.132 246.972 104.139C246.731 104.397 246.495 104.658 246.265 104.924C246.159 105.05 246.05 105.174 245.945 105.3C245.899 105.353 245.853 105.409 245.809 105.463C245.911 105.271 246.02 105.079 246.131 104.892C246.183 104.805 246.234 104.717 246.287 104.631C246.357 104.52 246.427 104.41 246.499 104.3C246.552 104.219 246.605 104.139 246.66 104.061C246.721 103.97 246.784 103.88 246.848 103.791C246.897 103.722 246.947 103.653 246.998 103.584C247.077 103.477 247.158 103.371 247.242 103.265C248.543 101.6 250.138 100.16 251.899 98.9742C253.664 97.779 255.584 96.8165 257.552 95.9619C258.535 95.534 259.536 95.1374 260.542 94.7576C260.851 94.6352 261.162 94.5178 261.472 94.3998C262.168 94.1358 262.868 93.8791 263.565 93.6132C263.29 93.6906 263.013 93.7694 262.737 93.8506C262.568 93.8996 262.402 93.9494 262.232 93.9998C261.643 94.1745 261.054 94.3555 260.464 94.5368C259.438 94.8672 258.415 95.2163 257.404 95.5986C255.381 96.3628 253.405 97.2927 251.571 98.4745C249.743 99.6645 248.071 101.126 246.733 102.871C246.151 103.632 245.633 104.44 245.198 105.294C245.133 105.421 245.072 105.547 245.011 105.676C244.792 106.156 244.595 106.65 244.432 107.151L244.42 107.183C244.405 107.235 244.388 107.288 244.372 107.341L244.361 107.373C244.133 107.703 243.91 108.036 243.697 108.377C243.318 108.952 242.992 109.559 242.655 110.16L242.191 111.086C242.034 111.393 241.908 111.714 241.765 112.029C241.439 112.786 241.141 113.555 240.88 114.336C240.822 114.504 240.768 114.672 240.717 114.842C240.693 114.92 240.668 114.996 240.646 115.072C240.622 115.148 240.601 115.227 240.579 115.303C240.518 115.516 240.459 115.727 240.404 115.942C240.054 117.278 239.796 118.642 239.645 120.018C239.498 121.395 239.442 122.782 239.478 124.168C239.5 124.687 239.535 125.205 239.583 125.723C239.647 126.413 239.735 127.103 239.843 127.787C239.872 127.957 239.901 128.129 239.93 128.299C239.938 128.344 239.946 128.387 239.954 128.432C239.983 128.59 240.014 128.75 240.046 128.906C240.079 129.072 240.115 129.236 240.153 129.4C240.163 129.45 240.175 129.501 240.187 129.549C240.218 129.686 240.25 129.824 240.285 129.96C240.389 130.382 240.504 130.798 240.625 131.214C240.554 131.109 240.487 131.003 240.421 130.899C240.363 130.805 240.307 130.709 240.254 130.615C239.81 129.819 239.548 128.928 239.286 128.019C239.152 127.567 239.018 127.116 238.888 126.664C238.823 126.437 238.761 126.212 238.698 125.985C238.637 125.76 238.577 125.533 238.521 125.305C238.05 123.494 237.791 121.647 237.955 119.788C238.101 117.928 238.555 116.091 239.046 114.262C238.821 114.802 238.61 115.35 238.417 115.906C238.374 116.028 238.335 116.149 238.294 116.272C238.251 116.403 238.21 116.533 238.171 116.665C238.095 116.908 238.024 117.156 237.957 117.402C237.928 117.51 237.899 117.62 237.873 117.729C237.863 117.763 237.854 117.796 237.846 117.831C237.82 117.944 237.793 118.059 237.768 118.173C237.748 118.254 237.732 118.337 237.714 118.419C237.697 118.491 237.683 118.562 237.671 118.634C237.599 119.001 237.538 119.369 237.492 119.741C237.444 120.097 237.414 120.457 237.396 120.818C237.387 121.056 237.383 121.3 237.384 121.54C237.387 121.781 237.396 122.022 237.409 122.26C237.416 122.381 237.425 122.501 237.436 122.621C237.526 123.581 237.715 124.525 237.944 125.451C238.184 126.375 238.46 127.283 238.748 128.184C238.775 128.267 238.802 128.352 238.83 128.436C238.911 128.689 238.995 128.944 239.087 129.201C239.148 129.37 239.212 129.539 239.279 129.708C239.325 129.821 239.372 129.932 239.423 130.042C239.548 130.319 239.69 130.589 239.854 130.849C240.184 131.376 240.566 131.847 240.965 132.298C240.968 132.307 240.971 132.317 240.975 132.326C241.865 134.969 243.194 137.399 244.551 139.749C245.24 140.919 245.925 142.083 246.638 143.246C247.354 144.407 248.093 145.562 248.918 146.665C249.737 147.769 250.625 148.831 251.612 149.805C252.101 150.295 252.623 150.752 253.165 151.188C253.431 151.409 253.72 151.604 253.997 151.813C254.065 151.866 254.14 151.911 254.211 151.959C254.285 152.008 254.357 152.056 254.443 152.082C254.473 152.092 254.505 152.101 254.539 152.107C254.551 152.111 254.563 152.113 254.577 152.114C254.635 152.123 254.697 152.126 254.767 152.12C254.786 152.119 254.804 152.116 254.821 152.114C254.826 152.113 254.83 152.113 254.835 152.112C254.812 152.176 254.788 152.242 254.762 152.304C254.746 152.343 254.731 152.382 254.713 152.42C254.7 152.451 254.685 152.484 254.67 152.515C254.654 152.549 254.637 152.584 254.619 152.617C254.603 152.654 254.585 152.688 254.567 152.721C254.55 152.722 254.533 152.72 254.518 152.721C254.532 152.722 254.549 152.724 254.566 152.723C254.531 152.787 254.496 152.851 254.458 152.912C254.393 153.02 254.326 153.124 254.25 153.227C254.222 153.272 254.19 153.315 254.156 153.357C254.14 153.379 254.123 153.4 254.105 153.421C254.066 153.473 254.025 153.524 253.981 153.572C253.976 153.581 253.969 153.587 253.96 153.594C253.913 153.652 253.863 153.706 253.81 153.761C253.79 153.782 253.77 153.802 253.748 153.822C253.708 153.865 253.664 153.909 253.618 153.95C253.598 153.97 253.574 153.991 253.55 154.011C253.508 154.053 253.463 154.092 253.414 154.13C253.397 154.147 253.38 154.162 253.359 154.178C253.305 154.225 253.25 154.269 253.193 154.313C253.135 154.356 253.079 154.397 253.02 154.44C253.051 154.466 253.082 154.491 253.116 154.516C253.123 154.52 253.129 154.525 253.136 154.529C253.17 154.554 253.204 154.578 253.241 154.599C253.287 154.63 253.336 154.658 253.388 154.684C253.413 154.699 253.438 154.712 253.463 154.723C253.47 154.727 253.476 154.729 253.484 154.732C253.515 154.749 253.551 154.763 253.585 154.78L253.602 154.785C253.655 154.808 253.711 154.83 253.766 154.849C253.82 154.867 253.877 154.885 253.933 154.9C254.021 154.927 254.111 154.947 254.201 154.966C254.205 154.965 254.207 154.966 254.211 154.967C254.306 154.985 254.402 155 254.497 155.01C254.764 155.037 255.028 155.035 255.266 155.003C255.306 154.997 255.342 154.991 255.381 154.983C255.423 154.977 255.464 154.966 255.506 154.957C255.538 154.949 255.568 154.941 255.598 154.932C255.629 154.924 255.66 154.914 255.689 154.903C255.698 154.899 255.708 154.896 255.717 154.893C255.752 154.88 255.784 154.866 255.816 154.852C255.848 154.838 255.882 154.82 255.913 154.803C255.926 154.797 255.938 154.791 255.949 154.784C255.976 154.768 256 154.753 256.025 154.737C256.036 154.728 256.047 154.721 256.057 154.712C256.067 154.705 256.076 154.699 256.084 154.692C256.116 154.669 256.146 154.643 256.174 154.617C256.176 154.616 256.178 154.617 256.179 154.615C256.212 154.586 256.242 154.555 256.272 154.523C256.332 154.459 256.385 154.391 256.428 154.32C256.451 154.286 256.471 154.251 256.49 154.215L256.492 154.21C256.506 154.183 256.519 154.156 256.531 154.128C256.544 154.101 256.555 154.076 256.565 154.047C256.574 154.029 256.582 154.011 256.589 153.992L256.592 153.981C256.613 153.927 256.63 153.872 256.645 153.816C256.648 153.808 256.651 153.801 256.652 153.791C256.667 153.735 256.681 153.676 256.694 153.62C256.696 153.61 256.698 153.602 256.699 153.594C256.719 153.494 256.736 153.39 256.749 153.287L256.749 153.285C256.756 153.248 256.761 153.209 256.764 153.17C256.769 153.132 256.772 153.093 256.777 153.054L256.777 153.053C256.779 153.036 256.781 153.018 256.782 153.002C256.783 152.975 256.785 152.946 256.787 152.917C256.835 152.954 256.885 152.993 256.935 153.029C256.987 153.068 257.039 153.107 257.091 153.146C257.097 153.151 257.102 153.155 257.109 153.159C257.175 153.207 257.242 153.258 257.307 153.304C257.317 153.312 257.329 153.32 257.339 153.328L257.602 153.486C257.818 153.616 258.039 153.745 258.261 153.871C258.284 153.883 258.305 153.896 258.328 153.909C258.333 153.912 258.338 153.916 258.345 153.919C258.453 153.979 258.56 154.04 258.668 154.098C258.849 154.197 259.037 154.273 259.225 154.357L259.79 154.601C259.98 154.678 260.165 154.765 260.358 154.834L261.518 155.236C261.712 155.303 261.905 155.37 262.103 155.42L263.286 155.748C263.472 155.798 263.655 155.838 263.842 155.878C263.936 155.898 264.028 155.917 264.122 155.937C264.215 155.956 264.307 155.976 264.401 155.996C264.429 156.001 264.456 156.008 264.483 156.014L265.083 156.137L265.689 156.23C266.093 156.285 266.496 156.358 266.901 156.404L268.118 156.518L268.425 156.547L268.729 156.56L269.339 156.583C269.746 156.598 270.153 156.621 270.56 156.609L271.781 156.596C272.187 156.579 272.593 156.551 272.998 156.525C273.201 156.511 273.405 156.504 273.606 156.486L273.768 156.468L274.212 156.42C274.615 156.374 275.021 156.345 275.422 156.283L275.716 156.238L276.625 156.1C277.026 156.041 277.421 155.947 277.82 155.874C279.412 155.552 280.978 155.166 282.531 154.643C283.336 154.373 284.138 154.053 284.917 153.678L284.919 153.679C285.06 153.648 285.199 153.618 285.339 153.585C285.35 153.582 285.362 153.58 285.373 153.578C285.509 153.545 285.644 153.512 285.779 153.476C285.883 153.451 285.985 153.423 286.088 153.392C286.246 153.35 286.403 153.303 286.561 153.255C286.66 153.226 286.76 153.193 286.859 153.16C286.875 153.157 286.89 153.152 286.904 153.146C287.002 153.114 287.097 153.082 287.193 153.048C287.305 153.009 287.416 152.969 287.527 152.928C287.527 152.928 287.529 152.929 287.53 152.927C287.548 152.921 287.568 152.913 287.588 152.905C287.713 152.86 287.835 152.812 287.957 152.762C288.07 152.716 288.183 152.669 288.296 152.622C288.362 152.597 288.429 152.567 288.496 152.538C288.761 152.425 289.021 152.307 289.279 152.184C289.408 152.121 289.537 152.058 289.665 151.993C289.921 151.863 290.172 151.727 290.422 151.584C291.79 150.803 293.064 149.85 294.215 148.771C295.042 147.973 295.803 147.108 296.487 146.187C297.156 145.254 297.751 144.279 298.313 143.296C298.455 143.051 298.595 142.806 298.735 142.56C298.877 142.315 299.017 142.068 299.155 141.821C299.295 141.575 299.436 141.329 299.574 141.082C299.712 140.835 299.851 140.588 299.989 140.341C300.127 140.095 300.264 139.847 300.401 139.598C300.485 139.447 300.567 139.295 300.651 139.145C300.761 138.941 300.872 138.737 300.983 138.532C301.107 138.303 301.231 138.074 301.352 137.845C301.441 137.681 301.528 137.52 301.615 137.356C301.361 137.73 301.109 138.104 300.861 138.479C300.747 138.65 300.633 138.821 300.52 138.995C300.413 139.156 300.307 139.317 300.202 139.478C300.046 139.715 299.892 139.952 299.738 140.191C299.584 140.429 299.432 140.667 299.278 140.904C299.076 141.219 298.875 141.537 298.675 141.853C298.42 142.253 298.168 142.654 297.915 143.055C297.838 143.174 297.763 143.293 297.688 143.413C297.461 143.77 297.234 144.125 297 144.478C296.691 144.946 296.373 145.406 296.034 145.851C295.694 146.293 295.339 146.724 294.968 147.138C294.784 147.346 294.593 147.55 294.4 147.75C294.206 147.95 294.007 148.147 293.806 148.338C293.724 148.417 293.642 148.496 293.558 148.572C293.499 148.628 293.442 148.682 293.383 148.733C293.246 148.858 293.106 148.978 292.965 149.098C292.906 149.149 292.846 149.198 292.787 149.247C292.436 149.538 292.076 149.815 291.707 150.083C291.541 150.205 291.374 150.323 291.205 150.44C291.049 150.542 290.897 150.651 290.742 150.755C290.739 150.756 290.738 150.758 290.736 150.76C290.662 150.81 290.586 150.857 290.509 150.904L289.792 151.338C289.669 151.405 289.547 151.472 289.425 151.539C289.178 151.673 288.934 151.807 288.684 151.933C288.559 151.995 288.434 152.058 288.307 152.116C288.137 152.199 287.969 152.277 287.797 152.352C287.672 152.408 287.548 152.462 287.423 152.513C287.358 152.543 287.292 152.571 287.226 152.597C287.105 152.647 286.983 152.696 286.859 152.743C286.781 152.775 286.701 152.804 286.621 152.835C286.494 152.884 286.366 152.93 286.237 152.976C286.351 152.908 286.466 152.84 286.578 152.77C286.719 152.686 286.857 152.597 286.994 152.506C287.139 152.408 287.283 152.311 287.427 152.211C287.621 152.076 287.812 151.936 288.003 151.794C288.142 151.69 288.278 151.584 288.414 151.477C288.439 151.459 288.465 151.438 288.491 151.418C288.61 151.324 288.727 151.23 288.843 151.133C289.485 150.606 290.099 150.05 290.69 149.48C290.719 149.452 290.747 149.426 290.776 149.398C290.958 149.219 291.14 149.04 291.318 148.86C291.465 148.715 291.609 148.567 291.753 148.418C291.763 148.409 291.772 148.4 291.782 148.39C291.92 148.247 292.061 148.102 292.198 147.955C292.362 147.785 292.523 147.613 292.684 147.439C292.816 147.295 292.949 147.15 293.081 147.006C293.108 146.977 293.135 146.947 293.161 146.916C293.304 146.759 293.445 146.601 293.582 146.44C293.73 146.275 293.875 146.106 294.02 145.937C294.02 145.935 294.023 145.934 294.024 145.932C294.158 145.774 294.291 145.616 294.422 145.457C294.492 145.376 294.561 145.292 294.628 145.209C294.767 145.04 294.904 144.87 295.038 144.7C295.127 144.589 295.214 144.479 295.301 144.368C295.415 144.222 295.529 144.074 295.642 143.925C295.696 143.856 295.75 143.786 295.801 143.716C296.215 143.166 296.616 142.606 297.004 142.035C297.42 141.417 297.819 140.788 298.199 140.147C298.301 139.976 298.401 139.803 298.502 139.629C298.551 139.54 298.6 139.454 298.65 139.366C298.699 139.278 298.747 139.189 298.794 139.103C298.817 139.06 298.839 139.019 298.863 138.977C298.931 138.853 298.998 138.727 299.064 138.602C299.159 138.566 299.253 138.525 299.347 138.483C299.355 138.48 299.365 138.477 299.372 138.473C299.632 138.356 299.885 138.226 300.13 138.079C300.135 138.076 300.141 138.072 300.146 138.069C300.245 138.009 300.342 137.948 300.439 137.882C300.442 137.879 300.448 137.875 300.453 137.873C300.554 137.804 300.652 137.735 300.749 137.662C301.552 137.079 302.226 136.325 302.76 135.482C302.825 135.376 302.888 135.267 302.946 135.159C303.037 134.994 303.122 134.828 303.2 134.657C303.28 134.489 303.354 134.317 303.421 134.142C303.47 134.007 303.516 133.874 303.561 133.739C303.581 133.675 303.601 133.61 303.621 133.547L303.613 133.556ZM284.583 127.581C284.693 127.526 284.802 127.471 284.908 127.413C285.003 127.364 285.097 127.314 285.19 127.263C285.204 127.255 285.216 127.249 285.23 127.241C285.336 127.183 285.441 127.124 285.544 127.063C285.565 127.052 285.585 127.042 285.604 127.029C285.701 126.974 285.798 126.915 285.891 126.857C285.903 126.853 285.912 126.846 285.921 126.84C285.934 126.832 285.948 126.822 285.963 126.815L285.964 126.813C286.009 126.786 286.051 126.761 286.094 126.734C286.188 126.676 286.282 126.618 286.375 126.558C286.513 126.47 286.646 126.382 286.781 126.292C287.052 126.106 287.316 125.913 287.577 125.715C287.646 125.663 287.714 125.613 287.78 125.56C287.792 125.549 287.806 125.541 287.818 125.531L287.818 125.529C287.942 125.433 288.068 125.333 288.189 125.232C288.315 125.13 288.439 125.026 288.562 124.921C288.571 124.914 288.58 124.904 288.589 124.897C288.601 124.888 288.613 124.878 288.622 124.868C288.625 124.867 288.625 124.865 288.628 124.864C288.643 124.85 288.658 124.838 288.675 124.825L288.676 124.824C288.694 124.807 288.715 124.789 288.734 124.772C288.77 124.74 288.806 124.709 288.843 124.675C288.849 124.671 288.854 124.668 288.858 124.663C288.86 124.662 288.861 124.661 288.861 124.66C288.867 124.656 288.87 124.653 288.874 124.648C288.883 124.638 288.892 124.633 288.903 124.624L288.904 124.622C288.91 124.616 288.918 124.612 288.924 124.606C288.983 124.553 289.044 124.498 289.102 124.444C289.176 124.377 289.251 124.308 289.325 124.24C289.434 124.138 289.542 124.035 289.645 123.931C289.742 123.839 289.835 123.747 289.927 123.652C290.197 123.38 290.46 123.1 290.715 122.813C290.804 122.716 290.891 122.616 290.979 122.515C291.034 122.452 291.089 122.387 291.145 122.322C291.206 122.249 291.268 122.175 291.329 122.102C291.335 122.096 291.342 122.088 291.347 122.079C291.395 122.022 291.442 121.964 291.489 121.907C291.49 121.905 291.493 121.902 291.494 121.9C291.505 121.885 291.517 121.87 291.528 121.855C291.542 121.841 291.553 121.826 291.565 121.811C291.571 121.805 291.578 121.796 291.583 121.788C291.59 121.781 291.597 121.773 291.601 121.766C291.604 121.763 291.608 121.76 291.61 121.755C291.744 121.586 291.876 121.417 292.005 121.245C292.09 121.135 292.172 121.025 292.254 120.912C292.334 120.801 292.416 120.688 292.495 120.575C292.611 120.41 292.726 120.244 292.839 120.076C292.89 120.002 292.939 119.926 292.989 119.851C293.132 119.633 293.274 119.412 293.41 119.188C293.546 118.962 293.676 118.731 293.804 118.497C293.781 118.824 293.752 119.151 293.719 119.476C293.704 119.627 293.688 119.779 293.671 119.93C293.661 120.025 293.65 120.118 293.639 120.211C293.638 120.234 293.634 120.256 293.631 120.278C293.625 120.337 293.618 120.394 293.61 120.452C293.608 120.477 293.606 120.501 293.602 120.525C293.596 120.578 293.588 120.632 293.58 120.684C293.546 120.954 293.509 121.224 293.466 121.493C293.447 121.628 293.425 121.763 293.402 121.897C293.36 122.166 293.311 122.434 293.261 122.7C293.237 122.835 293.21 122.969 293.182 123.103C293.155 123.235 293.128 123.368 293.099 123.501C293.084 123.574 293.07 123.645 293.054 123.717C293.045 123.754 293.038 123.792 293.03 123.829C293.027 123.841 293.024 123.852 293.022 123.864C293.009 123.925 292.994 123.985 292.98 124.046C292.938 124.246 292.891 124.447 292.841 124.646C292.794 124.847 292.745 125.045 292.693 125.244C292.644 125.432 292.596 125.621 292.544 125.807C292.534 125.84 292.525 125.873 292.516 125.905C292.484 126.021 292.452 126.138 292.419 126.253C292.402 126.314 292.386 126.372 292.365 126.432C292.362 126.44 292.362 126.448 292.359 126.456L292.358 126.457C292.339 126.525 292.321 126.59 292.299 126.658C292.289 126.693 292.279 126.727 292.27 126.762L292.213 126.944C292.184 127.04 292.155 127.135 292.124 127.231C292.118 127.248 292.113 127.268 292.107 127.285L292.092 127.33C292.081 127.366 292.07 127.405 292.057 127.44L292.057 127.442C292.046 127.481 292.034 127.514 292.021 127.552C291.996 127.63 291.969 127.707 291.944 127.785C291.926 127.839 291.908 127.896 291.889 127.951C291.811 128.181 291.732 128.41 291.65 128.639L291.648 128.644C291.596 128.789 291.544 128.934 291.49 129.078C291.428 129.249 291.363 129.417 291.298 129.587L291.286 129.623C291.22 129.789 291.154 129.956 291.087 130.122C291.103 130.06 291.12 129.999 291.135 129.937C291.145 129.896 291.154 129.857 291.164 129.816L291.165 129.812C291.292 129.3 291.402 128.784 291.493 128.266C291.457 128.38 291.42 128.494 291.383 128.607C291.221 129.109 291.049 129.608 290.863 130.101C290.53 130.993 290.16 131.867 289.749 132.718C289.747 132.722 289.744 132.725 289.743 132.729C289.732 132.755 289.718 132.782 289.705 132.807C289.639 132.944 289.57 133.08 289.5 133.216C289.49 133.238 289.481 133.258 289.47 133.279C289.456 133.308 289.441 133.337 289.425 133.365C289.354 133.504 289.282 133.644 289.207 133.78C289.14 133.908 289.07 134.036 289 134.161C288.971 134.214 288.942 134.267 288.911 134.318C288.85 134.429 288.787 134.538 288.721 134.648C288.682 134.716 288.642 134.785 288.6 134.852C288.522 134.985 288.441 135.115 288.359 135.247C288.266 135.395 288.168 135.544 288.07 135.692C287.973 135.839 287.876 135.985 287.775 136.131C287.768 136.143 287.76 136.153 287.752 136.165C287.743 136.179 287.734 136.193 287.726 136.204C287.71 136.224 287.698 136.243 287.684 136.264C287.702 136.226 287.72 136.19 287.736 136.151C287.744 136.133 287.752 136.117 287.76 136.098C287.764 136.093 287.766 136.088 287.769 136.08L287.77 136.078C287.774 136.072 287.779 136.065 287.782 136.055C287.795 136.028 287.807 136.001 287.821 135.974C287.849 135.91 287.88 135.845 287.909 135.781C287.943 135.704 287.977 135.627 288.008 135.55C288.037 135.482 288.065 135.414 288.093 135.346C288.108 135.309 288.123 135.272 288.137 135.237C288.185 135.118 288.231 134.998 288.274 134.878C288.28 134.867 288.284 134.858 288.287 134.846C288.288 134.845 288.291 134.841 288.292 134.84C288.293 134.836 288.293 134.831 288.293 134.829C288.375 134.612 288.451 134.393 288.525 134.173C288.566 134.054 288.606 133.934 288.645 133.814L288.65 133.801C288.67 133.737 288.689 133.676 288.71 133.611C288.789 133.344 288.865 133.077 288.937 132.81C288.969 132.694 288.999 132.581 289.028 132.467C289.084 132.25 289.138 132.035 289.187 131.82C289.219 131.692 289.249 131.564 289.277 131.434C289.434 130.695 289.589 129.957 289.713 129.216C289.976 127.738 290.21 126.253 290.367 124.75C290.247 125.109 290.131 125.469 290.021 125.828C289.981 125.954 289.945 126.076 289.908 126.2C289.838 126.435 289.769 126.67 289.7 126.905C289.633 127.141 289.564 127.376 289.499 127.612C289.44 127.823 289.384 128.034 289.328 128.246C289.252 128.525 289.178 128.805 289.107 129.083C288.91 129.809 288.742 130.536 288.545 131.256C288.36 131.977 288.168 132.696 287.945 133.4C287.925 133.463 287.907 133.528 287.885 133.59C287.85 133.711 287.813 133.829 287.774 133.948L287.766 133.97C287.716 134.126 287.665 134.281 287.612 134.433C287.54 134.641 287.463 134.849 287.385 135.056L287.385 135.058C287.305 135.27 287.221 135.481 287.136 135.69C287.103 135.773 287.069 135.854 287.034 135.936C287 136.015 286.966 136.096 286.93 136.174C286.909 136.222 286.889 136.267 286.869 136.315L286.868 136.317C286.833 136.393 286.799 136.468 286.764 136.544C286.691 136.706 286.615 136.865 286.537 137.023C286.46 137.184 286.38 137.342 286.298 137.499C286.099 137.878 285.89 138.255 285.67 138.625C285.597 138.749 285.523 138.871 285.447 138.994C285.283 139.162 285.115 139.33 284.946 139.492C284.607 139.819 284.256 140.133 283.893 140.431C283.867 140.453 283.84 140.476 283.812 140.495C283.656 140.623 283.499 140.747 283.339 140.869C283.06 141.09 282.773 141.3 282.478 141.501C282.416 141.545 282.353 141.586 282.288 141.627L282.288 141.629C282.271 141.64 282.257 141.65 282.241 141.659C282.093 141.759 281.942 141.854 281.791 141.949C281.621 142.057 281.448 142.163 281.273 142.265C281.191 142.312 281.11 142.36 281.028 142.407C281.028 142.407 281.027 142.408 281.025 142.411C280.92 142.469 280.815 142.528 280.711 142.586C280.617 142.638 280.522 142.689 280.428 142.74C280.334 142.792 280.239 142.843 280.143 142.894C280.026 142.957 279.908 143.019 279.787 143.078C279.763 143.091 279.737 143.105 279.712 143.117C279.687 143.13 279.661 143.144 279.635 143.156C279.596 143.178 279.555 143.198 279.51 143.218C279.508 143.219 279.505 143.221 279.505 143.223C279.492 143.229 279.479 143.237 279.464 143.242C279.387 143.281 279.311 143.32 279.233 143.356C279.23 143.357 279.23 143.359 279.227 143.36C279.159 143.393 279.088 143.428 279.017 143.46C278.661 143.632 278.3 143.797 277.939 143.958C277.767 144.036 277.594 144.11 277.422 144.186L277.417 144.188C277.258 144.257 277.097 144.328 276.938 144.397C277.287 144.151 277.625 143.892 277.954 143.618C278.078 143.515 278.199 143.41 278.32 143.302C278.356 143.273 278.389 143.242 278.423 143.212C278.442 143.193 278.463 143.175 278.483 143.154C278.522 143.122 278.557 143.087 278.592 143.053L278.597 143.051C278.612 143.037 278.626 143.023 278.641 143.009C278.73 142.928 278.818 142.845 278.903 142.759C279.039 142.627 279.17 142.493 279.3 142.355C279.316 142.337 279.333 142.32 279.35 142.301C279.416 142.233 279.481 142.161 279.543 142.09C279.555 142.079 279.566 142.066 279.576 142.055C279.59 142.041 279.601 142.028 279.614 142.013L279.615 142.011C279.742 141.87 279.865 141.728 279.987 141.582L279.988 141.58C279.997 141.573 280.004 141.563 280.011 141.555C280.073 141.479 280.135 141.404 280.198 141.327C280.232 141.284 280.266 141.241 280.3 141.198C280.3 141.196 280.303 141.195 280.303 141.193C280.357 141.125 280.41 141.057 280.461 140.987C280.837 140.493 281.186 139.978 281.516 139.457C281.913 138.807 282.285 138.146 282.635 137.477C282.975 136.801 283.313 136.128 283.622 135.444C283.747 135.175 283.87 134.906 283.992 134.637C284.109 134.38 284.225 134.126 284.337 133.868C284.344 133.855 284.349 133.84 284.355 133.828L284.357 133.822C284.363 133.811 284.368 133.796 284.374 133.786L284.375 133.782C284.495 133.51 284.614 133.235 284.73 132.961C284.846 132.686 284.958 132.411 285.071 132.134C285.086 132.099 285.1 132.062 285.115 132.027L285.117 132.019C285.181 131.86 285.245 131.699 285.305 131.539C285.338 131.457 285.369 131.378 285.4 131.296C285.329 131.402 285.261 131.509 285.192 131.615L285.191 131.617C285.173 131.645 285.156 131.67 285.14 131.699C285.02 131.88 284.904 132.063 284.789 132.249C284.775 132.27 284.761 132.292 284.748 132.313L284.747 132.315C284.741 132.325 284.734 132.335 284.728 132.346C284.654 132.461 284.582 132.577 284.512 132.694L284.512 132.696C284.497 132.719 284.483 132.741 284.469 132.764C284.376 132.917 284.284 133.068 284.192 133.222C283.807 133.863 283.434 134.509 283.069 135.16C282.694 135.811 282.346 136.474 281.972 137.117C281.79 137.441 281.606 137.765 281.418 138.087C281.232 138.406 281.039 138.723 280.841 139.035C280.784 139.127 280.726 139.219 280.669 139.311C280.617 139.396 280.563 139.478 280.508 139.562C280.504 139.569 280.499 139.576 280.495 139.583C280.491 139.588 280.489 139.593 280.485 139.598C280.301 139.88 280.114 140.159 279.92 140.433L279.919 140.436C279.913 140.443 279.908 140.449 279.904 140.456C279.825 140.568 279.744 140.679 279.662 140.789C279.565 140.922 279.467 141.052 279.368 141.18C279.346 141.207 279.326 141.233 279.304 141.261C279.235 141.351 279.163 141.442 279.09 141.531C278.806 141.889 278.509 142.237 278.199 142.576C278.182 142.595 278.162 142.616 278.145 142.635L278.142 142.636C278.041 142.747 277.938 142.856 277.834 142.965C277.791 143.011 277.745 143.059 277.7 143.104C277.621 143.185 277.543 143.265 277.463 143.344C277.231 143.575 276.994 143.803 276.752 144.027C276.635 144.133 276.518 144.24 276.4 144.345C276.385 144.358 276.367 144.373 276.351 144.387C276.295 144.439 276.236 144.49 276.176 144.541C276.043 144.657 275.908 144.772 275.771 144.887C275.754 144.894 275.739 144.901 275.722 144.908C275.712 144.913 275.701 144.915 275.69 144.92C275.546 144.978 275.406 145.037 275.261 145.096C275.253 145.099 275.247 145.101 275.239 145.105C275.124 145.149 275.01 145.198 274.896 145.245C274.301 145.489 273.708 145.741 273.113 145.964C272.986 146.013 272.858 146.059 272.731 146.105C272.611 146.148 272.49 146.188 272.37 146.224C272.318 146.24 272.268 146.258 272.216 146.272C272.129 146.298 272.042 146.325 271.954 146.348C271.952 146.349 271.951 146.351 271.949 146.35C271.849 146.378 271.749 146.405 271.648 146.429C271.77 146.34 271.889 146.251 272.009 146.16C272.168 146.041 272.325 145.916 272.481 145.789C272.481 145.789 272.481 145.787 272.483 145.788C272.544 145.739 272.607 145.691 272.666 145.642C272.728 145.592 272.792 145.543 272.851 145.493C272.913 145.443 272.972 145.394 273.032 145.343C273.304 145.118 273.571 144.886 273.839 144.654L273.842 144.653C273.857 144.64 273.872 144.628 273.887 144.614C274.056 144.46 274.225 144.304 274.394 144.149C274.563 143.995 274.731 143.839 274.895 143.681C275.005 143.575 275.114 143.468 275.221 143.36C275.388 143.194 275.553 143.03 275.714 142.861C275.878 142.694 276.04 142.525 276.197 142.354C276.256 142.295 276.312 142.232 276.368 142.172C276.379 142.158 276.389 142.147 276.4 142.134C276.427 142.105 276.453 142.079 276.478 142.049C276.545 141.98 276.608 141.907 276.672 141.837C276.828 141.661 276.982 141.485 277.133 141.308C277.32 141.093 277.501 140.873 277.679 140.651C278.444 139.703 279.169 138.718 279.813 137.682C279.892 137.557 279.969 137.433 280.044 137.307C280.122 137.18 280.197 137.055 280.272 136.929C280.373 136.757 280.472 136.588 280.572 136.416L280.574 136.41C280.622 136.327 280.669 136.247 280.714 136.164C280.716 136.158 280.719 136.155 280.721 136.15C280.781 136.044 280.841 135.938 280.899 135.832C280.933 135.77 280.967 135.71 280.999 135.647C281.056 135.543 281.111 135.438 281.165 135.332C281.227 135.213 281.291 135.092 281.349 134.971C281.431 134.809 281.509 134.649 281.587 134.487C281.648 134.358 281.708 134.228 281.768 134.097C281.827 133.971 281.883 133.844 281.94 133.716L281.945 133.703C281.992 133.597 282.039 133.492 282.085 133.383L282.086 133.381C282.098 133.352 282.111 133.322 282.124 133.291C282.172 133.181 282.219 133.072 282.264 132.959C282.349 132.757 282.431 132.551 282.511 132.345C282.557 132.23 282.601 132.115 282.644 131.997L282.645 131.995C282.757 131.702 282.862 131.405 282.964 131.105C282.988 131.031 283.014 130.956 283.037 130.882C283.051 130.843 283.063 130.803 283.076 130.763C283.086 130.729 283.098 130.695 283.108 130.66C283.118 130.632 283.126 130.601 283.136 130.573C283.165 130.484 283.192 130.394 283.216 130.304C283.263 130.152 283.308 129.997 283.351 129.843C283.44 129.537 283.522 129.228 283.598 128.92C283.614 128.86 283.628 128.802 283.643 128.741L283.643 128.74C283.672 128.625 283.699 128.513 283.726 128.398C283.759 128.266 283.788 128.133 283.819 128C283.819 127.996 283.82 127.992 283.821 127.988C283.838 127.916 283.854 127.846 283.871 127.774L283.926 127.894C284.15 127.795 284.369 127.692 284.586 127.582L284.583 127.581ZM257.225 151.018C257.15 151.029 257.077 151.04 257.001 151.051C256.926 151.061 256.853 151.072 256.779 151.082C256.74 151.087 256.699 151.094 256.658 151.097C256.634 151.101 256.609 151.105 256.585 151.107C256.545 151.115 256.503 151.119 256.461 151.124C256.404 151.131 256.345 151.138 256.285 151.145C256.272 151.147 256.261 151.149 256.248 151.151L256.176 151.157C256.174 151.158 256.172 151.158 256.171 151.158C256.171 151.158 256.169 151.159 256.167 151.159L256.028 151.176C255.948 151.03 255.871 150.881 255.797 150.731C255.794 150.728 255.79 150.72 255.788 150.715C255.713 150.565 255.642 150.414 255.57 150.261L255.571 150.259C255.551 150.219 255.534 150.177 255.514 150.136C255.481 150.057 255.445 149.977 255.412 149.898L255.41 149.896C255.318 149.676 255.232 149.457 255.15 149.232C255.14 149.206 255.131 149.182 255.122 149.155C255.077 149.034 255.035 148.912 254.995 148.791C254.956 148.674 254.918 148.558 254.881 148.44C254.807 148.205 254.738 147.967 254.675 147.728C254.653 147.647 254.633 147.566 254.613 147.483C254.584 147.372 254.557 147.261 254.532 147.15C254.503 147.026 254.476 146.903 254.452 146.781C254.391 146.493 254.34 146.205 254.293 145.915C254.29 145.899 254.287 145.881 254.286 145.866C254.272 145.786 254.26 145.705 254.25 145.624C254.235 145.528 254.222 145.431 254.211 145.335L254.209 145.322C254.207 145.306 254.205 145.293 254.204 145.278C254.199 145.238 254.193 145.198 254.188 145.159C254.365 144.99 254.542 144.824 254.72 144.663C254.743 144.641 254.767 144.62 254.79 144.6L254.791 144.598C254.816 144.575 254.841 144.552 254.865 144.531C254.942 144.461 255.02 144.393 255.098 144.326C255.175 144.256 255.254 144.188 255.334 144.121L255.334 144.12C255.481 143.993 255.63 143.87 255.781 143.75C255.802 143.732 255.824 143.714 255.845 143.696C255.871 143.676 255.896 143.655 255.922 143.634C255.997 143.574 256.073 143.514 256.149 143.454C256.238 143.386 256.327 143.318 256.415 143.252C256.436 143.234 256.458 143.218 256.481 143.201C256.524 143.167 256.568 143.134 256.613 143.101C256.93 142.866 257.253 142.638 257.58 142.419L257.58 142.417C257.585 142.417 257.587 142.415 257.591 142.412C257.626 142.389 257.664 142.364 257.7 142.341C257.725 142.324 257.749 142.307 257.778 142.292C257.781 142.289 257.782 142.287 257.784 142.285C257.834 142.252 257.885 142.219 257.939 142.187C257.958 142.175 257.977 142.162 257.996 142.15C258.106 142.076 258.219 142.006 258.335 141.937C258.352 141.924 258.37 141.914 258.389 141.903C258.422 141.881 258.456 141.861 258.488 141.841C258.617 141.761 258.748 141.682 258.879 141.606C258.994 141.538 259.107 141.472 259.226 141.408C259.242 141.399 259.26 141.388 259.276 141.379L259.277 141.377C259.389 141.315 259.496 141.255 259.606 141.192C259.762 141.105 259.919 141.019 260.078 140.931C260.216 140.854 260.357 140.777 260.497 140.699C260.419 140.706 260.34 140.714 260.261 140.725C260.219 140.729 260.178 140.734 260.137 140.741C260.063 140.749 259.991 140.762 259.917 140.774C259.863 140.785 259.808 140.795 259.754 140.806C259.671 140.82 259.589 140.839 259.508 140.858C259.467 140.867 259.428 140.876 259.388 140.888C259.359 140.894 259.33 140.904 259.301 140.91C259.284 140.915 259.268 140.92 259.251 140.925C259.151 140.951 259.051 140.98 258.954 141.011C258.905 141.026 258.857 141.043 258.809 141.058L258.807 141.059C258.678 141.101 258.553 141.146 258.429 141.196C258.414 141.201 258.4 141.207 258.385 141.212C258.324 141.235 258.264 141.258 258.204 141.284C258.167 141.299 258.132 141.314 258.098 141.33C258.08 141.338 258.06 141.346 258.043 141.355L258.041 141.354C257.482 141.598 256.947 141.895 256.446 142.242L256.445 142.244C256.393 142.278 256.341 142.315 256.29 142.352L256.137 142.463C256.115 142.479 256.095 142.495 256.072 142.512C255.992 142.573 255.913 142.637 255.832 142.699C255.812 142.713 255.795 142.728 255.777 142.743C255.733 142.778 255.691 142.814 255.649 142.85C255.605 142.886 255.563 142.922 255.523 142.958C255.439 143.03 255.356 143.105 255.275 143.182L255.274 143.184C255.252 143.205 255.227 143.227 255.207 143.249C255.136 143.315 255.068 143.382 255 143.451C254.91 143.54 254.824 143.632 254.738 143.726L254.737 143.728C254.681 143.789 254.626 143.85 254.572 143.913C254.517 143.974 254.463 144.038 254.412 144.101C254.31 144.224 254.216 144.349 254.121 144.479C254.079 143.954 254.059 143.429 254.06 142.905C254.061 142.659 254.066 142.414 254.076 142.172C254.082 142.077 254.087 141.982 254.093 141.887C254.098 141.775 254.106 141.662 254.117 141.55C254.123 141.478 254.128 141.408 254.136 141.337C254.138 141.313 254.14 141.288 254.142 141.264C254.155 141.15 254.166 141.036 254.18 140.923C254.19 140.848 254.198 140.775 254.209 140.701C254.23 140.536 254.255 140.374 254.285 140.21C254.289 140.186 254.293 140.16 254.297 140.136C254.303 140.096 254.312 140.059 254.318 140.021C254.325 139.983 254.334 139.946 254.341 139.907C254.343 139.895 254.347 139.883 254.349 139.871C254.368 139.787 254.385 139.702 254.402 139.616C254.466 139.304 254.528 138.99 254.592 138.677C254.654 138.372 254.72 138.066 254.79 137.762C254.815 137.659 254.839 137.558 254.864 137.455C254.867 137.442 254.872 137.427 254.875 137.413C254.888 137.356 254.904 137.298 254.919 137.243C254.925 137.219 254.931 137.198 254.938 137.175C254.964 137.083 254.988 136.988 255.016 136.897C255.036 136.828 255.055 136.761 255.073 136.691C255.091 136.62 255.109 136.55 255.129 136.479L255.13 136.477C255.136 136.446 255.145 136.415 255.154 136.384C255.168 136.324 255.184 136.266 255.199 136.206C255.431 136.017 255.666 135.831 255.903 135.652C255.908 135.648 255.915 135.642 255.922 135.638C256.002 135.577 256.082 135.516 256.164 135.457C256.212 135.422 256.258 135.388 256.305 135.354C256.339 135.33 256.373 135.303 256.407 135.279C256.508 135.207 256.609 135.134 256.713 135.065C256.894 134.938 257.077 134.815 257.264 134.696C257.272 134.691 257.28 134.687 257.288 134.681C257.293 134.679 257.296 134.676 257.302 134.673C257.442 134.585 257.581 134.499 257.722 134.415C257.74 134.404 257.759 134.394 257.775 134.383C257.783 134.379 257.788 134.376 257.793 134.372C258.119 134.18 258.449 133.995 258.782 133.822C258.941 133.74 259.099 133.66 259.259 133.583C259.361 133.532 259.464 133.483 259.566 133.437C259.77 133.343 259.973 133.254 260.178 133.167C260.324 133.106 260.469 133.046 260.617 132.99C260.724 132.948 260.832 132.905 260.939 132.869C260.978 132.853 261.017 132.839 261.055 132.825C261.089 132.813 261.123 132.8 261.156 132.788C261.313 132.733 261.47 132.678 261.627 132.627C261.7 132.604 261.772 132.58 261.843 132.559C261.95 132.524 262.056 132.491 262.163 132.461C262.184 132.454 262.208 132.447 262.231 132.44C262.253 132.433 262.276 132.426 262.298 132.419C262.321 132.412 262.344 132.406 262.37 132.398C262.485 132.366 262.599 132.334 262.714 132.304C262.769 132.287 262.824 132.275 262.879 132.26C263.023 132.224 263.168 132.187 263.312 132.154C263.575 132.093 263.839 132.037 264.106 131.989C264.209 131.967 264.312 131.948 264.416 131.934C264.47 131.923 264.526 131.913 264.582 131.905C264.687 131.887 264.796 131.87 264.903 131.854C265.119 131.821 265.333 131.792 265.55 131.767C265.659 131.752 265.768 131.739 265.877 131.729C266.082 131.705 266.286 131.685 266.492 131.668L266.495 131.667C266.477 131.718 266.461 131.771 266.443 131.822C266.439 131.833 266.435 131.846 266.433 131.858C266.395 131.967 266.361 132.078 266.325 132.187C266.304 132.252 266.283 132.314 266.265 132.377C266.245 132.442 266.223 132.504 266.206 132.568C266.182 132.642 266.158 132.716 266.136 132.792C266.107 132.881 266.084 132.968 266.058 133.055C266.016 133.194 265.975 133.336 265.934 133.478C265.924 133.512 265.914 133.547 265.905 133.579C265.895 133.614 265.885 133.649 265.878 133.684C265.868 133.71 265.862 133.735 265.855 133.762L265.851 133.772C265.844 133.805 265.834 133.839 265.825 133.872C265.81 133.928 265.795 133.982 265.782 134.038C265.739 134.199 265.697 134.361 265.658 134.522C265.614 134.699 265.57 134.875 265.529 135.053C265.501 135.171 265.472 135.29 265.446 135.409C265.413 135.545 265.383 135.682 265.354 135.819C265.314 135.995 265.276 136.171 265.24 136.349C265.199 136.541 265.159 136.733 265.122 136.927C265.098 137.045 265.076 137.162 265.053 137.278C265.02 137.452 264.987 137.626 264.956 137.799C264.886 138.185 264.819 138.572 264.756 138.959C264.748 139.013 264.739 139.065 264.732 139.119C264.705 139.285 264.679 139.45 264.654 139.619C264.632 139.757 264.611 139.894 264.592 140.033C264.584 140.088 264.577 140.14 264.568 140.194C264.518 140.539 264.471 140.882 264.427 141.228C264.347 141.853 264.267 142.48 264.199 143.107C264.134 143.736 264.054 144.356 264.015 145.004C263.981 145.648 263.987 146.309 264.124 146.965C264.133 147.006 264.141 147.049 264.152 147.091C264.218 147.375 264.318 147.656 264.453 147.92C264.472 147.956 264.491 147.992 264.512 148.029C264.53 148.06 264.548 148.094 264.569 148.125C264.575 148.137 264.584 148.149 264.591 148.159C264.593 148.164 264.598 148.17 264.6 148.175C264.63 148.222 264.661 148.266 264.694 148.311C264.73 148.361 264.766 148.41 264.804 148.457C264.833 148.494 264.863 148.53 264.895 148.564C264.945 148.622 264.998 148.676 265.051 148.728C264.994 148.755 264.937 148.779 264.88 148.804C264.845 148.819 264.808 148.835 264.773 148.849C264.681 148.891 264.589 148.93 264.496 148.968C264.484 148.974 264.474 148.979 264.462 148.983C263.795 149.266 263.115 149.525 262.432 149.76C261.321 150.131 260.193 150.45 259.05 150.693C258.705 150.765 258.359 150.833 258.013 150.894C258.011 150.895 258.006 150.896 258.005 150.895C257.863 150.92 257.72 150.944 257.578 150.966C257.459 150.986 257.339 151.004 257.222 151.02L257.225 151.018ZM258.484 152.436C258.439 152.443 258.395 152.449 258.35 152.457C258.33 152.448 258.309 152.44 258.287 152.431C258.184 152.388 258.081 152.346 257.976 152.304C258.116 152.281 258.259 152.256 258.401 152.232C258.444 152.223 258.486 152.217 258.529 152.209C258.648 152.187 258.767 152.167 258.885 152.142C258.909 152.14 258.931 152.135 258.954 152.131L259.24 152.072L259.242 152.072C259.278 152.066 259.312 152.059 259.346 152.051C259.794 151.954 260.24 151.848 260.684 151.728C260.837 151.686 260.989 151.644 261.14 151.602L261.142 151.603C261.15 151.599 261.159 151.596 261.168 151.595C261.743 151.43 262.313 151.251 262.881 151.058C263.101 150.982 263.318 150.904 263.536 150.821C263.703 150.759 263.868 150.697 264.036 150.631C264.087 150.612 264.136 150.591 264.187 150.571C264.231 150.555 264.275 150.538 264.319 150.52C264.498 150.449 264.676 150.376 264.852 150.302L264.857 150.3C264.894 150.283 264.933 150.267 264.971 150.251C265.568 149.997 266.158 149.725 266.738 149.436C266.894 149.359 267.047 149.28 267.199 149.202C267.353 149.122 267.505 149.041 267.658 148.959C267.805 148.879 267.951 148.799 268.099 148.718C268.1 148.716 268.102 148.715 268.102 148.715C268.105 148.714 268.107 148.712 268.11 148.711C268.26 148.626 268.409 148.541 268.559 148.454C268.636 148.409 268.715 148.365 268.792 148.318C268.871 148.271 268.948 148.226 269.025 148.179C269.181 148.088 269.334 147.994 269.487 147.897C269.618 147.818 269.748 147.737 269.875 147.655C270.203 147.442 270.528 147.224 270.849 147.002C270.85 147.003 270.851 147.001 270.851 147.001C270.906 146.964 270.962 146.926 271.017 146.888C271.088 146.835 271.161 146.782 271.234 146.729C271.264 146.727 271.29 146.726 271.319 146.723C271.397 146.716 271.476 146.708 271.553 146.697C271.659 146.685 271.761 146.67 271.863 146.652L271.866 146.651C271.911 146.644 271.956 146.634 272.001 146.626C272.1 146.608 272.199 146.59 272.297 146.569C272.613 146.501 272.926 146.418 273.235 146.329C273.549 146.232 273.861 146.134 274.17 146.032C274.17 146.032 274.172 146.033 274.172 146.031C274.45 145.94 274.725 145.848 274.999 145.755C275.001 145.754 275.004 145.753 275.006 145.751C275.13 145.71 275.257 145.668 275.381 145.623C275.391 145.62 275.399 145.616 275.408 145.613C275.905 145.442 276.403 145.265 276.902 145.082C277.115 145.004 277.327 144.924 277.539 144.842C277.56 144.836 277.581 144.827 277.602 144.819C277.602 144.819 277.603 144.817 277.605 144.818C277.697 144.783 277.787 144.748 277.88 144.711C277.919 144.695 277.957 144.681 277.995 144.665C278.056 144.639 278.119 144.615 278.182 144.588C278.213 144.576 278.245 144.562 278.277 144.549C278.412 144.495 278.547 144.439 278.68 144.382C278.893 144.293 279.104 144.2 279.313 144.106C279.406 144.065 279.498 144.023 279.591 143.979C279.631 143.962 279.673 143.945 279.714 143.925C279.755 143.908 279.796 143.888 279.836 143.868C280.055 143.767 280.27 143.663 280.486 143.556C280.575 143.512 280.667 143.467 280.757 143.421L280.757 143.419C280.772 143.411 280.788 143.404 280.801 143.396C280.893 143.348 280.986 143.3 281.077 143.252C281.087 143.247 281.095 143.241 281.105 143.236C281.191 143.19 281.276 143.144 281.36 143.097C281.454 143.043 281.549 142.99 281.642 142.938C281.829 142.83 282.015 142.718 282.2 142.607C282.22 142.595 282.24 142.581 282.259 142.568L282.267 142.565C282.398 142.484 282.53 142.401 282.66 142.316C282.785 142.237 282.907 142.157 283.026 142.074C283.161 141.984 283.292 141.891 283.424 141.795C283.559 141.699 283.693 141.598 283.823 141.495C283.904 141.433 283.982 141.369 284.061 141.307C284.134 141.248 284.205 141.19 284.276 141.131C284.314 141.1 284.352 141.069 284.391 141.038C284.412 141.02 284.434 141.002 284.456 140.982C284.459 140.979 284.462 140.978 284.465 140.975C284.388 141.062 284.311 141.151 284.233 141.237C284.155 141.327 284.077 141.413 283.999 141.499C283.908 141.601 283.817 141.7 283.726 141.799L283.724 141.8C283.686 141.842 283.649 141.882 283.612 141.921C283.542 141.996 283.471 142.071 283.4 142.145C283.174 142.387 282.943 142.623 282.708 142.857C282.624 142.942 282.538 143.025 282.45 143.109C282.378 143.183 282.302 143.255 282.227 143.326C282.13 143.419 282.032 143.511 281.935 143.604C280.104 145.361 278.058 146.888 275.883 148.148C275.846 148.169 275.81 148.19 275.771 148.21C275.635 148.287 275.496 148.363 275.357 148.439C275.341 148.449 275.323 148.457 275.307 148.467C275.185 148.534 275.061 148.6 274.938 148.663C274.927 148.67 274.917 148.676 274.905 148.681L274.903 148.68C274.756 148.756 274.61 148.831 274.463 148.904C274.43 148.92 274.396 148.938 274.361 148.953C274.29 148.988 274.221 149.023 274.148 149.057C274.077 149.091 274.006 149.126 273.934 149.157C273.844 149.2 273.753 149.242 273.662 149.28C273.561 149.327 273.459 149.372 273.359 149.413C273.301 149.439 273.247 149.463 273.191 149.485C273.057 149.542 272.922 149.599 272.789 149.649C272.756 149.663 272.727 149.676 272.696 149.686C272.693 149.687 272.69 149.689 272.689 149.688C272.622 149.716 272.554 149.741 272.489 149.766C272.342 149.823 272.199 149.885 272.052 149.939L271.781 150.033L271.606 150.094C271.573 150.106 271.542 150.116 271.508 150.128C271.244 150.22 270.985 150.319 270.713 150.393L269.81 150.666L269.331 150.79L269.322 150.791L268.894 150.902C268.762 150.934 268.634 150.966 268.503 150.996C268.372 151.026 268.242 151.057 268.11 151.085C267.621 151.195 267.13 151.293 266.636 151.382C266.631 151.383 266.627 151.384 266.622 151.386C266.458 151.414 266.295 151.441 266.131 151.471C265.999 151.492 265.866 151.513 265.732 151.534C265.456 151.58 265.176 151.619 264.898 151.658C264.618 151.698 264.339 151.733 264.06 151.765C263.78 151.801 263.5 151.832 263.218 151.861C262.939 151.89 262.655 151.918 262.375 151.943C262.322 151.95 262.267 151.955 262.213 151.959C262.131 151.966 262.051 151.972 261.968 151.979C261.879 151.986 261.789 151.993 261.698 152.001C261.604 152.009 261.513 152.017 261.421 152.023L261.418 152.025C261.397 152.026 261.375 152.029 261.353 152.03C261.005 152.061 260.66 152.103 260.313 152.151C260.18 152.168 260.047 152.188 259.916 152.207C259.802 152.225 259.69 152.241 259.578 152.259L259.576 152.258C259.529 152.267 259.48 152.273 259.434 152.28C259.377 152.291 259.321 152.301 259.264 152.308C259.145 152.328 259.027 152.346 258.909 152.366C258.906 152.367 258.905 152.367 258.9 152.367C258.761 152.391 258.623 152.413 258.485 152.434L258.484 152.436ZM282.286 141.627C282.27 141.638 282.256 141.648 282.24 141.657C282.091 141.757 281.94 141.852 281.789 141.947C281.619 142.055 281.446 142.161 281.272 142.263C281.19 142.31 281.108 142.358 281.026 142.405C281.026 142.405 281.025 142.406 281.023 142.408C280.918 142.467 280.814 142.525 280.709 142.584C280.616 142.635 280.52 142.687 280.427 142.738C280.333 142.79 280.237 142.841 280.141 142.892C280.025 142.955 279.906 143.017 279.785 143.076C279.762 143.089 279.736 143.103 279.71 143.115C279.685 143.127 279.659 143.141 279.633 143.154C279.594 143.176 279.554 143.196 279.509 143.216C279.506 143.217 279.504 143.218 279.503 143.22C279.49 143.226 279.477 143.234 279.462 143.24C279.386 143.279 279.309 143.317 279.231 143.354C279.229 143.355 279.228 143.357 279.225 143.358C279.157 143.391 279.086 143.426 279.016 143.458C278.659 143.629 278.298 143.795 277.937 143.956C277.765 144.033 277.592 144.108 277.42 144.183L277.415 144.186C277.256 144.255 277.095 144.325 276.937 144.394C277.285 144.149 277.624 143.889 277.952 143.615C278.076 143.513 278.197 143.408 278.318 143.3C278.354 143.27 278.388 143.24 278.421 143.209C278.441 143.191 278.462 143.173 278.481 143.152C278.52 143.119 278.555 143.085 278.59 143.051L278.595 143.048C278.611 143.035 278.624 143.02 278.639 143.007C278.728 142.926 278.816 142.843 278.901 142.756C279.037 142.625 279.168 142.491 279.298 142.353C279.314 142.335 279.331 142.318 279.348 142.298C279.414 142.231 279.479 142.158 279.542 142.088C279.554 142.077 279.565 142.064 279.575 142.053C279.588 142.038 279.599 142.025 279.612 142.011L279.613 142.009C279.74 141.868 279.863 141.725 279.985 141.58L279.986 141.578C279.995 141.571 280.003 141.561 280.01 141.553C280.072 141.477 280.134 141.402 280.196 141.325C280.23 141.282 280.264 141.239 280.298 141.195C280.299 141.194 280.301 141.192 280.302 141.19C280.355 141.122 280.408 141.054 280.46 140.984C280.835 140.491 281.184 139.976 281.515 139.455C281.911 138.804 282.283 138.143 282.633 137.475C282.973 136.799 283.312 136.126 283.62 135.441C283.745 135.173 283.868 134.904 283.991 134.635C284.107 134.378 284.223 134.123 284.335 133.865C284.342 133.853 284.347 133.838 284.354 133.825L284.356 133.82C284.361 133.809 284.367 133.794 284.372 133.783L284.374 133.78C284.493 133.507 284.612 133.232 284.728 132.959C284.844 132.683 284.957 132.408 285.07 132.132C285.084 132.097 285.099 132.06 285.113 132.024L285.116 132.017C285.179 131.858 285.243 131.697 285.303 131.536C285.336 131.455 285.368 131.375 285.398 131.294C285.328 131.4 285.259 131.506 285.19 131.613L285.19 131.615C285.172 131.643 285.154 131.668 285.138 131.696C285.018 131.878 284.902 132.061 284.787 132.247C284.774 132.267 284.76 132.29 284.746 132.31L284.745 132.312C284.74 132.323 284.732 132.333 284.726 132.344C284.652 132.459 284.581 132.575 284.51 132.692L284.51 132.694C284.496 132.716 284.482 132.739 284.467 132.761C284.374 132.915 284.282 133.066 284.191 133.219C283.806 133.861 283.432 134.507 283.068 135.157C282.692 135.808 282.345 136.472 281.97 137.115C281.788 137.439 281.604 137.763 281.416 138.085C281.23 138.404 281.038 138.72 280.839 139.033C280.782 139.125 280.725 139.217 280.668 139.308C280.615 139.393 280.561 139.476 280.507 139.56C280.502 139.567 280.498 139.574 280.493 139.581C280.489 139.585 280.487 139.591 280.484 139.596C280.3 139.878 280.112 140.156 279.919 140.43L279.917 140.434C279.911 140.44 279.906 140.447 279.902 140.454C279.823 140.566 279.743 140.677 279.66 140.787C279.563 140.92 279.465 141.05 279.366 141.178C279.344 141.204 279.325 141.231 279.302 141.259C279.233 141.349 279.161 141.44 279.089 141.528C278.804 141.887 278.507 142.234 278.198 142.574C278.18 142.593 278.161 142.613 278.143 142.633L278.141 142.634C278.039 142.744 277.936 142.853 277.833 142.963C277.789 143.009 277.743 143.056 277.698 143.102C277.62 143.182 277.541 143.263 277.461 143.342C277.229 143.573 276.992 143.801 276.75 144.024C276.633 144.131 276.516 144.238 276.398 144.342C276.383 144.356 276.365 144.371 276.35 144.385C276.294 144.437 276.234 144.488 276.174 144.539C276.041 144.655 275.906 144.77 275.77 144.885C275.753 144.892 275.737 144.899 275.72 144.906C275.71 144.911 275.699 144.913 275.689 144.918C275.64 145.028 275.592 145.137 275.544 145.249C275.518 145.307 275.491 145.366 275.467 145.425C275.437 145.49 275.41 145.557 275.38 145.624C275.39 145.621 275.398 145.618 275.407 145.615C275.904 145.444 276.402 145.267 276.901 145.084C277.114 145.006 277.326 144.926 277.538 144.844C277.559 144.838 277.58 144.828 277.601 144.821C277.601 144.821 277.602 144.819 277.604 144.82C277.726 144.717 277.848 144.614 277.968 144.508C278.281 144.24 278.587 143.965 278.885 143.68C278.978 143.639 279.072 143.593 279.165 143.547L279.168 143.546C279.261 143.503 279.353 143.456 279.443 143.41C279.659 143.304 279.871 143.194 280.081 143.082C280.29 142.971 280.498 142.858 280.702 142.743C280.358 143.102 280.005 143.453 279.643 143.798C279.731 143.756 279.819 143.715 279.907 143.674C280.121 143.575 280.333 143.472 280.544 143.368C280.742 143.271 280.94 143.169 281.134 143.063C281.104 143.076 281.073 143.088 281.043 143.101C281.472 142.622 281.887 142.13 282.285 141.626L282.286 141.627ZM288.524 134.171C288.565 134.052 288.605 133.931 288.644 133.812L288.649 133.799C288.669 133.734 288.688 133.674 288.708 133.609C288.788 133.342 288.864 133.075 288.936 132.807C288.967 132.692 288.998 132.579 289.027 132.464C289.083 132.248 289.137 132.033 289.186 131.818C289.218 131.69 289.247 131.562 289.275 131.432C289.433 130.693 289.588 129.954 289.712 129.214C289.974 127.736 290.209 126.25 290.366 124.748C290.246 125.107 290.129 125.466 290.019 125.826C289.98 125.952 289.944 126.074 289.907 126.198C289.836 126.432 289.767 126.668 289.699 126.903C289.632 127.138 289.563 127.374 289.498 127.61C289.439 127.821 289.383 128.032 289.326 128.243C289.251 128.522 289.177 128.803 289.105 129.081C288.909 129.807 288.741 130.534 288.544 131.254C288.359 131.975 288.167 132.694 287.943 133.398C287.924 133.461 287.905 133.526 287.884 133.588C287.848 133.709 287.812 133.826 287.773 133.946L287.765 133.968C287.715 134.124 287.664 134.278 287.611 134.431C287.538 134.639 287.462 134.847 287.384 135.054L287.383 135.056C287.303 135.268 287.22 135.479 287.135 135.688C287.102 135.771 287.067 135.852 287.032 135.934C286.999 136.013 286.964 136.094 286.929 136.172C286.908 136.219 286.888 136.265 286.867 136.313L286.867 136.315C286.832 136.391 286.797 136.466 286.763 136.542C286.69 136.704 286.613 136.863 286.535 137.021C286.458 137.182 286.378 137.339 286.297 137.497C286.097 137.876 285.889 138.252 285.668 138.622C285.596 138.747 285.522 138.868 285.445 138.992C285.282 139.16 285.114 139.327 284.944 139.49C284.605 139.817 284.254 140.131 283.892 140.429C283.865 140.451 283.839 140.473 283.811 140.493C284.471 140.37 285.15 140.294 285.821 140.205C285.932 140.098 286.04 139.986 286.145 139.873C286.218 139.656 286.289 139.438 286.359 139.22C286.412 139.055 286.463 138.89 286.514 138.722C286.651 138.275 286.784 137.824 286.913 137.371C286.996 137.084 287.079 136.797 287.168 136.51C287.215 136.349 287.264 136.189 287.316 136.028L287.317 136.026C287.336 135.964 287.356 135.901 287.376 135.838C287.436 135.779 287.497 135.72 287.556 135.659C287.698 135.516 287.836 135.368 287.97 135.217C287.908 135.462 287.852 135.711 287.795 135.958C287.791 135.976 287.787 135.993 287.785 136.012L287.769 136.076C287.774 136.069 287.778 136.062 287.781 136.053C287.795 136.026 287.807 135.998 287.82 135.971C287.849 135.907 287.88 135.842 287.908 135.778C287.943 135.702 287.976 135.625 288.007 135.547C288.037 135.48 288.065 135.411 288.093 135.343C288.108 135.306 288.123 135.269 288.137 135.234C288.184 135.116 288.23 134.995 288.274 134.875C288.28 134.864 288.283 134.855 288.287 134.844C288.288 134.842 288.291 134.839 288.292 134.837C288.293 134.833 288.292 134.829 288.293 134.827C288.375 134.609 288.451 134.391 288.525 134.17L288.524 134.171ZM291.491 128.264C291.455 128.378 291.418 128.491 291.381 128.605C291.219 129.107 291.047 129.605 290.861 130.099C290.528 130.99 290.158 131.864 289.746 132.716C289.77 132.68 289.791 132.641 289.813 132.604C290.12 132.051 290.406 131.489 290.67 130.919C290.838 130.552 291.004 130.182 291.162 129.813L291.163 129.81C291.29 129.298 291.399 128.781 291.49 128.264L291.491 128.264ZM291.868 128.085C291.871 128.048 291.876 128.01 291.882 127.972C291.903 127.914 291.921 127.855 291.939 127.796C291.941 127.792 291.941 127.786 291.942 127.782C291.923 127.837 291.905 127.894 291.886 127.948C291.809 128.178 291.729 128.408 291.648 128.636C291.722 128.451 291.796 128.269 291.869 128.085L291.868 128.085ZM255.264 144.179C255.21 144.228 255.153 144.275 255.099 144.326C255.177 144.256 255.255 144.188 255.335 144.122C255.311 144.141 255.288 144.16 255.264 144.18L255.264 144.179ZM262.865 131.591C262.768 131.604 262.669 131.62 262.573 131.638C262.459 131.657 262.346 131.679 262.233 131.703C262.183 131.713 262.133 131.723 262.082 131.735C262.055 131.74 262.03 131.746 262.002 131.754C261.994 131.759 261.989 131.768 261.982 131.774C261.955 131.805 261.929 131.838 261.899 131.868C261.916 131.831 261.934 131.799 261.952 131.764C261.932 131.767 261.914 131.772 261.893 131.777C261.78 131.803 261.667 131.832 261.556 131.861C261.523 131.994 261.493 132.129 261.469 132.266C261.384 132.376 261.299 132.487 261.22 132.599C261.165 132.675 261.111 132.751 261.06 132.825C261.093 132.814 261.127 132.8 261.161 132.789C261.317 132.733 261.475 132.678 261.631 132.628C261.705 132.605 261.776 132.581 261.847 132.559C261.954 132.525 262.06 132.492 262.167 132.462C262.189 132.454 262.212 132.448 262.236 132.441C262.213 132.446 262.191 132.453 262.168 132.46L262.361 132.23L262.54 132.02C262.664 131.874 262.787 131.731 262.914 131.585C262.897 131.586 262.881 131.589 262.865 131.592L262.865 131.591ZM260.262 140.725C260.22 140.729 260.179 140.734 260.138 140.741C260.064 140.749 259.992 140.762 259.918 140.774C259.864 140.785 259.81 140.795 259.755 140.806C259.673 140.82 259.59 140.839 259.51 140.858C259.469 140.867 259.429 140.876 259.39 140.888C259.36 140.895 259.331 140.904 259.302 140.91C259.285 140.915 259.269 140.92 259.253 140.925C259.153 140.951 259.052 140.98 258.955 141.011C258.906 141.026 258.858 141.043 258.81 141.058L258.808 141.059C258.679 141.101 258.554 141.146 258.43 141.196C258.415 141.201 258.401 141.207 258.386 141.212C258.326 141.235 258.265 141.258 258.205 141.284C258.169 141.299 258.134 141.314 258.099 141.33C258.081 141.338 258.062 141.346 258.044 141.355L258.042 141.354C257.483 141.598 256.949 141.895 256.447 142.242L256.447 142.244C256.395 142.278 256.342 142.315 256.291 142.352L256.138 142.464C256.116 142.479 256.096 142.495 256.073 142.512C255.993 142.573 255.914 142.637 255.833 142.699C255.814 142.713 255.796 142.728 255.778 142.743C255.734 142.778 255.692 142.814 255.65 142.85C255.606 142.886 255.564 142.922 255.524 142.958C255.44 143.03 255.357 143.105 255.276 143.182L255.275 143.184C255.287 143.453 255.304 143.722 255.322 143.99C255.325 144.035 255.33 144.077 255.334 144.12C255.481 143.994 255.629 143.871 255.78 143.75C255.801 143.732 255.824 143.715 255.845 143.697C255.871 143.676 255.895 143.655 255.921 143.635C255.997 143.575 256.072 143.515 256.148 143.455C256.237 143.387 256.326 143.318 256.414 143.252C256.435 143.234 256.458 143.219 256.48 143.201C256.524 143.168 256.567 143.134 256.612 143.102C256.929 142.866 257.253 142.639 257.579 142.42L257.58 142.418C257.584 142.417 257.587 142.416 257.59 142.413C257.626 142.389 257.664 142.365 257.699 142.341C257.724 142.324 257.749 142.308 257.777 142.292C257.78 142.289 257.781 142.287 257.784 142.286C257.833 142.253 257.885 142.22 257.938 142.188C257.957 142.175 257.976 142.163 257.995 142.151C258.105 142.077 258.218 142.007 258.334 141.938C258.351 141.925 258.37 141.914 258.388 141.904C258.421 141.881 258.455 141.862 258.488 141.841C258.617 141.762 258.747 141.683 258.879 141.606C258.993 141.538 259.106 141.472 259.225 141.409C259.241 141.399 259.259 141.389 259.275 141.38L259.276 141.378C259.388 141.315 259.495 141.256 259.605 141.193C259.762 141.106 259.918 141.019 260.077 140.931C260.215 140.855 260.356 140.777 260.496 140.7C260.418 140.706 260.339 140.715 260.26 140.725L260.262 140.725ZM266.437 131.859C266.399 131.968 266.365 132.078 266.329 132.188C266.309 132.253 266.287 132.315 266.27 132.378C266.323 132.205 266.379 132.033 266.437 131.859ZM264.627 147.98C264.628 147.966 264.631 147.95 264.633 147.934C264.59 147.868 264.553 147.798 264.516 147.729C264.412 147.524 264.329 147.31 264.267 147.092C264.234 146.986 264.21 146.881 264.187 146.774C264.051 146.118 264.044 145.457 264.078 144.813C264.117 144.165 264.198 143.545 264.262 142.916C264.33 142.289 264.411 141.662 264.49 141.037C264.528 140.746 264.568 140.455 264.61 140.164C264.615 140.111 264.624 140.057 264.632 140.003C264.637 139.998 264.643 139.994 264.65 139.988C264.661 139.979 264.672 139.971 264.685 139.96C264.739 139.596 264.8 139.231 264.867 138.869C265.075 137.703 265.326 136.543 265.634 135.394C265.714 135.102 265.8 134.811 265.888 134.522C265.915 134.438 265.94 134.352 265.967 134.269C266.012 134.127 266.057 133.987 266.103 133.847C266.123 133.782 266.143 133.719 266.165 133.655C266.072 133.663 265.98 133.671 265.889 133.682C265.898 133.649 265.908 133.615 265.915 133.581C265.914 133.579 265.912 133.578 265.91 133.579C265.9 133.614 265.89 133.648 265.882 133.684C265.873 133.71 265.866 133.735 265.859 133.762L265.856 133.771C265.848 133.805 265.838 133.839 265.829 133.872C265.814 133.928 265.799 133.982 265.786 134.038C265.743 134.198 265.702 134.361 265.663 134.522C265.618 134.699 265.574 134.875 265.534 135.052C265.505 135.171 265.477 135.289 265.45 135.409C265.418 135.545 265.387 135.682 265.358 135.819C265.318 135.995 265.28 136.171 265.244 136.348C265.203 136.541 265.164 136.733 265.126 136.927C265.102 137.045 265.08 137.161 265.057 137.278C265.024 137.452 264.991 137.626 264.961 137.798C264.89 138.185 264.823 138.572 264.761 138.959C264.752 139.013 264.743 139.064 264.737 139.119C264.709 139.285 264.683 139.45 264.658 139.619C264.636 139.756 264.615 139.894 264.597 140.033C264.589 140.087 264.581 140.14 264.573 140.194C264.523 140.538 264.475 140.882 264.431 141.227C264.352 141.853 264.271 142.48 264.203 143.107C264.139 143.736 264.058 144.356 264.019 145.004C263.985 145.648 263.992 146.309 264.128 146.965C264.137 147.006 264.146 147.049 264.157 147.091C264.223 147.375 264.323 147.656 264.457 147.919C264.476 147.956 264.495 147.992 264.516 148.029C264.535 148.06 264.553 148.094 264.574 148.124C264.58 148.137 264.588 148.148 264.595 148.159C264.598 148.164 264.602 148.17 264.604 148.175L264.605 148.173C264.615 148.109 264.622 148.046 264.628 147.981L264.627 147.98ZM275.26 145.094C275.252 145.098 275.245 145.099 275.237 145.103C275.123 145.148 275.009 145.197 274.894 145.243C274.3 145.487 273.707 145.739 273.111 145.962C272.985 146.011 272.857 146.057 272.73 146.103C272.61 146.146 272.488 146.186 272.368 146.222C272.317 146.238 272.266 146.256 272.215 146.27C272.128 146.297 272.04 146.323 271.953 146.346C271.95 146.347 271.95 146.349 271.948 146.348C271.847 146.377 271.747 146.403 271.647 146.427C271.768 146.339 271.888 146.25 272.007 146.158C272.167 146.039 272.324 145.914 272.479 145.787C272.479 145.787 272.48 145.785 272.482 145.786C272.543 145.737 272.606 145.69 272.665 145.641C272.727 145.59 272.79 145.541 272.849 145.492C272.746 145.528 272.644 145.562 272.542 145.596C272.54 145.595 272.539 145.597 272.539 145.597C272.283 145.679 272.025 145.762 271.765 145.843C271.506 145.917 271.244 145.986 270.978 146.043L270.976 146.043C270.931 146.093 270.883 146.139 270.837 146.188C270.853 146.148 270.868 146.104 270.882 146.063C270.78 146.084 270.679 146.102 270.576 146.119C270.557 146.249 270.535 146.379 270.513 146.508C270.362 146.654 270.207 146.8 270.059 146.949C270.013 146.998 269.965 147.045 269.917 147.091C269.503 147.504 269.061 147.884 268.619 148.265C268.445 148.414 268.273 148.565 268.103 148.716C268.105 148.715 268.108 148.714 268.11 148.713C268.26 148.627 268.409 148.543 268.559 148.456C268.636 148.41 268.715 148.366 268.792 148.319C268.872 148.273 268.948 148.228 269.026 148.181C269.182 148.089 269.334 147.995 269.488 147.899C269.619 147.82 269.748 147.739 269.875 147.656C270.204 147.444 270.528 147.225 270.849 147.004C270.851 147.005 270.851 147.003 270.851 147.003C270.907 146.965 270.962 146.927 271.017 146.889C271.088 146.836 271.161 146.783 271.235 146.731C271.265 146.729 271.291 146.727 271.319 146.724C271.397 146.718 271.476 146.709 271.554 146.698C271.659 146.686 271.761 146.671 271.864 146.654L271.866 146.653C271.911 146.645 271.957 146.635 272.001 146.628C272.1 146.609 272.2 146.591 272.297 146.57C272.613 146.503 272.926 146.42 273.235 146.331C273.549 146.233 273.861 146.135 274.17 146.034C274.17 146.034 274.172 146.034 274.173 146.032C274.451 145.941 274.725 145.849 274.999 145.757C275.002 145.755 275.004 145.754 275.007 145.753C275.131 145.711 275.257 145.669 275.382 145.624C275.412 145.556 275.439 145.49 275.468 145.424C275.493 145.365 275.519 145.307 275.546 145.249C275.593 145.137 275.641 145.027 275.69 144.918C275.546 144.975 275.406 145.034 275.261 145.093L275.26 145.094ZM281.134 143.064C280.94 143.17 280.742 143.271 280.544 143.369C280.333 143.473 280.121 143.576 279.907 143.675C279.819 143.716 279.731 143.757 279.643 143.798C280.005 143.454 280.358 143.103 280.702 142.744C280.498 142.859 280.29 142.972 280.081 143.083C279.871 143.195 279.659 143.305 279.443 143.411C279.353 143.458 279.261 143.504 279.168 143.547L279.165 143.548C279.071 143.594 278.978 143.639 278.886 143.681C278.587 143.965 278.281 144.24 277.969 144.509C277.848 144.615 277.726 144.717 277.604 144.821C277.696 144.785 277.786 144.751 277.879 144.714C277.918 144.698 277.956 144.684 277.994 144.667C278.055 144.642 278.119 144.618 278.181 144.591C278.212 144.578 278.245 144.564 278.276 144.552C278.411 144.498 278.546 144.441 278.68 144.385C278.892 144.296 279.103 144.203 279.312 144.109C279.405 144.067 279.497 144.026 279.59 143.982C279.63 143.964 279.672 143.947 279.713 143.927C279.754 143.91 279.795 143.891 279.835 143.871C280.054 143.77 280.269 143.665 280.485 143.559C280.574 143.514 280.666 143.47 280.756 143.423L280.756 143.421C280.771 143.414 280.787 143.407 280.8 143.399C280.893 143.35 280.985 143.302 281.076 143.254C281.086 143.249 281.094 143.244 281.104 143.239C281.19 143.193 281.275 143.146 281.359 143.1C281.454 143.046 281.548 142.992 281.641 142.941C281.829 142.833 282.015 142.721 282.199 142.609C282.22 142.598 282.239 142.583 282.258 142.571C281.891 142.745 281.515 142.905 281.135 143.064L281.134 143.064ZM284.389 141.04C284.41 141.022 284.433 141.005 284.455 140.985C284.458 140.982 284.459 140.98 284.462 140.977C284.438 140.998 284.413 141.019 284.389 141.04ZM282.286 141.627C282.269 141.638 282.255 141.648 282.24 141.657C282.091 141.757 281.94 141.852 281.789 141.948C281.619 142.055 281.446 142.161 281.271 142.263C281.19 142.31 281.108 142.358 281.026 142.405C281.026 142.405 281.025 142.407 281.023 142.409C280.918 142.467 280.813 142.526 280.709 142.584C280.615 142.636 280.52 142.687 280.426 142.739C280.333 142.79 280.237 142.841 280.141 142.892C280.025 142.955 279.906 143.017 279.785 143.076C279.761 143.089 279.735 143.103 279.71 143.115C279.685 143.128 279.659 143.142 279.633 143.154C279.594 143.176 279.553 143.196 279.509 143.216C279.506 143.217 279.503 143.219 279.503 143.221C279.49 143.227 279.477 143.235 279.462 143.24C279.386 143.279 279.309 143.318 279.231 143.354C279.228 143.355 279.228 143.357 279.225 143.358C279.157 143.392 279.086 143.426 279.016 143.458C278.659 143.63 278.298 143.795 277.937 143.956C277.765 144.034 277.592 144.108 277.42 144.184L277.415 144.186C277.256 144.255 277.095 144.326 276.936 144.395C277.285 144.149 277.623 143.89 277.952 143.616C278.076 143.513 278.197 143.408 278.318 143.301C278.354 143.271 278.388 143.24 278.421 143.21C278.44 143.191 278.461 143.173 278.481 143.153C278.52 143.12 278.555 143.085 278.59 143.051L278.595 143.049C278.61 143.035 278.624 143.021 278.639 143.007C278.728 142.926 278.816 142.843 278.901 142.757C279.037 142.625 279.168 142.491 279.298 142.353C279.314 142.336 279.331 142.318 279.348 142.299C279.414 142.231 279.479 142.159 279.541 142.088C279.554 142.077 279.564 142.064 279.575 142.053C279.588 142.039 279.599 142.026 279.612 142.011L279.613 142.009C279.74 141.868 279.863 141.726 279.985 141.58L279.986 141.578C279.995 141.571 280.002 141.561 280.009 141.553C280.071 141.477 280.133 141.402 280.196 141.325C280.23 141.282 280.264 141.239 280.298 141.196C280.298 141.194 280.301 141.193 280.302 141.191C280.355 141.123 280.408 141.055 280.46 140.985C280.835 140.491 281.184 139.976 281.515 139.455C281.911 138.805 282.283 138.144 282.633 137.475C282.973 136.799 283.311 136.127 283.62 135.442C283.745 135.173 283.868 134.904 283.991 134.635C284.107 134.379 284.223 134.124 284.335 133.866C284.342 133.853 284.347 133.838 284.353 133.826L284.355 133.82C284.361 133.809 284.366 133.794 284.372 133.784L284.373 133.78C284.493 133.508 284.612 133.233 284.728 132.959C284.844 132.684 284.957 132.409 285.069 132.132C285.084 132.097 285.099 132.06 285.113 132.025L285.116 132.017C285.179 131.858 285.243 131.697 285.303 131.537C285.336 131.455 285.368 131.376 285.398 131.294C285.327 131.4 285.259 131.507 285.19 131.614L285.19 131.615C285.172 131.643 285.154 131.669 285.138 131.697C285.018 131.879 284.902 132.061 284.787 132.247C284.774 132.268 284.759 132.29 284.746 132.311L284.745 132.313C284.74 132.323 284.732 132.333 284.726 132.344C284.652 132.46 284.58 132.575 284.51 132.692L284.51 132.694C284.496 132.717 284.481 132.739 284.467 132.762C284.374 132.915 284.282 133.066 284.19 133.22C283.806 133.861 283.432 134.507 283.068 135.158C282.692 135.809 282.344 136.472 281.97 137.115C281.788 137.439 281.604 137.763 281.416 138.085C281.23 138.404 281.038 138.721 280.839 139.033C280.782 139.125 280.725 139.217 280.668 139.309C280.615 139.394 280.561 139.476 280.507 139.56C280.502 139.567 280.498 139.574 280.493 139.581C280.489 139.586 280.487 139.592 280.483 139.597C280.299 139.878 280.112 140.157 279.918 140.431L279.917 140.434C279.911 140.441 279.906 140.447 279.902 140.454C279.823 140.566 279.742 140.677 279.66 140.787C279.563 140.92 279.465 141.051 279.366 141.178C279.344 141.205 279.324 141.231 279.302 141.26C279.233 141.349 279.161 141.441 279.089 141.529C278.804 141.887 278.507 142.235 278.197 142.574C278.18 142.593 278.16 142.614 278.143 142.633L278.141 142.634C278.039 142.745 277.936 142.854 277.833 142.963C277.789 143.01 277.743 143.057 277.698 143.102C277.619 143.183 277.541 143.263 277.461 143.342C277.229 143.573 276.992 143.801 276.75 144.025C276.633 144.132 276.516 144.238 276.398 144.343C276.383 144.356 276.365 144.371 276.35 144.385C276.294 144.437 276.234 144.488 276.174 144.539C276.041 144.655 275.906 144.77 275.77 144.885C275.752 144.892 275.737 144.899 275.72 144.906C275.71 144.911 275.699 144.913 275.689 144.918C275.64 145.028 275.592 145.137 275.544 145.249C275.518 145.308 275.491 145.366 275.466 145.425C275.437 145.491 275.41 145.557 275.38 145.625C275.39 145.622 275.397 145.618 275.407 145.615C275.904 145.444 276.402 145.267 276.901 145.084C277.114 145.006 277.326 144.926 277.538 144.844C277.559 144.839 277.579 144.829 277.601 144.821C277.601 144.821 277.602 144.82 277.603 144.82C277.726 144.717 277.848 144.614 277.968 144.509C278.281 144.24 278.587 143.965 278.885 143.681C278.978 143.639 279.072 143.593 279.165 143.548L279.168 143.547C279.261 143.503 279.353 143.457 279.442 143.41C279.659 143.304 279.871 143.195 280.081 143.082C280.29 142.971 280.498 142.858 280.702 142.743C280.358 143.102 280.005 143.454 279.643 143.798C279.731 143.757 279.819 143.716 279.907 143.674C280.12 143.576 280.333 143.473 280.544 143.369C280.742 143.271 280.939 143.169 281.134 143.064C281.104 143.077 281.073 143.089 281.043 143.102C281.472 142.623 281.887 142.131 282.285 141.626L282.286 141.627ZM288.524 134.171C288.565 134.053 288.605 133.932 288.644 133.813L288.648 133.799C288.669 133.735 288.688 133.674 288.708 133.609C288.788 133.342 288.864 133.076 288.935 132.808C288.967 132.692 288.998 132.579 289.027 132.465C289.083 132.248 289.137 132.033 289.186 131.819C289.217 131.69 289.247 131.562 289.275 131.433C289.433 130.693 289.587 129.955 289.712 129.215C289.974 127.736 290.209 126.251 290.366 124.748C290.245 125.107 290.129 125.467 290.019 125.827C289.98 125.952 289.944 126.074 289.907 126.198C289.836 126.433 289.767 126.668 289.698 126.903C289.631 127.139 289.562 127.374 289.497 127.61C289.439 127.822 289.383 128.032 289.326 128.244C289.251 128.523 289.177 128.803 289.105 129.081C288.908 129.807 288.74 130.535 288.544 131.254C288.359 131.975 288.166 132.695 287.943 133.399C287.924 133.461 287.905 133.527 287.884 133.589C287.848 133.709 287.812 133.827 287.772 133.946L287.765 133.969C287.715 134.124 287.663 134.279 287.611 134.431C287.538 134.64 287.462 134.847 287.384 135.054L287.383 135.056C287.303 135.268 287.22 135.48 287.135 135.688C287.102 135.771 287.067 135.852 287.032 135.934C286.999 136.013 286.964 136.094 286.929 136.172C286.908 136.22 286.888 136.266 286.867 136.313L286.867 136.315C286.832 136.391 286.797 136.466 286.763 136.542C286.689 136.704 286.613 136.863 286.535 137.021C286.458 137.182 286.378 137.34 286.296 137.497C286.097 137.876 285.889 138.253 285.668 138.623C285.596 138.747 285.522 138.869 285.445 138.992C285.282 139.16 285.114 139.328 284.944 139.49C284.605 139.817 284.254 140.131 283.892 140.429C283.865 140.451 283.839 140.474 283.811 140.494C284.47 140.371 285.15 140.294 285.821 140.205C285.932 140.098 286.04 139.986 286.145 139.873C286.218 139.656 286.289 139.439 286.359 139.221C286.412 139.056 286.463 138.89 286.514 138.723C286.651 138.275 286.784 137.824 286.913 137.372C286.996 137.085 287.079 136.797 287.168 136.51C287.215 136.349 287.264 136.19 287.316 136.029L287.316 136.027C287.336 135.964 287.356 135.901 287.375 135.838C287.436 135.779 287.497 135.72 287.556 135.659C287.698 135.516 287.836 135.369 287.97 135.217C287.908 135.463 287.851 135.711 287.795 135.959C287.791 135.976 287.787 135.994 287.785 136.012L287.769 136.076C287.774 136.069 287.778 136.062 287.781 136.053C287.795 136.026 287.807 135.998 287.82 135.972C287.849 135.908 287.88 135.843 287.908 135.779C287.943 135.702 287.976 135.625 288.007 135.548C288.037 135.48 288.065 135.412 288.093 135.343C288.108 135.306 288.123 135.269 288.137 135.234C288.184 135.116 288.23 134.995 288.274 134.875C288.28 134.865 288.283 134.855 288.287 134.844C288.288 134.842 288.291 134.839 288.291 134.837C288.293 134.833 288.292 134.829 288.293 134.827C288.375 134.609 288.45 134.391 288.525 134.171L288.524 134.171ZM291.491 128.264C291.455 128.378 291.418 128.492 291.381 128.605C291.219 129.107 291.046 129.606 290.861 130.099C290.528 130.991 290.158 131.865 289.746 132.716C289.769 132.68 289.791 132.641 289.813 132.604C290.12 132.052 290.406 131.49 290.67 130.92C290.838 130.552 291.004 130.183 291.161 129.814L291.163 129.81C291.29 129.298 291.399 128.782 291.49 128.264L291.491 128.264ZM291.868 128.086C291.871 128.049 291.875 128.01 291.882 127.972C291.902 127.914 291.921 127.855 291.939 127.796C291.94 127.792 291.941 127.786 291.942 127.782C291.923 127.837 291.905 127.894 291.886 127.949C291.809 128.178 291.729 128.408 291.648 128.637C291.722 128.452 291.796 128.269 291.868 128.085L291.868 128.086ZM255.264 144.18C255.209 144.228 255.153 144.276 255.099 144.327C255.176 144.257 255.255 144.189 255.335 144.122C255.311 144.141 255.288 144.161 255.264 144.18L255.264 144.18ZM262.865 131.592C262.768 131.604 262.669 131.621 262.573 131.638C262.459 131.657 262.346 131.679 262.232 131.703C262.183 131.713 262.133 131.723 262.082 131.735C262.055 131.741 262.03 131.747 262.002 131.754C261.994 131.76 261.989 131.768 261.982 131.775C261.955 131.805 261.929 131.838 261.899 131.868C261.916 131.832 261.933 131.8 261.952 131.764C261.932 131.768 261.914 131.772 261.893 131.777C261.78 131.804 261.667 131.832 261.556 131.861C261.523 131.995 261.493 132.129 261.468 132.266C261.384 132.376 261.299 132.488 261.22 132.599C261.164 132.675 261.111 132.751 261.059 132.826C261.093 132.814 261.127 132.801 261.161 132.789C261.317 132.734 261.475 132.679 261.631 132.628C261.705 132.605 261.776 132.581 261.847 132.56C261.954 132.525 262.06 132.492 262.167 132.462C262.189 132.455 262.212 132.448 262.235 132.441C262.213 132.446 262.191 132.453 262.168 132.46L262.361 132.23L262.539 132.021C262.664 131.874 262.787 131.732 262.914 131.586C262.897 131.586 262.881 131.589 262.865 131.592L262.865 131.592ZM260.262 140.725C260.22 140.73 260.179 140.734 260.138 140.741C260.064 140.749 259.992 140.762 259.918 140.774C259.864 140.785 259.81 140.796 259.755 140.806C259.673 140.82 259.59 140.84 259.51 140.858C259.468 140.867 259.429 140.877 259.39 140.888C259.36 140.895 259.331 140.904 259.302 140.911C259.285 140.915 259.269 140.92 259.252 140.925C259.153 140.952 259.052 140.98 258.955 141.012C258.906 141.026 258.858 141.043 258.81 141.058L258.808 141.06C258.679 141.102 258.554 141.147 258.43 141.196C258.415 141.201 258.401 141.207 258.386 141.212C258.325 141.236 258.265 141.259 258.205 141.285C258.168 141.299 258.134 141.315 258.099 141.33C258.081 141.339 258.061 141.346 258.044 141.355L258.042 141.354C257.483 141.599 256.948 141.896 256.447 142.242L256.446 142.244C256.394 142.279 256.342 142.315 256.291 142.352L256.138 142.464C256.116 142.479 256.096 142.496 256.073 142.513C255.993 142.574 255.914 142.637 255.833 142.699C255.814 142.713 255.796 142.728 255.778 142.743C255.734 142.779 255.692 142.815 255.65 142.851C255.606 142.886 255.564 142.922 255.524 142.959C255.44 143.031 255.357 143.105 255.276 143.182L255.275 143.184C255.287 143.453 255.303 143.723 255.322 143.99C255.325 144.035 255.33 144.077 255.334 144.121C255.481 143.994 255.629 143.871 255.78 143.751C255.801 143.733 255.824 143.715 255.845 143.697C255.871 143.677 255.895 143.656 255.921 143.635C255.997 143.575 256.072 143.515 256.148 143.455C256.237 143.387 256.326 143.319 256.414 143.253C256.435 143.235 256.457 143.219 256.48 143.202C256.524 143.168 256.567 143.135 256.612 143.102C256.929 142.867 257.253 142.639 257.579 142.42L257.58 142.418C257.584 142.418 257.587 142.416 257.59 142.413C257.625 142.39 257.664 142.365 257.699 142.342C257.724 142.325 257.749 142.308 257.777 142.293C257.78 142.29 257.781 142.288 257.784 142.286C257.833 142.253 257.884 142.22 257.938 142.188C257.957 142.176 257.976 142.163 257.995 142.151C258.105 142.077 258.218 142.007 258.334 141.938C258.351 141.925 258.37 141.915 258.388 141.904C258.421 141.882 258.455 141.862 258.488 141.842C258.616 141.762 258.747 141.683 258.879 141.607C258.993 141.539 259.106 141.473 259.225 141.409C259.241 141.4 259.259 141.389 259.275 141.38L259.276 141.378C259.388 141.316 259.495 141.256 259.605 141.193C259.762 141.106 259.918 141.02 260.077 140.932C260.215 140.855 260.356 140.778 260.496 140.7C260.418 140.707 260.339 140.715 260.26 140.726L260.262 140.725ZM266.437 131.859C266.399 131.968 266.365 132.079 266.329 132.188C266.309 132.253 266.287 132.315 266.269 132.379C266.323 132.205 266.379 132.033 266.437 131.859ZM264.627 147.98C264.628 147.966 264.631 147.95 264.632 147.934C264.59 147.869 264.553 147.799 264.516 147.729C264.412 147.524 264.328 147.31 264.267 147.093C264.234 146.987 264.209 146.881 264.187 146.775C264.051 146.119 264.044 145.457 264.078 144.814C264.117 144.166 264.198 143.545 264.262 142.917C264.33 142.289 264.41 141.662 264.49 141.037C264.528 140.747 264.568 140.455 264.61 140.164C264.615 140.111 264.623 140.057 264.632 140.003C264.637 139.999 264.643 139.995 264.649 139.988C264.661 139.98 264.672 139.971 264.684 139.96C264.739 139.596 264.8 139.232 264.867 138.869C265.075 137.703 265.326 136.543 265.634 135.394C265.714 135.102 265.8 134.812 265.888 134.522C265.915 134.439 265.94 134.353 265.967 134.27C266.012 134.127 266.057 133.987 266.103 133.847C266.123 133.782 266.143 133.72 266.165 133.656C266.072 133.663 265.98 133.672 265.889 133.682C265.898 133.649 265.908 133.615 265.915 133.582C265.914 133.579 265.912 133.578 265.909 133.58C265.9 133.614 265.89 133.649 265.882 133.684C265.873 133.71 265.866 133.735 265.859 133.762L265.855 133.772C265.848 133.805 265.838 133.84 265.829 133.872C265.814 133.928 265.799 133.982 265.786 134.039C265.743 134.199 265.702 134.361 265.663 134.522C265.618 134.699 265.574 134.875 265.533 135.053C265.505 135.171 265.477 135.29 265.45 135.409C265.417 135.545 265.387 135.682 265.358 135.82C265.318 135.996 265.28 136.172 265.244 136.349C265.203 136.541 265.163 136.734 265.126 136.927C265.102 137.045 265.08 137.162 2