---
aliases:
  - ../administration/security/
  - ../installation/security/
description: Learn how to make Grafana secure.
labels:
  products:
    - enterprise
    - oss
title: Configure security
weight: 600
---

# Configure security

If you run non-Grafana web services on your Grafana server or within its local network, then they might be vulnerable to exploitation through the Grafana data source proxy or other methods.

To prevent this type of exploitation from happening, we recommend that you apply one or more of the precautions listed below.

## Limit IP addresses/hostnames for data source URL

You can configure Grafana to only allow certain IP addresses or hostnames to be used as data source URLs and proxied through the Grafana data source proxy. Refer to [data_source_proxy_whitelist](../configure-grafana/#data_source_proxy_whitelist) for usage instructions.

## Request security

The request security configuration option allows users to limit requests from the Grafana server. It targets requests that are generated by users. For more information, refer to [Request security](configure-request-security/).

{{% admonition type="note" %}}
Request security is available in Grafana Enterprise v7.4 and later versions.
{{% /admonition %}}

## Firewall rules

Configure a firewall to restrict Grafana from making network requests to sensitive internal web services.

There are many firewall tools available. Refer to the documentation for your specific security tool. For example, Linux users can use [iptables](https://en.wikipedia.org/wiki/Iptables).

## Proxy server

You can require all network requests made by Grafana to go through a proxy server.

Self-hosted reverse proxy options include but are not limited to:

- [Pomerium](https://www.pomerium.com/docs), which has a [guide for securing Grafana](https://www.pomerium.com/docs/guides/grafana)
- [NGINX](https://docs.nginx.com/nginx/) using their [guide on restricting access with HTTP basic authentication](https://docs.nginx.com/nginx/admin-guide/security-controls/configuring-http-basic-authentication/)
- [OAuth2 proxy](https://github.com/oauth2-proxy/oauth2-proxy)

## Limit Viewer query permissions

Users with the `Viewer role` can enter _any possible query_ in _any_ of the data sources available in the **organization**, not just the queries that are defined on the dashboards for which the user has Viewer permissions.

For example, in a Grafana instance with one data source, one dashboard, and one panel that has one query defined, you might assume that a Viewer can only see the result of the query defined in that panel. Actually, the Viewer has access to send any query to the data source. With a command-line tool like curl (there are many tools for this), the Viewer can make their own query to the data source and potentially access sensitive data.

To address this vulnerability, you can restrict data source query access in the following ways:

- Create multiple data sources with some restrictions added in data source configuration that restrict access (like database name or credentials). Then use the [Data Source Permissions](../../administration/data-source-management/#data-source-permissions) Enterprise feature to restrict user access to the data source in Grafana.
- Create a separate Grafana organization, and in that organization, create a separate data source. Make sure the data source has some option/user/credentials setting that limits access to a subset of the data. Not all data sources have an option to limit access.

## Implications of enabling anonymous access to dashboards

When you enable anonymous access in Grafana, any visitor or user can use Grafana as a Viewer without signing in. This section lists the security implications of enabling Anonymous access.

- Anyone with the URL of a dashboard accessible by the Viewer role can access that dashboard.
- New dashboards are publicly available unless the dashboard creator hides them from **all Viewers**.
- Anyone can edit or delete dashboards that have granted Edit or Admin abilities to Viewers.
- Anyone can make `view` calls to the API and list all folders, dashboards, and data sources.
- Anyone can make arbitrary queries to any data source that the Grafana instance is configured with.
