import { css, cx } from '@emotion/css';
import React__default, { PureComponent } from 'react';
import '@grafana/data';
import { withTheme2 } from '../../themes/ThemeContext.js';
import { stylesFactory } from '../../themes/stylesFactory.js';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';
import { Button } from '../Button/Button.js';
import '../Button/ButtonGroup.js';

var __defProp = Object.defineProperty;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField = (obj, key, value) => {
  __defNormalProp(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
class UnThemedConfirmButton extends PureComponent {
  constructor() {
    super(...arguments);
    __publicField(this, "mainButtonRef", React__default.createRef());
    __publicField(this, "confirmButtonRef", React__default.createRef());
    __publicField(this, "state", {
      showConfirm: false
    });
    __publicField(this, "onClickButton", (event) => {
      if (event) {
        event.preventDefault();
      }
      this.setState(
        {
          showConfirm: true
        },
        () => {
          if (this.props.autoFocus && this.confirmButtonRef.current) {
            this.confirmButtonRef.current.focus();
          }
        }
      );
      if (this.props.onClick) {
        this.props.onClick();
      }
    });
    __publicField(this, "onClickCancel", (event) => {
      if (event) {
        event.preventDefault();
      }
      this.setState(
        {
          showConfirm: false
        },
        () => {
          var _a;
          (_a = this.mainButtonRef.current) == null ? void 0 : _a.focus();
        }
      );
      if (this.props.onCancel) {
        this.props.onCancel();
      }
    });
    __publicField(this, "onConfirm", (event) => {
      if (event) {
        event.preventDefault();
      }
      this.props.onConfirm();
      if (this.props.closeOnConfirm) {
        this.setState({
          showConfirm: false
        });
      }
    });
  }
  render() {
    const {
      theme,
      className,
      size,
      disabled,
      confirmText,
      confirmVariant: confirmButtonVariant,
      children
    } = this.props;
    const styles = getStyles(theme);
    const buttonClass = cx(
      className,
      this.state.showConfirm ? styles.buttonHide : styles.buttonShow,
      disabled && styles.buttonDisabled
    );
    const confirmButtonClass = cx(
      styles.confirmButton,
      this.state.showConfirm ? styles.confirmButtonShow : styles.confirmButtonHide
    );
    const onClick = disabled ? () => {
    } : this.onClickButton;
    return /* @__PURE__ */ React__default.createElement("span", { className: styles.buttonContainer }, /* @__PURE__ */ React__default.createElement("div", { className: cx(disabled && styles.disabled) }, /* @__PURE__ */ React__default.createElement("span", { className: buttonClass }, typeof children === "string" ? /* @__PURE__ */ React__default.createElement(Button, { size, fill: "text", onClick, ref: this.mainButtonRef }, children) : React__default.cloneElement(children, { onClick, ref: this.mainButtonRef }))), /* @__PURE__ */ React__default.createElement("span", { className: confirmButtonClass }, /* @__PURE__ */ React__default.createElement(Button, { size, variant: confirmButtonVariant, onClick: this.onConfirm, ref: this.confirmButtonRef }, confirmText), /* @__PURE__ */ React__default.createElement(Button, { size, fill: "text", onClick: this.onClickCancel }, "Cancel")));
  }
}
const ConfirmButton = withTheme2(UnThemedConfirmButton);
const getStyles = stylesFactory((theme) => {
  return {
    buttonContainer: css({
      display: "flex",
      alignItems: "center",
      justifyContent: "flex-end"
    }),
    buttonDisabled: css({
      textDecoration: "none",
      color: theme.colors.text.primary,
      opacity: 0.65,
      pointerEvents: "none"
    }),
    buttonShow: css({
      opacity: 1,
      transition: "opacity 0.1s ease",
      zIndex: 2
    }),
    buttonHide: css({
      opacity: 0,
      transition: "opacity 0.1s ease, visibility 0 0.1s",
      visibility: "hidden",
      zIndex: 0
    }),
    confirmButton: css({
      alignItems: "flex-start",
      background: theme.colors.background.primary,
      display: "flex",
      position: "absolute",
      pointerEvents: "none"
    }),
    confirmButtonShow: css({
      zIndex: 1,
      opacity: 1,
      transition: "opacity 0.08s ease-out, transform 0.1s ease-out",
      transform: "translateX(0)",
      pointerEvents: "all"
    }),
    confirmButtonHide: css({
      opacity: 0,
      visibility: "hidden",
      transition: "opacity 0.12s ease-in, transform 0.14s ease-in, visibility 0s 0.12s",
      transform: "translateX(100px)"
    }),
    disabled: css({
      cursor: "not-allowed"
    })
  };
});
ConfirmButton.defaultProps = {
  size: "md",
  confirmText: "Save",
  disabled: false,
  confirmVariant: "primary"
};
ConfirmButton.displayName = "ConfirmButton";

export { ConfirmButton };
//# sourceMappingURL=ConfirmButton.js.map
