import { FieldType } from '../types/dataFrame.js';
import '@grafana/schema';
import '../datetime/moment_wrapper.js';
import '../types/vector.js';
import '../types/datasource.js';
import 'lodash';
import '../types/legacyEvents.js';

class IndexVector extends Array {
  constructor(len) {
    super();
    const arr = new Array(len);
    for (let i = 0; i < len; i++) {
      arr[i] = i;
    }
    return arr;
  }
  /**
   * Returns a field representing the range [0 ... length-1]
   *
   * @deprecated
   */
  static newField(len) {
    return {
      name: "",
      values: new IndexVector(len),
      type: FieldType.number,
      config: {
        min: 0,
        max: len - 1
      }
    };
  }
}

export { IndexVector };
//# sourceMappingURL=IndexVector.js.map
