---
aliases:
  - ../http_api/
  - ../overview/
canonical: /docs/grafana/latest/developers/http_api/
description: Grafana HTTP API
keywords:
  - grafana
  - http
  - documentation
  - api
  - overview
labels:
  products:
    - enterprise
    - oss
title: HTTP API
weight: 100
---

# HTTP API reference

The Grafana backend exposes an HTTP API, which is the same API that is used by the frontend to do everything from saving
dashboards, creating users, and updating data sources.

Since version 8.4, HTTP API details are [specified](https://editor.swagger.io/?url=https://raw.githubusercontent.com/grafana/grafana/main/public/api-merged.json) using OpenAPI v2.

Starting from version 9.1, there is also a [OpenAPI v3 specification](https://editor.swagger.io/?url=https://raw.githubusercontent.com/grafana/grafana/main/public/openapi3.json) (generated by the v2 one).

Users can browser and try out both via the Swagger UI editor (served by the grafana server) by navigating to `/swagger-ui`.

## Authenticating API requests

You can authenticate requests using basic auth, a service account token or a session cookie (acquired using regular login or OAuth).

### Basic Auth

If basic auth is enabled (it is enabled by default), then you can authenticate your HTTP request via
standard basic auth. Basic auth will also authenticate LDAP users.

curl example:

```bash
curl http://admin:admin@localhost:3000/api/org
{"id":1,"name":"Main Org."}
```

### Service Account Token

To create a service account token, click on **Administration** in the left-side menu, click **Users and access**, then **Service Accounts**.
For more information on how to use service account tokens, refer to the [Service Accounts](../../administration/service-accounts/) documentation.

You use the token in all requests in the `Authorization` header, like this:

**Example**:

```http
GET http://your.grafana.com/api/dashboards/db/mydash HTTP/1.1
Accept: application/json
Authorization: Bearer eyJrIjoiT0tTcG1pUlY2RnVKZTFVaDFsNFZXdE9ZWmNrMkZYbk
```

The `Authorization` header value should be `Bearer <your service account token>`.

## X-Grafana-Org-Id Header

**X-Grafana-Org-Id** is an optional property that specifies the organization to which the action is applied. If it is not set, the created key belongs to the current context org. Use this header in all requests except those regarding admin.

**Example Request**:

```http
GET /api/org/ HTTP/1.1
Accept: application/json
Content-Type: application/json
X-Grafana-Org-Id: 2
Authorization: Bearer eyJrIjoiT0tTcG1pUlY2RnVKZTFVaDFsNFZXdE9ZWmNrMkZYbk
```

## HTTP APIs

- [Admin API](admin/)
- [Alerting API (unstable)](https://editor.swagger.io/?url=https://raw.githubusercontent.com/grafana/grafana/main/pkg/services/ngalert/api/tooling/post.json)
- [Alerting Provisioning API](alerting_provisioning/)
- [Annotations API](annotations/)
- [Correlations API](correlations/)
- [Dashboard API](dashboard/)
- [Dashboard Permissions API](dashboard_permissions/)
- [Dashboard Versions API](dashboard_versions/)
- [Data source API](data_source/)
- [Folder API](folder/)
- [Folder Permissions API](folder_permissions/)
- [Folder/Dashboard Search API](folder_dashboard_search/)
- [Library Element API](library_element/)
- [Organization API](org/)
- [Other API](other/)
- [Playlists API](playlist/)
- [Preferences API](preferences/)
- [Short URL API](short_url/)
- [Query history API](query_history/)
- [Snapshot API](snapshot/)
- [Team API](team/)
- [User API](user/)

## Deprecated HTTP APIs

- [Alerting Notification Channels API](alerting_notification_channels/)
- [Alerting API](alerting/)
- [Authentication API](auth/)

## Grafana Enterprise HTTP APIs

Grafana Enterprise includes all of the Grafana OSS APIs as well as those that follow:

- [Role-based access control API](access_control/)
- [Data source permissions API](datasource_permissions/)
- [Team sync API](team_sync/)
- [License API](licensing/)
- [Reporting API](reporting/)
- [Query and resource caching API](query_and_resource_caching/)
