---
aliases:
  - guides/
description: Learn about breaking changes in Grafana
labels:
  products:
    - cloud
    - enterprise
    - oss
title: Breaking changes
weight: 2
---

# Breaking changes in Grafana

In some cases, major releases that introduce many new features also introduce breaking changes. These changes are described, along with information about what to do, in the breaking changes pages specific to each release.

For our purposes, a breaking change is any change that requires users or operators to do something. This includes:

- Changes in one part of the system that could cause other components to fail
- Deprecations or removal of a feature
- Changes to an API that could break automation
- Changes that affect some plugins or functions of Grafana
- Migrations that can’t be rolled back

{{% admonition type="note" %}}

To learn what's available in a Grafana release, refer to the [What's new ](../whatsnew/) page for each version. For the steps we recommend when you upgrade, check out the [Upgrade guide](../upgrade-guide/) for each version.

{{% /admonition %}}

Refer to any of the following breaking changes guides:

{{< section menuTitle="true">}}
