---
aliases:
  - ../data-sources/influxdb/
  - ../data-sources/influxdb/provision-influxdb/
  - ../features/datasources/influxdb/
  - provision-influxdb/
description: Guide for using InfluxDB in Grafana
keywords:
  - grafana
  - influxdb
  - guide
  - flux
labels:
  products:
    - cloud
    - enterprise
    - oss
menuTitle: InfluxDB
title: InfluxDB data source
weight: 700
refs:
  data-source-management:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/administration/data-source-management/
  build-dashboards:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/dashboards/build-dashboards/
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana/<GRAFANA_VERSION>/dashboards/build-dashboards/
  explore:
    - pattern: /docs/grafana/
      destination: /docs/grafana/<GRAFANA_VERSION>/explore/
    - pattern: /docs/grafana-cloud/
      destination: /docs/grafana/<GRAFANA_VERSION>/explore/
---

# InfluxDB data source

{{< docs/shared lookup="influxdb/intro.md" source="grafana" version="<GRAFANA_VERSION>" >}}

Grafana includes built-in support for InfluxDB.
This topic explains options, variables, querying, and other features specific to the InfluxDB data source, which include
its [feature-rich code editor for queries and visual query builder](query-editor/).

For instructions on how to add a data source to Grafana, refer to
the [administration documentation](ref:data-source-management).
Only users with the organization administrator role can add data sources.
Administrators can also [configure the data source via YAML](#provision-the-data-source) with Grafana's provisioning
system.

Once you've added the InfluxDB data source, you can [configure it](#configure-the-data-source) so that your Grafana
instance's users can create queries in its [query editor](query-editor/) when
they [build dashboards](ref:build-dashboards) and use [Explore](ref:explore).

## Configure the data source

To configure basic settings for the data source, complete the following steps:

1. Click **Connections** in the left-side menu.
1. Under Your connections, click **Data sources**.
1. Enter `InfluxDB` in the search bar.
1. Select **InfluxDB**.

   The **Settings** tab of the data source is displayed.

1. Set the data source's basic configuration options carefully:

| Name                  | Description                                                                                                                                                                                                  |
| --------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| **Name**              | Sets the name you use to refer to the data source in panels and queries. We recommend something like `InfluxDB-InfluxQL`.                                                                                    |
| **Default**           | Sets whether the data source is pre-selected for new panels.                                                                                                                                                 |
| **URL**               | The HTTP protocol, IP address, and port of your InfluxDB API. InfluxDB's default API port is 8086.                                                                                                           |
| **Min time interval** | _(Optional)_ Refer to [Min time interval](#configure-min-time-interval).                                                                                                                                     |
| **Max series**        | _(Optional)_ Limits the number of series and tables that Grafana processes. Lower this number to prevent abuse, and increase it if you have many small time series and not all are shown. Defaults to 1,000. |

You can also configure settings specific to the InfluxDB data source. These options are described in the sections below.

### Min time interval

The **Min time interval** setting defines a lower limit for the auto group-by time interval.

This value _must_ be formatted as a number followed by a valid time identifier:

| Identifier | Description |
| ---------- | ----------- |
| `y`        | year        |
| `M`        | month       |
| `w`        | week        |
| `d`        | day         |
| `h`        | hour        |
| `m`        | minute      |
| `s`        | second      |
| `ms`       | millisecond |

We recommend setting this value to match your InfluxDB write frequency.
For example, use `1m` if InfluxDB writes data every minute.

You can also override this setting in a dashboard panel under its data source options.

### Select a query language

InfluxDB data source options differ depending on which query language you select:

- [InfluxQL](https://docs.influxdata.com/influxdb/v1.8/query_language/explore-data/), a SQL-like language for querying
  InfluxDB, with statements such as SELECT, FROM, WHERE, and GROUP BY that are familiar to SQL users.
  InfluxQL is available in InfluxDB 1.0 onwards.
- [SQL](https://www.influxdata.com/products/sql/) native SQL language with
  support [FlightSQL](https://www.influxdata.com/glossary/apache-arrow-flight-sql/).
- [Flux](https://docs.influxdata.com/influxdb/v2.0/query-data/get-started/), which provides significantly broader
  functionality than InfluxQL. It supports not only queries but also built-in functions for data shaping, string
  manipulation, and joining to non-InfluxDB data sources, but also processing time-series data.
  It's similar to JavaScript with a functional style.

To help choose the best language for your needs, refer to
a [comparison of Flux vs InfluxQL](https://docs.influxdata.com/influxdb/v1.8/flux/flux-vs-influxql/)
and [why InfluxData created Flux](https://www.influxdata.com/blog/why-were-building-flux-a-new-data-scripting-and-query-language/).

{{% admonition type="note" %}}
Though not required, we recommend that you append your query language choice to the data source's **Name** setting:

- InfluxDB-InfluxQL
- InfluxDB-SQL
- InfluxDB-Flux

{{% /admonition %}}

### Configure InfluxQL

Configure these options if you select the InfluxQL (classic InfluxDB) query language:

| Name                | Description                                                                                                                                                                                         |
| ------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| **Allowed cookies** | Defines which cookies are forwarded to the data source. All other cookies are deleted.                                                                                                              |
| **Database**        | Sets the ID of the bucket to query. Copy this from the [Buckets page](https://docs.influxdata.com/influxdb/v2.0/organizations/buckets/view-buckets/) of the InfluxDB UI.                            |
| **User**            | Sets the username to sign into InfluxDB.                                                                                                                                                            |
| **Password**        | Defines the token you use to query the bucket defined in **Database**. Copy this from the [Tokens page](https://docs.influxdata.com/influxdb/v2.0/security/tokens/view-tokens/) of the InfluxDB UI. |
| **HTTP mode**       | Sets the HTTP method used to query your data source. The POST verb allows for larger queries that would return an error using the GET verb. Defaults to GET.                                        |

### Configure SQL

Configure these options if you select the SQL query language:

| Name         | Description                                                                                                                                                                                                                   |
| ------------ | ----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| **Database** | Sets the ID of the bucket to query. Copy this from the Buckets page of the InfluxDB UI.                                                                                                                                       |
| **Token**    | API token used for SQL queries. It can be generated on InfluxDB Cloud dashboard under [Load Data > API Tokens](https://docs.influxdata.com/influxdb/cloud-serverless/get-started/setup/#create-an-all-access-api-token) menu. |

### Configure Flux

Configure these options if you select the Flux query language:

| Name               | Description                                                                                                                                                                                                                                                                                                                    |
| ------------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| **Organization**   | The [Influx organization](https://v2.docs.influxdata.com/v2.0/organizations/) that will be used for Flux queries. This is also used to for the `v.organization` query macro.                                                                                                                                                   |
| **Token**          | The authentication token used for Flux queries. With Influx 2.0, use the [influx authentication token to function](https://v2.docs.influxdata.com/v2.0/security/tokens/create-token/). Token must be set as `Authorization` header with the value `Token <geenrated-token>`. For influx 1.8, the token is `username:password`. |
| **Default bucket** | _(Optional)_ The [Influx bucket](https://v2.docs.influxdata.com/v2.0/organizations/buckets/) that will be used for the `v.defaultBucket` macro in Flux queries.                                                                                                                                                                |

### Provision the data source

You can define and configure the data source in YAML files as part of Grafana's provisioning system.
For more information about provisioning, and for available configuration options, refer
to [Provisioning Grafana][provisioning-data-sources].

{{% admonition type="note" %}}
`database` [field is deprecated](https://github.com/grafana/grafana/pull/58647).
We suggest to use `dbName` field in `jsonData`. Please see the examples below.
No need to change existing provisioning settings.
{{% /admonition %}}

#### Provisioning examples

**InfluxDB 1.x example:**

```yaml
apiVersion: 1

datasources:
  - name: InfluxDB_v1
    type: influxdb
    access: proxy
    user: grafana
    url: http://localhost:8086
    jsonData:
      dbName: site
      httpMode: GET
    secureJsonData:
      password: grafana
```

**InfluxDB 2.x for Flux example:**

```yaml
apiVersion: 1

datasources:
  - name: InfluxDB_v2_Flux
    type: influxdb
    access: proxy
    url: http://localhost:8086
    jsonData:
      version: Flux
      organization: organization
      defaultBucket: bucket
      tlsSkipVerify: true
    secureJsonData:
      token: token
```

**InfluxDB 2.x for InfluxQL example:**

```yaml
apiVersion: 1

datasources:
  - name: InfluxDB_v2_InfluxQL
    type: influxdb
    access: proxy
    url: http://localhost:8086
    jsonData:
      version: SQL
      metadata:
        - database: <bucket-name>
    secureJsonData:
      httpHeaderValue1: 'Token <token>'
```

**InfluxDB 3.x for SQL example:**

```yaml
apiVersion: 1

datasources:
  - name: InfluxDB_v2_InfluxQL
    type: influxdb
    access: proxy
    url: http://localhost:8086
    jsonData:
      dbName: site
      httpMode: POST
    secureJsonData:
      token: '<api-token>'
```

## Query the data source

The InfluxDB data source's query editor has two modes, InfluxQL and Flux, depending on your choice of query language in
the [data source configuration](#configure-the-data-source):

For details, refer to the [query editor documentation](query-editor/).

## Use template variables

Instead of hard-coding details such as server, application, and sensor names in metric queries, you can use variables.
Grafana lists these variables in dropdown select boxes at the top of the dashboard to help you change the data displayed
in your dashboard.
Grafana refers to such variables as template variables.

For details, see the [template variables documentation](template-variables/).
