import { css } from '@emotion/css';
import React__default from 'react';
import { CSSTransition } from 'react-transition-group';
import '@grafana/data';
import { useStyles2 } from '../../themes/ThemeContext.js';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../utils/skeleton.js';

function SlideOutTransition(props) {
  const { visible, children, duration = 250, horizontal, size } = props;
  const styles = useStyles2(getStyles, duration, horizontal ? "width" : "height", size);
  return /* @__PURE__ */ React__default.createElement(CSSTransition, { in: visible, mountOnEnter: true, unmountOnExit: true, timeout: duration, classNames: styles }, children);
}
const getStyles = (_theme, duration, measurement, size) => ({
  enter: css({
    label: "enter",
    [`${measurement}`]: 0,
    opacity: 0
  }),
  enterActive: css({
    label: "enterActive",
    [`${measurement}`]: `${size}px`,
    opacity: 1,
    transition: `opacity ${duration}ms ease-out, ${measurement} ${duration}ms ease-out`
  }),
  exit: css({
    label: "exit",
    [`${measurement}`]: `${size}px`,
    opacity: 1
  }),
  exitActive: css({
    label: "exitActive",
    opacity: 0,
    [`${measurement}`]: 0,
    transition: `opacity ${duration}ms ease-out, ${measurement} ${duration}ms ease-out`
  })
});

export { SlideOutTransition };
//# sourceMappingURL=SlideOutTransition.js.map
