import React__default from 'react';
import { useAsyncDependency } from '../../utils/useAsyncDependency.js';
import { ErrorWithStack } from '../ErrorBoundary/ErrorWithStack.js';
import { LoadingPlaceholder } from '../LoadingPlaceholder/LoadingPlaceholder.js';

var __defProp = Object.defineProperty;
var __getOwnPropSymbols = Object.getOwnPropertySymbols;
var __hasOwnProp = Object.prototype.hasOwnProperty;
var __propIsEnum = Object.prototype.propertyIsEnumerable;
var __defNormalProp = (obj, key, value) => key in obj ? __defProp(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp.call(b, prop))
      __defNormalProp(a, prop, b[prop]);
  if (__getOwnPropSymbols)
    for (var prop of __getOwnPropSymbols(b)) {
      if (__propIsEnum.call(b, prop))
        __defNormalProp(a, prop, b[prop]);
    }
  return a;
};
const ReactMonacoEditorLazy = (props) => {
  const { loading, error, dependency } = useAsyncDependency(
    import(
      /* webpackChunkName: "react-monaco-editor" */
      './ReactMonacoEditor.js'
    )
  );
  if (loading) {
    return /* @__PURE__ */ React__default.createElement(LoadingPlaceholder, { text: "" });
  }
  if (error) {
    return /* @__PURE__ */ React__default.createElement(
      ErrorWithStack,
      {
        title: "React Monaco Editor failed to load",
        error,
        errorInfo: { componentStack: (error == null ? void 0 : error.stack) || "" }
      }
    );
  }
  const ReactMonacoEditor = dependency.ReactMonacoEditor;
  return /* @__PURE__ */ React__default.createElement(ReactMonacoEditor, __spreadValues({}, props));
};

export { ReactMonacoEditorLazy };
//# sourceMappingURL=ReactMonacoEditorLazy.js.map
