import 'systemjs/dist/system';
import 'systemjs/dist/extras/amd';
import 'systemjs-cjs-extra';
import { config } from '../config.js';

const SystemJS = window.System;
async function loadPluginCss(options) {
  try {
    const cssPath = config.bootData.user.theme === "light" ? options.light : options.dark;
    return SystemJS.import(cssPath);
  } catch (err) {
    console.error(err);
  }
}
let pluginImportUtils;
function setPluginImportUtils(utils) {
  if (pluginImportUtils) {
    throw new Error("pluginImportUtils should only be set once, when Grafana is starting.");
  }
  pluginImportUtils = utils;
}
function getPluginImportUtils() {
  if (!pluginImportUtils) {
    throw new Error("pluginImportUtils can only be used after Grafana instance has started.");
  }
  return pluginImportUtils;
}
window.__grafana_amd_define = window.define;
window.define = void 0;

export { SystemJS, getPluginImportUtils, loadPluginCss, setPluginImportUtils };
//# sourceMappingURL=plugin.js.map
