'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var css = require('@emotion/css');
var React = require('react');
var classNames = require('classnames');
var SVG = require('react-inlinesvg');
var data = require('@grafana/data');
var hoistNonReactStatics = require('hoist-non-react-statics');
var memoize = require('micro-memoize');
var react$1 = require('@floating-ui/react');
var e2eSelectors = require('@grafana/e2e-selectors');
var ReactDOM = require('react-dom');
var react = require('@emotion/react');
var tinycolor = require('tinycolor2');
var lodash = require('lodash');
var slate = require('slate');
var ansicolor = require('ansicolor');
var ReactSelect = require('react-select');
var ReactAsyncSelect = require('react-select/async');
var Creatable = require('react-select/creatable');
var Scrollbars = require('react-custom-scrollbars-2');
var reactTransitionGroup = require('react-transition-group');
var reactPopper = require('react-popper');
var Transition = require('react-transition-group/Transition');
var i18next = require('i18next');
var reactI18next = require('react-i18next');
var RCCascader = require('rc-cascader');
var useMeasure = require('react-use/lib/useMeasure');
var AsyncCreatable = require('react-select/async-creatable');
var reactWindow = require('react-window');
var focus = require('@react-aria/focus');
var reactColorful = require('react-colorful');
var reactUse = require('react-use');
var dateFns = require('date-fns');
var dialog = require('@react-aria/dialog');
var overlays = require('@react-aria/overlays');
var Calendar = require('react-calendar');
var uuid = require('uuid');
var RcTimePicker = require('rc-time-picker');
var reactTable = require('react-table');
var Skeleton = require('react-loading-skeleton');
var Plain = require('slate-plain-serializer');
var slateReact = require('slate-react');
var isHotkey = require('is-hotkey');
var Prism = require('prismjs');
var immutable = require('immutable');
var calculateSize = require('calculate-size');
var Highlighter = require('react-highlight-words');
var reactRouterDom = require('react-router-dom');
var rxjs = require('rxjs');
var operators = require('rxjs/operators');
var schema = require('@grafana/schema');
var uPlot = require('uplot');
var $ = require('jquery');
var ReactDOMServer = require('react-dom/server');
var usePrevious = require('react-use/lib/usePrevious');
var useClickAway = require('react-use/lib/useClickAway');
var faroWebSdk = require('@grafana/faro-web-sdk');
var RcDrawer = require('rc-drawer');
var SliderComponent = require('rc-slider');
var Tooltip$1 = require('rc-tooltip');
var reactHookForm = require('react-hook-form');
var reactDropzone = require('react-dropzone');
var WKT = require('ol/format/WKT');
var geom = require('ol/geom');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

function _interopNamespace(e) {
  if (e && e.__esModule) return e;
  var n = Object.create(null);
  if (e) {
    Object.keys(e).forEach(function (k) {
      if (k !== 'default') {
        var d = Object.getOwnPropertyDescriptor(e, k);
        Object.defineProperty(n, k, d.get ? d : {
          enumerable: true,
          get: function () { return e[k]; }
        });
      }
    });
  }
  n["default"] = e;
  return Object.freeze(n);
}

var React__default = /*#__PURE__*/_interopDefaultLegacy(React);
var React__namespace = /*#__PURE__*/_interopNamespace(React);
var classNames__default = /*#__PURE__*/_interopDefaultLegacy(classNames);
var SVG__default = /*#__PURE__*/_interopDefaultLegacy(SVG);
var hoistNonReactStatics__default = /*#__PURE__*/_interopDefaultLegacy(hoistNonReactStatics);
var memoize__default = /*#__PURE__*/_interopDefaultLegacy(memoize);
var ReactDOM__default = /*#__PURE__*/_interopDefaultLegacy(ReactDOM);
var tinycolor__default = /*#__PURE__*/_interopDefaultLegacy(tinycolor);
var ReactSelect__default = /*#__PURE__*/_interopDefaultLegacy(ReactSelect);
var ReactAsyncSelect__default = /*#__PURE__*/_interopDefaultLegacy(ReactAsyncSelect);
var Creatable__default = /*#__PURE__*/_interopDefaultLegacy(Creatable);
var Scrollbars__default = /*#__PURE__*/_interopDefaultLegacy(Scrollbars);
var Transition__default = /*#__PURE__*/_interopDefaultLegacy(Transition);
var i18next__default = /*#__PURE__*/_interopDefaultLegacy(i18next);
var RCCascader__default = /*#__PURE__*/_interopDefaultLegacy(RCCascader);
var useMeasure__default = /*#__PURE__*/_interopDefaultLegacy(useMeasure);
var AsyncCreatable__default = /*#__PURE__*/_interopDefaultLegacy(AsyncCreatable);
var Calendar__default = /*#__PURE__*/_interopDefaultLegacy(Calendar);
var RcTimePicker__default = /*#__PURE__*/_interopDefaultLegacy(RcTimePicker);
var Skeleton__default = /*#__PURE__*/_interopDefaultLegacy(Skeleton);
var Plain__default = /*#__PURE__*/_interopDefaultLegacy(Plain);
var Prism__default = /*#__PURE__*/_interopDefaultLegacy(Prism);
var calculateSize__default = /*#__PURE__*/_interopDefaultLegacy(calculateSize);
var Highlighter__default = /*#__PURE__*/_interopDefaultLegacy(Highlighter);
var uPlot__default = /*#__PURE__*/_interopDefaultLegacy(uPlot);
var $__default = /*#__PURE__*/_interopDefaultLegacy($);
var ReactDOMServer__default = /*#__PURE__*/_interopDefaultLegacy(ReactDOMServer);
var usePrevious__default = /*#__PURE__*/_interopDefaultLegacy(usePrevious);
var useClickAway__default = /*#__PURE__*/_interopDefaultLegacy(useClickAway);
var RcDrawer__default = /*#__PURE__*/_interopDefaultLegacy(RcDrawer);
var SliderComponent__default = /*#__PURE__*/_interopDefaultLegacy(SliderComponent);
var Tooltip__default = /*#__PURE__*/_interopDefaultLegacy(Tooltip$1);
var WKT__default = /*#__PURE__*/_interopDefaultLegacy(WKT);

function stylesFactory(stylesCreator) {
  return memoize__default["default"](stylesCreator);
}

var __defProp$35 = Object.defineProperty;
var __defProps$1Q = Object.defineProperties;
var __getOwnPropDescs$1Q = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2P = Object.getOwnPropertySymbols;
var __hasOwnProp$2P = Object.prototype.hasOwnProperty;
var __propIsEnum$2P = Object.prototype.propertyIsEnumerable;
var __defNormalProp$35 = (obj, key, value) => key in obj ? __defProp$35(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2N = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2P.call(b, prop))
      __defNormalProp$35(a, prop, b[prop]);
  if (__getOwnPropSymbols$2P)
    for (var prop of __getOwnPropSymbols$2P(b)) {
      if (__propIsEnum$2P.call(b, prop))
        __defNormalProp$35(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1Q = (a, b) => __defProps$1Q(a, __getOwnPropDescs$1Q(b));
let ThemeContextMock = null;
const memoizedStyleCreators = /* @__PURE__ */ new WeakMap();
const withTheme = (Component) => {
  const WithTheme = (props) => {
    const ContextComponent = ThemeContextMock || data.ThemeContext;
    return (
      // @ts-ignore
      /* @__PURE__ */ React__default["default"].createElement(ContextComponent.Consumer, null, (theme) => /* @__PURE__ */ React__default["default"].createElement(Component, __spreadProps$1Q(__spreadValues$2N({}, props), { theme: theme.v1 })))
    );
  };
  WithTheme.displayName = `WithTheme(${Component.displayName})`;
  hoistNonReactStatics__default["default"](WithTheme, Component);
  return WithTheme;
};
const withTheme2 = (Component) => {
  const WithTheme = (props) => {
    const ContextComponent = ThemeContextMock || data.ThemeContext;
    return (
      // @ts-ignore
      /* @__PURE__ */ React__default["default"].createElement(ContextComponent.Consumer, null, (theme) => /* @__PURE__ */ React__default["default"].createElement(Component, __spreadProps$1Q(__spreadValues$2N({}, props), { theme })))
    );
  };
  WithTheme.displayName = `WithTheme(${Component.displayName})`;
  hoistNonReactStatics__default["default"](WithTheme, Component);
  return WithTheme;
};
function useTheme() {
  return React.useContext(ThemeContextMock || data.ThemeContext).v1;
}
function useTheme2() {
  return React.useContext(ThemeContextMock || data.ThemeContext);
}
function useStyles(getStyles) {
  const theme = useTheme();
  let memoizedStyleCreator = memoizedStyleCreators.get(getStyles);
  if (!memoizedStyleCreator) {
    memoizedStyleCreator = stylesFactory(getStyles);
    memoizedStyleCreators.set(getStyles, memoizedStyleCreator);
  }
  return memoizedStyleCreator(theme);
}
function useStyles2(getStyles, ...additionalArguments) {
  const theme = useTheme2();
  let memoizedStyleCreator = memoizedStyleCreators.get(getStyles);
  if (!memoizedStyleCreator) {
    memoizedStyleCreator = memoize__default["default"](getStyles, { maxSize: 10 });
    memoizedStyleCreators.set(getStyles, memoizedStyleCreator);
  }
  return memoizedStyleCreator(theme, ...additionalArguments);
}
const mockThemeContext = (theme) => {
  ThemeContextMock = React__default["default"].createContext(theme);
  return () => {
    ThemeContextMock = null;
  };
};

const alwaysMonoIcons = [
  "grafana",
  "favorite",
  "heart-break",
  "heart",
  "panel-add",
  "library-panel",
  "circle-mono"
];
function getIconSubDir(name, type) {
  if (name == null ? void 0 : name.startsWith("gf-")) {
    return "custom";
  } else if (alwaysMonoIcons.includes(name)) {
    return "mono";
  } else if (type === "default") {
    return "unicons";
  } else if (type === "solid") {
    return "solid";
  } else {
    return "mono";
  }
}
function getSvgSize(size) {
  switch (size) {
    case "xs":
      return 12;
    case "sm":
      return 14;
    case "md":
      return 16;
    case "lg":
      return 18;
    case "xl":
      return 24;
    case "xxl":
      return 36;
    case "xxxl":
      return 48;
  }
}
let iconRoot;
function getIconRoot() {
  if (iconRoot) {
    return iconRoot;
  }
  const grafanaPublicPath = typeof window !== "undefined" && window.__grafana_public_path__;
  if (grafanaPublicPath) {
    iconRoot = grafanaPublicPath + "img/icons/";
  } else {
    iconRoot = "public/img/icons/";
  }
  return iconRoot;
}

var __defProp$34 = Object.defineProperty;
var __getOwnPropSymbols$2O = Object.getOwnPropertySymbols;
var __hasOwnProp$2O = Object.prototype.hasOwnProperty;
var __propIsEnum$2O = Object.prototype.propertyIsEnumerable;
var __defNormalProp$34 = (obj, key, value) => key in obj ? __defProp$34(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2M = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2O.call(b, prop))
      __defNormalProp$34(a, prop, b[prop]);
  if (__getOwnPropSymbols$2O)
    for (var prop of __getOwnPropSymbols$2O(b)) {
      if (__propIsEnum$2O.call(b, prop))
        __defNormalProp$34(a, prop, b[prop]);
    }
  return a;
};
var __objRest$1k = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2O.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2O)
    for (var prop of __getOwnPropSymbols$2O(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2O.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const getIconStyles = (theme) => {
  return {
    icon: css.css({
      display: "inline-block",
      fill: "currentColor",
      flexShrink: 0,
      label: "Icon",
      // line-height: 0; is needed for correct icon alignment in Safari
      lineHeight: 0,
      verticalAlign: "middle"
    }),
    orange: css.css({
      fill: theme.v1.palette.orange
    })
  };
};
const Icon = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, { size = "md", type = "default", name, className, style, title = "" } = _b, rest = __objRest$1k(_b, ["size", "type", "name", "className", "style", "title"]);
    const styles = useStyles2(getIconStyles);
    if (!data.isIconName(name)) {
      console.warn("Icon component passed an invalid icon name", name);
    }
    const iconName = name === "fa fa-spinner" ? "spinner" : name;
    const iconRoot = getIconRoot();
    const svgSize = getSvgSize(size);
    const svgHgt = svgSize;
    const svgWid = name.startsWith("gf-bar-align") ? 16 : name.startsWith("gf-interp") ? 30 : svgSize;
    const subDir = getIconSubDir(iconName, type);
    const svgPath = `${iconRoot}${subDir}/${iconName}.svg`;
    const composedClassName = css.cx(
      styles.icon,
      className,
      type === "mono" ? { [styles.orange]: name === "favorite" } : "",
      iconName === "spinner" && "fa-spin"
    );
    return /* @__PURE__ */ React__default["default"].createElement(
      SVG__default["default"],
      __spreadValues$2M({
        innerRef: ref,
        src: svgPath,
        width: svgWid,
        height: svgHgt,
        title,
        className: composedClassName,
        style
      }, rest)
    );
  }
);
Icon.displayName = "Icon";

function getPlacement(placement) {
  switch (placement) {
    case "auto":
      return "bottom";
    case "auto-start":
      return "bottom-start";
    case "auto-end":
      return "bottom-end";
    default:
      return placement != null ? placement : "bottom";
  }
}
function buildTooltipTheme(theme, tooltipBg, toggletipBorder, tooltipText, tooltipPadding) {
  return {
    arrow: css.css({
      fill: tooltipBg
    }),
    container: css.css({
      backgroundColor: tooltipBg,
      borderRadius: theme.shape.radius.default,
      border: `1px solid ${toggletipBorder}`,
      boxShadow: theme.shadows.z2,
      color: tooltipText,
      fontSize: theme.typography.bodySmall.fontSize,
      padding: theme.spacing(tooltipPadding.topBottom, tooltipPadding.rightLeft),
      transition: "opacity 0.3s",
      zIndex: theme.zIndex.tooltip,
      maxWidth: "400px",
      overflowWrap: "break-word",
      "&[data-popper-interactive='false']": {
        pointerEvents: "none"
      },
      code: {
        border: "none",
        display: "inline",
        background: data.colorManipulator.darken(tooltipBg, 0.1),
        color: tooltipText,
        whiteSpace: "normal"
      },
      pre: {
        background: data.colorManipulator.darken(tooltipBg, 0.1),
        color: tooltipText
      },
      a: {
        color: tooltipText,
        textDecoration: "underline"
      },
      "a:hover": {
        textDecoration: "none"
      }
    }),
    headerClose: css.css({
      color: theme.colors.text.secondary,
      position: "absolute",
      right: theme.spacing(1),
      top: theme.spacing(1.5),
      backgroundColor: "transparent",
      border: 0
    }),
    header: css.css({
      paddingTop: theme.spacing(1),
      paddingBottom: theme.spacing(2)
    }),
    body: css.css({
      paddingTop: theme.spacing(1),
      paddingBottom: theme.spacing(1)
    }),
    footer: css.css({
      paddingTop: theme.spacing(2),
      paddingBottom: theme.spacing(1)
    })
  };
}

let themeMock;
const getTheme = (mode = "dark") => {
  if (themeMock) {
    return themeMock(mode);
  }
  return data.createTheme({ colors: { mode } }).v1;
};
const mockTheme = (mock) => {
  themeMock = mock;
  return () => {
    themeMock = null;
  };
};

function getAgularPanelStyles(theme) {
  return react.css({
    ".panel-options-group": {
      borderBottom: `1px solid ${theme.colors.border.weak}`
    },
    ".panel-options-group__header": {
      padding: theme.spacing(1, 2, 1, 1),
      position: "relative",
      display: "flex",
      alignItems: "center",
      cursor: "pointer",
      fontWeight: 500,
      color: theme.colors.text.primary,
      "&:hover": {
        background: theme.colors.emphasize(theme.colors.background.primary, 0.03)
      }
    },
    ".panel-options-group__icon": {
      color: theme.colors.text.secondary,
      marginRight: theme.spacing(1),
      padding: theme.spacing(0, 0.9, 0, 0.6)
    },
    ".panel-options-group__title": {
      position: "relative"
    },
    ".panel-options-group__body": {
      padding: theme.spacing(1, 2, 1, 4)
    }
  });
}

function getCardStyles$1(theme) {
  return react.css({
    ".card-section": {
      marginBottom: theme.spacing(4)
    },
    ".card-list": {
      display: "flex",
      flexDirection: "row",
      flexWrap: "wrap",
      listStyleType: "none"
    },
    ".card-item": {
      display: "block",
      height: "100%",
      background: theme.colors.background.secondary,
      boxShadow: "none",
      padding: theme.spacing(2),
      borderRadius: "4px",
      "&:hover": {
        background: theme.colors.emphasize(theme.colors.background.secondary, 0.03)
      },
      ".label-tag": {
        marginLeft: theme.spacing(1),
        fontSize: "11px",
        padding: "2px 6px"
      }
    },
    ".card-item-body": {
      display: "flex",
      overflow: "hidden"
    },
    ".card-item-details": {
      overflow: "hidden"
    },
    ".card-item-header": {
      marginBottom: theme.spacing(2)
    },
    ".card-item-type": {
      color: theme.colors.text.secondary,
      textTransform: "uppercase",
      fontSize: theme.typography.size.sm,
      fontWeight: theme.typography.fontWeightMedium
    },
    ".card-item-badge": {
      margin: "6px 0"
    },
    ".card-item-notice": {
      fontSize: theme.typography.size.sm
    },
    ".card-item-name": {
      color: theme.colors.text.primary,
      overflow: "hidden",
      textOverflow: "ellipsis",
      width: "100%"
    },
    ".card-item-label": {
      marginLeft: theme.spacing(1)
    },
    ".card-item-sub-name": {
      color: theme.colors.text.secondary,
      overflow: "hidden",
      textOverflow: "ellipsis",
      width: "100%"
    },
    ".card-item-sub-name--header": {
      color: theme.colors.text.secondary,
      textTransform: "uppercase",
      marginBottom: theme.spacing(2),
      fontSize: theme.typography.size.sm,
      fontWeight: "bold"
    },
    ".card-list-layout-grid": {
      ".card-item-type": {
        display: "inline-block"
      },
      ".card-item-notice": {
        fontSize: theme.typography.size.sm,
        display: "inline-block",
        marginLeft: theme.spacing(2)
      },
      ".card-item-header-action": {
        float: "right"
      },
      ".card-item-wrapper": {
        width: "100%",
        padding: theme.spacing(0, 2, 2, 0)
      },
      ".card-item-wrapper--clickable": {
        cursor: "pointer"
      },
      ".card-item-figure": {
        margin: theme.spacing(0, 2, 2, 0),
        height: "80px",
        img: {
          width: "80px"
        }
      },
      ".card-item-name": {
        fontSize: theme.typography.h3.fontSize
      },
      [theme.breakpoints.up("md")]: {
        ".card-item-wrapper": {
          width: "50%"
        }
      },
      [theme.breakpoints.up("lg")]: {
        ".card-item-wrapper": {
          width: "33.333333%"
        }
      },
      "&.card-list-layout-grid--max-2-col": {
        [theme.breakpoints.up("lg")]: {
          ".card-item-wrapper": {
            width: "50%"
          }
        }
      }
    },
    ".card-list-layout-list": {
      ".card-item-wrapper": {
        padding: 0,
        width: "100%",
        marginBottom: theme.spacing(1)
      },
      ".card-item-wrapper--clickable": {
        cursor: "pointer"
      },
      ".card-item": {
        borderRadius: "2px"
      },
      ".card-item-header": {
        float: "right",
        textAlign: "right"
      },
      ".card-item-figure": {
        margin: theme.spacing(0, 2, 0, 0),
        img: {
          width: "48px"
        }
      },
      ".card-item-name": {
        fontSize: theme.typography.h4.fontSize
      },
      ".card-item-sub-name": {
        fontSize: theme.typography.size.sm
      },
      ".layout-selector": {
        marginRight: 0
      }
    }
  });
}

function cardChrome(theme) {
  return `
    background: ${theme.colors.background.secondary};
    &:hover {
      background: ${hoverColor(theme.colors.background.secondary, theme)};
    }
    box-shadow: ${theme.components.panel.boxShadow};
    border-radius: ${theme.shape.radius.default};
`;
}
function hoverColor(color, theme) {
  return theme.isDark ? tinycolor__default["default"](color).brighten(2).toString() : tinycolor__default["default"](color).darken(2).toString();
}
function listItem(theme) {
  return `
  background: ${theme.colors.background.secondary};
  &:hover {
    background: ${hoverColor(theme.colors.background.secondary, theme)};
  }
  box-shadow: ${theme.components.panel.boxShadow};
  border-radius: ${theme.shape.radius.default};
`;
}
function listItemSelected(theme) {
  return `
    background: ${hoverColor(theme.colors.background.secondary, theme)};
    color: ${theme.colors.text.maxContrast};
`;
}
function mediaUp(breakpoint) {
  return `only screen and (min-width: ${breakpoint})`;
}
const isGrafanaTheme2 = (theme) => theme.hasOwnProperty("v1");
const focusCss = (theme) => {
  const isTheme2 = isGrafanaTheme2(theme);
  const firstColor = isTheme2 ? theme.colors.background.canvas : theme.colors.bodyBg;
  const secondColor = isTheme2 ? theme.colors.primary.main : theme.colors.formFocusOutline;
  return `
  outline: 2px dotted transparent;
  outline-offset: 2px;
  box-shadow: 0 0 0 2px ${firstColor}, 0 0 0px 4px ${secondColor};
  transition-property: outline, outline-offset, box-shadow;
  transition-duration: 0.2s;
  transition-timing-function: cubic-bezier(0.19, 1, 0.22, 1);`;
};
function getMouseFocusStyles(theme) {
  return {
    outline: "none",
    boxShadow: `none`
  };
}
function getFocusStyles(theme) {
  return {
    outline: "2px dotted transparent",
    outlineOffset: "2px",
    boxShadow: `0 0 0 2px ${theme.colors.background.canvas}, 0 0 0px 4px ${theme.colors.primary.main}`,
    transitionTimingFunction: `cubic-bezier(0.19, 1, 0.22, 1)`,
    transitionDuration: "0.2s",
    transitionProperty: "outline, outline-offset, box-shadow"
  };
}
const getTooltipContainerStyles = (theme) => ({
  overflow: "hidden",
  background: theme.colors.background.secondary,
  boxShadow: theme.shadows.z2,
  maxWidth: "800px",
  padding: theme.spacing(1),
  borderRadius: theme.shape.radius.default,
  zIndex: theme.zIndex.tooltip
});

var mixins = /*#__PURE__*/Object.freeze({
  __proto__: null,
  cardChrome: cardChrome,
  hoverColor: hoverColor,
  listItem: listItem,
  listItemSelected: listItemSelected,
  mediaUp: mediaUp,
  focusCss: focusCss,
  getMouseFocusStyles: getMouseFocusStyles,
  getFocusStyles: getFocusStyles,
  getTooltipContainerStyles: getTooltipContainerStyles
});

var __defProp$33 = Object.defineProperty;
var __getOwnPropSymbols$2N = Object.getOwnPropertySymbols;
var __hasOwnProp$2N = Object.prototype.hasOwnProperty;
var __propIsEnum$2N = Object.prototype.propertyIsEnumerable;
var __defNormalProp$33 = (obj, key, value) => key in obj ? __defProp$33(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2L = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2N.call(b, prop))
      __defNormalProp$33(a, prop, b[prop]);
  if (__getOwnPropSymbols$2N)
    for (var prop of __getOwnPropSymbols$2N(b)) {
      if (__propIsEnum$2N.call(b, prop))
        __defNormalProp$33(a, prop, b[prop]);
    }
  return a;
};
function getElementStyles(theme) {
  return react.css({
    html: {
      MsOverflowStyle: "scrollbar",
      WebkitTapHighlightColor: "rgba(0, 0, 0, 0)",
      height: "100%",
      fontSize: `${theme.typography.htmlFontSize}px`,
      fontFamily: theme.typography.fontFamily,
      lineHeight: theme.typography.body.lineHeight,
      fontKerning: "normal"
    },
    ":root": {
      colorScheme: theme.colors.mode
    },
    body: __spreadValues$2L({
      height: "100%",
      width: "100%",
      position: "absolute",
      color: theme.colors.text.primary,
      backgroundColor: theme.colors.background.canvas
    }, getVariantStyles(theme.typography.body)),
    "h1, .h1": getVariantStyles(theme.typography.h1),
    "h2, .h2": getVariantStyles(theme.typography.h2),
    "h3, .h3": getVariantStyles(theme.typography.h3),
    "h4, .h4": getVariantStyles(theme.typography.h4),
    "h5, .h5": getVariantStyles(theme.typography.h5),
    "h6, .h6": getVariantStyles(theme.typography.h6),
    p: {
      margin: theme.spacing(0, 0, 2)
    },
    button: {
      letterSpacing: theme.typography.body.letterSpacing,
      "&:focus-visible": getFocusStyles(theme),
      "&:focus": {
        outline: "none"
      }
    },
    // Ex: 14px base font * 85% = about 12px
    small: {
      fontSize: theme.typography.bodySmall.fontSize
    },
    "b, strong": {
      fontWeight: theme.typography.fontWeightMedium
    },
    em: {
      fontStyle: "italic",
      color: theme.colors.text.primary
    },
    cite: {
      fontStyle: "normal"
    },
    // Utility classes
    ".muted": {
      color: theme.colors.text.secondary
    },
    "a.muted:hover, a.muted:focus": {
      color: theme.colors.text.primary
    },
    ".text-warning": {
      color: theme.colors.warning.text,
      "&:hover, &:focus": {
        color: theme.colors.emphasize(theme.colors.warning.text, 0.15)
      }
    },
    ".text-error": {
      color: theme.colors.error.text,
      "&:hover, &:focus": {
        color: theme.colors.emphasize(theme.colors.error.text, 0.15)
      }
    },
    ".text-success": {
      color: "$success-text-color",
      "&:hover, &:focus": {
        color: theme.colors.emphasize(theme.colors.success.text, 0.15)
      }
    },
    a: {
      cursor: "pointer",
      color: theme.colors.text.primary,
      textDecoration: "none",
      "&:focus": {
        outline: "none"
      },
      "&:focus-visible": getFocusStyles(theme),
      "&:[disabled]": {
        cursor: "default",
        // Need type assertion here due to the use of !important
        // see https://github.com/frenic/csstype/issues/114#issuecomment-697201978
        // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
        pointerEvents: "none !important"
      }
    },
    ".text-link": {
      textDecoration: "underline"
    },
    ".text-left": {
      textAlign: "left"
    },
    ".text-right": {
      textAlign: "right"
    },
    ".text-center": {
      textAlign: "center"
    },
    ".highlight-search-match": {
      background: theme.components.textHighlight.background,
      color: theme.components.textHighlight.text,
      padding: 0
    }
  });
}
function getVariantStyles(variant) {
  return {
    margin: 0,
    fontSize: variant.fontSize,
    lineHeight: variant.lineHeight,
    fontWeight: variant.fontWeight,
    letterSpacing: variant.letterSpacing,
    fontFamily: variant.fontFamily,
    marginBottom: "0.45em"
  };
}

function getExtraStyles(theme) {
  return react.css({
    // fix white background on intercom in dark mode
    "iframe.intercom-borderless-frame": {
      colorScheme: theme.colors.mode
    }
  });
}

function getFormElementStyles(theme) {
  return react.css({
    "input, button, select, textarea": {
      fontFamily: theme.typography.body.fontFamily,
      fontSize: theme.typography.body.fontSize,
      fontWeight: theme.typography.body.fontWeight,
      lineHeight: theme.typography.body.lineHeight
    },
    "input, select": {
      backgroundColor: theme.components.input.background,
      color: theme.components.input.text,
      border: "none",
      boxShadow: "none"
    },
    textarea: {
      height: "auto"
    },
    // Reset width of input images, buttons, radios, checkboxes
    "input[type='file'], input[type='image'], input[type='submit'], input[type='reset'], input[type='button'], input[type='radio'], input[type='checkbox']": {
      width: "auto"
      // Override of generic input selector
    }
  });
}

function getMarkdownStyles(theme) {
  return react.css({
    // TODO copy from _utils.scss
  });
}

function getPageStyles(theme) {
  const maxWidthBreakpoint = theme.breakpoints.values.xxl + theme.spacing.gridSize * 2 + theme.components.sidemenu.width;
  return react.css({
    ".grafana-app": {
      display: "flex",
      alignItems: "stretch",
      position: "absolute",
      width: "100%",
      height: "100%",
      top: 0,
      left: 0
    },
    ".main-view": {
      position: "relative",
      display: "flex",
      flexDirection: "column",
      flexGrow: 1,
      height: "100%",
      flex: "1 1 0",
      minWidth: 0
    },
    ".page-scrollbar-content": {
      display: "flex",
      minHeight: "100%",
      flexDirection: "column",
      width: "100%",
      height: "100%"
    },
    ".page-container": {
      flexGrow: 1,
      flexBasis: "100%",
      paddingLeft: theme.spacing(2),
      paddingRight: theme.spacing(2),
      [theme.breakpoints.up("sm")]: {
        margin: theme.spacing(0, 1)
      },
      [theme.breakpoints.up("md")]: {
        margin: theme.spacing(0, 2)
      },
      [`@media (min-width: ${maxWidthBreakpoint}px)`]: {
        maxWidth: `${theme.breakpoints.values.xxl}px`,
        marginLeft: "auto",
        marginRight: "auto",
        width: "100%"
      }
    },
    ".page-full": {
      marginLeft: theme.spacing(2),
      paddingLeft: theme.spacing(2),
      paddingRight: theme.spacing(2)
    },
    ".page-body": {
      padding: theme.spacing(1),
      background: theme.components.panel.background,
      border: `1px solid ${theme.components.panel.borderColor}`,
      marginBottom: "32px",
      [theme.breakpoints.up("md")]: {
        padding: theme.spacing(2)
      },
      [theme.breakpoints.up("lg")]: {
        padding: theme.spacing(3)
      }
    },
    ".page-heading": {
      fontSize: theme.typography.h4.fontSize,
      marginTop: 0,
      marginBottom: theme.spacing(2)
    },
    ".page-action-bar": {
      marginBottom: theme.spacing(2),
      display: "flex",
      alignItems: "flex-start",
      gap: theme.spacing(2)
    },
    ".page-action-bar--narrow": {
      marginBottom: 0
    },
    ".page-action-bar__spacer": {
      width: theme.spacing(2),
      flexGrow: 1
    },
    ".page-sub-heading": {
      marginBottom: theme.spacing(2)
    },
    ".page-sub-heading-icon": {
      marginLeft: theme.spacing(1),
      marginTop: theme.spacing(0.5)
    },
    ".page-hidden": {
      display: "none"
    }
  });
}

var __defProp$32 = Object.defineProperty;
var __defProps$1P = Object.defineProperties;
var __getOwnPropDescs$1P = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2M = Object.getOwnPropertySymbols;
var __hasOwnProp$2M = Object.prototype.hasOwnProperty;
var __propIsEnum$2M = Object.prototype.propertyIsEnumerable;
var __defNormalProp$32 = (obj, key, value) => key in obj ? __defProp$32(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2K = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2M.call(b, prop))
      __defNormalProp$32(a, prop, b[prop]);
  if (__getOwnPropSymbols$2M)
    for (var prop of __getOwnPropSymbols$2M(b)) {
      if (__propIsEnum$2M.call(b, prop))
        __defNormalProp$32(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1P = (a, b) => __defProps$1P(a, __getOwnPropDescs$1P(b));
const fadeIn = css.keyframes({
  "0%": {
    opacity: 0
  },
  "100%": {
    opacity: 1
  }
});
const skeletonAnimation = {
  animationName: fadeIn,
  animationDelay: "100ms",
  animationTimingFunction: "ease-in",
  animationDuration: "100ms",
  animationFillMode: "backwards"
};
const attachSkeleton = (Component, Skeleton) => {
  const skeletonWrapper = (props) => {
    return /* @__PURE__ */ React__default["default"].createElement(
      Skeleton,
      __spreadProps$1P(__spreadValues$2K({}, props), {
        rootProps: {
          style: skeletonAnimation
        }
      })
    );
  };
  return Object.assign(Component, { Skeleton: skeletonWrapper });
};

const getSkeletonStyles$3 = (theme) => {
  return react.css({
    ".react-loading-skeleton": skeletonAnimation
  });
};

function GlobalStyles() {
  const theme = useTheme2();
  return /* @__PURE__ */ React__default["default"].createElement(
    react.Global,
    {
      styles: [
        getElementStyles(theme),
        getExtraStyles(theme),
        getFormElementStyles(theme),
        getPageStyles(theme),
        getCardStyles$1(theme),
        getAgularPanelStyles(theme),
        getMarkdownStyles(),
        getSkeletonStyles$3()
      ]
    }
  );
}

var __defProp$31 = Object.defineProperty;
var __defProps$1O = Object.defineProperties;
var __getOwnPropDescs$1O = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2L = Object.getOwnPropertySymbols;
var __hasOwnProp$2L = Object.prototype.hasOwnProperty;
var __propIsEnum$2L = Object.prototype.propertyIsEnumerable;
var __defNormalProp$31 = (obj, key, value) => key in obj ? __defProp$31(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2J = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2L.call(b, prop))
      __defNormalProp$31(a, prop, b[prop]);
  if (__getOwnPropSymbols$2L)
    for (var prop of __getOwnPropSymbols$2L(b)) {
      if (__propIsEnum$2L.call(b, prop))
        __defNormalProp$31(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1O = (a, b) => __defProps$1O(a, __getOwnPropDescs$1O(b));
function Portal$1(props) {
  const { children, className, root, forwardedRef } = props;
  const theme = useTheme2();
  const node = React.useRef(null);
  const portalRoot = root != null ? root : getPortalContainer();
  if (!node.current) {
    node.current = document.createElement("div");
    if (className) {
      node.current.className = className;
    }
    node.current.style.position = "relative";
    node.current.style.zIndex = `${theme.zIndex.portal}`;
  }
  React.useLayoutEffect(() => {
    if (node.current) {
      portalRoot.appendChild(node.current);
    }
    return () => {
      if (node.current) {
        portalRoot.removeChild(node.current);
      }
    };
  }, [portalRoot]);
  return ReactDOM__default["default"].createPortal(/* @__PURE__ */ React__default["default"].createElement("div", { ref: forwardedRef }, children), node.current);
}
function getPortalContainer() {
  var _a;
  return (_a = window.document.getElementById("grafana-portal-container")) != null ? _a : document.body;
}
function PortalContainer() {
  return /* @__PURE__ */ React__default["default"].createElement("div", { id: "grafana-portal-container" });
}
const RefForwardingPortal = React__default["default"].forwardRef((props, ref) => {
  return /* @__PURE__ */ React__default["default"].createElement(Portal$1, __spreadProps$1O(__spreadValues$2J({}, props), { forwardedRef: ref }));
});
RefForwardingPortal.displayName = "RefForwardingPortal";

var __defProp$30 = Object.defineProperty;
var __getOwnPropSymbols$2K = Object.getOwnPropertySymbols;
var __hasOwnProp$2K = Object.prototype.hasOwnProperty;
var __propIsEnum$2K = Object.prototype.propertyIsEnumerable;
var __defNormalProp$30 = (obj, key, value) => key in obj ? __defProp$30(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2I = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2K.call(b, prop))
      __defNormalProp$30(a, prop, b[prop]);
  if (__getOwnPropSymbols$2K)
    for (var prop of __getOwnPropSymbols$2K(b)) {
      if (__propIsEnum$2K.call(b, prop))
        __defNormalProp$30(a, prop, b[prop]);
    }
  return a;
};
const Tooltip = React__default["default"].forwardRef(
  ({ children, theme, interactive, show, placement, content }, forwardedRef) => {
    const arrowRef = React.useRef(null);
    const [controlledVisible, setControlledVisible] = React.useState(show);
    const isOpen = show != null ? show : controlledVisible;
    const middleware = [
      react$1.offset(8),
      react$1.flip({
        fallbackAxisSideDirection: "end",
        // see https://floating-ui.com/docs/flip#combining-with-shift
        crossAxis: false,
        boundary: document.body
      }),
      react$1.shift(),
      react$1.arrow({
        element: arrowRef
      })
    ];
    const { context, refs, floatingStyles } = react$1.useFloating({
      open: isOpen,
      placement: getPlacement(placement),
      onOpenChange: setControlledVisible,
      middleware,
      whileElementsMounted: react$1.autoUpdate
    });
    const tooltipId = React.useId();
    const hover = react$1.useHover(context, {
      delay: {
        close: interactive ? 100 : 0
      },
      move: false
    });
    const focus = react$1.useFocus(context);
    const dismiss = react$1.useDismiss(context);
    const { getReferenceProps, getFloatingProps } = react$1.useInteractions([dismiss, hover, focus]);
    const contentIsFunction = typeof content === "function";
    const styles = useStyles2(getStyles$20);
    const style = styles[theme != null ? theme : "info"];
    const handleRef = React.useCallback(
      (ref) => {
        refs.setReference(ref);
        if (typeof forwardedRef === "function") {
          forwardedRef(ref);
        } else if (forwardedRef) {
          forwardedRef.current = ref;
        }
      },
      [forwardedRef, refs]
    );
    const childHasMatchingAriaLabel = "aria-label" in children.props && children.props["aria-label"] === content;
    return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, React__default["default"].cloneElement(children, __spreadValues$2I({
      ref: handleRef,
      tabIndex: 0,
      // tooltip trigger should be keyboard focusable
      "aria-describedby": !childHasMatchingAriaLabel && isOpen ? tooltipId : void 0
    }, getReferenceProps())), isOpen && /* @__PURE__ */ React__default["default"].createElement(Portal$1, null, /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$2I({ ref: refs.setFloating, style: floatingStyles }, getFloatingProps()), /* @__PURE__ */ React__default["default"].createElement(react$1.FloatingArrow, { className: style.arrow, ref: arrowRef, context }), /* @__PURE__ */ React__default["default"].createElement(
      "div",
      {
        "data-testid": e2eSelectors.selectors.components.Tooltip.container,
        id: tooltipId,
        role: "tooltip",
        className: style.container
      },
      typeof content === "string" && content,
      React__default["default"].isValidElement(content) && React__default["default"].cloneElement(content),
      contentIsFunction && content({})
    ))));
  }
);
Tooltip.displayName = "Tooltip";
const getStyles$20 = (theme) => {
  const info = buildTooltipTheme(
    theme,
    theme.components.tooltip.background,
    theme.components.tooltip.background,
    theme.components.tooltip.text,
    { topBottom: 0.5, rightLeft: 1 }
  );
  const error = buildTooltipTheme(
    theme,
    theme.colors.error.main,
    theme.colors.error.main,
    theme.colors.error.contrastText,
    { topBottom: 0.5, rightLeft: 1 }
  );
  return {
    info,
    ["info-alt"]: info,
    error
  };
};

var __defProp$2$ = Object.defineProperty;
var __defNormalProp$2$ = (obj, key, value) => key in obj ? __defProp$2$(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$w = (obj, key, value) => {
  __defNormalProp$2$(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
class PopoverController extends React.Component {
  constructor() {
    super(...arguments);
    __publicField$w(this, "hideTimeout", null);
    __publicField$w(this, "state", { show: false });
    __publicField$w(this, "showPopper", () => {
      if (this.hideTimeout) {
        clearTimeout(this.hideTimeout);
      }
      this.setState({ show: true });
    });
    __publicField$w(this, "hidePopper", () => {
      this.hideTimeout = setTimeout(() => {
        this.setState({ show: false });
      }, this.props.hideAfter);
    });
  }
  render() {
    const { children, content, placement = "auto" } = this.props;
    const { show } = this.state;
    return children(this.showPopper, this.hidePopper, {
      show,
      placement,
      content
    });
  }
}

var __defProp$2_ = Object.defineProperty;
var __defProps$1N = Object.defineProperties;
var __getOwnPropDescs$1N = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2J = Object.getOwnPropertySymbols;
var __hasOwnProp$2J = Object.prototype.hasOwnProperty;
var __propIsEnum$2J = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2_ = (obj, key, value) => key in obj ? __defProp$2_(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2H = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2J.call(b, prop))
      __defNormalProp$2_(a, prop, b[prop]);
  if (__getOwnPropSymbols$2J)
    for (var prop of __getOwnPropSymbols$2J(b)) {
      if (__propIsEnum$2J.call(b, prop))
        __defNormalProp$2_(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1N = (a, b) => __defProps$1N(a, __getOwnPropDescs$1N(b));
var __objRest$1j = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2J.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2J)
    for (var prop of __getOwnPropSymbols$2J(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2J.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const FormLabel = (_a) => {
  var _b = _a, {
    children,
    isFocused,
    isInvalid,
    className,
    htmlFor,
    tooltip,
    width,
    interactive
  } = _b, rest = __objRest$1j(_b, [
    "children",
    "isFocused",
    "isInvalid",
    "className",
    "htmlFor",
    "tooltip",
    "width",
    "interactive"
  ]);
  const classes = classNames__default["default"](className, `gf-form-label width-${width ? width : "10"}`, {
    "gf-form-label--is-focused": isFocused,
    "gf-form-label--is-invalid": isInvalid
  });
  return /* @__PURE__ */ React__default["default"].createElement("label", __spreadProps$1N(__spreadValues$2H({ className: classes }, rest), { htmlFor }), children, tooltip && /* @__PURE__ */ React__default["default"].createElement(Tooltip, { placement: "top", content: tooltip, theme: "info", interactive }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "info-circle", size: "sm", style: { marginLeft: "10px" } })));
};
const InlineFormLabel = FormLabel;

var __defProp$2Z = Object.defineProperty;
var __defProps$1M = Object.defineProperties;
var __getOwnPropDescs$1M = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2I = Object.getOwnPropertySymbols;
var __hasOwnProp$2I = Object.prototype.hasOwnProperty;
var __propIsEnum$2I = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2Z = (obj, key, value) => key in obj ? __defProp$2Z(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2G = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2I.call(b, prop))
      __defNormalProp$2Z(a, prop, b[prop]);
  if (__getOwnPropSymbols$2I)
    for (var prop of __getOwnPropSymbols$2I(b)) {
      if (__propIsEnum$2I.call(b, prop))
        __defNormalProp$2Z(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1M = (a, b) => __defProps$1M(a, __getOwnPropDescs$1M(b));
var __objRest$1i = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2I.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2I)
    for (var prop of __getOwnPropSymbols$2I(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2I.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultProps = {
  labelWidth: 6,
  inputWidth: 12
};
const FormField = (_a) => {
  var _b = _a, {
    label,
    tooltip,
    labelWidth,
    inputWidth,
    inputEl,
    className,
    interactive
  } = _b, inputProps = __objRest$1i(_b, [
    "label",
    "tooltip",
    "labelWidth",
    "inputWidth",
    "inputEl",
    "className",
    "interactive"
  ]);
  const styles = getStyles$1$();
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.formField, className) }, /* @__PURE__ */ React__default["default"].createElement(InlineFormLabel, { width: labelWidth, tooltip, interactive }, label), inputEl || /* @__PURE__ */ React__default["default"].createElement(
    "input",
    __spreadProps$1M(__spreadValues$2G({
      type: "text",
      className: `gf-form-input ${inputWidth ? `width-${inputWidth}` : ""}`
    }, inputProps), {
      disabled: inputProps.disabled
    })
  ));
};
FormField.displayName = "FormField";
FormField.defaultProps = defaultProps;
const getStyles$1$ = () => {
  return {
    formField: css.css({
      display: "flex",
      flexDirection: "row",
      alignItems: "flex-start",
      textAlign: "left",
      position: "relative"
    })
  };
};

if (typeof window !== "undefined" && "Element" in window && !Element.prototype.closest) {
  Element.prototype.closest = function(s) {
    const matches = (this.document || this.ownerDocument).querySelectorAll(s);
    let el = this;
    let i;
    do {
      i = matches.length;
      while (--i >= 0 && matches.item(i) !== el) {
      }
      el = el.parentElement;
    } while (i < 0 && el);
    return el;
  };
}
function getPreviousCousin(node, selector) {
  let sibling = node.parentElement.previousSibling;
  let el;
  while (sibling) {
    el = sibling.querySelector(selector);
    if (el) {
      return el;
    }
    sibling = sibling.previousSibling;
  }
  return void 0;
}
function getNextCharacter(global) {
  const selection = (global || window).getSelection();
  if (!selection || !selection.anchorNode) {
    return null;
  }
  const range = selection.getRangeAt(0);
  const text = selection.anchorNode.textContent;
  const offset = range.startOffset;
  return text.slice(offset, offset + 1);
}

var dom = /*#__PURE__*/Object.freeze({
  __proto__: null,
  getPreviousCousin: getPreviousCousin,
  getNextCharacter: getNextCharacter
});

function getChildId(children) {
  let inputId;
  const child = React__default["default"].Children.only(children);
  if ("id" in (child == null ? void 0 : child.props)) {
    inputId = child.props.id;
  } else if ("inputId" in child.props) {
    inputId = child == null ? void 0 : child.props.inputId;
  }
  return typeof inputId === "string" ? inputId : void 0;
}
function renderOrCallToRender(itemToRender, props) {
  if (React__default["default"].isValidElement(itemToRender) || typeof itemToRender === "string" || typeof itemToRender === "number") {
    return itemToRender;
  }
  if (typeof itemToRender === "function" && props) {
    return itemToRender(props);
  }
  throw new Error(`${itemToRender} is not a React element nor a function that returns React element`);
}

var reactUtils = /*#__PURE__*/Object.freeze({
  __proto__: null,
  getChildId: getChildId,
  renderOrCallToRender: renderOrCallToRender
});

const PALETTE_ROWS = 4;
const DEFAULT_ANNOTATION_COLOR = "rgba(0, 211, 255, 1)";
const OK_COLOR = "rgba(11, 237, 50, 1)";
const ALERTING_COLOR = "rgba(237, 46, 24, 1)";
const NO_DATA_COLOR = "rgba(150, 150, 150, 1)";
const PENDING_COLOR = "rgba(247, 149, 32, 1)";
const REGION_FILL_ALPHA = 0.09;
const colors = [
  "#7EB26D",
  // 0: pale green
  "#EAB839",
  // 1: mustard
  "#6ED0E0",
  // 2: light blue
  "#EF843C",
  // 3: orange
  "#E24D42",
  // 4: red
  "#1F78C1",
  // 5: ocean
  "#BA43A9",
  // 6: purple
  "#705DA0",
  // 7: violet
  "#508642",
  // 8: dark green
  "#CCA300",
  // 9: dark sand
  "#447EBC",
  "#C15C17",
  "#890F02",
  "#0A437C",
  "#6D1F62",
  "#584477",
  "#B7DBAB",
  "#F4D598",
  "#70DBED",
  "#F9BA8F",
  "#F29191",
  "#82B5D8",
  "#E5A8E2",
  "#AEA2E0",
  "#629E51",
  "#E5AC0E",
  "#64B0C8",
  "#E0752D",
  "#BF1B00",
  "#0A50A1",
  "#962D82",
  "#614D93",
  "#9AC48A",
  "#F2C96D",
  "#65C5DB",
  "#F9934E",
  "#EA6460",
  "#5195CE",
  "#D683CE",
  "#806EB7",
  "#3F6833",
  "#967302",
  "#2F575E",
  "#99440A",
  "#58140C",
  "#052B51",
  "#511749",
  "#3F2B5B",
  "#E0F9D7",
  "#FCEACA",
  "#CFFAFF",
  "#F9E2D2",
  "#FCE2DE",
  "#BADFF4",
  "#F9D9F9",
  "#DEDAF7"
];
function sortColorsByHue(hexColors) {
  const hslColors = lodash.map(hexColors, hexToHsl);
  const sortedHSLColors = lodash.sortBy(hslColors, ["h"]);
  const chunkedHSLColors = lodash.chunk(sortedHSLColors, PALETTE_ROWS);
  const sortedChunkedHSLColors = lodash.map(chunkedHSLColors, (chunk2) => {
    return lodash.sortBy(chunk2, "l");
  });
  const flattenedZippedSortedChunkedHSLColors = lodash.flattenDeep(lodash.zip(...sortedChunkedHSLColors));
  return lodash.map(flattenedZippedSortedChunkedHSLColors, hslToHex);
}
function hexToHsl(color) {
  return tinycolor__default["default"](color).toHsl();
}
function hslToHex(color) {
  return tinycolor__default["default"](color).toHexString();
}
function getTextColorForBackground(color) {
  const b = tinycolor__default["default"](color).getBrightness();
  return b > 180 ? "rgb(32, 34, 38)" : "rgb(247, 248, 250)";
}
function getTextColorForAlphaBackground(color, themeIsDark) {
  const tcolor = tinycolor__default["default"](color);
  const b = tcolor.getBrightness();
  const a = tcolor.getAlpha();
  if (a < 0.3) {
    return themeIsDark ? "rgb(247, 248, 250)" : "rgb(32, 34, 38)";
  }
  return b > 180 ? "rgb(32, 34, 38)" : "rgb(247, 248, 250)";
}
let sortedColors = sortColorsByHue(colors);

var EventsWithValidation = /* @__PURE__ */ ((EventsWithValidation2) => {
  EventsWithValidation2["onBlur"] = "onBlur";
  EventsWithValidation2["onFocus"] = "onFocus";
  EventsWithValidation2["onChange"] = "onChange";
  return EventsWithValidation2;
})(EventsWithValidation || {});
const validate = (value, validationRules) => {
  const errors = validationRules.reduce((acc, currRule) => {
    if (!currRule.rule(value)) {
      return acc.concat(currRule.errorMessage);
    }
    return acc;
  }, []);
  return errors.length > 0 ? errors : null;
};
const hasValidationEvent = (event, validationEvents) => {
  return validationEvents && validationEvents[event];
};
const regexValidation = (pattern, errorMessage) => {
  return {
    rule: (valueToValidate) => {
      return !!valueToValidate.match(pattern);
    },
    errorMessage: errorMessage || "Value is not valid"
  };
};

const SCHEMA = {
  document: {
    nodes: [
      {
        match: [{ type: "paragraph" }, { type: "code_block" }, { type: "code_line" }]
      }
    ]
  },
  inlines: {}
};
const makeFragment = (text, syntax) => {
  const lines = text.split("\n").map(
    (line) => slate.Block.create({
      type: "code_line",
      nodes: [slate.Text.create(line)]
    })
  );
  const block = slate.Block.create({
    data: {
      syntax
    },
    type: "code_block",
    nodes: lines
  });
  return slate.Document.create({
    nodes: [block]
  });
};
const makeValue = (text, syntax) => {
  const fragment = makeFragment(text, syntax);
  return slate.Value.create({
    document: fragment
  });
};

const linkModelToContextMenuItems = (links) => {
  return links().map((link) => {
    return {
      label: link.title,
      ariaLabel: link.title,
      // TODO: rename to href
      url: link.href,
      target: link.target,
      icon: `${link.target === "_blank" ? "external-link-alt" : "link"}`,
      onClick: link.onClick
    };
  });
};
const isCompactUrl = (url) => {
  const compactExploreUrlRegex = /\/explore\?.*&(left|right)=\[(.*\,){2,}(.*){1}\]/;
  return compactExploreUrlRegex.test(url);
};

const TAG_COLORS = [
  "#D32D20",
  "#1E72B8",
  "#B240A2",
  "#705DA0",
  "#466803",
  "#497A3C",
  "#3D71AA",
  "#B15415",
  "#890F02",
  "#6E6E6E",
  "#0A437C",
  "#6D1F62",
  "#584477",
  "#4C7A3F",
  "#2F4F4F",
  "#BF1B00",
  "#7662B1",
  "#8A2EB8",
  "#517A00",
  "#000000",
  "#3F6833",
  "#2F575E",
  "#99440A",
  "#AE561A",
  "#0E4AB4",
  "#58140C",
  "#052B51",
  "#511749",
  "#3F2B5B"
];
const TAG_BORDER_COLORS = [
  "#FF7368",
  "#459EE7",
  "#E069CF",
  "#9683C6",
  "#6C8E29",
  "#76AC68",
  "#6AA4E2",
  "#E7823D",
  "#AF3528",
  "#9B9B9B",
  "#3069A2",
  "#934588",
  "#7E6A9D",
  "#88C477",
  "#557575",
  "#E54126",
  "#A694DD",
  "#B054DE",
  "#8FC426",
  "#262626",
  "#658E59",
  "#557D84",
  "#BF6A30",
  "#FF9B53",
  "#3470DA",
  "#7E3A32",
  "#2B5177",
  "#773D6F",
  "#655181"
];
function getTagColorIndexFromName(name = "") {
  const hash = djb2(name.toLowerCase());
  return Math.abs(hash % TAG_COLORS.length);
}
function getTagColorsFromName(name = "") {
  const index = getTagColorIndexFromName(name);
  return getTagColor(index);
}
function getTagColor(index) {
  return { color: TAG_COLORS[index], borderColor: TAG_BORDER_COLORS[index] };
}
function djb2(str) {
  let hash = 5381;
  for (let i = 0; i < str.length; i++) {
    hash = (hash << 5) + hash + str.charCodeAt(i);
  }
  return hash;
}

let scrollbarWidth = null;
function getScrollbarWidth() {
  if (scrollbarWidth !== null) {
    return scrollbarWidth;
  }
  if (typeof document !== "undefined") {
    const div = document.createElement("div");
    const newStyles = {
      width: "100px",
      height: "100px",
      position: "absolute",
      top: "-9999px",
      overflow: "scroll",
      MsOverflowStyle: "scrollbar"
    };
    Object.keys(newStyles).map((style) => {
      div.style[style] = newStyles[style];
    });
    document.body.appendChild(div);
    scrollbarWidth = div.offsetWidth - div.clientWidth;
    document.body.removeChild(div);
  } else {
    scrollbarWidth = 0;
  }
  return scrollbarWidth || 0;
}

const getCellLinks = (field, row) => {
  let links;
  if (field.getLinks) {
    links = field.getLinks({
      valueRowIndex: row.index
    });
  }
  if (!links) {
    return;
  }
  for (let i = 0; i < (links == null ? void 0 : links.length); i++) {
    if (links[i].onClick) {
      const origOnClick = links[i].onClick;
      links[i].onClick = (event) => {
        if (!(event.ctrlKey || event.metaKey || event.shiftKey)) {
          event.preventDefault();
          origOnClick(event, {
            field,
            rowIndex: row.index
          });
        }
      };
    }
  }
  return links;
};

let _context;
const cache = /* @__PURE__ */ new Map();
const cacheLimit = 500;
let ctxFontStyle = "";
function getCanvasContext() {
  if (!_context) {
    _context = document.createElement("canvas").getContext("2d");
  }
  return _context;
}
function measureText(text, fontSize, fontWeight = 400) {
  const fontStyle = `${fontWeight} ${fontSize}px 'Inter'`;
  const cacheKey = text + fontStyle;
  const fromCache = cache.get(cacheKey);
  if (fromCache) {
    return fromCache;
  }
  const context = getCanvasContext();
  if (ctxFontStyle !== fontStyle) {
    context.font = ctxFontStyle = fontStyle;
  }
  const metrics = context.measureText(text);
  if (cache.size === cacheLimit) {
    cache.clear();
  }
  cache.set(cacheKey, metrics);
  return metrics;
}
function calculateFontSize(text, width, height, lineHeight, maxSize, fontWeight) {
  const textSize = measureText(text, 14, fontWeight);
  const fontSizeBasedOnWidth = width / (textSize.width + 2) * 14;
  const fontSizeBasedOnHeight = height / lineHeight;
  const optimalSize = Math.min(fontSizeBasedOnHeight, fontSizeBasedOnWidth);
  return Math.min(optimalSize, maxSize != null ? maxSize : optimalSize);
}

function useForceUpdate() {
  const [_, setValue] = React.useState(0);
  return () => setValue((prevState) => prevState + 1);
}

function fuzzyMatch(stack, needle) {
  let distance = 0, searchIndex = stack.indexOf(needle);
  needle = needle.replace(/\s/g, "");
  const ranges = [];
  if (searchIndex !== -1) {
    return {
      distance: 0,
      found: true,
      ranges: [{ start: searchIndex, end: searchIndex + needle.length - 1 }]
    };
  }
  for (const letter of needle) {
    const letterIndex = stack.indexOf(letter, searchIndex);
    if (letterIndex === -1) {
      return { distance: Infinity, ranges: [], found: false };
    }
    if (searchIndex !== -1) {
      distance += letterIndex - searchIndex;
    }
    searchIndex = letterIndex + 1;
    if (ranges.length === 0) {
      ranges.push({ start: letterIndex, end: letterIndex });
    } else {
      const lastRange = lodash.last(ranges);
      if (letterIndex === lastRange.end + 1) {
        lastRange.end++;
      } else {
        ranges.push({ start: letterIndex, end: letterIndex });
      }
    }
  }
  return {
    distance,
    ranges,
    found: true
  };
}

var SearchFunctionType = /* @__PURE__ */ ((SearchFunctionType2) => {
  SearchFunctionType2["Word"] = "Word";
  SearchFunctionType2["Prefix"] = "Prefix";
  SearchFunctionType2["Fuzzy"] = "Fuzzy";
  return SearchFunctionType2;
})(SearchFunctionType || {});
const wordSearch = (items, text) => {
  return items.filter((c) => (c.filterText || c.label).includes(text));
};
const prefixSearch = (items, text) => {
  return items.filter((c) => (c.filterText || c.label).startsWith(text));
};
const fuzzySearch = (items, text) => {
  text = text.toLowerCase();
  return items.filter((item) => {
    const { distance, ranges, found } = fuzzyMatch(item.label.toLowerCase(), text);
    if (!found) {
      return false;
    }
    item.sortValue = distance;
    item.highlightParts = ranges;
    return true;
  });
};
const SearchFunctionMap = {
  ["Word" /* Word */]: wordSearch,
  ["Prefix" /* Prefix */]: prefixSearch,
  ["Fuzzy" /* Fuzzy */]: fuzzySearch
};

const throttledLog = lodash.throttle((...t) => {
  console.log(...t);
}, 500);
const createLogger = (name) => {
  let loggingEnabled = false;
  if (typeof window !== "undefined") {
    loggingEnabled = window.localStorage.getItem("grafana.debug") === "true";
  }
  return {
    logger: (id, throttle2 = false, ...t) => {
      if (process.env.NODE_ENV === "production" || process.env.NODE_ENV === "test" || !loggingEnabled) {
        return;
      }
      const fn = throttle2 ? throttledLog : console.log;
      fn(`[${name}: ${id}]:`, ...t);
    },
    enable: () => loggingEnabled = true,
    disable: () => loggingEnabled = false,
    isEnabled: () => loggingEnabled
  };
};

var __defProp$2Y = Object.defineProperty;
var __defProps$1L = Object.defineProperties;
var __getOwnPropDescs$1L = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2H = Object.getOwnPropertySymbols;
var __hasOwnProp$2H = Object.prototype.hasOwnProperty;
var __propIsEnum$2H = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2Y = (obj, key, value) => key in obj ? __defProp$2Y(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2F = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2H.call(b, prop))
      __defNormalProp$2Y(a, prop, b[prop]);
  if (__getOwnPropSymbols$2H)
    for (var prop of __getOwnPropSymbols$2H(b)) {
      if (__propIsEnum$2H.call(b, prop))
        __defNormalProp$2Y(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1L = (a, b) => __defProps$1L(a, __getOwnPropDescs$1L(b));
function attachDebugger(key, thebugger, logger) {
  var _a;
  if (process.env.NODE_ENV === "production") {
    return;
  }
  let completeDebugger = thebugger || {};
  if (logger !== void 0) {
    completeDebugger = __spreadProps$1L(__spreadValues$2F({}, completeDebugger), { enable: () => logger.enable(), disable: () => logger.disable() });
  }
  let debugGlobal = (_a = typeof window !== "undefined" && window["_debug"]) != null ? _a : {};
  debugGlobal[key] = completeDebugger;
  if (typeof window !== "undefined") {
    window["_debug"] = debugGlobal;
  }
}

var NodeGraphDataFrameFieldNames = /* @__PURE__ */ ((NodeGraphDataFrameFieldNames2) => {
  NodeGraphDataFrameFieldNames2["id"] = "id";
  NodeGraphDataFrameFieldNames2["title"] = "title";
  NodeGraphDataFrameFieldNames2["subTitle"] = "subTitle";
  NodeGraphDataFrameFieldNames2["mainStat"] = "mainStat";
  NodeGraphDataFrameFieldNames2["secondaryStat"] = "secondaryStat";
  NodeGraphDataFrameFieldNames2["source"] = "source";
  NodeGraphDataFrameFieldNames2["target"] = "target";
  NodeGraphDataFrameFieldNames2["detail"] = "detail__";
  NodeGraphDataFrameFieldNames2["arc"] = "arc__";
  NodeGraphDataFrameFieldNames2["color"] = "color";
  return NodeGraphDataFrameFieldNames2;
})(NodeGraphDataFrameFieldNames || {});

var __defProp$2X = Object.defineProperty;
var __defProps$1K = Object.defineProperties;
var __getOwnPropDescs$1K = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2G = Object.getOwnPropertySymbols;
var __hasOwnProp$2G = Object.prototype.hasOwnProperty;
var __propIsEnum$2G = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2X = (obj, key, value) => key in obj ? __defProp$2X(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2E = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2G.call(b, prop))
      __defNormalProp$2X(a, prop, b[prop]);
  if (__getOwnPropSymbols$2G)
    for (var prop of __getOwnPropSymbols$2G(b)) {
      if (__propIsEnum$2G.call(b, prop))
        __defNormalProp$2X(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1K = (a, b) => __defProps$1K(a, __getOwnPropDescs$1K(b));
var __objRest$1h = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2G.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2G)
    for (var prop of __getOwnPropSymbols$2G(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2G.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var __publicField$v = (obj, key, value) => {
  __defNormalProp$2X(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var LegacyInputStatus = /* @__PURE__ */ ((LegacyInputStatus2) => {
  LegacyInputStatus2["Invalid"] = "invalid";
  LegacyInputStatus2["Valid"] = "valid";
  return LegacyInputStatus2;
})(LegacyInputStatus || {});
class Input$1 extends React.PureComponent {
  constructor() {
    super(...arguments);
    __publicField$v(this, "state", {
      error: null
    });
    __publicField$v(this, "validatorAsync", (validationRules) => {
      return (evt) => {
        const errors = validate(evt.target.value, validationRules);
        this.setState((prevState) => {
          return __spreadProps$1K(__spreadValues$2E({}, prevState), { error: errors ? errors[0] : null });
        });
      };
    });
    __publicField$v(this, "populateEventPropsWithStatus", (restProps, validationEvents) => {
      const inputElementProps = __spreadValues$2E({}, restProps);
      if (!validationEvents) {
        return inputElementProps;
      }
      Object.keys(EventsWithValidation).forEach((eventName) => {
        if (hasValidationEvent(eventName, validationEvents) || restProps[eventName]) {
          inputElementProps[eventName] = async (evt) => {
            evt.persist();
            if (hasValidationEvent(eventName, validationEvents)) {
              await this.validatorAsync(validationEvents[eventName]).apply(this, [evt]);
            }
            if (restProps[eventName]) {
              restProps[eventName].apply(null, [evt, this.status]);
            }
          };
        }
      });
      return inputElementProps;
    });
  }
  get status() {
    return this.state.error ? "invalid" /* Invalid */ : "valid" /* Valid */;
  }
  get isInvalid() {
    return this.status === "invalid" /* Invalid */;
  }
  render() {
    const _a = this.props, { validationEvents, className, hideErrorMessage, inputRef } = _a, restProps = __objRest$1h(_a, ["validationEvents", "className", "hideErrorMessage", "inputRef"]);
    const { error } = this.state;
    const inputClassName = classNames__default["default"]("gf-form-input", { invalid: this.isInvalid }, className);
    const inputElementProps = this.populateEventPropsWithStatus(restProps, validationEvents);
    return /* @__PURE__ */ React__default["default"].createElement("div", { style: { flexGrow: 1 } }, /* @__PURE__ */ React__default["default"].createElement("input", __spreadProps$1K(__spreadValues$2E({}, inputElementProps), { ref: inputRef, className: inputClassName })), error && !hideErrorMessage && /* @__PURE__ */ React__default["default"].createElement("span", null, error));
  }
}
__publicField$v(Input$1, "defaultProps", {
  className: ""
});

var __defProp$2W = Object.defineProperty;
var __getOwnPropSymbols$2F = Object.getOwnPropertySymbols;
var __hasOwnProp$2F = Object.prototype.hasOwnProperty;
var __propIsEnum$2F = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2W = (obj, key, value) => key in obj ? __defProp$2W(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2D = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2F.call(b, prop))
      __defNormalProp$2W(a, prop, b[prop]);
  if (__getOwnPropSymbols$2F)
    for (var prop of __getOwnPropSymbols$2F(b)) {
      if (__propIsEnum$2F.call(b, prop))
        __defNormalProp$2W(a, prop, b[prop]);
    }
  return a;
};
const IndicatorsContainer$1 = (props) => {
  const isOpen = props.selectProps.menuIsOpen;
  return /* @__PURE__ */ React__default["default"].createElement(ReactSelect.components.IndicatorsContainer, __spreadValues$2D({}, props), /* @__PURE__ */ React__default["default"].createElement(Icon, { name: isOpen ? "angle-up" : "angle-down", style: { marginTop: "7px" } }));
};

var __defProp$2V = Object.defineProperty;
var __getOwnPropSymbols$2E = Object.getOwnPropertySymbols;
var __hasOwnProp$2E = Object.prototype.hasOwnProperty;
var __propIsEnum$2E = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2V = (obj, key, value) => key in obj ? __defProp$2V(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2C = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2E.call(b, prop))
      __defNormalProp$2V(a, prop, b[prop]);
  if (__getOwnPropSymbols$2E)
    for (var prop of __getOwnPropSymbols$2E(b)) {
      if (__propIsEnum$2E.call(b, prop))
        __defNormalProp$2V(a, prop, b[prop]);
    }
  return a;
};
const NoOptionsMessage = (props) => {
  const { children } = props;
  return /* @__PURE__ */ React__default["default"].createElement(ReactSelect.components.NoOptionsMessage, __spreadValues$2C({}, props), /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-select-box__desc-option" }, /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-select-box__desc-option__body" }, children)));
};

const ScrollIndicators = ({ children }) => {
  const [showScrollTopIndicator, setShowTopScrollIndicator] = React.useState(false);
  const [showScrollBottomIndicator, setShowBottomScrollIndicator] = React.useState(false);
  const scrollTopMarker = React.useRef(null);
  const scrollBottomMarker = React.useRef(null);
  const styles = useStyles2(getStyles$1_);
  React.useEffect(() => {
    const intersectionObserver = new IntersectionObserver((entries) => {
      entries.forEach((entry) => {
        if (entry.target === scrollTopMarker.current) {
          setShowTopScrollIndicator(!entry.isIntersecting);
        } else if (entry.target === scrollBottomMarker.current) {
          setShowBottomScrollIndicator(!entry.isIntersecting);
        }
      });
    });
    [scrollTopMarker, scrollBottomMarker].forEach((ref) => {
      if (ref.current) {
        intersectionObserver.observe(ref.current);
      }
    });
    return () => intersectionObserver.disconnect();
  }, []);
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      className: css.cx(styles.scrollIndicator, styles.scrollTopIndicator, {
        [styles.scrollIndicatorVisible]: showScrollTopIndicator
      })
    }
  ), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.scrollContent }, /* @__PURE__ */ React__default["default"].createElement("div", { ref: scrollTopMarker }), children, /* @__PURE__ */ React__default["default"].createElement("div", { ref: scrollBottomMarker })), /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      className: css.cx(styles.scrollIndicator, styles.scrollBottomIndicator, {
        [styles.scrollIndicatorVisible]: showScrollBottomIndicator
      })
    }
  ));
};
const getStyles$1_ = (theme) => {
  return {
    scrollContent: css.css({
      flex: 1,
      position: "relative"
    }),
    scrollIndicator: css.css({
      height: theme.spacing(6),
      left: 0,
      opacity: 0,
      pointerEvents: "none",
      position: "absolute",
      right: 0,
      transition: theme.transitions.create("opacity"),
      zIndex: 1
    }),
    scrollTopIndicator: css.css({
      background: `linear-gradient(0deg, transparent, ${theme.colors.background.canvas})`,
      top: 0
    }),
    scrollBottomIndicator: css.css({
      background: `linear-gradient(180deg, transparent, ${theme.colors.background.canvas})`,
      bottom: 0
    }),
    scrollIndicatorVisible: css.css({
      opacity: 1
    })
  };
};

var __defProp$2U = Object.defineProperty;
var __defProps$1J = Object.defineProperties;
var __getOwnPropDescs$1J = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2D = Object.getOwnPropertySymbols;
var __hasOwnProp$2D = Object.prototype.hasOwnProperty;
var __propIsEnum$2D = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2U = (obj, key, value) => key in obj ? __defProp$2U(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2B = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2D.call(b, prop))
      __defNormalProp$2U(a, prop, b[prop]);
  if (__getOwnPropSymbols$2D)
    for (var prop of __getOwnPropSymbols$2D(b)) {
      if (__propIsEnum$2D.call(b, prop))
        __defNormalProp$2U(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1J = (a, b) => __defProps$1J(a, __getOwnPropDescs$1J(b));
const CustomScrollbar = ({
  autoHide = false,
  autoHideTimeout = 200,
  setScrollTop,
  className,
  testId,
  autoHeightMin = "0",
  autoHeightMax = "100%",
  hideTracksWhenNotNeeded = false,
  hideHorizontalTrack,
  hideVerticalTrack,
  scrollRefCallback,
  showScrollIndicators = false,
  updateAfterMountMs,
  scrollTop,
  onScroll,
  children
}) => {
  const ref = React.useRef(null);
  const styles = useStyles2(getStyles$1Z);
  React.useEffect(() => {
    if (ref.current && scrollRefCallback) {
      scrollRefCallback(ref.current.view);
    }
  }, [ref, scrollRefCallback]);
  React.useEffect(() => {
    if (ref.current && scrollTop != null) {
      ref.current.scrollTop(scrollTop);
    }
  }, [scrollTop]);
  React.useEffect(() => {
    if (!updateAfterMountMs) {
      return;
    }
    setTimeout(() => {
      const scrollbar = ref.current;
      if (scrollbar == null ? void 0 : scrollbar.update) {
        scrollbar.update();
      }
    }, updateAfterMountMs);
  }, [updateAfterMountMs]);
  function renderTrack(className2, hideTrack, passedProps) {
    if (passedProps.style && hideTrack) {
      passedProps.style.display = "none";
    }
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1J(__spreadValues$2B({}, passedProps), { className: className2 }));
  }
  const renderTrackHorizontal = React.useCallback(
    (passedProps) => {
      return renderTrack("track-horizontal", hideHorizontalTrack, passedProps);
    },
    [hideHorizontalTrack]
  );
  const renderTrackVertical = React.useCallback(
    (passedProps) => {
      return renderTrack("track-vertical", hideVerticalTrack, passedProps);
    },
    [hideVerticalTrack]
  );
  const renderThumbHorizontal = React.useCallback((passedProps) => {
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1J(__spreadValues$2B({}, passedProps), { className: "thumb-horizontal" }));
  }, []);
  const renderThumbVertical = React.useCallback((passedProps) => {
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1J(__spreadValues$2B({}, passedProps), { className: "thumb-vertical" }));
  }, []);
  const renderView = React.useCallback((passedProps) => {
    if (passedProps.style && passedProps.style["WebkitOverflowScrolling"] === "touch") {
      passedProps.style["WebkitOverflowScrolling"] = "auto";
    }
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1J(__spreadValues$2B({}, passedProps), { className: "scrollbar-view" }));
  }, []);
  const onScrollStop = React.useCallback(() => {
    ref.current && setScrollTop && setScrollTop(ref.current.getValues());
  }, [setScrollTop]);
  return /* @__PURE__ */ React__default["default"].createElement(
    Scrollbars__default["default"],
    {
      "data-testid": testId,
      ref,
      className: css.cx(styles.customScrollbar, className, {
        [styles.scrollbarWithScrollIndicators]: showScrollIndicators
      }),
      onScrollStop,
      autoHeight: true,
      autoHide,
      autoHideTimeout,
      hideTracksWhenNotNeeded,
      autoHeightMax,
      autoHeightMin,
      renderTrackHorizontal,
      renderTrackVertical,
      renderThumbHorizontal,
      renderThumbVertical,
      renderView,
      onScroll
    },
    showScrollIndicators ? /* @__PURE__ */ React__default["default"].createElement(ScrollIndicators, null, children) : children
  );
};
const getStyles$1Z = (theme) => {
  return {
    customScrollbar: css.css({
      // Fix for Firefox. For some reason sometimes .view container gets a height of its content, but in order to
      // make scroll working it should fit outer container size (scroll appears only when inner container size is
      // greater than outer one).
      display: "flex",
      flexGrow: 1,
      ".scrollbar-view": {
        display: "flex",
        flexGrow: 1,
        flexDirection: "column"
      },
      ".track-vertical": {
        borderRadius: theme.shape.borderRadius(2),
        width: `${theme.spacing(1)} !important`,
        right: 0,
        bottom: theme.spacing(0.25),
        top: theme.spacing(0.25)
      },
      ".track-horizontal": {
        borderRadius: theme.shape.borderRadius(2),
        height: `${theme.spacing(1)} !important`,
        right: theme.spacing(0.25),
        bottom: theme.spacing(0.25),
        left: theme.spacing(0.25)
      },
      ".thumb-vertical": {
        background: theme.colors.action.focus,
        borderRadius: theme.shape.borderRadius(2),
        opacity: 0
      },
      ".thumb-horizontal": {
        background: theme.colors.action.focus,
        borderRadius: theme.shape.borderRadius(2),
        opacity: 0
      },
      "&:hover": {
        ".thumb-vertical, .thumb-horizontal": {
          opacity: 1,
          transition: "opacity 0.3s ease-in-out"
        }
      }
    }),
    // override the scroll container position so that the scroll indicators
    // are positioned at the top and bottom correctly.
    // react-custom-scrollbars doesn't provide any way for us to hook in nicely,
    // so we have to override with !important. feelsbad.
    scrollbarWithScrollIndicators: css.css({
      ".scrollbar-view": {
        // Need type assertion here due to the use of !important
        // see https://github.com/frenic/csstype/issues/114#issuecomment-697201978
        // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
        position: "static !important"
      }
    })
  };
};

var __defProp$2T = Object.defineProperty;
var __defNormalProp$2T = (obj, key, value) => key in obj ? __defProp$2T(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$u = (obj, key, value) => {
  __defNormalProp$2T(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
const getSelectOptionGroupStyles = stylesFactory((theme) => {
  return {
    header: css.css({
      display: "flex",
      alignItems: "center",
      justifyContent: "flex-start",
      justifyItems: "center",
      cursor: "pointer",
      padding: "7px 10px",
      width: "100%",
      borderBottom: `1px solid ${theme.colors.background.secondary}`,
      "&:hover": {
        color: theme.colors.text.maxContrast
      }
    }),
    label: css.css({
      flexGrow: 1
    }),
    icon: css.css({
      paddingRight: "2px"
    })
  };
});
class UnthemedSelectOptionGroup extends React.PureComponent {
  constructor() {
    super(...arguments);
    __publicField$u(this, "state", {
      expanded: false
    });
    __publicField$u(this, "onToggleChildren", () => {
      this.setState((prevState) => ({
        expanded: !prevState.expanded
      }));
    });
  }
  componentDidMount() {
    if (this.props.data.expanded) {
      this.setState({ expanded: true });
    } else if (this.props.selectProps && this.props.selectProps.value) {
      const { value } = this.props.selectProps.value;
      if (value && this.props.options.some((option) => option.value === value)) {
        this.setState({ expanded: true });
      }
    }
  }
  componentDidUpdate(nextProps) {
    if (nextProps.selectProps.inputValue !== "") {
      this.setState({ expanded: true });
    }
  }
  render() {
    const { children, label, theme } = this.props;
    const { expanded } = this.state;
    const styles = getSelectOptionGroupStyles(theme);
    return /* @__PURE__ */ React__default["default"].createElement("div", null, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.header, onClick: this.onToggleChildren, role: "presentation" }, /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.label }, label), /* @__PURE__ */ React__default["default"].createElement(Icon, { className: styles.icon, name: expanded ? "angle-up" : "angle-down" })), expanded && children);
  }
}
const SelectOptionGroup = withTheme2(UnthemedSelectOptionGroup);

function useDelayedSwitch(value, options = {}) {
  const { duration = 250, delay = 250 } = options;
  const [delayedValue, setDelayedValue] = React.useState(value);
  const onStartTime = React.useRef();
  React.useEffect(() => {
    let timeout;
    if (value) {
      timeout = setTimeout(() => {
        onStartTime.current = /* @__PURE__ */ new Date();
        setDelayedValue(value);
      }, delay);
    } else {
      const timeSpent = onStartTime.current ? Date.now() - onStartTime.current.valueOf() : 0;
      const turnOff = () => {
        onStartTime.current = void 0;
        setDelayedValue(value);
      };
      if (timeSpent >= duration) {
        turnOff();
      } else {
        timeout = setTimeout(turnOff, duration - timeSpent);
      }
    }
    return () => {
      if (timeout) {
        clearTimeout(timeout);
        timeout = void 0;
      }
    };
  }, [value, duration, delay]);
  return delayedValue;
}

var CompletionItemKind = /* @__PURE__ */ ((CompletionItemKind2) => {
  CompletionItemKind2["GroupTitle"] = "GroupTitle";
  return CompletionItemKind2;
})(CompletionItemKind || {});

const isIconSize = (value) => {
  return ["xs", "sm", "md", "lg", "xl", "xxl", "xxxl"].includes(value);
};
const getAvailableIcons = () => Object.keys(data.availableIconsIndex);
function getFieldTypeIcon(field) {
  return getFieldTypeIconName(field == null ? void 0 : field.type);
}
function getFieldTypeIconName(type) {
  if (type) {
    switch (type) {
      case data.FieldType.time:
        return "clock-nine";
      case data.FieldType.string:
        return "font";
      case data.FieldType.number:
        return "calculator-alt";
      case data.FieldType.boolean:
        return "toggle-on";
      case data.FieldType.trace:
        return "info-circle";
      case data.FieldType.enum:
        return "list-ol";
      case data.FieldType.geo:
        return "map-marker";
      case data.FieldType.other:
        return "brackets-curly";
    }
  }
  return "question-circle";
}

const Spinner = ({
  className,
  inline = false,
  iconClassName,
  style,
  size = "md"
}) => {
  const styles = useStyles2(getStyles$1Y);
  const deprecatedStyles = useStyles2(getDeprecatedStyles, size);
  if (typeof size !== "string" || !isIconSize(size)) {
    const iconRoot = getIconRoot();
    const iconName = "spinner";
    const subDir = getIconSubDir(iconName, "default");
    const svgPath = `${iconRoot}${subDir}/${iconName}.svg`;
    return /* @__PURE__ */ React__default["default"].createElement(
      "div",
      {
        "data-testid": "Spinner",
        style,
        className: css.cx(
          {
            [styles.inline]: inline
          },
          deprecatedStyles.wrapper,
          className
        )
      },
      /* @__PURE__ */ React__default["default"].createElement(
        SVG__default["default"],
        {
          src: svgPath,
          width: size,
          height: size,
          className: css.cx("fa-spin", deprecatedStyles.icon, className),
          style
        }
      )
    );
  }
  return /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      "data-testid": "Spinner",
      style,
      className: css.cx(
        {
          [styles.inline]: inline
        },
        className
      )
    },
    /* @__PURE__ */ React__default["default"].createElement(Icon, { className: css.cx("fa-spin", iconClassName), name: "spinner", size, "aria-label": "loading spinner" })
  );
};
const getStyles$1Y = (theme) => ({
  inline: css.css({
    display: "inline-block"
  })
});
const getDeprecatedStyles = (theme, size) => ({
  wrapper: css.css({
    fontSize: typeof size === "string" ? size : `${size}px`
  }),
  icon: css.css({
    display: "inline-block",
    fill: "currentColor",
    flexShrink: 0,
    label: "Icon",
    // line-height: 0; is needed for correct icon alignment in Safari
    lineHeight: 0,
    verticalAlign: "middle"
  })
});

function FadeTransition(props) {
  const { visible, children, duration = 250 } = props;
  const styles = useStyles2(getStyles$1X, duration);
  return /* @__PURE__ */ React__default["default"].createElement(reactTransitionGroup.CSSTransition, { in: visible, mountOnEnter: true, unmountOnExit: true, timeout: duration, classNames: styles }, children);
}
const getStyles$1X = (_theme, duration) => ({
  enter: css.css({
    label: "enter",
    opacity: 0
  }),
  enterActive: css.css({
    label: "enterActive",
    opacity: 1,
    transition: `opacity ${duration}ms ease-out`
  }),
  exit: css.css({
    label: "exit",
    opacity: 1
  }),
  exitActive: css.css({
    label: "exitActive",
    opacity: 0,
    transition: `opacity ${duration}ms ease-out`
  })
});

function SlideOutTransition(props) {
  const { visible, children, duration = 250, horizontal, size } = props;
  const styles = useStyles2(getStyles$1W, duration, horizontal ? "width" : "height", size);
  return /* @__PURE__ */ React__default["default"].createElement(reactTransitionGroup.CSSTransition, { in: visible, mountOnEnter: true, unmountOnExit: true, timeout: duration, classNames: styles }, children);
}
const getStyles$1W = (_theme, duration, measurement, size) => ({
  enter: css.css({
    label: "enter",
    [`${measurement}`]: 0,
    opacity: 0
  }),
  enterActive: css.css({
    label: "enterActive",
    [`${measurement}`]: `${size}px`,
    opacity: 1,
    transition: `opacity ${duration}ms ease-out, ${measurement} ${duration}ms ease-out`
  }),
  exit: css.css({
    label: "exit",
    [`${measurement}`]: `${size}px`,
    opacity: 1
  }),
  exitActive: css.css({
    label: "exitActive",
    opacity: 0,
    [`${measurement}`]: 0,
    transition: `opacity ${duration}ms ease-out, ${measurement} ${duration}ms ease-out`
  })
});

var __defProp$2S = Object.defineProperty;
var __defProps$1I = Object.defineProperties;
var __getOwnPropDescs$1I = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2C = Object.getOwnPropertySymbols;
var __hasOwnProp$2C = Object.prototype.hasOwnProperty;
var __propIsEnum$2C = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2S = (obj, key, value) => key in obj ? __defProp$2S(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2A = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2C.call(b, prop))
      __defNormalProp$2S(a, prop, b[prop]);
  if (__getOwnPropSymbols$2C)
    for (var prop of __getOwnPropSymbols$2C(b)) {
      if (__propIsEnum$2C.call(b, prop))
        __defNormalProp$2S(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1I = (a, b) => __defProps$1I(a, __getOwnPropDescs$1I(b));
const getStyles$1V = (theme) => {
  return {
    singleValue: css.css({
      label: "singleValue",
      whiteSpace: "nowrap",
      overflow: "hidden",
      textOverflow: "ellipsis",
      boxSizing: "border-box",
      maxWidth: "100%",
      gridArea: "1 / 1 / 2 / 3"
    }),
    spinnerWrapper: css.css({
      width: "16px",
      height: "16px",
      display: "inline-block",
      marginRight: "10px",
      position: "relative",
      verticalAlign: "middle",
      overflow: "hidden"
    }),
    spinnerIcon: css.css({
      width: "100%",
      height: "100%",
      position: "absolute"
    }),
    optionIcon: css.css({
      marginRight: theme.spacing(1),
      color: theme.colors.text.secondary
    }),
    disabled: css.css({
      color: theme.colors.text.disabled
    }),
    isOpen: css.css({
      color: theme.colors.text.disabled
    })
  };
};
const SingleValue = (props) => {
  var _a;
  const { children, data: data$1, isDisabled } = props;
  const styles = useStyles2(getStyles$1V);
  const loading = useDelayedSwitch(data$1.loading || false, { delay: 250, duration: 750 });
  const icon = data$1.icon ? data.toIconName(data$1.icon) : void 0;
  return /* @__PURE__ */ React__default["default"].createElement(
    ReactSelect.components.SingleValue,
    __spreadProps$1I(__spreadValues$2A({}, props), {
      className: css.cx(styles.singleValue, isDisabled && styles.disabled, props.selectProps.menuIsOpen && styles.isOpen)
    }),
    data$1.imgUrl ? /* @__PURE__ */ React__default["default"].createElement(FadeWithImage, { loading, imgUrl: data$1.imgUrl, styles, alt: String((_a = data$1.label) != null ? _a : data$1.value) }) : /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(SlideOutTransition, { horizontal: true, size: 16, visible: loading, duration: 150 }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.spinnerWrapper }, /* @__PURE__ */ React__default["default"].createElement(Spinner, { className: styles.spinnerIcon, inline: true }))), icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, role: "img", className: styles.optionIcon })),
    !data$1.hideText && children
  );
};
const FadeWithImage = (props) => {
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: props.styles.spinnerWrapper }, /* @__PURE__ */ React__default["default"].createElement(FadeTransition, { duration: 150, visible: props.loading }, /* @__PURE__ */ React__default["default"].createElement(Spinner, { className: props.styles.spinnerIcon, inline: true })), /* @__PURE__ */ React__default["default"].createElement(FadeTransition, { duration: 150, visible: !props.loading }, /* @__PURE__ */ React__default["default"].createElement("img", { className: props.styles.spinnerIcon, src: props.imgUrl, alt: props.alt })));
};

var __defProp$2R = Object.defineProperty;
var __defProps$1H = Object.defineProperties;
var __getOwnPropDescs$1H = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2B = Object.getOwnPropertySymbols;
var __hasOwnProp$2B = Object.prototype.hasOwnProperty;
var __propIsEnum$2B = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2R = (obj, key, value) => key in obj ? __defProp$2R(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2z = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2B.call(b, prop))
      __defNormalProp$2R(a, prop, b[prop]);
  if (__getOwnPropSymbols$2B)
    for (var prop of __getOwnPropSymbols$2B(b)) {
      if (__propIsEnum$2B.call(b, prop))
        __defNormalProp$2R(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1H = (a, b) => __defProps$1H(a, __getOwnPropDescs$1H(b));
function resetSelectStyles(theme) {
  return {
    clearIndicator: () => ({}),
    container: () => ({}),
    control: () => ({}),
    dropdownIndicator: () => ({}),
    group: () => ({}),
    groupHeading: () => ({}),
    indicatorsContainer: () => ({}),
    indicatorSeparator: () => ({}),
    input: function(originalStyles) {
      return __spreadProps$1H(__spreadValues$2z({}, originalStyles), {
        color: "inherit",
        margin: 0,
        padding: 0,
        // Set an explicit z-index here to ensure this element always overlays the singleValue
        zIndex: 1
      });
    },
    loadingIndicator: () => ({}),
    loadingMessage: () => ({}),
    menu: () => ({}),
    menuList: ({ maxHeight }) => ({
      maxHeight
    }),
    multiValue: () => ({}),
    multiValueLabel: () => ({
      overflow: "hidden",
      textOverflow: "ellipsis"
    }),
    multiValueRemove: () => ({}),
    noOptionsMessage: () => ({}),
    option: () => ({}),
    placeholder: (originalStyles) => __spreadProps$1H(__spreadValues$2z({}, originalStyles), {
      color: theme.colors.text.secondary
    }),
    singleValue: () => ({}),
    valueContainer: () => ({})
  };
}
function useCustomSelectStyles(theme, width) {
  return React.useMemo(() => {
    return __spreadProps$1H(__spreadValues$2z({}, resetSelectStyles(theme)), {
      menuPortal: (base) => {
        return __spreadProps$1H(__spreadValues$2z({}, base), {
          zIndex: theme.zIndex.portal
        });
      },
      //These are required for the menu positioning to function
      menu: ({ top, bottom, position }) => {
        return {
          top,
          bottom,
          position,
          minWidth: "100%",
          zIndex: theme.zIndex.dropdown
        };
      },
      container: () => ({
        width: width ? theme.spacing(width) : "100%",
        display: width === "auto" ? "inline-flex" : "flex"
      }),
      option: (provided, state) => __spreadProps$1H(__spreadValues$2z({}, provided), {
        opacity: state.isDisabled ? 0.5 : 1
      })
    });
  }, [theme, width]);
}

var __defProp$2Q = Object.defineProperty;
var __getOwnPropSymbols$2A = Object.getOwnPropertySymbols;
var __hasOwnProp$2A = Object.prototype.hasOwnProperty;
var __propIsEnum$2A = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2Q = (obj, key, value) => key in obj ? __defProp$2Q(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2y = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2A.call(b, prop))
      __defNormalProp$2Q(a, prop, b[prop]);
  if (__getOwnPropSymbols$2A)
    for (var prop of __getOwnPropSymbols$2A(b)) {
      if (__propIsEnum$2A.call(b, prop))
        __defNormalProp$2Q(a, prop, b[prop]);
    }
  return a;
};
const SelectOption = (props) => {
  const { children, isSelected, data } = props;
  return /* @__PURE__ */ React__default["default"].createElement(ReactSelect.components.Option, __spreadValues$2y({}, props), /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-select-box__desc-option" }, data.imgUrl && /* @__PURE__ */ React__default["default"].createElement("img", { className: "gf-form-select-box__desc-option__img", src: data.imgUrl, alt: "" }), /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-select-box__desc-option__body" }, /* @__PURE__ */ React__default["default"].createElement("div", null, children), data.description && /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-select-box__desc-option__desc" }, data.description)), isSelected && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "check", "aria-hidden": "true" })));
};

var __defProp$2P = Object.defineProperty;
var __getOwnPropSymbols$2z = Object.getOwnPropertySymbols;
var __hasOwnProp$2z = Object.prototype.hasOwnProperty;
var __propIsEnum$2z = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2P = (obj, key, value) => key in obj ? __defProp$2P(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2x = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2z.call(b, prop))
      __defNormalProp$2P(a, prop, b[prop]);
  if (__getOwnPropSymbols$2z)
    for (var prop of __getOwnPropSymbols$2z(b)) {
      if (__propIsEnum$2z.call(b, prop))
        __defNormalProp$2P(a, prop, b[prop]);
    }
  return a;
};
var __publicField$t = (obj, key, value) => {
  __defNormalProp$2P(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
const MenuList = (props) => {
  return /* @__PURE__ */ React__default["default"].createElement(ReactSelect.components.MenuList, __spreadValues$2x({}, props), /* @__PURE__ */ React__default["default"].createElement(CustomScrollbar, { autoHide: false, autoHeightMax: "inherit" }, props.children));
};
const _Select = class _Select extends React.PureComponent {
  render() {
    const {
      defaultValue,
      getOptionLabel,
      getOptionValue,
      onChange,
      options,
      placeholder,
      width,
      value,
      className,
      isDisabled,
      isLoading,
      isSearchable,
      isClearable,
      backspaceRemovesValue,
      isMulti,
      autoFocus,
      openMenuOnFocus,
      onBlur,
      maxMenuHeight,
      noOptionsMessage,
      isOpen,
      components: components2,
      tooltipContent,
      tabSelectsValue,
      onCloseMenu,
      onOpenMenu,
      allowCustomValue,
      formatCreateLabel,
      "aria-label": ariaLabel
    } = this.props;
    let widthClass = "";
    if (width) {
      widthClass = "width-" + width;
    }
    let SelectComponent = ReactSelect__default["default"];
    const creatableOptions = {};
    if (allowCustomValue) {
      SelectComponent = Creatable__default["default"];
      creatableOptions.formatCreateLabel = formatCreateLabel != null ? formatCreateLabel : (input) => input;
    }
    const selectClassNames = classNames__default["default"]("gf-form-input", "gf-form-input--form-dropdown", widthClass, className);
    const selectComponents = __spreadValues$2x(__spreadValues$2x({}, _Select.defaultProps.components), components2);
    return /* @__PURE__ */ React__default["default"].createElement(WrapInTooltip, { onCloseMenu, onOpenMenu, tooltipContent, isOpen }, (onOpenMenuInternal, onCloseMenuInternal) => {
      return /* @__PURE__ */ React__default["default"].createElement(
        SelectComponent,
        __spreadValues$2x({
          captureMenuScroll: false,
          classNamePrefix: "gf-form-select-box",
          className: selectClassNames,
          components: selectComponents,
          defaultValue,
          value,
          getOptionLabel,
          getOptionValue,
          menuShouldScrollIntoView: false,
          isSearchable,
          onChange,
          options,
          placeholder: placeholder || "Choose",
          styles: resetSelectStyles(this.context),
          isDisabled,
          isLoading,
          isClearable,
          autoFocus,
          onBlur,
          openMenuOnFocus,
          maxMenuHeight,
          noOptionsMessage,
          isMulti,
          backspaceRemovesValue,
          menuIsOpen: isOpen,
          onMenuOpen: onOpenMenuInternal,
          onMenuClose: onCloseMenuInternal,
          tabSelectsValue,
          "aria-label": ariaLabel
        }, creatableOptions)
      );
    });
  }
};
__publicField$t(_Select, "contextType", data.ThemeContext);
__publicField$t(_Select, "defaultProps", {
  className: "",
  isDisabled: false,
  isSearchable: true,
  isClearable: false,
  isMulti: false,
  openMenuOnFocus: false,
  autoFocus: false,
  isLoading: false,
  backspaceRemovesValue: true,
  maxMenuHeight: 300,
  tabSelectsValue: true,
  allowCustomValue: false,
  components: {
    Option: SelectOption,
    SingleValue,
    IndicatorsContainer: IndicatorsContainer$1,
    MenuList,
    Group: SelectOptionGroup
  }
});
let Select$1 = _Select;
class AsyncSelect$1 extends React.PureComponent {
  render() {
    const {
      defaultValue,
      getOptionLabel,
      getOptionValue,
      onChange,
      placeholder,
      width,
      value,
      className,
      loadOptions,
      defaultOptions,
      isLoading,
      loadingMessage,
      noOptionsMessage,
      isDisabled,
      isSearchable,
      isClearable,
      backspaceRemovesValue,
      autoFocus,
      onBlur,
      openMenuOnFocus,
      maxMenuHeight,
      isMulti,
      tooltipContent,
      onCloseMenu,
      onOpenMenu,
      isOpen
    } = this.props;
    let widthClass = "";
    if (width) {
      widthClass = "width-" + width;
    }
    const selectClassNames = classNames__default["default"]("gf-form-input", "gf-form-input--form-dropdown", widthClass, className);
    return /* @__PURE__ */ React__default["default"].createElement(WrapInTooltip, { onCloseMenu, onOpenMenu, tooltipContent, isOpen }, (onOpenMenuInternal, onCloseMenuInternal) => {
      return /* @__PURE__ */ React__default["default"].createElement(
        ReactAsyncSelect__default["default"],
        {
          captureMenuScroll: false,
          classNamePrefix: "gf-form-select-box",
          className: selectClassNames,
          components: {
            Option: SelectOption,
            SingleValue,
            IndicatorsContainer: IndicatorsContainer$1,
            NoOptionsMessage
          },
          defaultValue,
          value,
          getOptionLabel,
          getOptionValue,
          menuShouldScrollIntoView: false,
          onChange,
          loadOptions,
          isLoading,
          defaultOptions,
          placeholder: placeholder || "Choose",
          styles: resetSelectStyles(this.context),
          loadingMessage,
          noOptionsMessage,
          isDisabled,
          isSearchable,
          isClearable,
          autoFocus,
          onBlur,
          openMenuOnFocus,
          maxMenuHeight,
          isMulti,
          backspaceRemovesValue
        }
      );
    });
  }
}
__publicField$t(AsyncSelect$1, "contextType", data.ThemeContext);
__publicField$t(AsyncSelect$1, "defaultProps", {
  className: "",
  components: {},
  loadingMessage: () => "Loading...",
  isDisabled: false,
  isClearable: false,
  isMulti: false,
  isSearchable: true,
  backspaceRemovesValue: true,
  autoFocus: false,
  openMenuOnFocus: false,
  maxMenuHeight: 300
});
class WrapInTooltip extends React.PureComponent {
  constructor() {
    super(...arguments);
    __publicField$t(this, "state", {
      isOpenInternal: false
    });
    __publicField$t(this, "onOpenMenu", () => {
      const { onOpenMenu } = this.props;
      if (onOpenMenu) {
        onOpenMenu();
      }
      this.setState({ isOpenInternal: true });
    });
    __publicField$t(this, "onCloseMenu", () => {
      const { onCloseMenu } = this.props;
      if (onCloseMenu) {
        onCloseMenu();
      }
      this.setState({ isOpenInternal: false });
    });
  }
  render() {
    const { children, isOpen, tooltipContent } = this.props;
    const { isOpenInternal } = this.state;
    let showTooltip = void 0;
    if (isOpenInternal || isOpen) {
      showTooltip = false;
    }
    if (tooltipContent) {
      return /* @__PURE__ */ React__default["default"].createElement(Tooltip, { show: showTooltip, content: tooltipContent, placement: "bottom" }, /* @__PURE__ */ React__default["default"].createElement("div", null, children(this.onOpenMenu, this.onCloseMenu)));
    } else {
      return /* @__PURE__ */ React__default["default"].createElement("div", null, children(this.onOpenMenu, this.onCloseMenu));
    }
  }
}

var __defProp$2O = Object.defineProperty;
var __defNormalProp$2O = (obj, key, value) => key in obj ? __defProp$2O(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$s = (obj, key, value) => {
  __defNormalProp$2O(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
class Switch$1 extends React.PureComponent {
  constructor() {
    super(...arguments);
    __publicField$s(this, "state", {
      id: lodash.uniqueId()
    });
    __publicField$s(this, "internalOnChange", (event) => {
      event.stopPropagation();
      this.props.onChange(event);
    });
  }
  render() {
    const {
      labelClass = "",
      switchClass = "",
      label,
      checked,
      disabled,
      transparent,
      className,
      tooltip,
      tooltipPlacement
    } = this.props;
    const labelId = this.state.id;
    const labelClassName = `gf-form-label ${labelClass} ${transparent ? "gf-form-label--transparent" : ""} pointer`;
    const switchClassName = `gf-form-switch ${switchClass} ${transparent ? "gf-form-switch--transparent" : ""}`;
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-switch-container-react" }, /* @__PURE__ */ React__default["default"].createElement("label", { htmlFor: labelId, className: `gf-form gf-form-switch-container ${className || ""}` }, label && /* @__PURE__ */ React__default["default"].createElement("div", { className: labelClassName }, label, tooltip && /* @__PURE__ */ React__default["default"].createElement(Tooltip, { placement: tooltipPlacement ? tooltipPlacement : "auto", content: tooltip, theme: "info" }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "info-circle", size: "sm", style: { marginLeft: "10px" } }))), /* @__PURE__ */ React__default["default"].createElement("div", { className: switchClassName }, /* @__PURE__ */ React__default["default"].createElement(
      "input",
      {
        disabled,
        id: labelId,
        type: "checkbox",
        checked,
        onChange: this.internalOnChange
      }
    ), /* @__PURE__ */ React__default["default"].createElement("span", { className: "gf-form-switch__slider" }))));
  }
}

const getFocusStyle = (theme) => css.css({
  "&:focus": getFocusStyles(theme)
});
const sharedInputStyle = (theme, invalid = false) => {
  const borderColor = invalid ? theme.colors.error.border : theme.components.input.borderColor;
  const borderColorHover = invalid ? theme.colors.error.shade : theme.components.input.borderHover;
  const background = theme.components.input.background;
  const textColor = theme.components.input.text;
  const autoFillBorder = theme.isDark ? "#2e2f35" : "#bab4ca";
  return css.cx(
    inputPadding(theme),
    css.css({
      background,
      lineHeight: theme.typography.body.lineHeight,
      fontSize: theme.typography.size.md,
      color: textColor,
      border: `1px solid ${borderColor}`,
      "&:-webkit-autofill, &:-webkit-autofill:hover": {
        /* Welcome to 2005. This is a HACK to get rid od Chromes default autofill styling */
        boxShadow: `inset 0 0 0 1px rgba(255, 255, 255, 0), inset 0 0 0 100px ${background}!important`,
        WebkitTextFillColor: `${textColor} !important`,
        borderColor: autoFillBorder
      },
      "&:-webkit-autofill:focus": {
        /* Welcome to 2005. This is a HACK to get rid od Chromes default autofill styling */
        boxShadow: `0 0 0 2px ${theme.colors.background.primary}, 0 0 0px 4px ${theme.colors.primary.main}, inset 0 0 0 1px rgba(255, 255, 255, 0), inset 0 0 0 100px ${background}!important`,
        WebkitTextFillColor: `${textColor} !important`
      },
      "&:hover": {
        borderColor: borderColorHover
      },
      "&:focus": {
        outline: "none"
      },
      "&:disabled": {
        backgroundColor: theme.colors.action.disabledBackground,
        color: theme.colors.action.disabledText,
        border: `1px solid ${theme.colors.action.disabledBackground}`,
        "&:hover": {
          borderColor
        }
      },
      "&::placeholder": {
        color: theme.colors.text.disabled,
        opacity: 1
      }
    })
  );
};
const inputPadding = (theme) => {
  return css.css({
    padding: theme.spacing(0, 1, 0, 1)
  });
};
const inputSizes = () => {
  return {
    sm: css.css({
      width: inputSizesPixels("sm")
    }),
    md: css.css({
      width: inputSizesPixels("md")
    }),
    lg: css.css({
      width: inputSizesPixels("lg")
    }),
    auto: css.css({
      width: inputSizesPixels("auto")
    })
  };
};
const inputSizesPixels = (size) => {
  switch (size) {
    case "sm":
      return "200px";
    case "md":
      return "320px";
    case "lg":
      return "580px";
    case "auto":
    default:
      return "auto";
  }
};
function getPropertiesForButtonSize(size, theme) {
  switch (size) {
    case "sm":
      return {
        padding: 1,
        fontSize: theme.typography.size.sm,
        height: theme.components.height.sm
      };
    case "lg":
      return {
        padding: 3,
        fontSize: theme.typography.size.lg,
        height: theme.components.height.lg
      };
    case "md":
    default:
      return {
        padding: 2,
        fontSize: theme.typography.size.md,
        height: theme.components.height.md
      };
  }
}

var __defProp$2N = Object.defineProperty;
var __defProps$1G = Object.defineProperties;
var __getOwnPropDescs$1G = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2y = Object.getOwnPropertySymbols;
var __hasOwnProp$2y = Object.prototype.hasOwnProperty;
var __propIsEnum$2y = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2N = (obj, key, value) => key in obj ? __defProp$2N(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2w = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2y.call(b, prop))
      __defNormalProp$2N(a, prop, b[prop]);
  if (__getOwnPropSymbols$2y)
    for (var prop of __getOwnPropSymbols$2y(b)) {
      if (__propIsEnum$2y.call(b, prop))
        __defNormalProp$2N(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1G = (a, b) => __defProps$1G(a, __getOwnPropDescs$1G(b));
var __objRest$1g = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2y.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2y)
    for (var prop of __getOwnPropSymbols$2y(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2y.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Button = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, {
      variant = "primary",
      size = "md",
      fill = "solid",
      icon,
      fullWidth,
      children,
      className,
      type = "button",
      tooltip,
      tooltipPlacement
    } = _b, otherProps = __objRest$1g(_b, [
      "variant",
      "size",
      "fill",
      "icon",
      "fullWidth",
      "children",
      "className",
      "type",
      "tooltip",
      "tooltipPlacement"
    ]);
    const theme = useTheme2();
    const styles = getButtonStyles({
      theme,
      size,
      variant,
      fill,
      fullWidth,
      iconOnly: !children
    });
    const button = /* @__PURE__ */ React__default["default"].createElement("button", __spreadProps$1G(__spreadValues$2w({ className: css.cx(styles.button, className), type }, otherProps), { ref: tooltip ? void 0 : ref }), icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, size, className: styles.icon }), children && /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.content }, children));
    if (tooltip) {
      return /* @__PURE__ */ React__default["default"].createElement(Tooltip, { ref, content: tooltip, placement: tooltipPlacement }, button);
    }
    return button;
  }
);
Button.displayName = "Button";
const LinkButton = React__default["default"].forwardRef(
  (_c, ref) => {
    var _d = _c, {
      variant = "primary",
      size = "md",
      fill = "solid",
      icon,
      fullWidth,
      children,
      className,
      onBlur,
      onFocus,
      disabled,
      tooltip,
      tooltipPlacement
    } = _d, otherProps = __objRest$1g(_d, [
      "variant",
      "size",
      "fill",
      "icon",
      "fullWidth",
      "children",
      "className",
      "onBlur",
      "onFocus",
      "disabled",
      "tooltip",
      "tooltipPlacement"
    ]);
    const theme = useTheme2();
    const styles = getButtonStyles({
      theme,
      fullWidth,
      size,
      variant,
      fill,
      iconOnly: !children
    });
    const linkButtonStyles = css.cx(
      styles.button,
      {
        [css.css(styles.disabled, {
          pointerEvents: "none"
        })]: disabled
      },
      className
    );
    const button = /* @__PURE__ */ React__default["default"].createElement(
      "a",
      __spreadProps$1G(__spreadValues$2w({
        className: linkButtonStyles
      }, otherProps), {
        tabIndex: disabled ? -1 : 0,
        "aria-disabled": disabled,
        ref: tooltip ? void 0 : ref
      }),
      icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, size, className: styles.icon }),
      children && /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.content }, children)
    );
    if (tooltip) {
      return /* @__PURE__ */ React__default["default"].createElement(Tooltip, { ref, content: tooltip, placement: tooltipPlacement }, button);
    }
    return button;
  }
);
LinkButton.displayName = "LinkButton";
const getButtonStyles = (props) => {
  const { theme, variant, fill = "solid", size, iconOnly, fullWidth } = props;
  const { height, padding, fontSize } = getPropertiesForButtonSize(size, theme);
  const variantStyles = getPropertiesForVariant(theme, variant, fill);
  const disabledStyles = getPropertiesForDisabled(theme, variant, fill);
  const focusStyle = getFocusStyles(theme);
  const paddingMinusBorder = theme.spacing.gridSize * padding - 1;
  return {
    button: css.css(__spreadProps$1G(__spreadValues$2w(__spreadValues$2w({
      label: "button",
      display: "inline-flex",
      alignItems: "center",
      fontSize,
      fontWeight: theme.typography.fontWeightMedium,
      fontFamily: theme.typography.fontFamily,
      padding: `0 ${paddingMinusBorder}px`,
      height: theme.spacing(height),
      // Deduct border from line-height for perfect vertical centering on windows and linux
      lineHeight: `${theme.spacing.gridSize * height - 2}px`,
      verticalAlign: "middle",
      cursor: "pointer",
      borderRadius: theme.shape.radius.default,
      "&:focus": focusStyle,
      "&:focus-visible": focusStyle,
      "&:focus:not(:focus-visible)": getMouseFocusStyles()
    }, fullWidth && {
      flexGrow: 1,
      justifyContent: "center"
    }), variantStyles), {
      ":disabled": disabledStyles,
      "&[disabled]": disabledStyles
    })),
    disabled: css.css(disabledStyles),
    img: css.css({
      width: "16px",
      height: "16px",
      margin: theme.spacing(0, 1, 0, 0.5)
    }),
    icon: iconOnly ? css.css({
      // Important not to set margin bottom here as it would override internal icon bottom margin
      marginRight: theme.spacing(-padding / 2),
      marginLeft: theme.spacing(-padding / 2)
    }) : css.css({
      marginRight: theme.spacing(padding / 2)
    }),
    content: css.css({
      display: "flex",
      flexDirection: "row",
      alignItems: "center",
      whiteSpace: "nowrap",
      overflow: "hidden",
      height: "100%"
    })
  };
};
function getButtonVariantStyles(theme, color, fill) {
  let outlineBorderColor = color.border;
  let borderColor = "transparent";
  let hoverBorderColor = "transparent";
  if (color.name === "secondary") {
    borderColor = color.border;
    hoverBorderColor = theme.colors.emphasize(color.border, 0.25);
    outlineBorderColor = theme.colors.border.strong;
  }
  if (fill === "outline") {
    return {
      background: "transparent",
      color: color.text,
      border: `1px solid ${outlineBorderColor}`,
      transition: theme.transitions.create(["background-color", "border-color", "color"], {
        duration: theme.transitions.duration.short
      }),
      "&:hover": {
        background: color.transparent,
        borderColor: theme.colors.emphasize(outlineBorderColor, 0.25),
        color: color.text
      }
    };
  }
  if (fill === "text") {
    return {
      background: "transparent",
      color: color.text,
      border: "1px solid transparent",
      transition: theme.transitions.create(["background-color", "color"], {
        duration: theme.transitions.duration.short
      }),
      "&:focus": {
        outline: "none",
        textDecoration: "none"
      },
      "&:hover": {
        background: color.transparent,
        textDecoration: "none"
      }
    };
  }
  return {
    background: color.main,
    color: color.contrastText,
    border: `1px solid ${borderColor}`,
    transition: theme.transitions.create(["background-color", "box-shadow", "border-color", "color"], {
      duration: theme.transitions.duration.short
    }),
    "&:hover": {
      background: color.shade,
      color: color.contrastText,
      boxShadow: theme.shadows.z1,
      borderColor: hoverBorderColor
    }
  };
}
function getPropertiesForDisabled(theme, variant, fill) {
  const disabledStyles = {
    cursor: "not-allowed",
    boxShadow: "none",
    color: theme.colors.text.disabled,
    transition: "none"
  };
  if (fill === "text") {
    return __spreadProps$1G(__spreadValues$2w({}, disabledStyles), {
      background: "transparent",
      border: `1px solid transparent`
    });
  }
  if (fill === "outline") {
    return __spreadProps$1G(__spreadValues$2w({}, disabledStyles), {
      background: "transparent",
      border: `1px solid ${theme.colors.border.weak}`
    });
  }
  return __spreadProps$1G(__spreadValues$2w({}, disabledStyles), {
    background: theme.colors.action.disabledBackground,
    border: `1px solid transparent`
  });
}
function getPropertiesForVariant(theme, variant, fill) {
  switch (variant) {
    case "secondary":
      return getButtonVariantStyles(theme, theme.colors.secondary, fill);
    case "destructive":
      return getButtonVariantStyles(theme, theme.colors.error, fill);
    case "success":
      return getButtonVariantStyles(theme, theme.colors.success, fill);
    case "primary":
    default:
      return getButtonVariantStyles(theme, theme.colors.primary, fill);
  }
}
const clearButtonStyles = (theme) => {
  return css.css({
    background: "transparent",
    color: theme.colors.text.primary,
    border: "none",
    padding: 0
  });
};
const clearLinkButtonStyles = (theme) => {
  return css.css({
    background: "transparent",
    border: "none",
    padding: 0,
    fontFamily: "inherit",
    color: "inherit",
    height: "100%",
    "&:hover": {
      background: "transparent",
      color: "inherit"
    }
  });
};

var __defProp$2M = Object.defineProperty;
var __getOwnPropSymbols$2x = Object.getOwnPropertySymbols;
var __hasOwnProp$2x = Object.prototype.hasOwnProperty;
var __propIsEnum$2x = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2M = (obj, key, value) => key in obj ? __defProp$2M(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2v = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2x.call(b, prop))
      __defNormalProp$2M(a, prop, b[prop]);
  if (__getOwnPropSymbols$2x)
    for (var prop of __getOwnPropSymbols$2x(b)) {
      if (__propIsEnum$2x.call(b, prop))
        __defNormalProp$2M(a, prop, b[prop]);
    }
  return a;
};
var __objRest$1f = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2x.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2x)
    for (var prop of __getOwnPropSymbols$2x(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2x.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const getSecretFormFieldStyles = () => {
  return {
    noRadiusInput: css.css({
      borderBottomRightRadius: "0 !important",
      borderTopRightRadius: "0 !important"
    }),
    noRadiusButton: css.css({
      borderBottomLeftRadius: "0 !important",
      borderTopLeftRadius: "0 !important"
    })
  };
};
const SecretFormField = (_a) => {
  var _b = _a, {
    label = "Password",
    labelWidth,
    inputWidth = 12,
    onReset,
    isConfigured,
    tooltip,
    placeholder = "Password",
    interactive
  } = _b, inputProps = __objRest$1f(_b, [
    "label",
    "labelWidth",
    "inputWidth",
    "onReset",
    "isConfigured",
    "tooltip",
    "placeholder",
    "interactive"
  ]);
  const styles = getSecretFormFieldStyles();
  return /* @__PURE__ */ React__default["default"].createElement(
    FormField,
    {
      label,
      tooltip,
      interactive,
      labelWidth,
      inputEl: isConfigured ? /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(
        "input",
        __spreadValues$2v({
          type: "text",
          className: css.cx(`gf-form-input width-${inputWidth}`, styles.noRadiusInput),
          disabled: true,
          value: "configured"
        }, lodash.omit(inputProps, "value"))
      ), /* @__PURE__ */ React__default["default"].createElement(Button, { onClick: onReset, variant: "secondary", type: "button" }, "Reset")) : /* @__PURE__ */ React__default["default"].createElement(
        "input",
        __spreadValues$2v({
          type: "password",
          className: `gf-form-input width-${inputWidth}`,
          placeholder
        }, inputProps)
      )
    }
  );
};
SecretFormField.displayName = "SecretFormField";

var __defProp$2L = Object.defineProperty;
var __defProps$1F = Object.defineProperties;
var __getOwnPropDescs$1F = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2w = Object.getOwnPropertySymbols;
var __hasOwnProp$2w = Object.prototype.hasOwnProperty;
var __propIsEnum$2w = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2L = (obj, key, value) => key in obj ? __defProp$2L(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2u = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2w.call(b, prop))
      __defNormalProp$2L(a, prop, b[prop]);
  if (__getOwnPropSymbols$2w)
    for (var prop of __getOwnPropSymbols$2w(b)) {
      if (__propIsEnum$2w.call(b, prop))
        __defNormalProp$2L(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1F = (a, b) => __defProps$1F(a, __getOwnPropDescs$1F(b));
var __objRest$1e = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2w.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2w)
    for (var prop of __getOwnPropSymbols$2w(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2w.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const IconButton = React__default["default"].forwardRef((props, ref) => {
  const { size = "md", variant = "secondary" } = props;
  let limitedIconSize;
  if (size === "xxl" || size === "xxxl") {
    data.deprecationWarning("IconButton", 'size="xxl" and size="xxxl"', 'size="xl"');
    limitedIconSize = "xl";
  } else {
    limitedIconSize = size;
  }
  const styles = useStyles2(getStyles$1U, limitedIconSize, variant);
  let ariaLabel;
  let buttonRef;
  if ("tooltip" in props) {
    const { tooltip } = props;
    ariaLabel = typeof tooltip === "string" ? tooltip : void 0;
  } else if ("ariaLabel" in props || "aria-label" in props) {
    const { ariaLabel: deprecatedAriaLabel, ["aria-label"]: ariaLabelProp } = props;
    ariaLabel = ariaLabelProp || deprecatedAriaLabel;
    buttonRef = ref;
  }
  if ("tooltip" in props) {
    const _a = props, { name, iconType, className, tooltip, tooltipPlacement } = _a, restProps = __objRest$1e(_a, ["name", "iconType", "className", "tooltip", "tooltipPlacement"]);
    return /* @__PURE__ */ React__default["default"].createElement(Tooltip, { ref, content: tooltip, placement: tooltipPlacement }, /* @__PURE__ */ React__default["default"].createElement(
      "button",
      __spreadProps$1F(__spreadValues$2u({}, restProps), {
        ref: buttonRef,
        "aria-label": ariaLabel,
        className: css.cx(styles.button, className),
        type: "button"
      }),
      /* @__PURE__ */ React__default["default"].createElement(Icon, { name, size: limitedIconSize, className: styles.icon, type: iconType })
    ));
  } else {
    const _b = props, { name, iconType, className } = _b, restProps = __objRest$1e(_b, ["name", "iconType", "className"]);
    return /* @__PURE__ */ React__default["default"].createElement(
      "button",
      __spreadProps$1F(__spreadValues$2u({}, restProps), {
        ref: buttonRef,
        "aria-label": ariaLabel,
        className: css.cx(styles.button, className),
        type: "button"
      }),
      /* @__PURE__ */ React__default["default"].createElement(Icon, { name, size: limitedIconSize, className: styles.icon, type: iconType })
    );
  }
});
IconButton.displayName = "IconButton";
const getStyles$1U = (theme, size, variant) => {
  const hoverSize = getSvgSize(size) + theme.spacing.gridSize;
  let iconColor = theme.colors.text.primary;
  if (variant === "primary") {
    iconColor = theme.colors.primary.text;
  } else if (variant === "destructive") {
    iconColor = theme.colors.error.text;
  }
  return {
    button: css.css({
      zIndex: 0,
      position: "relative",
      margin: `0 ${theme.spacing.x0_5} 0 0`,
      boxShadow: "none",
      border: "none",
      display: "inline-flex",
      background: "transparent",
      justifyContent: "center",
      alignItems: "center",
      padding: 0,
      color: iconColor,
      "&[disabled], &:disabled": {
        cursor: "not-allowed",
        color: theme.colors.action.disabledText,
        opacity: 0.65
      },
      "&:before": {
        zIndex: -1,
        position: "absolute",
        opacity: 0,
        width: `${hoverSize}px`,
        height: `${hoverSize}px`,
        borderRadius: theme.shape.radius.default,
        content: '""',
        transitionDuration: "0.2s",
        transitionTimingFunction: "cubic-bezier(0.4, 0, 0.2, 1)",
        transitionProperty: "opacity"
      },
      "&:focus, &:focus-visible": getFocusStyles(theme),
      "&:focus:not(:focus-visible)": getMouseFocusStyles(),
      "&:hover": {
        "&:before": {
          backgroundColor: variant === "secondary" ? theme.colors.action.hover : data.colorManipulator.alpha(iconColor, 0.12),
          opacity: 1
        }
      }
    }),
    icon: css.css({
      verticalAlign: "baseline"
    })
  };
};

var __defProp$2K = Object.defineProperty;
var __getOwnPropSymbols$2v = Object.getOwnPropertySymbols;
var __hasOwnProp$2v = Object.prototype.hasOwnProperty;
var __propIsEnum$2v = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2K = (obj, key, value) => key in obj ? __defProp$2K(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2t = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2v.call(b, prop))
      __defNormalProp$2K(a, prop, b[prop]);
  if (__getOwnPropSymbols$2v)
    for (var prop of __getOwnPropSymbols$2v(b)) {
      if (__propIsEnum$2v.call(b, prop))
        __defNormalProp$2K(a, prop, b[prop]);
    }
  return a;
};
var __objRest$1d = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2v.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2v)
    for (var prop of __getOwnPropSymbols$2v(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2v.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const ButtonGroup = React.forwardRef((_a, ref) => {
  var _b = _a, { className, children } = _b, rest = __objRest$1d(_b, ["className", "children"]);
  const styles = useStyles2(getStyles$1T);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$2t({ ref, className: css.cx("button-group", styles.wrapper, className) }, rest), children);
});
ButtonGroup.displayName = "ButtonGroup";
const getStyles$1T = (theme) => ({
  wrapper: css.css({
    display: "flex",
    "> .button-group:not(:first-child) > button, > button:not(:first-child)": {
      borderTopLeftRadius: 0,
      borderBottomLeftRadius: 0
    },
    "> .button-group:not(:last-child) > button, > button:not(:last-child)": {
      borderTopRightRadius: 0,
      borderBottomRightRadius: 0,
      borderRightWidth: 0
    }
  })
});

var __defProp$2J = Object.defineProperty;
var __defNormalProp$2J = (obj, key, value) => key in obj ? __defProp$2J(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$r = (obj, key, value) => {
  __defNormalProp$2J(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
class UnThemedConfirmButton extends React.PureComponent {
  constructor() {
    super(...arguments);
    __publicField$r(this, "mainButtonRef", React__default["default"].createRef());
    __publicField$r(this, "confirmButtonRef", React__default["default"].createRef());
    __publicField$r(this, "state", {
      showConfirm: false
    });
    __publicField$r(this, "onClickButton", (event) => {
      if (event) {
        event.preventDefault();
      }
      this.setState(
        {
          showConfirm: true
        },
        () => {
          if (this.props.autoFocus && this.confirmButtonRef.current) {
            this.confirmButtonRef.current.focus();
          }
        }
      );
      if (this.props.onClick) {
        this.props.onClick();
      }
    });
    __publicField$r(this, "onClickCancel", (event) => {
      if (event) {
        event.preventDefault();
      }
      this.setState(
        {
          showConfirm: false
        },
        () => {
          var _a;
          (_a = this.mainButtonRef.current) == null ? void 0 : _a.focus();
        }
      );
      if (this.props.onCancel) {
        this.props.onCancel();
      }
    });
    __publicField$r(this, "onConfirm", (event) => {
      if (event) {
        event.preventDefault();
      }
      this.props.onConfirm();
      if (this.props.closeOnConfirm) {
        this.setState({
          showConfirm: false
        });
      }
    });
  }
  render() {
    const {
      theme,
      className,
      size,
      disabled,
      confirmText,
      confirmVariant: confirmButtonVariant,
      children
    } = this.props;
    const styles = getStyles$1S(theme);
    const buttonClass = css.cx(
      className,
      this.state.showConfirm ? styles.buttonHide : styles.buttonShow,
      disabled && styles.buttonDisabled
    );
    const confirmButtonClass = css.cx(
      styles.confirmButton,
      this.state.showConfirm ? styles.confirmButtonShow : styles.confirmButtonHide
    );
    const onClick = disabled ? () => {
    } : this.onClickButton;
    return /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.buttonContainer }, /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(disabled && styles.disabled) }, /* @__PURE__ */ React__default["default"].createElement("span", { className: buttonClass }, typeof children === "string" ? /* @__PURE__ */ React__default["default"].createElement(Button, { size, fill: "text", onClick, ref: this.mainButtonRef }, children) : React__default["default"].cloneElement(children, { onClick, ref: this.mainButtonRef }))), /* @__PURE__ */ React__default["default"].createElement("span", { className: confirmButtonClass }, /* @__PURE__ */ React__default["default"].createElement(Button, { size, variant: confirmButtonVariant, onClick: this.onConfirm, ref: this.confirmButtonRef }, confirmText), /* @__PURE__ */ React__default["default"].createElement(Button, { size, fill: "text", onClick: this.onClickCancel }, "Cancel")));
  }
}
const ConfirmButton = withTheme2(UnThemedConfirmButton);
const getStyles$1S = stylesFactory((theme) => {
  return {
    buttonContainer: css.css({
      display: "flex",
      alignItems: "center",
      justifyContent: "flex-end"
    }),
    buttonDisabled: css.css({
      textDecoration: "none",
      color: theme.colors.text.primary,
      opacity: 0.65,
      pointerEvents: "none"
    }),
    buttonShow: css.css({
      opacity: 1,
      transition: "opacity 0.1s ease",
      zIndex: 2
    }),
    buttonHide: css.css({
      opacity: 0,
      transition: "opacity 0.1s ease, visibility 0 0.1s",
      visibility: "hidden",
      zIndex: 0
    }),
    confirmButton: css.css({
      alignItems: "flex-start",
      background: theme.colors.background.primary,
      display: "flex",
      position: "absolute",
      pointerEvents: "none"
    }),
    confirmButtonShow: css.css({
      zIndex: 1,
      opacity: 1,
      transition: "opacity 0.08s ease-out, transform 0.1s ease-out",
      transform: "translateX(0)",
      pointerEvents: "all"
    }),
    confirmButtonHide: css.css({
      opacity: 0,
      visibility: "hidden",
      transition: "opacity 0.12s ease-in, transform 0.14s ease-in, visibility 0s 0.12s",
      transform: "translateX(100px)"
    }),
    disabled: css.css({
      cursor: "not-allowed"
    })
  };
});
ConfirmButton.defaultProps = {
  size: "md",
  confirmText: "Save",
  disabled: false,
  confirmVariant: "primary"
};
ConfirmButton.displayName = "ConfirmButton";

const DeleteButton = ({ size, disabled, onConfirm, "aria-label": ariaLabel, closeOnConfirm }) => {
  return /* @__PURE__ */ React__default["default"].createElement(
    ConfirmButton,
    {
      confirmText: "Delete",
      confirmVariant: "destructive",
      size: size || "md",
      disabled,
      onConfirm,
      closeOnConfirm
    },
    /* @__PURE__ */ React__default["default"].createElement(Button, { "aria-label": ariaLabel, variant: "destructive", icon: "times", size: size || "sm" })
  );
};

var __defProp$2I = Object.defineProperty;
var __getOwnPropSymbols$2u = Object.getOwnPropertySymbols;
var __hasOwnProp$2u = Object.prototype.hasOwnProperty;
var __propIsEnum$2u = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2I = (obj, key, value) => key in obj ? __defProp$2I(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2s = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2u.call(b, prop))
      __defNormalProp$2I(a, prop, b[prop]);
  if (__getOwnPropSymbols$2u)
    for (var prop of __getOwnPropSymbols$2u(b)) {
      if (__propIsEnum$2u.call(b, prop))
        __defNormalProp$2I(a, prop, b[prop]);
    }
  return a;
};
var __objRest$1c = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2u.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2u)
    for (var prop of __getOwnPropSymbols$2u(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2u.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const defaultTransitionStyles = {
  transitionProperty: "opacity",
  transitionDuration: "200ms",
  transitionTimingFunction: "linear",
  opacity: 0
};
const transitionStyles = {
  exited: { opacity: 0 },
  entering: { opacity: 0 },
  entered: { opacity: 1, transitionDelay: "0s" },
  exiting: { opacity: 0, transitionDelay: "500ms" }
};
class Popover extends React.PureComponent {
  render() {
    const _a = this.props, { content, show, placement, className, wrapperClassName, renderArrow, referenceElement } = _a, rest = __objRest$1c(_a, ["content", "show", "placement", "className", "wrapperClassName", "renderArrow", "referenceElement"]);
    return /* @__PURE__ */ React__default["default"].createElement(reactPopper.Manager, null, /* @__PURE__ */ React__default["default"].createElement(Transition__default["default"], { in: show, timeout: 100, mountOnEnter: true, unmountOnExit: true }, (transitionState) => {
      return /* @__PURE__ */ React__default["default"].createElement(Portal$1, null, /* @__PURE__ */ React__default["default"].createElement(
        reactPopper.Popper,
        {
          placement,
          referenceElement,
          modifiers: [
            { name: "preventOverflow", enabled: true, options: { rootBoundary: "viewport" } },
            {
              name: "eventListeners",
              options: { scroll: true, resize: true }
            }
          ]
        },
        ({ ref, style, placement: placement2, arrowProps, update }) => {
          return /* @__PURE__ */ React__default["default"].createElement(
            "div",
            __spreadValues$2s({
              ref,
              style: __spreadValues$2s(__spreadValues$2s(__spreadValues$2s({}, style), defaultTransitionStyles), transitionStyles[transitionState]),
              "data-placement": placement2,
              className: `${wrapperClassName}`
            }, rest),
            /* @__PURE__ */ React__default["default"].createElement("div", { className }, typeof content === "string" && content, React__default["default"].isValidElement(content) && React__default["default"].cloneElement(content), typeof content === "function" && content({
              updatePopperPosition: update
            }), renderArrow && renderArrow({
              arrowProps,
              placement: placement2
            }))
          );
        }
      ));
    }));
  }
}

var __defProp$2H = Object.defineProperty;
var __getOwnPropSymbols$2t = Object.getOwnPropertySymbols;
var __hasOwnProp$2t = Object.prototype.hasOwnProperty;
var __propIsEnum$2t = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2H = (obj, key, value) => key in obj ? __defProp$2H(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2r = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2t.call(b, prop))
      __defNormalProp$2H(a, prop, b[prop]);
  if (__getOwnPropSymbols$2t)
    for (var prop of __getOwnPropSymbols$2t(b)) {
      if (__propIsEnum$2t.call(b, prop))
        __defNormalProp$2H(a, prop, b[prop]);
    }
  return a;
};
const Toggletip = React__default["default"].memo(
  ({
    children,
    theme = "info",
    placement = "auto",
    content,
    title,
    closeButton = true,
    onClose,
    footer,
    fitContent = false,
    onOpen,
    show
  }) => {
    const arrowRef = React.useRef(null);
    const grafanaTheme = useTheme2();
    const styles = useStyles2(getStyles$1R);
    const style = styles[theme];
    const [controlledVisible, setControlledVisible] = React.useState(show);
    const isOpen = show != null ? show : controlledVisible;
    const middleware = [
      react$1.offset(8),
      react$1.flip({
        fallbackAxisSideDirection: "end",
        // see https://floating-ui.com/docs/flip#combining-with-shift
        crossAxis: false,
        boundary: document.body
      }),
      react$1.shift(),
      react$1.arrow({
        element: arrowRef
      })
    ];
    const { context, refs, floatingStyles } = react$1.useFloating({
      open: isOpen,
      placement: getPlacement(placement),
      onOpenChange: (open) => {
        if (show === void 0) {
          setControlledVisible(open);
        }
        if (!open) {
          onClose == null ? void 0 : onClose();
        } else {
          onOpen == null ? void 0 : onOpen();
        }
      },
      middleware,
      whileElementsMounted: react$1.autoUpdate,
      strategy: "fixed"
    });
    const click = react$1.useClick(context);
    const dismiss = react$1.useDismiss(context);
    const { getReferenceProps, getFloatingProps } = react$1.useInteractions([dismiss, click]);
    return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, React__default["default"].cloneElement(children, __spreadValues$2r({
      ref: refs.setReference,
      tabIndex: 0,
      "aria-expanded": isOpen
    }, getReferenceProps())), isOpen && /* @__PURE__ */ React__default["default"].createElement(react$1.FloatingFocusManager, { context, modal: false, closeOnFocusOut: false }, /* @__PURE__ */ React__default["default"].createElement(
      "div",
      __spreadValues$2r({
        "data-testid": "toggletip-content",
        className: css.cx(style.container, {
          [styles.fitContent]: fitContent
        }),
        ref: refs.setFloating,
        style: floatingStyles
      }, getFloatingProps()),
      /* @__PURE__ */ React__default["default"].createElement(
        react$1.FloatingArrow,
        {
          strokeWidth: 0.3,
          stroke: grafanaTheme.colors.border.weak,
          className: style.arrow,
          ref: arrowRef,
          context
        }
      ),
      Boolean(title) && /* @__PURE__ */ React__default["default"].createElement("div", { className: style.header }, title),
      closeButton && /* @__PURE__ */ React__default["default"].createElement("div", { className: style.headerClose }, /* @__PURE__ */ React__default["default"].createElement(
        IconButton,
        {
          "aria-label": "Close",
          name: "times",
          "data-testid": "toggletip-header-close",
          onClick: () => {
            setControlledVisible(false);
            onClose == null ? void 0 : onClose();
          }
        }
      )),
      /* @__PURE__ */ React__default["default"].createElement("div", { className: style.body }, (typeof content === "string" || React__default["default"].isValidElement(content)) && content, typeof content === "function" && content({})),
      Boolean(footer) && /* @__PURE__ */ React__default["default"].createElement("div", { className: style.footer }, footer)
    )));
  }
);
Toggletip.displayName = "Toggletip";
const getStyles$1R = (theme) => {
  const info = buildTooltipTheme(
    theme,
    theme.colors.background.primary,
    theme.colors.border.weak,
    theme.components.tooltip.text,
    { topBottom: 2, rightLeft: 2 }
  );
  const error = buildTooltipTheme(
    theme,
    theme.colors.error.main,
    theme.colors.error.main,
    theme.colors.error.contrastText,
    { topBottom: 2, rightLeft: 2 }
  );
  return {
    info,
    error,
    fitContent: css.css({
      maxWidth: "fit-content"
    })
  };
};

const Counter = ({ value }) => {
  const styles = useStyles2(getStyles$1Q);
  return /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.counter }, data.locale(value, 0).text);
};
const getStyles$1Q = (theme) => ({
  counter: css.css({
    label: "counter",
    marginLeft: theme.spacing(1),
    borderRadius: theme.spacing(3),
    backgroundColor: theme.colors.action.hover,
    padding: theme.spacing(0.25, 1),
    color: theme.colors.text.secondary,
    fontWeight: theme.typography.fontWeightMedium,
    fontSize: theme.typography.size.sm
  })
});

var __defProp$2G = Object.defineProperty;
var __defProps$1E = Object.defineProperties;
var __getOwnPropDescs$1E = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2s = Object.getOwnPropertySymbols;
var __hasOwnProp$2s = Object.prototype.hasOwnProperty;
var __propIsEnum$2s = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2G = (obj, key, value) => key in obj ? __defProp$2G(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2q = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2s.call(b, prop))
      __defNormalProp$2G(a, prop, b[prop]);
  if (__getOwnPropSymbols$2s)
    for (var prop of __getOwnPropSymbols$2s(b)) {
      if (__propIsEnum$2s.call(b, prop))
        __defNormalProp$2G(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1E = (a, b) => __defProps$1E(a, __getOwnPropDescs$1E(b));
var __objRest$1b = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2s.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2s)
    for (var prop of __getOwnPropSymbols$2s(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2s.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Tab = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, { label, active, icon, onChangeTab, counter, suffix: Suffix, className, href } = _b, otherProps = __objRest$1b(_b, ["label", "active", "icon", "onChangeTab", "counter", "suffix", "className", "href"]);
    const tabsStyles = useStyles2(getStyles$1P);
    const clearStyles = useStyles2(clearButtonStyles);
    const content = () => /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon }), label, typeof counter === "number" && /* @__PURE__ */ React__default["default"].createElement(Counter, { value: counter }), Suffix && /* @__PURE__ */ React__default["default"].createElement(Suffix, { className: tabsStyles.suffix }));
    const linkClass = css.cx(clearStyles, tabsStyles.link, active ? tabsStyles.activeStyle : tabsStyles.notActive);
    const commonProps = __spreadProps$1E(__spreadValues$2q({
      className: linkClass
    }, otherProps), {
      onClick: onChangeTab,
      "aria-label": otherProps["aria-label"] || e2eSelectors.selectors.components.Tab.title(label),
      role: "tab",
      "aria-selected": active
    });
    if (href) {
      return /* @__PURE__ */ React__default["default"].createElement("div", { className: tabsStyles.item }, /* @__PURE__ */ React__default["default"].createElement(
        "a",
        __spreadProps$1E(__spreadValues$2q({}, commonProps), {
          href,
          ref
        }),
        content()
      ));
    }
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: tabsStyles.item }, /* @__PURE__ */ React__default["default"].createElement(
      "button",
      __spreadProps$1E(__spreadValues$2q({}, commonProps), {
        type: "button",
        ref
      }),
      content()
    ));
  }
);
Tab.displayName = "Tab";
const getStyles$1P = (theme) => {
  return {
    item: css.css({
      listStyle: "none",
      position: "relative",
      display: "flex",
      whiteSpace: "nowrap",
      padding: theme.spacing(0.5)
    }),
    link: css.css({
      color: theme.colors.text.secondary,
      padding: theme.spacing(1, 1.5, 0.5),
      borderRadius: theme.shape.radius.default,
      display: "block",
      height: "100%",
      svg: {
        marginRight: theme.spacing(1)
      },
      "&:focus-visible": getFocusStyles(theme),
      "&::before": {
        display: "block",
        content: '" "',
        position: "absolute",
        left: 0,
        right: 0,
        height: "4px",
        borderRadius: theme.shape.radius.default,
        bottom: 0
      }
    }),
    notActive: css.css({
      "a:hover, &:hover, &:focus": {
        color: theme.colors.text.primary,
        "&::before": {
          backgroundColor: theme.colors.action.hover
        }
      }
    }),
    activeStyle: css.css({
      label: "activeTabStyle",
      color: theme.colors.text.primary,
      overflow: "hidden",
      "&::before": {
        backgroundImage: theme.colors.gradients.brandHorizontal
      }
    }),
    suffix: css.css({
      marginLeft: theme.spacing(1)
    })
  };
};

const TabsBar = React__default["default"].forwardRef(({ children, className, hideBorder = false }, ref) => {
  const styles = useStyles2(getStyles$1O);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.tabsWrapper, hideBorder && styles.noBorder, className), ref }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.tabs, role: "tablist" }, children));
});
const getStyles$1O = (theme) => ({
  tabsWrapper: css.css({
    borderBottom: `1px solid ${theme.colors.border.weak}`,
    overflowX: "auto"
  }),
  noBorder: css.css({
    borderBottom: 0
  }),
  tabs: css.css({
    position: "relative",
    display: "flex",
    height: `${theme.components.menuTabs.height}px`,
    alignItems: "center"
  })
});
TabsBar.displayName = "TabsBar";

var __defProp$2F = Object.defineProperty;
var __defProps$1D = Object.defineProperties;
var __getOwnPropDescs$1D = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2r = Object.getOwnPropertySymbols;
var __hasOwnProp$2r = Object.prototype.hasOwnProperty;
var __propIsEnum$2r = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2F = (obj, key, value) => key in obj ? __defProp$2F(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2p = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2r.call(b, prop))
      __defNormalProp$2F(a, prop, b[prop]);
  if (__getOwnPropSymbols$2r)
    for (var prop of __getOwnPropSymbols$2r(b)) {
      if (__propIsEnum$2r.call(b, prop))
        __defNormalProp$2F(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1D = (a, b) => __defProps$1D(a, __getOwnPropDescs$1D(b));
var __objRest$1a = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2r.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2r)
    for (var prop of __getOwnPropSymbols$2r(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2r.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const TabContent = (_a) => {
  var _b = _a, { children, className } = _b, restProps = __objRest$1a(_b, ["children", "className"]);
  const styles = useStyles2(getTabContentStyle);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1D(__spreadValues$2p({}, restProps), { className: css.cx(styles.tabContent, className) }), children);
};
const getTabContentStyle = (theme) => ({
  tabContent: css.css({
    background: theme.colors.background.primary
  })
});

function TabbedContainer({ tabs, defaultTab, closeIconTooltip, onClose }) {
  var _a;
  const [activeTab, setActiveTab] = React.useState(tabs.some((tab) => tab.value === defaultTab) ? defaultTab : tabs[0].value);
  const styles = useStyles2(getStyles$1N);
  const theme = useTheme2();
  const onSelectTab = (item) => {
    setActiveTab(item.value);
  };
  const autoHeight = `calc(100% - (${theme.components.menuTabs.height}px + ${theme.spacing(1)}))`;
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.container }, /* @__PURE__ */ React__default["default"].createElement(TabsBar, { className: styles.tabs }, tabs.map((t) => /* @__PURE__ */ React__default["default"].createElement(
    Tab,
    {
      key: t.value,
      label: t.label,
      active: t.value === activeTab,
      onChangeTab: () => onSelectTab(t),
      icon: t.icon
    }
  )), /* @__PURE__ */ React__default["default"].createElement(IconButton, { className: styles.close, onClick: onClose, name: "times", tooltip: closeIconTooltip != null ? closeIconTooltip : "Close" })), /* @__PURE__ */ React__default["default"].createElement(CustomScrollbar, { autoHeightMin: autoHeight, autoHeightMax: autoHeight }, /* @__PURE__ */ React__default["default"].createElement(TabContent, { className: styles.tabContent }, (_a = tabs.find((t) => t.value === activeTab)) == null ? void 0 : _a.content)));
}
const getStyles$1N = (theme) => ({
  container: css.css({
    height: "100%"
  }),
  tabContent: css.css({
    padding: theme.spacing(2),
    backgroundColor: theme.colors.background.primary,
    height: `100%`
  }),
  close: css.css({
    position: "absolute",
    right: "16px",
    top: "5px",
    cursor: "pointer",
    fontSize: theme.typography.size.lg
  }),
  tabs: css.css({
    paddingTop: theme.spacing(1),
    borderColor: theme.colors.border.weak,
    ul: {
      marginLeft: theme.spacing(2)
    }
  })
});

var __defProp$2E = Object.defineProperty;
var __getOwnPropSymbols$2q = Object.getOwnPropertySymbols;
var __hasOwnProp$2q = Object.prototype.hasOwnProperty;
var __propIsEnum$2q = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2E = (obj, key, value) => key in obj ? __defProp$2E(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2o = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2q.call(b, prop))
      __defNormalProp$2E(a, prop, b[prop]);
  if (__getOwnPropSymbols$2q)
    for (var prop of __getOwnPropSymbols$2q(b)) {
      if (__propIsEnum$2q.call(b, prop))
        __defNormalProp$2E(a, prop, b[prop]);
    }
  return a;
};
function initI18n() {
  if (typeof i18next__default["default"].options.resources !== "object") {
    i18next__default["default"].use(reactI18next.initReactI18next).init({
      resources: {},
      returnEmptyString: false,
      lng: "en-US"
      // this should be the locale of the phrases in our source JSX
    });
  }
}
const Trans = (props) => {
  initI18n();
  return /* @__PURE__ */ React__default["default"].createElement(reactI18next.Trans, __spreadValues$2o({}, props));
};
const tFunc = i18next__default["default"].t;
const t = (id, defaultMessage, values) => {
  initI18n();
  return tFunc(id, defaultMessage, values);
};

var __defProp$2D = Object.defineProperty;
var __defProps$1C = Object.defineProperties;
var __getOwnPropDescs$1C = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2p = Object.getOwnPropertySymbols;
var __hasOwnProp$2p = Object.prototype.hasOwnProperty;
var __propIsEnum$2p = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2D = (obj, key, value) => key in obj ? __defProp$2D(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2n = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2p.call(b, prop))
      __defNormalProp$2D(a, prop, b[prop]);
  if (__getOwnPropSymbols$2p)
    for (var prop of __getOwnPropSymbols$2p(b)) {
      if (__propIsEnum$2p.call(b, prop))
        __defNormalProp$2D(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1C = (a, b) => __defProps$1C(a, __getOwnPropDescs$1C(b));
function InlineToast({ referenceElement, children, suffixIcon, placement }) {
  const styles = useStyles2(getStyles$1M);
  const theme = useTheme2();
  const middleware = [
    react$1.offset(8),
    react$1.flip({
      fallbackAxisSideDirection: "end",
      // see https://floating-ui.com/docs/flip#combining-with-shift
      crossAxis: false,
      boundary: document.body
    }),
    react$1.shift()
  ];
  const { context, refs, floatingStyles } = react$1.useFloating({
    open: true,
    placement,
    middleware,
    whileElementsMounted: react$1.autoUpdate,
    strategy: "fixed"
  });
  React.useLayoutEffect(() => {
    refs.setReference(referenceElement);
  }, [referenceElement, refs]);
  const { styles: placementStyles } = react$1.useTransitionStyles(context, {
    initial: ({ side }) => {
      return {
        opacity: 0,
        transform: getInitialTransform(side, theme)
      };
    },
    duration: theme.transitions.duration.shortest
  });
  return /* @__PURE__ */ React__default["default"].createElement(Portal$1, null, /* @__PURE__ */ React__default["default"].createElement("div", { style: __spreadValues$2n({ display: "inline-block" }, floatingStyles), ref: refs.setFloating, "aria-live": "polite" }, /* @__PURE__ */ React__default["default"].createElement("span", { className: css.cx(styles.root), style: placementStyles }, children && /* @__PURE__ */ React__default["default"].createElement("span", null, children), suffixIcon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: suffixIcon }))));
}
const getStyles$1M = (theme) => {
  return {
    root: css.css(__spreadProps$1C(__spreadValues$2n({}, theme.typography.bodySmall), {
      willChange: "transform",
      background: theme.components.tooltip.background,
      color: theme.components.tooltip.text,
      padding: theme.spacing(0.5, 1.5),
      // get's an extra .5 of vertical padding to account for the rounded corners
      borderRadius: theme.shape.radius.pill,
      display: "inline-flex",
      gap: theme.spacing(0.5),
      alignItems: "center"
    }))
  };
};
const getInitialTransform = (placement, theme) => {
  const gap = 1;
  switch (placement) {
    case "top":
      return `translateY(${theme.spacing(gap)})`;
    case "bottom":
      return `translateY(-${theme.spacing(gap)})`;
    case "left":
      return `translateX(${theme.spacing(gap)})`;
    case "right":
      return `translateX(-${theme.spacing(gap)})`;
  }
};

var __defProp$2C = Object.defineProperty;
var __defProps$1B = Object.defineProperties;
var __getOwnPropDescs$1B = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2o = Object.getOwnPropertySymbols;
var __hasOwnProp$2o = Object.prototype.hasOwnProperty;
var __propIsEnum$2o = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2C = (obj, key, value) => key in obj ? __defProp$2C(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2m = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2o.call(b, prop))
      __defNormalProp$2C(a, prop, b[prop]);
  if (__getOwnPropSymbols$2o)
    for (var prop of __getOwnPropSymbols$2o(b)) {
      if (__propIsEnum$2o.call(b, prop))
        __defNormalProp$2C(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1B = (a, b) => __defProps$1B(a, __getOwnPropDescs$1B(b));
var __objRest$19 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2o.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2o)
    for (var prop of __getOwnPropSymbols$2o(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2o.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const SHOW_SUCCESS_DURATION$1 = 2 * 1e3;
function ClipboardButton(_a) {
  var _b = _a, {
    onClipboardCopy,
    onClipboardError,
    children,
    getText,
    icon,
    variant
  } = _b, buttonProps = __objRest$19(_b, [
    "onClipboardCopy",
    "onClipboardError",
    "children",
    "getText",
    "icon",
    "variant"
  ]);
  const styles = useStyles2(getStyles$1L);
  const [showCopySuccess, setShowCopySuccess] = React.useState(false);
  React.useEffect(() => {
    let timeoutId;
    if (showCopySuccess) {
      timeoutId = setTimeout(() => {
        setShowCopySuccess(false);
      }, SHOW_SUCCESS_DURATION$1);
    }
    return () => {
      window.clearTimeout(timeoutId);
    };
  }, [showCopySuccess]);
  const buttonRef = React.useRef(null);
  const copyTextCallback = React.useCallback(async () => {
    const textToCopy = getText();
    try {
      await copyText(textToCopy, buttonRef);
      setShowCopySuccess(true);
      onClipboardCopy == null ? void 0 : onClipboardCopy(textToCopy);
    } catch (e) {
      onClipboardError == null ? void 0 : onClipboardError(textToCopy, e);
    }
  }, [getText, onClipboardCopy, onClipboardError]);
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, showCopySuccess && /* @__PURE__ */ React__default["default"].createElement(InlineToast, { placement: "top", referenceElement: buttonRef.current }, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "clipboard-button.inline-toast.success" }, "Copied")), /* @__PURE__ */ React__default["default"].createElement(
    Button,
    __spreadProps$1B(__spreadValues$2m({
      onClick: copyTextCallback,
      icon,
      variant: showCopySuccess ? "success" : variant,
      "aria-label": showCopySuccess ? "Copied" : void 0
    }, buttonProps), {
      className: css.cx(styles.button, showCopySuccess && styles.successButton, buttonProps.className),
      ref: buttonRef
    }),
    children,
    showCopySuccess && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.successOverlay }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "check" }))
  ));
}
const copyText = async (text, buttonRef) => {
  var _a;
  if (navigator.clipboard && window.isSecureContext) {
    return navigator.clipboard.writeText(text);
  } else {
    const textarea = document.createElement("textarea");
    (_a = buttonRef.current) == null ? void 0 : _a.appendChild(textarea);
    textarea.value = text;
    textarea.focus();
    textarea.select();
    document.execCommand("copy");
    textarea.remove();
  }
};
const getStyles$1L = (theme) => {
  return {
    button: css.css({
      position: "relative"
    }),
    successButton: css.css({
      "> *": css.css({
        visibility: "hidden"
      })
    }),
    successOverlay: css.css({
      position: "absolute",
      top: 0,
      bottom: 0,
      right: 0,
      left: 0,
      visibility: "visible"
      // re-visible the overlay
    })
  };
};

var __defProp$2B = Object.defineProperty;
var __defProps$1A = Object.defineProperties;
var __getOwnPropDescs$1A = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2n = Object.getOwnPropertySymbols;
var __hasOwnProp$2n = Object.prototype.hasOwnProperty;
var __propIsEnum$2n = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2B = (obj, key, value) => key in obj ? __defProp$2B(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2l = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2n.call(b, prop))
      __defNormalProp$2B(a, prop, b[prop]);
  if (__getOwnPropSymbols$2n)
    for (var prop of __getOwnPropSymbols$2n(b)) {
      if (__propIsEnum$2n.call(b, prop))
        __defNormalProp$2B(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1A = (a, b) => __defProps$1A(a, __getOwnPropDescs$1A(b));
var __objRest$18 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2n.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2n)
    for (var prop of __getOwnPropSymbols$2n(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2n.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Input = React__default["default"].forwardRef((props, ref) => {
  const _a = props, { className, addonAfter, addonBefore, prefix, suffix, invalid, loading, width = 0 } = _a, restProps = __objRest$18(_a, ["className", "addonAfter", "addonBefore", "prefix", "suffix", "invalid", "loading", "width"]);
  const [prefixRef, prefixRect] = useMeasure__default["default"]();
  const [suffixRef, suffixRect] = useMeasure__default["default"]();
  const theme = useTheme2();
  const styles = getInputStyles({ theme, invalid: !!invalid, width });
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.wrapper, className), "data-testid": "input-wrapper" }, !!addonBefore && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.addon }, addonBefore), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.inputWrapper }, prefix && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.prefix, ref: prefixRef }, prefix), /* @__PURE__ */ React__default["default"].createElement(
    "input",
    __spreadProps$1A(__spreadValues$2l({
      ref,
      className: styles.input
    }, restProps), {
      style: {
        paddingLeft: prefix ? prefixRect.width + 12 : void 0,
        paddingRight: suffix || loading ? suffixRect.width + 12 : void 0
      }
    })
  ), (suffix || loading) && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.suffix, ref: suffixRef }, loading && /* @__PURE__ */ React__default["default"].createElement(Spinner, { className: styles.loadingIndicator, inline: true }), suffix)), !!addonAfter && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.addon }, addonAfter));
});
Input.displayName = "Input";
const getInputStyles = stylesFactory(({ theme, invalid = false, width }) => {
  const prefixSuffixStaticWidth = "28px";
  const prefixSuffix = css.css({
    position: "absolute",
    top: 0,
    zIndex: 1,
    display: "flex",
    alignItems: "center",
    justifyContent: "center",
    flexGrow: 0,
    flexShrink: 0,
    fontSize: theme.typography.size.md,
    height: "100%",
    /* Min width specified for prefix/suffix classes used outside React component*/
    minWidth: prefixSuffixStaticWidth,
    color: theme.colors.text.secondary
  });
  return {
    // Wraps inputWrapper and addons
    wrapper: css.cx(
      css.css({
        label: "input-wrapper",
        display: "flex",
        width: width ? theme.spacing(width) : "100%",
        height: theme.spacing(theme.components.height.md),
        borderRadius: theme.shape.radius.default,
        "&:hover": {
          "> .prefix, .suffix, .input": {
            borderColor: invalid ? theme.colors.error.border : theme.colors.primary.border
          },
          // only show number buttons on hover
          "input[type='number']": {
            appearance: "textfield"
          },
          "input[type='number']::-webkit-inner-spin-button, input[type='number']::-webkit-outer-spin-button": {
            // Need type assertion here due to the use of !important
            // see https://github.com/frenic/csstype/issues/114#issuecomment-697201978
            // eslint-disable-next-line @typescript-eslint/consistent-type-assertions
            WebkitAppearance: "inner-spin-button !important",
            opacity: 1
          }
        }
      })
    ),
    // Wraps input and prefix/suffix
    inputWrapper: css.css({
      label: "input-inputWrapper",
      position: "relative",
      flexGrow: 1,
      /* we want input to be above addons, especially for focused state */
      zIndex: 1,
      /* when input rendered with addon before only*/
      "&:not(:first-child):last-child": {
        "> input": {
          borderLeft: "none",
          borderTopLeftRadius: 0,
          borderBottomLeftRadius: 0
        }
      },
      /* when input rendered with addon after only*/
      "&:first-child:not(:last-child)": {
        "> input": {
          borderRight: "none",
          borderTopRightRadius: 0,
          borderBottomRightRadius: 0
        }
      },
      /* when rendered with addon before and after */
      "&:not(:first-child):not(:last-child)": {
        "> input": {
          borderRight: "none",
          borderTopRightRadius: 0,
          borderBottomRightRadius: 0,
          borderTopLeftRadius: 0,
          borderBottomLeftRadius: 0
        }
      },
      input: {
        /* paddings specified for classes used outside React component */
        "&:not(:first-child)": {
          paddingLeft: prefixSuffixStaticWidth
        },
        "&:not(:last-child)": {
          paddingRight: prefixSuffixStaticWidth
        },
        "&[readonly]": {
          cursor: "default"
        }
      }
    }),
    input: css.cx(
      getFocusStyle(theme),
      sharedInputStyle(theme, invalid),
      css.css({
        label: "input-input",
        position: "relative",
        zIndex: 0,
        flexGrow: 1,
        borderRadius: theme.shape.radius.default,
        height: "100%",
        width: "100%"
      })
    ),
    inputDisabled: css.css({
      backgroundColor: theme.colors.action.disabledBackground,
      color: theme.colors.action.disabledText,
      border: `1px solid ${theme.colors.action.disabledBackground}`,
      "&:focus": {
        boxShadow: "none"
      }
    }),
    addon: css.css({
      label: "input-addon",
      display: "flex",
      justifyContent: "center",
      alignItems: "center",
      flexGrow: 0,
      flexShrink: 0,
      position: "relative",
      "&:first-child": {
        borderTopRightRadius: 0,
        borderBottomRightRadius: 0,
        "> :last-child": {
          borderTopRightRadius: 0,
          borderBottomRightRadius: 0
        }
      },
      "&:last-child": {
        borderTopLeftRadius: 0,
        borderBottomLeftRadius: 0,
        "> :first-child": {
          borderTopLeftRadius: 0,
          borderBottomLeftRadius: 0
        }
      },
      "> *:focus": {
        /* we want anything that has focus and is an addon to be above input */
        zIndex: 2
      }
    }),
    prefix: css.cx(
      prefixSuffix,
      css.css({
        label: "input-prefix",
        paddingLeft: theme.spacing(1),
        paddingRight: theme.spacing(0.5),
        borderRight: "none",
        borderTopRightRadius: 0,
        borderBottomRightRadius: 0
      })
    ),
    suffix: css.cx(
      prefixSuffix,
      css.css({
        label: "input-suffix",
        paddingLeft: theme.spacing(1),
        paddingRight: theme.spacing(1),
        marginBottom: "-2px",
        borderLeft: "none",
        borderTopLeftRadius: 0,
        borderBottomLeftRadius: 0,
        right: 0
      })
    ),
    loadingIndicator: css.css({
      "& + *": {
        marginLeft: theme.spacing(0.5)
      }
    })
  };
});

function DropdownIndicator({ selectProps }) {
  const isOpen = selectProps.menuIsOpen;
  const icon = isOpen ? "search" : "angle-down";
  const size = isOpen ? "sm" : "md";
  return /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, size });
}

const IndicatorsContainer = React__default["default"].forwardRef((props, ref) => {
  const { children } = props;
  const theme = useTheme2();
  const styles = getInputStyles({ theme, invalid: false });
  return /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      className: css.cx(
        styles.suffix,
        css.css({
          position: "relative"
        })
      ),
      ref
    },
    children
  );
});
IndicatorsContainer.displayName = "IndicatorsContainer";

var __defProp$2A = Object.defineProperty;
var __defProps$1z = Object.defineProperties;
var __getOwnPropDescs$1z = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2m = Object.getOwnPropertySymbols;
var __hasOwnProp$2m = Object.prototype.hasOwnProperty;
var __propIsEnum$2m = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2A = (obj, key, value) => key in obj ? __defProp$2A(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2k = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2m.call(b, prop))
      __defNormalProp$2A(a, prop, b[prop]);
  if (__getOwnPropSymbols$2m)
    for (var prop of __getOwnPropSymbols$2m(b)) {
      if (__propIsEnum$2m.call(b, prop))
        __defNormalProp$2A(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1z = (a, b) => __defProps$1z(a, __getOwnPropDescs$1z(b));
var __objRest$17 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2m.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2m)
    for (var prop of __getOwnPropSymbols$2m(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2m.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const InputControl$1 = React__default["default"].forwardRef(
  function InputControl2(_a, ref) {
    var _b = _a, { focused, invalid, disabled, children, innerProps, prefix } = _b; __objRest$17(_b, ["focused", "invalid", "disabled", "children", "innerProps", "prefix"]);
    const styles = useStyles2(getInputControlStyles, invalid, !!prefix);
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1z(__spreadValues$2k({ className: styles.input }, innerProps), { ref }), prefix && /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.prefix) }, prefix), children);
  }
);
const getInputControlStyles = (theme, invalid, withPrefix) => {
  const styles = getInputStyles({ theme, invalid });
  return {
    input: css.cx(
      inputPadding(theme),
      css.css({
        width: "100%",
        maxWidth: "100%",
        display: "flex",
        flexDirection: "row",
        alignItems: "center",
        flexWrap: "wrap",
        justifyContent: "space-between",
        paddingRight: 0,
        position: "relative",
        boxSizing: "border-box"
      }),
      withPrefix && css.css({
        paddingLeft: 0
      })
    ),
    prefix: css.cx(
      styles.prefix,
      css.css({
        position: "relative"
      })
    )
  };
};

const getSelectStyles = stylesFactory((theme) => {
  return {
    menu: css.css({
      label: "grafana-select-menu",
      background: theme.components.dropdown.background,
      boxShadow: theme.shadows.z3,
      position: "relative",
      minWidth: "100%",
      zIndex: 1
    }),
    option: css.css({
      label: "grafana-select-option",
      padding: "8px",
      display: "flex",
      alignItems: "center",
      flexDirection: "row",
      flexShrink: 0,
      whiteSpace: "nowrap",
      cursor: "pointer",
      borderLeft: "2px solid transparent",
      "&:hover": {
        background: theme.colors.action.hover,
        "@media (forced-colors: active), (prefers-contrast: more)": {
          border: `1px solid ${theme.colors.primary.border}`
        }
      }
    }),
    optionIcon: css.css({
      marginRight: theme.spacing(1)
    }),
    optionImage: css.css({
      label: "grafana-select-option-image",
      width: "16px",
      marginRight: "10px"
    }),
    optionDescription: css.css({
      label: "grafana-select-option-description",
      fontWeight: "normal",
      fontSize: theme.typography.size.sm,
      color: theme.colors.text.secondary,
      whiteSpace: "normal",
      lineHeight: theme.typography.body.lineHeight
    }),
    optionBody: css.css({
      label: "grafana-select-option-body",
      display: "flex",
      fontWeight: theme.typography.fontWeightMedium,
      flexDirection: "column",
      flexGrow: 1
    }),
    optionFocused: css.css({
      label: "grafana-select-option-focused",
      background: theme.colors.action.focus,
      "@media (forced-colors: active), (prefers-contrast: more)": {
        border: `1px solid ${theme.colors.primary.border}`
      }
    }),
    optionSelected: css.css({
      background: theme.colors.action.selected
    }),
    optionDisabled: css.css({
      label: "grafana-select-option-disabled",
      backgroundColor: theme.colors.action.disabledBackground,
      color: theme.colors.action.disabledText,
      cursor: "not-allowed"
    }),
    singleValue: css.css({
      label: "grafana-select-single-value",
      color: theme.components.input.text,
      gridArea: "1 / 1 / 2 / 3",
      whiteSpace: "nowrap",
      overflow: "hidden",
      textOverflow: "ellipsis",
      boxSizing: "border-box",
      maxWidth: "100%"
    }),
    valueContainer: css.css({
      label: "grafana-select-value-container",
      alignItems: "center",
      display: "grid",
      position: "relative",
      boxSizing: "border-box",
      flex: "1 1 0%",
      outline: "none",
      overflow: "hidden"
    }),
    valueContainerMulti: css.css({
      label: "grafana-select-value-container-multi",
      flexWrap: "wrap",
      display: "flex"
    }),
    valueContainerMultiNoWrap: css.css({
      flexWrap: "nowrap"
    }),
    loadingMessage: css.css({
      label: "grafana-select-loading-message",
      padding: theme.spacing(1),
      textAlign: "center",
      width: "100%"
    }),
    multiValueContainer: css.css({
      label: "grafana-select-multi-value-container",
      display: "flex",
      alignItems: "center",
      lineHeight: 1,
      background: theme.colors.background.secondary,
      borderRadius: theme.shape.radius.default,
      margin: theme.spacing(0.25, 1, 0.25, 0),
      padding: theme.spacing(0.25, 0, 0.25, 1),
      color: theme.colors.text.primary,
      fontSize: theme.typography.size.sm,
      overflow: "hidden",
      whiteSpace: "nowrap",
      "&:hover": {
        background: theme.colors.emphasize(theme.colors.background.secondary)
      }
    }),
    multiValueRemove: css.css({
      label: "grafana-select-multi-value-remove",
      margin: theme.spacing(0, 0.5),
      cursor: "pointer",
      svg: {
        marginBottom: 0
      }
    }),
    singleValueRemove: css.css({
      cursor: "pointer",
      "&:hover": {
        color: theme.colors.text.primary
      }
    })
  };
});

var __defProp$2z = Object.defineProperty;
var __defProps$1y = Object.defineProperties;
var __getOwnPropDescs$1y = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2l = Object.getOwnPropertySymbols;
var __hasOwnProp$2l = Object.prototype.hasOwnProperty;
var __propIsEnum$2l = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2z = (obj, key, value) => key in obj ? __defProp$2z(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2j = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2l.call(b, prop))
      __defNormalProp$2z(a, prop, b[prop]);
  if (__getOwnPropSymbols$2l)
    for (var prop of __getOwnPropSymbols$2l(b)) {
      if (__propIsEnum$2l.call(b, prop))
        __defNormalProp$2z(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1y = (a, b) => __defProps$1y(a, __getOwnPropDescs$1y(b));
const MultiValueContainer = ({ innerProps, children }) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1y(__spreadValues$2j({}, innerProps), { className: styles.multiValueContainer }), children);
};
const MultiValueRemove = ({ children, innerProps }) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  return /* @__PURE__ */ React__default["default"].createElement(IconButton, __spreadProps$1y(__spreadValues$2j({}, innerProps), { name: "times", size: "sm", className: styles.multiValueRemove, tooltip: "Remove" }));
};

var __defProp$2y = Object.defineProperty;
var __defProps$1x = Object.defineProperties;
var __getOwnPropDescs$1x = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2k = Object.getOwnPropertySymbols;
var __hasOwnProp$2k = Object.prototype.hasOwnProperty;
var __propIsEnum$2k = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2y = (obj, key, value) => key in obj ? __defProp$2y(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2i = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2k.call(b, prop))
      __defNormalProp$2y(a, prop, b[prop]);
  if (__getOwnPropSymbols$2k)
    for (var prop of __getOwnPropSymbols$2k(b)) {
      if (__propIsEnum$2k.call(b, prop))
        __defNormalProp$2y(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1x = (a, b) => __defProps$1x(a, __getOwnPropDescs$1x(b));
const SelectContainer = (props) => {
  const {
    isDisabled,
    isFocused,
    children,
    selectProps: { invalid = false }
  } = props;
  const styles = useStyles2(getSelectContainerStyles, isFocused, isDisabled, invalid);
  return /* @__PURE__ */ React__default["default"].createElement(ReactSelect.components.SelectContainer, __spreadProps$1x(__spreadValues$2i({}, props), { className: css.cx(styles.wrapper, props.className) }), children);
};
const getSelectContainerStyles = (theme, focused, disabled, invalid) => {
  const styles = getInputStyles({ theme, invalid });
  return {
    wrapper: css.cx(
      styles.wrapper,
      sharedInputStyle(theme, invalid),
      focused && css.css(getFocusStyles(theme)),
      disabled && styles.inputDisabled,
      css.css({
        position: "relative",
        boxSizing: "border-box",
        /* The display property is set by the styles prop in SelectBase because it's dependant on the width prop  */
        flexDirection: "row",
        flexWrap: "wrap",
        alignItems: "stretch",
        justifyContent: "space-between",
        minHeight: "32px",
        height: "auto",
        maxWidth: "100%",
        /* Input padding is applied to the InputControl so the menu is aligned correctly */
        padding: 0,
        cursor: disabled ? "not-allowed" : "pointer"
      })
    )
  };
};

var __defProp$2x = Object.defineProperty;
var __defProps$1w = Object.defineProperties;
var __getOwnPropDescs$1w = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2j = Object.getOwnPropertySymbols;
var __hasOwnProp$2j = Object.prototype.hasOwnProperty;
var __propIsEnum$2j = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2x = (obj, key, value) => key in obj ? __defProp$2x(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2h = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2j.call(b, prop))
      __defNormalProp$2x(a, prop, b[prop]);
  if (__getOwnPropSymbols$2j)
    for (var prop of __getOwnPropSymbols$2j(b)) {
      if (__propIsEnum$2j.call(b, prop))
        __defNormalProp$2x(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1w = (a, b) => __defProps$1w(a, __getOwnPropDescs$1w(b));
var __objRest$16 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2j.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2j)
    for (var prop of __getOwnPropSymbols$2j(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2j.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const SelectMenu = ({ children, maxHeight, innerRef, innerProps }) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1w(__spreadValues$2h({}, innerProps), { className: styles.menu, style: { maxHeight }, "aria-label": "Select options menu" }), /* @__PURE__ */ React__default["default"].createElement(CustomScrollbar, { scrollRefCallback: innerRef, autoHide: false, autoHeightMax: "inherit", hideHorizontalTrack: true }, children));
};
SelectMenu.displayName = "SelectMenu";
const VIRTUAL_LIST_ITEM_HEIGHT = 37;
const VIRTUAL_LIST_WIDTH_ESTIMATE_MULTIPLIER = 7;
const VirtualizedSelectMenu = ({ children, maxHeight, options, getValue }) => {
  var _a;
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  const [value] = getValue();
  const valueIndex = value ? options.findIndex((option) => option.value === value.value) : 0;
  const initialOffset = valueIndex * VIRTUAL_LIST_ITEM_HEIGHT;
  if (!Array.isArray(children)) {
    return null;
  }
  const longestOption = (_a = lodash.max(options.map((option) => {
    var _a2;
    return (_a2 = option.label) == null ? void 0 : _a2.length;
  }))) != null ? _a : 0;
  const widthEstimate = longestOption * VIRTUAL_LIST_WIDTH_ESTIMATE_MULTIPLIER;
  const heightEstimate = Math.min(options.length * VIRTUAL_LIST_ITEM_HEIGHT, maxHeight);
  return /* @__PURE__ */ React__default["default"].createElement(
    reactWindow.FixedSizeList,
    {
      className: styles.menu,
      height: heightEstimate,
      width: widthEstimate,
      "aria-label": "Select options menu",
      itemCount: children.length,
      itemSize: VIRTUAL_LIST_ITEM_HEIGHT,
      initialScrollOffset: initialOffset
    },
    ({ index, style }) => /* @__PURE__ */ React__default["default"].createElement("div", { style: __spreadProps$1w(__spreadValues$2h({}, style), { overflow: "hidden" }) }, children[index])
  );
};
VirtualizedSelectMenu.displayName = "VirtualizedSelectMenu";
const SelectMenuOptions = ({
  children,
  data: data$1,
  innerProps,
  innerRef,
  isFocused,
  isSelected,
  renderOptionLabel
}) => {
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  const icon = data$1.icon ? data.toIconName(data$1.icon) : void 0;
  const _a = innerProps, rest = __objRest$16(_a, ["onMouseMove", "onMouseOver"]);
  return /* @__PURE__ */ React__default["default"].createElement(
    "div",
    __spreadProps$1w(__spreadValues$2h({
      ref: innerRef,
      className: css.cx(
        styles.option,
        isFocused && styles.optionFocused,
        isSelected && styles.optionSelected,
        data$1.isDisabled && styles.optionDisabled
      )
    }, rest), {
      "aria-label": "Select option",
      title: data$1.title
    }),
    icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, className: styles.optionIcon }),
    data$1.imgUrl && /* @__PURE__ */ React__default["default"].createElement("img", { className: styles.optionImage, src: data$1.imgUrl, alt: data$1.label || String(data$1.value) }),
    /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.optionBody }, /* @__PURE__ */ React__default["default"].createElement("span", null, renderOptionLabel ? renderOptionLabel(data$1) : children), data$1.description && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.optionDescription }, data$1.description), data$1.component && /* @__PURE__ */ React__default["default"].createElement(data$1.component, null))
  );
};
SelectMenuOptions.displayName = "SelectMenuOptions";

class UnthemedValueContainer extends React.Component {
  render() {
    const { children } = this.props;
    const { selectProps } = this.props;
    if (selectProps && Array.isArray(children) && Array.isArray(children[0]) && selectProps.maxVisibleValues !== void 0 && !(selectProps.showAllSelectedWhenOpen && selectProps.menuIsOpen)) {
      const [valueChildren, ...otherChildren] = children;
      const truncatedValues = valueChildren.slice(0, selectProps.maxVisibleValues);
      return this.renderContainer([truncatedValues, ...otherChildren]);
    }
    return this.renderContainer(children);
  }
  renderContainer(children) {
    var _a, _b;
    const { isMulti, theme, selectProps } = this.props;
    const noWrap = ((_a = this.props.selectProps) == null ? void 0 : _a.noMultiValueWrap) && !((_b = this.props.selectProps) == null ? void 0 : _b.menuIsOpen);
    const styles = getSelectStyles(theme);
    const dataTestid = selectProps["data-testid"];
    const className = css.cx(
      styles.valueContainer,
      isMulti && styles.valueContainerMulti,
      noWrap && styles.valueContainerMultiNoWrap
    );
    return /* @__PURE__ */ React__default["default"].createElement("div", { "data-testid": dataTestid, className }, children);
  }
}
const ValueContainer = withTheme2(UnthemedValueContainer);

var __getOwnPropSymbols$2i = Object.getOwnPropertySymbols;
var __hasOwnProp$2i = Object.prototype.hasOwnProperty;
var __propIsEnum$2i = Object.prototype.propertyIsEnumerable;
var __objRest$15 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2i.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2i)
    for (var prop of __getOwnPropSymbols$2i(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2i.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const cleanValue = (value, options) => {
  if (Array.isArray(value)) {
    const filtered = value.filter(Boolean);
    return (filtered == null ? void 0 : filtered.length) ? filtered : void 0;
  }
  if (typeof value === "object") {
    return [value];
  }
  if (typeof value === "string" || typeof value === "number") {
    const selectedValue = findSelectedValue(value, options);
    if (selectedValue) {
      return [selectedValue];
    }
  }
  return void 0;
};
const findSelectedValue = (value, options) => {
  for (const option of options) {
    if ("options" in option) {
      let found = findSelectedValue(value, option.options);
      if (found) {
        return found;
      }
    } else if ("value" in option && option.value === value) {
      return option;
    }
  }
  return null;
};
const omitDescriptions = (options) => {
  return options.map((_a) => {
    var _b = _a, rest = __objRest$15(_b, ["description"]);
    return rest;
  });
};

var __defProp$2w = Object.defineProperty;
var __defProps$1v = Object.defineProperties;
var __getOwnPropDescs$1v = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2h = Object.getOwnPropertySymbols;
var __hasOwnProp$2h = Object.prototype.hasOwnProperty;
var __propIsEnum$2h = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2w = (obj, key, value) => key in obj ? __defProp$2w(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2g = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2h.call(b, prop))
      __defNormalProp$2w(a, prop, b[prop]);
  if (__getOwnPropSymbols$2h)
    for (var prop of __getOwnPropSymbols$2h(b)) {
      if (__propIsEnum$2h.call(b, prop))
        __defNormalProp$2w(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1v = (a, b) => __defProps$1v(a, __getOwnPropDescs$1v(b));
var __objRest$14 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2h.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2h)
    for (var prop of __getOwnPropSymbols$2h(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2h.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const CustomControl = (props) => {
  const {
    children,
    innerProps,
    selectProps: { menuIsOpen, onMenuClose, onMenuOpen },
    isFocused,
    isMulti,
    getValue,
    innerRef
  } = props;
  const selectProps = props.selectProps;
  if (selectProps.renderControl) {
    return React__default["default"].createElement(selectProps.renderControl, {
      isOpen: menuIsOpen,
      value: isMulti ? getValue() : getValue()[0],
      ref: innerRef,
      onClick: menuIsOpen ? onMenuClose : onMenuOpen,
      onBlur: onMenuClose,
      disabled: !!selectProps.disabled,
      invalid: !!selectProps.invalid
    });
  }
  return /* @__PURE__ */ React__default["default"].createElement(
    InputControl$1,
    {
      ref: innerRef,
      innerProps,
      prefix: selectProps.prefix,
      focused: isFocused,
      invalid: !!selectProps.invalid,
      disabled: !!selectProps.disabled
    },
    children
  );
};
function SelectBase(_a) {
  var _b = _a, {
    allowCustomValue = false,
    allowCreateWhileLoading = false,
    "aria-label": ariaLabel,
    "data-testid": dataTestid,
    autoFocus = false,
    backspaceRemovesValue = true,
    blurInputOnSelect,
    cacheOptions,
    className,
    closeMenuOnSelect = true,
    components,
    createOptionPosition = "last",
    defaultOptions,
    defaultValue,
    disabled = false,
    filterOption,
    formatCreateLabel,
    getOptionLabel,
    getOptionValue,
    inputValue,
    invalid,
    isClearable = false,
    id,
    isLoading = false,
    isMulti = false,
    inputId,
    isOpen,
    isOptionDisabled,
    isSearchable = true,
    loadOptions,
    loadingMessage = "Loading options...",
    maxMenuHeight = 300,
    minMenuHeight,
    maxVisibleValues,
    menuPlacement = "auto",
    menuPosition,
    menuShouldPortal = true,
    noOptionsMessage = i18next.t("grafana-ui.select.no-options-label", "No options found"),
    onBlur,
    onChange,
    onCloseMenu,
    onCreateOption,
    onInputChange,
    onKeyDown,
    onMenuScrollToBottom,
    onMenuScrollToTop,
    onOpenMenu,
    onFocus,
    openMenuOnFocus = false,
    options = [],
    placeholder = i18next.t("grafana-ui.select.placeholder", "Choose"),
    prefix,
    renderControl,
    showAllSelectedWhenOpen = true,
    tabSelectsValue = true,
    value,
    virtualized = false,
    noMultiValueWrap,
    width,
    isValidNewOption,
    formatOptionLabel,
    hideSelectedOptions
  } = _b, rest = __objRest$14(_b, [
    "allowCustomValue",
    "allowCreateWhileLoading",
    "aria-label",
    "data-testid",
    "autoFocus",
    "backspaceRemovesValue",
    "blurInputOnSelect",
    "cacheOptions",
    "className",
    "closeMenuOnSelect",
    "components",
    "createOptionPosition",
    "defaultOptions",
    "defaultValue",
    "disabled",
    "filterOption",
    "formatCreateLabel",
    "getOptionLabel",
    "getOptionValue",
    "inputValue",
    "invalid",
    "isClearable",
    "id",
    "isLoading",
    "isMulti",
    "inputId",
    "isOpen",
    "isOptionDisabled",
    "isSearchable",
    "loadOptions",
    "loadingMessage",
    "maxMenuHeight",
    "minMenuHeight",
    "maxVisibleValues",
    "menuPlacement",
    "menuPosition",
    "menuShouldPortal",
    "noOptionsMessage",
    "onBlur",
    "onChange",
    "onCloseMenu",
    "onCreateOption",
    "onInputChange",
    "onKeyDown",
    "onMenuScrollToBottom",
    "onMenuScrollToTop",
    "onOpenMenu",
    "onFocus",
    "openMenuOnFocus",
    "options",
    "placeholder",
    "prefix",
    "renderControl",
    "showAllSelectedWhenOpen",
    "tabSelectsValue",
    "value",
    "virtualized",
    "noMultiValueWrap",
    "width",
    "isValidNewOption",
    "formatOptionLabel",
    "hideSelectedOptions"
  ]);
  const theme = useTheme2();
  const styles = getSelectStyles(theme);
  const reactSelectRef = React.useRef(null);
  const [closeToBottom, setCloseToBottom] = React.useState(false);
  const selectStyles = useCustomSelectStyles(theme, width);
  const [hasInputValue, setHasInputValue] = React.useState(!!inputValue);
  React.useEffect(() => {
    if (loadOptions && isOpen && reactSelectRef.current && reactSelectRef.current.controlRef && menuPlacement === "auto") {
      const distance = window.innerHeight - reactSelectRef.current.controlRef.getBoundingClientRect().bottom;
      setCloseToBottom(distance < maxMenuHeight);
    }
  }, [maxMenuHeight, menuPlacement, loadOptions, isOpen]);
  const onChangeWithEmpty = React.useCallback(
    (value2, action) => {
      if (isMulti && (value2 === void 0 || value2 === null)) {
        return onChange([], action);
      }
      onChange(value2, action);
    },
    [isMulti, onChange]
  );
  let ReactSelectComponent = ReactSelect__default["default"];
  const creatableProps = {};
  let asyncSelectProps = {};
  let selectedValue;
  if (isMulti && loadOptions) {
    selectedValue = value;
  } else {
    if (isMulti && value && Array.isArray(value) && !loadOptions) {
      selectedValue = value.map((v) => {
        var _a2;
        const selectableValue = findSelectedValue((_a2 = v.value) != null ? _a2 : v, options);
        if (!allowCustomValue || selectableValue) {
          return selectableValue;
        }
        return typeof v === "string" ? data.toOption(v) : v;
      });
    } else if (loadOptions) {
      const hasValue = defaultValue || value;
      selectedValue = hasValue ? [hasValue] : [];
    } else {
      selectedValue = cleanValue(value, options);
    }
  }
  const commonSelectProps = {
    "aria-label": ariaLabel,
    "data-testid": dataTestid,
    autoFocus,
    backspaceRemovesValue,
    blurInputOnSelect,
    captureMenuScroll: onMenuScrollToBottom || onMenuScrollToTop,
    closeMenuOnSelect,
    // We don't want to close if we're actually scrolling the menu
    // So only close if none of the parents are the select menu itself
    defaultValue,
    // Also passing disabled, as this is the new Select API, and I want to use this prop instead of react-select's one
    disabled,
    // react-select always tries to filter the options even at first menu open, which is a problem for performance
    // in large lists. So we set it to not try to filter the options if there is no input value.
    filterOption: hasInputValue ? filterOption : null,
    getOptionLabel,
    getOptionValue,
    hideSelectedOptions,
    inputValue,
    invalid,
    isClearable,
    id,
    // Passing isDisabled as react-select accepts this prop
    isDisabled: disabled,
    isLoading,
    isMulti,
    inputId,
    isOptionDisabled,
    isSearchable,
    maxMenuHeight,
    minMenuHeight,
    maxVisibleValues,
    menuIsOpen: isOpen,
    menuPlacement: menuPlacement === "auto" && closeToBottom ? "top" : menuPlacement,
    menuPosition,
    menuShouldBlockScroll: true,
    menuPortalTarget: menuShouldPortal && typeof document !== "undefined" ? document.body : void 0,
    menuShouldScrollIntoView: false,
    onBlur,
    onChange: onChangeWithEmpty,
    onInputChange: (val, actionMeta) => {
      setHasInputValue(!!val);
      onInputChange == null ? void 0 : onInputChange(val, actionMeta);
    },
    onKeyDown,
    onMenuClose: onCloseMenu,
    onMenuOpen: onOpenMenu,
    onMenuScrollToBottom,
    onMenuScrollToTop,
    onFocus,
    formatOptionLabel,
    openMenuOnFocus,
    options: virtualized ? omitDescriptions(options) : options,
    placeholder,
    prefix,
    renderControl,
    showAllSelectedWhenOpen,
    tabSelectsValue,
    value: isMulti ? selectedValue : selectedValue == null ? void 0 : selectedValue[0],
    noMultiValueWrap
  };
  if (allowCustomValue) {
    ReactSelectComponent = Creatable__default["default"];
    creatableProps.allowCreateWhileLoading = allowCreateWhileLoading;
    creatableProps.formatCreateLabel = formatCreateLabel != null ? formatCreateLabel : defaultFormatCreateLabel;
    creatableProps.onCreateOption = onCreateOption;
    creatableProps.createOptionPosition = createOptionPosition;
    creatableProps.isValidNewOption = isValidNewOption;
  }
  if (loadOptions) {
    ReactSelectComponent = allowCustomValue ? AsyncCreatable__default["default"] : ReactAsyncSelect__default["default"];
    asyncSelectProps = {
      loadOptions,
      cacheOptions,
      defaultOptions
    };
  }
  const SelectMenuComponent = virtualized ? VirtualizedSelectMenu : SelectMenu;
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(
    ReactSelectComponent,
    __spreadValues$2g(__spreadValues$2g(__spreadValues$2g(__spreadValues$2g({
      ref: reactSelectRef,
      components: __spreadValues$2g({
        MenuList: SelectMenuComponent,
        Group: SelectOptionGroup,
        ValueContainer,
        IndicatorsContainer: CustomIndicatorsContainer,
        IndicatorSeparator,
        Control: CustomControl,
        Option: SelectMenuOptions,
        ClearIndicator(props) {
          const { clearValue } = props;
          return /* @__PURE__ */ React__default["default"].createElement(
            Icon,
            {
              name: "times",
              role: "button",
              "aria-label": "select-clear-value",
              className: styles.singleValueRemove,
              onMouseDown: (e) => {
                e.preventDefault();
                e.stopPropagation();
                clearValue();
              }
            }
          );
        },
        LoadingIndicator() {
          return /* @__PURE__ */ React__default["default"].createElement(Spinner, { inline: true });
        },
        LoadingMessage() {
          return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.loadingMessage }, loadingMessage);
        },
        NoOptionsMessage() {
          return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.loadingMessage, "aria-label": "No options provided" }, noOptionsMessage);
        },
        DropdownIndicator,
        SingleValue(props) {
          return /* @__PURE__ */ React__default["default"].createElement(SingleValue, __spreadProps$1v(__spreadValues$2g({}, props), { isDisabled: disabled }));
        },
        SelectContainer,
        MultiValueContainer,
        MultiValueRemove: !disabled ? MultiValueRemove : () => null
      }, components),
      styles: selectStyles,
      className
    }, commonSelectProps), creatableProps), asyncSelectProps), rest)
  ));
}
function defaultFormatCreateLabel(input) {
  return /* @__PURE__ */ React__default["default"].createElement("div", { style: { display: "flex", gap: "8px", alignItems: "center" } }, /* @__PURE__ */ React__default["default"].createElement("div", null, input), /* @__PURE__ */ React__default["default"].createElement("div", { style: { flexGrow: 1 } }), /* @__PURE__ */ React__default["default"].createElement("div", { className: "muted small", style: { display: "flex", gap: "8px", alignItems: "center" } }, "Hit enter to add"));
}
function CustomIndicatorsContainer(props) {
  const { showAllSelectedWhenOpen, maxVisibleValues, menuIsOpen } = props.selectProps;
  const value = props.getValue();
  if (maxVisibleValues !== void 0 && Array.isArray(props.children)) {
    const selectedValuesCount = value.length;
    if (selectedValuesCount > maxVisibleValues && !(showAllSelectedWhenOpen && menuIsOpen)) {
      const indicatorChildren = [...props.children];
      indicatorChildren.splice(
        -1,
        0,
        /* @__PURE__ */ React__default["default"].createElement("span", { key: "excess-values", id: "excess-values" }, "(+", selectedValuesCount - maxVisibleValues, ")")
      );
      return /* @__PURE__ */ React__default["default"].createElement(IndicatorsContainer, __spreadValues$2g({}, props), indicatorChildren);
    }
  }
  return /* @__PURE__ */ React__default["default"].createElement(IndicatorsContainer, __spreadValues$2g({}, props));
}
function IndicatorSeparator() {
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null);
}

var __defProp$2v = Object.defineProperty;
var __defProps$1u = Object.defineProperties;
var __getOwnPropDescs$1u = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2g = Object.getOwnPropertySymbols;
var __hasOwnProp$2g = Object.prototype.hasOwnProperty;
var __propIsEnum$2g = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2v = (obj, key, value) => key in obj ? __defProp$2v(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2f = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2g.call(b, prop))
      __defNormalProp$2v(a, prop, b[prop]);
  if (__getOwnPropSymbols$2g)
    for (var prop of __getOwnPropSymbols$2g(b)) {
      if (__propIsEnum$2g.call(b, prop))
        __defNormalProp$2v(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1u = (a, b) => __defProps$1u(a, __getOwnPropDescs$1u(b));
function Select(props) {
  return /* @__PURE__ */ React__default["default"].createElement(SelectBase, __spreadValues$2f({}, props));
}
function MultiSelect(props) {
  return /* @__PURE__ */ React__default["default"].createElement(SelectBase, __spreadProps$1u(__spreadValues$2f({}, props), { isMulti: true }));
}
function AsyncSelect(props) {
  return /* @__PURE__ */ React__default["default"].createElement(SelectBase, __spreadValues$2f({}, props));
}
function VirtualizedSelect(props) {
  return /* @__PURE__ */ React__default["default"].createElement(SelectBase, __spreadValues$2f({ virtualized: true }, props));
}
function AsyncVirtualizedSelect(props) {
  return /* @__PURE__ */ React__default["default"].createElement(SelectBase, __spreadValues$2f({ virtualized: true }, props));
}
function AsyncMultiSelect(props) {
  return /* @__PURE__ */ React__default["default"].createElement(SelectBase, __spreadProps$1u(__spreadValues$2f({}, props), { isMulti: true }));
}

const onChangeCascader = (onChanged) => (values, options) => {
  if (onChanged) {
    onChanged(
      values.map((value) => String(value)),
      fromRCOptions(options)
    );
  }
};
const onLoadDataCascader = (onLoadData) => (options) => {
  if (onLoadData) {
    onLoadData(fromRCOptions(options));
  }
};
const fromRCOptions = (options) => {
  return options.map(fromRCOption);
};
const fromRCOption = (option) => {
  var _a;
  return {
    value: (_a = option.value) != null ? _a : "",
    label: option.label
  };
};

var __defProp$2u = Object.defineProperty;
var __defNormalProp$2u = (obj, key, value) => key in obj ? __defProp$2u(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$q = (obj, key, value) => {
  __defNormalProp$2u(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
const disableDivFocus = css.css({
  "&:focus": {
    outline: "none"
  }
});
const DEFAULT_SEPARATOR = " / ";
class Cascader extends React.PureComponent {
  constructor(props) {
    super(props);
    __publicField$q(this, "flattenOptions", (options, optionPath = []) => {
      let selectOptions = [];
      for (const option of options) {
        const cpy = [...optionPath];
        cpy.push(option);
        if (!option.items || option.items.length === 0) {
          selectOptions.push({
            singleLabel: cpy[cpy.length - 1].label,
            label: cpy.map((o) => o.label).join(this.props.separator || DEFAULT_SEPARATOR),
            value: cpy.map((o) => o.value)
          });
        } else {
          selectOptions = [...selectOptions, ...this.flattenOptions(option.items, cpy)];
        }
      }
      return selectOptions;
    });
    __publicField$q(this, "getSearchableOptions", memoize__default["default"]((options) => this.flattenOptions(options)));
    //For rc-cascader
    __publicField$q(this, "onChange", (value, selectedOptions) => {
      const activeLabel = this.props.hideActiveLevelLabel ? "" : this.props.displayAllSelectedLevels ? selectedOptions.map((option) => option.label).join(this.props.separator || DEFAULT_SEPARATOR) : selectedOptions[selectedOptions.length - 1].label;
      const state = {
        rcValue: { value, label: activeLabel },
        focusCascade: true,
        activeLabel,
        isSearching: false
      };
      this.setState(state);
      this.props.onSelect(selectedOptions[selectedOptions.length - 1].value);
    });
    //For select
    __publicField$q(this, "onSelect", (obj) => {
      const valueArray = obj.value || [];
      const activeLabel = this.props.displayAllSelectedLevels ? obj.label : obj.singleLabel || "";
      const state = {
        activeLabel,
        rcValue: { value: valueArray, label: activeLabel },
        isSearching: false,
        focusCascade: false
      };
      this.setState(state);
      this.props.onSelect(valueArray[valueArray.length - 1]);
    });
    __publicField$q(this, "onCreateOption", (value) => {
      this.setState({
        activeLabel: value,
        rcValue: [],
        isSearching: false
      });
      this.props.onSelect(value);
    });
    __publicField$q(this, "onBlur", () => {
      var _a, _b;
      this.setState({
        isSearching: false,
        focusCascade: false
      });
      if (this.state.activeLabel === "") {
        this.setState({
          rcValue: []
        });
      }
      (_b = (_a = this.props).onBlur) == null ? void 0 : _b.call(_a);
    });
    __publicField$q(this, "onBlurCascade", () => {
      var _a, _b;
      this.setState({
        focusCascade: false
      });
      (_b = (_a = this.props).onBlur) == null ? void 0 : _b.call(_a);
    });
    __publicField$q(this, "onInputKeyDown", (e) => {
      if (["ArrowDown", "ArrowUp", "Enter", "ArrowLeft", "ArrowRight", "Backspace"].includes(e.key)) {
        return;
      }
      this.setState({
        focusCascade: false,
        isSearching: true
      });
    });
    __publicField$q(this, "onSelectInputChange", (value) => {
      if (value === "") {
        this.setState({
          isSearching: false
        });
      }
    });
    const searchableOptions = this.getSearchableOptions(props.options);
    const { rcValue, activeLabel } = this.setInitialValue(searchableOptions, props.initialValue);
    this.state = {
      isSearching: false,
      focusCascade: false,
      rcValue,
      activeLabel
    };
  }
  setInitialValue(searchableOptions, initValue) {
    if (!initValue) {
      return { rcValue: [], activeLabel: "" };
    }
    for (const option of searchableOptions) {
      const optionPath = option.value || [];
      if (optionPath[optionPath.length - 1] === initValue) {
        return {
          rcValue: optionPath,
          activeLabel: this.props.displayAllSelectedLevels ? option.label : option.singleLabel || ""
        };
      }
    }
    if (this.props.allowCustomValue) {
      return { rcValue: [], activeLabel: initValue };
    }
    return { rcValue: [], activeLabel: "" };
  }
  render() {
    const { allowCustomValue, formatCreateLabel, placeholder, width, changeOnSelect, options, disabled } = this.props;
    const { focusCascade, isSearching, rcValue, activeLabel } = this.state;
    const searchableOptions = this.getSearchableOptions(options);
    return /* @__PURE__ */ React__default["default"].createElement("div", null, isSearching ? /* @__PURE__ */ React__default["default"].createElement(
      Select,
      {
        allowCustomValue,
        placeholder,
        autoFocus: !focusCascade,
        onChange: this.onSelect,
        onBlur: this.onBlur,
        options: searchableOptions,
        onCreateOption: this.onCreateOption,
        formatCreateLabel,
        width,
        onInputChange: this.onSelectInputChange,
        disabled
      }
    ) : /* @__PURE__ */ React__default["default"].createElement(
      RCCascader__default["default"],
      {
        onChange: onChangeCascader(this.onChange),
        options,
        changeOnSelect,
        value: rcValue.value,
        fieldNames: { label: "label", value: "value", children: "items" },
        expandIcon: null,
        open: this.props.alwaysOpen,
        disabled
      },
      /* @__PURE__ */ React__default["default"].createElement("div", { className: disableDivFocus }, /* @__PURE__ */ React__default["default"].createElement(
        Input,
        {
          autoFocus: this.props.autoFocus,
          width,
          placeholder,
          onBlur: this.onBlurCascade,
          value: activeLabel,
          onKeyDown: this.onInputKeyDown,
          onChange: () => {
          },
          suffix: focusCascade ? /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-up" }) : /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-down", style: { marginBottom: 0, marginLeft: "4px" } }),
          disabled
        }
      ))
    ));
  }
}
__publicField$q(Cascader, "defaultProps", { changeOnSelect: true });

var __defProp$2t = Object.defineProperty;
var __defProps$1t = Object.defineProperties;
var __getOwnPropDescs$1t = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2f = Object.getOwnPropertySymbols;
var __hasOwnProp$2f = Object.prototype.hasOwnProperty;
var __propIsEnum$2f = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2t = (obj, key, value) => key in obj ? __defProp$2t(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2e = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2f.call(b, prop))
      __defNormalProp$2t(a, prop, b[prop]);
  if (__getOwnPropSymbols$2f)
    for (var prop of __getOwnPropSymbols$2f(b)) {
      if (__propIsEnum$2f.call(b, prop))
        __defNormalProp$2t(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1t = (a, b) => __defProps$1t(a, __getOwnPropDescs$1t(b));
var __objRest$13 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2f.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2f)
    for (var prop of __getOwnPropSymbols$2f(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2f.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const ButtonCascader = (props) => {
  const _a = props, { onChange, className, loadData, icon, buttonProps, hideDownIcon, variant, disabled } = _a, rest = __objRest$13(_a, ["onChange", "className", "loadData", "icon", "buttonProps", "hideDownIcon", "variant", "disabled"]);
  const styles = useStyles2(getStyles$1K);
  let content = props.children;
  if (!hideDownIcon) {
    content = [props.children, /* @__PURE__ */ React__default["default"].createElement(Icon, { key: "down-icon", name: "angle-down", className: styles.icons.right })];
  }
  return /* @__PURE__ */ React__default["default"].createElement(
    RCCascader__default["default"],
    __spreadProps$1t(__spreadValues$2e({
      onChange: onChangeCascader(onChange),
      loadData: onLoadDataCascader(loadData),
      dropdownClassName: styles.popup
    }, rest), {
      expandIcon: null
    }),
    /* @__PURE__ */ React__default["default"].createElement(Button, __spreadValues$2e({ icon, disabled, variant }, buttonProps != null ? buttonProps : {}), content)
  );
};
ButtonCascader.displayName = "ButtonCascader";
const getStyles$1K = (theme) => {
  return {
    popup: css.css({
      label: "popup",
      zIndex: theme.zIndex.dropdown
    }),
    icons: {
      right: css.css({
        margin: "1px 0 0 4px"
      }),
      left: css.css({
        margin: "-1px 4px 0 0"
      })
    }
  };
};

var __defProp$2s = Object.defineProperty;
var __getOwnPropSymbols$2e = Object.getOwnPropertySymbols;
var __hasOwnProp$2e = Object.prototype.hasOwnProperty;
var __propIsEnum$2e = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2s = (obj, key, value) => key in obj ? __defProp$2s(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2d = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2e.call(b, prop))
      __defNormalProp$2s(a, prop, b[prop]);
  if (__getOwnPropSymbols$2e)
    for (var prop of __getOwnPropSymbols$2e(b)) {
      if (__propIsEnum$2e.call(b, prop))
        __defNormalProp$2s(a, prop, b[prop]);
    }
  return a;
};
var __objRest$12 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2e.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2e)
    for (var prop of __getOwnPropSymbols$2e(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2e.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const LoadingPlaceholder = (_a) => {
  var _b = _a, { text, className } = _b, rest = __objRest$12(_b, ["text", "className"]);
  const styles = useStyles2(getStyles$1J);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$2d({ className: css.cx(styles.container, className) }, rest), text, " ", /* @__PURE__ */ React__default["default"].createElement(Spinner, { inline: true }));
};
const getStyles$1J = (theme) => {
  return {
    container: css.css({
      marginBottom: theme.spacing(4)
    })
  };
};

const BAR_WIDTH = 28;
const MILLISECONDS_PER_PIXEL = 2.4;
const MIN_DURATION_MS = 500;
const MAX_DURATION_MS = 4e3;
const DEFAULT_ANIMATION_DELAY = 300;
const MAX_TRANSLATE_X = 100 / BAR_WIDTH * 100;
function LoadingBar({ width, delay = DEFAULT_ANIMATION_DELAY, ariaLabel = "Loading bar" }) {
  const durationMs = Math.min(Math.max(Math.round(width * MILLISECONDS_PER_PIXEL), MIN_DURATION_MS), MAX_DURATION_MS);
  const styles = useStyles2(getStyles$1I, delay, durationMs);
  const containerStyles = {
    overflow: "hidden"
  };
  return /* @__PURE__ */ React__default["default"].createElement("div", { style: containerStyles }, /* @__PURE__ */ React__default["default"].createElement("div", { "aria-label": ariaLabel, className: styles.bar }));
}
const getStyles$1I = (_theme, delay, duration) => {
  const animation = css.keyframes({
    "0%": {
      transform: "translateX(-100%)"
    },
    // this gives us a delay between iterations
    "85%, 100%": {
      transform: `translateX(${MAX_TRANSLATE_X}%)`
    }
  });
  return {
    bar: css.css({
      width: BAR_WIDTH + "%",
      height: 1,
      background: "linear-gradient(90deg, rgba(110, 159, 255, 0) 0%, #6E9FFF 80.75%, rgba(110, 159, 255, 0) 100%)",
      transform: "translateX(-100%)",
      animationName: animation,
      // an initial delay to prevent the loader from showing if the response is faster than the delay
      animationDelay: `${delay}ms`,
      animationDuration: `${duration}ms`,
      animationTimingFunction: "linear",
      animationIterationCount: "infinite",
      willChange: "transform"
    })
  };
};

const closePopover = (event, hidePopper) => {
  if (event.key === "Tab" || event.altKey || event.ctrlKey || event.metaKey) {
    return;
  }
  event.stopPropagation();
  if (event.key === "Escape") {
    hidePopper();
  }
  return;
};

var __defProp$2r = Object.defineProperty;
var __defProps$1s = Object.defineProperties;
var __getOwnPropDescs$1s = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2d = Object.getOwnPropertySymbols;
var __hasOwnProp$2d = Object.prototype.hasOwnProperty;
var __propIsEnum$2d = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2r = (obj, key, value) => key in obj ? __defProp$2r(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2c = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2d.call(b, prop))
      __defNormalProp$2r(a, prop, b[prop]);
  if (__getOwnPropSymbols$2d)
    for (var prop of __getOwnPropSymbols$2d(b)) {
      if (__propIsEnum$2d.call(b, prop))
        __defNormalProp$2r(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1s = (a, b) => __defProps$1s(a, __getOwnPropDescs$1s(b));
var __objRest$11 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2d.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2d)
    for (var prop of __getOwnPropSymbols$2d(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2d.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var ColorSwatchVariant = /* @__PURE__ */ ((ColorSwatchVariant2) => {
  ColorSwatchVariant2["Small"] = "small";
  ColorSwatchVariant2["Large"] = "large";
  return ColorSwatchVariant2;
})(ColorSwatchVariant || {});
const ColorSwatch = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, { color, label, variant = "small" /* Small */, isSelected, "aria-label": ariaLabel } = _b, otherProps = __objRest$11(_b, ["color", "label", "variant", "isSelected", "aria-label"]);
    const theme = useTheme2();
    const { isFocusVisible, focusProps } = focus.useFocusRing();
    const styles = getStyles$1H(theme, variant, color, isFocusVisible, isSelected);
    const hasLabel = !!label;
    const colorLabel = ariaLabel || label;
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$2c({ ref, className: styles.wrapper, "data-testid": e2eSelectors.selectors.components.ColorSwatch.name }, otherProps), hasLabel && /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.label }, label), /* @__PURE__ */ React__default["default"].createElement(
      "button",
      __spreadProps$1s(__spreadValues$2c({
        className: styles.swatch
      }, focusProps), {
        "aria-label": colorLabel ? `${colorLabel} color` : "Pick a color",
        type: "button"
      })
    ));
  }
);
const getStyles$1H = (theme, variant, color, isFocusVisible, isSelected) => {
  const tc = tinycolor__default["default"](color);
  const isSmall = variant === "small" /* Small */;
  const swatchSize = isSmall ? "16px" : "32px";
  let border = "none";
  if (tc.getAlpha() < 0.1) {
    border = `2px solid ${theme.colors.border.medium}`;
  }
  return {
    wrapper: css.css({
      display: "flex",
      alignItems: "center",
      cursor: "pointer"
    }),
    label: css.css({
      marginRight: theme.spacing(1)
    }),
    swatch: css.css({
      width: swatchSize,
      height: swatchSize,
      background: `${color}`,
      border,
      borderRadius: theme.shape.radius.circle,
      outlineOffset: "1px",
      outline: isFocusVisible ? `2px solid  ${theme.colors.primary.main}` : "none",
      boxShadow: isSelected ? `inset 0 0 0 2px ${color}, inset 0 0 0 4px ${theme.colors.getContrastText(color)}` : "none",
      transition: theme.transitions.create(["transform"], {
        duration: theme.transitions.duration.short
      }),
      "&:hover": {
        transform: "scale(1.1)"
      },
      "@media (forced-colors: active)": {
        forcedColorAdjust: "none"
      }
    })
  };
};
ColorSwatch.displayName = "ColorSwatch";

function reverseMap(arr, callbackfn) {
  const reversedAndMapped = new Array(arr.length);
  for (let i = 0; i < arr.length; i++) {
    const reverseIndex = arr.length - 1 - i;
    reversedAndMapped[i] = callbackfn(arr[reverseIndex], reverseIndex, arr);
  }
  return reversedAndMapped;
}

var __defProp$2q = Object.defineProperty;
var __defProps$1r = Object.defineProperties;
var __getOwnPropDescs$1r = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2c = Object.getOwnPropertySymbols;
var __hasOwnProp$2c = Object.prototype.hasOwnProperty;
var __propIsEnum$2c = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2q = (obj, key, value) => key in obj ? __defProp$2q(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2b = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2c.call(b, prop))
      __defNormalProp$2q(a, prop, b[prop]);
  if (__getOwnPropSymbols$2c)
    for (var prop of __getOwnPropSymbols$2c(b)) {
      if (__propIsEnum$2c.call(b, prop))
        __defNormalProp$2q(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1r = (a, b) => __defProps$1r(a, __getOwnPropDescs$1r(b));
var __objRest$10 = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2c.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2c)
    for (var prop of __getOwnPropSymbols$2c(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2c.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const NamedColorsGroup = (_a) => {
  var _b = _a, { hue, selectedColor, onColorSelect } = _b, otherProps = __objRest$10(_b, ["hue", "selectedColor", "onColorSelect"]);
  const label = lodash.upperFirst(hue.name);
  const styles = useStyles2(getStyles$1G);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.colorRow }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.colorLabel }, label), /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1r(__spreadValues$2b({}, otherProps), { className: styles.swatchRow }), reverseMap(hue.shades, (shade) => /* @__PURE__ */ React__default["default"].createElement(
    ColorSwatch,
    {
      key: shade.name,
      "aria-label": shade.name,
      variant: shade.primary ? ColorSwatchVariant.Large : ColorSwatchVariant.Small,
      isSelected: shade.name === selectedColor,
      color: shade.color,
      onClick: () => onColorSelect(shade.name)
    }
  ))));
};
const getStyles$1G = (theme) => {
  return {
    colorRow: css.css({
      display: "grid",
      gridTemplateColumns: "25% 1fr",
      gridColumnGap: theme.spacing(2),
      padding: theme.spacing(0.5, 0),
      "&:hover": {
        background: theme.colors.background.secondary
      }
    }),
    colorLabel: css.css({
      paddingLeft: theme.spacing(2),
      display: "flex",
      alignItems: "center"
    }),
    swatchRow: css.css({
      display: "flex",
      gap: theme.spacing(1),
      alignItems: "center",
      justifyContent: "space-around",
      flexDirection: "row"
    })
  };
};

const NamedColorsPalette = ({ color, onChange }) => {
  const theme = useTheme2();
  const styles = useStyles2(getStyles$1F);
  const swatches = [];
  for (const hue of theme.visualization.hues) {
    swatches.push(/* @__PURE__ */ React__default["default"].createElement(NamedColorsGroup, { key: hue.name, selectedColor: color, hue, onColorSelect: onChange }));
  }
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.swatches }, swatches), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.extraColors }, /* @__PURE__ */ React__default["default"].createElement(
    ColorSwatch,
    {
      isSelected: color === "transparent",
      color: "rgba(0,0,0,0)",
      label: "Transparent",
      onClick: () => onChange("transparent")
    }
  ), /* @__PURE__ */ React__default["default"].createElement(
    ColorSwatch,
    {
      isSelected: color === "text",
      color: theme.colors.text.primary,
      label: "Text color",
      onClick: () => onChange("text")
    }
  )));
};
const getStyles$1F = (theme) => {
  return {
    container: css.css({
      display: "flex",
      flexDirection: "column"
    }),
    extraColors: css.css({
      display: "flex",
      alignItems: "center",
      justifyContent: "space-around",
      gap: theme.spacing(1),
      padding: theme.spacing(1, 0)
    }),
    swatches: css.css({
      display: "grid",
      flexGrow: 1
    })
  };
};

var __defProp$2p = Object.defineProperty;
var __defProps$1q = Object.defineProperties;
var __getOwnPropDescs$1q = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2b = Object.getOwnPropertySymbols;
var __hasOwnProp$2b = Object.prototype.hasOwnProperty;
var __propIsEnum$2b = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2p = (obj, key, value) => key in obj ? __defProp$2p(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$2a = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2b.call(b, prop))
      __defNormalProp$2p(a, prop, b[prop]);
  if (__getOwnPropSymbols$2b)
    for (var prop of __getOwnPropSymbols$2b(b)) {
      if (__propIsEnum$2b.call(b, prop))
        __defNormalProp$2p(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1q = (a, b) => __defProps$1q(a, __getOwnPropDescs$1q(b));
var __objRest$$ = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2b.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2b)
    for (var prop of __getOwnPropSymbols$2b(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2b.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const ColorInput = React.forwardRef(
  (_a, ref) => {
    var _b = _a, { color, onChange, isClearable = false, onClick, onBlur, disabled, buttonAriaLabel } = _b, inputProps = __objRest$$(_b, ["color", "onChange", "isClearable", "onClick", "onBlur", "disabled", "buttonAriaLabel"]);
    const [value, setValue] = React.useState(color);
    const [previousColor, setPreviousColor] = React.useState(color);
    const updateColor = React.useMemo(() => lodash.debounce(onChange, 100), []);
    React.useEffect(() => {
      const newColor = tinycolor__default["default"](color);
      if (newColor.isValid() && color !== previousColor) {
        setValue(newColor.toString());
        setPreviousColor(color);
      }
    }, [color, previousColor]);
    const onChangeColor = (event) => {
      const { value: colorValue } = event.currentTarget;
      setValue(colorValue);
      if (colorValue === "" && isClearable) {
        updateColor(colorValue);
        return;
      }
      const newColor = tinycolor__default["default"](colorValue);
      if (newColor.isValid()) {
        updateColor(newColor.toString());
      }
    };
    const onBlurInput = (event) => {
      const newColor = tinycolor__default["default"](value);
      if (!newColor.isValid()) {
        setValue(color);
      }
      onBlur == null ? void 0 : onBlur(event);
    };
    return /* @__PURE__ */ React__default["default"].createElement(
      Input,
      __spreadProps$1q(__spreadValues$2a({}, inputProps), {
        value,
        onChange: onChangeColor,
        disabled,
        onClick,
        onBlur: onBlurInput,
        addonBefore: /* @__PURE__ */ React__default["default"].createElement(ColorPreview, { onClick, ariaLabel: buttonAriaLabel, disabled, color }),
        ref
      })
    );
  }
);
ColorInput.displayName = "ColorInput";
const ColorPreview = ({ color, onClick, disabled, ariaLabel }) => {
  const styles = useStyles2(getColorPreviewStyles);
  return /* @__PURE__ */ React__default["default"].createElement(
    "button",
    {
      type: "button",
      onClick,
      "aria-label": ariaLabel,
      disabled: disabled || !onClick,
      className: css.cx(
        styles,
        css.css({
          backgroundColor: color
        })
      )
    }
  );
};
const getColorPreviewStyles = (theme) => css.css({
  height: "100%",
  width: `${theme.spacing.gridSize * 4}px`,
  borderRadius: `${theme.shape.radius.default} 0 0 ${theme.shape.radius.default}`,
  border: `1px solid ${theme.colors.border.medium}`
});

const SpectrumPalette = ({ color, onChange }) => {
  const [currentColor, setColor] = React.useState(color);
  reactUse.useThrottleFn(
    (c) => {
      onChange(data.colorManipulator.asHexString(theme.visualization.getColorByName(c)));
    },
    500,
    [currentColor]
  );
  const theme = useTheme2();
  const styles = useStyles2(getStyles$1E);
  const rgbaString = React.useMemo(() => {
    return currentColor.startsWith("rgba") ? currentColor : tinycolor__default["default"](theme.visualization.getColorByName(color)).toRgbString();
  }, [currentColor, theme, color]);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.wrapper }, /* @__PURE__ */ React__default["default"].createElement(reactColorful.RgbaStringColorPicker, { className: styles.root, color: rgbaString, onChange: setColor }), /* @__PURE__ */ React__default["default"].createElement(ColorInput, { theme, color: rgbaString, onChange: setColor, className: styles.colorInput }));
};
const getStyles$1E = (theme) => ({
  wrapper: css.css({
    flexGrow: 1
  }),
  root: css.css({
    "&.react-colorful": {
      width: "auto"
    },
    ".react-colorful": {
      "&__saturation": {
        borderRadius: `${theme.shape.radius.default} ${theme.shape.radius.default} 0 0`
      },
      "&__alpha": {
        borderRadius: `0 0 ${theme.shape.radius.default} ${theme.shape.radius.default}`
      },
      "&__alpha, &__hue": {
        height: theme.spacing(2),
        position: "relative"
      },
      "&__pointer": {
        height: theme.spacing(2),
        width: theme.spacing(2)
      }
    }
  }),
  colorInput: css.css({
    marginTop: theme.spacing(2)
  })
});

var __defProp$2o = Object.defineProperty;
var __defNormalProp$2o = (obj, key, value) => key in obj ? __defProp$2o(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$p = (obj, key, value) => {
  __defNormalProp$2o(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
class UnThemedColorPickerPopover extends React.Component {
  constructor(props) {
    super(props);
    __publicField$p(this, "getTabClassName", (tabName) => {
      const { activePicker } = this.state;
      return `ColorPickerPopover__tab ${activePicker === tabName && "ColorPickerPopover__tab--active"}`;
    });
    __publicField$p(this, "handleChange", (color) => {
      const { onChange, enableNamedColors, theme } = this.props;
      if (enableNamedColors) {
        return onChange(color);
      }
      onChange(data.colorManipulator.asHexString(theme.visualization.getColorByName(color)));
    });
    __publicField$p(this, "onTabChange", (tab) => {
      return () => this.setState({ activePicker: tab });
    });
    __publicField$p(this, "renderPicker", () => {
      const { activePicker } = this.state;
      const { color } = this.props;
      switch (activePicker) {
        case "spectrum":
          return /* @__PURE__ */ React__default["default"].createElement(SpectrumPalette, { color, onChange: this.handleChange });
        case "palette":
          return /* @__PURE__ */ React__default["default"].createElement(NamedColorsPalette, { color, onChange: this.handleChange });
        default:
          return this.renderCustomPicker(activePicker);
      }
    });
    __publicField$p(this, "renderCustomPicker", (tabKey) => {
      const { customPickers, color, theme } = this.props;
      if (!customPickers) {
        return null;
      }
      return React__default["default"].createElement(customPickers[tabKey].tabComponent, {
        color,
        theme,
        onChange: this.handleChange
      });
    });
    __publicField$p(this, "renderCustomPickerTabs", () => {
      const { customPickers } = this.props;
      if (!customPickers) {
        return null;
      }
      return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, Object.keys(customPickers).map((key) => {
        return /* @__PURE__ */ React__default["default"].createElement("button", { className: this.getTabClassName(key), onClick: this.onTabChange(key), key, type: "button" }, customPickers[key].name);
      }));
    });
    this.state = {
      activePicker: "palette"
    };
  }
  render() {
    const { theme } = this.props;
    const styles = getStyles$1D(theme);
    return /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { contain: true, restoreFocus: true, autoFocus: true }, /* @__PURE__ */ React__default["default"].createElement("div", { tabIndex: -1, className: styles.colorPickerPopover }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.colorPickerPopoverTabs }, /* @__PURE__ */ React__default["default"].createElement("button", { className: this.getTabClassName("palette"), onClick: this.onTabChange("palette"), type: "button" }, "Colors"), /* @__PURE__ */ React__default["default"].createElement("button", { className: this.getTabClassName("spectrum"), onClick: this.onTabChange("spectrum"), type: "button" }, "Custom"), this.renderCustomPickerTabs()), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.colorPickerPopoverContent }, this.renderPicker())));
  }
}
const ColorPickerPopover = withTheme2(UnThemedColorPickerPopover);
ColorPickerPopover.displayName = "ColorPickerPopover";
const getStyles$1D = stylesFactory((theme) => {
  return {
    colorPickerPopover: css.css({
      borderRadius: theme.shape.radius.default,
      boxShadow: theme.shadows.z3,
      background: theme.colors.background.primary,
      border: `1px solid ${theme.colors.border.weak}`,
      ".ColorPickerPopover__tab": {
        width: "50%",
        textAlign: "center",
        padding: theme.spacing(1, 0),
        background: theme.colors.background.secondary,
        color: theme.colors.text.secondary,
        fontSize: theme.typography.bodySmall.fontSize,
        cursor: "pointer",
        border: "none",
        "&:focus:not(:focus-visible)": {
          outline: "none",
          boxShadow: "none"
        },
        ":focus-visible": {
          position: "relative"
        }
      },
      ".ColorPickerPopover__tab--active": {
        color: theme.colors.text.primary,
        fontWeight: theme.typography.fontWeightMedium,
        background: theme.colors.background.primary
      }
    }),
    colorPickerPopoverContent: css.css({
      width: "246px",
      fontSize: theme.typography.bodySmall.fontSize,
      minHeight: "184px",
      padding: theme.spacing(1),
      display: "flex",
      flexDirection: "column"
    }),
    colorPickerPopoverTabs: css.css({
      display: "flex",
      width: "100%",
      borderRadius: `${theme.shape.radius.default} ${theme.shape.radius.default} 0 0`
    })
  };
});

var __defProp$2n = Object.defineProperty;
var __defProps$1p = Object.defineProperties;
var __getOwnPropDescs$1p = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$2a = Object.getOwnPropertySymbols;
var __hasOwnProp$2a = Object.prototype.hasOwnProperty;
var __propIsEnum$2a = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2n = (obj, key, value) => key in obj ? __defProp$2n(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$29 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$2a.call(b, prop))
      __defNormalProp$2n(a, prop, b[prop]);
  if (__getOwnPropSymbols$2a)
    for (var prop of __getOwnPropSymbols$2a(b)) {
      if (__propIsEnum$2a.call(b, prop))
        __defNormalProp$2n(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1p = (a, b) => __defProps$1p(a, __getOwnPropDescs$1p(b));
var __objRest$_ = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$2a.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$2a)
    for (var prop of __getOwnPropSymbols$2a(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$2a.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const SeriesColorPickerPopover = (props) => {
  const styles = useStyles2(getStyles$1C);
  const _a = props, { yaxis, onToggleAxis, color } = _a, colorPickerProps = __objRest$_(_a, ["yaxis", "onToggleAxis", "color"]);
  const customPickers = onToggleAxis ? {
    yaxis: {
      name: "Y-Axis",
      tabComponent() {
        return /* @__PURE__ */ React__default["default"].createElement(
          Switch$1,
          {
            key: "yaxisSwitch",
            label: "Use right y-axis",
            className: styles.colorPickerAxisSwitch,
            labelClass: styles.colorPickerAxisSwitchLabel,
            checked: yaxis === 2,
            onChange: () => {
              if (onToggleAxis) {
                onToggleAxis();
              }
            }
          }
        );
      }
    }
  } : void 0;
  return /* @__PURE__ */ React__default["default"].createElement(ColorPickerPopover, __spreadProps$1p(__spreadValues$29({}, colorPickerProps), { color: color || "#000000", customPickers }));
};
const SeriesColorPickerPopoverWithTheme = withTheme2(SeriesColorPickerPopover);
const getStyles$1C = () => {
  return {
    colorPickerAxisSwitch: css.css({
      width: "100%"
    }),
    colorPickerAxisSwitchLabel: css.css({
      display: "flex",
      flexGrow: 1
    })
  };
};

var __defProp$2m = Object.defineProperty;
var __defProps$1o = Object.defineProperties;
var __getOwnPropDescs$1o = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$29 = Object.getOwnPropertySymbols;
var __hasOwnProp$29 = Object.prototype.hasOwnProperty;
var __propIsEnum$29 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2m = (obj, key, value) => key in obj ? __defProp$2m(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$28 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$29.call(b, prop))
      __defNormalProp$2m(a, prop, b[prop]);
  if (__getOwnPropSymbols$29)
    for (var prop of __getOwnPropSymbols$29(b)) {
      if (__propIsEnum$29.call(b, prop))
        __defNormalProp$2m(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1o = (a, b) => __defProps$1o(a, __getOwnPropDescs$1o(b));
var __publicField$o = (obj, key, value) => {
  __defNormalProp$2m(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
const colorPickerFactory = (popover, displayName = "ColorPicker") => {
  var _a;
  return _a = class extends React.Component {
    constructor() {
      super(...arguments);
      __publicField$o(this, "pickerTriggerRef", React.createRef());
    }
    render() {
      const { theme, children, onChange, color } = this.props;
      const styles = getStyles$1B(theme);
      const popoverElement = React__default["default"].createElement(popover, __spreadProps$1o(__spreadValues$28({}, __spreadProps$1o(__spreadValues$28({}, this.props), { children: null })), {
        onChange
      }));
      return /* @__PURE__ */ React__default["default"].createElement(PopoverController, { content: popoverElement, hideAfter: 300 }, (showPopper, hidePopper, popperProps) => {
        return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, this.pickerTriggerRef.current && /* @__PURE__ */ React__default["default"].createElement(
          Popover,
          __spreadProps$1o(__spreadValues$28({}, popperProps), {
            referenceElement: this.pickerTriggerRef.current,
            wrapperClassName: styles.colorPicker,
            onMouseLeave: hidePopper,
            onMouseEnter: showPopper,
            onKeyDown: (event) => closePopover(event, hidePopper)
          })
        ), children ? children({
          ref: this.pickerTriggerRef,
          showColorPicker: showPopper,
          hideColorPicker: hidePopper
        }) : /* @__PURE__ */ React__default["default"].createElement(
          ColorSwatch,
          {
            ref: this.pickerTriggerRef,
            onClick: showPopper,
            onMouseLeave: hidePopper,
            color: theme.visualization.getColorByName(color || "#000000"),
            "aria-label": color
          }
        ));
      });
    }
  }, __publicField$o(_a, "displayName", displayName), _a;
};
const ColorPicker = withTheme2(colorPickerFactory(ColorPickerPopover, "ColorPicker"));
const SeriesColorPicker = withTheme2(colorPickerFactory(SeriesColorPickerPopover, "SeriesColorPicker"));
const getStyles$1B = stylesFactory((theme) => {
  return {
    colorPicker: css.css({
      position: "absolute",
      zIndex: theme.zIndex.tooltip,
      color: theme.colors.text.primary,
      maxWidth: "400px",
      fontSize: theme.typography.size.sm,
      // !important because these styles are also provided to popper via .popper classes from Tooltip component
      // hope to get rid of those soon
      padding: "15px !important",
      '& [data-placement^="top"]': {
        paddingLeft: "0 !important",
        paddingRight: "0 !important"
      },
      '& [data-placement^="bottom"]': {
        paddingLeft: "0 !important",
        paddingRight: "0 !important"
      },
      '& [data-placement^="left"]': {
        paddingTop: "0 !important"
      },
      '& [data-placement^="right"]': {
        paddingTop: "0 !important"
      }
    })
  };
});

var __defProp$2l = Object.defineProperty;
var __defNormalProp$2l = (obj, key, value) => key in obj ? __defProp$2l(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$n = (obj, key, value) => {
  __defNormalProp$2l(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
class ClickOutsideWrapper extends React.PureComponent {
  constructor() {
    super(...arguments);
    __publicField$n(this, "myRef", React.createRef());
    __publicField$n(this, "state", {
      hasEventListener: false
    });
    __publicField$n(this, "onOutsideClick", (event) => {
      const domNode = this.myRef.current;
      if (!domNode || event.target instanceof Node && !domNode.contains(event.target)) {
        this.props.onClick();
      }
    });
  }
  componentDidMount() {
    this.props.parent.addEventListener("click", this.onOutsideClick, this.props.useCapture);
    if (this.props.includeButtonPress) {
      this.props.parent.addEventListener("keyup", this.onOutsideClick, this.props.useCapture);
    }
  }
  componentWillUnmount() {
    this.props.parent.removeEventListener("click", this.onOutsideClick, this.props.useCapture);
    if (this.props.includeButtonPress) {
      this.props.parent.removeEventListener("keyup", this.onOutsideClick, this.props.useCapture);
    }
  }
  render() {
    return /* @__PURE__ */ React__default["default"].createElement("div", { ref: this.myRef }, this.props.children);
  }
}
__publicField$n(ClickOutsideWrapper, "defaultProps", {
  includeButtonPress: true,
  parent: typeof window !== "undefined" ? window : void 0,
  useCapture: false
});

var __defProp$2k = Object.defineProperty;
var __defProps$1n = Object.defineProperties;
var __getOwnPropDescs$1n = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$28 = Object.getOwnPropertySymbols;
var __hasOwnProp$28 = Object.prototype.hasOwnProperty;
var __propIsEnum$28 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2k = (obj, key, value) => key in obj ? __defProp$2k(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$27 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$28.call(b, prop))
      __defNormalProp$2k(a, prop, b[prop]);
  if (__getOwnPropSymbols$28)
    for (var prop of __getOwnPropSymbols$28(b)) {
      if (__propIsEnum$28.call(b, prop))
        __defNormalProp$2k(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1n = (a, b) => __defProps$1n(a, __getOwnPropDescs$1n(b));
var __objRest$Z = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$28.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$28)
    for (var prop of __getOwnPropSymbols$28(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$28.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const ColorPickerInput = React.forwardRef(
  (_a, ref) => {
    var _b = _a, { value = "", onChange, returnColorAs = "rgb" } = _b, inputProps = __objRest$Z(_b, ["value", "onChange", "returnColorAs"]);
    const [currentColor, setColor] = React.useState(value);
    const [isOpen, setIsOpen] = React.useState(false);
    const theme = useTheme2();
    const styles = useStyles2(getStyles$1A);
    const paletteStyles = useStyles2(getStyles$1E);
    reactUse.useThrottleFn(
      (c) => {
        if (c === value) {
          return;
        }
        if (!c) {
          onChange("");
          return;
        }
        const color = theme.visualization.getColorByName(c);
        if (returnColorAs === "rgb") {
          onChange(data.colorManipulator.asRgbString(color));
        } else {
          onChange(data.colorManipulator.asHexString(color));
        }
      },
      500,
      [currentColor]
    );
    return /* @__PURE__ */ React__default["default"].createElement(ClickOutsideWrapper, { onClick: () => setIsOpen(false) }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.wrapper }, isOpen && !inputProps.disabled && /* @__PURE__ */ React__default["default"].createElement(
      reactColorful.RgbaStringColorPicker,
      {
        "data-testid": "color-popover",
        color: currentColor,
        onChange: setColor,
        className: css.cx(paletteStyles.root, styles.picker)
      }
    ), /* @__PURE__ */ React__default["default"].createElement(
      ColorInput,
      __spreadProps$1n(__spreadValues$27({}, inputProps), {
        theme,
        color: currentColor,
        onChange: setColor,
        buttonAriaLabel: "Open color picker",
        onClick: () => setIsOpen(true),
        onBlur: () => setIsOpen(false),
        ref,
        isClearable: true
      })
    )));
  }
);
ColorPickerInput.displayName = "ColorPickerInput";
const getStyles$1A = (theme) => {
  return {
    wrapper: css.css({
      position: "relative"
    }),
    picker: css.css({
      "&.react-colorful": {
        position: "absolute",
        width: "100%",
        zIndex: 11,
        bottom: "36px"
      }
    }),
    inner: css.css({
      position: "absolute"
    })
  };
};

const EmptySearchResult = ({ children }) => {
  const styles = useStyles2(getStyles$1z);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.container }, children);
};
const getStyles$1z = (theme) => {
  return {
    container: css.css({
      borderLeft: `3px solid ${theme.colors.info.main}`,
      backgroundColor: `${theme.colors.background.secondary}`,
      padding: theme.spacing(2),
      minWidth: "350px",
      borderRadius: theme.shape.radius.default,
      marginBottom: theme.spacing(4)
    })
  };
};

var __defProp$2j = Object.defineProperty;
var __defNormalProp$2j = (obj, key, value) => key in obj ? __defProp$2j(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$m = (obj, key, value) => {
  __defNormalProp$2j(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
function formatCreateLabel(input) {
  return `Custom unit: ${input}`;
}
class UnitPicker extends React.PureComponent {
  constructor() {
    super(...arguments);
    __publicField$m(this, "onChange", (value) => {
      this.props.onChange(value.value);
    });
  }
  render() {
    const { value, width } = this.props;
    let current = void 0;
    const unitGroups = data.getValueFormats();
    const groupOptions = unitGroups.map((group) => {
      const options = group.submenu.map((unit) => {
        const sel = {
          label: unit.text,
          value: unit.value
        };
        if (unit.value === value) {
          current = sel;
        }
        return sel;
      });
      return {
        label: group.text,
        value: group.text,
        items: options
      };
    });
    if (value && !current) {
      current = { value, label: value };
    }
    return /* @__PURE__ */ React__default["default"].createElement(
      Cascader,
      {
        width,
        initialValue: current && current.label,
        allowCustomValue: true,
        changeOnSelect: false,
        formatCreateLabel,
        options: groupOptions,
        placeholder: "Choose",
        onSelect: this.props.onChange
      }
    );
  }
}

var __defProp$2i = Object.defineProperty;
var __defNormalProp$2i = (obj, key, value) => key in obj ? __defProp$2i(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$l = (obj, key, value) => {
  __defNormalProp$2i(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
class StatsPicker extends React.PureComponent {
  constructor() {
    super(...arguments);
    __publicField$l(this, "checkInput", () => {
      const { stats, allowMultiple, defaultStat, onChange } = this.props;
      const current = data.fieldReducers.list(stats);
      if (current.length !== stats.length) {
        const found = current.map((v) => v.id);
        const notFound = lodash.difference(stats, found);
        console.warn("Unknown stats", notFound, stats);
        onChange(current.map((stat) => stat.id));
      }
      if (!allowMultiple && stats.length > 1) {
        console.warn("Removing extra stat", stats);
        onChange([stats[0]]);
      }
      if (defaultStat && stats.length < 1) {
        onChange([defaultStat]);
      }
    });
    __publicField$l(this, "onSelectionChange", (item) => {
      const { onChange } = this.props;
      if (Array.isArray(item)) {
        onChange(item.map((v) => v.value));
      } else {
        onChange(item && item.value ? [item.value] : []);
      }
    });
  }
  componentDidMount() {
    this.checkInput();
  }
  componentDidUpdate(prevProps) {
    this.checkInput();
  }
  render() {
    const { stats, allowMultiple, defaultStat, placeholder, className, menuPlacement, width, inputId, filterOptions } = this.props;
    const select = data.fieldReducers.selectOptions(stats, filterOptions);
    return /* @__PURE__ */ React__default["default"].createElement(
      Select,
      {
        value: select.current,
        className,
        isClearable: !defaultStat,
        isMulti: allowMultiple,
        width,
        isSearchable: true,
        options: select.options,
        placeholder,
        onChange: this.onSelectionChange,
        menuPlacement,
        inputId
      }
    );
  }
}
__publicField$l(StatsPicker, "defaultProps", {
  allowMultiple: false
});

function MenuDivider() {
  const styles = useStyles2(getStyles$1y);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.divider });
}
const getStyles$1y = (theme) => {
  return {
    divider: css.css({
      height: 1,
      backgroundColor: theme.colors.border.weak,
      margin: theme.spacing(0.5, 0)
    })
  };
};

const MenuGroup = ({ label, ariaLabel, children }) => {
  const styles = useStyles2(getStyles$1x);
  const labelID = `group-label-${lodash.uniqueId()}`;
  return /* @__PURE__ */ React__default["default"].createElement("div", { role: "group", "aria-labelledby": !ariaLabel && label ? labelID : void 0, "aria-label": ariaLabel }, label && /* @__PURE__ */ React__default["default"].createElement("label", { id: labelID, className: styles.groupLabel, "aria-hidden": true }, label), children);
};
MenuGroup.displayName = "MenuGroup";
const getStyles$1x = (theme) => {
  return {
    groupLabel: css.css({
      color: theme.colors.text.secondary,
      fontSize: theme.typography.size.sm,
      padding: theme.spacing(0.5, 1)
    })
  };
};

function breakpointCSS(theme, prop, getCSS, key) {
  const value = prop[key];
  if (value !== void 0 && value !== null) {
    return {
      [theme.breakpoints.up(key)]: getCSS(value)
    };
  }
  return;
}
function getResponsiveStyle(theme, prop, getCSS) {
  if (prop === void 0 || prop === null) {
    return null;
  }
  if (typeof prop !== "object" || !("xs" in prop)) {
    return getCSS(prop);
  }
  return [
    breakpointCSS(theme, prop, getCSS, "xs"),
    breakpointCSS(theme, prop, getCSS, "sm"),
    breakpointCSS(theme, prop, getCSS, "md"),
    breakpointCSS(theme, prop, getCSS, "lg"),
    breakpointCSS(theme, prop, getCSS, "xl"),
    breakpointCSS(theme, prop, getCSS, "xxl")
  ];
}

var __defProp$2h = Object.defineProperty;
var __getOwnPropSymbols$27 = Object.getOwnPropertySymbols;
var __hasOwnProp$27 = Object.prototype.hasOwnProperty;
var __propIsEnum$27 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2h = (obj, key, value) => key in obj ? __defProp$2h(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$26 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$27.call(b, prop))
      __defNormalProp$2h(a, prop, b[prop]);
  if (__getOwnPropSymbols$27)
    for (var prop of __getOwnPropSymbols$27(b)) {
      if (__propIsEnum$27.call(b, prop))
        __defNormalProp$2h(a, prop, b[prop]);
    }
  return a;
};
var __objRest$Y = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$27.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$27)
    for (var prop of __getOwnPropSymbols$27(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$27.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Stack = React__default["default"].forwardRef((props, ref) => {
  const _a = props, { gap = 1, alignItems, justifyContent, direction, wrap, children, grow, shrink, basis, flex } = _a, rest = __objRest$Y(_a, ["gap", "alignItems", "justifyContent", "direction", "wrap", "children", "grow", "shrink", "basis", "flex"]);
  const styles = useStyles2(getStyles$1w, gap, alignItems, justifyContent, direction, wrap, grow, shrink, basis, flex);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$26({ ref, className: styles.flex }, rest), children);
});
Stack.displayName = "Stack";
const getStyles$1w = (theme, gap, alignItems, justifyContent, direction, wrap, grow, shrink, basis, flex) => {
  return {
    flex: css.css([
      {
        display: "flex"
      },
      getResponsiveStyle(theme, direction, (val) => ({
        flexDirection: val
      })),
      getResponsiveStyle(theme, wrap, (val) => ({
        flexWrap: val
      })),
      getResponsiveStyle(theme, alignItems, (val) => ({
        alignItems: val
      })),
      getResponsiveStyle(theme, justifyContent, (val) => ({
        justifyContent: val
      })),
      getResponsiveStyle(theme, gap, (val) => ({
        gap: theme.spacing(val)
      })),
      getResponsiveStyle(theme, grow, (val) => ({
        flexGrow: val
      })),
      getResponsiveStyle(theme, shrink, (val) => ({
        flexShrink: val
      })),
      getResponsiveStyle(theme, basis, (val) => ({
        flexBasis: val
      })),
      getResponsiveStyle(theme, flex, (val) => ({
        flex: val
      }))
    ])
  };
};

const modulo$2 = (a, n) => (a % n + n) % n;
const UNFOCUSED = -1;
const useMenuFocus = ({
  localRef,
  isMenuOpen,
  openedWithArrow,
  setOpenedWithArrow,
  close,
  onOpen,
  onClose,
  onKeyDown
}) => {
  const [focusedItem, setFocusedItem] = React.useState(UNFOCUSED);
  React.useEffect(() => {
    if (isMenuOpen && openedWithArrow) {
      setFocusedItem(0);
      setOpenedWithArrow == null ? void 0 : setOpenedWithArrow(false);
    }
  }, [isMenuOpen, openedWithArrow, setOpenedWithArrow]);
  React.useEffect(() => {
    var _a, _b;
    const menuItems = (_a = localRef == null ? void 0 : localRef.current) == null ? void 0 : _a.querySelectorAll(
      '[data-role="menuitem"]:not([data-disabled])'
    );
    (_b = menuItems == null ? void 0 : menuItems[focusedItem]) == null ? void 0 : _b.focus();
    menuItems == null ? void 0 : menuItems.forEach((menuItem, i) => {
      menuItem.tabIndex = i === focusedItem ? 0 : -1;
    });
  }, [localRef, focusedItem]);
  reactUse.useEffectOnce(() => {
    onOpen == null ? void 0 : onOpen(setFocusedItem);
  });
  const handleKeys = (event) => {
    var _a, _b, _c;
    const menuItems = (_a = localRef == null ? void 0 : localRef.current) == null ? void 0 : _a.querySelectorAll(
      '[data-role="menuitem"]:not([data-disabled])'
    );
    const menuItemsCount = (_b = menuItems == null ? void 0 : menuItems.length) != null ? _b : 0;
    switch (event.key) {
      case "ArrowUp":
        event.preventDefault();
        event.stopPropagation();
        setFocusedItem(modulo$2(focusedItem - 1, menuItemsCount));
        break;
      case "ArrowDown":
        event.preventDefault();
        event.stopPropagation();
        setFocusedItem(modulo$2(focusedItem + 1, menuItemsCount));
        break;
      case "ArrowLeft":
        event.preventDefault();
        event.stopPropagation();
        setFocusedItem(UNFOCUSED);
        close == null ? void 0 : close();
        break;
      case "Home":
        event.preventDefault();
        event.stopPropagation();
        setFocusedItem(0);
        break;
      case "End":
        event.preventDefault();
        event.stopPropagation();
        setFocusedItem(menuItemsCount - 1);
        break;
      case "Enter":
        event.preventDefault();
        event.stopPropagation();
        (_c = menuItems == null ? void 0 : menuItems[focusedItem]) == null ? void 0 : _c.click();
        break;
      case "Escape":
        onClose == null ? void 0 : onClose();
        break;
      case "Tab":
        event.preventDefault();
        onClose == null ? void 0 : onClose();
        break;
    }
    onKeyDown == null ? void 0 : onKeyDown(event);
  };
  return [handleKeys];
};

const isElementOverflowing = (element) => {
  if (!element) {
    return false;
  }
  const wrapperPos = element.parentElement.getBoundingClientRect();
  const pos = element.getBoundingClientRect();
  return pos.width !== 0 && wrapperPos.right + pos.width + 10 > window.innerWidth;
};

const SubMenu = React__default["default"].memo(
  ({ items, isOpen, openedWithArrow, setOpenedWithArrow, close, customStyle }) => {
    const styles = useStyles2(getStyles$1v);
    const localRef = React.useRef(null);
    const [handleKeys] = useMenuFocus({
      localRef,
      isMenuOpen: isOpen,
      openedWithArrow,
      setOpenedWithArrow,
      close
    });
    const [pushLeft, setPushLeft] = React.useState(false);
    React.useEffect(() => {
      if (isOpen && localRef.current) {
        setPushLeft(isElementOverflowing(localRef.current));
      }
    }, [isOpen]);
    return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.iconWrapper, "aria-hidden": true, "data-testid": e2eSelectors.selectors.components.Menu.SubMenu.icon }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-right", className: styles.icon })), isOpen && /* @__PURE__ */ React__default["default"].createElement(
      "div",
      {
        ref: localRef,
        className: css.cx(styles.subMenu, { [styles.pushLeft]: pushLeft }),
        "data-testid": e2eSelectors.selectors.components.Menu.SubMenu.container,
        style: customStyle
      },
      /* @__PURE__ */ React__default["default"].createElement("div", { tabIndex: -1, className: styles.itemsWrapper, role: "menu", onKeyDown: handleKeys }, items)
    ));
  }
);
SubMenu.displayName = "SubMenu";
const getStyles$1v = (theme) => {
  return {
    iconWrapper: css.css({
      display: "flex",
      flex: 1,
      justifyContent: "end"
    }),
    icon: css.css({
      opacity: 0.7,
      marginLeft: theme.spacing(1),
      color: theme.colors.text.secondary
    }),
    itemsWrapper: css.css({
      background: theme.colors.background.primary,
      boxShadow: theme.shadows.z3,
      display: "inline-block",
      borderRadius: theme.shape.radius.default
    }),
    pushLeft: css.css({
      right: "100%",
      left: "unset"
    }),
    subMenu: css.css({
      position: "absolute",
      top: 0,
      left: "100%",
      zIndex: theme.zIndex.dropdown
    })
  };
};

var __defProp$2g = Object.defineProperty;
var __defProps$1m = Object.defineProperties;
var __getOwnPropDescs$1m = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$26 = Object.getOwnPropertySymbols;
var __hasOwnProp$26 = Object.prototype.hasOwnProperty;
var __propIsEnum$26 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2g = (obj, key, value) => key in obj ? __defProp$2g(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$25 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$26.call(b, prop))
      __defNormalProp$2g(a, prop, b[prop]);
  if (__getOwnPropSymbols$26)
    for (var prop of __getOwnPropSymbols$26(b)) {
      if (__propIsEnum$26.call(b, prop))
        __defNormalProp$2g(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1m = (a, b) => __defProps$1m(a, __getOwnPropDescs$1m(b));
const MenuItem = React__default["default"].memo(
  React__default["default"].forwardRef((props, ref) => {
    const {
      url,
      icon,
      label,
      description,
      ariaLabel,
      ariaChecked,
      target,
      onClick,
      className,
      active,
      disabled,
      destructive,
      childItems,
      role = "menuitem",
      tabIndex = -1,
      customSubMenuContainerStyles,
      shortcut,
      testId
    } = props;
    const styles = useStyles2(getStyles$1u);
    const [isActive, setIsActive] = React.useState(active);
    const [isSubMenuOpen, setIsSubMenuOpen] = React.useState(false);
    const [openedWithArrow, setOpenedWithArrow] = React.useState(false);
    const onMouseEnter = React.useCallback(() => {
      if (disabled) {
        return;
      }
      setIsSubMenuOpen(true);
      setIsActive(true);
    }, [disabled]);
    const onMouseLeave = React.useCallback(() => {
      if (disabled) {
        return;
      }
      setIsSubMenuOpen(false);
      setIsActive(false);
    }, [disabled]);
    const hasSubMenu = childItems && childItems.length > 0;
    const ItemElement = hasSubMenu ? "div" : url === void 0 ? "button" : "a";
    const itemStyle = css.cx(
      {
        [styles.item]: true,
        [styles.active]: isActive,
        [styles.disabled]: disabled,
        [styles.destructive]: destructive && !disabled
      },
      className
    );
    const disabledProps = __spreadValues$25(__spreadValues$25({
      [ItemElement === "button" ? "disabled" : "aria-disabled"]: disabled
    }, ItemElement === "a" && disabled && { href: void 0, onClick: void 0 }), disabled && {
      tabIndex: -1,
      ["data-disabled"]: disabled
      // used to identify disabled items in Menu.tsx
    });
    const localRef = React.useRef(null);
    React.useImperativeHandle(ref, () => localRef.current);
    const handleKeys = (event) => {
      switch (event.key) {
        case "ArrowRight":
          event.preventDefault();
          event.stopPropagation();
          if (hasSubMenu) {
            setIsSubMenuOpen(true);
            setOpenedWithArrow(true);
            setIsActive(true);
          }
          break;
      }
    };
    const closeSubMenu = () => {
      var _a;
      setIsSubMenuOpen(false);
      setIsActive(false);
      (_a = localRef == null ? void 0 : localRef.current) == null ? void 0 : _a.focus();
    };
    const hasShortcut = Boolean(shortcut && shortcut.length > 0);
    return /* @__PURE__ */ React__default["default"].createElement(
      ItemElement,
      __spreadValues$25({
        target,
        className: itemStyle,
        rel: target === "_blank" ? "noopener noreferrer" : void 0,
        href: url,
        onClick,
        onMouseEnter,
        onMouseLeave,
        onKeyDown: handleKeys,
        role: url === void 0 ? role : void 0,
        "data-role": "menuitem",
        ref: localRef,
        "data-testid": testId,
        "aria-label": ariaLabel,
        "aria-checked": ariaChecked,
        tabIndex
      }, disabledProps),
      /* @__PURE__ */ React__default["default"].createElement(Stack, { direction: "row", justifyContent: "flex-start", alignItems: "center" }, icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, className: styles.icon, "aria-hidden": true }), /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.ellipsis }, label), /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.rightWrapper, { [styles.withShortcut]: hasShortcut }) }, hasShortcut && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.shortcut }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "keyboard", title: "keyboard shortcut" }), shortcut), hasSubMenu && /* @__PURE__ */ React__default["default"].createElement(
        SubMenu,
        {
          items: childItems,
          isOpen: isSubMenuOpen,
          openedWithArrow,
          setOpenedWithArrow,
          close: closeSubMenu,
          customStyle: customSubMenuContainerStyles
        }
      ))),
      description && /* @__PURE__ */ React__default["default"].createElement(
        "div",
        {
          className: css.cx(styles.description, styles.ellipsis, {
            [styles.descriptionWithIcon]: icon !== void 0
          })
        },
        description
      )
    );
  })
);
MenuItem.displayName = "MenuItem";
const getStyles$1u = (theme) => {
  return {
    item: css.css({
      background: "none",
      cursor: "pointer",
      whiteSpace: "nowrap",
      color: theme.colors.text.primary,
      display: "flex",
      flexDirection: "column",
      alignItems: "stretch",
      padding: theme.spacing(0.5, 2),
      minHeight: theme.spacing(4),
      margin: 0,
      border: "none",
      width: "100%",
      position: "relative",
      "&:hover, &:focus, &:focus-visible": {
        background: theme.colors.action.hover,
        color: theme.colors.text.primary,
        textDecoration: "none"
      },
      "&:focus-visible": getFocusStyles(theme)
    }),
    active: css.css({
      background: theme.colors.action.hover
    }),
    destructive: css.css({
      color: theme.colors.error.text,
      svg: {
        color: theme.colors.error.text
      },
      "&:hover, &:focus, &:focus-visible": {
        background: theme.colors.error.main,
        color: theme.colors.error.contrastText,
        svg: {
          color: theme.colors.error.contrastText
        }
      }
    }),
    disabled: css.css({
      color: theme.colors.action.disabledText,
      label: "menu-item-disabled",
      "&:hover, &:focus, &:focus-visible": {
        cursor: "not-allowed",
        background: "none",
        color: theme.colors.action.disabledText
      }
    }),
    icon: css.css({
      opacity: 0.7,
      color: theme.colors.text.secondary
    }),
    rightWrapper: css.css({
      display: "flex",
      alignItems: "center",
      marginLeft: "auto"
    }),
    withShortcut: css.css({
      minWidth: theme.spacing(10.5)
    }),
    shortcut: css.css({
      display: "flex",
      alignItems: "center",
      gap: theme.spacing(1),
      marginLeft: theme.spacing(2),
      color: theme.colors.text.secondary,
      opacity: 0.7
    }),
    description: css.css(__spreadProps$1m(__spreadValues$25({}, theme.typography.bodySmall), {
      color: theme.colors.text.secondary,
      textAlign: "start"
    })),
    descriptionWithIcon: css.css({
      marginLeft: theme.spacing(3)
    }),
    ellipsis: css.css({
      overflow: "hidden",
      textOverflow: "ellipsis",
      whiteSpace: "nowrap"
    })
  };
};

var __defProp$2f = Object.defineProperty;
var __defProps$1l = Object.defineProperties;
var __getOwnPropDescs$1l = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$25 = Object.getOwnPropertySymbols;
var __hasOwnProp$25 = Object.prototype.hasOwnProperty;
var __propIsEnum$25 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2f = (obj, key, value) => key in obj ? __defProp$2f(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$24 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$25.call(b, prop))
      __defNormalProp$2f(a, prop, b[prop]);
  if (__getOwnPropSymbols$25)
    for (var prop of __getOwnPropSymbols$25(b)) {
      if (__propIsEnum$25.call(b, prop))
        __defNormalProp$2f(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1l = (a, b) => __defProps$1l(a, __getOwnPropDescs$1l(b));
var __objRest$X = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$25.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$25)
    for (var prop of __getOwnPropSymbols$25(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$25.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const MenuComp = React__default["default"].forwardRef(
  (_a, forwardedRef) => {
    var _b = _a, { header, children, ariaLabel, onOpen, onClose, onKeyDown } = _b, otherProps = __objRest$X(_b, ["header", "children", "ariaLabel", "onOpen", "onClose", "onKeyDown"]);
    const styles = useStyles2(getStyles$1t);
    const localRef = React.useRef(null);
    React.useImperativeHandle(forwardedRef, () => localRef.current);
    const [handleKeys] = useMenuFocus({ localRef, onOpen, onClose, onKeyDown });
    return /* @__PURE__ */ React__default["default"].createElement(
      "div",
      __spreadProps$1l(__spreadValues$24({}, otherProps), {
        tabIndex: -1,
        ref: localRef,
        className: styles.wrapper,
        role: "menu",
        "aria-label": ariaLabel,
        onKeyDown: handleKeys
      }),
      header && /* @__PURE__ */ React__default["default"].createElement(
        "div",
        {
          className: css.cx(
            styles.header,
            Boolean(children) && React__default["default"].Children.toArray(children).length > 0 && styles.headerBorder
          )
        },
        header
      ),
      children
    );
  }
);
MenuComp.displayName = "Menu";
const Menu = Object.assign(MenuComp, {
  Item: MenuItem,
  Divider: MenuDivider,
  Group: MenuGroup
});
const getStyles$1t = (theme) => {
  return {
    header: css.css({
      padding: `${theme.spacing(0.5, 1, 1, 1)}`
    }),
    headerBorder: css.css({
      borderBottom: `1px solid ${theme.colors.border.weak}`
    }),
    wrapper: css.css({
      background: `${theme.colors.background.primary}`,
      boxShadow: `${theme.shadows.z3}`,
      display: `inline-block`,
      borderRadius: `${theme.shape.radius.default}`,
      padding: `${theme.spacing(0.5, 0)}`
    })
  };
};

var __defProp$2e = Object.defineProperty;
var __defProps$1k = Object.defineProperties;
var __getOwnPropDescs$1k = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$24 = Object.getOwnPropertySymbols;
var __hasOwnProp$24 = Object.prototype.hasOwnProperty;
var __propIsEnum$24 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2e = (obj, key, value) => key in obj ? __defProp$2e(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$23 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$24.call(b, prop))
      __defNormalProp$2e(a, prop, b[prop]);
  if (__getOwnPropSymbols$24)
    for (var prop of __getOwnPropSymbols$24(b)) {
      if (__propIsEnum$24.call(b, prop))
        __defNormalProp$2e(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1k = (a, b) => __defProps$1k(a, __getOwnPropDescs$1k(b));
var __objRest$W = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$24.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$24)
    for (var prop of __getOwnPropSymbols$24(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$24.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const ToolbarButton = React.forwardRef(
  (_a, ref) => {
    var _b = _a, {
      tooltip,
      icon,
      iconSize,
      className,
      children,
      imgSrc,
      imgAlt,
      fullWidth,
      isOpen,
      narrow,
      variant = "default",
      iconOnly,
      "aria-label": ariaLabel,
      isHighlighted
    } = _b, rest = __objRest$W(_b, [
      "tooltip",
      "icon",
      "iconSize",
      "className",
      "children",
      "imgSrc",
      "imgAlt",
      "fullWidth",
      "isOpen",
      "narrow",
      "variant",
      "iconOnly",
      "aria-label",
      "isHighlighted"
    ]);
    const styles = useStyles2(getStyles$1s);
    const buttonStyles = css.cx(
      {
        [styles.button]: true,
        [styles.buttonFullWidth]: fullWidth,
        [styles.narrow]: narrow
      },
      styles[variant],
      className
    );
    const contentStyles = css.cx({
      [styles.content]: true,
      [styles.contentWithIcon]: !!icon,
      [styles.contentWithRightIcon]: isOpen !== void 0
    });
    const body = /* @__PURE__ */ React__default["default"].createElement(
      "button",
      __spreadValues$23({
        ref,
        className: buttonStyles,
        "aria-label": getButtonAriaLabel(ariaLabel, tooltip),
        "aria-expanded": isOpen
      }, rest),
      renderIcon(icon, iconSize),
      imgSrc && /* @__PURE__ */ React__default["default"].createElement("img", { className: styles.img, src: imgSrc, alt: imgAlt != null ? imgAlt : "" }),
      children && !iconOnly && /* @__PURE__ */ React__default["default"].createElement("div", { className: contentStyles }, children),
      isOpen === false && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-down" }),
      isOpen === true && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-up" }),
      isHighlighted && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.highlight })
    );
    return tooltip ? /* @__PURE__ */ React__default["default"].createElement(Tooltip, { ref, content: tooltip, placement: "bottom" }, body) : body;
  }
);
ToolbarButton.displayName = "ToolbarButton";
function getButtonAriaLabel(ariaLabel, tooltip) {
  return ariaLabel ? ariaLabel : tooltip ? e2eSelectors.selectors.components.PageToolbar.item(tooltip) : void 0;
}
function renderIcon(icon, iconSize) {
  if (!icon) {
    return null;
  }
  if (data.isIconName(icon)) {
    return /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, size: `${iconSize ? iconSize : "lg"}` });
  }
  return icon;
}
const getStyles$1s = (theme) => {
  const primaryVariant = getPropertiesForVariant(theme, "primary", "solid");
  const destructiveVariant = getPropertiesForVariant(theme, "destructive", "solid");
  const defaultOld = css.css({
    color: theme.colors.text.primary,
    background: theme.colors.secondary.main,
    "&:hover": {
      color: theme.colors.text.primary,
      background: theme.colors.secondary.shade,
      border: `1px solid ${theme.colors.border.medium}`
    }
  });
  return {
    button: css.css({
      label: "toolbar-button",
      position: "relative",
      display: "flex",
      alignItems: "center",
      height: theme.spacing(theme.components.height.md),
      padding: theme.spacing(0, 1),
      borderRadius: theme.shape.radius.default,
      lineHeight: `${theme.components.height.md * theme.spacing.gridSize - 2}px`,
      fontWeight: theme.typography.fontWeightMedium,
      border: `1px solid ${theme.colors.secondary.border}`,
      whiteSpace: "nowrap",
      transition: theme.transitions.create(["background", "box-shadow", "border-color", "color"], {
        duration: theme.transitions.duration.short
      }),
      "&:focus, &:focus-visible": __spreadProps$1k(__spreadValues$23({}, getFocusStyles(theme)), {
        zIndex: 1
      }),
      "&:focus:not(:focus-visible)": getMouseFocusStyles(),
      "&:hover": {
        boxShadow: theme.shadows.z1
      },
      "&[disabled], &:disabled": {
        cursor: "not-allowed",
        opacity: theme.colors.action.disabledOpacity,
        background: theme.colors.action.disabledBackground,
        boxShadow: "none",
        "&:hover": {
          color: theme.colors.text.disabled,
          background: theme.colors.action.disabledBackground,
          boxShadow: "none"
        }
      }
    }),
    default: css.css({
      color: theme.colors.text.secondary,
      background: "transparent",
      border: `1px solid transparent`,
      "&:hover": {
        color: theme.colors.text.primary,
        background: theme.colors.background.secondary
      }
    }),
    canvas: defaultOld,
    active: css.cx(
      defaultOld,
      css.css({
        "&::before": {
          display: "block",
          content: '" "',
          position: "absolute",
          left: 0,
          right: 0,
          height: "2px",
          bottom: 0,
          borderRadius: theme.shape.radius.default,
          backgroundImage: theme.colors.gradients.brandHorizontal
        }
      })
    ),
    primary: css.css(primaryVariant),
    destructive: css.css(destructiveVariant),
    narrow: css.css({
      padding: theme.spacing(0, 0.5)
    }),
    img: css.css({
      width: "16px",
      height: "16px",
      marginRight: theme.spacing(1)
    }),
    buttonFullWidth: css.css({
      flexGrow: 1
    }),
    content: css.css({
      flexGrow: 1
    }),
    contentWithIcon: css.css({
      display: "none",
      paddingLeft: theme.spacing(1),
      [`@media ${mediaUp(theme.v1.breakpoints.md)}`]: {
        display: "block"
      }
    }),
    contentWithRightIcon: css.css({
      paddingRight: theme.spacing(0.5)
    }),
    highlight: css.css({
      backgroundColor: theme.colors.success.main,
      borderRadius: theme.shape.radius.circle,
      width: "6px",
      height: "6px",
      position: "absolute",
      top: "-3px",
      right: "-3px",
      zIndex: 1
    })
  };
};

var __defProp$2d = Object.defineProperty;
var __getOwnPropSymbols$23 = Object.getOwnPropertySymbols;
var __hasOwnProp$23 = Object.prototype.hasOwnProperty;
var __propIsEnum$23 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2d = (obj, key, value) => key in obj ? __defProp$2d(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$22 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$23.call(b, prop))
      __defNormalProp$2d(a, prop, b[prop]);
  if (__getOwnPropSymbols$23)
    for (var prop of __getOwnPropSymbols$23(b)) {
      if (__propIsEnum$23.call(b, prop))
        __defNormalProp$2d(a, prop, b[prop]);
    }
  return a;
};
var __objRest$V = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$23.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$23)
    for (var prop of __getOwnPropSymbols$23(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$23.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const ToolbarButtonRow = React.forwardRef(
  (_a, ref) => {
    var _b = _a, { alignment = "left", className, children } = _b, rest = __objRest$V(_b, ["alignment", "className", "children"]);
    const childrenWithoutNull = React__default["default"].Children.toArray(children).filter((child) => child != null);
    const [childVisibility, setChildVisibility] = React.useState(Array(childrenWithoutNull.length).fill(false));
    const containerRef = React.useRef(null);
    const [showOverflowItems, setShowOverflowItems] = React.useState(false);
    const overflowRef = React.useRef(null);
    const overflowItemsRef = React.createRef();
    const { overlayProps } = overlays.useOverlay(
      {
        onClose: () => setShowOverflowItems(false),
        isDismissable: true,
        isOpen: showOverflowItems,
        shouldCloseOnInteractOutside: (element) => {
          var _a2;
          const portalContainer = getPortalContainer();
          return !((_a2 = overflowRef.current) == null ? void 0 : _a2.contains(element)) && !portalContainer.contains(element);
        }
      },
      overflowItemsRef
    );
    const { dialogProps } = dialog.useDialog({}, overflowItemsRef);
    const theme = useTheme2();
    const overflowButtonOrder = alignment === "left" ? childVisibility.indexOf(false) - 1 : childVisibility.length;
    const styles = getStyles$1r(theme, overflowButtonOrder, alignment);
    React.useLayoutEffect(() => {
      const intersectionObserver = new IntersectionObserver(
        (entries) => {
          entries.forEach((entry) => {
            if (entry.target instanceof HTMLElement && entry.target.parentNode) {
              const index = Array.prototype.indexOf.call(entry.target.parentNode.children, entry.target);
              setChildVisibility((prev) => {
                const newVisibility = [...prev];
                newVisibility[index] = entry.isIntersecting;
                return newVisibility;
              });
            }
          });
        },
        {
          threshold: 1,
          root: containerRef.current
        }
      );
      if (containerRef.current) {
        Array.from(containerRef.current.children).forEach((item) => {
          if (item instanceof HTMLElement && item !== overflowRef.current) {
            intersectionObserver.observe(item);
          }
        });
      }
      return () => intersectionObserver.disconnect();
    }, [children]);
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$22({ ref: containerRef, className: css.cx(styles.container, className) }, rest), childrenWithoutNull.map((child, index) => /* @__PURE__ */ React__default["default"].createElement(
      "div",
      {
        key: index,
        style: { order: index, visibility: childVisibility[index] ? "visible" : "hidden" },
        className: styles.childWrapper
      },
      child
    )), childVisibility.includes(false) && /* @__PURE__ */ React__default["default"].createElement("div", { ref: overflowRef, className: styles.overflowButton }, /* @__PURE__ */ React__default["default"].createElement(
      ToolbarButton,
      {
        variant: showOverflowItems ? "active" : "default",
        tooltip: "Show more items",
        onClick: () => setShowOverflowItems(!showOverflowItems),
        icon: "ellipsis-v",
        iconOnly: true,
        narrow: true
      }
    ), showOverflowItems && /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { contain: true, autoFocus: true }, /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$22(__spreadValues$22({ className: styles.overflowItems, ref: overflowItemsRef }, overlayProps), dialogProps), childrenWithoutNull.map((child, index) => !childVisibility[index] && child)))));
  }
);
ToolbarButtonRow.displayName = "ToolbarButtonRow";
const getStyles$1r = (theme, overflowButtonOrder, alignment) => ({
  overflowButton: css.css({
    order: overflowButtonOrder
  }),
  overflowItems: css.css({
    alignItems: "center",
    backgroundColor: theme.colors.background.primary,
    borderRadius: theme.shape.radius.default,
    boxShadow: theme.shadows.z2,
    display: "flex",
    flexWrap: "wrap",
    gap: theme.spacing(1),
    marginTop: theme.spacing(1),
    maxWidth: "80vw",
    padding: theme.spacing(0.5, 1),
    position: "absolute",
    right: 0,
    top: "100%",
    width: "max-content",
    zIndex: theme.zIndex.dropdown
  }),
  container: css.css({
    alignItems: "center",
    display: "flex",
    gap: theme.spacing(1),
    justifyContent: alignment === "left" ? "flex-start" : "flex-end",
    minWidth: 0,
    position: "relative"
  }),
  childWrapper: css.css({
    alignItems: "center",
    display: "flex",
    gap: theme.spacing(1)
  })
});

var __defProp$2c = Object.defineProperty;
var __defProps$1j = Object.defineProperties;
var __getOwnPropDescs$1j = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$22 = Object.getOwnPropertySymbols;
var __hasOwnProp$22 = Object.prototype.hasOwnProperty;
var __propIsEnum$22 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2c = (obj, key, value) => key in obj ? __defProp$2c(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$21 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$22.call(b, prop))
      __defNormalProp$2c(a, prop, b[prop]);
  if (__getOwnPropSymbols$22)
    for (var prop of __getOwnPropSymbols$22(b)) {
      if (__propIsEnum$22.call(b, prop))
        __defNormalProp$2c(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1j = (a, b) => __defProps$1j(a, __getOwnPropDescs$1j(b));
var __objRest$U = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$22.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$22)
    for (var prop of __getOwnPropSymbols$22(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$22.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const ButtonSelectComponent = (props) => {
  const _a = props, { className, options, value, onChange, narrow, variant } = _a, restProps = __objRest$U(_a, ["className", "options", "value", "onChange", "narrow", "variant"]);
  const styles = useStyles2(getStyles$1q);
  const [isOpen, setIsOpen] = React.useState(false);
  const middleware = [
    react$1.offset(0),
    react$1.flip({
      fallbackAxisSideDirection: "end",
      // see https://floating-ui.com/docs/flip#combining-with-shift
      crossAxis: false,
      boundary: document.body
    }),
    react$1.shift()
  ];
  const { context, refs, floatingStyles } = react$1.useFloating({
    open: isOpen,
    placement: "bottom-end",
    onOpenChange: setIsOpen,
    middleware,
    whileElementsMounted: react$1.autoUpdate
  });
  const click = react$1.useClick(context);
  const dismiss = react$1.useDismiss(context);
  const { getReferenceProps, getFloatingProps } = react$1.useInteractions([dismiss, click]);
  const onChangeInternal = (item) => {
    onChange(item);
    setIsOpen(false);
  };
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.wrapper }, /* @__PURE__ */ React__default["default"].createElement(
    ToolbarButton,
    __spreadValues$21(__spreadValues$21({
      className,
      isOpen,
      narrow,
      variant,
      ref: refs.setReference
    }, getReferenceProps()), restProps),
    (value == null ? void 0 : value.label) || ((value == null ? void 0 : value.value) != null ? String(value == null ? void 0 : value.value) : null)
  ), isOpen && /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1j(__spreadValues$21({ className: styles.menuWrapper, ref: refs.setFloating }, getFloatingProps()), { style: floatingStyles }), /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { contain: true, autoFocus: true, restoreFocus: true }, /* @__PURE__ */ React__default["default"].createElement(Menu, { tabIndex: -1, onClose: () => setIsOpen(false) }, options.map((item) => {
    var _a2;
    return /* @__PURE__ */ React__default["default"].createElement(
      MenuItem,
      {
        key: `${item.value}`,
        label: (_a2 = item.label) != null ? _a2 : String(item.value),
        onClick: () => onChangeInternal(item),
        active: item.value === (value == null ? void 0 : value.value),
        ariaChecked: item.value === (value == null ? void 0 : value.value),
        ariaLabel: item.ariaLabel || item.label,
        role: "menuitemradio"
      }
    );
  })))));
};
ButtonSelectComponent.displayName = "ButtonSelect";
const ButtonSelect = React__default["default"].memo(ButtonSelectComponent);
const getStyles$1q = (theme) => {
  return {
    wrapper: css.css({
      position: "relative",
      display: "inline-flex"
    }),
    menuWrapper: css.css({
      zIndex: theme.zIndex.dropdown
    })
  };
};

var __defProp$2b = Object.defineProperty;
var __defNormalProp$2b = (obj, key, value) => key in obj ? __defProp$2b(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$k = (obj, key, value) => {
  __defNormalProp$2b(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
const defaultIntervals = ["5s", "10s", "30s", "1m", "5m", "15m", "30m", "1h", "2h", "1d"];
const _RefreshPicker = class _RefreshPicker extends React.PureComponent {
  constructor(props) {
    super(props);
    __publicField$k(this, "onChangeSelect", (item) => {
      const { onIntervalChanged } = this.props;
      if (onIntervalChanged && item.value != null) {
        onIntervalChanged(item.value);
      }
    });
  }
  getVariant() {
    if (this.props.isLive) {
      return "primary";
    }
    if (this.props.isLoading) {
      return "destructive";
    }
    if (this.props.primary) {
      return "primary";
    }
    return this.props.isOnCanvas ? "canvas" : "default";
  }
  render() {
    const { onRefresh, intervals, tooltip, value, text, isLoading, noIntervalPicker, width, showAutoInterval } = this.props;
    const currentValue = value || "";
    const variant = this.getVariant();
    const options = intervalsToOptions({ intervals, showAutoInterval });
    const option = options.find(({ value: value2 }) => value2 === currentValue);
    const translatedOffOption = translateOption(_RefreshPicker.offOption.value);
    let selectedValue = option || translatedOffOption;
    if (selectedValue.label === translatedOffOption.label) {
      selectedValue = { value: "" };
    }
    const durationAriaLabel = selectedValue.ariaLabel;
    const ariaLabelDurationSelectedMessage = t(
      "refresh-picker.aria-label.duration-selected",
      "Choose refresh time interval with current interval {{durationAriaLabel}} selected",
      { durationAriaLabel }
    );
    const ariaLabelChooseIntervalMessage = t(
      "refresh-picker.aria-label.choose-interval",
      "Auto refresh turned off. Choose refresh time interval"
    );
    const ariaLabel = selectedValue.value === "" ? ariaLabelChooseIntervalMessage : ariaLabelDurationSelectedMessage;
    const tooltipIntervalSelected = t("refresh-picker.tooltip.interval-selected", "Set auto refresh interval");
    const tooltipAutoRefreshOff = t("refresh-picker.tooltip.turned-off", "Auto refresh off");
    const tooltipAutoRefresh = selectedValue.value === "" ? tooltipAutoRefreshOff : tooltipIntervalSelected;
    return /* @__PURE__ */ React__default["default"].createElement(ButtonGroup, { className: "refresh-picker" }, /* @__PURE__ */ React__default["default"].createElement(
      ToolbarButton,
      {
        "aria-label": text,
        tooltip,
        onClick: onRefresh,
        variant,
        icon: isLoading ? "spinner" : "sync",
        style: width ? { width } : void 0,
        "data-testid": e2eSelectors.selectors.components.RefreshPicker.runButtonV2
      },
      text
    ), !noIntervalPicker && /* @__PURE__ */ React__default["default"].createElement(
      ButtonSelect,
      {
        value: selectedValue,
        options,
        onChange: this.onChangeSelect,
        variant,
        "data-testid": e2eSelectors.selectors.components.RefreshPicker.intervalButtonV2,
        "aria-label": ariaLabel,
        tooltip: tooltipAutoRefresh
      }
    ));
  }
};
__publicField$k(_RefreshPicker, "offOption", {
  label: "Off",
  value: "",
  ariaLabel: "Turn off auto refresh"
});
__publicField$k(_RefreshPicker, "liveOption", {
  label: "Live",
  value: "LIVE",
  ariaLabel: "Turn on live streaming"
});
__publicField$k(_RefreshPicker, "autoOption", {
  label: "Auto",
  value: "auto",
  ariaLabel: "Select refresh from the query range"
});
__publicField$k(_RefreshPicker, "isLive", (refreshInterval) => refreshInterval === _RefreshPicker.liveOption.value);
let RefreshPicker = _RefreshPicker;
function translateOption(option) {
  switch (option) {
    case RefreshPicker.liveOption.value:
      return {
        label: t("refresh-picker.live-option.label", "Live"),
        value: option,
        ariaLabel: t("refresh-picker.live-option.aria-label", "Turn on live streaming")
      };
    case RefreshPicker.offOption.value:
      return {
        label: t("refresh-picker.off-option.label", "Off"),
        value: option,
        ariaLabel: t("refresh-picker.off-option.aria-label", "Turn off auto refresh")
      };
    case RefreshPicker.autoOption.value:
      return {
        label: t("refresh-picker.auto-option.label", RefreshPicker.autoOption.label),
        value: option,
        ariaLabel: t("refresh-picker.auto-option.aria-label", RefreshPicker.autoOption.ariaLabel)
      };
  }
  return {
    label: option,
    value: option
  };
}
function intervalsToOptions({
  intervals = defaultIntervals,
  showAutoInterval = false
} = {}) {
  const options = intervals.map((interval) => {
    const duration = data.parseDuration(interval);
    const ariaLabel = dateFns.formatDuration(duration);
    return {
      label: interval,
      value: interval,
      ariaLabel
    };
  });
  if (showAutoInterval) {
    options.unshift(translateOption(RefreshPicker.autoOption.value));
  }
  options.unshift(translateOption(RefreshPicker.offOption.value));
  return options;
}

const getModalStyles = (theme) => {
  const borderRadius = theme.shape.radius.default;
  return {
    modal: css.css({
      position: "fixed",
      zIndex: theme.zIndex.modal,
      background: theme.colors.background.primary,
      boxShadow: theme.shadows.z3,
      borderRadius,
      border: `1px solid ${theme.colors.border.weak}`,
      backgroundClip: "padding-box",
      outline: "none",
      width: "750px",
      maxWidth: "100%",
      left: 0,
      right: 0,
      marginLeft: "auto",
      marginRight: "auto",
      top: "10%",
      maxHeight: "80%",
      display: "flex",
      flexDirection: "column"
    }),
    modalBackdrop: css.css({
      position: "fixed",
      zIndex: theme.zIndex.modalBackdrop,
      top: 0,
      right: 0,
      bottom: 0,
      left: 0,
      backgroundColor: theme.components.overlay.background,
      backdropFilter: "blur(1px)"
    }),
    modalHeader: css.css({
      label: "modalHeader",
      display: "flex",
      alignItems: "center",
      minHeight: "42px",
      margin: theme.spacing(1, 2, 0, 2)
    }),
    modalHeaderWithTabs: css.css({
      borderBottom: `1px solid ${theme.colors.border.weak}`
    }),
    modalHeaderTitle: css.css({
      fontSize: theme.typography.size.lg,
      margin: theme.spacing(0, 4, 0, 1),
      display: "flex",
      alignItems: "center",
      position: "relative",
      top: "2px"
    }),
    modalHeaderIcon: css.css({
      marginRight: theme.spacing(2),
      fontSize: "inherit",
      "&:before": {
        verticalAlign: "baseline"
      }
    }),
    modalHeaderClose: css.css({
      height: "100%",
      display: "flex",
      alignItems: "center",
      color: theme.colors.text.secondary,
      flexGrow: 1,
      justifyContent: "flex-end"
    }),
    modalContent: css.css({
      overflow: "auto",
      padding: theme.spacing(3),
      width: "100%"
    }),
    modalButtonRow: css.css({
      paddingTop: theme.spacing(3)
    })
  };
};

function useCombinedRefs(...refs) {
  const targetRef = React__default["default"].useRef(null);
  React__default["default"].useEffect(() => {
    refs.forEach((ref) => {
      if (!ref) {
        return;
      }
      if (typeof ref === "function") {
        ref(targetRef.current);
      } else {
        ref.current = targetRef.current;
      }
    });
  }, [refs]);
  return targetRef;
}

var __defProp$2a = Object.defineProperty;
var __defProps$1i = Object.defineProperties;
var __getOwnPropDescs$1i = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$21 = Object.getOwnPropertySymbols;
var __hasOwnProp$21 = Object.prototype.hasOwnProperty;
var __propIsEnum$21 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$2a = (obj, key, value) => key in obj ? __defProp$2a(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$20 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$21.call(b, prop))
      __defNormalProp$2a(a, prop, b[prop]);
  if (__getOwnPropSymbols$21)
    for (var prop of __getOwnPropSymbols$21(b)) {
      if (__propIsEnum$21.call(b, prop))
        __defNormalProp$2a(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1i = (a, b) => __defProps$1i(a, __getOwnPropDescs$1i(b));
var __objRest$T = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$21.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$21)
    for (var prop of __getOwnPropSymbols$21(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$21.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const FilterInput = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, { value, width, onChange, escapeRegex = true } = _b, restProps = __objRest$T(_b, ["value", "width", "onChange", "escapeRegex"]);
    const innerRef = React__default["default"].useRef(null);
    const combinedRef = useCombinedRefs(ref, innerRef);
    const suffix = value !== "" ? /* @__PURE__ */ React__default["default"].createElement(
      Button,
      {
        icon: "times",
        fill: "text",
        size: "sm",
        onClick: (e) => {
          var _a2;
          (_a2 = innerRef.current) == null ? void 0 : _a2.focus();
          onChange("");
          e.stopPropagation();
        }
      },
      "Clear"
    ) : null;
    return /* @__PURE__ */ React__default["default"].createElement(
      Input,
      __spreadProps$1i(__spreadValues$20({
        prefix: /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "search" }),
        suffix,
        width,
        type: "text",
        value: escapeRegex ? data.unEscapeStringFromRegex(value != null ? value : "") : value,
        onChange: (event) => onChange(escapeRegex ? data.escapeStringForRegex(event.currentTarget.value) : event.currentTarget.value)
      }, restProps), {
        ref: combinedRef
      })
    );
  }
);
FilterInput.displayName = "FilterInput";

const FieldValidationMessage = ({
  children,
  horizontal,
  className
}) => {
  const styles = useStyles2(getFieldValidationMessageStyles);
  const cssName = css.cx(horizontal ? styles.horizontal : styles.vertical, className);
  return /* @__PURE__ */ React__default["default"].createElement("div", { role: "alert", className: cssName }, /* @__PURE__ */ React__default["default"].createElement(Icon, { className: styles.fieldValidationMessageIcon, name: "exclamation-triangle" }), children);
};
const getFieldValidationMessageStyles = (theme) => {
  const baseStyle = `
      font-size: ${theme.typography.size.sm};
      font-weight: ${theme.typography.fontWeightMedium};
      padding: ${theme.spacing(0.5, 1)};
      color: ${theme.colors.error.contrastText};
      background: ${theme.colors.error.main};
      border-radius: ${theme.shape.radius.default};
      position: relative;
      display: inline-block;
      align-self: flex-start;

      a {
        color: ${theme.colors.error.contrastText};
        text-decoration: underline;
      }

      a:hover {
        text-decoration: none;
      }
    `;
  return {
    vertical: css.css(baseStyle, {
      margin: theme.spacing(0.5, 0, 0, 0),
      "&:before": {
        content: '""',
        position: "absolute",
        left: "9px",
        top: "-5px",
        width: 0,
        height: 0,
        borderWidth: "0 4px 5px 4px",
        borderColor: `transparent transparent ${theme.colors.error.main} transparent`,
        borderStyle: "solid"
      }
    }),
    horizontal: css.css(baseStyle, {
      marginLeft: "10px",
      "&:before": {
        content: '""',
        position: "absolute",
        left: "-5px",
        top: "9px",
        width: 0,
        height: 0,
        borderWidth: "4px 5px 4px 0",
        borderColor: "transparent #e02f44 transparent transparent",
        borderStyle: "solid"
      }
    }),
    fieldValidationMessageIcon: css.css({
      marginRight: theme.spacing()
    })
  };
};

var __defProp$29 = Object.defineProperty;
var __getOwnPropSymbols$20 = Object.getOwnPropertySymbols;
var __hasOwnProp$20 = Object.prototype.hasOwnProperty;
var __propIsEnum$20 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$29 = (obj, key, value) => key in obj ? __defProp$29(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1$ = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$20.call(b, prop))
      __defNormalProp$29(a, prop, b[prop]);
  if (__getOwnPropSymbols$20)
    for (var prop of __getOwnPropSymbols$20(b)) {
      if (__propIsEnum$20.call(b, prop))
        __defNormalProp$29(a, prop, b[prop]);
    }
  return a;
};
var __objRest$S = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$20.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$20)
    for (var prop of __getOwnPropSymbols$20(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$20.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Label$1 = (_a) => {
  var _b = _a, { children, description, className, category } = _b, labelProps = __objRest$S(_b, ["children", "description", "className", "category"]);
  const styles = useStyles2(getLabelStyles$3);
  const categories = category == null ? void 0 : category.map((c, i) => {
    return /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.categories, key: `${c}/${i}` }, /* @__PURE__ */ React__default["default"].createElement("span", null, c), /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-right", className: styles.chevron }));
  });
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.label, className) }, /* @__PURE__ */ React__default["default"].createElement("label", __spreadValues$1$({}, labelProps), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.labelContent }, categories, children), description && /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.description }, description)));
};
const getLabelStyles$3 = (theme) => ({
  label: css.css({
    label: "Label",
    fontSize: theme.typography.size.sm,
    fontWeight: theme.typography.fontWeightMedium,
    lineHeight: 1.25,
    marginBottom: theme.spacing(0.5),
    color: theme.colors.text.primary,
    maxWidth: "480px"
  }),
  labelContent: css.css({
    display: "flex",
    alignItems: "center"
  }),
  description: css.css({
    label: "Label-description",
    color: theme.colors.text.secondary,
    fontSize: theme.typography.size.sm,
    fontWeight: theme.typography.fontWeightRegular,
    marginTop: theme.spacing(0.25),
    display: "block"
  }),
  categories: css.css({
    label: "Label-categories",
    display: "inline-flex",
    alignItems: "center"
  }),
  chevron: css.css({
    margin: theme.spacing(0, 0.25)
  })
});

var __defProp$28 = Object.defineProperty;
var __getOwnPropSymbols$1$ = Object.getOwnPropertySymbols;
var __hasOwnProp$1$ = Object.prototype.hasOwnProperty;
var __propIsEnum$1$ = Object.prototype.propertyIsEnumerable;
var __defNormalProp$28 = (obj, key, value) => key in obj ? __defProp$28(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1_ = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1$.call(b, prop))
      __defNormalProp$28(a, prop, b[prop]);
  if (__getOwnPropSymbols$1$)
    for (var prop of __getOwnPropSymbols$1$(b)) {
      if (__propIsEnum$1$.call(b, prop))
        __defNormalProp$28(a, prop, b[prop]);
    }
  return a;
};
var __objRest$R = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1$.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1$)
    for (var prop of __getOwnPropSymbols$1$(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1$.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Field = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, {
      label,
      description,
      horizontal,
      invalid,
      loading,
      disabled,
      required,
      error,
      children,
      className,
      validationMessageHorizontalOverflow,
      htmlFor
    } = _b, otherProps = __objRest$R(_b, [
      "label",
      "description",
      "horizontal",
      "invalid",
      "loading",
      "disabled",
      "required",
      "error",
      "children",
      "className",
      "validationMessageHorizontalOverflow",
      "htmlFor"
    ]);
    const styles = useStyles2(getFieldStyles);
    const inputId = htmlFor != null ? htmlFor : getChildId(children);
    const labelElement = typeof label === "string" ? /* @__PURE__ */ React__default["default"].createElement(Label$1, { htmlFor: inputId, description }, `${label}${required ? " *" : ""}`) : label;
    const childProps = deleteUndefinedProps({ invalid, disabled, loading });
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1_({ className: css.cx(styles.field, horizontal && styles.fieldHorizontal, className) }, otherProps), labelElement, /* @__PURE__ */ React__default["default"].createElement("div", null, /* @__PURE__ */ React__default["default"].createElement("div", { ref }, React__default["default"].cloneElement(children, childProps)), invalid && error && !horizontal && /* @__PURE__ */ React__default["default"].createElement(
      "div",
      {
        className: css.cx(styles.fieldValidationWrapper, {
          [styles.validationMessageHorizontalOverflow]: !!validationMessageHorizontalOverflow
        })
      },
      /* @__PURE__ */ React__default["default"].createElement(FieldValidationMessage, null, error)
    )), invalid && error && horizontal && /* @__PURE__ */ React__default["default"].createElement(
      "div",
      {
        className: css.cx(styles.fieldValidationWrapper, styles.fieldValidationWrapperHorizontal, {
          [styles.validationMessageHorizontalOverflow]: !!validationMessageHorizontalOverflow
        })
      },
      /* @__PURE__ */ React__default["default"].createElement(FieldValidationMessage, null, error)
    ));
  }
);
Field.displayName = "Field";
function deleteUndefinedProps(obj) {
  for (const key in obj) {
    if (obj[key] === void 0) {
      delete obj[key];
    }
  }
  return obj;
}
const getFieldStyles = (theme) => ({
  field: css.css({
    display: "flex",
    flexDirection: "column",
    marginBottom: theme.spacing(2)
  }),
  fieldHorizontal: css.css({
    flexDirection: "row",
    justifyContent: "space-between",
    flexWrap: "wrap"
  }),
  fieldValidationWrapper: css.css({
    marginTop: theme.spacing(0.5)
  }),
  fieldValidationWrapperHorizontal: css.css({
    flex: "1 1 100%"
  }),
  validationMessageHorizontalOverflow: css.css({
    width: 0,
    overflowX: "visible",
    "& > *": {
      whiteSpace: "nowrap"
    }
  })
});

const RadioButton = React__default["default"].forwardRef(
  ({
    children,
    active = false,
    disabled = false,
    size = "md",
    onChange,
    onClick,
    id,
    name = void 0,
    description,
    fullWidth,
    "aria-label": ariaLabel
  }, ref) => {
    const styles = useStyles2(getRadioButtonStyles, size, fullWidth);
    const inputRadioButton = /* @__PURE__ */ React__default["default"].createElement(
      "input",
      {
        type: "radio",
        className: styles.radio,
        onChange,
        onClick,
        disabled,
        id,
        checked: active,
        name,
        "aria-label": ariaLabel,
        ref
      }
    );
    return description ? /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.radioOption, "data-testid": e2eSelectors.selectors.components.RadioButton.container }, /* @__PURE__ */ React__default["default"].createElement(Tooltip, { content: description, placement: "bottom" }, inputRadioButton), /* @__PURE__ */ React__default["default"].createElement("label", { className: styles.radioLabel, htmlFor: id, title: description || ariaLabel }, children)) : /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.radioOption, "data-testid": e2eSelectors.selectors.components.RadioButton.container }, inputRadioButton, /* @__PURE__ */ React__default["default"].createElement("label", { className: styles.radioLabel, htmlFor: id, title: description || ariaLabel }, children));
  }
);
RadioButton.displayName = "RadioButton";
const getRadioButtonStyles = (theme, size, fullWidth) => {
  const { fontSize, height, padding } = getPropertiesForButtonSize(size, theme);
  const textColor = theme.colors.text.secondary;
  const textColorHover = theme.colors.text.primary;
  const labelHeight = height * theme.spacing.gridSize - 4 - 2;
  return {
    radioOption: css.css({
      display: "flex",
      justifyContent: "space-between",
      position: "relative",
      flex: fullWidth ? `1 0 0` : "none",
      textAlign: "center"
    }),
    radio: css.css({
      position: "absolute",
      opacity: 0,
      zIndex: 2,
      width: "100% !important",
      height: "100%",
      cursor: "pointer",
      "&:checked + label": {
        color: theme.colors.text.primary,
        fontWeight: theme.typography.fontWeightMedium,
        background: theme.colors.action.selected,
        zIndex: 1
      },
      "&:focus + label, &:focus-visible + label": getFocusStyles(theme),
      "&:focus:not(:focus-visible) + label": getMouseFocusStyles(),
      "&:disabled + label": {
        color: theme.colors.text.disabled,
        cursor: "not-allowed"
      }
    }),
    radioLabel: css.css({
      display: "flex",
      alignItems: "center",
      justifyContent: "center",
      fontSize,
      height: `${labelHeight}px`,
      // Deduct border from line-height for perfect vertical centering on windows and linux
      lineHeight: `${labelHeight}px`,
      color: textColor,
      padding: theme.spacing(0, padding),
      borderRadius: theme.shape.radius.default,
      background: theme.colors.background.primary,
      cursor: "pointer",
      userSelect: "none",
      whiteSpace: "nowrap",
      flexGrow: 1,
      "&:hover": {
        color: textColorHover
      }
    })
  };
};

function RadioButtonGroup({
  options,
  value,
  onChange,
  onClick,
  disabled,
  disabledOptions,
  size = "md",
  id,
  className,
  fullWidth = false,
  autoFocus = false,
  "aria-label": ariaLabel,
  invalid = false
}) {
  const handleOnChange = React.useCallback(
    (option) => {
      return () => {
        if (onChange) {
          onChange(option.value);
        }
      };
    },
    [onChange]
  );
  const handleOnClick = React.useCallback(
    (option) => {
      return () => {
        if (onClick) {
          onClick(option.value);
        }
      };
    },
    [onClick]
  );
  const internalId = id != null ? id : lodash.uniqueId("radiogroup-");
  const groupName = React.useRef(internalId);
  const styles = useStyles2(getStyles$1p);
  const activeButtonRef = React.useRef(null);
  React.useEffect(() => {
    if (autoFocus && activeButtonRef.current) {
      activeButtonRef.current.focus();
    }
  }, [autoFocus]);
  return /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      role: "radiogroup",
      "aria-label": ariaLabel,
      className: css.cx(styles.radioGroup, fullWidth && styles.fullWidth, invalid && styles.invalid, className)
    },
    options.map((opt, i) => {
      const isItemDisabled = disabledOptions && opt.value && disabledOptions.includes(opt.value);
      const icon = opt.icon ? data.toIconName(opt.icon) : void 0;
      const hasNonIconPart = Boolean(opt.imgUrl || opt.label || opt.component);
      return /* @__PURE__ */ React__default["default"].createElement(
        RadioButton,
        {
          size,
          disabled: isItemDisabled || disabled,
          active: value === opt.value,
          key: `o.label-${i}`,
          "aria-label": opt.ariaLabel,
          onChange: handleOnChange(opt),
          onClick: handleOnClick(opt),
          id: `option-${opt.value}-${internalId}`,
          name: groupName.current,
          description: opt.description,
          fullWidth,
          ref: value === opt.value ? activeButtonRef : void 0
        },
        icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, className: css.cx(hasNonIconPart && styles.icon) }),
        opt.imgUrl && /* @__PURE__ */ React__default["default"].createElement("img", { src: opt.imgUrl, alt: opt.label, className: styles.img }),
        opt.label,
        " ",
        opt.component ? /* @__PURE__ */ React__default["default"].createElement(opt.component, null) : null
      );
    })
  );
}
RadioButtonGroup.displayName = "RadioButtonGroup";
const getStyles$1p = (theme) => {
  return {
    radioGroup: css.css({
      display: "inline-flex",
      flexDirection: "row",
      flexWrap: "nowrap",
      border: `1px solid ${theme.components.input.borderColor}`,
      borderRadius: theme.shape.radius.default,
      padding: "2px"
    }),
    fullWidth: css.css({
      display: "flex"
    }),
    icon: css.css({
      marginRight: "6px"
    }),
    img: css.css({
      width: theme.spacing(2),
      height: theme.spacing(2),
      marginRight: theme.spacing(1)
    }),
    invalid: css.css({
      border: `1px solid ${theme.colors.error.border}`
    })
  };
};

const TimeZoneGroup = (props) => {
  const { children, label } = props;
  const styles = useStyles2(getStyles$1o);
  if (!label) {
    return /* @__PURE__ */ React__default["default"].createElement("div", null, children);
  }
  return /* @__PURE__ */ React__default["default"].createElement("div", null, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.header }, /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.label }, label)), children);
};
const getStyles$1o = (theme) => {
  return {
    header: css.css({
      padding: "7px 10px",
      width: "100%",
      borderTop: `1px solid ${theme.colors.border.weak}`,
      textTransform: "capitalize"
    }),
    label: css.css({
      fontSize: theme.typography.size.sm,
      color: theme.colors.text.secondary,
      fontWeight: theme.typography.fontWeightMedium
    })
  };
};

const TimeZoneOffset = (props) => {
  const { timestamp, timeZone, className } = props;
  const styles = useStyles2(getStyles$1n);
  if (!lodash.isString(timeZone)) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("span", { className: css.cx(styles.offset, className) }, formatUtcOffset(timestamp, timeZone)));
};
const formatUtcOffset = (timestamp, timeZone) => {
  const offset = data.dateTimeFormat(timestamp, {
    timeZone,
    format: "Z"
  });
  if (offset === "+00:00") {
    return "UTC";
  }
  return `UTC${offset}`;
};
const getStyles$1n = (theme) => {
  const textBase = css.css({
    fontWeight: "normal",
    fontSize: theme.typography.size.sm,
    color: theme.colors.text.secondary,
    whiteSpace: "normal"
  });
  return {
    offset: css.css(textBase, {
      color: theme.colors.text.primary,
      background: theme.colors.background.secondary,
      padding: "2px 5px",
      borderRadius: theme.shape.radius.default,
      marginLeft: "4px"
    })
  };
};

const TimeZoneDescription = ({ info }) => {
  const styles = useStyles2(getStyles$1m);
  const description = useDescription(info);
  if (!info) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.description }, description);
};
const useDescription = (info) => {
  return React.useMemo(() => {
    const parts = [];
    if (!info) {
      return "";
    }
    if (info.name === "Europe/Simferopol") {
      return "Ukraine, EEST";
    }
    if (info.countries.length > 0) {
      const country = info.countries[0];
      parts.push(country.name);
    }
    if (info.abbreviation) {
      parts.push(info.abbreviation);
    }
    return parts.join(", ");
  }, [info]);
};
const getStyles$1m = (theme) => {
  return {
    description: css.css({
      fontWeight: "normal",
      fontSize: theme.typography.size.sm,
      color: theme.colors.text.secondary,
      whiteSpace: "normal",
      textOverflow: "ellipsis"
    })
  };
};

const TimeZoneTitle = ({ title }) => {
  const styles = useStyles2(getStyles$1l);
  if (!title) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.title }, title);
};
const getStyles$1l = (theme) => {
  return {
    title: css.css({
      fontWeight: theme.typography.fontWeightRegular,
      textOverflow: "ellipsis"
    })
  };
};

var __defProp$27 = Object.defineProperty;
var __defProps$1h = Object.defineProperties;
var __getOwnPropDescs$1h = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1_ = Object.getOwnPropertySymbols;
var __hasOwnProp$1_ = Object.prototype.hasOwnProperty;
var __propIsEnum$1_ = Object.prototype.propertyIsEnumerable;
var __defNormalProp$27 = (obj, key, value) => key in obj ? __defProp$27(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1Z = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1_.call(b, prop))
      __defNormalProp$27(a, prop, b[prop]);
  if (__getOwnPropSymbols$1_)
    for (var prop of __getOwnPropSymbols$1_(b)) {
      if (__propIsEnum$1_.call(b, prop))
        __defNormalProp$27(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1h = (a, b) => __defProps$1h(a, __getOwnPropDescs$1h(b));
const offsetClassName = "tz-utc-offset";
const WideTimeZoneOption = (props) => {
  const { children, innerProps, innerRef, data: data$1, isSelected, isFocused } = props;
  const styles = useStyles2(getStyles$1k);
  const timestamp = Date.now();
  const containerStyles = css.cx(styles.container, isFocused && styles.containerFocused);
  if (!lodash.isString(data$1.value)) {
    return null;
  }
  const timeZoneInfo = data.getTimeZoneInfo(data$1.value, timestamp);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1h(__spreadValues$1Z({ className: containerStyles }, innerProps), { ref: innerRef, "aria-label": "Select option" }), /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.leftColumn, styles.row) }, /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.leftColumn, styles.wideRow) }, /* @__PURE__ */ React__default["default"].createElement(TimeZoneTitle, { title: children }), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.spacer }), /* @__PURE__ */ React__default["default"].createElement(TimeZoneDescription, { info: timeZoneInfo })), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.rightColumn }, /* @__PURE__ */ React__default["default"].createElement(
    TimeZoneOffset,
    {
      timeZone: (timeZoneInfo == null ? void 0 : timeZoneInfo.ianaName) || data$1.value,
      timestamp,
      className: offsetClassName
    }
  ), isSelected && /* @__PURE__ */ React__default["default"].createElement("span", null, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "check" })))));
};
const CompactTimeZoneOption = (props) => {
  const { children, innerProps, innerRef, data: data$1, isSelected, isFocused } = props;
  const styles = useStyles2(getStyles$1k);
  const timestamp = Date.now();
  const containerStyles = css.cx(styles.container, isFocused && styles.containerFocused);
  if (!lodash.isString(data$1.value)) {
    return null;
  }
  const timeZoneInfo = data.getTimeZoneInfo(data$1.value, timestamp);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$1h(__spreadValues$1Z({ className: containerStyles }, innerProps), { ref: innerRef, "aria-label": "Select option" }), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.body }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.row }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.leftColumn }, /* @__PURE__ */ React__default["default"].createElement(TimeZoneTitle, { title: children })), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.rightColumn }, isSelected && /* @__PURE__ */ React__default["default"].createElement("span", null, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "check" })))), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.row }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.leftColumn }, /* @__PURE__ */ React__default["default"].createElement(TimeZoneDescription, { info: timeZoneInfo })), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.rightColumn }, /* @__PURE__ */ React__default["default"].createElement(
    TimeZoneOffset,
    {
      timestamp,
      timeZone: (timeZoneInfo == null ? void 0 : timeZoneInfo.ianaName) || data$1.value,
      className: offsetClassName
    }
  )))));
};
const getStyles$1k = (theme) => ({
  container: css.css({
    display: "flex",
    alignItems: "center",
    flexDirection: "row",
    flexShrink: 0,
    whiteSpace: "nowrap",
    cursor: "pointer",
    padding: "6px 8px 4px",
    "&:hover": {
      background: theme.colors.action.hover
    }
  }),
  containerFocused: css.css({
    background: theme.colors.action.hover
  }),
  body: css.css({
    display: "flex",
    fontWeight: theme.typography.fontWeightMedium,
    flexDirection: "column",
    flexGrow: 1
  }),
  row: css.css({
    display: "flex",
    flexDirection: "row"
  }),
  leftColumn: css.css({
    flexGrow: 1,
    textOverflow: "ellipsis"
  }),
  rightColumn: css.css({
    justifyContent: "flex-end",
    alignItems: "center"
  }),
  wideRow: css.css({
    display: "flex",
    flexDirection: "row",
    alignItems: "baseline"
  }),
  spacer: css.css({
    marginLeft: "6px"
  })
});

const TimeZonePicker = (props) => {
  const {
    onChange,
    width,
    autoFocus = false,
    onBlur,
    value,
    includeInternal = false,
    disabled = false,
    inputId,
    menuShouldPortal = true,
    openMenuOnFocus = true
  } = props;
  const groupedTimeZones = useTimeZones(includeInternal);
  const selected = useSelectedTimeZone(groupedTimeZones, value);
  const filterBySearchIndex = useFilterBySearchIndex();
  const TimeZoneOption = width && width <= 45 ? CompactTimeZoneOption : WideTimeZoneOption;
  const onChangeTz = React.useCallback(
    (selectable) => {
      if (!selectable || !lodash.isString(selectable.value)) {
        return onChange(value);
      }
      onChange(selectable.value);
    },
    [onChange, value]
  );
  return /* @__PURE__ */ React__default["default"].createElement(
    Select,
    {
      inputId,
      value: selected,
      placeholder: t("time-picker.zone.select-search-input", "Type to search (country, city, abbreviation)"),
      autoFocus,
      menuShouldPortal,
      openMenuOnFocus,
      width,
      filterOption: filterBySearchIndex,
      options: groupedTimeZones,
      onChange: onChangeTz,
      onBlur,
      components: { Option: TimeZoneOption, Group: TimeZoneGroup },
      disabled,
      "aria-label": t("time-picker.zone.select-aria-label", "Time zone picker")
    }
  );
};
const useTimeZones = (includeInternal) => {
  const now = Date.now();
  const timeZoneGroups = data.getTimeZoneGroups(includeInternal).map((group) => {
    const options = group.zones.reduce((options2, zone) => {
      const info = data.getTimeZoneInfo(zone, now);
      if (!info) {
        return options2;
      }
      options2.push({
        label: info.name,
        value: info.zone,
        searchIndex: getSearchIndex(info, now)
      });
      return options2;
    }, []);
    return {
      label: group.name,
      options
    };
  });
  return timeZoneGroups;
};
const useSelectedTimeZone = (groups, timeZone) => {
  return React.useMemo(() => {
    if (timeZone === void 0) {
      return void 0;
    }
    const tz = lodash.toLower(timeZone);
    const group = groups.find((group2) => {
      if (!group2.label) {
        return isInternal(tz);
      }
      return tz.startsWith(lodash.toLower(group2.label));
    });
    return group == null ? void 0 : group.options.find((option) => {
      if (lodash.isEmpty(tz)) {
        return option.value === data.InternalTimeZones.default;
      }
      return lodash.toLower(option.value) === tz;
    });
  }, [groups, timeZone]);
};
const isInternal = (timeZone) => {
  switch (timeZone) {
    case data.InternalTimeZones.default:
    case data.InternalTimeZones.localBrowserTime:
    case data.InternalTimeZones.utc:
      return true;
    default:
      return false;
  }
};
const useFilterBySearchIndex = () => {
  return React.useCallback((option, searchQuery) => {
    if (!searchQuery || !option.data || !option.data.searchIndex) {
      return true;
    }
    return option.data.searchIndex.indexOf(lodash.toLower(searchQuery)) > -1;
  }, []);
};
const getSearchIndex = (info, timestamp) => {
  const parts = [
    lodash.toLower(info.name),
    lodash.toLower(info.abbreviation),
    lodash.toLower(formatUtcOffset(timestamp, info.zone))
  ];
  for (const country of info.countries) {
    parts.push(lodash.toLower(country.name));
    parts.push(lodash.toLower(country.code));
  }
  return parts.join("|");
};

const quickOptions = [
  { from: "now-5m", to: "now", display: "Last 5 minutes" },
  { from: "now-15m", to: "now", display: "Last 15 minutes" },
  { from: "now-30m", to: "now", display: "Last 30 minutes" },
  { from: "now-1h", to: "now", display: "Last 1 hour" },
  { from: "now-3h", to: "now", display: "Last 3 hours" },
  { from: "now-6h", to: "now", display: "Last 6 hours" },
  { from: "now-12h", to: "now", display: "Last 12 hours" },
  { from: "now-24h", to: "now", display: "Last 24 hours" },
  { from: "now-2d", to: "now", display: "Last 2 days" },
  { from: "now-7d", to: "now", display: "Last 7 days" },
  { from: "now-30d", to: "now", display: "Last 30 days" },
  { from: "now-90d", to: "now", display: "Last 90 days" },
  { from: "now-6M", to: "now", display: "Last 6 months" },
  { from: "now-1y", to: "now", display: "Last 1 year" },
  { from: "now-2y", to: "now", display: "Last 2 years" },
  { from: "now-5y", to: "now", display: "Last 5 years" },
  { from: "now-1d/d", to: "now-1d/d", display: "Yesterday" },
  { from: "now-2d/d", to: "now-2d/d", display: "Day before yesterday" },
  { from: "now-7d/d", to: "now-7d/d", display: "This day last week" },
  { from: "now-1w/w", to: "now-1w/w", display: "Previous week" },
  { from: "now-1M/M", to: "now-1M/M", display: "Previous month" },
  { from: "now-1Q/fQ", to: "now-1Q/fQ", display: "Previous fiscal quarter" },
  { from: "now-1y/y", to: "now-1y/y", display: "Previous year" },
  { from: "now-1y/fy", to: "now-1y/fy", display: "Previous fiscal year" },
  { from: "now/d", to: "now/d", display: "Today" },
  { from: "now/d", to: "now", display: "Today so far" },
  { from: "now/w", to: "now/w", display: "This week" },
  { from: "now/w", to: "now", display: "This week so far" },
  { from: "now/M", to: "now/M", display: "This month" },
  { from: "now/M", to: "now", display: "This month so far" },
  { from: "now/y", to: "now/y", display: "This year" },
  { from: "now/y", to: "now", display: "This year so far" },
  { from: "now/fQ", to: "now", display: "This fiscal quarter so far" },
  { from: "now/fQ", to: "now/fQ", display: "This fiscal quarter" },
  { from: "now/fy", to: "now", display: "This fiscal year so far" },
  { from: "now/fy", to: "now/fy", display: "This fiscal year" }
];
const monthOptions = [
  { label: "January", value: 0 },
  { label: "February", value: 1 },
  { label: "March", value: 2 },
  { label: "April", value: 3 },
  { label: "May", value: 4 },
  { label: "June", value: 5 },
  { label: "July", value: 6 },
  { label: "August", value: 7 },
  { label: "September", value: 8 },
  { label: "October", value: 9 },
  { label: "November", value: 10 },
  { label: "December", value: 11 }
];

const TimePickerFooter = (props) => {
  const {
    timeZone,
    fiscalYearStartMonth,
    timestamp = Date.now(),
    onChangeTimeZone,
    onChangeFiscalYearStartMonth
  } = props;
  const [isEditing, setEditing] = React.useState(false);
  const [editMode, setEditMode] = React.useState("tz");
  const onToggleChangeTimeSettings = React.useCallback(
    (event) => {
      if (event) {
        event.stopPropagation();
      }
      setEditing(!isEditing);
    },
    [isEditing, setEditing]
  );
  const style = useStyles2(getStyle);
  if (!lodash.isString(timeZone)) {
    return null;
  }
  const info = data.getTimeZoneInfo(timeZone, timestamp);
  if (!info) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement("div", null, /* @__PURE__ */ React__default["default"].createElement(
    "section",
    {
      "aria-label": t("time-picker.footer.time-zone-selection", "Time zone selection"),
      className: style.container
    },
    /* @__PURE__ */ React__default["default"].createElement("div", { className: style.timeZoneContainer }, /* @__PURE__ */ React__default["default"].createElement("div", { className: style.timeZone }, /* @__PURE__ */ React__default["default"].createElement(TimeZoneTitle, { title: info.name }), /* @__PURE__ */ React__default["default"].createElement("div", { className: style.spacer }), /* @__PURE__ */ React__default["default"].createElement(TimeZoneDescription, { info })), /* @__PURE__ */ React__default["default"].createElement(TimeZoneOffset, { timeZone, timestamp })),
    /* @__PURE__ */ React__default["default"].createElement("div", { className: style.spacer }),
    /* @__PURE__ */ React__default["default"].createElement(Button, { variant: "secondary", onClick: onToggleChangeTimeSettings, size: "sm" }, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "time-picker.footer.change-settings-button" }, "Change time settings"))
  ), isEditing ? /* @__PURE__ */ React__default["default"].createElement("div", { className: style.editContainer }, /* @__PURE__ */ React__default["default"].createElement("div", null, /* @__PURE__ */ React__default["default"].createElement(
    RadioButtonGroup,
    {
      value: editMode,
      options: [
        { label: t("time-picker.footer.time-zone-option", "Time zone"), value: "tz" },
        { label: t("time-picker.footer.fiscal-year-option", "Fiscal year"), value: "fy" }
      ],
      onChange: setEditMode
    }
  )), editMode === "tz" ? /* @__PURE__ */ React__default["default"].createElement(
    "section",
    {
      "data-testid": e2eSelectors.selectors.components.TimeZonePicker.containerV2,
      className: css.cx(style.timeZoneContainer, style.timeSettingContainer)
    },
    /* @__PURE__ */ React__default["default"].createElement(
      TimeZonePicker,
      {
        includeInternal: true,
        onChange: (timeZone2) => {
          onToggleChangeTimeSettings();
          if (lodash.isString(timeZone2)) {
            onChangeTimeZone(timeZone2);
          }
        },
        onBlur: onToggleChangeTimeSettings,
        menuShouldPortal: false
      }
    )
  ) : /* @__PURE__ */ React__default["default"].createElement(
    "section",
    {
      "data-testid": e2eSelectors.selectors.components.TimeZonePicker.containerV2,
      className: css.cx(style.timeZoneContainer, style.timeSettingContainer)
    },
    /* @__PURE__ */ React__default["default"].createElement(
      Field,
      {
        className: style.fiscalYearField,
        label: t("time-picker.footer.fiscal-year-start", "Fiscal year start month")
      },
      /* @__PURE__ */ React__default["default"].createElement(
        Select,
        {
          value: fiscalYearStartMonth,
          menuShouldPortal: false,
          options: monthOptions,
          onChange: (value) => {
            var _a;
            if (onChangeFiscalYearStartMonth) {
              onChangeFiscalYearStartMonth((_a = value.value) != null ? _a : 0);
            }
          }
        }
      )
    )
  )) : null);
};
const getStyle = (theme) => ({
  container: css.css({
    borderTop: `1px solid ${theme.colors.border.weak}`,
    padding: "11px",
    display: "flex",
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center"
  }),
  editContainer: css.css({
    borderTop: `1px solid ${theme.colors.border.weak}`,
    padding: "11px",
    justifyContent: "space-between",
    alignItems: "center"
  }),
  spacer: css.css({
    marginLeft: "7px"
  }),
  timeSettingContainer: css.css({
    paddingTop: theme.spacing(1)
  }),
  fiscalYearField: css.css({
    marginBottom: 0
  }),
  timeZoneContainer: css.css({
    display: "flex",
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center",
    flexGrow: 1
  }),
  timeZone: css.css({
    display: "flex",
    flexDirection: "row",
    alignItems: "baseline",
    flexGrow: 1
  })
});

const getStyles$1j = (theme) => {
  return {
    text: css.css({
      fontSize: theme.typography.size.md,
      fontWeight: theme.typography.fontWeightMedium,
      color: theme.colors.text.primary,
      margin: 0,
      display: "flex"
    })
  };
};
const TimePickerTitle = React.memo(({ children }) => {
  const styles = useStyles2(getStyles$1j);
  return /* @__PURE__ */ React__default["default"].createElement("h3", { className: styles.text }, children);
});
TimePickerTitle.displayName = "TimePickerTitle";

function isValid(value, roundUp, timeZone) {
  if (data.isDateTime(value)) {
    return value.isValid();
  }
  if (data.dateMath.isMathString(value)) {
    return data.dateMath.isValid(value);
  }
  const parsed = data.dateTimeParse(value, { roundUp, timeZone });
  return parsed.isValid();
}
function isValidTimeRange(range) {
  return data.dateMath.isValid(range.from) && data.dateMath.isValid(range.to);
}

function Body$1({ onChange, from, to, timeZone }) {
  const value = inputToValue(from, to, /* @__PURE__ */ new Date(), timeZone);
  const onCalendarChange = useOnCalendarChange(onChange, timeZone);
  const styles = useStyles2(getBodyStyles);
  return /* @__PURE__ */ React__default["default"].createElement(
    Calendar__default["default"],
    {
      selectRange: true,
      next2Label: null,
      prev2Label: null,
      className: styles.body,
      tileClassName: styles.title,
      value,
      nextLabel: /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-right" }),
      prevLabel: /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-left" }),
      onChange: onCalendarChange,
      locale: "en"
    }
  );
}
Body$1.displayName = "Body";
function inputToValue(from, to, invalidDateDefault = /* @__PURE__ */ new Date(), timezone) {
  let fromAsDate = from.isValid() ? from.toDate() : invalidDateDefault;
  let toAsDate = to.isValid() ? to.toDate() : invalidDateDefault;
  if (timezone) {
    [fromAsDate, toAsDate] = adjustDateForReactCalendar(fromAsDate, toAsDate, timezone);
  }
  if (fromAsDate > toAsDate) {
    return [toAsDate, fromAsDate];
  }
  return [fromAsDate, toAsDate];
}
function adjustDateForReactCalendar(from, to, timeZone) {
  const zone = data.getZone(timeZone);
  if (!zone) {
    return [from, to];
  }
  const timezonePrefFromOffset = zone.utcOffset(from.getTime());
  const timezonePrefToOffset = zone.utcOffset(to.getTime());
  const localFromOffset = from.getTimezoneOffset();
  const localToOffset = to.getTimezoneOffset();
  const fromDiff = timezonePrefFromOffset - localFromOffset;
  const toDiff = timezonePrefToOffset - localToOffset;
  const newFromDate = new Date(from.getTime() - fromDiff * 1e3 * 60);
  const newToDate = new Date(to.getTime() - toDiff * 1e3 * 60);
  return [newFromDate, newToDate];
}
function useOnCalendarChange(onChange, timeZone) {
  return React.useCallback(
    (value) => {
      if (!Array.isArray(value)) {
        return console.error("onCalendarChange: should be run in selectRange={true}");
      }
      if (value[0] && value[1]) {
        const from = data.dateTimeParse(dateInfo(value[0]), { timeZone });
        const to = data.dateTimeParse(dateInfo(value[1]), { timeZone });
        onChange(from, to);
      }
    },
    [onChange, timeZone]
  );
}
function dateInfo(date) {
  return [date.getFullYear(), date.getMonth(), date.getDate(), date.getHours(), date.getMinutes(), date.getSeconds()];
}
const getBodyStyles = (theme) => {
  const hasActiveSelector = `.react-calendar__tile--hasActive:not(.react-calendar__tile--range)`;
  return {
    title: css.css({
      color: theme.colors.text.primary,
      backgroundColor: theme.colors.background.primary,
      fontSize: theme.typography.size.md,
      border: "1px solid transparent",
      "&:hover": {
        position: "relative"
      },
      "&:disabled": {
        color: theme.colors.action.disabledText
      }
    }),
    body: css.css({
      zIndex: theme.zIndex.modal,
      backgroundColor: theme.colors.background.primary,
      width: "268px",
      ".react-calendar__navigation": {
        display: "flex"
      },
      ".react-calendar__navigation__label, .react-calendar__navigation__arrow, .react-calendar__navigation": {
        paddingTop: "4px",
        backgroundColor: "inherit",
        color: theme.colors.text.primary,
        border: 0,
        fontWeight: theme.typography.fontWeightMedium
      },
      ".react-calendar__month-view__weekdays": {
        backgroundColor: "inherit",
        textAlign: "center",
        color: theme.colors.primary.text,
        abbr: {
          border: 0,
          textDecoration: "none",
          cursor: "default",
          display: "block",
          padding: "4px 0 4px 0"
        }
      },
      ".react-calendar__month-view__days": {
        backgroundColor: "inherit"
      },
      ".react-calendar__tile, .react-calendar__tile--now": {
        marginBottom: "4px",
        backgroundColor: "inherit",
        height: "26px"
      },
      ".react-calendar__navigation__label, .react-calendar__navigation > button:focus, .time-picker-calendar-tile:focus": {
        outline: 0
      },
      [`${hasActiveSelector}, .react-calendar__tile--active, .react-calendar__tile--active:hover`]: {
        color: theme.colors.primary.contrastText,
        fontWeight: theme.typography.fontWeightMedium,
        background: theme.colors.primary.main,
        boxShadow: "none",
        border: "0px"
      },
      ".react-calendar__tile--rangeEnd, .react-calendar__tile--rangeStart": {
        padding: 0,
        border: "0px",
        color: theme.colors.primary.contrastText,
        fontWeight: theme.typography.fontWeightMedium,
        background: theme.colors.primary.main,
        abbr: {
          backgroundColor: theme.colors.primary.main,
          borderRadius: "100px",
          display: "block",
          paddingTop: "2px",
          height: "26px"
        }
      },
      [`${hasActiveSelector}, .react-calendar__tile--rangeStart`]: {
        borderTopLeftRadius: "20px",
        borderBottomLeftRadius: "20px"
      },
      [`${hasActiveSelector}, .react-calendar__tile--rangeEnd`]: {
        borderTopRightRadius: "20px",
        borderBottomRightRadius: "20px"
      }
    })
  };
};

function Footer({ onClose, onApply }) {
  return /* @__PURE__ */ React__default["default"].createElement(Stack, { gap: 2, justifyContent: "space-between" }, /* @__PURE__ */ React__default["default"].createElement(Button, { variant: "secondary", onClick: onClose }, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "time-picker.calendar.cancel-button" }, "Cancel")), /* @__PURE__ */ React__default["default"].createElement(Button, { onClick: onApply }, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "time-picker.calendar.apply-button" }, "Apply time range")));
}
Footer.displayName = "Footer";

function Header({ onClose }) {
  return /* @__PURE__ */ React__default["default"].createElement(Stack, { justifyContent: "space-between" }, /* @__PURE__ */ React__default["default"].createElement(TimePickerTitle, null, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "time-picker.calendar.select-time" }, "Select a time range")), /* @__PURE__ */ React__default["default"].createElement(
    IconButton,
    {
      "data-testid": e2eSelectors.selectors.components.TimePicker.calendar.closeButton,
      tooltip: t(`time-picker.calendar.close`, "Close calendar"),
      name: "times",
      variant: "secondary",
      onClick: onClose
    }
  ));
}
Header.displayName = "Header";

var __defProp$26 = Object.defineProperty;
var __defProps$1g = Object.defineProperties;
var __getOwnPropDescs$1g = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1Z = Object.getOwnPropertySymbols;
var __hasOwnProp$1Z = Object.prototype.hasOwnProperty;
var __propIsEnum$1Z = Object.prototype.propertyIsEnumerable;
var __defNormalProp$26 = (obj, key, value) => key in obj ? __defProp$26(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1Y = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1Z.call(b, prop))
      __defNormalProp$26(a, prop, b[prop]);
  if (__getOwnPropSymbols$1Z)
    for (var prop of __getOwnPropSymbols$1Z(b)) {
      if (__propIsEnum$1Z.call(b, prop))
        __defNormalProp$26(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1g = (a, b) => __defProps$1g(a, __getOwnPropDescs$1g(b));
const getStyles$1i = (theme, isReversed = false) => {
  return {
    container: css.css({
      top: 0,
      position: "absolute",
      [`${isReversed ? "left" : "right"}`]: "546px"
      // lmao
    }),
    modalContainer: css.css({
      label: "modalContainer",
      margin: "0 auto"
    }),
    calendar: css.css({
      display: "flex",
      flexDirection: "column",
      gap: theme.spacing(1),
      padding: theme.spacing(1),
      label: "calendar",
      boxShadow: theme.shadows.z3,
      backgroundColor: theme.colors.background.primary,
      border: `1px solid ${theme.colors.border.weak}`,
      borderRadius: theme.shape.radius.default
    }),
    modal: css.css({
      label: "modal",
      boxShadow: theme.shadows.z3,
      left: "50%",
      position: "fixed",
      top: "50%",
      transform: "translate(-50%, -50%)",
      zIndex: theme.zIndex.modal
    })
  };
};
function TimePickerCalendar(props) {
  const theme = useTheme2();
  const { modalBackdrop } = useStyles2(getModalStyles);
  const styles = getStyles$1i(theme, props.isReversed);
  const { isOpen, isFullscreen: isFullscreenProp, onClose } = props;
  const ref = React__default["default"].createRef();
  const { dialogProps } = dialog.useDialog(
    {
      "aria-label": e2eSelectors.selectors.components.TimePicker.calendar.label
    },
    ref
  );
  const { overlayProps } = overlays.useOverlay(
    {
      isDismissable: true,
      isOpen,
      onClose
    },
    ref
  );
  const showInModal = !isFullscreenProp;
  if (!isOpen) {
    return null;
  }
  const calendar = /* @__PURE__ */ React__default["default"].createElement(
    "section",
    __spreadProps$1g(__spreadValues$1Y(__spreadValues$1Y({
      className: styles.calendar,
      ref
    }, overlayProps), dialogProps), {
      "data-testid": e2eSelectors.selectors.components.TimePicker.calendar.label
    }),
    /* @__PURE__ */ React__default["default"].createElement(Header, __spreadValues$1Y({}, props)),
    /* @__PURE__ */ React__default["default"].createElement(Body$1, __spreadValues$1Y({}, props)),
    showInModal && /* @__PURE__ */ React__default["default"].createElement(Footer, __spreadValues$1Y({}, props))
  );
  if (!showInModal) {
    return /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { contain: true, restoreFocus: true, autoFocus: true }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.container }, calendar));
  }
  return /* @__PURE__ */ React__default["default"].createElement(overlays.OverlayContainer, null, /* @__PURE__ */ React__default["default"].createElement("div", { className: modalBackdrop }), /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { contain: true, autoFocus: true, restoreFocus: true }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.modal }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.modalContainer }, calendar))));
}
var TimePickerCalendar$1 = React.memo(TimePickerCalendar);
TimePickerCalendar.displayName = "TimePickerCalendar";

const ERROR_MESSAGES = {
  default: () => t("time-picker.range-content.default-error", 'Please enter a past date or "now"'),
  range: () => t("time-picker.range-content.range-error", `"From" can't be after "To"`)
};
const TimeRangeContent = (props) => {
  const {
    value,
    isFullscreen = false,
    timeZone,
    onApply: onApplyFromProps,
    isReversed,
    fiscalYearStartMonth,
    onError
  } = props;
  const [fromValue, toValue] = valueToState(value.raw.from, value.raw.to, timeZone);
  const style = useStyles2(getStyles$1h);
  const [from, setFrom] = React.useState(fromValue);
  const [to, setTo] = React.useState(toValue);
  const [isOpen, setOpen] = React.useState(false);
  const fromFieldId = React.useId();
  const toFieldId = React.useId();
  React.useEffect(() => {
    const [fromValue2, toValue2] = valueToState(value.raw.from, value.raw.to, timeZone);
    setFrom(fromValue2);
    setTo(toValue2);
  }, [value.raw.from, value.raw.to, timeZone]);
  const onOpen = React.useCallback(
    (event) => {
      event.preventDefault();
      setOpen(true);
    },
    [setOpen]
  );
  const onApply = React.useCallback(() => {
    if (to.invalid || from.invalid) {
      return;
    }
    const raw = { from: from.value, to: to.value };
    const timeRange = data.rangeUtil.convertRawToRange(raw, timeZone, fiscalYearStartMonth);
    onApplyFromProps(timeRange);
  }, [from.invalid, from.value, onApplyFromProps, timeZone, to.invalid, to.value, fiscalYearStartMonth]);
  const onChange = React.useCallback(
    (from2, to2) => {
      const [fromValue2, toValue2] = valueToState(from2, to2, timeZone);
      setFrom(fromValue2);
      setTo(toValue2);
    },
    [timeZone]
  );
  const submitOnEnter = (event) => {
    if (event.key === "Enter") {
      onApply();
    }
  };
  const onCopy = () => {
    const raw = { from: from.value, to: to.value };
    navigator.clipboard.writeText(JSON.stringify(raw));
  };
  const onPaste = async () => {
    const raw = await navigator.clipboard.readText();
    let range;
    try {
      range = JSON.parse(raw);
    } catch (error) {
      if (onError) {
        onError(raw);
      }
      return;
    }
    const [fromValue2, toValue2] = valueToState(range.from, range.to, timeZone);
    setFrom(fromValue2);
    setTo(toValue2);
  };
  const fiscalYear = data.rangeUtil.convertRawToRange({ from: "now/fy", to: "now/fy" }, timeZone, fiscalYearStartMonth);
  const fiscalYearMessage = t("time-picker.range-content.fiscal-year", "Fiscal year");
  const fyTooltip = /* @__PURE__ */ React__default["default"].createElement("div", { className: style.tooltip }, data.rangeUtil.isFiscal(value) ? /* @__PURE__ */ React__default["default"].createElement(
    Tooltip,
    {
      content: `${fiscalYearMessage}: ${fiscalYear.from.format("MMM-DD")} - ${fiscalYear.to.format("MMM-DD")}`
    },
    /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "info-circle" })
  ) : null);
  const icon = /* @__PURE__ */ React__default["default"].createElement(
    Button,
    {
      "aria-label": t("time-picker.range-content.open-input-calendar", "Open calendar"),
      "data-testid": e2eSelectors.selectors.components.TimePicker.calendar.openButton,
      icon: "calendar-alt",
      variant: "secondary",
      type: "button",
      onClick: onOpen
    }
  );
  return /* @__PURE__ */ React__default["default"].createElement("div", null, /* @__PURE__ */ React__default["default"].createElement("div", { className: style.fieldContainer }, /* @__PURE__ */ React__default["default"].createElement(
    Field,
    {
      label: t("time-picker.range-content.from-input", "From"),
      invalid: from.invalid,
      error: from.errorMessage
    },
    /* @__PURE__ */ React__default["default"].createElement(
      Input,
      {
        id: fromFieldId,
        onClick: (event) => event.stopPropagation(),
        onChange: (event) => onChange(event.currentTarget.value, to.value),
        addonAfter: icon,
        onKeyDown: submitOnEnter,
        "data-testid": e2eSelectors.selectors.components.TimePicker.fromField,
        value: from.value
      }
    )
  ), fyTooltip), /* @__PURE__ */ React__default["default"].createElement("div", { className: style.fieldContainer }, /* @__PURE__ */ React__default["default"].createElement(Field, { label: t("time-picker.range-content.to-input", "To"), invalid: to.invalid, error: to.errorMessage }, /* @__PURE__ */ React__default["default"].createElement(
    Input,
    {
      id: toFieldId,
      onClick: (event) => event.stopPropagation(),
      onChange: (event) => onChange(from.value, event.currentTarget.value),
      addonAfter: icon,
      onKeyDown: submitOnEnter,
      "data-testid": e2eSelectors.selectors.components.TimePicker.toField,
      value: to.value
    }
  )), fyTooltip), /* @__PURE__ */ React__default["default"].createElement("div", { className: style.buttonsContainer }, /* @__PURE__ */ React__default["default"].createElement(
    Button,
    {
      "data-testid": e2eSelectors.selectors.components.TimePicker.copyTimeRange,
      icon: "copy",
      variant: "secondary",
      tooltip: t("time-picker.copy-paste.tooltip-copy", "Copy time range to clipboard"),
      type: "button",
      onClick: onCopy
    }
  ), /* @__PURE__ */ React__default["default"].createElement(
    Button,
    {
      "data-testid": e2eSelectors.selectors.components.TimePicker.pasteTimeRange,
      icon: "clipboard-alt",
      variant: "secondary",
      tooltip: t("time-picker.copy-paste.tooltip-paste", "Paste time range"),
      type: "button",
      onClick: onPaste
    }
  ), /* @__PURE__ */ React__default["default"].createElement(Button, { "data-testid": e2eSelectors.selectors.components.TimePicker.applyTimeRange, type: "button", onClick: onApply }, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "time-picker.range-content.apply-button" }, "Apply time range"))), /* @__PURE__ */ React__default["default"].createElement(
    TimePickerCalendar$1,
    {
      isFullscreen,
      isOpen,
      from: data.dateTimeParse(from.value, { timeZone }),
      to: data.dateTimeParse(to.value, { timeZone }),
      onApply,
      onClose: () => setOpen(false),
      onChange,
      timeZone,
      isReversed
    }
  ));
};
function isRangeInvalid(from, to, timezone) {
  const raw = { from, to };
  const timeRange = data.rangeUtil.convertRawToRange(raw, timezone);
  const valid = timeRange.from.isSame(timeRange.to) || timeRange.from.isBefore(timeRange.to);
  return !valid;
}
function valueToState(rawFrom, rawTo, timeZone) {
  const fromValue = valueAsString(rawFrom, timeZone);
  const toValue = valueAsString(rawTo, timeZone);
  const fromInvalid = !isValid(fromValue, false, timeZone);
  const toInvalid = !isValid(toValue, true, timeZone);
  const rangeInvalid = isRangeInvalid(fromValue, toValue, timeZone) && !toInvalid;
  return [
    {
      value: fromValue,
      invalid: fromInvalid || rangeInvalid,
      errorMessage: rangeInvalid && !fromInvalid ? ERROR_MESSAGES.range() : ERROR_MESSAGES.default()
    },
    { value: toValue, invalid: toInvalid, errorMessage: ERROR_MESSAGES.default() }
  ];
}
function valueAsString(value, timeZone) {
  if (data.isDateTime(value)) {
    return data.dateTimeFormat(value, { timeZone });
  }
  return value;
}
function getStyles$1h(theme) {
  return {
    fieldContainer: css.css({
      display: "flex"
    }),
    buttonsContainer: css.css({
      display: "flex",
      gap: theme.spacing(0.5),
      marginTop: theme.spacing(1)
    }),
    tooltip: css.css({
      paddingLeft: theme.spacing(1),
      paddingTop: theme.spacing(3)
    })
  };
}

const getStyles$1g = (theme) => {
  return {
    container: css.css({
      display: "flex",
      alignItems: "center",
      flexDirection: "row-reverse",
      justifyContent: "space-between"
    }),
    selected: css.css({
      background: theme.colors.action.selected,
      fontWeight: theme.typography.fontWeightMedium
    }),
    radio: css.css({
      opacity: 0,
      width: "0 !important",
      "&:focus-visible + label": getFocusStyles(theme)
    }),
    label: css.css({
      cursor: "pointer",
      flex: 1,
      padding: "7px 9px 7px 9px",
      "&:hover": {
        background: theme.colors.action.hover,
        cursor: "pointer"
      }
    })
  };
};
const TimeRangeOption = React.memo(({ value, onSelect, selected = false, name }) => {
  const styles = useStyles2(getStyles$1g);
  const id = uuid.v4();
  return /* @__PURE__ */ React__default["default"].createElement("li", { className: css.cx(styles.container, selected && styles.selected) }, /* @__PURE__ */ React__default["default"].createElement(
    "input",
    {
      className: styles.radio,
      checked: selected,
      name,
      type: "checkbox",
      id,
      onChange: () => onSelect(value)
    }
  ), /* @__PURE__ */ React__default["default"].createElement("label", { className: styles.label, htmlFor: id }, value.display));
});
TimeRangeOption.displayName = "TimeRangeOption";

var __defProp$25 = Object.defineProperty;
var __getOwnPropSymbols$1Y = Object.getOwnPropertySymbols;
var __hasOwnProp$1Y = Object.prototype.hasOwnProperty;
var __propIsEnum$1Y = Object.prototype.propertyIsEnumerable;
var __defNormalProp$25 = (obj, key, value) => key in obj ? __defProp$25(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1X = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1Y.call(b, prop))
      __defNormalProp$25(a, prop, b[prop]);
  if (__getOwnPropSymbols$1Y)
    for (var prop of __getOwnPropSymbols$1Y(b)) {
      if (__propIsEnum$1Y.call(b, prop))
        __defNormalProp$25(a, prop, b[prop]);
    }
  return a;
};
const TimeRangeList = (props) => {
  const styles = useStyles2(getStyles$1f);
  const { title, options, placeholderEmpty } = props;
  if (typeof placeholderEmpty !== "undefined" && options.length <= 0) {
    return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, placeholderEmpty);
  }
  if (!title) {
    return /* @__PURE__ */ React__default["default"].createElement(Options$1, __spreadValues$1X({}, props));
  }
  return /* @__PURE__ */ React__default["default"].createElement("section", { "aria-label": title }, /* @__PURE__ */ React__default["default"].createElement("fieldset", null, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.title }, /* @__PURE__ */ React__default["default"].createElement(TimePickerTitle, null, title)), /* @__PURE__ */ React__default["default"].createElement(Options$1, __spreadValues$1X({}, props))));
};
const Options$1 = ({ options, value, onChange, title }) => {
  const styles = useStyles2(getOptionsStyles);
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("ul", { "aria-roledescription": t("time-picker.time-range.aria-role", "Time range selection") }, options.map((option, index) => /* @__PURE__ */ React__default["default"].createElement(
    TimeRangeOption,
    {
      key: keyForOption(option, index),
      value: option,
      selected: isEqual(option, value),
      onSelect: onChange,
      name: title != null ? title : t("time-picker.time-range.default-title", "Time ranges")
    }
  ))), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.grow }));
};
function keyForOption(option, index) {
  return `${option.from}-${option.to}-${index}`;
}
function isEqual(x, y) {
  if (!y || !x) {
    return false;
  }
  return y.from === x.from && y.to === x.to;
}
const getStyles$1f = () => ({
  title: css.css({
    display: "flex",
    alignItems: "center",
    justifyContent: "space-between",
    padding: "8px 16px 5px 9px"
  })
});
const getOptionsStyles = () => ({
  grow: css.css({
    flexGrow: 1,
    alignItems: "flex-start"
  })
});

const mapOptionToTimeRange = (option, timeZone) => {
  return data.rangeUtil.convertRawToRange({ from: option.from, to: option.to }, timeZone);
};
const mapRangeToTimeOption = (range, timeZone) => {
  const from = data.dateTimeFormat(range.from, { timeZone });
  const to = data.dateTimeFormat(range.to, { timeZone });
  return {
    from,
    to,
    display: `${from} to ${to}`
  };
};

var __defProp$24 = Object.defineProperty;
var __defProps$1f = Object.defineProperties;
var __getOwnPropDescs$1f = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1X = Object.getOwnPropertySymbols;
var __hasOwnProp$1X = Object.prototype.hasOwnProperty;
var __propIsEnum$1X = Object.prototype.propertyIsEnumerable;
var __defNormalProp$24 = (obj, key, value) => key in obj ? __defProp$24(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1W = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1X.call(b, prop))
      __defNormalProp$24(a, prop, b[prop]);
  if (__getOwnPropSymbols$1X)
    for (var prop of __getOwnPropSymbols$1X(b)) {
      if (__propIsEnum$1X.call(b, prop))
        __defNormalProp$24(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1f = (a, b) => __defProps$1f(a, __getOwnPropDescs$1f(b));
const TimePickerContentWithScreenSize = (props) => {
  const {
    quickOptions = [],
    isReversed,
    isFullscreen,
    hideQuickRanges,
    timeZone,
    fiscalYearStartMonth,
    value,
    onChange,
    history,
    showHistory,
    className,
    hideTimeZone,
    onChangeTimeZone,
    onChangeFiscalYearStartMonth
  } = props;
  const isHistoryEmpty = !(history == null ? void 0 : history.length);
  const isContainerTall = isFullscreen && showHistory || !isFullscreen && (showHistory && !isHistoryEmpty || !hideQuickRanges);
  const styles = useStyles2(getStyles$1e, isReversed, hideQuickRanges, isContainerTall, isFullscreen);
  const historyOptions = mapToHistoryOptions(history, timeZone);
  const timeOption = useTimeOption(value.raw, quickOptions);
  const [searchTerm, setSearchQuery] = React.useState("");
  const filteredQuickOptions = quickOptions.filter((o) => o.display.toLowerCase().includes(searchTerm.toLowerCase()));
  const onChangeTimeOption = (timeOption2) => {
    return onChange(mapOptionToTimeRange(timeOption2));
  };
  return /* @__PURE__ */ React__default["default"].createElement("div", { id: "TimePickerContent", className: css.cx(styles.container, className) }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.body }, (!isFullscreen || !hideQuickRanges) && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.rightSide }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.timeRangeFilter }, /* @__PURE__ */ React__default["default"].createElement(
    FilterInput,
    {
      width: 0,
      value: searchTerm,
      onChange: setSearchQuery,
      placeholder: t("time-picker.content.filter-placeholder", "Search quick ranges")
    }
  )), /* @__PURE__ */ React__default["default"].createElement(CustomScrollbar, null, !isFullscreen && /* @__PURE__ */ React__default["default"].createElement(NarrowScreenForm, __spreadProps$1f(__spreadValues$1W({}, props), { historyOptions })), !hideQuickRanges && /* @__PURE__ */ React__default["default"].createElement(TimeRangeList, { options: filteredQuickOptions, onChange: onChangeTimeOption, value: timeOption }))), isFullscreen && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.leftSide }, /* @__PURE__ */ React__default["default"].createElement(FullScreenForm, __spreadProps$1f(__spreadValues$1W({}, props), { historyOptions })))), !hideTimeZone && isFullscreen && /* @__PURE__ */ React__default["default"].createElement(
    TimePickerFooter,
    {
      timeZone,
      fiscalYearStartMonth,
      onChangeTimeZone,
      onChangeFiscalYearStartMonth
    }
  ));
};
const TimePickerContent = (props) => {
  const { widthOverride } = props;
  const theme = useTheme2();
  const isFullscreen = (widthOverride || window.innerWidth) >= theme.breakpoints.values.lg;
  return /* @__PURE__ */ React__default["default"].createElement(TimePickerContentWithScreenSize, __spreadProps$1f(__spreadValues$1W({}, props), { isFullscreen }));
};
const NarrowScreenForm = (props) => {
  const { value, hideQuickRanges, onChange, timeZone, historyOptions = [], showHistory, onError } = props;
  const styles = useStyles2(getNarrowScreenStyles);
  const isAbsolute = data.isDateTime(value.raw.from) || data.isDateTime(value.raw.to);
  const [collapsedFlag, setCollapsedFlag] = React.useState(!isAbsolute);
  const collapsed = hideQuickRanges ? false : collapsedFlag;
  const onChangeTimeOption = (timeOption) => {
    return onChange(mapOptionToTimeRange(timeOption, timeZone));
  };
  return /* @__PURE__ */ React__default["default"].createElement("fieldset", null, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.header }, /* @__PURE__ */ React__default["default"].createElement(
    "button",
    {
      type: "button",
      className: styles.expandButton,
      onClick: () => {
        if (!hideQuickRanges) {
          setCollapsedFlag(!collapsed);
        }
      },
      "data-testid": e2eSelectors.selectors.components.TimePicker.absoluteTimeRangeTitle,
      "aria-expanded": !collapsed,
      "aria-controls": "expanded-timerange"
    },
    /* @__PURE__ */ React__default["default"].createElement(TimePickerTitle, null, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "time-picker.absolute.title" }, "Absolute time range")),
    !hideQuickRanges && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: !collapsed ? "angle-up" : "angle-down" })
  )), !collapsed && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.body, id: "expanded-timerange" }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.form }, /* @__PURE__ */ React__default["default"].createElement(
    TimeRangeContent,
    {
      value,
      onApply: onChange,
      timeZone,
      isFullscreen: false,
      onError
    }
  )), showHistory && /* @__PURE__ */ React__default["default"].createElement(
    TimeRangeList,
    {
      title: t("time-picker.absolute.recent-title", "Recently used absolute ranges"),
      options: historyOptions,
      onChange: onChangeTimeOption,
      placeholderEmpty: null
    }
  )));
};
const FullScreenForm = (props) => {
  const { onChange, value, timeZone, fiscalYearStartMonth, isReversed, historyOptions, onError } = props;
  const styles = useStyles2(getFullScreenStyles, props.hideQuickRanges);
  const onChangeTimeOption = (timeOption) => {
    return onChange(mapOptionToTimeRange(timeOption, timeZone));
  };
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.container }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.title, "data-testid": e2eSelectors.selectors.components.TimePicker.absoluteTimeRangeTitle }, /* @__PURE__ */ React__default["default"].createElement(TimePickerTitle, null, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "time-picker.absolute.title" }, "Absolute time range"))), /* @__PURE__ */ React__default["default"].createElement(
    TimeRangeContent,
    {
      value,
      timeZone,
      fiscalYearStartMonth,
      onApply: onChange,
      isFullscreen: true,
      isReversed,
      onError
    }
  )), props.showHistory && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.recent }, /* @__PURE__ */ React__default["default"].createElement(
    TimeRangeList,
    {
      title: t("time-picker.absolute.recent-title", "Recently used absolute ranges"),
      options: historyOptions || [],
      onChange: onChangeTimeOption,
      placeholderEmpty: /* @__PURE__ */ React__default["default"].createElement(EmptyRecentList, null)
    }
  )));
};
const EmptyRecentList = React.memo(() => {
  const styles = useStyles2(getEmptyListStyles);
  const emptyRecentListText = t(
    "time-picker.content.empty-recent-list-info",
    "It looks like you haven't used this time picker before. As soon as you enter some time intervals, recently used intervals will appear here."
  );
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.container }, /* @__PURE__ */ React__default["default"].createElement("div", null, /* @__PURE__ */ React__default["default"].createElement("span", null, emptyRecentListText)), /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "time-picker.content.empty-recent-list-docs" }, /* @__PURE__ */ React__default["default"].createElement("div", null, /* @__PURE__ */ React__default["default"].createElement(
    "a",
    {
      className: styles.link,
      href: "https://grafana.com/docs/grafana/latest/dashboards/time-range-controls",
      target: "_new"
    },
    "Read the documentation"
  ), /* @__PURE__ */ React__default["default"].createElement("span", null, " to find out more about how to enter custom time ranges."))));
});
function mapToHistoryOptions(ranges, timeZone) {
  if (!Array.isArray(ranges) || ranges.length === 0) {
    return [];
  }
  return ranges.map((range) => mapRangeToTimeOption(range, timeZone));
}
EmptyRecentList.displayName = "EmptyRecentList";
const useTimeOption = (raw, quickOptions) => {
  return React.useMemo(() => {
    if (!data.rangeUtil.isRelativeTimeRange(raw)) {
      return;
    }
    return quickOptions.find((option) => {
      return option.from === raw.from && option.to === raw.to;
    });
  }, [raw, quickOptions]);
};
const getStyles$1e = (theme, isReversed, hideQuickRanges, isContainerTall, isFullscreen) => ({
  container: css.css({
    background: theme.colors.background.primary,
    boxShadow: theme.shadows.z3,
    width: `${isFullscreen ? "546px" : "262px"}`,
    borderRadius: theme.shape.radius.default,
    border: `1px solid ${theme.colors.border.weak}`,
    [`${isReversed ? "left" : "right"}`]: 0
  }),
  body: css.css({
    display: "flex",
    flexDirection: "row-reverse",
    height: `${isContainerTall ? "381px" : "217px"}`,
    maxHeight: "100vh"
  }),
  leftSide: css.css({
    display: "flex",
    flexDirection: "column",
    borderRight: `${isReversed ? "none" : `1px solid ${theme.colors.border.weak}`}`,
    width: `${!hideQuickRanges ? "60%" : "100%"}`,
    overflow: "hidden",
    order: isReversed ? 1 : 0
  }),
  rightSide: css.css({
    width: `${isFullscreen ? "40%" : "100%"}; !important`,
    borderRight: isReversed ? `1px solid ${theme.colors.border.weak}` : "none",
    display: "flex",
    flexDirection: "column"
  }),
  timeRangeFilter: css.css({
    padding: theme.spacing(1)
  }),
  spacing: css.css({
    marginTop: "16px"
  })
});
const getNarrowScreenStyles = (theme) => ({
  header: css.css({
    display: "flex",
    flexDirection: "row",
    justifyContent: "space-between",
    alignItems: "center",
    borderBottom: `1px solid ${theme.colors.border.weak}`,
    padding: "7px 9px 7px 9px"
  }),
  expandButton: css.css({
    backgroundColor: "transparent",
    border: "none",
    display: "flex",
    width: "100%",
    "&:focus-visible": getFocusStyles(theme)
  }),
  body: css.css({
    borderBottom: `1px solid ${theme.colors.border.weak}`
  }),
  form: css.css({
    padding: "7px 9px 7px 9px"
  })
});
const getFullScreenStyles = (theme, hideQuickRanges) => ({
  container: css.css({
    paddingTop: "9px",
    paddingLeft: "11px",
    paddingRight: !hideQuickRanges ? "20%" : "11px"
  }),
  title: css.css({
    marginBottom: "11px"
  }),
  recent: css.css({
    flexGrow: 1,
    display: "flex",
    flexDirection: "column",
    justifyContent: "flex-end",
    paddingTop: theme.spacing(1)
  })
});
const getEmptyListStyles = (theme) => ({
  container: css.css({
    padding: "12px",
    margin: "12px",
    "a, span": {
      fontSize: "13px"
    }
  }),
  link: css.css({
    color: theme.colors.text.link
  })
});

var __defProp$23 = Object.defineProperty;
var __getOwnPropSymbols$1W = Object.getOwnPropertySymbols;
var __hasOwnProp$1W = Object.prototype.hasOwnProperty;
var __propIsEnum$1W = Object.prototype.propertyIsEnumerable;
var __defNormalProp$23 = (obj, key, value) => key in obj ? __defProp$23(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1V = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1W.call(b, prop))
      __defNormalProp$23(a, prop, b[prop]);
  if (__getOwnPropSymbols$1W)
    for (var prop of __getOwnPropSymbols$1W(b)) {
      if (__propIsEnum$1W.call(b, prop))
        __defNormalProp$23(a, prop, b[prop]);
    }
  return a;
};
function TimeRangePicker(props) {
  var _a;
  const [isOpen, setOpen] = React.useState(false);
  const {
    value,
    onMoveBackward,
    onMoveForward,
    onZoom,
    onError,
    timeZone,
    fiscalYearStartMonth,
    timeSyncButton,
    isSynced,
    history,
    onChangeTimeZone,
    onChangeFiscalYearStartMonth,
    hideQuickRanges,
    widthOverride,
    isOnCanvas,
    onToolbarTimePickerClick
  } = props;
  const onChange = (timeRange) => {
    props.onChange(timeRange);
    setOpen(false);
  };
  React.useEffect(() => {
    if (isOpen && onToolbarTimePickerClick) {
      onToolbarTimePickerClick();
    }
  }, [isOpen, onToolbarTimePickerClick]);
  const onToolbarButtonSwitch = () => {
    setOpen((prevState) => !prevState);
  };
  const onClose = () => {
    setOpen(false);
  };
  const overlayRef = React.createRef();
  const buttonRef = React.createRef();
  const { overlayProps, underlayProps } = overlays.useOverlay(
    {
      onClose,
      isDismissable: true,
      isOpen,
      shouldCloseOnInteractOutside: (element) => {
        var _a2;
        return !((_a2 = buttonRef.current) == null ? void 0 : _a2.contains(element));
      }
    },
    overlayRef
  );
  const { dialogProps } = dialog.useDialog({}, overlayRef);
  const styles = useStyles2(getStyles$1d);
  const { modalBackdrop } = useStyles2(getModalStyles);
  const hasAbsolute = !data.rangeUtil.isRelativeTime(value.raw.from) || !data.rangeUtil.isRelativeTime(value.raw.to);
  const variant = isSynced ? "active" : isOnCanvas ? "canvas" : "default";
  const isFromAfterTo = (_a = value == null ? void 0 : value.to) == null ? void 0 : _a.isBefore(value.from);
  const timePickerIcon = isFromAfterTo ? "exclamation-triangle" : "clock-nine";
  const currentTimeRange = formattedRange(value, timeZone);
  return /* @__PURE__ */ React__default["default"].createElement(ButtonGroup, { className: styles.container }, hasAbsolute && /* @__PURE__ */ React__default["default"].createElement(
    ToolbarButton,
    {
      "aria-label": t("time-picker.range-picker.backwards-time-aria-label", "Move time range backwards"),
      variant,
      onClick: onMoveBackward,
      icon: "angle-left",
      narrow: true
    }
  ), /* @__PURE__ */ React__default["default"].createElement(
    Tooltip,
    {
      ref: buttonRef,
      content: /* @__PURE__ */ React__default["default"].createElement(TimePickerTooltip, { timeRange: value, timeZone }),
      placement: "bottom",
      interactive: true
    },
    /* @__PURE__ */ React__default["default"].createElement(
      ToolbarButton,
      {
        "data-testid": e2eSelectors.selectors.components.TimePicker.openButton,
        "aria-label": t("time-picker.range-picker.current-time-selected", "Time range selected: {{currentTimeRange}}", {
          currentTimeRange
        }),
        "aria-controls": "TimePickerContent",
        onClick: onToolbarButtonSwitch,
        icon: timePickerIcon,
        isOpen,
        variant
      },
      /* @__PURE__ */ React__default["default"].createElement(TimePickerButtonLabel, __spreadValues$1V({}, props))
    )
  ), isOpen && /* @__PURE__ */ React__default["default"].createElement("div", { "data-testid": e2eSelectors.selectors.components.TimePicker.overlayContent }, /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1V({ role: "presentation", className: css.cx(modalBackdrop, styles.backdrop) }, underlayProps)), /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { contain: true, autoFocus: true, restoreFocus: true }, /* @__PURE__ */ React__default["default"].createElement("section", __spreadValues$1V(__spreadValues$1V({ className: styles.content, ref: overlayRef }, overlayProps), dialogProps), /* @__PURE__ */ React__default["default"].createElement(
    TimePickerContent,
    {
      timeZone,
      fiscalYearStartMonth,
      value,
      onChange,
      quickOptions,
      history,
      showHistory: true,
      widthOverride,
      onChangeTimeZone,
      onChangeFiscalYearStartMonth,
      hideQuickRanges,
      onError
    }
  )))), timeSyncButton, hasAbsolute && /* @__PURE__ */ React__default["default"].createElement(
    ToolbarButton,
    {
      "aria-label": t("time-picker.range-picker.forwards-time-aria-label", "Move time range forwards"),
      onClick: onMoveForward,
      icon: "angle-right",
      narrow: true,
      variant
    }
  ), /* @__PURE__ */ React__default["default"].createElement(Tooltip, { content: ZoomOutTooltip, placement: "bottom" }, /* @__PURE__ */ React__default["default"].createElement(
    ToolbarButton,
    {
      "aria-label": t("time-picker.range-picker.zoom-out-button", "Zoom out time range"),
      onClick: onZoom,
      icon: "search-minus",
      variant
    }
  )));
}
TimeRangePicker.displayName = "TimeRangePicker";
const ZoomOutTooltip = () => /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "time-picker.range-picker.zoom-out-tooltip" }, "Time range zoom out ", /* @__PURE__ */ React__default["default"].createElement("br", null), " CTRL+Z"));
const TimePickerTooltip = ({ timeRange, timeZone }) => {
  const styles = useStyles2(getLabelStyles$2);
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, data.dateTimeFormat(timeRange.from, { timeZone }), /* @__PURE__ */ React__default["default"].createElement("div", { className: "text-center" }, /* @__PURE__ */ React__default["default"].createElement(Trans, { i18nKey: "time-picker.range-picker.to" }, "to")), data.dateTimeFormat(timeRange.to, { timeZone }), /* @__PURE__ */ React__default["default"].createElement("div", { className: "text-center" }, /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.utc }, data.timeZoneFormatUserFriendly(timeZone))));
};
const TimePickerButtonLabel = React.memo(({ hideText, value, timeZone }) => {
  const styles = useStyles2(getLabelStyles$2);
  if (hideText) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.container }, /* @__PURE__ */ React__default["default"].createElement("span", null, formattedRange(value, timeZone)), /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.utc }, data.rangeUtil.describeTimeRangeAbbreviation(value, timeZone)));
});
TimePickerButtonLabel.displayName = "TimePickerButtonLabel";
const formattedRange = (value, timeZone) => {
  const adjustedTimeRange = {
    to: data.dateMath.isMathString(value.raw.to) ? value.raw.to : value.to,
    from: data.dateMath.isMathString(value.raw.from) ? value.raw.from : value.from
  };
  return data.rangeUtil.describeTimeRange(adjustedTimeRange, timeZone);
};
const getStyles$1d = (theme) => {
  return {
    container: css.css({
      position: "relative",
      display: "flex",
      verticalAlign: "middle"
    }),
    backdrop: css.css({
      display: "none",
      [theme.breakpoints.down("sm")]: {
        display: "block"
      }
    }),
    content: css.css({
      position: "absolute",
      right: 0,
      top: "116%",
      zIndex: theme.zIndex.dropdown,
      [theme.breakpoints.down("sm")]: {
        position: "fixed",
        right: "50%",
        top: "50%",
        transform: "translate(50%, -50%)",
        zIndex: theme.zIndex.modal
      }
    })
  };
};
const getLabelStyles$2 = (theme) => {
  return {
    container: css.css({
      display: "flex",
      alignItems: "center",
      whiteSpace: "nowrap"
    }),
    utc: css.css({
      color: theme.v1.palette.orange,
      fontSize: theme.typography.size.sm,
      paddingLeft: "6px",
      lineHeight: "28px",
      verticalAlign: "bottom",
      fontWeight: theme.typography.fontWeightMedium
    })
  };
};

const TimeRangeLabel = React.memo(function TimePickerLabel({
  hideText,
  value,
  timeZone = "browser",
  placeholder = "No time range selected",
  className
}) {
  const styles = useStyles2(getLabelStyles$1);
  if (hideText) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement("span", { className }, isValidTimeRange(value) ? /* @__PURE__ */ React__default["default"].createElement(TimePickerButtonLabel, { value, timeZone }) : /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.placeholder }, placeholder));
});
const getLabelStyles$1 = (theme) => {
  return {
    placeholder: css.css({
      color: theme.colors.text.disabled,
      opacity: 1
    })
  };
};

const POPUP_CLASS_NAME = "time-of-day-picker-panel";
const TimeOfDayPicker = ({
  minuteStep = 1,
  showHour = true,
  showSeconds = false,
  onChange,
  value,
  size = "auto",
  disabled,
  disabledHours,
  disabledMinutes,
  disabledSeconds
}) => {
  const styles = useStyles2(getStyles$1c);
  return /* @__PURE__ */ React__default["default"].createElement(
    RcTimePicker__default["default"],
    {
      className: css.cx(inputSizes()[size], styles.input),
      popupClassName: css.cx(styles.picker, POPUP_CLASS_NAME),
      defaultValue: data.dateTimeAsMoment(),
      onChange: (value2) => {
        if (data.isDateTimeInput(value2)) {
          return onChange(data.dateTime(value2));
        }
      },
      allowEmpty: false,
      showSecond: showSeconds,
      value: data.dateTimeAsMoment(value),
      showHour,
      minuteStep,
      inputIcon: /* @__PURE__ */ React__default["default"].createElement(Caret, { wrapperStyle: styles.caretWrapper }),
      disabled,
      disabledHours,
      disabledMinutes,
      disabledSeconds
    }
  );
};
const Caret = ({ wrapperStyle = "" }) => {
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: wrapperStyle }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-down" }));
};
const getStyles$1c = (theme) => {
  const bgColor = theme.components.input.background;
  const menuShadowColor = theme.v1.palette.black;
  const optionBgHover = theme.colors.background.secondary;
  const borderRadius = theme.shape.radius.default;
  const borderColor = theme.components.input.borderColor;
  return {
    caretWrapper: css.css({
      position: "absolute",
      right: "8px",
      top: "50%",
      transform: "translateY(-50%)",
      display: "inline-block",
      textAlign: "right",
      color: theme.colors.text.secondary
    }),
    picker: css.css({
      ".rc-time-picker-panel-select": {
        fontSize: "14px",
        backgroundColor: bgColor,
        borderColor,
        li: {
          outlineWidth: "2px",
          "&.rc-time-picker-panel-select-option-selected": {
            backgroundColor: "inherit",
            border: `1px solid ${theme.v1.palette.orange}`,
            borderRadius
          },
          "&:hover": {
            background: optionBgHover
          },
          "&.rc-time-picker-panel-select-option-disabled": {
            color: theme.colors.action.disabledText
          }
        }
      },
      ".rc-time-picker-panel-inner": {
        boxShadow: `0px 4px 4px ${menuShadowColor}`,
        backgroundColor: bgColor,
        borderColor,
        borderRadius,
        marginTop: "3px",
        ".rc-time-picker-panel-input-wrap": {
          marginRight: "2px",
          "&, .rc-time-picker-panel-input": {
            backgroundColor: bgColor,
            paddingTop: "2px"
          }
        },
        ".rc-time-picker-panel-combobox": {
          display: "flex"
        }
      }
    }),
    input: css.css({
      ".rc-time-picker-input": {
        backgroundColor: bgColor,
        borderRadius,
        borderColor,
        height: theme.spacing(4),
        "&:focus": getFocusStyles(theme),
        "&:disabled": {
          backgroundColor: theme.colors.action.disabledBackground,
          color: theme.colors.action.disabledText,
          border: `1px solid ${theme.colors.action.disabledBackground}`,
          "&:focus": {
            boxShadow: "none"
          }
        }
      }
    })
  };
};

const weekStarts = [
  { value: "", label: "Default" },
  { value: "saturday", label: "Saturday" },
  { value: "sunday", label: "Sunday" },
  { value: "monday", label: "Monday" }
];
const WeekStartPicker = (props) => {
  var _a;
  const { onChange, width, autoFocus = false, onBlur, value, disabled = false, inputId } = props;
  const onChangeWeekStart = React.useCallback(
    (selectable) => {
      if (selectable.value !== void 0) {
        onChange(selectable.value);
      }
    },
    [onChange]
  );
  return /* @__PURE__ */ React__default["default"].createElement(
    Select,
    {
      inputId,
      value: (_a = weekStarts.find((item) => item.value === value)) == null ? void 0 : _a.value,
      placeholder: e2eSelectors.selectors.components.WeekStartPicker.placeholder,
      autoFocus,
      openMenuOnFocus: true,
      width,
      options: weekStarts,
      onChange: onChangeWeekStart,
      onBlur,
      disabled
    }
  );
};

var __defProp$22 = Object.defineProperty;
var __getOwnPropSymbols$1V = Object.getOwnPropertySymbols;
var __hasOwnProp$1V = Object.prototype.hasOwnProperty;
var __propIsEnum$1V = Object.prototype.propertyIsEnumerable;
var __defNormalProp$22 = (obj, key, value) => key in obj ? __defProp$22(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1U = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1V.call(b, prop))
      __defNormalProp$22(a, prop, b[prop]);
  if (__getOwnPropSymbols$1V)
    for (var prop of __getOwnPropSymbols$1V(b)) {
      if (__propIsEnum$1V.call(b, prop))
        __defNormalProp$22(a, prop, b[prop]);
    }
  return a;
};
const DatePicker = React.memo((props) => {
  const styles = useStyles2(getStyles$1b);
  const { isOpen, onClose } = props;
  if (!isOpen) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement(ClickOutsideWrapper, { useCapture: true, includeButtonPress: false, onClick: onClose }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.modal, "data-testid": "date-picker" }, /* @__PURE__ */ React__default["default"].createElement(Body, __spreadValues$1U({}, props))));
});
DatePicker.displayName = "DatePicker";
const Body = React.memo(({ value, minDate, maxDate, onChange }) => {
  const styles = useStyles2(getBodyStyles);
  return /* @__PURE__ */ React__default["default"].createElement(
    Calendar__default["default"],
    {
      className: styles.body,
      tileClassName: styles.title,
      value: value || /* @__PURE__ */ new Date(),
      minDate,
      maxDate,
      nextLabel: /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-right" }),
      prevLabel: /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-left" }),
      onChange: (ev) => {
        if (ev && !Array.isArray(ev)) {
          onChange(ev);
        }
      },
      locale: "en"
    }
  );
});
Body.displayName = "Body";
const getStyles$1b = (theme) => {
  return {
    modal: css.css({
      zIndex: theme.zIndex.modal,
      position: "absolute",
      boxShadow: theme.shadows.z3,
      backgroundColor: theme.colors.background.primary,
      border: `1px solid ${theme.colors.border.weak}`,
      borderTopLeftRadius: theme.shape.radius.default,
      borderBottomLeftRadius: theme.shape.radius.default,
      "button:disabled": {
        color: theme.colors.text.disabled
      }
    })
  };
};

var __defProp$21 = Object.defineProperty;
var __getOwnPropSymbols$1U = Object.getOwnPropertySymbols;
var __hasOwnProp$1U = Object.prototype.hasOwnProperty;
var __propIsEnum$1U = Object.prototype.propertyIsEnumerable;
var __defNormalProp$21 = (obj, key, value) => key in obj ? __defProp$21(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1T = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1U.call(b, prop))
      __defNormalProp$21(a, prop, b[prop]);
  if (__getOwnPropSymbols$1U)
    for (var prop of __getOwnPropSymbols$1U(b)) {
      if (__propIsEnum$1U.call(b, prop))
        __defNormalProp$21(a, prop, b[prop]);
    }
  return a;
};
var __objRest$Q = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1U.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1U)
    for (var prop of __getOwnPropSymbols$1U(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1U.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const formatDate = (date) => data.dateTime(date).format("L");
const DatePickerWithInput = (_a) => {
  var _b = _a, {
    value,
    minDate,
    maxDate,
    onChange,
    closeOnSelect,
    placeholder = "Date"
  } = _b, rest = __objRest$Q(_b, [
    "value",
    "minDate",
    "maxDate",
    "onChange",
    "closeOnSelect",
    "placeholder"
  ]);
  const [open, setOpen] = React__default["default"].useState(false);
  const styles = useStyles2(getStyles$1a);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.container }, /* @__PURE__ */ React__default["default"].createElement(
    Input,
    __spreadValues$1T({
      type: "text",
      autoComplete: "off",
      placeholder,
      value: value ? formatDate(value) : value,
      onClick: () => setOpen(true),
      onChange: (ev) => {
        if (ev.target.value === "") {
          onChange("");
        }
      },
      className: styles.input
    }, rest)
  ), /* @__PURE__ */ React__default["default"].createElement(
    DatePicker,
    {
      isOpen: open,
      value: value && typeof value !== "string" ? value : data.dateTime().toDate(),
      minDate,
      maxDate,
      onChange: (ev) => {
        onChange(ev);
        if (closeOnSelect) {
          setOpen(false);
        }
      },
      onClose: () => setOpen(false)
    }
  ));
};
const getStyles$1a = () => {
  return {
    container: css.css({
      position: "relative"
    }),
    input: css.css({
      /* hides the native Calendar picker icon given when using type=date */
      "input[type='date']::-webkit-inner-spin-button, input[type='date']::-webkit-calendar-picker-indicator": {
        display: "none",
        WebkitAppearance: "none"
      }
    })
  };
};

var __defProp$20 = Object.defineProperty;
var __getOwnPropSymbols$1T = Object.getOwnPropertySymbols;
var __hasOwnProp$1T = Object.prototype.hasOwnProperty;
var __propIsEnum$1T = Object.prototype.propertyIsEnumerable;
var __defNormalProp$20 = (obj, key, value) => key in obj ? __defProp$20(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1S = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1T.call(b, prop))
      __defNormalProp$20(a, prop, b[prop]);
  if (__getOwnPropSymbols$1T)
    for (var prop of __getOwnPropSymbols$1T(b)) {
      if (__propIsEnum$1T.call(b, prop))
        __defNormalProp$20(a, prop, b[prop]);
    }
  return a;
};
var __objRest$P = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1T.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1T)
    for (var prop of __getOwnPropSymbols$1T(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1T.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const InlineLabel = (_a) => {
  var _b = _a, {
    children,
    className,
    tooltip,
    width,
    transparent,
    interactive,
    as: Component = "label"
  } = _b, rest = __objRest$P(_b, [
    "children",
    "className",
    "tooltip",
    "width",
    "transparent",
    "interactive",
    "as"
  ]);
  const styles = useStyles2(getInlineLabelStyles, transparent, width);
  return /* @__PURE__ */ React__default["default"].createElement(Component, __spreadValues$1S({ className: css.cx(styles.label, className) }, rest), children, tooltip && /* @__PURE__ */ React__default["default"].createElement(Tooltip, { interactive, placement: "top", content: tooltip, theme: "info" }, /* @__PURE__ */ React__default["default"].createElement(Icon, { tabIndex: 0, name: "info-circle", size: "sm", className: styles.icon })));
};
const getInlineLabelStyles = (theme, transparent = false, width) => {
  return {
    label: css.css({
      display: "flex",
      alignItems: "center",
      justifyContent: "space-between",
      flexShrink: 0,
      padding: theme.spacing(0, 1),
      fontWeight: theme.typography.fontWeightMedium,
      fontSize: theme.typography.size.sm,
      backgroundColor: transparent ? "transparent" : theme.colors.background.secondary,
      height: theme.spacing(theme.components.height.md),
      lineHeight: theme.spacing(theme.components.height.md),
      marginRight: theme.spacing(0.5),
      borderRadius: theme.shape.radius.default,
      border: "none",
      width: width ? width !== "auto" ? `${8 * width}px` : width : "100%",
      color: theme.colors.text.primary
    }),
    icon: css.css({
      color: theme.colors.text.secondary,
      marginLeft: "10px",
      ":hover": {
        color: theme.colors.text.primary
      }
    })
  };
};

var __defProp$1$ = Object.defineProperty;
var __getOwnPropSymbols$1S = Object.getOwnPropertySymbols;
var __hasOwnProp$1S = Object.prototype.hasOwnProperty;
var __propIsEnum$1S = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1$ = (obj, key, value) => key in obj ? __defProp$1$(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1R = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1S.call(b, prop))
      __defNormalProp$1$(a, prop, b[prop]);
  if (__getOwnPropSymbols$1S)
    for (var prop of __getOwnPropSymbols$1S(b)) {
      if (__propIsEnum$1S.call(b, prop))
        __defNormalProp$1$(a, prop, b[prop]);
    }
  return a;
};
var __objRest$O = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1S.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1S)
    for (var prop of __getOwnPropSymbols$1S(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1S.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const InlineField = (_a) => {
  var _b = _a, {
    children,
    label,
    tooltip,
    labelWidth = "auto",
    invalid,
    loading,
    disabled,
    required,
    className,
    htmlFor,
    grow,
    shrink,
    error,
    transparent,
    interactive
  } = _b, htmlProps = __objRest$O(_b, [
    "children",
    "label",
    "tooltip",
    "labelWidth",
    "invalid",
    "loading",
    "disabled",
    "required",
    "className",
    "htmlFor",
    "grow",
    "shrink",
    "error",
    "transparent",
    "interactive"
  ]);
  const theme = useTheme2();
  const styles = getStyles$19(theme, grow, shrink);
  const inputId = htmlFor != null ? htmlFor : getChildId(children);
  const labelElement = typeof label === "string" ? /* @__PURE__ */ React__default["default"].createElement(
    InlineLabel,
    {
      interactive,
      width: labelWidth,
      tooltip,
      htmlFor: inputId,
      transparent
    },
    `${label}${required ? " *" : ""}`
  ) : label;
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1R({ className: css.cx(styles.container, className) }, htmlProps), labelElement, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.childContainer }, React__default["default"].cloneElement(children, { invalid, disabled, loading }), invalid && error && /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.fieldValidationWrapper) }, /* @__PURE__ */ React__default["default"].createElement(FieldValidationMessage, null, error))));
};
InlineField.displayName = "InlineField";
const getStyles$19 = (theme, grow, shrink) => {
  return {
    container: css.css({
      display: "flex",
      flexDirection: "row",
      alignItems: "flex-start",
      textAlign: "left",
      position: "relative",
      flex: `${grow ? 1 : 0} ${shrink ? 1 : 0} auto`,
      margin: `0 ${theme.spacing(0.5)} ${theme.spacing(0.5)} 0`
    }),
    childContainer: css.css({
      flex: `${grow ? 1 : 0} ${shrink ? 1 : 0} auto`
    }),
    fieldValidationWrapper: css.css({
      marginTop: theme.spacing(0.5)
    })
  };
};

var __defProp$1_ = Object.defineProperty;
var __getOwnPropSymbols$1R = Object.getOwnPropertySymbols;
var __hasOwnProp$1R = Object.prototype.hasOwnProperty;
var __propIsEnum$1R = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1_ = (obj, key, value) => key in obj ? __defProp$1_(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1Q = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1R.call(b, prop))
      __defNormalProp$1_(a, prop, b[prop]);
  if (__getOwnPropSymbols$1R)
    for (var prop of __getOwnPropSymbols$1R(b)) {
      if (__propIsEnum$1R.call(b, prop))
        __defNormalProp$1_(a, prop, b[prop]);
    }
  return a;
};
var __objRest$N = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1R.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1R)
    for (var prop of __getOwnPropSymbols$1R(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1R.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Layout = (_a) => {
  var _b = _a, {
    children,
    orientation = 0 /* Horizontal */,
    spacing = "sm",
    justify = "flex-start",
    align = "normal",
    wrap = false,
    width = "100%",
    height = "100%"
  } = _b, rest = __objRest$N(_b, [
    "children",
    "orientation",
    "spacing",
    "justify",
    "align",
    "wrap",
    "width",
    "height"
  ]);
  const styles = useStyles2(getStyles$18, orientation, spacing, justify, align, wrap);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1Q({ className: styles.layout, style: { width, height } }, rest), React__default["default"].Children.toArray(children).filter(Boolean).map((child, index) => {
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.childWrapper, key: index }, child);
  }));
};
const HorizontalGroup = ({
  children,
  spacing,
  justify,
  align = "center",
  wrap,
  width,
  height
}) => /* @__PURE__ */ React__default["default"].createElement(
  Layout,
  {
    spacing,
    justify,
    orientation: 0 /* Horizontal */,
    align,
    width,
    height,
    wrap
  },
  children
);
const VerticalGroup = ({
  children,
  spacing,
  justify,
  align,
  width,
  height
}) => /* @__PURE__ */ React__default["default"].createElement(
  Layout,
  {
    spacing,
    justify,
    orientation: 1 /* Vertical */,
    align,
    width,
    height
  },
  children
);
const Container = ({ children, padding, margin, grow, shrink }) => {
  const styles = useStyles2(getContainerStyles, padding, margin);
  return /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      className: css.cx(
        styles.wrapper,
        grow !== void 0 && css.css({ flexGrow: grow }),
        shrink !== void 0 && css.css({ flexShrink: shrink })
      )
    },
    children
  );
};
const getStyles$18 = (theme, orientation, spacing, justify, align, wrap) => {
  const finalSpacing = spacing !== "none" ? theme.spacing(spacingToNumber[spacing]) : 0;
  const marginCompensation = orientation === 0 /* Horizontal */ && !wrap || orientation === 1 /* Vertical */ ? 0 : `-${finalSpacing}`;
  const label = orientation === 1 /* Vertical */ ? "vertical-group" : "horizontal-group";
  return {
    layout: css.css({
      label,
      display: "flex",
      flexDirection: orientation === 1 /* Vertical */ ? "column" : "row",
      flexWrap: wrap ? "wrap" : "nowrap",
      justifyContent: justify,
      alignItems: align,
      height: "100%",
      maxWidth: "100%",
      // compensate for last row margin when wrapped, horizontal layout
      marginBottom: marginCompensation
    }),
    childWrapper: css.css({
      label: "layoutChildrenWrapper",
      marginBottom: orientation === 0 /* Horizontal */ && !wrap ? 0 : finalSpacing,
      marginRight: orientation === 0 /* Horizontal */ ? finalSpacing : 0,
      display: "flex",
      alignItems: align,
      "&:last-child": {
        marginBottom: orientation === 1 /* Vertical */ ? 0 : void 0,
        marginRight: orientation === 0 /* Horizontal */ ? 0 : void 0
      }
    })
  };
};
const spacingToNumber = {
  none: 0,
  xs: 0.5,
  sm: 1,
  md: 2,
  lg: 3
};
const getContainerStyles = (theme, padding, margin) => {
  const paddingSize = padding && padding !== "none" && theme.spacing(spacingToNumber[padding]) || 0;
  const marginSize = margin && margin !== "none" && theme.spacing(spacingToNumber[margin]) || 0;
  return {
    wrapper: css.css({
      label: "container",
      margin: marginSize,
      padding: paddingSize
    })
  };
};

var __defProp$1Z = Object.defineProperty;
var __getOwnPropSymbols$1Q = Object.getOwnPropertySymbols;
var __hasOwnProp$1Q = Object.prototype.hasOwnProperty;
var __propIsEnum$1Q = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1Z = (obj, key, value) => key in obj ? __defProp$1Z(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1P = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1Q.call(b, prop))
      __defNormalProp$1Z(a, prop, b[prop]);
  if (__getOwnPropSymbols$1Q)
    for (var prop of __getOwnPropSymbols$1Q(b)) {
      if (__propIsEnum$1Q.call(b, prop))
        __defNormalProp$1Z(a, prop, b[prop]);
    }
  return a;
};
const DateTimePicker = ({
  date,
  maxDate,
  minDate,
  label,
  onChange,
  disabledHours,
  disabledMinutes,
  disabledSeconds,
  showSeconds = true
}) => {
  const [isOpen, setOpen] = React.useState(false);
  const ref = React.useRef(null);
  const { overlayProps, underlayProps } = overlays.useOverlay(
    {
      onClose: () => setOpen(false),
      isDismissable: true,
      isOpen,
      shouldCloseOnInteractOutside: (element) => {
        const popupElement = document.getElementsByClassName(POPUP_CLASS_NAME)[0];
        return !(popupElement && popupElement.contains(element));
      }
    },
    ref
  );
  const { dialogProps } = dialog.useDialog({}, ref);
  const theme = useTheme2();
  const { modalBackdrop } = useStyles2(getModalStyles);
  const isFullscreen = reactUse.useMedia(`(min-width: ${theme.breakpoints.values.lg}px)`);
  const styles = useStyles2(getStyles$17);
  const [markerElement, setMarkerElement] = React.useState();
  const [selectorElement, setSelectorElement] = React.useState();
  const popper = reactPopper.usePopper(markerElement, selectorElement, {
    placement: "bottom-start"
  });
  const onApply = React.useCallback(
    (date2) => {
      setOpen(false);
      onChange(date2);
    },
    [onChange]
  );
  const onOpen = React.useCallback(
    (event) => {
      event.preventDefault();
      setOpen(true);
    },
    [setOpen]
  );
  return /* @__PURE__ */ React__default["default"].createElement("div", { "data-testid": "date-time-picker", style: { position: "relative" } }, /* @__PURE__ */ React__default["default"].createElement(
    DateTimeInput,
    {
      date,
      onChange,
      isFullscreen,
      onOpen,
      label,
      ref: setMarkerElement,
      showSeconds
    }
  ), isOpen ? isFullscreen ? /* @__PURE__ */ React__default["default"].createElement(Portal$1, null, /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { contain: true, autoFocus: true, restoreFocus: true }, /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1P(__spreadValues$1P({ ref }, overlayProps), dialogProps), /* @__PURE__ */ React__default["default"].createElement(
    DateTimeCalendar,
    {
      date,
      onChange: onApply,
      isFullscreen: true,
      onClose: () => setOpen(false),
      maxDate,
      minDate,
      ref: setSelectorElement,
      style: popper.styles.popper,
      showSeconds,
      disabledHours,
      disabledMinutes,
      disabledSeconds
    }
  )))) : /* @__PURE__ */ React__default["default"].createElement(Portal$1, null, /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1P({ className: modalBackdrop }, underlayProps)), /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { contain: true, autoFocus: true, restoreFocus: true }, /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1P(__spreadValues$1P({ ref }, overlayProps), dialogProps), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.modal }, /* @__PURE__ */ React__default["default"].createElement(
    DateTimeCalendar,
    {
      date,
      maxDate,
      minDate,
      onChange: onApply,
      isFullscreen: false,
      onClose: () => setOpen(false),
      showSeconds,
      disabledHours,
      disabledMinutes,
      disabledSeconds
    }
  ))))) : null);
};
const DateTimeInput = React__default["default"].forwardRef(
  ({ date, label, onChange, onOpen, showSeconds = true }, ref) => {
    const format = showSeconds ? "YYYY-MM-DD HH:mm:ss" : "YYYY-MM-DD HH:mm";
    const [internalDate, setInternalDate] = React.useState(() => {
      return { value: date ? data.dateTimeFormat(date) : data.dateTimeFormat(data.dateTime()), invalid: false };
    });
    React.useEffect(() => {
      if (date) {
        setInternalDate({
          invalid: !isValid(data.dateTimeFormat(date, { format })),
          value: data.isDateTime(date) ? data.dateTimeFormat(date, { format }) : date
        });
      }
    }, [date, format]);
    const onChangeDate = React.useCallback((event) => {
      const isInvalid = !isValid(event.currentTarget.value);
      setInternalDate({
        value: event.currentTarget.value,
        invalid: isInvalid
      });
    }, []);
    const onBlur = React.useCallback(() => {
      if (!internalDate.invalid) {
        const date2 = data.dateTime(internalDate.value);
        onChange(date2);
      }
    }, [internalDate, onChange]);
    const icon = /* @__PURE__ */ React__default["default"].createElement(Button, { "aria-label": "Time picker", icon: "calendar-alt", variant: "secondary", onClick: onOpen });
    return /* @__PURE__ */ React__default["default"].createElement(
      InlineField,
      {
        label,
        invalid: !!(internalDate.value && internalDate.invalid),
        className: css.css({
          marginBottom: 0
        })
      },
      /* @__PURE__ */ React__default["default"].createElement(
        Input,
        {
          onChange: onChangeDate,
          addonAfter: icon,
          value: internalDate.value,
          onBlur,
          "data-testid": e2eSelectors.Components.DateTimePicker.input,
          placeholder: "Select date/time",
          ref
        }
      )
    );
  }
);
DateTimeInput.displayName = "DateTimeInput";
const DateTimeCalendar = React__default["default"].forwardRef(
  ({
    date,
    onClose,
    onChange,
    isFullscreen,
    maxDate,
    minDate,
    style,
    showSeconds = true,
    disabledHours,
    disabledMinutes,
    disabledSeconds
  }, ref) => {
    const calendarStyles = useStyles2(getBodyStyles);
    const styles = useStyles2(getStyles$17);
    const [internalDate, setInternalDate] = React.useState(() => {
      if (date && date.isValid()) {
        return date.toDate();
      }
      return /* @__PURE__ */ new Date();
    });
    const onChangeDate = React.useCallback((date2) => {
      if (date2 && !Array.isArray(date2)) {
        setInternalDate((prevState) => {
          date2.setHours(prevState.getHours());
          date2.setMinutes(prevState.getMinutes());
          date2.setSeconds(prevState.getSeconds());
          return date2;
        });
      }
    }, []);
    const onChangeTime = React.useCallback((date2) => {
      setInternalDate(date2.toDate());
    }, []);
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.container, { [styles.fullScreen]: isFullscreen }), style, ref }, /* @__PURE__ */ React__default["default"].createElement(
      Calendar__default["default"],
      {
        next2Label: null,
        prev2Label: null,
        value: internalDate,
        nextLabel: /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-right" }),
        nextAriaLabel: "Next month",
        prevLabel: /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-left" }),
        prevAriaLabel: "Previous month",
        onChange: onChangeDate,
        locale: "en",
        className: calendarStyles.body,
        tileClassName: calendarStyles.title,
        maxDate,
        minDate
      }
    ), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.time }, /* @__PURE__ */ React__default["default"].createElement(
      TimeOfDayPicker,
      {
        showSeconds,
        onChange: onChangeTime,
        value: data.dateTime(internalDate),
        disabledHours,
        disabledMinutes,
        disabledSeconds
      }
    )), /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, null, /* @__PURE__ */ React__default["default"].createElement(Button, { type: "button", onClick: () => onChange(data.dateTime(internalDate)) }, "Apply"), /* @__PURE__ */ React__default["default"].createElement(Button, { variant: "secondary", type: "button", onClick: onClose }, "Cancel")));
  }
);
DateTimeCalendar.displayName = "DateTimeCalendar";
const getStyles$17 = (theme) => ({
  container: css.css({
    padding: theme.spacing(1),
    border: `1px ${theme.colors.border.weak} solid`,
    borderRadius: theme.shape.radius.default,
    backgroundColor: theme.colors.background.primary,
    zIndex: theme.zIndex.modal
  }),
  fullScreen: css.css({
    position: "absolute"
  }),
  time: css.css({
    marginBottom: theme.spacing(2)
  }),
  modal: css.css({
    position: "fixed",
    top: "50%",
    left: "50%",
    transform: "translate(-50%, -50%)",
    zIndex: theme.zIndex.modal,
    maxWidth: "280px"
  })
});

const getStyles$16 = stylesFactory((inlineList = false) => ({
  list: css.css({
    listStyleType: "none",
    margin: 0,
    padding: 0
  }),
  item: css.css({
    display: inlineList && "inline-block" || "block"
  })
}));
class AbstractList extends React.PureComponent {
  constructor(props) {
    super(props);
  }
  render() {
    const { items, renderItem, getItemKey, className, inline } = this.props;
    const styles = getStyles$16(inline);
    return /* @__PURE__ */ React__default["default"].createElement("ul", { className: css.cx(styles.list, className) }, items.map((item, i) => {
      return /* @__PURE__ */ React__default["default"].createElement("li", { className: styles.item, key: getItemKey ? getItemKey(item) : i }, renderItem(item, i));
    }));
  }
}

var __defProp$1Y = Object.defineProperty;
var __getOwnPropSymbols$1P = Object.getOwnPropertySymbols;
var __hasOwnProp$1P = Object.prototype.hasOwnProperty;
var __propIsEnum$1P = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1Y = (obj, key, value) => key in obj ? __defProp$1Y(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1O = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1P.call(b, prop))
      __defNormalProp$1Y(a, prop, b[prop]);
  if (__getOwnPropSymbols$1P)
    for (var prop of __getOwnPropSymbols$1P(b)) {
      if (__propIsEnum$1P.call(b, prop))
        __defNormalProp$1Y(a, prop, b[prop]);
    }
  return a;
};
class List extends React.PureComponent {
  render() {
    return /* @__PURE__ */ React__default["default"].createElement(AbstractList, __spreadValues$1O({}, this.props));
  }
}

const Pagination = ({
  currentPage,
  numberOfPages,
  onNavigate,
  hideWhenSinglePage,
  showSmallVersion,
  className
}) => {
  const styles = useStyles2(getStyles$15);
  const pageLengthToCondense = showSmallVersion ? 1 : 8;
  const pageButtons = React.useMemo(() => {
    const pages = [...new Array(numberOfPages).keys()];
    const condensePages = numberOfPages > pageLengthToCondense;
    const getListItem = (page, variant) => /* @__PURE__ */ React__default["default"].createElement("li", { key: page, className: styles.item }, /* @__PURE__ */ React__default["default"].createElement(Button, { size: "sm", variant, onClick: () => onNavigate(page) }, page));
    return pages.reduce((pagesToRender, pageIndex) => {
      const page = pageIndex + 1;
      const variant = page === currentPage ? "primary" : "secondary";
      const lowerBoundIndex = pageLengthToCondense;
      const upperBoundIndex = numberOfPages - pageLengthToCondense + 1;
      const differenceOfBounds = upperBoundIndex - lowerBoundIndex;
      const isFirstOrLastPage = page === 1 || page === numberOfPages;
      const currentPageIsBetweenBounds = differenceOfBounds > -1 && currentPage >= lowerBoundIndex && currentPage <= upperBoundIndex;
      const ellipsisOffset = showSmallVersion ? 1 : 3;
      const pageOffset = showSmallVersion ? 0 : 2;
      if (condensePages) {
        if (isFirstOrLastPage || currentPage < lowerBoundIndex && page < lowerBoundIndex || differenceOfBounds >= 0 && currentPage > upperBoundIndex && page > upperBoundIndex || differenceOfBounds < 0 && currentPage >= lowerBoundIndex && page > upperBoundIndex || currentPageIsBetweenBounds && page >= currentPage - pageOffset && page <= currentPage + pageOffset) {
          pagesToRender.push(getListItem(page, variant));
        } else if (page === lowerBoundIndex && currentPage < lowerBoundIndex || page === upperBoundIndex && currentPage > upperBoundIndex || currentPageIsBetweenBounds && (page === currentPage - ellipsisOffset || page === currentPage + ellipsisOffset)) {
          pagesToRender.push(
            /* @__PURE__ */ React__default["default"].createElement("li", { key: page, className: styles.item }, /* @__PURE__ */ React__default["default"].createElement(Icon, { className: styles.ellipsis, name: "ellipsis-v" }))
          );
        }
      } else {
        pagesToRender.push(getListItem(page, variant));
      }
      return pagesToRender;
    }, []);
  }, [currentPage, numberOfPages, onNavigate, pageLengthToCondense, showSmallVersion, styles.ellipsis, styles.item]);
  if (hideWhenSinglePage && numberOfPages <= 1) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.container, className) }, /* @__PURE__ */ React__default["default"].createElement("ol", null, /* @__PURE__ */ React__default["default"].createElement("li", { className: styles.item }, /* @__PURE__ */ React__default["default"].createElement(
    Button,
    {
      "aria-label": `previous page`,
      size: "sm",
      variant: "secondary",
      onClick: () => onNavigate(currentPage - 1),
      disabled: currentPage === 1
    },
    /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-left" })
  )), pageButtons, /* @__PURE__ */ React__default["default"].createElement("li", { className: styles.item }, /* @__PURE__ */ React__default["default"].createElement(
    Button,
    {
      "aria-label": `next page`,
      size: "sm",
      variant: "secondary",
      onClick: () => onNavigate(currentPage + 1),
      disabled: currentPage === numberOfPages
    },
    /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "angle-right" })
  ))));
};
const getStyles$15 = () => {
  return {
    container: css.css({
      float: "right"
    }),
    item: css.css({
      display: "inline-block",
      paddingLeft: "10px",
      marginBottom: "5px"
    }),
    ellipsis: css.css({
      transform: "rotate(90deg)"
    })
  };
};

var __defProp$1X = Object.defineProperty;
var __defProps$1e = Object.defineProperties;
var __getOwnPropDescs$1e = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1O = Object.getOwnPropertySymbols;
var __hasOwnProp$1O = Object.prototype.hasOwnProperty;
var __propIsEnum$1O = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1X = (obj, key, value) => key in obj ? __defProp$1X(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1N = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1O.call(b, prop))
      __defNormalProp$1X(a, prop, b[prop]);
  if (__getOwnPropSymbols$1O)
    for (var prop of __getOwnPropSymbols$1O(b)) {
      if (__propIsEnum$1O.call(b, prop))
        __defNormalProp$1X(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1e = (a, b) => __defProps$1e(a, __getOwnPropDescs$1e(b));
const expanderContainerStyles = css.css({
  display: "flex",
  alignItems: "center",
  height: "100%"
});
function ExpanderCell({ row, __rowID }) {
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: expanderContainerStyles }, /* @__PURE__ */ React__default["default"].createElement(
    IconButton,
    __spreadProps$1e(__spreadValues$1N({
      tooltip: "toggle row expanded",
      "aria-controls": __rowID,
      name: row.isExpanded ? "angle-down" : "angle-right",
      "aria-expanded": row.isExpanded
    }, row.getToggleRowExpandedProps()), {
      size: "lg"
    })
  ));
}

var __defProp$1W = Object.defineProperty;
var __getOwnPropSymbols$1N = Object.getOwnPropertySymbols;
var __hasOwnProp$1N = Object.prototype.hasOwnProperty;
var __propIsEnum$1N = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1W = (obj, key, value) => key in obj ? __defProp$1W(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1M = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1N.call(b, prop))
      __defNormalProp$1W(a, prop, b[prop]);
  if (__getOwnPropSymbols$1N)
    for (var prop of __getOwnPropSymbols$1N(b)) {
      if (__propIsEnum$1N.call(b, prop))
        __defNormalProp$1W(a, prop, b[prop]);
    }
  return a;
};
const EXPANDER_CELL_ID = "__expander";
function getColumns$1(columns) {
  return [
    {
      id: EXPANDER_CELL_ID,
      Cell: ExpanderCell,
      disableSortBy: true,
      width: 0
    },
    // @ts-expect-error react-table expects each column key(id) to have data associated with it and therefore complains about
    // column.id being possibly undefined and not keyof T (where T is the data object)
    // We do not want to be that strict as we simply pass undefined to cells that do not have data associated with them.
    ...columns.map((column) => __spreadValues$1M({
      id: column.id,
      accessor: column.id,
      Header: column.header || (() => null),
      sortType: column.sortType || "alphanumeric",
      disableSortBy: !Boolean(column.sortType),
      width: column.disableGrow ? 0 : void 0,
      visible: column.visible
    }, column.cell && { Cell: column.cell }))
  ];
}

var __defProp$1V = Object.defineProperty;
var __defProps$1d = Object.defineProperties;
var __getOwnPropDescs$1d = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1M = Object.getOwnPropertySymbols;
var __hasOwnProp$1M = Object.prototype.hasOwnProperty;
var __propIsEnum$1M = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1V = (obj, key, value) => key in obj ? __defProp$1V(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1L = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1M.call(b, prop))
      __defNormalProp$1V(a, prop, b[prop]);
  if (__getOwnPropSymbols$1M)
    for (var prop of __getOwnPropSymbols$1M(b)) {
      if (__propIsEnum$1M.call(b, prop))
        __defNormalProp$1V(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1d = (a, b) => __defProps$1d(a, __getOwnPropDescs$1d(b));
var __objRest$M = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1M.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1M)
    for (var prop of __getOwnPropSymbols$1M(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1M.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const getStyles$14 = (theme) => {
  const rowHoverBg = theme.colors.emphasize(theme.colors.background.primary, 0.03);
  return {
    container: css.css({
      display: "flex",
      gap: theme.spacing(2),
      flexDirection: "column",
      width: "100%",
      overflowX: "auto"
    }),
    table: css.css({
      borderRadius: theme.shape.radius.default,
      width: "100%",
      td: {
        padding: theme.spacing(1)
      },
      "td, th": {
        minWidth: theme.spacing(3)
      }
    }),
    disableGrow: css.css({
      width: 0
    }),
    header: css.css({
      borderBottom: `1px solid ${theme.colors.border.weak}`,
      "&, & > button": {
        position: "relative",
        whiteSpace: "nowrap",
        padding: theme.spacing(1)
      },
      "& > button": {
        "&:after": {
          content: '"\\00a0"'
        },
        width: "100%",
        height: "100%",
        background: "none",
        border: "none",
        paddingRight: theme.spacing(2.5),
        textAlign: "left",
        fontWeight: theme.typography.fontWeightMedium
      }
    }),
    row: css.css({
      label: "row",
      borderBottom: `1px solid ${theme.colors.border.weak}`,
      "&:hover": {
        backgroundColor: rowHoverBg
      },
      "&:last-child": {
        borderBottom: 0
      }
    }),
    expandedRow: css.css({
      label: "expanded-row-content",
      borderBottom: "none"
    }),
    expandedContentRow: css.css({
      label: "expanded-row-content",
      td: {
        borderBottom: `1px solid ${theme.colors.border.weak}`,
        position: "relative",
        padding: theme.spacing(2, 2, 2, 5),
        "&:before": {
          content: '""',
          position: "absolute",
          width: "1px",
          top: 0,
          left: "16px",
          bottom: theme.spacing(2),
          background: theme.colors.border.medium
        }
      }
    }),
    sortableHeader: css.css({
      /* increases selector's specificity so that it always takes precedence over default styles  */
      "&&": {
        padding: 0
      }
    })
  };
};
function InteractiveTable({
  className,
  columns,
  data: data$1,
  getRowId,
  headerTooltips,
  pageSize = 0,
  renderExpandedRow,
  fetchData
}) {
  const styles = useStyles2(getStyles$14);
  const tableColumns = React.useMemo(() => {
    return getColumns$1(columns);
  }, [columns]);
  const id = useUniqueId();
  const getRowHTMLID = React.useCallback(
    (row) => {
      return `${id}-${row.id}`.replace(/\s/g, "");
    },
    [id]
  );
  const tableHooks = [reactTable.useSortBy, reactTable.useExpanded];
  const multiplePages = data$1.length > pageSize;
  const paginationEnabled = pageSize > 0 && multiplePages;
  if (paginationEnabled) {
    tableHooks.push(reactTable.usePagination);
  }
  const tableInstance = reactTable.useTable(
    {
      columns: tableColumns,
      data: data$1,
      autoResetExpanded: false,
      autoResetSortBy: false,
      disableMultiSort: true,
      // If fetchData is provided, we disable client-side sorting
      manualSortBy: Boolean(fetchData),
      getRowId,
      initialState: {
        hiddenColumns: [
          !renderExpandedRow && EXPANDER_CELL_ID,
          ...tableColumns.filter((col) => !(col.visible ? col.visible(data$1) : true)).map((c) => c.id).filter(data.isTruthy)
        ].filter(data.isTruthy)
      }
    },
    ...tableHooks
  );
  const { getTableProps, getTableBodyProps, headerGroups, prepareRow } = tableInstance;
  const { sortBy } = tableInstance.state;
  React.useEffect(() => {
    if (fetchData) {
      fetchData({ sortBy });
    }
  }, [sortBy, fetchData]);
  React.useEffect(() => {
    if (paginationEnabled) {
      tableInstance.setPageSize(pageSize);
    }
  }, [paginationEnabled, pageSize, tableInstance.setPageSize, tableInstance]);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.container }, /* @__PURE__ */ React__default["default"].createElement("table", __spreadProps$1d(__spreadValues$1L({}, getTableProps()), { className: css.cx(styles.table, className) }), /* @__PURE__ */ React__default["default"].createElement("thead", null, headerGroups.map((headerGroup) => {
    const _a = headerGroup.getHeaderGroupProps(), { key } = _a, headerRowProps = __objRest$M(_a, ["key"]);
    return /* @__PURE__ */ React__default["default"].createElement("tr", __spreadValues$1L({ key }, headerRowProps), headerGroup.headers.map((column) => {
      const _a2 = column.getHeaderProps(), { key: key2 } = _a2, headerCellProps = __objRest$M(_a2, ["key"]);
      const headerTooltip = headerTooltips == null ? void 0 : headerTooltips[column.id];
      return /* @__PURE__ */ React__default["default"].createElement(
        "th",
        __spreadValues$1L(__spreadValues$1L({
          key: key2,
          className: css.cx(styles.header, {
            [styles.disableGrow]: column.width === 0,
            [styles.sortableHeader]: column.canSort
          })
        }, headerCellProps), column.isSorted && { "aria-sort": column.isSortedDesc ? "descending" : "ascending" }),
        /* @__PURE__ */ React__default["default"].createElement(ColumnHeader, { column, headerTooltip })
      );
    }));
  })), /* @__PURE__ */ React__default["default"].createElement("tbody", __spreadValues$1L({}, getTableBodyProps()), (paginationEnabled ? tableInstance.page : tableInstance.rows).map((row) => {
    prepareRow(row);
    const _a = row.getRowProps(), { key } = _a, otherRowProps = __objRest$M(_a, ["key"]);
    const rowId = getRowHTMLID(row);
    const isExpanded = row.isExpanded;
    return /* @__PURE__ */ React__default["default"].createElement(React.Fragment, { key }, /* @__PURE__ */ React__default["default"].createElement("tr", __spreadProps$1d(__spreadValues$1L({}, otherRowProps), { className: css.cx(styles.row, isExpanded && styles.expandedRow) }), row.cells.map((cell) => {
      const _a2 = cell.getCellProps(), { key: key2 } = _a2, otherCellProps = __objRest$M(_a2, ["key"]);
      return /* @__PURE__ */ React__default["default"].createElement("td", __spreadValues$1L({ key: key2 }, otherCellProps), cell.render("Cell", { __rowID: rowId }));
    })), isExpanded && renderExpandedRow && /* @__PURE__ */ React__default["default"].createElement("tr", __spreadProps$1d(__spreadValues$1L({}, otherRowProps), { id: rowId, className: styles.expandedContentRow }), /* @__PURE__ */ React__default["default"].createElement("td", { colSpan: row.cells.length }, renderExpandedRow(row.original))));
  }))), paginationEnabled && /* @__PURE__ */ React__default["default"].createElement("span", null, /* @__PURE__ */ React__default["default"].createElement(
    Pagination,
    {
      currentPage: tableInstance.state.pageIndex + 1,
      numberOfPages: tableInstance.pageOptions.length,
      onNavigate: (toPage) => tableInstance.gotoPage(toPage - 1)
    }
  )));
}
const useUniqueId = () => {
  return React.useMemo(() => lodash.uniqueId("InteractiveTable"), []);
};
const getColumnHeaderStyles = (theme) => ({
  sortIcon: css.css({
    position: "absolute",
    top: theme.spacing(1)
  }),
  headerTooltipIcon: css.css({
    marginLeft: theme.spacing(0.5)
  })
});
function ColumnHeader({
  column: { canSort, render, isSorted, isSortedDesc, getSortByToggleProps },
  headerTooltip
}) {
  const styles = useStyles2(getColumnHeaderStyles);
  const { onClick } = getSortByToggleProps();
  const children = /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, render("Header"), headerTooltip && /* @__PURE__ */ React__default["default"].createElement(Tooltip, { theme: "info-alt", content: headerTooltip.content, placement: "top-end" }, /* @__PURE__ */ React__default["default"].createElement(
    Icon,
    {
      className: styles.headerTooltipIcon,
      name: headerTooltip.iconName || "info-circle",
      "data-testid": "header-tooltip-icon"
    }
  )), isSorted && /* @__PURE__ */ React__default["default"].createElement("span", { "aria-hidden": "true", className: styles.sortIcon }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: isSortedDesc ? "angle-down" : "angle-up" })));
  if (canSort) {
    return /* @__PURE__ */ React__default["default"].createElement("button", { type: "button", onClick }, children);
  }
  return children;
}

const TagItem = ({ name, disabled, onRemove }) => {
  const { color, borderColor } = React.useMemo(() => getTagColorsFromName(name), [name]);
  const styles = useStyles2(getStyles$13);
  return /* @__PURE__ */ React__default["default"].createElement("li", { className: styles.itemStyle, style: { backgroundColor: color, borderColor } }, /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.nameStyle }, name), /* @__PURE__ */ React__default["default"].createElement(
    IconButton,
    {
      name: "times",
      size: "lg",
      disabled,
      tooltip: `Remove "${name}" tag`,
      onClick: () => onRemove(name),
      className: styles.buttonStyles
    }
  ));
};
const getStyles$13 = (theme) => {
  const height = theme.spacing.gridSize * 3;
  return {
    itemStyle: css.css({
      display: "flex",
      gap: "3px",
      alignItems: "center",
      height: `${height}px`,
      lineHeight: `${height - 2}px`,
      color: "#fff",
      borderWidth: "1px",
      borderStyle: "solid",
      borderRadius: theme.shape.radius.default,
      padding: `0 ${theme.spacing(0.5)}`,
      whiteSpace: "nowrap",
      textShadow: "none",
      fontWeight: 500,
      fontSize: theme.typography.size.sm
    }),
    nameStyle: css.css({
      maxWidth: "25ch",
      textOverflow: "ellipsis",
      overflow: "hidden"
    }),
    buttonStyles: css.css({
      margin: 0,
      "&:hover::before": {
        display: "none"
      }
    })
  };
};

const TagsInput = ({
  placeholder = "New tag (enter key to add)",
  tags = [],
  onChange,
  width,
  className,
  disabled,
  addOnBlur,
  invalid,
  id
}) => {
  const [newTagName, setNewTagName] = React.useState("");
  const styles = useStyles2(getStyles$12);
  const theme = useTheme2();
  const onNameChange = React.useCallback((event) => {
    setNewTagName(event.target.value);
  }, []);
  const onRemove = (tagToRemove) => {
    onChange(tags.filter((x) => x !== tagToRemove));
  };
  const onAdd = (event) => {
    event == null ? void 0 : event.preventDefault();
    if (!tags.includes(newTagName)) {
      onChange(tags.concat(newTagName));
    }
    setNewTagName("");
  };
  const onBlur = () => {
    if (addOnBlur && newTagName) {
      onAdd();
    }
  };
  const onKeyboardAdd = (event) => {
    if (event.key === "Enter" && newTagName !== "") {
      onAdd(event);
    }
  };
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.wrapper, className, width ? css.css({ width: theme.spacing(width) }) : "") }, /* @__PURE__ */ React__default["default"].createElement(
    Input,
    {
      id,
      disabled,
      placeholder,
      onChange: onNameChange,
      value: newTagName,
      onKeyDown: onKeyboardAdd,
      onBlur,
      invalid,
      suffix: /* @__PURE__ */ React__default["default"].createElement(
        Button,
        {
          fill: "text",
          className: styles.addButtonStyle,
          onClick: onAdd,
          size: "md",
          disabled: newTagName.length <= 0
        },
        "Add"
      )
    }
  ), (tags == null ? void 0 : tags.length) > 0 && /* @__PURE__ */ React__default["default"].createElement("ul", { className: styles.tags }, tags.map((tag) => /* @__PURE__ */ React__default["default"].createElement(TagItem, { key: tag, name: tag, onRemove, disabled }))));
};
const getStyles$12 = (theme) => ({
  wrapper: css.css({
    minHeight: theme.spacing(4),
    display: "flex",
    flexDirection: "column",
    gap: theme.spacing(1),
    flexWrap: "wrap"
  }),
  tags: css.css({
    display: "flex",
    justifyContent: "flex-start",
    flexWrap: "wrap",
    gap: theme.spacing(0.5)
  }),
  addButtonStyle: css.css({
    margin: `0 -${theme.spacing(1)}`
  })
});

const EllipsisAnimated = React__default["default"].memo(() => {
  const styles = useStyles2(getStyles$11);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.ellipsis }, /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.firstDot }, "."), /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.secondDot }, "."), /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.thirdDot }, "."));
});
EllipsisAnimated.displayName = "EllipsisAnimated";
const getStyles$11 = () => {
  return {
    ellipsis: css.css({
      display: "inline"
    }),
    firstDot: css.css({
      animation: `${firstDot} 2s linear infinite`
    }),
    secondDot: css.css({
      animation: `${secondDot} 2s linear infinite`
    }),
    thirdDot: css.css({
      animation: `${thirdDot} 2s linear infinite`
    })
  };
};
const firstDot = css.keyframes`
  0% {
    opacity: 1;
  }
  65% {
    opacity: 1;
  }
  66% {
    opacity: 0.5;
  }
  100% {
    opacity: 0;
  }
  `;
const secondDot = css.keyframes`
  0% {
    opacity: 0;
  }
  21% {
    opacity: 0.5;
  }
  22% {
    opacity: 1;
  }
  65% {
    opacity: 1;
  }
  66% {
    opacity: 0.5;
  }
  100% {
    opacity: 0;
  }
  `;
const thirdDot = css.keyframes`
  0% {
    opacity: 0;
  }
  43% {
    opacity: 0.5;
  }
  44% {
    opacity: 1;
  }
  65% {
    opacity: 1;
  }
  66% {
    opacity: 0.5;
  }
  100% {
    opacity: 0;
  }
  `;

var __defProp$1U = Object.defineProperty;
var __defProps$1c = Object.defineProperties;
var __getOwnPropDescs$1c = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1L = Object.getOwnPropertySymbols;
var __hasOwnProp$1L = Object.prototype.hasOwnProperty;
var __propIsEnum$1L = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1U = (obj, key, value) => key in obj ? __defProp$1U(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1K = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1L.call(b, prop))
      __defNormalProp$1U(a, prop, b[prop]);
  if (__getOwnPropSymbols$1L)
    for (var prop of __getOwnPropSymbols$1L(b)) {
      if (__propIsEnum$1L.call(b, prop))
        __defNormalProp$1U(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1c = (a, b) => __defProps$1c(a, __getOwnPropDescs$1c(b));
var __objRest$L = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1L.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1L)
    for (var prop of __getOwnPropSymbols$1L(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1L.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const SHOW_SUCCESS_DURATION = 2 * 1e3;
function AutoSaveField(props) {
  const _a = props, {
    invalid,
    loading,
    onFinishChange,
    saveErrorMessage = "Error saving this value",
    error,
    children,
    disabled
  } = _a, restProps = __objRest$L(_a, [
    "invalid",
    "loading",
    "onFinishChange",
    "saveErrorMessage",
    "error",
    "children",
    "disabled"
  ]);
  const [fieldState, setFieldState] = React__default["default"].useState({
    isLoading: false,
    showSuccess: false,
    showError: invalid
  });
  const fieldRef = React.useRef(null);
  React__default["default"].useEffect(() => {
    let timeoutId;
    if (fieldState.showSuccess) {
      const time = fieldState.showError ? 0 : SHOW_SUCCESS_DURATION;
      timeoutId = setTimeout(() => {
        setFieldState(__spreadProps$1c(__spreadValues$1K({}, fieldState), { showSuccess: false }));
      }, time);
    }
    return () => {
      window.clearTimeout(timeoutId);
    };
  }, [fieldState]);
  const handleChange = React.useCallback(
    (nextValue) => {
      if (invalid) {
        return;
      }
      setFieldState(__spreadProps$1c(__spreadValues$1K({}, fieldState), { isLoading: true, showSuccess: false }));
      onFinishChange(nextValue).then(() => {
        setFieldState({
          isLoading: false,
          showSuccess: true,
          showError: false
        });
      }).catch(() => {
        setFieldState(__spreadProps$1c(__spreadValues$1K({}, fieldState), {
          isLoading: false,
          showError: true
        }));
      });
    },
    [invalid, fieldState, onFinishChange]
  );
  const lodashDebounce = React.useMemo(() => lodash.debounce(handleChange, 600, { leading: false }), [handleChange]);
  const isInvalid = invalid || fieldState.showError || void 0;
  const styles = useStyles2(getStyles$10);
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(
    Field,
    __spreadProps$1c(__spreadValues$1K({}, restProps), {
      loading: loading || void 0,
      invalid: isInvalid,
      disabled,
      error: error || fieldState.showError && saveErrorMessage,
      ref: fieldRef,
      className: styles.widthFitContent
    }),
    React__default["default"].cloneElement(
      children((newValue) => {
        lodashDebounce(newValue);
      })
    )
  ), fieldState.isLoading && /* @__PURE__ */ React__default["default"].createElement(InlineToast, { referenceElement: fieldRef.current, placement: "right" }, "Saving ", /* @__PURE__ */ React__default["default"].createElement(EllipsisAnimated, null)), fieldState.showSuccess && /* @__PURE__ */ React__default["default"].createElement(InlineToast, { suffixIcon: "check", referenceElement: fieldRef.current, placement: "right" }, "Saved!"));
}
AutoSaveField.displayName = "AutoSaveField";
const getStyles$10 = () => {
  return {
    widthFitContent: css.css({
      width: "fit-content"
    })
  };
};

var __defProp$1T = Object.defineProperty;
var __defProps$1b = Object.defineProperties;
var __getOwnPropDescs$1b = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1K = Object.getOwnPropertySymbols;
var __hasOwnProp$1K = Object.prototype.hasOwnProperty;
var __propIsEnum$1K = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1T = (obj, key, value) => key in obj ? __defProp$1T(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1J = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1K.call(b, prop))
      __defNormalProp$1T(a, prop, b[prop]);
  if (__getOwnPropSymbols$1K)
    for (var prop of __getOwnPropSymbols$1K(b)) {
      if (__propIsEnum$1K.call(b, prop))
        __defNormalProp$1T(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1b = (a, b) => __defProps$1b(a, __getOwnPropDescs$1b(b));
var __objRest$K = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1K.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1K)
    for (var prop of __getOwnPropSymbols$1K(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1K.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const TagComponent = React.forwardRef((_a, ref) => {
  var _b = _a, { name, onClick, icon, className, colorIndex } = _b, rest = __objRest$K(_b, ["name", "onClick", "icon", "className", "colorIndex"]);
  const theme = useTheme2();
  const styles = getTagStyles$1(theme, name, colorIndex);
  const onTagClick = (event) => {
    event.preventDefault();
    event.stopPropagation();
    onClick == null ? void 0 : onClick(name, event);
  };
  const classes = css.cx(styles.wrapper, className, { [styles.hover]: onClick !== void 0 });
  return onClick ? /* @__PURE__ */ React__default["default"].createElement("button", __spreadProps$1b(__spreadValues$1J({}, rest), { className: classes, onClick: onTagClick, ref }), icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon }), name) : /* @__PURE__ */ React__default["default"].createElement("span", __spreadProps$1b(__spreadValues$1J({}, rest), { className: classes, ref }), icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon }), name);
});
TagComponent.displayName = "Tag";
const TagSkeleton = ({ rootProps }) => {
  const styles = useStyles2(getSkeletonStyles$2);
  return /* @__PURE__ */ React__default["default"].createElement(Skeleton__default["default"], __spreadValues$1J({ width: 60, height: 22, containerClassName: styles.container }, rootProps));
};
const Tag = attachSkeleton(TagComponent, TagSkeleton);
const getSkeletonStyles$2 = () => ({
  container: css.css({
    lineHeight: 1
  })
});
const getTagStyles$1 = (theme, name, colorIndex) => {
  let colors;
  if (colorIndex === void 0) {
    colors = getTagColorsFromName(name);
  } else {
    colors = getTagColor(colorIndex);
  }
  return {
    wrapper: css.css({
      appearance: "none",
      borderStyle: "none",
      fontWeight: theme.typography.fontWeightMedium,
      fontSize: theme.typography.size.sm,
      lineHeight: theme.typography.bodySmall.lineHeight,
      verticalAlign: "baseline",
      backgroundColor: colors.color,
      color: theme.v1.palette.gray98,
      whiteSpace: "nowrap",
      textShadow: "none",
      padding: "3px 6px",
      borderRadius: theme.shape.radius.default
    }),
    hover: css.css({
      "&:hover": {
        opacity: 0.85,
        cursor: "pointer"
      }
    })
  };
};

var __defProp$1S = Object.defineProperty;
var __getOwnPropSymbols$1J = Object.getOwnPropertySymbols;
var __hasOwnProp$1J = Object.prototype.hasOwnProperty;
var __propIsEnum$1J = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1S = (obj, key, value) => key in obj ? __defProp$1S(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1I = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1J.call(b, prop))
      __defNormalProp$1S(a, prop, b[prop]);
  if (__getOwnPropSymbols$1J)
    for (var prop of __getOwnPropSymbols$1J(b)) {
      if (__propIsEnum$1J.call(b, prop))
        __defNormalProp$1S(a, prop, b[prop]);
    }
  return a;
};
const TagListComponent = React.memo(
  React.forwardRef(
    ({ displayMax, tags, icon, onClick, className, getAriaLabel, getColorIndex }, ref) => {
      const theme = useTheme2();
      const styles = getStyles$$(theme, Boolean(displayMax && displayMax > 0));
      const numTags = tags.length;
      const tagsToDisplay = displayMax ? tags.slice(0, displayMax) : tags;
      return /* @__PURE__ */ React__default["default"].createElement("ul", { className: css.cx(styles.wrapper, className), "aria-label": "Tags", ref }, tagsToDisplay.map((tag, i) => /* @__PURE__ */ React__default["default"].createElement("li", { className: styles.li, key: tag }, /* @__PURE__ */ React__default["default"].createElement(
        Tag,
        {
          name: tag,
          icon,
          onClick,
          "aria-label": getAriaLabel == null ? void 0 : getAriaLabel(tag, i),
          "data-tag-id": i,
          colorIndex: getColorIndex == null ? void 0 : getColorIndex(tag, i)
        }
      ))), displayMax && displayMax > 0 && numTags - displayMax > 0 && /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.moreTagsLabel }, "+ ", numTags - displayMax));
    }
  )
);
TagListComponent.displayName = "TagList";
const TagListSkeleton = ({ rootProps }) => {
  const styles = useStyles2(getSkeletonStyles$1);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1I({ className: styles.container }, rootProps), /* @__PURE__ */ React__default["default"].createElement(Tag.Skeleton, null), /* @__PURE__ */ React__default["default"].createElement(Tag.Skeleton, null));
};
const TagList = attachSkeleton(TagListComponent, TagListSkeleton);
const getSkeletonStyles$1 = (theme) => ({
  container: css.css({
    display: "flex",
    gap: theme.spacing(1)
  })
});
const getStyles$$ = (theme, isTruncated) => {
  return {
    wrapper: css.css({
      position: "relative",
      alignItems: isTruncated ? "center" : "unset",
      display: "flex",
      flex: "1 1 auto",
      flexWrap: "wrap",
      flexShrink: isTruncated ? 0 : 1,
      justifyContent: "flex-end",
      gap: "6px"
    }),
    moreTagsLabel: css.css({
      color: theme.colors.text.secondary,
      fontSize: theme.typography.size.sm
    }),
    li: css.css({
      listStyle: "none"
    })
  };
};

const FilterPill = ({ label, selected, onClick, icon = "check" }) => {
  const styles = useStyles2(getStyles$_);
  const clearButton = useStyles2(clearButtonStyles);
  return /* @__PURE__ */ React__default["default"].createElement("button", { type: "button", className: css.cx(clearButton, styles.wrapper, selected && styles.selected), onClick }, /* @__PURE__ */ React__default["default"].createElement("span", null, label), selected && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, className: styles.icon }));
};
const getStyles$_ = (theme) => {
  return {
    wrapper: css.css({
      background: theme.colors.background.secondary,
      borderRadius: theme.shape.radius.pill,
      padding: theme.spacing(0, 2),
      fontSize: theme.typography.bodySmall.fontSize,
      fontWeight: theme.typography.fontWeightMedium,
      lineHeight: theme.typography.bodySmall.lineHeight,
      color: theme.colors.text.secondary,
      display: "flex",
      alignItems: "center",
      height: "32px",
      position: "relative",
      border: `1px solid ${theme.colors.background.secondary}`,
      whiteSpace: "nowrap",
      "&:hover": {
        background: theme.colors.action.hover,
        color: theme.colors.text.primary
      }
    }),
    selected: css.css({
      color: theme.colors.text.primary,
      background: theme.colors.action.selected,
      "&:hover": {
        background: theme.colors.action.focus
      }
    }),
    icon: css.css({
      marginLeft: theme.spacing(0.5)
    })
  };
};

const ModalHeader = ({ icon, iconTooltip, title, children, id }) => {
  const styles = useStyles2(getModalStyles);
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("h2", { className: styles.modalHeaderTitle, id }, title), children);
};

var __defProp$1R = Object.defineProperty;
var __defProps$1a = Object.defineProperties;
var __getOwnPropDescs$1a = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1I = Object.getOwnPropertySymbols;
var __hasOwnProp$1I = Object.prototype.hasOwnProperty;
var __propIsEnum$1I = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1R = (obj, key, value) => key in obj ? __defProp$1R(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1H = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1I.call(b, prop))
      __defNormalProp$1R(a, prop, b[prop]);
  if (__getOwnPropSymbols$1I)
    for (var prop of __getOwnPropSymbols$1I(b)) {
      if (__propIsEnum$1I.call(b, prop))
        __defNormalProp$1R(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$1a = (a, b) => __defProps$1a(a, __getOwnPropDescs$1a(b));
function Modal(props) {
  const {
    title,
    children,
    isOpen = false,
    closeOnEscape = true,
    closeOnBackdropClick = true,
    className,
    contentClassName,
    onDismiss,
    onClickBackdrop,
    trapFocus = true
  } = props;
  const styles = useStyles2(getModalStyles);
  const ref = React.useRef(null);
  const { overlayProps, underlayProps } = overlays.useOverlay(
    { isKeyboardDismissDisabled: !closeOnEscape, isOpen, onClose: onDismiss },
    ref
  );
  const { dialogProps, titleProps } = dialog.useDialog({}, ref);
  if (!isOpen) {
    return null;
  }
  const headerClass = css.cx(styles.modalHeader, typeof title !== "string" && styles.modalHeaderWithTabs);
  return /* @__PURE__ */ React__default["default"].createElement(overlays.OverlayContainer, null, /* @__PURE__ */ React__default["default"].createElement(
    "div",
    __spreadValues$1H({
      role: "presentation",
      className: styles.modalBackdrop,
      onClick: onClickBackdrop || (closeOnBackdropClick ? onDismiss : void 0)
    }, underlayProps)
  ), /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { contain: trapFocus, autoFocus: true, restoreFocus: true }, /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1H(__spreadValues$1H({ className: css.cx(styles.modal, className), ref }, overlayProps), dialogProps), /* @__PURE__ */ React__default["default"].createElement(
    "div",
    { className: headerClass },
    typeof title === "string" && /* @__PURE__ */ React__default["default"].createElement(DefaultModalHeader, __spreadProps$1a(__spreadValues$1H({}, props), { title, id: titleProps.id })),
    // FIXME: custom title components won't get an accessible title.
    // Do we really want to support them or shall we just limit this ModalTabsHeader?
    typeof title !== "string" && title,
    /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.modalHeaderClose }, /* @__PURE__ */ React__default["default"].createElement(
      IconButton,
      {
        name: "times",
        size: "xl",
        onClick: onDismiss,
        "aria-label": t("grafana-ui.modal.close-tooltip", "Close")
      }
    ))
  ), /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.modalContent, contentClassName) }, children))));
}
function ModalButtonRow({ leftItems, children }) {
  const styles = useStyles2(getModalStyles);
  if (leftItems) {
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.modalButtonRow }, /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, { justify: "space-between" }, /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, { justify: "flex-start", spacing: "md" }, leftItems), /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, { justify: "flex-end", spacing: "md" }, children)));
  }
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.modalButtonRow }, /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, { justify: "flex-end", spacing: "md", wrap: true }, children));
}
Modal.ButtonRow = ModalButtonRow;
function DefaultModalHeader({ icon, iconTooltip, title, id }) {
  return /* @__PURE__ */ React__default["default"].createElement(ModalHeader, { icon, iconTooltip, title, id });
}

const ConfirmModal = ({
  isOpen,
  title,
  body,
  description,
  confirmText,
  confirmVariant = "destructive",
  confirmationText,
  dismissText = "Cancel",
  dismissVariant = "secondary",
  alternativeText,
  modalClass,
  icon = "exclamation-triangle",
  onConfirm,
  onDismiss,
  onAlternative,
  confirmButtonVariant = "destructive"
}) => {
  const [disabled, setDisabled] = React.useState(Boolean(confirmationText));
  const styles = useStyles2(getStyles$Z);
  const buttonRef = React.useRef(null);
  const onConfirmationTextChange = (event) => {
    setDisabled((confirmationText == null ? void 0 : confirmationText.toLowerCase().localeCompare(event.currentTarget.value.toLowerCase())) !== 0);
  };
  React.useEffect(() => {
    var _a;
    if (isOpen) {
      (_a = buttonRef.current) == null ? void 0 : _a.focus();
    }
  }, [isOpen]);
  React.useEffect(() => {
    if (isOpen) {
      setDisabled(Boolean(confirmationText));
    }
  }, [isOpen, confirmationText]);
  const onConfirmClick = async () => {
    setDisabled(true);
    try {
      await onConfirm();
    } finally {
      setDisabled(false);
    }
  };
  return /* @__PURE__ */ React__default["default"].createElement(Modal, { className: css.cx(styles.modal, modalClass), title, icon, isOpen, onDismiss }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.modalText }, body, description ? /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.modalDescription }, description) : null, confirmationText ? /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.modalConfirmationInput }, /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, null, /* @__PURE__ */ React__default["default"].createElement(Input, { placeholder: `Type "${confirmationText}" to confirm`, onChange: onConfirmationTextChange }))) : null), /* @__PURE__ */ React__default["default"].createElement(Modal.ButtonRow, null, /* @__PURE__ */ React__default["default"].createElement(Button, { variant: dismissVariant, onClick: onDismiss, fill: "outline" }, dismissText), /* @__PURE__ */ React__default["default"].createElement(
    Button,
    {
      variant: confirmButtonVariant,
      onClick: onConfirmClick,
      disabled,
      ref: buttonRef,
      "data-testid": e2eSelectors.selectors.pages.ConfirmModal.delete
    },
    confirmText
  ), onAlternative ? /* @__PURE__ */ React__default["default"].createElement(Button, { variant: "primary", onClick: onAlternative }, alternativeText) : null));
};
const getStyles$Z = (theme) => ({
  modal: css.css({
    width: "500px"
  }),
  modalText: css.css({
    fontSize: theme.typography.h5.fontSize,
    color: theme.colors.text.primary
  }),
  modalDescription: css.css({
    fontSize: theme.typography.body.fontSize
  }),
  modalConfirmationInput: css.css({
    paddingTop: theme.spacing(1)
  })
});

const BRACES = {
  "[": "]",
  "{": "}",
  "(": ")"
};
const MATCH_MARK = "brace_match";
function BracesPlugin() {
  return {
    onKeyDown(event, editor, next) {
      const { value } = editor;
      switch (event.key) {
        case "(":
        case "{":
        case "[": {
          const {
            start: { offset: startOffset, key: startKey },
            end: { offset: endOffset, key: endKey },
            focus: { offset: focusOffset }
          } = value.selection;
          const text = value.focusText.text;
          if (value.selection.isExpanded) {
            event.preventDefault();
            editor.insertTextByKey(startKey, startOffset, event.key).insertTextByKey(endKey, endOffset + 1, BRACES[event.key]).moveEndBackward(1);
            return true;
          } else if (
            // Insert matching brace when there is no input after caret
            focusOffset === text.length || text[focusOffset] === " " || Object.values(BRACES).includes(text[focusOffset])
          ) {
            event.preventDefault();
            const complement = BRACES[event.key];
            const matchAnnotation = {
              key: `${MATCH_MARK}-${uuid.v4()}`,
              type: `${MATCH_MARK}-${complement}`,
              anchor: {
                key: startKey,
                offset: startOffset,
                object: "point"
              },
              focus: {
                key: endKey,
                offset: endOffset + 1,
                object: "point"
              },
              object: "annotation"
            };
            editor.insertText(event.key).insertText(complement).addAnnotation(matchAnnotation).moveBackward(1);
            return true;
          }
          break;
        }
        case ")":
        case "}":
        case "]": {
          const text = value.anchorText.text;
          const offset = value.selection.anchor.offset;
          const nextChar = text[offset];
          const complement = event.key;
          const annotationType = `${MATCH_MARK}-${complement}`;
          const annotation = value.annotations.find(
            (a) => (a == null ? void 0 : a.type) === annotationType && a.anchor.key === value.anchorText.key
          );
          if (annotation && nextChar === complement && !value.selection.isExpanded) {
            event.preventDefault();
            editor.moveFocusForward(1).removeAnnotation(annotation).moveAnchorForward(1);
            return true;
          }
          break;
        }
        case "Backspace": {
          const text = value.anchorText.text;
          const offset = value.selection.anchor.offset;
          const previousChar = text[offset - 1];
          const nextChar = text[offset];
          if (BRACES[previousChar] && BRACES[previousChar] === nextChar) {
            event.preventDefault();
            editor.deleteBackward(1).deleteForward(1).focus();
            return true;
          }
        }
      }
      return next();
    }
  };
}

function ClearPlugin() {
  return {
    onKeyDown(event, editor, next) {
      const value = editor.value;
      if (value.selection.isExpanded) {
        return next();
      }
      if (event.key === "k" && event.ctrlKey) {
        event.preventDefault();
        const text = value.anchorText.text;
        const offset = value.selection.anchor.offset;
        const length = text.length;
        const forward = length - offset;
        editor.deleteForward(forward);
        return true;
      }
      return next();
    }
  };
}

var __defProp$1Q = Object.defineProperty;
var __defProps$19 = Object.defineProperties;
var __getOwnPropDescs$19 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1H = Object.getOwnPropertySymbols;
var __hasOwnProp$1H = Object.prototype.hasOwnProperty;
var __propIsEnum$1H = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1Q = (obj, key, value) => key in obj ? __defProp$1Q(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1G = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1H.call(b, prop))
      __defNormalProp$1Q(a, prop, b[prop]);
  if (__getOwnPropSymbols$1H)
    for (var prop of __getOwnPropSymbols$1H(b)) {
      if (__propIsEnum$1H.call(b, prop))
        __defNormalProp$1Q(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$19 = (a, b) => __defProps$19(a, __getOwnPropDescs$19(b));
const getCopiedText = (textBlocks, startOffset, endOffset) => {
  if (!textBlocks.length) {
    return void 0;
  }
  const excludingLastLineLength = textBlocks.slice(0, -1).join("").length + textBlocks.length - 1;
  return textBlocks.join("\n").slice(startOffset, excludingLastLineLength + endOffset);
};
const removeBom = (str) => {
  return str == null ? void 0 : str.replace(/[\uFEFF]/g, "");
};
function ClipboardPlugin() {
  const clipboardPlugin = {
    onCopy(event, editor, next) {
      event.preventDefault();
      const { document, selection } = editor.value;
      const {
        start: { offset: startOffset },
        end: { offset: endOffset }
      } = selection;
      const selectedBlocks = document.getLeafBlocksAtRange(selection).toArray().map((block) => block.text);
      const copiedText = removeBom(getCopiedText(selectedBlocks, startOffset, endOffset));
      if (copiedText && event.clipboardData) {
        event.clipboardData.setData("Text", copiedText);
      }
      return true;
    },
    onPaste(event, editor, next) {
      event.preventDefault();
      if (event.clipboardData) {
        const pastedValue = removeBom(event.clipboardData.getData("Text"));
        const lines = pastedValue == null ? void 0 : pastedValue.split("\n");
        if (lines && lines.length) {
          editor.insertText(lines[0]);
          for (const line of lines.slice(1)) {
            editor.splitBlock().insertText(line);
          }
        }
      }
      return true;
    }
  };
  return __spreadProps$19(__spreadValues$1G({}, clipboardPlugin), {
    onCut(event, editor, next) {
      clipboardPlugin.onCopy(event, editor, next);
      editor.deleteAtRange(editor.value.selection);
      return true;
    }
  });
}

const isIndentLeftHotkey = isHotkey.isKeyHotkey("mod+[");
const isShiftTabHotkey = isHotkey.isKeyHotkey("shift+tab");
const isIndentRightHotkey = isHotkey.isKeyHotkey("mod+]");
const SLATE_TAB = "  ";
const handleTabKey = (event, editor, next) => {
  const {
    startBlock,
    endBlock,
    selection: {
      start: { offset: startOffset, key: startKey },
      end: { offset: endOffset, key: endKey }
    }
  } = editor.value;
  if (Plain__default["default"].serialize(editor.value) === "") {
    return;
  }
  event.preventDefault();
  const first = startBlock.getFirstText();
  const startBlockIsSelected = first && startOffset === 0 && startKey === first.key && endOffset === first.text.length && endKey === first.key;
  if (startBlockIsSelected || !startBlock.equals(endBlock)) {
    handleIndent(editor, "right");
  } else {
    editor.insertText(SLATE_TAB);
  }
};
const handleIndent = (editor, indentDirection) => {
  const curSelection = editor.value.selection;
  const selectedBlocks = editor.value.document.getLeafBlocksAtRange(curSelection).toArray();
  if (indentDirection === "left") {
    for (const block of selectedBlocks) {
      const blockWhitespace = block.text.length - block.text.trimLeft().length;
      const textKey = block.getFirstText().key;
      const rangeProperties = {
        anchor: {
          key: textKey,
          offset: blockWhitespace,
          path: []
        },
        focus: {
          key: textKey,
          offset: blockWhitespace,
          path: []
        }
      };
      editor.deleteBackwardAtRange(slate.Range.create(rangeProperties), Math.min(SLATE_TAB.length, blockWhitespace));
    }
  } else {
    const { startText } = editor.value;
    const textBeforeCaret = startText.text.slice(0, curSelection.start.offset);
    const isWhiteSpace = /^\s*$/.test(textBeforeCaret);
    for (const block of selectedBlocks) {
      editor.insertTextByKey(block.getFirstText().key, 0, SLATE_TAB);
    }
    if (isWhiteSpace) {
      editor.moveStartBackward(SLATE_TAB.length);
    }
  }
};
function IndentationPlugin() {
  return {
    onKeyDown(event, editor, next) {
      if (isIndentLeftHotkey(event) || isShiftTabHotkey(event)) {
        event.preventDefault();
        handleIndent(editor, "left");
      } else if (isIndentRightHotkey(event)) {
        event.preventDefault();
        handleIndent(editor, "right");
      } else if (event.key === "Tab") {
        handleTabKey(event, editor);
      } else {
        return next();
      }
      return true;
    }
  };
}

function getIndent(text) {
  let offset = text.length - text.trimLeft().length;
  if (offset) {
    let indent = text[0];
    while (--offset) {
      indent += text[0];
    }
    return indent;
  }
  return "";
}
function NewlinePlugin() {
  return {
    onKeyDown(event, editor, next) {
      const value = editor.value;
      if (value.selection.isExpanded) {
        return next();
      }
      if (event.key === "Enter") {
        event.preventDefault();
        const { startBlock } = value;
        const currentLineText = startBlock.text;
        const indent = getIndent(currentLineText);
        return editor.splitBlock().insertText(indent).focus();
      }
      return next();
    }
  };
}

function RunnerPlugin({ handler }) {
  return {
    onKeyDown(event, editor, next) {
      if (handler && event.key === "Enter" && (event.shiftKey || event.ctrlKey)) {
        event.preventDefault();
        handler(event);
        return editor;
      }
      return next();
    }
  };
}

const isSelectLineHotkey = isHotkey.isKeyHotkey("mod+l");
function SelectionShortcutsPlugin() {
  return {
    onKeyDown(event, editor, next) {
      if (isSelectLineHotkey(event)) {
        event.preventDefault();
        const { focusBlock, document } = editor.value;
        editor.moveAnchorToStartOfBlock();
        const nextBlock = document.getNextBlock(focusBlock.key);
        if (nextBlock) {
          editor.moveFocusToStartOfNextBlock();
        } else {
          editor.moveFocusToEndOfText();
        }
      } else {
        return next();
      }
      return true;
    }
  };
}

const TOKEN_MARK = "prism-token";

function defaultOnlyIn(node) {
  return node.object === "block" && node.type === "code_block";
}
function defaultGetSyntax(node) {
  return "javascript";
}
function defaultRenderDecoration(props, editor, next) {
  const { decoration } = props;
  if (decoration.type !== TOKEN_MARK) {
    return next();
  }
  const className = decoration.data.get("className");
  return /* @__PURE__ */ React__default["default"].createElement("span", { className }, props.children);
}
class Options extends immutable.Record({
  onlyIn: defaultOnlyIn,
  getSyntax: defaultGetSyntax,
  renderDecoration: defaultRenderDecoration
}) {
  constructor(props) {
    super(props);
  }
}

function SlatePrism(optsParam = {}, prismLanguages = Prism__default["default"].languages) {
  const opts = new Options(optsParam);
  return {
    decorateNode: (node, editor, next) => {
      if (!opts.onlyIn(node)) {
        return next();
      }
      const block = slate.Block.create(node);
      const grammarName = opts.getSyntax(block);
      const grammar = prismLanguages[grammarName];
      if (!grammar) {
        return [];
      }
      const texts = block.getTexts();
      const blockText = texts.map((text) => text && text.getText()).join("\n");
      const tokens = Prism__default["default"].tokenize(blockText, grammar);
      const flattened = flattenTokens(tokens);
      const newData = editor.value.data.set("tokens", flattened);
      editor.setData(newData);
      return decorateNode(opts, tokens, block);
    },
    renderDecoration: (props, editor, next) => opts.renderDecoration(
      {
        children: props.children,
        decoration: props.decoration
      },
      editor,
      next
    )
  };
}
function decorateNode(opts, tokens, block) {
  const texts = block.getTexts();
  const decorations = [];
  let textStart = 0;
  let textEnd = 0;
  texts.forEach((text) => {
    textEnd = textStart + text.getText().length;
    let offset = 0;
    function processToken(token, accu) {
      if (typeof token === "string") {
        if (accu) {
          const decoration = createDecoration({
            text,
            textStart,
            textEnd,
            start: offset,
            end: offset + token.length,
            className: `prism-token token ${accu}`,
            block
          });
          if (decoration) {
            decorations.push(decoration);
          }
        }
        offset += token.length;
      } else {
        accu = `${accu} ${token.type}`;
        if (token.alias) {
          accu += " " + token.alias;
        }
        if (typeof token.content === "string") {
          const decoration = createDecoration({
            text,
            textStart,
            textEnd,
            start: offset,
            end: offset + token.content.length,
            className: `prism-token token ${accu}`,
            block
          });
          if (decoration) {
            decorations.push(decoration);
          }
          offset += token.content.length;
        } else {
          for (let i = 0; i < token.content.length; i += 1) {
            processToken(token.content[i], accu);
          }
        }
      }
    }
    tokens.forEach(processToken);
    textStart = textEnd + 1;
  });
  return decorations;
}
function createDecoration({
  text,
  textStart,
  textEnd,
  start,
  end,
  className,
  block
}) {
  if (start >= textEnd || end <= textStart) {
    return null;
  }
  start = Math.max(start, textStart);
  end = Math.min(end, textEnd);
  start -= textStart;
  end -= textStart;
  const myDec = block.createDecoration({
    object: "decoration",
    anchor: {
      key: text.key,
      offset: start,
      object: "point"
    },
    focus: {
      key: text.key,
      offset: end,
      object: "point"
    },
    type: TOKEN_MARK,
    data: { className }
  });
  return myDec;
}
function flattenToken(token) {
  if (typeof token === "string") {
    return [
      {
        content: token,
        types: [],
        aliases: []
      }
    ];
  } else if (Array.isArray(token)) {
    return token.flatMap((t) => flattenToken(t));
  } else if (token instanceof Prism__default["default"].Token) {
    return flattenToken(token.content).flatMap((t) => {
      var _a;
      let aliases = [];
      if (typeof token.alias === "string") {
        aliases = [token.alias];
      } else {
        aliases = (_a = token.alias) != null ? _a : [];
      }
      return {
        content: t.content,
        types: [token.type, ...t.types],
        aliases: [...aliases, ...t.aliases]
      };
    });
  }
  return [];
}
function flattenTokens(token) {
  const tokens = flattenToken(token);
  if (!tokens.length) {
    return [];
  }
  const firstToken = tokens[0];
  firstToken.prev = null;
  firstToken.next = tokens.length >= 2 ? tokens[1] : null;
  firstToken.offsets = {
    start: 0,
    end: firstToken.content.length
  };
  for (let i = 1; i < tokens.length - 1; i++) {
    tokens[i].prev = tokens[i - 1];
    tokens[i].next = tokens[i + 1];
    tokens[i].offsets = {
      start: tokens[i - 1].offsets.end,
      end: tokens[i - 1].offsets.end + tokens[i].content.length
    };
  }
  const lastToken = tokens[tokens.length - 1];
  lastToken.prev = tokens.length >= 2 ? tokens[tokens.length - 2] : null;
  lastToken.next = null;
  lastToken.offsets = {
    start: tokens.length >= 2 ? tokens[tokens.length - 2].offsets.end : 0,
    end: tokens.length >= 2 ? tokens[tokens.length - 2].offsets.end + lastToken.content.length : lastToken.content.length
  };
  return tokens;
}

const flattenGroupItems = (groupedItems) => {
  return groupedItems.reduce((all, { items, label }) => {
    all.push({
      label,
      kind: CompletionItemKind.GroupTitle
    });
    return items.reduce((all2, item) => {
      all2.push(item);
      return all2;
    }, all);
  }, []);
};
const calculateLongestLabel = (allItems) => {
  return allItems.reduce((longest, current) => {
    return longest.length < current.label.length ? current.label : longest;
  }, "");
};
const calculateListSizes = (theme, allItems, longestLabel) => {
  const size = calculateSize__default["default"](longestLabel, {
    font: theme.typography.fontFamilyMonospace,
    fontSize: theme.typography.bodySmall.fontSize,
    fontWeight: "normal"
  });
  const listWidth = calculateListWidth(size.width, theme);
  const itemHeight = calculateItemHeight(size.height, theme);
  const listHeight = calculateListHeight(itemHeight, allItems);
  return {
    listWidth,
    listHeight,
    itemHeight
  };
};
const calculateItemHeight = (longestLabelHeight, theme) => {
  const horizontalPadding = theme.spacing.gridSize * 2;
  const itemHeight = longestLabelHeight + horizontalPadding;
  return itemHeight;
};
const calculateListWidth = (longestLabelWidth, theme) => {
  const verticalPadding = theme.spacing.gridSize * 3;
  const maxWidth = 800;
  const listWidth = Math.min(Math.max(longestLabelWidth + verticalPadding, 200), maxWidth);
  return listWidth;
};
const calculateListHeight = (itemHeight, allItems) => {
  const numberOfItemsToShow = Math.min(allItems.length, 10);
  const minHeight = 100;
  const totalHeight = numberOfItemsToShow * itemHeight;
  const listHeight = Math.max(totalHeight, minHeight);
  return listHeight;
};

const getStyles$Y = (theme, height, visible) => {
  return {
    typeaheadItem: css.css({
      label: "type-ahead-item",
      zIndex: 11,
      padding: theme.spacing(1, 1, 1, 2),
      border: theme.colors.border.medium,
      overflowY: "scroll",
      overflowX: "hidden",
      outline: "none",
      background: theme.colors.background.secondary,
      color: theme.colors.text.secondary,
      boxShadow: `0 0 20px ${theme.v1.colors.dropdownShadow}`,
      visibility: visible === true ? "visible" : "hidden",
      width: "250px",
      minHeight: `${height + parseInt(theme.spacing(0.25), 10)}px`,
      position: "relative",
      wordBreak: "break-word"
    })
  };
};
const TypeaheadInfo = ({ item, height }) => {
  const visible = item && !!item.documentation;
  const label = item ? item.label : "";
  const documentation = data.renderMarkdown(item == null ? void 0 : item.documentation);
  const theme = useTheme2();
  const styles = getStyles$Y(theme, height, visible);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx([styles.typeaheadItem]) }, /* @__PURE__ */ React__default["default"].createElement("b", null, label), /* @__PURE__ */ React__default["default"].createElement("hr", null), /* @__PURE__ */ React__default["default"].createElement("div", { dangerouslySetInnerHTML: { __html: documentation } }));
};

function getStartIndices(parts, length) {
  const indices = [];
  parts.forEach((part) => {
    indices.push(part.start, part.end + 1);
  });
  if (indices[0] !== 0) {
    indices.unshift(0);
  }
  if (indices[indices.length - 1] !== length) {
    indices.push(length);
  }
  return indices;
}
const PartialHighlighter = (props) => {
  let { highlightParts, text, highlightClassName } = props;
  if (!(highlightParts == null ? void 0 : highlightParts.length)) {
    return null;
  }
  let children = [];
  let indices = getStartIndices(highlightParts, text.length);
  let highlighted = highlightParts[0].start === 0;
  for (let i = 1; i < indices.length; i++) {
    let start = indices[i - 1];
    let end = indices[i];
    children.push(
      React.createElement(
        highlighted ? "mark" : "span",
        {
          key: i - 1,
          className: highlighted ? highlightClassName : void 0
        },
        text.substring(start, end)
      )
    );
    highlighted = !highlighted;
  }
  return /* @__PURE__ */ React__default["default"].createElement("div", null, children);
};

const getStyles$X = (theme) => ({
  typeaheadItem: css.css({
    border: "none",
    background: "none",
    textAlign: "left",
    label: "type-ahead-item",
    height: "auto",
    fontFamily: theme.typography.fontFamilyMonospace,
    padding: theme.spacing(1, 1, 1, 2),
    fontSize: theme.typography.bodySmall.fontSize,
    textOverflow: "ellipsis",
    overflow: "hidden",
    zIndex: 11,
    display: "block",
    whiteSpace: "nowrap",
    cursor: "pointer",
    transition: "color 0.3s cubic-bezier(0.645, 0.045, 0.355, 1), border-color 0.3s cubic-bezier(0.645, 0.045, 0.355, 1), background 0.3s cubic-bezier(0.645, 0.045, 0.355, 1), padding 0.15s cubic-bezier(0.645, 0.045, 0.355, 1)"
  }),
  typeaheadItemSelected: css.css({
    label: "type-ahead-item-selected",
    backgroundColor: theme.colors.background.secondary
  }),
  typeaheadItemMatch: css.css({
    label: "type-ahead-item-match",
    color: theme.v1.palette.yellow,
    borderBottom: `1px solid ${theme.v1.palette.yellow}`,
    padding: "inherit",
    background: "inherit"
  }),
  typeaheadItemGroupTitle: css.css({
    label: "type-ahead-item-group-title",
    color: theme.colors.text.secondary,
    fontSize: theme.typography.bodySmall.fontSize,
    lineHeight: theme.typography.body.lineHeight,
    padding: theme.spacing(1)
  })
});
const TypeaheadItem = (props) => {
  const styles = useStyles2(getStyles$X);
  const { isSelected, item, prefix, style, onMouseEnter, onMouseLeave, onClickItem } = props;
  const className = isSelected ? css.cx([styles.typeaheadItem, styles.typeaheadItemSelected]) : css.cx([styles.typeaheadItem]);
  const highlightClassName = css.cx([styles.typeaheadItemMatch]);
  const itemGroupTitleClassName = css.cx([styles.typeaheadItemGroupTitle]);
  const label = item.label || "";
  if (item.kind === CompletionItemKind.GroupTitle) {
    return /* @__PURE__ */ React__default["default"].createElement("li", { className: itemGroupTitleClassName, style }, /* @__PURE__ */ React__default["default"].createElement("span", null, label));
  }
  return /* @__PURE__ */ React__default["default"].createElement("li", { role: "none" }, /* @__PURE__ */ React__default["default"].createElement(
    "button",
    {
      role: "menuitem",
      className,
      style,
      onMouseDown: onClickItem,
      onMouseEnter,
      onMouseLeave,
      type: "button"
    },
    item.highlightParts !== void 0 ? /* @__PURE__ */ React__default["default"].createElement(
      PartialHighlighter,
      {
        text: label,
        highlightClassName,
        highlightParts: item.highlightParts
      }
    ) : /* @__PURE__ */ React__default["default"].createElement(
      Highlighter__default["default"],
      {
        textToHighlight: label,
        searchWords: [prefix != null ? prefix : ""],
        autoEscape: true,
        highlightClassName
      }
    )
  ));
};

var __defProp$1P = Object.defineProperty;
var __defNormalProp$1P = (obj, key, value) => key in obj ? __defProp$1P(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$j = (obj, key, value) => {
  __defNormalProp$1P(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
const modulo$1 = (a, n) => a - n * Math.floor(a / n);
class Typeahead extends React.PureComponent {
  constructor() {
    super(...arguments);
    __publicField$j(this, "context");
    __publicField$j(this, "listRef", React.createRef());
    __publicField$j(this, "state", {
      hoveredItem: null,
      typeaheadIndex: null,
      allItems: [],
      listWidth: -1,
      listHeight: -1,
      itemHeight: -1
    });
    __publicField$j(this, "componentDidMount", () => {
      if (this.props.menuRef) {
        this.props.menuRef(this);
      }
      document.addEventListener("selectionchange", this.handleSelectionChange);
      const allItems = flattenGroupItems(this.props.groupedItems);
      const longestLabel = calculateLongestLabel(allItems);
      const { listWidth, listHeight, itemHeight } = calculateListSizes(this.context, allItems, longestLabel);
      this.setState({
        listWidth,
        listHeight,
        itemHeight,
        allItems
      });
    });
    __publicField$j(this, "componentWillUnmount", () => {
      document.removeEventListener("selectionchange", this.handleSelectionChange);
    });
    __publicField$j(this, "handleSelectionChange", () => {
      this.forceUpdate();
    });
    __publicField$j(this, "componentDidUpdate", (prevProps, prevState) => {
      if (this.state.typeaheadIndex !== null && prevState.typeaheadIndex !== this.state.typeaheadIndex && this.listRef && this.listRef.current) {
        if (this.state.typeaheadIndex === 1) {
          this.listRef.current.scrollToItem(0);
          return;
        }
        this.listRef.current.scrollToItem(this.state.typeaheadIndex);
      }
      if (lodash.isEqual(prevProps.groupedItems, this.props.groupedItems) === false) {
        const allItems = flattenGroupItems(this.props.groupedItems);
        const longestLabel = calculateLongestLabel(allItems);
        const { listWidth, listHeight, itemHeight } = calculateListSizes(this.context, allItems, longestLabel);
        this.setState({ listWidth, listHeight, itemHeight, allItems, typeaheadIndex: null });
      }
    });
    __publicField$j(this, "onMouseEnter", (index) => {
      this.setState({
        hoveredItem: index
      });
    });
    __publicField$j(this, "onMouseLeave", () => {
      this.setState({
        hoveredItem: null
      });
    });
    __publicField$j(this, "moveMenuIndex", (moveAmount) => {
      const itemCount = this.state.allItems.length;
      if (itemCount) {
        const typeaheadIndex = this.state.typeaheadIndex || 0;
        let newTypeaheadIndex = modulo$1(typeaheadIndex + moveAmount, itemCount);
        if (this.state.allItems[newTypeaheadIndex].kind === CompletionItemKind.GroupTitle) {
          newTypeaheadIndex = modulo$1(newTypeaheadIndex + moveAmount, itemCount);
        }
        this.setState({
          typeaheadIndex: newTypeaheadIndex
        });
        return;
      }
    });
    __publicField$j(this, "insertSuggestion", () => {
      if (this.props.onSelectSuggestion && this.state.typeaheadIndex !== null) {
        this.props.onSelectSuggestion(this.state.allItems[this.state.typeaheadIndex]);
      }
    });
  }
  get menuPosition() {
    if (!window.getSelection) {
      return "";
    }
    const selection = window.getSelection();
    const node = selection && selection.anchorNode;
    if (node && node.parentElement) {
      const rect = node.parentElement.getBoundingClientRect();
      const scrollX = window.scrollX;
      const scrollY = window.scrollY;
      return `position: absolute; display: flex; top: ${rect.top + scrollY + rect.height + 6}px; left: ${rect.left + scrollX - 2}px`;
    }
    return "";
  }
  render() {
    const { prefix, isOpen = false, origin } = this.props;
    const { allItems, listWidth, listHeight, itemHeight, hoveredItem, typeaheadIndex } = this.state;
    const showDocumentation = hoveredItem || typeaheadIndex;
    const documentationItem = allItems[hoveredItem ? hoveredItem : typeaheadIndex || 0];
    return /* @__PURE__ */ React__default["default"].createElement(Portal, { origin, isOpen, style: this.menuPosition }, /* @__PURE__ */ React__default["default"].createElement("ul", { role: "menu", className: "typeahead", "data-testid": "typeahead" }, /* @__PURE__ */ React__default["default"].createElement(
      reactWindow.FixedSizeList,
      {
        ref: this.listRef,
        itemCount: allItems.length,
        itemSize: itemHeight,
        itemKey: (index) => {
          const item = allItems && allItems[index];
          const key = item ? `${index}-${item.label}` : `${index}`;
          return key;
        },
        width: listWidth,
        height: listHeight
      },
      ({ index, style }) => {
        const item = allItems && allItems[index];
        if (!item) {
          return null;
        }
        return /* @__PURE__ */ React__default["default"].createElement(
          TypeaheadItem,
          {
            onClickItem: () => this.props.onSelectSuggestion ? this.props.onSelectSuggestion(item) : {},
            isSelected: typeaheadIndex === null ? false : allItems[typeaheadIndex] === item,
            item,
            prefix,
            style,
            onMouseEnter: () => this.onMouseEnter(index),
            onMouseLeave: this.onMouseLeave
          }
        );
      }
    )), showDocumentation && /* @__PURE__ */ React__default["default"].createElement(TypeaheadInfo, { height: listHeight, item: documentationItem }));
  }
}
__publicField$j(Typeahead, "contextType", data.ThemeContext);
class Portal extends React.PureComponent {
  constructor(props) {
    super(props);
    __publicField$j(this, "node");
    const { index = 0, origin = "query", style } = props;
    this.node = document.createElement("div");
    this.node.setAttribute("style", style);
    this.node.classList.add(`slate-typeahead`, `slate-typeahead-${origin}-${index}`);
    document.body.appendChild(this.node);
  }
  componentWillUnmount() {
    document.body.removeChild(this.node);
  }
  render() {
    if (this.props.isOpen) {
      this.node.setAttribute("style", this.props.style);
      this.node.classList.add(`slate-typeahead--open`);
      return ReactDOM__default["default"].createPortal(this.props.children, this.node);
    } else {
      this.node.classList.remove(`slate-typeahead--open`);
    }
    return null;
  }
}

var __defProp$1O = Object.defineProperty;
var __defProps$18 = Object.defineProperties;
var __getOwnPropDescs$18 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1G = Object.getOwnPropertySymbols;
var __hasOwnProp$1G = Object.prototype.hasOwnProperty;
var __propIsEnum$1G = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1O = (obj, key, value) => key in obj ? __defProp$1O(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1F = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1G.call(b, prop))
      __defNormalProp$1O(a, prop, b[prop]);
  if (__getOwnPropSymbols$1G)
    for (var prop of __getOwnPropSymbols$1G(b)) {
      if (__propIsEnum$1G.call(b, prop))
        __defNormalProp$1O(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$18 = (a, b) => __defProps$18(a, __getOwnPropDescs$18(b));
const TYPEAHEAD_DEBOUNCE = 250;
function SuggestionsPlugin({
  onTypeahead,
  cleanText,
  onWillApplySuggestion,
  portalOrigin
}) {
  let typeaheadRef;
  let state = {
    groupedItems: [],
    typeaheadPrefix: "",
    typeaheadContext: "",
    typeaheadText: ""
  };
  const handleTypeaheadDebounced = lodash.debounce(handleTypeahead, TYPEAHEAD_DEBOUNCE);
  const setState = (update) => {
    state = __spreadValues$1F(__spreadValues$1F({}, state), update);
  };
  return {
    onBlur: (event, editor, next) => {
      state = __spreadProps$18(__spreadValues$1F({}, state), {
        groupedItems: []
      });
      return next();
    },
    onClick: (event, editor, next) => {
      state = __spreadProps$18(__spreadValues$1F({}, state), {
        groupedItems: []
      });
      return next();
    },
    onKeyDown: (event, editor, next) => {
      const currentSuggestions = state.groupedItems;
      const hasSuggestions = currentSuggestions.length;
      switch (event.key) {
        case "Escape": {
          if (hasSuggestions) {
            event.preventDefault();
            state = __spreadProps$18(__spreadValues$1F({}, state), {
              groupedItems: []
            });
            return editor.insertText("");
          }
          break;
        }
        case "ArrowDown":
        case "ArrowUp":
          if (hasSuggestions) {
            event.preventDefault();
            typeaheadRef.moveMenuIndex(event.key === "ArrowDown" ? 1 : -1);
            return;
          }
          break;
        case "Enter": {
          if (!(event.shiftKey || event.ctrlKey) && hasSuggestions) {
            event.preventDefault();
            return typeaheadRef.insertSuggestion();
          }
          break;
        }
        case "Tab": {
          if (hasSuggestions) {
            event.preventDefault();
            return typeaheadRef.insertSuggestion();
          }
          break;
        }
        default: {
          if (event.key.length === 1) {
            handleTypeaheadDebounced(editor, setState, onTypeahead, cleanText);
          }
          break;
        }
      }
      return next();
    },
    commands: {
      selectSuggestion: (editor, suggestion) => {
        const suggestions = state.groupedItems;
        if (!suggestions || !suggestions.length) {
          return editor;
        }
        const ed = editor.applyTypeahead(suggestion);
        handleTypeaheadDebounced(editor, setState, onTypeahead, cleanText);
        return ed;
      },
      applyTypeahead: (editor, suggestion) => {
        let suggestionText = suggestion.insertText || suggestion.label;
        const preserveSuffix = suggestion.kind === "function";
        const move = suggestion.move || 0;
        const moveForward = move > 0 ? move : 0;
        const moveBackward = move < 0 ? -move : 0;
        const { typeaheadPrefix, typeaheadText, typeaheadContext } = state;
        if (onWillApplySuggestion) {
          suggestionText = onWillApplySuggestion(suggestionText, {
            groupedItems: state.groupedItems,
            typeaheadContext,
            typeaheadPrefix,
            typeaheadText
          });
        }
        const { forward, backward } = getNumCharsToDelete(
          suggestionText,
          typeaheadPrefix,
          typeaheadText,
          preserveSuffix,
          suggestion.deleteBackwards,
          cleanText
        );
        if (suggestionText.match(/\n/)) {
          const fragment = makeFragment(suggestionText);
          editor.deleteBackward(backward).deleteForward(forward).insertFragment(fragment).focus();
          return editor;
        }
        state = __spreadProps$18(__spreadValues$1F({}, state), {
          groupedItems: []
        });
        editor.snapshotSelection().deleteBackward(backward).deleteForward(forward).insertText(suggestionText).moveForward(moveForward).moveBackward(moveBackward).focus();
        return editor;
      }
    },
    renderEditor(props, editor, next) {
      if (editor.value.selection.isExpanded) {
        return next();
      }
      const children = next();
      return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, children, /* @__PURE__ */ React__default["default"].createElement(
        Typeahead,
        {
          menuRef: (menu) => typeaheadRef = menu,
          origin: portalOrigin,
          prefix: state.typeaheadPrefix,
          isOpen: !!state.groupedItems.length,
          groupedItems: state.groupedItems,
          onSelectSuggestion: editor.selectSuggestion
        }
      ));
    }
  };
}
const handleTypeahead = async (editor, onStateChange, onTypeahead, cleanText) => {
  if (!onTypeahead) {
    return;
  }
  const { value } = editor;
  const { selection } = value;
  const parentBlock = value.document.getClosestBlock(value.focusBlock.key);
  const selectionStartOffset = value.selection.start.offset - 1;
  const decorations = parentBlock && parentBlock.getDecorations(editor);
  const filteredDecorations = decorations ? decorations.filter(
    (decoration) => decoration.start.offset <= selectionStartOffset && decoration.end.offset > selectionStartOffset && decoration.type === TOKEN_MARK
  ).toArray() : [];
  const labelKeyDec = decorations && decorations.filter(
    (decoration) => decoration.end.offset <= selectionStartOffset && decoration.type === TOKEN_MARK && decoration.data.get("className").includes("label-key")
  ).last();
  const labelKey = labelKeyDec && value.focusText.text.slice(labelKeyDec.start.offset, labelKeyDec.end.offset);
  const wrapperClasses = filteredDecorations.map((decoration) => decoration.data.get("className")).join(" ").split(" ").filter((className) => className.length);
  let text = value.focusText.text;
  let prefix = text.slice(0, selection.focus.offset);
  if (filteredDecorations.length) {
    text = value.focusText.text.slice(filteredDecorations[0].start.offset, filteredDecorations[0].end.offset);
    prefix = value.focusText.text.slice(filteredDecorations[0].start.offset, selection.focus.offset);
  }
  const labelValueMatch = prefix.match(/(?:!?=~?"?|")(.*)/);
  if (labelValueMatch) {
    prefix = labelValueMatch[1];
  } else if (cleanText) {
    prefix = cleanText(prefix);
  }
  const { suggestions, context } = await onTypeahead({
    prefix,
    text,
    value,
    wrapperClasses,
    labelKey: labelKey || void 0,
    editor
  });
  const filteredSuggestions = suggestions.map((group) => {
    if (!group.items) {
      return group;
    }
    const searchFunctionType = group.searchFunctionType || (group.prefixMatch ? SearchFunctionType.Prefix : SearchFunctionType.Word);
    const searchFunction = SearchFunctionMap[searchFunctionType];
    let newGroup = __spreadValues$1F({}, group);
    if (prefix) {
      if (!group.skipFilter) {
        newGroup.items = newGroup.items.filter((c) => (c.filterText || c.label).length >= prefix.length);
        newGroup.items = searchFunction(newGroup.items, prefix);
      }
      newGroup.items = newGroup.items.filter(
        (c) => {
          var _a;
          return !(c.insertText === prefix || ((_a = c.filterText) != null ? _a : c.label) === prefix);
        }
      );
    }
    if (!group.skipSort) {
      newGroup.items = lodash.sortBy(newGroup.items, (item) => {
        if (item.sortText === void 0) {
          return item.sortValue !== void 0 ? item.sortValue : item.label;
        } else {
          return item.sortText || item.label;
        }
      });
    }
    return newGroup;
  }).filter((gr) => gr.items && gr.items.length);
  onStateChange({
    groupedItems: filteredSuggestions,
    typeaheadPrefix: prefix,
    typeaheadContext: context,
    typeaheadText: text
  });
  editor.blur().focus();
};
function getNumCharsToDelete(suggestionText, typeaheadPrefix, typeaheadText, preserveSuffix, deleteBackwards, cleanText) {
  const backward = deleteBackwards || typeaheadPrefix.length;
  const text = cleanText ? cleanText(typeaheadText) : typeaheadText;
  const offset = typeaheadText.indexOf(typeaheadPrefix);
  const suffixLength = offset > -1 ? text.length - offset - typeaheadPrefix.length : text.length - typeaheadPrefix.length;
  const midWord = Boolean(typeaheadPrefix && suffixLength > 0 || suggestionText === typeaheadText);
  const forward = midWord && !preserveSuffix ? suffixLength + offset : 0;
  return {
    forward,
    backward
  };
}

var __defProp$1N = Object.defineProperty;
var __defNormalProp$1N = (obj, key, value) => key in obj ? __defProp$1N(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$i = (obj, key, value) => {
  __defNormalProp$1N(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
class UnThemedQueryField extends React.PureComponent {
  constructor(props) {
    super(props);
    __publicField$i(this, "plugins");
    __publicField$i(this, "runOnChangeDebounced");
    __publicField$i(this, "lastExecutedValue", null);
    __publicField$i(this, "mounted", false);
    __publicField$i(this, "editor", null);
    /**
     * Update local state, propagate change upstream and optionally run the query afterwards.
     */
    __publicField$i(this, "onChange", (value, runQuery) => {
      const documentChanged = value.document !== this.state.value.document;
      const prevValue = this.state.value;
      if (this.props.onRichValueChange) {
        this.props.onRichValueChange(value);
      }
      this.setState({ value }, () => {
        if (documentChanged) {
          const textChanged = Plain__default["default"].serialize(prevValue) !== Plain__default["default"].serialize(value);
          if (textChanged && runQuery) {
            this.runOnChangeAndRunQuery();
          }
          if (textChanged && !runQuery) {
            this.runOnChangeDebounced();
          }
        }
      });
    });
    __publicField$i(this, "runOnChange", () => {
      const { onChange } = this.props;
      const value = Plain__default["default"].serialize(this.state.value);
      if (onChange) {
        onChange(this.cleanText(value));
      }
    });
    __publicField$i(this, "runOnRunQuery", () => {
      const { onRunQuery } = this.props;
      if (onRunQuery) {
        onRunQuery();
        this.lastExecutedValue = this.state.value;
      }
    });
    __publicField$i(this, "runOnChangeAndRunQuery", () => {
      this.runOnChange();
      this.runOnRunQuery();
    });
    /**
     * We need to handle blur events here mainly because of dashboard panels which expect to have query executed on blur.
     */
    __publicField$i(this, "handleBlur", (_, editor, next) => {
      const { onBlur } = this.props;
      if (onBlur) {
        onBlur();
      } else {
        const previousValue = this.lastExecutedValue ? Plain__default["default"].serialize(this.lastExecutedValue) : "";
        const currentValue = Plain__default["default"].serialize(editor.value);
        if (previousValue !== currentValue) {
          this.runOnChangeAndRunQuery();
        }
      }
      return next();
    });
    this.runOnChangeDebounced = lodash.debounce(this.runOnChange, 500);
    const { onTypeahead, cleanText, portalOrigin, onWillApplySuggestion } = props;
    this.plugins = [
      // SuggestionsPlugin and RunnerPlugin need to be before NewlinePlugin
      // because they override Enter behavior
      SuggestionsPlugin({ onTypeahead, cleanText, portalOrigin, onWillApplySuggestion }),
      RunnerPlugin({ handler: this.runOnChangeAndRunQuery }),
      NewlinePlugin(),
      ClearPlugin(),
      SelectionShortcutsPlugin(),
      IndentationPlugin(),
      ClipboardPlugin(),
      ...props.additionalPlugins || []
    ].filter((p) => p);
    this.state = {
      suggestions: [],
      typeaheadContext: null,
      typeaheadPrefix: "",
      typeaheadText: "",
      value: makeValue(props.query || "", props.syntax)
    };
  }
  componentDidMount() {
    this.mounted = true;
  }
  componentWillUnmount() {
    this.mounted = false;
  }
  componentDidUpdate(prevProps, prevState) {
    const { query, syntax, syntaxLoaded } = this.props;
    if (!prevProps.syntaxLoaded && syntaxLoaded && this.editor) {
      const editor = this.editor.insertText(" ").deleteBackward(1);
      this.onChange(editor.value, true);
    }
    const { value } = this.state;
    if (query !== prevProps.query) {
      if (query !== Plain__default["default"].serialize(value)) {
        this.setState({ value: makeValue(query || "", syntax) });
      }
    }
  }
  cleanText(text) {
    const newText = text.replace(/[\r]/g, "");
    return newText;
  }
  render() {
    const { disabled, theme } = this.props;
    const wrapperClassName = classNames__default["default"]("slate-query-field__wrapper", {
      "slate-query-field__wrapper--disabled": disabled
    });
    const styles = getStyles$W(theme);
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(wrapperClassName, styles.wrapper) }, /* @__PURE__ */ React__default["default"].createElement("div", { className: "slate-query-field", "data-testid": e2eSelectors.selectors.components.QueryField.container }, /* @__PURE__ */ React__default["default"].createElement(
      slateReact.Editor,
      {
        ref: (editor) => this.editor = editor,
        schema: SCHEMA,
        autoCorrect: false,
        readOnly: this.props.disabled,
        onBlur: this.handleBlur,
        onClick: this.props.onClick,
        onChange: (change) => {
          this.onChange(change.value, false);
        },
        placeholder: this.props.placeholder,
        plugins: this.plugins,
        spellCheck: false,
        value: this.state.value
      }
    )));
  }
}
const QueryField = withTheme2(UnThemedQueryField);
QueryField.defaultProps = {
  onBlur: () => {
  }
};
const getStyles$W = (theme) => {
  const focusStyles = getFocusStyles(theme);
  return {
    wrapper: css.css({
      "&:focus-within": focusStyles
    })
  };
};

var __defProp$1M = Object.defineProperty;
var __defProps$17 = Object.defineProperties;
var __getOwnPropDescs$17 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1F = Object.getOwnPropertySymbols;
var __hasOwnProp$1F = Object.prototype.hasOwnProperty;
var __propIsEnum$1F = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1M = (obj, key, value) => key in obj ? __defProp$1M(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1E = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1F.call(b, prop))
      __defNormalProp$1M(a, prop, b[prop]);
  if (__getOwnPropSymbols$1F)
    for (var prop of __getOwnPropSymbols$1F(b)) {
      if (__propIsEnum$1F.call(b, prop))
        __defNormalProp$1M(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$17 = (a, b) => __defProps$17(a, __getOwnPropDescs$17(b));
const useAsyncDependency = (importStatement) => {
  const state = reactUse.useAsync(async () => {
    return await importStatement;
  });
  return __spreadProps$17(__spreadValues$1E({}, state), {
    dependency: state.value
  });
};

const ErrorWithStack = ({ error, errorInfo, title }) => {
  const style = useStyles2(getStyles$V);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: style }, /* @__PURE__ */ React__default["default"].createElement("h2", null, title), /* @__PURE__ */ React__default["default"].createElement("details", { style: { whiteSpace: "pre-wrap" } }, error && error.toString(), /* @__PURE__ */ React__default["default"].createElement("br", null), errorInfo && errorInfo.componentStack));
};
ErrorWithStack.displayName = "ErrorWithStack";
const getStyles$V = () => {
  return css.css({
    width: "500px",
    margin: "64px auto"
  });
};

var __defProp$1L = Object.defineProperty;
var __getOwnPropSymbols$1E = Object.getOwnPropertySymbols;
var __hasOwnProp$1E = Object.prototype.hasOwnProperty;
var __propIsEnum$1E = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1L = (obj, key, value) => key in obj ? __defProp$1L(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1D = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1E.call(b, prop))
      __defNormalProp$1L(a, prop, b[prop]);
  if (__getOwnPropSymbols$1E)
    for (var prop of __getOwnPropSymbols$1E(b)) {
      if (__propIsEnum$1E.call(b, prop))
        __defNormalProp$1L(a, prop, b[prop]);
    }
  return a;
};
const ReactMonacoEditorLazy = (props) => {
  const { loading, error, dependency } = useAsyncDependency(
    Promise.resolve().then(function () { return require(
      /* webpackChunkName: "react-monaco-editor" */
      './ReactMonacoEditor-3c82a1b1.js'
    ); })
  );
  if (loading) {
    return /* @__PURE__ */ React__default["default"].createElement(LoadingPlaceholder, { text: "" });
  }
  if (error) {
    return /* @__PURE__ */ React__default["default"].createElement(
      ErrorWithStack,
      {
        title: "React Monaco Editor failed to load",
        error,
        errorInfo: { componentStack: (error == null ? void 0 : error.stack) || "" }
      }
    );
  }
  const ReactMonacoEditor = dependency.ReactMonacoEditor;
  return /* @__PURE__ */ React__default["default"].createElement(ReactMonacoEditor, __spreadValues$1D({}, props));
};

var CodeEditorSuggestionItemKind = /* @__PURE__ */ ((CodeEditorSuggestionItemKind2) => {
  CodeEditorSuggestionItemKind2["Method"] = "method";
  CodeEditorSuggestionItemKind2["Field"] = "field";
  CodeEditorSuggestionItemKind2["Property"] = "property";
  CodeEditorSuggestionItemKind2["Constant"] = "constant";
  CodeEditorSuggestionItemKind2["Text"] = "text";
  return CodeEditorSuggestionItemKind2;
})(CodeEditorSuggestionItemKind || {});

var __defProp$1K = Object.defineProperty;
var __defProps$16 = Object.defineProperties;
var __getOwnPropDescs$16 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1D = Object.getOwnPropertySymbols;
var __hasOwnProp$1D = Object.prototype.hasOwnProperty;
var __propIsEnum$1D = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1K = (obj, key, value) => key in obj ? __defProp$1K(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1C = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1D.call(b, prop))
      __defNormalProp$1K(a, prop, b[prop]);
  if (__getOwnPropSymbols$1D)
    for (var prop of __getOwnPropSymbols$1D(b)) {
      if (__propIsEnum$1D.call(b, prop))
        __defNormalProp$1K(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$16 = (a, b) => __defProps$16(a, __getOwnPropDescs$16(b));
function findInsertIndex(line) {
  for (let i = line.length - 1; i > 0; i--) {
    const ch = line.charAt(i);
    if (ch === "$") {
      return {
        index: i,
        prefix: line.substring(i)
      };
    }
    if (ch === " " || ch === "	" || ch === '"' || ch === "'") {
      return {
        index: i + 1,
        prefix: line.substring(i + 1)
      };
    }
  }
  return {
    index: 0,
    prefix: line
  };
}
function getCompletionItems(monaco, prefix, suggestions, range) {
  var _a;
  const items = [];
  for (const suggestion of suggestions) {
    if (prefix && !suggestion.label.startsWith(prefix)) {
      continue;
    }
    items.push(__spreadProps$16(__spreadValues$1C({}, suggestion), {
      kind: mapKinds(monaco, suggestion.kind),
      range,
      insertText: (_a = suggestion.insertText) != null ? _a : suggestion.label
    }));
  }
  return items;
}
function mapKinds(monaco, sug) {
  switch (sug) {
    case CodeEditorSuggestionItemKind.Method:
      return monaco.languages.CompletionItemKind.Method;
    case CodeEditorSuggestionItemKind.Field:
      return monaco.languages.CompletionItemKind.Field;
    case CodeEditorSuggestionItemKind.Property:
      return monaco.languages.CompletionItemKind.Property;
    case CodeEditorSuggestionItemKind.Constant:
      return monaco.languages.CompletionItemKind.Constant;
    case CodeEditorSuggestionItemKind.Text:
      return monaco.languages.CompletionItemKind.Text;
  }
  return monaco.languages.CompletionItemKind.Text;
}
function registerSuggestions(monaco, language, getSuggestions, modelId) {
  if (!language || !getSuggestions) {
    return void 0;
  }
  return monaco.languages.registerCompletionItemProvider(language, {
    triggerCharacters: ["$"],
    provideCompletionItems: (model, position, context) => {
      if (model.id !== modelId) {
        return void 0;
      }
      const range = {
        startLineNumber: position.lineNumber,
        endLineNumber: position.lineNumber,
        startColumn: position.column,
        endColumn: position.column
      };
      if (context.triggerCharacter === "$") {
        range.startColumn = position.column - 1;
        return {
          suggestions: getCompletionItems(monaco, "$", getSuggestions(), range)
        };
      }
      const currentLine = model.getValueInRange({
        startLineNumber: position.lineNumber,
        startColumn: 1,
        endLineNumber: position.lineNumber,
        endColumn: position.column
      });
      const { index, prefix } = findInsertIndex(currentLine);
      range.startColumn = index + 1;
      const suggestions = getCompletionItems(monaco, prefix, getSuggestions(), range);
      if (suggestions.length) {
        return { suggestions };
      }
      return void 0;
    }
  });
}

var __defProp$1J = Object.defineProperty;
var __getOwnPropSymbols$1C = Object.getOwnPropertySymbols;
var __hasOwnProp$1C = Object.prototype.hasOwnProperty;
var __propIsEnum$1C = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1J = (obj, key, value) => key in obj ? __defProp$1J(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1B = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1C.call(b, prop))
      __defNormalProp$1J(a, prop, b[prop]);
  if (__getOwnPropSymbols$1C)
    for (var prop of __getOwnPropSymbols$1C(b)) {
      if (__propIsEnum$1C.call(b, prop))
        __defNormalProp$1J(a, prop, b[prop]);
    }
  return a;
};
var __objRest$J = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1C.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1C)
    for (var prop of __getOwnPropSymbols$1C(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1C.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
var __publicField$h = (obj, key, value) => {
  __defNormalProp$1J(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
class UnthemedCodeEditor extends React.PureComponent {
  constructor(props) {
    super(props);
    __publicField$h(this, "completionCancel");
    __publicField$h(this, "monaco");
    __publicField$h(this, "modelId");
    __publicField$h(this, "loadCustomLanguage", () => {
      const { language } = this.props;
      const customLanguage = data.monacoLanguageRegistry.getIfExists(language);
      if (customLanguage) {
        return customLanguage.init();
      }
      return Promise.resolve();
    });
    // This is replaced with a real function when the actual editor mounts
    __publicField$h(this, "getEditorValue", () => "");
    __publicField$h(this, "onBlur", () => {
      const { onBlur } = this.props;
      if (onBlur) {
        onBlur(this.getEditorValue());
      }
    });
    __publicField$h(this, "onFocus", () => {
      const { onFocus } = this.props;
      if (onFocus) {
        onFocus(this.getEditorValue());
      }
    });
    __publicField$h(this, "onSave", () => {
      const { onSave } = this.props;
      if (onSave) {
        onSave(this.getEditorValue());
      }
    });
    __publicField$h(this, "handleBeforeMount", (monaco) => {
      this.monaco = monaco;
      const { onBeforeEditorMount } = this.props;
      onBeforeEditorMount == null ? void 0 : onBeforeEditorMount(monaco);
    });
    __publicField$h(this, "handleOnMount", (editor, monaco) => {
      var _a, _b;
      const { getSuggestions, language, onChange, onEditorDidMount } = this.props;
      this.modelId = (_a = editor.getModel()) == null ? void 0 : _a.id;
      this.getEditorValue = () => editor.getValue();
      if (getSuggestions && this.modelId) {
        this.completionCancel = registerSuggestions(monaco, language, getSuggestions, this.modelId);
      }
      editor.onKeyDown((e) => {
        if (e.keyCode === monaco.KeyCode.KeyS && (e.ctrlKey || e.metaKey)) {
          e.preventDefault();
          this.onSave();
        }
      });
      const languagePromise = this.loadCustomLanguage();
      if (onChange) {
        (_b = editor.getModel()) == null ? void 0 : _b.onDidChangeContent(() => onChange(editor.getValue()));
      }
      if (onEditorDidMount) {
        languagePromise.then(() => onEditorDidMount(editor, monaco));
      }
    });
  }
  componentWillUnmount() {
    var _a, _b;
    if (this.completionCancel) {
      this.completionCancel.dispose();
    }
    (_b = (_a = this.props).onEditorWillUnmount) == null ? void 0 : _b.call(_a);
  }
  componentDidUpdate(oldProps) {
    const { getSuggestions, language } = this.props;
    const newLanguage = oldProps.language !== language;
    const newGetSuggestions = oldProps.getSuggestions !== getSuggestions;
    if (newGetSuggestions || newLanguage) {
      if (this.completionCancel) {
        this.completionCancel.dispose();
      }
      if (!this.monaco) {
        console.warn("Monaco instance not loaded yet");
        return;
      }
      if (getSuggestions && this.modelId) {
        this.completionCancel = registerSuggestions(this.monaco, language, getSuggestions, this.modelId);
      }
    }
    if (newLanguage) {
      this.loadCustomLanguage();
    }
  }
  render() {
    var _b, _c;
    const { theme, language, width, height, showMiniMap, showLineNumbers, readOnly, monacoOptions } = this.props;
    const _a = monacoOptions != null ? monacoOptions : {}, { alwaysConsumeMouseWheel } = _a, restMonacoOptions = __objRest$J(_a, ["alwaysConsumeMouseWheel"]);
    const value = (_b = this.props.value) != null ? _b : "";
    const longText = value.length > 100;
    const containerStyles = (_c = this.props.containerStyles) != null ? _c : getStyles$U(theme).container;
    const options = {
      wordWrap: "off",
      tabSize: 2,
      codeLens: false,
      contextmenu: false,
      minimap: {
        enabled: longText && showMiniMap,
        renderCharacters: false
      },
      readOnly,
      lineNumbersMinChars: 4,
      lineDecorationsWidth: 1 * theme.spacing.gridSize,
      overviewRulerBorder: false,
      automaticLayout: true,
      padding: {
        top: 0.5 * theme.spacing.gridSize,
        bottom: 0.5 * theme.spacing.gridSize
      },
      fixedOverflowWidgets: true,
      // Ensures suggestions menu is drawn on top
      scrollbar: {
        alwaysConsumeMouseWheel: alwaysConsumeMouseWheel != null ? alwaysConsumeMouseWheel : false
      }
    };
    if (!showLineNumbers) {
      options.glyphMargin = false;
      options.folding = false;
      options.lineNumbers = "off";
      options.lineNumbersMinChars = 0;
    }
    return /* @__PURE__ */ React__default["default"].createElement(
      "div",
      {
        className: containerStyles,
        onFocus: this.onFocus,
        onBlur: this.onBlur,
        "data-testid": e2eSelectors.selectors.components.CodeEditor.container
      },
      /* @__PURE__ */ React__default["default"].createElement(
        ReactMonacoEditorLazy,
        {
          width,
          height,
          language,
          value,
          options: __spreadValues$1B(__spreadValues$1B({}, options), restMonacoOptions != null ? restMonacoOptions : {}),
          beforeMount: this.handleBeforeMount,
          onMount: this.handleOnMount,
          keepCurrentModel: true
        }
      )
    );
  }
}
const CodeEditor = withTheme2(UnthemedCodeEditor);
const getStyles$U = (theme) => {
  return {
    container: css.css({
      borderRadius: theme.shape.radius.default,
      border: `1px solid ${theme.components.input.borderColor}`
    })
  };
};

function variableSuggestionToCodeEditorSuggestion(sug) {
  const label = "${" + sug.value + "}";
  const detail = sug.value === sug.label ? sug.origin : `${sug.label} / ${sug.origin}`;
  return {
    label,
    kind: CodeEditorSuggestionItemKind.Property,
    detail,
    documentation: sug.documentation
  };
}

const ModalTabsHeader = ({ icon, title, tabs, activeTab, onChangeTab }) => {
  return /* @__PURE__ */ React__default["default"].createElement(ModalHeader, { icon, title }, /* @__PURE__ */ React__default["default"].createElement(TabsBar, { hideBorder: true }, tabs.map((t, index) => {
    return /* @__PURE__ */ React__default["default"].createElement(
      Tab,
      {
        key: `${t.value}-${index}`,
        label: t.label,
        icon: t.icon,
        suffix: t.tabSuffix,
        active: t.value === activeTab,
        onChangeTab: () => onChangeTab(t)
      }
    );
  })));
};

const ModalTabContent = ({ children }) => {
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: "share-modal-body" }, /* @__PURE__ */ React__default["default"].createElement("div", { className: "share-modal-header" }, /* @__PURE__ */ React__default["default"].createElement("div", { className: "share-modal-content" }, children)));
};

var __defProp$1I = Object.defineProperty;
var __getOwnPropSymbols$1B = Object.getOwnPropertySymbols;
var __hasOwnProp$1B = Object.prototype.hasOwnProperty;
var __propIsEnum$1B = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1I = (obj, key, value) => key in obj ? __defProp$1I(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1A = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1B.call(b, prop))
      __defNormalProp$1I(a, prop, b[prop]);
  if (__getOwnPropSymbols$1B)
    for (var prop of __getOwnPropSymbols$1B(b)) {
      if (__propIsEnum$1B.call(b, prop))
        __defNormalProp$1I(a, prop, b[prop]);
    }
  return a;
};
var __publicField$g = (obj, key, value) => {
  __defNormalProp$1I(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
const ModalsContext = React__default["default"].createContext({
  component: null,
  props: {},
  showModal: () => {
  },
  hideModal: () => {
  }
});
class ModalsProvider extends React.Component {
  constructor(props) {
    super(props);
    __publicField$g(this, "showModal", (component, props) => {
      this.setState({
        component,
        props
      });
    });
    __publicField$g(this, "hideModal", () => {
      this.setState({
        component: null,
        props: {}
      });
    });
    this.state = {
      component: props.component || null,
      props: props.props || {},
      showModal: this.showModal,
      hideModal: this.hideModal
    };
  }
  render() {
    return /* @__PURE__ */ React__default["default"].createElement(ModalsContext.Provider, { value: this.state }, this.props.children);
  }
}
const ModalRoot = () => /* @__PURE__ */ React__default["default"].createElement(ModalsContext.Consumer, null, ({ component: Component2, props }) => {
  return Component2 ? /* @__PURE__ */ React__default["default"].createElement(Component2, __spreadValues$1A({}, props)) : null;
});
const ModalsController = ModalsContext.Consumer;

var __defProp$1H = Object.defineProperty;
var __getOwnPropSymbols$1A = Object.getOwnPropertySymbols;
var __hasOwnProp$1A = Object.prototype.hasOwnProperty;
var __propIsEnum$1A = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1H = (obj, key, value) => key in obj ? __defProp$1H(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1z = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1A.call(b, prop))
      __defNormalProp$1H(a, prop, b[prop]);
  if (__getOwnPropSymbols$1A)
    for (var prop of __getOwnPropSymbols$1A(b)) {
      if (__propIsEnum$1A.call(b, prop))
        __defNormalProp$1H(a, prop, b[prop]);
    }
  return a;
};
var __objRest$I = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1A.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1A)
    for (var prop of __getOwnPropSymbols$1A(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1A.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Link = React.forwardRef((_a, ref) => {
  var _b = _a, { href, children } = _b, rest = __objRest$I(_b, ["href", "children"]);
  const validUrl = data.locationUtil.stripBaseFromUrl(data.textUtil.sanitizeUrl(href != null ? href : ""));
  return /* @__PURE__ */ React__default["default"].createElement(reactRouterDom.Link, __spreadValues$1z({ ref, to: validUrl }, rest), children);
});
Link.displayName = "Link";

const PageToolbar = React__default["default"].memo(
  ({
    title,
    section,
    parent,
    pageIcon,
    onGoBack,
    children,
    titleHref,
    parentHref,
    leftItems,
    isFullscreen,
    className,
    /** main nav-container aria-label **/
    "aria-label": ariaLabel,
    buttonOverflowAlignment = "right",
    forceShowLeftItems = false
  }) => {
    const styles = useStyles2(getStyles$T);
    const mainStyle = css.cx(
      "page-toolbar",
      styles.toolbar,
      {
        ["page-toolbar--fullscreen"]: isFullscreen,
        [styles.noPageIcon]: !pageIcon
      },
      className
    );
    const titleEl = /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.truncateText }, title), section && /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.pre }, " / ", section));
    return /* @__PURE__ */ React__default["default"].createElement("nav", { className: mainStyle, "aria-label": ariaLabel }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.leftWrapper }, pageIcon && !onGoBack && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.pageIcon }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: pageIcon, size: "lg", "aria-hidden": true })), onGoBack && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.pageIcon }, /* @__PURE__ */ React__default["default"].createElement(
      IconButton,
      {
        name: "arrow-left",
        tooltip: "Go back (Esc)",
        tooltipPlacement: "bottom",
        size: "xxl",
        "data-testid": e2eSelectors.selectors.components.BackButton.backArrow,
        onClick: onGoBack
      }
    )), /* @__PURE__ */ React__default["default"].createElement("nav", { "aria-label": "Search links", className: styles.navElement }, parent && parentHref && /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(
      Link,
      {
        "aria-label": `Search dashboard in the ${parent} folder`,
        className: css.cx(styles.titleText, styles.parentLink, styles.titleLink, styles.truncateText),
        href: parentHref
      },
      parent,
      " ",
      /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.parentIcon })
    ), titleHref && /* @__PURE__ */ React__default["default"].createElement("span", { className: css.cx(styles.titleText, styles.titleDivider), "aria-hidden": true }, "/")), (title || Boolean(leftItems == null ? void 0 : leftItems.length)) && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.titleWrapper }, title && /* @__PURE__ */ React__default["default"].createElement("h1", { className: styles.h1Styles }, titleHref ? /* @__PURE__ */ React__default["default"].createElement(
      Link,
      {
        "aria-label": "Search dashboard by name",
        className: css.cx(styles.titleText, styles.titleLink),
        href: titleHref
      },
      titleEl
    ) : /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.titleText }, titleEl)), leftItems == null ? void 0 : leftItems.map((child, index) => /* @__PURE__ */ React__default["default"].createElement(
      "div",
      {
        className: css.cx(styles.leftActionItem, { [styles.forceShowLeftActionItems]: forceShowLeftItems }),
        key: index
      },
      child
    ))))), /* @__PURE__ */ React__default["default"].createElement(ToolbarButtonRow, { alignment: buttonOverflowAlignment }, React__default["default"].Children.toArray(children).filter(Boolean)));
  }
);
PageToolbar.displayName = "PageToolbar";
const getStyles$T = (theme) => {
  const { spacing, typography } = theme;
  const focusStyle = getFocusStyles(theme);
  return {
    pre: css.css({
      whiteSpace: "pre"
    }),
    toolbar: css.css({
      alignItems: "center",
      background: theme.colors.background.canvas,
      display: "flex",
      gap: theme.spacing(2),
      justifyContent: "space-between",
      padding: theme.spacing(1.5, 2),
      [theme.breakpoints.down("md")]: {
        paddingLeft: "53px"
      }
    }),
    noPageIcon: css.css({
      [theme.breakpoints.down("md")]: {
        paddingLeft: theme.spacing(2)
      }
    }),
    leftWrapper: css.css({
      display: "flex",
      flexWrap: "nowrap",
      maxWidth: "70%"
    }),
    pageIcon: css.css({
      display: "none",
      [theme.breakpoints.up("sm")]: {
        display: "flex",
        paddingRight: theme.spacing(1),
        alignItems: "center"
      }
    }),
    truncateText: css.css({
      overflow: "hidden",
      textOverflow: "ellipsis",
      whiteSpace: "nowrap"
    }),
    titleWrapper: css.css({
      display: "flex",
      margin: 0,
      minWidth: 0
    }),
    navElement: css.css({
      display: "flex",
      alignItems: "center",
      minWidth: 0
    }),
    h1Styles: css.css({
      margin: spacing(0, 1, 0, 0),
      lineHeight: "inherit",
      flexGrow: 1,
      minWidth: 0
    }),
    parentIcon: css.css({
      marginLeft: theme.spacing(0.5)
    }),
    titleText: css.css({
      display: "flex",
      fontSize: typography.size.lg,
      margin: 0,
      borderRadius: theme.shape.radius.default
    }),
    titleLink: css.css({
      "&:focus-visible": focusStyle
    }),
    titleDivider: css.css({
      padding: spacing(0, 0.5, 0, 0.5),
      display: "none",
      [theme.breakpoints.up("md")]: {
        display: "unset"
      }
    }),
    parentLink: css.css({
      display: "none",
      [theme.breakpoints.up("md")]: {
        display: "unset",
        flex: 1
      }
    }),
    leftActionItem: css.css({
      display: "none",
      alignItems: "center",
      paddingRight: spacing(0.5),
      [theme.breakpoints.up("md")]: {
        display: "flex"
      }
    }),
    forceShowLeftActionItems: css.css({
      display: "flex"
    })
  };
};

var __defProp$1G = Object.defineProperty;
var __defNormalProp$1G = (obj, key, value) => key in obj ? __defProp$1G(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$f = (obj, key, value) => {
  __defNormalProp$1G(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
class SetInterval extends React.PureComponent {
  constructor(props) {
    super(props);
    __publicField$f(this, "propsSubject");
    __publicField$f(this, "subscription");
    this.propsSubject = new rxjs.Subject();
    this.subscription = null;
  }
  componentDidMount() {
    this.subscription = this.propsSubject.pipe(
      // switchMap creates a new observables based on the input stream,
      // which becomes part of the propsSubject stream
      operators.switchMap((props) => {
        if (RefreshPicker.isLive(props.interval)) {
          return rxjs.of({});
        }
        return props.loading ? rxjs.NEVER : rxjs.interval(data.stringToMs(props.interval));
      }),
      // tap will execute function passed via func prop
      // * on value from `of` stream merged if query is live
      // * on specified interval (triggered by values emitted by interval)
      operators.tap(() => this.props.func())
    ).subscribe();
    this.propsSubject.next(this.props);
  }
  componentDidUpdate(prevProps) {
    if (RefreshPicker.isLive(prevProps.interval) && RefreshPicker.isLive(this.props.interval) || lodash.isEqual(prevProps, this.props)) {
      return;
    }
    this.propsSubject.next(this.props);
  }
  componentWillUnmount() {
    if (this.subscription) {
      this.subscription.unsubscribe();
    }
    this.propsSubject.unsubscribe();
  }
  render() {
    return null;
  }
}

const FooterCell = (props) => {
  const cell = css.css({
    width: "100%",
    listStyle: "none"
  });
  const list = css.css({
    width: "100%",
    display: "flex",
    flexDirection: "row",
    justifyContent: "space-between"
  });
  if (props.value && !Array.isArray(props.value)) {
    return /* @__PURE__ */ React__default["default"].createElement("span", null, props.value);
  }
  if (props.value && Array.isArray(props.value) && props.value.length > 0) {
    return /* @__PURE__ */ React__default["default"].createElement("ul", { className: cell }, props.value.map((v, i) => {
      const key = Object.keys(v)[0];
      return /* @__PURE__ */ React__default["default"].createElement("li", { className: list, key: i }, /* @__PURE__ */ React__default["default"].createElement("span", null, key), /* @__PURE__ */ React__default["default"].createElement("span", null, v[key]));
    }));
  }
  return EmptyCell;
};
const EmptyCell = () => {
  return /* @__PURE__ */ React__default["default"].createElement("span", null, "\xA0");
};

var __defProp$1F = Object.defineProperty;
var __defProps$15 = Object.defineProperties;
var __getOwnPropDescs$15 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1z = Object.getOwnPropertySymbols;
var __hasOwnProp$1z = Object.prototype.hasOwnProperty;
var __propIsEnum$1z = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1F = (obj, key, value) => key in obj ? __defProp$1F(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1y = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1z.call(b, prop))
      __defNormalProp$1F(a, prop, b[prop]);
  if (__getOwnPropSymbols$1z)
    for (var prop of __getOwnPropSymbols$1z(b)) {
      if (__propIsEnum$1z.call(b, prop))
        __defNormalProp$1F(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$15 = (a, b) => __defProps$15(a, __getOwnPropDescs$15(b));
var __objRest$H = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1z.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1z)
    for (var prop of __getOwnPropSymbols$1z(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1z.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function FooterRow(props) {
  const { totalColumnsWidth, footerGroups, isPaginationVisible, tableStyles } = props;
  const e2eSelectorsTable = e2eSelectors.selectors.components.Panels.Visualization.Table;
  return /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      style: {
        position: isPaginationVisible ? "relative" : "absolute",
        width: totalColumnsWidth ? `${totalColumnsWidth}px` : "100%",
        bottom: "0px"
      }
    },
    footerGroups.map((footerGroup) => {
      const _a = footerGroup.getFooterGroupProps(), { key } = _a, footerGroupProps = __objRest$H(_a, ["key"]);
      return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$15(__spreadValues$1y({ className: tableStyles.tfoot }, footerGroupProps), { key, "data-testid": e2eSelectorsTable.footer }), footerGroup.headers.map((column) => renderFooterCell(column, tableStyles)));
    })
  );
}
function renderFooterCell(column, tableStyles) {
  var _a;
  const footerProps = column.getHeaderProps();
  if (!footerProps) {
    return null;
  }
  footerProps.style = (_a = footerProps.style) != null ? _a : {};
  footerProps.style.position = "absolute";
  footerProps.style.justifyContent = column.justifyContent;
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1y({ className: tableStyles.headerCell }, footerProps), column.render("Footer"));
}
function getFooterValue(index, footerValues, isCountRowsSet) {
  if (footerValues === void 0) {
    return EmptyCell;
  }
  if (isCountRowsSet) {
    if (footerValues[index] === void 0) {
      return EmptyCell;
    }
    const key = data.fieldReducers.get(data.ReducerID.count).name;
    return FooterCell({ value: [{ [key]: String(footerValues[index]) }] });
  }
  return FooterCell({ value: footerValues[index] });
}

const ITEM_HEIGHT = 28;
const MIN_HEIGHT = ITEM_HEIGHT * 5;
const operatorSelectableValues = {
  Contains: { label: "Contains", value: "Contains", description: "Contains" },
  "=": { label: "=", value: "=", description: "Equals" },
  "!=": { label: "!=", value: "!=", description: "Not equals" },
  ">": { label: ">", value: ">", description: "Greater" },
  ">=": { label: ">=", value: ">=", description: "Greater or Equal" },
  "<": { label: "<", value: "<", description: "Less" },
  "<=": { label: "<=", value: "<=", description: "Less or Equal" },
  Expression: {
    label: "Expression",
    value: "Expression",
    description: 'Bool Expression (Char $ represents the column value in the expression, e.g. "$ >= 10 && $ <= 12")'
  }
};
const OPERATORS = Object.values(operatorSelectableValues);
const REGEX_OPERATOR = operatorSelectableValues["Contains"];
const XPR_OPERATOR = operatorSelectableValues["Expression"];
const comparableValue = (value) => {
  value = value.trim().replace(/\\/g, "");
  if (/^(\d{4}-\d{2}-\d{2}|\d{4}\/\d{2}\/\d{2})/.test(value)) {
    const date = new Date(value);
    if (!isNaN(date.getTime())) {
      const fmt = data.getValueFormat("dateTimeAsIso");
      return data.formattedValueToString(fmt(date.getTime()));
    }
  }
  const num = parseFloat(value);
  if (!isNaN(num)) {
    return num;
  }
  const lvalue = value.toLowerCase();
  if (lvalue === "true" || lvalue === "false") {
    return lvalue === "true";
  }
  return value;
};
const FilterList = ({ options, values, caseSensitive, showOperators, onChange }) => {
  const [operator, setOperator] = React.useState(REGEX_OPERATOR);
  const [searchFilter, setSearchFilter] = React.useState("");
  const regex = React.useMemo(() => new RegExp(searchFilter, caseSensitive ? void 0 : "i"), [searchFilter, caseSensitive]);
  const items = React.useMemo(
    () => options.filter((option) => {
      if (!showOperators || !searchFilter || operator.value === REGEX_OPERATOR.value) {
        if (option.label === void 0) {
          return false;
        }
        return regex.test(option.label);
      } else if (operator.value === XPR_OPERATOR.value) {
        if (option.value === void 0) {
          return false;
        }
        try {
          const xpr = searchFilter.replace(/\\/g, "");
          const fnc = new Function("$", `'use strict'; return ${xpr};`);
          const val = comparableValue(option.value);
          return fnc(val);
        } catch (_) {
        }
        return false;
      } else {
        if (option.value === void 0) {
          return false;
        }
        const value1 = comparableValue(option.value);
        const value2 = comparableValue(searchFilter);
        switch (operator.value) {
          case "=":
            return value1 === value2;
          case "!=":
            return value1 !== value2;
          case ">":
            return value1 > value2;
          case ">=":
            return value1 >= value2;
          case "<":
            return value1 < value2;
          case "<=":
            return value1 <= value2;
        }
        return false;
      }
    }),
    [options, regex, showOperators, operator, searchFilter]
  );
  const selectedItems = React.useMemo(() => items.filter((item) => values.includes(item)), [items, values]);
  const selectCheckValue = React.useMemo(() => items.length === selectedItems.length, [items, selectedItems]);
  const selectCheckIndeterminate = React.useMemo(
    () => selectedItems.length > 0 && items.length > selectedItems.length,
    [items, selectedItems]
  );
  const selectCheckLabel = React.useMemo(
    () => selectedItems.length ? `${selectedItems.length} selected` : `Select all`,
    [selectedItems]
  );
  const selectCheckDescription = React.useMemo(
    () => items.length !== selectedItems.length ? "Add all displayed values to the filter" : "Remove all displayed values from the filter",
    [items, selectedItems]
  );
  const styles = useStyles2(getStyles$S);
  const theme = useTheme2();
  const gutter = theme.spacing.gridSize;
  const height = React.useMemo(() => Math.min(items.length * ITEM_HEIGHT, MIN_HEIGHT) + gutter, [gutter, items.length]);
  const onCheckedChanged = React.useCallback(
    (option) => (event) => {
      const newValues = event.currentTarget.checked ? values.concat(option) : values.filter((c) => c.value !== option.value);
      onChange(newValues);
    },
    [onChange, values]
  );
  const onSelectChanged = React.useCallback(() => {
    if (items.length === selectedItems.length) {
      const newValues = values.filter((item) => !items.includes(item));
      onChange(newValues);
    } else {
      const newValues = [.../* @__PURE__ */ new Set([...values, ...items])];
      onChange(newValues);
    }
  }, [onChange, values, items, selectedItems]);
  return /* @__PURE__ */ React__default["default"].createElement(VerticalGroup, { spacing: "md" }, !showOperators && /* @__PURE__ */ React__default["default"].createElement(FilterInput, { placeholder: "Filter values", onChange: setSearchFilter, value: searchFilter }), showOperators && /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, null, /* @__PURE__ */ React__default["default"].createElement(
    ButtonSelect,
    {
      variant: "canvas",
      options: OPERATORS,
      onChange: setOperator,
      value: operator,
      tooltip: operator.description
    }
  ), /* @__PURE__ */ React__default["default"].createElement(FilterInput, { placeholder: "Filter values", onChange: setSearchFilter, value: searchFilter })), !items.length && /* @__PURE__ */ React__default["default"].createElement(Label$1, null, "No values"), items.length && /* @__PURE__ */ React__default["default"].createElement(
    reactWindow.FixedSizeList,
    {
      height,
      itemCount: items.length,
      itemSize: ITEM_HEIGHT,
      width: "100%",
      className: styles.filterList
    },
    ({ index, style }) => {
      const option = items[index];
      const { value, label } = option;
      const isChecked = values.find((s) => s.value === value) !== void 0;
      return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.filterListRow, style, title: label }, /* @__PURE__ */ React__default["default"].createElement(Checkbox, { value: isChecked, label, onChange: onCheckedChanged(option) }));
    }
  ), items.length && /* @__PURE__ */ React__default["default"].createElement(VerticalGroup, { spacing: "xs" }, /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.selectDivider) }), /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.filterListRow) }, /* @__PURE__ */ React__default["default"].createElement(
    Checkbox,
    {
      value: selectCheckValue,
      indeterminate: selectCheckIndeterminate,
      label: selectCheckLabel,
      description: selectCheckDescription,
      onChange: onSelectChanged
    }
  ))));
};
const getStyles$S = (theme) => ({
  filterList: css.css({
    label: "filterList"
  }),
  filterListRow: css.css({
    label: "filterListRow",
    cursor: "pointer",
    whiteSpace: "nowrap",
    overflow: "hidden",
    textOverflow: "ellipsis",
    padding: theme.spacing(0.5),
    ":hover": {
      backgroundColor: theme.colors.action.hover
    }
  }),
  selectDivider: css.css({
    label: "selectDivider",
    width: "100%",
    borderTop: `1px solid ${theme.colors.border.medium}`,
    padding: theme.spacing(0.5, 2)
  })
});

var __defProp$1E = Object.defineProperty;
var __getOwnPropSymbols$1y = Object.getOwnPropertySymbols;
var __hasOwnProp$1y = Object.prototype.hasOwnProperty;
var __propIsEnum$1y = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1E = (obj, key, value) => key in obj ? __defProp$1E(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1x = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1y.call(b, prop))
      __defNormalProp$1E(a, prop, b[prop]);
  if (__getOwnPropSymbols$1y)
    for (var prop of __getOwnPropSymbols$1y(b)) {
      if (__propIsEnum$1y.call(b, prop))
        __defNormalProp$1E(a, prop, b[prop]);
    }
  return a;
};
var __objRest$G = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1y.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1y)
    for (var prop of __getOwnPropSymbols$1y(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1y.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function fontSizeReductionFactor(fontSize) {
  if (fontSize < 20) {
    return 0.9;
  }
  if (fontSize < 26) {
    return 0.8;
  }
  return 0.6;
}
const FormattedValueDisplay = (_a) => {
  var _b = _a, { value, className, style } = _b, htmlProps = __objRest$G(_b, ["value", "className", "style"]);
  var _a2, _b2;
  const hasPrefix = ((_a2 = value.prefix) != null ? _a2 : "").length > 0;
  const hasSuffix = ((_b2 = value.suffix) != null ? _b2 : "").length > 0;
  let suffixStyle;
  if (style && style.fontSize && typeof style.fontSize === "number") {
    const fontSize = style.fontSize;
    const reductionFactor = fontSizeReductionFactor(fontSize);
    suffixStyle = { fontSize: fontSize * reductionFactor };
  }
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1x({ className, style }, htmlProps), /* @__PURE__ */ React__default["default"].createElement("div", null, hasPrefix && /* @__PURE__ */ React__default["default"].createElement("span", null, value.prefix), /* @__PURE__ */ React__default["default"].createElement("span", null, value.text), hasSuffix && /* @__PURE__ */ React__default["default"].createElement("span", { style: suffixStyle }, value.suffix)));
};
FormattedValueDisplay.displayName = "FormattedDisplayValue";

var __defProp$1D = Object.defineProperty;
var __defNormalProp$1D = (obj, key, value) => key in obj ? __defProp$1D(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$e = (obj, key, value) => {
  __defNormalProp$1D(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
const MIN_VALUE_HEIGHT = 18;
const MAX_VALUE_HEIGHT = 50;
const MAX_VALUE_WIDTH = 150;
const TITLE_LINE_HEIGHT = 1.5;
const VALUE_LINE_HEIGHT = 1;
const VALUE_LEFT_PADDING = 10;
class BarGauge extends React.PureComponent {
  render() {
    const { onClick, className, theme } = this.props;
    const { title } = this.props.value;
    const styles = getTitleStyles(this.props);
    if (onClick) {
      return /* @__PURE__ */ React__default["default"].createElement(
        "button",
        {
          type: "button",
          style: styles.wrapper,
          onClick,
          className: css.cx(clearButtonStyles(theme), className)
        },
        /* @__PURE__ */ React__default["default"].createElement("div", { style: styles.title }, title),
        this.renderBarAndValue()
      );
    }
    return /* @__PURE__ */ React__default["default"].createElement("div", { style: styles.wrapper, className }, title && /* @__PURE__ */ React__default["default"].createElement("div", { style: styles.title }, title), this.renderBarAndValue());
  }
  renderBarAndValue() {
    switch (this.props.displayMode) {
      case "lcd":
        return this.renderRetroBars();
      case "basic":
      case "gradient":
      default:
        return this.renderBasicAndGradientBars();
    }
  }
  renderBasicAndGradientBars() {
    const { value, showUnfilled, valueDisplayMode } = this.props;
    const styles = getBasicAndGradientStyles(this.props);
    return /* @__PURE__ */ React__default["default"].createElement("div", { style: styles.wrapper }, valueDisplayMode !== schema.BarGaugeValueMode.Hidden && /* @__PURE__ */ React__default["default"].createElement(
      FormattedValueDisplay,
      {
        "data-testid": e2eSelectors.selectors.components.Panels.Visualization.BarGauge.valueV2,
        value,
        style: styles.value
      }
    ), showUnfilled && /* @__PURE__ */ React__default["default"].createElement("div", { style: styles.emptyBar }), /* @__PURE__ */ React__default["default"].createElement("div", { style: styles.bar }));
  }
  renderRetroBars() {
    var _a, _b;
    const {
      display,
      field,
      value,
      itemSpacing,
      alignmentFactors,
      orientation,
      lcdCellWidth,
      text,
      valueDisplayMode,
      theme
    } = this.props;
    const { valueHeight, valueWidth, maxBarHeight, maxBarWidth, wrapperWidth, wrapperHeight } = calculateBarAndValueDimensions(this.props);
    const minValue = (_a = field.min) != null ? _a : data.GAUGE_DEFAULT_MINIMUM;
    const maxValue = (_b = field.max) != null ? _b : data.GAUGE_DEFAULT_MAXIMUM;
    const isVert = isVertical(orientation);
    const valueRange = maxValue - minValue;
    const maxSize = isVert ? maxBarHeight : maxBarWidth;
    const cellSpacing = itemSpacing;
    const cellCount = Math.floor(maxSize / lcdCellWidth);
    const cellSize = Math.floor((maxSize - cellSpacing * cellCount) / cellCount);
    const valueColor = getTextValueColor(this.props);
    const valueToBaseSizeOn = alignmentFactors ? alignmentFactors : value;
    const valueStyles = getValueStyles(valueToBaseSizeOn, valueColor, valueWidth, valueHeight, orientation, text);
    const containerStyles = {
      width: `${wrapperWidth}px`,
      height: `${wrapperHeight}px`,
      display: "flex"
    };
    if (isVert) {
      containerStyles.flexDirection = "column-reverse";
      containerStyles.alignItems = "center";
    } else {
      containerStyles.flexDirection = "row";
      containerStyles.alignItems = "center";
      valueStyles.justifyContent = "flex-end";
    }
    const cells = [];
    for (let i = 0; i < cellCount; i++) {
      const currentValue = minValue + valueRange / cellCount * i;
      const cellColor = getCellColor(currentValue, value, display);
      const cellStyles = {
        borderRadius: theme.shape.radius.default
      };
      if (cellColor.isLit) {
        cellStyles.backgroundImage = `radial-gradient(${cellColor.background} 10%, ${cellColor.backgroundShade})`;
      } else {
        cellStyles.backgroundColor = cellColor.background;
      }
      if (isVert) {
        cellStyles.height = `${cellSize}px`;
        cellStyles.width = `${maxBarWidth}px`;
        cellStyles.marginTop = `${cellSpacing}px`;
      } else {
        cellStyles.width = `${cellSize}px`;
        cellStyles.height = `${maxBarHeight}px`;
        cellStyles.marginRight = `${cellSpacing}px`;
      }
      cells.push(/* @__PURE__ */ React__default["default"].createElement("div", { key: i.toString(), style: cellStyles }));
    }
    return /* @__PURE__ */ React__default["default"].createElement("div", { style: containerStyles }, cells, valueDisplayMode !== schema.BarGaugeValueMode.Hidden && /* @__PURE__ */ React__default["default"].createElement(
      FormattedValueDisplay,
      {
        "data-testid": e2eSelectors.selectors.components.Panels.Visualization.BarGauge.valueV2,
        value,
        style: valueStyles
      }
    ));
  }
}
__publicField$e(BarGauge, "defaultProps", {
  lcdCellWidth: 12,
  value: {
    text: "100",
    numeric: 100
  },
  displayMode: schema.BarGaugeDisplayMode.Gradient,
  orientation: data.VizOrientation.Horizontal,
  field: {
    min: 0,
    max: 100,
    thresholds: {
      mode: data.ThresholdsMode.Absolute,
      steps: []
    }
  },
  itemSpacing: 8,
  showUnfilled: true
});
function isVertical(orientation) {
  return orientation === data.VizOrientation.Vertical;
}
function calculateTitleDimensions(props) {
  var _a, _b;
  const { height, width, alignmentFactors, orientation, text, namePlacement } = props;
  const title = alignmentFactors ? alignmentFactors.title : props.value.title;
  if (!title) {
    return { fontSize: 0, width: 0, height: 0, placement: "above" };
  }
  if (isVertical(orientation)) {
    const fontSize = (_a = text == null ? void 0 : text.titleSize) != null ? _a : 14;
    return {
      fontSize,
      width,
      height: fontSize * TITLE_LINE_HEIGHT,
      placement: "below"
    };
  }
  const shouldDisplayValueAbove = height > 40 && namePlacement === schema.BarGaugeNamePlacement.Auto || namePlacement === schema.BarGaugeNamePlacement.Top;
  if (shouldDisplayValueAbove) {
    if (text == null ? void 0 : text.titleSize) {
      return {
        fontSize: text == null ? void 0 : text.titleSize,
        width: 0,
        height: text.titleSize * TITLE_LINE_HEIGHT,
        placement: "above"
      };
    }
    const maxTitleHeightRatio2 = 0.45;
    const titleHeight2 = Math.max(Math.min(height * maxTitleHeightRatio2, MAX_VALUE_HEIGHT), 17);
    return {
      fontSize: titleHeight2 / TITLE_LINE_HEIGHT,
      width: 0,
      height: titleHeight2,
      placement: "above"
    };
  }
  const maxTitleHeightRatio = 0.6;
  const titleHeight = Math.max(height * maxTitleHeightRatio, MIN_VALUE_HEIGHT);
  const titleFontSize = titleHeight / TITLE_LINE_HEIGHT;
  const textSize = measureText(title, titleFontSize);
  const textWidth = Math.min(textSize.width + 15, width * 0.4);
  return {
    fontSize: (_b = text == null ? void 0 : text.titleSize) != null ? _b : titleFontSize,
    height: 0,
    width: textWidth,
    placement: "left"
  };
}
function getTitleStyles(props) {
  const wrapperStyles = {
    display: "flex",
    overflow: "hidden",
    width: "100%"
  };
  const titleDim = calculateTitleDimensions(props);
  const titleStyles = {
    fontSize: `${titleDim.fontSize}px`,
    whiteSpace: "nowrap",
    overflow: "hidden",
    textOverflow: "ellipsis",
    width: "100%",
    alignItems: "center",
    alignSelf: "center"
  };
  if (isVertical(props.orientation)) {
    wrapperStyles.flexDirection = "column-reverse";
    titleStyles.textAlign = "center";
  } else {
    if (titleDim.placement === "above") {
      wrapperStyles.flexDirection = "column";
    } else {
      wrapperStyles.flexDirection = "row";
      titleStyles.width = `${titleDim.width}px`;
      titleStyles.textAlign = "right";
      titleStyles.paddingRight = "10px";
    }
  }
  return {
    wrapper: wrapperStyles,
    title: titleStyles
  };
}
function calculateBarAndValueDimensions(props) {
  var _a;
  const { height, width, orientation, text, alignmentFactors, valueDisplayMode } = props;
  const titleDim = calculateTitleDimensions(props);
  const value = alignmentFactors != null ? alignmentFactors : props.value;
  const valueString = data.formattedValueToString(value);
  let maxBarHeight = 0;
  let maxBarWidth = 0;
  let valueHeight = 0;
  let valueWidth = 0;
  let wrapperWidth = 0;
  let wrapperHeight = 0;
  const fontSizeToMeasureWith = (_a = text == null ? void 0 : text.valueSize) != null ? _a : Math.max(titleDim.fontSize, 12);
  const realTextSize = measureText(valueString, fontSizeToMeasureWith);
  const realValueWidth = realTextSize.width + VALUE_LEFT_PADDING * 2;
  if (isVertical(orientation)) {
    if (text == null ? void 0 : text.valueSize) {
      valueHeight = text.valueSize * VALUE_LINE_HEIGHT;
    } else {
      valueHeight = Math.min(Math.max(height * 0.1, MIN_VALUE_HEIGHT), MAX_VALUE_HEIGHT);
    }
    valueWidth = width;
    if (valueDisplayMode === schema.BarGaugeValueMode.Hidden) {
      valueHeight = 0;
      valueWidth = 0;
    }
    maxBarHeight = height - (titleDim.height + valueHeight);
    maxBarWidth = width;
    wrapperWidth = width;
    wrapperHeight = height - titleDim.height;
  } else {
    if (valueDisplayMode === schema.BarGaugeValueMode.Hidden) {
      valueHeight = 0;
      valueWidth = 0;
    } else {
      valueHeight = height - titleDim.height;
      valueWidth = Math.max(Math.min(width * 0.2, MAX_VALUE_WIDTH), realValueWidth);
    }
    maxBarHeight = height - titleDim.height;
    maxBarWidth = width - valueWidth - titleDim.width;
    if (titleDim.placement === "above") {
      wrapperWidth = width;
      wrapperHeight = height - titleDim.height;
    } else {
      wrapperWidth = width - titleDim.width;
      wrapperHeight = height;
    }
  }
  return {
    valueWidth,
    valueHeight,
    maxBarWidth,
    maxBarHeight,
    wrapperHeight,
    wrapperWidth
  };
}
function getCellColor(positionValue, value, display) {
  if (positionValue === null) {
    return {
      background: data.FALLBACK_COLOR,
      border: data.FALLBACK_COLOR
    };
  }
  const color = display ? display(positionValue).color : null;
  if (color) {
    if (value === null || isNaN(value.numeric) || positionValue !== null && positionValue > value.numeric) {
      return {
        background: tinycolor__default["default"](color).setAlpha(0.18).toRgbString(),
        border: "transparent",
        isLit: false
      };
    } else {
      return {
        background: tinycolor__default["default"](color).setAlpha(0.95).toRgbString(),
        backgroundShade: tinycolor__default["default"](color).setAlpha(0.55).toRgbString(),
        border: tinycolor__default["default"](color).setAlpha(0.9).toRgbString(),
        isLit: true
      };
    }
  }
  return {
    background: data.FALLBACK_COLOR,
    border: data.FALLBACK_COLOR
  };
}
function getValuePercent(value, minValue, maxValue) {
  const valueRatio = Math.min((value - minValue) / (maxValue - minValue), 1);
  return isNaN(valueRatio) ? 0 : valueRatio;
}
function getBasicAndGradientStyles(props) {
  var _a, _b, _c;
  const { displayMode, field, value, alignmentFactors, orientation, theme, text } = props;
  const { valueWidth, valueHeight, maxBarHeight, maxBarWidth } = calculateBarAndValueDimensions(props);
  const minValue = (_a = field.min) != null ? _a : data.GAUGE_DEFAULT_MINIMUM;
  const maxValue = (_b = field.max) != null ? _b : data.GAUGE_DEFAULT_MAXIMUM;
  const valuePercent = getValuePercent(value.numeric, minValue, maxValue);
  const textColor = getTextValueColor(props);
  const barColor = (_c = value.color) != null ? _c : data.FALLBACK_COLOR;
  const valueToBaseSizeOn = alignmentFactors ? alignmentFactors : value;
  const valueStyles = getValueStyles(valueToBaseSizeOn, textColor, valueWidth, valueHeight, orientation, text);
  const isBasic = displayMode === "basic";
  const wrapperStyles = {
    display: "flex",
    flexGrow: 1
  };
  const barStyles = {
    borderRadius: theme.shape.radius.default,
    position: "relative",
    zIndex: 1
  };
  const emptyBar = {
    background: theme.colors.background.secondary,
    flexGrow: 1,
    display: "flex",
    borderRadius: theme.shape.radius.default,
    position: "relative"
  };
  if (isVertical(orientation)) {
    const barHeight = Math.max(valuePercent * maxBarHeight, 1);
    wrapperStyles.flexDirection = "column";
    wrapperStyles.justifyContent = "flex-end";
    barStyles.transition = "height 1s";
    barStyles.height = `${barHeight}px`;
    barStyles.width = `${maxBarWidth}px`;
    emptyBar.bottom = "-3px";
    emptyBar.width = `${valueWidth}px`;
    if (isBasic) {
      barStyles.background = `${tinycolor__default["default"](barColor).setAlpha(0.35).toRgbString()}`;
      barStyles.borderTop = `2px solid ${barColor}`;
    } else {
      barStyles.background = getBarGradient(props, maxBarHeight);
    }
  } else {
    const barWidth = Math.max(valuePercent * maxBarWidth, 1);
    wrapperStyles.flexDirection = "row-reverse";
    wrapperStyles.justifyContent = "flex-end";
    wrapperStyles.alignItems = "stretch";
    barStyles.transition = "width 1s";
    barStyles.height = `${maxBarHeight}px`;
    barStyles.width = `${barWidth}px`;
    emptyBar.left = "-3px";
    emptyBar.height = `${valueHeight}px`;
    if (isBasic) {
      barStyles.background = `${tinycolor__default["default"](barColor).setAlpha(0.35).toRgbString()}`;
      barStyles.borderRight = `2px solid ${barColor}`;
    } else {
      barStyles.background = getBarGradient(props, maxBarWidth);
    }
  }
  return {
    wrapper: wrapperStyles,
    bar: barStyles,
    value: valueStyles,
    emptyBar
  };
}
function getBarGradient(props, maxSize) {
  var _a, _b;
  const { field, value, orientation, theme } = props;
  const cssDirection = isVertical(orientation) ? "0deg" : "90deg";
  const minValue = field.min;
  const maxValue = field.max;
  let gradient = "";
  let lastpos = 0;
  let mode = data.getFieldColorMode((_a = field.color) == null ? void 0 : _a.mode);
  if (mode.id === data.FieldColorModeId.Thresholds) {
    const thresholds = field.thresholds;
    for (let i = 0; i < thresholds.steps.length; i++) {
      const threshold = thresholds.steps[i];
      const color = props.theme.visualization.getColorByName(threshold.color);
      const valuePercent = thresholds.mode === data.ThresholdsMode.Percentage ? threshold.value / 100 : getValuePercent(threshold.value, minValue, maxValue);
      const pos = valuePercent * maxSize;
      const offset = Math.round(pos - (pos - lastpos) / 2);
      const thresholdValue = thresholds.mode === data.ThresholdsMode.Percentage ? minValue + (maxValue - minValue) * valuePercent : threshold.value;
      if (gradient === "") {
        gradient = `linear-gradient(${cssDirection}, ${color}, ${color}`;
      } else if (value.numeric < thresholdValue) {
        break;
      } else {
        lastpos = pos;
        gradient += ` ${offset}px, ${color}`;
      }
    }
    return gradient + ")";
  }
  if (mode.isContinuous && mode.getColors) {
    const scheme = mode.getColors(theme);
    for (let i = 0; i < scheme.length; i++) {
      const color = scheme[i];
      if (gradient === "") {
        gradient = `linear-gradient(${cssDirection}, ${color} 0px`;
      } else {
        const valuePercent = i / (scheme.length - 1);
        const pos = valuePercent * maxSize;
        gradient += `, ${color} ${pos}px`;
      }
    }
    return gradient + ")";
  }
  return (_b = value.color) != null ? _b : data.FALLBACK_COLOR;
}
function getTextValueColor(props) {
  if (props.valueDisplayMode === "text") {
    return props.theme.colors.text.primary;
  }
  const { value } = props;
  if (value.color) {
    return value.color;
  }
  return data.FALLBACK_COLOR;
}
function getValueStyles(value, color, width, height, orientation, text) {
  var _a, _b;
  const styles = {
    color,
    height: `${height}px`,
    width: `${width}px`,
    display: "flex",
    alignItems: "center",
    lineHeight: VALUE_LINE_HEIGHT
  };
  let textWidth = width;
  const formattedValueString = data.formattedValueToString(value);
  if (isVertical(orientation)) {
    styles.fontSize = (_a = text == null ? void 0 : text.valueSize) != null ? _a : calculateFontSize(formattedValueString, textWidth, height, VALUE_LINE_HEIGHT);
    styles.justifyContent = `center`;
  } else {
    styles.fontSize = (_b = text == null ? void 0 : text.valueSize) != null ? _b : calculateFontSize(formattedValueString, textWidth - VALUE_LEFT_PADDING * 2, height, VALUE_LINE_HEIGHT);
    styles.justifyContent = `flex-end`;
    styles.paddingLeft = `${VALUE_LEFT_PADDING}px`;
    styles.paddingRight = `${VALUE_LEFT_PADDING}px`;
    textWidth -= VALUE_LEFT_PADDING;
  }
  return styles;
}

const ContextMenu = React__default["default"].memo(
  ({ x, y, onClose, focusOnOpen = true, renderMenuItems, renderHeader }) => {
    const menuRef = React.useRef(null);
    const [positionStyles, setPositionStyles] = React.useState({});
    React.useLayoutEffect(() => {
      const menuElement = menuRef.current;
      if (menuElement) {
        const rect = menuElement.getBoundingClientRect();
        const OFFSET = 5;
        const collisions = {
          right: window.innerWidth < x + rect.width,
          bottom: window.innerHeight < y + rect.height + OFFSET
        };
        setPositionStyles({
          position: "fixed",
          left: collisions.right ? x - rect.width - OFFSET : x - OFFSET,
          top: Math.max(0, collisions.bottom ? y - rect.height - OFFSET : y + OFFSET)
        });
      }
    }, [x, y]);
    reactUse.useClickAway(menuRef, () => {
      onClose == null ? void 0 : onClose();
    });
    const header = renderHeader == null ? void 0 : renderHeader();
    const menuItems = renderMenuItems == null ? void 0 : renderMenuItems();
    const onOpen = (setFocusedItem) => {
      if (focusOnOpen) {
        setFocusedItem(0);
      }
    };
    const onKeyDown = (e) => {
      if (e.key === "Escape") {
        e.preventDefault();
        e.stopPropagation();
        onClose == null ? void 0 : onClose();
      }
    };
    return /* @__PURE__ */ React__default["default"].createElement(Portal$1, null, /* @__PURE__ */ React__default["default"].createElement(
      Menu,
      {
        header,
        ref: menuRef,
        style: positionStyles,
        ariaLabel: e2eSelectors.selectors.components.Menu.MenuComponent("Context"),
        onOpen,
        onClick: onClose,
        onKeyDown
      },
      menuItems
    ));
  }
);
ContextMenu.displayName = "ContextMenu";

const WithContextMenu = ({ children, renderMenuItems, focusOnOpen = true }) => {
  const [isMenuOpen, setIsMenuOpen] = React.useState(false);
  const [menuPosition, setMenuPosition] = React.useState({ x: 0, y: 0 });
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, children({
    openMenu: (e) => {
      setIsMenuOpen(true);
      setMenuPosition({
        x: e.pageX,
        y: e.pageY
      });
    }
  }), isMenuOpen && /* @__PURE__ */ React__default["default"].createElement(
    ContextMenu,
    {
      onClose: () => setIsMenuOpen(false),
      x: menuPosition.x,
      y: menuPosition.y,
      renderMenuItems,
      focusOnOpen
    }
  ));
};

var __defProp$1C = Object.defineProperty;
var __defProps$14 = Object.defineProperties;
var __getOwnPropDescs$14 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1x = Object.getOwnPropertySymbols;
var __hasOwnProp$1x = Object.prototype.hasOwnProperty;
var __propIsEnum$1x = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1C = (obj, key, value) => key in obj ? __defProp$1C(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1w = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1x.call(b, prop))
      __defNormalProp$1C(a, prop, b[prop]);
  if (__getOwnPropSymbols$1x)
    for (var prop of __getOwnPropSymbols$1x(b)) {
      if (__propIsEnum$1x.call(b, prop))
        __defNormalProp$1C(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$14 = (a, b) => __defProps$14(a, __getOwnPropDescs$14(b));
const DataLinksContextMenu = ({ children, links, style }) => {
  const itemsGroup = [{ items: linkModelToContextMenuItems(links), label: "Data links" }];
  const linksCounter = itemsGroup[0].items.length;
  const renderMenuGroupItems = () => {
    return itemsGroup.map((group, groupIdx) => /* @__PURE__ */ React__default["default"].createElement(MenuGroup, { key: `${group.label}${groupIdx}`, label: group.label }, (group.items || []).map((item, itemIdx) => /* @__PURE__ */ React__default["default"].createElement(
      MenuItem,
      {
        key: `${group.label}-${groupIdx}-${itemIdx}}`,
        url: item.url,
        label: item.label,
        target: item.target,
        icon: item.icon,
        active: item.active,
        onClick: item.onClick
      }
    ))));
  };
  const targetClassName = css.css({
    cursor: "context-menu"
  });
  if (linksCounter > 1) {
    return /* @__PURE__ */ React__default["default"].createElement(WithContextMenu, { renderMenuItems: renderMenuGroupItems }, ({ openMenu }) => {
      return children({ openMenu, targetClassName });
    });
  } else {
    const linkModel = links()[0];
    return /* @__PURE__ */ React__default["default"].createElement(
      "a",
      {
        href: linkModel.href,
        onClick: linkModel.onClick,
        target: linkModel.target,
        title: linkModel.title,
        style: __spreadProps$14(__spreadValues$1w({}, style), { overflow: "hidden", display: "flex" }),
        "data-testid": e2eSelectors.selectors.components.DataLinksContextMenu.singleLink
      },
      children({})
    );
  }
};

var __defProp$1B = Object.defineProperty;
var __defProps$13 = Object.defineProperties;
var __getOwnPropDescs$13 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1w = Object.getOwnPropertySymbols;
var __hasOwnProp$1w = Object.prototype.hasOwnProperty;
var __propIsEnum$1w = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1B = (obj, key, value) => key in obj ? __defProp$1B(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1v = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1w.call(b, prop))
      __defNormalProp$1B(a, prop, b[prop]);
  if (__getOwnPropSymbols$1w)
    for (var prop of __getOwnPropSymbols$1w(b)) {
      if (__propIsEnum$1w.call(b, prop))
        __defNormalProp$1B(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$13 = (a, b) => __defProps$13(a, __getOwnPropDescs$13(b));
const defaultScale = {
  mode: data.ThresholdsMode.Absolute,
  steps: [
    {
      color: "blue",
      value: -Infinity
    },
    {
      color: "green",
      value: 20
    }
  ]
};
const BarGaugeCell = (props) => {
  var _a;
  const { field, innerWidth, tableStyles, cell, cellProps, row } = props;
  const displayValue = field.display(cell.value);
  const cellOptions = getCellOptions(field);
  let config = data.getFieldConfigWithMinMax(field, false);
  if (!config.thresholds) {
    config = __spreadProps$13(__spreadValues$1v({}, config), {
      thresholds: defaultScale
    });
  }
  let barGaugeMode = schema.BarGaugeDisplayMode.Gradient;
  let valueDisplayMode = void 0;
  if (cellOptions.type === schema.TableCellDisplayMode.Gauge) {
    barGaugeMode = (_a = cellOptions.mode) != null ? _a : schema.BarGaugeDisplayMode.Gradient;
    valueDisplayMode = cellOptions.valueDisplayMode !== void 0 ? cellOptions.valueDisplayMode : schema.BarGaugeValueMode.Text;
  }
  const getLinks = () => {
    if (!lodash.isFunction(field.getLinks)) {
      return [];
    }
    return field.getLinks({ valueRowIndex: row.index });
  };
  const hasLinks = Boolean(getLinks().length);
  const alignmentFactors = getAlignmentFactor(field, displayValue, cell.row.index);
  const renderComponent = (menuProps) => {
    const { openMenu, targetClassName } = menuProps;
    return /* @__PURE__ */ React__default["default"].createElement(
      BarGauge,
      {
        width: innerWidth,
        height: tableStyles.cellHeightInner,
        field: config,
        display: field.display,
        text: { valueSize: 14 },
        value: displayValue,
        orientation: data.VizOrientation.Horizontal,
        theme: tableStyles.theme,
        alignmentFactors,
        onClick: openMenu,
        className: targetClassName,
        itemSpacing: 1,
        lcdCellWidth: 8,
        displayMode: barGaugeMode,
        valueDisplayMode
      }
    );
  };
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$13(__spreadValues$1v({}, cellProps), { className: tableStyles.cellContainer }), hasLinks && /* @__PURE__ */ React__default["default"].createElement(DataLinksContextMenu, { links: getLinks, style: { display: "flex", width: "100%" } }, (api) => renderComponent(api)), !hasLinks && renderComponent({}));
};

var __defProp$1A = Object.defineProperty;
var __defProps$12 = Object.defineProperties;
var __getOwnPropDescs$12 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1v = Object.getOwnPropertySymbols;
var __hasOwnProp$1v = Object.prototype.hasOwnProperty;
var __propIsEnum$1v = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1A = (obj, key, value) => key in obj ? __defProp$1A(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1u = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1v.call(b, prop))
      __defNormalProp$1A(a, prop, b[prop]);
  if (__getOwnPropSymbols$1v)
    for (var prop of __getOwnPropSymbols$1v(b)) {
      if (__propIsEnum$1v.call(b, prop))
        __defNormalProp$1A(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$12 = (a, b) => __defProps$12(a, __getOwnPropDescs$12(b));
const DataLinksCell = (props) => {
  const { field, row, cellProps, tableStyles } = props;
  const links = getCellLinks(field, row);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$12(__spreadValues$1u({}, cellProps), { className: tableStyles.cellContainerText }), links && links.map((link, idx) => {
    return (
      // eslint-disable-next-line jsx-a11y/click-events-have-key-events, jsx-a11y/no-static-element-interactions
      /* @__PURE__ */ React__default["default"].createElement("span", { key: idx, className: tableStyles.cellLink, onClick: link.onClick }, /* @__PURE__ */ React__default["default"].createElement("a", { href: link.href, target: link.target }, link.title))
    );
  }));
};

function TableCellInspectModal({ value, onDismiss, mode }) {
  let displayValue = value;
  if (lodash.isString(value)) {
    const trimmedValue = value.trim();
    if (trimmedValue[0] === "{" || trimmedValue[0] === "[" || mode === "code") {
      try {
        value = JSON.parse(value);
        mode = "code";
      } catch (e) {
        mode = "text";
      }
    } else {
      mode = "text";
    }
  } else {
    displayValue = JSON.stringify(value, null, " ");
  }
  let text = displayValue;
  if (mode === "code") {
    text = JSON.stringify(value, null, " ");
  }
  return /* @__PURE__ */ React__default["default"].createElement(Modal, { onDismiss, isOpen: true, title: "Inspect value" }, mode === "code" ? /* @__PURE__ */ React__default["default"].createElement(
    CodeEditor,
    {
      width: "100%",
      height: 500,
      language: "json",
      showLineNumbers: true,
      showMiniMap: (text && text.length) > 100,
      value: text,
      readOnly: true
    }
  ) : /* @__PURE__ */ React__default["default"].createElement("pre", null, text), /* @__PURE__ */ React__default["default"].createElement(Modal.ButtonRow, null, /* @__PURE__ */ React__default["default"].createElement(ClipboardButton, { icon: "copy", getText: () => text }, "Copy to Clipboard")));
}

const FILTER_FOR_OPERATOR = "=";
const FILTER_OUT_OPERATOR = "!=";

var __defProp$1z = Object.defineProperty;
var __getOwnPropSymbols$1u = Object.getOwnPropertySymbols;
var __hasOwnProp$1u = Object.prototype.hasOwnProperty;
var __propIsEnum$1u = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1z = (obj, key, value) => key in obj ? __defProp$1z(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1t = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1u.call(b, prop))
      __defNormalProp$1z(a, prop, b[prop]);
  if (__getOwnPropSymbols$1u)
    for (var prop of __getOwnPropSymbols$1u(b)) {
      if (__propIsEnum$1u.call(b, prop))
        __defNormalProp$1z(a, prop, b[prop]);
    }
  return a;
};
function CellActions({ field, cell, previewMode, showFilters, onCellFilterAdded }) {
  var _a;
  const [isInspecting, setIsInspecting] = React.useState(false);
  const isRightAligned = getTextAlign(field) === "flex-end";
  const inspectEnabled = Boolean((_a = field.config.custom) == null ? void 0 : _a.inspect);
  const commonButtonProps = {
    size: "sm",
    tooltipPlacement: "top"
  };
  const onFilterFor = React.useCallback(
    (event) => {
      if (onCellFilterAdded) {
        onCellFilterAdded({ key: field.name, operator: FILTER_FOR_OPERATOR, value: cell.value });
      }
    },
    [cell, field, onCellFilterAdded]
  );
  const onFilterOut = React.useCallback(
    (event) => {
      if (onCellFilterAdded) {
        onCellFilterAdded({ key: field.name, operator: FILTER_OUT_OPERATOR, value: cell.value });
      }
    },
    [cell, field, onCellFilterAdded]
  );
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("div", { className: `cellActions ${isRightAligned ? "cellActionsLeft" : ""}` }, /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, { spacing: "xs" }, inspectEnabled && /* @__PURE__ */ React__default["default"].createElement(
    IconButton,
    __spreadValues$1t({
      name: "eye",
      tooltip: "Inspect value",
      onClick: () => {
        setIsInspecting(true);
      }
    }, commonButtonProps)
  ), showFilters && /* @__PURE__ */ React__default["default"].createElement(IconButton, __spreadValues$1t({ name: "search-plus", onClick: onFilterFor, tooltip: "Filter for value" }, commonButtonProps)), showFilters && /* @__PURE__ */ React__default["default"].createElement(IconButton, __spreadValues$1t({ name: "search-minus", onClick: onFilterOut, tooltip: "Filter out value" }, commonButtonProps)))), isInspecting && /* @__PURE__ */ React__default["default"].createElement(
    TableCellInspectModal,
    {
      mode: previewMode,
      value: cell.value,
      onDismiss: () => {
        setIsInspecting(false);
      }
    }
  ));
}

var __defProp$1y = Object.defineProperty;
var __defProps$11 = Object.defineProperties;
var __getOwnPropDescs$11 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1t = Object.getOwnPropertySymbols;
var __hasOwnProp$1t = Object.prototype.hasOwnProperty;
var __propIsEnum$1t = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1y = (obj, key, value) => key in obj ? __defProp$1y(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1s = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1t.call(b, prop))
      __defNormalProp$1y(a, prop, b[prop]);
  if (__getOwnPropSymbols$1t)
    for (var prop of __getOwnPropSymbols$1t(b)) {
      if (__propIsEnum$1t.call(b, prop))
        __defNormalProp$1y(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$11 = (a, b) => __defProps$11(a, __getOwnPropDescs$11(b));
const DefaultCell = (props) => {
  var _a, _b, _c;
  const { field, cell, tableStyles, row, cellProps, frame } = props;
  const inspectEnabled = Boolean((_a = field.config.custom) == null ? void 0 : _a.inspect);
  const displayValue = field.display(cell.value);
  const showFilters = props.onCellFilterAdded && field.config.filterable;
  const showActions = showFilters && cell.value !== void 0 || inspectEnabled;
  const cellOptions = getCellOptions(field);
  const hasLinks = Boolean((_b = getCellLinks(field, row)) == null ? void 0 : _b.length);
  const clearButtonStyle = useStyles2(clearLinkButtonStyles);
  const [hover, setHover] = React.useState(false);
  let value;
  const onMouseLeave = () => {
    setHover(false);
  };
  const onMouseEnter = () => {
    setHover(true);
  };
  if (cellOptions.type === schema.TableCellDisplayMode.Custom) {
    const CustomCellComponent = cellOptions.cellComponent;
    value = /* @__PURE__ */ React__default["default"].createElement(CustomCellComponent, { field, value: cell.value, rowIndex: row.index, frame });
  } else {
    if (React__default["default"].isValidElement(cell.value)) {
      value = cell.value;
    } else {
      value = data.formattedValueToString(displayValue);
    }
  }
  const isStringValue = typeof value === "string";
  const cellStyle = getCellStyle(tableStyles, cellOptions, displayValue, inspectEnabled, isStringValue);
  if (isStringValue) {
    let justifyContent = (_c = cellProps.style) == null ? void 0 : _c.justifyContent;
    if (justifyContent === "flex-end") {
      cellProps.style = __spreadProps$11(__spreadValues$1s({}, cellProps.style), { textAlign: "right" });
    } else if (justifyContent === "center") {
      cellProps.style = __spreadProps$11(__spreadValues$1s({}, cellProps.style), { textAlign: "center" });
    }
  }
  return /* @__PURE__ */ React__default["default"].createElement(
    "div",
    __spreadProps$11(__spreadValues$1s({}, cellProps), {
      onMouseEnter: showActions ? onMouseEnter : void 0,
      onMouseLeave: showActions ? onMouseLeave : void 0,
      className: cellStyle
    }),
    !hasLinks && (isStringValue ? `${value}` : /* @__PURE__ */ React__default["default"].createElement("div", { className: tableStyles.cellText }, value)),
    hasLinks && /* @__PURE__ */ React__default["default"].createElement(DataLinksContextMenu, { links: () => getCellLinks(field, row) || [] }, (api) => {
      if (api.openMenu) {
        return /* @__PURE__ */ React__default["default"].createElement(
          "button",
          {
            className: css.cx(clearButtonStyle, getLinkStyle(tableStyles, cellOptions, api.targetClassName)),
            onClick: api.openMenu
          },
          value
        );
      } else {
        return /* @__PURE__ */ React__default["default"].createElement("div", { className: getLinkStyle(tableStyles, cellOptions, api.targetClassName) }, value);
      }
    }),
    hover && showActions && /* @__PURE__ */ React__default["default"].createElement(CellActions, __spreadProps$11(__spreadValues$1s({}, props), { previewMode: "text", showFilters }))
  );
};
function getCellStyle(tableStyles, cellOptions, displayValue, disableOverflowOnHover = false, isStringValue = false) {
  var _a;
  const darkeningFactor = tableStyles.theme.isDark ? 1 : -0.7;
  let textColor = void 0;
  let bgColor = void 0;
  if (cellOptions.type === schema.TableCellDisplayMode.ColorText) {
    textColor = displayValue.color;
  } else if (cellOptions.type === schema.TableCellDisplayMode.ColorBackground) {
    const mode = (_a = cellOptions.mode) != null ? _a : schema.TableCellBackgroundDisplayMode.Gradient;
    if (mode === schema.TableCellBackgroundDisplayMode.Basic) {
      textColor = getTextColorForAlphaBackground(displayValue.color, tableStyles.theme.isDark);
      bgColor = tinycolor__default["default"](displayValue.color).toRgbString();
    } else if (mode === schema.TableCellBackgroundDisplayMode.Gradient) {
      const bgColor2 = tinycolor__default["default"](displayValue.color).darken(10 * darkeningFactor).spin(5);
      textColor = getTextColorForAlphaBackground(displayValue.color, tableStyles.theme.isDark);
      bgColor = `linear-gradient(120deg, ${bgColor2.toRgbString()}, ${displayValue.color})`;
    }
  }
  if (textColor !== void 0 || bgColor !== void 0) {
    return tableStyles.buildCellContainerStyle(textColor, bgColor, !disableOverflowOnHover, isStringValue);
  }
  if (isStringValue) {
    return disableOverflowOnHover ? tableStyles.cellContainerTextNoOverflow : tableStyles.cellContainerText;
  } else {
    return disableOverflowOnHover ? tableStyles.cellContainerNoOverflow : tableStyles.cellContainer;
  }
}
function getLinkStyle(tableStyles, cellOptions, targetClassName) {
  if (cellOptions.type === schema.TableCellDisplayMode.Auto) {
    return css.cx(tableStyles.cellLink, targetClassName);
  }
  return css.cx(tableStyles.cellLinkForColoredCell, targetClassName);
}

var __defProp$1x = Object.defineProperty;
var __defProps$10 = Object.defineProperties;
var __getOwnPropDescs$10 = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1s = Object.getOwnPropertySymbols;
var __hasOwnProp$1s = Object.prototype.hasOwnProperty;
var __propIsEnum$1s = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1x = (obj, key, value) => key in obj ? __defProp$1x(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1r = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1s.call(b, prop))
      __defNormalProp$1x(a, prop, b[prop]);
  if (__getOwnPropSymbols$1s)
    for (var prop of __getOwnPropSymbols$1s(b)) {
      if (__propIsEnum$1s.call(b, prop))
        __defNormalProp$1x(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$10 = (a, b) => __defProps$10(a, __getOwnPropDescs$10(b));
function GeoCell(props) {
  const { cell, tableStyles, cellProps } = props;
  let disp = "";
  if (cell.value instanceof geom.Geometry) {
    disp = new WKT__default["default"]().writeGeometry(cell.value, {
      featureProjection: "EPSG:3857",
      dataProjection: "EPSG:4326"
    });
  } else if (cell.value != null) {
    disp = `${cell.value}`;
  }
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$10(__spreadValues$1r({}, cellProps), { className: tableStyles.cellContainer }), /* @__PURE__ */ React__default["default"].createElement("div", { className: tableStyles.cellText, style: { fontFamily: "monospace" } }, disp));
}

var __defProp$1w = Object.defineProperty;
var __defProps$$ = Object.defineProperties;
var __getOwnPropDescs$$ = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1r = Object.getOwnPropertySymbols;
var __hasOwnProp$1r = Object.prototype.hasOwnProperty;
var __propIsEnum$1r = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1w = (obj, key, value) => key in obj ? __defProp$1w(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1q = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1r.call(b, prop))
      __defNormalProp$1w(a, prop, b[prop]);
  if (__getOwnPropSymbols$1r)
    for (var prop of __getOwnPropSymbols$1r(b)) {
      if (__propIsEnum$1r.call(b, prop))
        __defNormalProp$1w(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$$ = (a, b) => __defProps$$(a, __getOwnPropDescs$$(b));
const ImageCell = (props) => {
  var _a;
  const { field, cell, tableStyles, row, cellProps } = props;
  const displayValue = field.display(cell.value);
  const hasLinks = Boolean((_a = getCellLinks(field, row)) == null ? void 0 : _a.length);
  const clearButtonStyle = useStyles2(clearLinkButtonStyles);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$$(__spreadValues$1q({}, cellProps), { className: tableStyles.cellContainer }), !hasLinks && /* @__PURE__ */ React__default["default"].createElement("img", { src: displayValue.text, className: tableStyles.imageCell, alt: "" }), hasLinks && /* @__PURE__ */ React__default["default"].createElement(DataLinksContextMenu, { style: { height: "100%" }, links: () => getCellLinks(field, row) || [] }, (api) => {
    const img = /* @__PURE__ */ React__default["default"].createElement("img", { src: displayValue.text, className: tableStyles.imageCell, alt: "" });
    if (api.openMenu) {
      return /* @__PURE__ */ React__default["default"].createElement(Button, { className: css.cx(clearButtonStyle), onClick: api.openMenu }, img);
    } else {
      return img;
    }
  }));
};

var __defProp$1v = Object.defineProperty;
var __defProps$_ = Object.defineProperties;
var __getOwnPropDescs$_ = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1q = Object.getOwnPropertySymbols;
var __hasOwnProp$1q = Object.prototype.hasOwnProperty;
var __propIsEnum$1q = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1v = (obj, key, value) => key in obj ? __defProp$1v(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1p = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1q.call(b, prop))
      __defNormalProp$1v(a, prop, b[prop]);
  if (__getOwnPropSymbols$1q)
    for (var prop of __getOwnPropSymbols$1q(b)) {
      if (__propIsEnum$1q.call(b, prop))
        __defNormalProp$1v(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$_ = (a, b) => __defProps$_(a, __getOwnPropDescs$_(b));
function JSONViewCell(props) {
  var _a, _b;
  const { cell, tableStyles, cellProps, field, row } = props;
  const inspectEnabled = Boolean((_a = field.config.custom) == null ? void 0 : _a.inspect);
  const txt = css.css({
    cursor: "pointer",
    fontFamily: "monospace"
  });
  let value = cell.value;
  let displayValue = value;
  if (lodash.isString(value)) {
    try {
      value = JSON.parse(value);
    } catch (e) {
    }
  } else {
    displayValue = JSON.stringify(value, null, " ");
  }
  const hasLinks = Boolean((_b = getCellLinks(field, row)) == null ? void 0 : _b.length);
  const clearButtonStyle = useStyles2(clearLinkButtonStyles);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$_(__spreadValues$1p({}, cellProps), { className: inspectEnabled ? tableStyles.cellContainerNoOverflow : tableStyles.cellContainer }), /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(tableStyles.cellText, txt) }, !hasLinks && /* @__PURE__ */ React__default["default"].createElement("div", { className: tableStyles.cellText }, displayValue), hasLinks && /* @__PURE__ */ React__default["default"].createElement(DataLinksContextMenu, { links: () => getCellLinks(field, row) || [] }, (api) => {
    if (api.openMenu) {
      return /* @__PURE__ */ React__default["default"].createElement(Button, { className: css.cx(clearButtonStyle), onClick: api.openMenu }, displayValue);
    } else {
      return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, displayValue);
    }
  })), inspectEnabled && /* @__PURE__ */ React__default["default"].createElement(CellActions, __spreadProps$_(__spreadValues$1p({}, props), { previewMode: "code" })));
}

var __defProp$1u = Object.defineProperty;
var __getOwnPropSymbols$1p = Object.getOwnPropertySymbols;
var __hasOwnProp$1p = Object.prototype.hasOwnProperty;
var __propIsEnum$1p = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1u = (obj, key, value) => key in obj ? __defProp$1u(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1o = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1p.call(b, prop))
      __defNormalProp$1u(a, prop, b[prop]);
  if (__getOwnPropSymbols$1p)
    for (var prop of __getOwnPropSymbols$1p(b)) {
      if (__propIsEnum$1p.call(b, prop))
        __defNormalProp$1u(a, prop, b[prop]);
    }
  return a;
};
function RowExpander({ row, tableStyles }) {
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$1o({ className: tableStyles.expanderCell }, row.getToggleRowExpandedProps()), /* @__PURE__ */ React__default["default"].createElement(
    Icon,
    {
      "aria-label": row.isExpanded ? "Collapse row" : "Expand row",
      name: row.isExpanded ? "angle-down" : "angle-right",
      size: "lg"
    }
  ));
}

const FIXED_UNIT = "__fixed";
class PlotConfigBuilder {
  constructor(props) {
    this.props = props;
  }
}

function buildScaleKey$1(config, fieldType) {
  var _a, _b, _c, _d, _e, _f, _g;
  const defaultPart = "na";
  const scaleRange = `${config.min !== void 0 ? config.min : defaultPart}-${config.max !== void 0 ? config.max : defaultPart}`;
  const scaleSoftRange = `${((_a = config.custom) == null ? void 0 : _a.axisSoftMin) !== void 0 ? config.custom.axisSoftMin : defaultPart}-${((_b = config.custom) == null ? void 0 : _b.axisSoftMax) !== void 0 ? config.custom.axisSoftMax : defaultPart}`;
  const scalePlacement = `${((_c = config.custom) == null ? void 0 : _c.axisPlacement) !== void 0 ? (_d = config.custom) == null ? void 0 : _d.axisPlacement : schema.AxisPlacement.Auto}`;
  const scaleUnit = (_e = config.unit) != null ? _e : FIXED_UNIT;
  const scaleDistribution = ((_f = config.custom) == null ? void 0 : _f.scaleDistribution) ? getScaleDistributionPart$1(config.custom.scaleDistribution) : schema.ScaleDistribution.Linear;
  const scaleLabel = Boolean((_g = config.custom) == null ? void 0 : _g.axisLabel) ? config.custom.axisLabel : defaultPart;
  return `${scaleUnit}/${scaleRange}/${scaleSoftRange}/${scalePlacement}/${scaleDistribution}/${scaleLabel}/${fieldType}`;
}
function getScaleDistributionPart$1(config) {
  if (config.type === schema.ScaleDistribution.Log) {
    return `${config.type}${config.log}`;
  }
  return config.type;
}

const paddingSide = (u, side, sidesWithAxes) => {
  let hasCrossAxis = side % 2 ? sidesWithAxes[0] || sidesWithAxes[2] : sidesWithAxes[1] || sidesWithAxes[3];
  return sidesWithAxes[side] || !hasCrossAxis ? 0 : 8;
};
const DEFAULT_PLOT_CONFIG = {
  ms: 1,
  focus: {
    alpha: 1
  },
  cursor: {
    focus: {
      prox: 30
    }
  },
  legend: {
    show: false
  },
  padding: [paddingSide, paddingSide, paddingSide, paddingSide],
  series: [],
  hooks: {}
};
function getStackingBands(group) {
  let bands = [];
  let { series, dir } = group;
  let lastIdx = series.length - 1;
  let rSeries = series.slice().reverse();
  rSeries.forEach((si, i) => {
    if (i !== lastIdx) {
      let nextIdx = rSeries[i + 1];
      bands.push({
        series: [si, nextIdx],
        // fill direction is inverted from stack direction
        dir: -1 * dir
      });
    }
  });
  return bands;
}
function getStackingGroups(frame) {
  let groups = /* @__PURE__ */ new Map();
  frame.fields.forEach(({ config, values, type }, i) => {
    var _a;
    if (i === 0) {
      return;
    }
    let { custom } = config;
    if (custom == null) {
      return;
    }
    if ((_a = custom.hideFrom) == null ? void 0 : _a.viz) {
      return;
    }
    let { stacking } = custom;
    if (stacking == null) {
      return;
    }
    let { mode: stackingMode, group: stackingGroup } = stacking;
    if (stackingMode === schema.StackingMode.None) {
      return;
    }
    let transform = custom.transform;
    let stackDir = getStackDirection(transform, values);
    let drawStyle = custom.drawStyle;
    let drawStyle2 = drawStyle === schema.GraphDrawStyle.Bars ? custom.barAlignment : drawStyle === schema.GraphDrawStyle.Line ? custom.lineInterpolation : null;
    let stackKey = `${stackDir}|${stackingMode}|${stackingGroup}|${buildScaleKey$1(
      config,
      type
    )}|${drawStyle}|${drawStyle2}`;
    let group = groups.get(stackKey);
    if (group == null) {
      group = {
        series: [],
        dir: stackDir
      };
      groups.set(stackKey, group);
    }
    group.series.push(i);
  });
  return [...groups.values()];
}
function preparePlotData2(frame, stackingGroups, onStackMeta) {
  let data$1 = Array(frame.fields.length);
  let stacksQty = stackingGroups.length;
  let dataLen = frame.length;
  let zeroArr = stacksQty > 0 ? Array(dataLen).fill(0) : [];
  let falseArr = stacksQty > 0 ? Array(dataLen).fill(false) : [];
  let accums = Array.from({ length: stacksQty }, () => zeroArr.slice());
  let anyValsAtX = Array.from({ length: stacksQty }, () => falseArr.slice());
  stackingGroups.forEach((group, groupIdx) => {
    let groupValsAtX = anyValsAtX[groupIdx];
    group.series.forEach((seriesIdx) => {
      var _a, _b;
      let field = frame.fields[seriesIdx];
      if ((_b = (_a = field.config.custom) == null ? void 0 : _a.hideFrom) == null ? void 0 : _b.viz) {
        return;
      }
      let vals = field.values;
      for (let i = 0; i < dataLen; i++) {
        if (vals[i] != null) {
          groupValsAtX[i] = true;
        }
      }
    });
  });
  frame.fields.forEach((field, i) => {
    var _a, _b;
    let vals = field.values;
    if (i === 0) {
      if (field.type === data.FieldType.time) {
        data$1[i] = data.ensureTimeField(field).values;
      } else {
        data$1[i] = vals;
      }
      return;
    }
    let { custom } = field.config;
    if (!custom || ((_a = custom.hideFrom) == null ? void 0 : _a.viz)) {
      data$1[i] = vals;
      return;
    }
    if (custom.transform === schema.GraphTransform.Constant) {
      let firstValIdx = vals.findIndex((v) => v != null);
      let firstVal = vals[firstValIdx];
      vals = Array(vals.length).fill(void 0);
      vals[firstValIdx] = firstVal;
    } else {
      vals = vals.slice();
      if (custom.transform === schema.GraphTransform.NegativeY) {
        for (let i2 = 0; i2 < vals.length; i2++) {
          if (vals[i2] != null) {
            vals[i2] *= -1;
          }
        }
      }
    }
    let stackingMode = (_b = custom.stacking) == null ? void 0 : _b.mode;
    if (!stackingMode || stackingMode === schema.StackingMode.None) {
      data$1[i] = vals;
    } else {
      let stackIdx = stackingGroups.findIndex((group) => group.series.indexOf(i) > -1);
      let accum = accums[stackIdx];
      let groupValsAtX = anyValsAtX[stackIdx];
      let stacked = data$1[i] = Array(dataLen);
      for (let i2 = 0; i2 < dataLen; i2++) {
        let v = vals[i2];
        if (v != null) {
          stacked[i2] = accum[i2] += v;
        } else {
          stacked[i2] = groupValsAtX[i2] ? accum[i2] : v;
        }
      }
    }
  });
  if (onStackMeta) {
    let accumsBySeriesIdx = data$1.map((vals, i) => {
      let stackIdx = stackingGroups.findIndex((group) => group.series.indexOf(i) > -1);
      return stackIdx !== -1 ? accums[stackIdx] : vals;
    });
    onStackMeta({
      totals: accumsBySeriesIdx
    });
  }
  frame.fields.forEach((field, i) => {
    var _a, _b, _c, _d;
    if (i === 0 || ((_b = (_a = field.config.custom) == null ? void 0 : _a.hideFrom) == null ? void 0 : _b.viz)) {
      return;
    }
    let stackingMode = (_d = (_c = field.config.custom) == null ? void 0 : _c.stacking) == null ? void 0 : _d.mode;
    if (stackingMode === schema.StackingMode.Percent) {
      let stackIdx = stackingGroups.findIndex((group2) => group2.series.indexOf(i) > -1);
      let accum = accums[stackIdx];
      let group = stackingGroups[stackIdx];
      let stacked = data$1[i];
      for (let i2 = 0; i2 < dataLen; i2++) {
        let v = stacked[i2];
        if (v != null) {
          stacked[i2] = accum[i2] === 0 ? 0 : group.dir * (v / accum[i2]);
        }
      }
    }
  });
  return data$1;
}
function findMidPointYPosition(u, idx) {
  let y;
  let sMaxIdx = 1;
  let sMinIdx = 1;
  let max = u.data[1][idx];
  let min = u.data[1][idx];
  for (let i = 1; i < u.data.length; i++) {
    const sData = u.data[i];
    const sVal = sData[idx];
    if (sVal != null) {
      if (max == null) {
        max = sVal;
      } else {
        if (sVal > max) {
          max = u.data[i][idx];
          sMaxIdx = i;
        }
      }
      if (min == null) {
        min = sVal;
      } else {
        if (sVal < min) {
          min = u.data[i][idx];
          sMinIdx = i;
        }
      }
    }
  }
  if (min == null && max == null) {
    y = void 0;
  } else if (min != null && max != null) {
    y = (u.valToPos(min, u.series[sMinIdx].scale) + u.valToPos(max, u.series[sMaxIdx].scale)) / 2;
  } else {
    y = u.valToPos(min || max, u.series[sMaxIdx || sMinIdx].scale);
  }
  if (y !== void 0 && y < 0) {
    y = u.bbox.height / devicePixelRatio;
  }
  return y;
}
function getStackDirection(transform, data) {
  const hasNegSamp = hasNegSample(data);
  if (transform === schema.GraphTransform.NegativeY) {
    return hasNegSamp ? 1 /* Pos */ : -1 /* Neg */;
  }
  return hasNegSamp ? -1 /* Neg */ : 1 /* Pos */;
}
function hasNegSample(data, samples = 100) {
  const len = data.length;
  if (len === 0) {
    return false;
  }
  let firstIdx = 0;
  let lastIdx = len - 1;
  while (firstIdx <= lastIdx && data[firstIdx] == null) {
    firstIdx++;
  }
  while (lastIdx >= firstIdx && data[lastIdx] == null) {
    lastIdx--;
  }
  let negCount = 0;
  let posCount = 0;
  if (lastIdx >= firstIdx) {
    const stride = Math.max(1, Math.floor((lastIdx - firstIdx + 1) / samples));
    for (let i = firstIdx; i <= lastIdx; i += stride) {
      const v = data[i];
      if (v != null && typeof v === "number") {
        if (v < 0 || Object.is(v, -0)) {
          negCount++;
        } else if (v > 0) {
          posCount++;
        }
      }
    }
    if (negCount > posCount) {
      return true;
    }
  }
  return false;
}
const pluginLogger = createLogger("uPlot");
const pluginLog = pluginLogger.logger;
attachDebugger("graphng", void 0, pluginLogger);

var __defProp$1t = Object.defineProperty;
var __getOwnPropSymbols$1o = Object.getOwnPropertySymbols;
var __hasOwnProp$1o = Object.prototype.hasOwnProperty;
var __propIsEnum$1o = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1t = (obj, key, value) => key in obj ? __defProp$1t(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1n = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1o.call(b, prop))
      __defNormalProp$1t(a, prop, b[prop]);
  if (__getOwnPropSymbols$1o)
    for (var prop of __getOwnPropSymbols$1o(b)) {
      if (__propIsEnum$1o.call(b, prop))
        __defNormalProp$1t(a, prop, b[prop]);
    }
  return a;
};
var __publicField$d = (obj, key, value) => {
  __defNormalProp$1t(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
function sameDims(prevProps, nextProps) {
  return nextProps.width === prevProps.width && nextProps.height === prevProps.height;
}
function sameData(prevProps, nextProps) {
  return nextProps.data === prevProps.data;
}
function sameConfig(prevProps, nextProps) {
  return nextProps.config === prevProps.config;
}
class UPlotChart extends React.Component {
  constructor(props) {
    super(props);
    __publicField$d(this, "plotContainer", React.createRef());
    __publicField$d(this, "plotCanvasBBox", React.createRef());
    this.state = {
      plot: null
    };
  }
  reinitPlot() {
    var _a;
    let { width, height, plotRef } = this.props;
    (_a = this.state.plot) == null ? void 0 : _a.destroy();
    if (width === 0 && height === 0) {
      return;
    }
    this.props.config.addHook("setSize", (u) => {
      const canvas = u.over;
      if (!canvas) {
        return;
      }
    });
    const config = __spreadValues$1n({
      width: Math.floor(this.props.width),
      height: Math.floor(this.props.height)
    }, this.props.config.getConfig());
    pluginLog("UPlot", false, "Reinitializing plot", config);
    const plot = new uPlot__default["default"](config, this.props.data, this.plotContainer.current);
    if (plotRef) {
      plotRef(plot);
    }
    this.setState({ plot });
  }
  componentDidMount() {
    this.reinitPlot();
  }
  componentWillUnmount() {
    var _a;
    (_a = this.state.plot) == null ? void 0 : _a.destroy();
  }
  componentDidUpdate(prevProps) {
    let { plot } = this.state;
    if (!sameDims(prevProps, this.props)) {
      plot == null ? void 0 : plot.setSize({
        width: Math.floor(this.props.width),
        height: Math.floor(this.props.height)
      });
    } else if (!sameConfig(prevProps, this.props)) {
      this.reinitPlot();
    } else if (!sameData(prevProps, this.props)) {
      plot == null ? void 0 : plot.setData(this.props.data);
    }
  }
  render() {
    return /* @__PURE__ */ React__default["default"].createElement("div", { style: { position: "relative" } }, /* @__PURE__ */ React__default["default"].createElement("div", { ref: this.plotContainer, "data-testid": "uplot-main-div" }), this.props.children);
  }
}

var __defProp$1s = Object.defineProperty;
var __getOwnPropSymbols$1n = Object.getOwnPropertySymbols;
var __hasOwnProp$1n = Object.prototype.hasOwnProperty;
var __propIsEnum$1n = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1s = (obj, key, value) => key in obj ? __defProp$1s(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1m = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1n.call(b, prop))
      __defNormalProp$1s(a, prop, b[prop]);
  if (__getOwnPropSymbols$1n)
    for (var prop of __getOwnPropSymbols$1n(b)) {
      if (__propIsEnum$1n.call(b, prop))
        __defNormalProp$1s(a, prop, b[prop]);
    }
  return a;
};
class UPlotScaleBuilder extends PlotConfigBuilder {
  merge(props) {
    this.props.min = optMinMax("min", this.props.min, props.min);
    this.props.max = optMinMax("max", this.props.max, props.max);
  }
  getConfig() {
    var _a, _b;
    let {
      isTime,
      scaleKey,
      min: hardMin,
      max: hardMax,
      softMin,
      softMax,
      range,
      direction,
      orientation,
      centeredZero,
      decimals
    } = this.props;
    const distr = this.props.distribution;
    const distribution = !isTime ? {
      distr: distr === schema.ScaleDistribution.Symlog ? 4 : distr === schema.ScaleDistribution.Log ? 3 : distr === schema.ScaleDistribution.Ordinal ? 2 : 1,
      log: distr === schema.ScaleDistribution.Log || distr === schema.ScaleDistribution.Symlog ? (_a = this.props.log) != null ? _a : 2 : void 0,
      asinh: distr === schema.ScaleDistribution.Symlog ? (_b = this.props.linearThreshold) != null ? _b : 1 : void 0
    } : {};
    if (distr === schema.ScaleDistribution.Log) {
      let logBase = this.props.log;
      let logFn = logBase === 2 ? Math.log2 : Math.log10;
      if (hardMin != null) {
        if (hardMin <= 0) {
          hardMin = null;
        } else {
          hardMin = logBase ** Math.floor(logFn(hardMin));
        }
      }
      if (hardMax != null) {
        if (hardMax <= 0) {
          hardMax = null;
        } else {
          hardMax = logBase ** Math.ceil(logFn(hardMax));
        }
      }
      if (softMin != null) {
        if (softMin <= 0) {
          softMin = null;
        } else {
          softMin = logBase ** Math.floor(logFn(softMin));
        }
      }
      if (softMax != null) {
        if (softMax <= 0) {
          softMax = null;
        } else {
          softMax = logBase ** Math.ceil(logFn(softMax));
        }
      }
    }
    let softMinMode = softMin == null ? 3 : 1;
    let softMaxMode = softMax == null ? 3 : 1;
    const rangeConfig = {
      min: {
        pad: 0.1,
        hard: hardMin != null ? hardMin : -Infinity,
        soft: softMin || 0,
        mode: softMinMode
      },
      max: {
        pad: 0.1,
        hard: hardMax != null ? hardMax : Infinity,
        soft: softMax || 0,
        mode: softMaxMode
      }
    };
    let hardMinOnly = softMin == null && hardMin != null;
    let hardMaxOnly = softMax == null && hardMax != null;
    let hasFixedRange = hardMinOnly && hardMaxOnly;
    const rangeFn = (u, dataMin, dataMax, scaleKey2) => {
      var _a2;
      const scale = u.scales[scaleKey2];
      let minMax = [dataMin, dataMax];
      if (scaleKey2 === "x" && !isTime && distr === schema.ScaleDistribution.Linear) {
        return minMax;
      }
      if (!hasFixedRange && dataMin == null && dataMax == null) {
        return minMax;
      }
      let logBase = (_a2 = scale.log) != null ? _a2 : 10;
      if (scale.distr === 1 || scale.distr === 2 || scale.distr === 4) {
        if (centeredZero) {
          let absMin = Math.abs(dataMin);
          let absMax = Math.abs(dataMax);
          let max = Math.max(absMin, absMax);
          if (max === 0) {
            max = 80;
          }
          dataMin = -max;
          dataMax = max;
        }
        if (scale.distr === 4) {
          minMax = uPlot__default["default"].rangeAsinh(dataMin, dataMax, logBase, true);
        } else {
          minMax = uPlot__default["default"].rangeNum(hardMinOnly ? hardMin : dataMin, hardMaxOnly ? hardMax : dataMax, rangeConfig);
        }
      } else if (scale.distr === 3) {
        minMax = uPlot__default["default"].rangeLog(hardMin != null ? hardMin : dataMin, hardMax != null ? hardMax : dataMax, logBase, true);
      }
      if (decimals === 0) {
        if (scale.distr === 1 || scale.distr === 2) {
          minMax[0] = data.incrRoundDn(minMax[0], 1);
          minMax[1] = data.incrRoundUp(minMax[1], 1);
        } else if (scale.distr === 3) {
          let logFn = scale.log === 2 ? Math.log2 : Math.log10;
          if (minMax[0] <= 1) {
            minMax[0] = 1;
          } else {
            let minExp = Math.floor(logFn(minMax[0]));
            minMax[0] = logBase ** minExp;
          }
          let maxExp = Math.ceil(logFn(minMax[1]));
          minMax[1] = logBase ** maxExp;
          if (minMax[0] === minMax[1]) {
            minMax[1] *= logBase;
          }
        } else if (scale.distr === 4) {
          minMax[0] = data.incrRoundDn(minMax[0], 1);
          minMax[1] = data.incrRoundUp(minMax[1], 1);
        }
      }
      if (scale.distr === 1 || scale.distr === 4) {
        if (hardMinOnly) {
          minMax[0] = hardMin;
        }
        if (hardMaxOnly) {
          minMax[1] = hardMax;
        }
      }
      if (minMax[0] >= minMax[1]) {
        minMax[0] = scale.distr === 3 ? 1 : 0;
        minMax[1] = 100;
      }
      return minMax;
    };
    let auto = !isTime && !hasFixedRange;
    if (data.isBooleanUnit(scaleKey)) {
      auto = false;
      range = [0, 1];
    }
    return {
      [scaleKey]: __spreadValues$1m({
        time: isTime,
        auto,
        range: range != null ? range : rangeFn,
        dir: direction,
        ori: orientation
      }, distribution)
    };
  }
}
function optMinMax(minmax, a, b) {
  const hasA = !(a === void 0 || a === null);
  const hasB = !(b === void 0 || b === null);
  if (hasA) {
    if (!hasB) {
      return a;
    }
    if (minmax === "min") {
      return a < b ? a : b;
    }
    return a > b ? a : b;
  }
  return b;
}

var __defProp$1r = Object.defineProperty;
var __getOwnPropSymbols$1m = Object.getOwnPropertySymbols;
var __hasOwnProp$1m = Object.prototype.hasOwnProperty;
var __propIsEnum$1m = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1r = (obj, key, value) => key in obj ? __defProp$1r(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1l = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1m.call(b, prop))
      __defNormalProp$1r(a, prop, b[prop]);
  if (__getOwnPropSymbols$1m)
    for (var prop of __getOwnPropSymbols$1m(b)) {
      if (__propIsEnum$1m.call(b, prop))
        __defNormalProp$1r(a, prop, b[prop]);
    }
  return a;
};
const UPLOT_AXIS_FONT_SIZE = 12;
const labelPad = 8;
class UPlotAxisBuilder extends PlotConfigBuilder {
  merge(props) {
    this.props.size = optMinMax("max", this.props.size, props.size);
    if (!this.props.label) {
      this.props.label = props.label;
    }
    if (this.props.placement === schema.AxisPlacement.Auto) {
      this.props.placement = props.placement;
    }
  }
  /* Minimum grid & tick spacing in CSS pixels */
  calculateSpace(self, axisIdx, scaleMin, scaleMax, plotDim) {
    const axis = self.axes[axisIdx];
    const scale = self.scales[axis.scale];
    if (axis.side !== 2 || !scale) {
      return 30;
    }
    const defaultSpacing = 40;
    if (scale.time) {
      const maxTicks = plotDim / defaultSpacing;
      const increment = (scaleMax - scaleMin) / maxTicks;
      const sample = formatTime(self, [scaleMin], axisIdx, defaultSpacing, increment);
      const width = measureText(sample[0], UPLOT_AXIS_FONT_SIZE).width + 18;
      return width;
    }
    return defaultSpacing;
  }
  /** height of x axis or width of y axis in CSS pixels alloted for values, gap & ticks, but excluding axis label */
  calculateAxisSize(self, values, axisIdx) {
    const axis = self.axes[axisIdx];
    let axisSize = axis.ticks.size;
    if (axis.side === 2) {
      axisSize += axis.gap + UPLOT_AXIS_FONT_SIZE;
    } else if (values == null ? void 0 : values.length) {
      let maxTextWidth = values.reduce(
        (acc, value) => Math.max(acc, measureText(value, UPLOT_AXIS_FONT_SIZE).width),
        0
      );
      const textWidthWithLimit = Math.min(self.width * 0.4, maxTextWidth);
      axisSize += axis.gap + axis.labelGap + textWidthWithLimit;
    }
    return Math.ceil(axisSize);
  }
  getConfig() {
    let {
      scaleKey,
      label,
      show = true,
      placement = schema.AxisPlacement.Auto,
      grid = { show: true },
      ticks,
      space,
      filter,
      gap = 5,
      formatValue,
      splits,
      values,
      incrs,
      isTime,
      timeZone,
      theme,
      tickLabelRotation,
      size,
      color,
      border,
      decimals,
      distr = schema.ScaleDistribution.Linear
    } = this.props;
    const font = `${UPLOT_AXIS_FONT_SIZE}px ${theme.typography.fontFamily}`;
    const gridColor = theme.isDark ? "rgba(240, 250, 255, 0.09)" : "rgba(0, 10, 23, 0.09)";
    if (data.isBooleanUnit(scaleKey)) {
      splits = [0, 1];
    }
    if (decimals === 0 && distr === schema.ScaleDistribution.Linear) {
      filter = (u, splits2) => splits2.map((v) => Number.isInteger(v) ? v : null);
    }
    let config = {
      scale: scaleKey,
      show,
      stroke: color != null ? color : theme.colors.text.primary,
      side: getUPlotSideFromAxis(placement),
      font,
      size: size != null ? size : (self, values2, axisIdx) => {
        return this.calculateAxisSize(self, values2, axisIdx);
      },
      rotate: tickLabelRotation,
      gap,
      labelGap: 0,
      grid: {
        show: grid.show,
        stroke: gridColor,
        width: 1 / devicePixelRatio
      },
      ticks: Object.assign(
        {
          show: true,
          stroke: (border == null ? void 0 : border.show) ? color != null ? color : theme.colors.text.primary : gridColor,
          width: 1 / devicePixelRatio,
          size: 4
        },
        ticks
      ),
      splits,
      values,
      space: space != null ? space : (self, axisIdx, scaleMin, scaleMax, plotDim) => {
        return this.calculateSpace(self, axisIdx, scaleMin, scaleMax, plotDim);
      },
      filter,
      incrs
    };
    if (border == null ? void 0 : border.show) {
      config.border = __spreadValues$1l({
        stroke: color != null ? color : theme.colors.text.primary,
        width: 1 / devicePixelRatio
      }, border);
    }
    if (label != null && label.length > 0) {
      config.label = label;
      config.labelSize = UPLOT_AXIS_FONT_SIZE + labelPad;
      config.labelFont = font;
      config.labelGap = labelPad;
    }
    if (values) {
      config.values = values;
    } else if (isTime) {
      config.values = formatTime;
    } else if (formatValue) {
      config.values = (u, splits2, axisIdx, tickSpace, tickIncr) => {
        let decimals2 = data.guessDecimals(data.roundDecimals(tickIncr, 6));
        return splits2.map((v) => formatValue(v, decimals2 > 0 ? decimals2 : void 0));
      };
    }
    config.timeZone = timeZone;
    return config;
  }
}
const timeUnitSize = {
  second: 1e3,
  minute: 60 * 1e3,
  hour: 60 * 60 * 1e3,
  day: 24 * 60 * 60 * 1e3,
  month: 28 * 24 * 60 * 60 * 1e3,
  year: 365 * 24 * 60 * 60 * 1e3
};
function formatTime(self, splits, axisIdx, foundSpace, foundIncr) {
  var _a, _b;
  const timeZone = self.axes[axisIdx].timeZone;
  const scale = self.scales.x;
  const range = ((_a = scale == null ? void 0 : scale.max) != null ? _a : 0) - ((_b = scale == null ? void 0 : scale.min) != null ? _b : 0);
  const yearRoundedToDay = Math.round(timeUnitSize.year / timeUnitSize.day) * timeUnitSize.day;
  const incrementRoundedToDay = Math.round(foundIncr / timeUnitSize.day) * timeUnitSize.day;
  let format = data.systemDateFormats.interval.year;
  if (foundIncr < timeUnitSize.second) {
    format = data.systemDateFormats.interval.millisecond;
  } else if (foundIncr <= timeUnitSize.minute) {
    format = data.systemDateFormats.interval.second;
  } else if (range <= timeUnitSize.day) {
    format = data.systemDateFormats.interval.minute;
  } else if (foundIncr <= timeUnitSize.day) {
    format = data.systemDateFormats.interval.hour;
  } else if (range < timeUnitSize.year) {
    format = data.systemDateFormats.interval.day;
  } else if (incrementRoundedToDay === yearRoundedToDay) {
    format = data.systemDateFormats.interval.year;
  } else if (foundIncr <= timeUnitSize.year) {
    format = data.systemDateFormats.interval.month;
  }
  return splits.map((v) => v == null ? "" : data.dateTimeFormat(v, { format, timeZone }));
}
function getUPlotSideFromAxis(axis) {
  switch (axis) {
    case schema.AxisPlacement.Top:
      return 0;
    case schema.AxisPlacement.Right:
      return 1;
    case schema.AxisPlacement.Bottom:
      return 2;
    case schema.AxisPlacement.Left:
  }
  return 3;
}

function makeDirectionalGradient(direction, bbox, ctx) {
  let x0 = 0, y0 = 0, x1 = 0, y1 = 0;
  if (direction === 3 /* Down */) {
    y0 = bbox.top;
    y1 = bbox.top + bbox.height;
  } else if (direction === 2 /* Left */) {
    x0 = bbox.left + bbox.width;
    x1 = bbox.left;
  } else if (direction === 1 /* Up */) {
    y0 = bbox.top + bbox.height;
    y1 = bbox.top;
  } else if (direction === 0 /* Right */) {
    x0 = bbox.left;
    x1 = bbox.left + bbox.width;
  }
  return ctx.createLinearGradient(x0, y0, x1, y1);
}
function getOpacityGradientFn(color, opacity) {
  return (plot, seriesIdx) => {
    const ctx = getCanvasContext();
    const gradient = makeDirectionalGradient(
      plot.scales.x.ori === schema.ScaleOrientation.Horizontal ? 3 /* Down */ : 2 /* Left */,
      plot.bbox,
      ctx
    );
    gradient.addColorStop(0, data.colorManipulator.alpha(color, opacity));
    gradient.addColorStop(1, data.colorManipulator.alpha(color, 0));
    return gradient;
  };
}
function getHueGradientFn(color, opacity, theme) {
  return (plot, seriesIdx) => {
    const ctx = getCanvasContext();
    const gradient = makeDirectionalGradient(
      plot.scales.x.ori === schema.ScaleOrientation.Horizontal ? 3 /* Down */ : 2 /* Left */,
      plot.bbox,
      ctx
    );
    const color1 = tinycolor__default["default"](color).spin(-25).darken(5);
    const color2 = tinycolor__default["default"](color).saturate(20).spin(20).brighten(10);
    if (theme.isDark) {
      gradient.addColorStop(0, color2.lighten(10).setAlpha(opacity).toString());
      gradient.addColorStop(1, color1.darken(10).setAlpha(opacity).toString());
    } else {
      gradient.addColorStop(0, color2.lighten(10).setAlpha(opacity).toString());
      gradient.addColorStop(1, color1.setAlpha(opacity).toString());
    }
    return gradient;
  };
}
function scaleGradient(u, scaleKey, scaleStops, discrete = false) {
  let scale = u.scales[scaleKey];
  let minStopIdx = null;
  let maxStopIdx = null;
  for (let i = 0; i < scaleStops.length; i++) {
    let stopVal = scaleStops[i][0];
    if (stopVal <= scale.min || minStopIdx == null) {
      minStopIdx = i;
    }
    maxStopIdx = i;
    if (stopVal >= scale.max) {
      break;
    }
  }
  if (minStopIdx === maxStopIdx) {
    return scaleStops[minStopIdx][1];
  }
  let minStopVal = scaleStops[minStopIdx][0];
  let maxStopVal = scaleStops[maxStopIdx][0];
  if (minStopVal === -Infinity) {
    minStopVal = scale.min;
  }
  if (maxStopVal === Infinity) {
    maxStopVal = scale.max;
  }
  let minStopPos = Math.round(u.valToPos(minStopVal, scaleKey, true));
  let maxStopPos = Math.round(u.valToPos(maxStopVal, scaleKey, true));
  let range = minStopPos - maxStopPos;
  if (range === 0) {
    return scaleStops[maxStopIdx][1];
  }
  let x0, y0, x1, y1;
  if (u.scales.x.ori === schema.ScaleOrientation.Horizontal) {
    x0 = x1 = 0;
    y0 = minStopPos;
    y1 = maxStopPos;
  } else {
    y0 = y1 = 0;
    x0 = minStopPos;
    x1 = maxStopPos;
  }
  let ctx = getCanvasContext();
  let grd = ctx.createLinearGradient(x0, y0, x1, y1);
  let prevColor;
  for (let i = minStopIdx; i <= maxStopIdx; i++) {
    let s = scaleStops[i];
    let stopPos = i === minStopIdx ? minStopPos : i === maxStopIdx ? maxStopPos : Math.round(u.valToPos(s[0], scaleKey, true));
    let pct = (minStopPos - stopPos) / range;
    if (discrete && i > minStopIdx) {
      grd.addColorStop(pct, prevColor);
    }
    grd.addColorStop(pct, prevColor = s[1]);
  }
  return grd;
}
function getDataRange(plot, scaleKey) {
  let sc = plot.scales[scaleKey];
  let min = Infinity;
  let max = -Infinity;
  plot.series.forEach((ser, seriesIdx) => {
    if (ser.show && ser.scale === scaleKey) {
      if (ser.min == null) {
        let data = plot.data[seriesIdx];
        for (let i = 0; i < data.length; i++) {
          if (data[i] != null) {
            min = Math.min(min, data[i]);
            max = Math.max(max, data[i]);
          }
        }
      } else {
        min = Math.min(min, ser.min);
        max = Math.max(max, ser.max);
      }
    }
  });
  if (max === min) {
    min = sc.min;
    max = sc.max;
  }
  return [min, max];
}
function getGradientRange(u, scaleKey, hardMin, hardMax, softMin, softMax) {
  var _a, _b, _c, _d;
  let min = (_a = hardMin != null ? hardMin : softMin) != null ? _a : null;
  let max = (_b = hardMax != null ? hardMax : softMax) != null ? _b : null;
  if (min == null || max == null) {
    let [dataMin, dataMax] = getDataRange(u, scaleKey);
    min = (_c = min != null ? min : dataMin) != null ? _c : 0;
    max = (_d = max != null ? max : dataMax) != null ? _d : 100;
  }
  return [min, max];
}
function isStepTransparent(color) {
  return color === "transparent" || color[0] === "#" && color.slice(-2) === "00";
}
function getScaleGradientFn(opacity, theme, colorMode, thresholds, hardMin, hardMax, softMin, softMax) {
  if (!colorMode) {
    throw Error("Missing colorMode required for color scheme gradients");
  }
  if (!thresholds) {
    throw Error("Missing thresholds required for color scheme gradients");
  }
  return (plot, seriesIdx) => {
    let scaleKey = plot.series[seriesIdx].scale;
    let gradient = "";
    if (colorMode.id === data.FieldColorModeId.Thresholds) {
      if (thresholds.mode === data.ThresholdsMode.Absolute) {
        const valueStops = thresholds.steps.map((step) => [
          step.value,
          isStepTransparent(step.color) ? "#0000" : data.colorManipulator.alpha(theme.visualization.getColorByName(step.color), opacity)
        ]);
        gradient = scaleGradient(plot, scaleKey, valueStops, true);
      } else {
        const [min, max] = getGradientRange(plot, scaleKey, hardMin, hardMax, softMin, softMax);
        const range = max - min;
        const valueStops = thresholds.steps.map((step) => [
          min + range * (step.value / 100),
          data.colorManipulator.alpha(theme.visualization.getColorByName(step.color), opacity)
        ]);
        gradient = scaleGradient(plot, scaleKey, valueStops, true);
      }
    } else if (colorMode.getColors) {
      const colors = colorMode.getColors(theme);
      const [min, max] = getGradientRange(plot, scaleKey, hardMin, hardMax, softMin, softMax);
      const range = max - min;
      const valueStops = colors.map((color, i) => [
        min + range * (i / (colors.length - 1)),
        data.colorManipulator.alpha(theme.visualization.getColorByName(color), opacity)
      ]);
      gradient = scaleGradient(plot, scaleKey, valueStops, false);
    }
    return gradient;
  };
}

var __defProp$1q = Object.defineProperty;
var __getOwnPropSymbols$1l = Object.getOwnPropertySymbols;
var __hasOwnProp$1l = Object.prototype.hasOwnProperty;
var __propIsEnum$1l = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1q = (obj, key, value) => key in obj ? __defProp$1q(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1k = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1l.call(b, prop))
      __defNormalProp$1q(a, prop, b[prop]);
  if (__getOwnPropSymbols$1l)
    for (var prop of __getOwnPropSymbols$1l(b)) {
      if (__propIsEnum$1l.call(b, prop))
        __defNormalProp$1q(a, prop, b[prop]);
    }
  return a;
};
class UPlotSeriesBuilder extends PlotConfigBuilder {
  getConfig() {
    var _a;
    const {
      facets,
      drawStyle,
      pathBuilder,
      pointsBuilder,
      pointsFilter,
      lineInterpolation,
      lineWidth,
      lineStyle,
      barAlignment,
      barWidthFactor,
      barMaxWidth,
      showPoints,
      pointSize,
      scaleKey,
      pxAlign,
      spanNulls,
      show = true
    } = this.props;
    let lineConfig = {};
    let lineColor = this.getLineColor();
    lineConfig.stroke = lineColor;
    lineConfig.width = lineWidth;
    if (lineStyle && lineStyle.fill !== "solid") {
      if (lineStyle.fill === "dot") {
        lineConfig.cap = "round";
      }
      lineConfig.dash = (_a = lineStyle.dash) != null ? _a : [10, 10];
    }
    if (pathBuilder != null) {
      lineConfig.paths = pathBuilder;
    } else if (drawStyle === schema.GraphDrawStyle.Points) {
      lineConfig.paths = () => null;
    } else if (drawStyle != null) {
      lineConfig.paths = (self, seriesIdx, idx0, idx1) => {
        let pathsBuilder = mapDrawStyleToPathBuilder(
          drawStyle,
          lineInterpolation,
          barAlignment,
          barWidthFactor,
          barMaxWidth
        );
        return pathsBuilder(self, seriesIdx, idx0, idx1);
      };
    }
    const useColor = (
      // @ts-ignore
      typeof lineColor === "string" ? lineColor : (u, seriesIdx) => u.series[seriesIdx]._stroke
    );
    const pointsConfig = {
      points: {
        stroke: useColor,
        fill: useColor,
        size: !pointSize || pointSize < lineWidth ? void 0 : pointSize,
        filter: pointsFilter
      }
    };
    if (pointsBuilder != null) {
      pointsConfig.points.show = pointsBuilder;
    } else {
      if (drawStyle === schema.GraphDrawStyle.Points) {
        pointsConfig.points.show = true;
      } else {
        if (showPoints === schema.VisibilityMode.Auto) {
          if (drawStyle === schema.GraphDrawStyle.Bars) {
            pointsConfig.points.show = false;
          }
        } else if (showPoints === schema.VisibilityMode.Never) {
          pointsConfig.points.show = false;
        } else if (showPoints === schema.VisibilityMode.Always) {
          pointsConfig.points.show = true;
        }
      }
    }
    return __spreadValues$1k(__spreadValues$1k({
      scale: scaleKey,
      facets,
      spanGaps: typeof spanNulls === "number" ? false : spanNulls,
      value: () => "",
      pxAlign,
      show,
      fill: this.getFill()
    }, lineConfig), pointsConfig);
  }
  getLineColor() {
    const {
      lineColor,
      gradientMode,
      colorMode,
      thresholds,
      theme,
      hardMin,
      hardMax,
      softMin,
      softMax,
      dynamicSeriesColor
    } = this.props;
    if (gradientMode === schema.GraphGradientMode.None && dynamicSeriesColor) {
      return (plot, seriesIdx) => {
        var _a, _b;
        return (_b = (_a = dynamicSeriesColor(seriesIdx)) != null ? _a : lineColor) != null ? _b : data.FALLBACK_COLOR;
      };
    }
    if (gradientMode === schema.GraphGradientMode.Scheme && (colorMode == null ? void 0 : colorMode.id) !== data.FieldColorModeId.Fixed) {
      return getScaleGradientFn(1, theme, colorMode, thresholds, hardMin, hardMax, softMin, softMax);
    }
    if (gradientMode === schema.GraphGradientMode.Hue) {
      return getHueGradientFn(lineColor != null ? lineColor : data.FALLBACK_COLOR, 1, theme);
    }
    return lineColor != null ? lineColor : data.FALLBACK_COLOR;
  }
  getFill() {
    const {
      lineColor,
      fillColor,
      gradientMode,
      fillOpacity,
      colorMode,
      thresholds,
      theme,
      hardMin,
      hardMax,
      softMin,
      softMax,
      dynamicSeriesColor
    } = this.props;
    if (fillColor) {
      return fillColor;
    }
    const mode = gradientMode != null ? gradientMode : schema.GraphGradientMode.None;
    const opacityPercent = (fillOpacity != null ? fillOpacity : 0) / 100;
    if (mode === schema.GraphGradientMode.None && dynamicSeriesColor && opacityPercent > 0) {
      return (u, seriesIdx) => {
        let lineColor2 = u.series[seriesIdx]._stroke;
        return data.colorManipulator.alpha(lineColor2 != null ? lineColor2 : "", opacityPercent);
      };
    }
    switch (mode) {
      case schema.GraphGradientMode.Opacity:
        return getOpacityGradientFn(fillColor != null ? fillColor : lineColor, opacityPercent);
      case schema.GraphGradientMode.Hue:
        return getHueGradientFn(fillColor != null ? fillColor : lineColor, opacityPercent, theme);
      case schema.GraphGradientMode.Scheme:
        if ((colorMode == null ? void 0 : colorMode.id) !== data.FieldColorModeId.Fixed) {
          return getScaleGradientFn(opacityPercent, theme, colorMode, thresholds, hardMin, hardMax, softMin, softMax);
        }
      default:
        if (opacityPercent > 0) {
          return data.colorManipulator.alpha(lineColor != null ? lineColor : "", opacityPercent);
        }
    }
    return void 0;
  }
}
let builders = void 0;
function mapDrawStyleToPathBuilder(style, lineInterpolation, barAlignment = schema.BarAlignment.Center, barWidthFactor = 0.6, barMaxWidth = 200) {
  const pathBuilders = uPlot__default["default"].paths;
  if (!builders) {
    builders = {
      linear: pathBuilders.linear(),
      smooth: pathBuilders.spline(),
      stepBefore: pathBuilders.stepped({ align: -1 }),
      stepAfter: pathBuilders.stepped({ align: 1 })
    };
  }
  if (style === schema.GraphDrawStyle.Bars) {
    let barsCfgKey = `bars|${barAlignment}|${barWidthFactor}|${barMaxWidth}`;
    if (!builders[barsCfgKey]) {
      builders[barsCfgKey] = pathBuilders.bars({
        size: [barWidthFactor, barMaxWidth],
        align: barAlignment
      });
    }
    return builders[barsCfgKey];
  } else if (style === schema.GraphDrawStyle.Line) {
    if (lineInterpolation === schema.LineInterpolation.StepBefore) {
      return builders.stepBefore;
    }
    if (lineInterpolation === schema.LineInterpolation.StepAfter) {
      return builders.stepAfter;
    }
    if (lineInterpolation === schema.LineInterpolation.Smooth) {
      return builders.smooth;
    }
  }
  return builders.linear;
}

var __defProp$1p = Object.defineProperty;
var __defProps$Z = Object.defineProperties;
var __getOwnPropDescs$Z = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1k = Object.getOwnPropertySymbols;
var __hasOwnProp$1k = Object.prototype.hasOwnProperty;
var __propIsEnum$1k = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1p = (obj, key, value) => key in obj ? __defProp$1p(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1j = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1k.call(b, prop))
      __defNormalProp$1p(a, prop, b[prop]);
  if (__getOwnPropSymbols$1k)
    for (var prop of __getOwnPropSymbols$1k(b)) {
      if (__propIsEnum$1k.call(b, prop))
        __defNormalProp$1p(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$Z = (a, b) => __defProps$Z(a, __getOwnPropDescs$Z(b));
function getThresholdsDrawHook(options) {
  const dashSegments = options.config.mode === schema.GraphThresholdsStyleMode.Dashed || options.config.mode === schema.GraphThresholdsStyleMode.DashedAndArea ? [10, 10] : null;
  function addLines(u, yScaleKey, steps, theme2) {
    let ctx = u.ctx;
    let transparentIndex = 0;
    for (let idx = 0; idx < steps.length; idx++) {
      const step = steps[idx];
      if (step.color === "transparent") {
        transparentIndex = idx;
        break;
      }
    }
    ctx.lineWidth = 2;
    if (dashSegments) {
      ctx.setLineDash(dashSegments);
    }
    for (let idx = 1; idx < steps.length; idx++) {
      const step = steps[idx];
      let color;
      if (transparentIndex >= idx && idx > 0) {
        color = tinycolor__default["default"](theme2.visualization.getColorByName(steps[idx - 1].color));
      } else {
        color = tinycolor__default["default"](theme2.visualization.getColorByName(step.color));
      }
      if (color.getAlpha() === 1) {
        color.setAlpha(0.7);
      }
      let x0 = Math.round(u.bbox.left);
      let y0 = Math.round(u.valToPos(step.value, yScaleKey, true));
      let x1 = Math.round(u.bbox.left + u.bbox.width);
      let y1 = Math.round(u.valToPos(step.value, yScaleKey, true));
      ctx.beginPath();
      ctx.moveTo(x0, y0);
      ctx.lineTo(x1, y1);
      ctx.strokeStyle = color.toString();
      ctx.stroke();
    }
  }
  function addAreas(u, yScaleKey, steps, theme2) {
    let ctx = u.ctx;
    let grd = scaleGradient(
      u,
      yScaleKey,
      steps.map((step) => {
        let color = tinycolor__default["default"](theme2.visualization.getColorByName(step.color));
        if (color.getAlpha() === 1) {
          color.setAlpha(0.15);
        }
        return [step.value, color.toString()];
      }),
      true
    );
    ctx.fillStyle = grd;
    ctx.fillRect(u.bbox.left, u.bbox.top, u.bbox.width, u.bbox.height);
  }
  const { scaleKey, thresholds, theme, config, hardMin, hardMax, softMin, softMax } = options;
  return (u) => {
    const ctx = u.ctx;
    const { min: xMin, max: xMax } = u.scales.x;
    const { min: yMin, max: yMax } = u.scales[scaleKey];
    if (xMin == null || xMax == null || yMin == null || yMax == null) {
      return;
    }
    let { steps, mode } = thresholds;
    if (mode === data.ThresholdsMode.Percentage) {
      let [min, max] = getGradientRange(u, scaleKey, hardMin, hardMax, softMin, softMax);
      let range = max - min;
      steps = steps.map((step) => __spreadProps$Z(__spreadValues$1j({}, step), {
        value: min + range * (step.value / 100)
      }));
    }
    ctx.save();
    switch (config.mode) {
      case schema.GraphThresholdsStyleMode.Line:
      case schema.GraphThresholdsStyleMode.Dashed:
        addLines(u, scaleKey, steps, theme);
        break;
      case schema.GraphThresholdsStyleMode.Area:
        addAreas(u, scaleKey, steps, theme);
        break;
      case schema.GraphThresholdsStyleMode.LineAndArea:
      case schema.GraphThresholdsStyleMode.DashedAndArea:
        addAreas(u, scaleKey, steps, theme);
        addLines(u, scaleKey, steps, theme);
    }
    ctx.restore();
  };
}

var __defProp$1o = Object.defineProperty;
var __defProps$Y = Object.defineProperties;
var __getOwnPropDescs$Y = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1j = Object.getOwnPropertySymbols;
var __hasOwnProp$1j = Object.prototype.hasOwnProperty;
var __propIsEnum$1j = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1o = (obj, key, value) => key in obj ? __defProp$1o(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1i = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1j.call(b, prop))
      __defNormalProp$1o(a, prop, b[prop]);
  if (__getOwnPropSymbols$1j)
    for (var prop of __getOwnPropSymbols$1j(b)) {
      if (__propIsEnum$1j.call(b, prop))
        __defNormalProp$1o(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$Y = (a, b) => __defProps$Y(a, __getOwnPropDescs$Y(b));
var __publicField$c = (obj, key, value) => {
  __defNormalProp$1o(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
const cursorDefaults = {
  // prevent client-side zoom from triggering at the end of a selection
  drag: { setScale: false },
  points: {
    /*@ts-ignore*/
    size: (u, seriesIdx) => u.series[seriesIdx].points.size * 2,
    /*@ts-ignore*/
    width: (u, seriesIdx, size) => size / 4
  },
  focus: {
    prox: 30
  }
};
class UPlotConfigBuilder {
  constructor(timeZone = data.DefaultTimeZone) {
    __publicField$c(this, "series", []);
    __publicField$c(this, "axes", {});
    __publicField$c(this, "scales", []);
    __publicField$c(this, "bands", []);
    __publicField$c(this, "stackingGroups", []);
    __publicField$c(this, "cursor");
    __publicField$c(this, "select");
    __publicField$c(this, "hasLeftAxis", false);
    __publicField$c(this, "hooks", {});
    __publicField$c(this, "tz");
    __publicField$c(this, "sync", false);
    __publicField$c(this, "mode", 1);
    __publicField$c(this, "frames");
    // to prevent more than one threshold per scale
    __publicField$c(this, "thresholds", {});
    // Custom handler for closest datapoint and series lookup
    __publicField$c(this, "tooltipInterpolator");
    __publicField$c(this, "padding");
    __publicField$c(this, "cachedConfig");
    __publicField$c(this, "prepData");
    // Exposed to let the container know the primary scale keys
    __publicField$c(this, "scaleKeys", ["", ""]);
    __publicField$c(this, "tzDate", (ts) => {
      let date = new Date(ts);
      return this.tz ? uPlot__default["default"].tzDate(date, this.tz) : date;
    });
    var _a;
    this.tz = (_a = data.getTimeZoneInfo(timeZone, Date.now())) == null ? void 0 : _a.ianaName;
  }
  addHook(type, hook) {
    pluginLog("UPlotConfigBuilder", false, "addHook", type);
    if (!this.hooks[type]) {
      this.hooks[type] = [];
    }
    this.hooks[type].push(hook);
  }
  addThresholds(options) {
    if (!this.thresholds[options.scaleKey]) {
      this.thresholds[options.scaleKey] = options;
      this.addHook("drawClear", getThresholdsDrawHook(options));
    }
  }
  addAxis(props) {
    var _a, _b, _c;
    props.placement = (_a = props.placement) != null ? _a : schema.AxisPlacement.Auto;
    props.grid = (_b = props.grid) != null ? _b : {};
    let scaleKey = props.scaleKey;
    if (scaleKey === "x") {
      scaleKey += (_c = props.timeZone) != null ? _c : "";
    }
    if (this.axes[scaleKey]) {
      this.axes[scaleKey].merge(props);
      return;
    }
    if (props.placement === schema.AxisPlacement.Auto) {
      props.placement = this.hasLeftAxis ? schema.AxisPlacement.Right : schema.AxisPlacement.Left;
    }
    if (props.placement === schema.AxisPlacement.Left) {
      this.hasLeftAxis = true;
    }
    if (props.placement === schema.AxisPlacement.Hidden) {
      props.grid.show = false;
      props.size = 0;
    }
    this.axes[scaleKey] = new UPlotAxisBuilder(props);
  }
  getAxisPlacement(scaleKey) {
    var _a;
    const axis = this.axes[scaleKey];
    return (_a = axis == null ? void 0 : axis.props.placement) != null ? _a : schema.AxisPlacement.Left;
  }
  setCursor(cursor) {
    this.cursor = lodash.merge({}, this.cursor, cursor);
  }
  setMode(mode) {
    this.mode = mode;
  }
  setSelect(select) {
    this.select = select;
  }
  addSeries(props) {
    this.series.push(new UPlotSeriesBuilder(props));
  }
  getSeries() {
    return this.series;
  }
  /** Add or update the scale with the scale key */
  addScale(props) {
    const current = this.scales.find((v) => v.props.scaleKey === props.scaleKey);
    if (current) {
      current.merge(props);
      return;
    }
    this.scales.push(new UPlotScaleBuilder(props));
  }
  addBand(band) {
    this.bands.push(band);
  }
  setStackingGroups(groups) {
    this.stackingGroups = groups;
  }
  getStackingGroups() {
    return this.stackingGroups;
  }
  setTooltipInterpolator(interpolator) {
    this.tooltipInterpolator = interpolator;
  }
  getTooltipInterpolator() {
    return this.tooltipInterpolator;
  }
  setPrepData(prepData) {
    this.prepData = (frames) => {
      this.frames = frames;
      return prepData(frames, this.getStackingGroups());
    };
  }
  setSync() {
    this.sync = true;
  }
  hasSync() {
    return this.sync;
  }
  setPadding(padding) {
    this.padding = padding;
  }
  getConfig() {
    if (this.cachedConfig) {
      return this.cachedConfig;
    }
    const config = __spreadProps$Y(__spreadValues$1i({}, DEFAULT_PLOT_CONFIG), {
      mode: this.mode,
      series: [
        this.mode === 2 ? null : {
          value: () => ""
        }
      ]
    });
    config.axes = this.ensureNonOverlappingAxes(Object.values(this.axes)).map((a) => a.getConfig());
    config.series = [...config.series, ...this.series.map((s) => s.getConfig())];
    config.scales = this.scales.reduce((acc, s) => {
      return __spreadValues$1i(__spreadValues$1i({}, acc), s.getConfig());
    }, {});
    config.hooks = this.hooks;
    config.select = this.select;
    const pointColorFn = (alphaHex = "") => (u, seriesIdx) => {
      let s = u.series[seriesIdx].points._stroke;
      if (typeof s !== "string") {
        let field = this.frames[0].fields[seriesIdx];
        s = field.display(field.values[u.cursor.idxs[seriesIdx]]).color;
      }
      return s + alphaHex;
    };
    config.cursor = lodash.merge(
      {},
      cursorDefaults,
      {
        points: {
          stroke: pointColorFn("80"),
          fill: pointColorFn()
        }
      },
      this.cursor
    );
    config.tzDate = this.tzDate;
    if (Array.isArray(this.padding)) {
      config.padding = this.padding;
    }
    this.stackingGroups.forEach((group) => {
      getStackingBands(group).forEach((band) => {
        this.addBand(band);
      });
    });
    if (this.bands.length) {
      config.bands = this.bands;
    }
    this.cachedConfig = config;
    return config;
  }
  ensureNonOverlappingAxes(axes) {
    const xAxis = axes.find((a) => a.props.scaleKey === "x");
    const axesWithoutGridSet = axes.filter((a) => {
      var _a;
      return ((_a = a.props.grid) == null ? void 0 : _a.show) === void 0;
    });
    const firstValueAxisIdx = axesWithoutGridSet.findIndex(
      (a) => a.props.placement === schema.AxisPlacement.Left || a.props.placement === schema.AxisPlacement.Right || a.props.placement === schema.AxisPlacement.Bottom && a !== xAxis
    );
    for (let i = 0; i < axesWithoutGridSet.length; i++) {
      if (axesWithoutGridSet[i] === xAxis || i === firstValueAxisIdx) {
        axesWithoutGridSet[i].props.grid.show = true;
      } else {
        axesWithoutGridSet[i].props.grid.show = false;
      }
    }
    return axes;
  }
}

var __defProp$1n = Object.defineProperty;
var __defProps$X = Object.defineProperties;
var __getOwnPropDescs$X = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1i = Object.getOwnPropertySymbols;
var __hasOwnProp$1i = Object.prototype.hasOwnProperty;
var __propIsEnum$1i = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1n = (obj, key, value) => key in obj ? __defProp$1n(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1h = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1i.call(b, prop))
      __defNormalProp$1n(a, prop, b[prop]);
  if (__getOwnPropSymbols$1i)
    for (var prop of __getOwnPropSymbols$1i(b)) {
      if (__propIsEnum$1i.call(b, prop))
        __defNormalProp$1n(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$X = (a, b) => __defProps$X(a, __getOwnPropDescs$X(b));
function preparePlotFrame$1(sparkline, config) {
  var _a, _b, _c;
  const length = sparkline.y.values.length;
  const yFieldConfig = __spreadValues$1h(__spreadValues$1h({}, sparkline.y.config), config);
  const xField = (_a = sparkline.x) != null ? _a : {
    name: "",
    values: [...Array(length).keys()],
    type: data.FieldType.number,
    config: {}
  };
  let frame = {
    refId: "sparkline",
    fields: [
      xField,
      __spreadProps$X(__spreadValues$1h({}, sparkline.y), {
        config: yFieldConfig
      })
    ],
    length
  };
  if (!data.isLikelyAscendingVector(xField.values)) {
    frame = data.sortDataFrame(frame, 0);
  }
  return data.applyNullInsertThreshold({
    frame,
    refFieldPseudoMin: (_b = sparkline.timeRange) == null ? void 0 : _b.from.valueOf(),
    refFieldPseudoMax: (_c = sparkline.timeRange) == null ? void 0 : _c.to.valueOf()
  });
}

var __defProp$1m = Object.defineProperty;
var __defProps$W = Object.defineProperties;
var __getOwnPropDescs$W = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1h = Object.getOwnPropertySymbols;
var __hasOwnProp$1h = Object.prototype.hasOwnProperty;
var __propIsEnum$1h = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1m = (obj, key, value) => key in obj ? __defProp$1m(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1g = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1h.call(b, prop))
      __defNormalProp$1m(a, prop, b[prop]);
  if (__getOwnPropSymbols$1h)
    for (var prop of __getOwnPropSymbols$1h(b)) {
      if (__propIsEnum$1h.call(b, prop))
        __defNormalProp$1m(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$W = (a, b) => __defProps$W(a, __getOwnPropDescs$W(b));
const defaultConfig$1 = {
  drawStyle: schema.GraphDrawStyle.Line,
  showPoints: schema.VisibilityMode.Auto,
  axisPlacement: schema.AxisPlacement.Hidden,
  pointSize: 2
};
class Sparkline extends React.PureComponent {
  constructor(props) {
    super(props);
    const alignedDataFrame = preparePlotFrame$1(props.sparkline, props.config);
    this.state = {
      data: preparePlotData2(alignedDataFrame, getStackingGroups(alignedDataFrame)),
      alignedDataFrame,
      configBuilder: this.prepareConfig(alignedDataFrame)
    };
  }
  static getDerivedStateFromProps(props, state) {
    const _frame = preparePlotFrame$1(props.sparkline, props.config);
    const frame = data.nullToValue(_frame);
    if (!frame) {
      return __spreadValues$1g({}, state);
    }
    return __spreadProps$W(__spreadValues$1g({}, state), {
      data: preparePlotData2(frame, getStackingGroups(frame)),
      alignedDataFrame: frame
    });
  }
  componentDidUpdate(prevProps, prevState) {
    const { alignedDataFrame } = this.state;
    if (!alignedDataFrame) {
      return;
    }
    let rebuildConfig = false;
    if (prevProps.sparkline !== this.props.sparkline) {
      rebuildConfig = !data.compareDataFrameStructures(this.state.alignedDataFrame, prevState.alignedDataFrame);
    } else {
      rebuildConfig = !lodash.isEqual(prevProps.config, this.props.config);
    }
    if (rebuildConfig) {
      this.setState({ configBuilder: this.prepareConfig(alignedDataFrame) });
    }
  }
  getYRange(field) {
    var _a, _b, _c, _d;
    let { min, max } = (_a = this.state.alignedDataFrame.fields[1].state) == null ? void 0 : _a.range;
    const noValue = +((_b = this.state.alignedDataFrame.fields[1].config) == null ? void 0 : _b.noValue);
    if (!Number.isNaN(noValue)) {
      min = Math.min(min, +noValue);
      max = Math.max(max, +noValue);
    }
    if (min === max) {
      if (min === 0) {
        max = 100;
      } else {
        min = 0;
        max *= 2;
      }
      return [min, max];
    }
    return [Math.max(min, (_c = field.config.min) != null ? _c : -Infinity), Math.min(max, (_d = field.config.max) != null ? _d : Infinity)];
  }
  prepareConfig(data$1) {
    var _a;
    const { theme } = this.props;
    const builder = new UPlotConfigBuilder();
    builder.setCursor({
      show: false,
      x: false,
      // no crosshairs
      y: false
    });
    const xField = data$1.fields[0];
    builder.addScale({
      scaleKey: "x",
      orientation: schema.ScaleOrientation.Horizontal,
      direction: schema.ScaleDirection.Right,
      isTime: false,
      //xField.type === FieldType.time,
      range: () => {
        const { sparkline } = this.props;
        if (sparkline.x) {
          if (sparkline.timeRange && sparkline.x.type === data.FieldType.time) {
            return [sparkline.timeRange.from.valueOf(), sparkline.timeRange.to.valueOf()];
          }
          const vals = sparkline.x.values;
          return [vals[0], vals[vals.length - 1]];
        }
        return [0, sparkline.y.values.length - 1];
      }
    });
    builder.addAxis({
      scaleKey: "x",
      theme,
      placement: schema.AxisPlacement.Hidden
    });
    for (let i = 0; i < data$1.fields.length; i++) {
      const field = data$1.fields[i];
      const config = field.config;
      const customConfig = __spreadValues$1g(__spreadValues$1g({}, defaultConfig$1), config.custom);
      if (field === xField || field.type !== data.FieldType.number) {
        continue;
      }
      const scaleKey = config.unit || "__fixed";
      builder.addScale({
        scaleKey,
        orientation: schema.ScaleOrientation.Vertical,
        direction: schema.ScaleDirection.Up,
        range: () => this.getYRange(field)
      });
      builder.addAxis({
        scaleKey,
        theme,
        placement: schema.AxisPlacement.Hidden
      });
      const colorMode = data.getFieldColorModeForField(field);
      const seriesColor = colorMode.getCalculator(field, theme)(0, 0);
      const pointsMode = customConfig.drawStyle === schema.GraphDrawStyle.Points ? schema.VisibilityMode.Always : customConfig.showPoints;
      builder.addSeries({
        pxAlign: false,
        scaleKey,
        theme,
        colorMode,
        thresholds: config.thresholds,
        drawStyle: customConfig.drawStyle,
        lineColor: (_a = customConfig.lineColor) != null ? _a : seriesColor,
        lineWidth: customConfig.lineWidth,
        lineInterpolation: customConfig.lineInterpolation,
        showPoints: pointsMode,
        pointSize: customConfig.pointSize,
        fillOpacity: customConfig.fillOpacity,
        fillColor: customConfig.fillColor,
        lineStyle: customConfig.lineStyle,
        gradientMode: customConfig.gradientMode
      });
    }
    return builder;
  }
  render() {
    const { data, configBuilder } = this.state;
    const { width, height } = this.props;
    return /* @__PURE__ */ React__default["default"].createElement(UPlotChart, { data, config: configBuilder, width, height });
  }
}

var __defProp$1l = Object.defineProperty;
var __defProps$V = Object.defineProperties;
var __getOwnPropDescs$V = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1g = Object.getOwnPropertySymbols;
var __hasOwnProp$1g = Object.prototype.hasOwnProperty;
var __propIsEnum$1g = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1l = (obj, key, value) => key in obj ? __defProp$1l(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1f = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1g.call(b, prop))
      __defNormalProp$1l(a, prop, b[prop]);
  if (__getOwnPropSymbols$1g)
    for (var prop of __getOwnPropSymbols$1g(b)) {
      if (__propIsEnum$1g.call(b, prop))
        __defNormalProp$1l(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$V = (a, b) => __defProps$V(a, __getOwnPropDescs$V(b));
const defaultSparklineCellConfig = {
  type: schema.TableCellDisplayMode.Sparkline,
  drawStyle: schema.GraphDrawStyle.Line,
  lineInterpolation: schema.LineInterpolation.Smooth,
  lineWidth: 1,
  fillOpacity: 17,
  gradientMode: schema.GraphGradientMode.Hue,
  pointSize: 2,
  barAlignment: schema.BarAlignment.Center,
  showPoints: schema.VisibilityMode.Never,
  hideValue: false
};
const SparklineCell = (props) => {
  var _a, _b, _c, _d;
  const { field, innerWidth, tableStyles, cell, cellProps, timeRange } = props;
  const sparkline = getSparkline(cell.value);
  const theme = useTheme2();
  if (!sparkline) {
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$V(__spreadValues$1f({}, cellProps), { className: tableStyles.cellContainer }), field.config.noValue || "no data");
  }
  if (sparkline.x && !sparkline.x.config.interval && sparkline.x.values.length > 1) {
    sparkline.x.config.interval = sparkline.x.values[1] - sparkline.x.values[0];
  }
  sparkline.y.values = sparkline.y.values.map((v) => {
    if (!Number.isFinite(v)) {
      return null;
    } else {
      return v;
    }
  });
  const range = data.getMinMaxAndDelta(sparkline.y);
  sparkline.y.config.min = range.min;
  sparkline.y.config.max = range.max;
  sparkline.y.state = { range };
  sparkline.timeRange = timeRange;
  const cellOptions = getTableSparklineCellOptions(field);
  const config = {
    color: field.config.color,
    custom: __spreadValues$1f(__spreadValues$1f({}, defaultSparklineCellConfig), cellOptions)
  };
  const hideValue = (_b = (_a = field.config.custom) == null ? void 0 : _a.cellOptions) == null ? void 0 : _b.hideValue;
  let valueWidth = 0;
  let valueElement = null;
  if (!hideValue) {
    const value = data.isDataFrameWithValue(cell.value) ? cell.value.value : null;
    const displayValue = field.display(value);
    const alignmentFactor = getAlignmentFactor(field, displayValue, cell.row.index);
    valueWidth = measureText(`${(_c = alignmentFactor.prefix) != null ? _c : ""}${alignmentFactor.text}${(_d = alignmentFactor.suffix) != null ? _d : ""}`, 16).width + theme.spacing.gridSize;
    valueElement = /* @__PURE__ */ React__default["default"].createElement(
      FormattedValueDisplay,
      {
        style: {
          width: `${valueWidth - theme.spacing.gridSize}px`,
          textAlign: "right",
          marginRight: theme.spacing(1)
        },
        value: displayValue
      }
    );
  }
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$V(__spreadValues$1f({}, cellProps), { className: tableStyles.cellContainer }), valueElement, /* @__PURE__ */ React__default["default"].createElement("div", null, /* @__PURE__ */ React__default["default"].createElement(
    Sparkline,
    {
      width: innerWidth - valueWidth,
      height: tableStyles.cellHeightInner,
      sparkline,
      config,
      theme: tableStyles.theme
    }
  )));
};
function getSparkline(value) {
  if (Array.isArray(value)) {
    return {
      y: {
        name: "test",
        type: data.FieldType.number,
        values: value,
        config: {}
      }
    };
  }
  if (data.isDataFrame(value)) {
    const timeField = value.fields.find((x) => x.type === data.FieldType.time);
    const numberField = value.fields.find((x) => x.type === data.FieldType.number);
    if (timeField && numberField) {
      return { x: timeField, y: numberField };
    }
  }
  return;
}
function getTableSparklineCellOptions(field) {
  let options = getCellOptions(field);
  if (options.type === schema.TableCellDisplayMode.Auto) {
    options = __spreadProps$V(__spreadValues$1f({}, options), { type: schema.TableCellDisplayMode.Sparkline });
  }
  if (options.type === schema.TableCellDisplayMode.Sparkline) {
    return options;
  }
  throw new Error(`Expected options type ${schema.TableCellDisplayMode.Sparkline} but got ${options.type}`);
}

var __defProp$1k = Object.defineProperty;
var __getOwnPropSymbols$1f = Object.getOwnPropertySymbols;
var __hasOwnProp$1f = Object.prototype.hasOwnProperty;
var __propIsEnum$1f = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1k = (obj, key, value) => key in obj ? __defProp$1k(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1e = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1f.call(b, prop))
      __defNormalProp$1k(a, prop, b[prop]);
  if (__getOwnPropSymbols$1f)
    for (var prop of __getOwnPropSymbols$1f(b)) {
      if (__propIsEnum$1f.call(b, prop))
        __defNormalProp$1k(a, prop, b[prop]);
    }
  return a;
};
const EXPANDER_WIDTH = 50;
function getTextAlign(field) {
  if (!field) {
    return "flex-start";
  }
  if (field.config.custom) {
    const custom = field.config.custom;
    switch (custom.align) {
      case "right":
        return "flex-end";
      case "left":
        return "flex-start";
      case "center":
        return "center";
    }
  }
  if (field.type === data.FieldType.number) {
    return "flex-end";
  }
  return "flex-start";
}
function getColumns(data$1, availableWidth, columnMinWidth, expander, footerValues, isCountRowsSet) {
  var _a, _b;
  const columns = [];
  let fieldCountWithoutWidth = 0;
  if (expander) {
    columns.push({
      // Make an expander cell
      Header: () => null,
      // No header
      id: "expander",
      // It needs an ID
      // @ts-expect-error
      // TODO fix type error here
      Cell: RowExpander,
      width: EXPANDER_WIDTH,
      minWidth: EXPANDER_WIDTH,
      filter: (_rows, _id, _filterValues) => {
        return [];
      },
      justifyContent: "left",
      field: data$1.fields[0],
      sortType: "basic"
    });
    availableWidth -= EXPANDER_WIDTH;
  }
  for (const [fieldIndex, field] of data$1.fields.entries()) {
    const fieldTableOptions = field.config.custom || {};
    if (fieldTableOptions.hidden || field.type === data.FieldType.nestedFrames) {
      continue;
    }
    if (fieldTableOptions.width) {
      availableWidth -= fieldTableOptions.width;
    } else {
      fieldCountWithoutWidth++;
    }
    const selectSortType = (type) => {
      switch (type) {
        case data.FieldType.number:
        case data.FieldType.frame:
          return "number";
        case data.FieldType.time:
          return "basic";
        default:
          return "alphanumeric-insensitive";
      }
    };
    const Cell = getCellComponent((_a = fieldTableOptions.cellOptions) == null ? void 0 : _a.type, field);
    columns.push({
      // @ts-expect-error
      // TODO fix type error here
      Cell,
      id: fieldIndex.toString(),
      field,
      Header: fieldTableOptions.hideHeader ? "" : data.getFieldDisplayName(field, data$1),
      accessor: (_row, i) => field.values[i],
      sortType: selectSortType(field.type),
      width: fieldTableOptions.width,
      minWidth: (_b = fieldTableOptions.minWidth) != null ? _b : columnMinWidth,
      filter: memoize__default["default"](filterByValue(field)),
      justifyContent: getTextAlign(field),
      Footer: getFooterValue(fieldIndex, footerValues, isCountRowsSet)
    });
  }
  let sharedWidth = availableWidth / fieldCountWithoutWidth;
  for (let i = fieldCountWithoutWidth; i > 0; i--) {
    for (const column of columns) {
      if (!column.width && column.minWidth > sharedWidth) {
        column.width = column.minWidth;
        availableWidth -= column.width;
        fieldCountWithoutWidth -= 1;
        sharedWidth = availableWidth / fieldCountWithoutWidth;
      }
    }
  }
  for (const column of columns) {
    if (!column.width) {
      column.width = sharedWidth;
    }
    column.minWidth = 50;
  }
  return columns;
}
function getCellComponent(displayMode, field) {
  switch (displayMode) {
    case schema.TableCellDisplayMode.Custom:
    case schema.TableCellDisplayMode.ColorText:
    case schema.TableCellDisplayMode.ColorBackground:
      return DefaultCell;
    case schema.TableCellDisplayMode.Image:
      return ImageCell;
    case schema.TableCellDisplayMode.Gauge:
      return BarGaugeCell;
    case schema.TableCellDisplayMode.Sparkline:
      return SparklineCell;
    case schema.TableCellDisplayMode.JSONView:
      return JSONViewCell;
    case schema.TableCellDisplayMode.DataLinks:
      return DataLinksCell;
  }
  if (field.type === data.FieldType.geo) {
    return GeoCell;
  }
  if (field.type === data.FieldType.frame) {
    const firstValue = field.values[0];
    if (data.isDataFrame(firstValue) && data.isTimeSeriesFrame(firstValue)) {
      return SparklineCell;
    }
    return JSONViewCell;
  }
  if (field.type === data.FieldType.other) {
    return JSONViewCell;
  }
  return DefaultCell;
}
function filterByValue(field) {
  return function(rows, id, filterValues) {
    if (rows.length === 0) {
      return rows;
    }
    if (!filterValues) {
      return rows;
    }
    if (!field) {
      return rows;
    }
    return rows.filter((row) => {
      if (!row.values.hasOwnProperty(id)) {
        return false;
      }
      const value = rowToFieldValue(row, field);
      return filterValues.find((filter) => filter.value === value) !== void 0;
    });
  };
}
function calculateUniqueFieldValues(rows, field) {
  if (!field || rows.length === 0) {
    return {};
  }
  const set = {};
  for (let index = 0; index < rows.length; index++) {
    const value = rowToFieldValue(rows[index], field);
    set[value || "(Blanks)"] = value;
  }
  return set;
}
function rowToFieldValue(row, field) {
  if (!field || !row) {
    return "";
  }
  const fieldValue = field.values[row.index];
  const displayValue = field.display ? field.display(fieldValue) : fieldValue;
  const value = field.display ? data.formattedValueToString(displayValue) : displayValue;
  return value;
}
function valuesToOptions(unique) {
  return Object.keys(unique).reduce((all, key) => all.concat({ value: unique[key], label: key }), []).sort(sortOptions);
}
function sortOptions(a, b) {
  if (a.label === void 0 && b.label === void 0) {
    return 0;
  }
  if (a.label === void 0 && b.label !== void 0) {
    return -1;
  }
  if (a.label !== void 0 && b.label === void 0) {
    return 1;
  }
  if (a.label < b.label) {
    return -1;
  }
  if (a.label > b.label) {
    return 1;
  }
  return 0;
}
function getFilteredOptions(options, filterValues) {
  if (!filterValues) {
    return [];
  }
  return options.filter((option) => filterValues.some((filtered) => filtered.value === option.value));
}
function sortCaseInsensitive(a, b, id) {
  return String(a.values[id]).localeCompare(String(b.values[id]), void 0, { sensitivity: "base" });
}
function sortNumber(rowA, rowB, id) {
  const a = toNumber(rowA.values[id]);
  const b = toNumber(rowB.values[id]);
  return a === b ? 0 : a > b ? 1 : -1;
}
function toNumber(value) {
  var _a;
  if (data.isDataFrameWithValue(value)) {
    return (_a = value.value) != null ? _a : Number.NEGATIVE_INFINITY;
  }
  if (value === null || value === void 0 || value === "" || isNaN(value)) {
    return Number.NEGATIVE_INFINITY;
  }
  if (typeof value === "number") {
    return value;
  }
  return Number(value);
}
function getFooterItems(filterFields, values, options, theme2) {
  addMissingColumnIndex(filterFields);
  return filterFields.map((data$1, i) => {
    var _a;
    if (((_a = data$1 == null ? void 0 : data$1.field) == null ? void 0 : _a.type) !== data.FieldType.number) {
      if (i === 0 && options.reducer && options.reducer.length > 0) {
        const reducer = data.fieldReducers.get(options.reducer[0]);
        return reducer.name;
      }
      return void 0;
    }
    let newField = lodash.clone(data$1.field);
    newField.values = values[data$1.id];
    newField.state = void 0;
    data$1.field = newField;
    if (options.fields && options.fields.length > 0) {
      const f = options.fields.find((f2) => {
        var _a2;
        return f2 === ((_a2 = data$1 == null ? void 0 : data$1.field) == null ? void 0 : _a2.name);
      });
      if (f) {
        return getFormattedValue(data$1.field, options.reducer, theme2);
      }
      return void 0;
    }
    return getFormattedValue(data$1.field, options.reducer || [], theme2);
  });
}
function getFormattedValue(field, reducer, theme) {
  var _a;
  const fmt = (_a = field.display) != null ? _a : data.getDisplayProcessor({ field, theme });
  const calc = reducer[0];
  const v = data.reduceField({ field, reducers: reducer })[calc];
  return data.formattedValueToString(fmt(v));
}
function createFooterCalculationValues(rows) {
  const values = [];
  for (const key in rows) {
    for (const [valKey, val] of Object.entries(rows[key].values)) {
      if (values[valKey] === void 0) {
        values[valKey] = [];
      }
      values[valKey].push(val);
    }
  }
  return values;
}
const defaultCellOptions = { type: schema.TableCellDisplayMode.Auto };
function getCellOptions(field) {
  var _a, _b, _c;
  if ((_a = field.config.custom) == null ? void 0 : _a.displayMode) {
    return migrateTableDisplayModeToCellOptions((_b = field.config.custom) == null ? void 0 : _b.displayMode);
  }
  if (!((_c = field.config.custom) == null ? void 0 : _c.cellOptions)) {
    return defaultCellOptions;
  }
  return field.config.custom.cellOptions;
}
function migrateTableDisplayModeToCellOptions(displayMode) {
  switch (displayMode) {
    case "basic":
    case "gradient-gauge":
    case "lcd-gauge":
      let gaugeMode = schema.BarGaugeDisplayMode.Basic;
      if (displayMode === "gradient-gauge") {
        gaugeMode = schema.BarGaugeDisplayMode.Gradient;
      } else if (displayMode === "lcd-gauge") {
        gaugeMode = schema.BarGaugeDisplayMode.Lcd;
      }
      return {
        type: schema.TableCellDisplayMode.Gauge,
        mode: gaugeMode
      };
    case "color-background":
    case "color-background-solid":
      let mode = schema.TableCellBackgroundDisplayMode.Basic;
      if (displayMode === "color-background") {
        mode = schema.TableCellBackgroundDisplayMode.Gradient;
      }
      return {
        type: schema.TableCellDisplayMode.ColorBackground,
        mode
      };
    default:
      return {
        // @ts-ignore
        type: displayMode
      };
  }
}
function addMissingColumnIndex(columns) {
  var _a;
  const missingIndex = columns.findIndex((field, index) => (field == null ? void 0 : field.id) !== String(index));
  if (missingIndex === -1 || ((_a = columns[missingIndex]) == null ? void 0 : _a.id) === "expander") {
    return;
  }
  columns.splice(missingIndex, 0, { id: String(missingIndex) });
  addMissingColumnIndex(columns);
}
function getAlignmentFactor(field, displayValue, rowIndex) {
  var _a;
  let alignmentFactor = (_a = field.state) == null ? void 0 : _a.alignmentFactors;
  if (alignmentFactor) {
    if (alignmentFactor.text.length < displayValue.text.length) {
      alignmentFactor.text = displayValue.text;
    }
    return alignmentFactor;
  } else {
    alignmentFactor = __spreadValues$1e({}, displayValue);
    const maxIndex = Math.min(field.values.length, rowIndex + 1e3);
    for (let i = rowIndex + 1; i < maxIndex; i++) {
      const nextDisplayValue = field.display(field.values[i]);
      if (nextDisplayValue.text.length > alignmentFactor.text.length) {
        alignmentFactor.text = displayValue.text;
      }
    }
    if (field.state) {
      field.state.alignmentFactors = alignmentFactor;
    } else {
      field.state = { alignmentFactors: alignmentFactor };
    }
    return alignmentFactor;
  }
}
function isPointTimeValAroundTableTimeVal(pointTime, rowTime, threshold) {
  return Math.abs(Math.floor(pointTime) - rowTime) < threshold;
}
function calculateAroundPointThreshold(timeField) {
  let max = -Number.MAX_VALUE;
  let min = Number.MAX_VALUE;
  if (timeField.values.length < 2) {
    return 0;
  }
  for (let i = 0; i < timeField.values.length; i++) {
    const value = timeField.values[i];
    if (value > max) {
      max = value;
    }
    if (value < min) {
      min = value;
    }
  }
  return (max - min) / timeField.values.length;
}

const FilterPopup = ({ column: { preFilteredRows, filterValue, setFilter }, onClose, field }) => {
  const theme = useTheme2();
  const uniqueValues = React.useMemo(() => calculateUniqueFieldValues(preFilteredRows, field), [preFilteredRows, field]);
  const options = React.useMemo(() => valuesToOptions(uniqueValues), [uniqueValues]);
  const filteredOptions = React.useMemo(() => getFilteredOptions(options, filterValue), [options, filterValue]);
  const [values, setValues] = React.useState(filteredOptions);
  const [matchCase, setMatchCase] = React.useState(false);
  const onCancel = React.useCallback((event) => onClose(), [onClose]);
  const onFilter = React.useCallback(
    (event) => {
      const filtered = values.length ? values : void 0;
      setFilter(filtered);
      onClose();
    },
    [setFilter, values, onClose]
  );
  const onClearFilter = React.useCallback(
    (event) => {
      setFilter(void 0);
      onClose();
    },
    [setFilter, onClose]
  );
  const clearFilterVisible = React.useMemo(() => filterValue !== void 0, [filterValue]);
  const styles = useStyles2(getStyles$R);
  return /* @__PURE__ */ React__default["default"].createElement(ClickOutsideWrapper, { onClick: onCancel, useCapture: true }, /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.filterContainer), onClick: stopPropagation }, /* @__PURE__ */ React__default["default"].createElement(VerticalGroup, { spacing: "lg" }, /* @__PURE__ */ React__default["default"].createElement(VerticalGroup, { spacing: "xs" }, /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, { justify: "space-between", align: "center" }, /* @__PURE__ */ React__default["default"].createElement(Label$1, { className: styles.label }, "Filter by values:"), /* @__PURE__ */ React__default["default"].createElement(
    IconButton,
    {
      name: "text-fields",
      tooltip: "Match case",
      style: { color: matchCase ? theme.colors.text.link : theme.colors.text.disabled },
      onClick: () => {
        setMatchCase((s) => !s);
      }
    }
  )), /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.listDivider) }), /* @__PURE__ */ React__default["default"].createElement(
    FilterList,
    {
      onChange: setValues,
      values,
      options,
      caseSensitive: matchCase,
      showOperators: true
    }
  )), /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, { spacing: "lg" }, /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, null, /* @__PURE__ */ React__default["default"].createElement(Button, { size: "sm", onClick: onFilter }, "Ok"), /* @__PURE__ */ React__default["default"].createElement(Button, { size: "sm", variant: "secondary", onClick: onCancel }, "Cancel")), clearFilterVisible && /* @__PURE__ */ React__default["default"].createElement(HorizontalGroup, null, /* @__PURE__ */ React__default["default"].createElement(Button, { fill: "text", size: "sm", onClick: onClearFilter }, "Clear filter"))))));
};
const getStyles$R = (theme) => ({
  filterContainer: css.css({
    label: "filterContainer",
    width: "100%",
    minWidth: "250px",
    height: "100%",
    maxHeight: "400px",
    backgroundColor: theme.colors.background.primary,
    border: `1px solid ${theme.colors.border.weak}`,
    padding: theme.spacing(2),
    margin: theme.spacing(1, 0),
    boxShadow: theme.shadows.z3,
    borderRadius: theme.shape.radius.default
  }),
  listDivider: css.css({
    label: "listDivider",
    width: "100%",
    borderTop: `1px solid ${theme.colors.border.medium}`,
    padding: theme.spacing(0.5, 2)
  }),
  label: css.css({
    marginBottom: 0
  })
});
const stopPropagation = (event) => {
  event.stopPropagation();
};

const Filter = ({ column, field, tableStyles }) => {
  var _a;
  const ref = React.useRef(null);
  const [isPopoverVisible, setPopoverVisible] = React.useState(false);
  const styles = useStyles2(getStyles$Q);
  const filterEnabled = React.useMemo(() => Boolean(column.filterValue), [column.filterValue]);
  const onShowPopover = React.useCallback(() => setPopoverVisible(true), [setPopoverVisible]);
  const onClosePopover = React.useCallback(() => setPopoverVisible(false), [setPopoverVisible]);
  if (!field || !((_a = field.config.custom) == null ? void 0 : _a.filterable)) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement(
    "button",
    {
      className: css.cx(tableStyles.headerFilter, filterEnabled ? styles.filterIconEnabled : styles.filterIconDisabled),
      ref,
      type: "button",
      onClick: onShowPopover
    },
    /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "filter" }),
    isPopoverVisible && ref.current && /* @__PURE__ */ React__default["default"].createElement(
      Popover,
      {
        content: /* @__PURE__ */ React__default["default"].createElement(FilterPopup, { column, tableStyles, field, onClose: onClosePopover }),
        placement: "bottom-start",
        referenceElement: ref.current,
        show: true
      }
    )
  );
};
const getStyles$Q = (theme) => ({
  filterIconEnabled: css.css({
    label: "filterIconEnabled",
    color: theme.colors.primary.text
  }),
  filterIconDisabled: css.css({
    label: "filterIconDisabled",
    color: theme.colors.text.disabled
  })
});

var __defProp$1j = Object.defineProperty;
var __defProps$U = Object.defineProperties;
var __getOwnPropDescs$U = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1e = Object.getOwnPropertySymbols;
var __hasOwnProp$1e = Object.prototype.hasOwnProperty;
var __propIsEnum$1e = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1j = (obj, key, value) => key in obj ? __defProp$1j(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1d = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1e.call(b, prop))
      __defNormalProp$1j(a, prop, b[prop]);
  if (__getOwnPropSymbols$1e)
    for (var prop of __getOwnPropSymbols$1e(b)) {
      if (__propIsEnum$1e.call(b, prop))
        __defNormalProp$1j(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$U = (a, b) => __defProps$U(a, __getOwnPropDescs$U(b));
var __objRest$F = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1e.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1e)
    for (var prop of __getOwnPropSymbols$1e(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1e.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const HeaderRow = (props) => {
  const { headerGroups, showTypeIcons, tableStyles } = props;
  const e2eSelectorsTable = e2eSelectors.selectors.components.Panels.Visualization.Table;
  return /* @__PURE__ */ React__default["default"].createElement("div", { role: "rowgroup", className: tableStyles.headerRow }, headerGroups.map((headerGroup) => {
    const _a = headerGroup.getHeaderGroupProps(), { key } = _a, headerGroupProps = __objRest$F(_a, ["key"]);
    return /* @__PURE__ */ React__default["default"].createElement(
      "div",
      __spreadProps$U(__spreadValues$1d({
        className: tableStyles.thead
      }, headerGroupProps), {
        key,
        "aria-label": e2eSelectorsTable.header,
        role: "row"
      }),
      headerGroup.headers.map(
        (column, index) => renderHeaderCell(column, tableStyles, showTypeIcons)
      )
    );
  }));
};
function renderHeaderCell(column, tableStyles, showTypeIcons) {
  var _a;
  const headerProps = column.getHeaderProps();
  const field = (_a = column.field) != null ? _a : null;
  if (column.canResize) {
    headerProps.style.userSelect = column.isResizing ? "none" : "auto";
  }
  headerProps.style.position = "absolute";
  headerProps.style.justifyContent = column.justifyContent;
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$U(__spreadValues$1d({ className: tableStyles.headerCell }, headerProps), { role: "columnheader" }), column.canSort && /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("button", __spreadProps$U(__spreadValues$1d({}, column.getSortByToggleProps()), { className: tableStyles.headerCellLabel }), showTypeIcons && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: getFieldTypeIcon(field), title: field == null ? void 0 : field.type, size: "sm", className: tableStyles.typeIcon }), /* @__PURE__ */ React__default["default"].createElement("div", null, column.render("Header")), column.isSorted && (column.isSortedDesc ? /* @__PURE__ */ React__default["default"].createElement(Icon, { size: "lg", name: "arrow-down", className: tableStyles.sortIcon }) : /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "arrow-up", size: "lg", className: tableStyles.sortIcon }))), column.canFilter && /* @__PURE__ */ React__default["default"].createElement(Filter, { column, tableStyles, field })), !column.canSort && column.render("Header"), !column.canSort && column.canFilter && /* @__PURE__ */ React__default["default"].createElement(Filter, { column, tableStyles, field }), column.canResize && /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$U(__spreadValues$1d({}, column.getResizerProps()), { className: tableStyles.resizeHandle })));
}

const LoadingIndicator = ({ onCancel, loading }) => {
  const styles = useStyles2(getStyles$P);
  if (!loading) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement(Tooltip, { content: "Cancel query" }, /* @__PURE__ */ React__default["default"].createElement(
    Icon,
    {
      className: css.cx("spin-clockwise", { [styles.clickable]: !!onCancel }),
      name: "sync",
      size: "sm",
      onClick: onCancel,
      "data-testid": e2eSelectors.selectors.components.LoadingIndicator.icon
    }
  ));
};
const getStyles$P = () => {
  return {
    clickable: css.css({
      cursor: "pointer"
    })
  };
};

function DelayRender({ children, delay }) {
  const [shouldRender, setShouldRender] = React.useState(false);
  React.useEffect(() => {
    window.setTimeout(() => {
      setShouldRender(true);
    }, delay);
  }, [children, delay]);
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, shouldRender ? children : null);
}

var __defProp$1i = Object.defineProperty;
var __getOwnPropSymbols$1d = Object.getOwnPropertySymbols;
var __hasOwnProp$1d = Object.prototype.hasOwnProperty;
var __propIsEnum$1d = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1i = (obj, key, value) => key in obj ? __defProp$1i(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1c = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1d.call(b, prop))
      __defNormalProp$1i(a, prop, b[prop]);
  if (__getOwnPropSymbols$1d)
    for (var prop of __getOwnPropSymbols$1d(b)) {
      if (__propIsEnum$1d.call(b, prop))
        __defNormalProp$1i(a, prop, b[prop]);
    }
  return a;
};
const Dropdown = React__default["default"].memo(({ children, overlay, placement, offset, onVisibleChange }) => {
  var _a, _b;
  const [show, setShow] = React.useState(false);
  const transitionRef = React.useRef(null);
  React.useEffect(() => {
    onVisibleChange == null ? void 0 : onVisibleChange(show);
  }, [onVisibleChange, show]);
  const middleware = [
    react$1.offset({
      mainAxis: (_a = offset == null ? void 0 : offset[0]) != null ? _a : 8,
      crossAxis: (_b = offset == null ? void 0 : offset[1]) != null ? _b : 0
    }),
    react$1.flip({
      fallbackAxisSideDirection: "end",
      // see https://floating-ui.com/docs/flip#combining-with-shift
      crossAxis: false,
      boundary: document.body
    }),
    react$1.shift()
  ];
  const { context, refs, floatingStyles } = react$1.useFloating({
    open: show,
    placement: getPlacement(placement),
    onOpenChange: setShow,
    middleware,
    whileElementsMounted: react$1.autoUpdate
  });
  const click = react$1.useClick(context);
  const dismiss = react$1.useDismiss(context);
  const { getReferenceProps, getFloatingProps } = react$1.useInteractions([dismiss, click]);
  const animationDuration = 150;
  const animationStyles = getStyles$O(animationDuration);
  const onOverlayClicked = () => {
    setShow(false);
  };
  const handleKeys = (event) => {
    if (event.key === "Tab") {
      setShow(false);
    }
  };
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, React__default["default"].cloneElement(children, __spreadValues$1c({
    ref: refs.setReference
  }, getReferenceProps())), show && /* @__PURE__ */ React__default["default"].createElement(Portal$1, null, /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { autoFocus: true, restoreFocus: true, contain: true }, /* @__PURE__ */ React__default["default"].createElement("div", { ref: refs.setFloating, style: floatingStyles, onClick: onOverlayClicked, onKeyDown: handleKeys }, /* @__PURE__ */ React__default["default"].createElement(
    reactTransitionGroup.CSSTransition,
    {
      nodeRef: transitionRef,
      appear: true,
      in: true,
      timeout: { appear: animationDuration, exit: 0, enter: 0 },
      classNames: animationStyles
    },
    /* @__PURE__ */ React__default["default"].createElement("div", { ref: transitionRef }, renderOrCallToRender(overlay, __spreadValues$1c({}, getFloatingProps())))
  )))));
});
Dropdown.displayName = "Dropdown";
const getStyles$O = (duration) => {
  return {
    appear: css.css({
      opacity: "0",
      position: "relative",
      transform: "scaleY(0.5)",
      transformOrigin: "top"
    }),
    appearActive: css.css({
      opacity: "1",
      transform: "scaleY(1)",
      transition: `transform ${duration}ms cubic-bezier(0.2, 0, 0.2, 1), opacity ${duration}ms cubic-bezier(0.2, 0, 0.2, 1)`
    })
  };
};

function PanelMenu({
  menu,
  title,
  placement = "bottom",
  offset,
  dragClassCancel,
  menuButtonClass,
  onOpenMenu
}) {
  const testId = title ? e2eSelectors.selectors.components.Panels.Panel.menu(title) : `panel-menu-button`;
  const handleVisibility = React.useCallback(
    (show) => {
      if (show && onOpenMenu) {
        onOpenMenu();
      }
    },
    [onOpenMenu]
  );
  return /* @__PURE__ */ React__default["default"].createElement(Dropdown, { overlay: menu, placement, offset, onVisibleChange: handleVisibility }, /* @__PURE__ */ React__default["default"].createElement(
    ToolbarButton,
    {
      "aria-label": `Menu for panel with ${title ? `title ${title}` : "no title"}`,
      title: "Menu",
      icon: "ellipsis-v",
      iconSize: "md",
      narrow: true,
      "data-testid": testId,
      className: css.cx(menuButtonClass, dragClassCancel)
    }
  ));
}

function HoverWidget({ menu, title, dragClass, children, offset = -32, onOpenMenu }) {
  const styles = useStyles2(getStyles$N);
  const draggableRef = React.useRef(null);
  const selectors = e2eSelectors.selectors.components.Panels.Panel.HoverWidget;
  const onPointerDown = React.useCallback((e) => {
    var _a;
    (_a = draggableRef.current) == null ? void 0 : _a.setPointerCapture(e.pointerId);
  }, []);
  const onPointerUp = React.useCallback((e) => {
    var _a;
    (_a = draggableRef.current) == null ? void 0 : _a.releasePointerCapture(e.pointerId);
  }, []);
  if (children === void 0 || React__default["default"].Children.count(children) === 0) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.container, "show-on-hover"), style: { top: offset }, "data-testid": selectors.container }, dragClass && /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      className: css.cx(styles.square, styles.draggable, dragClass),
      onPointerDown,
      onPointerUp,
      ref: draggableRef,
      "data-testid": selectors.dragIcon
    },
    /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "expand-arrows", className: styles.draggableIcon })
  ), children, menu && /* @__PURE__ */ React__default["default"].createElement(
    PanelMenu,
    {
      menu,
      title,
      placement: "bottom",
      menuButtonClass: styles.menuButton,
      onOpenMenu
    }
  ));
}
function getStyles$N(theme) {
  return {
    container: css.css({
      label: "hover-container-widget",
      transition: `all .1s linear`,
      display: "flex",
      position: "absolute",
      zIndex: 1,
      right: 0,
      boxSizing: "content-box",
      alignItems: "center",
      background: theme.colors.background.secondary,
      color: theme.colors.text.primary,
      border: `1px solid ${theme.colors.border.weak}`,
      borderRadius: theme.shape.radius.default,
      height: theme.spacing(4),
      boxShadow: theme.shadows.z1
    }),
    square: css.css({
      display: "flex",
      justifyContent: "center",
      alignItems: "center",
      width: theme.spacing(4),
      height: "100%"
    }),
    draggable: css.css({
      cursor: "move",
      // mobile do not support draggable panels
      [theme.breakpoints.down("md")]: {
        display: "none"
      }
    }),
    menuButton: css.css({
      // Background and border are overriden when topnav toggle is disabled
      background: "inherit",
      border: "none",
      "&:hover": {
        background: theme.colors.secondary.main
      }
    }),
    draggableIcon: css.css({
      transform: "rotate(45deg)",
      color: theme.colors.text.secondary,
      "&:hover": {
        color: theme.colors.text.primary
      }
    })
  };
}

var __defProp$1h = Object.defineProperty;
var __defProps$T = Object.defineProperties;
var __getOwnPropDescs$T = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1c = Object.getOwnPropertySymbols;
var __hasOwnProp$1c = Object.prototype.hasOwnProperty;
var __propIsEnum$1c = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1h = (obj, key, value) => key in obj ? __defProp$1h(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1b = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1c.call(b, prop))
      __defNormalProp$1h(a, prop, b[prop]);
  if (__getOwnPropSymbols$1c)
    for (var prop of __getOwnPropSymbols$1c(b)) {
      if (__propIsEnum$1c.call(b, prop))
        __defNormalProp$1h(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$T = (a, b) => __defProps$T(a, __getOwnPropDescs$T(b));
var __objRest$E = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$1c.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$1c)
    for (var prop of __getOwnPropSymbols$1c(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$1c.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const TitleItem = React.forwardRef(
  (_a, ref) => {
    var _b = _a, { className, children, href, onClick, target, title } = _b, rest = __objRest$E(_b, ["className", "children", "href", "onClick", "target", "title"]);
    const styles = useStyles2(getStyles$M);
    if (href) {
      return /* @__PURE__ */ React__default["default"].createElement(
        "a",
        __spreadValues$1b({
          ref,
          href,
          onClick,
          target,
          title,
          className: css.cx(styles.linkItem, className)
        }, rest),
        children
      );
    } else if (onClick) {
      return /* @__PURE__ */ React__default["default"].createElement(Button, { ref, className: css.cx(styles.item, className), variant: "secondary", fill: "text", onClick }, children);
    } else {
      return /* @__PURE__ */ React__default["default"].createElement("span", __spreadValues$1b({ ref, className: css.cx(styles.item, className) }, rest), children);
    }
  }
);
TitleItem.displayName = "TitleItem";
const getStyles$M = (theme) => {
  const item = css.css({
    color: `${theme.colors.text.secondary}`,
    label: "panel-header-item",
    cursor: "auto",
    border: "none",
    borderRadius: `${theme.shape.radius.default}`,
    padding: `${theme.spacing(0, 1)}`,
    height: `${theme.spacing(theme.components.panel.headerHeight)}`,
    display: "flex",
    alignItems: "center",
    justifyContent: "center",
    "&:focus, &:focus-visible": __spreadProps$T(__spreadValues$1b({}, getFocusStyles(theme)), {
      zIndex: 1
    }),
    "&: focus:not(:focus-visible)": getMouseFocusStyles(),
    "&:hover ": {
      boxShadow: `${theme.shadows.z1}`,
      background: `${theme.colors.background.secondary}`,
      color: `${theme.colors.text.primary}`
    }
  });
  return {
    item,
    linkItem: css.cx(item, css.css({ cursor: "pointer" }))
  };
};

function PanelDescription({ description, className }) {
  const styles = useStyles2(getStyles$L);
  const getDescriptionContent = () => {
    const panelDescription = typeof description === "function" ? description() : description;
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: "panel-info-content markdown-html" }, /* @__PURE__ */ React__default["default"].createElement("div", { dangerouslySetInnerHTML: { __html: panelDescription } }));
  };
  return description !== "" ? /* @__PURE__ */ React__default["default"].createElement(Tooltip, { interactive: true, content: getDescriptionContent }, /* @__PURE__ */ React__default["default"].createElement(TitleItem, { className: css.cx(className, styles.description) }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "info-circle", size: "md" }))) : null;
}
const getStyles$L = (theme) => {
  return {
    description: css.css({
      code: {
        whiteSpace: "normal",
        wordWrap: "break-word"
      },
      "pre > code": {
        display: "block"
      }
    })
  };
};

function PanelStatus({ message, onClick, ariaLabel = "status" }) {
  const styles = useStyles2(getStyles$K);
  return /* @__PURE__ */ React__default["default"].createElement(
    ToolbarButton,
    {
      className: styles.buttonStyles,
      onClick,
      variant: "destructive",
      icon: "exclamation-triangle",
      iconSize: "md",
      tooltip: message || "",
      "aria-label": ariaLabel,
      "data-testid": e2eSelectors.selectors.components.Panels.Panel.status("error")
    }
  );
}
const getStyles$K = (theme) => {
  const { headerHeight, padding } = theme.components.panel;
  return {
    buttonStyles: css.css({
      label: "panel-header-state-button",
      display: "flex",
      alignItems: "center",
      justifyContent: "center",
      padding: theme.spacing(padding),
      width: theme.spacing(headerHeight),
      height: theme.spacing(headerHeight),
      borderRadius: theme.shape.radius.default
    })
  };
};

function PanelChrome$1({
  width,
  height,
  children,
  padding = "md",
  title = "",
  description = "",
  displayMode = "default",
  titleItems,
  menu,
  dragClass,
  dragClassCancel,
  hoverHeader = false,
  hoverHeaderOffset,
  loadingState,
  statusMessage,
  statusMessageOnClick,
  leftItems,
  actions,
  onCancelQuery,
  onOpenMenu,
  collapsible = false,
  collapsed,
  onToggleCollapse
}) {
  const theme = useTheme2();
  const styles = useStyles2(getStyles$J);
  const panelContentId = React.useId();
  const hasHeader = !hoverHeader;
  const [isOpen, toggleOpen] = reactUse.useToggle(true);
  if (collapsed === void 0) {
    collapsed = !isOpen;
  }
  const showOnHoverClass = "show-on-hover";
  const isPanelTransparent = displayMode === "transparent";
  const headerHeight = getHeaderHeight(theme, hasHeader);
  const { contentStyle, innerWidth, innerHeight } = getContentStyle(
    padding,
    theme,
    headerHeight,
    collapsed,
    height,
    width
  );
  const headerStyles = {
    height: headerHeight,
    cursor: dragClass ? "move" : "auto"
  };
  const containerStyles = { width, height: collapsed ? void 0 : height };
  const [ref, { width: loadingBarWidth }] = reactUse.useMeasure();
  if (leftItems) {
    actions = leftItems;
  }
  const testid = typeof title === "string" ? e2eSelectors.selectors.components.Panels.Panel.title(title) : "Panel";
  const headerContent = /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, !collapsible && title && /* @__PURE__ */ React__default["default"].createElement("h6", { title: typeof title === "string" ? title : void 0, className: styles.title }, title), collapsible && /* @__PURE__ */ React__default["default"].createElement("h6", { className: styles.title }, /* @__PURE__ */ React__default["default"].createElement(
    "button",
    {
      type: "button",
      className: styles.clearButtonStyles,
      onClick: () => {
        toggleOpen();
        if (onToggleCollapse) {
          onToggleCollapse(!collapsed);
        }
      },
      "aria-expanded": !collapsed,
      "aria-controls": !collapsed ? panelContentId : void 0
    },
    /* @__PURE__ */ React__default["default"].createElement(
      Icon,
      {
        name: !collapsed ? "angle-down" : "angle-right",
        "aria-hidden": !!title,
        "aria-label": !title ? "toggle collapse panel" : void 0
      }
    ),
    title
  )), /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.titleItems, dragClassCancel), "data-testid": "title-items-container" }, /* @__PURE__ */ React__default["default"].createElement(PanelDescription, { description, className: dragClassCancel }), titleItems), loadingState === data.LoadingState.Streaming && /* @__PURE__ */ React__default["default"].createElement(Tooltip, { content: onCancelQuery ? "Stop streaming" : "Streaming" }, /* @__PURE__ */ React__default["default"].createElement(TitleItem, { className: dragClassCancel, "data-testid": "panel-streaming", onClick: onCancelQuery }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "circle-mono", size: "md", className: styles.streaming }))), loadingState === data.LoadingState.Loading && onCancelQuery && /* @__PURE__ */ React__default["default"].createElement(DelayRender, { delay: 2e3 }, /* @__PURE__ */ React__default["default"].createElement(Tooltip, { content: "Cancel query" }, /* @__PURE__ */ React__default["default"].createElement(
    TitleItem,
    {
      className: css.cx(dragClassCancel, styles.pointer),
      "data-testid": "panel-cancel-query",
      onClick: onCancelQuery
    },
    /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "sync-slash", size: "md" })
  ))), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.rightAligned }, actions && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.rightActions }, itemsRenderer(actions, (item) => item))));
  return (
    // tabIndex={0} is needed for keyboard accessibility in the plot area
    /* @__PURE__ */ React__default["default"].createElement(
      "div",
      {
        className: css.cx(styles.container, { [styles.transparentContainer]: isPanelTransparent }),
        style: containerStyles,
        "data-testid": testid,
        tabIndex: 0,
        ref
      },
      /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.loadingBarContainer }, loadingState === data.LoadingState.Loading ? /* @__PURE__ */ React__default["default"].createElement(LoadingBar, { width: loadingBarWidth, ariaLabel: "Panel loading bar" }) : null),
      hoverHeader && /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(
        HoverWidget,
        {
          menu,
          title: typeof title === "string" ? title : void 0,
          offset: hoverHeaderOffset,
          dragClass,
          onOpenMenu
        },
        headerContent
      ), statusMessage && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.errorContainerFloating }, /* @__PURE__ */ React__default["default"].createElement(PanelStatus, { message: statusMessage, onClick: statusMessageOnClick, ariaLabel: "Panel status" }))),
      hasHeader && /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.headerContainer, dragClass), style: headerStyles, "data-testid": "header-container" }, statusMessage && /* @__PURE__ */ React__default["default"].createElement("div", { className: dragClassCancel }, /* @__PURE__ */ React__default["default"].createElement(PanelStatus, { message: statusMessage, onClick: statusMessageOnClick, ariaLabel: "Panel status" })), headerContent, menu && /* @__PURE__ */ React__default["default"].createElement(
        PanelMenu,
        {
          menu,
          title: typeof title === "string" ? title : void 0,
          placement: "bottom-end",
          menuButtonClass: css.cx(styles.menuItem, dragClassCancel, showOnHoverClass),
          onOpenMenu
        }
      )),
      !collapsed && /* @__PURE__ */ React__default["default"].createElement(
        "div",
        {
          id: panelContentId,
          className: css.cx(styles.content, height === void 0 && styles.containNone),
          style: contentStyle
        },
        typeof children === "function" ? children(innerWidth, innerHeight) : children
      )
    )
  );
}
const itemsRenderer = (items, renderer) => {
  const toRender = React__default["default"].Children.toArray(items).filter(Boolean);
  return toRender.length > 0 ? renderer(toRender) : null;
};
const getHeaderHeight = (theme, hasHeader) => {
  if (hasHeader) {
    return theme.spacing.gridSize * theme.components.panel.headerHeight;
  }
  return 0;
};
const getContentStyle = (padding, theme, headerHeight, collapsed, height, width) => {
  const chromePadding = (padding === "md" ? theme.components.panel.padding : 0) * theme.spacing.gridSize;
  const panelPadding = chromePadding * 2;
  const panelBorder = 1 * 2;
  let innerWidth = 0;
  if (width) {
    innerWidth = width - panelPadding - panelBorder;
  }
  let innerHeight = 0;
  if (height) {
    innerHeight = height - headerHeight - panelPadding - panelBorder;
  }
  if (collapsed) {
    innerHeight = headerHeight;
  }
  const contentStyle = {
    padding: chromePadding
  };
  return { contentStyle, innerWidth, innerHeight };
};
const getStyles$J = (theme) => {
  const { background, borderColor, padding } = theme.components.panel;
  return {
    container: css.css({
      label: "panel-container",
      backgroundColor: background,
      border: `1px solid ${borderColor}`,
      position: "relative",
      borderRadius: theme.shape.radius.default,
      height: "100%",
      display: "flex",
      flexDirection: "column",
      "> *": {
        zIndex: 0
      },
      // matches .react-grid-item styles in _dashboard_grid.scss to ensure any contained tooltips occlude adjacent panels
      "&:hover, &:active, &:focus": {
        zIndex: theme.zIndex.activePanel
      },
      ".show-on-hover": {
        opacity: "0",
        visibility: "hidden"
      },
      "&:focus-visible, &:hover": {
        // only show menu icon on hover or focused panel
        ".show-on-hover": {
          opacity: "1",
          visibility: "visible"
        }
      },
      "&:focus-visible": getFocusStyles(theme),
      // The not:(:focus) clause is so that this rule is only applied when decendants are focused (important otherwise the hover header is visible when panel is clicked).
      "&:focus-within:not(:focus)": {
        ".show-on-hover": {
          visibility: "visible",
          opacity: "1"
        }
      }
    }),
    transparentContainer: css.css({
      label: "panel-transparent-container",
      backgroundColor: "transparent",
      border: "1px solid transparent",
      boxSizing: "border-box",
      "&:hover": {
        border: `1px solid ${borderColor}`
      }
    }),
    loadingBarContainer: css.css({
      label: "panel-loading-bar-container",
      position: "absolute",
      top: 0,
      width: "100%"
    }),
    containNone: css.css({
      contain: "none"
    }),
    content: css.css({
      label: "panel-content",
      flexGrow: 1,
      contain: "size layout"
    }),
    headerContainer: css.css({
      label: "panel-header",
      display: "flex",
      alignItems: "center"
    }),
    pointer: css.css({
      cursor: "pointer"
    }),
    streaming: css.css({
      label: "panel-streaming",
      marginRight: 0,
      color: theme.colors.success.text,
      "&:hover": {
        color: theme.colors.success.text
      }
    }),
    title: css.css({
      label: "panel-title",
      display: "flex",
      marginBottom: 0,
      // override default h6 margin-bottom
      padding: theme.spacing(0, padding),
      textOverflow: "ellipsis",
      overflow: "hidden",
      whiteSpace: "nowrap",
      fontSize: theme.typography.h6.fontSize,
      fontWeight: theme.typography.h6.fontWeight
    }),
    items: css.css({
      display: "flex"
    }),
    item: css.css({
      display: "flex",
      justifyContent: "center",
      alignItems: "center"
    }),
    hiddenMenu: css.css({
      visibility: "hidden"
    }),
    menuItem: css.css({
      label: "panel-menu",
      border: "none",
      background: theme.colors.secondary.main,
      "&:hover": {
        background: theme.colors.secondary.shade
      }
    }),
    errorContainerFloating: css.css({
      label: "error-container",
      position: "absolute",
      left: 0,
      top: 0,
      zIndex: 1
    }),
    rightActions: css.css({
      display: "flex",
      padding: theme.spacing(0, padding),
      gap: theme.spacing(1)
    }),
    rightAligned: css.css({
      label: "right-aligned-container",
      marginLeft: "auto",
      display: "flex",
      alignItems: "center"
    }),
    titleItems: css.css({
      display: "flex",
      height: "100%"
    }),
    clearButtonStyles: css.css({
      alignItems: "center",
      display: "flex",
      gap: theme.spacing(0.5),
      background: "transparent",
      color: theme.colors.text.primary,
      border: "none",
      padding: 0,
      textOverflow: "ellipsis",
      overflow: "hidden",
      whiteSpace: "nowrap",
      fontSize: theme.typography.h6.fontSize,
      fontWeight: theme.typography.h6.fontWeight
    })
  };
};

const PanelContextRoot = React__default["default"].createContext({
  eventsScope: "global",
  eventBus: new data.EventBusSrv()
});
const PanelContextProvider = PanelContextRoot.Provider;
const usePanelContext = () => React__default["default"].useContext(PanelContextRoot);

var SeriesVisibilityChangeMode = /* @__PURE__ */ ((SeriesVisibilityChangeMode2) => {
  SeriesVisibilityChangeMode2["ToggleSelection"] = "select";
  SeriesVisibilityChangeMode2["AppendToSelection"] = "append";
  return SeriesVisibilityChangeMode2;
})(SeriesVisibilityChangeMode || {});

const PanelChrome = PanelChrome$1;
PanelChrome.LoadingIndicator = LoadingIndicator;
PanelChrome.TitleItem = TitleItem;

function ExpandedRow({ tableStyles, nestedData, rowIndex, width, cellHeight }) {
  const frames = nestedData.values;
  const subTables = [];
  const theme = useTheme2();
  const styles = useStyles2(getStyles$I);
  let top = tableStyles.rowHeight + theme.spacing.gridSize;
  frames[rowIndex].forEach((nf, nfIndex) => {
    var _a, _b;
    const noHeader = !!((_b = (_a = nf.meta) == null ? void 0 : _a.custom) == null ? void 0 : _b.noHeader);
    const height = tableStyles.rowHeight * (nf.length + (noHeader ? 0 : 1));
    const subTable = {
      height,
      paddingLeft: EXPANDER_WIDTH,
      position: "absolute",
      top
    };
    top += height + theme.spacing.gridSize;
    subTables.push(
      /* @__PURE__ */ React__default["default"].createElement("div", { style: subTable, key: `subTable_${rowIndex}_${nfIndex}` }, /* @__PURE__ */ React__default["default"].createElement(
        Table,
        {
          data: nf,
          width: width - EXPANDER_WIDTH,
          height: tableStyles.rowHeight * (nf.length + 1),
          noHeader,
          cellHeight
        }
      ))
    );
  });
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.subTables }, subTables);
}
const getStyles$I = (theme) => {
  return {
    subTables: css.css({
      "&:before": {
        content: '""',
        position: "absolute",
        width: "1px",
        top: theme.spacing(5),
        left: theme.spacing(1),
        bottom: theme.spacing(2),
        background: theme.colors.border.medium
      }
    })
  };
};
function getExpandedRowHeight(nestedData, rowIndex, tableStyles) {
  const frames = nestedData.values;
  const height = frames[rowIndex].reduce((acc, frame) => {
    var _a, _b;
    if (frame.length) {
      const noHeader = !!((_b = (_a = frame.meta) == null ? void 0 : _a.custom) == null ? void 0 : _b.noHeader);
      return acc + tableStyles.rowHeight * (frame.length + (noHeader ? 0 : 1)) + 8;
    }
    return acc;
  }, tableStyles.rowHeight);
  return height != null ? height : tableStyles.rowHeight;
}

const TableCell = ({ cell, tableStyles, onCellFilterAdded, timeRange, userProps, frame }) => {
  const cellProps = cell.getCellProps();
  const field = cell.column.field;
  if (!(field == null ? void 0 : field.display)) {
    return null;
  }
  if (cellProps.style) {
    cellProps.style.minWidth = cellProps.style.width;
    cellProps.style.justifyContent = cell.column.justifyContent;
  }
  let innerWidth = (typeof cell.column.width === "number" ? cell.column.width : 24) - tableStyles.cellPadding * 2;
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, cell.render("Cell", {
    field,
    tableStyles,
    onCellFilterAdded,
    cellProps,
    innerWidth,
    timeRange,
    userProps,
    frame
  }));
};

var __defProp$1g = Object.defineProperty;
var __defProps$S = Object.defineProperties;
var __getOwnPropDescs$S = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1b = Object.getOwnPropertySymbols;
var __hasOwnProp$1b = Object.prototype.hasOwnProperty;
var __propIsEnum$1b = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1g = (obj, key, value) => key in obj ? __defProp$1g(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$1a = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1b.call(b, prop))
      __defNormalProp$1g(a, prop, b[prop]);
  if (__getOwnPropSymbols$1b)
    for (var prop of __getOwnPropSymbols$1b(b)) {
      if (__propIsEnum$1b.call(b, prop))
        __defNormalProp$1g(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$S = (a, b) => __defProps$S(a, __getOwnPropDescs$S(b));
const RowsList = (props) => {
  const {
    data: data$1,
    rows,
    headerHeight,
    footerPaginationEnabled,
    rowHeight,
    itemCount,
    pageIndex,
    tableState,
    prepareRow,
    onCellFilterAdded,
    width,
    cellHeight = schema.TableCellHeight.Sm,
    timeRange,
    tableStyles,
    nestedDataField,
    listHeight,
    listRef,
    enableSharedCrosshair = false,
    initialRowIndex = void 0
  } = props;
  const [rowHighlightIndex, setRowHighlightIndex] = React.useState(initialRowIndex);
  const theme = useTheme2();
  const panelContext = usePanelContext();
  const threshold = React.useMemo(() => {
    const timeField = data$1.fields.find((f) => f.type === data.FieldType.time);
    if (!timeField) {
      return 0;
    }
    return calculateAroundPointThreshold(timeField);
  }, [data$1]);
  const onRowHover = React.useCallback(
    (idx, frame) => {
      if (!panelContext || !enableSharedCrosshair || !data.hasTimeField(frame)) {
        return;
      }
      const timeField = frame.fields.find((f) => f.type === data.FieldType.time);
      panelContext.eventBus.publish(
        new data.DataHoverEvent({
          point: {
            time: timeField.values[idx]
          }
        })
      );
    },
    [enableSharedCrosshair, panelContext]
  );
  const onRowLeave = React.useCallback(() => {
    if (!panelContext || !enableSharedCrosshair) {
      return;
    }
    panelContext.eventBus.publish(new data.DataHoverClearEvent());
  }, [enableSharedCrosshair, panelContext]);
  const onDataHoverEvent = React.useCallback(
    (evt) => {
      var _a;
      if (((_a = evt.payload.point) == null ? void 0 : _a.time) && evt.payload.rowIndex !== void 0) {
        const timeField = data$1.fields.find((f) => f.type === data.FieldType.time);
        const time = timeField.values[evt.payload.rowIndex];
        const pointTime = evt.payload.point.time;
        if (isPointTimeValAroundTableTimeVal(pointTime, time, threshold)) {
          setRowHighlightIndex(evt.payload.rowIndex);
          return;
        }
        const matchedRowIndex = timeField.values.findIndex(
          (t) => isPointTimeValAroundTableTimeVal(pointTime, t, threshold)
        );
        if (matchedRowIndex !== -1) {
          setRowHighlightIndex(matchedRowIndex);
          return;
        }
        setRowHighlightIndex(void 0);
      }
    },
    [data$1.fields, threshold]
  );
  React.useEffect(() => {
    if (!panelContext || !enableSharedCrosshair || !data.hasTimeField(data$1) || footerPaginationEnabled) {
      return;
    }
    const subs = new rxjs.Subscription();
    subs.add(
      panelContext.eventBus.getStream(data.DataHoverEvent).pipe(rxjs.debounceTime(250)).subscribe({
        next: (evt) => {
          if (panelContext.eventBus === evt.origin) {
            return;
          }
          onDataHoverEvent(evt);
        }
      })
    );
    subs.add(
      panelContext.eventBus.getStream(data.DataHoverClearEvent).pipe(rxjs.debounceTime(250)).subscribe({
        next: (evt) => {
          if (panelContext.eventBus === evt.origin) {
            return;
          }
          setRowHighlightIndex(void 0);
        }
      })
    );
    return () => {
      subs.unsubscribe();
    };
  }, [data$1, enableSharedCrosshair, footerPaginationEnabled, onDataHoverEvent, panelContext]);
  let scrollTop = void 0;
  if (rowHighlightIndex !== void 0) {
    const firstMatchedRowIndex = rows.findIndex((row) => row.index === rowHighlightIndex);
    if (firstMatchedRowIndex !== -1) {
      scrollTop = headerHeight + (firstMatchedRowIndex - 1) * rowHeight;
    }
  }
  const rowIndexForPagination = React.useCallback(
    (index) => {
      return tableState.pageIndex * tableState.pageSize + index;
    },
    [tableState.pageIndex, tableState.pageSize]
  );
  const RenderRow = React.useCallback(
    ({ index, style, rowHighlightIndex: rowHighlightIndex2 }) => {
      const indexForPagination = rowIndexForPagination(index);
      const row = rows[indexForPagination];
      let additionalProps = {};
      prepareRow(row);
      const expandedRowStyle = tableState.expanded[row.id] ? css.css({ "&:hover": { background: "inherit" } }) : {};
      if (rowHighlightIndex2 !== void 0 && row.index === rowHighlightIndex2) {
        style = __spreadProps$S(__spreadValues$1a({}, style), { backgroundColor: theme.components.table.rowHoverBackground });
        additionalProps = {
          "aria-selected": "true"
        };
      }
      return /* @__PURE__ */ React__default["default"].createElement(
        "div",
        __spreadProps$S(__spreadValues$1a({}, row.getRowProps(__spreadValues$1a({ style }, additionalProps))), {
          className: css.cx(tableStyles.row, expandedRowStyle),
          onMouseEnter: () => onRowHover(index, data$1),
          onMouseLeave: onRowLeave
        }),
        nestedDataField && tableState.expanded[row.id] && /* @__PURE__ */ React__default["default"].createElement(
          ExpandedRow,
          {
            nestedData: nestedDataField,
            tableStyles,
            rowIndex: index,
            width,
            cellHeight
          }
        ),
        row.cells.map((cell, index2) => /* @__PURE__ */ React__default["default"].createElement(
          TableCell,
          {
            key: index2,
            tableStyles,
            cell,
            onCellFilterAdded,
            columnIndex: index2,
            columnCount: row.cells.length,
            timeRange,
            frame: data$1
          }
        ))
      );
    },
    [
      cellHeight,
      data$1,
      nestedDataField,
      onCellFilterAdded,
      onRowHover,
      onRowLeave,
      prepareRow,
      rowIndexForPagination,
      rows,
      tableState.expanded,
      tableStyles,
      theme.components.table.rowHoverBackground,
      timeRange,
      width
    ]
  );
  const getItemSize = (index) => {
    const indexForPagination = rowIndexForPagination(index);
    const row = rows[indexForPagination];
    if (tableState.expanded[row.id] && nestedDataField) {
      return getExpandedRowHeight(nestedDataField, index, tableStyles);
    }
    return tableStyles.rowHeight;
  };
  const handleScroll = (event) => {
    const { scrollTop: scrollTop2 } = event.currentTarget;
    if (listRef.current !== null) {
      listRef.current.scrollTo(scrollTop2);
    }
  };
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(CustomScrollbar, { onScroll: handleScroll, hideHorizontalTrack: true, scrollTop }, /* @__PURE__ */ React__default["default"].createElement(
    reactWindow.VariableSizeList,
    {
      key: rowHeight + pageIndex,
      height: listHeight,
      itemCount,
      itemSize: getItemSize,
      width: "100%",
      ref: listRef,
      style: { overflow: void 0 }
    },
    ({ index, style }) => RenderRow({ index, style, rowHighlightIndex })
  )));
};

function useFixScrollbarContainer(variableSizeListScrollbarRef, tableDivRef) {
  React.useEffect(() => {
    var _a;
    if (variableSizeListScrollbarRef.current && tableDivRef.current) {
      const listVerticalScrollbarHTML = variableSizeListScrollbarRef.current.querySelector(".track-vertical");
      const tableScrollbarView = tableDivRef.current.firstChild;
      if (tableScrollbarView && listVerticalScrollbarHTML) {
        listVerticalScrollbarHTML.remove();
        if (tableScrollbarView instanceof HTMLElement) {
          (_a = tableScrollbarView.querySelector(":scope > .track-vertical")) == null ? void 0 : _a.remove();
          tableScrollbarView.append(listVerticalScrollbarHTML);
        }
      }
    }
  });
}
function useResetVariableListSizeCache(extendedState, listRef, data, hasUniqueId) {
  const expandedRowsRepr = JSON.stringify(Object.keys(extendedState.expanded));
  React.useEffect(() => {
    var _a;
    let resetIndex = 0;
    if (!hasUniqueId) {
      if (Number.isFinite(extendedState.lastExpandedOrCollapsedIndex)) {
        resetIndex = extendedState.lastExpandedOrCollapsedIndex;
      }
      resetIndex = extendedState.pageIndex === 0 ? resetIndex - 1 : resetIndex - extendedState.pageIndex - extendedState.pageIndex * extendedState.pageSize;
    }
    (_a = listRef.current) == null ? void 0 : _a.resetAfterIndex(Math.max(resetIndex, 0));
    return;
  }, [
    extendedState.lastExpandedOrCollapsedIndex,
    extendedState.pageSize,
    extendedState.pageIndex,
    listRef,
    data,
    expandedRowsRepr,
    hasUniqueId
  ]);
}

var __defProp$1f = Object.defineProperty;
var __defProps$R = Object.defineProperties;
var __getOwnPropDescs$R = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$1a = Object.getOwnPropertySymbols;
var __hasOwnProp$1a = Object.prototype.hasOwnProperty;
var __propIsEnum$1a = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1f = (obj, key, value) => key in obj ? __defProp$1f(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$19 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$1a.call(b, prop))
      __defNormalProp$1f(a, prop, b[prop]);
  if (__getOwnPropSymbols$1a)
    for (var prop of __getOwnPropSymbols$1a(b)) {
      if (__propIsEnum$1a.call(b, prop))
        __defNormalProp$1f(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$R = (a, b) => __defProps$R(a, __getOwnPropDescs$R(b));
function useTableStateReducer({ onColumnResize, onSortByChange, data: data$1 }) {
  return React.useCallback(
    (newState, action) => {
      switch (action.type) {
        case "columnDoneResizing":
          if (onColumnResize) {
            const info = newState.columnResizing.headerIdWidths[0];
            const columnIdString = info[0];
            const fieldIndex = parseInt(columnIdString, 10);
            const width = Math.round(newState.columnResizing.columnWidths[columnIdString]);
            const field = data$1.fields[fieldIndex];
            if (!field) {
              return newState;
            }
            const fieldDisplayName = data.getFieldDisplayName(field, data$1);
            onColumnResize(fieldDisplayName, width);
          }
        case "toggleSortBy":
          if (onSortByChange) {
            const sortByFields = [];
            for (const sortItem of newState.sortBy) {
              const field = data$1.fields[parseInt(sortItem.id, 10)];
              if (!field) {
                continue;
              }
              sortByFields.push({
                displayName: data.getFieldDisplayName(field, data$1),
                desc: sortItem.desc
              });
            }
            onSortByChange(sortByFields);
          }
        case "toggleRowExpanded": {
          if (action.id) {
            return __spreadProps$R(__spreadValues$19({}, newState), {
              lastExpandedOrCollapsedIndex: parseInt(action.id, 10)
            });
          }
        }
      }
      return newState;
    },
    [data$1, onColumnResize, onSortByChange]
  );
}
function getInitialState(initialSortBy, columns) {
  const state = {};
  if (initialSortBy) {
    state.sortBy = [];
    for (const sortBy of initialSortBy) {
      for (const col of columns) {
        if (col.Header === sortBy.displayName) {
          state.sortBy.push({ id: col.id, desc: sortBy.desc });
        }
      }
    }
  }
  return state;
}

var __defProp$1e = Object.defineProperty;
var __defProps$Q = Object.defineProperties;
var __getOwnPropDescs$Q = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$19 = Object.getOwnPropertySymbols;
var __hasOwnProp$19 = Object.prototype.hasOwnProperty;
var __propIsEnum$19 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1e = (obj, key, value) => key in obj ? __defProp$1e(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$18 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$19.call(b, prop))
      __defNormalProp$1e(a, prop, b[prop]);
  if (__getOwnPropSymbols$19)
    for (var prop of __getOwnPropSymbols$19(b)) {
      if (__propIsEnum$19.call(b, prop))
        __defNormalProp$1e(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$Q = (a, b) => __defProps$Q(a, __getOwnPropDescs$Q(b));
function useTableStyles(theme, cellHeightOption) {
  const borderColor = theme.colors.border.weak;
  const resizerColor = theme.colors.primary.border;
  const cellPadding = 6;
  const cellHeight = getCellHeight(theme, cellHeightOption, cellPadding);
  const rowHeight = cellHeight + 2;
  const headerHeight = 28;
  const buildCellContainerStyle = (color, background, overflowOnHover, asCellText) => {
    return css.css(__spreadProps$Q(__spreadValues$18({
      label: overflowOnHover ? "cellContainerOverflow" : "cellContainerNoOverflow",
      padding: `${cellPadding}px`,
      width: "100%",
      // Cell height need to account for row border
      height: `${rowHeight - 1}px`,
      display: "flex"
    }, asCellText ? {
      overflow: "hidden",
      textOverflow: "ellipsis",
      userSelect: "text",
      whiteSpace: "nowrap"
    } : {}), {
      alignItems: "center",
      borderRight: `1px solid ${borderColor}`,
      color: color != null ? color : void 0,
      background: background != null ? background : void 0,
      backgroundClip: "padding-box",
      "&:last-child:not(:only-child)": {
        borderRight: "none"
      },
      "&:hover": {
        overflow: overflowOnHover ? "visible" : void 0,
        width: overflowOnHover ? "auto !important" : void 0,
        boxShadow: overflowOnHover ? `0 0 2px ${theme.colors.primary.main}` : void 0,
        background: overflowOnHover ? background != null ? background : theme.components.table.rowHoverBackground : void 0,
        zIndex: overflowOnHover ? 1 : void 0,
        ".cellActions": {
          visibility: "visible",
          opacity: 1,
          width: "auto"
        }
      },
      a: {
        color: "inherit"
      },
      ".cellActions": {
        display: "flex",
        position: overflowOnHover ? void 0 : "absolute",
        top: overflowOnHover ? void 0 : 0,
        right: overflowOnHover ? void 0 : 0,
        margin: overflowOnHover ? theme.spacing(0, -0.5, 0, 0.5) : "auto",
        visibility: "hidden",
        opacity: 0,
        width: 0,
        alignItems: "center",
        height: "100%",
        padding: theme.spacing(1, 0.5, 1, 0.5),
        background: background ? "none" : theme.colors.emphasize(theme.colors.background.primary, 0.03),
        svg: {
          color
        }
      },
      ".cellActionsLeft": {
        right: "auto !important",
        left: 0
      },
      ".cellActionsTransparent": {
        background: "none"
      }
    }));
  };
  return {
    theme,
    cellHeight,
    buildCellContainerStyle,
    cellPadding,
    cellHeightInner: cellHeight - cellPadding * 2,
    rowHeight,
    table: css.css({
      height: "100%",
      width: "100%",
      overflow: "auto",
      display: "flex",
      flexDirection: "column"
    }),
    thead: css.css({
      label: "thead",
      height: `${headerHeight}px`,
      overflowY: "auto",
      overflowX: "hidden",
      position: "relative"
    }),
    tfoot: css.css({
      label: "tfoot",
      height: `${headerHeight}px`,
      borderTop: `1px solid ${borderColor}`,
      overflowY: "auto",
      overflowX: "hidden",
      position: "relative"
    }),
    headerRow: css.css({
      label: "row",
      borderBottom: `1px solid ${borderColor}`
    }),
    headerCell: css.css({
      height: "100%",
      padding: `0 ${cellPadding}px`,
      overflow: "hidden",
      whiteSpace: "nowrap",
      display: "flex",
      alignItems: "center",
      fontWeight: theme.typography.fontWeightMedium,
      "&:last-child": {
        borderRight: "none"
      }
    }),
    headerCellLabel: css.css({
      border: "none",
      padding: 0,
      background: "inherit",
      cursor: "pointer",
      whiteSpace: "nowrap",
      overflow: "hidden",
      textOverflow: "ellipsis",
      fontWeight: theme.typography.fontWeightMedium,
      display: "flex",
      alignItems: "center",
      marginRight: theme.spacing(0.5),
      "&:hover": {
        textDecoration: "underline",
        color: theme.colors.text.link
      }
    }),
    cellContainerText: buildCellContainerStyle(void 0, void 0, true, true),
    cellContainerTextNoOverflow: buildCellContainerStyle(void 0, void 0, false, true),
    cellContainer: buildCellContainerStyle(void 0, void 0, true, false),
    cellContainerNoOverflow: buildCellContainerStyle(void 0, void 0, false, false),
    cellText: css.css({
      overflow: "hidden",
      textOverflow: "ellipsis",
      userSelect: "text",
      whiteSpace: "nowrap"
    }),
    sortIcon: css.css({
      marginLeft: theme.spacing(0.5)
    }),
    cellLink: css.css({
      cursor: "pointer",
      overflow: "hidden",
      textOverflow: "ellipsis",
      userSelect: "text",
      whiteSpace: "nowrap",
      color: theme.colors.text.link,
      fontWeight: theme.typography.fontWeightMedium,
      paddingRight: theme.spacing(1.5),
      "&:hover": {
        textDecoration: "underline",
        color: theme.colors.text.link
      }
    }),
    cellLinkForColoredCell: css.css({
      cursor: "pointer",
      overflow: "hidden",
      textOverflow: "ellipsis",
      userSelect: "text",
      whiteSpace: "nowrap",
      fontWeight: theme.typography.fontWeightMedium,
      textDecoration: "underline"
    }),
    imageCellLink: css.css({
      cursor: "pointer",
      overflow: "hidden",
      height: "100%"
    }),
    headerFilter: css.css({
      background: "transparent",
      border: "none",
      label: "headerFilter",
      padding: 0
    }),
    paginationWrapper: css.css({
      display: "flex",
      height: `${cellHeight}px`,
      justifyContent: "center",
      alignItems: "center",
      width: "100%",
      li: {
        marginBottom: 0
      }
    }),
    paginationSummary: css.css({
      color: theme.colors.text.secondary,
      fontSize: theme.typography.bodySmall.fontSize,
      display: "flex",
      justifyContent: "flex-end",
      padding: theme.spacing(0, 1, 0, 2)
    }),
    tableContentWrapper: (totalColumnsWidth) => {
      const width = totalColumnsWidth !== void 0 ? `${totalColumnsWidth}px` : "100%";
      return css.css({
        label: "tableContentWrapper",
        width,
        display: "flex",
        flexDirection: "column"
      });
    },
    row: css.css({
      label: "row",
      borderBottom: `1px solid ${borderColor}`,
      "&:hover": {
        backgroundColor: theme.components.table.rowHoverBackground
      },
      "&:last-child": {
        borderBottom: 0
      }
    }),
    imageCell: css.css({
      height: "100%"
    }),
    resizeHandle: css.css({
      label: "resizeHandle",
      cursor: "col-resize !important",
      display: "inline-block",
      background: resizerColor,
      opacity: 0,
      transition: "opacity 0.2s ease-in-out",
      width: "8px",
      height: "100%",
      position: "absolute",
      right: "-4px",
      borderRadius: theme.shape.radius.default,
      top: 0,
      touchAction: "none",
      "&:hover": {
        opacity: 1
      }
    }),
    typeIcon: css.css({
      marginRight: theme.spacing(1),
      color: theme.colors.text.secondary
    }),
    noData: css.css({
      alignItems: "center",
      display: "flex",
      height: "100%",
      justifyContent: "center",
      width: "100%"
    }),
    expanderCell: css.css({
      display: "flex",
      flexDirection: "column",
      justifyContent: "center",
      height: `${rowHeight}px`,
      cursor: "pointer"
    })
  };
}
function getCellHeight(theme, cellHeightOption, cellPadding) {
  const bodyFontSize = theme.typography.fontSize;
  const lineHeight = theme.typography.body.lineHeight;
  switch (cellHeightOption) {
    case "md":
      return 42;
    case "lg":
      return 48;
    case "sm":
    default:
      return cellPadding * 2 + bodyFontSize * lineHeight;
  }
}

var __defProp$1d = Object.defineProperty;
var __defProps$P = Object.defineProperties;
var __getOwnPropDescs$P = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$18 = Object.getOwnPropertySymbols;
var __hasOwnProp$18 = Object.prototype.hasOwnProperty;
var __propIsEnum$18 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1d = (obj, key, value) => key in obj ? __defProp$1d(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$17 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$18.call(b, prop))
      __defNormalProp$1d(a, prop, b[prop]);
  if (__getOwnPropSymbols$18)
    for (var prop of __getOwnPropSymbols$18(b)) {
      if (__propIsEnum$18.call(b, prop))
        __defNormalProp$1d(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$P = (a, b) => __defProps$P(a, __getOwnPropDescs$P(b));
const COLUMN_MIN_WIDTH = 150;
const FOOTER_ROW_HEIGHT = 36;
const Table = React.memo((props) => {
  var _a, _b;
  const {
    ariaLabel,
    data: data$1,
    height,
    onCellFilterAdded,
    width,
    columnMinWidth = COLUMN_MIN_WIDTH,
    noHeader,
    resizable = true,
    initialSortBy,
    footerOptions,
    showTypeIcons,
    footerValues,
    enablePagination,
    cellHeight = schema.TableCellHeight.Sm,
    timeRange,
    enableSharedCrosshair = false,
    initialRowIndex = void 0
  } = props;
  const listRef = React.useRef(null);
  const tableDivRef = React.useRef(null);
  const variableSizeListScrollbarRef = React.useRef(null);
  const theme = useTheme2();
  const tableStyles = useTableStyles(theme, cellHeight);
  const headerHeight = noHeader ? 0 : tableStyles.rowHeight;
  const [footerItems, setFooterItems] = React.useState(footerValues);
  const footerHeight = React.useMemo(() => {
    const EXTENDED_ROW_HEIGHT = FOOTER_ROW_HEIGHT;
    let length = 0;
    if (!footerItems) {
      return 0;
    }
    for (const fv of footerItems) {
      if (Array.isArray(fv) && fv.length > length) {
        length = fv.length;
      }
    }
    if (length > 1) {
      return EXTENDED_ROW_HEIGHT * length;
    }
    return EXTENDED_ROW_HEIGHT;
  }, [footerItems]);
  const memoizedData = React.useMemo(() => {
    if (!data$1.fields.length) {
      return [];
    }
    return Array(data$1.length).fill(0);
  }, [data$1]);
  const isCountRowsSet = Boolean(
    (footerOptions == null ? void 0 : footerOptions.countRows) && footerOptions.reducer && footerOptions.reducer.length && footerOptions.reducer[0] === data.ReducerID.count
  );
  const nestedDataField = data$1.fields.find((f) => f.type === data.FieldType.nestedFrames);
  const hasNestedData = nestedDataField !== void 0;
  const memoizedColumns = React.useMemo(
    () => getColumns(data$1, width, columnMinWidth, hasNestedData, footerItems, isCountRowsSet),
    [data$1, width, columnMinWidth, footerItems, hasNestedData, isCountRowsSet]
  );
  const toggleAllRowsExpandedRef = React.useRef();
  const stateReducer = useTableStateReducer(__spreadProps$P(__spreadValues$17({}, props), {
    onSortByChange: (state2) => {
      toggleAllRowsExpandedRef.current(false);
      if (props.onSortByChange) {
        props.onSortByChange(state2);
      }
    }
  }));
  const hasUniqueId = !!((_b = (_a = data$1.meta) == null ? void 0 : _a.uniqueRowIdFields) == null ? void 0 : _b.length);
  const options = React.useMemo(() => {
    const options2 = {
      columns: memoizedColumns,
      data: memoizedData,
      disableResizing: !resizable,
      stateReducer,
      autoResetPage: false,
      initialState: getInitialState(initialSortBy, memoizedColumns),
      autoResetFilters: false,
      sortTypes: {
        // the builtin number type on react-table does not handle NaN values
        number: sortNumber,
        // should be replaced with the builtin string when react-table is upgraded,
        // see https://github.com/tannerlinsley/react-table/pull/3235
        "alphanumeric-insensitive": sortCaseInsensitive
      }
    };
    if (hasUniqueId) {
      options2.getRowId = (row, relativeIndex) => data.getRowUniqueId(data$1, relativeIndex);
      options2.autoResetExpanded = false;
    }
    return options2;
  }, [initialSortBy, memoizedColumns, memoizedData, resizable, stateReducer, hasUniqueId, data$1]);
  const {
    getTableProps,
    headerGroups,
    footerGroups,
    rows,
    prepareRow,
    totalColumnsWidth,
    page,
    state,
    gotoPage,
    setPageSize,
    pageOptions,
    toggleAllRowsExpanded
  } = reactTable.useTable(options, reactTable.useFilters, reactTable.useSortBy, reactTable.useAbsoluteLayout, reactTable.useResizeColumns, reactTable.useExpanded, reactTable.usePagination);
  const extendedState = state;
  toggleAllRowsExpandedRef.current = toggleAllRowsExpanded;
  React.useEffect(() => {
    if (!footerOptions) {
      setFooterItems(footerValues);
    }
  }, [footerValues, footerOptions]);
  React.useEffect(() => {
    var _a2, _b2, _c;
    if (!footerOptions) {
      return;
    }
    if (!footerOptions.show) {
      setFooterItems(void 0);
      return;
    }
    if (isCountRowsSet) {
      const footerItemsCountRows = [];
      footerItemsCountRows[0] = (_c = (_b2 = (_a2 = headerGroups[0]) == null ? void 0 : _a2.headers[0]) == null ? void 0 : _b2.filteredRows.length.toString()) != null ? _c : data$1.length.toString();
      setFooterItems(footerItemsCountRows);
      return;
    }
    const footerItems2 = getFooterItems(
      headerGroups[0].headers,
      createFooterCalculationValues(rows),
      footerOptions,
      theme
    );
    setFooterItems(footerItems2);
  }, [footerOptions, theme, state.filters, data$1]);
  let listHeight = height - (headerHeight + footerHeight);
  if (enablePagination) {
    listHeight -= tableStyles.cellHeight;
  }
  const pageSize = Math.round(listHeight / tableStyles.rowHeight) - 1;
  React.useEffect(() => {
    if (pageSize <= 0) {
      return;
    }
    setPageSize(pageSize);
  }, [pageSize, setPageSize]);
  React.useEffect(() => {
    if (data$1.length / pageSize < state.pageIndex) {
      gotoPage(0);
    }
  }, [data$1]);
  useResetVariableListSizeCache(extendedState, listRef, data$1, hasUniqueId);
  useFixScrollbarContainer(variableSizeListScrollbarRef, tableDivRef);
  const onNavigate = React.useCallback(
    (toPage) => {
      gotoPage(toPage - 1);
    },
    [gotoPage]
  );
  const itemCount = enablePagination ? page.length : rows.length;
  let paginationEl = null;
  if (enablePagination) {
    const itemsRangeStart = state.pageIndex * state.pageSize + 1;
    let itemsRangeEnd = itemsRangeStart + state.pageSize - 1;
    const isSmall = width < 550;
    if (itemsRangeEnd > data$1.length) {
      itemsRangeEnd = data$1.length;
    }
    paginationEl = /* @__PURE__ */ React__default["default"].createElement("div", { className: tableStyles.paginationWrapper }, /* @__PURE__ */ React__default["default"].createElement(
      Pagination,
      {
        currentPage: state.pageIndex + 1,
        numberOfPages: pageOptions.length,
        showSmallVersion: isSmall,
        onNavigate
      }
    ), isSmall ? null : /* @__PURE__ */ React__default["default"].createElement("div", { className: tableStyles.paginationSummary }, itemsRangeStart, " - ", itemsRangeEnd, " of ", data$1.length, " rows"));
  }
  return /* @__PURE__ */ React__default["default"].createElement(
    "div",
    __spreadProps$P(__spreadValues$17({}, getTableProps()), {
      className: tableStyles.table,
      "aria-label": ariaLabel,
      role: "table",
      ref: tableDivRef,
      style: { width, height }
    }),
    /* @__PURE__ */ React__default["default"].createElement(CustomScrollbar, { hideVerticalTrack: true }, /* @__PURE__ */ React__default["default"].createElement("div", { className: tableStyles.tableContentWrapper(totalColumnsWidth) }, !noHeader && /* @__PURE__ */ React__default["default"].createElement(HeaderRow, { headerGroups, showTypeIcons, tableStyles }), itemCount > 0 ? /* @__PURE__ */ React__default["default"].createElement("div", { "data-testid": e2eSelectors.selectors.components.Panels.Visualization.Table.body, ref: variableSizeListScrollbarRef }, /* @__PURE__ */ React__default["default"].createElement(
      RowsList,
      {
        data: data$1,
        rows,
        width,
        cellHeight,
        headerHeight,
        rowHeight: tableStyles.rowHeight,
        itemCount,
        pageIndex: state.pageIndex,
        listHeight,
        listRef,
        tableState: state,
        prepareRow,
        timeRange,
        onCellFilterAdded,
        nestedDataField,
        tableStyles,
        footerPaginationEnabled: Boolean(enablePagination),
        enableSharedCrosshair,
        initialRowIndex
      }
    )) : /* @__PURE__ */ React__default["default"].createElement("div", { style: { height: height - headerHeight, width }, className: tableStyles.noData }, "No data"), footerItems && /* @__PURE__ */ React__default["default"].createElement(
      FooterRow,
      {
        isPaginationVisible: Boolean(enablePagination),
        footerValues: footerItems,
        footerGroups,
        totalColumnsWidth,
        tableStyles
      }
    ))),
    paginationEl
  );
});
Table.displayName = "Table";

var __defProp$1c = Object.defineProperty;
var __defProps$O = Object.defineProperties;
var __getOwnPropDescs$O = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$17 = Object.getOwnPropertySymbols;
var __hasOwnProp$17 = Object.prototype.hasOwnProperty;
var __propIsEnum$17 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1c = (obj, key, value) => key in obj ? __defProp$1c(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$16 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$17.call(b, prop))
      __defNormalProp$1c(a, prop, b[prop]);
  if (__getOwnPropSymbols$17)
    for (var prop of __getOwnPropSymbols$17(b)) {
      if (__propIsEnum$17.call(b, prop))
        __defNormalProp$1c(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$O = (a, b) => __defProps$O(a, __getOwnPropDescs$O(b));
var __objRest$D = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$17.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$17)
    for (var prop of __getOwnPropSymbols$17(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$17.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const TextArea = React__default["default"].forwardRef((_a, ref) => {
  var _b = _a, { invalid, className } = _b, props = __objRest$D(_b, ["invalid", "className"]);
  const styles = useStyles2(getTextAreaStyle, invalid);
  return /* @__PURE__ */ React__default["default"].createElement("textarea", __spreadProps$O(__spreadValues$16({}, props), { className: css.cx(styles.textarea, className), ref }));
});
const getTextAreaStyle = (theme, invalid = false) => ({
  textarea: css.cx(
    sharedInputStyle(theme),
    getFocusStyle(theme),
    css.css({
      display: "block",
      borderRadius: theme.shape.radius.default,
      padding: `${theme.spacing.gridSize / 4}px ${theme.spacing.gridSize}px`,
      width: "100%",
      borderColor: invalid ? theme.colors.error.border : theme.components.input.borderColor
    })
  )
});
TextArea.displayName = "TextArea";

var __defProp$1b = Object.defineProperty;
var __defNormalProp$1b = (obj, key, value) => key in obj ? __defProp$1b(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$b = (obj, key, value) => {
  __defNormalProp$1b(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
class UnThemedTableInputCSV extends React.PureComponent {
  constructor(props) {
    super(props);
    __publicField$b(this, "readCSV", lodash.debounce(() => {
      const { config } = this.props;
      const { text } = this.state;
      this.setState({ data: data.readCSV(text, { config }) });
    }, 150));
    __publicField$b(this, "onTextChange", (event) => {
      this.setState({ text: event.target.value });
    });
    const { text, config } = props;
    this.state = {
      text,
      data: data.readCSV(text, { config })
    };
  }
  componentDidUpdate(prevProps, prevState) {
    const { text } = this.state;
    if (text !== prevState.text || this.props.config !== prevProps.config) {
      this.readCSV();
    }
    if (this.props.text !== prevProps.text && this.props.text !== text) {
      this.setState({ text: this.props.text });
    }
    if (this.state.data !== prevState.data) {
      this.props.onSeriesParsed(this.state.data, this.state.text);
    }
  }
  render() {
    const { width, height, theme } = this.props;
    const { data } = this.state;
    const styles = getStyles$H(theme);
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.tableInputCsv }, /* @__PURE__ */ React__default["default"].createElement(
      TextArea,
      {
        style: { width, height },
        placeholder: "Enter CSV here...",
        value: this.state.text,
        onChange: this.onTextChange,
        className: styles.textarea
      }
    ), data && /* @__PURE__ */ React__default["default"].createElement("footer", { className: styles.footer }, data.map((frame, index) => {
      return /* @__PURE__ */ React__default["default"].createElement("span", { key: index }, "Rows:", frame.length, ", Columns:", frame.fields.length, " \xA0", /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "check-circle" }));
    })));
  }
}
const TableInputCSV = withTheme2(UnThemedTableInputCSV);
TableInputCSV.displayName = "TableInputCSV";
const getStyles$H = stylesFactory((theme) => {
  return {
    tableInputCsv: css.css({
      position: "relative"
    }),
    textarea: css.css({
      height: "100%",
      width: "100%"
    }),
    footer: css.css({
      position: "absolute",
      bottom: "15px",
      right: "15px",
      border: "1px solid #222",
      background: theme.colors.success.main,
      padding: `1px ${theme.spacing(0.5)}`,
      fontSize: "80%"
    })
  };
});

var __defProp$1a = Object.defineProperty;
var __defProps$N = Object.defineProperties;
var __getOwnPropDescs$N = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$16 = Object.getOwnPropertySymbols;
var __hasOwnProp$16 = Object.prototype.hasOwnProperty;
var __propIsEnum$16 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$1a = (obj, key, value) => key in obj ? __defProp$1a(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$15 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$16.call(b, prop))
      __defNormalProp$1a(a, prop, b[prop]);
  if (__getOwnPropSymbols$16)
    for (var prop of __getOwnPropSymbols$16(b)) {
      if (__propIsEnum$16.call(b, prop))
        __defNormalProp$1a(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$N = (a, b) => __defProps$N(a, __getOwnPropDescs$N(b));
var __objRest$C = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$16.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$16)
    for (var prop of __getOwnPropSymbols$16(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$16.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const VerticalTab = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, { label, active, icon, counter, className, suffix: Suffix, onChangeTab, href } = _b, otherProps = __objRest$C(_b, ["label", "active", "icon", "counter", "className", "suffix", "onChangeTab", "href"]);
    const tabsStyles = useStyles2(getTabStyles);
    const content = () => /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon }), label, typeof counter === "number" && /* @__PURE__ */ React__default["default"].createElement(Counter, { value: counter }), Suffix && /* @__PURE__ */ React__default["default"].createElement(Suffix, { className: tabsStyles.suffix }));
    const linkClass = css.cx(tabsStyles.link, active && tabsStyles.activeStyle);
    return /* @__PURE__ */ React__default["default"].createElement(
      "a",
      __spreadProps$N(__spreadValues$15({
        href,
        className: linkClass
      }, otherProps), {
        onClick: onChangeTab,
        "aria-label": otherProps["aria-label"] || e2eSelectors.selectors.components.Tab.title(label),
        role: "tab",
        "aria-selected": active,
        ref
      }),
      content()
    );
  }
);
VerticalTab.displayName = "Tab";
const getTabStyles = (theme) => {
  return {
    link: css.css({
      padding: "6px 12px",
      display: "block",
      height: "100%",
      cursor: "pointer",
      position: "relative",
      color: theme.colors.text.primary,
      svg: {
        marginRight: theme.spacing(1)
      },
      "&:hover, &:focus": {
        textDecoration: "underline"
      }
    }),
    activeStyle: css.css({
      label: "activeTabStyle",
      color: theme.colors.text.maxContrast,
      overflow: "hidden",
      "&::before": {
        display: "block",
        content: '" "',
        position: "absolute",
        left: 0,
        width: "4px",
        bottom: "2px",
        top: "2px",
        borderRadius: theme.shape.radius.default,
        backgroundImage: "linear-gradient(0deg, #f05a28 30%, #fbca0a 99%)"
      }
    }),
    suffix: css.css({
      marginLeft: theme.spacing(1)
    })
  };
};

var __defProp$19 = Object.defineProperty;
var __getOwnPropSymbols$15 = Object.getOwnPropertySymbols;
var __hasOwnProp$15 = Object.prototype.hasOwnProperty;
var __propIsEnum$15 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$19 = (obj, key, value) => key in obj ? __defProp$19(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$14 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$15.call(b, prop))
      __defNormalProp$19(a, prop, b[prop]);
  if (__getOwnPropSymbols$15)
    for (var prop of __getOwnPropSymbols$15(b)) {
      if (__propIsEnum$15.call(b, prop))
        __defNormalProp$19(a, prop, b[prop]);
    }
  return a;
};
var __objRest$B = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$15.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$15)
    for (var prop of __getOwnPropSymbols$15(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$15.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function RenderUserContentAsHTML(_a) {
  var _b = _a, {
    component,
    content
  } = _b, rest = __objRest$B(_b, [
    "component",
    "content"
  ]);
  return React__default["default"].createElement(component || "span", __spreadValues$14({
    dangerouslySetInnerHTML: { __html: data.textUtil.sanitize(content) }
  }, rest));
}

const PercentChange = ({ percentChange, styles }) => {
  const percentChangeIcon = percentChange && (percentChange > 0 ? "arrow-up" : percentChange < 0 ? "arrow-down" : void 0);
  return /* @__PURE__ */ React__default["default"].createElement("div", { style: styles.containerStyles }, percentChangeIcon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: percentChangeIcon, height: styles.iconSize, width: styles.iconSize, viewBox: "6 6 12 12" }), percentChangeString(percentChange));
};
const percentChangeString = (percentChange) => {
  var _a;
  return (_a = percentChange == null ? void 0 : percentChange.toLocaleString(void 0, { style: "percent", maximumSignificantDigits: 3 })) != null ? _a : "";
};

var __defProp$18 = Object.defineProperty;
var __defProps$M = Object.defineProperties;
var __getOwnPropDescs$M = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$14 = Object.getOwnPropertySymbols;
var __hasOwnProp$14 = Object.prototype.hasOwnProperty;
var __propIsEnum$14 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$18 = (obj, key, value) => key in obj ? __defProp$18(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$13 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$14.call(b, prop))
      __defNormalProp$18(a, prop, b[prop]);
  if (__getOwnPropSymbols$14)
    for (var prop of __getOwnPropSymbols$14(b)) {
      if (__propIsEnum$14.call(b, prop))
        __defNormalProp$18(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$M = (a, b) => __defProps$M(a, __getOwnPropDescs$M(b));
var __publicField$a = (obj, key, value) => {
  __defNormalProp$18(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
const LINE_HEIGHT = 1.2;
const MAX_TITLE_SIZE = 30;
const VALUE_FONT_WEIGHT = 500;
class BigValueLayout {
  constructor(props) {
    this.props = props;
    __publicField$a(this, "titleFontSize");
    __publicField$a(this, "valueFontSize");
    __publicField$a(this, "chartHeight");
    __publicField$a(this, "chartWidth");
    __publicField$a(this, "valueColor");
    __publicField$a(this, "panelPadding");
    __publicField$a(this, "justifyCenter");
    __publicField$a(this, "titleToAlignTo");
    __publicField$a(this, "valueToAlignTo");
    __publicField$a(this, "maxTextWidth");
    __publicField$a(this, "maxTextHeight");
    __publicField$a(this, "textValues");
    var _a;
    const { width, height, value, text } = props;
    this.valueColor = (_a = value.color) != null ? _a : "gray";
    this.panelPadding = height > 100 ? 12 : 8;
    this.textValues = getTextValues(props);
    this.justifyCenter = shouldJustifyCenter(props.justifyMode, this.textValues.title);
    this.valueToAlignTo = this.textValues.valueToAlignTo;
    this.titleToAlignTo = this.textValues.titleToAlignTo;
    this.titleFontSize = 0;
    this.valueFontSize = 0;
    this.chartHeight = 0;
    this.chartWidth = 0;
    this.maxTextWidth = width - this.panelPadding * 2;
    this.maxTextHeight = height - this.panelPadding * 2;
    if (text) {
      if (text.titleSize) {
        this.titleFontSize = text.titleSize;
        this.titleToAlignTo = void 0;
      }
      if (text.valueSize) {
        this.valueFontSize = text.valueSize;
        this.valueToAlignTo = "";
      }
    }
  }
  getTitleStyles() {
    const styles = {
      fontSize: `${this.titleFontSize}px`,
      lineHeight: LINE_HEIGHT
    };
    if (this.props.colorMode === BigValueColorMode.Background || this.props.colorMode === BigValueColorMode.BackgroundSolid) {
      styles.color = getTextColorForAlphaBackground(this.valueColor, this.props.theme.isDark);
    }
    return styles;
  }
  getValueStyles() {
    const styles = {
      fontSize: this.valueFontSize,
      fontWeight: VALUE_FONT_WEIGHT,
      lineHeight: LINE_HEIGHT,
      position: "relative",
      zIndex: 1
    };
    if (this.justifyCenter) {
      styles.textAlign = "center";
    }
    switch (this.props.colorMode) {
      case BigValueColorMode.Value:
        styles.color = this.valueColor;
        break;
      case BigValueColorMode.Background:
      case BigValueColorMode.BackgroundSolid:
        styles.color = getTextColorForAlphaBackground(this.valueColor, this.props.theme.isDark);
        break;
      case BigValueColorMode.None:
        styles.color = this.props.theme.colors.text.primary;
        break;
    }
    return styles;
  }
  getPercentChangeStyles(percentChange) {
    const VALUE_TO_PERCENT_CHANGE_RATIO = 2.5;
    const valueContainerStyles = this.getValueAndTitleContainerStyles();
    const percentFontSize = Math.max(this.valueFontSize / VALUE_TO_PERCENT_CHANGE_RATIO, 12);
    let iconSize = Math.max(this.valueFontSize / 3, 10);
    const color = percentChange > 0 ? this.props.theme.visualization.getColorByName("green") : this.props.theme.visualization.getColorByName("red");
    const containerStyles = {
      fontSize: percentFontSize,
      fontWeight: VALUE_FONT_WEIGHT,
      lineHeight: LINE_HEIGHT,
      position: "relative",
      display: "flex",
      alignItems: "center",
      gap: Math.max(percentFontSize / 3, 4),
      zIndex: 1,
      color
    };
    if (this.justifyCenter) {
      containerStyles.textAlign = "center";
    }
    if (valueContainerStyles.flexDirection === "column" && percentFontSize > 12) {
      containerStyles.marginTop = -(percentFontSize / 4);
    }
    if (valueContainerStyles.flexDirection === "row") {
      containerStyles.alignItems = "baseline";
      containerStyles.lineHeight = LINE_HEIGHT * VALUE_TO_PERCENT_CHANGE_RATIO;
    }
    switch (this.props.colorMode) {
      case BigValueColorMode.Background:
      case BigValueColorMode.BackgroundSolid:
        containerStyles.color = getTextColorForAlphaBackground(this.valueColor, this.props.theme.isDark);
        break;
    }
    if (this.props.textMode === BigValueTextMode.None) {
      containerStyles.fontSize = calculateFontSize(
        percentChangeString(percentChange),
        this.maxTextWidth * 0.8,
        this.maxTextHeight * 0.8,
        LINE_HEIGHT,
        void 0,
        VALUE_FONT_WEIGHT
      );
      iconSize = containerStyles.fontSize * 0.8;
    }
    return {
      containerStyles,
      iconSize
    };
  }
  getValueAndTitleContainerStyles() {
    const styles = {
      display: "flex",
      flexWrap: "wrap"
    };
    if (this.justifyCenter) {
      styles.alignItems = "center";
      styles.justifyContent = "center";
      styles.flexGrow = 1;
      styles.gap = "0.75ch";
    }
    return styles;
  }
  getPanelStyles() {
    const { width, height, theme, colorMode, textMode } = this.props;
    const panelStyles = {
      width: `${width}px`,
      height: `${height}px`,
      padding: `${textMode === BigValueTextMode.None ? 2 : this.panelPadding}px`,
      borderRadius: theme.shape.radius.default,
      position: "relative",
      display: "flex"
    };
    const themeFactor = theme.isDark ? 1 : -0.7;
    switch (colorMode) {
      case BigValueColorMode.Background:
        const bgColor2 = tinycolor__default["default"](this.valueColor).darken(15 * themeFactor).spin(8).toRgbString();
        const bgColor3 = tinycolor__default["default"](this.valueColor).darken(5 * themeFactor).spin(-8).toRgbString();
        panelStyles.background = `linear-gradient(120deg, ${bgColor2}, ${bgColor3})`;
        break;
      case BigValueColorMode.BackgroundSolid:
        panelStyles.background = tinycolor__default["default"](this.valueColor).toString();
        break;
      case BigValueColorMode.Value:
        panelStyles.background = `transparent`;
        break;
    }
    if (this.justifyCenter) {
      panelStyles.alignItems = "center";
      panelStyles.flexDirection = "row";
    }
    return panelStyles;
  }
  renderChart() {
    var _a;
    const { sparkline, colorMode } = this.props;
    if (!sparkline || ((_a = sparkline.y) == null ? void 0 : _a.type) !== data.FieldType.number) {
      return null;
    }
    let fillColor;
    let lineColor;
    switch (colorMode) {
      case BigValueColorMode.Background:
      case BigValueColorMode.BackgroundSolid:
        fillColor = "rgba(255,255,255,0.4)";
        lineColor = tinycolor__default["default"](this.valueColor).brighten(40).toRgbString();
        break;
      case BigValueColorMode.None:
      case BigValueColorMode.Value:
      default:
        lineColor = this.valueColor;
        fillColor = tinycolor__default["default"](this.valueColor).setAlpha(0.2).toRgbString();
        break;
    }
    const config = {
      custom: {
        drawStyle: schema.GraphDrawStyle.Line,
        lineWidth: 1,
        fillColor,
        lineColor
      }
    };
    return /* @__PURE__ */ React__default["default"].createElement("div", { style: this.getChartStyles() }, /* @__PURE__ */ React__default["default"].createElement(
      Sparkline,
      {
        height: this.chartHeight,
        width: this.chartWidth,
        sparkline,
        config,
        theme: this.props.theme
      }
    ));
  }
  getChartStyles() {
    return {
      position: "absolute",
      right: 0,
      bottom: 0
    };
  }
}
class WideNoChartLayout extends BigValueLayout {
  constructor(props) {
    var _a, _b;
    super(props);
    const valueWidthPercent = ((_a = this.titleToAlignTo) == null ? void 0 : _a.length) ? 0.3 : 1;
    if (this.valueToAlignTo.length) {
      this.valueFontSize = calculateFontSize(
        this.valueToAlignTo,
        this.maxTextWidth * valueWidthPercent,
        this.maxTextHeight,
        LINE_HEIGHT,
        void 0,
        VALUE_FONT_WEIGHT
      );
    }
    if ((_b = this.titleToAlignTo) == null ? void 0 : _b.length) {
      this.titleFontSize = calculateFontSize(
        this.titleToAlignTo,
        this.maxTextWidth * 0.6,
        this.maxTextHeight,
        LINE_HEIGHT,
        MAX_TITLE_SIZE
      );
      this.titleFontSize = Math.min(this.valueFontSize * 0.7, this.titleFontSize);
    }
  }
  getValueAndTitleContainerStyles() {
    const styles = super.getValueAndTitleContainerStyles();
    styles.flexDirection = "row";
    styles.alignItems = "center";
    styles.flexGrow = 1;
    if (!this.justifyCenter) {
      styles.justifyContent = "space-between";
    }
    return styles;
  }
  renderChart() {
    return null;
  }
  getPanelStyles() {
    const panelStyles = super.getPanelStyles();
    panelStyles.alignItems = "center";
    return panelStyles;
  }
}
class WideWithChartLayout extends BigValueLayout {
  constructor(props) {
    var _a;
    super(props);
    const { width, height } = props;
    const chartHeightPercent = 0.5;
    const titleWidthPercent = 0.6;
    const valueWidthPercent = 1 - titleWidthPercent;
    const textHeightPercent = 0.4;
    this.chartWidth = width;
    this.chartHeight = height * chartHeightPercent;
    if ((_a = this.titleToAlignTo) == null ? void 0 : _a.length) {
      this.titleFontSize = calculateFontSize(
        this.titleToAlignTo,
        this.maxTextWidth * titleWidthPercent,
        this.maxTextHeight * textHeightPercent,
        LINE_HEIGHT,
        MAX_TITLE_SIZE
      );
    }
    if (this.valueToAlignTo.length) {
      this.valueFontSize = calculateFontSize(
        this.valueToAlignTo,
        this.maxTextWidth * valueWidthPercent,
        this.maxTextHeight * chartHeightPercent,
        LINE_HEIGHT,
        void 0,
        VALUE_FONT_WEIGHT
      );
    }
  }
  getValueAndTitleContainerStyles() {
    const styles = super.getValueAndTitleContainerStyles();
    styles.flexDirection = "row";
    styles.flexGrow = 1;
    if (!this.justifyCenter) {
      styles.justifyContent = "space-between";
    }
    return styles;
  }
  getPanelStyles() {
    const styles = super.getPanelStyles();
    styles.flexDirection = "row";
    styles.justifyContent = "space-between";
    return styles;
  }
}
class StackedWithChartLayout extends BigValueLayout {
  constructor(props) {
    var _a, _b;
    super(props);
    const { width, height } = props;
    const titleHeightPercent = 0.15;
    const chartHeightPercent = 0.25;
    let titleHeight = 0;
    this.chartHeight = height * chartHeightPercent;
    this.chartWidth = width;
    if ((_a = this.titleToAlignTo) == null ? void 0 : _a.length) {
      this.titleFontSize = calculateFontSize(
        this.titleToAlignTo,
        this.maxTextWidth,
        height * titleHeightPercent,
        LINE_HEIGHT,
        MAX_TITLE_SIZE
      );
      titleHeight = this.titleFontSize * LINE_HEIGHT;
    }
    if (this.valueToAlignTo.length) {
      this.valueFontSize = calculateFontSize(
        this.valueToAlignTo,
        this.maxTextWidth,
        this.maxTextHeight - this.chartHeight - titleHeight,
        LINE_HEIGHT,
        void 0,
        VALUE_FONT_WEIGHT
      );
    }
    if ((_b = this.titleToAlignTo) == null ? void 0 : _b.length) {
      this.titleFontSize = Math.min(this.valueFontSize * 0.7, this.titleFontSize);
    }
    this.chartHeight = height - this.titleFontSize * LINE_HEIGHT - this.valueFontSize * LINE_HEIGHT;
  }
  getValueAndTitleContainerStyles() {
    const styles = super.getValueAndTitleContainerStyles();
    styles.flexDirection = "column";
    styles.justifyContent = "center";
    return styles;
  }
  getPanelStyles() {
    const styles = super.getPanelStyles();
    styles.flexDirection = "column";
    return styles;
  }
}
class StackedWithNoChartLayout extends BigValueLayout {
  constructor(props) {
    var _a, _b;
    super(props);
    const { height } = props;
    const titleHeightPercent = 0.15;
    let titleHeight = 0;
    if ((_a = this.titleToAlignTo) == null ? void 0 : _a.length) {
      this.titleFontSize = calculateFontSize(
        this.titleToAlignTo,
        this.maxTextWidth,
        height * titleHeightPercent,
        LINE_HEIGHT,
        MAX_TITLE_SIZE
      );
      titleHeight = this.titleFontSize * LINE_HEIGHT;
    }
    if (this.valueToAlignTo.length) {
      this.valueFontSize = calculateFontSize(
        this.valueToAlignTo,
        this.maxTextWidth,
        this.maxTextHeight - titleHeight,
        LINE_HEIGHT,
        void 0,
        VALUE_FONT_WEIGHT
      );
    }
    if ((_b = this.titleToAlignTo) == null ? void 0 : _b.length) {
      this.titleFontSize = Math.min(this.valueFontSize * 0.7, this.titleFontSize);
    }
  }
  getValueAndTitleContainerStyles() {
    const styles = super.getValueAndTitleContainerStyles();
    styles.flexDirection = "column";
    styles.flexGrow = 1;
    return styles;
  }
  renderChart() {
    return null;
  }
  getPanelStyles() {
    const styles = super.getPanelStyles();
    styles.alignItems = "center";
    return styles;
  }
}
function buildLayout(props) {
  const { width, height, sparkline } = props;
  const useWideLayout = width / height > 2.5 && !props.disableWideLayout;
  if (useWideLayout) {
    if (height > 50 && !!sparkline && sparkline.y.values.length > 1) {
      return new WideWithChartLayout(props);
    } else {
      return new WideNoChartLayout(props);
    }
  }
  if (height > 100 && sparkline && sparkline.y.values.length > 1) {
    return new StackedWithChartLayout(props);
  } else {
    return new StackedWithNoChartLayout(props);
  }
}
function shouldJustifyCenter(justifyMode, title) {
  if (justifyMode === BigValueJustifyMode.Center) {
    return true;
  }
  return (title != null ? title : "").length === 0;
}
function getTextValues(props) {
  const { value, alignmentFactors, count } = props;
  let { textMode } = props;
  const titleToAlignTo = alignmentFactors ? alignmentFactors.title : value.title;
  const valueToAlignTo = data.formattedValueToString(alignmentFactors ? alignmentFactors : value);
  if (textMode === BigValueTextMode.Auto && (count != null ? count : 1) === 1) {
    textMode = BigValueTextMode.Value;
  }
  switch (textMode) {
    case BigValueTextMode.Name:
      return __spreadProps$M(__spreadValues$13({}, value), {
        title: void 0,
        prefix: void 0,
        suffix: void 0,
        text: value.title || "",
        titleToAlignTo: void 0,
        valueToAlignTo: titleToAlignTo != null ? titleToAlignTo : "",
        tooltip: data.formattedValueToString(value)
      });
    case BigValueTextMode.Value:
      return __spreadProps$M(__spreadValues$13({}, value), {
        title: void 0,
        titleToAlignTo: void 0,
        valueToAlignTo,
        tooltip: value.title
      });
    case BigValueTextMode.None:
      return {
        numeric: value.numeric,
        color: value.color,
        title: void 0,
        text: "",
        titleToAlignTo: void 0,
        valueToAlignTo: "1",
        tooltip: `Name: ${value.title}
Value: ${data.formattedValueToString(value)}`
      };
    case BigValueTextMode.ValueAndName:
    default:
      return __spreadProps$M(__spreadValues$13({}, value), {
        titleToAlignTo,
        valueToAlignTo
      });
  }
}

var __defProp$17 = Object.defineProperty;
var __defNormalProp$17 = (obj, key, value) => key in obj ? __defProp$17(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$9 = (obj, key, value) => {
  __defNormalProp$17(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
var BigValueColorMode = /* @__PURE__ */ ((BigValueColorMode2) => {
  BigValueColorMode2["Background"] = "background";
  BigValueColorMode2["BackgroundSolid"] = "background_solid";
  BigValueColorMode2["None"] = "none";
  BigValueColorMode2["Value"] = "value";
  return BigValueColorMode2;
})(BigValueColorMode || {});
var BigValueGraphMode = /* @__PURE__ */ ((BigValueGraphMode2) => {
  BigValueGraphMode2["None"] = "none";
  BigValueGraphMode2["Line"] = "line";
  BigValueGraphMode2["Area"] = "area";
  return BigValueGraphMode2;
})(BigValueGraphMode || {});
var BigValueJustifyMode = /* @__PURE__ */ ((BigValueJustifyMode2) => {
  BigValueJustifyMode2["Auto"] = "auto";
  BigValueJustifyMode2["Center"] = "center";
  return BigValueJustifyMode2;
})(BigValueJustifyMode || {});
var BigValueTextMode = /* @__PURE__ */ ((BigValueTextMode2) => {
  BigValueTextMode2["Auto"] = "auto";
  BigValueTextMode2["Value"] = "value";
  BigValueTextMode2["ValueAndName"] = "value_and_name";
  BigValueTextMode2["Name"] = "name";
  BigValueTextMode2["None"] = "none";
  return BigValueTextMode2;
})(BigValueTextMode || {});
class BigValue extends React.PureComponent {
  render() {
    const { onClick, className, hasLinks, theme } = this.props;
    const layout = buildLayout(this.props);
    const panelStyles = layout.getPanelStyles();
    const valueAndTitleContainerStyles = layout.getValueAndTitleContainerStyles();
    const valueStyles = layout.getValueStyles();
    const titleStyles = layout.getTitleStyles();
    const textValues = layout.textValues;
    const percentChange = this.props.value.percentChange;
    const showPercentChange = percentChange != null && !Number.isNaN(percentChange);
    const tooltip = hasLinks ? void 0 : textValues.tooltip;
    if (!onClick) {
      return /* @__PURE__ */ React__default["default"].createElement("div", { className, style: panelStyles, title: tooltip }, /* @__PURE__ */ React__default["default"].createElement("div", { style: valueAndTitleContainerStyles }, textValues.title && /* @__PURE__ */ React__default["default"].createElement("div", { style: titleStyles }, textValues.title), /* @__PURE__ */ React__default["default"].createElement(FormattedValueDisplay, { value: textValues, style: valueStyles }), showPercentChange && /* @__PURE__ */ React__default["default"].createElement(PercentChange, { percentChange, styles: layout.getPercentChangeStyles(percentChange) })), layout.renderChart());
    }
    return /* @__PURE__ */ React__default["default"].createElement(
      "button",
      {
        type: "button",
        className: css.cx(clearButtonStyles(theme), className),
        style: panelStyles,
        onClick,
        title: tooltip
      },
      /* @__PURE__ */ React__default["default"].createElement("div", { style: valueAndTitleContainerStyles }, textValues.title && /* @__PURE__ */ React__default["default"].createElement("div", { style: titleStyles }, textValues.title), /* @__PURE__ */ React__default["default"].createElement(FormattedValueDisplay, { value: textValues, style: valueStyles })),
      layout.renderChart()
    );
  }
}
__publicField$9(BigValue, "defaultProps", {
  justifyMode: "auto" /* Auto */
});

const DEFAULT_THRESHOLDS = {
  mode: data.ThresholdsMode.Absolute,
  steps: [
    { value: -Infinity, color: "green" },
    { value: 80, color: "red" }
  ]
};
function calculateGaugeAutoProps(width, height, title, orientation) {
  const showLabel = title !== null && title !== void 0;
  const titleFontSizeDimension = orientation === schema.VizOrientation.Vertical ? height : width;
  const titleFontSize = Math.min(titleFontSizeDimension * 0.15 / 1.5, 20);
  const titleHeight = titleFontSize * 1.5;
  const availableHeight = showLabel ? height - titleHeight : height;
  const gaugeHeight = Math.min(availableHeight, width);
  return {
    showLabel,
    gaugeHeight,
    titleFontSize
  };
}
function getFormattedThresholds(decimals, field, value, theme) {
  var _a, _b, _c, _d, _e, _f;
  if (((_a = field.color) == null ? void 0 : _a.mode) !== data.FieldColorModeId.Thresholds) {
    return [{ value: (_b = field.min) != null ? _b : data.GAUGE_DEFAULT_MINIMUM, color: (_c = value.color) != null ? _c : data.FALLBACK_COLOR }];
  }
  const thresholds = (_d = field.thresholds) != null ? _d : DEFAULT_THRESHOLDS;
  const isPercent = thresholds.mode === data.ThresholdsMode.Percentage;
  const steps = thresholds.steps;
  let min = (_e = field.min) != null ? _e : data.GAUGE_DEFAULT_MINIMUM;
  let max = (_f = field.max) != null ? _f : data.GAUGE_DEFAULT_MAXIMUM;
  if (isPercent) {
    min = 0;
    max = 100;
  }
  const first = data.getActiveThreshold(min, steps);
  const last = data.getActiveThreshold(max, steps);
  const formatted = [
    { value: +min.toFixed(decimals), color: theme.visualization.getColorByName(first.color) }
  ];
  let skip = true;
  for (let i = 0; i < steps.length; i++) {
    const step = steps[i];
    if (skip) {
      if (first === step) {
        skip = false;
      }
      continue;
    }
    const prev = steps[i - 1];
    formatted.push({ value: step.value, color: theme.visualization.getColorByName(prev.color) });
    if (step === last) {
      break;
    }
  }
  formatted.push({ value: +max.toFixed(decimals), color: theme.visualization.getColorByName(last.color) });
  return formatted;
}

var __defProp$16 = Object.defineProperty;
var __defNormalProp$16 = (obj, key, value) => key in obj ? __defProp$16(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$8 = (obj, key, value) => {
  __defNormalProp$16(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
class Gauge extends React.PureComponent {
  constructor() {
    super(...arguments);
    __publicField$8(this, "canvasElement", null);
    __publicField$8(this, "renderVisualization", () => {
      var _a;
      const { width, value, height, onClick, text, theme, orientation } = this.props;
      const autoProps = calculateGaugeAutoProps(width, height, value.title, orientation);
      const gaugeWidth = orientation === schema.VizOrientation.Vertical ? `${autoProps.gaugeHeight}px` : "100%";
      const gaugeElement = /* @__PURE__ */ React__default["default"].createElement(
        "div",
        {
          style: { height: `${autoProps.gaugeHeight}px`, width: gaugeWidth },
          ref: (element) => this.canvasElement = element
        }
      );
      return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, onClick ? /* @__PURE__ */ React__default["default"].createElement("button", { className: clearButtonStyles(theme), type: "button", onClick }, gaugeElement) : gaugeElement, autoProps.showLabel && /* @__PURE__ */ React__default["default"].createElement(
        "div",
        {
          style: {
            textAlign: "center",
            fontSize: (_a = text == null ? void 0 : text.titleSize) != null ? _a : autoProps.titleFontSize,
            overflow: "hidden",
            textOverflow: "ellipsis",
            whiteSpace: "nowrap",
            position: "relative",
            width: gaugeWidth,
            top: "-4px",
            cursor: "default"
          }
        },
        value.title
      ));
    });
  }
  componentDidMount() {
    this.draw();
  }
  componentDidUpdate() {
    this.draw();
  }
  draw() {
    var _a, _b, _c, _d, _e, _f;
    const { field, showThresholdLabels, showThresholdMarkers, width, height, theme, value, orientation } = this.props;
    const autoProps = calculateGaugeAutoProps(width, height, value.title);
    const calculatedGaugeWidth = orientation === schema.VizOrientation.Vertical ? autoProps.gaugeHeight : width;
    const dimension = Math.min(calculatedGaugeWidth, autoProps.gaugeHeight);
    const backgroundColor = theme.colors.background.secondary;
    const gaugeWidthReduceRatio = showThresholdLabels ? 1.5 : 1;
    const gaugeWidth = Math.min(dimension / 5.5, 40) / gaugeWidthReduceRatio;
    const thresholdMarkersWidth = gaugeWidth / 5;
    const text = data.formattedValueToString(value);
    const valueWidthBase = Math.min(calculatedGaugeWidth, dimension * 1.3) * 0.9;
    const valueWidth = valueWidthBase - ((gaugeWidth + (showThresholdMarkers ? thresholdMarkersWidth : 0) + (showThresholdLabels ? 10 : 0)) * 2 + 10);
    const fontSize = (_b = (_a = this.props.text) == null ? void 0 : _a.valueSize) != null ? _b : calculateFontSize(text, valueWidth, dimension, 1, gaugeWidth * 1.7);
    const thresholdLabelFontSize = Math.max(fontSize / 2.5, 12);
    let min = (_c = field.min) != null ? _c : data.GAUGE_DEFAULT_MINIMUM;
    let max = (_d = field.max) != null ? _d : data.GAUGE_DEFAULT_MAXIMUM;
    let numeric = value.numeric;
    if (((_e = field.thresholds) == null ? void 0 : _e.mode) === data.ThresholdsMode.Percentage) {
      min = 0;
      max = 100;
      if (value.percent === void 0) {
        numeric = (numeric - min) / (max - min) * 100;
      } else {
        numeric = value.percent * 100;
      }
    }
    const decimals = field.decimals === void 0 ? 2 : field.decimals;
    if (showThresholdMarkers) {
      min = +min.toFixed(decimals);
      max = +max.toFixed(decimals);
    }
    const options = {
      series: {
        gauges: {
          gauge: {
            min,
            max,
            neutralValue: (_f = field.custom) == null ? void 0 : _f.neutral,
            background: { color: backgroundColor },
            border: { color: null },
            shadow: { show: false },
            width: gaugeWidth
          },
          frame: { show: false },
          label: { show: false },
          layout: { margin: 0, thresholdWidth: 0, vMargin: 0 },
          cell: { border: { width: 0 } },
          threshold: {
            values: getFormattedThresholds(decimals, field, value, theme),
            label: {
              show: showThresholdLabels,
              margin: thresholdMarkersWidth + 1,
              font: { size: thresholdLabelFontSize }
            },
            show: showThresholdMarkers,
            width: thresholdMarkersWidth
          },
          value: {
            color: value.color,
            formatter: () => {
              return text;
            },
            font: { size: fontSize, family: theme.typography.fontFamily }
          },
          show: true
        }
      }
    };
    const plotSeries = {
      data: [[0, numeric]],
      label: value.title
    };
    try {
      if (this.canvasElement) {
        $__default["default"].plot(this.canvasElement, [plotSeries], options);
      }
    } catch (err) {
      console.error("Gauge rendering error", err, options, value);
    }
  }
  render() {
    return /* @__PURE__ */ React__default["default"].createElement(
      "div",
      {
        style: {
          width: "100%",
          height: "100%",
          display: "flex",
          flexDirection: "column",
          justifyContent: "center",
          overflow: "hidden"
        },
        className: this.props.className
      },
      this.renderVisualization()
    );
  }
}
__publicField$8(Gauge, "defaultProps", {
  showThresholdMarkers: true,
  showThresholdLabels: false,
  field: {
    min: 0,
    max: 100,
    thresholds: DEFAULT_THRESHOLDS
  }
});

const calculateTooltipPosition = (xPos = 0, yPos = 0, tooltipWidth = 0, tooltipHeight = 0, xOffset = 0, yOffset = 0, windowWidth = 0, windowHeight = 0) => {
  let x = xPos;
  let y = yPos;
  const overflowRight = Math.max(xPos + xOffset + tooltipWidth - (windowWidth - xOffset), 0);
  const overflowLeft = Math.abs(Math.min(xPos - xOffset - tooltipWidth - xOffset, 0));
  const wouldOverflowRight = overflowRight > 0;
  const wouldOverflowLeft = overflowLeft > 0;
  const overflowBelow = Math.max(yPos + yOffset + tooltipHeight - (windowHeight - yOffset), 0);
  const overflowAbove = Math.abs(Math.min(yPos - yOffset - tooltipHeight - yOffset, 0));
  const wouldOverflowBelow = overflowBelow > 0;
  const wouldOverflowAbove = overflowAbove > 0;
  if (wouldOverflowRight && wouldOverflowLeft) {
    x = overflowRight > overflowLeft ? xOffset : windowWidth - xOffset - tooltipWidth;
  } else if (wouldOverflowRight) {
    x = xPos - xOffset - tooltipWidth;
  } else {
    x = xPos + xOffset;
  }
  if (wouldOverflowBelow && wouldOverflowAbove) {
    y = overflowBelow > overflowAbove ? yOffset : windowHeight - yOffset - tooltipHeight;
  } else if (wouldOverflowBelow) {
    y = yPos - yOffset - tooltipHeight;
  } else {
    y = yPos + yOffset;
  }
  return { x, y };
};

var __defProp$15 = Object.defineProperty;
var __defProps$L = Object.defineProperties;
var __getOwnPropDescs$L = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$13 = Object.getOwnPropertySymbols;
var __hasOwnProp$13 = Object.prototype.hasOwnProperty;
var __propIsEnum$13 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$15 = (obj, key, value) => key in obj ? __defProp$15(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$12 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$13.call(b, prop))
      __defNormalProp$15(a, prop, b[prop]);
  if (__getOwnPropSymbols$13)
    for (var prop of __getOwnPropSymbols$13(b)) {
      if (__propIsEnum$13.call(b, prop))
        __defNormalProp$15(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$L = (a, b) => __defProps$L(a, __getOwnPropDescs$L(b));
var __objRest$A = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$13.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$13)
    for (var prop of __getOwnPropSymbols$13(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$13.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const VizTooltipContainer = (_a) => {
  var _b = _a, {
    position: { x: positionX, y: positionY },
    offset: { x: offsetX, y: offsetY },
    children,
    allowPointerEvents = false,
    className
  } = _b, otherProps = __objRest$A(_b, [
    "position",
    "offset",
    "children",
    "allowPointerEvents",
    "className"
  ]);
  const tooltipRef = React.useRef(null);
  const [tooltipMeasurement, setTooltipMeasurement] = React.useState({ width: 0, height: 0 });
  const { width, height } = reactUse.useWindowSize();
  const [placement, setPlacement] = React.useState({
    x: positionX + offsetX,
    y: positionY + offsetY
  });
  const resizeObserver = React.useMemo(
    () => (
      // TS has hard time playing games with @types/resize-observer-browser, hence the ignore
      // @ts-ignore
      new ResizeObserver((entries) => {
        for (let entry of entries) {
          const tW = Math.floor(entry.contentRect.width + 2 * 8);
          const tH = Math.floor(entry.contentRect.height + 2 * 8);
          if (tooltipMeasurement.width !== tW || tooltipMeasurement.height !== tH) {
            setTooltipMeasurement({
              width: Math.min(tW, width),
              height: Math.min(tH, height)
            });
          }
        }
      })
    ),
    [tooltipMeasurement, width, height]
  );
  React.useLayoutEffect(() => {
    if (tooltipRef.current) {
      resizeObserver.observe(tooltipRef.current);
    }
    return () => {
      resizeObserver.disconnect();
    };
  }, [resizeObserver]);
  React.useLayoutEffect(() => {
    if (tooltipRef && tooltipRef.current) {
      const { x, y } = calculateTooltipPosition(
        positionX,
        positionY,
        tooltipMeasurement.width,
        tooltipMeasurement.height,
        offsetX,
        offsetY,
        width,
        height
      );
      setPlacement({ x, y });
    }
  }, [width, height, positionX, offsetX, positionY, offsetY, tooltipMeasurement]);
  const styles = useStyles2(getStyles$G);
  return /* @__PURE__ */ React__default["default"].createElement(
    "div",
    __spreadProps$L(__spreadValues$12({
      ref: tooltipRef,
      style: {
        position: "fixed",
        left: 0,
        // disabling pointer-events is to prevent the tooltip from flickering when moving left to right
        // see e.g. https://github.com/grafana/grafana/pull/33609
        pointerEvents: allowPointerEvents ? "auto" : "none",
        top: 0,
        transform: `translate(${placement.x}px, ${placement.y}px)`,
        transition: "transform ease-out 0.1s"
      },
      "aria-live": "polite",
      "aria-atomic": "true"
    }, otherProps), {
      className: css.cx(styles.wrapper, className)
    }),
    children
  );
};
VizTooltipContainer.displayName = "VizTooltipContainer";
const getStyles$G = (theme) => ({
  wrapper: css.css(getTooltipContainerStyles(theme))
});

const VizTooltip = ({ content, position, offset }) => {
  const styles = useStyles2(getStyles$F);
  if (position) {
    return /* @__PURE__ */ React__default["default"].createElement(Portal$1, { className: styles.portal }, /* @__PURE__ */ React__default["default"].createElement(VizTooltipContainer, { position, offset: offset || { x: 0, y: 0 } }, content));
  }
  return null;
};
VizTooltip.displayName = "VizTooltip";
const getStyles$F = () => {
  return {
    portal: css.css({
      position: "absolute",
      top: 0,
      left: 0,
      pointerEvents: "none",
      width: "100%",
      height: "100%"
    })
  };
};

var __defProp$14 = Object.defineProperty;
var __getOwnPropSymbols$12 = Object.getOwnPropertySymbols;
var __hasOwnProp$12 = Object.prototype.hasOwnProperty;
var __propIsEnum$12 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$14 = (obj, key, value) => key in obj ? __defProp$14(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$11 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$12.call(b, prop))
      __defNormalProp$14(a, prop, b[prop]);
  if (__getOwnPropSymbols$12)
    for (var prop of __getOwnPropSymbols$12(b)) {
      if (__propIsEnum$12.call(b, prop))
        __defNormalProp$14(a, prop, b[prop]);
    }
  return a;
};
var __objRest$z = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$12.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$12)
    for (var prop of __getOwnPropSymbols$12(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$12.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const SeriesIcon = React__default["default"].memo(
  React__default["default"].forwardRef((_a, ref) => {
    var _b = _a, { color, className, gradient } = _b, restProps = __objRest$z(_b, ["color", "className", "gradient"]);
    var _a2, _b2;
    const theme = useTheme2();
    const styles2 = useStyles2(getStyles$E);
    let cssColor;
    if (gradient) {
      const colors = (_b2 = (_a2 = data.fieldColorModeRegistry.get(gradient)).getColors) == null ? void 0 : _b2.call(_a2, theme);
      if (colors == null ? void 0 : colors.length) {
        cssColor = `linear-gradient(90deg, ${colors.join(", ")})`;
      } else {
        cssColor = theme.visualization.getColorByName("");
      }
    } else {
      cssColor = color;
    }
    const styles = {
      background: cssColor,
      width: "14px",
      height: "4px",
      borderRadius: theme.shape.radius.pill,
      display: "inline-block",
      marginRight: "8px"
    };
    return /* @__PURE__ */ React__default["default"].createElement(
      "div",
      __spreadValues$11({
        "data-testid": "series-icon",
        ref,
        className: css.cx(className, styles2.forcedColors),
        style: styles
      }, restProps)
    );
  })
);
const getStyles$E = () => ({
  forcedColors: css.css({
    "@media (forced-colors: active)": {
      forcedColorAdjust: "none"
    }
  })
});
SeriesIcon.displayName = "SeriesIcon";

const getSeriesTableRowStyles = (theme) => {
  return {
    icon: css.css({
      marginRight: theme.spacing(1),
      verticalAlign: "middle"
    }),
    seriesTable: css.css({
      display: "table"
    }),
    seriesTableRow: css.css({
      display: "table-row",
      fontSize: theme.typography.bodySmall.fontSize
    }),
    seriesTableCell: css.css({
      display: "table-cell"
    }),
    label: css.css({
      wordBreak: "break-all"
    }),
    value: css.css({
      paddingLeft: theme.spacing(2),
      textAlign: "right"
    }),
    activeSeries: css.css({
      fontWeight: theme.typography.fontWeightBold,
      color: theme.colors.text.maxContrast
    }),
    timestamp: css.css({
      fontWeight: theme.typography.fontWeightBold,
      fontSize: theme.typography.bodySmall.fontSize
    })
  };
};
const SeriesTableRow = ({ color, label, value, isActive }) => {
  const styles = useStyles2(getSeriesTableRowStyles);
  return /* @__PURE__ */ React__default["default"].createElement("div", { "data-testid": "SeriesTableRow", className: css.cx(styles.seriesTableRow, isActive && styles.activeSeries) }, color && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.seriesTableCell }, /* @__PURE__ */ React__default["default"].createElement(SeriesIcon, { color, className: styles.icon })), label && /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.seriesTableCell, styles.label) }, label), value && /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.seriesTableCell, styles.value) }, value));
};
const SeriesTable = ({ timestamp, series }) => {
  const styles = useStyles2(getSeriesTableRowStyles);
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, timestamp && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.timestamp, "aria-label": "Timestamp" }, timestamp), series.map((s, i) => {
    return /* @__PURE__ */ React__default["default"].createElement(
      SeriesTableRow,
      {
        isActive: s.isActive,
        label: s.label,
        color: s.color,
        value: s.value,
        key: `${s.label}-${i}`
      }
    );
  }));
};

const calculateGridDimensions = (parentWidth, parentHeight, itemSpacing, numberOfChildren) => {
  const vertical = calculateSizeOfChild(parentWidth, parentHeight, numberOfChildren);
  const horizontal = calculateSizeOfChild(parentHeight, parentWidth, numberOfChildren);
  const square = Math.max(vertical, horizontal);
  let xCount = Math.floor(parentWidth / square);
  let yCount = Math.ceil(numberOfChildren / xCount);
  xCount = Math.ceil(numberOfChildren / yCount);
  const itemsOnLastRow = xCount - (xCount * yCount - numberOfChildren);
  const widthOnLastRow = parentWidth / itemsOnLastRow - itemSpacing + itemSpacing / itemsOnLastRow;
  return {
    width: parentWidth / xCount - itemSpacing + itemSpacing / xCount,
    height: parentHeight / yCount - itemSpacing + itemSpacing / yCount,
    widthOnLastRow,
    xCount,
    yCount
  };
};
function calculateSizeOfChild(parentWidth, parentHeight, numberOfChildren) {
  const parts = Math.ceil(Math.sqrt(numberOfChildren * parentWidth / parentHeight));
  if (Math.floor(parts * parentHeight / parentWidth) * parts < numberOfChildren) {
    return parentHeight / Math.ceil(parts * parentHeight / parentWidth);
  }
  return parentWidth / parts;
}

var __defProp$13 = Object.defineProperty;
var __defProps$K = Object.defineProperties;
var __getOwnPropDescs$K = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$11 = Object.getOwnPropertySymbols;
var __hasOwnProp$11 = Object.prototype.hasOwnProperty;
var __propIsEnum$11 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$13 = (obj, key, value) => key in obj ? __defProp$13(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$10 = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$11.call(b, prop))
      __defNormalProp$13(a, prop, b[prop]);
  if (__getOwnPropSymbols$11)
    for (var prop of __getOwnPropSymbols$11(b)) {
      if (__propIsEnum$11.call(b, prop))
        __defNormalProp$13(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$K = (a, b) => __defProps$K(a, __getOwnPropDescs$K(b));
var __publicField$7 = (obj, key, value) => {
  __defNormalProp$13(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
class VizRepeater extends React.PureComponent {
  constructor(props) {
    super(props);
    this.state = {
      values: props.getValues()
    };
  }
  componentDidUpdate(prevProps) {
    const { renderCounter, source } = this.props;
    if (renderCounter !== prevProps.renderCounter || source !== prevProps.source) {
      this.setState({ values: this.props.getValues() });
    }
  }
  getOrientation() {
    const { orientation, width, height } = this.props;
    if (orientation === data.VizOrientation.Auto) {
      if (width > height) {
        return data.VizOrientation.Vertical;
      } else {
        return data.VizOrientation.Horizontal;
      }
    }
    return orientation;
  }
  renderGrid() {
    const { renderValue, height, width, itemSpacing, getAlignmentFactors, orientation } = this.props;
    const { values } = this.state;
    const grid = calculateGridDimensions(width, height, itemSpacing, values.length);
    const alignmentFactors = getAlignmentFactors ? getAlignmentFactors(values, grid.width, grid.height) : {};
    let xGrid = 0;
    let yGrid = 0;
    let items = [];
    for (let i = 0; i < values.length; i++) {
      const value = values[i];
      const isLastRow = yGrid === grid.yCount - 1;
      const itemWidth = isLastRow ? grid.widthOnLastRow : grid.width;
      const itemHeight = grid.height;
      const xPos = xGrid * itemWidth + itemSpacing * xGrid;
      const yPos = yGrid * itemHeight + itemSpacing * yGrid;
      const itemStyles = {
        position: "absolute",
        left: xPos,
        top: yPos,
        width: `${itemWidth}px`,
        height: `${itemHeight}px`
      };
      items.push(
        /* @__PURE__ */ React__default["default"].createElement("div", { key: i, style: itemStyles }, renderValue({
          value,
          width: itemWidth,
          height: itemHeight,
          alignmentFactors,
          orientation,
          count: values.length
        }))
      );
      xGrid++;
      if (xGrid === grid.xCount) {
        xGrid = 0;
        yGrid++;
      }
    }
    return /* @__PURE__ */ React__default["default"].createElement("div", { style: { position: "relative" } }, items);
  }
  render() {
    const {
      renderValue,
      height,
      width,
      itemSpacing,
      getAlignmentFactors,
      autoGrid,
      orientation,
      maxVizHeight,
      minVizWidth,
      minVizHeight
    } = this.props;
    const { values } = this.state;
    if (autoGrid && orientation === data.VizOrientation.Auto) {
      return this.renderGrid();
    }
    const itemStyles = {
      display: "flex"
    };
    const repeaterStyle = {
      display: "flex",
      overflow: `${minVizWidth ? "auto" : "hidden"} ${minVizHeight ? "auto" : "hidden"}`
    };
    let vizHeight = height;
    let vizWidth = width;
    const resolvedOrientation = this.getOrientation();
    switch (resolvedOrientation) {
      case data.VizOrientation.Horizontal:
        const defaultVizHeight = (height + itemSpacing) / values.length - itemSpacing;
        repeaterStyle.flexDirection = "column";
        repeaterStyle.height = `${height}px`;
        itemStyles.marginBottom = `${itemSpacing}px`;
        vizWidth = width;
        vizHeight = lodash.clamp(defaultVizHeight, minVizHeight != null ? minVizHeight : 0, maxVizHeight != null ? maxVizHeight : defaultVizHeight);
        break;
      case data.VizOrientation.Vertical:
        repeaterStyle.flexDirection = "row";
        repeaterStyle.justifyContent = "space-between";
        itemStyles.marginRight = `${itemSpacing}px`;
        vizHeight = height;
        vizWidth = Math.max(width / values.length - itemSpacing + itemSpacing / values.length, minVizWidth != null ? minVizWidth : 0);
    }
    itemStyles.width = `${vizWidth}px`;
    itemStyles.height = `${vizHeight}px`;
    const alignmentFactors = getAlignmentFactors ? getAlignmentFactors(values, vizWidth, vizHeight) : {};
    return /* @__PURE__ */ React__default["default"].createElement("div", { style: repeaterStyle }, values.map((value, index) => {
      return /* @__PURE__ */ React__default["default"].createElement("div", { key: index, style: getItemStylesForIndex(itemStyles, index, values.length) }, renderValue({
        value,
        width: vizWidth,
        height: vizHeight,
        alignmentFactors,
        orientation: resolvedOrientation,
        count: values.length
      }));
    }));
  }
}
__publicField$7(VizRepeater, "defaultProps", {
  itemSpacing: 8
});
function getItemStylesForIndex(itemStyles, index, length) {
  if (index === length - 1) {
    return __spreadProps$K(__spreadValues$10({}, itemStyles), {
      marginRight: 0,
      marginBottom: 0
    });
  }
  return itemStyles;
}

const VizLayout = ({ width, height, legend, children }) => {
  const theme = useTheme2();
  const styles = useStyles2(getVizStyles);
  const containerStyle = {
    display: "flex",
    width: `${width}px`,
    height: `${height}px`
  };
  const [legendRef, legendMeasure] = reactUse.useMeasure();
  if (!legend) {
    return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("div", { style: containerStyle, className: styles.viz }, children(width, height)));
  }
  let { placement, maxHeight = "35%", maxWidth = "60%" } = legend.props;
  if (document.body.clientWidth < theme.breakpoints.values.lg) {
    placement = "bottom";
  }
  let size = null;
  const legendStyle = {};
  switch (placement) {
    case "bottom":
      containerStyle.flexDirection = "column";
      legendStyle.maxHeight = maxHeight;
      if (legendMeasure.height) {
        size = { width, height: height - legendMeasure.height };
      }
      break;
    case "right":
      containerStyle.flexDirection = "row";
      legendStyle.maxWidth = maxWidth;
      if (legendMeasure.width) {
        size = { width: width - legendMeasure.width, height };
      }
      if (legend.props.width) {
        legendStyle.width = legend.props.width;
        size = { width: width - legend.props.width, height };
      }
      break;
  }
  if ((size == null ? void 0 : size.width) === 0) {
    size.width = width;
  }
  if ((size == null ? void 0 : size.height) === 0) {
    size.height = height;
  }
  return /* @__PURE__ */ React__default["default"].createElement("div", { style: containerStyle }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.viz }, size && children(size.width, size.height)), /* @__PURE__ */ React__default["default"].createElement("div", { style: legendStyle, ref: legendRef }, /* @__PURE__ */ React__default["default"].createElement(CustomScrollbar, { hideHorizontalTrack: true }, legend)));
};
const getVizStyles = (theme) => {
  return {
    viz: css.css({
      flexGrow: 2,
      borderRadius: theme.shape.radius.default,
      "&:focus-visible": getFocusStyles(theme)
    })
  };
};
const VizLayoutLegend = ({ children }) => {
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, children);
};
VizLayout.Legend = VizLayoutLegend;

var SeriesVisibilityChangeBehavior = /* @__PURE__ */ ((SeriesVisibilityChangeBehavior2) => {
  SeriesVisibilityChangeBehavior2[SeriesVisibilityChangeBehavior2["Isolate"] = 0] = "Isolate";
  SeriesVisibilityChangeBehavior2[SeriesVisibilityChangeBehavior2["Hide"] = 1] = "Hide";
  return SeriesVisibilityChangeBehavior2;
})(SeriesVisibilityChangeBehavior || {});

var __defProp$12 = Object.defineProperty;
var __getOwnPropSymbols$10 = Object.getOwnPropertySymbols;
var __hasOwnProp$10 = Object.prototype.hasOwnProperty;
var __propIsEnum$10 = Object.prototype.propertyIsEnumerable;
var __defNormalProp$12 = (obj, key, value) => key in obj ? __defProp$12(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$$ = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$10.call(b, prop))
      __defNormalProp$12(a, prop, b[prop]);
  if (__getOwnPropSymbols$10)
    for (var prop of __getOwnPropSymbols$10(b)) {
      if (__propIsEnum$10.call(b, prop))
        __defNormalProp$12(a, prop, b[prop]);
    }
  return a;
};
class InlineList extends React.PureComponent {
  render() {
    return /* @__PURE__ */ React__default["default"].createElement(AbstractList, __spreadValues$$({ inline: true }, this.props));
  }
}

const VizLegendSeriesIcon = React__default["default"].memo(({ seriesName, color, gradient, readonly }) => {
  const { onSeriesColorChange } = usePanelContext();
  const onChange = React.useCallback(
    (color2) => {
      return onSeriesColorChange(seriesName, color2);
    },
    [seriesName, onSeriesColorChange]
  );
  if (seriesName && onSeriesColorChange && color && !readonly) {
    return /* @__PURE__ */ React__default["default"].createElement(SeriesColorPicker, { color, onChange, enableNamedColors: true }, ({ ref, showColorPicker, hideColorPicker }) => /* @__PURE__ */ React__default["default"].createElement(
      SeriesIcon,
      {
        color,
        className: "pointer",
        ref,
        onClick: showColorPicker,
        onMouseLeave: hideColorPicker
      }
    ));
  }
  return /* @__PURE__ */ React__default["default"].createElement(SeriesIcon, { color, gradient });
});
VizLegendSeriesIcon.displayName = "VizLegendSeriesIcon";

const VizLegendStatsList = ({ stats }) => {
  const styles = useStyles2(getStyles$D);
  if (stats.length === 0) {
    return null;
  }
  return /* @__PURE__ */ React__default["default"].createElement(
    InlineList,
    {
      className: styles.list,
      items: stats,
      renderItem: (stat) => /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.item, title: stat.description }, stat.title && `${lodash.capitalize(stat.title)}:`, " ", data.formattedValueToString(stat))
    }
  );
};
const getStyles$D = () => ({
  list: css.css({
    flexGrow: 1,
    textAlign: "right"
  }),
  item: css.css({
    marginLeft: "8px"
  })
});
VizLegendStatsList.displayName = "VizLegendStatsList";

const VizLegendListItem = ({
  item,
  onLabelClick,
  onLabelMouseOver,
  onLabelMouseOut,
  className,
  readonly
}) => {
  const styles = useStyles2(getStyles$C);
  const onMouseOver = React.useCallback(
    (event) => {
      if (onLabelMouseOver) {
        onLabelMouseOver(item, event);
      }
    },
    [item, onLabelMouseOver]
  );
  const onMouseOut = React.useCallback(
    (event) => {
      if (onLabelMouseOut) {
        onLabelMouseOut(item, event);
      }
    },
    [item, onLabelMouseOut]
  );
  const onClick = React.useCallback(
    (event) => {
      if (onLabelClick) {
        onLabelClick(item, event);
      }
    },
    [item, onLabelClick]
  );
  return /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      className: css.cx(styles.itemWrapper, item.disabled && styles.itemDisabled, className),
      "data-testid": e2eSelectors.selectors.components.VizLegend.seriesName(item.label)
    },
    /* @__PURE__ */ React__default["default"].createElement(VizLegendSeriesIcon, { seriesName: item.label, color: item.color, gradient: item.gradient, readonly }),
    /* @__PURE__ */ React__default["default"].createElement(
      "button",
      {
        disabled: readonly,
        type: "button",
        onBlur: onMouseOut,
        onFocus: onMouseOver,
        onMouseOver,
        onMouseOut,
        onClick,
        className: styles.label
      },
      item.label
    ),
    item.getDisplayValues && /* @__PURE__ */ React__default["default"].createElement(VizLegendStatsList, { stats: item.getDisplayValues() })
  );
};
VizLegendListItem.displayName = "VizLegendListItem";
const getStyles$C = (theme) => ({
  label: css.css({
    label: "LegendLabel",
    whiteSpace: "nowrap",
    background: "none",
    border: "none",
    fontSize: "inherit",
    padding: 0,
    userSelect: "text"
  }),
  itemDisabled: css.css({
    label: "LegendLabelDisabled",
    color: theme.colors.text.disabled
  }),
  itemWrapper: css.css({
    label: "LegendItemWrapper",
    display: "flex",
    whiteSpace: "nowrap",
    alignItems: "center",
    flexGrow: 1
  }),
  value: css.css({
    textAlign: "right"
  }),
  yAxisLabel: css.css({
    color: theme.v1.palette.gray2
  })
});

const VizLegendList = ({
  items,
  itemRenderer,
  onLabelMouseOver,
  onLabelMouseOut,
  onLabelClick,
  placement,
  className,
  readonly
}) => {
  const styles = useStyles2(getStyles$B);
  if (!itemRenderer) {
    itemRenderer = (item) => /* @__PURE__ */ React__default["default"].createElement(
      VizLegendListItem,
      {
        item,
        onLabelClick,
        onLabelMouseOver,
        onLabelMouseOut,
        readonly
      }
    );
  }
  const getItemKey = (item) => `${item.getItemKey ? item.getItemKey() : item.label}`;
  switch (placement) {
    case "right": {
      const renderItem = (item, index) => {
        return /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.itemRight }, itemRenderer(item, index));
      };
      return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.rightWrapper, className) }, /* @__PURE__ */ React__default["default"].createElement(List, { items, renderItem, getItemKey }));
    }
    case "bottom":
    default: {
      const leftItems = items.filter((item) => item.yAxis === 1);
      const rightItems = items.filter((item) => item.yAxis !== 1);
      const renderItem = (item, index) => {
        return /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.itemBottom }, itemRenderer(item, index));
      };
      return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.bottomWrapper, className) }, leftItems.length > 0 && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.section }, /* @__PURE__ */ React__default["default"].createElement(InlineList, { items: leftItems, renderItem, getItemKey })), rightItems.length > 0 && /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.section, styles.sectionRight) }, /* @__PURE__ */ React__default["default"].createElement(InlineList, { items: rightItems, renderItem, getItemKey })));
    }
  }
};
VizLegendList.displayName = "VizLegendList";
const getStyles$B = (theme) => {
  const itemStyles = css.css({
    paddingRight: "10px",
    display: "flex",
    fontSize: theme.typography.bodySmall.fontSize,
    whiteSpace: "nowrap"
  });
  return {
    itemBottom: itemStyles,
    itemRight: css.cx(
      itemStyles,
      css.css({
        marginBottom: theme.spacing(0.5)
      })
    ),
    rightWrapper: css.css({
      paddingLeft: theme.spacing(0.5)
    }),
    bottomWrapper: css.css({
      display: "flex",
      flexWrap: "wrap",
      justifyContent: "space-between",
      width: "100%",
      paddingLeft: theme.spacing(0.5),
      gap: "15px 25px"
    }),
    section: css.css({
      display: "flex"
    }),
    sectionRight: css.css({
      justifyContent: "flex-end",
      flexGrow: 1,
      flexBasis: "50%"
    })
  };
};

const LegendTableItem = ({
  item,
  onLabelClick,
  onLabelMouseOver,
  onLabelMouseOut,
  className,
  readonly
}) => {
  const styles = useStyles2(getStyles$A);
  const onMouseOver = React.useCallback(
    (event) => {
      if (onLabelMouseOver) {
        onLabelMouseOver(item, event);
      }
    },
    [item, onLabelMouseOver]
  );
  const onMouseOut = React.useCallback(
    (event) => {
      if (onLabelMouseOut) {
        onLabelMouseOut(item, event);
      }
    },
    [item, onLabelMouseOut]
  );
  const onClick = React.useCallback(
    (event) => {
      if (onLabelClick) {
        onLabelClick(item, event);
      }
    },
    [item, onLabelClick]
  );
  return /* @__PURE__ */ React__default["default"].createElement("tr", { className: css.cx(styles.row, className) }, /* @__PURE__ */ React__default["default"].createElement("td", null, /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.itemWrapper }, /* @__PURE__ */ React__default["default"].createElement(VizLegendSeriesIcon, { color: item.color, seriesName: item.label, readonly }), /* @__PURE__ */ React__default["default"].createElement(
    "button",
    {
      disabled: readonly,
      type: "button",
      title: item.label,
      onBlur: onMouseOut,
      onFocus: onMouseOver,
      onMouseOver,
      onMouseOut,
      onClick: !readonly ? onClick : void 0,
      className: css.cx(styles.label, item.disabled && styles.labelDisabled)
    },
    item.label,
    " ",
    item.yAxis === 2 && /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.yAxisLabel }, "(right y-axis)")
  ))), item.getDisplayValues && item.getDisplayValues().map((stat, index) => {
    return /* @__PURE__ */ React__default["default"].createElement("td", { className: styles.value, key: `${stat.title}-${index}` }, data.formattedValueToString(stat));
  }));
};
LegendTableItem.displayName = "LegendTableItem";
const getStyles$A = (theme) => {
  const rowHoverBg = hoverColor(theme.colors.background.primary, theme);
  return {
    row: css.css({
      label: "LegendRow",
      fontSize: theme.v1.typography.size.sm,
      borderBottom: `1px solid ${theme.colors.border.weak}`,
      td: {
        padding: theme.spacing(0.25, 1),
        whiteSpace: "nowrap"
      },
      "&:hover": {
        background: rowHoverBg
      }
    }),
    label: css.css({
      label: "LegendLabel",
      whiteSpace: "nowrap",
      background: "none",
      border: "none",
      fontSize: "inherit",
      padding: 0,
      maxWidth: "600px",
      textOverflow: "ellipsis",
      overflow: "hidden"
    }),
    labelDisabled: css.css({
      label: "LegendLabelDisabled",
      color: theme.colors.text.disabled
    }),
    itemWrapper: css.css({
      display: "flex",
      whiteSpace: "nowrap",
      alignItems: "center"
    }),
    value: css.css({
      textAlign: "right"
    }),
    yAxisLabel: css.css({
      color: theme.colors.text.secondary
    })
  };
};

const nameSortKey = "Name";
const naturalCompare = new Intl.Collator(void 0, { numeric: true, sensitivity: "base" }).compare;
const VizLegendTable = ({
  items,
  sortBy: sortKey,
  sortDesc,
  itemRenderer,
  className,
  onToggleSort,
  onLabelClick,
  onLabelMouseOver,
  onLabelMouseOut,
  readonly,
  isSortable
}) => {
  var _a, _b;
  const styles = useStyles2(getStyles$z);
  const header = {};
  if (isSortable) {
    header[nameSortKey] = "";
  }
  for (const item of items) {
    if (item.getDisplayValues) {
      for (const displayValue of item.getDisplayValues()) {
        header[(_a = displayValue.title) != null ? _a : "?"] = (_b = displayValue.description) != null ? _b : "";
      }
    }
  }
  if (sortKey != null) {
    let itemVals = /* @__PURE__ */ new Map();
    items.forEach((item) => {
      if (sortKey !== nameSortKey && item.getDisplayValues) {
        const stat = item.getDisplayValues().find((stat2) => stat2.title === sortKey);
        const val = stat == null || Number.isNaN(stat.numeric) ? -Infinity : stat.numeric;
        itemVals.set(item, val);
      }
    });
    let sortMult = sortDesc ? -1 : 1;
    if (sortKey === nameSortKey) {
      items.sort((a, b) => {
        return sortMult * naturalCompare(a.label, b.label);
      });
    } else {
      items.sort((a, b) => {
        var _a2, _b2;
        const aVal = (_a2 = itemVals.get(a)) != null ? _a2 : 0;
        const bVal = (_b2 = itemVals.get(b)) != null ? _b2 : 0;
        return sortMult * (aVal - bVal);
      });
    }
  }
  if (!itemRenderer) {
    itemRenderer = (item, index) => /* @__PURE__ */ React__default["default"].createElement(
      LegendTableItem,
      {
        key: `${item.label}-${index}`,
        item,
        onLabelClick,
        onLabelMouseOver,
        onLabelMouseOut,
        readonly
      }
    );
  }
  return /* @__PURE__ */ React__default["default"].createElement("table", { className: css.cx(styles.table, className) }, /* @__PURE__ */ React__default["default"].createElement("thead", null, /* @__PURE__ */ React__default["default"].createElement("tr", null, !isSortable && /* @__PURE__ */ React__default["default"].createElement("th", null), Object.keys(header).map((columnTitle) => /* @__PURE__ */ React__default["default"].createElement(
    "th",
    {
      title: header[columnTitle],
      key: columnTitle,
      className: css.cx(styles.header, onToggleSort && styles.headerSortable, isSortable && styles.nameHeader, {
        [styles.withIcon]: sortKey === columnTitle
      }),
      onClick: () => {
        if (onToggleSort) {
          onToggleSort(columnTitle);
        }
      }
    },
    columnTitle,
    sortKey === columnTitle && /* @__PURE__ */ React__default["default"].createElement(Icon, { size: "xs", name: sortDesc ? "angle-down" : "angle-up" })
  )))), /* @__PURE__ */ React__default["default"].createElement("tbody", null, items.map(itemRenderer)));
};
const getStyles$z = (theme) => ({
  table: css.css({
    width: "100%",
    "th:first-child": {
      width: "100%",
      borderBottom: `1px solid ${theme.colors.border.weak}`
    }
  }),
  header: css.css({
    color: theme.colors.primary.text,
    fontWeight: theme.typography.fontWeightMedium,
    borderBottom: `1px solid ${theme.colors.border.weak}`,
    padding: theme.spacing(0.25, 1, 0.25, 1),
    fontSize: theme.typography.bodySmall.fontSize,
    textAlign: "right",
    whiteSpace: "nowrap"
  }),
  nameHeader: css.css({
    textAlign: "left",
    paddingLeft: "30px"
  }),
  // This needs to be padding-right - icon size(xs==12) to avoid jumping
  withIcon: css.css({
    paddingRight: "4px"
  }),
  headerSortable: css.css({
    cursor: "pointer"
  })
});

function mapMouseEventToMode(event) {
  if (event.ctrlKey || event.metaKey || event.shiftKey) {
    return SeriesVisibilityChangeMode.AppendToSelection;
  }
  return SeriesVisibilityChangeMode.ToggleSelection;
}

function VizLegend({
  items,
  displayMode,
  sortBy: sortKey,
  seriesVisibilityChangeBehavior = SeriesVisibilityChangeBehavior.Isolate,
  sortDesc,
  onLabelClick,
  onToggleSort,
  placement,
  className,
  itemRenderer,
  readonly,
  isSortable
}) {
  const { eventBus, onToggleSeriesVisibility, onToggleLegendSort } = usePanelContext();
  const onMouseOver = React.useCallback(
    (item, event) => {
      eventBus == null ? void 0 : eventBus.publish({
        type: data.DataHoverEvent.type,
        payload: {
          raw: event,
          x: 0,
          y: 0,
          dataId: item.label
        }
      });
    },
    [eventBus]
  );
  const onMouseOut = React.useCallback(
    (item, event) => {
      eventBus == null ? void 0 : eventBus.publish({
        type: data.DataHoverClearEvent.type,
        payload: {
          raw: event,
          x: 0,
          y: 0,
          dataId: item.label
        }
      });
    },
    [eventBus]
  );
  const onLegendLabelClick = React.useCallback(
    (item, event) => {
      if (onLabelClick) {
        onLabelClick(item, event);
      }
      if (onToggleSeriesVisibility) {
        onToggleSeriesVisibility(
          item.label,
          seriesVisibilityChangeBehavior === SeriesVisibilityChangeBehavior.Hide ? SeriesVisibilityChangeMode.AppendToSelection : mapMouseEventToMode(event)
        );
      }
    },
    [onToggleSeriesVisibility, onLabelClick, seriesVisibilityChangeBehavior]
  );
  switch (displayMode) {
    case schema.LegendDisplayMode.Table:
      return /* @__PURE__ */ React__default["default"].createElement(
        VizLegendTable,
        {
          className,
          items,
          placement,
          sortBy: sortKey,
          sortDesc,
          onLabelClick: onLegendLabelClick,
          onToggleSort: onToggleSort || onToggleLegendSort,
          onLabelMouseOver: onMouseOver,
          onLabelMouseOut: onMouseOut,
          itemRenderer,
          readonly,
          isSortable
        }
      );
    case schema.LegendDisplayMode.List:
      return /* @__PURE__ */ React__default["default"].createElement(
        VizLegendList,
        {
          className,
          items,
          placement,
          onLabelMouseOver: onMouseOver,
          onLabelMouseOut: onMouseOut,
          onLabelClick: onLegendLabelClick,
          itemRenderer,
          readonly
        }
      );
    default:
      return null;
  }
}
VizLegend.displayName = "VizLegend";

var __defProp$11 = Object.defineProperty;
var __getOwnPropSymbols$$ = Object.getOwnPropertySymbols;
var __hasOwnProp$$ = Object.prototype.hasOwnProperty;
var __propIsEnum$$ = Object.prototype.propertyIsEnumerable;
var __defNormalProp$11 = (obj, key, value) => key in obj ? __defProp$11(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$_ = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$$.call(b, prop))
      __defNormalProp$11(a, prop, b[prop]);
  if (__getOwnPropSymbols$$)
    for (var prop of __getOwnPropSymbols$$(b)) {
      if (__propIsEnum$$.call(b, prop))
        __defNormalProp$11(a, prop, b[prop]);
    }
  return a;
};
var __objRest$y = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$$.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$$)
    for (var prop of __getOwnPropSymbols$$(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$$.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Box = React.forwardRef((props, ref) => {
  const _a = props, {
    children,
    margin,
    marginX,
    marginY,
    marginTop,
    marginBottom,
    marginLeft,
    marginRight,
    padding,
    paddingX,
    paddingY,
    paddingTop,
    paddingBottom,
    paddingLeft,
    paddingRight,
    display,
    backgroundColor,
    grow,
    shrink,
    basis,
    flex,
    borderColor,
    borderStyle,
    borderRadius,
    justifyContent,
    alignItems,
    boxShadow,
    element,
    gap
  } = _a, rest = __objRest$y(_a, [
    "children",
    "margin",
    "marginX",
    "marginY",
    "marginTop",
    "marginBottom",
    "marginLeft",
    "marginRight",
    "padding",
    "paddingX",
    "paddingY",
    "paddingTop",
    "paddingBottom",
    "paddingLeft",
    "paddingRight",
    "display",
    "backgroundColor",
    "grow",
    "shrink",
    "basis",
    "flex",
    "borderColor",
    "borderStyle",
    "borderRadius",
    "justifyContent",
    "alignItems",
    "boxShadow",
    "element",
    "gap"
  ]);
  const styles = useStyles2(
    getStyles$y,
    margin,
    marginX,
    marginY,
    marginTop,
    marginBottom,
    marginLeft,
    marginRight,
    padding,
    paddingX,
    paddingY,
    paddingTop,
    paddingBottom,
    paddingLeft,
    paddingRight,
    display,
    backgroundColor,
    grow,
    shrink,
    basis,
    flex,
    borderColor,
    borderStyle,
    borderRadius,
    justifyContent,
    alignItems,
    boxShadow,
    gap
  );
  const Element = element != null ? element : "div";
  return /* @__PURE__ */ React__default["default"].createElement(Element, __spreadValues$_({ ref, className: styles.root }, rest), children);
});
Box.displayName = "Box";
const customBorderColor = (color, theme) => {
  switch (color) {
    case "error":
    case "success":
    case "info":
    case "warning":
      return theme.colors[color].borderTransparent;
    default:
      return color ? theme.colors.border[color] : void 0;
  }
};
const customBackgroundColor = (color, theme) => {
  switch (color) {
    case "error":
    case "success":
    case "info":
    case "warning":
      return theme.colors[color].transparent;
    default:
      return color ? theme.colors.background[color] : void 0;
  }
};
const getStyles$y = (theme, margin, marginX, marginY, marginTop, marginBottom, marginLeft, marginRight, padding, paddingX, paddingY, paddingTop, paddingBottom, paddingLeft, paddingRight, display, backgroundColor, grow, shrink, basis, flex, borderColor, borderStyle, borderRadius, justifyContent, alignItems, boxShadow, gap) => {
  return {
    root: css.css([
      getResponsiveStyle(theme, margin, (val) => ({
        margin: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginX, (val) => ({
        marginLeft: theme.spacing(val),
        marginRight: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginY, (val) => ({
        marginTop: theme.spacing(val),
        marginBottom: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginTop, (val) => ({
        marginTop: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginBottom, (val) => ({
        marginBottom: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginLeft, (val) => ({
        marginLeft: theme.spacing(val)
      })),
      getResponsiveStyle(theme, marginRight, (val) => ({
        marginRight: theme.spacing(val)
      })),
      getResponsiveStyle(theme, padding, (val) => ({
        padding: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingX, (val) => ({
        paddingLeft: theme.spacing(val),
        paddingRight: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingY, (val) => ({
        paddingTop: theme.spacing(val),
        paddingBottom: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingTop, (val) => ({
        paddingTop: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingBottom, (val) => ({
        paddingBottom: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingLeft, (val) => ({
        paddingLeft: theme.spacing(val)
      })),
      getResponsiveStyle(theme, paddingRight, (val) => ({
        paddingRight: theme.spacing(val)
      })),
      getResponsiveStyle(theme, display, (val) => ({
        display: val
      })),
      getResponsiveStyle(theme, backgroundColor, (val) => ({
        backgroundColor: customBackgroundColor(val, theme)
      })),
      getResponsiveStyle(theme, grow, (val) => ({
        flexGrow: val
      })),
      getResponsiveStyle(theme, shrink, (val) => ({
        flexShrink: val
      })),
      getResponsiveStyle(theme, basis, (val) => ({
        flexBasis: val
      })),
      getResponsiveStyle(theme, flex, (val) => ({
        flex: val
      })),
      getResponsiveStyle(theme, borderStyle, (val) => ({
        borderStyle: val
      })),
      getResponsiveStyle(theme, borderColor, (val) => ({
        borderColor: customBorderColor(val, theme)
      })),
      (borderStyle || borderColor) && {
        borderWidth: "1px"
      },
      getResponsiveStyle(theme, justifyContent, (val) => ({
        justifyContent: val
      })),
      getResponsiveStyle(theme, alignItems, (val) => ({
        alignItems: val
      })),
      getResponsiveStyle(theme, borderRadius, (val) => ({
        borderRadius: theme.shape.radius[val]
      })),
      getResponsiveStyle(theme, boxShadow, (val) => ({
        boxShadow: theme.shadows[val]
      })),
      getResponsiveStyle(theme, gap, (val) => ({
        gap: theme.spacing(val)
      }))
    ])
  };
};

const TruncatedText = React__default["default"].forwardRef(({ childElement, children }, ref) => {
  const [isOverflowing, setIsOverflowing] = React.useState(false);
  const internalRef = React.useRef(null);
  React.useImperativeHandle(ref, () => internalRef.current);
  const resizeObserver = React.useMemo(
    () => new ResizeObserver((entries) => {
      for (const entry of entries) {
        if (entry.target.clientWidth && entry.target.scrollWidth) {
          if (entry.target.scrollWidth > entry.target.clientWidth) {
            setIsOverflowing(true);
          }
          if (entry.target.scrollWidth <= entry.target.clientWidth) {
            setIsOverflowing(false);
          }
        }
      }
    }),
    []
  );
  React.useEffect(() => {
    const { current } = internalRef;
    if (current) {
      resizeObserver.observe(current);
    }
    return () => {
      resizeObserver.disconnect();
    };
  }, [setIsOverflowing, resizeObserver]);
  const getTooltipText = (children2) => {
    if (typeof children2 === "string") {
      return children2;
    }
    const html = ReactDOMServer__default["default"].renderToStaticMarkup(/* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, children2));
    return html.replace(/(<([^>]+)>)/gi, "");
  };
  if (isOverflowing) {
    return /* @__PURE__ */ React__default["default"].createElement(Tooltip, { ref: internalRef, content: getTooltipText(children) }, childElement(void 0));
  } else {
    return childElement(internalRef);
  }
});
TruncatedText.displayName = "TruncatedText";

const customWeight = (weight, theme) => {
  switch (weight) {
    case "bold":
      return theme.typography.fontWeightBold;
    case "medium":
      return theme.typography.fontWeightMedium;
    case "light":
      return theme.typography.fontWeightLight;
    case "regular":
    case void 0:
      return theme.typography.fontWeightRegular;
  }
};
const customColor = (color, theme) => {
  switch (color) {
    case "error":
      return theme.colors.error.text;
    case "success":
      return theme.colors.success.text;
    case "info":
      return theme.colors.info.text;
    case "warning":
      return theme.colors.warning.text;
    default:
      return color ? theme.colors.text[color] : void 0;
  }
};
const customVariant = (theme, element, variant) => {
  if (variant) {
    return theme.typography[variant];
  }
  switch (element) {
    case "span":
      return;
    case "h1":
      return theme.typography.h1;
    case "h2":
      return theme.typography.h2;
    case "h3":
      return theme.typography.h3;
    case "h4":
      return theme.typography.h4;
    case "h5":
      return theme.typography.h5;
    case "h6":
      return theme.typography.h6;
    default:
      return theme.typography.body;
  }
};

var __defProp$10 = Object.defineProperty;
var __defProps$J = Object.defineProperties;
var __getOwnPropDescs$J = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$_ = Object.getOwnPropertySymbols;
var __hasOwnProp$_ = Object.prototype.hasOwnProperty;
var __propIsEnum$_ = Object.prototype.propertyIsEnumerable;
var __defNormalProp$10 = (obj, key, value) => key in obj ? __defProp$10(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$Z = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$_.call(b, prop))
      __defNormalProp$10(a, prop, b[prop]);
  if (__getOwnPropSymbols$_)
    for (var prop of __getOwnPropSymbols$_(b)) {
      if (__propIsEnum$_.call(b, prop))
        __defNormalProp$10(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$J = (a, b) => __defProps$J(a, __getOwnPropDescs$J(b));
var __objRest$x = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$_.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$_)
    for (var prop of __getOwnPropSymbols$_(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$_.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Text = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, { element = "span", variant, weight, color, truncate, italic, textAlignment, children } = _b, restProps = __objRest$x(_b, ["element", "variant", "weight", "color", "truncate", "italic", "textAlignment", "children"]);
    const styles = useStyles2(getTextStyles, element, variant, color, weight, truncate, italic, textAlignment);
    const childElement = (ref2) => {
      return React.createElement(
        element,
        __spreadProps$J(__spreadValues$Z({}, restProps), {
          style: void 0,
          // Remove the style prop to avoid overriding the styles
          className: styles,
          // When overflowing, the internalRef is passed to the tooltip, which forwards it to the child element
          ref: ref2
        }),
        children
      );
    };
    if (!truncate || element === "span") {
      return childElement(void 0);
    }
    return /* @__PURE__ */ React__default["default"].createElement(
      TruncatedText,
      {
        childElement,
        children,
        ref
      }
    );
  }
);
Text.displayName = "Text";
const getTextStyles = (theme, element, variant, color, weight, truncate, italic, textAlignment) => {
  return css.css([
    __spreadValues$Z({
      margin: 0,
      padding: 0
    }, customVariant(theme, element, variant)),
    variant && __spreadValues$Z({}, theme.typography[variant]),
    color && {
      color: customColor(color, theme)
    },
    weight && {
      fontWeight: customWeight(weight, theme)
    },
    truncate && {
      overflow: "hidden",
      textOverflow: "ellipsis",
      whiteSpace: "nowrap"
    },
    italic && {
      fontStyle: "italic"
    },
    textAlignment && {
      textAlign: textAlignment
    }
  ]);
};

var __defProp$$ = Object.defineProperty;
var __getOwnPropSymbols$Z = Object.getOwnPropertySymbols;
var __hasOwnProp$Z = Object.prototype.hasOwnProperty;
var __propIsEnum$Z = Object.prototype.propertyIsEnumerable;
var __defNormalProp$$ = (obj, key, value) => key in obj ? __defProp$$(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$Y = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$Z.call(b, prop))
      __defNormalProp$$(a, prop, b[prop]);
  if (__getOwnPropSymbols$Z)
    for (var prop of __getOwnPropSymbols$Z(b)) {
      if (__propIsEnum$Z.call(b, prop))
        __defNormalProp$$(a, prop, b[prop]);
    }
  return a;
};
var __objRest$w = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$Z.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$Z)
    for (var prop of __getOwnPropSymbols$Z(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$Z.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Alert = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, {
      title,
      onRemove,
      children,
      buttonContent,
      elevated,
      bottomSpacing,
      topSpacing,
      className,
      severity = "error"
    } = _b, restProps = __objRest$w(_b, [
      "title",
      "onRemove",
      "children",
      "buttonContent",
      "elevated",
      "bottomSpacing",
      "topSpacing",
      "className",
      "severity"
    ]);
    const theme = useTheme2();
    const hasTitle = Boolean(title);
    const styles = getStyles$x(theme, severity, hasTitle, elevated, bottomSpacing, topSpacing);
    const rolesBySeverity = {
      error: "alert",
      warning: "alert",
      info: "status",
      success: "status"
    };
    const role = restProps["role"] || rolesBySeverity[severity];
    const ariaLabel = restProps["aria-label"] || title;
    return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$Y({ ref, className: css.cx(styles.wrapper, className), role, "aria-label": ariaLabel }, restProps), /* @__PURE__ */ React__default["default"].createElement(
      Box,
      {
        "data-testid": e2eSelectors.selectors.components.Alert.alertV2(severity),
        display: "flex",
        backgroundColor: severity,
        borderRadius: "default",
        paddingY: 1,
        paddingX: 2,
        borderStyle: "solid",
        borderColor: severity,
        alignItems: "stretch",
        boxShadow: elevated ? "z3" : void 0
      },
      /* @__PURE__ */ React__default["default"].createElement(Box, { paddingTop: 1, paddingRight: 2 }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.icon }, /* @__PURE__ */ React__default["default"].createElement(Icon, { size: "xl", name: getIconFromSeverity(severity) }))),
      /* @__PURE__ */ React__default["default"].createElement(Box, { paddingY: 1, grow: 1 }, /* @__PURE__ */ React__default["default"].createElement(Text, { color: "primary", weight: "medium" }, title), children && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.content }, children)),
      onRemove && !buttonContent && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.close }, /* @__PURE__ */ React__default["default"].createElement(
        Button,
        {
          "aria-label": "Close alert",
          icon: "times",
          onClick: onRemove,
          type: "button",
          fill: "text",
          variant: "secondary"
        }
      )),
      onRemove && buttonContent && /* @__PURE__ */ React__default["default"].createElement(Box, { marginLeft: 1, display: "flex", alignItems: "center" }, /* @__PURE__ */ React__default["default"].createElement(Button, { "aria-label": "Close alert", variant: "secondary", onClick: onRemove, type: "button" }, buttonContent))
    ));
  }
);
Alert.displayName = "Alert";
const getIconFromSeverity = (severity) => {
  switch (severity) {
    case "error":
      return "exclamation-circle";
    case "warning":
      return "exclamation-triangle";
    case "info":
      return "info-circle";
    case "success":
      return "check";
  }
};
const getStyles$x = (theme, severity, hasTitle, elevated, bottomSpacing, topSpacing) => {
  const color = theme.colors[severity];
  return {
    wrapper: css.css({
      flexGrow: 1,
      marginBottom: theme.spacing(bottomSpacing != null ? bottomSpacing : 2),
      marginTop: theme.spacing(topSpacing != null ? topSpacing : 0),
      position: "relative",
      "&:before": {
        content: '""',
        position: "absolute",
        top: 0,
        left: 0,
        bottom: 0,
        right: 0,
        background: theme.colors.background.primary,
        zIndex: -1
      }
    }),
    icon: css.css({
      color: color.text
    }),
    content: css.css({
      color: theme.colors.text.primary,
      paddingTop: hasTitle ? theme.spacing(0.5) : 0,
      maxHeight: "50vh",
      overflowY: "auto"
    }),
    close: css.css({
      position: "relative",
      color: theme.colors.text.secondary,
      background: "none",
      display: "flex",
      top: "-6px",
      right: "-14px"
    })
  };
};

var __defProp$_ = Object.defineProperty;
var __defProps$I = Object.defineProperties;
var __getOwnPropDescs$I = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$Y = Object.getOwnPropertySymbols;
var __hasOwnProp$Y = Object.prototype.hasOwnProperty;
var __propIsEnum$Y = Object.prototype.propertyIsEnumerable;
var __defNormalProp$_ = (obj, key, value) => key in obj ? __defProp$_(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$X = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$Y.call(b, prop))
      __defNormalProp$_(a, prop, b[prop]);
  if (__getOwnPropSymbols$Y)
    for (var prop of __getOwnPropSymbols$Y(b)) {
      if (__propIsEnum$Y.call(b, prop))
        __defNormalProp$_(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$I = (a, b) => __defProps$I(a, __getOwnPropDescs$I(b));
class GraphSeriesToggler extends React.Component {
  constructor(props) {
    super(props);
    this.onSeriesToggle = this.onSeriesToggle.bind(this);
    this.state = {
      hiddenSeries: [],
      toggledSeries: props.series
    };
  }
  componentDidUpdate(prevProps) {
    const { series } = this.props;
    if (!lodash.isEqual(prevProps.series, series)) {
      this.setState({ hiddenSeries: [], toggledSeries: series });
    }
  }
  onSeriesToggle(label, event) {
    const { series, onHiddenSeriesChanged } = this.props;
    const { hiddenSeries } = this.state;
    if (event.ctrlKey || event.metaKey || event.shiftKey) {
      const newHiddenSeries2 = hiddenSeries.indexOf(label) > -1 ? hiddenSeries.filter((series2) => series2 !== label) : hiddenSeries.concat([label]);
      const toggledSeries2 = series.map((series2) => __spreadProps$I(__spreadValues$X({}, series2), {
        isVisible: newHiddenSeries2.indexOf(series2.label) === -1
      }));
      this.setState(
        { hiddenSeries: newHiddenSeries2, toggledSeries: toggledSeries2 },
        () => onHiddenSeriesChanged ? onHiddenSeriesChanged(newHiddenSeries2) : void 0
      );
      return;
    }
    const allSeriesLabels = series.map((series2) => series2.label);
    const newHiddenSeries = hiddenSeries.length + 1 === allSeriesLabels.length ? [] : lodash.difference(allSeriesLabels, [label]);
    const toggledSeries = series.map((series2) => __spreadProps$I(__spreadValues$X({}, series2), {
      isVisible: newHiddenSeries.indexOf(series2.label) === -1
    }));
    this.setState(
      { hiddenSeries: newHiddenSeries, toggledSeries },
      () => onHiddenSeriesChanged ? onHiddenSeriesChanged(newHiddenSeries) : void 0
    );
  }
  render() {
    const { children } = this.props;
    const { toggledSeries } = this.state;
    return children({
      onSeriesToggle: this.onSeriesToggle,
      toggledSeries
    });
  }
}

var __defProp$Z = Object.defineProperty;
var __defProps$H = Object.defineProperties;
var __getOwnPropDescs$H = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$X = Object.getOwnPropertySymbols;
var __hasOwnProp$X = Object.prototype.hasOwnProperty;
var __propIsEnum$X = Object.prototype.propertyIsEnumerable;
var __defNormalProp$Z = (obj, key, value) => key in obj ? __defProp$Z(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$W = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$X.call(b, prop))
      __defNormalProp$Z(a, prop, b[prop]);
  if (__getOwnPropSymbols$X)
    for (var prop of __getOwnPropSymbols$X(b)) {
      if (__propIsEnum$X.call(b, prop))
        __defNormalProp$Z(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$H = (a, b) => __defProps$H(a, __getOwnPropDescs$H(b));
var __objRest$v = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$X.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$X)
    for (var prop of __getOwnPropSymbols$X(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$X.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const getStyles$w = (theme) => ({
  collapse: css.css({
    label: "collapse",
    marginBottom: theme.spacing(1),
    backgroundColor: theme.colors.background.primary,
    border: `1px solid ${theme.colors.border.weak}`,
    position: "relative",
    borderRadius: theme.shape.radius.default,
    width: "100%",
    display: "flex",
    flexDirection: "column",
    flex: "1 1 0"
  }),
  collapseBody: css.css({
    label: "collapse__body",
    padding: theme.spacing(theme.components.panel.padding),
    paddingTop: 0,
    flex: 1,
    overflow: "hidden",
    display: "flex",
    flexDirection: "column"
  }),
  bodyContentWrapper: css.css({
    label: "bodyContentWrapper",
    flex: 1,
    overflow: "hidden"
  }),
  loader: css.css({
    label: "collapse__loader",
    height: "2px",
    position: "relative",
    overflow: "hidden",
    background: "none",
    margin: theme.spacing(0.5)
  }),
  loaderActive: css.css({
    label: "collapse__loader_active",
    "&:after": {
      content: "' '",
      display: "block",
      width: "25%",
      top: 0,
      height: "250%",
      position: "absolute",
      animation: "loader 2s cubic-bezier(0.17, 0.67, 0.83, 0.67) 500ms",
      animationIterationCount: 100,
      left: "-25%",
      background: theme.colors.primary.main
    },
    "@keyframes loader": {
      from: {
        left: "-25%",
        opacity: 0.1
      },
      to: {
        left: "100%",
        opacity: 1
      }
    }
  }),
  header: css.css({
    label: "collapse__header",
    padding: theme.spacing(1, 2, 1, 2),
    display: "flex",
    transition: "all 0.1s linear"
  }),
  headerCollapsed: css.css({
    label: "collapse__header--collapsed",
    padding: theme.spacing(1, 2, 1, 2)
  }),
  headerLabel: css.css({
    label: "collapse__header-label",
    fontWeight: theme.typography.fontWeightMedium,
    marginRight: theme.spacing(1),
    fontSize: theme.typography.size.md,
    display: "flex",
    flex: "0 0 100%"
  }),
  icon: css.css({
    label: "collapse__icon",
    margin: theme.spacing(0.25, 1, 0, -1)
  })
});
const ControlledCollapse = (_a) => {
  var _b = _a, { isOpen, onToggle } = _b, otherProps = __objRest$v(_b, ["isOpen", "onToggle"]);
  const [open, setOpen] = React.useState(isOpen);
  return /* @__PURE__ */ React__default["default"].createElement(
    Collapse,
    __spreadProps$H(__spreadValues$W({
      isOpen: open,
      collapsible: true
    }, otherProps), {
      onToggle: () => {
        setOpen(!open);
        if (onToggle) {
          onToggle(!open);
        }
      }
    })
  );
};
const Collapse = ({
  isOpen,
  label,
  loading,
  collapsible,
  onToggle,
  className,
  children
}) => {
  const buttonStyles = useStyles2(clearButtonStyles);
  const style = useStyles2(getStyles$w);
  const onClickToggle = () => {
    if (onToggle) {
      onToggle(!isOpen);
    }
  };
  const panelClass = css.cx([style.collapse, className]);
  const loaderClass = loading ? css.cx([style.loader, style.loaderActive]) : css.cx([style.loader]);
  const headerClass = collapsible ? css.cx([style.header]) : css.cx([style.headerCollapsed]);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: panelClass }, /* @__PURE__ */ React__default["default"].createElement("button", { type: "button", className: css.cx(buttonStyles, headerClass), onClick: onClickToggle }, collapsible && /* @__PURE__ */ React__default["default"].createElement(Icon, { className: style.icon, name: isOpen ? "angle-down" : "angle-right" }), /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx([style.headerLabel]) }, label)), isOpen && /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx([style.collapseBody]) }, /* @__PURE__ */ React__default["default"].createElement("div", { className: loaderClass }), /* @__PURE__ */ React__default["default"].createElement("div", { className: style.bodyContentWrapper }, children)));
};
Collapse.displayName = "Collapse";

const CollapsableSection = ({
  label,
  isOpen,
  onToggle,
  className,
  contentClassName,
  children,
  labelId,
  loading = false,
  headerDataTestId,
  contentDataTestId
}) => {
  const [open, toggleOpen] = React.useState(isOpen);
  const styles = useStyles2(collapsableSectionStyles);
  const onClick = (e) => {
    if (e.target instanceof HTMLElement && e.target.tagName === "A") {
      return;
    }
    e.preventDefault();
    e.stopPropagation();
    onToggle == null ? void 0 : onToggle(!open);
    toggleOpen(!open);
  };
  const { current: id } = React.useRef(lodash.uniqueId());
  const buttonLabelId = labelId != null ? labelId : `collapse-label-${id}`;
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("div", { onClick, className: css.cx(styles.header, className) }, /* @__PURE__ */ React__default["default"].createElement(
    "button",
    {
      type: "button",
      id: `collapse-button-${id}`,
      className: styles.button,
      onClick,
      "aria-expanded": open && !loading,
      "aria-controls": `collapse-content-${id}`,
      "aria-labelledby": buttonLabelId
    },
    loading ? /* @__PURE__ */ React__default["default"].createElement(Spinner, { className: styles.spinner }) : /* @__PURE__ */ React__default["default"].createElement(Icon, { name: open ? "angle-up" : "angle-down", className: styles.icon })
  ), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.label, id: `collapse-label-${id}`, "data-testid": headerDataTestId }, label)), open && /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      id: `collapse-content-${id}`,
      className: css.cx(styles.content, contentClassName),
      "data-testid": contentDataTestId
    },
    children
  ));
};
const collapsableSectionStyles = (theme) => ({
  header: css.css({
    display: "flex",
    cursor: "pointer",
    boxSizing: "border-box",
    flexDirection: "row-reverse",
    position: "relative",
    justifyContent: "space-between",
    fontSize: theme.typography.size.lg,
    padding: `${theme.spacing(0.5)} 0`,
    "&:focus-within": getFocusStyles(theme)
  }),
  button: css.css({
    all: "unset",
    "&:focus-visible": {
      outline: "none",
      outlineOffset: "unset",
      transition: "none",
      boxShadow: "none"
    }
  }),
  icon: css.css({
    color: theme.colors.text.secondary
  }),
  content: css.css({
    padding: `${theme.spacing(2)} 0`
  }),
  spinner: css.css({
    display: "flex",
    alignItems: "center",
    width: theme.spacing(2)
  }),
  label: css.css({
    display: "flex"
  })
});

var __defProp$Y = Object.defineProperty;
var __getOwnPropSymbols$W = Object.getOwnPropertySymbols;
var __hasOwnProp$W = Object.prototype.hasOwnProperty;
var __propIsEnum$W = Object.prototype.propertyIsEnumerable;
var __defNormalProp$Y = (obj, key, value) => key in obj ? __defProp$Y(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$V = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$W.call(b, prop))
      __defNormalProp$Y(a, prop, b[prop]);
  if (__getOwnPropSymbols$W)
    for (var prop of __getOwnPropSymbols$W(b)) {
      if (__propIsEnum$W.call(b, prop))
        __defNormalProp$Y(a, prop, b[prop]);
    }
  return a;
};
function DataLinkButton({ link, buttonProps }) {
  return /* @__PURE__ */ React__default["default"].createElement(
    "a",
    {
      href: link.href,
      target: link.target,
      rel: "noreferrer",
      onClick: link.onClick ? (event) => {
        if (!(event.ctrlKey || event.metaKey || event.shiftKey) && link.onClick) {
          event.preventDefault();
          link.onClick(event);
        }
      } : void 0
    },
    /* @__PURE__ */ React__default["default"].createElement(
      Button,
      __spreadValues$V({
        icon: link.target === "_blank" ? "external-link-alt" : void 0,
        variant: "primary",
        size: "sm"
      }, buttonProps),
      link.title
    )
  );
}

function FieldLinkList({ links }) {
  const styles = useStyles2(getStyles$v);
  if (links.length === 1) {
    return /* @__PURE__ */ React__default["default"].createElement(DataLinkButton, { link: links[0] });
  }
  const externalLinks = links.filter((link) => link.target === "_blank");
  const internalLinks = links.filter((link) => link.target === "_self");
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, internalLinks.map((link, i) => {
    return /* @__PURE__ */ React__default["default"].createElement(DataLinkButton, { key: i, link });
  }), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.wrapper }, /* @__PURE__ */ React__default["default"].createElement("p", { className: styles.externalLinksHeading }, "External links"), externalLinks.map((link, i) => /* @__PURE__ */ React__default["default"].createElement("a", { key: i, href: link.href, target: link.target, className: styles.externalLink }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "external-link-alt" }), link.title))));
}
const getStyles$v = (theme) => ({
  wrapper: css.css({
    flexBasis: "150px",
    width: "100px",
    marginTop: theme.spacing(1)
  }),
  externalLinksHeading: css.css({
    color: theme.colors.text.secondary,
    fontWeight: theme.typography.fontWeightRegular,
    fontSize: theme.typography.size.sm,
    margin: 0
  }),
  externalLink: css.css({
    color: theme.colors.text.link,
    fontWeight: theme.typography.fontWeightRegular,
    display: "block",
    whiteSpace: "nowrap",
    overflow: "hidden",
    textOverflow: "ellipsis",
    "&:hover": {
      textDecoration: "underline"
    },
    div: {
      marginRight: theme.spacing(1)
    }
  })
});

const FullWidthButtonContainer = ({ className, children }) => {
  const styles = useStyles2(getStyles$u);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles, className) }, children);
};
const getStyles$u = () => css.css({
  display: "flex",
  button: {
    flexGrow: 1,
    justifyContent: "center"
  },
  "> *": {
    flexGrow: 1
  },
  label: {
    flexGrow: 1,
    textAlign: "center"
  }
});

var __defProp$X = Object.defineProperty;
var __defProps$G = Object.defineProperties;
var __getOwnPropDescs$G = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$V = Object.getOwnPropertySymbols;
var __hasOwnProp$V = Object.prototype.hasOwnProperty;
var __propIsEnum$V = Object.prototype.propertyIsEnumerable;
var __defNormalProp$X = (obj, key, value) => key in obj ? __defProp$X(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$U = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$V.call(b, prop))
      __defNormalProp$X(a, prop, b[prop]);
  if (__getOwnPropSymbols$V)
    for (var prop of __getOwnPropSymbols$V(b)) {
      if (__propIsEnum$V.call(b, prop))
        __defNormalProp$X(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$G = (a, b) => __defProps$G(a, __getOwnPropDescs$G(b));
var __objRest$u = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$V.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$V)
    for (var prop of __getOwnPropSymbols$V(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$V.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const optionsToKeep = ["reduceOptions", "orientation"];
function sharedSingleStatPanelChangedHandler(panel, prevPluginId, prevOptions) {
  let options = panel.options;
  panel.fieldConfig = panel.fieldConfig || {
    defaults: {},
    overrides: []
  };
  if (prevPluginId === "singlestat" && prevOptions.angular) {
    return migrateFromAngularSinglestat(panel, prevOptions);
  }
  for (const k of optionsToKeep) {
    if (prevOptions.hasOwnProperty(k)) {
      options[k] = lodash.cloneDeep(prevOptions[k]);
    }
  }
  return options;
}
function migrateFromAngularSinglestat(panel, prevOptions) {
  const prevPanel = prevOptions.angular;
  const reducer = data.fieldReducers.getIfExists(prevPanel.valueName);
  const options = {
    reduceOptions: {
      calcs: [reducer ? reducer.id : data.ReducerID.mean]
    },
    orientation: data.VizOrientation.Horizontal
  };
  const defaults = {};
  if (prevPanel.format) {
    defaults.unit = prevPanel.format;
  }
  if (prevPanel.tableColumn) {
    options.reduceOptions.fields = `/^${prevPanel.tableColumn}$/`;
  }
  if (prevPanel.nullPointMode) {
    defaults.nullValueMode = prevPanel.nullPointMode;
  }
  if (prevPanel.nullText) {
    defaults.noValue = prevPanel.nullText;
  }
  if (prevPanel.decimals || prevPanel.decimals === 0) {
    defaults.decimals = prevPanel.decimals;
  }
  if (prevPanel.thresholds && prevPanel.colors) {
    const levels = prevPanel.thresholds.split(",").map((strVale) => {
      return Number(strVale.trim());
    });
    const thresholds = [];
    for (const color of prevPanel.colors) {
      const idx = thresholds.length - 1;
      if (idx >= 0) {
        thresholds.push({ value: levels[idx], color });
      } else {
        thresholds.push({ value: -Infinity, color });
      }
    }
    defaults.thresholds = {
      mode: data.ThresholdsMode.Absolute,
      steps: thresholds
    };
  }
  const mappings = data.convertOldAngularValueMappings(prevPanel, defaults.thresholds);
  if (mappings && mappings.length) {
    defaults.mappings = mappings;
  }
  if (prevPanel.gauge && prevPanel.gauge.show) {
    defaults.min = prevPanel.gauge.minValue;
    defaults.max = prevPanel.gauge.maxValue;
  }
  panel.fieldConfig.defaults = defaults;
  return options;
}
function sharedSingleStatMigrationHandler(panel) {
  var _b, _c;
  if (!panel.options) {
    return {};
  }
  const previousVersion = parseFloat(panel.pluginVersion || "6.1");
  let options = panel.options;
  if (previousVersion < 6.2) {
    options = migrateFromValueOptions(options);
  }
  if (previousVersion < 6.3) {
    options = moveThresholdsAndMappingsToField(options);
  }
  const { fieldOptions } = options;
  if (previousVersion < 6.6 && fieldOptions) {
    if (fieldOptions && fieldOptions.override) {
      const _a = options.fieldOptions, rest = __objRest$u(_a, ["override"]);
      options = __spreadProps$G(__spreadValues$U({}, options), {
        fieldOptions: __spreadProps$G(__spreadValues$U({}, rest), {
          overrides: []
        })
      });
    }
    let thresholds = (_b = fieldOptions == null ? void 0 : fieldOptions.defaults) == null ? void 0 : _b.thresholds;
    if (thresholds) {
      delete fieldOptions.defaults.thresholds;
    } else {
      thresholds = fieldOptions == null ? void 0 : fieldOptions.thresholds;
      delete fieldOptions.thresholds;
    }
    if (thresholds) {
      fieldOptions.defaults.thresholds = {
        mode: data.ThresholdsMode.Absolute,
        steps: thresholds
      };
    }
    const { defaults } = fieldOptions;
    if (defaults.color && typeof defaults.color === "string") {
      defaults.color = {
        mode: data.FieldColorModeId.Fixed,
        fixedColor: defaults.color
      };
    }
    data.validateFieldConfig(defaults);
  }
  if (previousVersion < 7) {
    panel.fieldConfig = panel.fieldConfig || { defaults: {}, overrides: [] };
    panel.fieldConfig = {
      defaults: fieldOptions && fieldOptions.defaults ? __spreadValues$U(__spreadValues$U({}, panel.fieldConfig.defaults), fieldOptions.defaults) : panel.fieldConfig.defaults,
      overrides: fieldOptions && fieldOptions.overrides ? [...panel.fieldConfig.overrides, ...fieldOptions.overrides] : panel.fieldConfig.overrides
    };
    if (fieldOptions) {
      options.reduceOptions = {
        values: fieldOptions.values,
        limit: fieldOptions.limit,
        calcs: fieldOptions.calcs
      };
    }
    delete options.fieldOptions;
  }
  if (previousVersion < 7.1) {
    const oldTitle = panel.fieldConfig.defaults.title;
    if (oldTitle !== void 0 && oldTitle !== null) {
      panel.fieldConfig.defaults.displayName = oldTitle;
      delete panel.fieldConfig.defaults.title;
    }
  }
  if (previousVersion < 8) {
    const config = (_c = panel.fieldConfig) == null ? void 0 : _c.defaults;
    let unit = config == null ? void 0 : config.unit;
    if (unit === "percent") {
      if (!lodash.isNumber(config.min)) {
        config.min = 0;
      }
      if (!lodash.isNumber(config.max)) {
        config.max = 100;
      }
    } else if (unit === "percentunit") {
      if (!lodash.isNumber(config.min)) {
        config.min = 0;
      }
      if (!lodash.isNumber(config.max)) {
        config.max = 1;
      }
    }
  }
  return options;
}
function moveThresholdsAndMappingsToField(old) {
  const { fieldOptions } = old;
  if (!fieldOptions) {
    return old;
  }
  const _a = old.fieldOptions, { mappings } = _a, rest = __objRest$u(_a, ["mappings"]);
  let thresholds = void 0;
  if (old.thresholds) {
    thresholds = {
      mode: data.ThresholdsMode.Absolute,
      steps: migrateOldThresholds(old.thresholds)
    };
  }
  return __spreadProps$G(__spreadValues$U({}, old), {
    fieldOptions: __spreadProps$G(__spreadValues$U({}, rest), {
      defaults: __spreadProps$G(__spreadValues$U({}, fieldOptions.defaults), {
        mappings,
        thresholds
      })
    })
  });
}
function migrateFromValueOptions(old) {
  const { valueOptions } = old;
  if (!valueOptions) {
    return old;
  }
  const fieldOptions = {};
  const fieldDefaults = {};
  fieldOptions.mappings = old.valueMappings;
  fieldOptions.thresholds = old.thresholds;
  fieldOptions.defaults = fieldDefaults;
  fieldDefaults.unit = valueOptions.unit;
  fieldDefaults.decimals = valueOptions.decimals;
  if (valueOptions.stat) {
    const reducer = data.fieldReducers.get(valueOptions.stat);
    if (reducer) {
      fieldOptions.calcs = [reducer.id];
    }
  }
  fieldDefaults.min = old.minValue;
  fieldDefaults.max = old.maxValue;
  const newOptions = __spreadProps$G(__spreadValues$U({}, old), {
    fieldOptions
  });
  return lodash.omit(newOptions, "valueMappings", "thresholds", "valueOptions", "minValue", "maxValue");
}
function migrateOldThresholds(thresholds) {
  if (!thresholds || !thresholds.length) {
    return void 0;
  }
  const copy = thresholds.map((t) => {
    return {
      // Drops 'index'
      value: t.value === null ? -Infinity : t.value,
      color: t.color
    };
  });
  data.sortThresholds(copy);
  copy[0].value = -Infinity;
  return copy;
}
function convertOldAngularValueMapping(panel) {
  return data.convertOldAngularValueMappings(panel);
}

const CallToActionCard = ({ message, callToActionElement, footer, className }) => {
  const css2 = useStyles2(getStyles$t);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx([css2.wrapper, className]) }, message && /* @__PURE__ */ React__default["default"].createElement("div", { className: css2.message }, message), callToActionElement, footer && /* @__PURE__ */ React__default["default"].createElement("div", { className: css2.footer }, footer));
};
const getStyles$t = (theme) => ({
  wrapper: css.css({
    label: "call-to-action-card",
    background: theme.colors.background.secondary,
    borderRadius: theme.shape.radius.default,
    display: "flex",
    flexDirection: "column",
    alignItems: "center",
    justifyContent: "center",
    flexGrow: 1,
    padding: theme.spacing(3),
    [theme.breakpoints.down("sm")]: {
      padding: theme.spacing(3, 1)
    }
  }),
  message: css.css({
    marginBottom: theme.spacing(3),
    fontStyle: "italic"
  }),
  footer: css.css({
    marginTop: theme.spacing(3)
  })
});

var __defProp$W = Object.defineProperty;
var __defProps$F = Object.defineProperties;
var __getOwnPropDescs$F = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$U = Object.getOwnPropertySymbols;
var __hasOwnProp$U = Object.prototype.hasOwnProperty;
var __propIsEnum$U = Object.prototype.propertyIsEnumerable;
var __defNormalProp$W = (obj, key, value) => key in obj ? __defProp$W(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$T = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$U.call(b, prop))
      __defNormalProp$W(a, prop, b[prop]);
  if (__getOwnPropSymbols$U)
    for (var prop of __getOwnPropSymbols$U(b)) {
      if (__propIsEnum$U.call(b, prop))
        __defNormalProp$W(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$F = (a, b) => __defProps$F(a, __getOwnPropDescs$F(b));
var __objRest$t = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$U.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$U)
    for (var prop of __getOwnPropSymbols$U(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$U.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const Switch = React__default["default"].forwardRef(
  (_a, ref) => {
    var _b = _a, { value, checked, onChange, id, label, disabled, invalid = false } = _b, inputProps = __objRest$t(_b, ["value", "checked", "onChange", "id", "label", "disabled", "invalid"]);
    if (checked) {
      data.deprecationWarning("Switch", "checked prop", "value");
    }
    const styles = useStyles2(getSwitchStyles);
    const switchIdRef = React.useRef(id ? id : lodash.uniqueId("switch-"));
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.switch, invalid && styles.invalid) }, /* @__PURE__ */ React__default["default"].createElement(
      "input",
      __spreadProps$F(__spreadValues$T({
        type: "checkbox",
        disabled,
        checked: value,
        onChange: (event) => {
          !disabled && (onChange == null ? void 0 : onChange(event));
        },
        id: switchIdRef.current
      }, inputProps), {
        ref
      })
    ), /* @__PURE__ */ React__default["default"].createElement("label", { htmlFor: switchIdRef.current, "aria-label": label != null ? label : "Toggle switch" }));
  }
);
Switch.displayName = "Switch";
const InlineSwitch = React__default["default"].forwardRef(
  (_c, ref) => {
    var _d = _c, { transparent, className, showLabel, label, value, id, invalid } = _d, props = __objRest$t(_d, ["transparent", "className", "showLabel", "label", "value", "id", "invalid"]);
    const styles = useStyles2(getSwitchStyles, transparent);
    return /* @__PURE__ */ React__default["default"].createElement(
      "div",
      {
        className: css.cx(styles.inlineContainer, className, props.disabled && styles.disabled, invalid && styles.invalid)
      },
      showLabel && /* @__PURE__ */ React__default["default"].createElement(
        "label",
        {
          htmlFor: id,
          className: css.cx(styles.inlineLabel, value && styles.inlineLabelEnabled, "inline-switch-label")
        },
        label
      ),
      /* @__PURE__ */ React__default["default"].createElement(Switch, __spreadProps$F(__spreadValues$T({}, props), { id, label, ref, value }))
    );
  }
);
InlineSwitch.displayName = "Switch";
const getSwitchStyles = (theme, transparent) => ({
  switch: css.css({
    width: "32px",
    height: "16px",
    position: "relative",
    lineHeight: 1,
    input: {
      opacity: 0,
      left: "-100vw",
      zIndex: -1e3,
      position: "absolute",
      "&:checked + label": {
        background: theme.colors.primary.main,
        borderColor: theme.colors.primary.main,
        "&:hover": {
          background: theme.colors.primary.shade
        },
        "&::after": {
          transform: "translate3d(18px, -50%, 0)",
          background: theme.colors.primary.contrastText
        }
      },
      "&:disabled + label": {
        background: theme.colors.action.disabledBackground,
        borderColor: theme.colors.border.weak,
        cursor: "not-allowed",
        "&:hover": {
          background: theme.colors.action.disabledBackground
        }
      },
      "&:disabled:checked + label": {
        "&::after": {
          background: theme.colors.text.disabled
        }
      },
      "&:focus + label, &:focus-visible + label": getFocusStyles(theme),
      "&:focus:not(:focus-visible) + label": getMouseFocusStyles()
    },
    label: {
      width: "100%",
      height: "100%",
      cursor: "pointer",
      borderRadius: theme.shape.radius.pill,
      background: theme.components.input.background,
      border: `1px solid ${theme.components.input.borderColor}`,
      transition: "all 0.3s ease",
      "&:hover": {
        borderColor: theme.components.input.borderHover
      },
      "&::after": {
        position: "absolute",
        display: "block",
        content: '""',
        width: "12px",
        height: "12px",
        borderRadius: theme.shape.radius.circle,
        background: theme.colors.text.secondary,
        boxShadow: theme.shadows.z1,
        top: "50%",
        transform: "translate3d(2px, -50%, 0)",
        transition: "transform 0.2s cubic-bezier(0.19, 1, 0.22, 1)",
        "@media (forced-colors: active)": {
          border: "1px solid transparent"
        }
      }
    }
  }),
  inlineContainer: css.css({
    padding: theme.spacing(0, 1),
    height: theme.spacing(theme.components.height.md),
    display: "inline-flex",
    alignItems: "center",
    background: transparent ? "transparent" : theme.components.input.background,
    border: `1px solid ${transparent ? "transparent" : theme.components.input.borderColor}`,
    borderRadius: theme.shape.radius.default,
    "&:hover": {
      border: `1px solid ${transparent ? "transparent" : theme.components.input.borderHover}`,
      ".inline-switch-label": {
        color: theme.colors.text.primary
      }
    }
  }),
  disabled: css.css({
    backgroundColor: "rgba(204, 204, 220, 0.04)",
    color: "rgba(204, 204, 220, 0.6)",
    border: "1px solid rgba(204, 204, 220, 0.04)"
  }),
  inlineLabel: css.css({
    cursor: "pointer",
    paddingRight: theme.spacing(1),
    color: theme.colors.text.secondary,
    whiteSpace: "nowrap"
  }),
  inlineLabelEnabled: css.css({
    color: theme.colors.text.primary
  }),
  invalid: css.css({
    "input + label, input:checked + label, input:hover + label": {
      border: `1px solid ${theme.colors.error.border}`
    }
  })
});

var __defProp$V = Object.defineProperty;
var __defProps$E = Object.defineProperties;
var __getOwnPropDescs$E = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$T = Object.getOwnPropertySymbols;
var __hasOwnProp$T = Object.prototype.hasOwnProperty;
var __propIsEnum$T = Object.prototype.propertyIsEnumerable;
var __defNormalProp$V = (obj, key, value) => key in obj ? __defProp$V(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$S = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$T.call(b, prop))
      __defNormalProp$V(a, prop, b[prop]);
  if (__getOwnPropSymbols$T)
    for (var prop of __getOwnPropSymbols$T(b)) {
      if (__propIsEnum$T.call(b, prop))
        __defNormalProp$V(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$E = (a, b) => __defProps$E(a, __getOwnPropDescs$E(b));
var __objRest$s = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$T.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$T)
    for (var prop of __getOwnPropSymbols$T(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$T.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const getStyles$s = (theme) => {
  return {
    list: css.css({
      borderBottom: `1px solid ${theme.colors.border.weak}`,
      "&:last-child": {
        border: "none"
      }
    }),
    wrapper: css.css({
      background: theme.colors.background.primary,
      width: "250px"
    }),
    item: css.css({
      background: "none",
      padding: "2px 8px",
      userSelect: "none",
      color: theme.colors.text.primary,
      cursor: "pointer",
      "&:hover": {
        background: theme.colors.action.hover
      }
    }),
    label: css.css({
      color: theme.colors.text.secondary
    }),
    activeItem: css.css({
      background: theme.colors.background.secondary,
      "&:hover": {
        background: theme.colors.background.secondary
      }
    }),
    itemValue: css.css({
      fontFamily: theme.typography.fontFamilyMonospace,
      fontSize: theme.typography.size.sm
    })
  };
};
const DataLinkSuggestions = (_a) => {
  var _b = _a, { suggestions } = _b, otherProps = __objRest$s(_b, ["suggestions"]);
  const ref = React.useRef(null);
  useClickAway__default["default"](ref, () => {
    if (otherProps.onClose) {
      otherProps.onClose();
    }
  });
  const groupedSuggestions = React.useMemo(() => {
    return lodash.groupBy(suggestions, (s) => s.origin);
  }, [suggestions]);
  const styles = useStyles2(getStyles$s);
  return /* @__PURE__ */ React__default["default"].createElement("div", { role: "menu", ref, className: styles.wrapper }, Object.keys(groupedSuggestions).map((key, i) => {
    const indexOffset = i === 0 ? 0 : Object.keys(groupedSuggestions).reduce((acc, current, index) => {
      if (index >= i) {
        return acc;
      }
      return acc + groupedSuggestions[current].length;
    }, 0);
    return /* @__PURE__ */ React__default["default"].createElement(
      DataLinkSuggestionsList,
      __spreadProps$E(__spreadValues$S({}, otherProps), {
        suggestions: groupedSuggestions[key],
        label: `${lodash.capitalize(key)}`,
        activeIndex: otherProps.activeIndex,
        activeIndexOffset: indexOffset,
        key
      })
    );
  }));
};
DataLinkSuggestions.displayName = "DataLinkSuggestions";
const DataLinkSuggestionsList = React__default["default"].memo(
  ({
    activeIndex,
    activeIndexOffset,
    label,
    onClose,
    onSuggestionSelect,
    suggestions,
    activeRef: selectedRef
  }) => {
    const styles = useStyles2(getStyles$s);
    return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(
      List,
      {
        className: styles.list,
        items: suggestions,
        renderItem: (item, index) => {
          const isActive = index + activeIndexOffset === activeIndex;
          return (
            // key events are handled by DataLinkInput
            // eslint-disable-next-line jsx-a11y/click-events-have-key-events
            /* @__PURE__ */ React__default["default"].createElement(
              "div",
              {
                role: "menuitem",
                tabIndex: 0,
                className: css.cx(styles.item, isActive && styles.activeItem),
                ref: isActive ? selectedRef : void 0,
                onClick: () => {
                  onSuggestionSelect(item);
                },
                title: item.documentation
              },
              /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.itemValue }, /* @__PURE__ */ React__default["default"].createElement("span", { className: styles.label }, label), " ", item.label)
            )
          );
        }
      }
    ));
  }
);
DataLinkSuggestionsList.displayName = "DataLinkSuggestionsList";

class SelectionReference {
  getBoundingClientRect() {
    const selection = window.getSelection();
    const node = selection && selection.anchorNode;
    if (node && node.parentElement) {
      const rect = node.parentElement.getBoundingClientRect();
      return rect;
    }
    const fallbackDOMRect = {
      top: 0,
      left: 0,
      bottom: 0,
      right: 0,
      width: 0,
      height: 0,
      x: 0,
      y: 0,
      toJSON: () => {
      }
    };
    return fallbackDOMRect;
  }
  get clientWidth() {
    return this.getBoundingClientRect().width;
  }
  get clientHeight() {
    return this.getBoundingClientRect().height;
  }
}

var __defProp$U = Object.defineProperty;
var __defProps$D = Object.defineProperties;
var __getOwnPropDescs$D = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$S = Object.getOwnPropertySymbols;
var __hasOwnProp$S = Object.prototype.hasOwnProperty;
var __propIsEnum$S = Object.prototype.propertyIsEnumerable;
var __defNormalProp$U = (obj, key, value) => key in obj ? __defProp$U(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$R = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$S.call(b, prop))
      __defNormalProp$U(a, prop, b[prop]);
  if (__getOwnPropSymbols$S)
    for (var prop of __getOwnPropSymbols$S(b)) {
      if (__propIsEnum$S.call(b, prop))
        __defNormalProp$U(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$D = (a, b) => __defProps$D(a, __getOwnPropDescs$D(b));
const modulo = (a, n) => a - n * Math.floor(a / n);
const datalinksSyntax = {
  builtInVariable: {
    pattern: /(\${\S+?})/
  }
};
const plugins = [
  SlatePrism(
    {
      onlyIn: (node) => "type" in node && node.type === "code_block",
      getSyntax: () => "links"
    },
    __spreadProps$D(__spreadValues$R({}, Prism__default["default"].languages), { links: datalinksSyntax })
  )
];
const getStyles$r = (theme) => ({
  input: getInputStyles({ theme, invalid: false }).input,
  editor: css.css({
    ".token.builtInVariable": {
      color: theme.colors.success.text
    },
    ".token.variable": {
      color: theme.colors.primary.text
    }
  }),
  suggestionsWrapper: css.css({
    boxShadow: theme.shadows.z2
  }),
  // Wrapper with child selector needed.
  // When classnames are applied to the same element as the wrapper, it causes the suggestions to stop working
  wrapperOverrides: css.css({
    width: "100%",
    "> .slate-query-field__wrapper": {
      padding: 0,
      backgroundColor: "transparent",
      border: "none"
    }
  })
});
const DataLinkInput = React.memo(
  ({
    value,
    onChange,
    suggestions,
    placeholder = "http://your-grafana.com/d/000000010/annotations"
  }) => {
    const editorRef = React.useRef(null);
    const styles = useStyles2(getStyles$r);
    const [showingSuggestions, setShowingSuggestions] = React.useState(false);
    const [suggestionsIndex, setSuggestionsIndex] = React.useState(0);
    const [linkUrl, setLinkUrl] = React.useState(makeValue(value));
    const prevLinkUrl = usePrevious__default["default"](linkUrl);
    const [scrollTop, setScrollTop] = React.useState(0);
    const middleware = [
      react$1.offset(({ rects }) => ({
        alignmentAxis: rects.reference.width
      })),
      react$1.flip({
        fallbackAxisSideDirection: "start",
        // see https://floating-ui.com/docs/flip#combining-with-shift
        crossAxis: false,
        boundary: document.body
      }),
      react$1.shift()
    ];
    const { refs, floatingStyles } = react$1.useFloating({
      open: showingSuggestions,
      placement: "bottom-start",
      onOpenChange: setShowingSuggestions,
      middleware,
      whileElementsMounted: react$1.autoUpdate,
      strategy: "fixed"
    });
    const stateRef = React.useRef({ showingSuggestions, suggestions, suggestionsIndex, linkUrl, onChange });
    stateRef.current = { showingSuggestions, suggestions, suggestionsIndex, linkUrl, onChange };
    const activeRef = React.useRef(null);
    React.useEffect(() => {
      setScrollTop(getElementPosition(activeRef.current, suggestionsIndex));
    }, [suggestionsIndex]);
    const onKeyDown = React__default["default"].useCallback((event, next) => {
      if (!stateRef.current.showingSuggestions) {
        if (event.key === "=" || event.key === "$" || event.keyCode === 32 && event.ctrlKey) {
          const selectionRef = new SelectionReference();
          refs.setReference(selectionRef);
          return setShowingSuggestions(true);
        }
        return next();
      }
      switch (event.key) {
        case "Backspace":
        case "Escape":
          setShowingSuggestions(false);
          return setSuggestionsIndex(0);
        case "Enter":
          event.preventDefault();
          return onVariableSelect(stateRef.current.suggestions[stateRef.current.suggestionsIndex]);
        case "ArrowDown":
        case "ArrowUp":
          event.preventDefault();
          const direction = event.key === "ArrowDown" ? 1 : -1;
          return setSuggestionsIndex((index) => modulo(index + direction, stateRef.current.suggestions.length));
        default:
          return next();
      }
    }, []);
    React.useEffect(() => {
      if (prevLinkUrl && prevLinkUrl.selection.isFocused && !linkUrl.selection.isFocused) {
        stateRef.current.onChange(Plain__default["default"].serialize(linkUrl));
      }
    }, [linkUrl, prevLinkUrl]);
    const onUrlChange = React__default["default"].useCallback(({ value: value2 }) => {
      setLinkUrl(value2);
    }, []);
    const onVariableSelect = (item, editor = editorRef.current) => {
      const precedingChar = getCharactersAroundCaret();
      const precedingDollar = precedingChar === "$";
      if (item.origin !== data.VariableOrigin.Template || item.value === data.DataLinkBuiltInVars.includeVars) {
        editor.insertText(`${precedingDollar ? "" : "$"}{${item.value}}`);
      } else {
        editor.insertText(`${precedingDollar ? "" : "$"}{${item.value}:queryparam}`);
      }
      setLinkUrl(editor.value);
      setShowingSuggestions(false);
      setSuggestionsIndex(0);
      stateRef.current.onChange(Plain__default["default"].serialize(editor.value));
    };
    const getCharactersAroundCaret = () => {
      const input = document.getElementById("data-link-input");
      let precedingChar = "", sel, range;
      if (window.getSelection) {
        sel = window.getSelection();
        if (sel && sel.rangeCount > 0) {
          range = sel.getRangeAt(0).cloneRange();
          range.collapse(true);
          range.setStart(input, 0);
          precedingChar = range.toString().slice(-1);
        }
      }
      return precedingChar;
    };
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.wrapperOverrides }, /* @__PURE__ */ React__default["default"].createElement("div", { className: "slate-query-field__wrapper" }, /* @__PURE__ */ React__default["default"].createElement("div", { id: "data-link-input", className: "slate-query-field" }, showingSuggestions && /* @__PURE__ */ React__default["default"].createElement(Portal$1, null, /* @__PURE__ */ React__default["default"].createElement("div", { ref: refs.setFloating, style: floatingStyles }, /* @__PURE__ */ React__default["default"].createElement(
      CustomScrollbar,
      {
        scrollTop,
        autoHeightMax: "300px",
        setScrollTop: ({ scrollTop: scrollTop2 }) => setScrollTop(scrollTop2)
      },
      /* @__PURE__ */ React__default["default"].createElement(
        DataLinkSuggestions,
        {
          activeRef,
          suggestions: stateRef.current.suggestions,
          onSuggestionSelect: onVariableSelect,
          onClose: () => setShowingSuggestions(false),
          activeIndex: suggestionsIndex
        }
      )
    ))), /* @__PURE__ */ React__default["default"].createElement(
      slateReact.Editor,
      {
        schema: SCHEMA,
        ref: editorRef,
        placeholder,
        value: stateRef.current.linkUrl,
        onChange: onUrlChange,
        onKeyDown: (event, _editor, next) => onKeyDown(event, next),
        plugins,
        className: css.cx(
          styles.editor,
          styles.input,
          css.css({
            padding: "3px 8px"
          })
        )
      }
    ))));
  }
);
DataLinkInput.displayName = "DataLinkInput";
function getElementPosition(suggestionElement, activeIndex) {
  var _a;
  return ((_a = suggestionElement == null ? void 0 : suggestionElement.clientHeight) != null ? _a : 0) * activeIndex;
}

var __defProp$T = Object.defineProperty;
var __defProps$C = Object.defineProperties;
var __getOwnPropDescs$C = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$R = Object.getOwnPropertySymbols;
var __hasOwnProp$R = Object.prototype.hasOwnProperty;
var __propIsEnum$R = Object.prototype.propertyIsEnumerable;
var __defNormalProp$T = (obj, key, value) => key in obj ? __defProp$T(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$Q = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$R.call(b, prop))
      __defNormalProp$T(a, prop, b[prop]);
  if (__getOwnPropSymbols$R)
    for (var prop of __getOwnPropSymbols$R(b)) {
      if (__propIsEnum$R.call(b, prop))
        __defNormalProp$T(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$C = (a, b) => __defProps$C(a, __getOwnPropDescs$C(b));
const getStyles$q = (theme) => ({
  listItem: css.css({
    marginBottom: theme.spacing()
  }),
  infoText: css.css({
    paddingBottom: theme.spacing(2),
    marginLeft: "66px",
    color: theme.colors.text.secondary
  })
});
const DataLinkEditor = React__default["default"].memo(({ index, value, onChange, suggestions, isLast }) => {
  const styles = useStyles2(getStyles$q);
  const onUrlChange = (url, callback) => {
    onChange(index, __spreadProps$C(__spreadValues$Q({}, value), { url }), callback);
  };
  const onTitleChange = (event) => {
    onChange(index, __spreadProps$C(__spreadValues$Q({}, value), { title: event.target.value }));
  };
  const onOpenInNewTabChanged = () => {
    onChange(index, __spreadProps$C(__spreadValues$Q({}, value), { targetBlank: !value.targetBlank }));
  };
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.listItem }, /* @__PURE__ */ React__default["default"].createElement(Field, { label: "Title" }, /* @__PURE__ */ React__default["default"].createElement(Input, { value: value.title, onChange: onTitleChange, placeholder: "Show details" })), /* @__PURE__ */ React__default["default"].createElement(
    Field,
    {
      label: "URL",
      invalid: isCompactUrl(value.url),
      error: "Data link is an Explore URL in a deprecated format. Please visit the URL to be redirected, and edit this data link to use that URL."
    },
    /* @__PURE__ */ React__default["default"].createElement(DataLinkInput, { value: value.url, onChange: onUrlChange, suggestions })
  ), /* @__PURE__ */ React__default["default"].createElement(Field, { label: "Open in new tab" }, /* @__PURE__ */ React__default["default"].createElement(Switch, { value: value.targetBlank || false, onChange: onOpenInNewTabChanged })), isLast && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.infoText }, "With data links you can reference data variables like series name, labels and values. Type CMD+Space, CTRL+Space, or $ to open variable suggestions."));
});
DataLinkEditor.displayName = "DataLinkEditor";

const DataLinkEditorModalContent = ({
  link,
  index,
  getSuggestions,
  onSave,
  onCancel
}) => {
  const [dirtyLink, setDirtyLink] = React.useState(link);
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(
    DataLinkEditor,
    {
      value: dirtyLink,
      index,
      isLast: false,
      suggestions: getSuggestions(),
      onChange: (index2, link2) => {
        setDirtyLink(link2);
      }
    }
  ), /* @__PURE__ */ React__default["default"].createElement(Modal.ButtonRow, null, /* @__PURE__ */ React__default["default"].createElement(Button, { variant: "secondary", onClick: () => onCancel(index), fill: "outline" }, "Cancel"), /* @__PURE__ */ React__default["default"].createElement(
    Button,
    {
      onClick: () => {
        onSave(index, dirtyLink);
      }
    },
    "Save"
  )));
};

const DataLinksListItem = ({ link, onEdit, onRemove }) => {
  const styles = useStyles2(getDataLinkListItemStyles);
  const { title = "", url = "" } = link;
  const hasTitle = title.trim() !== "";
  const hasUrl = url.trim() !== "";
  const isCompactExploreUrl = isCompactUrl(url);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.wrapper }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.titleWrapper }, /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.url, !hasUrl && styles.notConfigured, isCompactExploreUrl && styles.errored) }, hasTitle ? title : "Data link title not provided"), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.actionButtons }, /* @__PURE__ */ React__default["default"].createElement(IconButton, { name: "pen", onClick: onEdit, tooltip: "Edit data link title" }), /* @__PURE__ */ React__default["default"].createElement(IconButton, { name: "times", onClick: onRemove, tooltip: "Remove data link title" }))), /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      className: css.cx(styles.url, !hasUrl && styles.notConfigured, isCompactExploreUrl && styles.errored),
      title: url
    },
    hasUrl ? url : "Data link url not provided"
  ), isCompactExploreUrl && /* @__PURE__ */ React__default["default"].createElement(FieldValidationMessage, null, "Explore data link may not work in the future. Please edit."));
};
const getDataLinkListItemStyles = (theme) => {
  return {
    wrapper: css.css({
      marginBottom: theme.spacing(2),
      width: "100%",
      "&:last-child": {
        marginBottom: 0
      },
      display: "flex",
      flexDirection: "column"
    }),
    titleWrapper: css.css({
      label: "data-links-list-item-title",
      justifyContent: "space-between",
      display: "flex",
      width: "100%",
      alignItems: "center"
    }),
    actionButtons: css.css({
      marginLeft: theme.spacing(1),
      display: "flex"
    }),
    errored: css.css({
      color: theme.colors.error.text,
      fontStyle: "italic"
    }),
    notConfigured: css.css({
      fontStyle: "italic"
    }),
    title: css.css({
      color: theme.colors.text.primary,
      fontSize: theme.typography.size.sm,
      fontWeight: theme.typography.fontWeightMedium
    }),
    url: css.css({
      color: theme.colors.text.secondary,
      fontSize: theme.typography.size.sm,
      whiteSpace: "nowrap",
      overflow: "hidden",
      textOverflow: "ellipsis",
      maxWidth: "90%"
    })
  };
};

const DataLinksInlineEditor = ({ links, onChange, getSuggestions, data }) => {
  const [editIndex, setEditIndex] = React.useState(null);
  const [isNew, setIsNew] = React.useState(false);
  const styles = useStyles2(getDataLinksInlineEditorStyles);
  const linksSafe = links != null ? links : [];
  const isEditing = editIndex !== null;
  const onDataLinkChange = (index, link) => {
    if (isNew) {
      if (link.title.trim() === "" && link.url.trim() === "") {
        setIsNew(false);
        setEditIndex(null);
        return;
      } else {
        setEditIndex(null);
        setIsNew(false);
      }
    }
    const update = lodash.cloneDeep(linksSafe);
    update[index] = link;
    onChange(update);
    setEditIndex(null);
  };
  const onDataLinkAdd = () => {
    let update = lodash.cloneDeep(linksSafe);
    setEditIndex(update.length);
    setIsNew(true);
  };
  const onDataLinkCancel = (index) => {
    if (isNew) {
      setIsNew(false);
    }
    setEditIndex(null);
  };
  const onDataLinkRemove = (index) => {
    const update = lodash.cloneDeep(linksSafe);
    update.splice(index, 1);
    onChange(update);
  };
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, linksSafe.length > 0 && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.wrapper }, linksSafe.map((l, i) => {
    return /* @__PURE__ */ React__default["default"].createElement(
      DataLinksListItem,
      {
        key: `${l.title}/${i}`,
        index: i,
        link: l,
        onChange: onDataLinkChange,
        onEdit: () => setEditIndex(i),
        onRemove: () => onDataLinkRemove(i),
        data
      }
    );
  })), isEditing && editIndex !== null && /* @__PURE__ */ React__default["default"].createElement(
    Modal,
    {
      title: "Edit link",
      isOpen: true,
      closeOnBackdropClick: false,
      onDismiss: () => {
        onDataLinkCancel();
      }
    },
    /* @__PURE__ */ React__default["default"].createElement(
      DataLinkEditorModalContent,
      {
        index: editIndex,
        link: isNew ? { title: "", url: "" } : linksSafe[editIndex],
        data,
        onSave: onDataLinkChange,
        onCancel: onDataLinkCancel,
        getSuggestions
      }
    )
  ), /* @__PURE__ */ React__default["default"].createElement(Button, { size: "sm", icon: "plus", onClick: onDataLinkAdd, variant: "secondary" }, "Add link"));
};
const getDataLinksInlineEditorStyles = (theme) => ({
  wrapper: css.css({
    marginBottom: theme.spacing(2)
  })
});

var __defProp$S = Object.defineProperty;
var __defProps$B = Object.defineProperties;
var __getOwnPropDescs$B = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$Q = Object.getOwnPropertySymbols;
var __hasOwnProp$Q = Object.prototype.hasOwnProperty;
var __propIsEnum$Q = Object.prototype.propertyIsEnumerable;
var __defNormalProp$S = (obj, key, value) => key in obj ? __defProp$S(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$P = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$Q.call(b, prop))
      __defNormalProp$S(a, prop, b[prop]);
  if (__getOwnPropSymbols$Q)
    for (var prop of __getOwnPropSymbols$Q(b)) {
      if (__propIsEnum$Q.call(b, prop))
        __defNormalProp$S(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$B = (a, b) => __defProps$B(a, __getOwnPropDescs$B(b));
var __objRest$r = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$Q.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$Q)
    for (var prop of __getOwnPropSymbols$Q(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$Q.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const InfoBox = React__default["default"].memo(
  React__default["default"].forwardRef(
    (_a, ref) => {
      var _b = _a, { title, className, children, branded, url, urlTitle, onDismiss, severity = "info" } = _b, otherProps = __objRest$r(_b, ["title", "className", "children", "branded", "url", "urlTitle", "onDismiss", "severity"]);
      const styles = useStyles2(getStyles$p);
      return /* @__PURE__ */ React__default["default"].createElement(Alert, __spreadProps$B(__spreadValues$P({ severity, className }, otherProps), { ref, title }), /* @__PURE__ */ React__default["default"].createElement("div", null, children), url && /* @__PURE__ */ React__default["default"].createElement("a", { href: url, className: css.cx("external-link", styles.docsLink), target: "_blank", rel: "noreferrer" }, /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "book" }), " ", urlTitle || "Read more"));
    }
  )
);
InfoBox.displayName = "InfoBox";
const getStyles$p = (theme) => ({
  docsLink: css.css({
    display: "inline-block",
    marginTop: theme.spacing(2)
  })
});

var __defProp$R = Object.defineProperty;
var __getOwnPropSymbols$P = Object.getOwnPropertySymbols;
var __hasOwnProp$P = Object.prototype.hasOwnProperty;
var __propIsEnum$P = Object.prototype.propertyIsEnumerable;
var __defNormalProp$R = (obj, key, value) => key in obj ? __defProp$R(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$O = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$P.call(b, prop))
      __defNormalProp$R(a, prop, b[prop]);
  if (__getOwnPropSymbols$P)
    for (var prop of __getOwnPropSymbols$P(b)) {
      if (__propIsEnum$P.call(b, prop))
        __defNormalProp$R(a, prop, b[prop]);
    }
  return a;
};
var __objRest$q = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$P.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$P)
    for (var prop of __getOwnPropSymbols$P(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$P.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const BadgeComponent = React__default["default"].memo((_a) => {
  var _b = _a, { icon, color, text, tooltip, className } = _b, otherProps = __objRest$q(_b, ["icon", "color", "text", "tooltip", "className"]);
  const styles = useStyles2(getStyles$o, color);
  const badge = /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$O({ className: css.cx(styles.wrapper, className) }, otherProps), icon && /* @__PURE__ */ React__default["default"].createElement(Icon, { name: icon, size: "sm" }), text);
  return tooltip ? /* @__PURE__ */ React__default["default"].createElement(Tooltip, { content: tooltip, placement: "auto" }, badge) : badge;
});
BadgeComponent.displayName = "Badge";
const BadgeSkeleton = ({ rootProps }) => {
  const styles = useStyles2(getSkeletonStyles);
  return /* @__PURE__ */ React__default["default"].createElement(Skeleton__default["default"], __spreadValues$O({ width: 60, height: 22, containerClassName: styles.container }, rootProps));
};
const Badge = attachSkeleton(BadgeComponent, BadgeSkeleton);
const getSkeletonStyles = () => ({
  container: css.css({
    lineHeight: 1
  })
});
const getStyles$o = (theme, color) => {
  let sourceColor = theme.visualization.getColorByName(color);
  let borderColor = "";
  let bgColor = "";
  let textColor = "";
  if (theme.isDark) {
    bgColor = tinycolor__default["default"](sourceColor).setAlpha(0.15).toString();
    borderColor = tinycolor__default["default"](sourceColor).setAlpha(0.25).toString();
    textColor = tinycolor__default["default"](sourceColor).lighten(15).toString();
  } else {
    bgColor = tinycolor__default["default"](sourceColor).setAlpha(0.15).toString();
    borderColor = tinycolor__default["default"](sourceColor).setAlpha(0.25).toString();
    textColor = tinycolor__default["default"](sourceColor).darken(20).toString();
  }
  return {
    wrapper: css.css({
      display: "inline-flex",
      padding: "1px 4px",
      borderRadius: theme.shape.radius.default,
      background: bgColor,
      border: `1px solid ${borderColor}`,
      color: textColor,
      fontWeight: theme.typography.fontWeightRegular,
      gap: "2px",
      fontSize: theme.typography.bodySmall.fontSize,
      lineHeight: theme.typography.bodySmall.lineHeight,
      alignItems: "center"
    })
  };
};

var __defProp$Q = Object.defineProperty;
var __getOwnPropSymbols$O = Object.getOwnPropertySymbols;
var __hasOwnProp$O = Object.prototype.hasOwnProperty;
var __propIsEnum$O = Object.prototype.propertyIsEnumerable;
var __defNormalProp$Q = (obj, key, value) => key in obj ? __defProp$Q(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$N = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$O.call(b, prop))
      __defNormalProp$Q(a, prop, b[prop]);
  if (__getOwnPropSymbols$O)
    for (var prop of __getOwnPropSymbols$O(b)) {
      if (__propIsEnum$O.call(b, prop))
        __defNormalProp$Q(a, prop, b[prop]);
    }
  return a;
};
var __objRest$p = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$O.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$O)
    for (var prop of __getOwnPropSymbols$O(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$O.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const FeatureInfoBox = React__default["default"].memo(
  React__default["default"].forwardRef((_a, ref) => {
    var _b = _a, { title, featureState } = _b, otherProps = __objRest$p(_b, ["title", "featureState"]);
    const styles = useStyles2(getFeatureInfoBoxStyles);
    const titleEl = featureState ? /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.badge }, /* @__PURE__ */ React__default["default"].createElement(FeatureBadge, { featureState })), /* @__PURE__ */ React__default["default"].createElement("h3", null, title)) : /* @__PURE__ */ React__default["default"].createElement("h3", null, title);
    return /* @__PURE__ */ React__default["default"].createElement(InfoBox, __spreadValues$N({ branded: true, title: titleEl, urlTitle: "Read documentation", ref }, otherProps));
  })
);
FeatureInfoBox.displayName = "FeatureInfoBox";
const getFeatureInfoBoxStyles = (theme) => {
  return {
    badge: css.css({
      marginBottom: theme.spacing(1)
    })
  };
};
const FeatureBadge = ({ featureState, tooltip }) => {
  const display = getPanelStateBadgeDisplayModel(featureState);
  return /* @__PURE__ */ React__default["default"].createElement(Badge, { text: display.text, color: display.color, icon: display.icon, tooltip });
};
function getPanelStateBadgeDisplayModel(featureState) {
  switch (featureState) {
    case data.FeatureState.alpha:
      return {
        text: "Alpha",
        icon: "exclamation-triangle",
        color: "orange"
      };
  }
  return {
    text: "Beta",
    icon: "rocket",
    color: "blue"
  };
}

function formatString(str) {
  return str.replace(/\\/g, "\\\\").replace(/"/g, '\\"');
}
function isObject(value2) {
  const type = typeof value2;
  return !!value2 && type === "object";
}
function getObjectName(object) {
  if (object === void 0) {
    return "";
  }
  if (object === null) {
    return "Object";
  }
  if (typeof object === "object" && !object.constructor) {
    return "Object";
  }
  const funcNameRegex = /function ([^(]*)/;
  const results = funcNameRegex.exec(object.constructor.toString());
  if (results && results.length > 1) {
    return results[1];
  } else {
    return "";
  }
}
function getType(object) {
  if (object === null) {
    return "null";
  }
  return typeof object;
}
function getValuePreview(object, value2) {
  const type = getType(object);
  if (type === "null" || type === "undefined") {
    return type;
  }
  if (type === "string") {
    value2 = '"' + formatString(value2) + '"';
  }
  if (type === "function") {
    return object.toString().replace(/[\r\n]/g, "").replace(/\{.*\}/, "") + "{\u2026}";
  }
  return value2;
}
function cssClass(className) {
  return `json-formatter-${className}`;
}
function createElement(type, className, content) {
  const el = document.createElement(type);
  if (className) {
    el.classList.add(cssClass(className));
  }
  if (content !== void 0) {
    if (content instanceof Node) {
      el.appendChild(content);
    } else {
      el.appendChild(document.createTextNode(String(content)));
    }
  }
  return el;
}

var __defProp$P = Object.defineProperty;
var __defNormalProp$P = (obj, key, value) => key in obj ? __defProp$P(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$6 = (obj, key, value) => {
  __defNormalProp$P(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
const DATE_STRING_REGEX = /(^\d{1,4}[\.|\\/|-]\d{1,2}[\.|\\/|-]\d{1,4})(\s*(?:0?[1-9]:[0-5]|1(?=[012])\d:[0-5])\d\s*[ap]m)?$/;
const PARTIAL_DATE_REGEX = /\d{2}:\d{2}:\d{2} GMT-\d{4}/;
const JSON_DATE_REGEX = /\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}.\d{3}Z/;
const MAX_ANIMATED_TOGGLE_ITEMS = 10;
const requestAnimationFrame$1 = typeof window !== "undefined" && window.requestAnimationFrame || ((cb) => {
  cb();
  return 0;
});
const _defaultConfig = {
  animateOpen: true,
  animateClose: true
};
class JsonExplorer {
  /**
   * @param {object} json The JSON object you want to render. It has to be an
   * object or array. Do NOT pass raw JSON string.
   *
   * @param {number} [open=1] his number indicates up to how many levels the
   * rendered tree should expand. Set it to `0` to make the whole tree collapsed
   * or set it to `Infinity` to expand the tree deeply
   *
   * @param {object} [config=defaultConfig] -
   *  defaultConfig = {
   *   hoverPreviewEnabled: false,
   *   hoverPreviewArrayCount: 100,
   *   hoverPreviewFieldCount: 5
   * }
   *
   * Available configurations:
   *  #####Hover Preview
   * * `hoverPreviewEnabled`:  enable preview on hover
   * * `hoverPreviewArrayCount`: number of array items to show in preview Any
   *    array larger than this number will be shown as `Array[XXX]` where `XXX`
   *    is length of the array.
   * * `hoverPreviewFieldCount`: number of object properties to show for object
   *   preview. Any object with more properties that thin number will be
   *   truncated.
   *
   * @param {string} [key=undefined] The key that this object in its parent
   * context
   */
  constructor(json, open = 1, config = _defaultConfig, key) {
    this.json = json;
    this.open = open;
    this.config = config;
    this.key = key;
    // Hold the open state after the toggler is used
    __publicField$6(this, "_isOpen", null);
    // A reference to the element that we render to
    __publicField$6(this, "element", null);
    __publicField$6(this, "skipChildren", false);
  }
  /*
   * is formatter open?
   */
  get isOpen() {
    if (this._isOpen !== null) {
      return this._isOpen;
    } else {
      return this.open > 0;
    }
  }
  /*
   * set open state (from toggler)
   */
  set isOpen(value) {
    this._isOpen = value;
  }
  /*
   * is this a date string?
   */
  get isDate() {
    return this.type === "string" && (DATE_STRING_REGEX.test(this.json) || JSON_DATE_REGEX.test(this.json) || PARTIAL_DATE_REGEX.test(this.json));
  }
  /*
   * is this a URL string?
   */
  get isUrl() {
    return this.type === "string" && this.json.indexOf("http") === 0;
  }
  /*
   * is this an array?
   */
  get isArray() {
    return Array.isArray(this.json);
  }
  /*
   * is this an object?
   * Note: In this context arrays are object as well
   */
  get isObject() {
    return isObject(this.json);
  }
  /*
   * is this an empty object with no properties?
   */
  get isEmptyObject() {
    return !this.keys.length && !this.isArray;
  }
  /*
   * is this an empty object or array?
   */
  get isEmpty() {
    return this.isEmptyObject || this.keys && !this.keys.length && this.isArray;
  }
  /*
   * did we receive a key argument?
   * This means that the formatter was called as a sub formatter of a parent formatter
   */
  get hasKey() {
    return typeof this.key !== "undefined";
  }
  /*
   * if this is an object, get constructor function name
   */
  get constructorName() {
    return getObjectName(this.json);
  }
  /*
   * get type of this value
   * Possible values: all JavaScript primitive types plus "array" and "null"
   */
  get type() {
    return getType(this.json);
  }
  /*
   * get object keys
   * If there is an empty key we pad it wit quotes to make it visible
   */
  get keys() {
    if (this.isObject) {
      return Object.keys(this.json).map((key) => key ? key : '""');
    } else {
      return [];
    }
  }
  /**
   * Toggles `isOpen` state
   *
   */
  toggleOpen() {
    this.isOpen = !this.isOpen;
    if (this.element) {
      if (this.isOpen) {
        this.appendChildren(this.config.animateOpen);
      } else {
        this.removeChildren(this.config.animateClose);
      }
      this.element.classList.toggle(cssClass("open"));
    }
  }
  /**
   * Open all children up to a certain depth.
   * Allows actions such as expand all/collapse all
   *
   */
  openAtDepth(depth = 1) {
    if (depth < 0) {
      return;
    }
    this.open = depth;
    this.isOpen = depth !== 0;
    if (this.element) {
      this.removeChildren(false);
      if (depth === 0) {
        this.element.classList.remove(cssClass("open"));
      } else {
        this.appendChildren(this.config.animateOpen);
        this.element.classList.add(cssClass("open"));
      }
    }
  }
  isNumberArray() {
    return this.json.length > 0 && this.json.length < 4 && (lodash.isNumber(this.json[0]) || lodash.isNumber(this.json[1]));
  }
  renderArray() {
    const arrayWrapperSpan = createElement("span");
    arrayWrapperSpan.appendChild(createElement("span", "bracket", "["));
    if (this.isNumberArray()) {
      this.json.forEach((val, index) => {
        if (index > 0) {
          arrayWrapperSpan.appendChild(createElement("span", "array-comma", ","));
        }
        arrayWrapperSpan.appendChild(createElement("span", "number", val));
      });
      this.skipChildren = true;
    } else {
      arrayWrapperSpan.appendChild(createElement("span", "number", this.json.length));
    }
    arrayWrapperSpan.appendChild(createElement("span", "bracket", "]"));
    return arrayWrapperSpan;
  }
  /**
   * Renders an HTML element and installs event listeners
   *
   * @returns {HTMLDivElement}
   */
  render(skipRoot = false) {
    this.element = createElement("div", "row");
    const togglerLink = createElement("a", "toggler-link");
    const togglerIcon = createElement("span", "toggler");
    if (this.isObject) {
      togglerLink.appendChild(togglerIcon);
    }
    if (this.hasKey) {
      togglerLink.appendChild(createElement("span", "key", `${this.key}:`));
    }
    if (this.isObject) {
      const value = createElement("span", "value");
      const objectWrapperSpan = createElement("span");
      const constructorName = createElement("span", "constructor-name", this.constructorName);
      objectWrapperSpan.appendChild(constructorName);
      if (this.isArray) {
        const arrayWrapperSpan = this.renderArray();
        objectWrapperSpan.appendChild(arrayWrapperSpan);
      }
      value.appendChild(objectWrapperSpan);
      togglerLink.appendChild(value);
    } else {
      const value = this.isUrl ? createElement("a") : createElement("span");
      value.classList.add(cssClass(this.type));
      if (this.isDate) {
        value.classList.add(cssClass("date"));
      }
      if (this.isUrl) {
        value.classList.add(cssClass("url"));
        value.setAttribute("href", this.json);
      }
      const valuePreview = getValuePreview(this.json, this.json);
      value.appendChild(document.createTextNode(valuePreview));
      togglerLink.appendChild(value);
    }
    const children = createElement("div", "children");
    if (this.isObject) {
      children.classList.add(cssClass("object"));
    }
    if (this.isArray) {
      children.classList.add(cssClass("array"));
    }
    if (this.isEmpty) {
      children.classList.add(cssClass("empty"));
    }
    if (this.config && this.config.theme) {
      this.element.classList.add(cssClass(this.config.theme));
    }
    if (this.isOpen) {
      this.element.classList.add(cssClass("open"));
    }
    if (!skipRoot) {
      this.element.appendChild(togglerLink);
    }
    if (!this.skipChildren) {
      this.element.appendChild(children);
    } else {
      togglerLink.removeChild(togglerIcon);
    }
    if (this.isObject && this.isOpen) {
      this.appendChildren();
    }
    if (this.isObject) {
      togglerLink.addEventListener("click", this.toggleOpen.bind(this));
    }
    return this.element;
  }
  /**
   * Appends all the children to children element
   * Animated option is used when user triggers this via a click
   */
  appendChildren(animated = false) {
    const children = this.element && this.element.querySelector(`div.${cssClass("children")}`);
    if (!children || this.isEmpty) {
      return;
    }
    if (animated) {
      let index = 0;
      const addAChild = () => {
        const key = this.keys[index];
        const formatter = new JsonExplorer(this.json[key], this.open - 1, this.config, key);
        children.appendChild(formatter.render());
        index += 1;
        if (index < this.keys.length) {
          if (index > MAX_ANIMATED_TOGGLE_ITEMS) {
            addAChild();
          } else {
            requestAnimationFrame$1(addAChild);
          }
        }
      };
      requestAnimationFrame$1(addAChild);
    } else {
      this.keys.forEach((key) => {
        const formatter = new JsonExplorer(this.json[key], this.open - 1, this.config, key);
        children.appendChild(formatter.render());
      });
    }
  }
  /**
   * Removes all the children from children element
   * Animated option is used when user triggers this via a click
   */
  removeChildren(animated = false) {
    const childrenElement = this.element && this.element.querySelector(`div.${cssClass("children")}`);
    if (animated) {
      let childrenRemoved = 0;
      const removeAChild = () => {
        if (childrenElement && childrenElement.children.length) {
          childrenElement.removeChild(childrenElement.children[0]);
          childrenRemoved += 1;
          if (childrenRemoved > MAX_ANIMATED_TOGGLE_ITEMS) {
            removeAChild();
          } else {
            requestAnimationFrame$1(removeAChild);
          }
        }
      };
      requestAnimationFrame$1(removeAChild);
    } else {
      if (childrenElement) {
        childrenElement.innerHTML = "";
      }
    }
  }
}

var __defProp$O = Object.defineProperty;
var __defNormalProp$O = (obj, key, value) => key in obj ? __defProp$O(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __publicField$5 = (obj, key, value) => {
  __defNormalProp$O(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
class JSONFormatter extends React.PureComponent {
  constructor() {
    super(...arguments);
    __publicField$5(this, "wrapperRef", React.createRef());
    __publicField$5(this, "renderJson", () => {
      const { json, config, open, onDidRender } = this.props;
      const wrapperEl = this.wrapperRef.current;
      const formatter = new JsonExplorer(json, open, config);
      const hasChildren = wrapperEl.hasChildNodes();
      if (hasChildren) {
        wrapperEl.replaceChild(formatter.render(), wrapperEl.lastChild);
      } else {
        wrapperEl.appendChild(formatter.render());
      }
      if (onDidRender) {
        onDidRender(formatter.json);
      }
    });
  }
  componentDidMount() {
    this.renderJson();
  }
  componentDidUpdate() {
    this.renderJson();
  }
  render() {
    const { className } = this.props;
    return /* @__PURE__ */ React__default["default"].createElement("div", { className, ref: this.wrapperRef });
  }
}
__publicField$5(JSONFormatter, "defaultProps", {
  open: 3,
  config: {
    animateOpen: true
  }
});

var __defProp$N = Object.defineProperty;
var __getOwnPropSymbols$N = Object.getOwnPropertySymbols;
var __hasOwnProp$N = Object.prototype.hasOwnProperty;
var __propIsEnum$N = Object.prototype.propertyIsEnumerable;
var __defNormalProp$N = (obj, key, value) => key in obj ? __defProp$N(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$M = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$N.call(b, prop))
      __defNormalProp$N(a, prop, b[prop]);
  if (__getOwnPropSymbols$N)
    for (var prop of __getOwnPropSymbols$N(b)) {
      if (__propIsEnum$N.call(b, prop))
        __defNormalProp$N(a, prop, b[prop]);
    }
  return a;
};
var __publicField$4 = (obj, key, value) => {
  __defNormalProp$N(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
class ErrorBoundary extends React.PureComponent {
  constructor() {
    super(...arguments);
    __publicField$4(this, "state", {
      error: null,
      errorInfo: null
    });
  }
  componentDidCatch(error, errorInfo) {
    var _a, _b;
    (_b = (_a = faroWebSdk.faro) == null ? void 0 : _a.api) == null ? void 0 : _b.pushError(error);
    this.setState({ error, errorInfo });
    if (this.props.onError) {
      this.props.onError(error);
    }
  }
  componentDidUpdate(prevProps) {
    const { dependencies, onRecover } = this.props;
    if (this.state.error) {
      if (dependencies && prevProps.dependencies) {
        for (let i = 0; i < dependencies.length; i++) {
          if (dependencies[i] !== prevProps.dependencies[i]) {
            this.setState({ error: null, errorInfo: null });
            if (onRecover) {
              onRecover();
            }
            break;
          }
        }
      }
    }
  }
  render() {
    const { children } = this.props;
    const { error, errorInfo } = this.state;
    return children({
      error,
      errorInfo
    });
  }
}
class ErrorBoundaryAlert extends React.PureComponent {
  render() {
    const { title, children, style, dependencies } = this.props;
    return /* @__PURE__ */ React__default["default"].createElement(ErrorBoundary, { dependencies }, ({ error, errorInfo }) => {
      if (!errorInfo) {
        return children;
      }
      if (style === "alertbox") {
        return /* @__PURE__ */ React__default["default"].createElement(Alert, { title: title || "" }, /* @__PURE__ */ React__default["default"].createElement("details", { style: { whiteSpace: "pre-wrap" } }, error && error.toString(), /* @__PURE__ */ React__default["default"].createElement("br", null), errorInfo.componentStack));
      }
      return /* @__PURE__ */ React__default["default"].createElement(ErrorWithStack, { title: title || "", error, errorInfo });
    });
  }
}
__publicField$4(ErrorBoundaryAlert, "defaultProps", {
  title: "An unexpected error happened",
  style: "alertbox"
});
function withErrorBoundary(Component, errorBoundaryProps = {}) {
  const comp = (props) => /* @__PURE__ */ React__default["default"].createElement(ErrorBoundaryAlert, __spreadValues$M({}, errorBoundaryProps), /* @__PURE__ */ React__default["default"].createElement(Component, __spreadValues$M({}, props)));
  comp.displayName = "WithErrorBoundary";
  return comp;
}

var __defProp$M = Object.defineProperty;
var __defProps$A = Object.defineProperties;
var __getOwnPropDescs$A = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$M = Object.getOwnPropertySymbols;
var __hasOwnProp$M = Object.prototype.hasOwnProperty;
var __propIsEnum$M = Object.prototype.propertyIsEnumerable;
var __defNormalProp$M = (obj, key, value) => key in obj ? __defProp$M(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$L = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$M.call(b, prop))
      __defNormalProp$M(a, prop, b[prop]);
  if (__getOwnPropSymbols$M)
    for (var prop of __getOwnPropSymbols$M(b)) {
      if (__propIsEnum$M.call(b, prop))
        __defNormalProp$M(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$A = (a, b) => __defProps$A(a, __getOwnPropDescs$A(b));
const BasicAuthSettings = ({ dataSourceConfig, onChange }) => {
  const password = dataSourceConfig.secureJsonData ? dataSourceConfig.secureJsonData.basicAuthPassword : "";
  const onPasswordReset = () => {
    onChange(__spreadProps$A(__spreadValues$L({}, dataSourceConfig), {
      secureJsonData: __spreadProps$A(__spreadValues$L({}, dataSourceConfig.secureJsonData), {
        basicAuthPassword: ""
      }),
      secureJsonFields: __spreadProps$A(__spreadValues$L({}, dataSourceConfig.secureJsonFields), {
        basicAuthPassword: false
      })
    }));
  };
  const onPasswordChange = (event) => {
    onChange(__spreadProps$A(__spreadValues$L({}, dataSourceConfig), {
      secureJsonData: __spreadProps$A(__spreadValues$L({}, dataSourceConfig.secureJsonData), {
        basicAuthPassword: event.currentTarget.value
      })
    }));
  };
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(InlineField, { disabled: dataSourceConfig.readOnly }, /* @__PURE__ */ React__default["default"].createElement(
    FormField,
    {
      label: "User",
      labelWidth: 10,
      inputWidth: 18,
      placeholder: "user",
      value: dataSourceConfig.basicAuthUser,
      onChange: (event) => onChange(__spreadProps$A(__spreadValues$L({}, dataSourceConfig), { basicAuthUser: event.currentTarget.value }))
    }
  )), /* @__PURE__ */ React__default["default"].createElement(InlineField, { disabled: dataSourceConfig.readOnly }, /* @__PURE__ */ React__default["default"].createElement(
    SecretFormField,
    {
      isConfigured: !!(dataSourceConfig.secureJsonFields && dataSourceConfig.secureJsonFields.basicAuthPassword),
      value: password || "",
      inputWidth: 18,
      labelWidth: 10,
      onReset: onPasswordReset,
      onChange: onPasswordChange
    }
  )));
};

var __defProp$L = Object.defineProperty;
var __defProps$z = Object.defineProperties;
var __getOwnPropDescs$z = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$L = Object.getOwnPropertySymbols;
var __hasOwnProp$L = Object.prototype.hasOwnProperty;
var __propIsEnum$L = Object.prototype.propertyIsEnumerable;
var __defNormalProp$L = (obj, key, value) => key in obj ? __defProp$L(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$K = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$L.call(b, prop))
      __defNormalProp$L(a, prop, b[prop]);
  if (__getOwnPropSymbols$L)
    for (var prop of __getOwnPropSymbols$L(b)) {
      if (__propIsEnum$L.call(b, prop))
        __defNormalProp$L(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$z = (a, b) => __defProps$z(a, __getOwnPropDescs$z(b));
var __publicField$3 = (obj, key, value) => {
  __defNormalProp$L(obj, typeof key !== "symbol" ? key + "" : key, value);
  return value;
};
const getCustomHeaderRowStyles = () => ({
  layout: css.css({
    display: "flex",
    alignItems: "center",
    marginBottom: "4px",
    "> *": {
      marginLeft: "4px",
      marginBottom: 0,
      height: "100%",
      "&:first-child, &:last-child": {
        marginLeft: 0
      }
    }
  })
});
const CustomHeaderRow = ({ header, onBlur, onChange, onRemove, onReset }) => {
  const styles = useStyles2(getCustomHeaderRowStyles);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.layout }, /* @__PURE__ */ React__default["default"].createElement(
    FormField,
    {
      label: "Header",
      name: "name",
      placeholder: "X-Custom-Header",
      labelWidth: 5,
      value: header.name || "",
      onChange: (e) => onChange(__spreadProps$z(__spreadValues$K({}, header), { name: e.target.value })),
      onBlur
    }
  ), /* @__PURE__ */ React__default["default"].createElement(
    SecretFormField,
    {
      label: "Value",
      "aria-label": "Value",
      name: "value",
      isConfigured: header.configured,
      value: header.value,
      labelWidth: 5,
      inputWidth: header.configured ? 11 : 12,
      placeholder: "Header Value",
      onReset: () => onReset(header.id),
      onChange: (e) => onChange(__spreadProps$z(__spreadValues$K({}, header), { value: e.target.value })),
      onBlur
    }
  ), /* @__PURE__ */ React__default["default"].createElement(
    Button,
    {
      type: "button",
      "aria-label": "Remove header",
      variant: "secondary",
      size: "xs",
      onClick: (_e) => onRemove(header.id)
    },
    /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "trash-alt" })
  ));
};
CustomHeaderRow.displayName = "CustomHeaderRow";
class CustomHeadersSettings extends React.PureComponent {
  constructor(props) {
    super(props);
    __publicField$3(this, "state", {
      headers: []
    });
    __publicField$3(this, "updateSettings", () => {
      const { headers } = this.state;
      const newJsonData = Object.fromEntries(
        Object.entries(this.props.dataSourceConfig.jsonData).filter(([key, val]) => !key.startsWith("httpHeaderName"))
      );
      const newSecureJsonData = Object.fromEntries(
        Object.entries(this.props.dataSourceConfig.secureJsonData || {}).filter(
          ([key, val]) => !key.startsWith("httpHeaderValue")
        )
      );
      for (const [index, header] of headers.entries()) {
        newJsonData[`httpHeaderName${index + 1}`] = header.name;
        if (!header.configured) {
          newSecureJsonData[`httpHeaderValue${index + 1}`] = header.value;
        }
      }
      this.props.onChange(__spreadProps$z(__spreadValues$K({}, this.props.dataSourceConfig), {
        jsonData: newJsonData,
        secureJsonData: newSecureJsonData
      }));
    });
    __publicField$3(this, "onHeaderAdd", () => {
      this.setState((prevState) => {
        return { headers: [...prevState.headers, { id: lodash.uniqueId(), name: "", value: "", configured: false }] };
      });
    });
    __publicField$3(this, "onHeaderChange", (headerIndex, value) => {
      this.setState(({ headers }) => {
        return {
          headers: headers.map((item, index) => {
            if (headerIndex !== index) {
              return item;
            }
            return __spreadValues$K({}, value);
          })
        };
      });
    });
    __publicField$3(this, "onHeaderReset", (headerId) => {
      this.setState(({ headers }) => {
        return {
          headers: headers.map((h, i) => {
            if (h.id !== headerId) {
              return h;
            }
            return __spreadProps$z(__spreadValues$K({}, h), {
              value: "",
              configured: false
            });
          })
        };
      });
    });
    __publicField$3(this, "onHeaderRemove", (headerId) => {
      this.setState(
        ({ headers }) => ({
          headers: headers.filter((h) => h.id !== headerId)
        }),
        this.updateSettings
      );
    });
    const { jsonData, secureJsonData, secureJsonFields } = this.props.dataSourceConfig;
    this.state = {
      headers: Object.keys(jsonData).sort().filter((key) => key.startsWith("httpHeaderName")).map((key, index) => {
        return {
          id: lodash.uniqueId(),
          name: jsonData[key],
          value: secureJsonData !== void 0 ? secureJsonData[key] : "",
          configured: secureJsonFields && secureJsonFields[`httpHeaderValue${index + 1}`] || false
        };
      })
    };
  }
  render() {
    const { headers } = this.state;
    const { dataSourceConfig } = this.props;
    return /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-group" }, /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form" }, /* @__PURE__ */ React__default["default"].createElement("h6", null, "Custom HTTP Headers")), /* @__PURE__ */ React__default["default"].createElement("div", null, headers.map((header, i) => /* @__PURE__ */ React__default["default"].createElement(
      CustomHeaderRow,
      {
        key: header.id,
        header,
        onChange: (h) => {
          this.onHeaderChange(i, h);
        },
        onBlur: this.updateSettings,
        onRemove: this.onHeaderRemove,
        onReset: this.onHeaderReset
      }
    ))), !dataSourceConfig.readOnly && /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form" }, /* @__PURE__ */ React__default["default"].createElement(
      Button,
      {
        variant: "secondary",
        icon: "plus",
        type: "button",
        onClick: (e) => {
          this.onHeaderAdd();
        }
      },
      "Add header"
    )));
  }
}

var __defProp$K = Object.defineProperty;
var __defProps$y = Object.defineProperties;
var __getOwnPropDescs$y = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$K = Object.getOwnPropertySymbols;
var __hasOwnProp$K = Object.prototype.hasOwnProperty;
var __propIsEnum$K = Object.prototype.propertyIsEnumerable;
var __defNormalProp$K = (obj, key, value) => key in obj ? __defProp$K(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$J = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$K.call(b, prop))
      __defNormalProp$K(a, prop, b[prop]);
  if (__getOwnPropSymbols$K)
    for (var prop of __getOwnPropSymbols$K(b)) {
      if (__propIsEnum$K.call(b, prop))
        __defNormalProp$K(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$y = (a, b) => __defProps$y(a, __getOwnPropDescs$y(b));
const LABEL_WIDTH$1 = 26;
const HttpProxySettings = ({
  dataSourceConfig,
  onChange,
  showForwardOAuthIdentityOption = true
}) => {
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-inline" }, /* @__PURE__ */ React__default["default"].createElement(InlineField, { label: "TLS Client Auth", labelWidth: LABEL_WIDTH$1, disabled: dataSourceConfig.readOnly }, /* @__PURE__ */ React__default["default"].createElement(
    InlineSwitch,
    {
      id: "http-settings-tls-client-auth",
      value: dataSourceConfig.jsonData.tlsAuth || false,
      onChange: (event) => onChange(__spreadProps$y(__spreadValues$J({}, dataSourceConfig.jsonData), { tlsAuth: event.currentTarget.checked }))
    }
  )), /* @__PURE__ */ React__default["default"].createElement(
    InlineField,
    {
      label: "With CA Cert",
      tooltip: "Needed for verifying self-signed TLS Certs",
      labelWidth: LABEL_WIDTH$1,
      disabled: dataSourceConfig.readOnly
    },
    /* @__PURE__ */ React__default["default"].createElement(
      InlineSwitch,
      {
        id: "http-settings-ca-cert",
        value: dataSourceConfig.jsonData.tlsAuthWithCACert || false,
        onChange: (event) => onChange(__spreadProps$y(__spreadValues$J({}, dataSourceConfig.jsonData), { tlsAuthWithCACert: event.currentTarget.checked }))
      }
    )
  )), /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-inline" }, /* @__PURE__ */ React__default["default"].createElement(InlineField, { label: "Skip TLS Verify", labelWidth: LABEL_WIDTH$1, disabled: dataSourceConfig.readOnly }, /* @__PURE__ */ React__default["default"].createElement(
    InlineSwitch,
    {
      id: "http-settings-skip-tls-verify",
      value: dataSourceConfig.jsonData.tlsSkipVerify || false,
      onChange: (event) => onChange(__spreadProps$y(__spreadValues$J({}, dataSourceConfig.jsonData), { tlsSkipVerify: event.currentTarget.checked }))
    }
  ))), showForwardOAuthIdentityOption && /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-inline" }, /* @__PURE__ */ React__default["default"].createElement(
    InlineField,
    {
      label: "Forward OAuth Identity",
      tooltip: "Forward the user's upstream OAuth identity to the data source (Their access token gets passed along).",
      labelWidth: LABEL_WIDTH$1,
      disabled: dataSourceConfig.readOnly
    },
    /* @__PURE__ */ React__default["default"].createElement(
      InlineSwitch,
      {
        id: "http-settings-forward-oauth",
        value: dataSourceConfig.jsonData.oauthPassThru || false,
        onChange: (event) => onChange(__spreadProps$y(__spreadValues$J({}, dataSourceConfig.jsonData), { oauthPassThru: event.currentTarget.checked }))
      }
    )
  )));
};

var __defProp$J = Object.defineProperty;
var __defProps$x = Object.defineProperties;
var __getOwnPropDescs$x = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$J = Object.getOwnPropertySymbols;
var __hasOwnProp$J = Object.prototype.hasOwnProperty;
var __propIsEnum$J = Object.prototype.propertyIsEnumerable;
var __defNormalProp$J = (obj, key, value) => key in obj ? __defProp$J(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$I = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$J.call(b, prop))
      __defNormalProp$J(a, prop, b[prop]);
  if (__getOwnPropSymbols$J)
    for (var prop of __getOwnPropSymbols$J(b)) {
      if (__propIsEnum$J.call(b, prop))
        __defNormalProp$J(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$x = (a, b) => __defProps$x(a, __getOwnPropDescs$x(b));
function SecureSocksProxySettings({
  options,
  onOptionsChange
}) {
  var _a;
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("h3", { className: "page-heading" }, "Secure Socks Proxy"), /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-group" }, /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-inline" }, /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form" }, /* @__PURE__ */ React__default["default"].createElement(
    InlineField,
    {
      labelWidth: 26,
      label: "Enabled",
      tooltip: "Connect to this datasource via the secure socks proxy."
    },
    /* @__PURE__ */ React__default["default"].createElement(
      InlineSwitch,
      {
        value: (_a = options.jsonData.enableSecureSocksProxy) != null ? _a : false,
        onChange: (event) => onOptionsChange(__spreadProps$x(__spreadValues$I({}, options), {
          jsonData: __spreadProps$x(__spreadValues$I({}, options.jsonData), { enableSecureSocksProxy: event.currentTarget.checked })
        }))
      }
    )
  )))));
}

var __defProp$I = Object.defineProperty;
var __getOwnPropSymbols$I = Object.getOwnPropertySymbols;
var __hasOwnProp$I = Object.prototype.hasOwnProperty;
var __propIsEnum$I = Object.prototype.propertyIsEnumerable;
var __defNormalProp$I = (obj, key, value) => key in obj ? __defProp$I(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$H = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$I.call(b, prop))
      __defNormalProp$I(a, prop, b[prop]);
  if (__getOwnPropSymbols$I)
    for (var prop of __getOwnPropSymbols$I(b)) {
      if (__propIsEnum$I.call(b, prop))
        __defNormalProp$I(a, prop, b[prop]);
    }
  return a;
};
var __objRest$o = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$I.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$I)
    for (var prop of __getOwnPropSymbols$I(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$I.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const InlineFieldRow = (_a) => {
  var _b = _a, { children, className } = _b, htmlProps = __objRest$o(_b, ["children", "className"]);
  const styles = useStyles2(getStyles$n);
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadValues$H({ className: css.cx(styles.container, className) }, htmlProps), children);
};
const getStyles$n = (theme) => {
  return {
    container: css.css({
      label: "InlineFieldRow",
      display: "flex",
      flexDirection: "row",
      flexWrap: "wrap",
      alignContent: "flex-start",
      rowGap: theme.spacing(0.5)
    })
  };
};

const CertificationKey = ({ hasCert, label, onChange, onClick, placeholder }) => {
  return /* @__PURE__ */ React__default["default"].createElement(InlineFieldRow, null, /* @__PURE__ */ React__default["default"].createElement(InlineField, { label, labelWidth: 14, disabled: hasCert }, hasCert ? /* @__PURE__ */ React__default["default"].createElement(Input, { type: "text", value: "configured", width: 24 }) : /* @__PURE__ */ React__default["default"].createElement(TextArea, { rows: 7, onChange, placeholder, required: true })), hasCert && /* @__PURE__ */ React__default["default"].createElement(Button, { variant: "secondary", onClick, style: { marginLeft: 4 } }, "Reset"));
};

var __defProp$H = Object.defineProperty;
var __defProps$w = Object.defineProperties;
var __getOwnPropDescs$w = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$H = Object.getOwnPropertySymbols;
var __hasOwnProp$H = Object.prototype.hasOwnProperty;
var __propIsEnum$H = Object.prototype.propertyIsEnumerable;
var __defNormalProp$H = (obj, key, value) => key in obj ? __defProp$H(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$G = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$H.call(b, prop))
      __defNormalProp$H(a, prop, b[prop]);
  if (__getOwnPropSymbols$H)
    for (var prop of __getOwnPropSymbols$H(b)) {
      if (__propIsEnum$H.call(b, prop))
        __defNormalProp$H(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$w = (a, b) => __defProps$w(a, __getOwnPropDescs$w(b));
const TLSAuthSettings = ({ dataSourceConfig, onChange }) => {
  const hasTLSCACert = dataSourceConfig.secureJsonFields && dataSourceConfig.secureJsonFields.tlsCACert;
  const hasTLSClientCert = dataSourceConfig.secureJsonFields && dataSourceConfig.secureJsonFields.tlsClientCert;
  const hasTLSClientKey = dataSourceConfig.secureJsonFields && dataSourceConfig.secureJsonFields.tlsClientKey;
  const hasServerName = dataSourceConfig.jsonData && dataSourceConfig.jsonData.serverName;
  const onResetClickFactory = (field) => (event) => {
    event.preventDefault();
    const newSecureJsonFields = __spreadValues$G({}, dataSourceConfig.secureJsonFields);
    newSecureJsonFields[field] = false;
    onChange(__spreadProps$w(__spreadValues$G({}, dataSourceConfig), {
      secureJsonFields: newSecureJsonFields
    }));
  };
  const onCertificateChangeFactory = (field) => (event) => {
    const newSecureJsonData = __spreadValues$G({}, dataSourceConfig.secureJsonData);
    newSecureJsonData[field] = event.currentTarget.value;
    onChange(__spreadProps$w(__spreadValues$G({}, dataSourceConfig), {
      secureJsonData: newSecureJsonData
    }));
  };
  const onServerNameLabelChange = (event) => {
    const newJsonData = __spreadProps$w(__spreadValues$G({}, dataSourceConfig.jsonData), {
      serverName: event.currentTarget.value
    });
    onChange(__spreadProps$w(__spreadValues$G({}, dataSourceConfig), {
      jsonData: newJsonData
    }));
  };
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-group" }, /* @__PURE__ */ React__default["default"].createElement(
    "div",
    {
      className: css.cx(
        "gf-form",
        css.css({
          alignItems: "baseline"
        })
      )
    },
    /* @__PURE__ */ React__default["default"].createElement("h6", null, "TLS/SSL Auth Details"),
    /* @__PURE__ */ React__default["default"].createElement(
      Tooltip,
      {
        placement: "right-end",
        content: "TLS/SSL Certs are encrypted and stored in the Grafana database.",
        theme: "info"
      },
      /* @__PURE__ */ React__default["default"].createElement(Icon, { name: "info-circle", size: "xs", style: { marginLeft: "10px" } })
    )
  ), /* @__PURE__ */ React__default["default"].createElement("div", null, dataSourceConfig.jsonData.tlsAuthWithCACert && /* @__PURE__ */ React__default["default"].createElement(
    CertificationKey,
    {
      hasCert: !!hasTLSCACert,
      onChange: onCertificateChangeFactory("tlsCACert"),
      placeholder: "Begins with -----BEGIN CERTIFICATE-----",
      label: "CA Cert",
      onClick: onResetClickFactory("tlsCACert")
    }
  ), dataSourceConfig.jsonData.tlsAuth && /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form" }, /* @__PURE__ */ React__default["default"].createElement(
    FormField,
    {
      label: "ServerName",
      labelWidth: 7,
      inputWidth: 30,
      placeholder: "domain.example.com",
      value: hasServerName && dataSourceConfig.jsonData.serverName,
      onChange: onServerNameLabelChange
    }
  )), /* @__PURE__ */ React__default["default"].createElement(
    CertificationKey,
    {
      hasCert: !!hasTLSClientCert,
      label: "Client Cert",
      onChange: onCertificateChangeFactory("tlsClientCert"),
      placeholder: "Begins with -----BEGIN CERTIFICATE-----",
      onClick: onResetClickFactory("tlsClientCert")
    }
  ), /* @__PURE__ */ React__default["default"].createElement(
    CertificationKey,
    {
      hasCert: !!hasTLSClientKey,
      label: "Client Key",
      placeholder: "Begins with -----BEGIN RSA PRIVATE KEY-----",
      onChange: onCertificateChangeFactory("tlsClientKey"),
      onClick: onResetClickFactory("tlsClientKey")
    }
  ))));
};

var __defProp$G = Object.defineProperty;
var __defProps$v = Object.defineProperties;
var __getOwnPropDescs$v = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$G = Object.getOwnPropertySymbols;
var __hasOwnProp$G = Object.prototype.hasOwnProperty;
var __propIsEnum$G = Object.prototype.propertyIsEnumerable;
var __defNormalProp$G = (obj, key, value) => key in obj ? __defProp$G(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$F = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$G.call(b, prop))
      __defNormalProp$G(a, prop, b[prop]);
  if (__getOwnPropSymbols$G)
    for (var prop of __getOwnPropSymbols$G(b)) {
      if (__propIsEnum$G.call(b, prop))
        __defNormalProp$G(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$v = (a, b) => __defProps$v(a, __getOwnPropDescs$v(b));
const ACCESS_OPTIONS = [
  {
    label: "Server (default)",
    value: "proxy"
  },
  {
    label: "Browser",
    value: "direct"
  }
];
const DEFAULT_ACCESS_OPTION = {
  label: "Server (default)",
  value: "proxy"
};
const HttpAccessHelp = () => /* @__PURE__ */ React__default["default"].createElement("div", { className: "grafana-info-box m-t-2" }, /* @__PURE__ */ React__default["default"].createElement("p", null, "Access mode controls how requests to the data source will be handled.", /* @__PURE__ */ React__default["default"].createElement("strong", null, "\xA0", /* @__PURE__ */ React__default["default"].createElement("i", null, "Server")), " ", "should be the preferred way if nothing else is stated."), /* @__PURE__ */ React__default["default"].createElement("div", { className: "alert-title" }, "Server access mode (Default):"), /* @__PURE__ */ React__default["default"].createElement("p", null, "All requests will be made from the browser to Grafana backend/server which in turn will forward the requests to the data source and by that circumvent possible Cross-Origin Resource Sharing (CORS) requirements. The URL needs to be accessible from the grafana backend/server if you select this access mode."), /* @__PURE__ */ React__default["default"].createElement("div", { className: "alert-title" }, "Browser access mode:"), /* @__PURE__ */ React__default["default"].createElement("p", null, "All requests will be made from the browser directly to the data source and may be subject to Cross-Origin Resource Sharing (CORS) requirements. The URL needs to be accessible from the browser if you select this access mode."));
const LABEL_WIDTH = 26;
const DataSourceHttpSettings = (props) => {
  const {
    defaultUrl,
    dataSourceConfig,
    onChange,
    showAccessOptions,
    sigV4AuthToggleEnabled,
    showForwardOAuthIdentityOption,
    azureAuthSettings,
    renderSigV4Editor,
    secureSocksDSProxyEnabled,
    urlLabel,
    urlDocs
  } = props;
  const [isAccessHelpVisible, setIsAccessHelpVisible] = React.useState(false);
  const [azureAuthEnabled, setAzureAuthEnabled] = React.useState(false);
  const theme = useTheme2();
  let urlTooltip;
  const onSettingsChange = React.useCallback(
    (change) => {
      const isAzureAuthEnabled = (azureAuthSettings == null ? void 0 : azureAuthSettings.azureAuthSupported) && azureAuthSettings.getAzureAuthEnabled(dataSourceConfig) || false;
      setAzureAuthEnabled(isAzureAuthEnabled);
      if (isAzureAuthEnabled) {
        const tmpOauthPassThru = dataSourceConfig.jsonData.oauthPassThru !== void 0 ? dataSourceConfig.jsonData.oauthPassThru : false;
        change = __spreadProps$v(__spreadValues$F({}, change), {
          jsonData: __spreadProps$v(__spreadValues$F({}, dataSourceConfig.jsonData), {
            oauthPassThru: isAzureAuthEnabled ? false : tmpOauthPassThru
          })
        });
      }
      onChange(__spreadValues$F(__spreadValues$F({}, dataSourceConfig), change));
    },
    [azureAuthSettings, dataSourceConfig, onChange]
  );
  switch (dataSourceConfig.access) {
    case "direct":
      urlTooltip = /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, "Your access method is ", /* @__PURE__ */ React__default["default"].createElement("em", null, "Browser"), ", this means the URL needs to be accessible from the browser.", urlDocs);
      break;
    case "proxy":
      urlTooltip = /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, "Your access method is ", /* @__PURE__ */ React__default["default"].createElement("em", null, "Server"), ", this means the URL needs to be accessible from the grafana backend/server.", urlDocs);
      break;
    default:
      urlTooltip = /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, "Specify a complete HTTP URL (for example http://your_server:8080) ", urlDocs);
  }
  const accessSelect = /* @__PURE__ */ React__default["default"].createElement(
    Select,
    {
      "aria-label": "Access",
      className: "width-20 gf-form-input",
      options: ACCESS_OPTIONS,
      value: ACCESS_OPTIONS.filter((o) => o.value === dataSourceConfig.access)[0] || DEFAULT_ACCESS_OPTION,
      onChange: (selectedValue) => onSettingsChange({ access: selectedValue.value }),
      disabled: dataSourceConfig.readOnly
    }
  );
  const isValidUrl = /^(ftp|http|https):\/\/(\w+:{0,1}\w*@)?(\S+)(:[0-9]+)?(\/|\/([\w#!:.?+=&%@!\-\/]))?$/.test(
    dataSourceConfig.url
  );
  const notValidStyle = css.css({
    boxShadow: `inset 0 0px 5px ${theme.v1.palette.red}`
  });
  const inputStyle = css.cx({ [`width-20`]: true, [notValidStyle]: !isValidUrl });
  const fromFieldId = React.useId();
  const urlInput = /* @__PURE__ */ React__default["default"].createElement(
    Input$1,
    {
      id: fromFieldId,
      className: inputStyle,
      placeholder: defaultUrl,
      value: dataSourceConfig.url,
      "data-testid": e2eSelectors.selectors.components.DataSource.DataSourceHttpSettings.urlInput,
      onChange: (event) => onSettingsChange({ url: event.currentTarget.value }),
      disabled: dataSourceConfig.readOnly
    }
  );
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-group" }, /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("h3", { className: "page-heading" }, "HTTP"), /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-group" }, /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form" }, /* @__PURE__ */ React__default["default"].createElement(
    FormField,
    {
      interactive: urlDocs ? true : false,
      label: urlLabel != null ? urlLabel : "URL",
      labelWidth: 13,
      tooltip: urlTooltip,
      inputEl: urlInput
    }
  )), showAccessOptions && /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-inline" }, /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form" }, /* @__PURE__ */ React__default["default"].createElement(FormField, { label: "Access", labelWidth: 13, inputWidth: 20, inputEl: accessSelect })), /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form" }, /* @__PURE__ */ React__default["default"].createElement(
    "button",
    {
      type: "button",
      className: "gf-form-label query-keyword pointer",
      onClick: () => setIsAccessHelpVisible((isVisible) => !isVisible)
    },
    "Help\xA0",
    /* @__PURE__ */ React__default["default"].createElement(Icon, { name: isAccessHelpVisible ? "angle-down" : "angle-right", style: { marginBottom: 0 } })
  ))), isAccessHelpVisible && /* @__PURE__ */ React__default["default"].createElement(HttpAccessHelp, null)), dataSourceConfig.access === "proxy" && /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-group" }, /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form" }, /* @__PURE__ */ React__default["default"].createElement(
    InlineFormLabel,
    {
      width: 13,
      tooltip: "Grafana proxy deletes forwarded cookies by default. Specify cookies by name that should be forwarded to the data source."
    },
    "Allowed cookies"
  ), /* @__PURE__ */ React__default["default"].createElement(
    TagsInput,
    {
      tags: dataSourceConfig.jsonData.keepCookies,
      width: 40,
      onChange: (cookies) => onSettingsChange({ jsonData: __spreadProps$v(__spreadValues$F({}, dataSourceConfig.jsonData), { keepCookies: cookies }) }),
      disabled: dataSourceConfig.readOnly
    }
  )), /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form" }, /* @__PURE__ */ React__default["default"].createElement(
    FormField,
    {
      label: "Timeout",
      type: "number",
      labelWidth: 13,
      inputWidth: 20,
      tooltip: "HTTP request timeout in seconds",
      placeholder: "Timeout in seconds",
      "aria-label": "Timeout in seconds",
      value: dataSourceConfig.jsonData.timeout,
      onChange: (event) => {
        onSettingsChange({
          jsonData: __spreadProps$v(__spreadValues$F({}, dataSourceConfig.jsonData), { timeout: parseInt(event.currentTarget.value, 10) })
        });
      },
      disabled: dataSourceConfig.readOnly
    }
  ))))), /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("h3", { className: "page-heading" }, "Auth"), /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-group" }, /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-inline" }, /* @__PURE__ */ React__default["default"].createElement(InlineField, { label: "Basic auth", labelWidth: LABEL_WIDTH, disabled: dataSourceConfig.readOnly }, /* @__PURE__ */ React__default["default"].createElement(
    InlineSwitch,
    {
      id: "http-settings-basic-auth",
      value: dataSourceConfig.basicAuth,
      onChange: (event) => {
        onSettingsChange({ basicAuth: event.currentTarget.checked });
      }
    }
  )), /* @__PURE__ */ React__default["default"].createElement(
    InlineField,
    {
      label: "With Credentials",
      tooltip: "Whether credentials such as cookies or auth headers should be sent with cross-site requests.",
      labelWidth: LABEL_WIDTH,
      disabled: dataSourceConfig.readOnly
    },
    /* @__PURE__ */ React__default["default"].createElement(
      InlineSwitch,
      {
        id: "http-settings-with-credentials",
        value: dataSourceConfig.withCredentials,
        onChange: (event) => {
          onSettingsChange({ withCredentials: event.currentTarget.checked });
        }
      }
    )
  )), (azureAuthSettings == null ? void 0 : azureAuthSettings.azureAuthSupported) && /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-inline" }, /* @__PURE__ */ React__default["default"].createElement(
    InlineField,
    {
      label: "Azure Authentication",
      tooltip: "Use Azure authentication for Azure endpoint.",
      labelWidth: LABEL_WIDTH,
      disabled: dataSourceConfig.readOnly
    },
    /* @__PURE__ */ React__default["default"].createElement(
      InlineSwitch,
      {
        id: "http-settings-azure-auth",
        value: azureAuthEnabled,
        onChange: (event) => {
          onSettingsChange(
            azureAuthSettings.setAzureAuthEnabled(dataSourceConfig, event.currentTarget.checked)
          );
        }
      }
    )
  )), sigV4AuthToggleEnabled && /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-inline" }, /* @__PURE__ */ React__default["default"].createElement(InlineField, { label: "SigV4 auth", labelWidth: LABEL_WIDTH, disabled: dataSourceConfig.readOnly }, /* @__PURE__ */ React__default["default"].createElement(
    InlineSwitch,
    {
      id: "http-settings-sigv4-auth",
      value: dataSourceConfig.jsonData.sigV4Auth || false,
      onChange: (event) => {
        onSettingsChange({
          jsonData: __spreadProps$v(__spreadValues$F({}, dataSourceConfig.jsonData), { sigV4Auth: event.currentTarget.checked })
        });
      }
    }
  ))), dataSourceConfig.access === "proxy" && /* @__PURE__ */ React__default["default"].createElement(
    HttpProxySettings,
    {
      dataSourceConfig,
      onChange: (jsonData) => onSettingsChange({ jsonData }),
      showForwardOAuthIdentityOption: azureAuthEnabled ? false : showForwardOAuthIdentityOption
    }
  )), dataSourceConfig.basicAuth && /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("h6", null, "Basic Auth Details"), /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-group" }, /* @__PURE__ */ React__default["default"].createElement(BasicAuthSettings, __spreadValues$F({}, props)))), (azureAuthSettings == null ? void 0 : azureAuthSettings.azureAuthSupported) && azureAuthEnabled && azureAuthSettings.azureSettingsUI && /* @__PURE__ */ React__default["default"].createElement(azureAuthSettings.azureSettingsUI, { dataSourceConfig, onChange }), dataSourceConfig.jsonData.sigV4Auth && sigV4AuthToggleEnabled && renderSigV4Editor, (dataSourceConfig.jsonData.tlsAuth || dataSourceConfig.jsonData.tlsAuthWithCACert) && /* @__PURE__ */ React__default["default"].createElement(TLSAuthSettings, { dataSourceConfig, onChange }), dataSourceConfig.access === "proxy" && /* @__PURE__ */ React__default["default"].createElement(CustomHeadersSettings, { dataSourceConfig, onChange })), secureSocksDSProxyEnabled && /* @__PURE__ */ React__default["default"].createElement(SecureSocksProxySettings, { options: dataSourceConfig, onOptionsChange: onChange }));
};

var __defProp$F = Object.defineProperty;
var __defProps$u = Object.defineProperties;
var __getOwnPropDescs$u = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$F = Object.getOwnPropertySymbols;
var __hasOwnProp$F = Object.prototype.hasOwnProperty;
var __propIsEnum$F = Object.prototype.propertyIsEnumerable;
var __defNormalProp$F = (obj, key, value) => key in obj ? __defProp$F(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$E = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$F.call(b, prop))
      __defNormalProp$F(a, prop, b[prop]);
  if (__getOwnPropSymbols$F)
    for (var prop of __getOwnPropSymbols$F(b)) {
      if (__propIsEnum$F.call(b, prop))
        __defNormalProp$F(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$u = (a, b) => __defProps$u(a, __getOwnPropDescs$u(b));
function AlertingSettings({ options, onOptionsChange }) {
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement("h3", { className: "page-heading" }, "Alerting"), /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-group" }, /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form-inline" }, /* @__PURE__ */ React__default["default"].createElement("div", { className: "gf-form" }, /* @__PURE__ */ React__default["default"].createElement(
    InlineField,
    {
      labelWidth: 29,
      label: "Manage alert rules in Alerting UI",
      disabled: options.readOnly,
      tooltip: "Manage alert rules for this data source. To manage other alerting resources, add an Alertmanager data source."
    },
    /* @__PURE__ */ React__default["default"].createElement(
      InlineSwitch,
      {
        value: options.jsonData.manageAlerts !== false,
        onChange: (event) => onOptionsChange(__spreadProps$u(__spreadValues$E({}, options), {
          jsonData: __spreadProps$u(__spreadValues$E({}, options.jsonData), { manageAlerts: event.currentTarget.checked })
        }))
      }
    )
  )))));
}

var __defProp$E = Object.defineProperty;
var __defProps$t = Object.defineProperties;
var __getOwnPropDescs$t = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$E = Object.getOwnPropertySymbols;
var __hasOwnProp$E = Object.prototype.hasOwnProperty;
var __propIsEnum$E = Object.prototype.propertyIsEnumerable;
var __defNormalProp$E = (obj, key, value) => key in obj ? __defProp$E(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$D = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$E.call(b, prop))
      __defNormalProp$E(a, prop, b[prop]);
  if (__getOwnPropSymbols$E)
    for (var prop of __getOwnPropSymbols$E(b)) {
      if (__propIsEnum$E.call(b, prop))
        __defNormalProp$E(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$t = (a, b) => __defProps$t(a, __getOwnPropDescs$t(b));
var __objRest$n = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$E.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$E)
    for (var prop of __getOwnPropSymbols$E(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$E.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function SegmentSelect(_a) {
  var _b = _a, {
    value,
    placeholder = "",
    options = [],
    onChange,
    onClickOutside,
    loadOptions = void 0,
    width: widthPixels,
    noOptionsMessage = "",
    allowCustomValue = false,
    allowEmptyValue = false
  } = _b, rest = __objRest$n(_b, [
    "value",
    "placeholder",
    "options",
    "onChange",
    "onClickOutside",
    "loadOptions",
    "width",
    "noOptionsMessage",
    "allowCustomValue",
    "allowEmptyValue"
  ]);
  const ref = React.useRef(null);
  const theme = useTheme2();
  let width = widthPixels > 0 ? widthPixels / theme.spacing.gridSize : void 0;
  let Component;
  let asyncOptions = {};
  if (loadOptions) {
    Component = AsyncSelect;
    asyncOptions = { loadOptions, defaultOptions: true };
  } else {
    Component = Select;
  }
  return /* @__PURE__ */ React__default["default"].createElement("div", __spreadProps$t(__spreadValues$D({}, rest), { ref }), /* @__PURE__ */ React__default["default"].createElement(
    Component,
    __spreadValues$D({
      width,
      noOptionsMessage,
      placeholder,
      autoFocus: true,
      isOpen: true,
      onChange,
      options,
      value,
      closeMenuOnSelect: false,
      onCloseMenu: () => {
        if (ref && ref.current) {
          const input = ref.current.querySelector('input[id^="react-select-"]');
          if (input && (input.value || allowEmptyValue)) {
            onChange({ value: input.value, label: input.value });
          } else {
            onClickOutside();
          }
        }
      },
      allowCustomValue
    }, asyncOptions)
  ));
}

const getSegmentStyles = (theme) => {
  const palette = "v1" in theme ? theme.v1.palette : theme.palette;
  return {
    segment: css.css({
      cursor: "pointer",
      width: "auto"
    }),
    queryPlaceholder: css.css({
      color: palette.gray2
    }),
    disabled: css.css({
      cursor: "not-allowed",
      opacity: 0.65,
      boxShadow: "none"
    })
  };
};

const useExpandableLabel = (initialExpanded, onExpandedChange) => {
  const ref = React.useRef(null);
  const buttonStyles = useStyles2(clearButtonStyles);
  const [expanded, setExpanded] = React.useState(initialExpanded);
  const [width, setWidth] = React.useState(0);
  const setExpandedWrapper = (expanded2) => {
    setExpanded(expanded2);
    if (onExpandedChange) {
      onExpandedChange(expanded2);
    }
  };
  const Label = ({ Component, onClick, disabled }) => /* @__PURE__ */ React__default["default"].createElement(
    "button",
    {
      type: "button",
      className: buttonStyles,
      ref,
      disabled,
      onClick: () => {
        setExpandedWrapper(true);
        if (ref && ref.current) {
          setWidth(ref.current.clientWidth * 1.25);
        }
        onClick == null ? void 0 : onClick();
      }
    },
    Component
  );
  return [Label, width, expanded, setExpandedWrapper];
};

var __defProp$D = Object.defineProperty;
var __defProps$s = Object.defineProperties;
var __getOwnPropDescs$s = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$D = Object.getOwnPropertySymbols;
var __hasOwnProp$D = Object.prototype.hasOwnProperty;
var __propIsEnum$D = Object.prototype.propertyIsEnumerable;
var __defNormalProp$D = (obj, key, value) => key in obj ? __defProp$D(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$C = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$D.call(b, prop))
      __defNormalProp$D(a, prop, b[prop]);
  if (__getOwnPropSymbols$D)
    for (var prop of __getOwnPropSymbols$D(b)) {
      if (__propIsEnum$D.call(b, prop))
        __defNormalProp$D(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$s = (a, b) => __defProps$s(a, __getOwnPropDescs$s(b));
var __objRest$m = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$D.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$D)
    for (var prop of __getOwnPropSymbols$D(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$D.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function Segment(_a) {
  var _b = _a, {
    options,
    value,
    onChange,
    Component,
    className,
    allowCustomValue,
    allowEmptyValue,
    placeholder,
    disabled,
    inputMinWidth,
    inputPlaceholder,
    onExpandedChange,
    autofocus = false
  } = _b, rest = __objRest$m(_b, [
    "options",
    "value",
    "onChange",
    "Component",
    "className",
    "allowCustomValue",
    "allowEmptyValue",
    "placeholder",
    "disabled",
    "inputMinWidth",
    "inputPlaceholder",
    "onExpandedChange",
    "autofocus"
  ]);
  const [Label, labelWidth, expanded, setExpanded] = useExpandableLabel(autofocus, onExpandedChange);
  const width = inputMinWidth ? Math.max(inputMinWidth, labelWidth) : labelWidth;
  const styles = useStyles2(getSegmentStyles);
  if (!expanded) {
    const label = lodash.isObject(value) ? value.label : value;
    const labelAsString = label != null ? String(label) : void 0;
    return /* @__PURE__ */ React__default["default"].createElement(
      Label,
      {
        disabled,
        Component: Component || /* @__PURE__ */ React__default["default"].createElement(
          InlineLabel,
          {
            className: css.cx(
              styles.segment,
              {
                [styles.queryPlaceholder]: placeholder !== void 0 && !value,
                [styles.disabled]: disabled
              },
              className
            )
          },
          labelAsString || placeholder
        )
      }
    );
  }
  return /* @__PURE__ */ React__default["default"].createElement(
    SegmentSelect,
    __spreadProps$s(__spreadValues$C({}, rest), {
      value: value && !lodash.isObject(value) ? { value } : value,
      placeholder: inputPlaceholder,
      options,
      width,
      onClickOutside: () => setExpanded(false),
      allowCustomValue,
      allowEmptyValue,
      onChange: (item) => {
        setExpanded(false);
        onChange(item);
      }
    })
  );
}

var __defProp$C = Object.defineProperty;
var __defProps$r = Object.defineProperties;
var __getOwnPropDescs$r = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$C = Object.getOwnPropertySymbols;
var __hasOwnProp$C = Object.prototype.hasOwnProperty;
var __propIsEnum$C = Object.prototype.propertyIsEnumerable;
var __defNormalProp$C = (obj, key, value) => key in obj ? __defProp$C(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$B = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$C.call(b, prop))
      __defNormalProp$C(a, prop, b[prop]);
  if (__getOwnPropSymbols$C)
    for (var prop of __getOwnPropSymbols$C(b)) {
      if (__propIsEnum$C.call(b, prop))
        __defNormalProp$C(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$r = (a, b) => __defProps$r(a, __getOwnPropDescs$r(b));
var __objRest$l = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$C.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$C)
    for (var prop of __getOwnPropSymbols$C(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$C.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function SegmentAsync(_a) {
  var _b = _a, {
    value,
    onChange,
    loadOptions,
    reloadOptionsOnChange = false,
    Component,
    className,
    allowCustomValue,
    allowEmptyValue,
    disabled,
    placeholder,
    inputMinWidth,
    inputPlaceholder,
    autofocus = false,
    onExpandedChange,
    noOptionMessageHandler = mapStateToNoOptionsMessage
  } = _b, rest = __objRest$l(_b, [
    "value",
    "onChange",
    "loadOptions",
    "reloadOptionsOnChange",
    "Component",
    "className",
    "allowCustomValue",
    "allowEmptyValue",
    "disabled",
    "placeholder",
    "inputMinWidth",
    "inputPlaceholder",
    "autofocus",
    "onExpandedChange",
    "noOptionMessageHandler"
  ]);
  var _a2;
  const [state, fetchOptions] = reactUse.useAsyncFn(loadOptions, [loadOptions]);
  const [Label, labelWidth, expanded, setExpanded] = useExpandableLabel(autofocus, onExpandedChange);
  const width = inputMinWidth ? Math.max(inputMinWidth, labelWidth) : labelWidth;
  const styles = useStyles2(getSegmentStyles);
  if (!expanded) {
    const label = lodash.isObject(value) ? value.label : value;
    const labelAsString = label != null ? String(label) : void 0;
    return /* @__PURE__ */ React__default["default"].createElement(
      Label,
      {
        onClick: reloadOptionsOnChange ? void 0 : fetchOptions,
        disabled,
        Component: Component || /* @__PURE__ */ React__default["default"].createElement(
          InlineLabel,
          {
            className: css.cx(
              styles.segment,
              {
                [styles.queryPlaceholder]: placeholder !== void 0 && !value,
                [styles.disabled]: disabled
              },
              className
            )
          },
          labelAsString || placeholder
        )
      }
    );
  }
  return /* @__PURE__ */ React__default["default"].createElement(
    SegmentSelect,
    __spreadProps$r(__spreadValues$B({}, rest), {
      value: value && !lodash.isObject(value) ? { value } : value,
      placeholder: inputPlaceholder,
      options: (_a2 = state.value) != null ? _a2 : [],
      loadOptions: reloadOptionsOnChange ? fetchOptions : void 0,
      width,
      noOptionsMessage: noOptionMessageHandler(state),
      allowCustomValue,
      allowEmptyValue,
      onClickOutside: () => {
        setExpanded(false);
      },
      onChange: (item) => {
        setExpanded(false);
        onChange(item);
      }
    })
  );
}
function mapStateToNoOptionsMessage(state) {
  if (state.loading) {
    return t("grafana-ui.segment-async.loading", "Loading options...");
  }
  if (state.error) {
    return t("grafana-ui.segment-async.error", "Failed to load options");
  }
  return t("grafana-ui.segment-async.no-options", "No options found");
}

var __defProp$B = Object.defineProperty;
var __defProps$q = Object.defineProperties;
var __getOwnPropDescs$q = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$B = Object.getOwnPropertySymbols;
var __hasOwnProp$B = Object.prototype.hasOwnProperty;
var __propIsEnum$B = Object.prototype.propertyIsEnumerable;
var __defNormalProp$B = (obj, key, value) => key in obj ? __defProp$B(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$A = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$B.call(b, prop))
      __defNormalProp$B(a, prop, b[prop]);
  if (__getOwnPropSymbols$B)
    for (var prop of __getOwnPropSymbols$B(b)) {
      if (__propIsEnum$B.call(b, prop))
        __defNormalProp$B(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$q = (a, b) => __defProps$q(a, __getOwnPropDescs$q(b));
var __objRest$k = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$B.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$B)
    for (var prop of __getOwnPropSymbols$B(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$B.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const FONT_SIZE = 14;
function SegmentInput(_a) {
  var _b = _a, {
    value: initialValue,
    onChange,
    Component,
    className,
    placeholder,
    inputPlaceholder,
    disabled,
    autofocus = false,
    onExpandedChange
  } = _b, rest = __objRest$k(_b, [
    "value",
    "onChange",
    "Component",
    "className",
    "placeholder",
    "inputPlaceholder",
    "disabled",
    "autofocus",
    "onExpandedChange"
  ]);
  const ref = React.useRef(null);
  const [value, setValue] = React.useState(initialValue);
  const [inputWidth, setInputWidth] = React.useState(measureText((initialValue || "").toString(), FONT_SIZE).width);
  const [Label, , expanded, setExpanded] = useExpandableLabel(autofocus, onExpandedChange);
  const styles = useStyles2(getSegmentStyles);
  useClickAway__default["default"](ref, () => {
    setExpanded(false);
    onChange(value);
  });
  if (!expanded) {
    return /* @__PURE__ */ React__default["default"].createElement(
      Label,
      {
        disabled,
        Component: Component || /* @__PURE__ */ React__default["default"].createElement(
          InlineLabel,
          {
            className: css.cx(
              styles.segment,
              {
                [styles.queryPlaceholder]: placeholder !== void 0 && !value,
                [styles.disabled]: disabled
              },
              className
            )
          },
          initialValue || placeholder
        )
      }
    );
  }
  const inputWidthStyle = css.css({
    width: `${Math.max(inputWidth + 20, 32)}px`
  });
  return /* @__PURE__ */ React__default["default"].createElement(
    "input",
    __spreadProps$q(__spreadValues$A({}, rest), {
      ref,
      autoFocus: true,
      className: css.cx(`gf-form gf-form-input`, inputWidthStyle),
      value,
      placeholder: inputPlaceholder,
      onChange: (item) => {
        const { width } = measureText(item.target.value, FONT_SIZE);
        setInputWidth(width);
        setValue(item.target.value);
      },
      onBlur: () => {
        setExpanded(false);
        onChange(value);
      },
      onKeyDown: (e) => {
        if ([13, 27].includes(e.keyCode)) {
          setExpanded(false);
          onChange(value);
        }
      }
    })
  );
}

const SegmentSection = ({
  label,
  htmlFor,
  children,
  fill
}) => {
  const styles = useStyles2(getStyles$m);
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(InlineFieldRow, null, /* @__PURE__ */ React__default["default"].createElement(InlineLabel, { htmlFor, width: 12, className: styles.label }, label), children, fill && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.fill }, /* @__PURE__ */ React__default["default"].createElement(InlineLabel, null, ""))));
};
const getStyles$m = (theme) => ({
  label: css.css({
    color: theme.colors.primary.text
  }),
  fill: css.css({
    flexGrow: 1,
    marginBottom: theme.spacing(0.5)
  })
});

const getDragStyles = (theme, handlePosition) => {
  const position = handlePosition || "middle";
  const baseColor = theme.colors.emphasize(theme.colors.background.secondary, 0.15);
  const hoverColor = theme.colors.primary.border;
  const clickTargetSize = theme.spacing(2);
  const handlebarThickness = 4;
  const handlebarWidth = 200;
  let verticalOffset = "50%";
  let horizontalOffset = "50%";
  switch (position) {
    case "start": {
      verticalOffset = "0%";
      horizontalOffset = "0%";
      break;
    }
    case "end": {
      verticalOffset = "100%";
      horizontalOffset = "100%";
      break;
    }
  }
  const dragHandleBase = css.css({
    position: "relative",
    "&:before": {
      content: '""',
      position: "absolute",
      transition: theme.transitions.create("border-color"),
      zIndex: 1
    },
    "&:after": {
      background: baseColor,
      content: '""',
      position: "absolute",
      transition: theme.transitions.create("background"),
      transform: "translate(-50%, -50%)",
      borderRadius: theme.shape.radius.pill,
      zIndex: 1
    },
    "&:hover": {
      "&:before": {
        borderColor: hoverColor
      },
      "&:after": {
        background: hoverColor
      }
    }
  });
  return {
    dragHandleVertical: css.cx(
      dragHandleBase,
      css.css({
        cursor: "col-resize",
        width: clickTargetSize,
        "&:before": {
          borderRight: "1px solid transparent",
          height: "100%",
          left: verticalOffset,
          transform: "translateX(-50%)"
        },
        "&:after": {
          left: verticalOffset,
          top: "50%",
          height: handlebarWidth,
          width: handlebarThickness
        }
      })
    ),
    dragHandleHorizontal: css.cx(
      dragHandleBase,
      css.css({
        height: clickTargetSize,
        cursor: "row-resize",
        "&:before": {
          borderTop: "1px solid transparent",
          top: horizontalOffset,
          transform: "translateY(-50%)",
          width: "100%"
        },
        "&:after": {
          left: "50%",
          top: horizontalOffset,
          height: handlebarThickness,
          width: handlebarWidth
        }
      })
    )
  };
};

var __defProp$A = Object.defineProperty;
var __defProps$p = Object.defineProperties;
var __getOwnPropDescs$p = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$A = Object.getOwnPropertySymbols;
var __hasOwnProp$A = Object.prototype.hasOwnProperty;
var __propIsEnum$A = Object.prototype.propertyIsEnumerable;
var __defNormalProp$A = (obj, key, value) => key in obj ? __defProp$A(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$z = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$A.call(b, prop))
      __defNormalProp$A(a, prop, b[prop]);
  if (__getOwnPropSymbols$A)
    for (var prop of __getOwnPropSymbols$A(b)) {
      if (__propIsEnum$A.call(b, prop))
        __defNormalProp$A(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$p = (a, b) => __defProps$p(a, __getOwnPropDescs$p(b));
function Drawer({
  children,
  onClose,
  closeOnMaskClick = true,
  scrollableContent = true,
  title,
  subtitle,
  width,
  size = "md",
  tabs
}) {
  const [drawerWidth, onMouseDown, onTouchStart] = useResizebleDrawer();
  const styles = useStyles2(getStyles$l);
  const sizeStyles = useStyles2(getSizeStyles, size, drawerWidth != null ? drawerWidth : width);
  const dragStyles = useStyles2(getDragStyles);
  const overlayRef = React__default["default"].useRef(null);
  const { dialogProps, titleProps } = dialog.useDialog({}, overlayRef);
  const { overlayProps } = overlays.useOverlay(
    {
      isDismissable: false,
      isOpen: true,
      onClose
    },
    overlayRef
  );
  useBodyClassWhileOpen();
  const rootClass = css.cx(styles.drawer, sizeStyles);
  const content = /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.content }, children);
  return /* @__PURE__ */ React__default["default"].createElement(
    RcDrawer__default["default"],
    {
      open: true,
      onClose,
      placement: "right",
      getContainer: ".main-view",
      className: styles.drawerContent,
      rootClassName: rootClass,
      width: "",
      motion: {
        motionAppear: true,
        motionName: styles.drawerMotion
      },
      maskClassName: styles.mask,
      maskClosable: closeOnMaskClick,
      maskMotion: {
        motionAppear: true,
        motionName: styles.maskMotion
      }
    },
    /* @__PURE__ */ React__default["default"].createElement(focus.FocusScope, { restoreFocus: true, contain: true, autoFocus: true }, /* @__PURE__ */ React__default["default"].createElement(
      "div",
      __spreadProps$p(__spreadValues$z(__spreadValues$z({
        "aria-label": typeof title === "string" ? e2eSelectors.selectors.components.Drawer.General.title(title) : e2eSelectors.selectors.components.Drawer.General.title("no title"),
        className: styles.container
      }, overlayProps), dialogProps), {
        ref: overlayRef
      }),
      /* @__PURE__ */ React__default["default"].createElement(
        "div",
        {
          className: css.cx(dragStyles.dragHandleVertical, styles.resizer),
          onMouseDown,
          onTouchStart
        }
      ),
      typeof title === "string" && /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.header, Boolean(tabs) && styles.headerWithTabs) }, /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.actions }, /* @__PURE__ */ React__default["default"].createElement(
        IconButton,
        {
          name: "times",
          variant: "secondary",
          onClick: onClose,
          "data-testid": e2eSelectors.selectors.components.Drawer.General.close,
          tooltip: t(`grafana-ui.drawer.close`, "Close")
        }
      )), /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.titleWrapper }, /* @__PURE__ */ React__default["default"].createElement(Text, __spreadValues$z({ element: "h3" }, titleProps), title), subtitle && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.subtitle, "data-testid": e2eSelectors.selectors.components.Drawer.General.subtitle }, subtitle), tabs && /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.tabsWrapper }, tabs))),
      typeof title !== "string" && title,
      !scrollableContent ? content : /* @__PURE__ */ React__default["default"].createElement(CustomScrollbar, null, content)
    ))
  );
}
function useResizebleDrawer() {
  const [drawerWidth, setDrawerWidth] = React.useState(void 0);
  const onMouseMove = React.useCallback((e) => {
    setDrawerWidth(getCustomDrawerWidth(e.clientX));
  }, []);
  const onTouchMove = React.useCallback((e) => {
    const touch = e.touches[0];
    setDrawerWidth(getCustomDrawerWidth(touch.clientX));
  }, []);
  const onMouseUp = React.useCallback(
    (e) => {
      document.removeEventListener("mousemove", onMouseMove);
      document.removeEventListener("mouseup", onMouseUp);
    },
    [onMouseMove]
  );
  const onTouchEnd = React.useCallback(
    (e) => {
      document.removeEventListener("touchmove", onTouchMove);
      document.removeEventListener("touchend", onTouchEnd);
    },
    [onTouchMove]
  );
  function onMouseDown(e) {
    e.stopPropagation();
    e.preventDefault();
    document.addEventListener("mousemove", onMouseMove);
    document.addEventListener("mouseup", onMouseUp);
  }
  function onTouchStart(e) {
    e.stopPropagation();
    e.preventDefault();
    document.addEventListener("touchmove", onTouchMove);
    document.addEventListener("touchend", onTouchEnd);
  }
  return [drawerWidth, onMouseDown, onTouchStart];
}
function getCustomDrawerWidth(clientX) {
  let offsetRight = document.body.offsetWidth - (clientX - document.body.offsetLeft);
  let widthPercent = Math.min(offsetRight / document.body.clientWidth * 100, 98).toFixed(2);
  return `${widthPercent}vw`;
}
function useBodyClassWhileOpen() {
  React.useEffect(() => {
    if (!document.body) {
      return;
    }
    document.body.classList.add("body-drawer-open");
    return () => {
      document.body.classList.remove("body-drawer-open");
    };
  }, []);
}
const getStyles$l = (theme) => {
  return {
    container: css.css({
      display: "flex",
      flexDirection: "column",
      height: "100%",
      flex: "1 1 0",
      minHeight: "100%",
      position: "relative"
    }),
    drawer: css.css({
      ".main-view &": {
        top: 80
      },
      ".main-view--search-bar-hidden &": {
        top: 40
      },
      ".main-view--chrome-hidden &": {
        top: 0
      },
      ".rc-drawer-content-wrapper": {
        boxShadow: theme.shadows.z3
      }
    }),
    drawerContent: css.css({
      backgroundColor: `${theme.colors.background.primary} !important`,
      display: "flex",
      overflow: "unset",
      flexDirection: "column"
    }),
    drawerMotion: css.css({
      "&-appear": {
        transform: "translateX(100%)",
        transition: "none !important",
        "&-active": {
          transition: `${theme.transitions.create("transform")} !important`,
          transform: "translateX(0)"
        }
      }
    }),
    // we want the mask itself to span the whole page including the top bar
    // this ensures trying to click something in the top bar will close the drawer correctly
    // but we don't want the backdrop styling to apply over the top bar as it looks weird
    // instead have a child pseudo element to apply the backdrop styling below the top bar
    mask: css.css({
      backgroundColor: "transparent",
      position: "fixed",
      "&:before": {
        backgroundColor: `${theme.components.overlay.background} !important`,
        backdropFilter: "blur(1px)",
        bottom: 0,
        content: '""',
        left: 0,
        position: "fixed",
        right: 0,
        ".main-view &": {
          top: 80
        },
        ".main-view--search-bar-hidden &": {
          top: 40
        },
        ".main-view--chrome-hidden &": {
          top: 0
        }
      }
    }),
    maskMotion: css.css({
      "&-appear": {
        opacity: 0,
        "&-active": {
          opacity: 1,
          transition: theme.transitions.create("opacity")
        }
      }
    }),
    header: css.css({
      label: "drawer-header",
      flexGrow: 0,
      padding: theme.spacing(2, 2, 3),
      borderBottom: `1px solid ${theme.colors.border.weak}`
    }),
    headerWithTabs: css.css({
      borderBottom: "none"
    }),
    actions: css.css({
      position: "absolute",
      right: theme.spacing(1),
      top: theme.spacing(1)
    }),
    titleWrapper: css.css({
      label: "drawer-title",
      overflowWrap: "break-word"
    }),
    subtitle: css.css({
      label: "drawer-subtitle",
      color: theme.colors.text.secondary,
      paddingTop: theme.spacing(1)
    }),
    content: css.css({
      padding: theme.spacing(2),
      height: "100%",
      flexGrow: 1
    }),
    tabsWrapper: css.css({
      label: "drawer-tabs",
      paddingLeft: theme.spacing(2),
      margin: theme.spacing(1, -1, -3, -3)
    }),
    resizer: css.css({
      top: 0,
      left: theme.spacing(-1),
      bottom: 0,
      position: "absolute",
      zIndex: theme.zIndex.modal
    })
  };
};
const drawerSizes = {
  sm: { width: "25vw", minWidth: 384 },
  md: { width: "50vw", minWidth: 568 },
  lg: { width: "75vw", minWidth: 744 }
};
function getSizeStyles(theme, size, overrideWidth) {
  let width = overrideWidth != null ? overrideWidth : drawerSizes[size].width;
  let minWidth = drawerSizes[size].minWidth;
  return css.css({
    ".rc-drawer-content-wrapper": {
      label: `drawer-content-wrapper-${size}`,
      width,
      minWidth,
      overflow: "unset",
      [theme.breakpoints.down("md")]: {
        width: `calc(100% - ${theme.spacing(2)}) !important`,
        minWidth: 0
      }
    }
  });
}

const getStyles$k = (theme, isHorizontal, hasMarks = false) => {
  const { spacing } = theme;
  const railColor = theme.colors.border.strong;
  const trackColor = theme.colors.primary.main;
  const handleColor = theme.colors.primary.main;
  const blueOpacity = theme.colors.primary.transparent;
  const hoverStyle = `box-shadow: 0px 0px 0px 6px ${blueOpacity}`;
  return {
    container: css.css({
      width: "100%",
      margin: isHorizontal ? "inherit" : spacing(1, 3, 1, 1),
      paddingBottom: isHorizontal && hasMarks ? theme.spacing(1) : "inherit",
      height: isHorizontal ? "auto" : "100%"
    }),
    // can't write this as an object since it needs to overwrite rc-slider styles
    // object syntax doesn't support kebab case keys
    // eslint-disable-next-line @emotion/syntax-preference
    slider: css.css`
      .rc-slider {
        display: flex;
        flex-grow: 1;
        margin-left: 7px; // half the size of the handle to align handle to the left on 0 value
      }
      .rc-slider-mark {
        top: ${theme.spacing(1.75)};
      }
      .rc-slider-mark-text {
        color: ${theme.colors.text.disabled};
        font-size: ${theme.typography.bodySmall.fontSize};
      }
      .rc-slider-mark-text-active {
        color: ${theme.colors.text.primary};
      }
      .rc-slider-handle {
        border: none;
        background-color: ${handleColor};
        box-shadow: ${theme.shadows.z1};
        cursor: pointer;
        opacity: 1;
      }

      .rc-slider-handle:hover,
      .rc-slider-handle:active,
      .rc-slider-handle-click-focused:focus {
        ${hoverStyle};
      }

      // The triple class names is needed because that's the specificity used in the source css :(
      .rc-slider-handle-dragging.rc-slider-handle-dragging.rc-slider-handle-dragging,
      .rc-slider-handle:focus-visible {
        box-shadow: 0 0 0 5px ${theme.colors.text.primary};
      }

      .rc-slider-dot,
      .rc-slider-dot-active {
        background-color: ${theme.colors.text.primary};
        border-color: ${theme.colors.text.primary};
      }

      .rc-slider-track {
        background-color: ${trackColor};
      }
      .rc-slider-rail {
        background-color: ${railColor};
        cursor: pointer;
      }
    `,
    /** Global component from @emotion/core doesn't accept computed classname string returned from css from emotion.
     * It accepts object containing the computed name and flattened styles returned from css from @emotion/core
     * */
    tooltip: react.css`
      body {
        .rc-slider-tooltip {
          cursor: grab;
          user-select: none;
          z-index: ${theme.zIndex.tooltip};
        }

        .rc-slider-tooltip-inner {
          color: ${theme.colors.text.primary};
          background-color: transparent !important;
          border-radius: 0;
          box-shadow: none;
        }

        .rc-slider-tooltip-placement-top .rc-slider-tooltip-arrow {
          display: none;
        }

        .rc-slider-tooltip-placement-top {
          padding: 0;
        }
      }
    `,
    sliderInput: css.css({
      display: "flex",
      flexDirection: "row",
      alignItems: "center",
      width: "100%"
    }),
    sliderInputVertical: css.css({
      flexDirection: "column",
      height: "100%",
      ".rc-slider": {
        margin: 0,
        order: 2
      }
    }),
    sliderInputField: css.css({
      marginLeft: theme.spacing(3),
      width: "60px",
      input: {
        textAlign: "center"
      }
    }),
    sliderInputFieldVertical: css.css({
      margin: `0 0 ${theme.spacing(3)} 0`,
      order: 1
    })
  };
};

const Slider = ({
  min,
  max,
  onChange,
  onAfterChange,
  orientation = "horizontal",
  reverse,
  step,
  value,
  ariaLabelForHandle,
  marks,
  included
}) => {
  const isHorizontal = orientation === "horizontal";
  const styles = useStyles2(getStyles$k, isHorizontal, Boolean(marks));
  const SliderWithTooltip = SliderComponent__default["default"];
  const [sliderValue, setSliderValue] = React.useState(value != null ? value : min);
  const onSliderChange = React.useCallback(
    (v) => {
      const value2 = typeof v === "number" ? v : v[0];
      setSliderValue(value2);
      onChange == null ? void 0 : onChange(value2);
    },
    [setSliderValue, onChange]
  );
  const onSliderInputChange = React.useCallback(
    (e) => {
      let v = +e.target.value;
      if (Number.isNaN(v)) {
        v = 0;
      }
      setSliderValue(v);
      if (onChange) {
        onChange(v);
      }
      if (onAfterChange) {
        onAfterChange(v);
      }
    },
    [onChange, onAfterChange]
  );
  const onSliderInputBlur = React.useCallback(
    (e) => {
      const v = +e.target.value;
      if (v > max) {
        setSliderValue(max);
      } else if (v < min) {
        setSliderValue(min);
      }
    },
    [max, min]
  );
  const handleChangeComplete = React.useCallback(
    (v) => {
      const value2 = typeof v === "number" ? v : v[0];
      onAfterChange == null ? void 0 : onAfterChange(value2);
    },
    [onAfterChange]
  );
  const sliderInputClassNames = !isHorizontal ? [styles.sliderInputVertical] : [];
  const sliderInputFieldClassNames = !isHorizontal ? [styles.sliderInputFieldVertical] : [];
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.container, styles.slider) }, /* @__PURE__ */ React__default["default"].createElement(react.Global, { styles: styles.tooltip }), /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.sliderInput, ...sliderInputClassNames) }, /* @__PURE__ */ React__default["default"].createElement(
    SliderWithTooltip,
    {
      min,
      max,
      step,
      defaultValue: value,
      value: sliderValue,
      onChange: onSliderChange,
      onChangeComplete: handleChangeComplete,
      vertical: !isHorizontal,
      reverse,
      ariaLabelForHandle,
      marks,
      included
    }
  ), /* @__PURE__ */ React__default["default"].createElement(
    Input,
    {
      type: "text",
      className: css.cx(styles.sliderInputField, ...sliderInputFieldClassNames),
      value: sliderValue,
      onChange: onSliderInputChange,
      onBlur: onSliderInputBlur,
      min,
      max
    }
  )));
};
Slider.displayName = "Slider";

var __defProp$z = Object.defineProperty;
var __getOwnPropSymbols$z = Object.getOwnPropertySymbols;
var __hasOwnProp$z = Object.prototype.hasOwnProperty;
var __propIsEnum$z = Object.prototype.propertyIsEnumerable;
var __defNormalProp$z = (obj, key, value) => key in obj ? __defProp$z(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$y = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$z.call(b, prop))
      __defNormalProp$z(a, prop, b[prop]);
  if (__getOwnPropSymbols$z)
    for (var prop of __getOwnPropSymbols$z(b)) {
      if (__propIsEnum$z.call(b, prop))
        __defNormalProp$z(a, prop, b[prop]);
    }
  return a;
};
var __objRest$j = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$z.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$z)
    for (var prop of __getOwnPropSymbols$z(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$z.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const HandleTooltip = (props) => {
  const _a = props, { value, children, visible, placement, tipFormatter } = _a, restProps = __objRest$j(_a, ["value", "children", "visible", "placement", "tipFormatter"]);
  const tooltipRef = React.useRef(null);
  const rafRef = React.useRef(null);
  const styles = useStyles2(tooltipStyles);
  function cancelKeepAlign() {
    if (rafRef.current !== null) {
      cancelAnimationFrame(rafRef.current);
    }
  }
  function keepAlign() {
    rafRef.current = requestAnimationFrame(() => {
      var _a2;
      (_a2 = tooltipRef.current) == null ? void 0 : _a2.forceAlign();
    });
  }
  React.useEffect(() => {
    if (visible) {
      keepAlign();
    } else {
      cancelKeepAlign();
    }
    return cancelKeepAlign;
  }, [value, visible]);
  return /* @__PURE__ */ React__default["default"].createElement(
    Tooltip__default["default"],
    __spreadValues$y({
      overlayClassName: styles.tooltip,
      placement,
      overlay: tipFormatter != null ? tipFormatter : value,
      overlayInnerStyle: { minHeight: "auto" },
      ref: tooltipRef,
      visible
    }, restProps),
    children
  );
};
const tooltipStyles = (theme) => {
  return {
    tooltip: css.css({
      position: "absolute",
      display: "block",
      visibility: "visible",
      fontSize: theme.typography.bodySmall.fontSize,
      opacity: 0.9,
      padding: 3,
      zIndex: theme.zIndex.tooltip
    })
  };
};

const RangeSlider = ({
  min,
  max,
  onChange,
  onAfterChange,
  orientation = "horizontal",
  reverse,
  step,
  formatTooltipResult,
  value,
  tooltipAlwaysVisible = true
}) => {
  const handleChange = React.useCallback(
    (v) => {
      const value2 = typeof v === "number" ? [v, v] : v;
      onChange == null ? void 0 : onChange(value2);
    },
    [onChange]
  );
  const handleChangeComplete = React.useCallback(
    (v) => {
      const value2 = typeof v === "number" ? [v, v] : v;
      onAfterChange == null ? void 0 : onAfterChange(value2);
    },
    [onAfterChange]
  );
  const isHorizontal = orientation === "horizontal";
  const styles = useStyles2(getStyles$k, isHorizontal);
  const tipHandleRender = (node, handleProps) => {
    return /* @__PURE__ */ React__default["default"].createElement(
      HandleTooltip,
      {
        value: handleProps.value,
        visible: tooltipAlwaysVisible || handleProps.dragging,
        tipFormatter: formatTooltipResult ? () => formatTooltipResult(handleProps.value) : void 0,
        placement: isHorizontal ? "top" : "right"
      },
      node
    );
  };
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: css.cx(styles.container, styles.slider) }, /* @__PURE__ */ React__default["default"].createElement(react.Global, { styles: styles.tooltip }), /* @__PURE__ */ React__default["default"].createElement(
    SliderComponent__default["default"],
    {
      min,
      max,
      step,
      defaultValue: value,
      range: true,
      onChange: handleChange,
      onChangeComplete: handleChangeComplete,
      vertical: !isHorizontal,
      reverse,
      handleRender: tipHandleRender
    }
  ));
};
RangeSlider.displayName = "RangeSlider";

var __defProp$y = Object.defineProperty;
var __getOwnPropSymbols$y = Object.getOwnPropertySymbols;
var __hasOwnProp$y = Object.prototype.hasOwnProperty;
var __propIsEnum$y = Object.prototype.propertyIsEnumerable;
var __defNormalProp$y = (obj, key, value) => key in obj ? __defProp$y(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$x = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$y.call(b, prop))
      __defNormalProp$y(a, prop, b[prop]);
  if (__getOwnPropSymbols$y)
    for (var prop of __getOwnPropSymbols$y(b)) {
      if (__propIsEnum$y.call(b, prop))
        __defNormalProp$y(a, prop, b[prop]);
    }
  return a;
};
var __objRest$i = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$y.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$y)
    for (var prop of __getOwnPropSymbols$y(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$y.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
function Form(_a) {
  var _b = _a, {
    defaultValues,
    onSubmit,
    validateOnMount = false,
    validateFieldsOnMount,
    children,
    validateOn = "onSubmit",
    maxWidth = 600
  } = _b, htmlProps = __objRest$i(_b, [
    "defaultValues",
    "onSubmit",
    "validateOnMount",
    "validateFieldsOnMount",
    "children",
    "validateOn",
    "maxWidth"
  ]);
  const _a2 = reactHookForm.useForm({
    mode: validateOn,
    defaultValues
  }), { handleSubmit, trigger, formState } = _a2, rest = __objRest$i(_a2, ["handleSubmit", "trigger", "formState"]);
  React.useEffect(() => {
    if (validateOnMount) {
      trigger(validateFieldsOnMount);
    }
  }, [trigger, validateFieldsOnMount, validateOnMount]);
  return /* @__PURE__ */ React__default["default"].createElement(
    "form",
    __spreadValues$x({
      className: css.css({
        maxWidth: maxWidth !== "none" ? maxWidth + "px" : maxWidth,
        width: "100%"
      }),
      onSubmit: handleSubmit(onSubmit)
    }, htmlProps),
    children(__spreadValues$x({ errors: formState.errors, formState, trigger }, rest))
  );
}

const InputControl = reactHookForm.Controller;

function ValuePicker({
  "aria-label": ariaLabel,
  label,
  icon,
  options,
  onChange,
  variant,
  minWidth = 16,
  size = "sm",
  isFullWidth = true,
  menuPlacement,
  fill,
  buttonCss
}) {
  const [isPicking, setIsPicking] = React.useState(false);
  const theme = useTheme2();
  return /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, !isPicking && /* @__PURE__ */ React__default["default"].createElement(
    Button,
    {
      size: size || "sm",
      className: buttonCss,
      icon: icon || "plus",
      onClick: () => setIsPicking(true),
      variant,
      fill,
      fullWidth: isFullWidth,
      "data-testid": e2eSelectors.selectors.components.ValuePicker.button(ariaLabel != null ? ariaLabel : label)
    },
    label
  ), isPicking && /* @__PURE__ */ React__default["default"].createElement("span", { style: { minWidth: theme.spacing(minWidth), flexGrow: isFullWidth ? 1 : void 0 } }, /* @__PURE__ */ React__default["default"].createElement(
    Select,
    {
      placeholder: label,
      options,
      "aria-label": e2eSelectors.selectors.components.ValuePicker.select(ariaLabel != null ? ariaLabel : label),
      isOpen: true,
      onCloseMenu: () => setIsPicking(false),
      autoFocus: true,
      onChange: (value) => {
        setIsPicking(false);
        onChange(value);
      },
      menuPlacement
    }
  )));
}

const FieldNameByRegexMatcherEditor = React.memo((props) => {
  const { options, onChange } = props;
  const onBlur = React.useCallback(
    (e) => {
      return onChange(e.target.value);
    },
    [onChange]
  );
  return /* @__PURE__ */ React__default["default"].createElement(Input, { placeholder: "Enter regular expression", defaultValue: options, onBlur });
});
FieldNameByRegexMatcherEditor.displayName = "FieldNameByRegexMatcherEditor";
const fieldNameByRegexMatcherItem = {
  id: data.FieldMatcherID.byRegexp,
  component: FieldNameByRegexMatcherEditor,
  matcher: data.fieldMatchers.get(data.FieldMatcherID.byRegexp),
  name: "Fields with name matching regex",
  description: "Set properties for fields with names matching a regex",
  optionsToLabel: (options) => options
};

function frameHasName(name, names) {
  if (!name) {
    return false;
  }
  return names.display.has(name) || names.raw.has(name);
}
function getFrameFieldsDisplayNames(data$1, filter) {
  const names = {
    display: /* @__PURE__ */ new Set(),
    raw: /* @__PURE__ */ new Set(),
    fields: /* @__PURE__ */ new Map()
  };
  for (const frame of data$1) {
    for (const field of frame.fields) {
      if (filter && !filter(field)) {
        continue;
      }
      const disp = data.getFieldDisplayName(field, frame, data$1);
      names.display.add(disp);
      names.fields.set(disp, field);
      if (field.name && disp !== field.name) {
        names.raw.add(field.name);
        names.fields.set(field.name, field);
      }
    }
  }
  return names;
}
function useFieldDisplayNames(data, filter) {
  return React.useMemo(() => {
    return getFrameFieldsDisplayNames(data, filter);
  }, [data, filter]);
}
function useSelectOptions$1(displayNames, currentName, firstItem, fieldType, baseNameMode) {
  return React.useMemo(() => {
    let found = false;
    const options = [];
    if (firstItem) {
      options.push(firstItem);
    }
    if (baseNameMode === data.FieldNamePickerBaseNameMode.OnlyBaseNames) {
      for (const name of displayNames.raw) {
        if (!found && name === currentName) {
          found = true;
        }
        options.push({
          value: name,
          label: `${name} (base field name)`
        });
      }
    } else {
      for (const name of displayNames.display) {
        if (!found && name === currentName) {
          found = true;
        }
        const field = displayNames.fields.get(name);
        if (!fieldType || fieldType === (field == null ? void 0 : field.type)) {
          options.push({
            value: name,
            label: name,
            icon: field ? getFieldTypeIcon(field) : void 0
          });
        }
      }
      if (baseNameMode !== data.FieldNamePickerBaseNameMode.ExcludeBaseNames) {
        for (const name of displayNames.raw) {
          if (!displayNames.display.has(name)) {
            if (!found && name === currentName) {
              found = true;
            }
            options.push({
              value: name,
              label: `${name} (base field name)`
            });
          }
        }
      }
    }
    if (currentName && !found) {
      options.push({
        value: currentName,
        label: `${currentName} (not found)`
      });
    }
    return options;
  }, [displayNames, currentName, firstItem, fieldType, baseNameMode]);
}

const FieldNameMatcherEditor = React.memo((props) => {
  const { data, options, onChange: onChangeFromProps, id } = props;
  const names = useFieldDisplayNames(data);
  const selectOptions = useSelectOptions$1(names, options);
  const onChange = React.useCallback(
    (selection) => {
      if (!frameHasName(selection.value, names)) {
        return;
      }
      return onChangeFromProps(selection.value);
    },
    [names, onChangeFromProps]
  );
  const selectedOption = selectOptions.find((v) => v.value === options);
  return /* @__PURE__ */ React__default["default"].createElement(Select, { value: selectedOption, options: selectOptions, onChange, inputId: id });
});
FieldNameMatcherEditor.displayName = "FieldNameMatcherEditor";
const fieldNameMatcherItem = {
  id: data.FieldMatcherID.byName,
  component: FieldNameMatcherEditor,
  matcher: data.fieldMatchers.get(data.FieldMatcherID.byName),
  name: "Fields with name",
  description: "Set properties for a specific field",
  optionsToLabel: (options) => options
};

var __defProp$x = Object.defineProperty;
var __defProps$o = Object.defineProperties;
var __getOwnPropDescs$o = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$x = Object.getOwnPropertySymbols;
var __hasOwnProp$x = Object.prototype.hasOwnProperty;
var __propIsEnum$x = Object.prototype.propertyIsEnumerable;
var __defNormalProp$x = (obj, key, value) => key in obj ? __defProp$x(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$w = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$x.call(b, prop))
      __defNormalProp$x(a, prop, b[prop]);
  if (__getOwnPropSymbols$x)
    for (var prop of __getOwnPropSymbols$x(b)) {
      if (__propIsEnum$x.call(b, prop))
        __defNormalProp$x(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$o = (a, b) => __defProps$o(a, __getOwnPropDescs$o(b));
const FieldNamesMatcherEditor = React.memo((props) => {
  var _a;
  const { data, options, onChange: onChangeFromProps } = props;
  const { readOnly, prefix } = options;
  const names = useFieldDisplayNames(data);
  const selectOptions = useSelectOptions$1(names, void 0);
  const onChange = React.useCallback(
    (selections) => {
      if (!Array.isArray(selections)) {
        return;
      }
      return onChangeFromProps(__spreadProps$o(__spreadValues$w({}, options), {
        names: selections.reduce((all, current) => {
          if (!frameHasName(current.value, names)) {
            return all;
          }
          all.push(current.value);
          return all;
        }, [])
      }));
    },
    [names, onChangeFromProps, options]
  );
  if (readOnly) {
    const displayNames = ((_a = options.names) != null ? _a : []).join(", ");
    return /* @__PURE__ */ React__default["default"].createElement(Input, { value: displayNames, readOnly: true, disabled: true, prefix });
  }
  return /* @__PURE__ */ React__default["default"].createElement(MultiSelect, { value: options.names, options: selectOptions, onChange });
});
FieldNamesMatcherEditor.displayName = "FieldNameMatcherEditor";
const fieldNamesMatcherItem = {
  id: data.FieldMatcherID.byNames,
  component: FieldNamesMatcherEditor,
  matcher: data.fieldMatchers.get(data.FieldMatcherID.byNames),
  name: "Fields with name",
  description: "Set properties for a specific field",
  optionsToLabel: (options) => {
    var _a;
    return ((_a = options.names) != null ? _a : []).join(", ");
  },
  excludeFromPicker: true
};

var __defProp$w = Object.defineProperty;
var __defProps$n = Object.defineProperties;
var __getOwnPropDescs$n = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$w = Object.getOwnPropertySymbols;
var __hasOwnProp$w = Object.prototype.hasOwnProperty;
var __propIsEnum$w = Object.prototype.propertyIsEnumerable;
var __defNormalProp$w = (obj, key, value) => key in obj ? __defProp$w(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$v = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$w.call(b, prop))
      __defNormalProp$w(a, prop, b[prop]);
  if (__getOwnPropSymbols$w)
    for (var prop of __getOwnPropSymbols$w(b)) {
      if (__propIsEnum$w.call(b, prop))
        __defNormalProp$w(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$n = (a, b) => __defProps$n(a, __getOwnPropDescs$n(b));
const FieldTypeMatcherEditor = React.memo((props) => {
  const { data, options, onChange: onChangeFromProps, id } = props;
  const counts = useFieldCounts(data);
  const selectOptions = useSelectOptions(counts, options);
  const onChange = React.useCallback(
    (selection) => {
      return onChangeFromProps(selection.value);
    },
    [onChangeFromProps]
  );
  const selectedOption = selectOptions.find((v) => v.value === options);
  return /* @__PURE__ */ React__default["default"].createElement(Select, { inputId: id, value: selectedOption, options: selectOptions, onChange });
});
FieldTypeMatcherEditor.displayName = "FieldTypeMatcherEditor";
const allFieldTypeIconOptions = [
  { value: data.FieldType.number, label: "Number", icon: getFieldTypeIconName(data.FieldType.number) },
  { value: data.FieldType.string, label: "String", icon: getFieldTypeIconName(data.FieldType.string) },
  { value: data.FieldType.time, label: "Time", icon: getFieldTypeIconName(data.FieldType.time) },
  { value: data.FieldType.boolean, label: "Boolean", icon: getFieldTypeIconName(data.FieldType.boolean) },
  { value: data.FieldType.trace, label: "Traces", icon: getFieldTypeIconName(data.FieldType.trace) },
  { value: data.FieldType.enum, label: "Enum", icon: getFieldTypeIconName(data.FieldType.enum) },
  { value: data.FieldType.other, label: "Other", icon: getFieldTypeIconName(data.FieldType.other) }
];
const useFieldCounts = (data$1) => {
  return React.useMemo(() => {
    const counts = /* @__PURE__ */ new Map();
    for (const t of allFieldTypeIconOptions) {
      counts.set(t.value, 0);
    }
    for (const frame of data$1) {
      for (const field of frame.fields) {
        const key = field.type || data.FieldType.other;
        let v = counts.get(key);
        if (!v) {
          v = 0;
        }
        counts.set(key, v + 1);
      }
    }
    return counts;
  }, [data$1]);
};
const useSelectOptions = (counts, opt) => {
  return React.useMemo(() => {
    let found = false;
    const options = [];
    for (const t of allFieldTypeIconOptions) {
      const count = counts.get(t.value);
      const match = opt === t.value;
      if (count || match) {
        options.push(__spreadProps$n(__spreadValues$v({}, t), {
          label: `${t.label} (${counts.get(t.value)})`
        }));
      }
      if (match) {
        found = true;
      }
    }
    if (opt && !found) {
      options.push({
        value: opt,
        label: `${opt} (No matches)`
      });
    }
    return options;
  }, [counts, opt]);
};
const fieldTypeMatcherItem = {
  id: data.FieldMatcherID.byType,
  component: FieldTypeMatcherEditor,
  matcher: data.fieldMatchers.get(data.FieldMatcherID.byType),
  name: "Fields with type",
  description: "Set properties for fields of a specific type (number, string, boolean)",
  optionsToLabel: (options) => options
};

var __defProp$v = Object.defineProperty;
var __defProps$m = Object.defineProperties;
var __getOwnPropDescs$m = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$v = Object.getOwnPropertySymbols;
var __hasOwnProp$v = Object.prototype.hasOwnProperty;
var __propIsEnum$v = Object.prototype.propertyIsEnumerable;
var __defNormalProp$v = (obj, key, value) => key in obj ? __defProp$v(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$u = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$v.call(b, prop))
      __defNormalProp$v(a, prop, b[prop]);
  if (__getOwnPropSymbols$v)
    for (var prop of __getOwnPropSymbols$v(b)) {
      if (__propIsEnum$v.call(b, prop))
        __defNormalProp$v(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$m = (a, b) => __defProps$m(a, __getOwnPropDescs$m(b));
const comparisonOperationOptions = [
  { label: "==", value: schema.ComparisonOperation.EQ },
  { label: "!=", value: schema.ComparisonOperation.NEQ },
  { label: ">", value: schema.ComparisonOperation.GT },
  { label: ">=", value: schema.ComparisonOperation.GTE },
  { label: "<", value: schema.ComparisonOperation.LT },
  { label: "<=", value: schema.ComparisonOperation.LTE }
];
function isBooleanReducer(r) {
  return r === data.ReducerID.allIsNull || r === data.ReducerID.allIsZero;
}
const FieldValueMatcherEditor = ({ options, onChange }) => {
  const styles = useStyles2(getStyles$j);
  const reducer = React.useMemo(() => data.fieldReducers.selectOptions([options == null ? void 0 : options.reducer]), [options == null ? void 0 : options.reducer]);
  const onSetReducer = React.useCallback(
    (selection) => {
      return onChange(__spreadProps$m(__spreadValues$u({}, options), { reducer: selection.value }));
    },
    [options, onChange]
  );
  const onChangeOp = React.useCallback(
    (v) => {
      return onChange(__spreadProps$m(__spreadValues$u({}, options), { op: v.value }));
    },
    [options, onChange]
  );
  const onChangeValue = React.useCallback(
    (e) => {
      const value = e.currentTarget.valueAsNumber;
      return onChange(__spreadProps$m(__spreadValues$u({}, options), { value }));
    },
    [options, onChange]
  );
  const opts = options != null ? options : {};
  const isBool = isBooleanReducer(options.reducer);
  return /* @__PURE__ */ React__default["default"].createElement("div", { className: styles.spot }, /* @__PURE__ */ React__default["default"].createElement(
    Select,
    {
      value: reducer.current,
      options: reducer.options,
      onChange: onSetReducer,
      placeholder: "Select field reducer"
    }
  ), opts.reducer && !isBool && /* @__PURE__ */ React__default["default"].createElement(React__default["default"].Fragment, null, /* @__PURE__ */ React__default["default"].createElement(
    Select,
    {
      value: comparisonOperationOptions.find((v) => v.value === opts.op),
      options: comparisonOperationOptions,
      onChange: onChangeOp,
      "aria-label": "Comparison operator",
      width: 19
    }
  ), /* @__PURE__ */ React__default["default"].createElement(Input, { type: "number", value: opts.value, onChange: onChangeValue })));
};
const getStyles$j = (theme) => {
  return {
    spot: css.css({
      display: "flex",
      flexDirection: "row",
      alignItems: "center",
      alignContent: "flex-end",
      gap: "4px"
    })
  };
};
const fieldValueMatcherItem = {
  id: data.FieldMatcherID.byValue,
  component: FieldValueMatcherEditor,
  matcher: data.fieldMatchers.get(data.FieldMatcherID.byValue),
  name: "Fields with values",
  description: "Set properties for fields with reducer condition",
  optionsToLabel: (options) => `${options == null ? void 0 : options.reducer} ${options == null ? void 0 : options.op} ${options == null ? void 0 : options.value}`
};

const recoverRefIdMissing = (newRefIds, oldRefIds, previousValue) => {
  if (!previousValue) {
    return;
  }
  let changedTo = newRefIds.find((refId) => {
    return !oldRefIds.some((refId2) => {
      return refId === refId2;
    });
  });
  if (changedTo) {
    return changedTo;
  }
  return;
};
function RefIDPicker({ value, data, onChange, placeholder }) {
  const listOfRefIds = React.useMemo(() => getListOfQueryRefIds(data), [data]);
  const [priorSelectionState, updatePriorSelectionState] = React.useState({
    refIds: [],
    value: void 0
  });
  const currentValue = React.useMemo(() => {
    var _a;
    return (_a = listOfRefIds.find((refId) => refId.value === value)) != null ? _a : recoverRefIdMissing(listOfRefIds, priorSelectionState.refIds, priorSelectionState.value);
  }, [value, listOfRefIds, priorSelectionState]);
  const onFilterChange = React.useCallback(
    (v) => {
      onChange(v == null ? void 0 : v.value);
    },
    [onChange]
  );
  if (listOfRefIds !== priorSelectionState.refIds || (currentValue == null ? void 0 : currentValue.value) !== priorSelectionState.value) {
    updatePriorSelectionState({
      refIds: listOfRefIds,
      value: currentValue == null ? void 0 : currentValue.value
    });
  }
  return /* @__PURE__ */ React__default["default"].createElement(
    Select,
    {
      options: listOfRefIds,
      onChange: onFilterChange,
      isClearable: true,
      placeholder: placeholder != null ? placeholder : "Select query refId",
      value: currentValue
    }
  );
}
function getListOfQueryRefIds(data) {
  var _a, _b;
  const queries = /* @__PURE__ */ new Map();
  for (const frame of data) {
    const refId = (_a = frame.refId) != null ? _a : "";
    const frames = (_b = queries.get(refId)) != null ? _b : [];
    if (frames.length === 0) {
      queries.set(refId, frames);
    }
    frames.push(frame);
  }
  const values = [];
  for (const [refId, frames] of queries.entries()) {
    values.push({
      value: refId,
      label: `Query: ${refId != null ? refId : "(missing refId)"}`,
      description: getFramesDescription(frames)
    });
  }
  return values;
}
function getFramesDescription(frames) {
  return `Frames (${frames.length}):
    ${frames.slice(0, Math.min(3, frames.length)).map((x) => data.getFrameDisplayName(x)).join(", ")} ${frames.length > 3 ? "..." : ""}`;
}
const fieldsByFrameRefIdItem = {
  id: data.FieldMatcherID.byFrameRefID,
  component: (props) => {
    return /* @__PURE__ */ React__default["default"].createElement(RefIDPicker, { value: props.options, data: props.data, onChange: props.onChange });
  },
  matcher: data.fieldMatchers.get(data.FieldMatcherID.byFrameRefID),
  name: "Fields returned by query",
  description: "Set properties for fields from a specific query",
  optionsToLabel: (options) => options
};

const fieldMatchersUI = new data.Registry(() => [
  fieldNameMatcherItem,
  fieldNameByRegexMatcherItem,
  fieldTypeMatcherItem,
  fieldsByFrameRefIdItem,
  fieldNamesMatcherItem,
  fieldValueMatcherItem
]);

var __defProp$u = Object.defineProperty;
var __defProps$l = Object.defineProperties;
var __getOwnPropDescs$l = Object.getOwnPropertyDescriptors;
var __getOwnPropSymbols$u = Object.getOwnPropertySymbols;
var __hasOwnProp$u = Object.prototype.hasOwnProperty;
var __propIsEnum$u = Object.prototype.propertyIsEnumerable;
var __defNormalProp$u = (obj, key, value) => key in obj ? __defProp$u(obj, key, { enumerable: true, configurable: true, writable: true, value }) : obj[key] = value;
var __spreadValues$t = (a, b) => {
  for (var prop in b || (b = {}))
    if (__hasOwnProp$u.call(b, prop))
      __defNormalProp$u(a, prop, b[prop]);
  if (__getOwnPropSymbols$u)
    for (var prop of __getOwnPropSymbols$u(b)) {
      if (__propIsEnum$u.call(b, prop))
        __defNormalProp$u(a, prop, b[prop]);
    }
  return a;
};
var __spreadProps$l = (a, b) => __defProps$l(a, __getOwnPropDescs$l(b));
var __objRest$h = (source, exclude) => {
  var target = {};
  for (var prop in source)
    if (__hasOwnProp$u.call(source, prop) && exclude.indexOf(prop) < 0)
      target[prop] = source[prop];
  if (source != null && __getOwnPropSymbols$u)
    for (var prop of __getOwnPropSymbols$u(source)) {
      if (exclude.indexOf(prop) < 0 && __propIsEnum$u.call(source, prop))
        target[prop] = source[prop];
    }
  return target;
};
const svgSizes = {
  h1: "xl",
  h2: "xl",
  h3: "lg",
  h4: "lg",
  h5: "md",
  h6: "md",
  body: "md",
  bodySmall: "xs"
};
const TextLink = React.forwardRef(
  (_a, ref) => {
    var _b = _a, { href, color = "link", external = false, inline = true, variant = "body", weight, icon, children } = _b, rest = __objRest$h(_b, ["href", "color", "external", "inline", "variant", "weight", "icon", "children"]);
    const validUrl = data.textUtil.sanitizeUrl(href != null ? href : "");
    const theme = useTheme2();
    const styles = getLinkStyles(theme, inline, variant, weight, color);
    const externalIcon = icon || "external-link-alt";
    if (external) {
      return /* @__PURE__ */ React__default["default"].createElement("a", __spreadProps$l(__spreadValues$t({ href: validUrl, ref }, rest), 