---
aliases:
  - /docs/grafana/latest/setup-grafana/configure-grafana/feature-toggles/
description: Learn about feature toggles, which you can enable or disable.
title: Configure feature toggles
weight: 150
---

<!-- DO NOT EDIT THIS PAGE, it is machine generated by running the test in -->
<!-- https://github.com/grafana/grafana/blob/main/pkg/services/featuremgmt/toggles_gen_test.go#L19 -->

# Configure feature toggles

You use feature toggles, also known as feature flags, to enable or disable features in Grafana. You can turn on feature toggles to try out new functionality in development or test environments.

This page contains a list of available feature toggles. To learn how to turn on feature toggles, refer to our [Configure Grafana documentation]({{< relref "../_index.md#feature_toggles" >}}). Feature toggles are also available to Grafana Cloud Advanced customers. If you use Grafana Cloud Advanced, you can open a support ticket and specify the feature toggles and stack for which you want them enabled.

## Feature toggles

Some features are enabled by default. You can disable these feature by setting the feature flag to "false" in the configuration.

| Feature toggle name                  | Description                                                                                                                                                                                                                  | Enabled by default |
| ------------------------------------ | ---------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- | ------------------ |
| `disableEnvelopeEncryption`          | Disable envelope encryption (emergency only)                                                                                                                                                                                 |                    |
| `publicDashboards`                   | [Deprecated] Public dashboards are now enabled by default; to disable them, use the configuration setting. This feature toggle will be removed in the next major version.                                                    | Yes                |
| `featureHighlights`                  | Highlight Grafana Enterprise features                                                                                                                                                                                        |                    |
| `correlations`                       | Correlations page                                                                                                                                                                                                            |                    |
| `exploreContentOutline`              | Content outline sidebar                                                                                                                                                                                                      | Yes                |
| `dataConnectionsConsole`             | Enables a new top-level page called Connections. This page is an experiment that provides a better experience when you install and configure data sources and other plugins.                                                 | Yes                |
| `cloudWatchCrossAccountQuerying`     | Enables cross-account querying in CloudWatch datasources                                                                                                                                                                     | Yes                |
| `redshiftAsyncQueryDataSupport`      | Enable async query data support for Redshift                                                                                                                                                                                 | Yes                |
| `athenaAsyncQueryDataSupport`        | Enable async query data support for Athena                                                                                                                                                                                   | Yes                |
| `nestedFolderPicker`                 | Enables the new folder picker to work with nested folders. Requires the nestedFolders feature toggle                                                                                                                         | Yes                |
| `logsContextDatasourceUi`            | Allow datasource to provide custom UI for context view                                                                                                                                                                       | Yes                |
| `lokiQuerySplitting`                 | Split large interval queries into subqueries with smaller time intervals                                                                                                                                                     | Yes                |
| `prometheusMetricEncyclopedia`       | Adds the metrics explorer component to the Prometheus query builder as an option in metric select                                                                                                                            | Yes                |
| `influxdbBackendMigration`           | Query InfluxDB InfluxQL without the proxy                                                                                                                                                                                    | Yes                |
| `prometheusDataplane`                | Changes responses to from Prometheus to be compliant with the dataplane specification. In particular, when this feature toggle is active, the numeric `Field.Name` is set from 'Value' to the value of the `__name__` label. | Yes                |
| `lokiMetricDataplane`                | Changes metric responses from Loki to be compliant with the dataplane specification.                                                                                                                                         | Yes                |
| `dataplaneFrontendFallback`          | Support dataplane contract field name change for transformations and field name matchers where the name is different                                                                                                         | Yes                |
| `enableElasticsearchBackendQuerying` | Enable the processing of queries and responses in the Elasticsearch data source through backend                                                                                                                              | Yes                |
| `cloudWatchLogsMonacoEditor`         | Enables the Monaco editor for CloudWatch Logs queries                                                                                                                                                                        | Yes                |
| `recordedQueriesMulti`               | Enables writing multiple items from a single query within Recorded Queries                                                                                                                                                   | Yes                |
| `logsExploreTableVisualisation`      | A table visualisation for logs in Explore                                                                                                                                                                                    | Yes                |
| `transformationsRedesign`            | Enables the transformations redesign                                                                                                                                                                                         | Yes                |
| `awsAsyncQueryCaching`               | Enable caching for async queries for Redshift and Athena. Requires that the datasource has caching and async query support enabled                                                                                           | Yes                |
| `prometheusConfigOverhaulAuth`       | Update the Prometheus configuration page with the new auth component                                                                                                                                                         | Yes                |
| `influxdbSqlSupport`                 | Enable InfluxDB SQL query language support with new querying UI                                                                                                                                                              | Yes                |
| `alertingNoDataErrorExecution`       | Changes how Alerting state manager handles execution of NoData/Error                                                                                                                                                         | Yes                |
| `angularDeprecationUI`               | Display Angular warnings in dashboards and panels                                                                                                                                                                            | Yes                |
| `alertingInsights`                   | Show the new alerting insights landing page                                                                                                                                                                                  | Yes                |
| `cloudWatchWildCardDimensionValues`  | Fetches dimension values from CloudWatch to correctly label wildcard dimensions                                                                                                                                              | Yes                |
| `panelMonitoring`                    | Enables panel monitoring through logs and measurements                                                                                                                                                                       | Yes                |
| `recoveryThreshold`                  | Enables feature recovery threshold (aka hysteresis) for threshold server-side expression                                                                                                                                     | Yes                |
| `lokiStructuredMetadata`             | Enables the loki data source to request structured metadata from the Loki server                                                                                                                                             | Yes                |
| `logRowsPopoverMenu`                 | Enable filtering menu displayed when text of a log line is selected                                                                                                                                                          | Yes                |
| `displayAnonymousStats`              | Enables anonymous stats to be shown in the UI for Grafana                                                                                                                                                                    | Yes                |
| `lokiQueryHints`                     | Enables query hints for Loki                                                                                                                                                                                                 | Yes                |
| `alertingPreviewUpgrade`             | Show Unified Alerting preview and upgrade page in legacy alerting                                                                                                                                                            | Yes                |
| `alertingQueryOptimization`          | Optimizes eligible queries in order to reduce load on datasources                                                                                                                                                            |                    |
| `alertingUpgradeDryrunOnStart`       | When activated in legacy alerting mode, this initiates a dry-run of the Unified Alerting upgrade during each startup. It logs any issues detected without implementing any actual changes.                                   | Yes                |

## Preview feature toggles

| Feature toggle name                    | Description                                                                                                                                                                                  |
| -------------------------------------- | -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `panelTitleSearch`                     | Search for dashboards using panel title                                                                                                                                                      |
| `migrationLocking`                     | Lock database during migrations                                                                                                                                                              |
| `autoMigrateOldPanels`                 | Migrate old angular panels to supported versions (graph, table-old, worldmap, etc)                                                                                                           |
| `autoMigrateGraphPanel`                | Migrate old graph panel to supported time series panel - broken out from autoMigrateOldPanels to enable granular tracking                                                                    |
| `autoMigrateTablePanel`                | Migrate old table panel to supported table panel - broken out from autoMigrateOldPanels to enable granular tracking                                                                          |
| `autoMigratePiechartPanel`             | Migrate old piechart panel to supported piechart panel - broken out from autoMigrateOldPanels to enable granular tracking                                                                    |
| `autoMigrateWorldmapPanel`             | Migrate old worldmap panel to supported geomap panel - broken out from autoMigrateOldPanels to enable granular tracking                                                                      |
| `autoMigrateStatPanel`                 | Migrate old stat panel to supported stat panel - broken out from autoMigrateOldPanels to enable granular tracking                                                                            |
| `disableAngular`                       | Dynamic flag to disable angular at runtime. The preferred method is to set `angular_support_enabled` to `false` in the [security] settings, which allows you to change the state at runtime. |
| `newVizTooltips`                       | New visualizations tooltips UX                                                                                                                                                               |
| `returnToPrevious`                     | Enables the return to previous context functionality                                                                                                                                         |
| `grpcServer`                           | Run the GRPC server                                                                                                                                                                          |
| `accessControlOnCall`                  | Access control primitives for OnCall                                                                                                                                                         |
| `nestedFolders`                        | Enable folder nesting                                                                                                                                                                        |
| `alertingNoNormalState`                | Stop maintaining state of alerts that are not firing                                                                                                                                         |
| `renderAuthJWT`                        | Uses JWT-based auth for rendering instead of relying on remote cache                                                                                                                         |
| `refactorVariablesTimeRange`           | Refactor time range variables flow to reduce number of API calls made when query variables are chained                                                                                       |
| `faroDatasourceSelector`               | Enable the data source selector within the Frontend Apps section of the Frontend Observability                                                                                               |
| `enableDatagridEditing`                | Enables the edit functionality in the datagrid panel                                                                                                                                         |
| `sqlDatasourceDatabaseSelection`       | Enables previous SQL data source dataset dropdown behavior                                                                                                                                   |
| `dashgpt`                              | Enable AI powered features in dashboards                                                                                                                                                     |
| `reportingRetries`                     | Enables rendering retries for the reporting feature                                                                                                                                          |
| `externalServiceAccounts`              | Automatic service account and token setup for plugins                                                                                                                                        |
| `formatString`                         | Enable format string transformer                                                                                                                                                             |
| `transformationsVariableSupport`       | Allows using variables in transformations                                                                                                                                                    |
| `cloudWatchBatchQueries`               | Runs CloudWatch metrics queries as separate batches                                                                                                                                          |
| `awsDatasourcesNewFormStyling`         | Applies new form styling for configuration and query editors in AWS plugins                                                                                                                  |
| `managedPluginsInstall`                | Install managed plugins directly from plugins catalog                                                                                                                                        |
| `addFieldFromCalculationStatFunctions` | Add cumulative and window functions to the add field from calculation transformation                                                                                                         |
| `pdfTables`                            | Enables generating table data as PDF in reporting                                                                                                                                            |
| `ssoSettingsApi`                       | Enables the SSO settings API and the OAuth configuration UIs in Grafana                                                                                                                      |
| `canvasPanelPanZoom`                   | Allow pan and zoom in canvas panel                                                                                                                                                           |
| `alertingSimplifiedRouting`            | Enables users to easily configure alert notifications by specifying a contact point directly when editing or creating an alert rule                                                          |
| `regressionTransformation`             | Enables regression analysis transformation                                                                                                                                                   |
| `groupToNestedTableTransformation`     | Enables the group to nested table transformation                                                                                                                                             |

## Experimental feature toggles

These features are early in their development lifecycle and so are not yet supported in Grafana Cloud.
Experimental features might be changed or removed without prior notice.

| Feature toggle name                         | Description                                                                                                                                                                                                                                                                       |
| ------------------------------------------- | --------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| `live-service-web-worker`                   | This will use a webworker thread to processes events rather than the main thread                                                                                                                                                                                                  |
| `queryOverLive`                             | Use Grafana Live WebSocket to execute backend queries                                                                                                                                                                                                                             |
| `lokiExperimentalStreaming`                 | Support new streaming approach for loki (prototype, needs special loki build)                                                                                                                                                                                                     |
| `storage`                                   | Configurable storage for dashboards, datasources, and resources                                                                                                                                                                                                                   |
| `datasourceQueryMultiStatus`                | Introduce HTTP 207 Multi Status for api/ds/query                                                                                                                                                                                                                                  |
| `traceToMetrics`                            | Enable trace to metrics links                                                                                                                                                                                                                                                     |
| `canvasPanelNesting`                        | Allow elements nesting                                                                                                                                                                                                                                                            |
| `scenes`                                    | Experimental framework to build interactive dashboards                                                                                                                                                                                                                            |
| `disableSecretsCompatibility`               | Disable duplicated secret storage in legacy tables                                                                                                                                                                                                                                |
| `logRequestsInstrumentedAsUnknown`          | Logs the path for requests that are instrumented as unknown                                                                                                                                                                                                                       |
| `showDashboardValidationWarnings`           | Show warnings when dashboards do not validate against the schema                                                                                                                                                                                                                  |
| `mysqlAnsiQuotes`                           | Use double quotes to escape keyword in a MySQL query                                                                                                                                                                                                                              |
| `alertingBacktesting`                       | Rule backtesting API for alerting                                                                                                                                                                                                                                                 |
| `editPanelCSVDragAndDrop`                   | Enables drag and drop for CSV and Excel files                                                                                                                                                                                                                                     |
| `lokiQuerySplittingConfig`                  | Give users the option to configure split durations for Loki queries                                                                                                                                                                                                               |
| `individualCookiePreferences`               | Support overriding cookie preferences per user                                                                                                                                                                                                                                    |
| `influxqlStreamingParser`                   | Enable streaming JSON parser for InfluxDB datasource InfluxQL query language                                                                                                                                                                                                      |
| `lokiLogsDataplane`                         | Changes logs responses from Loki to be compliant with the dataplane specification.                                                                                                                                                                                                |
| `disableSSEDataplane`                       | Disables dataplane specific processing in server side expressions.                                                                                                                                                                                                                |
| `alertStateHistoryLokiSecondary`            | Enable Grafana to write alert state history to an external Loki instance in addition to Grafana annotations.                                                                                                                                                                      |
| `alertStateHistoryLokiPrimary`              | Enable a remote Loki instance as the primary source for state history reads.                                                                                                                                                                                                      |
| `alertStateHistoryLokiOnly`                 | Disable Grafana alerts from emitting annotations when a remote Loki instance is available.                                                                                                                                                                                        |
| `unifiedRequestLog`                         | Writes error logs to the request logger                                                                                                                                                                                                                                           |
| `extraThemes`                               | Enables extra themes                                                                                                                                                                                                                                                              |
| `lokiPredefinedOperations`                  | Adds predefined query operations to Loki query editor                                                                                                                                                                                                                             |
| `pluginsFrontendSandbox`                    | Enables the plugins frontend sandbox                                                                                                                                                                                                                                              |
| `dashboardEmbed`                            | Allow embedding dashboard for external use in Code editors                                                                                                                                                                                                                        |
| `frontendSandboxMonitorOnly`                | Enables monitor only in the plugin frontend sandbox (if enabled)                                                                                                                                                                                                                  |
| `lokiFormatQuery`                           | Enables the ability to format Loki queries                                                                                                                                                                                                                                        |
| `exploreScrollableLogsContainer`            | Improves the scrolling behavior of logs in Explore                                                                                                                                                                                                                                |
| `pluginsDynamicAngularDetectionPatterns`    | Enables fetching Angular detection patterns for plugins from GCOM and fallback to hardcoded ones                                                                                                                                                                                  |
| `vizAndWidgetSplit`                         | Split panels between visualizations and widgets                                                                                                                                                                                                                                   |
| `prometheusIncrementalQueryInstrumentation` | Adds RudderStack events to incremental queries                                                                                                                                                                                                                                    |
| `awsDatasourcesTempCredentials`             | Support temporary security credentials in AWS plugins for Grafana Cloud customers                                                                                                                                                                                                 |
| `mlExpressions`                             | Enable support for Machine Learning in server-side expressions                                                                                                                                                                                                                    |
| `traceQLStreaming`                          | Enables response streaming of TraceQL queries of the Tempo data source                                                                                                                                                                                                            |
| `metricsSummary`                            | Enables metrics summary queries in the Tempo data source                                                                                                                                                                                                                          |
| `featureToggleAdminPage`                    | Enable admin page for managing feature toggles from the Grafana front-end                                                                                                                                                                                                         |
| `permissionsFilterRemoveSubquery`           | Alternative permission filter implementation that does not use subqueries for fetching the dashboard folder                                                                                                                                                                       |
| `sseGroupByDatasource`                      | Send query to the same datasource in a single request when using server side expressions. The `cloudWatchBatchQueries` feature toggle should be enabled if this used with CloudWatch.                                                                                             |
| `libraryPanelRBAC`                          | Enables RBAC support for library panels                                                                                                                                                                                                                                           |
| `wargamesTesting`                           | Placeholder feature flag for internal testing                                                                                                                                                                                                                                     |
| `externalCorePlugins`                       | Allow core plugins to be loaded as external                                                                                                                                                                                                                                       |
| `pluginsAPIMetrics`                         | Sends metrics of public grafana packages usage by plugins                                                                                                                                                                                                                         |
| `idForwarding`                              | Generate signed id token for identity that can be forwarded to plugins and external services                                                                                                                                                                                      |
| `enableNativeHTTPHistogram`                 | Enables native HTTP Histograms                                                                                                                                                                                                                                                    |
| `kubernetesPlaylists`                       | Use the kubernetes API in the frontend for playlists, and route /api/playlist requests to k8s                                                                                                                                                                                     |
| `kubernetesSnapshots`                       | Routes snapshot requests from /api to the /apis endpoint                                                                                                                                                                                                                          |
| `teamHttpHeaders`                           | Enables datasources to apply team headers to the client requests                                                                                                                                                                                                                  |
| `cachingOptimizeSerializationMemoryUsage`   | If enabled, the caching backend gradually serializes query responses for the cache, comparing against the configured `[caching]max_value_mb` value as it goes. This can can help prevent Grafana from running out of memory while attempting to cache very large query responses. |
| `pluginsInstrumentationStatusSource`        | Include a status source label for plugin request metrics and logs                                                                                                                                                                                                                 |
| `prometheusPromQAIL`                        | Prometheus and AI/ML to assist users in creating a query                                                                                                                                                                                                                          |
| `alertmanagerRemoteSecondary`               | Enable Grafana to sync configuration and state with a remote Alertmanager.                                                                                                                                                                                                        |
| `alertmanagerRemotePrimary`                 | Enable Grafana to have a remote Alertmanager instance as the primary Alertmanager.                                                                                                                                                                                                |
| `alertmanagerRemoteOnly`                    | Disable the internal Alertmanager and only use the external one defined.                                                                                                                                                                                                          |
| `annotationPermissionUpdate`                | Separate annotation permissions from dashboard permissions to allow for more granular control.                                                                                                                                                                                    |
| `extractFieldsNameDeduplication`            | Make sure extracted field names are unique in the dataframe                                                                                                                                                                                                                       |
| `dashboardSceneForViewers`                  | Enables dashboard rendering using Scenes for viewer roles                                                                                                                                                                                                                         |
| `dashboardSceneSolo`                        | Enables rendering dashboards using scenes for solo panels                                                                                                                                                                                                                         |
| `dashboardScene`                            | Enables dashboard rendering using scenes for all roles                                                                                                                                                                                                                            |
| `logsInfiniteScrolling`                     | Enables infinite scrolling for the Logs panel in Explore and Dashboards                                                                                                                                                                                                           |
| `flameGraphItemCollapsing`                  | Allow collapsing of flame graph items                                                                                                                                                                                                                                             |
| `pluginsSkipHostEnvVars`                    | Disables passing host environment variable to plugin processes                                                                                                                                                                                                                    |
| `tableSharedCrosshair`                      | Enables shared crosshair in table panel                                                                                                                                                                                                                                           |
| `kubernetesFeatureToggles`                  | Use the kubernetes API for feature toggle management in the frontend                                                                                                                                                                                                              |
| `enablePluginsTracingByDefault`             | Enable plugin tracing for all external plugins                                                                                                                                                                                                                                    |
| `newFolderPicker`                           | Enables the nested folder picker without having nested folders enabled                                                                                                                                                                                                            |
| `onPremToCloudMigrations`                   | In-development feature that will allow users to easily migrate their on-prem Grafana instances to Grafana Cloud.                                                                                                                                                                  |
| `promQLScope`                               | In-development feature that will allow injection of labels into prometheus queries.                                                                                                                                                                                               |
| `nodeGraphDotLayout`                        | Changed the layout algorithm for the node graph                                                                                                                                                                                                                                   |
| `newPDFRendering`                           | New implementation for the dashboard to PDF rendering                                                                                                                                                                                                                             |
| `kubernetesAggregator`                      | Enable grafana aggregator                                                                                                                                                                                                                                                         |

## Development feature toggles

The following toggles require explicitly setting Grafana's [app mode]({{< relref "../_index.md#app_mode" >}}) to 'development' before you can enable this feature toggle. These features tend to be experimental.

| Feature toggle name                    | Description                                                    |
| -------------------------------------- | -------------------------------------------------------------- |
| `unifiedStorage`                       | SQL-based k8s storage                                          |
| `externalServiceAuth`                  | Starts an OAuth2 authentication provider for external services |
| `grafanaAPIServerWithExperimentalAPIs` | Register experimental APIs with the k8s API server             |
| `grafanaAPIServerEnsureKubectlAccess`  | Start an additional https handler and write kubectl options    |
| `kubernetesQueryServiceRewrite`        | Rewrite requests targeting /ds/query to the query service      |
| `panelTitleSearchInV1`                 | Enable searching for dashboards using panel title in search v1 |
