import { jsxs, jsx } from 'react/jsx-runtime';
import { css } from '@emotion/css';
import { flip, shift, useFloating, autoUpdate, useClick, useDismiss, useInteractions } from '@floating-ui/react';
import { useState } from 'react';
import { dateTime } from '@grafana/data';
import { useStyles2 } from '../../../themes/ThemeContext.mjs';
import 'micro-memoize';
import '@emotion/react';
import 'tinycolor2';
import '../../../utils/skeleton.mjs';
import { Input } from '../../Input/Input.mjs';
import { DatePicker } from '../DatePicker/DatePicker.mjs';

const formatDate = (date) => dateTime(date).format("L");
const DatePickerWithInput = ({
  value,
  minDate,
  maxDate,
  onChange,
  closeOnSelect,
  placeholder = "Date",
  ...rest
}) => {
  const [open, setOpen] = useState(false);
  const styles = useStyles2(getStyles);
  const middleware = [
    flip({
      // see https://floating-ui.com/docs/flip#combining-with-shift
      crossAxis: false,
      boundary: document.body
    }),
    shift()
  ];
  const { context, refs, floatingStyles } = useFloating({
    open,
    placement: "bottom-start",
    onOpenChange: setOpen,
    middleware,
    whileElementsMounted: autoUpdate,
    strategy: "fixed"
  });
  const click = useClick(context);
  const dismiss = useDismiss(context);
  const { getReferenceProps, getFloatingProps } = useInteractions([dismiss, click]);
  return /* @__PURE__ */ jsxs("div", { className: styles.container, children: [
    /* @__PURE__ */ jsx(
      Input,
      {
        ref: refs.setReference,
        type: "text",
        autoComplete: "off",
        placeholder,
        value: value ? formatDate(value) : value,
        onChange: (ev) => {
          if (ev.target.value === "") {
            onChange("");
          }
        },
        className: styles.input,
        ...rest,
        ...getReferenceProps()
      }
    ),
    /* @__PURE__ */ jsx("div", { className: styles.popover, ref: refs.setFloating, style: floatingStyles, ...getFloatingProps(), children: /* @__PURE__ */ jsx(
      DatePicker,
      {
        isOpen: open,
        value: value && typeof value !== "string" ? value : dateTime().toDate(),
        minDate,
        maxDate,
        onChange: (ev) => {
          onChange(ev);
          if (closeOnSelect) {
            setOpen(false);
          }
        },
        onClose: () => setOpen(false)
      }
    ) })
  ] });
};
const getStyles = (theme) => {
  return {
    container: css({
      position: "relative"
    }),
    input: css({
      /* hides the native Calendar picker icon given when using type=date */
      "input[type='date']::-webkit-inner-spin-button, input[type='date']::-webkit-calendar-picker-indicator": {
        display: "none",
        WebkitAppearance: "none"
      }
    }),
    popover: css({
      zIndex: theme.zIndex.tooltip
    })
  };
};

export { DatePickerWithInput, formatDate };
//# sourceMappingURL=DatePickerWithInput.mjs.map
