import { jsx } from 'react/jsx-runtime';
import { useState, useEffect } from 'react';
import Skeleton from 'react-loading-skeleton';
import { isMigrationHandler, migrateQuery } from '../utils/migrationHandler.mjs';

function QueryEditorWithMigration(QueryEditor) {
  const WithExtra = (props) => {
    const [migrated, setMigrated] = useState(false);
    const [query, setQuery] = useState(props.query);
    useEffect(() => {
      if (props.query && isMigrationHandler(props.datasource)) {
        migrateQuery(props.datasource, props.query).then((migrated2) => {
          props.onChange(migrated2);
          setQuery(migrated2);
          setMigrated(true);
        });
      } else {
        setMigrated(true);
      }
    }, []);
    useEffect(() => {
      setQuery(props.query);
    }, [props.query]);
    if (!migrated) {
      return /* @__PURE__ */ jsx(Skeleton, { containerTestId: "react-loading-skeleton-testid", height: 75 });
    }
    return /* @__PURE__ */ jsx(QueryEditor, { ...props, query });
  };
  return WithExtra;
}

export { QueryEditorWithMigration };
//# sourceMappingURL=QueryEditorWithMigration.mjs.map
